!
! $Id: gr_fi_dyn_p.F90 5367 2024-12-03 09:40:13Z abarral $
!

#ifdef CPP_PARA
SUBROUTINE gr_fi_dyn_p(nfield,ngrid,im,jm,pfi,pdyn)
  ! Interface with parallel physics,
  USE mod_interface_dyn_phys
  USE dimphy
  USE parallel_lmdz
  IMPLICIT NONE
  !=======================================================================
  !   passage d'un champ de la grille scalaire a la grille physique
  !=======================================================================

  !-----------------------------------------------------------------------
  !   declarations:
  !   -------------

  INTEGER :: im,jm,ngrid,nfield
  REAL :: pdyn(im,jm,nfield)
  REAL :: pfi(ngrid,nfield)

  INTEGER :: i,j,ifield,ig

  !-----------------------------------------------------------------------
  !   calcul:
  !   -------
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO ifield=1,nfield

    do ig=1,klon
      i=index_i(ig)
      j=index_j(ig)
      pdyn(i,j,ifield)=pfi(ig,ifield)
      if (i==1) pdyn(im,j,ifield)=pdyn(i,j,ifield)
    enddo

  !   traitement des poles
  if (pole_nord) then
    do i=1,im
      pdyn(i,1,ifield)=pdyn(1,1,ifield)
    enddo
  endif

  if (pole_sud) then
    do i=1,im
      pdyn(i,jm,ifield)=pdyn(1,jm,ifield)
    enddo
  endif

  ENDDO
!$OMP END DO NOWAIT
  ! of #ifdef CPP_PARA
  RETURN
END SUBROUTINE gr_fi_dyn_p
#endif
