!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL2 (KIDIA,KFDIA,KLEV,P_TAU,PAVEL,P_COLDRY,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,P_FORFRAC,K_INDFOR,K_JP,K_JT,K_JT1,&
 & P_COLH2O,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 2:  250-500 cm-1 (low - H2O; high - H2O)

!     AUTHOR.
!     -------
!      JJMorcrette, ECMWF

!     MODIFICATIONS.
!     --------------
!      M.Hamrud      01-Oct-2003 CY28 Cleaning
!      NEC           25-Oct-2007 Optimisations
!      JJMorcrette 20110613 flexible number of g-points
!      ABozzo 201305 updated to rrtmg_lw_v4.85:
!*********
!     band 2:  350-500 cm-1 (low key - h2o; high key - h2o)
!
!     note: previous version of rrtm band 2: 
!           250 - 500 cm-1 (low - h2o; high - h2o)
!
! ---------------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK, DR_HOOK, JPHOOK

USE PARRRTM  , ONLY : JPBAND
USE YOERRTM  , ONLY : JPGPT  ,NG2   ,NGS1
USE YOERRTWN , ONLY : NSPA   ,NSPB
USE YOERRTA2 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,&
 & FORREF   ,SELFREF  

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KIDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KFDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(KIDIA:KFDIA,JPGPT,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: PAVEL(KIDIA:KFDIA,KLEV) ! Layer pressures (hPa)
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLDRY(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(KIDIA:KFDIA,KLEV,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFRAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFAC(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP(KIDIA:KFDIA) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDFOR(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(KIDIA:KFDIA,JPGPT,KLEV) 

! ---------------------------------------------------------------------------

INTEGER(KIND=JPIM) :: IND0(KLEV),IND1(KLEV),INDS(KLEV), INDF(KLEV)

INTEGER(KIND=JPIM) :: IG, JLAY
INTEGER(KIND=JPIM) :: JLON

REAL(KIND=JPRB) :: ZTAUFOR,ZTAUSELF,ZCORRADJ,ZPP
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

!     Compute the optical depth by interpolating in ln(pressure) and 
!     temperature.  Below LAYTROP, the water vapor self-continuum is 
!     interpolated (in temperature) separately.

ASSOCIATE(NFLEVG=>KLEV)
IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL2',0,ZHOOK_HANDLE)

DO JLAY = 1, KLEV
  DO JLON = KIDIA, KFDIA
    IF (JLAY <= K_LAYTROP(JLON)) THEN
      IND0(JLAY) = ((K_JP(JLON,JLAY)-1)*5+(K_JT(JLON,JLAY)-1))*NSPA(2) + 1
      IND1(JLAY) = (K_JP(JLON,JLAY)*5+(K_JT1(JLON,JLAY)-1))*NSPA(2) + 1
      INDS(JLAY) = K_INDSELF(JLON,JLAY)
      INDF(JLAY) = K_INDFOR(JLON,JLAY)
      ZPP = PAVEL(JLON,JLAY) !hPa(mb)
      ZCORRADJ = 1._JPRB - .05_JPRB * (ZPP - 100._JPRB) / 900._JPRB
!-- DS_000515  
!CDIR UNROLL=NG2
      DO IG = 1, NG2
!-- DS_000515  
         ZTAUSELF = P_SELFFAC(JLON,JLAY) * (SELFREF(INDS(JLAY),IG) + P_SELFFRAC(JLON,JLAY) * &
                 & (SELFREF(INDS(JLAY)+1,IG) - SELFREF(INDS(JLAY),IG)))
         ZTAUFOR =  P_FORFAC(JLON,JLAY) * (FORREF(INDF(JLAY),IG) + P_FORFRAC(JLON,JLAY) * &
                 & (FORREF(INDF(JLAY)+1,IG) - FORREF(INDF(JLAY),IG))) 
         P_TAU(JLON,NGS1+IG,JLAY) = ZCORRADJ * (P_COLH2O(JLON,JLAY) * &
                 & (P_FAC00(JLON,JLAY) * ABSA(IND0(JLAY),IG) + &
                 &  P_FAC10(JLON,JLAY) * ABSA(IND0(JLAY)+1,IG) + &
                 &  P_FAC01(JLON,JLAY) * ABSA(IND1(JLAY),IG) + &
                 &  P_FAC11(JLON,JLAY) * ABSA(IND1(JLAY)+1,IG)) &
               &  + ZTAUSELF + ZTAUFOR)+ P_TAUAERL(JLON,JLAY,2)
        PFRAC(JLON,NGS1+IG,JLAY) = FRACREFA(IG) 

      ENDDO
    ENDIF
    IF (JLAY > K_LAYTROP(JLON)) THEN

      IND0(JLAY) = ((K_JP(JLON,JLAY)-13)*5+(K_JT(JLON,JLAY)-1))*NSPB(2) + 1
      IND1(JLAY) = ((K_JP(JLON,JLAY)-12)*5+(K_JT1(JLON,JLAY)-1))*NSPB(2) + 1
      INDF(JLAY) = K_INDFOR(JLON,JLAY)
!-- JJM_000517
!CDIR UNROLL=NG2
      DO IG = 1, NG2
!-- JJM_000517
         ZTAUFOR = P_FORFAC(JLON,JLAY) * (FORREF(INDF(JLAY),IG) + &
                &  P_FORFRAC(JLON,JLAY) * (FORREF(INDF(JLAY)+1,IG) - FORREF(INDF(JLAY),IG))) 
         P_TAU(JLON,NGS1+IG,JLAY) = P_COLH2O(JLON,JLAY) * &
              &  (P_FAC00(JLON,JLAY) * ABSB(IND0(JLAY),IG) + &
              &   P_FAC10(JLON,JLAY) * ABSB(IND0(JLAY)+1,IG) + &
              &   P_FAC01(JLON,JLAY) * ABSB(IND1(JLAY),IG) + &
              &   P_FAC11(JLON,JLAY) * ABSB(IND1(JLAY)+1,IG)) &
              &   + ZTAUFOR + P_TAUAERL(JLON,JLAY,2)
       PFRAC(JLON,NGS1+IG,JLAY) = FRACREFB(IG)

      ENDDO
    ENDIF
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL2',1,ZHOOK_HANDLE)

END ASSOCIATE
END SUBROUTINE RRTM_TAUMOL2
