!*******************************************************************************
SUBROUTINE RRTM_TAUMOL10 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,K_JP,K_JT,K_JT1,&
 & P_COLH2O,K_LAYTROP,PFRAC)  

!     BAND 10:  1390-1480 cm-1 (low - H2O; high - H2O)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond   2000-05-15 speed-up
!     JJMorcrette 2000-05-17 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG10   ,NGS9
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA10, ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB

!  Input
!#include "yoeratm.h"

!      REAL TAUAER(JPLAY)

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PROFDATA             
!- from SP             
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY)

INTEGER(KIND=JPIM) :: IG, I_LAY
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,10),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure) and 
!     temperature.  

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL10',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(10) + 1
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(10) + 1
ENDDO

!-- DS_000515
DO IG = 1, NG10
  DO I_LAY = 1, K_LAYTROP
!-- DS_000515
    P_TAU (NGS9+IG,I_LAY) = P_COLH2O(I_LAY) *&
     & (P_FAC00(I_LAY) * ABSA(IND0(I_LAY)  ,IG) +&
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+1,IG) +&
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)  ,IG) +&
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+1,IG)) &
     & + P_TAUAERL(I_LAY,10)  
    PFRAC(NGS9+IG,I_LAY) = FRACREFA(IG)
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(10) + 1
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(10) + 1
ENDDO

!-- JJM_000517
DO IG = 1, NG10
  DO I_LAY = K_LAYTROP+1, KLEV
!-- JJM_000517
    P_TAU (NGS9+IG,I_LAY) = P_COLH2O(I_LAY) *&
     & (P_FAC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +&
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +&
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +&
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+1,IG)) &
     & + P_TAUAERL(I_LAY,10)  
    PFRAC(NGS9+IG,I_LAY) = FRACREFB(IG)
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL10',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL10
