!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB16

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 16:  2600-3000 cm-1 (low - H2O,CH4; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA16, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT1 &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART1',0,ZHOOK_HANDLE)


SFLUXREF = (/ &
 & 1.92269_JPRB    , 1.72844_JPRB    , 1.64326_JPRB    , 1.58451_JPRB     &
 & , 1.44031_JPRB    , 1.25108_JPRB    , 1.02724_JPRB    , 0.776759_JPRB    &
 & , 0.534444_JPRB   , 5.87755E-02_JPRB, 4.86706E-02_JPRB, 3.87989E-02_JPRB &
 & , 2.84532E-02_JPRB, 1.82431E-02_JPRB, 6.92320E-03_JPRB, 9.70770E-04_JPRB /)  

!     Rayleigh extinction coefficient at v = 2925 cm-1.
RAYL = 2.91E-10_JPRB

STRRAT1 = 252.131_JPRB

LAYREFFR = 18

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.15349E-04_JPRB,0.89162E-04_JPRB,0.97706E-04_JPRB,0.96973E-04_JPRB,0.90703E-04_JPRB, &
 & 0.80393E-04_JPRB,0.67242E-04_JPRB,0.50804E-04_JPRB,0.23334E-04_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.16138E-04_JPRB,0.89235E-04_JPRB,0.97696E-04_JPRB,0.96116E-04_JPRB,0.89625E-04_JPRB, &
 & 0.79382E-04_JPRB,0.66587E-04_JPRB,0.50583E-04_JPRB,0.24342E-04_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.16801E-04_JPRB,0.89390E-04_JPRB,0.97492E-04_JPRB,0.95146E-04_JPRB,0.88483E-04_JPRB, &
 & 0.78325E-04_JPRB,0.65873E-04_JPRB,0.50342E-04_JPRB,0.25245E-04_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.17584E-04_JPRB,0.89321E-04_JPRB,0.97141E-04_JPRB,0.93952E-04_JPRB,0.87141E-04_JPRB, &
 & 0.77126E-04_JPRB,0.65068E-04_JPRB,0.49985E-04_JPRB,0.26046E-04_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.18258E-04_JPRB,0.89204E-04_JPRB,0.96602E-04_JPRB,0.92773E-04_JPRB,0.85832E-04_JPRB, &
 & 0.76015E-04_JPRB,0.64318E-04_JPRB,0.49612E-04_JPRB,0.26697E-04_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.12783E-04_JPRB,0.77013E-04_JPRB,0.85056E-04_JPRB,0.84160E-04_JPRB,0.79021E-04_JPRB, &
 & 0.70101E-04_JPRB,0.58520E-04_JPRB,0.44007E-04_JPRB,0.19895E-04_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.13452E-04_JPRB,0.77084E-04_JPRB,0.84929E-04_JPRB,0.83386E-04_JPRB,0.78122E-04_JPRB, &
 & 0.69293E-04_JPRB,0.57974E-04_JPRB,0.43855E-04_JPRB,0.20713E-04_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.14066E-04_JPRB,0.77185E-04_JPRB,0.84612E-04_JPRB,0.82498E-04_JPRB,0.77177E-04_JPRB, &
 & 0.68443E-04_JPRB,0.57444E-04_JPRB,0.43722E-04_JPRB,0.21494E-04_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.14678E-04_JPRB,0.76996E-04_JPRB,0.83962E-04_JPRB,0.81526E-04_JPRB,0.76049E-04_JPRB, &
 & 0.67485E-04_JPRB,0.56822E-04_JPRB,0.43530E-04_JPRB,0.22200E-04_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.15258E-04_JPRB,0.76788E-04_JPRB,0.82821E-04_JPRB,0.80320E-04_JPRB,0.74845E-04_JPRB, &
 & 0.66487E-04_JPRB,0.56144E-04_JPRB,0.43262E-04_JPRB,0.22757E-04_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.10474E-04_JPRB,0.66144E-04_JPRB,0.73703E-04_JPRB,0.72701E-04_JPRB,0.68638E-04_JPRB, &
 & 0.60826E-04_JPRB,0.50854E-04_JPRB,0.37989E-04_JPRB,0.17743E-04_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.11024E-04_JPRB,0.66096E-04_JPRB,0.73447E-04_JPRB,0.72029E-04_JPRB,0.67858E-04_JPRB, &
 & 0.60163E-04_JPRB,0.50424E-04_JPRB,0.37886E-04_JPRB,0.18519E-04_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.11534E-04_JPRB,0.65974E-04_JPRB,0.72795E-04_JPRB,0.71229E-04_JPRB,0.67005E-04_JPRB, &
 & 0.59442E-04_JPRB,0.49950E-04_JPRB,0.37779E-04_JPRB,0.19184E-04_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.12091E-04_JPRB,0.65752E-04_JPRB,0.72003E-04_JPRB,0.70357E-04_JPRB,0.66129E-04_JPRB, &
 & 0.58718E-04_JPRB,0.49503E-04_JPRB,0.37690E-04_JPRB,0.19788E-04_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.12560E-04_JPRB,0.65678E-04_JPRB,0.71013E-04_JPRB,0.69266E-04_JPRB,0.65076E-04_JPRB, &
 & 0.57873E-04_JPRB,0.48947E-04_JPRB,0.37519E-04_JPRB,0.20290E-04_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.85236E-05_JPRB,0.56692E-04_JPRB,0.63625E-04_JPRB,0.62567E-04_JPRB,0.59412E-04_JPRB, &
 & 0.52601E-04_JPRB,0.43957E-04_JPRB,0.32602E-04_JPRB,0.16862E-04_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.89886E-05_JPRB,0.56512E-04_JPRB,0.63288E-04_JPRB,0.61902E-04_JPRB,0.58733E-04_JPRB, &
 & 0.52036E-04_JPRB,0.43629E-04_JPRB,0.32592E-04_JPRB,0.17543E-04_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.94085E-05_JPRB,0.56287E-04_JPRB,0.62588E-04_JPRB,0.61197E-04_JPRB,0.58020E-04_JPRB, &
 & 0.51469E-04_JPRB,0.43247E-04_JPRB,0.32567E-04_JPRB,0.18199E-04_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.98830E-05_JPRB,0.55998E-04_JPRB,0.61716E-04_JPRB,0.60485E-04_JPRB,0.57250E-04_JPRB, &
 & 0.50840E-04_JPRB,0.42842E-04_JPRB,0.32520E-04_JPRB,0.18771E-04_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.10278E-04_JPRB,0.55929E-04_JPRB,0.61011E-04_JPRB,0.59745E-04_JPRB,0.56462E-04_JPRB, &
 & 0.50254E-04_JPRB,0.42468E-04_JPRB,0.32457E-04_JPRB,0.19296E-04_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.68852E-05_JPRB,0.48282E-04_JPRB,0.54761E-04_JPRB,0.53543E-04_JPRB,0.51345E-04_JPRB, &
 & 0.45380E-04_JPRB,0.37794E-04_JPRB,0.27880E-04_JPRB,0.14959E-04_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.72830E-05_JPRB,0.48206E-04_JPRB,0.54379E-04_JPRB,0.52923E-04_JPRB,0.50723E-04_JPRB, &
 & 0.44903E-04_JPRB,0.37536E-04_JPRB,0.27938E-04_JPRB,0.15841E-04_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.76436E-05_JPRB,0.47928E-04_JPRB,0.53597E-04_JPRB,0.52299E-04_JPRB,0.50061E-04_JPRB, &
 & 0.44426E-04_JPRB,0.37240E-04_JPRB,0.27962E-04_JPRB,0.16760E-04_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.80055E-05_JPRB,0.47625E-04_JPRB,0.52896E-04_JPRB,0.51678E-04_JPRB,0.49302E-04_JPRB, &
 & 0.43902E-04_JPRB,0.36930E-04_JPRB,0.27968E-04_JPRB,0.17586E-04_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.83555E-05_JPRB,0.47486E-04_JPRB,0.52258E-04_JPRB,0.51112E-04_JPRB,0.48444E-04_JPRB, &
 & 0.43409E-04_JPRB,0.36652E-04_JPRB,0.27966E-04_JPRB,0.18270E-04_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.55363E-05_JPRB,0.40995E-04_JPRB,0.46991E-04_JPRB,0.45840E-04_JPRB,0.44200E-04_JPRB, &
 & 0.38984E-04_JPRB,0.32341E-04_JPRB,0.23743E-04_JPRB,0.12825E-04_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.58741E-05_JPRB,0.40851E-04_JPRB,0.46490E-04_JPRB,0.45277E-04_JPRB,0.43651E-04_JPRB, &
 & 0.38565E-04_JPRB,0.32141E-04_JPRB,0.23813E-04_JPRB,0.13671E-04_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.61821E-05_JPRB,0.40643E-04_JPRB,0.45850E-04_JPRB,0.44728E-04_JPRB,0.42924E-04_JPRB, &
 & 0.38164E-04_JPRB,0.31920E-04_JPRB,0.23858E-04_JPRB,0.14647E-04_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.64614E-05_JPRB,0.40329E-04_JPRB,0.45202E-04_JPRB,0.44163E-04_JPRB,0.42054E-04_JPRB, &
 & 0.37723E-04_JPRB,0.31679E-04_JPRB,0.23886E-04_JPRB,0.15533E-04_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.67675E-05_JPRB,0.40137E-04_JPRB,0.44578E-04_JPRB,0.43574E-04_JPRB,0.41267E-04_JPRB, &
 & 0.37271E-04_JPRB,0.31420E-04_JPRB,0.23883E-04_JPRB,0.16436E-04_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.44217E-05_JPRB,0.34626E-04_JPRB,0.39970E-04_JPRB,0.39080E-04_JPRB,0.37744E-04_JPRB, &
 & 0.33237E-04_JPRB,0.27507E-04_JPRB,0.20074E-04_JPRB,0.11007E-04_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.47104E-05_JPRB,0.34494E-04_JPRB,0.39592E-04_JPRB,0.38568E-04_JPRB,0.37283E-04_JPRB, &
 & 0.32875E-04_JPRB,0.27342E-04_JPRB,0.20149E-04_JPRB,0.11834E-04_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.49764E-05_JPRB,0.34300E-04_JPRB,0.39007E-04_JPRB,0.38074E-04_JPRB,0.36415E-04_JPRB, &
 & 0.32528E-04_JPRB,0.27158E-04_JPRB,0.20213E-04_JPRB,0.12801E-04_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.52135E-05_JPRB,0.34067E-04_JPRB,0.38449E-04_JPRB,0.37591E-04_JPRB,0.35661E-04_JPRB, &
 & 0.32173E-04_JPRB,0.26959E-04_JPRB,0.20265E-04_JPRB,0.13763E-04_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.54275E-05_JPRB,0.33832E-04_JPRB,0.37875E-04_JPRB,0.37057E-04_JPRB,0.35065E-04_JPRB, &
 & 0.31800E-04_JPRB,0.26760E-04_JPRB,0.20278E-04_JPRB,0.14677E-04_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.35317E-05_JPRB,0.29115E-04_JPRB,0.33824E-04_JPRB,0.33370E-04_JPRB,0.32237E-04_JPRB, &
 & 0.28331E-04_JPRB,0.23362E-04_JPRB,0.16932E-04_JPRB,0.96086E-05_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.37854E-05_JPRB,0.29084E-04_JPRB,0.33632E-04_JPRB,0.32929E-04_JPRB,0.31805E-04_JPRB, &
 & 0.28018E-04_JPRB,0.23236E-04_JPRB,0.17006E-04_JPRB,0.10621E-04_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.40127E-05_JPRB,0.28935E-04_JPRB,0.33190E-04_JPRB,0.32483E-04_JPRB,0.30936E-04_JPRB, &
 & 0.27716E-04_JPRB,0.23074E-04_JPRB,0.17087E-04_JPRB,0.11657E-04_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.42184E-05_JPRB,0.28732E-04_JPRB,0.32711E-04_JPRB,0.32042E-04_JPRB,0.30351E-04_JPRB, &
 & 0.27404E-04_JPRB,0.22906E-04_JPRB,0.17140E-04_JPRB,0.12504E-04_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.44040E-05_JPRB,0.28488E-04_JPRB,0.32207E-04_JPRB,0.31581E-04_JPRB,0.29852E-04_JPRB, &
 & 0.27086E-04_JPRB,0.22740E-04_JPRB,0.17166E-04_JPRB,0.13401E-04_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.28004E-05_JPRB,0.24421E-04_JPRB,0.28507E-04_JPRB,0.28270E-04_JPRB,0.27415E-04_JPRB, &
 & 0.24038E-04_JPRB,0.19759E-04_JPRB,0.14209E-04_JPRB,0.88498E-05_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.30342E-05_JPRB,0.24385E-04_JPRB,0.28391E-04_JPRB,0.27999E-04_JPRB,0.26969E-04_JPRB, &
 & 0.23770E-04_JPRB,0.19651E-04_JPRB,0.14288E-04_JPRB,0.10048E-04_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.32304E-05_JPRB,0.24304E-04_JPRB,0.28136E-04_JPRB,0.27602E-04_JPRB,0.26246E-04_JPRB, &
 & 0.23508E-04_JPRB,0.19517E-04_JPRB,0.14360E-04_JPRB,0.11188E-04_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.34049E-05_JPRB,0.24160E-04_JPRB,0.27731E-04_JPRB,0.27211E-04_JPRB,0.25756E-04_JPRB, &
 & 0.23246E-04_JPRB,0.19380E-04_JPRB,0.14426E-04_JPRB,0.12319E-04_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.35648E-05_JPRB,0.23940E-04_JPRB,0.27283E-04_JPRB,0.26806E-04_JPRB,0.25320E-04_JPRB, &
 & 0.22960E-04_JPRB,0.19234E-04_JPRB,0.14451E-04_JPRB,0.13506E-04_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.22115E-05_JPRB,0.20358E-04_JPRB,0.23898E-04_JPRB,0.23781E-04_JPRB,0.23142E-04_JPRB, &
 & 0.20260E-04_JPRB,0.16593E-04_JPRB,0.11876E-04_JPRB,0.77665E-05_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.24264E-05_JPRB,0.20362E-04_JPRB,0.23820E-04_JPRB,0.23569E-04_JPRB,0.22708E-04_JPRB, &
 & 0.20037E-04_JPRB,0.16524E-04_JPRB,0.11954E-04_JPRB,0.90216E-05_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.26002E-05_JPRB,0.20303E-04_JPRB,0.23663E-04_JPRB,0.23295E-04_JPRB,0.22132E-04_JPRB, &
 & 0.19806E-04_JPRB,0.16414E-04_JPRB,0.12011E-04_JPRB,0.10379E-04_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.27486E-05_JPRB,0.20198E-04_JPRB,0.23357E-04_JPRB,0.22943E-04_JPRB,0.21707E-04_JPRB, &
 & 0.19580E-04_JPRB,0.16298E-04_JPRB,0.12060E-04_JPRB,0.11771E-04_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.28881E-05_JPRB,0.20019E-04_JPRB,0.22982E-04_JPRB,0.22584E-04_JPRB,0.21296E-04_JPRB, &
 & 0.19341E-04_JPRB,0.16164E-04_JPRB,0.12088E-04_JPRB,0.13279E-04_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.18320E-05_JPRB,0.16927E-04_JPRB,0.19968E-04_JPRB,0.19856E-04_JPRB,0.19352E-04_JPRB, &
 & 0.16934E-04_JPRB,0.13866E-04_JPRB,0.99116E-05_JPRB,0.67134E-05_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.20049E-05_JPRB,0.16927E-04_JPRB,0.19853E-04_JPRB,0.19674E-04_JPRB,0.18853E-04_JPRB, &
 & 0.16739E-04_JPRB,0.13797E-04_JPRB,0.99757E-05_JPRB,0.78968E-05_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.21502E-05_JPRB,0.16866E-04_JPRB,0.19704E-04_JPRB,0.19448E-04_JPRB,0.18441E-04_JPRB, &
 & 0.16541E-04_JPRB,0.13705E-04_JPRB,0.10023E-04_JPRB,0.91593E-05_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.22714E-05_JPRB,0.16777E-04_JPRB,0.19465E-04_JPRB,0.19143E-04_JPRB,0.18062E-04_JPRB, &
 & 0.16347E-04_JPRB,0.13601E-04_JPRB,0.10057E-04_JPRB,0.10536E-04_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.23867E-05_JPRB,0.16634E-04_JPRB,0.19123E-04_JPRB,0.18829E-04_JPRB,0.17732E-04_JPRB, &
 & 0.16132E-04_JPRB,0.13484E-04_JPRB,0.10082E-04_JPRB,0.12018E-04_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.15169E-05_JPRB,0.14042E-04_JPRB,0.16626E-04_JPRB,0.16552E-04_JPRB,0.16148E-04_JPRB, &
 & 0.14121E-04_JPRB,0.11557E-04_JPRB,0.82558E-05_JPRB,0.56116E-05_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.16576E-05_JPRB,0.14051E-04_JPRB,0.16515E-04_JPRB,0.16389E-04_JPRB,0.15651E-04_JPRB, &
 & 0.13956E-04_JPRB,0.11498E-04_JPRB,0.83065E-05_JPRB,0.66756E-05_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.17786E-05_JPRB,0.13996E-04_JPRB,0.16382E-04_JPRB,0.16200E-04_JPRB,0.15335E-04_JPRB, &
 & 0.13791E-04_JPRB,0.11414E-04_JPRB,0.83396E-05_JPRB,0.78609E-05_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.18784E-05_JPRB,0.13920E-04_JPRB,0.16173E-04_JPRB,0.15944E-04_JPRB,0.15016E-04_JPRB, &
 & 0.13612E-04_JPRB,0.11321E-04_JPRB,0.83696E-05_JPRB,0.90657E-05_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.19730E-05_JPRB,0.13808E-04_JPRB,0.15876E-04_JPRB,0.15671E-04_JPRB,0.14704E-04_JPRB, &
 & 0.13425E-04_JPRB,0.11218E-04_JPRB,0.83846E-05_JPRB,0.10342E-04_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.12548E-05_JPRB,0.11622E-04_JPRB,0.13817E-04_JPRB,0.13765E-04_JPRB,0.13366E-04_JPRB, &
 & 0.11761E-04_JPRB,0.96214E-05_JPRB,0.68586E-05_JPRB,0.46815E-05_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.13720E-05_JPRB,0.11638E-04_JPRB,0.13707E-04_JPRB,0.13640E-04_JPRB,0.13007E-04_JPRB, &
 & 0.11624E-04_JPRB,0.95672E-05_JPRB,0.68978E-05_JPRB,0.55831E-05_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.14716E-05_JPRB,0.11595E-04_JPRB,0.13603E-04_JPRB,0.13476E-04_JPRB,0.12728E-04_JPRB, &
 & 0.11474E-04_JPRB,0.94883E-05_JPRB,0.69284E-05_JPRB,0.65694E-05_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.15544E-05_JPRB,0.11533E-04_JPRB,0.13432E-04_JPRB,0.13265E-04_JPRB,0.12450E-04_JPRB, &
 & 0.11320E-04_JPRB,0.94054E-05_JPRB,0.69510E-05_JPRB,0.75699E-05_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.16324E-05_JPRB,0.11450E-04_JPRB,0.13177E-04_JPRB,0.13030E-04_JPRB,0.12193E-04_JPRB, &
 & 0.11159E-04_JPRB,0.93157E-05_JPRB,0.69543E-05_JPRB,0.86449E-05_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.10905E-03_JPRB,0.19084E-03_JPRB,0.20069E-03_JPRB,0.19832E-03_JPRB,0.18610E-03_JPRB, &
 & 0.17089E-03_JPRB,0.14990E-03_JPRB,0.11759E-03_JPRB,0.64675E-04_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.11105E-03_JPRB,0.18952E-03_JPRB,0.19885E-03_JPRB,0.19823E-03_JPRB,0.18675E-03_JPRB, &
 & 0.17126E-03_JPRB,0.15098E-03_JPRB,0.11929E-03_JPRB,0.67071E-04_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.11276E-03_JPRB,0.18853E-03_JPRB,0.19769E-03_JPRB,0.19892E-03_JPRB,0.18804E-03_JPRB, &
 & 0.17228E-03_JPRB,0.15234E-03_JPRB,0.12104E-03_JPRB,0.69562E-04_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.11331E-03_JPRB,0.18716E-03_JPRB,0.19673E-03_JPRB,0.19862E-03_JPRB,0.18922E-03_JPRB, &
 & 0.17345E-03_JPRB,0.15364E-03_JPRB,0.12287E-03_JPRB,0.72145E-04_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.11374E-03_JPRB,0.18626E-03_JPRB,0.19656E-03_JPRB,0.19857E-03_JPRB,0.19062E-03_JPRB, &
 & 0.17445E-03_JPRB,0.15373E-03_JPRB,0.12483E-03_JPRB,0.74697E-04_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.94458E-04_JPRB,0.16650E-03_JPRB,0.17483E-03_JPRB,0.17491E-03_JPRB,0.16501E-03_JPRB, &
 & 0.15069E-03_JPRB,0.13359E-03_JPRB,0.10498E-03_JPRB,0.55352E-04_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.96121E-04_JPRB,0.16557E-03_JPRB,0.17383E-03_JPRB,0.17514E-03_JPRB,0.16597E-03_JPRB, &
 & 0.15082E-03_JPRB,0.13480E-03_JPRB,0.10677E-03_JPRB,0.57531E-04_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.97581E-04_JPRB,0.16494E-03_JPRB,0.17349E-03_JPRB,0.17480E-03_JPRB,0.16726E-03_JPRB, &
 & 0.15206E-03_JPRB,0.13520E-03_JPRB,0.10844E-03_JPRB,0.59621E-04_JPRB /)  
KA(:, 4, 2, 2) = (/ &
 & 0.98152E-04_JPRB,0.16427E-03_JPRB,0.17323E-03_JPRB,0.17471E-03_JPRB,0.16812E-03_JPRB, &
 & 0.15352E-03_JPRB,0.13523E-03_JPRB,0.11008E-03_JPRB,0.61894E-04_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.98081E-04_JPRB,0.16346E-03_JPRB,0.17334E-03_JPRB,0.17481E-03_JPRB,0.16845E-03_JPRB, &
 & 0.15496E-03_JPRB,0.13612E-03_JPRB,0.11175E-03_JPRB,0.64159E-04_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.80988E-04_JPRB,0.14444E-03_JPRB,0.15236E-03_JPRB,0.15355E-03_JPRB,0.14515E-03_JPRB, &
 & 0.13201E-03_JPRB,0.11827E-03_JPRB,0.92843E-04_JPRB,0.47818E-04_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.82627E-04_JPRB,0.14399E-03_JPRB,0.15198E-03_JPRB,0.15308E-03_JPRB,0.14622E-03_JPRB, &
 & 0.13285E-03_JPRB,0.11829E-03_JPRB,0.94579E-04_JPRB,0.49498E-04_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.83666E-04_JPRB,0.14365E-03_JPRB,0.15183E-03_JPRB,0.15300E-03_JPRB,0.14704E-03_JPRB, &
 & 0.13418E-03_JPRB,0.11832E-03_JPRB,0.96259E-04_JPRB,0.51225E-04_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.84164E-04_JPRB,0.14362E-03_JPRB,0.15205E-03_JPRB,0.15285E-03_JPRB,0.14764E-03_JPRB, &
 & 0.13590E-03_JPRB,0.11954E-03_JPRB,0.97885E-04_JPRB,0.52990E-04_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.84014E-04_JPRB,0.14269E-03_JPRB,0.15214E-03_JPRB,0.15331E-03_JPRB,0.14865E-03_JPRB, &
 & 0.13747E-03_JPRB,0.12089E-03_JPRB,0.99389E-04_JPRB,0.54936E-04_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.69055E-04_JPRB,0.12498E-03_JPRB,0.13260E-03_JPRB,0.13427E-03_JPRB,0.12748E-03_JPRB, &
 & 0.11593E-03_JPRB,0.10318E-03_JPRB,0.81535E-04_JPRB,0.43344E-04_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.70374E-04_JPRB,0.12479E-03_JPRB,0.13217E-03_JPRB,0.13387E-03_JPRB,0.12823E-03_JPRB, &
 & 0.11702E-03_JPRB,0.10316E-03_JPRB,0.83059E-04_JPRB,0.44577E-04_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.71321E-04_JPRB,0.12483E-03_JPRB,0.13205E-03_JPRB,0.13371E-03_JPRB,0.12866E-03_JPRB, &
 & 0.11820E-03_JPRB,0.10422E-03_JPRB,0.84648E-04_JPRB,0.45880E-04_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.71712E-04_JPRB,0.12475E-03_JPRB,0.13249E-03_JPRB,0.13379E-03_JPRB,0.12934E-03_JPRB, &
 & 0.11960E-03_JPRB,0.10551E-03_JPRB,0.86238E-04_JPRB,0.47243E-04_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.71917E-04_JPRB,0.12433E-03_JPRB,0.13275E-03_JPRB,0.13434E-03_JPRB,0.13049E-03_JPRB, &
 & 0.12131E-03_JPRB,0.10676E-03_JPRB,0.87830E-04_JPRB,0.48641E-04_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.58527E-04_JPRB,0.10840E-03_JPRB,0.11507E-03_JPRB,0.11730E-03_JPRB,0.11099E-03_JPRB, &
 & 0.10118E-03_JPRB,0.89566E-04_JPRB,0.71122E-04_JPRB,0.43658E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART2',0,ZHOOK_HANDLE)


KA(:, 2, 5, 2) = (/ &
 & 0.59798E-04_JPRB,0.10799E-03_JPRB,0.11447E-03_JPRB,0.11692E-03_JPRB,0.11189E-03_JPRB, &
 & 0.10224E-03_JPRB,0.90255E-04_JPRB,0.72476E-04_JPRB,0.44361E-04_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.60601E-04_JPRB,0.10799E-03_JPRB,0.11464E-03_JPRB,0.11677E-03_JPRB,0.11225E-03_JPRB, &
 & 0.10358E-03_JPRB,0.91122E-04_JPRB,0.73922E-04_JPRB,0.45004E-04_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.60971E-04_JPRB,0.10798E-03_JPRB,0.11486E-03_JPRB,0.11681E-03_JPRB,0.11304E-03_JPRB, &
 & 0.10512E-03_JPRB,0.91981E-04_JPRB,0.75441E-04_JPRB,0.45782E-04_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.61166E-04_JPRB,0.10769E-03_JPRB,0.11529E-03_JPRB,0.11740E-03_JPRB,0.11428E-03_JPRB, &
 & 0.10674E-03_JPRB,0.93329E-04_JPRB,0.76963E-04_JPRB,0.46781E-04_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.49298E-04_JPRB,0.93665E-04_JPRB,0.99302E-04_JPRB,0.10166E-03_JPRB,0.96125E-04_JPRB, &
 & 0.87991E-04_JPRB,0.77830E-04_JPRB,0.61651E-04_JPRB,0.45761E-04_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.50498E-04_JPRB,0.93479E-04_JPRB,0.98966E-04_JPRB,0.10139E-03_JPRB,0.96705E-04_JPRB, &
 & 0.89173E-04_JPRB,0.78227E-04_JPRB,0.62850E-04_JPRB,0.46039E-04_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.51269E-04_JPRB,0.93203E-04_JPRB,0.98973E-04_JPRB,0.10127E-03_JPRB,0.97298E-04_JPRB, &
 & 0.90362E-04_JPRB,0.78802E-04_JPRB,0.64157E-04_JPRB,0.46346E-04_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.51588E-04_JPRB,0.93137E-04_JPRB,0.99162E-04_JPRB,0.10129E-03_JPRB,0.98592E-04_JPRB, &
 & 0.91554E-04_JPRB,0.79929E-04_JPRB,0.65574E-04_JPRB,0.46727E-04_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.51597E-04_JPRB,0.92792E-04_JPRB,0.99458E-04_JPRB,0.10170E-03_JPRB,0.99448E-04_JPRB, &
 & 0.92834E-04_JPRB,0.81330E-04_JPRB,0.66366E-04_JPRB,0.47183E-04_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.41246E-04_JPRB,0.80496E-04_JPRB,0.85316E-04_JPRB,0.87435E-04_JPRB,0.82542E-04_JPRB, &
 & 0.75819E-04_JPRB,0.67022E-04_JPRB,0.53111E-04_JPRB,0.48352E-04_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.42332E-04_JPRB,0.80236E-04_JPRB,0.84984E-04_JPRB,0.87173E-04_JPRB,0.83192E-04_JPRB, &
 & 0.76872E-04_JPRB,0.67154E-04_JPRB,0.54235E-04_JPRB,0.49203E-04_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.43069E-04_JPRB,0.79969E-04_JPRB,0.85117E-04_JPRB,0.87191E-04_JPRB,0.83963E-04_JPRB, &
 & 0.78027E-04_JPRB,0.67911E-04_JPRB,0.55423E-04_JPRB,0.50036E-04_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.43347E-04_JPRB,0.79762E-04_JPRB,0.85176E-04_JPRB,0.87282E-04_JPRB,0.84970E-04_JPRB, &
 & 0.78971E-04_JPRB,0.69097E-04_JPRB,0.56659E-04_JPRB,0.50699E-04_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.43381E-04_JPRB,0.79473E-04_JPRB,0.85320E-04_JPRB,0.87550E-04_JPRB,0.85526E-04_JPRB, &
 & 0.80111E-04_JPRB,0.70399E-04_JPRB,0.56992E-04_JPRB,0.51218E-04_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.34402E-04_JPRB,0.69256E-04_JPRB,0.73264E-04_JPRB,0.74907E-04_JPRB,0.70733E-04_JPRB, &
 & 0.65058E-04_JPRB,0.57123E-04_JPRB,0.45547E-04_JPRB,0.49061E-04_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.35394E-04_JPRB,0.68938E-04_JPRB,0.72891E-04_JPRB,0.74693E-04_JPRB,0.71198E-04_JPRB, &
 & 0.66010E-04_JPRB,0.57419E-04_JPRB,0.46585E-04_JPRB,0.51368E-04_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.36086E-04_JPRB,0.68637E-04_JPRB,0.72875E-04_JPRB,0.74679E-04_JPRB,0.72090E-04_JPRB, &
 & 0.66902E-04_JPRB,0.58282E-04_JPRB,0.47622E-04_JPRB,0.51837E-04_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.36445E-04_JPRB,0.68326E-04_JPRB,0.72869E-04_JPRB,0.74856E-04_JPRB,0.72765E-04_JPRB, &
 & 0.67827E-04_JPRB,0.59362E-04_JPRB,0.48483E-04_JPRB,0.52297E-04_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.36483E-04_JPRB,0.68010E-04_JPRB,0.72961E-04_JPRB,0.75096E-04_JPRB,0.73241E-04_JPRB, &
 & 0.68587E-04_JPRB,0.60512E-04_JPRB,0.48784E-04_JPRB,0.53745E-04_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.28433E-04_JPRB,0.59232E-04_JPRB,0.62701E-04_JPRB,0.63901E-04_JPRB,0.60103E-04_JPRB, &
 & 0.55141E-04_JPRB,0.48531E-04_JPRB,0.38847E-04_JPRB,0.54662E-04_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.29405E-04_JPRB,0.58918E-04_JPRB,0.62216E-04_JPRB,0.63604E-04_JPRB,0.60633E-04_JPRB, &
 & 0.55830E-04_JPRB,0.48918E-04_JPRB,0.39795E-04_JPRB,0.56459E-04_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.30040E-04_JPRB,0.58597E-04_JPRB,0.61986E-04_JPRB,0.63627E-04_JPRB,0.61357E-04_JPRB, &
 & 0.56779E-04_JPRB,0.49706E-04_JPRB,0.40729E-04_JPRB,0.58698E-04_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.30412E-04_JPRB,0.58268E-04_JPRB,0.61940E-04_JPRB,0.63690E-04_JPRB,0.61916E-04_JPRB, &
 & 0.57700E-04_JPRB,0.50677E-04_JPRB,0.41137E-04_JPRB,0.60426E-04_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.30517E-04_JPRB,0.57913E-04_JPRB,0.61982E-04_JPRB,0.63808E-04_JPRB,0.62307E-04_JPRB, &
 & 0.58353E-04_JPRB,0.51602E-04_JPRB,0.41668E-04_JPRB,0.61933E-04_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.23291E-04_JPRB,0.50308E-04_JPRB,0.53243E-04_JPRB,0.54258E-04_JPRB,0.50787E-04_JPRB, &
 & 0.46509E-04_JPRB,0.41036E-04_JPRB,0.32969E-04_JPRB,0.63749E-04_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.24304E-04_JPRB,0.50027E-04_JPRB,0.52858E-04_JPRB,0.54035E-04_JPRB,0.51457E-04_JPRB, &
 & 0.47117E-04_JPRB,0.41427E-04_JPRB,0.33795E-04_JPRB,0.67891E-04_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.24884E-04_JPRB,0.49658E-04_JPRB,0.52484E-04_JPRB,0.53877E-04_JPRB,0.52001E-04_JPRB, &
 & 0.47908E-04_JPRB,0.42080E-04_JPRB,0.34652E-04_JPRB,0.71374E-04_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.25245E-04_JPRB,0.49329E-04_JPRB,0.52369E-04_JPRB,0.53861E-04_JPRB,0.52353E-04_JPRB, &
 & 0.48763E-04_JPRB,0.42918E-04_JPRB,0.34903E-04_JPRB,0.73983E-04_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.25399E-04_JPRB,0.49019E-04_JPRB,0.52344E-04_JPRB,0.53920E-04_JPRB,0.52702E-04_JPRB, &
 & 0.49354E-04_JPRB,0.43795E-04_JPRB,0.35336E-04_JPRB,0.76874E-04_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.19464E-04_JPRB,0.42428E-04_JPRB,0.44774E-04_JPRB,0.45764E-04_JPRB,0.43065E-04_JPRB, &
 & 0.39257E-04_JPRB,0.34681E-04_JPRB,0.28149E-04_JPRB,0.56538E-04_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.20274E-04_JPRB,0.42118E-04_JPRB,0.44484E-04_JPRB,0.45525E-04_JPRB,0.43594E-04_JPRB, &
 & 0.39908E-04_JPRB,0.35109E-04_JPRB,0.28880E-04_JPRB,0.61143E-04_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.20723E-04_JPRB,0.41781E-04_JPRB,0.44183E-04_JPRB,0.45345E-04_JPRB,0.43968E-04_JPRB, &
 & 0.40542E-04_JPRB,0.35722E-04_JPRB,0.29427E-04_JPRB,0.66428E-04_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.20986E-04_JPRB,0.41469E-04_JPRB,0.44005E-04_JPRB,0.45299E-04_JPRB,0.44240E-04_JPRB, &
 & 0.41204E-04_JPRB,0.36501E-04_JPRB,0.29565E-04_JPRB,0.70536E-04_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.21088E-04_JPRB,0.41122E-04_JPRB,0.44008E-04_JPRB,0.45344E-04_JPRB,0.44427E-04_JPRB, &
 & 0.41695E-04_JPRB,0.37345E-04_JPRB,0.29974E-04_JPRB,0.74164E-04_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.16205E-04_JPRB,0.35661E-04_JPRB,0.37585E-04_JPRB,0.38332E-04_JPRB,0.36196E-04_JPRB, &
 & 0.33054E-04_JPRB,0.29216E-04_JPRB,0.23917E-04_JPRB,0.49111E-04_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.16873E-04_JPRB,0.35314E-04_JPRB,0.37290E-04_JPRB,0.38165E-04_JPRB,0.36667E-04_JPRB, &
 & 0.33618E-04_JPRB,0.29598E-04_JPRB,0.24536E-04_JPRB,0.53408E-04_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.17216E-04_JPRB,0.35012E-04_JPRB,0.37013E-04_JPRB,0.37971E-04_JPRB,0.36937E-04_JPRB, &
 & 0.34200E-04_JPRB,0.30188E-04_JPRB,0.24727E-04_JPRB,0.56692E-04_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.17409E-04_JPRB,0.34711E-04_JPRB,0.36851E-04_JPRB,0.37885E-04_JPRB,0.37053E-04_JPRB, &
 & 0.34609E-04_JPRB,0.30881E-04_JPRB,0.24937E-04_JPRB,0.60809E-04_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.17480E-04_JPRB,0.34362E-04_JPRB,0.36830E-04_JPRB,0.37891E-04_JPRB,0.37213E-04_JPRB, &
 & 0.35045E-04_JPRB,0.31524E-04_JPRB,0.25269E-04_JPRB,0.65163E-04_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.13457E-04_JPRB,0.29884E-04_JPRB,0.31446E-04_JPRB,0.32052E-04_JPRB,0.30374E-04_JPRB, &
 & 0.27733E-04_JPRB,0.24511E-04_JPRB,0.20198E-04_JPRB,0.41009E-04_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.14007E-04_JPRB,0.29560E-04_JPRB,0.31187E-04_JPRB,0.31882E-04_JPRB,0.30716E-04_JPRB, &
 & 0.28181E-04_JPRB,0.24877E-04_JPRB,0.20737E-04_JPRB,0.44661E-04_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.14280E-04_JPRB,0.29273E-04_JPRB,0.30932E-04_JPRB,0.31685E-04_JPRB,0.30856E-04_JPRB, &
 & 0.28687E-04_JPRB,0.25310E-04_JPRB,0.20664E-04_JPRB,0.47397E-04_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.14434E-04_JPRB,0.28982E-04_JPRB,0.30751E-04_JPRB,0.31601E-04_JPRB,0.30957E-04_JPRB, &
 & 0.28945E-04_JPRB,0.25864E-04_JPRB,0.20868E-04_JPRB,0.50575E-04_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.14483E-04_JPRB,0.28660E-04_JPRB,0.30711E-04_JPRB,0.31533E-04_JPRB,0.31075E-04_JPRB, &
 & 0.29320E-04_JPRB,0.26408E-04_JPRB,0.21257E-04_JPRB,0.54097E-04_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.22536E-03_JPRB,0.32037E-03_JPRB,0.33781E-03_JPRB,0.34273E-03_JPRB,0.33729E-03_JPRB, &
 & 0.32075E-03_JPRB,0.29153E-03_JPRB,0.24856E-03_JPRB,0.16410E-03_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.22342E-03_JPRB,0.32281E-03_JPRB,0.34293E-03_JPRB,0.34673E-03_JPRB,0.34167E-03_JPRB, &
 & 0.32688E-03_JPRB,0.29787E-03_JPRB,0.25566E-03_JPRB,0.17029E-03_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.22157E-03_JPRB,0.32559E-03_JPRB,0.34865E-03_JPRB,0.35164E-03_JPRB,0.34805E-03_JPRB, &
 & 0.33353E-03_JPRB,0.30505E-03_JPRB,0.26380E-03_JPRB,0.17749E-03_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.21986E-03_JPRB,0.32894E-03_JPRB,0.35375E-03_JPRB,0.35845E-03_JPRB,0.35514E-03_JPRB, &
 & 0.33992E-03_JPRB,0.31266E-03_JPRB,0.27259E-03_JPRB,0.18209E-03_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.21815E-03_JPRB,0.33282E-03_JPRB,0.35982E-03_JPRB,0.36699E-03_JPRB,0.36319E-03_JPRB, &
 & 0.34849E-03_JPRB,0.32265E-03_JPRB,0.28174E-03_JPRB,0.18630E-03_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.19541E-03_JPRB,0.28383E-03_JPRB,0.30057E-03_JPRB,0.30208E-03_JPRB,0.29811E-03_JPRB, &
 & 0.28614E-03_JPRB,0.25813E-03_JPRB,0.22172E-03_JPRB,0.14533E-03_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.19410E-03_JPRB,0.28606E-03_JPRB,0.30502E-03_JPRB,0.30638E-03_JPRB,0.30342E-03_JPRB, &
 & 0.29123E-03_JPRB,0.26438E-03_JPRB,0.22759E-03_JPRB,0.15063E-03_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.19280E-03_JPRB,0.28892E-03_JPRB,0.31031E-03_JPRB,0.31345E-03_JPRB,0.30930E-03_JPRB, &
 & 0.29708E-03_JPRB,0.27075E-03_JPRB,0.23476E-03_JPRB,0.15387E-03_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.19169E-03_JPRB,0.29226E-03_JPRB,0.31596E-03_JPRB,0.32060E-03_JPRB,0.31687E-03_JPRB, &
 & 0.30282E-03_JPRB,0.27961E-03_JPRB,0.24147E-03_JPRB,0.15653E-03_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.19047E-03_JPRB,0.29594E-03_JPRB,0.32186E-03_JPRB,0.32831E-03_JPRB,0.32510E-03_JPRB, &
 & 0.31022E-03_JPRB,0.28786E-03_JPRB,0.24847E-03_JPRB,0.16195E-03_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.16871E-03_JPRB,0.24969E-03_JPRB,0.26468E-03_JPRB,0.26465E-03_JPRB,0.26214E-03_JPRB, &
 & 0.25247E-03_JPRB,0.22732E-03_JPRB,0.19530E-03_JPRB,0.12777E-03_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.16793E-03_JPRB,0.25161E-03_JPRB,0.26876E-03_JPRB,0.26973E-03_JPRB,0.26695E-03_JPRB, &
 & 0.25688E-03_JPRB,0.23244E-03_JPRB,0.20054E-03_JPRB,0.12972E-03_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.16733E-03_JPRB,0.25378E-03_JPRB,0.27385E-03_JPRB,0.27612E-03_JPRB,0.27305E-03_JPRB, &
 & 0.26119E-03_JPRB,0.23922E-03_JPRB,0.20542E-03_JPRB,0.13061E-03_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.16706E-03_JPRB,0.25676E-03_JPRB,0.27970E-03_JPRB,0.28379E-03_JPRB,0.28013E-03_JPRB, &
 & 0.26708E-03_JPRB,0.24668E-03_JPRB,0.21081E-03_JPRB,0.13394E-03_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.16637E-03_JPRB,0.26037E-03_JPRB,0.28504E-03_JPRB,0.29050E-03_JPRB,0.28611E-03_JPRB, &
 & 0.27355E-03_JPRB,0.25260E-03_JPRB,0.21670E-03_JPRB,0.13844E-03_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.14579E-03_JPRB,0.21908E-03_JPRB,0.23187E-03_JPRB,0.23162E-03_JPRB,0.22921E-03_JPRB, &
 & 0.22070E-03_JPRB,0.19997E-03_JPRB,0.17094E-03_JPRB,0.11198E-03_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.14542E-03_JPRB,0.22095E-03_JPRB,0.23576E-03_JPRB,0.23659E-03_JPRB,0.23393E-03_JPRB, &
 & 0.22421E-03_JPRB,0.20413E-03_JPRB,0.17485E-03_JPRB,0.11080E-03_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.14519E-03_JPRB,0.22277E-03_JPRB,0.24039E-03_JPRB,0.24264E-03_JPRB,0.23941E-03_JPRB, &
 & 0.22826E-03_JPRB,0.20957E-03_JPRB,0.17862E-03_JPRB,0.11236E-03_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.14504E-03_JPRB,0.22526E-03_JPRB,0.24523E-03_JPRB,0.24877E-03_JPRB,0.24473E-03_JPRB, &
 & 0.23381E-03_JPRB,0.21512E-03_JPRB,0.18339E-03_JPRB,0.11577E-03_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.14497E-03_JPRB,0.22869E-03_JPRB,0.25070E-03_JPRB,0.25513E-03_JPRB,0.25076E-03_JPRB, &
 & 0.23990E-03_JPRB,0.22117E-03_JPRB,0.18804E-03_JPRB,0.11947E-03_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.12609E-03_JPRB,0.19125E-03_JPRB,0.20302E-03_JPRB,0.20235E-03_JPRB,0.20038E-03_JPRB, &
 & 0.19210E-03_JPRB,0.17493E-03_JPRB,0.14918E-03_JPRB,0.95914E-04_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.12575E-03_JPRB,0.19304E-03_JPRB,0.20668E-03_JPRB,0.20708E-03_JPRB,0.20395E-03_JPRB, &
 & 0.19513E-03_JPRB,0.17862E-03_JPRB,0.15191E-03_JPRB,0.95952E-04_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.12572E-03_JPRB,0.19504E-03_JPRB,0.21070E-03_JPRB,0.21227E-03_JPRB,0.20862E-03_JPRB, &
 & 0.19877E-03_JPRB,0.18323E-03_JPRB,0.15540E-03_JPRB,0.98040E-04_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.12578E-03_JPRB,0.19736E-03_JPRB,0.21498E-03_JPRB,0.21770E-03_JPRB,0.21305E-03_JPRB, &
 & 0.20380E-03_JPRB,0.18766E-03_JPRB,0.15949E-03_JPRB,0.10020E-03_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.12588E-03_JPRB,0.20051E-03_JPRB,0.21971E-03_JPRB,0.22313E-03_JPRB,0.21848E-03_JPRB, &
 & 0.20915E-03_JPRB,0.19284E-03_JPRB,0.16321E-03_JPRB,0.10267E-03_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.10863E-03_JPRB,0.16576E-03_JPRB,0.17695E-03_JPRB,0.17678E-03_JPRB,0.17469E-03_JPRB, &
 & 0.16678E-03_JPRB,0.15163E-03_JPRB,0.12940E-03_JPRB,0.89550E-04_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.10863E-03_JPRB,0.16706E-03_JPRB,0.18030E-03_JPRB,0.18081E-03_JPRB,0.17775E-03_JPRB, &
 & 0.16938E-03_JPRB,0.15534E-03_JPRB,0.13148E-03_JPRB,0.89670E-04_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.10855E-03_JPRB,0.16916E-03_JPRB,0.18384E-03_JPRB,0.18538E-03_JPRB,0.18134E-03_JPRB, &
 & 0.17272E-03_JPRB,0.15912E-03_JPRB,0.13459E-03_JPRB,0.90520E-04_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.10855E-03_JPRB,0.17152E-03_JPRB,0.18761E-03_JPRB,0.18997E-03_JPRB,0.18510E-03_JPRB, &
 & 0.17711E-03_JPRB,0.16286E-03_JPRB,0.13757E-03_JPRB,0.91792E-04_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.10853E-03_JPRB,0.17415E-03_JPRB,0.19152E-03_JPRB,0.19450E-03_JPRB,0.18955E-03_JPRB, &
 & 0.18160E-03_JPRB,0.16658E-03_JPRB,0.14151E-03_JPRB,0.94030E-04_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.92930E-04_JPRB,0.14283E-03_JPRB,0.15332E-03_JPRB,0.15365E-03_JPRB,0.15192E-03_JPRB, &
 & 0.14476E-03_JPRB,0.13092E-03_JPRB,0.11095E-03_JPRB,0.91877E-04_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.92984E-04_JPRB,0.14401E-03_JPRB,0.15614E-03_JPRB,0.15721E-03_JPRB,0.15413E-03_JPRB, &
 & 0.14688E-03_JPRB,0.13443E-03_JPRB,0.11315E-03_JPRB,0.90405E-04_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.92945E-04_JPRB,0.14573E-03_JPRB,0.15905E-03_JPRB,0.16110E-03_JPRB,0.15737E-03_JPRB, &
 & 0.14983E-03_JPRB,0.13738E-03_JPRB,0.11591E-03_JPRB,0.89977E-04_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.93035E-04_JPRB,0.14787E-03_JPRB,0.16239E-03_JPRB,0.16472E-03_JPRB,0.16084E-03_JPRB, &
 & 0.15371E-03_JPRB,0.14051E-03_JPRB,0.11827E-03_JPRB,0.90955E-04_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.92985E-04_JPRB,0.15023E-03_JPRB,0.16593E-03_JPRB,0.16877E-03_JPRB,0.16496E-03_JPRB, &
 & 0.15743E-03_JPRB,0.14348E-03_JPRB,0.12221E-03_JPRB,0.92269E-04_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.79600E-04_JPRB,0.12290E-03_JPRB,0.13269E-03_JPRB,0.13322E-03_JPRB,0.13145E-03_JPRB, &
 & 0.12540E-03_JPRB,0.11354E-03_JPRB,0.94559E-04_JPRB,0.10796E-03_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.79683E-04_JPRB,0.12390E-03_JPRB,0.13495E-03_JPRB,0.13633E-03_JPRB,0.13351E-03_JPRB, &
 & 0.12708E-03_JPRB,0.11620E-03_JPRB,0.96898E-04_JPRB,0.10854E-03_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.79630E-04_JPRB,0.12537E-03_JPRB,0.13745E-03_JPRB,0.13937E-03_JPRB,0.13626E-03_JPRB, &
 & 0.12970E-03_JPRB,0.11867E-03_JPRB,0.99068E-04_JPRB,0.10974E-03_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.79625E-04_JPRB,0.12719E-03_JPRB,0.14027E-03_JPRB,0.14234E-03_JPRB,0.13941E-03_JPRB, &
 & 0.13283E-03_JPRB,0.12113E-03_JPRB,0.10155E-03_JPRB,0.11075E-03_JPRB /)  
KA(:, 5, 8, 3) = (/ &
 & 0.79589E-04_JPRB,0.12914E-03_JPRB,0.14322E-03_JPRB,0.14575E-03_JPRB,0.14305E-03_JPRB, &
 & 0.13597E-03_JPRB,0.12361E-03_JPRB,0.10505E-03_JPRB,0.11038E-03_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.67917E-04_JPRB,0.10525E-03_JPRB,0.11421E-03_JPRB,0.11510E-03_JPRB,0.11341E-03_JPRB, &
 & 0.10850E-03_JPRB,0.97945E-04_JPRB,0.80197E-04_JPRB,0.13259E-03_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.67928E-04_JPRB,0.10625E-03_JPRB,0.11606E-03_JPRB,0.11762E-03_JPRB,0.11532E-03_JPRB, &
 & 0.11035E-03_JPRB,0.10017E-03_JPRB,0.82394E-04_JPRB,0.13427E-03_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.67856E-04_JPRB,0.10744E-03_JPRB,0.11824E-03_JPRB,0.11998E-03_JPRB,0.11756E-03_JPRB, &
 & 0.11235E-03_JPRB,0.10203E-03_JPRB,0.84408E-04_JPRB,0.13461E-03_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.67768E-04_JPRB,0.10890E-03_JPRB,0.12070E-03_JPRB,0.12262E-03_JPRB,0.12012E-03_JPRB, &
 & 0.11456E-03_JPRB,0.10420E-03_JPRB,0.86916E-04_JPRB,0.13504E-03_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.67707E-04_JPRB,0.11054E-03_JPRB,0.12323E-03_JPRB,0.12567E-03_JPRB,0.12318E-03_JPRB, &
 & 0.11694E-03_JPRB,0.10644E-03_JPRB,0.89648E-04_JPRB,0.13829E-03_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.57658E-04_JPRB,0.89812E-04_JPRB,0.97774E-04_JPRB,0.98825E-04_JPRB,0.97412E-04_JPRB, &
 & 0.93433E-04_JPRB,0.84119E-04_JPRB,0.68026E-04_JPRB,0.20137E-03_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.57461E-04_JPRB,0.90575E-04_JPRB,0.99228E-04_JPRB,0.10076E-03_JPRB,0.98930E-04_JPRB, &
 & 0.94984E-04_JPRB,0.86081E-04_JPRB,0.70085E-04_JPRB,0.20178E-03_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.57397E-04_JPRB,0.91666E-04_JPRB,0.10122E-03_JPRB,0.10281E-03_JPRB,0.10088E-03_JPRB, &
 & 0.96688E-04_JPRB,0.87695E-04_JPRB,0.72010E-04_JPRB,0.20052E-03_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.57291E-04_JPRB,0.92869E-04_JPRB,0.10334E-03_JPRB,0.10517E-03_JPRB,0.10317E-03_JPRB, &
 & 0.98293E-04_JPRB,0.89394E-04_JPRB,0.74251E-04_JPRB,0.20103E-03_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.57126E-04_JPRB,0.94072E-04_JPRB,0.10545E-03_JPRB,0.10789E-03_JPRB,0.10579E-03_JPRB, &
 & 0.10034E-03_JPRB,0.91420E-04_JPRB,0.76761E-04_JPRB,0.20035E-03_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.48600E-04_JPRB,0.76535E-04_JPRB,0.83721E-04_JPRB,0.84782E-04_JPRB,0.83379E-04_JPRB, &
 & 0.80481E-04_JPRB,0.72441E-04_JPRB,0.58503E-04_JPRB,0.20926E-03_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.48356E-04_JPRB,0.77272E-04_JPRB,0.85067E-04_JPRB,0.86588E-04_JPRB,0.84928E-04_JPRB, &
 & 0.81803E-04_JPRB,0.74015E-04_JPRB,0.60222E-04_JPRB,0.21110E-03_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.48180E-04_JPRB,0.78198E-04_JPRB,0.86939E-04_JPRB,0.88416E-04_JPRB,0.86712E-04_JPRB, &
 & 0.83176E-04_JPRB,0.75535E-04_JPRB,0.61973E-04_JPRB,0.20823E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART3',0,ZHOOK_HANDLE)


KA(:, 4,11, 3) = (/ &
 & 0.48042E-04_JPRB,0.79160E-04_JPRB,0.88776E-04_JPRB,0.90704E-04_JPRB,0.88934E-04_JPRB, &
 & 0.84522E-04_JPRB,0.76983E-04_JPRB,0.64264E-04_JPRB,0.20745E-03_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.47901E-04_JPRB,0.80171E-04_JPRB,0.90395E-04_JPRB,0.92950E-04_JPRB,0.91253E-04_JPRB, &
 & 0.86364E-04_JPRB,0.78675E-04_JPRB,0.66159E-04_JPRB,0.20642E-03_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.40769E-04_JPRB,0.64775E-04_JPRB,0.71240E-04_JPRB,0.72409E-04_JPRB,0.71085E-04_JPRB, &
 & 0.68679E-04_JPRB,0.61925E-04_JPRB,0.50009E-04_JPRB,0.19056E-03_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.40486E-04_JPRB,0.65479E-04_JPRB,0.72574E-04_JPRB,0.73906E-04_JPRB,0.72438E-04_JPRB, &
 & 0.69693E-04_JPRB,0.63286E-04_JPRB,0.51717E-04_JPRB,0.19000E-03_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.40313E-04_JPRB,0.66212E-04_JPRB,0.74137E-04_JPRB,0.75686E-04_JPRB,0.74201E-04_JPRB, &
 & 0.70781E-04_JPRB,0.64554E-04_JPRB,0.53372E-04_JPRB,0.19242E-03_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.40107E-04_JPRB,0.66938E-04_JPRB,0.75524E-04_JPRB,0.77664E-04_JPRB,0.76142E-04_JPRB, &
 & 0.72280E-04_JPRB,0.65894E-04_JPRB,0.55174E-04_JPRB,0.19382E-03_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.39910E-04_JPRB,0.67782E-04_JPRB,0.76780E-04_JPRB,0.79463E-04_JPRB,0.78210E-04_JPRB, &
 & 0.73902E-04_JPRB,0.67292E-04_JPRB,0.56789E-04_JPRB,0.19106E-03_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.34103E-04_JPRB,0.54622E-04_JPRB,0.60315E-04_JPRB,0.61417E-04_JPRB,0.60332E-04_JPRB, &
 & 0.58110E-04_JPRB,0.52537E-04_JPRB,0.42612E-04_JPRB,0.15955E-03_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.33853E-04_JPRB,0.55148E-04_JPRB,0.61492E-04_JPRB,0.62745E-04_JPRB,0.61577E-04_JPRB, &
 & 0.59061E-04_JPRB,0.53702E-04_JPRB,0.43873E-04_JPRB,0.15892E-03_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.33647E-04_JPRB,0.55699E-04_JPRB,0.62687E-04_JPRB,0.64355E-04_JPRB,0.63160E-04_JPRB, &
 & 0.60072E-04_JPRB,0.54954E-04_JPRB,0.45643E-04_JPRB,0.16047E-03_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.33430E-04_JPRB,0.56291E-04_JPRB,0.63770E-04_JPRB,0.65844E-04_JPRB,0.64844E-04_JPRB, &
 & 0.61457E-04_JPRB,0.56064E-04_JPRB,0.47101E-04_JPRB,0.16125E-03_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.33186E-04_JPRB,0.56947E-04_JPRB,0.64747E-04_JPRB,0.67352E-04_JPRB,0.66508E-04_JPRB, &
 & 0.62903E-04_JPRB,0.57307E-04_JPRB,0.48379E-04_JPRB,0.16021E-03_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.36602E-03_JPRB,0.52858E-03_JPRB,0.59251E-03_JPRB,0.61027E-03_JPRB,0.60893E-03_JPRB, &
 & 0.58987E-03_JPRB,0.55560E-03_JPRB,0.49855E-03_JPRB,0.38105E-03_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.36935E-03_JPRB,0.53570E-03_JPRB,0.60138E-03_JPRB,0.62341E-03_JPRB,0.62297E-03_JPRB, &
 & 0.60228E-03_JPRB,0.56872E-03_JPRB,0.51035E-03_JPRB,0.39106E-03_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.37348E-03_JPRB,0.54590E-03_JPRB,0.61238E-03_JPRB,0.63855E-03_JPRB,0.63820E-03_JPRB, &
 & 0.61734E-03_JPRB,0.58475E-03_JPRB,0.52206E-03_JPRB,0.40317E-03_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.37665E-03_JPRB,0.55373E-03_JPRB,0.62261E-03_JPRB,0.65120E-03_JPRB,0.65250E-03_JPRB, &
 & 0.63373E-03_JPRB,0.59840E-03_JPRB,0.53517E-03_JPRB,0.41639E-03_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.38076E-03_JPRB,0.56302E-03_JPRB,0.63456E-03_JPRB,0.66611E-03_JPRB,0.66857E-03_JPRB, &
 & 0.65240E-03_JPRB,0.61521E-03_JPRB,0.55178E-03_JPRB,0.43702E-03_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.32225E-03_JPRB,0.47151E-03_JPRB,0.53262E-03_JPRB,0.55192E-03_JPRB,0.54706E-03_JPRB, &
 & 0.52658E-03_JPRB,0.49569E-03_JPRB,0.43958E-03_JPRB,0.31739E-03_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.32532E-03_JPRB,0.47816E-03_JPRB,0.54076E-03_JPRB,0.56222E-03_JPRB,0.55834E-03_JPRB, &
 & 0.53879E-03_JPRB,0.50612E-03_JPRB,0.44777E-03_JPRB,0.32763E-03_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.32941E-03_JPRB,0.48729E-03_JPRB,0.55083E-03_JPRB,0.57497E-03_JPRB,0.57312E-03_JPRB, &
 & 0.55394E-03_JPRB,0.51991E-03_JPRB,0.45969E-03_JPRB,0.33942E-03_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.33303E-03_JPRB,0.49510E-03_JPRB,0.56036E-03_JPRB,0.58720E-03_JPRB,0.58669E-03_JPRB, &
 & 0.56974E-03_JPRB,0.53255E-03_JPRB,0.47385E-03_JPRB,0.35453E-03_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.33657E-03_JPRB,0.50290E-03_JPRB,0.57014E-03_JPRB,0.59917E-03_JPRB,0.59997E-03_JPRB, &
 & 0.58475E-03_JPRB,0.54777E-03_JPRB,0.48909E-03_JPRB,0.36980E-03_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.28263E-03_JPRB,0.41968E-03_JPRB,0.47376E-03_JPRB,0.49297E-03_JPRB,0.48633E-03_JPRB, &
 & 0.46530E-03_JPRB,0.43654E-03_JPRB,0.38496E-03_JPRB,0.26217E-03_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.28517E-03_JPRB,0.42528E-03_JPRB,0.48017E-03_JPRB,0.50148E-03_JPRB,0.49564E-03_JPRB, &
 & 0.47634E-03_JPRB,0.44517E-03_JPRB,0.39228E-03_JPRB,0.27386E-03_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.28805E-03_JPRB,0.43254E-03_JPRB,0.48769E-03_JPRB,0.51075E-03_JPRB,0.50628E-03_JPRB, &
 & 0.48940E-03_JPRB,0.45557E-03_JPRB,0.40274E-03_JPRB,0.28527E-03_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.29156E-03_JPRB,0.44130E-03_JPRB,0.49824E-03_JPRB,0.52245E-03_JPRB,0.52001E-03_JPRB, &
 & 0.50355E-03_JPRB,0.46711E-03_JPRB,0.41540E-03_JPRB,0.29729E-03_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.29453E-03_JPRB,0.44828E-03_JPRB,0.50753E-03_JPRB,0.53257E-03_JPRB,0.53321E-03_JPRB, &
 & 0.51645E-03_JPRB,0.48189E-03_JPRB,0.42882E-03_JPRB,0.30960E-03_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.24709E-03_JPRB,0.37040E-03_JPRB,0.41811E-03_JPRB,0.43692E-03_JPRB,0.42924E-03_JPRB, &
 & 0.40974E-03_JPRB,0.38217E-03_JPRB,0.33504E-03_JPRB,0.21956E-03_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.24935E-03_JPRB,0.37531E-03_JPRB,0.42359E-03_JPRB,0.44356E-03_JPRB,0.43669E-03_JPRB, &
 & 0.41955E-03_JPRB,0.39063E-03_JPRB,0.34337E-03_JPRB,0.23257E-03_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.25192E-03_JPRB,0.38183E-03_JPRB,0.43049E-03_JPRB,0.45130E-03_JPRB,0.44572E-03_JPRB, &
 & 0.43016E-03_JPRB,0.39919E-03_JPRB,0.35274E-03_JPRB,0.24051E-03_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.25420E-03_JPRB,0.38887E-03_JPRB,0.43864E-03_JPRB,0.46020E-03_JPRB,0.45692E-03_JPRB, &
 & 0.44111E-03_JPRB,0.40882E-03_JPRB,0.36219E-03_JPRB,0.24966E-03_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.25772E-03_JPRB,0.39769E-03_JPRB,0.44993E-03_JPRB,0.47213E-03_JPRB,0.47068E-03_JPRB, &
 & 0.45426E-03_JPRB,0.42157E-03_JPRB,0.37400E-03_JPRB,0.25930E-03_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.21574E-03_JPRB,0.32603E-03_JPRB,0.36644E-03_JPRB,0.38307E-03_JPRB,0.37721E-03_JPRB, &
 & 0.36018E-03_JPRB,0.33363E-03_JPRB,0.29143E-03_JPRB,0.18896E-03_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.21778E-03_JPRB,0.33044E-03_JPRB,0.37107E-03_JPRB,0.38833E-03_JPRB,0.38426E-03_JPRB, &
 & 0.36797E-03_JPRB,0.34054E-03_JPRB,0.29920E-03_JPRB,0.19816E-03_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.22015E-03_JPRB,0.33584E-03_JPRB,0.37735E-03_JPRB,0.39513E-03_JPRB,0.39228E-03_JPRB, &
 & 0.37720E-03_JPRB,0.34842E-03_JPRB,0.30654E-03_JPRB,0.20383E-03_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.22252E-03_JPRB,0.34167E-03_JPRB,0.38484E-03_JPRB,0.40343E-03_JPRB,0.40251E-03_JPRB, &
 & 0.38567E-03_JPRB,0.35760E-03_JPRB,0.31401E-03_JPRB,0.21178E-03_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.22604E-03_JPRB,0.34964E-03_JPRB,0.39509E-03_JPRB,0.41443E-03_JPRB,0.41465E-03_JPRB, &
 & 0.39685E-03_JPRB,0.36847E-03_JPRB,0.32400E-03_JPRB,0.21929E-03_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.18783E-03_JPRB,0.28666E-03_JPRB,0.32037E-03_JPRB,0.33351E-03_JPRB,0.32945E-03_JPRB, &
 & 0.31516E-03_JPRB,0.29066E-03_JPRB,0.25263E-03_JPRB,0.16238E-03_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.18921E-03_JPRB,0.29078E-03_JPRB,0.32423E-03_JPRB,0.33799E-03_JPRB,0.33536E-03_JPRB, &
 & 0.32156E-03_JPRB,0.29643E-03_JPRB,0.25941E-03_JPRB,0.16831E-03_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.19117E-03_JPRB,0.29487E-03_JPRB,0.32978E-03_JPRB,0.34375E-03_JPRB,0.34274E-03_JPRB, &
 & 0.32907E-03_JPRB,0.30344E-03_JPRB,0.26560E-03_JPRB,0.17389E-03_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.19356E-03_JPRB,0.29979E-03_JPRB,0.33631E-03_JPRB,0.35135E-03_JPRB,0.35098E-03_JPRB, &
 & 0.33648E-03_JPRB,0.31108E-03_JPRB,0.27199E-03_JPRB,0.18056E-03_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.19643E-03_JPRB,0.30567E-03_JPRB,0.34396E-03_JPRB,0.35996E-03_JPRB,0.36067E-03_JPRB, &
 & 0.34559E-03_JPRB,0.32056E-03_JPRB,0.28009E-03_JPRB,0.18507E-03_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.16233E-03_JPRB,0.25159E-03_JPRB,0.28051E-03_JPRB,0.29071E-03_JPRB,0.28724E-03_JPRB, &
 & 0.27399E-03_JPRB,0.25257E-03_JPRB,0.21995E-03_JPRB,0.15053E-03_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.16394E-03_JPRB,0.25497E-03_JPRB,0.28374E-03_JPRB,0.29454E-03_JPRB,0.29203E-03_JPRB, &
 & 0.28002E-03_JPRB,0.25781E-03_JPRB,0.22523E-03_JPRB,0.15467E-03_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.16554E-03_JPRB,0.25862E-03_JPRB,0.28837E-03_JPRB,0.29946E-03_JPRB,0.29804E-03_JPRB, &
 & 0.28580E-03_JPRB,0.26386E-03_JPRB,0.23003E-03_JPRB,0.15858E-03_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.16755E-03_JPRB,0.26275E-03_JPRB,0.29380E-03_JPRB,0.30624E-03_JPRB,0.30499E-03_JPRB, &
 & 0.29233E-03_JPRB,0.27029E-03_JPRB,0.23539E-03_JPRB,0.16161E-03_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.17007E-03_JPRB,0.26765E-03_JPRB,0.30035E-03_JPRB,0.31353E-03_JPRB,0.31332E-03_JPRB, &
 & 0.30019E-03_JPRB,0.27871E-03_JPRB,0.24192E-03_JPRB,0.16587E-03_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.14021E-03_JPRB,0.21983E-03_JPRB,0.24557E-03_JPRB,0.25394E-03_JPRB,0.25027E-03_JPRB, &
 & 0.23769E-03_JPRB,0.21853E-03_JPRB,0.19056E-03_JPRB,0.17210E-03_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.14181E-03_JPRB,0.22244E-03_JPRB,0.24837E-03_JPRB,0.25730E-03_JPRB,0.25433E-03_JPRB, &
 & 0.24284E-03_JPRB,0.22361E-03_JPRB,0.19448E-03_JPRB,0.16707E-03_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.14344E-03_JPRB,0.22578E-03_JPRB,0.25216E-03_JPRB,0.26169E-03_JPRB,0.25950E-03_JPRB, &
 & 0.24760E-03_JPRB,0.22868E-03_JPRB,0.19861E-03_JPRB,0.16518E-03_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.14524E-03_JPRB,0.22935E-03_JPRB,0.25652E-03_JPRB,0.26715E-03_JPRB,0.26554E-03_JPRB, &
 & 0.25327E-03_JPRB,0.23470E-03_JPRB,0.20360E-03_JPRB,0.16514E-03_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.14752E-03_JPRB,0.23348E-03_JPRB,0.26209E-03_JPRB,0.27316E-03_JPRB,0.27225E-03_JPRB, &
 & 0.26056E-03_JPRB,0.24203E-03_JPRB,0.20916E-03_JPRB,0.16671E-03_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.12008E-03_JPRB,0.19084E-03_JPRB,0.21359E-03_JPRB,0.22137E-03_JPRB,0.21826E-03_JPRB, &
 & 0.20646E-03_JPRB,0.18855E-03_JPRB,0.16443E-03_JPRB,0.31379E-03_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.12170E-03_JPRB,0.19281E-03_JPRB,0.21619E-03_JPRB,0.22414E-03_JPRB,0.22156E-03_JPRB, &
 & 0.21036E-03_JPRB,0.19272E-03_JPRB,0.16751E-03_JPRB,0.30810E-03_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.12341E-03_JPRB,0.19553E-03_JPRB,0.21930E-03_JPRB,0.22810E-03_JPRB,0.22604E-03_JPRB, &
 & 0.21457E-03_JPRB,0.19724E-03_JPRB,0.17093E-03_JPRB,0.30579E-03_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.12515E-03_JPRB,0.19866E-03_JPRB,0.22306E-03_JPRB,0.23273E-03_JPRB,0.23128E-03_JPRB, &
 & 0.22000E-03_JPRB,0.20255E-03_JPRB,0.17520E-03_JPRB,0.30468E-03_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.12711E-03_JPRB,0.20244E-03_JPRB,0.22780E-03_JPRB,0.23779E-03_JPRB,0.23723E-03_JPRB, &
 & 0.22672E-03_JPRB,0.20873E-03_JPRB,0.18006E-03_JPRB,0.30071E-03_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.10239E-03_JPRB,0.16495E-03_JPRB,0.18568E-03_JPRB,0.19287E-03_JPRB,0.19038E-03_JPRB, &
 & 0.17962E-03_JPRB,0.16274E-03_JPRB,0.14112E-03_JPRB,0.46281E-03_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.10386E-03_JPRB,0.16652E-03_JPRB,0.18791E-03_JPRB,0.19539E-03_JPRB,0.19307E-03_JPRB, &
 & 0.18291E-03_JPRB,0.16628E-03_JPRB,0.14354E-03_JPRB,0.46032E-03_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.10550E-03_JPRB,0.16884E-03_JPRB,0.19060E-03_JPRB,0.19863E-03_JPRB,0.19685E-03_JPRB, &
 & 0.18669E-03_JPRB,0.17045E-03_JPRB,0.14674E-03_JPRB,0.45882E-03_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.10710E-03_JPRB,0.17185E-03_JPRB,0.19377E-03_JPRB,0.20238E-03_JPRB,0.20140E-03_JPRB, &
 & 0.19164E-03_JPRB,0.17544E-03_JPRB,0.15076E-03_JPRB,0.45556E-03_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.10887E-03_JPRB,0.17528E-03_JPRB,0.19755E-03_JPRB,0.20663E-03_JPRB,0.20650E-03_JPRB, &
 & 0.19756E-03_JPRB,0.18068E-03_JPRB,0.15495E-03_JPRB,0.45295E-03_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.87454E-04_JPRB,0.14214E-03_JPRB,0.16093E-03_JPRB,0.16784E-03_JPRB,0.16634E-03_JPRB, &
 & 0.15750E-03_JPRB,0.14233E-03_JPRB,0.12157E-03_JPRB,0.50227E-03_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.89026E-04_JPRB,0.14363E-03_JPRB,0.16297E-03_JPRB,0.17024E-03_JPRB,0.16905E-03_JPRB, &
 & 0.16052E-03_JPRB,0.14560E-03_JPRB,0.12384E-03_JPRB,0.48800E-03_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.90456E-04_JPRB,0.14595E-03_JPRB,0.16534E-03_JPRB,0.17342E-03_JPRB,0.17281E-03_JPRB, &
 & 0.16441E-03_JPRB,0.14965E-03_JPRB,0.12699E-03_JPRB,0.48638E-03_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.91788E-04_JPRB,0.14885E-03_JPRB,0.16823E-03_JPRB,0.17680E-03_JPRB,0.17688E-03_JPRB, &
 & 0.16911E-03_JPRB,0.15409E-03_JPRB,0.13060E-03_JPRB,0.48097E-03_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.92958E-04_JPRB,0.15220E-03_JPRB,0.17197E-03_JPRB,0.18085E-03_JPRB,0.18150E-03_JPRB, &
 & 0.17440E-03_JPRB,0.15892E-03_JPRB,0.13466E-03_JPRB,0.48115E-03_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.74228E-04_JPRB,0.12171E-03_JPRB,0.13828E-03_JPRB,0.14464E-03_JPRB,0.14381E-03_JPRB, &
 & 0.13674E-03_JPRB,0.12370E-03_JPRB,0.10454E-03_JPRB,0.48263E-03_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.75542E-04_JPRB,0.12330E-03_JPRB,0.13992E-03_JPRB,0.14688E-03_JPRB,0.14666E-03_JPRB, &
 & 0.13981E-03_JPRB,0.12694E-03_JPRB,0.10662E-03_JPRB,0.46961E-03_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.76696E-04_JPRB,0.12551E-03_JPRB,0.14218E-03_JPRB,0.14964E-03_JPRB,0.14989E-03_JPRB, &
 & 0.14346E-03_JPRB,0.13058E-03_JPRB,0.10986E-03_JPRB,0.45986E-03_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.77769E-04_JPRB,0.12821E-03_JPRB,0.14505E-03_JPRB,0.15276E-03_JPRB,0.15361E-03_JPRB, &
 & 0.14764E-03_JPRB,0.13466E-03_JPRB,0.11322E-03_JPRB,0.45064E-03_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.78633E-04_JPRB,0.13113E-03_JPRB,0.14863E-03_JPRB,0.15667E-03_JPRB,0.15783E-03_JPRB, &
 & 0.15249E-03_JPRB,0.13915E-03_JPRB,0.11696E-03_JPRB,0.45257E-03_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.62659E-04_JPRB,0.10388E-03_JPRB,0.11828E-03_JPRB,0.12392E-03_JPRB,0.12371E-03_JPRB, &
 & 0.11811E-03_JPRB,0.10712E-03_JPRB,0.89769E-04_JPRB,0.40925E-03_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.63709E-04_JPRB,0.10546E-03_JPRB,0.11986E-03_JPRB,0.12594E-03_JPRB,0.12627E-03_JPRB, &
 & 0.12095E-03_JPRB,0.11006E-03_JPRB,0.92053E-04_JPRB,0.39852E-03_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.64717E-04_JPRB,0.10750E-03_JPRB,0.12189E-03_JPRB,0.12839E-03_JPRB,0.12907E-03_JPRB, &
 & 0.12414E-03_JPRB,0.11317E-03_JPRB,0.94939E-04_JPRB,0.39013E-03_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.65465E-04_JPRB,0.10983E-03_JPRB,0.12464E-03_JPRB,0.13149E-03_JPRB,0.13253E-03_JPRB, &
 & 0.12801E-03_JPRB,0.11693E-03_JPRB,0.98001E-04_JPRB,0.38349E-03_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.66137E-04_JPRB,0.11222E-03_JPRB,0.12786E-03_JPRB,0.13517E-03_JPRB,0.13652E-03_JPRB, &
 & 0.13219E-03_JPRB,0.12093E-03_JPRB,0.10155E-03_JPRB,0.38305E-03_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.60998E-03_JPRB,0.92357E-03_JPRB,0.10463E-02_JPRB,0.11196E-02_JPRB,0.11571E-02_JPRB, &
 & 0.11569E-02_JPRB,0.11152E-02_JPRB,0.10342E-02_JPRB,0.80721E-03_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.61496E-03_JPRB,0.93510E-03_JPRB,0.10604E-02_JPRB,0.11361E-02_JPRB,0.11777E-02_JPRB, &
 & 0.11834E-02_JPRB,0.11457E-02_JPRB,0.10708E-02_JPRB,0.83732E-03_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.62454E-03_JPRB,0.95002E-03_JPRB,0.10819E-02_JPRB,0.11594E-02_JPRB,0.12038E-02_JPRB, &
 & 0.12158E-02_JPRB,0.11823E-02_JPRB,0.11158E-02_JPRB,0.87187E-03_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.63013E-03_JPRB,0.96444E-03_JPRB,0.11010E-02_JPRB,0.11847E-02_JPRB,0.12326E-02_JPRB, &
 & 0.12499E-02_JPRB,0.12239E-02_JPRB,0.11623E-02_JPRB,0.91505E-03_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.63867E-03_JPRB,0.98562E-03_JPRB,0.11276E-02_JPRB,0.12151E-02_JPRB,0.12673E-02_JPRB, &
 & 0.12886E-02_JPRB,0.12687E-02_JPRB,0.12127E-02_JPRB,0.95931E-03_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.54006E-03_JPRB,0.82110E-03_JPRB,0.93517E-03_JPRB,0.10086E-02_JPRB,0.10436E-02_JPRB, &
 & 0.10473E-02_JPRB,0.10071E-02_JPRB,0.92435E-03_JPRB,0.69632E-03_JPRB /)  
KA(:, 2, 2, 5) = (/ &
 & 0.54512E-03_JPRB,0.83214E-03_JPRB,0.94586E-03_JPRB,0.10224E-02_JPRB,0.10616E-02_JPRB, &
 & 0.10697E-02_JPRB,0.10360E-02_JPRB,0.95897E-03_JPRB,0.72282E-03_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.55430E-03_JPRB,0.84713E-03_JPRB,0.96481E-03_JPRB,0.10423E-02_JPRB,0.10850E-02_JPRB, &
 & 0.10972E-02_JPRB,0.10691E-02_JPRB,0.99640E-03_JPRB,0.75512E-03_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.56089E-03_JPRB,0.86369E-03_JPRB,0.98575E-03_JPRB,0.10648E-02_JPRB,0.11112E-02_JPRB, &
 & 0.11281E-02_JPRB,0.11049E-02_JPRB,0.10361E-02_JPRB,0.79150E-03_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.56701E-03_JPRB,0.88105E-03_JPRB,0.10081E-02_JPRB,0.10898E-02_JPRB,0.11420E-02_JPRB, &
 & 0.11626E-02_JPRB,0.11406E-02_JPRB,0.10780E-02_JPRB,0.83023E-03_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.47586E-03_JPRB,0.72781E-03_JPRB,0.83369E-03_JPRB,0.89860E-03_JPRB,0.93234E-03_JPRB, &
 & 0.93626E-03_JPRB,0.89909E-03_JPRB,0.81585E-03_JPRB,0.59036E-03_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.48035E-03_JPRB,0.73757E-03_JPRB,0.84502E-03_JPRB,0.91276E-03_JPRB,0.94800E-03_JPRB, &
 & 0.95536E-03_JPRB,0.92668E-03_JPRB,0.84501E-03_JPRB,0.61080E-03_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.48667E-03_JPRB,0.74941E-03_JPRB,0.86058E-03_JPRB,0.92996E-03_JPRB,0.96794E-03_JPRB, &
 & 0.97737E-03_JPRB,0.95368E-03_JPRB,0.87646E-03_JPRB,0.63872E-03_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.49637E-03_JPRB,0.76538E-03_JPRB,0.87882E-03_JPRB,0.95073E-03_JPRB,0.99190E-03_JPRB, &
 & 0.10051E-02_JPRB,0.98438E-03_JPRB,0.91070E-03_JPRB,0.66866E-03_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.50269E-03_JPRB,0.78028E-03_JPRB,0.89635E-03_JPRB,0.97198E-03_JPRB,0.10179E-02_JPRB, &
 & 0.10338E-02_JPRB,0.10130E-02_JPRB,0.94553E-03_JPRB,0.70095E-03_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.41745E-03_JPRB,0.64505E-03_JPRB,0.73966E-03_JPRB,0.79761E-03_JPRB,0.82752E-03_JPRB, &
 & 0.82878E-03_JPRB,0.79470E-03_JPRB,0.71636E-03_JPRB,0.49987E-03_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.42212E-03_JPRB,0.65318E-03_JPRB,0.75017E-03_JPRB,0.80979E-03_JPRB,0.84194E-03_JPRB, &
 & 0.84473E-03_JPRB,0.81717E-03_JPRB,0.73865E-03_JPRB,0.51625E-03_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.42808E-03_JPRB,0.66407E-03_JPRB,0.76314E-03_JPRB,0.82416E-03_JPRB,0.85814E-03_JPRB, &
 & 0.86375E-03_JPRB,0.83972E-03_JPRB,0.76440E-03_JPRB,0.53894E-03_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.43544E-03_JPRB,0.67737E-03_JPRB,0.77911E-03_JPRB,0.84222E-03_JPRB,0.87777E-03_JPRB, &
 & 0.88583E-03_JPRB,0.86479E-03_JPRB,0.79362E-03_JPRB,0.56271E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART4',0,ZHOOK_HANDLE)


KA(:, 5, 4, 5) = (/ &
 & 0.44549E-03_JPRB,0.69330E-03_JPRB,0.79686E-03_JPRB,0.86274E-03_JPRB,0.90103E-03_JPRB, &
 & 0.91189E-03_JPRB,0.89184E-03_JPRB,0.82416E-03_JPRB,0.58887E-03_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.36593E-03_JPRB,0.56942E-03_JPRB,0.65432E-03_JPRB,0.70354E-03_JPRB,0.72916E-03_JPRB, &
 & 0.72850E-03_JPRB,0.69713E-03_JPRB,0.62558E-03_JPRB,0.42621E-03_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.37099E-03_JPRB,0.57654E-03_JPRB,0.66395E-03_JPRB,0.71472E-03_JPRB,0.74107E-03_JPRB, &
 & 0.74240E-03_JPRB,0.71535E-03_JPRB,0.64376E-03_JPRB,0.43884E-03_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.37647E-03_JPRB,0.58652E-03_JPRB,0.67530E-03_JPRB,0.72837E-03_JPRB,0.75654E-03_JPRB, &
 & 0.75759E-03_JPRB,0.73402E-03_JPRB,0.66546E-03_JPRB,0.45630E-03_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.38311E-03_JPRB,0.59837E-03_JPRB,0.68871E-03_JPRB,0.74328E-03_JPRB,0.77277E-03_JPRB, &
 & 0.77677E-03_JPRB,0.75490E-03_JPRB,0.68962E-03_JPRB,0.47449E-03_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.39217E-03_JPRB,0.61368E-03_JPRB,0.70480E-03_JPRB,0.76178E-03_JPRB,0.79297E-03_JPRB, &
 & 0.79889E-03_JPRB,0.77761E-03_JPRB,0.71542E-03_JPRB,0.49580E-03_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.32055E-03_JPRB,0.49922E-03_JPRB,0.57435E-03_JPRB,0.61868E-03_JPRB,0.63931E-03_JPRB, &
 & 0.63779E-03_JPRB,0.60689E-03_JPRB,0.54327E-03_JPRB,0.36282E-03_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.32502E-03_JPRB,0.50520E-03_JPRB,0.58251E-03_JPRB,0.62835E-03_JPRB,0.64977E-03_JPRB, &
 & 0.64920E-03_JPRB,0.62209E-03_JPRB,0.55837E-03_JPRB,0.37399E-03_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.33055E-03_JPRB,0.51462E-03_JPRB,0.59267E-03_JPRB,0.63972E-03_JPRB,0.66253E-03_JPRB, &
 & 0.66213E-03_JPRB,0.63802E-03_JPRB,0.57660E-03_JPRB,0.38710E-03_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.33647E-03_JPRB,0.52569E-03_JPRB,0.60454E-03_JPRB,0.65260E-03_JPRB,0.67645E-03_JPRB, &
 & 0.67638E-03_JPRB,0.65560E-03_JPRB,0.59667E-03_JPRB,0.40130E-03_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.34306E-03_JPRB,0.53846E-03_JPRB,0.61820E-03_JPRB,0.66796E-03_JPRB,0.69284E-03_JPRB, &
 & 0.69400E-03_JPRB,0.67340E-03_JPRB,0.61700E-03_JPRB,0.41923E-03_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.28149E-03_JPRB,0.43644E-03_JPRB,0.49974E-03_JPRB,0.53938E-03_JPRB,0.55701E-03_JPRB, &
 & 0.55579E-03_JPRB,0.52736E-03_JPRB,0.47001E-03_JPRB,0.31306E-03_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.28528E-03_JPRB,0.44207E-03_JPRB,0.50655E-03_JPRB,0.54763E-03_JPRB,0.56691E-03_JPRB, &
 & 0.56439E-03_JPRB,0.53930E-03_JPRB,0.48247E-03_JPRB,0.32173E-03_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.29004E-03_JPRB,0.45020E-03_JPRB,0.51518E-03_JPRB,0.55741E-03_JPRB,0.57771E-03_JPRB, &
 & 0.57585E-03_JPRB,0.55263E-03_JPRB,0.49748E-03_JPRB,0.33090E-03_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.29568E-03_JPRB,0.46070E-03_JPRB,0.52625E-03_JPRB,0.56864E-03_JPRB,0.58962E-03_JPRB, &
 & 0.58944E-03_JPRB,0.56702E-03_JPRB,0.51458E-03_JPRB,0.34232E-03_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.30178E-03_JPRB,0.47274E-03_JPRB,0.53886E-03_JPRB,0.58253E-03_JPRB,0.60354E-03_JPRB, &
 & 0.60454E-03_JPRB,0.58225E-03_JPRB,0.53128E-03_JPRB,0.35470E-03_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.24786E-03_JPRB,0.38205E-03_JPRB,0.43403E-03_JPRB,0.46727E-03_JPRB,0.48302E-03_JPRB, &
 & 0.48227E-03_JPRB,0.45812E-03_JPRB,0.40611E-03_JPRB,0.30468E-03_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.25026E-03_JPRB,0.38705E-03_JPRB,0.43948E-03_JPRB,0.47351E-03_JPRB,0.49158E-03_JPRB, &
 & 0.49003E-03_JPRB,0.46771E-03_JPRB,0.41673E-03_JPRB,0.30992E-03_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.25464E-03_JPRB,0.39453E-03_JPRB,0.44681E-03_JPRB,0.48211E-03_JPRB,0.50112E-03_JPRB, &
 & 0.49992E-03_JPRB,0.47844E-03_JPRB,0.42901E-03_JPRB,0.31626E-03_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.25978E-03_JPRB,0.40390E-03_JPRB,0.45683E-03_JPRB,0.49220E-03_JPRB,0.51134E-03_JPRB, &
 & 0.51141E-03_JPRB,0.48898E-03_JPRB,0.44238E-03_JPRB,0.32406E-03_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.26514E-03_JPRB,0.41428E-03_JPRB,0.46827E-03_JPRB,0.50433E-03_JPRB,0.52333E-03_JPRB, &
 & 0.52414E-03_JPRB,0.50147E-03_JPRB,0.45619E-03_JPRB,0.33317E-03_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.21824E-03_JPRB,0.33786E-03_JPRB,0.37946E-03_JPRB,0.40535E-03_JPRB,0.41752E-03_JPRB, &
 & 0.41661E-03_JPRB,0.39611E-03_JPRB,0.34986E-03_JPRB,0.52178E-03_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.22059E-03_JPRB,0.34230E-03_JPRB,0.38410E-03_JPRB,0.41056E-03_JPRB,0.42477E-03_JPRB, &
 & 0.42372E-03_JPRB,0.40485E-03_JPRB,0.35866E-03_JPRB,0.50681E-03_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.22400E-03_JPRB,0.34814E-03_JPRB,0.39039E-03_JPRB,0.41748E-03_JPRB,0.43284E-03_JPRB, &
 & 0.43220E-03_JPRB,0.41363E-03_JPRB,0.36885E-03_JPRB,0.49302E-03_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.22873E-03_JPRB,0.35603E-03_JPRB,0.39905E-03_JPRB,0.42659E-03_JPRB,0.44174E-03_JPRB, &
 & 0.44167E-03_JPRB,0.42288E-03_JPRB,0.37972E-03_JPRB,0.48294E-03_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.23347E-03_JPRB,0.36495E-03_JPRB,0.40893E-03_JPRB,0.43763E-03_JPRB,0.45181E-03_JPRB, &
 & 0.45234E-03_JPRB,0.43347E-03_JPRB,0.39120E-03_JPRB,0.47762E-03_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.19122E-03_JPRB,0.29954E-03_JPRB,0.33486E-03_JPRB,0.35474E-03_JPRB,0.36349E-03_JPRB, &
 & 0.36120E-03_JPRB,0.34300E-03_JPRB,0.30153E-03_JPRB,0.10818E-02_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.19375E-03_JPRB,0.30331E-03_JPRB,0.33858E-03_JPRB,0.35959E-03_JPRB,0.36963E-03_JPRB, &
 & 0.36736E-03_JPRB,0.35033E-03_JPRB,0.30927E-03_JPRB,0.10683E-02_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.19685E-03_JPRB,0.30858E-03_JPRB,0.34410E-03_JPRB,0.36599E-03_JPRB,0.37648E-03_JPRB, &
 & 0.37420E-03_JPRB,0.35748E-03_JPRB,0.31737E-03_JPRB,0.10704E-02_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.20091E-03_JPRB,0.31499E-03_JPRB,0.35151E-03_JPRB,0.37400E-03_JPRB,0.38421E-03_JPRB, &
 & 0.38207E-03_JPRB,0.36506E-03_JPRB,0.32617E-03_JPRB,0.10743E-02_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.20539E-03_JPRB,0.32294E-03_JPRB,0.36050E-03_JPRB,0.38325E-03_JPRB,0.39308E-03_JPRB, &
 & 0.39074E-03_JPRB,0.37406E-03_JPRB,0.33544E-03_JPRB,0.10696E-02_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.16667E-03_JPRB,0.26520E-03_JPRB,0.29671E-03_JPRB,0.31441E-03_JPRB,0.32093E-03_JPRB, &
 & 0.31659E-03_JPRB,0.30045E-03_JPRB,0.26340E-03_JPRB,0.11835E-02_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.16885E-03_JPRB,0.26948E-03_JPRB,0.30096E-03_JPRB,0.31914E-03_JPRB,0.32661E-03_JPRB, &
 & 0.32210E-03_JPRB,0.30657E-03_JPRB,0.27004E-03_JPRB,0.11814E-02_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.17223E-03_JPRB,0.27439E-03_JPRB,0.30661E-03_JPRB,0.32470E-03_JPRB,0.33272E-03_JPRB, &
 & 0.32842E-03_JPRB,0.31227E-03_JPRB,0.27654E-03_JPRB,0.11630E-02_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.17618E-03_JPRB,0.28049E-03_JPRB,0.31365E-03_JPRB,0.33181E-03_JPRB,0.33965E-03_JPRB, &
 & 0.33555E-03_JPRB,0.31903E-03_JPRB,0.28400E-03_JPRB,0.11485E-02_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.18103E-03_JPRB,0.28752E-03_JPRB,0.32181E-03_JPRB,0.34031E-03_JPRB,0.34776E-03_JPRB, &
 & 0.34353E-03_JPRB,0.32710E-03_JPRB,0.29221E-03_JPRB,0.11367E-02_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.14364E-03_JPRB,0.23191E-03_JPRB,0.26011E-03_JPRB,0.27602E-03_JPRB,0.28230E-03_JPRB, &
 & 0.27753E-03_JPRB,0.26259E-03_JPRB,0.22940E-03_JPRB,0.11242E-02_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.14586E-03_JPRB,0.23578E-03_JPRB,0.26464E-03_JPRB,0.28074E-03_JPRB,0.28728E-03_JPRB, &
 & 0.28268E-03_JPRB,0.26740E-03_JPRB,0.23511E-03_JPRB,0.11131E-02_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.14908E-03_JPRB,0.24042E-03_JPRB,0.27020E-03_JPRB,0.28659E-03_JPRB,0.29280E-03_JPRB, &
 & 0.28866E-03_JPRB,0.27254E-03_JPRB,0.24089E-03_JPRB,0.10996E-02_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.15297E-03_JPRB,0.24595E-03_JPRB,0.27661E-03_JPRB,0.29313E-03_JPRB,0.29926E-03_JPRB, &
 & 0.29513E-03_JPRB,0.27870E-03_JPRB,0.24706E-03_JPRB,0.10965E-02_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.15735E-03_JPRB,0.25242E-03_JPRB,0.28422E-03_JPRB,0.30069E-03_JPRB,0.30695E-03_JPRB, &
 & 0.30241E-03_JPRB,0.28613E-03_JPRB,0.25425E-03_JPRB,0.10839E-02_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.12345E-03_JPRB,0.20108E-03_JPRB,0.22674E-03_JPRB,0.24086E-03_JPRB,0.24638E-03_JPRB, &
 & 0.24238E-03_JPRB,0.22876E-03_JPRB,0.19931E-03_JPRB,0.96895E-03_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.12581E-03_JPRB,0.20480E-03_JPRB,0.23117E-03_JPRB,0.24535E-03_JPRB,0.25104E-03_JPRB, &
 & 0.24702E-03_JPRB,0.23303E-03_JPRB,0.20421E-03_JPRB,0.96294E-03_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.12856E-03_JPRB,0.20921E-03_JPRB,0.23606E-03_JPRB,0.25076E-03_JPRB,0.25631E-03_JPRB, &
 & 0.25243E-03_JPRB,0.23816E-03_JPRB,0.20920E-03_JPRB,0.95736E-03_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.13210E-03_JPRB,0.21428E-03_JPRB,0.24223E-03_JPRB,0.25691E-03_JPRB,0.26218E-03_JPRB, &
 & 0.25847E-03_JPRB,0.24400E-03_JPRB,0.21468E-03_JPRB,0.95389E-03_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.13599E-03_JPRB,0.22037E-03_JPRB,0.24914E-03_JPRB,0.26391E-03_JPRB,0.26911E-03_JPRB, &
 & 0.26543E-03_JPRB,0.25095E-03_JPRB,0.22101E-03_JPRB,0.94116E-03_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.10602E-02_JPRB,0.17123E-02_JPRB,0.20157E-02_JPRB,0.22277E-02_JPRB,0.23726E-02_JPRB, &
 & 0.24628E-02_JPRB,0.25069E-02_JPRB,0.24686E-02_JPRB,0.20168E-02_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.10672E-02_JPRB,0.17270E-02_JPRB,0.20414E-02_JPRB,0.22652E-02_JPRB,0.24211E-02_JPRB, &
 & 0.25212E-02_JPRB,0.25704E-02_JPRB,0.25272E-02_JPRB,0.20646E-02_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.10788E-02_JPRB,0.17509E-02_JPRB,0.20769E-02_JPRB,0.23112E-02_JPRB,0.24814E-02_JPRB, &
 & 0.25914E-02_JPRB,0.26418E-02_JPRB,0.25942E-02_JPRB,0.21193E-02_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.10874E-02_JPRB,0.17764E-02_JPRB,0.21176E-02_JPRB,0.23585E-02_JPRB,0.25381E-02_JPRB, &
 & 0.26622E-02_JPRB,0.27175E-02_JPRB,0.26689E-02_JPRB,0.21851E-02_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.11018E-02_JPRB,0.18090E-02_JPRB,0.21640E-02_JPRB,0.24172E-02_JPRB,0.26051E-02_JPRB, &
 & 0.27415E-02_JPRB,0.28075E-02_JPRB,0.27566E-02_JPRB,0.22604E-02_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.95075E-03_JPRB,0.15355E-02_JPRB,0.17976E-02_JPRB,0.19766E-02_JPRB,0.21006E-02_JPRB, &
 & 0.21710E-02_JPRB,0.21998E-02_JPRB,0.21663E-02_JPRB,0.17568E-02_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.96010E-03_JPRB,0.15501E-02_JPRB,0.18242E-02_JPRB,0.20112E-02_JPRB,0.21419E-02_JPRB, &
 & 0.22180E-02_JPRB,0.22475E-02_JPRB,0.22135E-02_JPRB,0.17960E-02_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.97337E-03_JPRB,0.15726E-02_JPRB,0.18580E-02_JPRB,0.20531E-02_JPRB,0.21905E-02_JPRB, &
 & 0.22742E-02_JPRB,0.23072E-02_JPRB,0.22697E-02_JPRB,0.18409E-02_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.98600E-03_JPRB,0.15975E-02_JPRB,0.18942E-02_JPRB,0.20984E-02_JPRB,0.22403E-02_JPRB, &
 & 0.23334E-02_JPRB,0.23735E-02_JPRB,0.23328E-02_JPRB,0.18922E-02_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.99685E-03_JPRB,0.16266E-02_JPRB,0.19353E-02_JPRB,0.21493E-02_JPRB,0.22931E-02_JPRB, &
 & 0.23955E-02_JPRB,0.24466E-02_JPRB,0.24068E-02_JPRB,0.19548E-02_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.85253E-03_JPRB,0.13731E-02_JPRB,0.15966E-02_JPRB,0.17555E-02_JPRB,0.18660E-02_JPRB, &
 & 0.19267E-02_JPRB,0.19415E-02_JPRB,0.18992E-02_JPRB,0.15125E-02_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.86131E-03_JPRB,0.13853E-02_JPRB,0.16172E-02_JPRB,0.17827E-02_JPRB,0.18992E-02_JPRB, &
 & 0.19616E-02_JPRB,0.19781E-02_JPRB,0.19388E-02_JPRB,0.15472E-02_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.87215E-03_JPRB,0.13990E-02_JPRB,0.16433E-02_JPRB,0.18151E-02_JPRB,0.19357E-02_JPRB, &
 & 0.20044E-02_JPRB,0.20244E-02_JPRB,0.19864E-02_JPRB,0.15842E-02_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.88704E-03_JPRB,0.14261E-02_JPRB,0.16795E-02_JPRB,0.18576E-02_JPRB,0.19802E-02_JPRB, &
 & 0.20536E-02_JPRB,0.20804E-02_JPRB,0.20410E-02_JPRB,0.16256E-02_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.89758E-03_JPRB,0.14527E-02_JPRB,0.17171E-02_JPRB,0.19025E-02_JPRB,0.20236E-02_JPRB, &
 & 0.21045E-02_JPRB,0.21413E-02_JPRB,0.21023E-02_JPRB,0.16764E-02_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.76168E-03_JPRB,0.12206E-02_JPRB,0.14175E-02_JPRB,0.15588E-02_JPRB,0.16575E-02_JPRB, &
 & 0.17098E-02_JPRB,0.17134E-02_JPRB,0.16603E-02_JPRB,0.12974E-02_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.76958E-03_JPRB,0.12314E-02_JPRB,0.14342E-02_JPRB,0.15807E-02_JPRB,0.16847E-02_JPRB, &
 & 0.17400E-02_JPRB,0.17442E-02_JPRB,0.16938E-02_JPRB,0.13260E-02_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.78002E-03_JPRB,0.12481E-02_JPRB,0.14573E-02_JPRB,0.16092E-02_JPRB,0.17173E-02_JPRB, &
 & 0.17771E-02_JPRB,0.17830E-02_JPRB,0.17337E-02_JPRB,0.13577E-02_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.79261E-03_JPRB,0.12694E-02_JPRB,0.14861E-02_JPRB,0.16420E-02_JPRB,0.17536E-02_JPRB, &
 & 0.18179E-02_JPRB,0.18286E-02_JPRB,0.17776E-02_JPRB,0.13930E-02_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.80905E-03_JPRB,0.12930E-02_JPRB,0.15216E-02_JPRB,0.16835E-02_JPRB,0.17969E-02_JPRB, &
 & 0.18651E-02_JPRB,0.18829E-02_JPRB,0.18324E-02_JPRB,0.14370E-02_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.67567E-03_JPRB,0.10847E-02_JPRB,0.12673E-02_JPRB,0.13865E-02_JPRB,0.14678E-02_JPRB, &
 & 0.15102E-02_JPRB,0.15099E-02_JPRB,0.14466E-02_JPRB,0.11079E-02_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.68234E-03_JPRB,0.10948E-02_JPRB,0.12810E-02_JPRB,0.14048E-02_JPRB,0.14909E-02_JPRB, &
 & 0.15364E-02_JPRB,0.15351E-02_JPRB,0.14749E-02_JPRB,0.11322E-02_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.69172E-03_JPRB,0.11094E-02_JPRB,0.12954E-02_JPRB,0.14275E-02_JPRB,0.15177E-02_JPRB, &
 & 0.15693E-02_JPRB,0.15680E-02_JPRB,0.15069E-02_JPRB,0.11581E-02_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.70397E-03_JPRB,0.11284E-02_JPRB,0.13174E-02_JPRB,0.14563E-02_JPRB,0.15501E-02_JPRB, &
 & 0.16053E-02_JPRB,0.16071E-02_JPRB,0.15445E-02_JPRB,0.11891E-02_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.72110E-03_JPRB,0.11540E-02_JPRB,0.13487E-02_JPRB,0.14917E-02_JPRB,0.15891E-02_JPRB, &
 & 0.16474E-02_JPRB,0.16536E-02_JPRB,0.15913E-02_JPRB,0.12262E-02_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.59508E-03_JPRB,0.96565E-03_JPRB,0.11271E-02_JPRB,0.12321E-02_JPRB,0.12935E-02_JPRB, &
 & 0.13263E-02_JPRB,0.13235E-02_JPRB,0.12583E-02_JPRB,0.94318E-03_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.60163E-03_JPRB,0.97555E-03_JPRB,0.11390E-02_JPRB,0.12428E-02_JPRB,0.13136E-02_JPRB, &
 & 0.13483E-02_JPRB,0.13443E-02_JPRB,0.12812E-02_JPRB,0.96040E-03_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.61035E-03_JPRB,0.98842E-03_JPRB,0.11551E-02_JPRB,0.12623E-02_JPRB,0.13370E-02_JPRB, &
 & 0.13759E-02_JPRB,0.13716E-02_JPRB,0.13073E-02_JPRB,0.98049E-03_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.62216E-03_JPRB,0.10038E-02_JPRB,0.11750E-02_JPRB,0.12870E-02_JPRB,0.13646E-02_JPRB, &
 & 0.14087E-02_JPRB,0.14042E-02_JPRB,0.13389E-02_JPRB,0.10049E-02_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.63568E-03_JPRB,0.10246E-02_JPRB,0.11986E-02_JPRB,0.13152E-02_JPRB,0.13969E-02_JPRB, &
 & 0.14439E-02_JPRB,0.14425E-02_JPRB,0.13760E-02_JPRB,0.10351E-02_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.52222E-03_JPRB,0.85609E-03_JPRB,0.99991E-03_JPRB,0.10870E-02_JPRB,0.11353E-02_JPRB, &
 & 0.11602E-02_JPRB,0.11537E-02_JPRB,0.10909E-02_JPRB,0.79969E-03_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.52839E-03_JPRB,0.86572E-03_JPRB,0.10120E-02_JPRB,0.11011E-02_JPRB,0.11521E-02_JPRB, &
 & 0.11786E-02_JPRB,0.11705E-02_JPRB,0.11093E-02_JPRB,0.81421E-03_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.53695E-03_JPRB,0.87703E-03_JPRB,0.10261E-02_JPRB,0.11177E-02_JPRB,0.11714E-02_JPRB, &
 & 0.12016E-02_JPRB,0.11930E-02_JPRB,0.11309E-02_JPRB,0.83157E-03_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.54734E-03_JPRB,0.89105E-03_JPRB,0.10435E-02_JPRB,0.11340E-02_JPRB,0.11954E-02_JPRB, &
 & 0.12276E-02_JPRB,0.12204E-02_JPRB,0.11559E-02_JPRB,0.85189E-03_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.56071E-03_JPRB,0.90902E-03_JPRB,0.10648E-02_JPRB,0.11575E-02_JPRB,0.12234E-02_JPRB, &
 & 0.12571E-02_JPRB,0.12523E-02_JPRB,0.11865E-02_JPRB,0.87630E-03_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.45809E-03_JPRB,0.75296E-03_JPRB,0.88022E-03_JPRB,0.95530E-03_JPRB,0.99775E-03_JPRB, &
 & 0.10107E-02_JPRB,0.99991E-03_JPRB,0.94255E-03_JPRB,0.69349E-03_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.46457E-03_JPRB,0.76241E-03_JPRB,0.89241E-03_JPRB,0.96833E-03_JPRB,0.10107E-02_JPRB, &
 & 0.10258E-02_JPRB,0.10136E-02_JPRB,0.95735E-03_JPRB,0.70413E-03_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.47249E-03_JPRB,0.77258E-03_JPRB,0.90578E-03_JPRB,0.98260E-03_JPRB,0.10233E-02_JPRB, &
 & 0.10448E-02_JPRB,0.10324E-02_JPRB,0.97481E-03_JPRB,0.71522E-03_JPRB /)  
KA(:, 4, 8, 6) = (/ &
 & 0.48263E-03_JPRB,0.78537E-03_JPRB,0.92183E-03_JPRB,0.10012E-02_JPRB,0.10427E-02_JPRB, &
 & 0.10663E-02_JPRB,0.10558E-02_JPRB,0.99531E-03_JPRB,0.72922E-03_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.49501E-03_JPRB,0.80218E-03_JPRB,0.94059E-03_JPRB,0.10219E-02_JPRB,0.10669E-02_JPRB, &
 & 0.10907E-02_JPRB,0.10824E-02_JPRB,0.10204E-02_JPRB,0.74659E-03_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.40630E-03_JPRB,0.65697E-03_JPRB,0.76693E-03_JPRB,0.83253E-03_JPRB,0.86881E-03_JPRB, &
 & 0.87661E-03_JPRB,0.86393E-03_JPRB,0.81158E-03_JPRB,0.85763E-03_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.41166E-03_JPRB,0.66657E-03_JPRB,0.77941E-03_JPRB,0.84564E-03_JPRB,0.88174E-03_JPRB, &
 & 0.88952E-03_JPRB,0.87488E-03_JPRB,0.82351E-03_JPRB,0.84633E-03_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.41847E-03_JPRB,0.67680E-03_JPRB,0.79185E-03_JPRB,0.85875E-03_JPRB,0.89476E-03_JPRB, &
 & 0.90456E-03_JPRB,0.89101E-03_JPRB,0.83833E-03_JPRB,0.84017E-03_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.42661E-03_JPRB,0.68815E-03_JPRB,0.80637E-03_JPRB,0.87435E-03_JPRB,0.91036E-03_JPRB, &
 & 0.92205E-03_JPRB,0.90961E-03_JPRB,0.85502E-03_JPRB,0.83895E-03_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.43776E-03_JPRB,0.70278E-03_JPRB,0.82329E-03_JPRB,0.89247E-03_JPRB,0.92828E-03_JPRB, &
 & 0.94238E-03_JPRB,0.93168E-03_JPRB,0.87536E-03_JPRB,0.84088E-03_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.36854E-03_JPRB,0.57908E-03_JPRB,0.66869E-03_JPRB,0.72258E-03_JPRB,0.75231E-03_JPRB, &
 & 0.75942E-03_JPRB,0.74383E-03_JPRB,0.69709E-03_JPRB,0.20395E-02_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.37298E-03_JPRB,0.58711E-03_JPRB,0.68015E-03_JPRB,0.73349E-03_JPRB,0.76293E-03_JPRB, &
 & 0.77052E-03_JPRB,0.75338E-03_JPRB,0.70798E-03_JPRB,0.19202E-02_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.37876E-03_JPRB,0.59595E-03_JPRB,0.69100E-03_JPRB,0.74575E-03_JPRB,0.77497E-03_JPRB, &
 & 0.78295E-03_JPRB,0.76740E-03_JPRB,0.72017E-03_JPRB,0.18161E-02_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.38615E-03_JPRB,0.60708E-03_JPRB,0.70373E-03_JPRB,0.75914E-03_JPRB,0.78952E-03_JPRB, &
 & 0.79663E-03_JPRB,0.78331E-03_JPRB,0.73385E-03_JPRB,0.17247E-02_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.39564E-03_JPRB,0.62052E-03_JPRB,0.71856E-03_JPRB,0.77512E-03_JPRB,0.80699E-03_JPRB, &
 & 0.81444E-03_JPRB,0.80141E-03_JPRB,0.75081E-03_JPRB,0.16568E-02_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.33320E-03_JPRB,0.52088E-03_JPRB,0.59646E-03_JPRB,0.63812E-03_JPRB,0.65660E-03_JPRB, &
 & 0.65900E-03_JPRB,0.64138E-03_JPRB,0.60020E-03_JPRB,0.25696E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART5',0,ZHOOK_HANDLE)


KA(:, 2,11, 6) = (/ &
 & 0.33882E-03_JPRB,0.52942E-03_JPRB,0.60584E-03_JPRB,0.64728E-03_JPRB,0.66639E-03_JPRB, &
 & 0.66995E-03_JPRB,0.65115E-03_JPRB,0.61030E-03_JPRB,0.24243E-02_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.34516E-03_JPRB,0.53993E-03_JPRB,0.61579E-03_JPRB,0.65783E-03_JPRB,0.67758E-03_JPRB, &
 & 0.68193E-03_JPRB,0.66413E-03_JPRB,0.62169E-03_JPRB,0.23408E-02_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.35301E-03_JPRB,0.55124E-03_JPRB,0.62753E-03_JPRB,0.66999E-03_JPRB,0.69148E-03_JPRB, &
 & 0.69508E-03_JPRB,0.67858E-03_JPRB,0.63426E-03_JPRB,0.22732E-02_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.36214E-03_JPRB,0.56453E-03_JPRB,0.64151E-03_JPRB,0.68481E-03_JPRB,0.70755E-03_JPRB, &
 & 0.71086E-03_JPRB,0.69483E-03_JPRB,0.64938E-03_JPRB,0.21869E-02_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.29653E-03_JPRB,0.46559E-03_JPRB,0.53073E-03_JPRB,0.56520E-03_JPRB,0.57894E-03_JPRB, &
 & 0.57686E-03_JPRB,0.55698E-03_JPRB,0.51584E-03_JPRB,0.26304E-02_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.30188E-03_JPRB,0.47447E-03_JPRB,0.54017E-03_JPRB,0.57406E-03_JPRB,0.58804E-03_JPRB, &
 & 0.58653E-03_JPRB,0.56630E-03_JPRB,0.52472E-03_JPRB,0.24930E-02_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.30861E-03_JPRB,0.48517E-03_JPRB,0.55102E-03_JPRB,0.58380E-03_JPRB,0.59890E-03_JPRB, &
 & 0.59725E-03_JPRB,0.57721E-03_JPRB,0.53486E-03_JPRB,0.23834E-02_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.31637E-03_JPRB,0.49701E-03_JPRB,0.56299E-03_JPRB,0.59618E-03_JPRB,0.61191E-03_JPRB, &
 & 0.60936E-03_JPRB,0.58930E-03_JPRB,0.54649E-03_JPRB,0.22824E-02_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.32604E-03_JPRB,0.51148E-03_JPRB,0.57604E-03_JPRB,0.61103E-03_JPRB,0.62611E-03_JPRB, &
 & 0.62412E-03_JPRB,0.60375E-03_JPRB,0.56026E-03_JPRB,0.22084E-02_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.26154E-03_JPRB,0.41366E-03_JPRB,0.47019E-03_JPRB,0.50056E-03_JPRB,0.51140E-03_JPRB, &
 & 0.50695E-03_JPRB,0.48611E-03_JPRB,0.44348E-03_JPRB,0.22773E-02_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.26669E-03_JPRB,0.42267E-03_JPRB,0.47957E-03_JPRB,0.51009E-03_JPRB,0.52067E-03_JPRB, &
 & 0.51611E-03_JPRB,0.49506E-03_JPRB,0.45138E-03_JPRB,0.21516E-02_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.27302E-03_JPRB,0.43290E-03_JPRB,0.49082E-03_JPRB,0.52081E-03_JPRB,0.53105E-03_JPRB, &
 & 0.52578E-03_JPRB,0.50476E-03_JPRB,0.46026E-03_JPRB,0.20522E-02_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.28114E-03_JPRB,0.44552E-03_JPRB,0.50271E-03_JPRB,0.53316E-03_JPRB,0.54314E-03_JPRB, &
 & 0.53754E-03_JPRB,0.51555E-03_JPRB,0.47096E-03_JPRB,0.19694E-02_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.29046E-03_JPRB,0.45904E-03_JPRB,0.51716E-03_JPRB,0.54751E-03_JPRB,0.55727E-03_JPRB, &
 & 0.55147E-03_JPRB,0.52828E-03_JPRB,0.48333E-03_JPRB,0.19102E-02_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.21025E-02_JPRB,0.35934E-02_JPRB,0.44505E-02_JPRB,0.51294E-02_JPRB,0.56565E-02_JPRB, &
 & 0.60638E-02_JPRB,0.63051E-02_JPRB,0.63060E-02_JPRB,0.53132E-02_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.21147E-02_JPRB,0.36363E-02_JPRB,0.45228E-02_JPRB,0.52203E-02_JPRB,0.57590E-02_JPRB, &
 & 0.61627E-02_JPRB,0.64080E-02_JPRB,0.64123E-02_JPRB,0.54186E-02_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.21423E-02_JPRB,0.36907E-02_JPRB,0.46129E-02_JPRB,0.53384E-02_JPRB,0.58809E-02_JPRB, &
 & 0.62832E-02_JPRB,0.65320E-02_JPRB,0.65359E-02_JPRB,0.55396E-02_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.21655E-02_JPRB,0.37303E-02_JPRB,0.46928E-02_JPRB,0.54454E-02_JPRB,0.60067E-02_JPRB, &
 & 0.64159E-02_JPRB,0.66758E-02_JPRB,0.66776E-02_JPRB,0.56738E-02_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.22041E-02_JPRB,0.37865E-02_JPRB,0.47900E-02_JPRB,0.55720E-02_JPRB,0.61575E-02_JPRB, &
 & 0.65795E-02_JPRB,0.68426E-02_JPRB,0.68332E-02_JPRB,0.58218E-02_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.19184E-02_JPRB,0.32868E-02_JPRB,0.40037E-02_JPRB,0.45520E-02_JPRB,0.49723E-02_JPRB, &
 & 0.52862E-02_JPRB,0.54779E-02_JPRB,0.54778E-02_JPRB,0.44696E-02_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.19302E-02_JPRB,0.33258E-02_JPRB,0.40693E-02_JPRB,0.46336E-02_JPRB,0.50634E-02_JPRB, &
 & 0.53829E-02_JPRB,0.55797E-02_JPRB,0.55784E-02_JPRB,0.45568E-02_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.19586E-02_JPRB,0.33762E-02_JPRB,0.41518E-02_JPRB,0.47383E-02_JPRB,0.51749E-02_JPRB, &
 & 0.54993E-02_JPRB,0.56986E-02_JPRB,0.56923E-02_JPRB,0.46572E-02_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.19876E-02_JPRB,0.34214E-02_JPRB,0.42297E-02_JPRB,0.48395E-02_JPRB,0.52957E-02_JPRB, &
 & 0.56305E-02_JPRB,0.58340E-02_JPRB,0.58219E-02_JPRB,0.47733E-02_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.20222E-02_JPRB,0.34660E-02_JPRB,0.43057E-02_JPRB,0.49428E-02_JPRB,0.54286E-02_JPRB, &
 & 0.57769E-02_JPRB,0.59846E-02_JPRB,0.59651E-02_JPRB,0.49022E-02_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.17389E-02_JPRB,0.29833E-02_JPRB,0.35894E-02_JPRB,0.40314E-02_JPRB,0.43535E-02_JPRB, &
 & 0.45848E-02_JPRB,0.47251E-02_JPRB,0.47273E-02_JPRB,0.37675E-02_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.17511E-02_JPRB,0.30210E-02_JPRB,0.36487E-02_JPRB,0.40996E-02_JPRB,0.44314E-02_JPRB, &
 & 0.46730E-02_JPRB,0.48141E-02_JPRB,0.48126E-02_JPRB,0.38333E-02_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.17713E-02_JPRB,0.30646E-02_JPRB,0.37133E-02_JPRB,0.41800E-02_JPRB,0.45216E-02_JPRB, &
 & 0.47732E-02_JPRB,0.49178E-02_JPRB,0.49079E-02_JPRB,0.39121E-02_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.18058E-02_JPRB,0.31149E-02_JPRB,0.37889E-02_JPRB,0.42777E-02_JPRB,0.46349E-02_JPRB, &
 & 0.48925E-02_JPRB,0.50383E-02_JPRB,0.50219E-02_JPRB,0.40071E-02_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.18379E-02_JPRB,0.31573E-02_JPRB,0.38545E-02_JPRB,0.43660E-02_JPRB,0.47479E-02_JPRB, &
 & 0.50186E-02_JPRB,0.51717E-02_JPRB,0.51483E-02_JPRB,0.41141E-02_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.15760E-02_JPRB,0.26881E-02_JPRB,0.32116E-02_JPRB,0.35706E-02_JPRB,0.38258E-02_JPRB, &
 & 0.39911E-02_JPRB,0.40833E-02_JPRB,0.40813E-02_JPRB,0.32298E-02_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.15813E-02_JPRB,0.27249E-02_JPRB,0.32627E-02_JPRB,0.36295E-02_JPRB,0.38889E-02_JPRB, &
 & 0.40640E-02_JPRB,0.41571E-02_JPRB,0.41534E-02_JPRB,0.32787E-02_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.16001E-02_JPRB,0.27603E-02_JPRB,0.33193E-02_JPRB,0.36971E-02_JPRB,0.39631E-02_JPRB, &
 & 0.41442E-02_JPRB,0.42435E-02_JPRB,0.42324E-02_JPRB,0.33394E-02_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.16258E-02_JPRB,0.28020E-02_JPRB,0.33780E-02_JPRB,0.37750E-02_JPRB,0.40494E-02_JPRB, &
 & 0.42369E-02_JPRB,0.43436E-02_JPRB,0.43281E-02_JPRB,0.34138E-02_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.16664E-02_JPRB,0.28640E-02_JPRB,0.34503E-02_JPRB,0.38637E-02_JPRB,0.41572E-02_JPRB, &
 & 0.43540E-02_JPRB,0.44611E-02_JPRB,0.44376E-02_JPRB,0.34982E-02_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.14233E-02_JPRB,0.24061E-02_JPRB,0.28484E-02_JPRB,0.31675E-02_JPRB,0.33803E-02_JPRB, &
 & 0.35027E-02_JPRB,0.35528E-02_JPRB,0.35417E-02_JPRB,0.27814E-02_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.14350E-02_JPRB,0.24395E-02_JPRB,0.28937E-02_JPRB,0.32168E-02_JPRB,0.34318E-02_JPRB, &
 & 0.35619E-02_JPRB,0.36148E-02_JPRB,0.35990E-02_JPRB,0.28208E-02_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.14521E-02_JPRB,0.24725E-02_JPRB,0.29512E-02_JPRB,0.32733E-02_JPRB,0.34917E-02_JPRB, &
 & 0.36258E-02_JPRB,0.36856E-02_JPRB,0.36654E-02_JPRB,0.28719E-02_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.14701E-02_JPRB,0.25117E-02_JPRB,0.30081E-02_JPRB,0.33364E-02_JPRB,0.35619E-02_JPRB, &
 & 0.37016E-02_JPRB,0.37673E-02_JPRB,0.37455E-02_JPRB,0.29344E-02_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.15037E-02_JPRB,0.25667E-02_JPRB,0.30753E-02_JPRB,0.34136E-02_JPRB,0.36518E-02_JPRB, &
 & 0.37975E-02_JPRB,0.38648E-02_JPRB,0.38367E-02_JPRB,0.30050E-02_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.12833E-02_JPRB,0.21397E-02_JPRB,0.25249E-02_JPRB,0.27989E-02_JPRB,0.29941E-02_JPRB, &
 & 0.30943E-02_JPRB,0.31134E-02_JPRB,0.30718E-02_JPRB,0.23837E-02_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.12955E-02_JPRB,0.21689E-02_JPRB,0.25640E-02_JPRB,0.28465E-02_JPRB,0.30386E-02_JPRB, &
 & 0.31442E-02_JPRB,0.31666E-02_JPRB,0.31216E-02_JPRB,0.24190E-02_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.13128E-02_JPRB,0.22001E-02_JPRB,0.26092E-02_JPRB,0.28949E-02_JPRB,0.30875E-02_JPRB, &
 & 0.31967E-02_JPRB,0.32254E-02_JPRB,0.31772E-02_JPRB,0.24633E-02_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.13321E-02_JPRB,0.22373E-02_JPRB,0.26583E-02_JPRB,0.29483E-02_JPRB,0.31454E-02_JPRB, &
 & 0.32584E-02_JPRB,0.32916E-02_JPRB,0.32451E-02_JPRB,0.25158E-02_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.13570E-02_JPRB,0.22801E-02_JPRB,0.27142E-02_JPRB,0.30110E-02_JPRB,0.32147E-02_JPRB, &
 & 0.33324E-02_JPRB,0.33699E-02_JPRB,0.33240E-02_JPRB,0.25751E-02_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.11500E-02_JPRB,0.18956E-02_JPRB,0.22352E-02_JPRB,0.24771E-02_JPRB,0.26462E-02_JPRB, &
 & 0.27285E-02_JPRB,0.27284E-02_JPRB,0.26574E-02_JPRB,0.20286E-02_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.11641E-02_JPRB,0.19221E-02_JPRB,0.22681E-02_JPRB,0.25137E-02_JPRB,0.26876E-02_JPRB, &
 & 0.27741E-02_JPRB,0.27762E-02_JPRB,0.27013E-02_JPRB,0.20553E-02_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.11813E-02_JPRB,0.19513E-02_JPRB,0.23065E-02_JPRB,0.25547E-02_JPRB,0.27305E-02_JPRB, &
 & 0.28210E-02_JPRB,0.28261E-02_JPRB,0.27499E-02_JPRB,0.20900E-02_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.12020E-02_JPRB,0.19854E-02_JPRB,0.23499E-02_JPRB,0.26064E-02_JPRB,0.27813E-02_JPRB, &
 & 0.28738E-02_JPRB,0.28824E-02_JPRB,0.28095E-02_JPRB,0.21311E-02_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.12251E-02_JPRB,0.20252E-02_JPRB,0.23984E-02_JPRB,0.26618E-02_JPRB,0.28401E-02_JPRB, &
 & 0.29374E-02_JPRB,0.29496E-02_JPRB,0.28780E-02_JPRB,0.21792E-02_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.10232E-02_JPRB,0.16906E-02_JPRB,0.19769E-02_JPRB,0.21832E-02_JPRB,0.23202E-02_JPRB, &
 & 0.23917E-02_JPRB,0.23852E-02_JPRB,0.22950E-02_JPRB,0.17101E-02_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.10391E-02_JPRB,0.17050E-02_JPRB,0.20071E-02_JPRB,0.22179E-02_JPRB,0.23606E-02_JPRB, &
 & 0.24337E-02_JPRB,0.24284E-02_JPRB,0.23335E-02_JPRB,0.17331E-02_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.10558E-02_JPRB,0.17304E-02_JPRB,0.20412E-02_JPRB,0.22560E-02_JPRB,0.24048E-02_JPRB, &
 & 0.24767E-02_JPRB,0.24718E-02_JPRB,0.23758E-02_JPRB,0.17638E-02_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.10757E-02_JPRB,0.17611E-02_JPRB,0.20788E-02_JPRB,0.22974E-02_JPRB,0.24509E-02_JPRB, &
 & 0.25242E-02_JPRB,0.25220E-02_JPRB,0.24275E-02_JPRB,0.17981E-02_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.10980E-02_JPRB,0.17974E-02_JPRB,0.21207E-02_JPRB,0.23464E-02_JPRB,0.25025E-02_JPRB, &
 & 0.25827E-02_JPRB,0.25792E-02_JPRB,0.24843E-02_JPRB,0.18371E-02_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.89817E-03_JPRB,0.14995E-02_JPRB,0.17424E-02_JPRB,0.19141E-02_JPRB,0.20277E-02_JPRB, &
 & 0.20847E-02_JPRB,0.20717E-02_JPRB,0.19779E-02_JPRB,0.16529E-02_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.91497E-03_JPRB,0.15202E-02_JPRB,0.17713E-02_JPRB,0.19473E-02_JPRB,0.20642E-02_JPRB, &
 & 0.21241E-02_JPRB,0.21112E-02_JPRB,0.20125E-02_JPRB,0.16590E-02_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.93269E-03_JPRB,0.15411E-02_JPRB,0.18029E-02_JPRB,0.19839E-02_JPRB,0.21017E-02_JPRB, &
 & 0.21633E-02_JPRB,0.21507E-02_JPRB,0.20494E-02_JPRB,0.16738E-02_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.95304E-03_JPRB,0.15646E-02_JPRB,0.18368E-02_JPRB,0.20225E-02_JPRB,0.21451E-02_JPRB, &
 & 0.22062E-02_JPRB,0.21951E-02_JPRB,0.20930E-02_JPRB,0.16939E-02_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.97498E-03_JPRB,0.15941E-02_JPRB,0.18742E-02_JPRB,0.20657E-02_JPRB,0.21958E-02_JPRB, &
 & 0.22577E-02_JPRB,0.22448E-02_JPRB,0.21409E-02_JPRB,0.17176E-02_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.79262E-03_JPRB,0.13163E-02_JPRB,0.15328E-02_JPRB,0.16707E-02_JPRB,0.17648E-02_JPRB, &
 & 0.18068E-02_JPRB,0.17935E-02_JPRB,0.17058E-02_JPRB,0.29700E-02_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.80762E-03_JPRB,0.13411E-02_JPRB,0.15596E-02_JPRB,0.17027E-02_JPRB,0.18000E-02_JPRB, &
 & 0.18435E-02_JPRB,0.18291E-02_JPRB,0.17355E-02_JPRB,0.28651E-02_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.82251E-03_JPRB,0.13646E-02_JPRB,0.15856E-02_JPRB,0.17370E-02_JPRB,0.18349E-02_JPRB, &
 & 0.18799E-02_JPRB,0.18643E-02_JPRB,0.17669E-02_JPRB,0.27637E-02_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.84077E-03_JPRB,0.13892E-02_JPRB,0.16170E-02_JPRB,0.17747E-02_JPRB,0.18736E-02_JPRB, &
 & 0.19201E-02_JPRB,0.19036E-02_JPRB,0.18042E-02_JPRB,0.26870E-02_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.86106E-03_JPRB,0.14180E-02_JPRB,0.16516E-02_JPRB,0.18147E-02_JPRB,0.19171E-02_JPRB, &
 & 0.19660E-02_JPRB,0.19468E-02_JPRB,0.18451E-02_JPRB,0.26342E-02_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.72744E-03_JPRB,0.11669E-02_JPRB,0.13481E-02_JPRB,0.14590E-02_JPRB,0.15393E-02_JPRB, &
 & 0.15747E-02_JPRB,0.15610E-02_JPRB,0.14772E-02_JPRB,0.38429E-02_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.73930E-03_JPRB,0.11904E-02_JPRB,0.13759E-02_JPRB,0.14894E-02_JPRB,0.15715E-02_JPRB, &
 & 0.16066E-02_JPRB,0.15925E-02_JPRB,0.15038E-02_JPRB,0.36308E-02_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.75350E-03_JPRB,0.12120E-02_JPRB,0.14044E-02_JPRB,0.15240E-02_JPRB,0.16053E-02_JPRB, &
 & 0.16390E-02_JPRB,0.16251E-02_JPRB,0.15339E-02_JPRB,0.34122E-02_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.76930E-03_JPRB,0.12355E-02_JPRB,0.14324E-02_JPRB,0.15603E-02_JPRB,0.16424E-02_JPRB, &
 & 0.16774E-02_JPRB,0.16611E-02_JPRB,0.15677E-02_JPRB,0.32391E-02_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.78824E-03_JPRB,0.12645E-02_JPRB,0.14660E-02_JPRB,0.15998E-02_JPRB,0.16846E-02_JPRB, &
 & 0.17204E-02_JPRB,0.17007E-02_JPRB,0.16046E-02_JPRB,0.31291E-02_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.66909E-03_JPRB,0.10517E-02_JPRB,0.11921E-02_JPRB,0.12822E-02_JPRB,0.13379E-02_JPRB, &
 & 0.13630E-02_JPRB,0.13492E-02_JPRB,0.12752E-02_JPRB,0.39255E-02_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.68372E-03_JPRB,0.10717E-02_JPRB,0.12175E-02_JPRB,0.13089E-02_JPRB,0.13666E-02_JPRB, &
 & 0.13913E-02_JPRB,0.13783E-02_JPRB,0.12999E-02_JPRB,0.37011E-02_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.69881E-03_JPRB,0.10912E-02_JPRB,0.12439E-02_JPRB,0.13402E-02_JPRB,0.13970E-02_JPRB, &
 & 0.14222E-02_JPRB,0.14099E-02_JPRB,0.13279E-02_JPRB,0.35002E-02_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.71487E-03_JPRB,0.11132E-02_JPRB,0.12732E-02_JPRB,0.13738E-02_JPRB,0.14317E-02_JPRB, &
 & 0.14583E-02_JPRB,0.14439E-02_JPRB,0.13590E-02_JPRB,0.33360E-02_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.73461E-03_JPRB,0.11382E-02_JPRB,0.13053E-02_JPRB,0.14102E-02_JPRB,0.14713E-02_JPRB, &
 & 0.14974E-02_JPRB,0.14808E-02_JPRB,0.13924E-02_JPRB,0.31844E-02_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.61282E-03_JPRB,0.95575E-03_JPRB,0.10730E-02_JPRB,0.11388E-02_JPRB,0.11718E-02_JPRB, &
 & 0.11795E-02_JPRB,0.11618E-02_JPRB,0.10974E-02_JPRB,0.34089E-02_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.62765E-03_JPRB,0.97500E-03_JPRB,0.10966E-02_JPRB,0.11619E-02_JPRB,0.11959E-02_JPRB, &
 & 0.12054E-02_JPRB,0.11876E-02_JPRB,0.11206E-02_JPRB,0.32141E-02_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.64409E-03_JPRB,0.99523E-03_JPRB,0.11197E-02_JPRB,0.11873E-02_JPRB,0.12235E-02_JPRB, &
 & 0.12347E-02_JPRB,0.12163E-02_JPRB,0.11468E-02_JPRB,0.30396E-02_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.66230E-03_JPRB,0.10180E-02_JPRB,0.11464E-02_JPRB,0.12161E-02_JPRB,0.12557E-02_JPRB, &
 & 0.12667E-02_JPRB,0.12475E-02_JPRB,0.11749E-02_JPRB,0.28911E-02_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.68383E-03_JPRB,0.10452E-02_JPRB,0.11767E-02_JPRB,0.12484E-02_JPRB,0.12902E-02_JPRB, &
 & 0.13021E-02_JPRB,0.12822E-02_JPRB,0.12049E-02_JPRB,0.27576E-02_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.59073E-02_JPRB,0.94320E-02_JPRB,0.12084E-01_JPRB,0.14049E-01_JPRB,0.15571E-01_JPRB, &
 & 0.16640E-01_JPRB,0.17123E-01_JPRB,0.16625E-01_JPRB,0.14851E-01_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.60213E-02_JPRB,0.95565E-02_JPRB,0.12218E-01_JPRB,0.14200E-01_JPRB,0.15736E-01_JPRB, &
 & 0.16810E-01_JPRB,0.17290E-01_JPRB,0.16722E-01_JPRB,0.14969E-01_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.61698E-02_JPRB,0.97176E-02_JPRB,0.12383E-01_JPRB,0.14381E-01_JPRB,0.15939E-01_JPRB, &
 & 0.17010E-01_JPRB,0.17476E-01_JPRB,0.16866E-01_JPRB,0.15129E-01_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.62862E-02_JPRB,0.98624E-02_JPRB,0.12544E-01_JPRB,0.14586E-01_JPRB,0.16163E-01_JPRB, &
 & 0.17225E-01_JPRB,0.17690E-01_JPRB,0.17043E-01_JPRB,0.15322E-01_JPRB /)  
KA(:, 5, 1, 8) = (/ &
 & 0.64346E-02_JPRB,0.10033E-01_JPRB,0.12746E-01_JPRB,0.14817E-01_JPRB,0.16408E-01_JPRB, &
 & 0.17481E-01_JPRB,0.17940E-01_JPRB,0.17253E-01_JPRB,0.15543E-01_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.53740E-02_JPRB,0.87218E-02_JPRB,0.11053E-01_JPRB,0.12810E-01_JPRB,0.14176E-01_JPRB, &
 & 0.15120E-01_JPRB,0.15546E-01_JPRB,0.15059E-01_JPRB,0.12919E-01_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.54730E-02_JPRB,0.88522E-02_JPRB,0.11203E-01_JPRB,0.12984E-01_JPRB,0.14363E-01_JPRB, &
 & 0.15303E-01_JPRB,0.15712E-01_JPRB,0.15177E-01_JPRB,0.13038E-01_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.56074E-02_JPRB,0.90112E-02_JPRB,0.11386E-01_JPRB,0.13184E-01_JPRB,0.14577E-01_JPRB, &
 & 0.15506E-01_JPRB,0.15908E-01_JPRB,0.15341E-01_JPRB,0.13193E-01_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.57291E-02_JPRB,0.91663E-02_JPRB,0.11581E-01_JPRB,0.13408E-01_JPRB,0.14805E-01_JPRB, &
 & 0.15738E-01_JPRB,0.16140E-01_JPRB,0.15527E-01_JPRB,0.13373E-01_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.58374E-02_JPRB,0.93237E-02_JPRB,0.11790E-01_JPRB,0.13642E-01_JPRB,0.15063E-01_JPRB, &
 & 0.16008E-01_JPRB,0.16391E-01_JPRB,0.15740E-01_JPRB,0.13573E-01_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.49151E-02_JPRB,0.80083E-02_JPRB,0.10006E-01_JPRB,0.11528E-01_JPRB,0.12727E-01_JPRB, &
 & 0.13551E-01_JPRB,0.13911E-01_JPRB,0.13469E-01_JPRB,0.11070E-01_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.50045E-02_JPRB,0.81384E-02_JPRB,0.10158E-01_JPRB,0.11712E-01_JPRB,0.12918E-01_JPRB, &
 & 0.13727E-01_JPRB,0.14078E-01_JPRB,0.13598E-01_JPRB,0.11182E-01_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.51018E-02_JPRB,0.82774E-02_JPRB,0.10333E-01_JPRB,0.11906E-01_JPRB,0.13128E-01_JPRB, &
 & 0.13932E-01_JPRB,0.14276E-01_JPRB,0.13758E-01_JPRB,0.11318E-01_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.52290E-02_JPRB,0.84457E-02_JPRB,0.10545E-01_JPRB,0.12130E-01_JPRB,0.13362E-01_JPRB, &
 & 0.14179E-01_JPRB,0.14506E-01_JPRB,0.13944E-01_JPRB,0.11475E-01_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.53219E-02_JPRB,0.86004E-02_JPRB,0.10753E-01_JPRB,0.12365E-01_JPRB,0.13624E-01_JPRB, &
 & 0.14443E-01_JPRB,0.14743E-01_JPRB,0.14150E-01_JPRB,0.11664E-01_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.44996E-02_JPRB,0.73324E-02_JPRB,0.89976E-02_JPRB,0.10282E-01_JPRB,0.11291E-01_JPRB, &
 & 0.11989E-01_JPRB,0.12308E-01_JPRB,0.11915E-01_JPRB,0.94610E-02_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.45903E-02_JPRB,0.74608E-02_JPRB,0.91511E-02_JPRB,0.10467E-01_JPRB,0.11476E-01_JPRB, &
 & 0.12168E-01_JPRB,0.12474E-01_JPRB,0.12040E-01_JPRB,0.95583E-02_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.46786E-02_JPRB,0.75960E-02_JPRB,0.93200E-02_JPRB,0.10651E-01_JPRB,0.11685E-01_JPRB, &
 & 0.12375E-01_JPRB,0.12662E-01_JPRB,0.12197E-01_JPRB,0.96836E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART6',0,ZHOOK_HANDLE)


KA(:, 4, 4, 8) = (/ &
 & 0.47771E-02_JPRB,0.77407E-02_JPRB,0.95085E-02_JPRB,0.10860E-01_JPRB,0.11915E-01_JPRB, &
 & 0.12611E-01_JPRB,0.12868E-01_JPRB,0.12374E-01_JPRB,0.98243E-02_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.48920E-02_JPRB,0.79194E-02_JPRB,0.97305E-02_JPRB,0.11107E-01_JPRB,0.12174E-01_JPRB, &
 & 0.12866E-01_JPRB,0.13096E-01_JPRB,0.12573E-01_JPRB,0.99978E-02_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.41203E-02_JPRB,0.67057E-02_JPRB,0.80820E-02_JPRB,0.91247E-02_JPRB,0.99321E-02_JPRB, &
 & 0.10510E-01_JPRB,0.10783E-01_JPRB,0.10430E-01_JPRB,0.81020E-02_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.41993E-02_JPRB,0.68279E-02_JPRB,0.82322E-02_JPRB,0.92959E-02_JPRB,0.10115E-01_JPRB, &
 & 0.10684E-01_JPRB,0.10936E-01_JPRB,0.10557E-01_JPRB,0.81860E-02_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.42833E-02_JPRB,0.69588E-02_JPRB,0.83884E-02_JPRB,0.94726E-02_JPRB,0.10319E-01_JPRB, &
 & 0.10879E-01_JPRB,0.11113E-01_JPRB,0.10704E-01_JPRB,0.82915E-02_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.43800E-02_JPRB,0.70975E-02_JPRB,0.85585E-02_JPRB,0.96769E-02_JPRB,0.10538E-01_JPRB, &
 & 0.11098E-01_JPRB,0.11307E-01_JPRB,0.10873E-01_JPRB,0.84082E-02_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.44913E-02_JPRB,0.72638E-02_JPRB,0.87668E-02_JPRB,0.99106E-02_JPRB,0.10776E-01_JPRB, &
 & 0.11337E-01_JPRB,0.11521E-01_JPRB,0.11061E-01_JPRB,0.85492E-02_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.37432E-02_JPRB,0.61135E-02_JPRB,0.72507E-02_JPRB,0.80822E-02_JPRB,0.86984E-02_JPRB, &
 & 0.91424E-02_JPRB,0.93607E-02_JPRB,0.90800E-02_JPRB,0.69637E-02_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.38232E-02_JPRB,0.62277E-02_JPRB,0.73923E-02_JPRB,0.82383E-02_JPRB,0.88666E-02_JPRB, &
 & 0.93013E-02_JPRB,0.95051E-02_JPRB,0.91939E-02_JPRB,0.70311E-02_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.39028E-02_JPRB,0.63516E-02_JPRB,0.75330E-02_JPRB,0.84072E-02_JPRB,0.90542E-02_JPRB, &
 & 0.94860E-02_JPRB,0.96693E-02_JPRB,0.93306E-02_JPRB,0.71143E-02_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.39917E-02_JPRB,0.64850E-02_JPRB,0.76893E-02_JPRB,0.85935E-02_JPRB,0.92562E-02_JPRB, &
 & 0.96859E-02_JPRB,0.98481E-02_JPRB,0.94821E-02_JPRB,0.72080E-02_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.40851E-02_JPRB,0.66256E-02_JPRB,0.78694E-02_JPRB,0.87911E-02_JPRB,0.94733E-02_JPRB, &
 & 0.99019E-02_JPRB,0.10042E-01_JPRB,0.96464E-02_JPRB,0.73211E-02_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.33812E-02_JPRB,0.55475E-02_JPRB,0.65017E-02_JPRB,0.71556E-02_JPRB,0.76235E-02_JPRB, &
 & 0.79451E-02_JPRB,0.81101E-02_JPRB,0.78877E-02_JPRB,0.60070E-02_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.34581E-02_JPRB,0.56575E-02_JPRB,0.66301E-02_JPRB,0.72977E-02_JPRB,0.77709E-02_JPRB, &
 & 0.80903E-02_JPRB,0.82426E-02_JPRB,0.79917E-02_JPRB,0.60625E-02_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.35355E-02_JPRB,0.57759E-02_JPRB,0.67602E-02_JPRB,0.74532E-02_JPRB,0.79395E-02_JPRB, &
 & 0.82549E-02_JPRB,0.83890E-02_JPRB,0.81121E-02_JPRB,0.61274E-02_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.36191E-02_JPRB,0.58987E-02_JPRB,0.69034E-02_JPRB,0.76219E-02_JPRB,0.81209E-02_JPRB, &
 & 0.84343E-02_JPRB,0.85495E-02_JPRB,0.82395E-02_JPRB,0.62026E-02_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.37084E-02_JPRB,0.60308E-02_JPRB,0.70671E-02_JPRB,0.77977E-02_JPRB,0.83160E-02_JPRB, &
 & 0.86266E-02_JPRB,0.87205E-02_JPRB,0.83802E-02_JPRB,0.62947E-02_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.30376E-02_JPRB,0.49774E-02_JPRB,0.58172E-02_JPRB,0.63470E-02_JPRB,0.67038E-02_JPRB, &
 & 0.69396E-02_JPRB,0.70412E-02_JPRB,0.68509E-02_JPRB,0.51374E-02_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.31099E-02_JPRB,0.50996E-02_JPRB,0.59344E-02_JPRB,0.64736E-02_JPRB,0.68367E-02_JPRB, &
 & 0.70701E-02_JPRB,0.71564E-02_JPRB,0.69425E-02_JPRB,0.51813E-02_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.31853E-02_JPRB,0.52155E-02_JPRB,0.60541E-02_JPRB,0.66147E-02_JPRB,0.69858E-02_JPRB, &
 & 0.72120E-02_JPRB,0.72858E-02_JPRB,0.70465E-02_JPRB,0.52319E-02_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.32663E-02_JPRB,0.53312E-02_JPRB,0.61863E-02_JPRB,0.67654E-02_JPRB,0.71468E-02_JPRB, &
 & 0.73677E-02_JPRB,0.74252E-02_JPRB,0.71560E-02_JPRB,0.52932E-02_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.33510E-02_JPRB,0.54583E-02_JPRB,0.63345E-02_JPRB,0.69235E-02_JPRB,0.73170E-02_JPRB, &
 & 0.75339E-02_JPRB,0.75720E-02_JPRB,0.72770E-02_JPRB,0.53726E-02_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.27168E-02_JPRB,0.44406E-02_JPRB,0.51768E-02_JPRB,0.56339E-02_JPRB,0.59208E-02_JPRB, &
 & 0.60958E-02_JPRB,0.61438E-02_JPRB,0.59554E-02_JPRB,0.42511E-02_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.27853E-02_JPRB,0.45486E-02_JPRB,0.52870E-02_JPRB,0.57491E-02_JPRB,0.60397E-02_JPRB, &
 & 0.62076E-02_JPRB,0.62421E-02_JPRB,0.60358E-02_JPRB,0.42982E-02_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.28572E-02_JPRB,0.46609E-02_JPRB,0.53998E-02_JPRB,0.58755E-02_JPRB,0.61719E-02_JPRB, &
 & 0.63300E-02_JPRB,0.63536E-02_JPRB,0.61272E-02_JPRB,0.43479E-02_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.29351E-02_JPRB,0.47766E-02_JPRB,0.55244E-02_JPRB,0.60103E-02_JPRB,0.63121E-02_JPRB, &
 & 0.64656E-02_JPRB,0.64718E-02_JPRB,0.62231E-02_JPRB,0.44012E-02_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.30174E-02_JPRB,0.49013E-02_JPRB,0.56608E-02_JPRB,0.61542E-02_JPRB,0.64584E-02_JPRB, &
 & 0.66094E-02_JPRB,0.65960E-02_JPRB,0.63252E-02_JPRB,0.44655E-02_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.24055E-02_JPRB,0.39503E-02_JPRB,0.45833E-02_JPRB,0.49951E-02_JPRB,0.52507E-02_JPRB, &
 & 0.53857E-02_JPRB,0.53791E-02_JPRB,0.51629E-02_JPRB,0.55379E-02_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.24728E-02_JPRB,0.40487E-02_JPRB,0.46867E-02_JPRB,0.51042E-02_JPRB,0.53576E-02_JPRB, &
 & 0.54844E-02_JPRB,0.54704E-02_JPRB,0.52383E-02_JPRB,0.55398E-02_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.25454E-02_JPRB,0.41511E-02_JPRB,0.48010E-02_JPRB,0.52206E-02_JPRB,0.54751E-02_JPRB, &
 & 0.55927E-02_JPRB,0.55711E-02_JPRB,0.53216E-02_JPRB,0.55501E-02_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.26224E-02_JPRB,0.42542E-02_JPRB,0.49201E-02_JPRB,0.53438E-02_JPRB,0.55977E-02_JPRB, &
 & 0.57114E-02_JPRB,0.56753E-02_JPRB,0.54074E-02_JPRB,0.55558E-02_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.27039E-02_JPRB,0.43672E-02_JPRB,0.50470E-02_JPRB,0.54750E-02_JPRB,0.57276E-02_JPRB, &
 & 0.58363E-02_JPRB,0.57849E-02_JPRB,0.54996E-02_JPRB,0.55710E-02_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.21256E-02_JPRB,0.35221E-02_JPRB,0.40853E-02_JPRB,0.44612E-02_JPRB,0.46874E-02_JPRB, &
 & 0.47866E-02_JPRB,0.47389E-02_JPRB,0.44975E-02_JPRB,0.66135E-02_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.21937E-02_JPRB,0.36149E-02_JPRB,0.41854E-02_JPRB,0.45677E-02_JPRB,0.47907E-02_JPRB, &
 & 0.48833E-02_JPRB,0.48291E-02_JPRB,0.45707E-02_JPRB,0.65729E-02_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.22650E-02_JPRB,0.37098E-02_JPRB,0.42933E-02_JPRB,0.46764E-02_JPRB,0.49020E-02_JPRB, &
 & 0.49895E-02_JPRB,0.49234E-02_JPRB,0.46462E-02_JPRB,0.65598E-02_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.23425E-02_JPRB,0.38113E-02_JPRB,0.44107E-02_JPRB,0.47931E-02_JPRB,0.50165E-02_JPRB, &
 & 0.51000E-02_JPRB,0.50211E-02_JPRB,0.47251E-02_JPRB,0.65419E-02_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.24251E-02_JPRB,0.39222E-02_JPRB,0.45344E-02_JPRB,0.49164E-02_JPRB,0.51382E-02_JPRB, &
 & 0.52156E-02_JPRB,0.51233E-02_JPRB,0.48118E-02_JPRB,0.65404E-02_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.19014E-02_JPRB,0.31169E-02_JPRB,0.36336E-02_JPRB,0.39642E-02_JPRB,0.41602E-02_JPRB, &
 & 0.42352E-02_JPRB,0.41726E-02_JPRB,0.39183E-02_JPRB,0.68121E-02_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.19605E-02_JPRB,0.32068E-02_JPRB,0.37314E-02_JPRB,0.40676E-02_JPRB,0.42627E-02_JPRB, &
 & 0.43333E-02_JPRB,0.42591E-02_JPRB,0.39851E-02_JPRB,0.67229E-02_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.20227E-02_JPRB,0.33010E-02_JPRB,0.38333E-02_JPRB,0.41743E-02_JPRB,0.43708E-02_JPRB, &
 & 0.44355E-02_JPRB,0.43461E-02_JPRB,0.40520E-02_JPRB,0.66419E-02_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.20945E-02_JPRB,0.34006E-02_JPRB,0.39411E-02_JPRB,0.42851E-02_JPRB,0.44804E-02_JPRB, &
 & 0.45405E-02_JPRB,0.44353E-02_JPRB,0.41230E-02_JPRB,0.65948E-02_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.21695E-02_JPRB,0.35114E-02_JPRB,0.40581E-02_JPRB,0.44020E-02_JPRB,0.45960E-02_JPRB, &
 & 0.46501E-02_JPRB,0.45319E-02_JPRB,0.42045E-02_JPRB,0.65716E-02_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.17348E-02_JPRB,0.27575E-02_JPRB,0.32033E-02_JPRB,0.34905E-02_JPRB,0.36669E-02_JPRB, &
 & 0.37299E-02_JPRB,0.36615E-02_JPRB,0.34092E-02_JPRB,0.62173E-02_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.17868E-02_JPRB,0.28403E-02_JPRB,0.32978E-02_JPRB,0.35924E-02_JPRB,0.37684E-02_JPRB, &
 & 0.38248E-02_JPRB,0.37430E-02_JPRB,0.34686E-02_JPRB,0.61248E-02_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.18438E-02_JPRB,0.29272E-02_JPRB,0.33982E-02_JPRB,0.36985E-02_JPRB,0.38711E-02_JPRB, &
 & 0.39210E-02_JPRB,0.38240E-02_JPRB,0.35286E-02_JPRB,0.60637E-02_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.19066E-02_JPRB,0.30192E-02_JPRB,0.35016E-02_JPRB,0.38072E-02_JPRB,0.39764E-02_JPRB, &
 & 0.40199E-02_JPRB,0.39089E-02_JPRB,0.35954E-02_JPRB,0.60138E-02_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.19732E-02_JPRB,0.31237E-02_JPRB,0.36129E-02_JPRB,0.39207E-02_JPRB,0.40892E-02_JPRB, &
 & 0.41240E-02_JPRB,0.40022E-02_JPRB,0.36721E-02_JPRB,0.59944E-02_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.41219E-01_JPRB,0.41795E-01_JPRB,0.46848E-01_JPRB,0.50877E-01_JPRB,0.53437E-01_JPRB, &
 & 0.54488E-01_JPRB,0.53560E-01_JPRB,0.50235E-01_JPRB,0.51545E-01_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.42156E-01_JPRB,0.42406E-01_JPRB,0.47180E-01_JPRB,0.51006E-01_JPRB,0.53354E-01_JPRB, &
 & 0.54221E-01_JPRB,0.53185E-01_JPRB,0.49897E-01_JPRB,0.51289E-01_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.43082E-01_JPRB,0.43034E-01_JPRB,0.47543E-01_JPRB,0.51133E-01_JPRB,0.53289E-01_JPRB, &
 & 0.53978E-01_JPRB,0.52866E-01_JPRB,0.49591E-01_JPRB,0.51083E-01_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.43908E-01_JPRB,0.43606E-01_JPRB,0.47876E-01_JPRB,0.51241E-01_JPRB,0.53225E-01_JPRB, &
 & 0.53768E-01_JPRB,0.52555E-01_JPRB,0.49365E-01_JPRB,0.51010E-01_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.44717E-01_JPRB,0.44169E-01_JPRB,0.48160E-01_JPRB,0.51395E-01_JPRB,0.53206E-01_JPRB, &
 & 0.53607E-01_JPRB,0.52301E-01_JPRB,0.49268E-01_JPRB,0.51108E-01_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.38280E-01_JPRB,0.40368E-01_JPRB,0.46271E-01_JPRB,0.50387E-01_JPRB,0.53287E-01_JPRB, &
 & 0.54294E-01_JPRB,0.53147E-01_JPRB,0.49359E-01_JPRB,0.49444E-01_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.39278E-01_JPRB,0.41016E-01_JPRB,0.46659E-01_JPRB,0.50565E-01_JPRB,0.53249E-01_JPRB, &
 & 0.54064E-01_JPRB,0.52823E-01_JPRB,0.49016E-01_JPRB,0.49210E-01_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.40252E-01_JPRB,0.41678E-01_JPRB,0.47048E-01_JPRB,0.50745E-01_JPRB,0.53223E-01_JPRB, &
 & 0.53871E-01_JPRB,0.52519E-01_JPRB,0.48730E-01_JPRB,0.49081E-01_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.41132E-01_JPRB,0.42274E-01_JPRB,0.47387E-01_JPRB,0.50925E-01_JPRB,0.53214E-01_JPRB, &
 & 0.53693E-01_JPRB,0.52217E-01_JPRB,0.48559E-01_JPRB,0.49102E-01_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.41937E-01_JPRB,0.42806E-01_JPRB,0.47675E-01_JPRB,0.51115E-01_JPRB,0.53221E-01_JPRB, &
 & 0.53535E-01_JPRB,0.52007E-01_JPRB,0.48511E-01_JPRB,0.49285E-01_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.35016E-01_JPRB,0.38740E-01_JPRB,0.45035E-01_JPRB,0.49481E-01_JPRB,0.52517E-01_JPRB, &
 & 0.53496E-01_JPRB,0.52191E-01_JPRB,0.48044E-01_JPRB,0.46584E-01_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.36031E-01_JPRB,0.39393E-01_JPRB,0.45463E-01_JPRB,0.49713E-01_JPRB,0.52514E-01_JPRB, &
 & 0.53329E-01_JPRB,0.51912E-01_JPRB,0.47725E-01_JPRB,0.46413E-01_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.36991E-01_JPRB,0.40024E-01_JPRB,0.45863E-01_JPRB,0.49943E-01_JPRB,0.52531E-01_JPRB, &
 & 0.53167E-01_JPRB,0.51622E-01_JPRB,0.47472E-01_JPRB,0.46354E-01_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.37902E-01_JPRB,0.40620E-01_JPRB,0.46253E-01_JPRB,0.50181E-01_JPRB,0.52583E-01_JPRB, &
 & 0.53007E-01_JPRB,0.51384E-01_JPRB,0.47335E-01_JPRB,0.46441E-01_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.38707E-01_JPRB,0.41126E-01_JPRB,0.46598E-01_JPRB,0.50384E-01_JPRB,0.52633E-01_JPRB, &
 & 0.52879E-01_JPRB,0.51240E-01_JPRB,0.47311E-01_JPRB,0.46661E-01_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.31672E-01_JPRB,0.36966E-01_JPRB,0.43365E-01_JPRB,0.48073E-01_JPRB,0.51081E-01_JPRB, &
 & 0.52063E-01_JPRB,0.50596E-01_JPRB,0.46210E-01_JPRB,0.43228E-01_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.32685E-01_JPRB,0.37616E-01_JPRB,0.43827E-01_JPRB,0.48349E-01_JPRB,0.51147E-01_JPRB, &
 & 0.51967E-01_JPRB,0.50386E-01_JPRB,0.45960E-01_JPRB,0.43137E-01_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.33628E-01_JPRB,0.38241E-01_JPRB,0.44270E-01_JPRB,0.48639E-01_JPRB,0.51209E-01_JPRB, &
 & 0.51848E-01_JPRB,0.50172E-01_JPRB,0.45771E-01_JPRB,0.43147E-01_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.34503E-01_JPRB,0.38804E-01_JPRB,0.44698E-01_JPRB,0.48896E-01_JPRB,0.51278E-01_JPRB, &
 & 0.51724E-01_JPRB,0.50016E-01_JPRB,0.45686E-01_JPRB,0.43281E-01_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.35339E-01_JPRB,0.39319E-01_JPRB,0.45124E-01_JPRB,0.49160E-01_JPRB,0.51368E-01_JPRB, &
 & 0.51672E-01_JPRB,0.49945E-01_JPRB,0.45702E-01_JPRB,0.43520E-01_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.28453E-01_JPRB,0.34915E-01_JPRB,0.41400E-01_JPRB,0.46104E-01_JPRB,0.49014E-01_JPRB, &
 & 0.49952E-01_JPRB,0.48370E-01_JPRB,0.43932E-01_JPRB,0.39569E-01_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.29434E-01_JPRB,0.35588E-01_JPRB,0.41893E-01_JPRB,0.46437E-01_JPRB,0.49144E-01_JPRB, &
 & 0.49919E-01_JPRB,0.48254E-01_JPRB,0.43775E-01_JPRB,0.39548E-01_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.30340E-01_JPRB,0.36236E-01_JPRB,0.42373E-01_JPRB,0.46769E-01_JPRB,0.49255E-01_JPRB, &
 & 0.49873E-01_JPRB,0.48133E-01_JPRB,0.43667E-01_JPRB,0.39610E-01_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.31178E-01_JPRB,0.36810E-01_JPRB,0.42835E-01_JPRB,0.47061E-01_JPRB,0.49370E-01_JPRB, &
 & 0.49827E-01_JPRB,0.48071E-01_JPRB,0.43623E-01_JPRB,0.39779E-01_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.31999E-01_JPRB,0.37346E-01_JPRB,0.43284E-01_JPRB,0.47361E-01_JPRB,0.49516E-01_JPRB, &
 & 0.49857E-01_JPRB,0.48088E-01_JPRB,0.43666E-01_JPRB,0.40037E-01_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.25421E-01_JPRB,0.32626E-01_JPRB,0.39116E-01_JPRB,0.43609E-01_JPRB,0.46371E-01_JPRB, &
 & 0.47186E-01_JPRB,0.45634E-01_JPRB,0.41276E-01_JPRB,0.35722E-01_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.26347E-01_JPRB,0.33315E-01_JPRB,0.39629E-01_JPRB,0.44004E-01_JPRB,0.46570E-01_JPRB, &
 & 0.47251E-01_JPRB,0.45602E-01_JPRB,0.41217E-01_JPRB,0.35770E-01_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.27211E-01_JPRB,0.33965E-01_JPRB,0.40142E-01_JPRB,0.44371E-01_JPRB,0.46737E-01_JPRB, &
 & 0.47271E-01_JPRB,0.45579E-01_JPRB,0.41184E-01_JPRB,0.35883E-01_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.28013E-01_JPRB,0.34546E-01_JPRB,0.40641E-01_JPRB,0.44704E-01_JPRB,0.46903E-01_JPRB, &
 & 0.47305E-01_JPRB,0.45608E-01_JPRB,0.41201E-01_JPRB,0.36071E-01_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.28777E-01_JPRB,0.35080E-01_JPRB,0.41083E-01_JPRB,0.45018E-01_JPRB,0.47083E-01_JPRB, &
 & 0.47404E-01_JPRB,0.45685E-01_JPRB,0.41273E-01_JPRB,0.36328E-01_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.22628E-01_JPRB,0.30290E-01_JPRB,0.36520E-01_JPRB,0.40736E-01_JPRB,0.43195E-01_JPRB, &
 & 0.43894E-01_JPRB,0.42478E-01_JPRB,0.38357E-01_JPRB,0.31858E-01_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.23496E-01_JPRB,0.30981E-01_JPRB,0.37071E-01_JPRB,0.41159E-01_JPRB,0.43459E-01_JPRB, &
 & 0.44039E-01_JPRB,0.42534E-01_JPRB,0.38366E-01_JPRB,0.31954E-01_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.24311E-01_JPRB,0.31616E-01_JPRB,0.37614E-01_JPRB,0.41552E-01_JPRB,0.43690E-01_JPRB, &
 & 0.44135E-01_JPRB,0.42598E-01_JPRB,0.38398E-01_JPRB,0.32112E-01_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.25081E-01_JPRB,0.32194E-01_JPRB,0.38124E-01_JPRB,0.41906E-01_JPRB,0.43917E-01_JPRB, &
 & 0.44249E-01_JPRB,0.42700E-01_JPRB,0.38476E-01_JPRB,0.32312E-01_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.25796E-01_JPRB,0.32737E-01_JPRB,0.38583E-01_JPRB,0.42251E-01_JPRB,0.44147E-01_JPRB, &
 & 0.44425E-01_JPRB,0.42840E-01_JPRB,0.38587E-01_JPRB,0.32545E-01_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.20122E-01_JPRB,0.27995E-01_JPRB,0.33719E-01_JPRB,0.37485E-01_JPRB,0.39621E-01_JPRB, &
 & 0.40226E-01_JPRB,0.38971E-01_JPRB,0.35214E-01_JPRB,0.28110E-01_JPRB /)  
KA(:, 2, 8, 9) = (/ &
 & 0.20930E-01_JPRB,0.28671E-01_JPRB,0.34304E-01_JPRB,0.37966E-01_JPRB,0.39957E-01_JPRB, &
 & 0.40447E-01_JPRB,0.39124E-01_JPRB,0.35304E-01_JPRB,0.28246E-01_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.21692E-01_JPRB,0.29291E-01_JPRB,0.34870E-01_JPRB,0.38392E-01_JPRB,0.40254E-01_JPRB, &
 & 0.40624E-01_JPRB,0.39266E-01_JPRB,0.35403E-01_JPRB,0.28424E-01_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.22396E-01_JPRB,0.29880E-01_JPRB,0.35388E-01_JPRB,0.38779E-01_JPRB,0.40528E-01_JPRB, &
 & 0.40815E-01_JPRB,0.39436E-01_JPRB,0.35538E-01_JPRB,0.28597E-01_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.23064E-01_JPRB,0.30402E-01_JPRB,0.35848E-01_JPRB,0.39151E-01_JPRB,0.40824E-01_JPRB, &
 & 0.41057E-01_JPRB,0.39639E-01_JPRB,0.35669E-01_JPRB,0.28823E-01_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.17909E-01_JPRB,0.25709E-01_JPRB,0.30840E-01_JPRB,0.34036E-01_JPRB,0.35851E-01_JPRB, &
 & 0.36360E-01_JPRB,0.35282E-01_JPRB,0.31947E-01_JPRB,0.24003E-01_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.18652E-01_JPRB,0.26369E-01_JPRB,0.31431E-01_JPRB,0.34542E-01_JPRB,0.36244E-01_JPRB, &
 & 0.36648E-01_JPRB,0.35513E-01_JPRB,0.32109E-01_JPRB,0.24164E-01_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.19344E-01_JPRB,0.26986E-01_JPRB,0.31997E-01_JPRB,0.35005E-01_JPRB,0.36599E-01_JPRB, &
 & 0.36904E-01_JPRB,0.35718E-01_JPRB,0.32277E-01_JPRB,0.24318E-01_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.19991E-01_JPRB,0.27565E-01_JPRB,0.32506E-01_JPRB,0.35425E-01_JPRB,0.36934E-01_JPRB, &
 & 0.37163E-01_JPRB,0.35949E-01_JPRB,0.32440E-01_JPRB,0.24470E-01_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.20615E-01_JPRB,0.28069E-01_JPRB,0.32961E-01_JPRB,0.35817E-01_JPRB,0.37281E-01_JPRB, &
 & 0.37462E-01_JPRB,0.36191E-01_JPRB,0.32591E-01_JPRB,0.24688E-01_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.16038E-01_JPRB,0.23520E-01_JPRB,0.27944E-01_JPRB,0.30612E-01_JPRB,0.32108E-01_JPRB, &
 & 0.32531E-01_JPRB,0.31594E-01_JPRB,0.28710E-01_JPRB,0.19040E-01_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.16702E-01_JPRB,0.24155E-01_JPRB,0.28537E-01_JPRB,0.31140E-01_JPRB,0.32544E-01_JPRB, &
 & 0.32858E-01_JPRB,0.31863E-01_JPRB,0.28938E-01_JPRB,0.19154E-01_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.17329E-01_JPRB,0.24747E-01_JPRB,0.29094E-01_JPRB,0.31618E-01_JPRB,0.32949E-01_JPRB, &
 & 0.33160E-01_JPRB,0.32119E-01_JPRB,0.29151E-01_JPRB,0.19214E-01_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.17922E-01_JPRB,0.25302E-01_JPRB,0.29595E-01_JPRB,0.32058E-01_JPRB,0.33330E-01_JPRB, &
 & 0.33472E-01_JPRB,0.32385E-01_JPRB,0.29320E-01_JPRB,0.19269E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART7',0,ZHOOK_HANDLE)


KA(:, 5,10, 9) = (/ &
 & 0.18489E-01_JPRB,0.25799E-01_JPRB,0.30045E-01_JPRB,0.32466E-01_JPRB,0.33700E-01_JPRB, &
 & 0.33812E-01_JPRB,0.32629E-01_JPRB,0.29481E-01_JPRB,0.19405E-01_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.14687E-01_JPRB,0.21702E-01_JPRB,0.25384E-01_JPRB,0.27570E-01_JPRB,0.28760E-01_JPRB, &
 & 0.29017E-01_JPRB,0.28178E-01_JPRB,0.25716E-01_JPRB,0.20195E-01_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.15274E-01_JPRB,0.22296E-01_JPRB,0.25944E-01_JPRB,0.28087E-01_JPRB,0.29202E-01_JPRB, &
 & 0.29352E-01_JPRB,0.28471E-01_JPRB,0.25960E-01_JPRB,0.20265E-01_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.15835E-01_JPRB,0.22836E-01_JPRB,0.26465E-01_JPRB,0.28550E-01_JPRB,0.29611E-01_JPRB, &
 & 0.29694E-01_JPRB,0.28754E-01_JPRB,0.26152E-01_JPRB,0.20296E-01_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.16357E-01_JPRB,0.23338E-01_JPRB,0.26927E-01_JPRB,0.28982E-01_JPRB,0.29998E-01_JPRB, &
 & 0.30045E-01_JPRB,0.29008E-01_JPRB,0.26312E-01_JPRB,0.20131E-01_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.16879E-01_JPRB,0.23791E-01_JPRB,0.27359E-01_JPRB,0.29394E-01_JPRB,0.30387E-01_JPRB, &
 & 0.30372E-01_JPRB,0.29268E-01_JPRB,0.26507E-01_JPRB,0.20180E-01_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.13435E-01_JPRB,0.19917E-01_JPRB,0.22947E-01_JPRB,0.24741E-01_JPRB,0.25656E-01_JPRB, &
 & 0.25762E-01_JPRB,0.25010E-01_JPRB,0.22879E-01_JPRB,0.21935E-01_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.13973E-01_JPRB,0.20460E-01_JPRB,0.23475E-01_JPRB,0.25221E-01_JPRB,0.26084E-01_JPRB, &
 & 0.26126E-01_JPRB,0.25297E-01_JPRB,0.23091E-01_JPRB,0.22096E-01_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.14481E-01_JPRB,0.20956E-01_JPRB,0.23951E-01_JPRB,0.25665E-01_JPRB,0.26486E-01_JPRB, &
 & 0.26478E-01_JPRB,0.25558E-01_JPRB,0.23263E-01_JPRB,0.22257E-01_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.14966E-01_JPRB,0.21408E-01_JPRB,0.24388E-01_JPRB,0.26079E-01_JPRB,0.26872E-01_JPRB, &
 & 0.26802E-01_JPRB,0.25814E-01_JPRB,0.23444E-01_JPRB,0.22244E-01_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.15448E-01_JPRB,0.21834E-01_JPRB,0.24813E-01_JPRB,0.26492E-01_JPRB,0.27230E-01_JPRB, &
 & 0.27128E-01_JPRB,0.26103E-01_JPRB,0.23676E-01_JPRB,0.22318E-01_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.12253E-01_JPRB,0.18169E-01_JPRB,0.20712E-01_JPRB,0.22143E-01_JPRB,0.22829E-01_JPRB, &
 & 0.22840E-01_JPRB,0.22092E-01_JPRB,0.20210E-01_JPRB,0.22350E-01_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.12752E-01_JPRB,0.18675E-01_JPRB,0.21188E-01_JPRB,0.22590E-01_JPRB,0.23242E-01_JPRB, &
 & 0.23184E-01_JPRB,0.22356E-01_JPRB,0.20395E-01_JPRB,0.22569E-01_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.13220E-01_JPRB,0.19134E-01_JPRB,0.21627E-01_JPRB,0.23007E-01_JPRB,0.23621E-01_JPRB, &
 & 0.23502E-01_JPRB,0.22612E-01_JPRB,0.20571E-01_JPRB,0.22750E-01_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.13675E-01_JPRB,0.19566E-01_JPRB,0.22044E-01_JPRB,0.23405E-01_JPRB,0.23969E-01_JPRB, &
 & 0.23813E-01_JPRB,0.22875E-01_JPRB,0.20780E-01_JPRB,0.22726E-01_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.14122E-01_JPRB,0.19976E-01_JPRB,0.22454E-01_JPRB,0.23786E-01_JPRB,0.24318E-01_JPRB, &
 & 0.24140E-01_JPRB,0.23183E-01_JPRB,0.21041E-01_JPRB,0.22784E-01_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.14776E+00_JPRB,0.13250E+00_JPRB,0.11877E+00_JPRB,0.11907E+00_JPRB,0.11538E+00_JPRB, &
 & 0.11234E+00_JPRB,0.10926E+00_JPRB,0.11039E+00_JPRB,0.12102E+00_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.14758E+00_JPRB,0.13180E+00_JPRB,0.11760E+00_JPRB,0.11720E+00_JPRB,0.11379E+00_JPRB, &
 & 0.11206E+00_JPRB,0.10856E+00_JPRB,0.11029E+00_JPRB,0.12093E+00_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.14691E+00_JPRB,0.13078E+00_JPRB,0.11629E+00_JPRB,0.11563E+00_JPRB,0.11248E+00_JPRB, &
 & 0.11149E+00_JPRB,0.10785E+00_JPRB,0.11040E+00_JPRB,0.12104E+00_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.14609E+00_JPRB,0.12985E+00_JPRB,0.11503E+00_JPRB,0.11426E+00_JPRB,0.11150E+00_JPRB, &
 & 0.11061E+00_JPRB,0.10739E+00_JPRB,0.11031E+00_JPRB,0.12092E+00_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.14529E+00_JPRB,0.12911E+00_JPRB,0.11448E+00_JPRB,0.11310E+00_JPRB,0.11058E+00_JPRB, &
 & 0.10959E+00_JPRB,0.10721E+00_JPRB,0.11007E+00_JPRB,0.12050E+00_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.14616E+00_JPRB,0.13131E+00_JPRB,0.12350E+00_JPRB,0.12510E+00_JPRB,0.11934E+00_JPRB, &
 & 0.11762E+00_JPRB,0.11417E+00_JPRB,0.11460E+00_JPRB,0.12626E+00_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.14607E+00_JPRB,0.13063E+00_JPRB,0.12202E+00_JPRB,0.12312E+00_JPRB,0.11789E+00_JPRB, &
 & 0.11742E+00_JPRB,0.11363E+00_JPRB,0.11470E+00_JPRB,0.12636E+00_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.14577E+00_JPRB,0.12991E+00_JPRB,0.12074E+00_JPRB,0.12132E+00_JPRB,0.11671E+00_JPRB, &
 & 0.11676E+00_JPRB,0.11334E+00_JPRB,0.11448E+00_JPRB,0.12602E+00_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.14549E+00_JPRB,0.12948E+00_JPRB,0.11982E+00_JPRB,0.11971E+00_JPRB,0.11561E+00_JPRB, &
 & 0.11583E+00_JPRB,0.11311E+00_JPRB,0.11380E+00_JPRB,0.12515E+00_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.14518E+00_JPRB,0.12921E+00_JPRB,0.11930E+00_JPRB,0.11856E+00_JPRB,0.11453E+00_JPRB, &
 & 0.11499E+00_JPRB,0.11278E+00_JPRB,0.11303E+00_JPRB,0.12425E+00_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.14318E+00_JPRB,0.12893E+00_JPRB,0.12918E+00_JPRB,0.12942E+00_JPRB,0.12491E+00_JPRB, &
 & 0.12238E+00_JPRB,0.11842E+00_JPRB,0.11706E+00_JPRB,0.12892E+00_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.14362E+00_JPRB,0.12877E+00_JPRB,0.12794E+00_JPRB,0.12738E+00_JPRB,0.12367E+00_JPRB, &
 & 0.12214E+00_JPRB,0.11818E+00_JPRB,0.11730E+00_JPRB,0.12892E+00_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.14392E+00_JPRB,0.12859E+00_JPRB,0.12673E+00_JPRB,0.12555E+00_JPRB,0.12238E+00_JPRB, &
 & 0.12154E+00_JPRB,0.11804E+00_JPRB,0.11693E+00_JPRB,0.12825E+00_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.14418E+00_JPRB,0.12858E+00_JPRB,0.12588E+00_JPRB,0.12406E+00_JPRB,0.12111E+00_JPRB, &
 & 0.12100E+00_JPRB,0.11768E+00_JPRB,0.11605E+00_JPRB,0.12723E+00_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.14433E+00_JPRB,0.12868E+00_JPRB,0.12520E+00_JPRB,0.12307E+00_JPRB,0.11981E+00_JPRB, &
 & 0.12050E+00_JPRB,0.11702E+00_JPRB,0.11519E+00_JPRB,0.12642E+00_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.13900E+00_JPRB,0.12627E+00_JPRB,0.13262E+00_JPRB,0.13246E+00_JPRB,0.13018E+00_JPRB, &
 & 0.12656E+00_JPRB,0.12207E+00_JPRB,0.11856E+00_JPRB,0.12927E+00_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.13981E+00_JPRB,0.12631E+00_JPRB,0.13168E+00_JPRB,0.13063E+00_JPRB,0.12928E+00_JPRB, &
 & 0.12634E+00_JPRB,0.12180E+00_JPRB,0.11842E+00_JPRB,0.12888E+00_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.14055E+00_JPRB,0.12635E+00_JPRB,0.13064E+00_JPRB,0.12886E+00_JPRB,0.12826E+00_JPRB, &
 & 0.12591E+00_JPRB,0.12147E+00_JPRB,0.11781E+00_JPRB,0.12798E+00_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.14115E+00_JPRB,0.12659E+00_JPRB,0.12979E+00_JPRB,0.12765E+00_JPRB,0.12712E+00_JPRB, &
 & 0.12539E+00_JPRB,0.12094E+00_JPRB,0.11686E+00_JPRB,0.12709E+00_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.14205E+00_JPRB,0.12716E+00_JPRB,0.12897E+00_JPRB,0.12678E+00_JPRB,0.12607E+00_JPRB, &
 & 0.12463E+00_JPRB,0.12022E+00_JPRB,0.11611E+00_JPRB,0.12648E+00_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.13267E+00_JPRB,0.12451E+00_JPRB,0.13264E+00_JPRB,0.13467E+00_JPRB,0.13410E+00_JPRB, &
 & 0.12976E+00_JPRB,0.12532E+00_JPRB,0.11842E+00_JPRB,0.12663E+00_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.13391E+00_JPRB,0.12448E+00_JPRB,0.13222E+00_JPRB,0.13349E+00_JPRB,0.13365E+00_JPRB, &
 & 0.12967E+00_JPRB,0.12478E+00_JPRB,0.11793E+00_JPRB,0.12610E+00_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.13513E+00_JPRB,0.12441E+00_JPRB,0.13150E+00_JPRB,0.13226E+00_JPRB,0.13285E+00_JPRB, &
 & 0.12935E+00_JPRB,0.12414E+00_JPRB,0.11714E+00_JPRB,0.12535E+00_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.13635E+00_JPRB,0.12468E+00_JPRB,0.13071E+00_JPRB,0.13132E+00_JPRB,0.13192E+00_JPRB, &
 & 0.12883E+00_JPRB,0.12325E+00_JPRB,0.11628E+00_JPRB,0.12465E+00_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.13765E+00_JPRB,0.12523E+00_JPRB,0.12989E+00_JPRB,0.13067E+00_JPRB,0.13104E+00_JPRB, &
 & 0.12778E+00_JPRB,0.12230E+00_JPRB,0.11574E+00_JPRB,0.12447E+00_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.12480E+00_JPRB,0.12304E+00_JPRB,0.13086E+00_JPRB,0.13535E+00_JPRB,0.13580E+00_JPRB, &
 & 0.13244E+00_JPRB,0.12684E+00_JPRB,0.11687E+00_JPRB,0.12150E+00_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.12631E+00_JPRB,0.12320E+00_JPRB,0.13089E+00_JPRB,0.13488E+00_JPRB,0.13591E+00_JPRB, &
 & 0.13240E+00_JPRB,0.12644E+00_JPRB,0.11610E+00_JPRB,0.12096E+00_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.12783E+00_JPRB,0.12334E+00_JPRB,0.13031E+00_JPRB,0.13415E+00_JPRB,0.13555E+00_JPRB, &
 & 0.13212E+00_JPRB,0.12571E+00_JPRB,0.11517E+00_JPRB,0.12033E+00_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.12946E+00_JPRB,0.12375E+00_JPRB,0.12962E+00_JPRB,0.13360E+00_JPRB,0.13480E+00_JPRB, &
 & 0.13147E+00_JPRB,0.12458E+00_JPRB,0.11440E+00_JPRB,0.12012E+00_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.13098E+00_JPRB,0.12424E+00_JPRB,0.12926E+00_JPRB,0.13328E+00_JPRB,0.13390E+00_JPRB, &
 & 0.13035E+00_JPRB,0.12352E+00_JPRB,0.11410E+00_JPRB,0.12034E+00_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.11587E+00_JPRB,0.11977E+00_JPRB,0.12827E+00_JPRB,0.13413E+00_JPRB,0.13637E+00_JPRB, &
 & 0.13338E+00_JPRB,0.12607E+00_JPRB,0.11369E+00_JPRB,0.11422E+00_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.11755E+00_JPRB,0.12008E+00_JPRB,0.12851E+00_JPRB,0.13433E+00_JPRB,0.13653E+00_JPRB, &
 & 0.13350E+00_JPRB,0.12579E+00_JPRB,0.11303E+00_JPRB,0.11384E+00_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.11925E+00_JPRB,0.12045E+00_JPRB,0.12827E+00_JPRB,0.13401E+00_JPRB,0.13627E+00_JPRB, &
 & 0.13335E+00_JPRB,0.12531E+00_JPRB,0.11227E+00_JPRB,0.11342E+00_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.12111E+00_JPRB,0.12107E+00_JPRB,0.12798E+00_JPRB,0.13385E+00_JPRB,0.13564E+00_JPRB, &
 & 0.13268E+00_JPRB,0.12424E+00_JPRB,0.11167E+00_JPRB,0.11355E+00_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.12285E+00_JPRB,0.12168E+00_JPRB,0.12798E+00_JPRB,0.13376E+00_JPRB,0.13482E+00_JPRB, &
 & 0.13151E+00_JPRB,0.12334E+00_JPRB,0.11149E+00_JPRB,0.11415E+00_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.10591E+00_JPRB,0.11393E+00_JPRB,0.12456E+00_JPRB,0.13177E+00_JPRB,0.13532E+00_JPRB, &
 & 0.13189E+00_JPRB,0.12388E+00_JPRB,0.10965E+00_JPRB,0.10563E+00_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.10784E+00_JPRB,0.11446E+00_JPRB,0.12497E+00_JPRB,0.13191E+00_JPRB,0.13527E+00_JPRB, &
 & 0.13206E+00_JPRB,0.12372E+00_JPRB,0.10901E+00_JPRB,0.10541E+00_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.10982E+00_JPRB,0.11499E+00_JPRB,0.12496E+00_JPRB,0.13190E+00_JPRB,0.13491E+00_JPRB, &
 & 0.13198E+00_JPRB,0.12329E+00_JPRB,0.10836E+00_JPRB,0.10528E+00_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.11183E+00_JPRB,0.11569E+00_JPRB,0.12499E+00_JPRB,0.13184E+00_JPRB,0.13435E+00_JPRB, &
 & 0.13149E+00_JPRB,0.12252E+00_JPRB,0.10787E+00_JPRB,0.10590E+00_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.11351E+00_JPRB,0.11638E+00_JPRB,0.12535E+00_JPRB,0.13176E+00_JPRB,0.13360E+00_JPRB, &
 & 0.13054E+00_JPRB,0.12191E+00_JPRB,0.10801E+00_JPRB,0.10661E+00_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.95227E-01_JPRB,0.10714E+00_JPRB,0.11944E+00_JPRB,0.12826E+00_JPRB,0.13131E+00_JPRB, &
 & 0.12801E+00_JPRB,0.11973E+00_JPRB,0.10506E+00_JPRB,0.96127E-01_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.97380E-01_JPRB,0.10792E+00_JPRB,0.12010E+00_JPRB,0.12848E+00_JPRB,0.13131E+00_JPRB, &
 & 0.12823E+00_JPRB,0.11988E+00_JPRB,0.10446E+00_JPRB,0.96013E-01_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.99589E-01_JPRB,0.10861E+00_JPRB,0.12043E+00_JPRB,0.12826E+00_JPRB,0.13099E+00_JPRB, &
 & 0.12821E+00_JPRB,0.11964E+00_JPRB,0.10385E+00_JPRB,0.96337E-01_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.10172E+00_JPRB,0.10937E+00_JPRB,0.12073E+00_JPRB,0.12822E+00_JPRB,0.13048E+00_JPRB, &
 & 0.12786E+00_JPRB,0.11915E+00_JPRB,0.10369E+00_JPRB,0.97324E-01_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.10340E+00_JPRB,0.11015E+00_JPRB,0.12136E+00_JPRB,0.12832E+00_JPRB,0.12998E+00_JPRB, &
 & 0.12724E+00_JPRB,0.11892E+00_JPRB,0.10410E+00_JPRB,0.97908E-01_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.84549E-01_JPRB,0.10005E+00_JPRB,0.11370E+00_JPRB,0.12280E+00_JPRB,0.12503E+00_JPRB, &
 & 0.12157E+00_JPRB,0.11395E+00_JPRB,0.99558E-01_JPRB,0.78463E-01_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.86895E-01_JPRB,0.10114E+00_JPRB,0.11438E+00_JPRB,0.12270E+00_JPRB,0.12494E+00_JPRB, &
 & 0.12211E+00_JPRB,0.11447E+00_JPRB,0.98932E-01_JPRB,0.78293E-01_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.89280E-01_JPRB,0.10200E+00_JPRB,0.11501E+00_JPRB,0.12255E+00_JPRB,0.12466E+00_JPRB, &
 & 0.12232E+00_JPRB,0.11449E+00_JPRB,0.98490E-01_JPRB,0.78963E-01_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.91373E-01_JPRB,0.10297E+00_JPRB,0.11555E+00_JPRB,0.12264E+00_JPRB,0.12433E+00_JPRB, &
 & 0.12211E+00_JPRB,0.11429E+00_JPRB,0.98808E-01_JPRB,0.79894E-01_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.93116E-01_JPRB,0.10381E+00_JPRB,0.11616E+00_JPRB,0.12299E+00_JPRB,0.12420E+00_JPRB, &
 & 0.12176E+00_JPRB,0.11463E+00_JPRB,0.99400E-01_JPRB,0.79228E-01_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.75544E-01_JPRB,0.93054E-01_JPRB,0.10724E+00_JPRB,0.11489E+00_JPRB,0.11666E+00_JPRB, &
 & 0.11411E+00_JPRB,0.10739E+00_JPRB,0.92708E-01_JPRB,0.54552E-01_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.77908E-01_JPRB,0.94287E-01_JPRB,0.10808E+00_JPRB,0.11471E+00_JPRB,0.11661E+00_JPRB, &
 & 0.11478E+00_JPRB,0.10772E+00_JPRB,0.92504E-01_JPRB,0.54848E-01_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.80077E-01_JPRB,0.95473E-01_JPRB,0.10868E+00_JPRB,0.11491E+00_JPRB,0.11655E+00_JPRB, &
 & 0.11482E+00_JPRB,0.10782E+00_JPRB,0.93001E-01_JPRB,0.55769E-01_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.81960E-01_JPRB,0.96566E-01_JPRB,0.10943E+00_JPRB,0.11546E+00_JPRB,0.11672E+00_JPRB, &
 & 0.11473E+00_JPRB,0.10831E+00_JPRB,0.93879E-01_JPRB,0.57926E-01_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.83450E-01_JPRB,0.97453E-01_JPRB,0.11008E+00_JPRB,0.11599E+00_JPRB,0.11716E+00_JPRB, &
 & 0.11515E+00_JPRB,0.10911E+00_JPRB,0.94288E-01_JPRB,0.57746E-01_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.67513E-01_JPRB,0.86189E-01_JPRB,0.99369E-01_JPRB,0.10520E+00_JPRB,0.10724E+00_JPRB, &
 & 0.10586E+00_JPRB,0.99242E-01_JPRB,0.85556E-01_JPRB,0.53156E-01_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.69613E-01_JPRB,0.87484E-01_JPRB,0.10007E+00_JPRB,0.10560E+00_JPRB,0.10749E+00_JPRB, &
 & 0.10614E+00_JPRB,0.99761E-01_JPRB,0.86270E-01_JPRB,0.51781E-01_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.71469E-01_JPRB,0.88722E-01_JPRB,0.10094E+00_JPRB,0.10629E+00_JPRB,0.10784E+00_JPRB, &
 & 0.10630E+00_JPRB,0.10046E+00_JPRB,0.87349E-01_JPRB,0.51450E-01_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.73024E-01_JPRB,0.89773E-01_JPRB,0.10183E+00_JPRB,0.10713E+00_JPRB,0.10860E+00_JPRB, &
 & 0.10686E+00_JPRB,0.10138E+00_JPRB,0.88130E-01_JPRB,0.52601E-01_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.74303E-01_JPRB,0.90696E-01_JPRB,0.10259E+00_JPRB,0.10797E+00_JPRB,0.10971E+00_JPRB, &
 & 0.10792E+00_JPRB,0.10184E+00_JPRB,0.88445E-01_JPRB,0.51152E-01_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.60529E-01_JPRB,0.79607E-01_JPRB,0.90318E-01_JPRB,0.95428E-01_JPRB,0.97408E-01_JPRB, &
 & 0.96227E-01_JPRB,0.90699E-01_JPRB,0.78779E-01_JPRB,0.52832E-01_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.62276E-01_JPRB,0.80870E-01_JPRB,0.91247E-01_JPRB,0.96259E-01_JPRB,0.97934E-01_JPRB, &
 & 0.96714E-01_JPRB,0.91680E-01_JPRB,0.79941E-01_JPRB,0.52303E-01_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.63790E-01_JPRB,0.81933E-01_JPRB,0.92274E-01_JPRB,0.97270E-01_JPRB,0.98880E-01_JPRB, &
 & 0.97553E-01_JPRB,0.92636E-01_JPRB,0.80918E-01_JPRB,0.51576E-01_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.65028E-01_JPRB,0.82921E-01_JPRB,0.93287E-01_JPRB,0.98387E-01_JPRB,0.10023E+00_JPRB, &
 & 0.98785E-01_JPRB,0.93367E-01_JPRB,0.81491E-01_JPRB,0.53387E-01_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.66150E-01_JPRB,0.83739E-01_JPRB,0.94354E-01_JPRB,0.99696E-01_JPRB,0.10169E+00_JPRB, &
 & 0.99901E-01_JPRB,0.93863E-01_JPRB,0.81907E-01_JPRB,0.52837E-01_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.20407E+00_JPRB,0.18071E+00_JPRB,0.16029E+00_JPRB,0.15138E+00_JPRB,0.14997E+00_JPRB, &
 & 0.13984E+00_JPRB,0.13275E+00_JPRB,0.14129E+00_JPRB,0.15399E+00_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.20135E+00_JPRB,0.17935E+00_JPRB,0.15932E+00_JPRB,0.15017E+00_JPRB,0.14962E+00_JPRB, &
 & 0.13862E+00_JPRB,0.13266E+00_JPRB,0.14117E+00_JPRB,0.15393E+00_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.19936E+00_JPRB,0.17801E+00_JPRB,0.15787E+00_JPRB,0.14825E+00_JPRB,0.14805E+00_JPRB, &
 & 0.13791E+00_JPRB,0.13257E+00_JPRB,0.14065E+00_JPRB,0.15357E+00_JPRB /)  
KA(:, 4, 1,11) = (/ &
 & 0.19744E+00_JPRB,0.17636E+00_JPRB,0.15587E+00_JPRB,0.14600E+00_JPRB,0.14568E+00_JPRB, &
 & 0.13759E+00_JPRB,0.13216E+00_JPRB,0.14003E+00_JPRB,0.15311E+00_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.19560E+00_JPRB,0.17445E+00_JPRB,0.15370E+00_JPRB,0.14366E+00_JPRB,0.14353E+00_JPRB, &
 & 0.13719E+00_JPRB,0.13142E+00_JPRB,0.13943E+00_JPRB,0.15271E+00_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.21063E+00_JPRB,0.18653E+00_JPRB,0.16583E+00_JPRB,0.16261E+00_JPRB,0.15745E+00_JPRB, &
 & 0.14703E+00_JPRB,0.14143E+00_JPRB,0.14831E+00_JPRB,0.16307E+00_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.20807E+00_JPRB,0.18515E+00_JPRB,0.16450E+00_JPRB,0.16174E+00_JPRB,0.15680E+00_JPRB, &
 & 0.14604E+00_JPRB,0.14115E+00_JPRB,0.14798E+00_JPRB,0.16304E+00_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.20581E+00_JPRB,0.18338E+00_JPRB,0.16244E+00_JPRB,0.15978E+00_JPRB,0.15520E+00_JPRB, &
 & 0.14566E+00_JPRB,0.14067E+00_JPRB,0.14768E+00_JPRB,0.16312E+00_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.20347E+00_JPRB,0.18119E+00_JPRB,0.16010E+00_JPRB,0.15745E+00_JPRB,0.15333E+00_JPRB, &
 & 0.14529E+00_JPRB,0.14007E+00_JPRB,0.14753E+00_JPRB,0.16343E+00_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.20115E+00_JPRB,0.17885E+00_JPRB,0.15773E+00_JPRB,0.15483E+00_JPRB,0.15150E+00_JPRB, &
 & 0.14453E+00_JPRB,0.13948E+00_JPRB,0.14731E+00_JPRB,0.16359E+00_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.21616E+00_JPRB,0.19157E+00_JPRB,0.17353E+00_JPRB,0.17142E+00_JPRB,0.16301E+00_JPRB, &
 & 0.15566E+00_JPRB,0.14998E+00_JPRB,0.15514E+00_JPRB,0.17145E+00_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.21408E+00_JPRB,0.19026E+00_JPRB,0.17182E+00_JPRB,0.17122E+00_JPRB,0.16252E+00_JPRB, &
 & 0.15476E+00_JPRB,0.14939E+00_JPRB,0.15448E+00_JPRB,0.17139E+00_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.21163E+00_JPRB,0.18824E+00_JPRB,0.16950E+00_JPRB,0.16996E+00_JPRB,0.16151E+00_JPRB, &
 & 0.15419E+00_JPRB,0.14882E+00_JPRB,0.15406E+00_JPRB,0.17163E+00_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.20914E+00_JPRB,0.18593E+00_JPRB,0.16692E+00_JPRB,0.16757E+00_JPRB,0.16029E+00_JPRB, &
 & 0.15344E+00_JPRB,0.14837E+00_JPRB,0.15392E+00_JPRB,0.17198E+00_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.20701E+00_JPRB,0.18381E+00_JPRB,0.16453E+00_JPRB,0.16472E+00_JPRB,0.15897E+00_JPRB, &
 & 0.15236E+00_JPRB,0.14801E+00_JPRB,0.15351E+00_JPRB,0.17179E+00_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.21862E+00_JPRB,0.19379E+00_JPRB,0.18221E+00_JPRB,0.17807E+00_JPRB,0.16954E+00_JPRB, &
 & 0.16407E+00_JPRB,0.15829E+00_JPRB,0.16056E+00_JPRB,0.17755E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART8',0,ZHOOK_HANDLE)


KA(:, 2, 4,11) = (/ &
 & 0.21705E+00_JPRB,0.19285E+00_JPRB,0.18086E+00_JPRB,0.17812E+00_JPRB,0.16909E+00_JPRB, &
 & 0.16313E+00_JPRB,0.15767E+00_JPRB,0.16003E+00_JPRB,0.17784E+00_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.21534E+00_JPRB,0.19129E+00_JPRB,0.17879E+00_JPRB,0.17719E+00_JPRB,0.16821E+00_JPRB, &
 & 0.16252E+00_JPRB,0.15706E+00_JPRB,0.15944E+00_JPRB,0.17796E+00_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.21357E+00_JPRB,0.18961E+00_JPRB,0.17644E+00_JPRB,0.17503E+00_JPRB,0.16720E+00_JPRB, &
 & 0.16179E+00_JPRB,0.15644E+00_JPRB,0.15869E+00_JPRB,0.17755E+00_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.21192E+00_JPRB,0.18796E+00_JPRB,0.17436E+00_JPRB,0.17237E+00_JPRB,0.16599E+00_JPRB, &
 & 0.16096E+00_JPRB,0.15564E+00_JPRB,0.15746E+00_JPRB,0.17656E+00_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.21793E+00_JPRB,0.19325E+00_JPRB,0.18965E+00_JPRB,0.18402E+00_JPRB,0.17692E+00_JPRB, &
 & 0.17250E+00_JPRB,0.16494E+00_JPRB,0.16474E+00_JPRB,0.18189E+00_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.21706E+00_JPRB,0.19287E+00_JPRB,0.18835E+00_JPRB,0.18355E+00_JPRB,0.17627E+00_JPRB, &
 & 0.17161E+00_JPRB,0.16474E+00_JPRB,0.16398E+00_JPRB,0.18195E+00_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.21612E+00_JPRB,0.19181E+00_JPRB,0.18687E+00_JPRB,0.18213E+00_JPRB,0.17553E+00_JPRB, &
 & 0.17088E+00_JPRB,0.16425E+00_JPRB,0.16313E+00_JPRB,0.18152E+00_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.21478E+00_JPRB,0.19045E+00_JPRB,0.18500E+00_JPRB,0.18018E+00_JPRB,0.17440E+00_JPRB, &
 & 0.16996E+00_JPRB,0.16342E+00_JPRB,0.16188E+00_JPRB,0.18054E+00_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.21350E+00_JPRB,0.18909E+00_JPRB,0.18333E+00_JPRB,0.17782E+00_JPRB,0.17309E+00_JPRB, &
 & 0.16916E+00_JPRB,0.16213E+00_JPRB,0.16034E+00_JPRB,0.17917E+00_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.21342E+00_JPRB,0.19093E+00_JPRB,0.19390E+00_JPRB,0.18953E+00_JPRB,0.18412E+00_JPRB, &
 & 0.17932E+00_JPRB,0.17133E+00_JPRB,0.16726E+00_JPRB,0.18355E+00_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.21345E+00_JPRB,0.19062E+00_JPRB,0.19295E+00_JPRB,0.18836E+00_JPRB,0.18309E+00_JPRB, &
 & 0.17848E+00_JPRB,0.17069E+00_JPRB,0.16650E+00_JPRB,0.18323E+00_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.21341E+00_JPRB,0.18999E+00_JPRB,0.19180E+00_JPRB,0.18672E+00_JPRB,0.18231E+00_JPRB, &
 & 0.17805E+00_JPRB,0.16996E+00_JPRB,0.16523E+00_JPRB,0.18230E+00_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.21278E+00_JPRB,0.18888E+00_JPRB,0.19035E+00_JPRB,0.18488E+00_JPRB,0.18150E+00_JPRB, &
 & 0.17740E+00_JPRB,0.16888E+00_JPRB,0.16361E+00_JPRB,0.18086E+00_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.21199E+00_JPRB,0.18788E+00_JPRB,0.18853E+00_JPRB,0.18312E+00_JPRB,0.18053E+00_JPRB, &
 & 0.17647E+00_JPRB,0.16753E+00_JPRB,0.16185E+00_JPRB,0.17942E+00_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.20554E+00_JPRB,0.18880E+00_JPRB,0.19483E+00_JPRB,0.19351E+00_JPRB,0.18975E+00_JPRB, &
 & 0.18476E+00_JPRB,0.17703E+00_JPRB,0.16712E+00_JPRB,0.18079E+00_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.20652E+00_JPRB,0.18855E+00_JPRB,0.19393E+00_JPRB,0.19243E+00_JPRB,0.18938E+00_JPRB, &
 & 0.18427E+00_JPRB,0.17598E+00_JPRB,0.16627E+00_JPRB,0.18028E+00_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.20722E+00_JPRB,0.18798E+00_JPRB,0.19279E+00_JPRB,0.19112E+00_JPRB,0.18883E+00_JPRB, &
 & 0.18376E+00_JPRB,0.17458E+00_JPRB,0.16493E+00_JPRB,0.17920E+00_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.20704E+00_JPRB,0.18700E+00_JPRB,0.19152E+00_JPRB,0.18972E+00_JPRB,0.18818E+00_JPRB, &
 & 0.18325E+00_JPRB,0.17326E+00_JPRB,0.16331E+00_JPRB,0.17789E+00_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.20670E+00_JPRB,0.18595E+00_JPRB,0.18990E+00_JPRB,0.18822E+00_JPRB,0.18756E+00_JPRB, &
 & 0.18244E+00_JPRB,0.17179E+00_JPRB,0.16146E+00_JPRB,0.17654E+00_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.19482E+00_JPRB,0.18644E+00_JPRB,0.19372E+00_JPRB,0.19534E+00_JPRB,0.19341E+00_JPRB, &
 & 0.18978E+00_JPRB,0.17991E+00_JPRB,0.16480E+00_JPRB,0.17385E+00_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.19645E+00_JPRB,0.18662E+00_JPRB,0.19286E+00_JPRB,0.19499E+00_JPRB,0.19364E+00_JPRB, &
 & 0.18939E+00_JPRB,0.17872E+00_JPRB,0.16377E+00_JPRB,0.17323E+00_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.19752E+00_JPRB,0.18632E+00_JPRB,0.19176E+00_JPRB,0.19416E+00_JPRB,0.19361E+00_JPRB, &
 & 0.18898E+00_JPRB,0.17730E+00_JPRB,0.16248E+00_JPRB,0.17231E+00_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.19786E+00_JPRB,0.18535E+00_JPRB,0.19058E+00_JPRB,0.19340E+00_JPRB,0.19352E+00_JPRB, &
 & 0.18844E+00_JPRB,0.17582E+00_JPRB,0.16092E+00_JPRB,0.17110E+00_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.19827E+00_JPRB,0.18472E+00_JPRB,0.18922E+00_JPRB,0.19254E+00_JPRB,0.19302E+00_JPRB, &
 & 0.18739E+00_JPRB,0.17431E+00_JPRB,0.15936E+00_JPRB,0.17034E+00_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.18199E+00_JPRB,0.18200E+00_JPRB,0.19084E+00_JPRB,0.19456E+00_JPRB,0.19545E+00_JPRB, &
 & 0.19216E+00_JPRB,0.18018E+00_JPRB,0.16033E+00_JPRB,0.16333E+00_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.18402E+00_JPRB,0.18227E+00_JPRB,0.19032E+00_JPRB,0.19515E+00_JPRB,0.19643E+00_JPRB, &
 & 0.19212E+00_JPRB,0.17883E+00_JPRB,0.15954E+00_JPRB,0.16306E+00_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.18527E+00_JPRB,0.18204E+00_JPRB,0.18956E+00_JPRB,0.19541E+00_JPRB,0.19690E+00_JPRB, &
 & 0.19201E+00_JPRB,0.17754E+00_JPRB,0.15865E+00_JPRB,0.16240E+00_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.18597E+00_JPRB,0.18146E+00_JPRB,0.18866E+00_JPRB,0.19510E+00_JPRB,0.19689E+00_JPRB, &
 & 0.19145E+00_JPRB,0.17626E+00_JPRB,0.15729E+00_JPRB,0.16157E+00_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.18701E+00_JPRB,0.18150E+00_JPRB,0.18776E+00_JPRB,0.19449E+00_JPRB,0.19637E+00_JPRB, &
 & 0.19035E+00_JPRB,0.17490E+00_JPRB,0.15605E+00_JPRB,0.16154E+00_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.16786E+00_JPRB,0.17459E+00_JPRB,0.18572E+00_JPRB,0.19196E+00_JPRB,0.19497E+00_JPRB, &
 & 0.19093E+00_JPRB,0.17775E+00_JPRB,0.15445E+00_JPRB,0.12845E+00_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.16990E+00_JPRB,0.17470E+00_JPRB,0.18604E+00_JPRB,0.19354E+00_JPRB,0.19670E+00_JPRB, &
 & 0.19124E+00_JPRB,0.17643E+00_JPRB,0.15415E+00_JPRB,0.12953E+00_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.17115E+00_JPRB,0.17447E+00_JPRB,0.18577E+00_JPRB,0.19420E+00_JPRB,0.19734E+00_JPRB, &
 & 0.19133E+00_JPRB,0.17544E+00_JPRB,0.15343E+00_JPRB,0.13019E+00_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.17256E+00_JPRB,0.17421E+00_JPRB,0.18540E+00_JPRB,0.19426E+00_JPRB,0.19741E+00_JPRB, &
 & 0.19105E+00_JPRB,0.17463E+00_JPRB,0.15245E+00_JPRB,0.13135E+00_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.17411E+00_JPRB,0.17469E+00_JPRB,0.18532E+00_JPRB,0.19400E+00_JPRB,0.19690E+00_JPRB, &
 & 0.19024E+00_JPRB,0.17373E+00_JPRB,0.15177E+00_JPRB,0.13443E+00_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.15326E+00_JPRB,0.16530E+00_JPRB,0.17933E+00_JPRB,0.18873E+00_JPRB,0.19204E+00_JPRB, &
 & 0.18645E+00_JPRB,0.17157E+00_JPRB,0.14842E+00_JPRB,0.10906E+00_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.15510E+00_JPRB,0.16508E+00_JPRB,0.18002E+00_JPRB,0.19054E+00_JPRB,0.19337E+00_JPRB, &
 & 0.18697E+00_JPRB,0.17132E+00_JPRB,0.14823E+00_JPRB,0.10821E+00_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.15695E+00_JPRB,0.16517E+00_JPRB,0.18033E+00_JPRB,0.19125E+00_JPRB,0.19395E+00_JPRB, &
 & 0.18719E+00_JPRB,0.17114E+00_JPRB,0.14748E+00_JPRB,0.10735E+00_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.15884E+00_JPRB,0.16584E+00_JPRB,0.18066E+00_JPRB,0.19107E+00_JPRB,0.19386E+00_JPRB, &
 & 0.18714E+00_JPRB,0.17083E+00_JPRB,0.14679E+00_JPRB,0.10767E+00_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.16065E+00_JPRB,0.16693E+00_JPRB,0.18136E+00_JPRB,0.19090E+00_JPRB,0.19313E+00_JPRB, &
 & 0.18652E+00_JPRB,0.17043E+00_JPRB,0.14693E+00_JPRB,0.10852E+00_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.13812E+00_JPRB,0.15482E+00_JPRB,0.17200E+00_JPRB,0.18322E+00_JPRB,0.18516E+00_JPRB, &
 & 0.17855E+00_JPRB,0.16404E+00_JPRB,0.14149E+00_JPRB,0.85521E-01_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.14024E+00_JPRB,0.15523E+00_JPRB,0.17295E+00_JPRB,0.18464E+00_JPRB,0.18616E+00_JPRB, &
 & 0.17947E+00_JPRB,0.16474E+00_JPRB,0.14107E+00_JPRB,0.84251E-01_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.14232E+00_JPRB,0.15625E+00_JPRB,0.17374E+00_JPRB,0.18482E+00_JPRB,0.18666E+00_JPRB, &
 & 0.18015E+00_JPRB,0.16507E+00_JPRB,0.14067E+00_JPRB,0.83221E-01_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.14452E+00_JPRB,0.15760E+00_JPRB,0.17483E+00_JPRB,0.18482E+00_JPRB,0.18644E+00_JPRB, &
 & 0.18031E+00_JPRB,0.16530E+00_JPRB,0.14085E+00_JPRB,0.83052E-01_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.14659E+00_JPRB,0.15898E+00_JPRB,0.17608E+00_JPRB,0.18496E+00_JPRB,0.18608E+00_JPRB, &
 & 0.18007E+00_JPRB,0.16596E+00_JPRB,0.14156E+00_JPRB,0.86150E-01_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.12335E+00_JPRB,0.14397E+00_JPRB,0.16332E+00_JPRB,0.17403E+00_JPRB,0.17485E+00_JPRB, &
 & 0.16858E+00_JPRB,0.15532E+00_JPRB,0.13315E+00_JPRB,0.86982E-01_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.12553E+00_JPRB,0.14531E+00_JPRB,0.16473E+00_JPRB,0.17477E+00_JPRB,0.17593E+00_JPRB, &
 & 0.16998E+00_JPRB,0.15639E+00_JPRB,0.13322E+00_JPRB,0.83311E-01_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.12788E+00_JPRB,0.14705E+00_JPRB,0.16612E+00_JPRB,0.17511E+00_JPRB,0.17644E+00_JPRB, &
 & 0.17090E+00_JPRB,0.15730E+00_JPRB,0.13374E+00_JPRB,0.80969E-01_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.13027E+00_JPRB,0.14889E+00_JPRB,0.16746E+00_JPRB,0.17569E+00_JPRB,0.17660E+00_JPRB, &
 & 0.17136E+00_JPRB,0.15852E+00_JPRB,0.13468E+00_JPRB,0.79671E-01_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.13255E+00_JPRB,0.15069E+00_JPRB,0.16867E+00_JPRB,0.17661E+00_JPRB,0.17696E+00_JPRB, &
 & 0.17204E+00_JPRB,0.15992E+00_JPRB,0.13520E+00_JPRB,0.81334E-01_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.28721E+00_JPRB,0.25323E+00_JPRB,0.21917E+00_JPRB,0.19050E+00_JPRB,0.18439E+00_JPRB, &
 & 0.17842E+00_JPRB,0.17156E+00_JPRB,0.18245E+00_JPRB,0.20075E+00_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.28561E+00_JPRB,0.25177E+00_JPRB,0.21845E+00_JPRB,0.19052E+00_JPRB,0.18309E+00_JPRB, &
 & 0.17638E+00_JPRB,0.16966E+00_JPRB,0.18096E+00_JPRB,0.19965E+00_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.28230E+00_JPRB,0.24910E+00_JPRB,0.21697E+00_JPRB,0.19014E+00_JPRB,0.18233E+00_JPRB, &
 & 0.17414E+00_JPRB,0.16821E+00_JPRB,0.18034E+00_JPRB,0.19910E+00_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.27834E+00_JPRB,0.24592E+00_JPRB,0.21540E+00_JPRB,0.18935E+00_JPRB,0.18163E+00_JPRB, &
 & 0.17186E+00_JPRB,0.16739E+00_JPRB,0.18033E+00_JPRB,0.19922E+00_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.27434E+00_JPRB,0.24303E+00_JPRB,0.21391E+00_JPRB,0.18803E+00_JPRB,0.18019E+00_JPRB, &
 & 0.17025E+00_JPRB,0.16693E+00_JPRB,0.18042E+00_JPRB,0.19937E+00_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.29623E+00_JPRB,0.26097E+00_JPRB,0.22609E+00_JPRB,0.20293E+00_JPRB,0.20182E+00_JPRB, &
 & 0.19085E+00_JPRB,0.18240E+00_JPRB,0.19397E+00_JPRB,0.21604E+00_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.29432E+00_JPRB,0.25931E+00_JPRB,0.22539E+00_JPRB,0.20142E+00_JPRB,0.20026E+00_JPRB, &
 & 0.18828E+00_JPRB,0.18057E+00_JPRB,0.19299E+00_JPRB,0.21521E+00_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.29132E+00_JPRB,0.25712E+00_JPRB,0.22457E+00_JPRB,0.20070E+00_JPRB,0.19917E+00_JPRB, &
 & 0.18573E+00_JPRB,0.17946E+00_JPRB,0.19254E+00_JPRB,0.21482E+00_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.28797E+00_JPRB,0.25474E+00_JPRB,0.22345E+00_JPRB,0.19986E+00_JPRB,0.19780E+00_JPRB, &
 & 0.18370E+00_JPRB,0.17875E+00_JPRB,0.19238E+00_JPRB,0.21459E+00_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.28466E+00_JPRB,0.25242E+00_JPRB,0.22205E+00_JPRB,0.19838E+00_JPRB,0.19562E+00_JPRB, &
 & 0.18242E+00_JPRB,0.17806E+00_JPRB,0.19203E+00_JPRB,0.21421E+00_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.30561E+00_JPRB,0.26889E+00_JPRB,0.23295E+00_JPRB,0.21956E+00_JPRB,0.21717E+00_JPRB, &
 & 0.20307E+00_JPRB,0.19524E+00_JPRB,0.20742E+00_JPRB,0.23388E+00_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.30324E+00_JPRB,0.26704E+00_JPRB,0.23237E+00_JPRB,0.21738E+00_JPRB,0.21493E+00_JPRB, &
 & 0.20036E+00_JPRB,0.19375E+00_JPRB,0.20659E+00_JPRB,0.23304E+00_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.30058E+00_JPRB,0.26531E+00_JPRB,0.23190E+00_JPRB,0.21598E+00_JPRB,0.21300E+00_JPRB, &
 & 0.19790E+00_JPRB,0.19244E+00_JPRB,0.20627E+00_JPRB,0.23259E+00_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.29826E+00_JPRB,0.26386E+00_JPRB,0.23125E+00_JPRB,0.21516E+00_JPRB,0.21099E+00_JPRB, &
 & 0.19626E+00_JPRB,0.19135E+00_JPRB,0.20570E+00_JPRB,0.23176E+00_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.29569E+00_JPRB,0.26204E+00_JPRB,0.22972E+00_JPRB,0.21357E+00_JPRB,0.20846E+00_JPRB, &
 & 0.19500E+00_JPRB,0.19003E+00_JPRB,0.20504E+00_JPRB,0.23084E+00_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.31580E+00_JPRB,0.27765E+00_JPRB,0.24256E+00_JPRB,0.23825E+00_JPRB,0.23010E+00_JPRB, &
 & 0.21605E+00_JPRB,0.20908E+00_JPRB,0.22073E+00_JPRB,0.25027E+00_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.31385E+00_JPRB,0.27619E+00_JPRB,0.24143E+00_JPRB,0.23561E+00_JPRB,0.22732E+00_JPRB, &
 & 0.21355E+00_JPRB,0.20732E+00_JPRB,0.21997E+00_JPRB,0.24945E+00_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.31115E+00_JPRB,0.27450E+00_JPRB,0.24049E+00_JPRB,0.23383E+00_JPRB,0.22480E+00_JPRB, &
 & 0.21136E+00_JPRB,0.20583E+00_JPRB,0.21971E+00_JPRB,0.24898E+00_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.30851E+00_JPRB,0.27268E+00_JPRB,0.23896E+00_JPRB,0.23220E+00_JPRB,0.22243E+00_JPRB, &
 & 0.20992E+00_JPRB,0.20459E+00_JPRB,0.21945E+00_JPRB,0.24850E+00_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.30578E+00_JPRB,0.27071E+00_JPRB,0.23717E+00_JPRB,0.23033E+00_JPRB,0.22018E+00_JPRB, &
 & 0.20870E+00_JPRB,0.20353E+00_JPRB,0.21927E+00_JPRB,0.24814E+00_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.32525E+00_JPRB,0.28587E+00_JPRB,0.25583E+00_JPRB,0.25377E+00_JPRB,0.24260E+00_JPRB, &
 & 0.22945E+00_JPRB,0.22249E+00_JPRB,0.23280E+00_JPRB,0.26422E+00_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.32339E+00_JPRB,0.28450E+00_JPRB,0.25406E+00_JPRB,0.25143E+00_JPRB,0.23950E+00_JPRB, &
 & 0.22738E+00_JPRB,0.22044E+00_JPRB,0.23211E+00_JPRB,0.26348E+00_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.32075E+00_JPRB,0.28298E+00_JPRB,0.25200E+00_JPRB,0.24974E+00_JPRB,0.23665E+00_JPRB, &
 & 0.22565E+00_JPRB,0.21882E+00_JPRB,0.23178E+00_JPRB,0.26317E+00_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.31838E+00_JPRB,0.28134E+00_JPRB,0.24992E+00_JPRB,0.24807E+00_JPRB,0.23442E+00_JPRB, &
 & 0.22435E+00_JPRB,0.21780E+00_JPRB,0.23180E+00_JPRB,0.26307E+00_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.31581E+00_JPRB,0.27952E+00_JPRB,0.24774E+00_JPRB,0.24618E+00_JPRB,0.23239E+00_JPRB, &
 & 0.22315E+00_JPRB,0.21723E+00_JPRB,0.23168E+00_JPRB,0.26269E+00_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.33335E+00_JPRB,0.29286E+00_JPRB,0.27107E+00_JPRB,0.26707E+00_JPRB,0.25627E+00_JPRB, &
 & 0.24388E+00_JPRB,0.23516E+00_JPRB,0.24254E+00_JPRB,0.27495E+00_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.33185E+00_JPRB,0.29196E+00_JPRB,0.26927E+00_JPRB,0.26528E+00_JPRB,0.25338E+00_JPRB, &
 & 0.24199E+00_JPRB,0.23321E+00_JPRB,0.24178E+00_JPRB,0.27452E+00_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.32960E+00_JPRB,0.29070E+00_JPRB,0.26757E+00_JPRB,0.26387E+00_JPRB,0.25062E+00_JPRB, &
 & 0.24015E+00_JPRB,0.23158E+00_JPRB,0.24188E+00_JPRB,0.27485E+00_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.32714E+00_JPRB,0.28920E+00_JPRB,0.26543E+00_JPRB,0.26229E+00_JPRB,0.24828E+00_JPRB, &
 & 0.23863E+00_JPRB,0.23085E+00_JPRB,0.24191E+00_JPRB,0.27476E+00_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.32443E+00_JPRB,0.28722E+00_JPRB,0.26300E+00_JPRB,0.25993E+00_JPRB,0.24627E+00_JPRB, &
 & 0.23716E+00_JPRB,0.23011E+00_JPRB,0.24150E+00_JPRB,0.27410E+00_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.33805E+00_JPRB,0.29686E+00_JPRB,0.28577E+00_JPRB,0.27897E+00_JPRB,0.26998E+00_JPRB, &
 & 0.25892E+00_JPRB,0.24589E+00_JPRB,0.25046E+00_JPRB,0.28292E+00_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.33717E+00_JPRB,0.29673E+00_JPRB,0.28505E+00_JPRB,0.27748E+00_JPRB,0.26727E+00_JPRB, &
 & 0.25668E+00_JPRB,0.24439E+00_JPRB,0.24991E+00_JPRB,0.28315E+00_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.33582E+00_JPRB,0.29639E+00_JPRB,0.28414E+00_JPRB,0.27664E+00_JPRB,0.26503E+00_JPRB, &
 & 0.25454E+00_JPRB,0.24355E+00_JPRB,0.24982E+00_JPRB,0.28339E+00_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.33418E+00_JPRB,0.29565E+00_JPRB,0.28243E+00_JPRB,0.27502E+00_JPRB,0.26319E+00_JPRB, &
 & 0.25262E+00_JPRB,0.24314E+00_JPRB,0.24937E+00_JPRB,0.28297E+00_JPRB /)  
KA(:, 5, 7,12) = (/ &
 & 0.33223E+00_JPRB,0.29432E+00_JPRB,0.28036E+00_JPRB,0.27276E+00_JPRB,0.26126E+00_JPRB, &
 & 0.25114E+00_JPRB,0.24223E+00_JPRB,0.24874E+00_JPRB,0.28224E+00_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.33811E+00_JPRB,0.29881E+00_JPRB,0.29770E+00_JPRB,0.29087E+00_JPRB,0.28271E+00_JPRB, &
 & 0.27088E+00_JPRB,0.25606E+00_JPRB,0.25702E+00_JPRB,0.28869E+00_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.33858E+00_JPRB,0.29933E+00_JPRB,0.29817E+00_JPRB,0.28968E+00_JPRB,0.28063E+00_JPRB, &
 & 0.26913E+00_JPRB,0.25508E+00_JPRB,0.25647E+00_JPRB,0.28886E+00_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.33853E+00_JPRB,0.29979E+00_JPRB,0.29803E+00_JPRB,0.28900E+00_JPRB,0.27895E+00_JPRB, &
 & 0.26698E+00_JPRB,0.25454E+00_JPRB,0.25561E+00_JPRB,0.28857E+00_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.33786E+00_JPRB,0.29958E+00_JPRB,0.29705E+00_JPRB,0.28721E+00_JPRB,0.27754E+00_JPRB, &
 & 0.26522E+00_JPRB,0.25386E+00_JPRB,0.25480E+00_JPRB,0.28812E+00_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.33672E+00_JPRB,0.29874E+00_JPRB,0.29538E+00_JPRB,0.28492E+00_JPRB,0.27593E+00_JPRB, &
 & 0.26422E+00_JPRB,0.25288E+00_JPRB,0.25337E+00_JPRB,0.28657E+00_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.33304E+00_JPRB,0.29965E+00_JPRB,0.30451E+00_JPRB,0.30108E+00_JPRB,0.29380E+00_JPRB, &
 & 0.28100E+00_JPRB,0.26620E+00_JPRB,0.26062E+00_JPRB,0.28923E+00_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.33493E+00_JPRB,0.30099E+00_JPRB,0.30590E+00_JPRB,0.30051E+00_JPRB,0.29241E+00_JPRB, &
 & 0.27971E+00_JPRB,0.26553E+00_JPRB,0.25927E+00_JPRB,0.28890E+00_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.33639E+00_JPRB,0.30210E+00_JPRB,0.30672E+00_JPRB,0.29976E+00_JPRB,0.29135E+00_JPRB, &
 & 0.27789E+00_JPRB,0.26459E+00_JPRB,0.25779E+00_JPRB,0.28847E+00_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.33691E+00_JPRB,0.30238E+00_JPRB,0.30636E+00_JPRB,0.29831E+00_JPRB,0.29055E+00_JPRB, &
 & 0.27684E+00_JPRB,0.26372E+00_JPRB,0.25629E+00_JPRB,0.28756E+00_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.33680E+00_JPRB,0.30184E+00_JPRB,0.30474E+00_JPRB,0.29664E+00_JPRB,0.28906E+00_JPRB, &
 & 0.27593E+00_JPRB,0.26250E+00_JPRB,0.25436E+00_JPRB,0.28576E+00_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.32265E+00_JPRB,0.29931E+00_JPRB,0.30809E+00_JPRB,0.30788E+00_JPRB,0.30155E+00_JPRB, &
 & 0.29032E+00_JPRB,0.27398E+00_JPRB,0.25958E+00_JPRB,0.28232E+00_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.32643E+00_JPRB,0.30217E+00_JPRB,0.30992E+00_JPRB,0.30804E+00_JPRB,0.30109E+00_JPRB, &
 & 0.28947E+00_JPRB,0.27364E+00_JPRB,0.25761E+00_JPRB,0.28165E+00_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.32903E+00_JPRB,0.30409E+00_JPRB,0.31077E+00_JPRB,0.30846E+00_JPRB,0.30095E+00_JPRB, &
 & 0.28833E+00_JPRB,0.27259E+00_JPRB,0.25601E+00_JPRB,0.28124E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART9',0,ZHOOK_HANDLE)


KA(:, 4,10,12) = (/ &
 & 0.33021E+00_JPRB,0.30472E+00_JPRB,0.31062E+00_JPRB,0.30777E+00_JPRB,0.30050E+00_JPRB, &
 & 0.28725E+00_JPRB,0.27132E+00_JPRB,0.25418E+00_JPRB,0.28034E+00_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.33035E+00_JPRB,0.30379E+00_JPRB,0.30948E+00_JPRB,0.30647E+00_JPRB,0.29984E+00_JPRB, &
 & 0.28648E+00_JPRB,0.26959E+00_JPRB,0.25216E+00_JPRB,0.27891E+00_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.31092E+00_JPRB,0.29828E+00_JPRB,0.30944E+00_JPRB,0.31067E+00_JPRB,0.30618E+00_JPRB, &
 & 0.29698E+00_JPRB,0.27822E+00_JPRB,0.25367E+00_JPRB,0.20521E+00_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.31508E+00_JPRB,0.30179E+00_JPRB,0.31084E+00_JPRB,0.31247E+00_JPRB,0.30712E+00_JPRB, &
 & 0.29665E+00_JPRB,0.27717E+00_JPRB,0.25137E+00_JPRB,0.20791E+00_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.31745E+00_JPRB,0.30351E+00_JPRB,0.31148E+00_JPRB,0.31329E+00_JPRB,0.30764E+00_JPRB, &
 & 0.29592E+00_JPRB,0.27601E+00_JPRB,0.24946E+00_JPRB,0.21041E+00_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.31864E+00_JPRB,0.30345E+00_JPRB,0.31137E+00_JPRB,0.31328E+00_JPRB,0.30818E+00_JPRB, &
 & 0.29525E+00_JPRB,0.27444E+00_JPRB,0.24795E+00_JPRB,0.21312E+00_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.31936E+00_JPRB,0.30268E+00_JPRB,0.31034E+00_JPRB,0.31260E+00_JPRB,0.30827E+00_JPRB, &
 & 0.29465E+00_JPRB,0.27259E+00_JPRB,0.24615E+00_JPRB,0.21621E+00_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.29534E+00_JPRB,0.29381E+00_JPRB,0.30706E+00_JPRB,0.31081E+00_JPRB,0.30893E+00_JPRB, &
 & 0.29961E+00_JPRB,0.27811E+00_JPRB,0.24533E+00_JPRB,0.16496E+00_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.29914E+00_JPRB,0.29664E+00_JPRB,0.30890E+00_JPRB,0.31347E+00_JPRB,0.31102E+00_JPRB, &
 & 0.29958E+00_JPRB,0.27683E+00_JPRB,0.24361E+00_JPRB,0.16812E+00_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.30164E+00_JPRB,0.29790E+00_JPRB,0.30986E+00_JPRB,0.31529E+00_JPRB,0.31277E+00_JPRB, &
 & 0.29960E+00_JPRB,0.27547E+00_JPRB,0.24230E+00_JPRB,0.17163E+00_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.30318E+00_JPRB,0.29799E+00_JPRB,0.30963E+00_JPRB,0.31596E+00_JPRB,0.31358E+00_JPRB, &
 & 0.29964E+00_JPRB,0.27410E+00_JPRB,0.24090E+00_JPRB,0.17207E+00_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.30462E+00_JPRB,0.29774E+00_JPRB,0.30883E+00_JPRB,0.31580E+00_JPRB,0.31382E+00_JPRB, &
 & 0.29942E+00_JPRB,0.27289E+00_JPRB,0.23940E+00_JPRB,0.17248E+00_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.27646E+00_JPRB,0.28482E+00_JPRB,0.30092E+00_JPRB,0.30845E+00_JPRB,0.30839E+00_JPRB, &
 & 0.29721E+00_JPRB,0.27391E+00_JPRB,0.23566E+00_JPRB,0.13145E+00_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.28013E+00_JPRB,0.28703E+00_JPRB,0.30330E+00_JPRB,0.31210E+00_JPRB,0.31152E+00_JPRB, &
 & 0.29799E+00_JPRB,0.27265E+00_JPRB,0.23501E+00_JPRB,0.13680E+00_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.28251E+00_JPRB,0.28781E+00_JPRB,0.30455E+00_JPRB,0.31430E+00_JPRB,0.31342E+00_JPRB, &
 & 0.29883E+00_JPRB,0.27192E+00_JPRB,0.23420E+00_JPRB,0.14031E+00_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.28473E+00_JPRB,0.28806E+00_JPRB,0.30532E+00_JPRB,0.31558E+00_JPRB,0.31478E+00_JPRB, &
 & 0.29964E+00_JPRB,0.27140E+00_JPRB,0.23324E+00_JPRB,0.14138E+00_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.28731E+00_JPRB,0.28885E+00_JPRB,0.30563E+00_JPRB,0.31603E+00_JPRB,0.31529E+00_JPRB, &
 & 0.30003E+00_JPRB,0.27073E+00_JPRB,0.23300E+00_JPRB,0.14291E+00_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.39331E+00_JPRB,0.34536E+00_JPRB,0.29823E+00_JPRB,0.25200E+00_JPRB,0.22257E+00_JPRB, &
 & 0.22153E+00_JPRB,0.23263E+00_JPRB,0.25940E+00_JPRB,0.28372E+00_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.38484E+00_JPRB,0.33824E+00_JPRB,0.29242E+00_JPRB,0.24772E+00_JPRB,0.21768E+00_JPRB, &
 & 0.21972E+00_JPRB,0.23098E+00_JPRB,0.25833E+00_JPRB,0.28173E+00_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.37910E+00_JPRB,0.33360E+00_JPRB,0.28884E+00_JPRB,0.24475E+00_JPRB,0.21421E+00_JPRB, &
 & 0.21744E+00_JPRB,0.22823E+00_JPRB,0.25633E+00_JPRB,0.27932E+00_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.37406E+00_JPRB,0.32956E+00_JPRB,0.28576E+00_JPRB,0.24212E+00_JPRB,0.21151E+00_JPRB, &
 & 0.21463E+00_JPRB,0.22480E+00_JPRB,0.25354E+00_JPRB,0.27637E+00_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.36968E+00_JPRB,0.32602E+00_JPRB,0.28272E+00_JPRB,0.24026E+00_JPRB,0.20970E+00_JPRB, &
 & 0.21134E+00_JPRB,0.22163E+00_JPRB,0.25081E+00_JPRB,0.27385E+00_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.41602E+00_JPRB,0.36529E+00_JPRB,0.31527E+00_JPRB,0.26672E+00_JPRB,0.24637E+00_JPRB, &
 & 0.24718E+00_JPRB,0.25604E+00_JPRB,0.28585E+00_JPRB,0.31850E+00_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.40830E+00_JPRB,0.35891E+00_JPRB,0.31022E+00_JPRB,0.26338E+00_JPRB,0.24193E+00_JPRB, &
 & 0.24484E+00_JPRB,0.25382E+00_JPRB,0.28396E+00_JPRB,0.31574E+00_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.40220E+00_JPRB,0.35391E+00_JPRB,0.30635E+00_JPRB,0.26042E+00_JPRB,0.23856E+00_JPRB, &
 & 0.24224E+00_JPRB,0.25030E+00_JPRB,0.28140E+00_JPRB,0.31256E+00_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.39708E+00_JPRB,0.34976E+00_JPRB,0.30310E+00_JPRB,0.25764E+00_JPRB,0.23590E+00_JPRB, &
 & 0.23895E+00_JPRB,0.24655E+00_JPRB,0.27840E+00_JPRB,0.30929E+00_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.39199E+00_JPRB,0.34559E+00_JPRB,0.29962E+00_JPRB,0.25559E+00_JPRB,0.23369E+00_JPRB, &
 & 0.23517E+00_JPRB,0.24316E+00_JPRB,0.27577E+00_JPRB,0.30660E+00_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.43911E+00_JPRB,0.38551E+00_JPRB,0.33254E+00_JPRB,0.28548E+00_JPRB,0.27501E+00_JPRB, &
 & 0.27158E+00_JPRB,0.27806E+00_JPRB,0.30961E+00_JPRB,0.34942E+00_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.43165E+00_JPRB,0.37930E+00_JPRB,0.32763E+00_JPRB,0.28158E+00_JPRB,0.27135E+00_JPRB, &
 & 0.26881E+00_JPRB,0.27489E+00_JPRB,0.30725E+00_JPRB,0.34620E+00_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.42551E+00_JPRB,0.37419E+00_JPRB,0.32362E+00_JPRB,0.27772E+00_JPRB,0.26799E+00_JPRB, &
 & 0.26571E+00_JPRB,0.27096E+00_JPRB,0.30422E+00_JPRB,0.34240E+00_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.42038E+00_JPRB,0.37000E+00_JPRB,0.32049E+00_JPRB,0.27494E+00_JPRB,0.26498E+00_JPRB, &
 & 0.26183E+00_JPRB,0.26698E+00_JPRB,0.30136E+00_JPRB,0.33931E+00_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.41446E+00_JPRB,0.36533E+00_JPRB,0.31734E+00_JPRB,0.27304E+00_JPRB,0.26234E+00_JPRB, &
 & 0.25777E+00_JPRB,0.26380E+00_JPRB,0.29913E+00_JPRB,0.33705E+00_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.46241E+00_JPRB,0.40571E+00_JPRB,0.34961E+00_JPRB,0.30954E+00_JPRB,0.30425E+00_JPRB, &
 & 0.29507E+00_JPRB,0.29890E+00_JPRB,0.33301E+00_JPRB,0.37827E+00_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.45465E+00_JPRB,0.39923E+00_JPRB,0.34450E+00_JPRB,0.30510E+00_JPRB,0.30124E+00_JPRB, &
 & 0.29145E+00_JPRB,0.29516E+00_JPRB,0.32984E+00_JPRB,0.37410E+00_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.44872E+00_JPRB,0.39432E+00_JPRB,0.34072E+00_JPRB,0.30104E+00_JPRB,0.29841E+00_JPRB, &
 & 0.28758E+00_JPRB,0.29090E+00_JPRB,0.32641E+00_JPRB,0.36986E+00_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.44350E+00_JPRB,0.39014E+00_JPRB,0.33810E+00_JPRB,0.29814E+00_JPRB,0.29548E+00_JPRB, &
 & 0.28294E+00_JPRB,0.28676E+00_JPRB,0.32342E+00_JPRB,0.36667E+00_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.43828E+00_JPRB,0.38609E+00_JPRB,0.33570E+00_JPRB,0.29627E+00_JPRB,0.29269E+00_JPRB, &
 & 0.27870E+00_JPRB,0.28357E+00_JPRB,0.32115E+00_JPRB,0.36426E+00_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.48784E+00_JPRB,0.42784E+00_JPRB,0.36835E+00_JPRB,0.33984E+00_JPRB,0.33294E+00_JPRB, &
 & 0.31846E+00_JPRB,0.32126E+00_JPRB,0.35651E+00_JPRB,0.40621E+00_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.48030E+00_JPRB,0.42153E+00_JPRB,0.36340E+00_JPRB,0.33519E+00_JPRB,0.32973E+00_JPRB, &
 & 0.31380E+00_JPRB,0.31683E+00_JPRB,0.35311E+00_JPRB,0.40187E+00_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.47411E+00_JPRB,0.41636E+00_JPRB,0.35974E+00_JPRB,0.33136E+00_JPRB,0.32664E+00_JPRB, &
 & 0.30892E+00_JPRB,0.31220E+00_JPRB,0.34964E+00_JPRB,0.39763E+00_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.46883E+00_JPRB,0.41227E+00_JPRB,0.35745E+00_JPRB,0.32776E+00_JPRB,0.32317E+00_JPRB, &
 & 0.30393E+00_JPRB,0.30777E+00_JPRB,0.34651E+00_JPRB,0.39440E+00_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.46388E+00_JPRB,0.40844E+00_JPRB,0.35543E+00_JPRB,0.32520E+00_JPRB,0.31964E+00_JPRB, &
 & 0.29971E+00_JPRB,0.30439E+00_JPRB,0.34429E+00_JPRB,0.39205E+00_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.51535E+00_JPRB,0.45180E+00_JPRB,0.39162E+00_JPRB,0.37322E+00_JPRB,0.36050E+00_JPRB, &
 & 0.34300E+00_JPRB,0.34505E+00_JPRB,0.38137E+00_JPRB,0.43538E+00_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.50781E+00_JPRB,0.44545E+00_JPRB,0.38586E+00_JPRB,0.36868E+00_JPRB,0.35573E+00_JPRB, &
 & 0.33760E+00_JPRB,0.34025E+00_JPRB,0.37783E+00_JPRB,0.43095E+00_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.50139E+00_JPRB,0.44011E+00_JPRB,0.38148E+00_JPRB,0.36480E+00_JPRB,0.35183E+00_JPRB, &
 & 0.33217E+00_JPRB,0.33546E+00_JPRB,0.37434E+00_JPRB,0.42674E+00_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.49657E+00_JPRB,0.43636E+00_JPRB,0.37891E+00_JPRB,0.36116E+00_JPRB,0.34800E+00_JPRB, &
 & 0.32704E+00_JPRB,0.33102E+00_JPRB,0.37152E+00_JPRB,0.42385E+00_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.49171E+00_JPRB,0.43263E+00_JPRB,0.37693E+00_JPRB,0.35827E+00_JPRB,0.34376E+00_JPRB, &
 & 0.32320E+00_JPRB,0.32782E+00_JPRB,0.36976E+00_JPRB,0.42188E+00_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.54162E+00_JPRB,0.47464E+00_JPRB,0.41834E+00_JPRB,0.40782E+00_JPRB,0.38721E+00_JPRB, &
 & 0.36824E+00_JPRB,0.37067E+00_JPRB,0.40670E+00_JPRB,0.46460E+00_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.53535E+00_JPRB,0.46937E+00_JPRB,0.41220E+00_JPRB,0.40296E+00_JPRB,0.38145E+00_JPRB, &
 & 0.36278E+00_JPRB,0.36581E+00_JPRB,0.40309E+00_JPRB,0.46013E+00_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.52914E+00_JPRB,0.46429E+00_JPRB,0.40710E+00_JPRB,0.39788E+00_JPRB,0.37673E+00_JPRB, &
 & 0.35819E+00_JPRB,0.36078E+00_JPRB,0.40008E+00_JPRB,0.45678E+00_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.52440E+00_JPRB,0.46050E+00_JPRB,0.40384E+00_JPRB,0.39374E+00_JPRB,0.37204E+00_JPRB, &
 & 0.35371E+00_JPRB,0.35616E+00_JPRB,0.39775E+00_JPRB,0.45424E+00_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.52017E+00_JPRB,0.45722E+00_JPRB,0.40132E+00_JPRB,0.39030E+00_JPRB,0.36733E+00_JPRB, &
 & 0.34991E+00_JPRB,0.35252E+00_JPRB,0.39600E+00_JPRB,0.45213E+00_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.56560E+00_JPRB,0.49547E+00_JPRB,0.44792E+00_JPRB,0.43980E+00_JPRB,0.41568E+00_JPRB, &
 & 0.39571E+00_JPRB,0.39516E+00_JPRB,0.42687E+00_JPRB,0.48767E+00_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.55986E+00_JPRB,0.49068E+00_JPRB,0.44130E+00_JPRB,0.43344E+00_JPRB,0.40921E+00_JPRB, &
 & 0.39033E+00_JPRB,0.39006E+00_JPRB,0.42429E+00_JPRB,0.48458E+00_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.55439E+00_JPRB,0.48622E+00_JPRB,0.43604E+00_JPRB,0.42727E+00_JPRB,0.40340E+00_JPRB, &
 & 0.38637E+00_JPRB,0.38517E+00_JPRB,0.42255E+00_JPRB,0.48243E+00_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.55085E+00_JPRB,0.48344E+00_JPRB,0.43251E+00_JPRB,0.42285E+00_JPRB,0.39791E+00_JPRB, &
 & 0.38219E+00_JPRB,0.38096E+00_JPRB,0.42076E+00_JPRB,0.48039E+00_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.54722E+00_JPRB,0.48060E+00_JPRB,0.42969E+00_JPRB,0.41964E+00_JPRB,0.39283E+00_JPRB, &
 & 0.37840E+00_JPRB,0.37699E+00_JPRB,0.41955E+00_JPRB,0.47894E+00_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.58672E+00_JPRB,0.51388E+00_JPRB,0.47909E+00_JPRB,0.46769E+00_JPRB,0.44479E+00_JPRB, &
 & 0.42421E+00_JPRB,0.41694E+00_JPRB,0.44339E+00_JPRB,0.50662E+00_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.58159E+00_JPRB,0.50951E+00_JPRB,0.47213E+00_JPRB,0.46028E+00_JPRB,0.43736E+00_JPRB, &
 & 0.41895E+00_JPRB,0.41246E+00_JPRB,0.44257E+00_JPRB,0.50550E+00_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.57736E+00_JPRB,0.50610E+00_JPRB,0.46657E+00_JPRB,0.45431E+00_JPRB,0.43100E+00_JPRB, &
 & 0.41543E+00_JPRB,0.40868E+00_JPRB,0.44206E+00_JPRB,0.50480E+00_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.57459E+00_JPRB,0.50394E+00_JPRB,0.46330E+00_JPRB,0.44994E+00_JPRB,0.42562E+00_JPRB, &
 & 0.41143E+00_JPRB,0.40432E+00_JPRB,0.44089E+00_JPRB,0.50333E+00_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.57136E+00_JPRB,0.50148E+00_JPRB,0.46136E+00_JPRB,0.44665E+00_JPRB,0.42115E+00_JPRB, &
 & 0.40792E+00_JPRB,0.40001E+00_JPRB,0.43966E+00_JPRB,0.50186E+00_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.60279E+00_JPRB,0.52914E+00_JPRB,0.50725E+00_JPRB,0.49385E+00_JPRB,0.47296E+00_JPRB, &
 & 0.45056E+00_JPRB,0.43650E+00_JPRB,0.45649E+00_JPRB,0.52069E+00_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.59826E+00_JPRB,0.52452E+00_JPRB,0.50048E+00_JPRB,0.48635E+00_JPRB,0.46511E+00_JPRB, &
 & 0.44618E+00_JPRB,0.43278E+00_JPRB,0.45737E+00_JPRB,0.52170E+00_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.59590E+00_JPRB,0.52228E+00_JPRB,0.49610E+00_JPRB,0.47997E+00_JPRB,0.45903E+00_JPRB, &
 & 0.44309E+00_JPRB,0.42962E+00_JPRB,0.45759E+00_JPRB,0.52208E+00_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.59454E+00_JPRB,0.52120E+00_JPRB,0.49388E+00_JPRB,0.47548E+00_JPRB,0.45447E+00_JPRB, &
 & 0.44006E+00_JPRB,0.42512E+00_JPRB,0.45631E+00_JPRB,0.52061E+00_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.59357E+00_JPRB,0.52070E+00_JPRB,0.49246E+00_JPRB,0.47250E+00_JPRB,0.45028E+00_JPRB, &
 & 0.43610E+00_JPRB,0.42114E+00_JPRB,0.45529E+00_JPRB,0.51951E+00_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.60887E+00_JPRB,0.53839E+00_JPRB,0.52807E+00_JPRB,0.51587E+00_JPRB,0.49623E+00_JPRB, &
 & 0.47362E+00_JPRB,0.45440E+00_JPRB,0.46645E+00_JPRB,0.53001E+00_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.60756E+00_JPRB,0.53578E+00_JPRB,0.52411E+00_JPRB,0.50806E+00_JPRB,0.48992E+00_JPRB, &
 & 0.47089E+00_JPRB,0.45204E+00_JPRB,0.46808E+00_JPRB,0.53215E+00_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.60793E+00_JPRB,0.53524E+00_JPRB,0.52214E+00_JPRB,0.50280E+00_JPRB,0.48540E+00_JPRB, &
 & 0.46881E+00_JPRB,0.44770E+00_JPRB,0.46764E+00_JPRB,0.53195E+00_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.60970E+00_JPRB,0.53618E+00_JPRB,0.52106E+00_JPRB,0.49960E+00_JPRB,0.48160E+00_JPRB, &
 & 0.46481E+00_JPRB,0.44371E+00_JPRB,0.46667E+00_JPRB,0.53096E+00_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.61038E+00_JPRB,0.53650E+00_JPRB,0.52014E+00_JPRB,0.49804E+00_JPRB,0.47818E+00_JPRB, &
 & 0.45984E+00_JPRB,0.44017E+00_JPRB,0.46579E+00_JPRB,0.53008E+00_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.60957E+00_JPRB,0.54609E+00_JPRB,0.54565E+00_JPRB,0.53521E+00_JPRB,0.51779E+00_JPRB, &
 & 0.49593E+00_JPRB,0.47189E+00_JPRB,0.47309E+00_JPRB,0.46983E+00_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.61214E+00_JPRB,0.54625E+00_JPRB,0.54367E+00_JPRB,0.52921E+00_JPRB,0.51339E+00_JPRB, &
 & 0.49443E+00_JPRB,0.46946E+00_JPRB,0.47371E+00_JPRB,0.47545E+00_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.61642E+00_JPRB,0.54787E+00_JPRB,0.54269E+00_JPRB,0.52579E+00_JPRB,0.50981E+00_JPRB, &
 & 0.49118E+00_JPRB,0.46605E+00_JPRB,0.47265E+00_JPRB,0.47706E+00_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.62028E+00_JPRB,0.54980E+00_JPRB,0.54303E+00_JPRB,0.52440E+00_JPRB,0.50697E+00_JPRB, &
 & 0.48619E+00_JPRB,0.46182E+00_JPRB,0.47123E+00_JPRB,0.48084E+00_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.62175E+00_JPRB,0.55026E+00_JPRB,0.54305E+00_JPRB,0.52373E+00_JPRB,0.50407E+00_JPRB, &
 & 0.48153E+00_JPRB,0.45738E+00_JPRB,0.46998E+00_JPRB,0.48415E+00_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.60459E+00_JPRB,0.55304E+00_JPRB,0.55845E+00_JPRB,0.55195E+00_JPRB,0.53769E+00_JPRB, &
 & 0.51606E+00_JPRB,0.48661E+00_JPRB,0.47383E+00_JPRB,0.40484E+00_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.61134E+00_JPRB,0.55569E+00_JPRB,0.55809E+00_JPRB,0.54885E+00_JPRB,0.53426E+00_JPRB, &
 & 0.51450E+00_JPRB,0.48473E+00_JPRB,0.47289E+00_JPRB,0.40823E+00_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.61890E+00_JPRB,0.55963E+00_JPRB,0.55924E+00_JPRB,0.54802E+00_JPRB,0.53230E+00_JPRB, &
 & 0.51039E+00_JPRB,0.48075E+00_JPRB,0.47078E+00_JPRB,0.41355E+00_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.62388E+00_JPRB,0.56213E+00_JPRB,0.56099E+00_JPRB,0.54740E+00_JPRB,0.52999E+00_JPRB, &
 & 0.50582E+00_JPRB,0.47603E+00_JPRB,0.46901E+00_JPRB,0.41977E+00_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.62688E+00_JPRB,0.56314E+00_JPRB,0.56152E+00_JPRB,0.54685E+00_JPRB,0.52723E+00_JPRB, &
 & 0.50138E+00_JPRB,0.47115E+00_JPRB,0.46700E+00_JPRB,0.42405E+00_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.52445E+00_JPRB,0.46003E+00_JPRB,0.39566E+00_JPRB,0.33139E+00_JPRB,0.26995E+00_JPRB, &
 & 0.25837E+00_JPRB,0.28528E+00_JPRB,0.32819E+00_JPRB,0.35568E+00_JPRB /)  
KA(:, 2, 1,14) = (/ &
 & 0.51513E+00_JPRB,0.45183E+00_JPRB,0.38858E+00_JPRB,0.32553E+00_JPRB,0.26784E+00_JPRB, &
 & 0.25515E+00_JPRB,0.28229E+00_JPRB,0.32456E+00_JPRB,0.35149E+00_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.50548E+00_JPRB,0.44334E+00_JPRB,0.38125E+00_JPRB,0.32054E+00_JPRB,0.26590E+00_JPRB, &
 & 0.25305E+00_JPRB,0.28136E+00_JPRB,0.32218E+00_JPRB,0.34858E+00_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.49563E+00_JPRB,0.43466E+00_JPRB,0.37374E+00_JPRB,0.31559E+00_JPRB,0.26350E+00_JPRB, &
 & 0.25115E+00_JPRB,0.28088E+00_JPRB,0.32077E+00_JPRB,0.34651E+00_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.48636E+00_JPRB,0.42650E+00_JPRB,0.36724E+00_JPRB,0.31119E+00_JPRB,0.26146E+00_JPRB, &
 & 0.24908E+00_JPRB,0.27907E+00_JPRB,0.31920E+00_JPRB,0.34392E+00_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.56575E+00_JPRB,0.49609E+00_JPRB,0.42647E+00_JPRB,0.35691E+00_JPRB,0.29788E+00_JPRB, &
 & 0.29937E+00_JPRB,0.33584E+00_JPRB,0.38701E+00_JPRB,0.42822E+00_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.55481E+00_JPRB,0.48648E+00_JPRB,0.41819E+00_JPRB,0.35023E+00_JPRB,0.29393E+00_JPRB, &
 & 0.29578E+00_JPRB,0.33190E+00_JPRB,0.38233E+00_JPRB,0.42282E+00_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.54468E+00_JPRB,0.47756E+00_JPRB,0.41048E+00_JPRB,0.34498E+00_JPRB,0.29076E+00_JPRB, &
 & 0.29330E+00_JPRB,0.33000E+00_JPRB,0.37899E+00_JPRB,0.41892E+00_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.53444E+00_JPRB,0.46857E+00_JPRB,0.40281E+00_JPRB,0.34010E+00_JPRB,0.28772E+00_JPRB, &
 & 0.29117E+00_JPRB,0.32899E+00_JPRB,0.37674E+00_JPRB,0.41581E+00_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.52472E+00_JPRB,0.46000E+00_JPRB,0.39601E+00_JPRB,0.33543E+00_JPRB,0.28544E+00_JPRB, &
 & 0.28841E+00_JPRB,0.32728E+00_JPRB,0.37488E+00_JPRB,0.41300E+00_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.61401E+00_JPRB,0.53826E+00_JPRB,0.46254E+00_JPRB,0.38687E+00_JPRB,0.33653E+00_JPRB, &
 & 0.34874E+00_JPRB,0.39278E+00_JPRB,0.45331E+00_JPRB,0.51178E+00_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.60181E+00_JPRB,0.52754E+00_JPRB,0.45329E+00_JPRB,0.37917E+00_JPRB,0.33018E+00_JPRB, &
 & 0.34432E+00_JPRB,0.38762E+00_JPRB,0.44735E+00_JPRB,0.50487E+00_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.59018E+00_JPRB,0.51732E+00_JPRB,0.44448E+00_JPRB,0.37278E+00_JPRB,0.32516E+00_JPRB, &
 & 0.34086E+00_JPRB,0.38493E+00_JPRB,0.44336E+00_JPRB,0.50014E+00_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.57893E+00_JPRB,0.50743E+00_JPRB,0.43595E+00_JPRB,0.36714E+00_JPRB,0.32113E+00_JPRB, &
 & 0.33824E+00_JPRB,0.38315E+00_JPRB,0.44016E+00_JPRB,0.49598E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART10',0,ZHOOK_HANDLE)


KA(:, 5, 3,14) = (/ &
 & 0.56842E+00_JPRB,0.49818E+00_JPRB,0.42822E+00_JPRB,0.36203E+00_JPRB,0.31748E+00_JPRB, &
 & 0.33494E+00_JPRB,0.38145E+00_JPRB,0.43774E+00_JPRB,0.49238E+00_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.66683E+00_JPRB,0.58444E+00_JPRB,0.50208E+00_JPRB,0.41977E+00_JPRB,0.38494E+00_JPRB, &
 & 0.40485E+00_JPRB,0.45417E+00_JPRB,0.52508E+00_JPRB,0.59839E+00_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.65354E+00_JPRB,0.57275E+00_JPRB,0.49199E+00_JPRB,0.41128E+00_JPRB,0.37591E+00_JPRB, &
 & 0.39916E+00_JPRB,0.44835E+00_JPRB,0.51820E+00_JPRB,0.59043E+00_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.64071E+00_JPRB,0.56148E+00_JPRB,0.48227E+00_JPRB,0.40388E+00_JPRB,0.36879E+00_JPRB, &
 & 0.39404E+00_JPRB,0.44465E+00_JPRB,0.51320E+00_JPRB,0.58464E+00_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.62844E+00_JPRB,0.55070E+00_JPRB,0.47297E+00_JPRB,0.39753E+00_JPRB,0.36329E+00_JPRB, &
 & 0.39017E+00_JPRB,0.44183E+00_JPRB,0.50881E+00_JPRB,0.57888E+00_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.61748E+00_JPRB,0.54106E+00_JPRB,0.46467E+00_JPRB,0.39213E+00_JPRB,0.35832E+00_JPRB, &
 & 0.38631E+00_JPRB,0.43926E+00_JPRB,0.50522E+00_JPRB,0.57403E+00_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.72260E+00_JPRB,0.63317E+00_JPRB,0.54375E+00_JPRB,0.45913E+00_JPRB,0.43732E+00_JPRB, &
 & 0.46505E+00_JPRB,0.51783E+00_JPRB,0.59954E+00_JPRB,0.68564E+00_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.70858E+00_JPRB,0.62085E+00_JPRB,0.53314E+00_JPRB,0.44897E+00_JPRB,0.42823E+00_JPRB, &
 & 0.45720E+00_JPRB,0.51115E+00_JPRB,0.59162E+00_JPRB,0.67653E+00_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.69539E+00_JPRB,0.60926E+00_JPRB,0.52314E+00_JPRB,0.43994E+00_JPRB,0.42099E+00_JPRB, &
 & 0.45017E+00_JPRB,0.50656E+00_JPRB,0.58542E+00_JPRB,0.66941E+00_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.68235E+00_JPRB,0.59780E+00_JPRB,0.51326E+00_JPRB,0.43281E+00_JPRB,0.41557E+00_JPRB, &
 & 0.44468E+00_JPRB,0.50258E+00_JPRB,0.57996E+00_JPRB,0.66206E+00_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.67018E+00_JPRB,0.58711E+00_JPRB,0.50404E+00_JPRB,0.42628E+00_JPRB,0.41131E+00_JPRB, &
 & 0.43975E+00_JPRB,0.49863E+00_JPRB,0.57477E+00_JPRB,0.65556E+00_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.77964E+00_JPRB,0.68298E+00_JPRB,0.58633E+00_JPRB,0.50766E+00_JPRB,0.49641E+00_JPRB, &
 & 0.52605E+00_JPRB,0.58161E+00_JPRB,0.67425E+00_JPRB,0.77212E+00_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.76589E+00_JPRB,0.67092E+00_JPRB,0.57596E+00_JPRB,0.49531E+00_JPRB,0.48834E+00_JPRB, &
 & 0.51573E+00_JPRB,0.57361E+00_JPRB,0.66493E+00_JPRB,0.76124E+00_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.75251E+00_JPRB,0.65917E+00_JPRB,0.56583E+00_JPRB,0.48459E+00_JPRB,0.48115E+00_JPRB, &
 & 0.50704E+00_JPRB,0.56757E+00_JPRB,0.65686E+00_JPRB,0.75182E+00_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.73905E+00_JPRB,0.64728E+00_JPRB,0.55554E+00_JPRB,0.47565E+00_JPRB,0.47497E+00_JPRB, &
 & 0.50004E+00_JPRB,0.56191E+00_JPRB,0.64957E+00_JPRB,0.74243E+00_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.72636E+00_JPRB,0.63608E+00_JPRB,0.54581E+00_JPRB,0.46758E+00_JPRB,0.47009E+00_JPRB, &
 & 0.49349E+00_JPRB,0.55635E+00_JPRB,0.64252E+00_JPRB,0.73397E+00_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.84113E+00_JPRB,0.73668E+00_JPRB,0.63225E+00_JPRB,0.56459E+00_JPRB,0.56168E+00_JPRB, &
 & 0.58736E+00_JPRB,0.64476E+00_JPRB,0.74759E+00_JPRB,0.85655E+00_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.82630E+00_JPRB,0.72365E+00_JPRB,0.62103E+00_JPRB,0.55091E+00_JPRB,0.55367E+00_JPRB, &
 & 0.57467E+00_JPRB,0.63457E+00_JPRB,0.73605E+00_JPRB,0.84323E+00_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.81279E+00_JPRB,0.71173E+00_JPRB,0.61068E+00_JPRB,0.53944E+00_JPRB,0.54564E+00_JPRB, &
 & 0.56363E+00_JPRB,0.62610E+00_JPRB,0.72557E+00_JPRB,0.83073E+00_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.79922E+00_JPRB,0.69978E+00_JPRB,0.60035E+00_JPRB,0.52974E+00_JPRB,0.53833E+00_JPRB, &
 & 0.55444E+00_JPRB,0.61857E+00_JPRB,0.71625E+00_JPRB,0.81942E+00_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.78598E+00_JPRB,0.68814E+00_JPRB,0.59031E+00_JPRB,0.52130E+00_JPRB,0.53249E+00_JPRB, &
 & 0.54592E+00_JPRB,0.61225E+00_JPRB,0.70842E+00_JPRB,0.80994E+00_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.90865E+00_JPRB,0.79552E+00_JPRB,0.68301E+00_JPRB,0.62894E+00_JPRB,0.62980E+00_JPRB, &
 & 0.64956E+00_JPRB,0.70917E+00_JPRB,0.82179E+00_JPRB,0.94167E+00_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.89327E+00_JPRB,0.78202E+00_JPRB,0.67089E+00_JPRB,0.61713E+00_JPRB,0.62095E+00_JPRB, &
 & 0.63402E+00_JPRB,0.69617E+00_JPRB,0.80717E+00_JPRB,0.92484E+00_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.87903E+00_JPRB,0.76952E+00_JPRB,0.66001E+00_JPRB,0.60628E+00_JPRB,0.61235E+00_JPRB, &
 & 0.62019E+00_JPRB,0.68531E+00_JPRB,0.79440E+00_JPRB,0.90974E+00_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.86460E+00_JPRB,0.75687E+00_JPRB,0.64914E+00_JPRB,0.59649E+00_JPRB,0.60349E+00_JPRB, &
 & 0.60828E+00_JPRB,0.67580E+00_JPRB,0.78318E+00_JPRB,0.89639E+00_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.85091E+00_JPRB,0.74488E+00_JPRB,0.63886E+00_JPRB,0.58665E+00_JPRB,0.59566E+00_JPRB, &
 & 0.59754E+00_JPRB,0.66827E+00_JPRB,0.77422E+00_JPRB,0.88585E+00_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.98149E+00_JPRB,0.85912E+00_JPRB,0.74373E+00_JPRB,0.70295E+00_JPRB,0.70214E+00_JPRB, &
 & 0.71285E+00_JPRB,0.77237E+00_JPRB,0.89352E+00_JPRB,0.10239E+01_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.96640E+00_JPRB,0.84589E+00_JPRB,0.73081E+00_JPRB,0.69152E+00_JPRB,0.69170E+00_JPRB, &
 & 0.69439E+00_JPRB,0.75605E+00_JPRB,0.87558E+00_JPRB,0.10032E+01_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.95188E+00_JPRB,0.83316E+00_JPRB,0.71892E+00_JPRB,0.68080E+00_JPRB,0.68028E+00_JPRB, &
 & 0.67751E+00_JPRB,0.74271E+00_JPRB,0.86004E+00_JPRB,0.98493E+00_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.93737E+00_JPRB,0.82045E+00_JPRB,0.70700E+00_JPRB,0.67076E+00_JPRB,0.66785E+00_JPRB, &
 & 0.66265E+00_JPRB,0.73184E+00_JPRB,0.84775E+00_JPRB,0.97055E+00_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.92346E+00_JPRB,0.80828E+00_JPRB,0.69536E+00_JPRB,0.66047E+00_JPRB,0.65652E+00_JPRB, &
 & 0.65000E+00_JPRB,0.72388E+00_JPRB,0.83863E+00_JPRB,0.95986E+00_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.10577E+01_JPRB,0.92576E+00_JPRB,0.81364E+00_JPRB,0.78190E+00_JPRB,0.77617E+00_JPRB, &
 & 0.77603E+00_JPRB,0.83269E+00_JPRB,0.96109E+00_JPRB,0.11008E+01_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.10450E+01_JPRB,0.91463E+00_JPRB,0.80097E+00_JPRB,0.77046E+00_JPRB,0.76182E+00_JPRB, &
 & 0.75411E+00_JPRB,0.81384E+00_JPRB,0.94032E+00_JPRB,0.10769E+01_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.10312E+01_JPRB,0.90248E+00_JPRB,0.78812E+00_JPRB,0.75969E+00_JPRB,0.74632E+00_JPRB, &
 & 0.73436E+00_JPRB,0.79822E+00_JPRB,0.92300E+00_JPRB,0.10571E+01_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.10164E+01_JPRB,0.88956E+00_JPRB,0.77444E+00_JPRB,0.74952E+00_JPRB,0.73099E+00_JPRB, &
 & 0.71729E+00_JPRB,0.78702E+00_JPRB,0.91062E+00_JPRB,0.10426E+01_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.10010E+01_JPRB,0.87610E+00_JPRB,0.76045E+00_JPRB,0.73747E+00_JPRB,0.71669E+00_JPRB, &
 & 0.70419E+00_JPRB,0.77819E+00_JPRB,0.90060E+00_JPRB,0.10309E+01_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.11332E+01_JPRB,0.99169E+00_JPRB,0.88520E+00_JPRB,0.85938E+00_JPRB,0.84171E+00_JPRB, &
 & 0.82777E+00_JPRB,0.88045E+00_JPRB,0.10119E+01_JPRB,0.11581E+01_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.11221E+01_JPRB,0.98196E+00_JPRB,0.87210E+00_JPRB,0.84745E+00_JPRB,0.82287E+00_JPRB, &
 & 0.80383E+00_JPRB,0.86097E+00_JPRB,0.99198E+00_JPRB,0.11355E+01_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.11079E+01_JPRB,0.96953E+00_JPRB,0.85745E+00_JPRB,0.83492E+00_JPRB,0.80465E+00_JPRB, &
 & 0.78293E+00_JPRB,0.84710E+00_JPRB,0.97731E+00_JPRB,0.11185E+01_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.10888E+01_JPRB,0.95287E+00_JPRB,0.84018E+00_JPRB,0.82112E+00_JPRB,0.78666E+00_JPRB, &
 & 0.76752E+00_JPRB,0.83583E+00_JPRB,0.96514E+00_JPRB,0.11044E+01_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.10701E+01_JPRB,0.93668E+00_JPRB,0.82311E+00_JPRB,0.80490E+00_JPRB,0.77024E+00_JPRB, &
 & 0.75616E+00_JPRB,0.82679E+00_JPRB,0.95569E+00_JPRB,0.10935E+01_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.12101E+01_JPRB,0.10589E+01_JPRB,0.96254E+00_JPRB,0.93478E+00_JPRB,0.90424E+00_JPRB, &
 & 0.88111E+00_JPRB,0.92612E+00_JPRB,0.10566E+01_JPRB,0.12084E+01_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.11952E+01_JPRB,0.10459E+01_JPRB,0.94639E+00_JPRB,0.91979E+00_JPRB,0.88299E+00_JPRB, &
 & 0.85667E+00_JPRB,0.90737E+00_JPRB,0.10393E+01_JPRB,0.11885E+01_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.11758E+01_JPRB,0.10290E+01_JPRB,0.92827E+00_JPRB,0.90412E+00_JPRB,0.86234E+00_JPRB, &
 & 0.83719E+00_JPRB,0.89320E+00_JPRB,0.10260E+01_JPRB,0.11732E+01_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.11552E+01_JPRB,0.10111E+01_JPRB,0.90821E+00_JPRB,0.88659E+00_JPRB,0.84346E+00_JPRB, &
 & 0.82327E+00_JPRB,0.88324E+00_JPRB,0.10165E+01_JPRB,0.11624E+01_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.11370E+01_JPRB,0.99527E+00_JPRB,0.88941E+00_JPRB,0.86803E+00_JPRB,0.82686E+00_JPRB, &
 & 0.81098E+00_JPRB,0.87502E+00_JPRB,0.10085E+01_JPRB,0.11531E+01_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.12761E+01_JPRB,0.11169E+01_JPRB,0.10366E+01_JPRB,0.10056E+01_JPRB,0.96619E+00_JPRB, &
 & 0.93741E+00_JPRB,0.96971E+00_JPRB,0.10971E+01_JPRB,0.12455E+01_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.12590E+01_JPRB,0.11018E+01_JPRB,0.10193E+01_JPRB,0.98827E+00_JPRB,0.94401E+00_JPRB, &
 & 0.91331E+00_JPRB,0.95200E+00_JPRB,0.10824E+01_JPRB,0.12321E+01_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.12382E+01_JPRB,0.10836E+01_JPRB,0.99864E+00_JPRB,0.96922E+00_JPRB,0.92237E+00_JPRB, &
 & 0.89570E+00_JPRB,0.94013E+00_JPRB,0.10732E+01_JPRB,0.12212E+01_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.12192E+01_JPRB,0.10671E+01_JPRB,0.97718E+00_JPRB,0.94975E+00_JPRB,0.90316E+00_JPRB, &
 & 0.88110E+00_JPRB,0.93100E+00_JPRB,0.10658E+01_JPRB,0.12124E+01_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.12013E+01_JPRB,0.10515E+01_JPRB,0.95818E+00_JPRB,0.93022E+00_JPRB,0.88690E+00_JPRB, &
 & 0.86844E+00_JPRB,0.92401E+00_JPRB,0.10605E+01_JPRB,0.12064E+01_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.70834E+00_JPRB,0.62203E+00_JPRB,0.53582E+00_JPRB,0.44981E+00_JPRB,0.36430E+00_JPRB, &
 & 0.30456E+00_JPRB,0.33772E+00_JPRB,0.39113E+00_JPRB,0.42417E+00_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.69132E+00_JPRB,0.60682E+00_JPRB,0.52239E+00_JPRB,0.43815E+00_JPRB,0.35442E+00_JPRB, &
 & 0.29618E+00_JPRB,0.32847E+00_JPRB,0.37897E+00_JPRB,0.41053E+00_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.67551E+00_JPRB,0.59273E+00_JPRB,0.51002E+00_JPRB,0.42746E+00_JPRB,0.34540E+00_JPRB, &
 & 0.29170E+00_JPRB,0.32190E+00_JPRB,0.37054E+00_JPRB,0.40056E+00_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.65954E+00_JPRB,0.57855E+00_JPRB,0.49762E+00_JPRB,0.41681E+00_JPRB,0.33774E+00_JPRB, &
 & 0.29058E+00_JPRB,0.31932E+00_JPRB,0.36553E+00_JPRB,0.39416E+00_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.64426E+00_JPRB,0.56502E+00_JPRB,0.48582E+00_JPRB,0.40671E+00_JPRB,0.33237E+00_JPRB, &
 & 0.29156E+00_JPRB,0.32280E+00_JPRB,0.36526E+00_JPRB,0.39257E+00_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.79278E+00_JPRB,0.69566E+00_JPRB,0.59863E+00_JPRB,0.50180E+00_JPRB,0.40547E+00_JPRB, &
 & 0.36074E+00_JPRB,0.40858E+00_JPRB,0.47363E+00_JPRB,0.52463E+00_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.77384E+00_JPRB,0.67879E+00_JPRB,0.58381E+00_JPRB,0.48896E+00_JPRB,0.39453E+00_JPRB, &
 & 0.34912E+00_JPRB,0.39677E+00_JPRB,0.45884E+00_JPRB,0.50797E+00_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.75601E+00_JPRB,0.66296E+00_JPRB,0.56995E+00_JPRB,0.47701E+00_JPRB,0.38437E+00_JPRB, &
 & 0.34005E+00_JPRB,0.38826E+00_JPRB,0.44800E+00_JPRB,0.49524E+00_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.73809E+00_JPRB,0.64708E+00_JPRB,0.55610E+00_JPRB,0.46517E+00_JPRB,0.37616E+00_JPRB, &
 & 0.33560E+00_JPRB,0.38277E+00_JPRB,0.44095E+00_JPRB,0.48660E+00_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.72001E+00_JPRB,0.63111E+00_JPRB,0.54222E+00_JPRB,0.45336E+00_JPRB,0.36992E+00_JPRB, &
 & 0.33536E+00_JPRB,0.38227E+00_JPRB,0.43734E+00_JPRB,0.48144E+00_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.88640E+00_JPRB,0.77731E+00_JPRB,0.66826E+00_JPRB,0.55931E+00_JPRB,0.45077E+00_JPRB, &
 & 0.42993E+00_JPRB,0.49594E+00_JPRB,0.57510E+00_JPRB,0.65079E+00_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.86545E+00_JPRB,0.75870E+00_JPRB,0.65198E+00_JPRB,0.54530E+00_JPRB,0.43919E+00_JPRB, &
 & 0.41467E+00_JPRB,0.48152E+00_JPRB,0.55764E+00_JPRB,0.63093E+00_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.84484E+00_JPRB,0.74046E+00_JPRB,0.63609E+00_JPRB,0.53174E+00_JPRB,0.42841E+00_JPRB, &
 & 0.40263E+00_JPRB,0.47018E+00_JPRB,0.54358E+00_JPRB,0.61450E+00_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.82484E+00_JPRB,0.72279E+00_JPRB,0.62074E+00_JPRB,0.51870E+00_JPRB,0.41933E+00_JPRB, &
 & 0.39440E+00_JPRB,0.46214E+00_JPRB,0.53355E+00_JPRB,0.60235E+00_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.80403E+00_JPRB,0.70444E+00_JPRB,0.60484E+00_JPRB,0.50526E+00_JPRB,0.41249E+00_JPRB, &
 & 0.39177E+00_JPRB,0.45674E+00_JPRB,0.52614E+00_JPRB,0.59324E+00_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.98775E+00_JPRB,0.86568E+00_JPRB,0.74362E+00_JPRB,0.62157E+00_JPRB,0.50893E+00_JPRB, &
 & 0.51227E+00_JPRB,0.60104E+00_JPRB,0.69710E+00_JPRB,0.79722E+00_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.96448E+00_JPRB,0.84510E+00_JPRB,0.72572E+00_JPRB,0.60634E+00_JPRB,0.49496E+00_JPRB, &
 & 0.49365E+00_JPRB,0.58337E+00_JPRB,0.67615E+00_JPRB,0.77326E+00_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.94121E+00_JPRB,0.82456E+00_JPRB,0.70790E+00_JPRB,0.59124E+00_JPRB,0.48214E+00_JPRB, &
 & 0.47977E+00_JPRB,0.56920E+00_JPRB,0.65880E+00_JPRB,0.75281E+00_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.91776E+00_JPRB,0.80389E+00_JPRB,0.69002E+00_JPRB,0.57613E+00_JPRB,0.47050E+00_JPRB, &
 & 0.47009E+00_JPRB,0.55863E+00_JPRB,0.64595E+00_JPRB,0.73761E+00_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.89560E+00_JPRB,0.78437E+00_JPRB,0.67314E+00_JPRB,0.56190E+00_JPRB,0.46260E+00_JPRB, &
 & 0.46419E+00_JPRB,0.55009E+00_JPRB,0.63560E+00_JPRB,0.72526E+00_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.10958E+01_JPRB,0.95999E+00_JPRB,0.82419E+00_JPRB,0.68839E+00_JPRB,0.58904E+00_JPRB, &
 & 0.60909E+00_JPRB,0.72523E+00_JPRB,0.84139E+00_JPRB,0.96623E+00_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.10697E+01_JPRB,0.93701E+00_JPRB,0.80427E+00_JPRB,0.67151E+00_JPRB,0.56892E+00_JPRB, &
 & 0.58963E+00_JPRB,0.70431E+00_JPRB,0.81667E+00_JPRB,0.93800E+00_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.10434E+01_JPRB,0.91377E+00_JPRB,0.78415E+00_JPRB,0.65453E+00_JPRB,0.55082E+00_JPRB, &
 & 0.57510E+00_JPRB,0.68668E+00_JPRB,0.79542E+00_JPRB,0.91311E+00_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.10167E+01_JPRB,0.89033E+00_JPRB,0.76393E+00_JPRB,0.63753E+00_JPRB,0.53477E+00_JPRB, &
 & 0.56392E+00_JPRB,0.67291E+00_JPRB,0.77892E+00_JPRB,0.89383E+00_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.99271E+00_JPRB,0.86922E+00_JPRB,0.74573E+00_JPRB,0.62224E+00_JPRB,0.52129E+00_JPRB, &
 & 0.55503E+00_JPRB,0.66157E+00_JPRB,0.76538E+00_JPRB,0.87797E+00_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.12165E+01_JPRB,0.10653E+01_JPRB,0.91421E+00_JPRB,0.76309E+00_JPRB,0.68684E+00_JPRB, &
 & 0.72751E+00_JPRB,0.87072E+00_JPRB,0.10104E+01_JPRB,0.11626E+01_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.11851E+01_JPRB,0.10377E+01_JPRB,0.89038E+00_JPRB,0.74302E+00_JPRB,0.66078E+00_JPRB, &
 & 0.70740E+00_JPRB,0.84652E+00_JPRB,0.98180E+00_JPRB,0.11298E+01_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.11540E+01_JPRB,0.10104E+01_JPRB,0.86680E+00_JPRB,0.72322E+00_JPRB,0.63673E+00_JPRB, &
 & 0.69046E+00_JPRB,0.82558E+00_JPRB,0.95705E+00_JPRB,0.11007E+01_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.11233E+01_JPRB,0.98347E+00_JPRB,0.84364E+00_JPRB,0.70381E+00_JPRB,0.61623E+00_JPRB, &
 & 0.67656E+00_JPRB,0.80855E+00_JPRB,0.93682E+00_JPRB,0.10775E+01_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.10954E+01_JPRB,0.95895E+00_JPRB,0.82254E+00_JPRB,0.68614E+00_JPRB,0.59850E+00_JPRB, &
 & 0.66513E+00_JPRB,0.79440E+00_JPRB,0.92006E+00_JPRB,0.10579E+01_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.13516E+01_JPRB,0.11834E+01_JPRB,0.10152E+01_JPRB,0.84752E+00_JPRB,0.80189E+00_JPRB, &
 & 0.86751E+00_JPRB,0.10388E+01_JPRB,0.12059E+01_JPRB,0.13885E+01_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.13129E+01_JPRB,0.11495E+01_JPRB,0.98601E+00_JPRB,0.82254E+00_JPRB,0.76801E+00_JPRB, &
 & 0.84476E+00_JPRB,0.10112E+01_JPRB,0.11733E+01_JPRB,0.13510E+01_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.12754E+01_JPRB,0.11166E+01_JPRB,0.95771E+00_JPRB,0.79885E+00_JPRB,0.73832E+00_JPRB, &
 & 0.82499E+00_JPRB,0.98705E+00_JPRB,0.11448E+01_JPRB,0.13179E+01_JPRB /)  
KA(:, 4, 7,15) = (/ &
 & 0.12391E+01_JPRB,0.10847E+01_JPRB,0.93032E+00_JPRB,0.77593E+00_JPRB,0.71267E+00_JPRB, &
 & 0.80837E+00_JPRB,0.96685E+00_JPRB,0.11210E+01_JPRB,0.12906E+01_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.12065E+01_JPRB,0.10561E+01_JPRB,0.90576E+00_JPRB,0.75539E+00_JPRB,0.69035E+00_JPRB, &
 & 0.79409E+00_JPRB,0.94938E+00_JPRB,0.11005E+01_JPRB,0.12668E+01_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.14988E+01_JPRB,0.13122E+01_JPRB,0.11257E+01_JPRB,0.95045E+00_JPRB,0.92736E+00_JPRB, &
 & 0.10268E+01_JPRB,0.12293E+01_JPRB,0.14274E+01_JPRB,0.16436E+01_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.14532E+01_JPRB,0.12722E+01_JPRB,0.10913E+01_JPRB,0.91652E+00_JPRB,0.88763E+00_JPRB, &
 & 0.10018E+01_JPRB,0.11994E+01_JPRB,0.13921E+01_JPRB,0.16030E+01_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.14089E+01_JPRB,0.12334E+01_JPRB,0.10579E+01_JPRB,0.88636E+00_JPRB,0.85277E+00_JPRB, &
 & 0.97910E+00_JPRB,0.11719E+01_JPRB,0.13598E+01_JPRB,0.15656E+01_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.13671E+01_JPRB,0.11967E+01_JPRB,0.10263E+01_JPRB,0.85849E+00_JPRB,0.82373E+00_JPRB, &
 & 0.95955E+00_JPRB,0.11482E+01_JPRB,0.13320E+01_JPRB,0.15338E+01_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.13292E+01_JPRB,0.11635E+01_JPRB,0.99774E+00_JPRB,0.83411E+00_JPRB,0.79958E+00_JPRB, &
 & 0.94221E+00_JPRB,0.11271E+01_JPRB,0.13073E+01_JPRB,0.15052E+01_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.16562E+01_JPRB,0.14500E+01_JPRB,0.12437E+01_JPRB,0.10742E+01_JPRB,0.10651E+01_JPRB, &
 & 0.12070E+01_JPRB,0.14445E+01_JPRB,0.16775E+01_JPRB,0.19311E+01_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.16034E+01_JPRB,0.14036E+01_JPRB,0.12039E+01_JPRB,0.10312E+01_JPRB,0.10206E+01_JPRB, &
 & 0.11791E+01_JPRB,0.14116E+01_JPRB,0.16391E+01_JPRB,0.18869E+01_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.15525E+01_JPRB,0.13590E+01_JPRB,0.11655E+01_JPRB,0.99233E+00_JPRB,0.98476E+00_JPRB, &
 & 0.11530E+01_JPRB,0.13804E+01_JPRB,0.16026E+01_JPRB,0.18449E+01_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.15047E+01_JPRB,0.13171E+01_JPRB,0.11295E+01_JPRB,0.95737E+00_JPRB,0.95592E+00_JPRB, &
 & 0.11301E+01_JPRB,0.13529E+01_JPRB,0.15703E+01_JPRB,0.18077E+01_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.14611E+01_JPRB,0.12789E+01_JPRB,0.10967E+01_JPRB,0.92635E+00_JPRB,0.93256E+00_JPRB, &
 & 0.11088E+01_JPRB,0.13272E+01_JPRB,0.15403E+01_JPRB,0.17730E+01_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.18225E+01_JPRB,0.15953E+01_JPRB,0.13682E+01_JPRB,0.12131E+01_JPRB,0.12195E+01_JPRB, &
 & 0.14041E+01_JPRB,0.16789E+01_JPRB,0.19504E+01_JPRB,0.22442E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART11',0,ZHOOK_HANDLE)


KA(:, 2,10,15) = (/ &
 & 0.17586E+01_JPRB,0.15393E+01_JPRB,0.13201E+01_JPRB,0.11608E+01_JPRB,0.11760E+01_JPRB, &
 & 0.13729E+01_JPRB,0.16424E+01_JPRB,0.19078E+01_JPRB,0.21951E+01_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.16992E+01_JPRB,0.14873E+01_JPRB,0.12754E+01_JPRB,0.11134E+01_JPRB,0.11408E+01_JPRB, &
 & 0.13430E+01_JPRB,0.16073E+01_JPRB,0.18666E+01_JPRB,0.21480E+01_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.16453E+01_JPRB,0.14401E+01_JPRB,0.12349E+01_JPRB,0.10705E+01_JPRB,0.11101E+01_JPRB, &
 & 0.13157E+01_JPRB,0.15751E+01_JPRB,0.18293E+01_JPRB,0.21045E+01_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.15976E+01_JPRB,0.13983E+01_JPRB,0.11990E+01_JPRB,0.10350E+01_JPRB,0.10845E+01_JPRB, &
 & 0.12900E+01_JPRB,0.15444E+01_JPRB,0.17936E+01_JPRB,0.20634E+01_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.19716E+01_JPRB,0.17256E+01_JPRB,0.14797E+01_JPRB,0.13408E+01_JPRB,0.13798E+01_JPRB, &
 & 0.16011E+01_JPRB,0.19108E+01_JPRB,0.22209E+01_JPRB,0.25534E+01_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.18980E+01_JPRB,0.16613E+01_JPRB,0.14245E+01_JPRB,0.12841E+01_JPRB,0.13393E+01_JPRB, &
 & 0.15661E+01_JPRB,0.18703E+01_JPRB,0.21736E+01_JPRB,0.24991E+01_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.18334E+01_JPRB,0.16046E+01_JPRB,0.13758E+01_JPRB,0.12346E+01_JPRB,0.13019E+01_JPRB, &
 & 0.15332E+01_JPRB,0.18320E+01_JPRB,0.21288E+01_JPRB,0.24477E+01_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.17833E+01_JPRB,0.15608E+01_JPRB,0.13382E+01_JPRB,0.11928E+01_JPRB,0.12697E+01_JPRB, &
 & 0.15019E+01_JPRB,0.17959E+01_JPRB,0.20867E+01_JPRB,0.23990E+01_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.17385E+01_JPRB,0.15215E+01_JPRB,0.13045E+01_JPRB,0.11584E+01_JPRB,0.12412E+01_JPRB, &
 & 0.14723E+01_JPRB,0.17610E+01_JPRB,0.20462E+01_JPRB,0.23526E+01_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.21322E+01_JPRB,0.18661E+01_JPRB,0.16009E+01_JPRB,0.14913E+01_JPRB,0.15626E+01_JPRB, &
 & 0.18065E+01_JPRB,0.21498E+01_JPRB,0.24997E+01_JPRB,0.28719E+01_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.20605E+01_JPRB,0.18033E+01_JPRB,0.15462E+01_JPRB,0.14346E+01_JPRB,0.15183E+01_JPRB, &
 & 0.17679E+01_JPRB,0.21055E+01_JPRB,0.24481E+01_JPRB,0.28126E+01_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.20007E+01_JPRB,0.17509E+01_JPRB,0.15011E+01_JPRB,0.13841E+01_JPRB,0.14777E+01_JPRB, &
 & 0.17312E+01_JPRB,0.20634E+01_JPRB,0.23990E+01_JPRB,0.27564E+01_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.19501E+01_JPRB,0.17066E+01_JPRB,0.14631E+01_JPRB,0.13415E+01_JPRB,0.14420E+01_JPRB, &
 & 0.16956E+01_JPRB,0.20218E+01_JPRB,0.23506E+01_JPRB,0.27007E+01_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.19023E+01_JPRB,0.16648E+01_JPRB,0.14272E+01_JPRB,0.13048E+01_JPRB,0.14093E+01_JPRB, &
 & 0.16619E+01_JPRB,0.19834E+01_JPRB,0.23060E+01_JPRB,0.26492E+01_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.23283E+01_JPRB,0.20376E+01_JPRB,0.17570E+01_JPRB,0.16678E+01_JPRB,0.17574E+01_JPRB, &
 & 0.20182E+01_JPRB,0.23943E+01_JPRB,0.27850E+01_JPRB,0.31979E+01_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.22552E+01_JPRB,0.19735E+01_JPRB,0.16974E+01_JPRB,0.16068E+01_JPRB,0.17079E+01_JPRB, &
 & 0.19757E+01_JPRB,0.23460E+01_JPRB,0.27289E+01_JPRB,0.31334E+01_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.21945E+01_JPRB,0.19204E+01_JPRB,0.16488E+01_JPRB,0.15544E+01_JPRB,0.16639E+01_JPRB, &
 & 0.19336E+01_JPRB,0.22972E+01_JPRB,0.26723E+01_JPRB,0.30681E+01_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.21377E+01_JPRB,0.18706E+01_JPRB,0.16045E+01_JPRB,0.15082E+01_JPRB,0.16235E+01_JPRB, &
 & 0.18922E+01_JPRB,0.22504E+01_JPRB,0.26179E+01_JPRB,0.30055E+01_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.20822E+01_JPRB,0.18221E+01_JPRB,0.15623E+01_JPRB,0.14670E+01_JPRB,0.15845E+01_JPRB, &
 & 0.18531E+01_JPRB,0.22061E+01_JPRB,0.25663E+01_JPRB,0.29464E+01_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.84891E+00_JPRB,0.74682E+00_JPRB,0.64540E+00_JPRB,0.54510E+00_JPRB,0.44671E+00_JPRB, &
 & 0.34895E+00_JPRB,0.38105E+00_JPRB,0.44177E+00_JPRB,0.47725E+00_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.82292E+00_JPRB,0.72425E+00_JPRB,0.62615E+00_JPRB,0.52904E+00_JPRB,0.43334E+00_JPRB, &
 & 0.33791E+00_JPRB,0.37758E+00_JPRB,0.43769E+00_JPRB,0.47292E+00_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.79766E+00_JPRB,0.70221E+00_JPRB,0.60725E+00_JPRB,0.51315E+00_JPRB,0.42001E+00_JPRB, &
 & 0.32708E+00_JPRB,0.37351E+00_JPRB,0.43297E+00_JPRB,0.46789E+00_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.77341E+00_JPRB,0.68098E+00_JPRB,0.58899E+00_JPRB,0.49774E+00_JPRB,0.40711E+00_JPRB, &
 & 0.31834E+00_JPRB,0.36899E+00_JPRB,0.42775E+00_JPRB,0.46227E+00_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.74989E+00_JPRB,0.66035E+00_JPRB,0.57119E+00_JPRB,0.48264E+00_JPRB,0.39437E+00_JPRB, &
 & 0.32430E+00_JPRB,0.36416E+00_JPRB,0.42216E+00_JPRB,0.45636E+00_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.98489E+00_JPRB,0.86457E+00_JPRB,0.74461E+00_JPRB,0.62525E+00_JPRB,0.50699E+00_JPRB, &
 & 0.39502E+00_JPRB,0.46270E+00_JPRB,0.53626E+00_JPRB,0.59246E+00_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.95110E+00_JPRB,0.83523E+00_JPRB,0.71967E+00_JPRB,0.60464E+00_JPRB,0.49055E+00_JPRB, &
 & 0.38714E+00_JPRB,0.45775E+00_JPRB,0.53066E+00_JPRB,0.58669E+00_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.91868E+00_JPRB,0.80699E+00_JPRB,0.69557E+00_JPRB,0.58461E+00_JPRB,0.47447E+00_JPRB, &
 & 0.38030E+00_JPRB,0.45287E+00_JPRB,0.52498E+00_JPRB,0.58057E+00_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.88783E+00_JPRB,0.78006E+00_JPRB,0.67253E+00_JPRB,0.56540E+00_JPRB,0.45894E+00_JPRB, &
 & 0.37426E+00_JPRB,0.44739E+00_JPRB,0.51869E+00_JPRB,0.57355E+00_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.85824E+00_JPRB,0.75420E+00_JPRB,0.65037E+00_JPRB,0.54691E+00_JPRB,0.44407E+00_JPRB, &
 & 0.37572E+00_JPRB,0.44151E+00_JPRB,0.51192E+00_JPRB,0.56619E+00_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.11382E+01_JPRB,0.99791E+00_JPRB,0.85785E+00_JPRB,0.71816E+00_JPRB,0.57913E+00_JPRB, &
 & 0.47378E+00_JPRB,0.56732E+00_JPRB,0.65745E+00_JPRB,0.74321E+00_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.10944E+01_JPRB,0.95984E+00_JPRB,0.82550E+00_JPRB,0.69149E+00_JPRB,0.55807E+00_JPRB, &
 & 0.46534E+00_JPRB,0.55716E+00_JPRB,0.64588E+00_JPRB,0.73020E+00_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.10534E+01_JPRB,0.92416E+00_JPRB,0.79509E+00_JPRB,0.66633E+00_JPRB,0.53808E+00_JPRB, &
 & 0.45863E+00_JPRB,0.54915E+00_JPRB,0.63663E+00_JPRB,0.71995E+00_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.10141E+01_JPRB,0.88986E+00_JPRB,0.76582E+00_JPRB,0.64206E+00_JPRB,0.51870E+00_JPRB, &
 & 0.45265E+00_JPRB,0.54212E+00_JPRB,0.62853E+00_JPRB,0.71089E+00_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.97757E+00_JPRB,0.85802E+00_JPRB,0.73862E+00_JPRB,0.61943E+00_JPRB,0.50068E+00_JPRB, &
 & 0.44732E+00_JPRB,0.53486E+00_JPRB,0.62017E+00_JPRB,0.70154E+00_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.13027E+01_JPRB,0.11412E+01_JPRB,0.97988E+00_JPRB,0.81881E+00_JPRB,0.65819E+00_JPRB, &
 & 0.58495E+00_JPRB,0.70040E+00_JPRB,0.81176E+00_JPRB,0.92845E+00_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.12473E+01_JPRB,0.10931E+01_JPRB,0.93894E+00_JPRB,0.78506E+00_JPRB,0.63160E+00_JPRB, &
 & 0.57073E+00_JPRB,0.68340E+00_JPRB,0.79216E+00_JPRB,0.90610E+00_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.11956E+01_JPRB,0.10481E+01_JPRB,0.90063E+00_JPRB,0.75344E+00_JPRB,0.60663E+00_JPRB, &
 & 0.55958E+00_JPRB,0.67003E+00_JPRB,0.77669E+00_JPRB,0.88836E+00_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.11480E+01_JPRB,0.10066E+01_JPRB,0.86532E+00_JPRB,0.72426E+00_JPRB,0.58351E+00_JPRB, &
 & 0.54965E+00_JPRB,0.65819E+00_JPRB,0.76307E+00_JPRB,0.87291E+00_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.11042E+01_JPRB,0.96837E+00_JPRB,0.83267E+00_JPRB,0.69709E+00_JPRB,0.56180E+00_JPRB, &
 & 0.54039E+00_JPRB,0.64710E+00_JPRB,0.75045E+00_JPRB,0.85825E+00_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.14755E+01_JPRB,0.12919E+01_JPRB,0.11084E+01_JPRB,0.92503E+00_JPRB,0.74199E+00_JPRB, &
 & 0.72656E+00_JPRB,0.86992E+00_JPRB,0.10084E+01_JPRB,0.11593E+01_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.14077E+01_JPRB,0.12330E+01_JPRB,0.10584E+01_JPRB,0.88396E+00_JPRB,0.70985E+00_JPRB, &
 & 0.70337E+00_JPRB,0.84221E+00_JPRB,0.97628E+00_JPRB,0.11223E+01_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.13473E+01_JPRB,0.11805E+01_JPRB,0.10138E+01_JPRB,0.84723E+00_JPRB,0.68084E+00_JPRB, &
 & 0.68573E+00_JPRB,0.82117E+00_JPRB,0.95190E+00_JPRB,0.10943E+01_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.12931E+01_JPRB,0.11332E+01_JPRB,0.97336E+00_JPRB,0.81358E+00_JPRB,0.65399E+00_JPRB, &
 & 0.67083E+00_JPRB,0.80321E+00_JPRB,0.93120E+00_JPRB,0.10704E+01_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.12425E+01_JPRB,0.10889E+01_JPRB,0.93535E+00_JPRB,0.78185E+00_JPRB,0.62849E+00_JPRB, &
 & 0.65706E+00_JPRB,0.78689E+00_JPRB,0.91252E+00_JPRB,0.10486E+01_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.16632E+01_JPRB,0.14561E+01_JPRB,0.12491E+01_JPRB,0.10422E+01_JPRB,0.83545E+00_JPRB, &
 & 0.90592E+00_JPRB,0.10850E+01_JPRB,0.12579E+01_JPRB,0.14491E+01_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.15885E+01_JPRB,0.13911E+01_JPRB,0.11938E+01_JPRB,0.99649E+00_JPRB,0.79932E+00_JPRB, &
 & 0.87105E+00_JPRB,0.10430E+01_JPRB,0.12092E+01_JPRB,0.13933E+01_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.15219E+01_JPRB,0.13330E+01_JPRB,0.11441E+01_JPRB,0.95525E+00_JPRB,0.76651E+00_JPRB, &
 & 0.84460E+00_JPRB,0.10114E+01_JPRB,0.11726E+01_JPRB,0.13510E+01_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.14602E+01_JPRB,0.12790E+01_JPRB,0.10978E+01_JPRB,0.91668E+00_JPRB,0.73549E+00_JPRB, &
 & 0.82233E+00_JPRB,0.98468E+00_JPRB,0.11417E+01_JPRB,0.13152E+01_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.14027E+01_JPRB,0.12286E+01_JPRB,0.10546E+01_JPRB,0.88053E+00_JPRB,0.70846E+00_JPRB, &
 & 0.80220E+00_JPRB,0.96072E+00_JPRB,0.11140E+01_JPRB,0.12832E+01_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.18802E+01_JPRB,0.16460E+01_JPRB,0.14119E+01_JPRB,0.11779E+01_JPRB,0.95036E+00_JPRB, &
 & 0.11297E+01_JPRB,0.13528E+01_JPRB,0.15688E+01_JPRB,0.18094E+01_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.17989E+01_JPRB,0.15751E+01_JPRB,0.13512E+01_JPRB,0.11274E+01_JPRB,0.91055E+00_JPRB, &
 & 0.10797E+01_JPRB,0.12930E+01_JPRB,0.14993E+01_JPRB,0.17294E+01_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.17245E+01_JPRB,0.15100E+01_JPRB,0.12954E+01_JPRB,0.10809E+01_JPRB,0.87508E+00_JPRB, &
 & 0.10422E+01_JPRB,0.12481E+01_JPRB,0.14473E+01_JPRB,0.16693E+01_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.16543E+01_JPRB,0.14485E+01_JPRB,0.12427E+01_JPRB,0.10370E+01_JPRB,0.84724E+00_JPRB, &
 & 0.10105E+01_JPRB,0.12102E+01_JPRB,0.14035E+01_JPRB,0.16185E+01_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.15884E+01_JPRB,0.13908E+01_JPRB,0.11932E+01_JPRB,0.99569E+00_JPRB,0.82331E+00_JPRB, &
 & 0.98227E+00_JPRB,0.11764E+01_JPRB,0.13643E+01_JPRB,0.15734E+01_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.21327E+01_JPRB,0.18670E+01_JPRB,0.16012E+01_JPRB,0.13355E+01_JPRB,0.11430E+01_JPRB, &
 & 0.14062E+01_JPRB,0.16843E+01_JPRB,0.19535E+01_JPRB,0.22540E+01_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.20434E+01_JPRB,0.17888E+01_JPRB,0.15342E+01_JPRB,0.12796E+01_JPRB,0.10891E+01_JPRB, &
 & 0.13377E+01_JPRB,0.16020E+01_JPRB,0.18582E+01_JPRB,0.21442E+01_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.19592E+01_JPRB,0.17151E+01_JPRB,0.14711E+01_JPRB,0.12270E+01_JPRB,0.10443E+01_JPRB, &
 & 0.12854E+01_JPRB,0.15395E+01_JPRB,0.17855E+01_JPRB,0.20605E+01_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.18795E+01_JPRB,0.16454E+01_JPRB,0.14112E+01_JPRB,0.11771E+01_JPRB,0.10093E+01_JPRB, &
 & 0.12418E+01_JPRB,0.14873E+01_JPRB,0.17251E+01_JPRB,0.19905E+01_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.18040E+01_JPRB,0.15793E+01_JPRB,0.13546E+01_JPRB,0.11298E+01_JPRB,0.97893E+00_JPRB, &
 & 0.12029E+01_JPRB,0.14409E+01_JPRB,0.16715E+01_JPRB,0.19284E+01_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.24263E+01_JPRB,0.21237E+01_JPRB,0.18212E+01_JPRB,0.15186E+01_JPRB,0.14038E+01_JPRB, &
 & 0.17468E+01_JPRB,0.20923E+01_JPRB,0.24275E+01_JPRB,0.28010E+01_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.23266E+01_JPRB,0.20365E+01_JPRB,0.17464E+01_JPRB,0.14563E+01_JPRB,0.13334E+01_JPRB, &
 & 0.16567E+01_JPRB,0.19843E+01_JPRB,0.23023E+01_JPRB,0.26565E+01_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.22311E+01_JPRB,0.19529E+01_JPRB,0.16747E+01_JPRB,0.13965E+01_JPRB,0.12741E+01_JPRB, &
 & 0.15855E+01_JPRB,0.18989E+01_JPRB,0.22031E+01_JPRB,0.25421E+01_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.21400E+01_JPRB,0.18731E+01_JPRB,0.16063E+01_JPRB,0.13394E+01_JPRB,0.12261E+01_JPRB, &
 & 0.15261E+01_JPRB,0.18280E+01_JPRB,0.21210E+01_JPRB,0.24473E+01_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.20537E+01_JPRB,0.17976E+01_JPRB,0.15415E+01_JPRB,0.12854E+01_JPRB,0.11844E+01_JPRB, &
 & 0.14739E+01_JPRB,0.17653E+01_JPRB,0.20482E+01_JPRB,0.23631E+01_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.27556E+01_JPRB,0.24117E+01_JPRB,0.20679E+01_JPRB,0.17241E+01_JPRB,0.17250E+01_JPRB, &
 & 0.21531E+01_JPRB,0.25793E+01_JPRB,0.29930E+01_JPRB,0.34529E+01_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.26436E+01_JPRB,0.23137E+01_JPRB,0.19838E+01_JPRB,0.16540E+01_JPRB,0.16343E+01_JPRB, &
 & 0.20375E+01_JPRB,0.24406E+01_JPRB,0.28326E+01_JPRB,0.32672E+01_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.25350E+01_JPRB,0.22187E+01_JPRB,0.19024E+01_JPRB,0.15861E+01_JPRB,0.15582E+01_JPRB, &
 & 0.19443E+01_JPRB,0.23290E+01_JPRB,0.27026E+01_JPRB,0.31178E+01_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.24300E+01_JPRB,0.21267E+01_JPRB,0.18235E+01_JPRB,0.15203E+01_JPRB,0.14955E+01_JPRB, &
 & 0.18662E+01_JPRB,0.22353E+01_JPRB,0.25942E+01_JPRB,0.29924E+01_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.23355E+01_JPRB,0.20440E+01_JPRB,0.17526E+01_JPRB,0.14611E+01_JPRB,0.14399E+01_JPRB, &
 & 0.17966E+01_JPRB,0.21521E+01_JPRB,0.24975E+01_JPRB,0.28809E+01_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.30736E+01_JPRB,0.26899E+01_JPRB,0.23062E+01_JPRB,0.19287E+01_JPRB,0.20594E+01_JPRB, &
 & 0.25707E+01_JPRB,0.30796E+01_JPRB,0.35755E+01_JPRB,0.41218E+01_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.29458E+01_JPRB,0.25780E+01_JPRB,0.22102E+01_JPRB,0.18490E+01_JPRB,0.19506E+01_JPRB, &
 & 0.24353E+01_JPRB,0.29176E+01_JPRB,0.33867E+01_JPRB,0.39048E+01_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.28287E+01_JPRB,0.24755E+01_JPRB,0.21223E+01_JPRB,0.17723E+01_JPRB,0.18621E+01_JPRB, &
 & 0.23252E+01_JPRB,0.27855E+01_JPRB,0.32334E+01_JPRB,0.37281E+01_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.27181E+01_JPRB,0.23787E+01_JPRB,0.20393E+01_JPRB,0.17010E+01_JPRB,0.17848E+01_JPRB, &
 & 0.22284E+01_JPRB,0.26698E+01_JPRB,0.30991E+01_JPRB,0.35730E+01_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.26214E+01_JPRB,0.22941E+01_JPRB,0.19667E+01_JPRB,0.16394E+01_JPRB,0.17149E+01_JPRB, &
 & 0.21409E+01_JPRB,0.25649E+01_JPRB,0.29778E+01_JPRB,0.34326E+01_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.34457E+01_JPRB,0.30154E+01_JPRB,0.25850E+01_JPRB,0.22002E+01_JPRB,0.24421E+01_JPRB, &
 & 0.30491E+01_JPRB,0.36532E+01_JPRB,0.42422E+01_JPRB,0.48881E+01_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.33132E+01_JPRB,0.28993E+01_JPRB,0.24855E+01_JPRB,0.21037E+01_JPRB,0.23175E+01_JPRB, &
 & 0.28938E+01_JPRB,0.34673E+01_JPRB,0.40262E+01_JPRB,0.46397E+01_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.31843E+01_JPRB,0.27866E+01_JPRB,0.23888E+01_JPRB,0.20132E+01_JPRB,0.22107E+01_JPRB, &
 & 0.27603E+01_JPRB,0.33070E+01_JPRB,0.38403E+01_JPRB,0.44248E+01_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.30610E+01_JPRB,0.26787E+01_JPRB,0.22963E+01_JPRB,0.19289E+01_JPRB,0.21145E+01_JPRB, &
 & 0.26402E+01_JPRB,0.31632E+01_JPRB,0.36735E+01_JPRB,0.42326E+01_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.29533E+01_JPRB,0.25844E+01_JPRB,0.22155E+01_JPRB,0.18569E+01_JPRB,0.20264E+01_JPRB, &
 & 0.25300E+01_JPRB,0.30314E+01_JPRB,0.35205E+01_JPRB,0.40560E+01_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.38898E+01_JPRB,0.34039E+01_JPRB,0.29179E+01_JPRB,0.25320E+01_JPRB,0.28809E+01_JPRB, &
 & 0.35965E+01_JPRB,0.43091E+01_JPRB,0.50055E+01_JPRB,0.57650E+01_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.37371E+01_JPRB,0.32702E+01_JPRB,0.28033E+01_JPRB,0.24146E+01_JPRB,0.27330E+01_JPRB, &
 & 0.34120E+01_JPRB,0.40886E+01_JPRB,0.47494E+01_JPRB,0.54692E+01_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.35846E+01_JPRB,0.31367E+01_JPRB,0.26889E+01_JPRB,0.23047E+01_JPRB,0.26019E+01_JPRB, &
 & 0.32482E+01_JPRB,0.38921E+01_JPRB,0.45212E+01_JPRB,0.52066E+01_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.34450E+01_JPRB,0.30146E+01_JPRB,0.25842E+01_JPRB,0.22048E+01_JPRB,0.24829E+01_JPRB, &
 & 0.31006E+01_JPRB,0.37153E+01_JPRB,0.43162E+01_JPRB,0.49694E+01_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.33226E+01_JPRB,0.29075E+01_JPRB,0.24923E+01_JPRB,0.21144E+01_JPRB,0.23741E+01_JPRB, &
 & 0.29651E+01_JPRB,0.35532E+01_JPRB,0.41282E+01_JPRB,0.47532E+01_JPRB /)  
  
!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.78344E-03_JPRB,0.81478E-03_JPRB,0.83713E-03_JPRB,0.85265E-03_JPRB,0.85991E-03_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.65374E-03_JPRB,0.67963E-03_JPRB,0.69840E-03_JPRB,0.71131E-03_JPRB,0.71719E-03_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.55587E-03_JPRB,0.57751E-03_JPRB,0.59343E-03_JPRB,0.60410E-03_JPRB,0.60993E-03_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.48145E-03_JPRB,0.49780E-03_JPRB,0.51251E-03_JPRB,0.52093E-03_JPRB,0.52706E-03_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.42610E-03_JPRB,0.43577E-03_JPRB,0.44892E-03_JPRB,0.45812E-03_JPRB,0.46352E-03_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.38503E-03_JPRB,0.38849E-03_JPRB,0.40094E-03_JPRB,0.41067E-03_JPRB,0.41529E-03_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.35025E-03_JPRB,0.34902E-03_JPRB,0.35803E-03_JPRB,0.36759E-03_JPRB,0.37429E-03_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.30557E-03_JPRB,0.30381E-03_JPRB,0.30983E-03_JPRB,0.31782E-03_JPRB,0.32429E-03_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.26346E-03_JPRB,0.26127E-03_JPRB,0.26616E-03_JPRB,0.27270E-03_JPRB,0.27830E-03_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.22630E-03_JPRB,0.22463E-03_JPRB,0.22867E-03_JPRB,0.23419E-03_JPRB,0.23829E-03_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.19498E-03_JPRB,0.19376E-03_JPRB,0.19644E-03_JPRB,0.20096E-03_JPRB,0.20404E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART12',0,ZHOOK_HANDLE)


KB(:,24, 1) = (/ &
 & 0.16839E-03_JPRB,0.16687E-03_JPRB,0.16820E-03_JPRB,0.17215E-03_JPRB,0.17490E-03_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.14494E-03_JPRB,0.14347E-03_JPRB,0.14334E-03_JPRB,0.14728E-03_JPRB,0.14954E-03_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.12363E-03_JPRB,0.12241E-03_JPRB,0.12233E-03_JPRB,0.12518E-03_JPRB,0.12767E-03_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.10560E-03_JPRB,0.10482E-03_JPRB,0.10446E-03_JPRB,0.10681E-03_JPRB,0.10897E-03_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.90453E-04_JPRB,0.89921E-04_JPRB,0.89199E-04_JPRB,0.91278E-04_JPRB,0.93235E-04_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.77854E-04_JPRB,0.77467E-04_JPRB,0.76947E-04_JPRB,0.77977E-04_JPRB,0.79713E-04_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.67346E-04_JPRB,0.67074E-04_JPRB,0.66981E-04_JPRB,0.67340E-04_JPRB,0.68453E-04_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.58739E-04_JPRB,0.58583E-04_JPRB,0.58517E-04_JPRB,0.58421E-04_JPRB,0.59277E-04_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.51671E-04_JPRB,0.51476E-04_JPRB,0.51254E-04_JPRB,0.51199E-04_JPRB,0.51510E-04_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.45523E-04_JPRB,0.45406E-04_JPRB,0.45028E-04_JPRB,0.44849E-04_JPRB,0.44977E-04_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.40256E-04_JPRB,0.40062E-04_JPRB,0.39751E-04_JPRB,0.39416E-04_JPRB,0.39181E-04_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.35762E-04_JPRB,0.35429E-04_JPRB,0.35245E-04_JPRB,0.34916E-04_JPRB,0.34484E-04_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.31776E-04_JPRB,0.31666E-04_JPRB,0.31200E-04_JPRB,0.31013E-04_JPRB,0.30768E-04_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.26934E-04_JPRB,0.26971E-04_JPRB,0.26615E-04_JPRB,0.26355E-04_JPRB,0.26214E-04_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.22652E-04_JPRB,0.22874E-04_JPRB,0.22686E-04_JPRB,0.22466E-04_JPRB,0.22266E-04_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.18970E-04_JPRB,0.19273E-04_JPRB,0.19385E-04_JPRB,0.19198E-04_JPRB,0.19016E-04_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.15533E-04_JPRB,0.15831E-04_JPRB,0.15964E-04_JPRB,0.15836E-04_JPRB,0.15700E-04_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.12668E-04_JPRB,0.12826E-04_JPRB,0.12999E-04_JPRB,0.13018E-04_JPRB,0.12872E-04_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.10356E-04_JPRB,0.10475E-04_JPRB,0.10620E-04_JPRB,0.10666E-04_JPRB,0.10580E-04_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.83551E-05_JPRB,0.84490E-05_JPRB,0.85217E-05_JPRB,0.86140E-05_JPRB,0.86044E-05_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.66829E-05_JPRB,0.68022E-05_JPRB,0.68791E-05_JPRB,0.69429E-05_JPRB,0.69314E-05_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.53860E-05_JPRB,0.54494E-05_JPRB,0.55341E-05_JPRB,0.55544E-05_JPRB,0.55761E-05_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.43207E-05_JPRB,0.43601E-05_JPRB,0.44477E-05_JPRB,0.44761E-05_JPRB,0.44727E-05_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.34852E-05_JPRB,0.34924E-05_JPRB,0.35555E-05_JPRB,0.35928E-05_JPRB,0.35957E-05_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.27913E-05_JPRB,0.28024E-05_JPRB,0.28395E-05_JPRB,0.28713E-05_JPRB,0.28836E-05_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.22267E-05_JPRB,0.22549E-05_JPRB,0.22736E-05_JPRB,0.22769E-05_JPRB,0.23083E-05_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.17814E-05_JPRB,0.18056E-05_JPRB,0.18272E-05_JPRB,0.18178E-05_JPRB,0.18340E-05_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.14202E-05_JPRB,0.14390E-05_JPRB,0.14605E-05_JPRB,0.14515E-05_JPRB,0.14607E-05_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.11328E-05_JPRB,0.11511E-05_JPRB,0.11629E-05_JPRB,0.11627E-05_JPRB,0.11618E-05_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.90478E-06_JPRB,0.91291E-06_JPRB,0.92251E-06_JPRB,0.92910E-06_JPRB,0.92898E-06_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.71737E-06_JPRB,0.72444E-06_JPRB,0.73271E-06_JPRB,0.73646E-06_JPRB,0.74079E-06_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.56522E-06_JPRB,0.57444E-06_JPRB,0.57690E-06_JPRB,0.58444E-06_JPRB,0.59006E-06_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.44522E-06_JPRB,0.45152E-06_JPRB,0.45592E-06_JPRB,0.46208E-06_JPRB,0.46721E-06_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.35045E-06_JPRB,0.35432E-06_JPRB,0.36035E-06_JPRB,0.36444E-06_JPRB,0.36942E-06_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.27513E-06_JPRB,0.27793E-06_JPRB,0.28330E-06_JPRB,0.28729E-06_JPRB,0.29229E-06_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.21608E-06_JPRB,0.21966E-06_JPRB,0.22301E-06_JPRB,0.22740E-06_JPRB,0.23129E-06_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.41669E-02_JPRB,0.42141E-02_JPRB,0.42434E-02_JPRB,0.42683E-02_JPRB,0.42755E-02_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.34875E-02_JPRB,0.35201E-02_JPRB,0.35377E-02_JPRB,0.35547E-02_JPRB,0.35629E-02_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.29417E-02_JPRB,0.29682E-02_JPRB,0.29797E-02_JPRB,0.29877E-02_JPRB,0.29948E-02_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.25072E-02_JPRB,0.25337E-02_JPRB,0.25373E-02_JPRB,0.25423E-02_JPRB,0.25464E-02_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.21640E-02_JPRB,0.21948E-02_JPRB,0.21974E-02_JPRB,0.21951E-02_JPRB,0.21930E-02_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.18910E-02_JPRB,0.19229E-02_JPRB,0.19301E-02_JPRB,0.19201E-02_JPRB,0.19153E-02_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.16495E-02_JPRB,0.16848E-02_JPRB,0.16944E-02_JPRB,0.16885E-02_JPRB,0.16779E-02_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.14018E-02_JPRB,0.14333E-02_JPRB,0.14424E-02_JPRB,0.14394E-02_JPRB,0.14287E-02_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.11832E-02_JPRB,0.12125E-02_JPRB,0.12189E-02_JPRB,0.12151E-02_JPRB,0.12082E-02_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.99669E-03_JPRB,0.10233E-02_JPRB,0.10268E-02_JPRB,0.10250E-02_JPRB,0.10191E-02_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.83734E-03_JPRB,0.86220E-03_JPRB,0.86642E-03_JPRB,0.86487E-03_JPRB,0.86054E-03_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.70349E-03_JPRB,0.72654E-03_JPRB,0.73243E-03_JPRB,0.73077E-03_JPRB,0.72754E-03_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.59070E-03_JPRB,0.61044E-03_JPRB,0.61929E-03_JPRB,0.61773E-03_JPRB,0.61583E-03_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.49716E-03_JPRB,0.51139E-03_JPRB,0.52115E-03_JPRB,0.52139E-03_JPRB,0.52023E-03_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.41822E-03_JPRB,0.42737E-03_JPRB,0.43808E-03_JPRB,0.43978E-03_JPRB,0.43884E-03_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.35061E-03_JPRB,0.35848E-03_JPRB,0.36841E-03_JPRB,0.37095E-03_JPRB,0.37053E-03_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.29391E-03_JPRB,0.30227E-03_JPRB,0.30912E-03_JPRB,0.31376E-03_JPRB,0.31382E-03_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.24878E-03_JPRB,0.25551E-03_JPRB,0.25990E-03_JPRB,0.26493E-03_JPRB,0.26717E-03_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.21146E-03_JPRB,0.21606E-03_JPRB,0.21973E-03_JPRB,0.22385E-03_JPRB,0.22711E-03_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.17989E-03_JPRB,0.18248E-03_JPRB,0.18678E-03_JPRB,0.18914E-03_JPRB,0.19265E-03_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.15377E-03_JPRB,0.15569E-03_JPRB,0.15798E-03_JPRB,0.16109E-03_JPRB,0.16313E-03_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.13129E-03_JPRB,0.13289E-03_JPRB,0.13431E-03_JPRB,0.13679E-03_JPRB,0.13869E-03_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.11225E-03_JPRB,0.11370E-03_JPRB,0.11480E-03_JPRB,0.11616E-03_JPRB,0.11774E-03_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.96722E-04_JPRB,0.97093E-04_JPRB,0.98641E-04_JPRB,0.99964E-04_JPRB,0.10029E-03_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.81278E-04_JPRB,0.81350E-04_JPRB,0.82442E-04_JPRB,0.83555E-04_JPRB,0.83990E-04_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.68481E-04_JPRB,0.68398E-04_JPRB,0.68899E-04_JPRB,0.69737E-04_JPRB,0.70187E-04_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.57588E-04_JPRB,0.57895E-04_JPRB,0.57814E-04_JPRB,0.58095E-04_JPRB,0.58861E-04_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.47541E-04_JPRB,0.47609E-04_JPRB,0.47587E-04_JPRB,0.47727E-04_JPRB,0.48149E-04_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.39099E-04_JPRB,0.39119E-04_JPRB,0.39164E-04_JPRB,0.39161E-04_JPRB,0.39530E-04_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.32129E-04_JPRB,0.32067E-04_JPRB,0.32113E-04_JPRB,0.32128E-04_JPRB,0.32332E-04_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.26339E-04_JPRB,0.26195E-04_JPRB,0.26218E-04_JPRB,0.26313E-04_JPRB,0.26301E-04_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.21510E-04_JPRB,0.21341E-04_JPRB,0.21297E-04_JPRB,0.21378E-04_JPRB,0.21395E-04_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.17530E-04_JPRB,0.17454E-04_JPRB,0.17341E-04_JPRB,0.17352E-04_JPRB,0.17454E-04_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.14267E-04_JPRB,0.14213E-04_JPRB,0.14118E-04_JPRB,0.14076E-04_JPRB,0.14192E-04_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.11510E-04_JPRB,0.11593E-04_JPRB,0.11522E-04_JPRB,0.11431E-04_JPRB,0.11494E-04_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.92607E-05_JPRB,0.93963E-05_JPRB,0.93931E-05_JPRB,0.93302E-05_JPRB,0.93175E-05_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.74566E-05_JPRB,0.75640E-05_JPRB,0.76551E-05_JPRB,0.76195E-05_JPRB,0.75706E-05_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.60069E-05_JPRB,0.60789E-05_JPRB,0.61866E-05_JPRB,0.62136E-05_JPRB,0.61878E-05_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.48719E-05_JPRB,0.49189E-05_JPRB,0.49852E-05_JPRB,0.50599E-05_JPRB,0.50406E-05_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.39542E-05_JPRB,0.39622E-05_JPRB,0.40023E-05_JPRB,0.40853E-05_JPRB,0.41134E-05_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.31898E-05_JPRB,0.32108E-05_JPRB,0.32348E-05_JPRB,0.32873E-05_JPRB,0.33341E-05_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.25786E-05_JPRB,0.26009E-05_JPRB,0.26192E-05_JPRB,0.26504E-05_JPRB,0.26983E-05_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.20942E-05_JPRB,0.21017E-05_JPRB,0.21274E-05_JPRB,0.21442E-05_JPRB,0.21775E-05_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.16959E-05_JPRB,0.17018E-05_JPRB,0.17251E-05_JPRB,0.17374E-05_JPRB,0.17575E-05_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.13662E-05_JPRB,0.13805E-05_JPRB,0.13926E-05_JPRB,0.14091E-05_JPRB,0.14210E-05_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.10989E-05_JPRB,0.11199E-05_JPRB,0.11269E-05_JPRB,0.11436E-05_JPRB,0.11502E-05_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.88647E-06_JPRB,0.91054E-06_JPRB,0.91770E-06_JPRB,0.92872E-06_JPRB,0.93619E-06_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.91432E-02_JPRB,0.90907E-02_JPRB,0.90565E-02_JPRB,0.89984E-02_JPRB,0.89385E-02_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.76455E-02_JPRB,0.75988E-02_JPRB,0.75709E-02_JPRB,0.75150E-02_JPRB,0.74448E-02_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.64231E-02_JPRB,0.63826E-02_JPRB,0.63449E-02_JPRB,0.62999E-02_JPRB,0.62412E-02_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.54475E-02_JPRB,0.53998E-02_JPRB,0.53630E-02_JPRB,0.53153E-02_JPRB,0.52574E-02_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.46876E-02_JPRB,0.46363E-02_JPRB,0.45869E-02_JPRB,0.45398E-02_JPRB,0.44911E-02_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.40806E-02_JPRB,0.40265E-02_JPRB,0.39670E-02_JPRB,0.39185E-02_JPRB,0.38714E-02_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.35897E-02_JPRB,0.35272E-02_JPRB,0.34695E-02_JPRB,0.34174E-02_JPRB,0.33721E-02_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.30557E-02_JPRB,0.30003E-02_JPRB,0.29518E-02_JPRB,0.29027E-02_JPRB,0.28623E-02_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.25840E-02_JPRB,0.25346E-02_JPRB,0.24907E-02_JPRB,0.24530E-02_JPRB,0.24134E-02_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.21784E-02_JPRB,0.21342E-02_JPRB,0.20972E-02_JPRB,0.20639E-02_JPRB,0.20310E-02_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.18415E-02_JPRB,0.17987E-02_JPRB,0.17683E-02_JPRB,0.17405E-02_JPRB,0.17162E-02_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.15599E-02_JPRB,0.15210E-02_JPRB,0.14940E-02_JPRB,0.14715E-02_JPRB,0.14516E-02_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.13214E-02_JPRB,0.12882E-02_JPRB,0.12631E-02_JPRB,0.12449E-02_JPRB,0.12269E-02_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.11148E-02_JPRB,0.10885E-02_JPRB,0.10663E-02_JPRB,0.10485E-02_JPRB,0.10339E-02_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.94180E-03_JPRB,0.92291E-03_JPRB,0.90201E-03_JPRB,0.88582E-03_JPRB,0.87360E-03_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.79929E-03_JPRB,0.78315E-03_JPRB,0.76525E-03_JPRB,0.75093E-03_JPRB,0.73943E-03_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.68110E-03_JPRB,0.66580E-03_JPRB,0.65234E-03_JPRB,0.63866E-03_JPRB,0.62757E-03_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.57975E-03_JPRB,0.56820E-03_JPRB,0.55835E-03_JPRB,0.54581E-03_JPRB,0.53624E-03_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.49551E-03_JPRB,0.48804E-03_JPRB,0.47841E-03_JPRB,0.46871E-03_JPRB,0.45833E-03_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.42572E-03_JPRB,0.42052E-03_JPRB,0.41099E-03_JPRB,0.40377E-03_JPRB,0.39554E-03_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.36528E-03_JPRB,0.36135E-03_JPRB,0.35701E-03_JPRB,0.34948E-03_JPRB,0.34456E-03_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.31415E-03_JPRB,0.31283E-03_JPRB,0.30989E-03_JPRB,0.30612E-03_JPRB,0.30054E-03_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.27352E-03_JPRB,0.27102E-03_JPRB,0.26979E-03_JPRB,0.26826E-03_JPRB,0.26448E-03_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.23967E-03_JPRB,0.23742E-03_JPRB,0.23456E-03_JPRB,0.23474E-03_JPRB,0.23316E-03_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.20338E-03_JPRB,0.20142E-03_JPRB,0.19919E-03_JPRB,0.19875E-03_JPRB,0.19818E-03_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.17257E-03_JPRB,0.17079E-03_JPRB,0.16890E-03_JPRB,0.16818E-03_JPRB,0.16767E-03_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.14733E-03_JPRB,0.14508E-03_JPRB,0.14396E-03_JPRB,0.14263E-03_JPRB,0.14203E-03_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.12225E-03_JPRB,0.12069E-03_JPRB,0.11949E-03_JPRB,0.11833E-03_JPRB,0.11808E-03_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.10097E-03_JPRB,0.10002E-03_JPRB,0.98765E-04_JPRB,0.97895E-04_JPRB,0.97754E-04_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.83346E-04_JPRB,0.82796E-04_JPRB,0.81713E-04_JPRB,0.81007E-04_JPRB,0.80814E-04_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.68346E-04_JPRB,0.68043E-04_JPRB,0.67367E-04_JPRB,0.66543E-04_JPRB,0.66059E-04_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.55818E-04_JPRB,0.55703E-04_JPRB,0.55284E-04_JPRB,0.54584E-04_JPRB,0.54239E-04_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.45332E-04_JPRB,0.45541E-04_JPRB,0.45337E-04_JPRB,0.44929E-04_JPRB,0.44433E-04_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.36748E-04_JPRB,0.37223E-04_JPRB,0.37146E-04_JPRB,0.36884E-04_JPRB,0.36439E-04_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.29601E-04_JPRB,0.30289E-04_JPRB,0.30405E-04_JPRB,0.30257E-04_JPRB,0.29929E-04_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.23826E-04_JPRB,0.24579E-04_JPRB,0.24815E-04_JPRB,0.24762E-04_JPRB,0.24572E-04_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.19377E-04_JPRB,0.19814E-04_JPRB,0.20191E-04_JPRB,0.20227E-04_JPRB,0.20080E-04_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.15665E-04_JPRB,0.15965E-04_JPRB,0.16366E-04_JPRB,0.16467E-04_JPRB,0.16386E-04_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.12631E-04_JPRB,0.12915E-04_JPRB,0.13203E-04_JPRB,0.13389E-04_JPRB,0.13403E-04_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.10160E-04_JPRB,0.10402E-04_JPRB,0.10609E-04_JPRB,0.10858E-04_JPRB,0.10900E-04_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.81514E-05_JPRB,0.83717E-05_JPRB,0.85717E-05_JPRB,0.87255E-05_JPRB,0.88490E-05_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.65924E-05_JPRB,0.67623E-05_JPRB,0.69218E-05_JPRB,0.70363E-05_JPRB,0.71744E-05_JPRB /)  
KB(:,55, 3) = (/ &
 & 0.53378E-05_JPRB,0.54823E-05_JPRB,0.56002E-05_JPRB,0.57079E-05_JPRB,0.58136E-05_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.43093E-05_JPRB,0.44306E-05_JPRB,0.45341E-05_JPRB,0.46443E-05_JPRB,0.47053E-05_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.34880E-05_JPRB,0.35826E-05_JPRB,0.36738E-05_JPRB,0.37492E-05_JPRB,0.38094E-05_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.28214E-05_JPRB,0.28911E-05_JPRB,0.29636E-05_JPRB,0.30269E-05_JPRB,0.30943E-05_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.23049E-05_JPRB,0.23610E-05_JPRB,0.24232E-05_JPRB,0.24708E-05_JPRB,0.25266E-05_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.16886E-01_JPRB,0.17177E-01_JPRB,0.17415E-01_JPRB,0.17613E-01_JPRB,0.17771E-01_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.14297E-01_JPRB,0.14572E-01_JPRB,0.14791E-01_JPRB,0.14925E-01_JPRB,0.15051E-01_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.12142E-01_JPRB,0.12342E-01_JPRB,0.12507E-01_JPRB,0.12640E-01_JPRB,0.12754E-01_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.10284E-01_JPRB,0.10422E-01_JPRB,0.10545E-01_JPRB,0.10662E-01_JPRB,0.10740E-01_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.87377E-02_JPRB,0.88415E-02_JPRB,0.89329E-02_JPRB,0.90175E-02_JPRB,0.90716E-02_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.74766E-02_JPRB,0.75366E-02_JPRB,0.76038E-02_JPRB,0.76818E-02_JPRB,0.77135E-02_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.64241E-02_JPRB,0.64546E-02_JPRB,0.65027E-02_JPRB,0.65449E-02_JPRB,0.65755E-02_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.54390E-02_JPRB,0.54528E-02_JPRB,0.54854E-02_JPRB,0.55046E-02_JPRB,0.55309E-02_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.45856E-02_JPRB,0.45888E-02_JPRB,0.46080E-02_JPRB,0.46219E-02_JPRB,0.46381E-02_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.38581E-02_JPRB,0.38555E-02_JPRB,0.38631E-02_JPRB,0.38756E-02_JPRB,0.38888E-02_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.32522E-02_JPRB,0.32442E-02_JPRB,0.32437E-02_JPRB,0.32522E-02_JPRB,0.32616E-02_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.27421E-02_JPRB,0.27302E-02_JPRB,0.27267E-02_JPRB,0.27311E-02_JPRB,0.27351E-02_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.23082E-02_JPRB,0.22984E-02_JPRB,0.22916E-02_JPRB,0.22928E-02_JPRB,0.22950E-02_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.19386E-02_JPRB,0.19299E-02_JPRB,0.19241E-02_JPRB,0.19234E-02_JPRB,0.19234E-02_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.16295E-02_JPRB,0.16227E-02_JPRB,0.16172E-02_JPRB,0.16132E-02_JPRB,0.16138E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART13',0,ZHOOK_HANDLE)


KB(:,28, 4) = (/ &
 & 0.13714E-02_JPRB,0.13653E-02_JPRB,0.13589E-02_JPRB,0.13555E-02_JPRB,0.13562E-02_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.11583E-02_JPRB,0.11513E-02_JPRB,0.11440E-02_JPRB,0.11416E-02_JPRB,0.11458E-02_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.98213E-03_JPRB,0.97362E-03_JPRB,0.96774E-03_JPRB,0.96738E-03_JPRB,0.97898E-03_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.83694E-03_JPRB,0.82733E-03_JPRB,0.82506E-03_JPRB,0.82584E-03_JPRB,0.83454E-03_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.71631E-03_JPRB,0.70972E-03_JPRB,0.70944E-03_JPRB,0.70782E-03_JPRB,0.71382E-03_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.62056E-03_JPRB,0.61607E-03_JPRB,0.61112E-03_JPRB,0.60974E-03_JPRB,0.61416E-03_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.54260E-03_JPRB,0.53530E-03_JPRB,0.53018E-03_JPRB,0.53196E-03_JPRB,0.53190E-03_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.47557E-03_JPRB,0.47060E-03_JPRB,0.46470E-03_JPRB,0.46463E-03_JPRB,0.46278E-03_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.42108E-03_JPRB,0.41716E-03_JPRB,0.41356E-03_JPRB,0.41052E-03_JPRB,0.40671E-03_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.36059E-03_JPRB,0.35753E-03_JPRB,0.35465E-03_JPRB,0.35204E-03_JPRB,0.34625E-03_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.30926E-03_JPRB,0.30682E-03_JPRB,0.30403E-03_JPRB,0.30126E-03_JPRB,0.29597E-03_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.26586E-03_JPRB,0.26397E-03_JPRB,0.26023E-03_JPRB,0.25654E-03_JPRB,0.25399E-03_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.22228E-03_JPRB,0.22028E-03_JPRB,0.21711E-03_JPRB,0.21418E-03_JPRB,0.21203E-03_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.18516E-03_JPRB,0.18277E-03_JPRB,0.18056E-03_JPRB,0.17797E-03_JPRB,0.17615E-03_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.15367E-03_JPRB,0.15191E-03_JPRB,0.15012E-03_JPRB,0.14803E-03_JPRB,0.14667E-03_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.12696E-03_JPRB,0.12546E-03_JPRB,0.12398E-03_JPRB,0.12239E-03_JPRB,0.12042E-03_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.10470E-03_JPRB,0.10323E-03_JPRB,0.10199E-03_JPRB,0.10082E-03_JPRB,0.99093E-04_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.86543E-04_JPRB,0.84786E-04_JPRB,0.83972E-04_JPRB,0.82789E-04_JPRB,0.81392E-04_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.71529E-04_JPRB,0.69963E-04_JPRB,0.68982E-04_JPRB,0.67996E-04_JPRB,0.66867E-04_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.59457E-04_JPRB,0.57707E-04_JPRB,0.56668E-04_JPRB,0.55899E-04_JPRB,0.54959E-04_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.49467E-04_JPRB,0.47679E-04_JPRB,0.46593E-04_JPRB,0.45887E-04_JPRB,0.45090E-04_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.40766E-04_JPRB,0.39435E-04_JPRB,0.38281E-04_JPRB,0.37548E-04_JPRB,0.37003E-04_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.33628E-04_JPRB,0.32753E-04_JPRB,0.31623E-04_JPRB,0.30893E-04_JPRB,0.30385E-04_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.27865E-04_JPRB,0.27055E-04_JPRB,0.26162E-04_JPRB,0.25458E-04_JPRB,0.24898E-04_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.22934E-04_JPRB,0.22328E-04_JPRB,0.21731E-04_JPRB,0.20990E-04_JPRB,0.20456E-04_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.18846E-04_JPRB,0.18445E-04_JPRB,0.17912E-04_JPRB,0.17357E-04_JPRB,0.16833E-04_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.15388E-04_JPRB,0.15212E-04_JPRB,0.14808E-04_JPRB,0.14414E-04_JPRB,0.13935E-04_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.12598E-04_JPRB,0.12543E-04_JPRB,0.12261E-04_JPRB,0.11957E-04_JPRB,0.11571E-04_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.10381E-04_JPRB,0.10344E-04_JPRB,0.10166E-04_JPRB,0.98775E-05_JPRB,0.96020E-05_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.85457E-05_JPRB,0.84639E-05_JPRB,0.83932E-05_JPRB,0.81757E-05_JPRB,0.79545E-05_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.70397E-05_JPRB,0.69486E-05_JPRB,0.69316E-05_JPRB,0.67696E-05_JPRB,0.65859E-05_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.58257E-05_JPRB,0.57596E-05_JPRB,0.57448E-05_JPRB,0.56300E-05_JPRB,0.54831E-05_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.33040E-01_JPRB,0.33623E-01_JPRB,0.34360E-01_JPRB,0.35360E-01_JPRB,0.36383E-01_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.28634E-01_JPRB,0.29145E-01_JPRB,0.29913E-01_JPRB,0.30773E-01_JPRB,0.31595E-01_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.24852E-01_JPRB,0.25387E-01_JPRB,0.26038E-01_JPRB,0.26736E-01_JPRB,0.27406E-01_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.21426E-01_JPRB,0.21995E-01_JPRB,0.22531E-01_JPRB,0.23082E-01_JPRB,0.23575E-01_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.18563E-01_JPRB,0.19011E-01_JPRB,0.19492E-01_JPRB,0.19940E-01_JPRB,0.20337E-01_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.16067E-01_JPRB,0.16476E-01_JPRB,0.16902E-01_JPRB,0.17235E-01_JPRB,0.17579E-01_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.13911E-01_JPRB,0.14318E-01_JPRB,0.14657E-01_JPRB,0.14999E-01_JPRB,0.15265E-01_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.11889E-01_JPRB,0.12220E-01_JPRB,0.12522E-01_JPRB,0.12793E-01_JPRB,0.13028E-01_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.10107E-01_JPRB,0.10365E-01_JPRB,0.10626E-01_JPRB,0.10840E-01_JPRB,0.11030E-01_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.85828E-02_JPRB,0.88037E-02_JPRB,0.90066E-02_JPRB,0.91828E-02_JPRB,0.93108E-02_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.72873E-02_JPRB,0.74698E-02_JPRB,0.76229E-02_JPRB,0.77606E-02_JPRB,0.78812E-02_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.61731E-02_JPRB,0.63486E-02_JPRB,0.64551E-02_JPRB,0.65686E-02_JPRB,0.66826E-02_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.52349E-02_JPRB,0.53827E-02_JPRB,0.54728E-02_JPRB,0.55581E-02_JPRB,0.56691E-02_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.44343E-02_JPRB,0.45615E-02_JPRB,0.46303E-02_JPRB,0.47140E-02_JPRB,0.48058E-02_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.37566E-02_JPRB,0.38599E-02_JPRB,0.39250E-02_JPRB,0.39996E-02_JPRB,0.40739E-02_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.31898E-02_JPRB,0.32700E-02_JPRB,0.33284E-02_JPRB,0.33863E-02_JPRB,0.34483E-02_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.27069E-02_JPRB,0.27638E-02_JPRB,0.28173E-02_JPRB,0.28668E-02_JPRB,0.29159E-02_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.22952E-02_JPRB,0.23414E-02_JPRB,0.23862E-02_JPRB,0.24319E-02_JPRB,0.25045E-02_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.19469E-02_JPRB,0.19866E-02_JPRB,0.20269E-02_JPRB,0.20617E-02_JPRB,0.21285E-02_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.16569E-02_JPRB,0.16912E-02_JPRB,0.17225E-02_JPRB,0.17537E-02_JPRB,0.18151E-02_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.14159E-02_JPRB,0.14407E-02_JPRB,0.14672E-02_JPRB,0.14987E-02_JPRB,0.15568E-02_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.12124E-02_JPRB,0.12314E-02_JPRB,0.12565E-02_JPRB,0.13096E-02_JPRB,0.13455E-02_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.10402E-02_JPRB,0.10574E-02_JPRB,0.10852E-02_JPRB,0.11323E-02_JPRB,0.11671E-02_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.89606E-03_JPRB,0.91393E-03_JPRB,0.93957E-03_JPRB,0.98258E-03_JPRB,0.10142E-02_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.75556E-03_JPRB,0.77347E-03_JPRB,0.79494E-03_JPRB,0.83337E-03_JPRB,0.86466E-03_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.63793E-03_JPRB,0.65386E-03_JPRB,0.67373E-03_JPRB,0.70925E-03_JPRB,0.73610E-03_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.53995E-03_JPRB,0.55394E-03_JPRB,0.57091E-03_JPRB,0.59316E-03_JPRB,0.62725E-03_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.44830E-03_JPRB,0.46041E-03_JPRB,0.47605E-03_JPRB,0.49517E-03_JPRB,0.52406E-03_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.37113E-03_JPRB,0.38143E-03_JPRB,0.39555E-03_JPRB,0.41230E-03_JPRB,0.43648E-03_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.30743E-03_JPRB,0.31617E-03_JPRB,0.32840E-03_JPRB,0.34246E-03_JPRB,0.36323E-03_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.25237E-03_JPRB,0.25981E-03_JPRB,0.27013E-03_JPRB,0.28179E-03_JPRB,0.29414E-03_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.20643E-03_JPRB,0.21247E-03_JPRB,0.22138E-03_JPRB,0.23093E-03_JPRB,0.24175E-03_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.16882E-03_JPRB,0.17379E-03_JPRB,0.18072E-03_JPRB,0.18917E-03_JPRB,0.19837E-03_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.13808E-03_JPRB,0.14140E-03_JPRB,0.14740E-03_JPRB,0.15462E-03_JPRB,0.16243E-03_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.11262E-03_JPRB,0.11523E-03_JPRB,0.12010E-03_JPRB,0.12571E-03_JPRB,0.13225E-03_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.91738E-04_JPRB,0.93816E-04_JPRB,0.97414E-04_JPRB,0.10204E-03_JPRB,0.10733E-03_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.74533E-04_JPRB,0.76356E-04_JPRB,0.78756E-04_JPRB,0.82697E-04_JPRB,0.86848E-04_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.60870E-04_JPRB,0.62211E-04_JPRB,0.64031E-04_JPRB,0.67056E-04_JPRB,0.70590E-04_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.49547E-04_JPRB,0.50786E-04_JPRB,0.52181E-04_JPRB,0.54428E-04_JPRB,0.57574E-04_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.40457E-04_JPRB,0.41364E-04_JPRB,0.42403E-04_JPRB,0.44095E-04_JPRB,0.46746E-04_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.33032E-04_JPRB,0.33540E-04_JPRB,0.34449E-04_JPRB,0.35762E-04_JPRB,0.37780E-04_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.27201E-04_JPRB,0.27411E-04_JPRB,0.28166E-04_JPRB,0.29168E-04_JPRB,0.30744E-04_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.22471E-04_JPRB,0.22532E-04_JPRB,0.23075E-04_JPRB,0.23887E-04_JPRB,0.25092E-04_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.18480E-04_JPRB,0.18516E-04_JPRB,0.18857E-04_JPRB,0.19555E-04_JPRB,0.20483E-04_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.15198E-04_JPRB,0.15262E-04_JPRB,0.15424E-04_JPRB,0.15989E-04_JPRB,0.16742E-04_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.12523E-04_JPRB,0.12562E-04_JPRB,0.12648E-04_JPRB,0.13089E-04_JPRB,0.13686E-04_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.10416E-04_JPRB,0.10433E-04_JPRB,0.10536E-04_JPRB,0.10919E-04_JPRB,0.11421E-04_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.69718E-01_JPRB,0.71167E-01_JPRB,0.72961E-01_JPRB,0.74885E-01_JPRB,0.77322E-01_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.62182E-01_JPRB,0.63649E-01_JPRB,0.65193E-01_JPRB,0.67193E-01_JPRB,0.69746E-01_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.55177E-01_JPRB,0.56711E-01_JPRB,0.58414E-01_JPRB,0.60422E-01_JPRB,0.62756E-01_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.48867E-01_JPRB,0.50234E-01_JPRB,0.52023E-01_JPRB,0.54055E-01_JPRB,0.56254E-01_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.43174E-01_JPRB,0.44610E-01_JPRB,0.46287E-01_JPRB,0.48302E-01_JPRB,0.50389E-01_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.38339E-01_JPRB,0.39749E-01_JPRB,0.41335E-01_JPRB,0.43237E-01_JPRB,0.45123E-01_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.34315E-01_JPRB,0.35543E-01_JPRB,0.37065E-01_JPRB,0.38754E-01_JPRB,0.40597E-01_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.30036E-01_JPRB,0.31291E-01_JPRB,0.32637E-01_JPRB,0.34202E-01_JPRB,0.35839E-01_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.26135E-01_JPRB,0.27343E-01_JPRB,0.28574E-01_JPRB,0.30000E-01_JPRB,0.31460E-01_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.22750E-01_JPRB,0.23832E-01_JPRB,0.25080E-01_JPRB,0.26299E-01_JPRB,0.27580E-01_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.19795E-01_JPRB,0.20915E-01_JPRB,0.22028E-01_JPRB,0.23060E-01_JPRB,0.24140E-01_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.17353E-01_JPRB,0.18346E-01_JPRB,0.19305E-01_JPRB,0.20238E-01_JPRB,0.21103E-01_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.15226E-01_JPRB,0.16064E-01_JPRB,0.16955E-01_JPRB,0.17722E-01_JPRB,0.18477E-01_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.13309E-01_JPRB,0.14087E-01_JPRB,0.14848E-01_JPRB,0.15498E-01_JPRB,0.16180E-01_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.11623E-01_JPRB,0.12295E-01_JPRB,0.12913E-01_JPRB,0.13525E-01_JPRB,0.14113E-01_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.10147E-01_JPRB,0.10710E-01_JPRB,0.11240E-01_JPRB,0.11795E-01_JPRB,0.12384E-01_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.87968E-02_JPRB,0.92904E-02_JPRB,0.97797E-02_JPRB,0.10288E-01_JPRB,0.10828E-01_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.76490E-02_JPRB,0.80771E-02_JPRB,0.85219E-02_JPRB,0.90152E-02_JPRB,0.97888E-02_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.66330E-02_JPRB,0.70376E-02_JPRB,0.74659E-02_JPRB,0.79113E-02_JPRB,0.86622E-02_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.58073E-02_JPRB,0.61697E-02_JPRB,0.65754E-02_JPRB,0.70309E-02_JPRB,0.77115E-02_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.51062E-02_JPRB,0.54682E-02_JPRB,0.58582E-02_JPRB,0.62737E-02_JPRB,0.69163E-02_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.45302E-02_JPRB,0.48855E-02_JPRB,0.52639E-02_JPRB,0.58227E-02_JPRB,0.62719E-02_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.40254E-02_JPRB,0.43599E-02_JPRB,0.47158E-02_JPRB,0.52732E-02_JPRB,0.57228E-02_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.35647E-02_JPRB,0.38837E-02_JPRB,0.42167E-02_JPRB,0.47705E-02_JPRB,0.52032E-02_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.30730E-02_JPRB,0.33561E-02_JPRB,0.36823E-02_JPRB,0.41868E-02_JPRB,0.45932E-02_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.26407E-02_JPRB,0.29052E-02_JPRB,0.32061E-02_JPRB,0.36781E-02_JPRB,0.40664E-02_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.22667E-02_JPRB,0.25156E-02_JPRB,0.28017E-02_JPRB,0.31173E-02_JPRB,0.36136E-02_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.19056E-02_JPRB,0.21267E-02_JPRB,0.23879E-02_JPRB,0.26789E-02_JPRB,0.31309E-02_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.15967E-02_JPRB,0.17952E-02_JPRB,0.20263E-02_JPRB,0.22865E-02_JPRB,0.27062E-02_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.13343E-02_JPRB,0.15081E-02_JPRB,0.17167E-02_JPRB,0.19538E-02_JPRB,0.23416E-02_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.10981E-02_JPRB,0.12492E-02_JPRB,0.14292E-02_JPRB,0.16430E-02_JPRB,0.19013E-02_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.89464E-03_JPRB,0.10267E-02_JPRB,0.11827E-02_JPRB,0.13698E-02_JPRB,0.16046E-02_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.72683E-03_JPRB,0.83985E-03_JPRB,0.97469E-03_JPRB,0.11376E-02_JPRB,0.13459E-02_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.58610E-03_JPRB,0.68242E-03_JPRB,0.79873E-03_JPRB,0.94079E-03_JPRB,0.11248E-02_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.46823E-03_JPRB,0.54958E-03_JPRB,0.64876E-03_JPRB,0.77111E-03_JPRB,0.93276E-03_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.37202E-03_JPRB,0.44089E-03_JPRB,0.52431E-03_JPRB,0.62811E-03_JPRB,0.76979E-03_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.29424E-03_JPRB,0.35087E-03_JPRB,0.42017E-03_JPRB,0.50926E-03_JPRB,0.63166E-03_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.23381E-03_JPRB,0.28036E-03_JPRB,0.33854E-03_JPRB,0.41547E-03_JPRB,0.52066E-03_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.18542E-03_JPRB,0.22410E-03_JPRB,0.27211E-03_JPRB,0.33806E-03_JPRB,0.42775E-03_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.14646E-03_JPRB,0.17824E-03_JPRB,0.21799E-03_JPRB,0.27400E-03_JPRB,0.34964E-03_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.11499E-03_JPRB,0.14049E-03_JPRB,0.17412E-03_JPRB,0.22038E-03_JPRB,0.28435E-03_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.91160E-04_JPRB,0.11217E-03_JPRB,0.13972E-03_JPRB,0.17793E-03_JPRB,0.23213E-03_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.72474E-04_JPRB,0.89606E-04_JPRB,0.11228E-03_JPRB,0.14368E-03_JPRB,0.18928E-03_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.57463E-04_JPRB,0.71291E-04_JPRB,0.89786E-04_JPRB,0.11554E-03_JPRB,0.15352E-03_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.45287E-04_JPRB,0.56571E-04_JPRB,0.71524E-04_JPRB,0.92319E-04_JPRB,0.12382E-03_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.35841E-04_JPRB,0.44939E-04_JPRB,0.57025E-04_JPRB,0.73710E-04_JPRB,0.99673E-04_JPRB /)  
KB(:,59, 6) = (/ &
 & 0.29941E-04_JPRB,0.37721E-04_JPRB,0.48119E-04_JPRB,0.62420E-04_JPRB,0.85059E-04_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.16189E+00_JPRB,0.16561E+00_JPRB,0.16999E+00_JPRB,0.17514E+00_JPRB,0.18068E+00_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.14981E+00_JPRB,0.15416E+00_JPRB,0.15917E+00_JPRB,0.16420E+00_JPRB,0.16989E+00_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.13875E+00_JPRB,0.14297E+00_JPRB,0.14757E+00_JPRB,0.15249E+00_JPRB,0.15852E+00_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.12672E+00_JPRB,0.13073E+00_JPRB,0.13523E+00_JPRB,0.14037E+00_JPRB,0.14640E+00_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.11530E+00_JPRB,0.11958E+00_JPRB,0.12450E+00_JPRB,0.12975E+00_JPRB,0.13596E+00_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.10572E+00_JPRB,0.11005E+00_JPRB,0.11482E+00_JPRB,0.12031E+00_JPRB,0.12674E+00_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.97798E-01_JPRB,0.10221E+00_JPRB,0.10713E+00_JPRB,0.11251E+00_JPRB,0.11882E+00_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.88438E-01_JPRB,0.93059E-01_JPRB,0.98290E-01_JPRB,0.10406E+00_JPRB,0.11034E+00_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.79615E-01_JPRB,0.84383E-01_JPRB,0.89776E-01_JPRB,0.95707E-01_JPRB,0.10218E+00_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.71663E-01_JPRB,0.76568E-01_JPRB,0.81968E-01_JPRB,0.88106E-01_JPRB,0.94703E-01_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.64729E-01_JPRB,0.69601E-01_JPRB,0.75178E-01_JPRB,0.81445E-01_JPRB,0.88072E-01_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.58713E-01_JPRB,0.63692E-01_JPRB,0.69398E-01_JPRB,0.75609E-01_JPRB,0.82402E-01_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.53422E-01_JPRB,0.58504E-01_JPRB,0.64255E-01_JPRB,0.70582E-01_JPRB,0.77266E-01_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.48884E-01_JPRB,0.53907E-01_JPRB,0.59754E-01_JPRB,0.66093E-01_JPRB,0.72781E-01_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.44782E-01_JPRB,0.49959E-01_JPRB,0.55649E-01_JPRB,0.61937E-01_JPRB,0.68517E-01_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.41164E-01_JPRB,0.46305E-01_JPRB,0.52009E-01_JPRB,0.58205E-01_JPRB,0.64389E-01_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.37976E-01_JPRB,0.43033E-01_JPRB,0.48696E-01_JPRB,0.54470E-01_JPRB,0.60707E-01_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.35210E-01_JPRB,0.40258E-01_JPRB,0.45653E-01_JPRB,0.51435E-01_JPRB,0.59091E-01_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.32774E-01_JPRB,0.37557E-01_JPRB,0.43028E-01_JPRB,0.48762E-01_JPRB,0.56208E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART14',0,ZHOOK_HANDLE)


KB(:,32, 7) = (/ &
 & 0.30628E-01_JPRB,0.35555E-01_JPRB,0.40840E-01_JPRB,0.46513E-01_JPRB,0.53917E-01_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.29120E-01_JPRB,0.33908E-01_JPRB,0.39209E-01_JPRB,0.44801E-01_JPRB,0.52179E-01_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.27843E-01_JPRB,0.32610E-01_JPRB,0.37873E-01_JPRB,0.45101E-01_JPRB,0.51127E-01_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.26429E-01_JPRB,0.31201E-01_JPRB,0.36480E-01_JPRB,0.43796E-01_JPRB,0.49886E-01_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.24910E-01_JPRB,0.29603E-01_JPRB,0.34935E-01_JPRB,0.42317E-01_JPRB,0.48474E-01_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.22623E-01_JPRB,0.27186E-01_JPRB,0.32364E-01_JPRB,0.39709E-01_JPRB,0.45895E-01_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.20536E-01_JPRB,0.25035E-01_JPRB,0.30138E-01_JPRB,0.37341E-01_JPRB,0.43584E-01_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.18744E-01_JPRB,0.23143E-01_JPRB,0.28133E-01_JPRB,0.33754E-01_JPRB,0.41569E-01_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.16632E-01_JPRB,0.20751E-01_JPRB,0.25556E-01_JPRB,0.30972E-01_JPRB,0.38593E-01_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.14671E-01_JPRB,0.18541E-01_JPRB,0.23110E-01_JPRB,0.28292E-01_JPRB,0.35702E-01_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.12909E-01_JPRB,0.16573E-01_JPRB,0.20901E-01_JPRB,0.25885E-01_JPRB,0.32997E-01_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.11155E-01_JPRB,0.14521E-01_JPRB,0.18561E-01_JPRB,0.23268E-01_JPRB,0.28558E-01_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.95144E-02_JPRB,0.12576E-01_JPRB,0.16313E-01_JPRB,0.20662E-01_JPRB,0.25638E-01_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.80643E-02_JPRB,0.10847E-01_JPRB,0.14290E-01_JPRB,0.18347E-01_JPRB,0.23034E-01_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.67589E-02_JPRB,0.92659E-02_JPRB,0.12372E-01_JPRB,0.16082E-01_JPRB,0.20456E-01_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.55482E-02_JPRB,0.77474E-02_JPRB,0.10528E-01_JPRB,0.13920E-01_JPRB,0.17966E-01_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.45013E-02_JPRB,0.64175E-02_JPRB,0.88907E-02_JPRB,0.11958E-01_JPRB,0.15638E-01_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.36173E-02_JPRB,0.52743E-02_JPRB,0.74530E-02_JPRB,0.10200E-01_JPRB,0.13544E-01_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.29073E-02_JPRB,0.43372E-02_JPRB,0.62514E-02_JPRB,0.87078E-02_JPRB,0.11757E-01_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.23200E-02_JPRB,0.35429E-02_JPRB,0.52236E-02_JPRB,0.74160E-02_JPRB,0.10190E-01_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.18398E-02_JPRB,0.28704E-02_JPRB,0.43321E-02_JPRB,0.62743E-02_JPRB,0.87585E-02_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.14394E-02_JPRB,0.22999E-02_JPRB,0.35535E-02_JPRB,0.52615E-02_JPRB,0.74854E-02_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.11368E-02_JPRB,0.18545E-02_JPRB,0.29326E-02_JPRB,0.44372E-02_JPRB,0.64347E-02_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.89467E-03_JPRB,0.14935E-02_JPRB,0.24197E-02_JPRB,0.37410E-02_JPRB,0.55222E-02_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.69687E-03_JPRB,0.11894E-02_JPRB,0.19763E-02_JPRB,0.31286E-02_JPRB,0.47149E-02_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.53791E-03_JPRB,0.93747E-03_JPRB,0.15990E-02_JPRB,0.25976E-02_JPRB,0.39986E-02_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.41410E-03_JPRB,0.73971E-03_JPRB,0.12907E-02_JPRB,0.21482E-02_JPRB,0.33858E-02_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.35405E-03_JPRB,0.64717E-03_JPRB,0.11503E-02_JPRB,0.19466E-02_JPRB,0.31094E-02_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.45516E+00_JPRB,0.46955E+00_JPRB,0.48450E+00_JPRB,0.50029E+00_JPRB,0.51769E+00_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.43991E+00_JPRB,0.45312E+00_JPRB,0.46646E+00_JPRB,0.48116E+00_JPRB,0.49718E+00_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.42871E+00_JPRB,0.44246E+00_JPRB,0.45762E+00_JPRB,0.47406E+00_JPRB,0.49132E+00_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.40699E+00_JPRB,0.42153E+00_JPRB,0.43710E+00_JPRB,0.45468E+00_JPRB,0.47435E+00_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.38538E+00_JPRB,0.39940E+00_JPRB,0.41418E+00_JPRB,0.43146E+00_JPRB,0.45140E+00_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.36235E+00_JPRB,0.37741E+00_JPRB,0.39391E+00_JPRB,0.41121E+00_JPRB,0.43054E+00_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.34180E+00_JPRB,0.35677E+00_JPRB,0.37295E+00_JPRB,0.39070E+00_JPRB,0.41121E+00_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.31818E+00_JPRB,0.33243E+00_JPRB,0.34824E+00_JPRB,0.36683E+00_JPRB,0.38832E+00_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.29454E+00_JPRB,0.30892E+00_JPRB,0.32519E+00_JPRB,0.34434E+00_JPRB,0.36621E+00_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.27292E+00_JPRB,0.28819E+00_JPRB,0.30567E+00_JPRB,0.32553E+00_JPRB,0.34730E+00_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.25455E+00_JPRB,0.27053E+00_JPRB,0.28810E+00_JPRB,0.30845E+00_JPRB,0.33065E+00_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.23920E+00_JPRB,0.25523E+00_JPRB,0.27293E+00_JPRB,0.29370E+00_JPRB,0.31644E+00_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.22572E+00_JPRB,0.24152E+00_JPRB,0.26024E+00_JPRB,0.28092E+00_JPRB,0.30402E+00_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.21333E+00_JPRB,0.23053E+00_JPRB,0.24913E+00_JPRB,0.27069E+00_JPRB,0.29445E+00_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.20216E+00_JPRB,0.22006E+00_JPRB,0.23987E+00_JPRB,0.26172E+00_JPRB,0.28552E+00_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.19243E+00_JPRB,0.21106E+00_JPRB,0.23162E+00_JPRB,0.25373E+00_JPRB,0.27880E+00_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.18399E+00_JPRB,0.20352E+00_JPRB,0.22446E+00_JPRB,0.24815E+00_JPRB,0.27383E+00_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.17696E+00_JPRB,0.19707E+00_JPRB,0.21934E+00_JPRB,0.24428E+00_JPRB,0.27560E+00_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.17154E+00_JPRB,0.19276E+00_JPRB,0.21622E+00_JPRB,0.24297E+00_JPRB,0.27512E+00_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.16864E+00_JPRB,0.19074E+00_JPRB,0.21586E+00_JPRB,0.24341E+00_JPRB,0.27678E+00_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.16705E+00_JPRB,0.19103E+00_JPRB,0.21725E+00_JPRB,0.24571E+00_JPRB,0.27988E+00_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.16718E+00_JPRB,0.19214E+00_JPRB,0.21923E+00_JPRB,0.25236E+00_JPRB,0.28358E+00_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.16615E+00_JPRB,0.19194E+00_JPRB,0.21973E+00_JPRB,0.25386E+00_JPRB,0.28528E+00_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.16355E+00_JPRB,0.18981E+00_JPRB,0.21857E+00_JPRB,0.25318E+00_JPRB,0.28503E+00_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.15644E+00_JPRB,0.18272E+00_JPRB,0.21137E+00_JPRB,0.24627E+00_JPRB,0.27830E+00_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.14985E+00_JPRB,0.17574E+00_JPRB,0.20437E+00_JPRB,0.23950E+00_JPRB,0.27160E+00_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.14373E+00_JPRB,0.16918E+00_JPRB,0.19762E+00_JPRB,0.22814E+00_JPRB,0.26522E+00_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.13479E+00_JPRB,0.15968E+00_JPRB,0.18756E+00_JPRB,0.21775E+00_JPRB,0.25463E+00_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.12605E+00_JPRB,0.15045E+00_JPRB,0.17752E+00_JPRB,0.20726E+00_JPRB,0.24367E+00_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.11784E+00_JPRB,0.14153E+00_JPRB,0.16784E+00_JPRB,0.19712E+00_JPRB,0.23353E+00_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.10839E+00_JPRB,0.13122E+00_JPRB,0.15696E+00_JPRB,0.18528E+00_JPRB,0.21641E+00_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.98772E-01_JPRB,0.12078E+00_JPRB,0.14549E+00_JPRB,0.17313E+00_JPRB,0.20344E+00_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.89757E-01_JPRB,0.11096E+00_JPRB,0.13484E+00_JPRB,0.16135E+00_JPRB,0.19086E+00_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.80754E-01_JPRB,0.10111E+00_JPRB,0.12397E+00_JPRB,0.14951E+00_JPRB,0.17812E+00_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.71551E-01_JPRB,0.90848E-01_JPRB,0.11265E+00_JPRB,0.13712E+00_JPRB,0.16456E+00_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.63023E-01_JPRB,0.81188E-01_JPRB,0.10192E+00_JPRB,0.12530E+00_JPRB,0.15155E+00_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.55112E-01_JPRB,0.71966E-01_JPRB,0.91627E-01_JPRB,0.11386E+00_JPRB,0.13887E+00_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.48148E-01_JPRB,0.63904E-01_JPRB,0.82545E-01_JPRB,0.10380E+00_JPRB,0.12775E+00_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.42077E-01_JPRB,0.56742E-01_JPRB,0.74219E-01_JPRB,0.94436E-01_JPRB,0.11735E+00_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.36406E-01_JPRB,0.49929E-01_JPRB,0.66400E-01_JPRB,0.85557E-01_JPRB,0.10751E+00_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.31162E-01_JPRB,0.43645E-01_JPRB,0.58971E-01_JPRB,0.77049E-01_JPRB,0.97772E-01_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.26848E-01_JPRB,0.38389E-01_JPRB,0.52700E-01_JPRB,0.69937E-01_JPRB,0.89664E-01_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.23145E-01_JPRB,0.33793E-01_JPRB,0.47177E-01_JPRB,0.63590E-01_JPRB,0.82440E-01_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.19764E-01_JPRB,0.29522E-01_JPRB,0.42050E-01_JPRB,0.57472E-01_JPRB,0.75623E-01_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.16713E-01_JPRB,0.25602E-01_JPRB,0.37259E-01_JPRB,0.51705E-01_JPRB,0.68976E-01_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.14134E-01_JPRB,0.22215E-01_JPRB,0.32983E-01_JPRB,0.46579E-01_JPRB,0.62982E-01_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.13103E-01_JPRB,0.20874E-01_JPRB,0.31397E-01_JPRB,0.44700E-01_JPRB,0.60881E-01_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.30563E+01_JPRB,0.31744E+01_JPRB,0.32842E+01_JPRB,0.33901E+01_JPRB,0.34937E+01_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.27752E+01_JPRB,0.28869E+01_JPRB,0.29933E+01_JPRB,0.30958E+01_JPRB,0.31932E+01_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.25099E+01_JPRB,0.26164E+01_JPRB,0.27185E+01_JPRB,0.28161E+01_JPRB,0.29094E+01_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.23062E+01_JPRB,0.23985E+01_JPRB,0.24887E+01_JPRB,0.25791E+01_JPRB,0.26657E+01_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.21996E+01_JPRB,0.22783E+01_JPRB,0.23521E+01_JPRB,0.24248E+01_JPRB,0.25028E+01_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.22125E+01_JPRB,0.22932E+01_JPRB,0.23665E+01_JPRB,0.24375E+01_JPRB,0.25051E+01_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.22641E+01_JPRB,0.23491E+01_JPRB,0.24239E+01_JPRB,0.24973E+01_JPRB,0.25657E+01_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.22472E+01_JPRB,0.23357E+01_JPRB,0.24204E+01_JPRB,0.24964E+01_JPRB,0.25675E+01_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.21851E+01_JPRB,0.22830E+01_JPRB,0.23690E+01_JPRB,0.24562E+01_JPRB,0.25370E+01_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.21175E+01_JPRB,0.22142E+01_JPRB,0.23108E+01_JPRB,0.24049E+01_JPRB,0.24949E+01_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.20447E+01_JPRB,0.21452E+01_JPRB,0.22435E+01_JPRB,0.23385E+01_JPRB,0.24298E+01_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.19721E+01_JPRB,0.20737E+01_JPRB,0.21717E+01_JPRB,0.22760E+01_JPRB,0.23715E+01_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.18957E+01_JPRB,0.20036E+01_JPRB,0.21100E+01_JPRB,0.22176E+01_JPRB,0.23221E+01_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.18288E+01_JPRB,0.19378E+01_JPRB,0.20515E+01_JPRB,0.21609E+01_JPRB,0.22728E+01_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.17692E+01_JPRB,0.18810E+01_JPRB,0.19951E+01_JPRB,0.21151E+01_JPRB,0.22361E+01_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.17168E+01_JPRB,0.18338E+01_JPRB,0.19558E+01_JPRB,0.20789E+01_JPRB,0.22051E+01_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.16702E+01_JPRB,0.17936E+01_JPRB,0.19235E+01_JPRB,0.20524E+01_JPRB,0.21850E+01_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.16394E+01_JPRB,0.17677E+01_JPRB,0.19029E+01_JPRB,0.20369E+01_JPRB,0.21882E+01_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.16228E+01_JPRB,0.17523E+01_JPRB,0.18896E+01_JPRB,0.20262E+01_JPRB,0.21815E+01_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.16178E+01_JPRB,0.17489E+01_JPRB,0.18859E+01_JPRB,0.20233E+01_JPRB,0.21838E+01_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.16221E+01_JPRB,0.17529E+01_JPRB,0.18876E+01_JPRB,0.20327E+01_JPRB,0.21960E+01_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.16321E+01_JPRB,0.17688E+01_JPRB,0.19069E+01_JPRB,0.20650E+01_JPRB,0.22191E+01_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.16388E+01_JPRB,0.17830E+01_JPRB,0.19261E+01_JPRB,0.20887E+01_JPRB,0.22365E+01_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.16423E+01_JPRB,0.17895E+01_JPRB,0.19390E+01_JPRB,0.21032E+01_JPRB,0.22561E+01_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.16080E+01_JPRB,0.17565E+01_JPRB,0.19076E+01_JPRB,0.20741E+01_JPRB,0.22287E+01_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.15745E+01_JPRB,0.17245E+01_JPRB,0.18721E+01_JPRB,0.20419E+01_JPRB,0.21969E+01_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.15386E+01_JPRB,0.16919E+01_JPRB,0.18410E+01_JPRB,0.19923E+01_JPRB,0.21638E+01_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.14840E+01_JPRB,0.16355E+01_JPRB,0.17855E+01_JPRB,0.19337E+01_JPRB,0.21026E+01_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.14260E+01_JPRB,0.15758E+01_JPRB,0.17241E+01_JPRB,0.18746E+01_JPRB,0.20398E+01_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.13688E+01_JPRB,0.15162E+01_JPRB,0.16646E+01_JPRB,0.18157E+01_JPRB,0.19780E+01_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.13011E+01_JPRB,0.14473E+01_JPRB,0.15936E+01_JPRB,0.17402E+01_JPRB,0.18823E+01_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.12278E+01_JPRB,0.13710E+01_JPRB,0.15157E+01_JPRB,0.16568E+01_JPRB,0.17952E+01_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.11558E+01_JPRB,0.12957E+01_JPRB,0.14361E+01_JPRB,0.15731E+01_JPRB,0.17094E+01_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.10820E+01_JPRB,0.12147E+01_JPRB,0.13532E+01_JPRB,0.14890E+01_JPRB,0.16181E+01_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.10024E+01_JPRB,0.11346E+01_JPRB,0.12669E+01_JPRB,0.14002E+01_JPRB,0.15260E+01_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.92524E+00_JPRB,0.10524E+01_JPRB,0.11804E+01_JPRB,0.13068E+01_JPRB,0.14296E+01_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.84698E+00_JPRB,0.96805E+00_JPRB,0.10902E+01_JPRB,0.12100E+01_JPRB,0.13299E+01_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.78084E+00_JPRB,0.89928E+00_JPRB,0.10161E+01_JPRB,0.11323E+01_JPRB,0.12472E+01_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.72222E+00_JPRB,0.83480E+00_JPRB,0.94748E+00_JPRB,0.10626E+01_JPRB,0.11740E+01_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.66260E+00_JPRB,0.77045E+00_JPRB,0.88348E+00_JPRB,0.99181E+00_JPRB,0.10995E+01_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.60516E+00_JPRB,0.71083E+00_JPRB,0.81698E+00_JPRB,0.91863E+00_JPRB,0.10219E+01_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.56176E+00_JPRB,0.66472E+00_JPRB,0.77054E+00_JPRB,0.87249E+00_JPRB,0.97306E+00_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.52563E+00_JPRB,0.63037E+00_JPRB,0.73497E+00_JPRB,0.83878E+00_JPRB,0.93923E+00_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.49056E+00_JPRB,0.59429E+00_JPRB,0.69788E+00_JPRB,0.80509E+00_JPRB,0.90615E+00_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.45575E+00_JPRB,0.55861E+00_JPRB,0.66303E+00_JPRB,0.76942E+00_JPRB,0.87211E+00_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.42419E+00_JPRB,0.52609E+00_JPRB,0.63048E+00_JPRB,0.73708E+00_JPRB,0.84331E+00_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.42340E+00_JPRB,0.52953E+00_JPRB,0.63843E+00_JPRB,0.74879E+00_JPRB,0.86046E+00_JPRB /)  
KB(:,13,10) = (/ &
 & 0.14973E+02_JPRB,0.15466E+02_JPRB,0.15907E+02_JPRB,0.16294E+02_JPRB,0.16648E+02_JPRB /)  
KB(:,14,10) = (/ &
 & 0.13327E+02_JPRB,0.13717E+02_JPRB,0.14036E+02_JPRB,0.14348E+02_JPRB,0.14658E+02_JPRB /)  
KB(:,15,10) = (/ &
 & 0.12219E+02_JPRB,0.12428E+02_JPRB,0.12649E+02_JPRB,0.12810E+02_JPRB,0.12959E+02_JPRB /)  
KB(:,16,10) = (/ &
 & 0.11245E+02_JPRB,0.11501E+02_JPRB,0.11701E+02_JPRB,0.11817E+02_JPRB,0.11948E+02_JPRB /)  
KB(:,17,10) = (/ &
 & 0.96706E+01_JPRB,0.99707E+01_JPRB,0.10257E+02_JPRB,0.10540E+02_JPRB,0.10718E+02_JPRB /)  
KB(:,18,10) = (/ &
 & 0.83018E+01_JPRB,0.83446E+01_JPRB,0.84207E+01_JPRB,0.85262E+01_JPRB,0.86783E+01_JPRB /)  
KB(:,19,10) = (/ &
 & 0.82250E+01_JPRB,0.81929E+01_JPRB,0.82337E+01_JPRB,0.82572E+01_JPRB,0.83177E+01_JPRB /)  
KB(:,20,10) = (/ &
 & 0.81684E+01_JPRB,0.81782E+01_JPRB,0.82244E+01_JPRB,0.82765E+01_JPRB,0.82985E+01_JPRB /)  
KB(:,21,10) = (/ &
 & 0.82586E+01_JPRB,0.83055E+01_JPRB,0.84017E+01_JPRB,0.83815E+01_JPRB,0.83594E+01_JPRB /)  
KB(:,22,10) = (/ &
 & 0.83686E+01_JPRB,0.84604E+01_JPRB,0.85363E+01_JPRB,0.84786E+01_JPRB,0.84786E+01_JPRB /)  
KB(:,23,10) = (/ &
 & 0.84301E+01_JPRB,0.85903E+01_JPRB,0.87569E+01_JPRB,0.87953E+01_JPRB,0.87965E+01_JPRB /)  
KB(:,24,10) = (/ &
 & 0.85690E+01_JPRB,0.88097E+01_JPRB,0.90359E+01_JPRB,0.90994E+01_JPRB,0.92201E+01_JPRB /)  
KB(:,25,10) = (/ &
 & 0.87852E+01_JPRB,0.90719E+01_JPRB,0.92672E+01_JPRB,0.94098E+01_JPRB,0.95600E+01_JPRB /)  
KB(:,26,10) = (/ &
 & 0.88651E+01_JPRB,0.92334E+01_JPRB,0.94525E+01_JPRB,0.97256E+01_JPRB,0.98986E+01_JPRB /)  
KB(:,27,10) = (/ &
 & 0.88645E+01_JPRB,0.92932E+01_JPRB,0.96152E+01_JPRB,0.98392E+01_JPRB,0.10037E+02_JPRB /)  
KB(:,28,10) = (/ &
 & 0.88548E+01_JPRB,0.93070E+01_JPRB,0.96176E+01_JPRB,0.99813E+01_JPRB,0.10238E+02_JPRB /)  
KB(:,29,10) = (/ &
 & 0.88198E+01_JPRB,0.92265E+01_JPRB,0.96024E+01_JPRB,0.99285E+01_JPRB,0.10232E+02_JPRB /)  
KB(:,30,10) = (/ &
 & 0.87818E+01_JPRB,0.92083E+01_JPRB,0.95579E+01_JPRB,0.98976E+01_JPRB,0.10208E+02_JPRB /)  
KB(:,31,10) = (/ &
 & 0.86036E+01_JPRB,0.90621E+01_JPRB,0.94967E+01_JPRB,0.98500E+01_JPRB,0.10159E+02_JPRB /)  
KB(:,32,10) = (/ &
 & 0.84748E+01_JPRB,0.89960E+01_JPRB,0.94428E+01_JPRB,0.98336E+01_JPRB,0.10196E+02_JPRB /)  
KB(:,33,10) = (/ &
 & 0.84172E+01_JPRB,0.89420E+01_JPRB,0.94383E+01_JPRB,0.98344E+01_JPRB,0.10060E+02_JPRB /)  
KB(:,34,10) = (/ &
 & 0.84605E+01_JPRB,0.89751E+01_JPRB,0.94683E+01_JPRB,0.98852E+01_JPRB,0.10023E+02_JPRB /)  
KB(:,35,10) = (/ &
 & 0.84589E+01_JPRB,0.89233E+01_JPRB,0.94002E+01_JPRB,0.98511E+01_JPRB,0.10024E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART15',0,ZHOOK_HANDLE)


KB(:,36,10) = (/ &
 & 0.84558E+01_JPRB,0.89580E+01_JPRB,0.93747E+01_JPRB,0.98030E+01_JPRB,0.10000E+02_JPRB /)  
KB(:,37,10) = (/ &
 & 0.82385E+01_JPRB,0.87614E+01_JPRB,0.91541E+01_JPRB,0.95514E+01_JPRB,0.97363E+01_JPRB /)  
KB(:,38,10) = (/ &
 & 0.80132E+01_JPRB,0.84437E+01_JPRB,0.89304E+01_JPRB,0.92902E+01_JPRB,0.94811E+01_JPRB /)  
KB(:,39,10) = (/ &
 & 0.78203E+01_JPRB,0.81981E+01_JPRB,0.85539E+01_JPRB,0.89689E+01_JPRB,0.90927E+01_JPRB /)  
KB(:,40,10) = (/ &
 & 0.75978E+01_JPRB,0.79610E+01_JPRB,0.82423E+01_JPRB,0.86095E+01_JPRB,0.88190E+01_JPRB /)  
KB(:,41,10) = (/ &
 & 0.73029E+01_JPRB,0.76481E+01_JPRB,0.79708E+01_JPRB,0.82445E+01_JPRB,0.84426E+01_JPRB /)  
KB(:,42,10) = (/ &
 & 0.70166E+01_JPRB,0.73754E+01_JPRB,0.76378E+01_JPRB,0.78862E+01_JPRB,0.80985E+01_JPRB /)  
KB(:,43,10) = (/ &
 & 0.66293E+01_JPRB,0.69504E+01_JPRB,0.72276E+01_JPRB,0.75120E+01_JPRB,0.77099E+01_JPRB /)  
KB(:,44,10) = (/ &
 & 0.62312E+01_JPRB,0.65696E+01_JPRB,0.68647E+01_JPRB,0.71226E+01_JPRB,0.73305E+01_JPRB /)  
KB(:,45,10) = (/ &
 & 0.58229E+01_JPRB,0.61620E+01_JPRB,0.64682E+01_JPRB,0.67341E+01_JPRB,0.69070E+01_JPRB /)  
KB(:,46,10) = (/ &
 & 0.53657E+01_JPRB,0.57492E+01_JPRB,0.60377E+01_JPRB,0.63031E+01_JPRB,0.64992E+01_JPRB /)  
KB(:,47,10) = (/ &
 & 0.50350E+01_JPRB,0.53678E+01_JPRB,0.56656E+01_JPRB,0.59201E+01_JPRB,0.61262E+01_JPRB /)  
KB(:,48,10) = (/ &
 & 0.46566E+01_JPRB,0.49901E+01_JPRB,0.52633E+01_JPRB,0.54964E+01_JPRB,0.57537E+01_JPRB /)  
KB(:,49,10) = (/ &
 & 0.42801E+01_JPRB,0.46217E+01_JPRB,0.49093E+01_JPRB,0.51104E+01_JPRB,0.53644E+01_JPRB /)  
KB(:,50,10) = (/ &
 & 0.39613E+01_JPRB,0.43120E+01_JPRB,0.45848E+01_JPRB,0.48588E+01_JPRB,0.50774E+01_JPRB /)  
KB(:,51,10) = (/ &
 & 0.37006E+01_JPRB,0.40662E+01_JPRB,0.43615E+01_JPRB,0.46264E+01_JPRB,0.48701E+01_JPRB /)  
KB(:,52,10) = (/ &
 & 0.34485E+01_JPRB,0.37934E+01_JPRB,0.40667E+01_JPRB,0.43544E+01_JPRB,0.46481E+01_JPRB /)  
KB(:,53,10) = (/ &
 & 0.31594E+01_JPRB,0.35032E+01_JPRB,0.37934E+01_JPRB,0.41156E+01_JPRB,0.44077E+01_JPRB /)  
KB(:,54,10) = (/ &
 & 0.29800E+01_JPRB,0.33284E+01_JPRB,0.36333E+01_JPRB,0.39624E+01_JPRB,0.42528E+01_JPRB /)  
KB(:,55,10) = (/ &
 & 0.28569E+01_JPRB,0.32159E+01_JPRB,0.35391E+01_JPRB,0.38186E+01_JPRB,0.41402E+01_JPRB /)  
KB(:,56,10) = (/ &
 & 0.26907E+01_JPRB,0.31071E+01_JPRB,0.34476E+01_JPRB,0.36941E+01_JPRB,0.40212E+01_JPRB /)  
KB(:,57,10) = (/ &
 & 0.25638E+01_JPRB,0.29869E+01_JPRB,0.33345E+01_JPRB,0.36081E+01_JPRB,0.38859E+01_JPRB /)  
KB(:,58,10) = (/ &
 & 0.24665E+01_JPRB,0.28708E+01_JPRB,0.32402E+01_JPRB,0.35331E+01_JPRB,0.37851E+01_JPRB /)  
KB(:,59,10) = (/ &
 & 0.25432E+01_JPRB,0.29855E+01_JPRB,0.33662E+01_JPRB,0.37020E+01_JPRB,0.39522E+01_JPRB /)  
KB(:,13,11) = (/ &
 & 0.31099E+02_JPRB,0.31647E+02_JPRB,0.32241E+02_JPRB,0.32842E+02_JPRB,0.33417E+02_JPRB /)  
KB(:,14,11) = (/ &
 & 0.27698E+02_JPRB,0.28253E+02_JPRB,0.28859E+02_JPRB,0.29460E+02_JPRB,0.30083E+02_JPRB /)  
KB(:,15,11) = (/ &
 & 0.24330E+02_JPRB,0.24945E+02_JPRB,0.25542E+02_JPRB,0.26234E+02_JPRB,0.26922E+02_JPRB /)  
KB(:,16,11) = (/ &
 & 0.21190E+02_JPRB,0.21758E+02_JPRB,0.22384E+02_JPRB,0.23019E+02_JPRB,0.23628E+02_JPRB /)  
KB(:,17,11) = (/ &
 & 0.18967E+02_JPRB,0.19413E+02_JPRB,0.19858E+02_JPRB,0.20261E+02_JPRB,0.20672E+02_JPRB /)  
KB(:,18,11) = (/ &
 & 0.16374E+02_JPRB,0.16952E+02_JPRB,0.17497E+02_JPRB,0.17964E+02_JPRB,0.18478E+02_JPRB /)  
KB(:,19,11) = (/ &
 & 0.13248E+02_JPRB,0.13545E+02_JPRB,0.13847E+02_JPRB,0.14297E+02_JPRB,0.14705E+02_JPRB /)  
KB(:,20,11) = (/ &
 & 0.12757E+02_JPRB,0.12785E+02_JPRB,0.12667E+02_JPRB,0.12601E+02_JPRB,0.12612E+02_JPRB /)  
KB(:,21,11) = (/ &
 & 0.12844E+02_JPRB,0.12624E+02_JPRB,0.12433E+02_JPRB,0.12193E+02_JPRB,0.12175E+02_JPRB /)  
KB(:,22,11) = (/ &
 & 0.12738E+02_JPRB,0.12567E+02_JPRB,0.12225E+02_JPRB,0.12063E+02_JPRB,0.11980E+02_JPRB /)  
KB(:,23,11) = (/ &
 & 0.12815E+02_JPRB,0.12660E+02_JPRB,0.12272E+02_JPRB,0.12108E+02_JPRB,0.12066E+02_JPRB /)  
KB(:,24,11) = (/ &
 & 0.13079E+02_JPRB,0.12972E+02_JPRB,0.12651E+02_JPRB,0.12388E+02_JPRB,0.12367E+02_JPRB /)  
KB(:,25,11) = (/ &
 & 0.13341E+02_JPRB,0.13256E+02_JPRB,0.13023E+02_JPRB,0.12848E+02_JPRB,0.12659E+02_JPRB /)  
KB(:,26,11) = (/ &
 & 0.13512E+02_JPRB,0.13453E+02_JPRB,0.13443E+02_JPRB,0.13113E+02_JPRB,0.13141E+02_JPRB /)  
KB(:,27,11) = (/ &
 & 0.13706E+02_JPRB,0.13750E+02_JPRB,0.13824E+02_JPRB,0.13564E+02_JPRB,0.13665E+02_JPRB /)  
KB(:,28,11) = (/ &
 & 0.13979E+02_JPRB,0.14080E+02_JPRB,0.14203E+02_JPRB,0.13858E+02_JPRB,0.13981E+02_JPRB /)  
KB(:,29,11) = (/ &
 & 0.13934E+02_JPRB,0.14086E+02_JPRB,0.14156E+02_JPRB,0.14057E+02_JPRB,0.14114E+02_JPRB /)  
KB(:,30,11) = (/ &
 & 0.13981E+02_JPRB,0.13996E+02_JPRB,0.13975E+02_JPRB,0.14010E+02_JPRB,0.14196E+02_JPRB /)  
KB(:,31,11) = (/ &
 & 0.13896E+02_JPRB,0.13857E+02_JPRB,0.13654E+02_JPRB,0.13807E+02_JPRB,0.13871E+02_JPRB /)  
KB(:,32,11) = (/ &
 & 0.13655E+02_JPRB,0.13646E+02_JPRB,0.13416E+02_JPRB,0.13538E+02_JPRB,0.13488E+02_JPRB /)  
KB(:,33,11) = (/ &
 & 0.13398E+02_JPRB,0.13279E+02_JPRB,0.13235E+02_JPRB,0.13164E+02_JPRB,0.13195E+02_JPRB /)  
KB(:,34,11) = (/ &
 & 0.13280E+02_JPRB,0.13155E+02_JPRB,0.13035E+02_JPRB,0.13095E+02_JPRB,0.13023E+02_JPRB /)  
KB(:,35,11) = (/ &
 & 0.13174E+02_JPRB,0.13038E+02_JPRB,0.12951E+02_JPRB,0.12819E+02_JPRB,0.12932E+02_JPRB /)  
KB(:,36,11) = (/ &
 & 0.13159E+02_JPRB,0.12953E+02_JPRB,0.12943E+02_JPRB,0.12899E+02_JPRB,0.13077E+02_JPRB /)  
KB(:,37,11) = (/ &
 & 0.12968E+02_JPRB,0.12722E+02_JPRB,0.12741E+02_JPRB,0.12684E+02_JPRB,0.12881E+02_JPRB /)  
KB(:,38,11) = (/ &
 & 0.12648E+02_JPRB,0.12436E+02_JPRB,0.12390E+02_JPRB,0.12534E+02_JPRB,0.12593E+02_JPRB /)  
KB(:,39,11) = (/ &
 & 0.12145E+02_JPRB,0.12036E+02_JPRB,0.12198E+02_JPRB,0.12171E+02_JPRB,0.12374E+02_JPRB /)  
KB(:,40,11) = (/ &
 & 0.11784E+02_JPRB,0.11714E+02_JPRB,0.11852E+02_JPRB,0.11995E+02_JPRB,0.12020E+02_JPRB /)  
KB(:,41,11) = (/ &
 & 0.11419E+02_JPRB,0.11429E+02_JPRB,0.11554E+02_JPRB,0.11799E+02_JPRB,0.11809E+02_JPRB /)  
KB(:,42,11) = (/ &
 & 0.11076E+02_JPRB,0.11047E+02_JPRB,0.11287E+02_JPRB,0.11460E+02_JPRB,0.11610E+02_JPRB /)  
KB(:,43,11) = (/ &
 & 0.10635E+02_JPRB,0.10772E+02_JPRB,0.10970E+02_JPRB,0.11110E+02_JPRB,0.11339E+02_JPRB /)  
KB(:,44,11) = (/ &
 & 0.10081E+02_JPRB,0.10347E+02_JPRB,0.10495E+02_JPRB,0.10710E+02_JPRB,0.10998E+02_JPRB /)  
KB(:,45,11) = (/ &
 & 0.95493E+01_JPRB,0.97720E+01_JPRB,0.10013E+02_JPRB,0.10318E+02_JPRB,0.10626E+02_JPRB /)  
KB(:,46,11) = (/ &
 & 0.91901E+01_JPRB,0.92815E+01_JPRB,0.95285E+01_JPRB,0.99399E+01_JPRB,0.10216E+02_JPRB /)  
KB(:,47,11) = (/ &
 & 0.86762E+01_JPRB,0.88384E+01_JPRB,0.91370E+01_JPRB,0.95143E+01_JPRB,0.99290E+01_JPRB /)  
KB(:,48,11) = (/ &
 & 0.80969E+01_JPRB,0.84350E+01_JPRB,0.87222E+01_JPRB,0.91427E+01_JPRB,0.95881E+01_JPRB /)  
KB(:,49,11) = (/ &
 & 0.74881E+01_JPRB,0.78692E+01_JPRB,0.82390E+01_JPRB,0.88564E+01_JPRB,0.92509E+01_JPRB /)  
KB(:,50,11) = (/ &
 & 0.70193E+01_JPRB,0.74373E+01_JPRB,0.79400E+01_JPRB,0.84415E+01_JPRB,0.90721E+01_JPRB /)  
KB(:,51,11) = (/ &
 & 0.66370E+01_JPRB,0.71214E+01_JPRB,0.76381E+01_JPRB,0.81180E+01_JPRB,0.89263E+01_JPRB /)  
KB(:,52,11) = (/ &
 & 0.62242E+01_JPRB,0.68097E+01_JPRB,0.73447E+01_JPRB,0.79515E+01_JPRB,0.88951E+01_JPRB /)  
KB(:,53,11) = (/ &
 & 0.58238E+01_JPRB,0.63775E+01_JPRB,0.69942E+01_JPRB,0.79247E+01_JPRB,0.89454E+01_JPRB /)  
KB(:,54,11) = (/ &
 & 0.55499E+01_JPRB,0.61225E+01_JPRB,0.67115E+01_JPRB,0.76390E+01_JPRB,0.86771E+01_JPRB /)  
KB(:,55,11) = (/ &
 & 0.53976E+01_JPRB,0.59288E+01_JPRB,0.64661E+01_JPRB,0.72387E+01_JPRB,0.82482E+01_JPRB /)  
KB(:,56,11) = (/ &
 & 0.52864E+01_JPRB,0.57486E+01_JPRB,0.62663E+01_JPRB,0.68889E+01_JPRB,0.78153E+01_JPRB /)  
KB(:,57,11) = (/ &
 & 0.51174E+01_JPRB,0.55624E+01_JPRB,0.60808E+01_JPRB,0.66051E+01_JPRB,0.73800E+01_JPRB /)  
KB(:,58,11) = (/ &
 & 0.49368E+01_JPRB,0.54350E+01_JPRB,0.59533E+01_JPRB,0.64218E+01_JPRB,0.70057E+01_JPRB /)  
KB(:,59,11) = (/ &
 & 0.50812E+01_JPRB,0.56369E+01_JPRB,0.60928E+01_JPRB,0.64990E+01_JPRB,0.70265E+01_JPRB /)  
KB(:,13,12) = (/ &
 & 0.69704E+02_JPRB,0.70627E+02_JPRB,0.71228E+02_JPRB,0.71788E+02_JPRB,0.72437E+02_JPRB /)  
KB(:,14,12) = (/ &
 & 0.64379E+02_JPRB,0.65225E+02_JPRB,0.66016E+02_JPRB,0.66901E+02_JPRB,0.67785E+02_JPRB /)  
KB(:,15,12) = (/ &
 & 0.58655E+02_JPRB,0.59644E+02_JPRB,0.60731E+02_JPRB,0.61788E+02_JPRB,0.62973E+02_JPRB /)  
KB(:,16,12) = (/ &
 & 0.53041E+02_JPRB,0.54211E+02_JPRB,0.55406E+02_JPRB,0.56764E+02_JPRB,0.58230E+02_JPRB /)  
KB(:,17,12) = (/ &
 & 0.47145E+02_JPRB,0.48549E+02_JPRB,0.50104E+02_JPRB,0.51815E+02_JPRB,0.53646E+02_JPRB /)  
KB(:,18,12) = (/ &
 & 0.41118E+02_JPRB,0.42628E+02_JPRB,0.44372E+02_JPRB,0.46307E+02_JPRB,0.48319E+02_JPRB /)  
KB(:,19,12) = (/ &
 & 0.35042E+02_JPRB,0.36608E+02_JPRB,0.38443E+02_JPRB,0.40582E+02_JPRB,0.43018E+02_JPRB /)  
KB(:,20,12) = (/ &
 & 0.28625E+02_JPRB,0.30224E+02_JPRB,0.32288E+02_JPRB,0.34780E+02_JPRB,0.37414E+02_JPRB /)  
KB(:,21,12) = (/ &
 & 0.24017E+02_JPRB,0.25409E+02_JPRB,0.27330E+02_JPRB,0.29600E+02_JPRB,0.32108E+02_JPRB /)  
KB(:,22,12) = (/ &
 & 0.21793E+02_JPRB,0.22620E+02_JPRB,0.24096E+02_JPRB,0.26102E+02_JPRB,0.28497E+02_JPRB /)  
KB(:,23,12) = (/ &
 & 0.21413E+02_JPRB,0.21831E+02_JPRB,0.22594E+02_JPRB,0.23606E+02_JPRB,0.25745E+02_JPRB /)  
KB(:,24,12) = (/ &
 & 0.21009E+02_JPRB,0.21418E+02_JPRB,0.22293E+02_JPRB,0.23189E+02_JPRB,0.24234E+02_JPRB /)  
KB(:,25,12) = (/ &
 & 0.21184E+02_JPRB,0.21661E+02_JPRB,0.22476E+02_JPRB,0.23334E+02_JPRB,0.24471E+02_JPRB /)  
KB(:,26,12) = (/ &
 & 0.21853E+02_JPRB,0.22488E+02_JPRB,0.23205E+02_JPRB,0.24024E+02_JPRB,0.25192E+02_JPRB /)  
KB(:,27,12) = (/ &
 & 0.22275E+02_JPRB,0.22928E+02_JPRB,0.23659E+02_JPRB,0.24768E+02_JPRB,0.25734E+02_JPRB /)  
KB(:,28,12) = (/ &
 & 0.22649E+02_JPRB,0.23413E+02_JPRB,0.24091E+02_JPRB,0.25549E+02_JPRB,0.26436E+02_JPRB /)  
KB(:,29,12) = (/ &
 & 0.22704E+02_JPRB,0.23483E+02_JPRB,0.24191E+02_JPRB,0.25460E+02_JPRB,0.26653E+02_JPRB /)  
KB(:,30,12) = (/ &
 & 0.22666E+02_JPRB,0.23444E+02_JPRB,0.24530E+02_JPRB,0.25500E+02_JPRB,0.26652E+02_JPRB /)  
KB(:,31,12) = (/ &
 & 0.22235E+02_JPRB,0.23247E+02_JPRB,0.24248E+02_JPRB,0.25076E+02_JPRB,0.26466E+02_JPRB /)  
KB(:,32,12) = (/ &
 & 0.22226E+02_JPRB,0.22827E+02_JPRB,0.24083E+02_JPRB,0.25139E+02_JPRB,0.26181E+02_JPRB /)  
KB(:,33,12) = (/ &
 & 0.22210E+02_JPRB,0.22941E+02_JPRB,0.24126E+02_JPRB,0.25269E+02_JPRB,0.26783E+02_JPRB /)  
KB(:,34,12) = (/ &
 & 0.22243E+02_JPRB,0.23077E+02_JPRB,0.24337E+02_JPRB,0.25761E+02_JPRB,0.27799E+02_JPRB /)  
KB(:,35,12) = (/ &
 & 0.22396E+02_JPRB,0.23583E+02_JPRB,0.24898E+02_JPRB,0.26594E+02_JPRB,0.29392E+02_JPRB /)  
KB(:,36,12) = (/ &
 & 0.22982E+02_JPRB,0.24125E+02_JPRB,0.25363E+02_JPRB,0.27311E+02_JPRB,0.30508E+02_JPRB /)  
KB(:,37,12) = (/ &
 & 0.22918E+02_JPRB,0.23937E+02_JPRB,0.25281E+02_JPRB,0.27602E+02_JPRB,0.31235E+02_JPRB /)  
KB(:,38,12) = (/ &
 & 0.22758E+02_JPRB,0.23720E+02_JPRB,0.25240E+02_JPRB,0.28261E+02_JPRB,0.32012E+02_JPRB /)  
KB(:,39,12) = (/ &
 & 0.22553E+02_JPRB,0.23629E+02_JPRB,0.25559E+02_JPRB,0.29164E+02_JPRB,0.32971E+02_JPRB /)  
KB(:,40,12) = (/ &
 & 0.21913E+02_JPRB,0.23010E+02_JPRB,0.25397E+02_JPRB,0.28931E+02_JPRB,0.33000E+02_JPRB /)  
KB(:,41,12) = (/ &
 & 0.21428E+02_JPRB,0.22543E+02_JPRB,0.25193E+02_JPRB,0.28521E+02_JPRB,0.32655E+02_JPRB /)  
KB(:,42,12) = (/ &
 & 0.20806E+02_JPRB,0.22057E+02_JPRB,0.24895E+02_JPRB,0.28307E+02_JPRB,0.32344E+02_JPRB /)  
KB(:,43,12) = (/ &
 & 0.20230E+02_JPRB,0.21402E+02_JPRB,0.24438E+02_JPRB,0.27778E+02_JPRB,0.31742E+02_JPRB /)  
KB(:,44,12) = (/ &
 & 0.19439E+02_JPRB,0.20816E+02_JPRB,0.24038E+02_JPRB,0.27280E+02_JPRB,0.31112E+02_JPRB /)  
KB(:,45,12) = (/ &
 & 0.18615E+02_JPRB,0.20644E+02_JPRB,0.23787E+02_JPRB,0.26906E+02_JPRB,0.30508E+02_JPRB /)  
KB(:,46,12) = (/ &
 & 0.17932E+02_JPRB,0.20436E+02_JPRB,0.23444E+02_JPRB,0.26514E+02_JPRB,0.30043E+02_JPRB /)  
KB(:,47,12) = (/ &
 & 0.17388E+02_JPRB,0.20062E+02_JPRB,0.22865E+02_JPRB,0.25992E+02_JPRB,0.29187E+02_JPRB /)  
KB(:,48,12) = (/ &
 & 0.17144E+02_JPRB,0.19562E+02_JPRB,0.22419E+02_JPRB,0.25556E+02_JPRB,0.28578E+02_JPRB /)  
KB(:,49,12) = (/ &
 & 0.16956E+02_JPRB,0.19439E+02_JPRB,0.22133E+02_JPRB,0.25135E+02_JPRB,0.28141E+02_JPRB /)  
KB(:,50,12) = (/ &
 & 0.16529E+02_JPRB,0.19034E+02_JPRB,0.21605E+02_JPRB,0.24563E+02_JPRB,0.27331E+02_JPRB /)  
KB(:,51,12) = (/ &
 & 0.15953E+02_JPRB,0.18522E+02_JPRB,0.21071E+02_JPRB,0.23856E+02_JPRB,0.26389E+02_JPRB /)  
KB(:,52,12) = (/ &
 & 0.15476E+02_JPRB,0.18037E+02_JPRB,0.20576E+02_JPRB,0.23092E+02_JPRB,0.25303E+02_JPRB /)  
KB(:,53,12) = (/ &
 & 0.14987E+02_JPRB,0.17619E+02_JPRB,0.20150E+02_JPRB,0.22182E+02_JPRB,0.24323E+02_JPRB /)  
KB(:,54,12) = (/ &
 & 0.14316E+02_JPRB,0.16769E+02_JPRB,0.19340E+02_JPRB,0.21295E+02_JPRB,0.23328E+02_JPRB /)  
KB(:,55,12) = (/ &
 & 0.13478E+02_JPRB,0.15723E+02_JPRB,0.18284E+02_JPRB,0.20497E+02_JPRB,0.22282E+02_JPRB /)  
KB(:,56,12) = (/ &
 & 0.12615E+02_JPRB,0.14717E+02_JPRB,0.17222E+02_JPRB,0.19626E+02_JPRB,0.21412E+02_JPRB /)  
KB(:,57,12) = (/ &
 & 0.11789E+02_JPRB,0.13910E+02_JPRB,0.16111E+02_JPRB,0.18559E+02_JPRB,0.20605E+02_JPRB /)  
KB(:,58,12) = (/ &
 & 0.10935E+02_JPRB,0.12994E+02_JPRB,0.15023E+02_JPRB,0.17386E+02_JPRB,0.19630E+02_JPRB /)  
KB(:,59,12) = (/ &
 & 0.10847E+02_JPRB,0.11985E+02_JPRB,0.13699E+02_JPRB,0.15922E+02_JPRB,0.18130E+02_JPRB /)  
KB(:,13,13) = (/ &
 & 0.15243E+03_JPRB,0.15414E+03_JPRB,0.15604E+03_JPRB,0.15731E+03_JPRB,0.15805E+03_JPRB /)  
KB(:,14,13) = (/ &
 & 0.15017E+03_JPRB,0.15285E+03_JPRB,0.15509E+03_JPRB,0.15662E+03_JPRB,0.15764E+03_JPRB /)  
KB(:,15,13) = (/ &
 & 0.14701E+03_JPRB,0.15032E+03_JPRB,0.15250E+03_JPRB,0.15435E+03_JPRB,0.15583E+03_JPRB /)  
KB(:,16,13) = (/ &
 & 0.14269E+03_JPRB,0.14580E+03_JPRB,0.14857E+03_JPRB,0.15094E+03_JPRB,0.15306E+03_JPRB /)  
KB(:,17,13) = (/ &
 & 0.13670E+03_JPRB,0.14035E+03_JPRB,0.14376E+03_JPRB,0.14689E+03_JPRB,0.14976E+03_JPRB /)  
KB(:,18,13) = (/ &
 & 0.13015E+03_JPRB,0.13455E+03_JPRB,0.13871E+03_JPRB,0.14263E+03_JPRB,0.14625E+03_JPRB /)  
KB(:,19,13) = (/ &
 & 0.12287E+03_JPRB,0.12845E+03_JPRB,0.13370E+03_JPRB,0.13836E+03_JPRB,0.14277E+03_JPRB /)  
KB(:,20,13) = (/ &
 & 0.11516E+03_JPRB,0.12176E+03_JPRB,0.12807E+03_JPRB,0.13396E+03_JPRB,0.13973E+03_JPRB /)  
KB(:,21,13) = (/ &
 & 0.10676E+03_JPRB,0.11461E+03_JPRB,0.12196E+03_JPRB,0.12926E+03_JPRB,0.13605E+03_JPRB /)  
KB(:,22,13) = (/ &
 & 0.98495E+02_JPRB,0.10775E+03_JPRB,0.11663E+03_JPRB,0.12493E+03_JPRB,0.13260E+03_JPRB /)  
KB(:,23,13) = (/ &
 & 0.89816E+02_JPRB,0.10015E+03_JPRB,0.11065E+03_JPRB,0.12084E+03_JPRB,0.12951E+03_JPRB /)  
KB(:,24,13) = (/ &
 & 0.82797E+02_JPRB,0.93590E+02_JPRB,0.10444E+03_JPRB,0.11545E+03_JPRB,0.12590E+03_JPRB /)  
KB(:,25,13) = (/ &
 & 0.77256E+02_JPRB,0.88067E+02_JPRB,0.99408E+02_JPRB,0.11069E+03_JPRB,0.12164E+03_JPRB /)  
KB(:,26,13) = (/ &
 & 0.73787E+02_JPRB,0.84230E+02_JPRB,0.95403E+02_JPRB,0.10719E+03_JPRB,0.11797E+03_JPRB /)  
KB(:,27,13) = (/ &
 & 0.72626E+02_JPRB,0.82623E+02_JPRB,0.93417E+02_JPRB,0.10482E+03_JPRB,0.11588E+03_JPRB /)  
KB(:,28,13) = (/ &
 & 0.72289E+02_JPRB,0.81705E+02_JPRB,0.92658E+02_JPRB,0.10355E+03_JPRB,0.11467E+03_JPRB /)  
KB(:,29,13) = (/ &
 & 0.73831E+02_JPRB,0.83248E+02_JPRB,0.93801E+02_JPRB,0.10474E+03_JPRB,0.11551E+03_JPRB /)  
KB(:,30,13) = (/ &
 & 0.76016E+02_JPRB,0.86113E+02_JPRB,0.95367E+02_JPRB,0.10651E+03_JPRB,0.11733E+03_JPRB /)  
KB(:,31,13) = (/ &
 & 0.80058E+02_JPRB,0.89705E+02_JPRB,0.99793E+02_JPRB,0.10982E+03_JPRB,0.12052E+03_JPRB /)  
KB(:,32,13) = (/ &
 & 0.85064E+02_JPRB,0.94860E+02_JPRB,0.10434E+03_JPRB,0.11401E+03_JPRB,0.12404E+03_JPRB /)  
KB(:,33,13) = (/ &
 & 0.90655E+02_JPRB,0.10081E+03_JPRB,0.10992E+03_JPRB,0.11933E+03_JPRB,0.12788E+03_JPRB /)  
KB(:,34,13) = (/ &
 & 0.95857E+02_JPRB,0.10597E+03_JPRB,0.11520E+03_JPRB,0.12356E+03_JPRB,0.13127E+03_JPRB /)  
KB(:,35,13) = (/ &
 & 0.99393E+02_JPRB,0.11014E+03_JPRB,0.12003E+03_JPRB,0.12794E+03_JPRB,0.13407E+03_JPRB /)  
KB(:,36,13) = (/ &
 & 0.10100E+03_JPRB,0.11220E+03_JPRB,0.12221E+03_JPRB,0.13085E+03_JPRB,0.13724E+03_JPRB /)  
KB(:,37,13) = (/ &
 & 0.10052E+03_JPRB,0.11217E+03_JPRB,0.12302E+03_JPRB,0.13127E+03_JPRB,0.13704E+03_JPRB /)  
KB(:,38,13) = (/ &
 & 0.10046E+03_JPRB,0.11273E+03_JPRB,0.12310E+03_JPRB,0.13118E+03_JPRB,0.13742E+03_JPRB /)  
KB(:,39,13) = (/ &
 & 0.10122E+03_JPRB,0.11326E+03_JPRB,0.12361E+03_JPRB,0.13081E+03_JPRB,0.13784E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART16',0,ZHOOK_HANDLE)


KB(:,40,13) = (/ &
 & 0.10000E+03_JPRB,0.11180E+03_JPRB,0.12195E+03_JPRB,0.12930E+03_JPRB,0.13636E+03_JPRB /)  
KB(:,41,13) = (/ &
 & 0.98394E+02_JPRB,0.11024E+03_JPRB,0.11969E+03_JPRB,0.12788E+03_JPRB,0.13497E+03_JPRB /)  
KB(:,42,13) = (/ &
 & 0.97071E+02_JPRB,0.10823E+03_JPRB,0.11769E+03_JPRB,0.12630E+03_JPRB,0.13330E+03_JPRB /)  
KB(:,43,13) = (/ &
 & 0.94820E+02_JPRB,0.10592E+03_JPRB,0.11514E+03_JPRB,0.12393E+03_JPRB,0.13107E+03_JPRB /)  
KB(:,44,13) = (/ &
 & 0.92475E+02_JPRB,0.10313E+03_JPRB,0.11198E+03_JPRB,0.12120E+03_JPRB,0.12869E+03_JPRB /)  
KB(:,45,13) = (/ &
 & 0.90255E+02_JPRB,0.99678E+02_JPRB,0.10888E+03_JPRB,0.11824E+03_JPRB,0.12634E+03_JPRB /)  
KB(:,46,13) = (/ &
 & 0.87084E+02_JPRB,0.96376E+02_JPRB,0.10582E+03_JPRB,0.11496E+03_JPRB,0.12350E+03_JPRB /)  
KB(:,47,13) = (/ &
 & 0.83116E+02_JPRB,0.92026E+02_JPRB,0.10209E+03_JPRB,0.11120E+03_JPRB,0.12020E+03_JPRB /)  
KB(:,48,13) = (/ &
 & 0.78845E+02_JPRB,0.88316E+02_JPRB,0.97984E+02_JPRB,0.10729E+03_JPRB,0.11639E+03_JPRB /)  
KB(:,49,13) = (/ &
 & 0.74841E+02_JPRB,0.84389E+02_JPRB,0.93907E+02_JPRB,0.10286E+03_JPRB,0.11277E+03_JPRB /)  
KB(:,50,13) = (/ &
 & 0.71259E+02_JPRB,0.80370E+02_JPRB,0.89851E+02_JPRB,0.99011E+02_JPRB,0.10882E+03_JPRB /)  
KB(:,51,13) = (/ &
 & 0.67667E+02_JPRB,0.76332E+02_JPRB,0.85552E+02_JPRB,0.95111E+02_JPRB,0.10517E+03_JPRB /)  
KB(:,52,13) = (/ &
 & 0.64036E+02_JPRB,0.72373E+02_JPRB,0.81228E+02_JPRB,0.91458E+02_JPRB,0.10109E+03_JPRB /)  
KB(:,53,13) = (/ &
 & 0.60531E+02_JPRB,0.68539E+02_JPRB,0.77029E+02_JPRB,0.87314E+02_JPRB,0.97171E+02_JPRB /)  
KB(:,54,13) = (/ &
 & 0.57169E+02_JPRB,0.65298E+02_JPRB,0.73473E+02_JPRB,0.83504E+02_JPRB,0.93303E+02_JPRB /)  
KB(:,55,13) = (/ &
 & 0.53955E+02_JPRB,0.61813E+02_JPRB,0.70099E+02_JPRB,0.79656E+02_JPRB,0.89859E+02_JPRB /)  
KB(:,56,13) = (/ &
 & 0.50772E+02_JPRB,0.58658E+02_JPRB,0.66829E+02_JPRB,0.76079E+02_JPRB,0.86127E+02_JPRB /)  
KB(:,57,13) = (/ &
 & 0.47708E+02_JPRB,0.55213E+02_JPRB,0.63250E+02_JPRB,0.72545E+02_JPRB,0.82495E+02_JPRB /)  
KB(:,58,13) = (/ &
 & 0.45026E+02_JPRB,0.52243E+02_JPRB,0.60123E+02_JPRB,0.69281E+02_JPRB,0.79017E+02_JPRB /)  
KB(:,59,13) = (/ &
 & 0.42111E+02_JPRB,0.50365E+02_JPRB,0.58368E+02_JPRB,0.67832E+02_JPRB,0.76877E+02_JPRB /)  
KB(:,13,14) = (/ &
 & 0.32174E+03_JPRB,0.31744E+03_JPRB,0.31218E+03_JPRB,0.30740E+03_JPRB,0.30288E+03_JPRB /)  
KB(:,14,14) = (/ &
 & 0.33593E+03_JPRB,0.33142E+03_JPRB,0.32669E+03_JPRB,0.32231E+03_JPRB,0.31834E+03_JPRB /)  
KB(:,15,14) = (/ &
 & 0.34823E+03_JPRB,0.34389E+03_JPRB,0.34037E+03_JPRB,0.33690E+03_JPRB,0.33355E+03_JPRB /)  
KB(:,16,14) = (/ &
 & 0.35878E+03_JPRB,0.35631E+03_JPRB,0.35376E+03_JPRB,0.35105E+03_JPRB,0.34819E+03_JPRB /)  
KB(:,17,14) = (/ &
 & 0.36906E+03_JPRB,0.36793E+03_JPRB,0.36636E+03_JPRB,0.36433E+03_JPRB,0.36182E+03_JPRB /)  
KB(:,18,14) = (/ &
 & 0.37817E+03_JPRB,0.37835E+03_JPRB,0.37763E+03_JPRB,0.37618E+03_JPRB,0.37389E+03_JPRB /)  
KB(:,19,14) = (/ &
 & 0.38585E+03_JPRB,0.38729E+03_JPRB,0.38746E+03_JPRB,0.38655E+03_JPRB,0.38433E+03_JPRB /)  
KB(:,20,14) = (/ &
 & 0.39236E+03_JPRB,0.39495E+03_JPRB,0.39589E+03_JPRB,0.39530E+03_JPRB,0.39330E+03_JPRB /)  
KB(:,21,14) = (/ &
 & 0.39808E+03_JPRB,0.40159E+03_JPRB,0.40312E+03_JPRB,0.40280E+03_JPRB,0.40090E+03_JPRB /)  
KB(:,22,14) = (/ &
 & 0.40338E+03_JPRB,0.40757E+03_JPRB,0.40933E+03_JPRB,0.40908E+03_JPRB,0.40708E+03_JPRB /)  
KB(:,23,14) = (/ &
 & 0.40834E+03_JPRB,0.41282E+03_JPRB,0.41463E+03_JPRB,0.41442E+03_JPRB,0.41222E+03_JPRB /)  
KB(:,24,14) = (/ &
 & 0.41280E+03_JPRB,0.41739E+03_JPRB,0.41916E+03_JPRB,0.41879E+03_JPRB,0.41631E+03_JPRB /)  
KB(:,25,14) = (/ &
 & 0.41635E+03_JPRB,0.42140E+03_JPRB,0.42295E+03_JPRB,0.42231E+03_JPRB,0.41948E+03_JPRB /)  
KB(:,26,14) = (/ &
 & 0.41887E+03_JPRB,0.42439E+03_JPRB,0.42613E+03_JPRB,0.42509E+03_JPRB,0.42199E+03_JPRB /)  
KB(:,27,14) = (/ &
 & 0.42034E+03_JPRB,0.42637E+03_JPRB,0.42837E+03_JPRB,0.42723E+03_JPRB,0.42380E+03_JPRB /)  
KB(:,28,14) = (/ &
 & 0.42191E+03_JPRB,0.42841E+03_JPRB,0.43008E+03_JPRB,0.42870E+03_JPRB,0.42501E+03_JPRB /)  
KB(:,29,14) = (/ &
 & 0.42351E+03_JPRB,0.42979E+03_JPRB,0.43162E+03_JPRB,0.42986E+03_JPRB,0.42579E+03_JPRB /)  
KB(:,30,14) = (/ &
 & 0.42461E+03_JPRB,0.42985E+03_JPRB,0.43291E+03_JPRB,0.43068E+03_JPRB,0.42610E+03_JPRB /)  
KB(:,31,14) = (/ &
 & 0.42505E+03_JPRB,0.43017E+03_JPRB,0.43191E+03_JPRB,0.43099E+03_JPRB,0.42603E+03_JPRB /)  
KB(:,32,14) = (/ &
 & 0.42362E+03_JPRB,0.42860E+03_JPRB,0.43041E+03_JPRB,0.42915E+03_JPRB,0.42555E+03_JPRB /)  
KB(:,33,14) = (/ &
 & 0.42123E+03_JPRB,0.42505E+03_JPRB,0.42663E+03_JPRB,0.42551E+03_JPRB,0.42290E+03_JPRB /)  
KB(:,34,14) = (/ &
 & 0.41773E+03_JPRB,0.42082E+03_JPRB,0.42178E+03_JPRB,0.42110E+03_JPRB,0.41858E+03_JPRB /)  
KB(:,35,14) = (/ &
 & 0.41435E+03_JPRB,0.41544E+03_JPRB,0.41491E+03_JPRB,0.41443E+03_JPRB,0.41216E+03_JPRB /)  
KB(:,36,14) = (/ &
 & 0.41009E+03_JPRB,0.41065E+03_JPRB,0.40988E+03_JPRB,0.40756E+03_JPRB,0.40367E+03_JPRB /)  
KB(:,37,14) = (/ &
 & 0.40889E+03_JPRB,0.40948E+03_JPRB,0.40755E+03_JPRB,0.40547E+03_JPRB,0.40195E+03_JPRB /)  
KB(:,38,14) = (/ &
 & 0.40736E+03_JPRB,0.40781E+03_JPRB,0.40666E+03_JPRB,0.40322E+03_JPRB,0.39939E+03_JPRB /)  
KB(:,39,14) = (/ &
 & 0.40514E+03_JPRB,0.40605E+03_JPRB,0.40431E+03_JPRB,0.40166E+03_JPRB,0.39666E+03_JPRB /)  
KB(:,40,14) = (/ &
 & 0.40543E+03_JPRB,0.40633E+03_JPRB,0.40490E+03_JPRB,0.40260E+03_JPRB,0.39791E+03_JPRB /)  
KB(:,41,14) = (/ &
 & 0.40503E+03_JPRB,0.40615E+03_JPRB,0.40599E+03_JPRB,0.40348E+03_JPRB,0.39947E+03_JPRB /)  
KB(:,42,14) = (/ &
 & 0.40408E+03_JPRB,0.40664E+03_JPRB,0.40681E+03_JPRB,0.40441E+03_JPRB,0.40107E+03_JPRB /)  
KB(:,43,14) = (/ &
 & 0.40250E+03_JPRB,0.40659E+03_JPRB,0.40791E+03_JPRB,0.40633E+03_JPRB,0.40362E+03_JPRB /)  
KB(:,44,14) = (/ &
 & 0.40121E+03_JPRB,0.40653E+03_JPRB,0.40934E+03_JPRB,0.40832E+03_JPRB,0.40616E+03_JPRB /)  
KB(:,45,14) = (/ &
 & 0.39928E+03_JPRB,0.40669E+03_JPRB,0.41014E+03_JPRB,0.41010E+03_JPRB,0.40849E+03_JPRB /)  
KB(:,46,14) = (/ &
 & 0.39656E+03_JPRB,0.40551E+03_JPRB,0.41027E+03_JPRB,0.41167E+03_JPRB,0.41068E+03_JPRB /)  
KB(:,47,14) = (/ &
 & 0.39317E+03_JPRB,0.40403E+03_JPRB,0.40985E+03_JPRB,0.41273E+03_JPRB,0.41264E+03_JPRB /)  
KB(:,48,14) = (/ &
 & 0.38915E+03_JPRB,0.40116E+03_JPRB,0.40932E+03_JPRB,0.41346E+03_JPRB,0.41469E+03_JPRB /)  
KB(:,49,14) = (/ &
 & 0.38398E+03_JPRB,0.39755E+03_JPRB,0.40789E+03_JPRB,0.41416E+03_JPRB,0.41577E+03_JPRB /)  
KB(:,50,14) = (/ &
 & 0.37757E+03_JPRB,0.39396E+03_JPRB,0.40616E+03_JPRB,0.41381E+03_JPRB,0.41707E+03_JPRB /)  
KB(:,51,14) = (/ &
 & 0.37117E+03_JPRB,0.38987E+03_JPRB,0.40415E+03_JPRB,0.41318E+03_JPRB,0.41740E+03_JPRB /)  
KB(:,52,14) = (/ &
 & 0.36408E+03_JPRB,0.38505E+03_JPRB,0.40161E+03_JPRB,0.41151E+03_JPRB,0.41801E+03_JPRB /)  
KB(:,53,14) = (/ &
 & 0.35611E+03_JPRB,0.37948E+03_JPRB,0.39824E+03_JPRB,0.40994E+03_JPRB,0.41764E+03_JPRB /)  
KB(:,54,14) = (/ &
 & 0.34712E+03_JPRB,0.37341E+03_JPRB,0.39425E+03_JPRB,0.40798E+03_JPRB,0.41739E+03_JPRB /)  
KB(:,55,14) = (/ &
 & 0.33857E+03_JPRB,0.36757E+03_JPRB,0.38995E+03_JPRB,0.40583E+03_JPRB,0.41654E+03_JPRB /)  
KB(:,56,14) = (/ &
 & 0.32949E+03_JPRB,0.36056E+03_JPRB,0.38492E+03_JPRB,0.40281E+03_JPRB,0.41532E+03_JPRB /)  
KB(:,57,14) = (/ &
 & 0.31954E+03_JPRB,0.35312E+03_JPRB,0.37997E+03_JPRB,0.39944E+03_JPRB,0.41349E+03_JPRB /)  
KB(:,58,14) = (/ &
 & 0.30943E+03_JPRB,0.34518E+03_JPRB,0.37428E+03_JPRB,0.39571E+03_JPRB,0.41155E+03_JPRB /)  
KB(:,59,14) = (/ &
 & 0.30628E+03_JPRB,0.34259E+03_JPRB,0.37284E+03_JPRB,0.39463E+03_JPRB,0.41220E+03_JPRB /)  
KB(:,13,15) = (/ &
 & 0.58702E+03_JPRB,0.56862E+03_JPRB,0.55331E+03_JPRB,0.53896E+03_JPRB,0.52495E+03_JPRB /)  
KB(:,14,15) = (/ &
 & 0.64037E+03_JPRB,0.62129E+03_JPRB,0.60436E+03_JPRB,0.58772E+03_JPRB,0.57127E+03_JPRB /)  
KB(:,15,15) = (/ &
 & 0.69642E+03_JPRB,0.67640E+03_JPRB,0.65677E+03_JPRB,0.63714E+03_JPRB,0.61752E+03_JPRB /)  
KB(:,16,15) = (/ &
 & 0.75408E+03_JPRB,0.73150E+03_JPRB,0.70834E+03_JPRB,0.68512E+03_JPRB,0.66206E+03_JPRB /)  
KB(:,17,15) = (/ &
 & 0.81156E+03_JPRB,0.78496E+03_JPRB,0.75773E+03_JPRB,0.73064E+03_JPRB,0.70441E+03_JPRB /)  
KB(:,18,15) = (/ &
 & 0.86684E+03_JPRB,0.83552E+03_JPRB,0.80425E+03_JPRB,0.77370E+03_JPRB,0.74441E+03_JPRB /)  
KB(:,19,15) = (/ &
 & 0.91879E+03_JPRB,0.88284E+03_JPRB,0.84773E+03_JPRB,0.81356E+03_JPRB,0.78105E+03_JPRB /)  
KB(:,20,15) = (/ &
 & 0.96599E+03_JPRB,0.92558E+03_JPRB,0.88651E+03_JPRB,0.84884E+03_JPRB,0.81303E+03_JPRB /)  
KB(:,21,15) = (/ &
 & 0.10076E+04_JPRB,0.96291E+03_JPRB,0.92009E+03_JPRB,0.87920E+03_JPRB,0.84047E+03_JPRB /)  
KB(:,22,15) = (/ &
 & 0.10401E+04_JPRB,0.99157E+03_JPRB,0.94567E+03_JPRB,0.90208E+03_JPRB,0.86095E+03_JPRB /)  
KB(:,23,15) = (/ &
 & 0.10659E+04_JPRB,0.10143E+04_JPRB,0.96587E+03_JPRB,0.91983E+03_JPRB,0.87686E+03_JPRB /)  
KB(:,24,15) = (/ &
 & 0.10857E+04_JPRB,0.10316E+04_JPRB,0.98077E+03_JPRB,0.93285E+03_JPRB,0.88829E+03_JPRB /)  
KB(:,25,15) = (/ &
 & 0.10994E+04_JPRB,0.10434E+04_JPRB,0.99070E+03_JPRB,0.94138E+03_JPRB,0.89569E+03_JPRB /)  
KB(:,26,15) = (/ &
 & 0.11072E+04_JPRB,0.10495E+04_JPRB,0.99578E+03_JPRB,0.94553E+03_JPRB,0.89886E+03_JPRB /)  
KB(:,27,15) = (/ &
 & 0.11107E+04_JPRB,0.10519E+04_JPRB,0.99732E+03_JPRB,0.94654E+03_JPRB,0.89932E+03_JPRB /)  
KB(:,28,15) = (/ &
 & 0.11104E+04_JPRB,0.10510E+04_JPRB,0.99596E+03_JPRB,0.94493E+03_JPRB,0.89744E+03_JPRB /)  
KB(:,29,15) = (/ &
 & 0.11068E+04_JPRB,0.10472E+04_JPRB,0.99206E+03_JPRB,0.94099E+03_JPRB,0.89320E+03_JPRB /)  
KB(:,30,15) = (/ &
 & 0.11008E+04_JPRB,0.10413E+04_JPRB,0.98636E+03_JPRB,0.93544E+03_JPRB,0.88772E+03_JPRB /)  
KB(:,31,15) = (/ &
 & 0.10926E+04_JPRB,0.10334E+04_JPRB,0.97895E+03_JPRB,0.92827E+03_JPRB,0.88094E+03_JPRB /)  
KB(:,32,15) = (/ &
 & 0.10829E+04_JPRB,0.10242E+04_JPRB,0.97015E+03_JPRB,0.91986E+03_JPRB,0.87315E+03_JPRB /)  
KB(:,33,15) = (/ &
 & 0.10718E+04_JPRB,0.10140E+04_JPRB,0.96048E+03_JPRB,0.91059E+03_JPRB,0.86462E+03_JPRB /)  
KB(:,34,15) = (/ &
 & 0.10622E+04_JPRB,0.10049E+04_JPRB,0.95198E+03_JPRB,0.90258E+03_JPRB,0.85725E+03_JPRB /)  
KB(:,35,15) = (/ &
 & 0.10576E+04_JPRB,0.10006E+04_JPRB,0.94772E+03_JPRB,0.89854E+03_JPRB,0.85365E+03_JPRB /)  
KB(:,36,15) = (/ &
 & 0.10589E+04_JPRB,0.10017E+04_JPRB,0.94880E+03_JPRB,0.89934E+03_JPRB,0.85436E+03_JPRB /)  
KB(:,37,15) = (/ &
 & 0.10689E+04_JPRB,0.10108E+04_JPRB,0.95721E+03_JPRB,0.90723E+03_JPRB,0.86136E+03_JPRB /)  
KB(:,38,15) = (/ &
 & 0.10792E+04_JPRB,0.10202E+04_JPRB,0.96581E+03_JPRB,0.91534E+03_JPRB,0.86861E+03_JPRB /)  
KB(:,39,15) = (/ &
 & 0.10893E+04_JPRB,0.10294E+04_JPRB,0.97432E+03_JPRB,0.92308E+03_JPRB,0.87586E+03_JPRB /)  
KB(:,40,15) = (/ &
 & 0.11025E+04_JPRB,0.10445E+04_JPRB,0.98826E+03_JPRB,0.93598E+03_JPRB,0.88770E+03_JPRB /)  
KB(:,41,15) = (/ &
 & 0.11189E+04_JPRB,0.10606E+04_JPRB,0.10030E+04_JPRB,0.94969E+03_JPRB,0.90027E+03_JPRB /)  
KB(:,42,15) = (/ &
 & 0.11355E+04_JPRB,0.10769E+04_JPRB,0.10180E+04_JPRB,0.96359E+03_JPRB,0.91305E+03_JPRB /)  
KB(:,43,15) = (/ &
 & 0.11585E+04_JPRB,0.10971E+04_JPRB,0.10364E+04_JPRB,0.98067E+03_JPRB,0.92886E+03_JPRB /)  
KB(:,44,15) = (/ &
 & 0.11827E+04_JPRB,0.11193E+04_JPRB,0.10568E+04_JPRB,0.99947E+03_JPRB,0.94636E+03_JPRB /)  
KB(:,45,15) = (/ &
 & 0.12075E+04_JPRB,0.11422E+04_JPRB,0.10778E+04_JPRB,0.10187E+04_JPRB,0.96421E+03_JPRB /)  
KB(:,46,15) = (/ &
 & 0.12357E+04_JPRB,0.11671E+04_JPRB,0.11007E+04_JPRB,0.10396E+04_JPRB,0.98362E+03_JPRB /)  
KB(:,47,15) = (/ &
 & 0.12667E+04_JPRB,0.11958E+04_JPRB,0.11271E+04_JPRB,0.10639E+04_JPRB,0.10059E+04_JPRB /)  
KB(:,48,15) = (/ &
 & 0.12983E+04_JPRB,0.12254E+04_JPRB,0.11543E+04_JPRB,0.10888E+04_JPRB,0.10288E+04_JPRB /)  
KB(:,49,15) = (/ &
 & 0.13304E+04_JPRB,0.12559E+04_JPRB,0.11825E+04_JPRB,0.11147E+04_JPRB,0.10526E+04_JPRB /)  
KB(:,50,15) = (/ &
 & 0.13621E+04_JPRB,0.12852E+04_JPRB,0.12096E+04_JPRB,0.11397E+04_JPRB,0.10755E+04_JPRB /)  
KB(:,51,15) = (/ &
 & 0.13919E+04_JPRB,0.13140E+04_JPRB,0.12368E+04_JPRB,0.11648E+04_JPRB,0.10985E+04_JPRB /)  
KB(:,52,15) = (/ &
 & 0.14222E+04_JPRB,0.13432E+04_JPRB,0.12647E+04_JPRB,0.11905E+04_JPRB,0.11221E+04_JPRB /)  
KB(:,53,15) = (/ &
 & 0.14531E+04_JPRB,0.13729E+04_JPRB,0.12932E+04_JPRB,0.12171E+04_JPRB,0.11465E+04_JPRB /)  
KB(:,54,15) = (/ &
 & 0.14842E+04_JPRB,0.14002E+04_JPRB,0.13197E+04_JPRB,0.12421E+04_JPRB,0.11696E+04_JPRB /)  
KB(:,55,15) = (/ &
 & 0.15120E+04_JPRB,0.14267E+04_JPRB,0.13453E+04_JPRB,0.12667E+04_JPRB,0.11922E+04_JPRB /)  
KB(:,56,15) = (/ &
 & 0.15401E+04_JPRB,0.14538E+04_JPRB,0.13712E+04_JPRB,0.12915E+04_JPRB,0.12155E+04_JPRB /)  
KB(:,57,15) = (/ &
 & 0.15682E+04_JPRB,0.14811E+04_JPRB,0.13973E+04_JPRB,0.13167E+04_JPRB,0.12393E+04_JPRB /)  
KB(:,58,15) = (/ &
 & 0.15949E+04_JPRB,0.15073E+04_JPRB,0.14224E+04_JPRB,0.13410E+04_JPRB,0.12625E+04_JPRB /)  
KB(:,59,15) = (/ &
 & 0.16055E+04_JPRB,0.15180E+04_JPRB,0.14326E+04_JPRB,0.13507E+04_JPRB,0.12718E+04_JPRB /)  
KB(:,13,16) = (/ &
 & 0.98069E+03_JPRB,0.94212E+03_JPRB,0.90378E+03_JPRB,0.86861E+03_JPRB,0.83780E+03_JPRB /)  
KB(:,14,16) = (/ &
 & 0.11010E+04_JPRB,0.10540E+04_JPRB,0.10095E+04_JPRB,0.96975E+03_JPRB,0.93339E+03_JPRB /)  
KB(:,15,16) = (/ &
 & 0.12287E+04_JPRB,0.11714E+04_JPRB,0.11195E+04_JPRB,0.10736E+04_JPRB,0.10305E+04_JPRB /)  
KB(:,16,16) = (/ &
 & 0.13596E+04_JPRB,0.12909E+04_JPRB,0.12306E+04_JPRB,0.11762E+04_JPRB,0.11252E+04_JPRB /)  
KB(:,17,16) = (/ &
 & 0.14895E+04_JPRB,0.14091E+04_JPRB,0.13394E+04_JPRB,0.12751E+04_JPRB,0.12151E+04_JPRB /)  
KB(:,18,16) = (/ &
 & 0.16148E+04_JPRB,0.15230E+04_JPRB,0.14425E+04_JPRB,0.13683E+04_JPRB,0.12989E+04_JPRB /)  
KB(:,19,16) = (/ &
 & 0.17336E+04_JPRB,0.16302E+04_JPRB,0.15375E+04_JPRB,0.14530E+04_JPRB,0.13744E+04_JPRB /)  
KB(:,20,16) = (/ &
 & 0.18405E+04_JPRB,0.17248E+04_JPRB,0.16208E+04_JPRB,0.15267E+04_JPRB,0.14397E+04_JPRB /)  
KB(:,21,16) = (/ &
 & 0.19359E+04_JPRB,0.18083E+04_JPRB,0.16938E+04_JPRB,0.15909E+04_JPRB,0.14962E+04_JPRB /)  
KB(:,22,16) = (/ &
 & 0.20085E+04_JPRB,0.18707E+04_JPRB,0.17478E+04_JPRB,0.16373E+04_JPRB,0.15366E+04_JPRB /)  
KB(:,23,16) = (/ &
 & 0.20648E+04_JPRB,0.19188E+04_JPRB,0.17890E+04_JPRB,0.16725E+04_JPRB,0.15672E+04_JPRB /)  
KB(:,24,16) = (/ &
 & 0.21054E+04_JPRB,0.19528E+04_JPRB,0.18178E+04_JPRB,0.16967E+04_JPRB,0.15881E+04_JPRB /)  
KB(:,25,16) = (/ &
 & 0.21318E+04_JPRB,0.19742E+04_JPRB,0.18353E+04_JPRB,0.17113E+04_JPRB,0.16005E+04_JPRB /)  
KB(:,26,16) = (/ &
 & 0.21433E+04_JPRB,0.19836E+04_JPRB,0.18416E+04_JPRB,0.17161E+04_JPRB,0.16044E+04_JPRB /)  
KB(:,27,16) = (/ &
 & 0.21445E+04_JPRB,0.19835E+04_JPRB,0.18409E+04_JPRB,0.17145E+04_JPRB,0.16033E+04_JPRB /)  
KB(:,28,16) = (/ &
 & 0.21374E+04_JPRB,0.19764E+04_JPRB,0.18336E+04_JPRB,0.17081E+04_JPRB,0.15978E+04_JPRB /)  
KB(:,29,16) = (/ &
 & 0.21225E+04_JPRB,0.19618E+04_JPRB,0.18208E+04_JPRB,0.16961E+04_JPRB,0.15894E+04_JPRB /)  
KB(:,30,16) = (/ &
 & 0.21033E+04_JPRB,0.19434E+04_JPRB,0.18039E+04_JPRB,0.16808E+04_JPRB,0.15775E+04_JPRB /)  
KB(:,31,16) = (/ &
 & 0.20779E+04_JPRB,0.19206E+04_JPRB,0.17837E+04_JPRB,0.16635E+04_JPRB,0.15631E+04_JPRB /)  
KB(:,32,16) = (/ &
 & 0.20491E+04_JPRB,0.18949E+04_JPRB,0.17612E+04_JPRB,0.16447E+04_JPRB,0.15471E+04_JPRB /)  
KB(:,33,16) = (/ &
 & 0.20177E+04_JPRB,0.18682E+04_JPRB,0.17367E+04_JPRB,0.16246E+04_JPRB,0.15302E+04_JPRB /)  
KB(:,34,16) = (/ &
 & 0.19905E+04_JPRB,0.18445E+04_JPRB,0.17155E+04_JPRB,0.16076E+04_JPRB,0.15146E+04_JPRB /)  
KB(:,35,16) = (/ &
 & 0.19774E+04_JPRB,0.18329E+04_JPRB,0.17061E+04_JPRB,0.16001E+04_JPRB,0.15070E+04_JPRB /)  
KB(:,36,16) = (/ &
 & 0.19799E+04_JPRB,0.18350E+04_JPRB,0.17079E+04_JPRB,0.16017E+04_JPRB,0.15083E+04_JPRB /)  
KB(:,37,16) = (/ &
 & 0.20051E+04_JPRB,0.18569E+04_JPRB,0.17271E+04_JPRB,0.16176E+04_JPRB,0.15230E+04_JPRB /)  
KB(:,38,16) = (/ &
 & 0.20315E+04_JPRB,0.18800E+04_JPRB,0.17473E+04_JPRB,0.16343E+04_JPRB,0.15379E+04_JPRB /)  
KB(:,39,16) = (/ &
 & 0.20576E+04_JPRB,0.19026E+04_JPRB,0.17672E+04_JPRB,0.16508E+04_JPRB,0.15527E+04_JPRB /)  
KB(:,40,16) = (/ &
 & 0.21013E+04_JPRB,0.19405E+04_JPRB,0.18004E+04_JPRB,0.16787E+04_JPRB,0.15771E+04_JPRB /)  
KB(:,41,16) = (/ &
 & 0.21482E+04_JPRB,0.19814E+04_JPRB,0.18363E+04_JPRB,0.17091E+04_JPRB,0.16029E+04_JPRB /)  
KB(:,42,16) = (/ &
 & 0.21964E+04_JPRB,0.20236E+04_JPRB,0.18732E+04_JPRB,0.17410E+04_JPRB,0.16295E+04_JPRB /)  
KB(:,43,16) = (/ &
 & 0.22568E+04_JPRB,0.20769E+04_JPRB,0.19193E+04_JPRB,0.17816E+04_JPRB,0.16630E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART17',0,ZHOOK_HANDLE)


KB(:,44,16) = (/ &
 & 0.23247E+04_JPRB,0.21362E+04_JPRB,0.19712E+04_JPRB,0.18270E+04_JPRB,0.17012E+04_JPRB /)  
KB(:,45,16) = (/ &
 & 0.23959E+04_JPRB,0.21983E+04_JPRB,0.20252E+04_JPRB,0.18744E+04_JPRB,0.17420E+04_JPRB /)  
KB(:,46,16) = (/ &
 & 0.24748E+04_JPRB,0.22670E+04_JPRB,0.20858E+04_JPRB,0.19269E+04_JPRB,0.17884E+04_JPRB /)  
KB(:,47,16) = (/ &
 & 0.25688E+04_JPRB,0.23479E+04_JPRB,0.21568E+04_JPRB,0.19886E+04_JPRB,0.18424E+04_JPRB /)  
KB(:,48,16) = (/ &
 & 0.26704E+04_JPRB,0.24334E+04_JPRB,0.22313E+04_JPRB,0.20542E+04_JPRB,0.18994E+04_JPRB /)  
KB(:,49,16) = (/ &
 & 0.27805E+04_JPRB,0.25238E+04_JPRB,0.23096E+04_JPRB,0.21232E+04_JPRB,0.19594E+04_JPRB /)  
KB(:,50,16) = (/ &
 & 0.28920E+04_JPRB,0.26151E+04_JPRB,0.23873E+04_JPRB,0.21911E+04_JPRB,0.20186E+04_JPRB /)  
KB(:,51,16) = (/ &
 & 0.30093E+04_JPRB,0.27098E+04_JPRB,0.24666E+04_JPRB,0.22601E+04_JPRB,0.20794E+04_JPRB /)  
KB(:,52,16) = (/ &
 & 0.31338E+04_JPRB,0.28121E+04_JPRB,0.25503E+04_JPRB,0.23323E+04_JPRB,0.21428E+04_JPRB /)  
KB(:,53,16) = (/ &
 & 0.32663E+04_JPRB,0.29228E+04_JPRB,0.26405E+04_JPRB,0.24086E+04_JPRB,0.22095E+04_JPRB /)  
KB(:,54,16) = (/ &
 & 0.33958E+04_JPRB,0.30317E+04_JPRB,0.27288E+04_JPRB,0.24819E+04_JPRB,0.22731E+04_JPRB /)  
KB(:,55,16) = (/ &
 & 0.35272E+04_JPRB,0.31418E+04_JPRB,0.28194E+04_JPRB,0.25560E+04_JPRB,0.23371E+04_JPRB /)  
KB(:,56,16) = (/ &
 & 0.36664E+04_JPRB,0.32577E+04_JPRB,0.29162E+04_JPRB,0.26350E+04_JPRB,0.24040E+04_JPRB /)  
KB(:,57,16) = (/ &
 & 0.38139E+04_JPRB,0.33808E+04_JPRB,0.30193E+04_JPRB,0.27188E+04_JPRB,0.24736E+04_JPRB /)  
KB(:,58,16) = (/ &
 & 0.39629E+04_JPRB,0.35038E+04_JPRB,0.31229E+04_JPRB,0.28034E+04_JPRB,0.25431E+04_JPRB /)  
KB(:,59,16) = (/ &
 & 0.40252E+04_JPRB,0.35562E+04_JPRB,0.31659E+04_JPRB,0.28393E+04_JPRB,0.25724E+04_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.525585E-05_JPRB, 0.527618E-05_JPRB, 0.746929E-04_JPRB /)
FORREF(:, 2) = (/ 0.794660E-05_JPRB, 0.136902E-04_JPRB, 0.849878E-04_JPRB /)
FORREF(:, 3) = (/ 0.197099E-04_JPRB, 0.733094E-04_JPRB, 0.121687E-03_JPRB /)
FORREF(:, 4) = (/ 0.148274E-03_JPRB, 0.169776E-03_JPRB, 0.164848E-03_JPRB /)
FORREF(:, 5) = (/ 0.230296E-03_JPRB, 0.210384E-03_JPRB, 0.182028E-03_JPRB /)
FORREF(:, 6) = (/ 0.280575E-03_JPRB, 0.259217E-03_JPRB, 0.196080E-03_JPRB /)
FORREF(:, 7) = (/ 0.329034E-03_JPRB, 0.291575E-03_JPRB, 0.207044E-03_JPRB /)
FORREF(:, 8) = (/ 0.349989E-03_JPRB, 0.323471E-03_JPRB, 0.225712E-03_JPRB /)
FORREF(:, 9) = (/ 0.366097E-03_JPRB, 0.321519E-03_JPRB, 0.253150E-03_JPRB /)
FORREF(:,10) = (/ 0.383589E-03_JPRB, 0.355314E-03_JPRB, 0.262555E-03_JPRB /)
FORREF(:,11) = (/ 0.375933E-03_JPRB, 0.372443E-03_JPRB, 0.261313E-03_JPRB /)
FORREF(:,12) = (/ 0.370652E-03_JPRB, 0.382366E-03_JPRB, 0.250070E-03_JPRB /)
FORREF(:,13) = (/ 0.375092E-03_JPRB, 0.379542E-03_JPRB, 0.265794E-03_JPRB /)
FORREF(:,14) = (/ 0.389705E-03_JPRB, 0.384274E-03_JPRB, 0.322135E-03_JPRB /)
FORREF(:,15) = (/ 0.372084E-03_JPRB, 0.390422E-03_JPRB, 0.370035E-03_JPRB /)
FORREF(:,16) = (/ 0.437802E-03_JPRB, 0.373406E-03_JPRB, 0.373222E-03_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.126758E-02_JPRB, 0.105253E-02_JPRB, 0.873963E-03_JPRB, 0.725690E-03_JPRB, 0.602573E-03_JPRB, &
 & 0.500344E-03_JPRB, 0.415458E-03_JPRB, 0.344973E-03_JPRB, 0.286447E-03_JPRB, 0.237849E-03_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.144006E-02_JPRB, 0.118514E-02_JPRB, 0.975351E-03_JPRB, 0.802697E-03_JPRB, 0.660606E-03_JPRB, &
 & 0.543667E-03_JPRB, 0.447429E-03_JPRB, 0.368226E-03_JPRB, 0.303044E-03_JPRB, 0.249400E-03_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.294018E-02_JPRB, 0.227428E-02_JPRB, 0.175920E-02_JPRB, 0.136077E-02_JPRB, 0.105258E-02_JPRB, &
 & 0.814189E-03_JPRB, 0.629789E-03_JPRB, 0.487153E-03_JPRB, 0.376821E-03_JPRB, 0.291478E-03_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.395290E-02_JPRB, 0.348405E-02_JPRB, 0.307081E-02_JPRB, 0.270658E-02_JPRB, 0.238556E-02_JPRB, &
 & 0.210261E-02_JPRB, 0.185322E-02_JPRB, 0.163341E-02_JPRB, 0.143967E-02_JPRB, 0.126891E-02_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.419122E-02_JPRB, 0.385638E-02_JPRB, 0.354829E-02_JPRB, 0.326481E-02_JPRB, 0.300398E-02_JPRB, &
 & 0.276399E-02_JPRB, 0.254317E-02_JPRB, 0.234000E-02_JPRB, 0.215305E-02_JPRB, 0.198104E-02_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.495659E-02_JPRB, 0.456777E-02_JPRB, 0.420945E-02_JPRB, 0.387924E-02_JPRB, 0.357494E-02_JPRB, &
 & 0.329450E-02_JPRB, 0.303606E-02_JPRB, 0.279790E-02_JPRB, 0.257842E-02_JPRB, 0.237615E-02_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.526981E-02_JPRB, 0.490687E-02_JPRB, 0.456893E-02_JPRB, 0.425426E-02_JPRB, 0.396126E-02_JPRB, &
 & 0.368844E-02_JPRB, 0.343441E-02_JPRB, 0.319788E-02_JPRB, 0.297764E-02_JPRB, 0.277256E-02_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.575426E-02_JPRB, 0.531597E-02_JPRB, 0.491106E-02_JPRB, 0.453699E-02_JPRB, 0.419141E-02_JPRB, &
 & 0.387216E-02_JPRB, 0.357722E-02_JPRB, 0.330475E-02_JPRB, 0.305303E-02_JPRB, 0.282048E-02_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.549881E-02_JPRB, 0.514328E-02_JPRB, 0.481074E-02_JPRB, 0.449970E-02_JPRB, 0.420877E-02_JPRB, &
 & 0.393665E-02_JPRB, 0.368213E-02_JPRB, 0.344406E-02_JPRB, 0.322138E-02_JPRB, 0.301310E-02_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.605357E-02_JPRB, 0.561246E-02_JPRB, 0.520349E-02_JPRB, 0.482432E-02_JPRB, 0.447278E-02_JPRB, &
 & 0.414686E-02_JPRB, 0.384469E-02_JPRB, 0.356453E-02_JPRB, 0.330479E-02_JPRB, 0.306398E-02_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.640504E-02_JPRB, 0.587858E-02_JPRB, 0.539540E-02_JPRB, 0.495194E-02_JPRB, 0.454492E-02_JPRB, &
 & 0.417136E-02_JPRB, 0.382850E-02_JPRB, 0.351382E-02_JPRB, 0.322501E-02_JPRB, 0.295993E-02_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.677803E-02_JPRB, 0.615625E-02_JPRB, 0.559152E-02_JPRB, 0.507859E-02_JPRB, 0.461271E-02_JPRB, &
 & 0.418957E-02_JPRB, 0.380524E-02_JPRB, 0.345617E-02_JPRB, 0.313913E-02_JPRB, 0.285116E-02_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.690347E-02_JPRB, 0.627003E-02_JPRB, 0.569472E-02_JPRB, 0.517219E-02_JPRB, 0.469761E-02_JPRB, &
 & 0.426658E-02_JPRB, 0.387509E-02_JPRB, 0.351953E-02_JPRB, 0.319659E-02_JPRB, 0.290328E-02_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.692680E-02_JPRB, 0.632795E-02_JPRB, 0.578087E-02_JPRB, 0.528109E-02_JPRB, 0.482452E-02_JPRB, &
 & 0.440742E-02_JPRB, 0.402638E-02_JPRB, 0.367828E-02_JPRB, 0.336028E-02_JPRB, 0.306977E-02_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.754894E-02_JPRB, 0.681481E-02_JPRB, 0.615207E-02_JPRB, 0.555378E-02_JPRB, 0.501367E-02_JPRB, &
 & 0.452609E-02_JPRB, 0.408593E-02_JPRB, 0.368857E-02_JPRB, 0.332986E-02_JPRB, 0.300603E-02_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.760689E-02_JPRB, 0.709755E-02_JPRB, 0.662232E-02_JPRB, 0.617891E-02_JPRB, 0.576519E-02_JPRB, &
 & 0.537917E-02_JPRB, 0.501899E-02_JPRB, 0.468293E-02_JPRB, 0.436938E-02_JPRB, 0.407682E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB16:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


END SUBROUTINE SRTM_KGB16

