
! $Header$

SUBROUTINE ustarhb(klon, klev, knon, u, v, cd_m, ustar)
  IMPLICIT NONE
  ! ======================================================================
  ! Laurent Li (LMD/CNRS), le 30 septembre 1998
  ! Couche limite non-locale. Adaptation du code du CCM3.
  ! Code non teste, donc a ne pas utiliser.
  ! ======================================================================
  ! Nonlocal scheme that determines eddy diffusivities based on a
  ! diagnosed boundary layer height and a turbulent velocity scale.
  ! Also countergradient effects for heat and moisture are included.

  ! For more information, see Holtslag, A.A.M., and B.A. Boville, 1993:
  ! Local versus nonlocal boundary-layer diffusion in a global climate
  ! model. J. of Climate, vol. 6, 1825-1842.
  ! ======================================================================

  ! Arguments:

  INTEGER, INTENT(IN) :: klon, klev, knon ! nombre de points a calculer
  REAL, DIMENSION(klon, klev), INTENT(IN) :: u,v ! vent horizontal (m/s)
  REAL, DIMENSION(klon), INTENT(IN) :: cd_m ! coefficient de friction au sol pour vitesse
  REAL, DIMENSION(klon), INTENT(OUT) :: ustar

  INTEGER :: i, k
  REAL :: zxt, zxq, zxu, zxv, zxmod, taux, tauy
  REAL :: zx_alf1, zx_alf2 ! parametres pour extrapolation

  DO i = 1, knon
    zx_alf1 = 1.0
    zx_alf2 = 1.0 - zx_alf1
    zxu = u(i, 1)*zx_alf1 + u(i, 2)*zx_alf2
    zxv = v(i, 1)*zx_alf1 + v(i, 2)*zx_alf2
    zxmod = 1.0 + sqrt(zxu**2+zxv**2)
    taux = zxu*zxmod*cd_m(i)
    tauy = zxv*zxmod*cd_m(i)
    ustar(i) = sqrt(taux**2+tauy**2)
  END DO

  RETURN
END SUBROUTINE ustarhb
