SUBROUTINE SRTM_TAUMOL20 &
 & ( KLEV,&
 & P_FAC00   , P_FAC01  , P_FAC10   , P_FAC11,&
 & K_JP      , K_JT     , K_JT1     , P_ONEMINUS,&
 & P_COLH2O  , P_COLCH4 , P_COLMOL,&
 & K_LAYTROP , P_SELFFAC, P_SELFFRAC, K_INDSELF  , P_FORFAC, P_FORFRAC, K_INDFOR,&
 & P_SFLUXZEN, P_TAUG   , P_TAUR    &
 & )  

!     Written by Eli J. Mlawer, Atmospheric & Environmental Research.

!     BAND 20:  5150-6150 cm-1 (low - H2O; high - H2O)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     JJMorcrette 2003-02-24 adapted to ECMWF environment

!      PARAMETER (MG=16, MXLAY=203, NBANDS=14)

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARSRTM  , ONLY : JPLAY, JPG, NG20
USE YOESRTA20, ONLY : ABSA, ABSB, FORREFC, SELFREFC &
 & , SFLUXREFC, ABSCH4C, RAYL &
 & , LAYREFFR  
USE YOESRTWN , ONLY : NSPA, NSPB

IMPLICIT NONE

!-- Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)                  :: P_ONEMINUS ! Argument NOT used
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCH4(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLMOL(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDFOR(JPLAY) 

REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_SFLUXZEN(JPG) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAUG(JPLAY,JPG) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAUR(JPLAY,JPG) 
!- from INTFAC      
!- from INTIND
!- from PRECISE             
!- from PROFDATA             
!- from SELF             
INTEGER(KIND=JPIM) :: IG, IND0, IND1, INDS, INDF, I_LAY, I_LAYSOLFR, I_NLAYERS

REAL(KIND=JPRB) ::  &
 & Z_TAURAY  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_TAUMOL20',0,ZHOOK_HANDLE)
I_NLAYERS = KLEV

!     Compute the optical depth by interpolating in ln(pressure), 
!     temperature, and appropriate species.  Below LAYTROP, the water
!     vapor self-continuum is interpolated (in temperature) separately.  

I_LAYSOLFR = K_LAYTROP

DO I_LAY = 1, K_LAYTROP
  IF (K_JP(I_LAY) < LAYREFFR .AND. K_JP(I_LAY+1) >= LAYREFFR) &
   & I_LAYSOLFR = MIN(I_LAY+1,K_LAYTROP)  
  IND0 = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(20) + 1
  IND1 = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(20) + 1
  INDS = K_INDSELF(I_LAY)
  INDF = K_INDFOR(I_LAY)
  Z_TAURAY = P_COLMOL(I_LAY) * RAYL

!  DO IG = 1, NG(20)
  DO IG = 1 , NG20
    P_TAUG(I_LAY,IG) = P_COLH2O(I_LAY) * &
     & ((P_FAC00(I_LAY) * ABSA(IND0,IG) + &
     & P_FAC10(I_LAY) * ABSA(IND0+1,IG) + &
     & P_FAC01(I_LAY) * ABSA(IND1,IG) + &
     & P_FAC11(I_LAY) * ABSA(IND1+1,IG)) + &
     & P_SELFFAC(I_LAY) * (SELFREFC(INDS,IG) +  &
     & P_SELFFRAC(I_LAY) * &
     & (SELFREFC(INDS+1,IG) - SELFREFC(INDS,IG))) + &
     & P_FORFAC(I_LAY) * (FORREFC(INDF,IG) + &
     & P_FORFRAC(I_LAY) * &
     & (FORREFC(INDF+1,IG) - FORREFC(INDF,IG)))) &
     & + P_COLCH4(I_LAY) * ABSCH4C(IG)  
!     &           + TAURAY &
!    SSA(LAY,IG) = TAURAY/TAUG(LAY,IG)
    P_TAUR(I_LAY,IG) = Z_TAURAY 
    IF (I_LAY == I_LAYSOLFR) P_SFLUXZEN(IG) = SFLUXREFC(IG) 
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, I_NLAYERS
  IND0 = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(20) + 1
  IND1 = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(20) + 1
  INDF = K_INDFOR(I_LAY)
  Z_TAURAY = P_COLMOL(I_LAY) * RAYL

!  DO IG = 1, NG(20)
  DO IG = 1 , NG20
    P_TAUG(I_LAY,IG) = P_COLH2O(I_LAY) * &
     & (P_FAC00(I_LAY) * ABSB(IND0,IG) + &
     & P_FAC10(I_LAY) * ABSB(IND0+1,IG) + &
     & P_FAC01(I_LAY) * ABSB(IND1,IG) + &
     & P_FAC11(I_LAY) * ABSB(IND1+1,IG) + &
     & P_FORFAC(I_LAY) * (FORREFC(INDF,IG) + &
     & P_FORFRAC(I_LAY) * &
     & (FORREFC(INDF+1,IG) - FORREFC(INDF,IG)))) + &
     & P_COLCH4(I_LAY) * ABSCH4C(IG)  
!     &           TAURAY + &
!    SSA(LAY,IG) = TAURAY/TAUG(LAY,IG)
    P_TAUR(I_LAY,IG) = Z_TAURAY 
  ENDDO
ENDDO

!-----------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_TAUMOL20',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_TAUMOL20

