MODULE YOMCLOP15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!     * YOMCLOP15* PARAMETERS FOR CLOUD OPTICAL PROPERTIES
!*                       FROZEN VERSION (CYCLE 15) OF YOECLOP
!     ------------------------------------------------------------------

REAL(KIND=JPRB) :: RYFWCA15(2)
REAL(KIND=JPRB) :: RYFWCB15(2)
REAL(KIND=JPRB) :: RYFWCC15(2)
REAL(KIND=JPRB) :: RYFWCD15(2)
REAL(KIND=JPRB) :: RYFWCE15(2)
REAL(KIND=JPRB) :: RYFWCF15(2)
REAL(KIND=JPRB) :: REBCUA15(2)
REAL(KIND=JPRB) :: REBCUB15(2)
REAL(KIND=JPRB) :: REBCUC15(2)
REAL(KIND=JPRB) :: REBCUD15(2)
REAL(KIND=JPRB) :: REBCUE15(2)
REAL(KIND=JPRB) :: REBCUF15(2)
REAL(KIND=JPRB) :: REBCUG15
REAL(KIND=JPRB) :: REBCUH15
REAL(KIND=JPRB) :: REFFIA15
REAL(KIND=JPRB) :: REFFIB15
REAL(KIND=JPRB) :: REFFWIA15
REAL(KIND=JPRB) :: RTIW15
REAL(KIND=JPRB) :: RRIW15

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME       TYPE     PURPOSE
!  ----    :  ----   : -------------------------------------------------
!*    FOUQUART (1987) WATER CLOUD OPTICAL PROPERTIES

! RYFWCA15 :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RYFWCB15 :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RYFWCC15 :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCD15 :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCE15 :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCF15 :  REAL   : ASSYMETRY FACTOR

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM EBERT-CURRY (1992)

! REBCUA15 :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! REBCUB15 :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! REBCUC15 :  REAL   : 1-C3  IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUD15 :  REAL   : C4 IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUE15 :  REAL   : C5 IN ASSYMETRY FACTOR FORMULA
! REBCUF15 :  REAL   : C6 IN ASSYMETRY FACTOR FORMULA
! REBCUG15 :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT FORMULA
! REBCUH15 :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT FORMULA

! REFFIA15 :  REAL   : C9  IN EFFECTIVE RADIUS FORMULA
! REFFIB15 :  REAL   : C10 IN EFFECTIVE RADIUS FORMULA

!*    TRANSITION BETWEEN LIQUID AND SOLID WATER

! RTIW15   :  REAL   : TEMPERATURE THRESHOLD
! RRIW15   :  REAL   :  TRANSITION RANGE
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(rebcua15,rebcub15,rebcuc15,rebcud15,rebcue15,rebcuf15,rebcug15,rebcuh15)
!$OMP THREADPRIVATE(reffia15,reffib15,reffwia15,rriw15,rtiw15,ryfwca15,ryfwcb15,ryfwcc15,ryfwcd15,ryfwce15,ryfwcf15)
END MODULE YOMCLOP15
