!
! $Id: dimphy.f90 5648 2025-05-12 09:14:58Z amaison $
!
  MODULE dimphy
  
  INTEGER,SAVE :: klon
  INTEGER,SAVE :: kdlon
  INTEGER,SAVE :: kfdia
  INTEGER,SAVE :: kidia
  INTEGER,SAVE :: klev
  INTEGER,SAVE :: klevp1
  INTEGER,SAVE :: klevm1
  INTEGER,SAVE :: kflev
  INTEGER,SAVE :: nbtersrf !AM
  INTEGER,SAVE :: nbtsoildepths !AM

!$OMP THREADPRIVATE(klon,kfdia,kidia,kdlon)
! note that klev, klevp1, klevm1 and kflev are
! not included in an ompthreadprivate statement 
! because of the way they are initialized below (omp master)

REAL,save,allocatable,dimension(:) :: zmasq
!$OMP THREADPRIVATE(zmasq)   

CONTAINS
  
  SUBROUTINE Init_dimphy(klon0,klev0)
  IMPLICIT NONE
  
    INTEGER, INTENT(in) :: klon0
    INTEGER, INTENT(in) :: klev0
    
    klon=klon0
    kdlon=klon
    kidia=1
    kfdia=klon
!$OMP MASTER 
    klev=klev0
    klevp1=klev+1
    klevm1=klev-1
    kflev=klev
!$OMP END MASTER    
    ALLOCATE(zmasq(klon))    
    zmasq=0.
    
  END SUBROUTINE Init_dimphy

  SUBROUTINE Init_dimphy1D(klon0,klev0,nbtersrf0,nbtsoildepths0)
! 1D special version of dimphy without ALLOCATE(zmasq)
! which will be allocated in iniphysiq
  IMPLICIT NONE
  
    INTEGER, INTENT(in) :: klon0
    INTEGER, INTENT(in) :: klev0
    INTEGER, INTENT(in), OPTIONAL :: nbtersrf0
    INTEGER, INTENT(in), OPTIONAL :: nbtsoildepths0

    klon=klon0
    kdlon=klon
    kidia=1
    kfdia=klon
    klev=klev0
    klevp1=klev+1
    klevm1=klev-1
    kflev=klev

    IF (PRESENT(nbtersrf0)) THEN
      nbtersrf=nbtersrf0
    ELSE
      nbtersrf = 0
    ENDIF
    IF (PRESENT(nbtsoildepths0)) THEN
      nbtsoildepths=nbtsoildepths0
    ELSE
      nbtsoildepths = 0
    ENDIF

  END SUBROUTINE Init_dimphy1D

  
END MODULE dimphy
