!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0
SUBROUTINE SRTM_KGB18

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 18:  4000-4650 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA18, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:,1) = (/ &
 & 3.65840_JPRB    , 3.54375_JPRB    , 3.34481_JPRB    , 3.10534_JPRB    , &
 & 2.79879_JPRB    , 2.42841_JPRB    , 1.98748_JPRB    , 1.49377_JPRB    , &
 & 1.00196_JPRB    , 0.108342_JPRB   , 8.95099E-02_JPRB, 7.05199E-02_JPRB, &
 & 5.16432E-02_JPRB, 3.27635E-02_JPRB, 1.25133E-02_JPRB, 1.73001E-03_JPRB /)    
SFLUXREF(:,2) = (/ &
 & 3.86372_JPRB    , 3.48521_JPRB    , 3.30790_JPRB    , 3.08103_JPRB    , &
 & 2.77552_JPRB    , 2.40722_JPRB    , 1.97307_JPRB    , 1.48023_JPRB    , &
 & 0.993055_JPRB   , 0.107691_JPRB   , 8.84430E-02_JPRB, 6.99354E-02_JPRB, &
 & 5.07881E-02_JPRB, 3.24121E-02_JPRB, 1.19442E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,3) = (/ &
 & 3.90370_JPRB    , 3.50657_JPRB    , 3.30629_JPRB    , 3.06046_JPRB    , &
 & 2.76982_JPRB    , 2.39907_JPRB    , 1.96358_JPRB    , 1.47458_JPRB    , &
 & 0.988475_JPRB   , 0.106698_JPRB   , 8.75242E-02_JPRB, 6.85898E-02_JPRB, &
 & 5.04798E-02_JPRB, 3.13718E-02_JPRB, 1.09533E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,4) = (/ &
 & 3.93165_JPRB    , 3.52058_JPRB    , 3.31346_JPRB    , 3.04944_JPRB    , &
 & 2.76074_JPRB    , 2.39433_JPRB    , 1.95556_JPRB    , 1.46712_JPRB    , &
 & 0.984056_JPRB   , 0.105885_JPRB   , 8.73062E-02_JPRB, 6.84054E-02_JPRB, &
 & 4.87443E-02_JPRB, 2.99295E-02_JPRB, 1.09533E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,5) = (/ &
 & 3.94082_JPRB    , 3.55221_JPRB    , 3.31863_JPRB    , 3.04730_JPRB    , &
 & 2.74918_JPRB    , 2.38328_JPRB    , 1.95212_JPRB    , 1.45889_JPRB    , &
 & 0.978888_JPRB   , 0.105102_JPRB   , 8.65732E-02_JPRB, 6.74563E-02_JPRB, &
 & 4.76592E-02_JPRB, 2.91017E-02_JPRB, 1.09533E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,6) = (/ &
 & 3.94198_JPRB    , 3.58743_JPRB    , 3.32106_JPRB    , 3.05866_JPRB    , &
 & 2.74115_JPRB    , 2.36939_JPRB    , 1.94305_JPRB    , 1.45180_JPRB    , &
 & 0.971784_JPRB   , 1.04045E-01_JPRB, 8.53731E-02_JPRB, 6.60654E-02_JPRB, &
 & 4.63228E-02_JPRB, 2.91016E-02_JPRB, 1.09552E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,7) = (/ &
 & 3.93596_JPRB    , 3.63366_JPRB    , 3.33144_JPRB    , 3.06252_JPRB    , &
 & 2.74054_JPRB    , 2.35492_JPRB    , 1.92769_JPRB    , 1.44300_JPRB    , &
 & 0.961809_JPRB   , 1.02867E-01_JPRB, 8.34164E-02_JPRB, 6.41005E-02_JPRB, &
 & 4.61826E-02_JPRB, 2.91006E-02_JPRB, 1.09553E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,8) = (/ &
 & 3.92520_JPRB    , 3.69078_JPRB    , 3.35656_JPRB    , 3.07055_JPRB    , &
 & 2.73862_JPRB    , 2.34430_JPRB    , 1.90187_JPRB    , 1.42242_JPRB    , &
 & 0.946676_JPRB   , 9.96302E-02_JPRB, 8.14421E-02_JPRB, 6.38622E-02_JPRB, &
 & 4.61794E-02_JPRB, 2.91017E-02_JPRB, 1.09553E-02_JPRB, 1.57612E-03_JPRB /)  
SFLUXREF(:,9) = (/ &
 & 3.80721_JPRB    , 3.74437_JPRB    , 3.50205_JPRB    , 3.18009_JPRB    , &
 & 2.75757_JPRB    , 2.29188_JPRB    , 1.84382_JPRB    , 1.35694_JPRB    , &
 & 0.914040_JPRB   , 9.86811E-02_JPRB, 8.14321E-02_JPRB, 6.38541E-02_JPRB, &
 & 4.61795E-02_JPRB, 2.90960E-02_JPRB, 1.09613E-02_JPRB, 1.57612E-03_JPRB /)  

!     Rayleigh extinction coefficient at v = 4325 cm-1.
RAYL = 1.39E-09_JPRB

STRRAT = 38.9589_JPRB

LAYREFFR = 6

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.14813E-04_JPRB,0.39842E-04_JPRB,0.43362E-04_JPRB,0.43095E-04_JPRB,0.39811E-04_JPRB, &
 & 0.34994E-04_JPRB,0.28984E-04_JPRB,0.20609E-04_JPRB,0.18845E-05_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.14432E-04_JPRB,0.38749E-04_JPRB,0.42119E-04_JPRB,0.41834E-04_JPRB,0.38900E-04_JPRB, &
 & 0.34365E-04_JPRB,0.28571E-04_JPRB,0.20503E-04_JPRB,0.14715E-05_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.13969E-04_JPRB,0.37666E-04_JPRB,0.40942E-04_JPRB,0.40703E-04_JPRB,0.37982E-04_JPRB, &
 & 0.33731E-04_JPRB,0.28158E-04_JPRB,0.20351E-04_JPRB,0.10842E-05_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.13367E-04_JPRB,0.36605E-04_JPRB,0.39729E-04_JPRB,0.39529E-04_JPRB,0.37033E-04_JPRB, &
 & 0.33096E-04_JPRB,0.27690E-04_JPRB,0.20154E-04_JPRB,0.78702E-06_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.12765E-04_JPRB,0.35584E-04_JPRB,0.38536E-04_JPRB,0.38361E-04_JPRB,0.36073E-04_JPRB, &
 & 0.32384E-04_JPRB,0.27242E-04_JPRB,0.19932E-04_JPRB,0.58296E-06_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.12299E-04_JPRB,0.34179E-04_JPRB,0.37405E-04_JPRB,0.37535E-04_JPRB,0.34714E-04_JPRB, &
 & 0.30335E-04_JPRB,0.24892E-04_JPRB,0.17524E-04_JPRB,0.13301E-05_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.12064E-04_JPRB,0.33225E-04_JPRB,0.36357E-04_JPRB,0.36512E-04_JPRB,0.33870E-04_JPRB, &
 & 0.29789E-04_JPRB,0.24578E-04_JPRB,0.17435E-04_JPRB,0.10217E-05_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.11697E-04_JPRB,0.32301E-04_JPRB,0.35316E-04_JPRB,0.35481E-04_JPRB,0.33049E-04_JPRB, &
 & 0.29226E-04_JPRB,0.24233E-04_JPRB,0.17304E-04_JPRB,0.72152E-06_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.11209E-04_JPRB,0.31395E-04_JPRB,0.34263E-04_JPRB,0.34436E-04_JPRB,0.32173E-04_JPRB, &
 & 0.28610E-04_JPRB,0.23847E-04_JPRB,0.17161E-04_JPRB,0.51787E-06_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.10706E-04_JPRB,0.30496E-04_JPRB,0.33311E-04_JPRB,0.33396E-04_JPRB,0.31295E-04_JPRB, &
 & 0.28002E-04_JPRB,0.23445E-04_JPRB,0.16971E-04_JPRB,0.40230E-06_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.10271E-04_JPRB,0.29273E-04_JPRB,0.32049E-04_JPRB,0.32365E-04_JPRB,0.29857E-04_JPRB, &
 & 0.26171E-04_JPRB,0.21352E-04_JPRB,0.14814E-04_JPRB,0.80470E-06_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.10058E-04_JPRB,0.28458E-04_JPRB,0.31196E-04_JPRB,0.31440E-04_JPRB,0.29133E-04_JPRB, &
 & 0.25640E-04_JPRB,0.21056E-04_JPRB,0.14756E-04_JPRB,0.53010E-06_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.98172E-05_JPRB,0.27651E-04_JPRB,0.30352E-04_JPRB,0.30609E-04_JPRB,0.28396E-04_JPRB, &
 & 0.25110E-04_JPRB,0.20730E-04_JPRB,0.14655E-04_JPRB,0.38652E-06_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.94577E-05_JPRB,0.26874E-04_JPRB,0.29475E-04_JPRB,0.29749E-04_JPRB,0.27669E-04_JPRB, &
 & 0.24553E-04_JPRB,0.20400E-04_JPRB,0.14536E-04_JPRB,0.33236E-06_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.90508E-05_JPRB,0.26128E-04_JPRB,0.28631E-04_JPRB,0.28834E-04_JPRB,0.26952E-04_JPRB, &
 & 0.24015E-04_JPRB,0.20045E-04_JPRB,0.14382E-04_JPRB,0.30659E-06_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.86081E-05_JPRB,0.24897E-04_JPRB,0.27317E-04_JPRB,0.27632E-04_JPRB,0.25465E-04_JPRB, &
 & 0.22328E-04_JPRB,0.18112E-04_JPRB,0.12468E-04_JPRB,0.39286E-06_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.83793E-05_JPRB,0.24273E-04_JPRB,0.26590E-04_JPRB,0.26865E-04_JPRB,0.24876E-04_JPRB, &
 & 0.21867E-04_JPRB,0.17849E-04_JPRB,0.12420E-04_JPRB,0.32266E-06_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.82296E-05_JPRB,0.23584E-04_JPRB,0.25869E-04_JPRB,0.26155E-04_JPRB,0.24255E-04_JPRB, &
 & 0.21403E-04_JPRB,0.17579E-04_JPRB,0.12338E-04_JPRB,0.30775E-06_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.79731E-05_JPRB,0.22915E-04_JPRB,0.25166E-04_JPRB,0.25435E-04_JPRB,0.23627E-04_JPRB, &
 & 0.20917E-04_JPRB,0.17282E-04_JPRB,0.12242E-04_JPRB,0.30418E-06_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.76553E-05_JPRB,0.22259E-04_JPRB,0.24440E-04_JPRB,0.24673E-04_JPRB,0.23003E-04_JPRB, &
 & 0.20437E-04_JPRB,0.16984E-04_JPRB,0.12112E-04_JPRB,0.30638E-06_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.72259E-05_JPRB,0.21089E-04_JPRB,0.23177E-04_JPRB,0.23419E-04_JPRB,0.21584E-04_JPRB, &
 & 0.18926E-04_JPRB,0.15251E-04_JPRB,0.10417E-04_JPRB,0.25170E-06_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.70215E-05_JPRB,0.20567E-04_JPRB,0.22541E-04_JPRB,0.22788E-04_JPRB,0.21102E-04_JPRB, &
 & 0.18526E-04_JPRB,0.15049E-04_JPRB,0.10379E-04_JPRB,0.25958E-06_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.68490E-05_JPRB,0.20018E-04_JPRB,0.21938E-04_JPRB,0.22206E-04_JPRB,0.20579E-04_JPRB, &
 & 0.18139E-04_JPRB,0.14806E-04_JPRB,0.10313E-04_JPRB,0.26666E-06_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.66973E-05_JPRB,0.19444E-04_JPRB,0.21340E-04_JPRB,0.21615E-04_JPRB,0.20070E-04_JPRB, &
 & 0.17728E-04_JPRB,0.14554E-04_JPRB,0.10239E-04_JPRB,0.28589E-06_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.64808E-05_JPRB,0.18883E-04_JPRB,0.20738E-04_JPRB,0.20994E-04_JPRB,0.19546E-04_JPRB, &
 & 0.17304E-04_JPRB,0.14306E-04_JPRB,0.10148E-04_JPRB,0.30886E-06_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.60727E-05_JPRB,0.17794E-04_JPRB,0.19609E-04_JPRB,0.19769E-04_JPRB,0.18228E-04_JPRB, &
 & 0.15946E-04_JPRB,0.12793E-04_JPRB,0.86559E-05_JPRB,0.18559E-06_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.58949E-05_JPRB,0.17390E-04_JPRB,0.19059E-04_JPRB,0.19244E-04_JPRB,0.17820E-04_JPRB, &
 & 0.15647E-04_JPRB,0.12626E-04_JPRB,0.86354E-05_JPRB,0.19544E-06_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.57268E-05_JPRB,0.16935E-04_JPRB,0.18564E-04_JPRB,0.18724E-04_JPRB,0.17402E-04_JPRB, &
 & 0.15304E-04_JPRB,0.12433E-04_JPRB,0.85882E-05_JPRB,0.22033E-06_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.56243E-05_JPRB,0.16459E-04_JPRB,0.18054E-04_JPRB,0.18263E-04_JPRB,0.16984E-04_JPRB, &
 & 0.14971E-04_JPRB,0.12215E-04_JPRB,0.85268E-05_JPRB,0.25072E-06_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.54584E-05_JPRB,0.15984E-04_JPRB,0.17548E-04_JPRB,0.17773E-04_JPRB,0.16551E-04_JPRB, &
 & 0.14601E-04_JPRB,0.12004E-04_JPRB,0.84568E-05_JPRB,0.28110E-06_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.50624E-05_JPRB,0.14963E-04_JPRB,0.16482E-04_JPRB,0.16611E-04_JPRB,0.15339E-04_JPRB, &
 & 0.13333E-04_JPRB,0.10656E-04_JPRB,0.71570E-05_JPRB,0.13453E-06_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.49428E-05_JPRB,0.14636E-04_JPRB,0.16040E-04_JPRB,0.16181E-04_JPRB,0.14992E-04_JPRB, &
 & 0.13144E-04_JPRB,0.10533E-04_JPRB,0.71532E-05_JPRB,0.15620E-06_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.47955E-05_JPRB,0.14256E-04_JPRB,0.15611E-04_JPRB,0.15735E-04_JPRB,0.14643E-04_JPRB, &
 & 0.12865E-04_JPRB,0.10390E-04_JPRB,0.71248E-05_JPRB,0.18571E-06_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.46743E-05_JPRB,0.13876E-04_JPRB,0.15213E-04_JPRB,0.15342E-04_JPRB,0.14293E-04_JPRB, &
 & 0.12576E-04_JPRB,0.10215E-04_JPRB,0.70735E-05_JPRB,0.21382E-06_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.45708E-05_JPRB,0.13473E-04_JPRB,0.14782E-04_JPRB,0.14947E-04_JPRB,0.13933E-04_JPRB, &
 & 0.12274E-04_JPRB,0.10036E-04_JPRB,0.70177E-05_JPRB,0.24419E-06_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.42289E-05_JPRB,0.12528E-04_JPRB,0.13817E-04_JPRB,0.13922E-04_JPRB,0.12867E-04_JPRB, &
 & 0.11126E-04_JPRB,0.88468E-05_JPRB,0.59010E-05_JPRB,0.10600E-06_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.41319E-05_JPRB,0.12286E-04_JPRB,0.13480E-04_JPRB,0.13582E-04_JPRB,0.12584E-04_JPRB, &
 & 0.10973E-04_JPRB,0.87644E-05_JPRB,0.59049E-05_JPRB,0.12951E-06_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.40317E-05_JPRB,0.11996E-04_JPRB,0.13116E-04_JPRB,0.13206E-04_JPRB,0.12295E-04_JPRB, &
 & 0.10786E-04_JPRB,0.86537E-05_JPRB,0.58898E-05_JPRB,0.15731E-06_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.39107E-05_JPRB,0.11666E-04_JPRB,0.12771E-04_JPRB,0.12870E-04_JPRB,0.12010E-04_JPRB, &
 & 0.10546E-04_JPRB,0.85244E-05_JPRB,0.58536E-05_JPRB,0.18716E-06_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.38384E-05_JPRB,0.11346E-04_JPRB,0.12435E-04_JPRB,0.12549E-04_JPRB,0.11706E-04_JPRB, &
 & 0.10289E-04_JPRB,0.83756E-05_JPRB,0.58104E-05_JPRB,0.21679E-06_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.35240E-05_JPRB,0.10418E-04_JPRB,0.11558E-04_JPRB,0.11687E-04_JPRB,0.10748E-04_JPRB, &
 & 0.92305E-05_JPRB,0.73198E-05_JPRB,0.48514E-05_JPRB,0.10176E-06_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.34478E-05_JPRB,0.10296E-04_JPRB,0.11296E-04_JPRB,0.11369E-04_JPRB,0.10532E-04_JPRB, &
 & 0.91375E-05_JPRB,0.72737E-05_JPRB,0.48639E-05_JPRB,0.12695E-06_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.33718E-05_JPRB,0.10068E-04_JPRB,0.10996E-04_JPRB,0.11063E-04_JPRB,0.10290E-04_JPRB, &
 & 0.89957E-05_JPRB,0.71844E-05_JPRB,0.48583E-05_JPRB,0.15482E-06_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.32801E-05_JPRB,0.97990E-05_JPRB,0.10712E-04_JPRB,0.10762E-04_JPRB,0.10056E-04_JPRB, &
 & 0.88255E-05_JPRB,0.70907E-05_JPRB,0.48364E-05_JPRB,0.18123E-06_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.31960E-05_JPRB,0.95350E-05_JPRB,0.10427E-04_JPRB,0.10501E-04_JPRB,0.98056E-05_JPRB, &
 & 0.86157E-05_JPRB,0.69723E-05_JPRB,0.48010E-05_JPRB,0.20738E-06_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.29197E-05_JPRB,0.86183E-05_JPRB,0.96100E-05_JPRB,0.97448E-05_JPRB,0.89187E-05_JPRB, &
 & 0.76354E-05_JPRB,0.60318E-05_JPRB,0.39733E-05_JPRB,0.10310E-06_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.28677E-05_JPRB,0.85565E-05_JPRB,0.94191E-05_JPRB,0.94682E-05_JPRB,0.87653E-05_JPRB, &
 & 0.75725E-05_JPRB,0.60089E-05_JPRB,0.39956E-05_JPRB,0.12951E-06_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.28036E-05_JPRB,0.84121E-05_JPRB,0.91902E-05_JPRB,0.92251E-05_JPRB,0.85811E-05_JPRB, &
 & 0.74653E-05_JPRB,0.59452E-05_JPRB,0.39967E-05_JPRB,0.15684E-06_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.27420E-05_JPRB,0.82035E-05_JPRB,0.89440E-05_JPRB,0.89748E-05_JPRB,0.83817E-05_JPRB, &
 & 0.73422E-05_JPRB,0.58725E-05_JPRB,0.39844E-05_JPRB,0.18564E-06_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.26596E-05_JPRB,0.79739E-05_JPRB,0.87074E-05_JPRB,0.87508E-05_JPRB,0.81784E-05_JPRB, &
 & 0.71781E-05_JPRB,0.57815E-05_JPRB,0.39569E-05_JPRB,0.21476E-06_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.23988E-05_JPRB,0.71135E-05_JPRB,0.79121E-05_JPRB,0.80118E-05_JPRB,0.73370E-05_JPRB, &
 & 0.62844E-05_JPRB,0.49610E-05_JPRB,0.32641E-05_JPRB,0.91697E-07_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.23552E-05_JPRB,0.70587E-05_JPRB,0.77519E-05_JPRB,0.77821E-05_JPRB,0.72113E-05_JPRB, &
 & 0.62297E-05_JPRB,0.49407E-05_JPRB,0.32815E-05_JPRB,0.11307E-06_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.23046E-05_JPRB,0.69367E-05_JPRB,0.75662E-05_JPRB,0.75790E-05_JPRB,0.70631E-05_JPRB, &
 & 0.61409E-05_JPRB,0.48867E-05_JPRB,0.32812E-05_JPRB,0.13715E-06_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.22557E-05_JPRB,0.67632E-05_JPRB,0.73640E-05_JPRB,0.73772E-05_JPRB,0.68972E-05_JPRB, &
 & 0.60381E-05_JPRB,0.48254E-05_JPRB,0.32705E-05_JPRB,0.16436E-06_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.21899E-05_JPRB,0.65748E-05_JPRB,0.71695E-05_JPRB,0.71946E-05_JPRB,0.67295E-05_JPRB, &
 & 0.59022E-05_JPRB,0.47488E-05_JPRB,0.32476E-05_JPRB,0.19025E-06_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.19699E-05_JPRB,0.58670E-05_JPRB,0.65075E-05_JPRB,0.65808E-05_JPRB,0.60300E-05_JPRB, &
 & 0.51665E-05_JPRB,0.40749E-05_JPRB,0.26788E-05_JPRB,0.77100E-07_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.19348E-05_JPRB,0.58146E-05_JPRB,0.63730E-05_JPRB,0.63891E-05_JPRB,0.59260E-05_JPRB, &
 & 0.51196E-05_JPRB,0.40577E-05_JPRB,0.26926E-05_JPRB,0.95693E-07_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.18947E-05_JPRB,0.57134E-05_JPRB,0.62207E-05_JPRB,0.62238E-05_JPRB,0.58090E-05_JPRB, &
 & 0.50459E-05_JPRB,0.40113E-05_JPRB,0.26916E-05_JPRB,0.11572E-06_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.18552E-05_JPRB,0.55709E-05_JPRB,0.60522E-05_JPRB,0.60611E-05_JPRB,0.56693E-05_JPRB, &
 & 0.49594E-05_JPRB,0.39606E-05_JPRB,0.26824E-05_JPRB,0.13797E-06_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.18040E-05_JPRB,0.54137E-05_JPRB,0.58935E-05_JPRB,0.59096E-05_JPRB,0.55294E-05_JPRB, &
 & 0.48443E-05_JPRB,0.38977E-05_JPRB,0.26633E-05_JPRB,0.15884E-06_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.16167E-05_JPRB,0.48272E-05_JPRB,0.53475E-05_JPRB,0.53983E-05_JPRB,0.49503E-05_JPRB, &
 & 0.42413E-05_JPRB,0.33431E-05_JPRB,0.21956E-05_JPRB,0.61381E-07_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.15895E-05_JPRB,0.47809E-05_JPRB,0.52342E-05_JPRB,0.52409E-05_JPRB,0.48652E-05_JPRB, &
 & 0.42021E-05_JPRB,0.33263E-05_JPRB,0.22072E-05_JPRB,0.76382E-07_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.15582E-05_JPRB,0.46982E-05_JPRB,0.51055E-05_JPRB,0.51058E-05_JPRB,0.47716E-05_JPRB, &
 & 0.41406E-05_JPRB,0.32886E-05_JPRB,0.22058E-05_JPRB,0.93083E-07_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.15242E-05_JPRB,0.45831E-05_JPRB,0.49696E-05_JPRB,0.49735E-05_JPRB,0.46534E-05_JPRB, &
 & 0.40678E-05_JPRB,0.32469E-05_JPRB,0.21969E-05_JPRB,0.11211E-06_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.14859E-05_JPRB,0.44492E-05_JPRB,0.48392E-05_JPRB,0.48479E-05_JPRB,0.45378E-05_JPRB, &
 & 0.39689E-05_JPRB,0.31933E-05_JPRB,0.21813E-05_JPRB,0.12970E-06_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.10138E-03_JPRB,0.20456E-03_JPRB,0.22117E-03_JPRB,0.21948E-03_JPRB,0.20805E-03_JPRB, &
 & 0.18373E-03_JPRB,0.14999E-03_JPRB,0.95382E-04_JPRB,0.33213E-05_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.10141E-03_JPRB,0.20889E-03_JPRB,0.22456E-03_JPRB,0.22223E-03_JPRB,0.20912E-03_JPRB, &
 & 0.18467E-03_JPRB,0.15060E-03_JPRB,0.95713E-04_JPRB,0.28479E-05_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.10125E-03_JPRB,0.21223E-03_JPRB,0.22712E-03_JPRB,0.22388E-03_JPRB,0.20983E-03_JPRB, &
 & 0.18513E-03_JPRB,0.15100E-03_JPRB,0.95881E-04_JPRB,0.26338E-05_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.10105E-03_JPRB,0.21442E-03_JPRB,0.22863E-03_JPRB,0.22421E-03_JPRB,0.21046E-03_JPRB, &
 & 0.18540E-03_JPRB,0.15060E-03_JPRB,0.95798E-04_JPRB,0.27638E-05_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.10040E-03_JPRB,0.21612E-03_JPRB,0.22899E-03_JPRB,0.22416E-03_JPRB,0.21046E-03_JPRB, &
 & 0.18570E-03_JPRB,0.15001E-03_JPRB,0.95569E-04_JPRB,0.29313E-05_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.89639E-04_JPRB,0.17797E-03_JPRB,0.19284E-03_JPRB,0.18986E-03_JPRB,0.17824E-03_JPRB, &
 & 0.15789E-03_JPRB,0.12906E-03_JPRB,0.83524E-04_JPRB,0.23926E-05_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.89499E-04_JPRB,0.18144E-03_JPRB,0.19563E-03_JPRB,0.19227E-03_JPRB,0.17941E-03_JPRB, &
 & 0.15844E-03_JPRB,0.12961E-03_JPRB,0.83632E-04_JPRB,0.21969E-05_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.89411E-04_JPRB,0.18401E-03_JPRB,0.19753E-03_JPRB,0.19350E-03_JPRB,0.17999E-03_JPRB, &
 & 0.15883E-03_JPRB,0.12989E-03_JPRB,0.83577E-04_JPRB,0.23158E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART2',0,ZHOOK_HANDLE)


KA(:, 4, 2, 2) = (/ &
 & 0.88841E-04_JPRB,0.18541E-03_JPRB,0.19872E-03_JPRB,0.19398E-03_JPRB,0.18053E-03_JPRB, &
 & 0.15907E-03_JPRB,0.12972E-03_JPRB,0.83396E-04_JPRB,0.23760E-05_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.87949E-04_JPRB,0.18659E-03_JPRB,0.19902E-03_JPRB,0.19407E-03_JPRB,0.18073E-03_JPRB, &
 & 0.15910E-03_JPRB,0.12937E-03_JPRB,0.83120E-04_JPRB,0.25247E-05_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.77466E-04_JPRB,0.15264E-03_JPRB,0.16704E-03_JPRB,0.16342E-03_JPRB,0.15300E-03_JPRB, &
 & 0.13499E-03_JPRB,0.11007E-03_JPRB,0.71881E-04_JPRB,0.17839E-05_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.77483E-04_JPRB,0.15611E-03_JPRB,0.16950E-03_JPRB,0.16551E-03_JPRB,0.15408E-03_JPRB, &
 & 0.13580E-03_JPRB,0.11055E-03_JPRB,0.72020E-04_JPRB,0.18564E-05_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.77142E-04_JPRB,0.15867E-03_JPRB,0.17112E-03_JPRB,0.16672E-03_JPRB,0.15481E-03_JPRB, &
 & 0.13616E-03_JPRB,0.11077E-03_JPRB,0.71922E-04_JPRB,0.20228E-05_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.76460E-04_JPRB,0.16058E-03_JPRB,0.17186E-03_JPRB,0.16717E-03_JPRB,0.15519E-03_JPRB, &
 & 0.13641E-03_JPRB,0.11060E-03_JPRB,0.71775E-04_JPRB,0.21717E-05_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.75510E-04_JPRB,0.16158E-03_JPRB,0.17210E-03_JPRB,0.16730E-03_JPRB,0.15521E-03_JPRB, &
 & 0.13649E-03_JPRB,0.11022E-03_JPRB,0.71516E-04_JPRB,0.23140E-05_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.65931E-04_JPRB,0.12940E-03_JPRB,0.14295E-03_JPRB,0.14005E-03_JPRB,0.13095E-03_JPRB, &
 & 0.11494E-03_JPRB,0.93656E-04_JPRB,0.61167E-04_JPRB,0.17094E-05_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.66090E-04_JPRB,0.13269E-03_JPRB,0.14542E-03_JPRB,0.14233E-03_JPRB,0.13201E-03_JPRB, &
 & 0.11558E-03_JPRB,0.93975E-04_JPRB,0.61436E-04_JPRB,0.18527E-05_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.65630E-04_JPRB,0.13532E-03_JPRB,0.14717E-03_JPRB,0.14364E-03_JPRB,0.13266E-03_JPRB, &
 & 0.11604E-03_JPRB,0.94126E-04_JPRB,0.61467E-04_JPRB,0.19576E-05_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.64971E-04_JPRB,0.13708E-03_JPRB,0.14818E-03_JPRB,0.14427E-03_JPRB,0.13304E-03_JPRB, &
 & 0.11616E-03_JPRB,0.94152E-04_JPRB,0.61334E-04_JPRB,0.20614E-05_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.64122E-04_JPRB,0.13834E-03_JPRB,0.14864E-03_JPRB,0.14451E-03_JPRB,0.13312E-03_JPRB, &
 & 0.11638E-03_JPRB,0.93955E-04_JPRB,0.61162E-04_JPRB,0.21640E-05_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.55594E-04_JPRB,0.10830E-03_JPRB,0.12068E-03_JPRB,0.11865E-03_JPRB,0.11127E-03_JPRB, &
 & 0.97925E-04_JPRB,0.79208E-04_JPRB,0.51842E-04_JPRB,0.15954E-05_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.55669E-04_JPRB,0.11117E-03_JPRB,0.12299E-03_JPRB,0.12091E-03_JPRB,0.11248E-03_JPRB, &
 & 0.98643E-04_JPRB,0.79433E-04_JPRB,0.52127E-04_JPRB,0.16966E-05_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.55430E-04_JPRB,0.11345E-03_JPRB,0.12478E-03_JPRB,0.12235E-03_JPRB,0.11332E-03_JPRB, &
 & 0.99117E-04_JPRB,0.79823E-04_JPRB,0.52286E-04_JPRB,0.18304E-05_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.54800E-04_JPRB,0.11543E-03_JPRB,0.12601E-03_JPRB,0.12304E-03_JPRB,0.11389E-03_JPRB, &
 & 0.99346E-04_JPRB,0.79935E-04_JPRB,0.52275E-04_JPRB,0.19479E-05_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.54027E-04_JPRB,0.11665E-03_JPRB,0.12660E-03_JPRB,0.12339E-03_JPRB,0.11410E-03_JPRB, &
 & 0.99535E-04_JPRB,0.79840E-04_JPRB,0.52168E-04_JPRB,0.20583E-05_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.46500E-04_JPRB,0.89887E-04_JPRB,0.10048E-03_JPRB,0.99161E-04_JPRB,0.93136E-04_JPRB, &
 & 0.82279E-04_JPRB,0.66872E-04_JPRB,0.43617E-04_JPRB,0.14730E-05_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.46632E-04_JPRB,0.92444E-04_JPRB,0.10271E-03_JPRB,0.10123E-03_JPRB,0.94559E-04_JPRB, &
 & 0.83135E-04_JPRB,0.67204E-04_JPRB,0.44046E-04_JPRB,0.16215E-05_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.46490E-04_JPRB,0.94415E-04_JPRB,0.10446E-03_JPRB,0.10269E-03_JPRB,0.95387E-04_JPRB, &
 & 0.83676E-04_JPRB,0.67579E-04_JPRB,0.44279E-04_JPRB,0.17358E-05_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.46004E-04_JPRB,0.96190E-04_JPRB,0.10570E-03_JPRB,0.10346E-03_JPRB,0.95883E-04_JPRB, &
 & 0.84038E-04_JPRB,0.67753E-04_JPRB,0.44348E-04_JPRB,0.18096E-05_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.45362E-04_JPRB,0.97511E-04_JPRB,0.10645E-03_JPRB,0.10384E-03_JPRB,0.96197E-04_JPRB, &
 & 0.84347E-04_JPRB,0.67758E-04_JPRB,0.44305E-04_JPRB,0.18882E-05_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.38597E-04_JPRB,0.74019E-04_JPRB,0.82882E-04_JPRB,0.81807E-04_JPRB,0.76936E-04_JPRB, &
 & 0.68278E-04_JPRB,0.55744E-04_JPRB,0.36507E-04_JPRB,0.13400E-05_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.38728E-04_JPRB,0.76353E-04_JPRB,0.85030E-04_JPRB,0.83822E-04_JPRB,0.78523E-04_JPRB, &
 & 0.69221E-04_JPRB,0.56199E-04_JPRB,0.36932E-04_JPRB,0.14766E-05_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.38688E-04_JPRB,0.78164E-04_JPRB,0.86691E-04_JPRB,0.85269E-04_JPRB,0.79424E-04_JPRB, &
 & 0.69849E-04_JPRB,0.56507E-04_JPRB,0.37211E-04_JPRB,0.16077E-05_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.38399E-04_JPRB,0.79654E-04_JPRB,0.87882E-04_JPRB,0.86145E-04_JPRB,0.79917E-04_JPRB, &
 & 0.70214E-04_JPRB,0.56698E-04_JPRB,0.37302E-04_JPRB,0.17365E-05_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.37899E-04_JPRB,0.81012E-04_JPRB,0.88706E-04_JPRB,0.86589E-04_JPRB,0.80259E-04_JPRB, &
 & 0.70429E-04_JPRB,0.56810E-04_JPRB,0.37287E-04_JPRB,0.18595E-05_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.31959E-04_JPRB,0.60671E-04_JPRB,0.67963E-04_JPRB,0.67053E-04_JPRB,0.63057E-04_JPRB, &
 & 0.56287E-04_JPRB,0.46187E-04_JPRB,0.30298E-04_JPRB,0.12071E-05_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.32062E-04_JPRB,0.62753E-04_JPRB,0.69892E-04_JPRB,0.68941E-04_JPRB,0.64624E-04_JPRB, &
 & 0.57187E-04_JPRB,0.46566E-04_JPRB,0.30687E-04_JPRB,0.13582E-05_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.32098E-04_JPRB,0.64435E-04_JPRB,0.71423E-04_JPRB,0.70359E-04_JPRB,0.65646E-04_JPRB, &
 & 0.57882E-04_JPRB,0.46897E-04_JPRB,0.30993E-04_JPRB,0.15217E-05_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.31956E-04_JPRB,0.65758E-04_JPRB,0.72650E-04_JPRB,0.71275E-04_JPRB,0.66275E-04_JPRB, &
 & 0.58298E-04_JPRB,0.47100E-04_JPRB,0.31079E-04_JPRB,0.16794E-05_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.31584E-04_JPRB,0.66916E-04_JPRB,0.73502E-04_JPRB,0.71819E-04_JPRB,0.66611E-04_JPRB, &
 & 0.58505E-04_JPRB,0.47243E-04_JPRB,0.31088E-04_JPRB,0.18250E-05_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.26355E-04_JPRB,0.49472E-04_JPRB,0.55415E-04_JPRB,0.54584E-04_JPRB,0.51361E-04_JPRB, &
 & 0.46135E-04_JPRB,0.38027E-04_JPRB,0.24983E-04_JPRB,0.13549E-05_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.26472E-04_JPRB,0.51302E-04_JPRB,0.57165E-04_JPRB,0.56417E-04_JPRB,0.52936E-04_JPRB, &
 & 0.47048E-04_JPRB,0.38417E-04_JPRB,0.25347E-04_JPRB,0.14941E-05_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.26545E-04_JPRB,0.52866E-04_JPRB,0.58563E-04_JPRB,0.57776E-04_JPRB,0.53988E-04_JPRB, &
 & 0.47706E-04_JPRB,0.38739E-04_JPRB,0.25638E-04_JPRB,0.16563E-05_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.26469E-04_JPRB,0.54105E-04_JPRB,0.59749E-04_JPRB,0.58746E-04_JPRB,0.54668E-04_JPRB, &
 & 0.48161E-04_JPRB,0.38970E-04_JPRB,0.25744E-04_JPRB,0.18262E-05_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.26248E-04_JPRB,0.55079E-04_JPRB,0.60619E-04_JPRB,0.59317E-04_JPRB,0.55099E-04_JPRB, &
 & 0.48435E-04_JPRB,0.39115E-04_JPRB,0.25778E-04_JPRB,0.20238E-05_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.21631E-04_JPRB,0.40297E-04_JPRB,0.45170E-04_JPRB,0.44298E-04_JPRB,0.41876E-04_JPRB, &
 & 0.37690E-04_JPRB,0.31212E-04_JPRB,0.20552E-04_JPRB,0.16328E-05_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.21814E-04_JPRB,0.41896E-04_JPRB,0.46681E-04_JPRB,0.46065E-04_JPRB,0.43227E-04_JPRB, &
 & 0.38608E-04_JPRB,0.31614E-04_JPRB,0.20857E-04_JPRB,0.18610E-05_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.21864E-04_JPRB,0.43247E-04_JPRB,0.47945E-04_JPRB,0.47327E-04_JPRB,0.44273E-04_JPRB, &
 & 0.39201E-04_JPRB,0.31894E-04_JPRB,0.21119E-04_JPRB,0.20775E-05_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.21835E-04_JPRB,0.44386E-04_JPRB,0.48986E-04_JPRB,0.48228E-04_JPRB,0.44916E-04_JPRB, &
 & 0.39637E-04_JPRB,0.32093E-04_JPRB,0.21228E-04_JPRB,0.22541E-05_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.21728E-04_JPRB,0.45263E-04_JPRB,0.49804E-04_JPRB,0.48818E-04_JPRB,0.45409E-04_JPRB, &
 & 0.39950E-04_JPRB,0.32269E-04_JPRB,0.21290E-04_JPRB,0.24525E-05_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.17823E-04_JPRB,0.33378E-04_JPRB,0.37337E-04_JPRB,0.36619E-04_JPRB,0.34598E-04_JPRB, &
 & 0.31113E-04_JPRB,0.25761E-04_JPRB,0.16956E-04_JPRB,0.15042E-05_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.17970E-04_JPRB,0.34679E-04_JPRB,0.38589E-04_JPRB,0.38065E-04_JPRB,0.35695E-04_JPRB, &
 & 0.31869E-04_JPRB,0.26044E-04_JPRB,0.17214E-04_JPRB,0.16847E-05_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.17997E-04_JPRB,0.35791E-04_JPRB,0.39619E-04_JPRB,0.39097E-04_JPRB,0.36539E-04_JPRB, &
 & 0.32374E-04_JPRB,0.26298E-04_JPRB,0.17428E-04_JPRB,0.18887E-05_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.17967E-04_JPRB,0.36717E-04_JPRB,0.40463E-04_JPRB,0.39821E-04_JPRB,0.37071E-04_JPRB, &
 & 0.32716E-04_JPRB,0.26461E-04_JPRB,0.17496E-04_JPRB,0.20546E-05_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.17868E-04_JPRB,0.37423E-04_JPRB,0.41124E-04_JPRB,0.40304E-04_JPRB,0.37473E-04_JPRB, &
 & 0.32971E-04_JPRB,0.26612E-04_JPRB,0.17532E-04_JPRB,0.22240E-05_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.14665E-04_JPRB,0.27605E-04_JPRB,0.30811E-04_JPRB,0.30250E-04_JPRB,0.28525E-04_JPRB, &
 & 0.25644E-04_JPRB,0.21186E-04_JPRB,0.13955E-04_JPRB,0.12588E-05_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.14775E-04_JPRB,0.28655E-04_JPRB,0.31851E-04_JPRB,0.31408E-04_JPRB,0.29418E-04_JPRB, &
 & 0.26261E-04_JPRB,0.21430E-04_JPRB,0.14172E-04_JPRB,0.14181E-05_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.14799E-04_JPRB,0.29571E-04_JPRB,0.32687E-04_JPRB,0.32242E-04_JPRB,0.30093E-04_JPRB, &
 & 0.26683E-04_JPRB,0.21636E-04_JPRB,0.14338E-04_JPRB,0.15619E-05_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.14777E-04_JPRB,0.30325E-04_JPRB,0.33371E-04_JPRB,0.32826E-04_JPRB,0.30553E-04_JPRB, &
 & 0.26945E-04_JPRB,0.21775E-04_JPRB,0.14380E-04_JPRB,0.16917E-05_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.14685E-04_JPRB,0.30904E-04_JPRB,0.33907E-04_JPRB,0.33214E-04_JPRB,0.30875E-04_JPRB, &
 & 0.27158E-04_JPRB,0.21883E-04_JPRB,0.14414E-04_JPRB,0.18423E-05_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.12044E-04_JPRB,0.22772E-04_JPRB,0.25375E-04_JPRB,0.24926E-04_JPRB,0.23458E-04_JPRB, &
 & 0.21059E-04_JPRB,0.17387E-04_JPRB,0.11457E-04_JPRB,0.99122E-06_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.12128E-04_JPRB,0.23637E-04_JPRB,0.26249E-04_JPRB,0.25842E-04_JPRB,0.24187E-04_JPRB, &
 & 0.21582E-04_JPRB,0.17590E-04_JPRB,0.11636E-04_JPRB,0.11037E-05_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.12152E-04_JPRB,0.24386E-04_JPRB,0.26910E-04_JPRB,0.26531E-04_JPRB,0.24731E-04_JPRB, &
 & 0.21923E-04_JPRB,0.17760E-04_JPRB,0.11755E-04_JPRB,0.12026E-05_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.12130E-04_JPRB,0.24996E-04_JPRB,0.27464E-04_JPRB,0.27006E-04_JPRB,0.25113E-04_JPRB, &
 & 0.22138E-04_JPRB,0.17874E-04_JPRB,0.11797E-04_JPRB,0.13028E-05_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.12050E-04_JPRB,0.25474E-04_JPRB,0.27895E-04_JPRB,0.27297E-04_JPRB,0.25373E-04_JPRB, &
 & 0.22302E-04_JPRB,0.17948E-04_JPRB,0.11817E-04_JPRB,0.14010E-05_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.36823E-03_JPRB,0.49613E-03_JPRB,0.51817E-03_JPRB,0.50538E-03_JPRB,0.45711E-03_JPRB, &
 & 0.39605E-03_JPRB,0.31486E-03_JPRB,0.21474E-03_JPRB,0.10932E-04_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.37008E-03_JPRB,0.50778E-03_JPRB,0.53361E-03_JPRB,0.51778E-03_JPRB,0.46995E-03_JPRB, &
 & 0.40629E-03_JPRB,0.32309E-03_JPRB,0.21878E-03_JPRB,0.11421E-04_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.36989E-03_JPRB,0.51812E-03_JPRB,0.54699E-03_JPRB,0.52922E-03_JPRB,0.48036E-03_JPRB, &
 & 0.41559E-03_JPRB,0.32965E-03_JPRB,0.22226E-03_JPRB,0.12395E-04_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.36721E-03_JPRB,0.52763E-03_JPRB,0.55746E-03_JPRB,0.53957E-03_JPRB,0.48891E-03_JPRB, &
 & 0.42313E-03_JPRB,0.33545E-03_JPRB,0.22588E-03_JPRB,0.13515E-04_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.36313E-03_JPRB,0.53652E-03_JPRB,0.56680E-03_JPRB,0.54791E-03_JPRB,0.49664E-03_JPRB, &
 & 0.42907E-03_JPRB,0.34043E-03_JPRB,0.22916E-03_JPRB,0.14734E-04_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.32411E-03_JPRB,0.42815E-03_JPRB,0.44725E-03_JPRB,0.43813E-03_JPRB,0.40150E-03_JPRB, &
 & 0.34871E-03_JPRB,0.27912E-03_JPRB,0.18929E-03_JPRB,0.80741E-05_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.32567E-03_JPRB,0.43786E-03_JPRB,0.46069E-03_JPRB,0.45027E-03_JPRB,0.41319E-03_JPRB, &
 & 0.35819E-03_JPRB,0.28635E-03_JPRB,0.19325E-03_JPRB,0.87340E-05_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.32429E-03_JPRB,0.44638E-03_JPRB,0.47228E-03_JPRB,0.46074E-03_JPRB,0.42272E-03_JPRB, &
 & 0.36602E-03_JPRB,0.29201E-03_JPRB,0.19653E-03_JPRB,0.96110E-05_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.32137E-03_JPRB,0.45531E-03_JPRB,0.48142E-03_JPRB,0.46951E-03_JPRB,0.42996E-03_JPRB, &
 & 0.37250E-03_JPRB,0.29709E-03_JPRB,0.19974E-03_JPRB,0.10697E-04_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.31776E-03_JPRB,0.46207E-03_JPRB,0.48880E-03_JPRB,0.47659E-03_JPRB,0.43551E-03_JPRB, &
 & 0.37776E-03_JPRB,0.30138E-03_JPRB,0.20274E-03_JPRB,0.11704E-04_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.28488E-03_JPRB,0.36767E-03_JPRB,0.38081E-03_JPRB,0.37438E-03_JPRB,0.34525E-03_JPRB, &
 & 0.30150E-03_JPRB,0.24332E-03_JPRB,0.16415E-03_JPRB,0.63970E-05_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.28539E-03_JPRB,0.37509E-03_JPRB,0.39196E-03_JPRB,0.38510E-03_JPRB,0.35566E-03_JPRB, &
 & 0.30998E-03_JPRB,0.24963E-03_JPRB,0.16766E-03_JPRB,0.72006E-05_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.28397E-03_JPRB,0.38215E-03_JPRB,0.40156E-03_JPRB,0.39428E-03_JPRB,0.36418E-03_JPRB, &
 & 0.31727E-03_JPRB,0.25446E-03_JPRB,0.17107E-03_JPRB,0.79574E-05_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.28134E-03_JPRB,0.38867E-03_JPRB,0.40959E-03_JPRB,0.40230E-03_JPRB,0.37093E-03_JPRB, &
 & 0.32301E-03_JPRB,0.25898E-03_JPRB,0.17447E-03_JPRB,0.87131E-05_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.27886E-03_JPRB,0.39360E-03_JPRB,0.41642E-03_JPRB,0.40852E-03_JPRB,0.37609E-03_JPRB, &
 & 0.32740E-03_JPRB,0.26312E-03_JPRB,0.17737E-03_JPRB,0.94704E-05_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.24923E-03_JPRB,0.31555E-03_JPRB,0.32423E-03_JPRB,0.31731E-03_JPRB,0.29410E-03_JPRB, &
 & 0.25671E-03_JPRB,0.20762E-03_JPRB,0.14074E-03_JPRB,0.55877E-05_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.24977E-03_JPRB,0.32120E-03_JPRB,0.33372E-03_JPRB,0.32657E-03_JPRB,0.30295E-03_JPRB, &
 & 0.26472E-03_JPRB,0.21303E-03_JPRB,0.14396E-03_JPRB,0.61575E-05_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.24865E-03_JPRB,0.32668E-03_JPRB,0.34180E-03_JPRB,0.33446E-03_JPRB,0.31033E-03_JPRB, &
 & 0.27144E-03_JPRB,0.21777E-03_JPRB,0.14714E-03_JPRB,0.67916E-05_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.24709E-03_JPRB,0.33133E-03_JPRB,0.34841E-03_JPRB,0.34134E-03_JPRB,0.31600E-03_JPRB, &
 & 0.27647E-03_JPRB,0.22179E-03_JPRB,0.15016E-03_JPRB,0.74653E-05_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.24455E-03_JPRB,0.33491E-03_JPRB,0.35388E-03_JPRB,0.34708E-03_JPRB,0.32069E-03_JPRB, &
 & 0.28005E-03_JPRB,0.22522E-03_JPRB,0.15242E-03_JPRB,0.81619E-05_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.21526E-03_JPRB,0.27115E-03_JPRB,0.27505E-03_JPRB,0.26802E-03_JPRB,0.24968E-03_JPRB, &
 & 0.21690E-03_JPRB,0.17481E-03_JPRB,0.11906E-03_JPRB,0.50850E-05_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.21611E-03_JPRB,0.27621E-03_JPRB,0.28298E-03_JPRB,0.27620E-03_JPRB,0.25722E-03_JPRB, &
 & 0.22411E-03_JPRB,0.18004E-03_JPRB,0.12197E-03_JPRB,0.55738E-05_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.21583E-03_JPRB,0.28060E-03_JPRB,0.28955E-03_JPRB,0.28282E-03_JPRB,0.26346E-03_JPRB, &
 & 0.23005E-03_JPRB,0.18415E-03_JPRB,0.12451E-03_JPRB,0.60864E-05_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.21446E-03_JPRB,0.28363E-03_JPRB,0.29469E-03_JPRB,0.28896E-03_JPRB,0.26860E-03_JPRB, &
 & 0.23435E-03_JPRB,0.18768E-03_JPRB,0.12690E-03_JPRB,0.66417E-05_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.21217E-03_JPRB,0.28626E-03_JPRB,0.29929E-03_JPRB,0.29370E-03_JPRB,0.27250E-03_JPRB, &
 & 0.23763E-03_JPRB,0.19073E-03_JPRB,0.12909E-03_JPRB,0.72122E-05_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.18262E-03_JPRB,0.23112E-03_JPRB,0.23388E-03_JPRB,0.22681E-03_JPRB,0.21062E-03_JPRB, &
 & 0.18196E-03_JPRB,0.14634E-03_JPRB,0.99707E-04_JPRB,0.48078E-05_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.18393E-03_JPRB,0.23591E-03_JPRB,0.24094E-03_JPRB,0.23364E-03_JPRB,0.21663E-03_JPRB, &
 & 0.18814E-03_JPRB,0.15114E-03_JPRB,0.10205E-03_JPRB,0.52252E-05_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.18379E-03_JPRB,0.23984E-03_JPRB,0.24676E-03_JPRB,0.23956E-03_JPRB,0.22221E-03_JPRB, &
 & 0.19356E-03_JPRB,0.15489E-03_JPRB,0.10434E-03_JPRB,0.56405E-05_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.18270E-03_JPRB,0.24258E-03_JPRB,0.25102E-03_JPRB,0.24458E-03_JPRB,0.22685E-03_JPRB, &
 & 0.19771E-03_JPRB,0.15805E-03_JPRB,0.10655E-03_JPRB,0.60728E-05_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.18067E-03_JPRB,0.24446E-03_JPRB,0.25467E-03_JPRB,0.24894E-03_JPRB,0.23051E-03_JPRB, &
 & 0.20056E-03_JPRB,0.16088E-03_JPRB,0.10844E-03_JPRB,0.65160E-05_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.15269E-03_JPRB,0.19407E-03_JPRB,0.19640E-03_JPRB,0.19073E-03_JPRB,0.17715E-03_JPRB, &
 & 0.15224E-03_JPRB,0.12181E-03_JPRB,0.83302E-04_JPRB,0.45185E-05_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.15450E-03_JPRB,0.19834E-03_JPRB,0.20246E-03_JPRB,0.19675E-03_JPRB,0.18242E-03_JPRB, &
 & 0.15776E-03_JPRB,0.12610E-03_JPRB,0.85306E-04_JPRB,0.49315E-05_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.15459E-03_JPRB,0.20178E-03_JPRB,0.20759E-03_JPRB,0.20176E-03_JPRB,0.18737E-03_JPRB, &
 & 0.16233E-03_JPRB,0.12951E-03_JPRB,0.87417E-04_JPRB,0.53491E-05_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.15368E-03_JPRB,0.20410E-03_JPRB,0.21160E-03_JPRB,0.20623E-03_JPRB,0.19161E-03_JPRB, &
 & 0.16603E-03_JPRB,0.13246E-03_JPRB,0.89237E-04_JPRB,0.57562E-05_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.15207E-03_JPRB,0.20567E-03_JPRB,0.21458E-03_JPRB,0.20991E-03_JPRB,0.19525E-03_JPRB, &
 & 0.16906E-03_JPRB,0.13481E-03_JPRB,0.90932E-04_JPRB,0.61659E-05_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.12672E-03_JPRB,0.16159E-03_JPRB,0.16329E-03_JPRB,0.15821E-03_JPRB,0.14746E-03_JPRB, &
 & 0.12624E-03_JPRB,0.10116E-03_JPRB,0.69306E-04_JPRB,0.46652E-05_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.12853E-03_JPRB,0.16539E-03_JPRB,0.16859E-03_JPRB,0.16359E-03_JPRB,0.15208E-03_JPRB, &
 & 0.13120E-03_JPRB,0.10513E-03_JPRB,0.71005E-04_JPRB,0.51392E-05_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.12901E-03_JPRB,0.16841E-03_JPRB,0.17301E-03_JPRB,0.16813E-03_JPRB,0.15614E-03_JPRB, &
 & 0.13532E-03_JPRB,0.10829E-03_JPRB,0.72863E-04_JPRB,0.55244E-05_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.12833E-03_JPRB,0.17058E-03_JPRB,0.17652E-03_JPRB,0.17184E-03_JPRB,0.15971E-03_JPRB, &
 & 0.13867E-03_JPRB,0.11087E-03_JPRB,0.74475E-04_JPRB,0.58193E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART3',0,ZHOOK_HANDLE)


KA(:, 5, 8, 3) = (/ &
 & 0.12715E-03_JPRB,0.17197E-03_JPRB,0.17918E-03_JPRB,0.17513E-03_JPRB,0.16292E-03_JPRB, &
 & 0.14144E-03_JPRB,0.11301E-03_JPRB,0.75965E-04_JPRB,0.61705E-05_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.10428E-03_JPRB,0.13348E-03_JPRB,0.13462E-03_JPRB,0.12995E-03_JPRB,0.12158E-03_JPRB, &
 & 0.10379E-03_JPRB,0.83005E-04_JPRB,0.57371E-04_JPRB,0.55965E-05_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.10619E-03_JPRB,0.13710E-03_JPRB,0.13932E-03_JPRB,0.13469E-03_JPRB,0.12538E-03_JPRB, &
 & 0.10800E-03_JPRB,0.86632E-04_JPRB,0.58954E-04_JPRB,0.61961E-05_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.10690E-03_JPRB,0.13978E-03_JPRB,0.14315E-03_JPRB,0.13877E-03_JPRB,0.12885E-03_JPRB, &
 & 0.11169E-03_JPRB,0.89643E-04_JPRB,0.60568E-04_JPRB,0.68526E-05_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.10668E-03_JPRB,0.14178E-03_JPRB,0.14626E-03_JPRB,0.14213E-03_JPRB,0.13207E-03_JPRB, &
 & 0.11468E-03_JPRB,0.91984E-04_JPRB,0.62070E-04_JPRB,0.75122E-05_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.10582E-03_JPRB,0.14316E-03_JPRB,0.14873E-03_JPRB,0.14501E-03_JPRB,0.13471E-03_JPRB, &
 & 0.11704E-03_JPRB,0.93876E-04_JPRB,0.63388E-04_JPRB,0.80761E-05_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.85476E-04_JPRB,0.10982E-03_JPRB,0.11034E-03_JPRB,0.10643E-03_JPRB,0.99702E-04_JPRB, &
 & 0.84967E-04_JPRB,0.68008E-04_JPRB,0.47229E-04_JPRB,0.66145E-05_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.87242E-04_JPRB,0.11322E-03_JPRB,0.11463E-03_JPRB,0.11045E-03_JPRB,0.10293E-03_JPRB, &
 & 0.88580E-04_JPRB,0.71113E-04_JPRB,0.48631E-04_JPRB,0.75452E-05_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.88111E-04_JPRB,0.11563E-03_JPRB,0.11792E-03_JPRB,0.11404E-03_JPRB,0.10587E-03_JPRB, &
 & 0.91877E-04_JPRB,0.73790E-04_JPRB,0.50044E-04_JPRB,0.84881E-05_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.88200E-04_JPRB,0.11743E-03_JPRB,0.12065E-03_JPRB,0.11708E-03_JPRB,0.10870E-03_JPRB, &
 & 0.94480E-04_JPRB,0.75897E-04_JPRB,0.51384E-04_JPRB,0.95136E-05_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.87583E-04_JPRB,0.11871E-03_JPRB,0.12292E-03_JPRB,0.11954E-03_JPRB,0.11103E-03_JPRB, &
 & 0.96523E-04_JPRB,0.77526E-04_JPRB,0.52518E-04_JPRB,0.10532E-04_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.70556E-04_JPRB,0.91428E-04_JPRB,0.91867E-04_JPRB,0.88463E-04_JPRB,0.82846E-04_JPRB, &
 & 0.70774E-04_JPRB,0.56632E-04_JPRB,0.39167E-04_JPRB,0.61872E-05_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.71933E-04_JPRB,0.94182E-04_JPRB,0.95269E-04_JPRB,0.91646E-04_JPRB,0.85383E-04_JPRB, &
 & 0.73738E-04_JPRB,0.59219E-04_JPRB,0.40474E-04_JPRB,0.69965E-05_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.72567E-04_JPRB,0.96098E-04_JPRB,0.97927E-04_JPRB,0.94606E-04_JPRB,0.87837E-04_JPRB, &
 & 0.76370E-04_JPRB,0.61326E-04_JPRB,0.41633E-04_JPRB,0.78235E-05_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.72529E-04_JPRB,0.97532E-04_JPRB,0.10011E-03_JPRB,0.97076E-04_JPRB,0.90134E-04_JPRB, &
 & 0.78428E-04_JPRB,0.63016E-04_JPRB,0.42754E-04_JPRB,0.87904E-05_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.71990E-04_JPRB,0.98552E-04_JPRB,0.10193E-03_JPRB,0.99080E-04_JPRB,0.92091E-04_JPRB, &
 & 0.80068E-04_JPRB,0.64349E-04_JPRB,0.43674E-04_JPRB,0.98011E-05_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.58072E-04_JPRB,0.75815E-04_JPRB,0.76168E-04_JPRB,0.73252E-04_JPRB,0.68521E-04_JPRB, &
 & 0.58748E-04_JPRB,0.47029E-04_JPRB,0.32430E-04_JPRB,0.51838E-05_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.59149E-04_JPRB,0.78005E-04_JPRB,0.78889E-04_JPRB,0.75853E-04_JPRB,0.70691E-04_JPRB, &
 & 0.61160E-04_JPRB,0.49105E-04_JPRB,0.33572E-04_JPRB,0.58669E-05_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.59615E-04_JPRB,0.79572E-04_JPRB,0.81043E-04_JPRB,0.78301E-04_JPRB,0.72716E-04_JPRB, &
 & 0.63265E-04_JPRB,0.50777E-04_JPRB,0.34506E-04_JPRB,0.66464E-05_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.59506E-04_JPRB,0.80712E-04_JPRB,0.82811E-04_JPRB,0.80321E-04_JPRB,0.74571E-04_JPRB, &
 & 0.64935E-04_JPRB,0.52165E-04_JPRB,0.35447E-04_JPRB,0.74412E-05_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.59067E-04_JPRB,0.81520E-04_JPRB,0.84288E-04_JPRB,0.81977E-04_JPRB,0.76172E-04_JPRB, &
 & 0.66259E-04_JPRB,0.53281E-04_JPRB,0.36178E-04_JPRB,0.82465E-05_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.47640E-04_JPRB,0.62583E-04_JPRB,0.62887E-04_JPRB,0.60485E-04_JPRB,0.56559E-04_JPRB, &
 & 0.48624E-04_JPRB,0.38904E-04_JPRB,0.26773E-04_JPRB,0.40582E-05_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.48498E-04_JPRB,0.64379E-04_JPRB,0.65087E-04_JPRB,0.62641E-04_JPRB,0.58377E-04_JPRB, &
 & 0.50572E-04_JPRB,0.40566E-04_JPRB,0.27717E-04_JPRB,0.46616E-05_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.48844E-04_JPRB,0.65656E-04_JPRB,0.66851E-04_JPRB,0.64628E-04_JPRB,0.60042E-04_JPRB, &
 & 0.52254E-04_JPRB,0.41917E-04_JPRB,0.28510E-04_JPRB,0.53204E-05_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.48722E-04_JPRB,0.66574E-04_JPRB,0.68303E-04_JPRB,0.66300E-04_JPRB,0.61547E-04_JPRB, &
 & 0.53614E-04_JPRB,0.43058E-04_JPRB,0.29254E-04_JPRB,0.59442E-05_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.48355E-04_JPRB,0.67217E-04_JPRB,0.69511E-04_JPRB,0.67651E-04_JPRB,0.62864E-04_JPRB, &
 & 0.54712E-04_JPRB,0.43998E-04_JPRB,0.29875E-04_JPRB,0.66436E-05_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.85387E-03_JPRB,0.97268E-03_JPRB,0.95201E-03_JPRB,0.89226E-03_JPRB,0.81465E-03_JPRB, &
 & 0.69707E-03_JPRB,0.54829E-03_JPRB,0.35882E-03_JPRB,0.37920E-04_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.85496E-03_JPRB,0.98746E-03_JPRB,0.97188E-03_JPRB,0.91775E-03_JPRB,0.83529E-03_JPRB, &
 & 0.71649E-03_JPRB,0.56376E-03_JPRB,0.37061E-03_JPRB,0.43155E-04_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.85154E-03_JPRB,0.99908E-03_JPRB,0.98969E-03_JPRB,0.94014E-03_JPRB,0.85604E-03_JPRB, &
 & 0.73379E-03_JPRB,0.57832E-03_JPRB,0.38183E-03_JPRB,0.48702E-04_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.84606E-03_JPRB,0.10090E-02_JPRB,0.10068E-02_JPRB,0.95944E-03_JPRB,0.87434E-03_JPRB, &
 & 0.74975E-03_JPRB,0.59243E-03_JPRB,0.39188E-03_JPRB,0.54022E-04_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.84061E-03_JPRB,0.10171E-02_JPRB,0.10218E-02_JPRB,0.97684E-03_JPRB,0.88906E-03_JPRB, &
 & 0.76345E-03_JPRB,0.60471E-03_JPRB,0.40180E-03_JPRB,0.59778E-04_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.76106E-03_JPRB,0.86763E-03_JPRB,0.84620E-03_JPRB,0.79337E-03_JPRB,0.72368E-03_JPRB, &
 & 0.62633E-03_JPRB,0.49168E-03_JPRB,0.32346E-03_JPRB,0.31322E-04_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.76153E-03_JPRB,0.88148E-03_JPRB,0.86349E-03_JPRB,0.81559E-03_JPRB,0.74480E-03_JPRB, &
 & 0.64448E-03_JPRB,0.50635E-03_JPRB,0.33430E-03_JPRB,0.35566E-04_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.75977E-03_JPRB,0.89195E-03_JPRB,0.87871E-03_JPRB,0.83605E-03_JPRB,0.76286E-03_JPRB, &
 & 0.66127E-03_JPRB,0.51959E-03_JPRB,0.34472E-03_JPRB,0.39705E-04_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.75771E-03_JPRB,0.89987E-03_JPRB,0.89406E-03_JPRB,0.85530E-03_JPRB,0.78123E-03_JPRB, &
 & 0.67612E-03_JPRB,0.53221E-03_JPRB,0.35447E-03_JPRB,0.44266E-04_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.75289E-03_JPRB,0.90657E-03_JPRB,0.90771E-03_JPRB,0.87200E-03_JPRB,0.79715E-03_JPRB, &
 & 0.68926E-03_JPRB,0.54382E-03_JPRB,0.36372E-03_JPRB,0.48708E-04_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.66893E-03_JPRB,0.76246E-03_JPRB,0.74334E-03_JPRB,0.69752E-03_JPRB,0.63501E-03_JPRB, &
 & 0.55362E-03_JPRB,0.43455E-03_JPRB,0.28843E-03_JPRB,0.24260E-04_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.67118E-03_JPRB,0.77588E-03_JPRB,0.75944E-03_JPRB,0.71710E-03_JPRB,0.65461E-03_JPRB, &
 & 0.57122E-03_JPRB,0.44991E-03_JPRB,0.29906E-03_JPRB,0.27434E-04_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.67218E-03_JPRB,0.78505E-03_JPRB,0.77328E-03_JPRB,0.73497E-03_JPRB,0.67286E-03_JPRB, &
 & 0.58718E-03_JPRB,0.46375E-03_JPRB,0.30933E-03_JPRB,0.30808E-04_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.67058E-03_JPRB,0.79242E-03_JPRB,0.78627E-03_JPRB,0.75181E-03_JPRB,0.68946E-03_JPRB, &
 & 0.60183E-03_JPRB,0.47532E-03_JPRB,0.31743E-03_JPRB,0.34324E-04_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.66467E-03_JPRB,0.79822E-03_JPRB,0.79776E-03_JPRB,0.76779E-03_JPRB,0.70481E-03_JPRB, &
 & 0.61510E-03_JPRB,0.48553E-03_JPRB,0.32526E-03_JPRB,0.37905E-04_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.58297E-03_JPRB,0.66020E-03_JPRB,0.64337E-03_JPRB,0.60610E-03_JPRB,0.55222E-03_JPRB, &
 & 0.48338E-03_JPRB,0.38154E-03_JPRB,0.25537E-03_JPRB,0.20054E-04_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.58616E-03_JPRB,0.67311E-03_JPRB,0.65764E-03_JPRB,0.62362E-03_JPRB,0.56996E-03_JPRB, &
 & 0.49939E-03_JPRB,0.39657E-03_JPRB,0.26418E-03_JPRB,0.22457E-04_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.58719E-03_JPRB,0.68291E-03_JPRB,0.67014E-03_JPRB,0.63926E-03_JPRB,0.58703E-03_JPRB, &
 & 0.51453E-03_JPRB,0.40976E-03_JPRB,0.27280E-03_JPRB,0.24974E-04_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.58451E-03_JPRB,0.68925E-03_JPRB,0.68144E-03_JPRB,0.65410E-03_JPRB,0.60312E-03_JPRB, &
 & 0.52903E-03_JPRB,0.42147E-03_JPRB,0.28096E-03_JPRB,0.27613E-04_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.57885E-03_JPRB,0.69369E-03_JPRB,0.69153E-03_JPRB,0.66725E-03_JPRB,0.61666E-03_JPRB, &
 & 0.54114E-03_JPRB,0.43123E-03_JPRB,0.28907E-03_JPRB,0.30243E-04_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.50639E-03_JPRB,0.56897E-03_JPRB,0.55412E-03_JPRB,0.52127E-03_JPRB,0.47341E-03_JPRB, &
 & 0.41669E-03_JPRB,0.33293E-03_JPRB,0.22215E-03_JPRB,0.17057E-04_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.51065E-03_JPRB,0.58111E-03_JPRB,0.56740E-03_JPRB,0.53642E-03_JPRB,0.48970E-03_JPRB, &
 & 0.43166E-03_JPRB,0.34671E-03_JPRB,0.23111E-03_JPRB,0.19191E-04_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.51131E-03_JPRB,0.58923E-03_JPRB,0.57802E-03_JPRB,0.54989E-03_JPRB,0.50519E-03_JPRB, &
 & 0.44520E-03_JPRB,0.35867E-03_JPRB,0.23955E-03_JPRB,0.21238E-04_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.50888E-03_JPRB,0.59432E-03_JPRB,0.58700E-03_JPRB,0.56238E-03_JPRB,0.51899E-03_JPRB, &
 & 0.45787E-03_JPRB,0.36960E-03_JPRB,0.24733E-03_JPRB,0.23442E-04_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.50411E-03_JPRB,0.59804E-03_JPRB,0.59497E-03_JPRB,0.57342E-03_JPRB,0.53158E-03_JPRB, &
 & 0.46924E-03_JPRB,0.37886E-03_JPRB,0.25450E-03_JPRB,0.25756E-04_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.43673E-03_JPRB,0.48782E-03_JPRB,0.47499E-03_JPRB,0.44629E-03_JPRB,0.40354E-03_JPRB, &
 & 0.35457E-03_JPRB,0.28605E-03_JPRB,0.19086E-03_JPRB,0.14702E-04_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.44102E-03_JPRB,0.49831E-03_JPRB,0.48639E-03_JPRB,0.45943E-03_JPRB,0.41879E-03_JPRB, &
 & 0.36808E-03_JPRB,0.29802E-03_JPRB,0.19985E-03_JPRB,0.16471E-04_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.44221E-03_JPRB,0.50518E-03_JPRB,0.49538E-03_JPRB,0.47075E-03_JPRB,0.43183E-03_JPRB, &
 & 0.37995E-03_JPRB,0.30882E-03_JPRB,0.20763E-03_JPRB,0.18420E-04_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.44017E-03_JPRB,0.50994E-03_JPRB,0.50323E-03_JPRB,0.48141E-03_JPRB,0.44360E-03_JPRB, &
 & 0.39116E-03_JPRB,0.31844E-03_JPRB,0.21460E-03_JPRB,0.20473E-04_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.43656E-03_JPRB,0.51249E-03_JPRB,0.51000E-03_JPRB,0.49068E-03_JPRB,0.45425E-03_JPRB, &
 & 0.40107E-03_JPRB,0.32653E-03_JPRB,0.22109E-03_JPRB,0.22600E-04_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.37627E-03_JPRB,0.41525E-03_JPRB,0.40365E-03_JPRB,0.37923E-03_JPRB,0.34257E-03_JPRB, &
 & 0.30147E-03_JPRB,0.24324E-03_JPRB,0.16094E-03_JPRB,0.13400E-04_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.38051E-03_JPRB,0.42489E-03_JPRB,0.41400E-03_JPRB,0.39067E-03_JPRB,0.35555E-03_JPRB, &
 & 0.31257E-03_JPRB,0.25353E-03_JPRB,0.16947E-03_JPRB,0.14905E-04_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.38196E-03_JPRB,0.43154E-03_JPRB,0.42169E-03_JPRB,0.40035E-03_JPRB,0.36703E-03_JPRB, &
 & 0.32311E-03_JPRB,0.26291E-03_JPRB,0.17672E-03_JPRB,0.16566E-04_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.38108E-03_JPRB,0.43587E-03_JPRB,0.42809E-03_JPRB,0.40890E-03_JPRB,0.37694E-03_JPRB, &
 & 0.33246E-03_JPRB,0.27094E-03_JPRB,0.18305E-03_JPRB,0.18352E-04_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.37854E-03_JPRB,0.43889E-03_JPRB,0.43402E-03_JPRB,0.41697E-03_JPRB,0.38532E-03_JPRB, &
 & 0.34074E-03_JPRB,0.27816E-03_JPRB,0.18873E-03_JPRB,0.20220E-04_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.31968E-03_JPRB,0.35301E-03_JPRB,0.34310E-03_JPRB,0.32206E-03_JPRB,0.28904E-03_JPRB, &
 & 0.25356E-03_JPRB,0.20523E-03_JPRB,0.13432E-03_JPRB,0.13548E-04_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.32386E-03_JPRB,0.36229E-03_JPRB,0.35288E-03_JPRB,0.33214E-03_JPRB,0.30033E-03_JPRB, &
 & 0.26345E-03_JPRB,0.21374E-03_JPRB,0.14198E-03_JPRB,0.14966E-04_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.32521E-03_JPRB,0.36848E-03_JPRB,0.35986E-03_JPRB,0.34056E-03_JPRB,0.31042E-03_JPRB, &
 & 0.27222E-03_JPRB,0.22115E-03_JPRB,0.14841E-03_JPRB,0.16278E-04_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.32527E-03_JPRB,0.37258E-03_JPRB,0.36553E-03_JPRB,0.34811E-03_JPRB,0.31916E-03_JPRB, &
 & 0.28034E-03_JPRB,0.22837E-03_JPRB,0.15443E-03_JPRB,0.17614E-04_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.32272E-03_JPRB,0.37533E-03_JPRB,0.37025E-03_JPRB,0.35438E-03_JPRB,0.32632E-03_JPRB, &
 & 0.28740E-03_JPRB,0.23484E-03_JPRB,0.15952E-03_JPRB,0.19075E-04_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.26794E-03_JPRB,0.29655E-03_JPRB,0.28851E-03_JPRB,0.27155E-03_JPRB,0.24290E-03_JPRB, &
 & 0.21182E-03_JPRB,0.17187E-03_JPRB,0.11158E-03_JPRB,0.16893E-04_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.27215E-03_JPRB,0.30477E-03_JPRB,0.29765E-03_JPRB,0.28075E-03_JPRB,0.25336E-03_JPRB, &
 & 0.22120E-03_JPRB,0.17858E-03_JPRB,0.11794E-03_JPRB,0.18576E-04_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.27400E-03_JPRB,0.31061E-03_JPRB,0.30447E-03_JPRB,0.28836E-03_JPRB,0.26224E-03_JPRB, &
 & 0.22886E-03_JPRB,0.18474E-03_JPRB,0.12372E-03_JPRB,0.20056E-04_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.27385E-03_JPRB,0.31424E-03_JPRB,0.30923E-03_JPRB,0.29477E-03_JPRB,0.26977E-03_JPRB, &
 & 0.23554E-03_JPRB,0.19093E-03_JPRB,0.12884E-03_JPRB,0.21321E-04_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.27196E-03_JPRB,0.31647E-03_JPRB,0.31308E-03_JPRB,0.30006E-03_JPRB,0.27604E-03_JPRB, &
 & 0.24191E-03_JPRB,0.19649E-03_JPRB,0.13352E-03_JPRB,0.22611E-04_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.22255E-03_JPRB,0.24716E-03_JPRB,0.24087E-03_JPRB,0.22672E-03_JPRB,0.20216E-03_JPRB, &
 & 0.17582E-03_JPRB,0.14339E-03_JPRB,0.92528E-04_JPRB,0.22471E-04_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.22663E-03_JPRB,0.25429E-03_JPRB,0.24908E-03_JPRB,0.23506E-03_JPRB,0.21167E-03_JPRB, &
 & 0.18377E-03_JPRB,0.14910E-03_JPRB,0.97972E-04_JPRB,0.24536E-04_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.22867E-03_JPRB,0.25963E-03_JPRB,0.25532E-03_JPRB,0.24169E-03_JPRB,0.21923E-03_JPRB, &
 & 0.19067E-03_JPRB,0.15458E-03_JPRB,0.10293E-03_JPRB,0.26453E-04_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.22853E-03_JPRB,0.26273E-03_JPRB,0.25960E-03_JPRB,0.24704E-03_JPRB,0.22549E-03_JPRB, &
 & 0.19679E-03_JPRB,0.15968E-03_JPRB,0.10728E-03_JPRB,0.28383E-04_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.22704E-03_JPRB,0.26469E-03_JPRB,0.26259E-03_JPRB,0.25141E-03_JPRB,0.23080E-03_JPRB, &
 & 0.20216E-03_JPRB,0.16433E-03_JPRB,0.11116E-03_JPRB,0.30111E-04_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.18570E-03_JPRB,0.20791E-03_JPRB,0.20310E-03_JPRB,0.19106E-03_JPRB,0.17066E-03_JPRB, &
 & 0.14797E-03_JPRB,0.12097E-03_JPRB,0.78704E-04_JPRB,0.20720E-04_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.18868E-03_JPRB,0.21356E-03_JPRB,0.20969E-03_JPRB,0.19807E-03_JPRB,0.17821E-03_JPRB, &
 & 0.15434E-03_JPRB,0.12584E-03_JPRB,0.83179E-04_JPRB,0.23268E-04_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.18972E-03_JPRB,0.21732E-03_JPRB,0.21447E-03_JPRB,0.20305E-03_JPRB,0.18416E-03_JPRB, &
 & 0.15993E-03_JPRB,0.13006E-03_JPRB,0.87134E-04_JPRB,0.25781E-04_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.18929E-03_JPRB,0.21955E-03_JPRB,0.21771E-03_JPRB,0.20711E-03_JPRB,0.18907E-03_JPRB, &
 & 0.16493E-03_JPRB,0.13420E-03_JPRB,0.90699E-04_JPRB,0.28181E-04_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.18766E-03_JPRB,0.22095E-03_JPRB,0.21987E-03_JPRB,0.21045E-03_JPRB,0.19312E-03_JPRB, &
 & 0.16934E-03_JPRB,0.13812E-03_JPRB,0.93840E-04_JPRB,0.30489E-04_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.15409E-03_JPRB,0.17399E-03_JPRB,0.17010E-03_JPRB,0.16002E-03_JPRB,0.14311E-03_JPRB, &
 & 0.12376E-03_JPRB,0.10121E-03_JPRB,0.66428E-04_JPRB,0.17813E-04_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.15599E-03_JPRB,0.17831E-03_JPRB,0.17521E-03_JPRB,0.16554E-03_JPRB,0.14890E-03_JPRB, &
 & 0.12881E-03_JPRB,0.10527E-03_JPRB,0.69964E-04_JPRB,0.19918E-04_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.15661E-03_JPRB,0.18119E-03_JPRB,0.17892E-03_JPRB,0.16934E-03_JPRB,0.15365E-03_JPRB, &
 & 0.13338E-03_JPRB,0.10864E-03_JPRB,0.73142E-04_JPRB,0.22121E-04_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.15608E-03_JPRB,0.18293E-03_JPRB,0.18145E-03_JPRB,0.17254E-03_JPRB,0.15743E-03_JPRB, &
 & 0.13747E-03_JPRB,0.11209E-03_JPRB,0.75971E-04_JPRB,0.24425E-04_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.15453E-03_JPRB,0.18383E-03_JPRB,0.18309E-03_JPRB,0.17510E-03_JPRB,0.16067E-03_JPRB, &
 & 0.14102E-03_JPRB,0.11529E-03_JPRB,0.78607E-04_JPRB,0.26791E-04_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.12705E-03_JPRB,0.14485E-03_JPRB,0.14155E-03_JPRB,0.13312E-03_JPRB,0.11914E-03_JPRB, &
 & 0.10299E-03_JPRB,0.84416E-04_JPRB,0.55598E-04_JPRB,0.14429E-04_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.12843E-03_JPRB,0.14822E-03_JPRB,0.14555E-03_JPRB,0.13748E-03_JPRB,0.12377E-03_JPRB, &
 & 0.10702E-03_JPRB,0.87520E-04_JPRB,0.58405E-04_JPRB,0.16147E-04_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.12875E-03_JPRB,0.15043E-03_JPRB,0.14850E-03_JPRB,0.14053E-03_JPRB,0.12752E-03_JPRB, &
 & 0.11081E-03_JPRB,0.90348E-04_JPRB,0.60934E-04_JPRB,0.17992E-04_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.12822E-03_JPRB,0.15175E-03_JPRB,0.15049E-03_JPRB,0.14301E-03_JPRB,0.13059E-03_JPRB, &
 & 0.11413E-03_JPRB,0.93171E-04_JPRB,0.63296E-04_JPRB,0.19888E-04_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.12684E-03_JPRB,0.15239E-03_JPRB,0.15179E-03_JPRB,0.14511E-03_JPRB,0.13320E-03_JPRB, &
 & 0.11702E-03_JPRB,0.95786E-04_JPRB,0.65468E-04_JPRB,0.21706E-04_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.16451E-02_JPRB,0.17375E-02_JPRB,0.16665E-02_JPRB,0.15396E-02_JPRB,0.13696E-02_JPRB, &
 & 0.11731E-02_JPRB,0.92753E-03_JPRB,0.61159E-03_JPRB,0.14680E-03_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.16450E-02_JPRB,0.17591E-02_JPRB,0.16954E-02_JPRB,0.15711E-02_JPRB,0.14087E-02_JPRB, &
 & 0.12092E-02_JPRB,0.95859E-03_JPRB,0.63308E-03_JPRB,0.16131E-03_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.16396E-02_JPRB,0.17762E-02_JPRB,0.17200E-02_JPRB,0.16012E-02_JPRB,0.14448E-02_JPRB, &
 & 0.12424E-02_JPRB,0.98862E-03_JPRB,0.65400E-03_JPRB,0.17365E-03_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.16299E-02_JPRB,0.17875E-02_JPRB,0.17415E-02_JPRB,0.16313E-02_JPRB,0.14788E-02_JPRB, &
 & 0.12751E-02_JPRB,0.10161E-02_JPRB,0.67524E-03_JPRB,0.18499E-03_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.16127E-02_JPRB,0.17946E-02_JPRB,0.17629E-02_JPRB,0.16594E-02_JPRB,0.15119E-02_JPRB, &
 & 0.13059E-02_JPRB,0.10419E-02_JPRB,0.69511E-03_JPRB,0.19999E-03_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.15084E-02_JPRB,0.15931E-02_JPRB,0.15186E-02_JPRB,0.13958E-02_JPRB,0.12369E-02_JPRB, &
 & 0.10500E-02_JPRB,0.83688E-03_JPRB,0.55465E-03_JPRB,0.11914E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART4',0,ZHOOK_HANDLE)


KA(:, 2, 2, 5) = (/ &
 & 0.15115E-02_JPRB,0.16146E-02_JPRB,0.15457E-02_JPRB,0.14241E-02_JPRB,0.12724E-02_JPRB, &
 & 0.10844E-02_JPRB,0.86669E-03_JPRB,0.57603E-03_JPRB,0.13037E-03_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.15084E-02_JPRB,0.16309E-02_JPRB,0.15669E-02_JPRB,0.14522E-02_JPRB,0.13074E-02_JPRB, &
 & 0.11181E-02_JPRB,0.89787E-03_JPRB,0.59657E-03_JPRB,0.13918E-03_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.14965E-02_JPRB,0.16419E-02_JPRB,0.15861E-02_JPRB,0.14781E-02_JPRB,0.13385E-02_JPRB, &
 & 0.11507E-02_JPRB,0.92569E-03_JPRB,0.61596E-03_JPRB,0.15053E-03_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.14804E-02_JPRB,0.16493E-02_JPRB,0.16042E-02_JPRB,0.15021E-02_JPRB,0.13704E-02_JPRB, &
 & 0.11804E-02_JPRB,0.95044E-03_JPRB,0.63472E-03_JPRB,0.16410E-03_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.13707E-02_JPRB,0.14436E-02_JPRB,0.13706E-02_JPRB,0.12561E-02_JPRB,0.11093E-02_JPRB, &
 & 0.93534E-03_JPRB,0.74505E-03_JPRB,0.49303E-03_JPRB,0.93388E-04_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.13760E-02_JPRB,0.14666E-02_JPRB,0.13986E-02_JPRB,0.12850E-02_JPRB,0.11416E-02_JPRB, &
 & 0.96700E-03_JPRB,0.77192E-03_JPRB,0.51430E-03_JPRB,0.10062E-03_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.13732E-02_JPRB,0.14839E-02_JPRB,0.14208E-02_JPRB,0.13112E-02_JPRB,0.11718E-02_JPRB, &
 & 0.99814E-03_JPRB,0.79899E-03_JPRB,0.53404E-03_JPRB,0.10964E-03_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.13644E-02_JPRB,0.14939E-02_JPRB,0.14404E-02_JPRB,0.13346E-02_JPRB,0.12002E-02_JPRB, &
 & 0.10295E-02_JPRB,0.82532E-03_JPRB,0.55285E-03_JPRB,0.12023E-03_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.13512E-02_JPRB,0.15024E-02_JPRB,0.14568E-02_JPRB,0.13559E-02_JPRB,0.12266E-02_JPRB, &
 & 0.10592E-02_JPRB,0.85085E-03_JPRB,0.57058E-03_JPRB,0.13064E-03_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.12336E-02_JPRB,0.12968E-02_JPRB,0.12255E-02_JPRB,0.11189E-02_JPRB,0.98785E-03_JPRB, &
 & 0.83184E-03_JPRB,0.66033E-03_JPRB,0.43467E-03_JPRB,0.70047E-04_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.12419E-02_JPRB,0.13192E-02_JPRB,0.12543E-02_JPRB,0.11482E-02_JPRB,0.10189E-02_JPRB, &
 & 0.86315E-03_JPRB,0.68559E-03_JPRB,0.45559E-03_JPRB,0.76629E-04_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.12416E-02_JPRB,0.13349E-02_JPRB,0.12771E-02_JPRB,0.11745E-02_JPRB,0.10469E-02_JPRB, &
 & 0.89182E-03_JPRB,0.71110E-03_JPRB,0.47551E-03_JPRB,0.84761E-04_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.12342E-02_JPRB,0.13470E-02_JPRB,0.12958E-02_JPRB,0.11964E-02_JPRB,0.10726E-02_JPRB, &
 & 0.91965E-03_JPRB,0.73487E-03_JPRB,0.49419E-03_JPRB,0.93979E-04_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.12238E-02_JPRB,0.13566E-02_JPRB,0.13110E-02_JPRB,0.12168E-02_JPRB,0.10976E-02_JPRB, &
 & 0.94731E-03_JPRB,0.75866E-03_JPRB,0.51080E-03_JPRB,0.10249E-03_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.10970E-02_JPRB,0.11491E-02_JPRB,0.10850E-02_JPRB,0.99037E-03_JPRB,0.87478E-03_JPRB, &
 & 0.73644E-03_JPRB,0.58168E-03_JPRB,0.38673E-03_JPRB,0.55328E-04_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.11051E-02_JPRB,0.11716E-02_JPRB,0.11129E-02_JPRB,0.10196E-02_JPRB,0.90431E-03_JPRB, &
 & 0.76445E-03_JPRB,0.60553E-03_JPRB,0.40600E-03_JPRB,0.61413E-04_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.11053E-02_JPRB,0.11877E-02_JPRB,0.11365E-02_JPRB,0.10446E-02_JPRB,0.92981E-03_JPRB, &
 & 0.79114E-03_JPRB,0.62919E-03_JPRB,0.42419E-03_JPRB,0.68340E-04_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.11000E-02_JPRB,0.12008E-02_JPRB,0.11557E-02_JPRB,0.10648E-02_JPRB,0.95310E-03_JPRB, &
 & 0.81721E-03_JPRB,0.65273E-03_JPRB,0.44128E-03_JPRB,0.75425E-04_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.10930E-02_JPRB,0.12101E-02_JPRB,0.11704E-02_JPRB,0.10855E-02_JPRB,0.97521E-03_JPRB, &
 & 0.84232E-03_JPRB,0.67516E-03_JPRB,0.45733E-03_JPRB,0.82112E-04_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.96254E-03_JPRB,0.10041E-02_JPRB,0.94496E-03_JPRB,0.86305E-03_JPRB,0.76515E-03_JPRB, &
 & 0.64666E-03_JPRB,0.50949E-03_JPRB,0.34237E-03_JPRB,0.45743E-04_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.97168E-03_JPRB,0.10257E-02_JPRB,0.97306E-03_JPRB,0.89241E-03_JPRB,0.79300E-03_JPRB, &
 & 0.67315E-03_JPRB,0.53212E-03_JPRB,0.35953E-03_JPRB,0.50936E-04_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.97307E-03_JPRB,0.10417E-02_JPRB,0.99540E-03_JPRB,0.91663E-03_JPRB,0.81739E-03_JPRB, &
 & 0.69764E-03_JPRB,0.55388E-03_JPRB,0.37625E-03_JPRB,0.56704E-04_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.97112E-03_JPRB,0.10538E-02_JPRB,0.10130E-02_JPRB,0.93600E-03_JPRB,0.83875E-03_JPRB, &
 & 0.72048E-03_JPRB,0.57540E-03_JPRB,0.39219E-03_JPRB,0.62214E-04_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.96524E-03_JPRB,0.10634E-02_JPRB,0.10272E-02_JPRB,0.95339E-03_JPRB,0.85814E-03_JPRB, &
 & 0.74256E-03_JPRB,0.59649E-03_JPRB,0.40723E-03_JPRB,0.68154E-04_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.83977E-03_JPRB,0.87150E-03_JPRB,0.81798E-03_JPRB,0.74510E-03_JPRB,0.66073E-03_JPRB, &
 & 0.55889E-03_JPRB,0.44038E-03_JPRB,0.30023E-03_JPRB,0.39438E-04_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.84860E-03_JPRB,0.89183E-03_JPRB,0.84311E-03_JPRB,0.77202E-03_JPRB,0.68677E-03_JPRB, &
 & 0.58412E-03_JPRB,0.46261E-03_JPRB,0.31513E-03_JPRB,0.44026E-04_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.85156E-03_JPRB,0.90640E-03_JPRB,0.86357E-03_JPRB,0.79472E-03_JPRB,0.70843E-03_JPRB, &
 & 0.60616E-03_JPRB,0.48333E-03_JPRB,0.32962E-03_JPRB,0.48169E-04_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.84996E-03_JPRB,0.91804E-03_JPRB,0.88000E-03_JPRB,0.81332E-03_JPRB,0.72741E-03_JPRB, &
 & 0.62668E-03_JPRB,0.50295E-03_JPRB,0.34425E-03_JPRB,0.52632E-04_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.84411E-03_JPRB,0.92502E-03_JPRB,0.89195E-03_JPRB,0.82771E-03_JPRB,0.74479E-03_JPRB, &
 & 0.64630E-03_JPRB,0.52177E-03_JPRB,0.35838E-03_JPRB,0.57490E-04_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.72566E-03_JPRB,0.75029E-03_JPRB,0.70410E-03_JPRB,0.64085E-03_JPRB,0.56881E-03_JPRB, &
 & 0.48163E-03_JPRB,0.37585E-03_JPRB,0.26029E-03_JPRB,0.35173E-04_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.73526E-03_JPRB,0.76878E-03_JPRB,0.72724E-03_JPRB,0.66569E-03_JPRB,0.59239E-03_JPRB, &
 & 0.50357E-03_JPRB,0.39670E-03_JPRB,0.27234E-03_JPRB,0.38442E-04_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.73942E-03_JPRB,0.78240E-03_JPRB,0.74617E-03_JPRB,0.68580E-03_JPRB,0.61175E-03_JPRB, &
 & 0.52308E-03_JPRB,0.41633E-03_JPRB,0.28548E-03_JPRB,0.42620E-04_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.73787E-03_JPRB,0.79331E-03_JPRB,0.76108E-03_JPRB,0.70193E-03_JPRB,0.62821E-03_JPRB, &
 & 0.54092E-03_JPRB,0.43381E-03_JPRB,0.29821E-03_JPRB,0.47013E-04_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.73365E-03_JPRB,0.79895E-03_JPRB,0.77125E-03_JPRB,0.71463E-03_JPRB,0.64295E-03_JPRB, &
 & 0.55753E-03_JPRB,0.45033E-03_JPRB,0.31091E-03_JPRB,0.51519E-04_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.62112E-03_JPRB,0.63900E-03_JPRB,0.60071E-03_JPRB,0.54641E-03_JPRB,0.48585E-03_JPRB, &
 & 0.41219E-03_JPRB,0.31988E-03_JPRB,0.22088E-03_JPRB,0.39225E-04_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.63089E-03_JPRB,0.65678E-03_JPRB,0.62144E-03_JPRB,0.56855E-03_JPRB,0.50663E-03_JPRB, &
 & 0.43158E-03_JPRB,0.33912E-03_JPRB,0.23261E-03_JPRB,0.43145E-04_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.63630E-03_JPRB,0.67023E-03_JPRB,0.63841E-03_JPRB,0.58635E-03_JPRB,0.52398E-03_JPRB, &
 & 0.44876E-03_JPRB,0.35619E-03_JPRB,0.24341E-03_JPRB,0.47182E-04_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.63678E-03_JPRB,0.68001E-03_JPRB,0.65143E-03_JPRB,0.60045E-03_JPRB,0.53807E-03_JPRB, &
 & 0.46446E-03_JPRB,0.37160E-03_JPRB,0.25517E-03_JPRB,0.51310E-04_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.63384E-03_JPRB,0.68558E-03_JPRB,0.66049E-03_JPRB,0.61133E-03_JPRB,0.55067E-03_JPRB, &
 & 0.47828E-03_JPRB,0.38622E-03_JPRB,0.26607E-03_JPRB,0.55652E-04_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.52818E-03_JPRB,0.54302E-03_JPRB,0.51109E-03_JPRB,0.46524E-03_JPRB,0.41303E-03_JPRB, &
 & 0.35089E-03_JPRB,0.27050E-03_JPRB,0.18719E-03_JPRB,0.51897E-04_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.53874E-03_JPRB,0.56000E-03_JPRB,0.52974E-03_JPRB,0.48429E-03_JPRB,0.43151E-03_JPRB, &
 & 0.36826E-03_JPRB,0.28749E-03_JPRB,0.19624E-03_JPRB,0.57480E-04_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.54407E-03_JPRB,0.57298E-03_JPRB,0.54499E-03_JPRB,0.50007E-03_JPRB,0.44685E-03_JPRB, &
 & 0.38282E-03_JPRB,0.30218E-03_JPRB,0.20623E-03_JPRB,0.63250E-04_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.54510E-03_JPRB,0.58221E-03_JPRB,0.55605E-03_JPRB,0.51259E-03_JPRB,0.45923E-03_JPRB, &
 & 0.39550E-03_JPRB,0.31547E-03_JPRB,0.21632E-03_JPRB,0.68339E-04_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.54335E-03_JPRB,0.58744E-03_JPRB,0.56412E-03_JPRB,0.52185E-03_JPRB,0.47008E-03_JPRB, &
 & 0.40728E-03_JPRB,0.32798E-03_JPRB,0.22618E-03_JPRB,0.72964E-04_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.44901E-03_JPRB,0.46427E-03_JPRB,0.43915E-03_JPRB,0.40187E-03_JPRB,0.35719E-03_JPRB, &
 & 0.30380E-03_JPRB,0.23427E-03_JPRB,0.15956E-03_JPRB,0.52228E-04_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.45685E-03_JPRB,0.47845E-03_JPRB,0.45475E-03_JPRB,0.41772E-03_JPRB,0.37275E-03_JPRB, &
 & 0.31798E-03_JPRB,0.24772E-03_JPRB,0.16817E-03_JPRB,0.56979E-04_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.46005E-03_JPRB,0.48879E-03_JPRB,0.46665E-03_JPRB,0.43038E-03_JPRB,0.38526E-03_JPRB, &
 & 0.32982E-03_JPRB,0.25983E-03_JPRB,0.17707E-03_JPRB,0.61788E-04_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.46029E-03_JPRB,0.49540E-03_JPRB,0.47547E-03_JPRB,0.44015E-03_JPRB,0.39539E-03_JPRB, &
 & 0.34025E-03_JPRB,0.27087E-03_JPRB,0.18596E-03_JPRB,0.66537E-04_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.45760E-03_JPRB,0.49879E-03_JPRB,0.48175E-03_JPRB,0.44812E-03_JPRB,0.40429E-03_JPRB, &
 & 0.34971E-03_JPRB,0.28105E-03_JPRB,0.19422E-03_JPRB,0.70982E-04_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.37789E-03_JPRB,0.39359E-03_JPRB,0.37439E-03_JPRB,0.34335E-03_JPRB,0.30516E-03_JPRB, &
 & 0.25987E-03_JPRB,0.20136E-03_JPRB,0.13616E-03_JPRB,0.47471E-04_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.38345E-03_JPRB,0.40460E-03_JPRB,0.38678E-03_JPRB,0.35616E-03_JPRB,0.31793E-03_JPRB, &
 & 0.27155E-03_JPRB,0.21219E-03_JPRB,0.14366E-03_JPRB,0.51576E-04_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.38556E-03_JPRB,0.41241E-03_JPRB,0.39583E-03_JPRB,0.36622E-03_JPRB,0.32808E-03_JPRB, &
 & 0.28132E-03_JPRB,0.22259E-03_JPRB,0.15133E-03_JPRB,0.55529E-04_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.38464E-03_JPRB,0.41687E-03_JPRB,0.40247E-03_JPRB,0.37394E-03_JPRB,0.33650E-03_JPRB, &
 & 0.28994E-03_JPRB,0.23157E-03_JPRB,0.15870E-03_JPRB,0.59557E-04_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.38119E-03_JPRB,0.41880E-03_JPRB,0.40725E-03_JPRB,0.38009E-03_JPRB,0.34354E-03_JPRB, &
 & 0.29781E-03_JPRB,0.23974E-03_JPRB,0.16572E-03_JPRB,0.63195E-04_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.31518E-03_JPRB,0.33080E-03_JPRB,0.31644E-03_JPRB,0.29051E-03_JPRB,0.25824E-03_JPRB, &
 & 0.21997E-03_JPRB,0.17074E-03_JPRB,0.11585E-03_JPRB,0.39419E-04_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.31945E-03_JPRB,0.33947E-03_JPRB,0.32620E-03_JPRB,0.30064E-03_JPRB,0.26839E-03_JPRB, &
 & 0.22968E-03_JPRB,0.17999E-03_JPRB,0.12241E-03_JPRB,0.42717E-04_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.32042E-03_JPRB,0.34518E-03_JPRB,0.33311E-03_JPRB,0.30844E-03_JPRB,0.27653E-03_JPRB, &
 & 0.23733E-03_JPRB,0.18840E-03_JPRB,0.12892E-03_JPRB,0.45799E-04_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.31877E-03_JPRB,0.34829E-03_JPRB,0.33813E-03_JPRB,0.31466E-03_JPRB,0.28316E-03_JPRB, &
 & 0.24429E-03_JPRB,0.19577E-03_JPRB,0.13500E-03_JPRB,0.49095E-04_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.31533E-03_JPRB,0.34943E-03_JPRB,0.34164E-03_JPRB,0.31953E-03_JPRB,0.28883E-03_JPRB, &
 & 0.25064E-03_JPRB,0.20247E-03_JPRB,0.14079E-03_JPRB,0.52225E-04_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.30073E-02_JPRB,0.30215E-02_JPRB,0.28549E-02_JPRB,0.26145E-02_JPRB,0.23223E-02_JPRB, &
 & 0.19698E-02_JPRB,0.15631E-02_JPRB,0.10671E-02_JPRB,0.34349E-03_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.30045E-02_JPRB,0.30464E-02_JPRB,0.29000E-02_JPRB,0.26682E-02_JPRB,0.23795E-02_JPRB, &
 & 0.20320E-02_JPRB,0.16241E-02_JPRB,0.11180E-02_JPRB,0.37241E-03_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.29924E-02_JPRB,0.30694E-02_JPRB,0.29376E-02_JPRB,0.27170E-02_JPRB,0.24327E-02_JPRB, &
 & 0.20955E-02_JPRB,0.16828E-02_JPRB,0.11692E-02_JPRB,0.41183E-03_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.29732E-02_JPRB,0.30875E-02_JPRB,0.29723E-02_JPRB,0.27617E-02_JPRB,0.24862E-02_JPRB, &
 & 0.21555E-02_JPRB,0.17426E-02_JPRB,0.12186E-02_JPRB,0.45672E-03_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.29511E-02_JPRB,0.31004E-02_JPRB,0.30014E-02_JPRB,0.28043E-02_JPRB,0.25375E-02_JPRB, &
 & 0.22174E-02_JPRB,0.18018E-02_JPRB,0.12656E-02_JPRB,0.49848E-03_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.28011E-02_JPRB,0.28061E-02_JPRB,0.26513E-02_JPRB,0.24171E-02_JPRB,0.21391E-02_JPRB, &
 & 0.18145E-02_JPRB,0.14290E-02_JPRB,0.97808E-03_JPRB,0.28283E-03_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.28038E-02_JPRB,0.28333E-02_JPRB,0.26971E-02_JPRB,0.24708E-02_JPRB,0.21906E-02_JPRB, &
 & 0.18715E-02_JPRB,0.14859E-02_JPRB,0.10236E-02_JPRB,0.31088E-03_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.27978E-02_JPRB,0.28587E-02_JPRB,0.27386E-02_JPRB,0.25159E-02_JPRB,0.22406E-02_JPRB, &
 & 0.19256E-02_JPRB,0.15398E-02_JPRB,0.10695E-02_JPRB,0.34605E-03_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.27864E-02_JPRB,0.28782E-02_JPRB,0.27737E-02_JPRB,0.25561E-02_JPRB,0.22888E-02_JPRB, &
 & 0.19778E-02_JPRB,0.15963E-02_JPRB,0.11144E-02_JPRB,0.38043E-03_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.27682E-02_JPRB,0.28941E-02_JPRB,0.28027E-02_JPRB,0.25952E-02_JPRB,0.23337E-02_JPRB, &
 & 0.20308E-02_JPRB,0.16518E-02_JPRB,0.11583E-02_JPRB,0.41249E-03_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.26013E-02_JPRB,0.25925E-02_JPRB,0.24368E-02_JPRB,0.22059E-02_JPRB,0.19447E-02_JPRB, &
 & 0.16443E-02_JPRB,0.12895E-02_JPRB,0.88356E-03_JPRB,0.22980E-03_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.26118E-02_JPRB,0.26228E-02_JPRB,0.24826E-02_JPRB,0.22596E-02_JPRB,0.19971E-02_JPRB, &
 & 0.16971E-02_JPRB,0.13425E-02_JPRB,0.92292E-03_JPRB,0.25666E-03_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.26121E-02_JPRB,0.26511E-02_JPRB,0.25221E-02_JPRB,0.23045E-02_JPRB,0.20442E-02_JPRB, &
 & 0.17465E-02_JPRB,0.13937E-02_JPRB,0.96423E-03_JPRB,0.28307E-03_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.26050E-02_JPRB,0.26757E-02_JPRB,0.25536E-02_JPRB,0.23446E-02_JPRB,0.20883E-02_JPRB, &
 & 0.17925E-02_JPRB,0.14453E-02_JPRB,0.10074E-02_JPRB,0.30818E-03_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.25933E-02_JPRB,0.26944E-02_JPRB,0.25823E-02_JPRB,0.23794E-02_JPRB,0.21318E-02_JPRB, &
 & 0.18378E-02_JPRB,0.14965E-02_JPRB,0.10492E-02_JPRB,0.33812E-03_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.24078E-02_JPRB,0.23894E-02_JPRB,0.22370E-02_JPRB,0.20125E-02_JPRB,0.17599E-02_JPRB, &
 & 0.14763E-02_JPRB,0.11554E-02_JPRB,0.78494E-03_JPRB,0.18813E-03_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.24225E-02_JPRB,0.24253E-02_JPRB,0.22813E-02_JPRB,0.20638E-02_JPRB,0.18093E-02_JPRB, &
 & 0.15251E-02_JPRB,0.12031E-02_JPRB,0.82373E-03_JPRB,0.21030E-03_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.24294E-02_JPRB,0.24564E-02_JPRB,0.23198E-02_JPRB,0.21085E-02_JPRB,0.18532E-02_JPRB, &
 & 0.15708E-02_JPRB,0.12482E-02_JPRB,0.86229E-03_JPRB,0.23129E-03_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.24309E-02_JPRB,0.24808E-02_JPRB,0.23546E-02_JPRB,0.21467E-02_JPRB,0.18923E-02_JPRB, &
 & 0.16129E-02_JPRB,0.12944E-02_JPRB,0.90119E-03_JPRB,0.25224E-03_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.24223E-02_JPRB,0.24983E-02_JPRB,0.23839E-02_JPRB,0.21783E-02_JPRB,0.19305E-02_JPRB, &
 & 0.16540E-02_JPRB,0.13401E-02_JPRB,0.94049E-03_JPRB,0.27779E-03_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.22071E-02_JPRB,0.21851E-02_JPRB,0.20436E-02_JPRB,0.18357E-02_JPRB,0.15952E-02_JPRB, &
 & 0.13304E-02_JPRB,0.10307E-02_JPRB,0.69163E-03_JPRB,0.14983E-03_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.22284E-02_JPRB,0.22243E-02_JPRB,0.20887E-02_JPRB,0.18839E-02_JPRB,0.16450E-02_JPRB, &
 & 0.13762E-02_JPRB,0.10736E-02_JPRB,0.72602E-03_JPRB,0.16732E-03_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.22426E-02_JPRB,0.22593E-02_JPRB,0.21270E-02_JPRB,0.19281E-02_JPRB,0.16889E-02_JPRB, &
 & 0.14169E-02_JPRB,0.11148E-02_JPRB,0.76201E-03_JPRB,0.18420E-03_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.22476E-02_JPRB,0.22863E-02_JPRB,0.21609E-02_JPRB,0.19676E-02_JPRB,0.17258E-02_JPRB, &
 & 0.14525E-02_JPRB,0.11537E-02_JPRB,0.79815E-03_JPRB,0.20325E-03_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.22399E-02_JPRB,0.23048E-02_JPRB,0.21912E-02_JPRB,0.19974E-02_JPRB,0.17586E-02_JPRB, &
 & 0.14880E-02_JPRB,0.11934E-02_JPRB,0.83564E-03_JPRB,0.22470E-03_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.20075E-02_JPRB,0.19795E-02_JPRB,0.18447E-02_JPRB,0.16541E-02_JPRB,0.14341E-02_JPRB, &
 & 0.11951E-02_JPRB,0.92238E-03_JPRB,0.60660E-03_JPRB,0.12381E-03_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.20344E-02_JPRB,0.20227E-02_JPRB,0.18912E-02_JPRB,0.17028E-02_JPRB,0.14828E-02_JPRB, &
 & 0.12404E-02_JPRB,0.96234E-03_JPRB,0.63833E-03_JPRB,0.13822E-03_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.20513E-02_JPRB,0.20598E-02_JPRB,0.19311E-02_JPRB,0.17466E-02_JPRB,0.15267E-02_JPRB, &
 & 0.12805E-02_JPRB,0.99815E-03_JPRB,0.66987E-03_JPRB,0.15138E-03_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.20576E-02_JPRB,0.20878E-02_JPRB,0.19661E-02_JPRB,0.17857E-02_JPRB,0.15647E-02_JPRB, &
 & 0.13147E-02_JPRB,0.10319E-02_JPRB,0.70266E-03_JPRB,0.16753E-03_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.20521E-02_JPRB,0.21067E-02_JPRB,0.19938E-02_JPRB,0.18157E-02_JPRB,0.15969E-02_JPRB, &
 & 0.13475E-02_JPRB,0.10644E-02_JPRB,0.73524E-03_JPRB,0.18430E-03_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.17951E-02_JPRB,0.17708E-02_JPRB,0.16476E-02_JPRB,0.14764E-02_JPRB,0.12769E-02_JPRB, &
 & 0.10613E-02_JPRB,0.82141E-03_JPRB,0.53387E-03_JPRB,0.10356E-03_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.18257E-02_JPRB,0.18161E-02_JPRB,0.16970E-02_JPRB,0.15264E-02_JPRB,0.13250E-02_JPRB, &
 & 0.11052E-02_JPRB,0.85771E-03_JPRB,0.56341E-03_JPRB,0.11419E-03_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.18457E-02_JPRB,0.18541E-02_JPRB,0.17382E-02_JPRB,0.15700E-02_JPRB,0.13685E-02_JPRB, &
 & 0.11444E-02_JPRB,0.89062E-03_JPRB,0.59265E-03_JPRB,0.12737E-03_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.18534E-02_JPRB,0.18833E-02_JPRB,0.17713E-02_JPRB,0.16066E-02_JPRB,0.14063E-02_JPRB, &
 & 0.11787E-02_JPRB,0.92220E-03_JPRB,0.62067E-03_JPRB,0.14148E-03_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.18508E-02_JPRB,0.19025E-02_JPRB,0.17986E-02_JPRB,0.16377E-02_JPRB,0.14382E-02_JPRB, &
 & 0.12095E-02_JPRB,0.95313E-03_JPRB,0.64883E-03_JPRB,0.15624E-03_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.15853E-02_JPRB,0.15606E-02_JPRB,0.14491E-02_JPRB,0.13005E-02_JPRB,0.11253E-02_JPRB, &
 & 0.93388E-03_JPRB,0.72631E-03_JPRB,0.46832E-03_JPRB,0.90402E-04_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.16191E-02_JPRB,0.16074E-02_JPRB,0.14980E-02_JPRB,0.13497E-02_JPRB,0.11730E-02_JPRB, &
 & 0.97691E-03_JPRB,0.76027E-03_JPRB,0.49835E-03_JPRB,0.10124E-03_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.16393E-02_JPRB,0.16464E-02_JPRB,0.15392E-02_JPRB,0.13927E-02_JPRB,0.12147E-02_JPRB, &
 & 0.10153E-02_JPRB,0.79129E-03_JPRB,0.52537E-03_JPRB,0.11276E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART5',0,ZHOOK_HANDLE)


KA(:, 4, 8, 6) = (/ &
 & 0.16487E-02_JPRB,0.16729E-02_JPRB,0.15721E-02_JPRB,0.14286E-02_JPRB,0.12504E-02_JPRB, &
 & 0.10480E-02_JPRB,0.82072E-03_JPRB,0.55187E-03_JPRB,0.12515E-03_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.16472E-02_JPRB,0.16924E-02_JPRB,0.15977E-02_JPRB,0.14588E-02_JPRB,0.12817E-02_JPRB, &
 & 0.10777E-02_JPRB,0.84873E-03_JPRB,0.57800E-03_JPRB,0.13784E-03_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.13936E-02_JPRB,0.13674E-02_JPRB,0.12635E-02_JPRB,0.11331E-02_JPRB,0.97871E-03_JPRB, &
 & 0.81331E-03_JPRB,0.63480E-03_JPRB,0.40910E-03_JPRB,0.92222E-04_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.14271E-02_JPRB,0.14126E-02_JPRB,0.13114E-02_JPRB,0.11804E-02_JPRB,0.10248E-02_JPRB, &
 & 0.85405E-03_JPRB,0.66828E-03_JPRB,0.43677E-03_JPRB,0.10207E-03_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.14461E-02_JPRB,0.14478E-02_JPRB,0.13500E-02_JPRB,0.12219E-02_JPRB,0.10647E-02_JPRB, &
 & 0.89058E-03_JPRB,0.69816E-03_JPRB,0.46305E-03_JPRB,0.11262E-03_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.14547E-02_JPRB,0.14726E-02_JPRB,0.13807E-02_JPRB,0.12557E-02_JPRB,0.10996E-02_JPRB, &
 & 0.92247E-03_JPRB,0.72520E-03_JPRB,0.48654E-03_JPRB,0.12376E-03_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.14563E-02_JPRB,0.14902E-02_JPRB,0.14046E-02_JPRB,0.12841E-02_JPRB,0.11288E-02_JPRB, &
 & 0.95105E-03_JPRB,0.75065E-03_JPRB,0.51065E-03_JPRB,0.13556E-03_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.12161E-02_JPRB,0.11928E-02_JPRB,0.11004E-02_JPRB,0.98725E-03_JPRB,0.85318E-03_JPRB, &
 & 0.70775E-03_JPRB,0.55081E-03_JPRB,0.35481E-03_JPRB,0.12422E-03_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.12463E-02_JPRB,0.12352E-02_JPRB,0.11444E-02_JPRB,0.10316E-02_JPRB,0.89480E-03_JPRB, &
 & 0.74560E-03_JPRB,0.58282E-03_JPRB,0.38195E-03_JPRB,0.13273E-03_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.12646E-02_JPRB,0.12662E-02_JPRB,0.11796E-02_JPRB,0.10687E-02_JPRB,0.93096E-03_JPRB, &
 & 0.77883E-03_JPRB,0.61138E-03_JPRB,0.40526E-03_JPRB,0.14193E-03_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.12733E-02_JPRB,0.12880E-02_JPRB,0.12074E-02_JPRB,0.10979E-02_JPRB,0.96169E-03_JPRB, &
 & 0.80809E-03_JPRB,0.63689E-03_JPRB,0.42724E-03_JPRB,0.15291E-03_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.12740E-02_JPRB,0.13044E-02_JPRB,0.12293E-02_JPRB,0.11231E-02_JPRB,0.98752E-03_JPRB, &
 & 0.83380E-03_JPRB,0.66030E-03_JPRB,0.44847E-03_JPRB,0.16460E-03_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.10656E-02_JPRB,0.10497E-02_JPRB,0.96881E-03_JPRB,0.87108E-03_JPRB,0.75627E-03_JPRB, &
 & 0.62893E-03_JPRB,0.48955E-03_JPRB,0.31741E-03_JPRB,0.13016E-03_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.10879E-02_JPRB,0.10821E-02_JPRB,0.10046E-02_JPRB,0.90804E-03_JPRB,0.79130E-03_JPRB, &
 & 0.66235E-03_JPRB,0.51807E-03_JPRB,0.34003E-03_JPRB,0.13779E-03_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.11001E-02_JPRB,0.11057E-02_JPRB,0.10327E-02_JPRB,0.93770E-03_JPRB,0.82120E-03_JPRB, &
 & 0.69087E-03_JPRB,0.54346E-03_JPRB,0.36047E-03_JPRB,0.14411E-03_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.11047E-02_JPRB,0.11226E-02_JPRB,0.10548E-02_JPRB,0.96212E-03_JPRB,0.84667E-03_JPRB, &
 & 0.71575E-03_JPRB,0.56548E-03_JPRB,0.37954E-03_JPRB,0.15311E-03_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.11028E-02_JPRB,0.11345E-02_JPRB,0.10715E-02_JPRB,0.98143E-03_JPRB,0.86845E-03_JPRB, &
 & 0.73791E-03_JPRB,0.58600E-03_JPRB,0.39874E-03_JPRB,0.16257E-03_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.92541E-03_JPRB,0.91485E-03_JPRB,0.84575E-03_JPRB,0.76287E-03_JPRB,0.66530E-03_JPRB, &
 & 0.55435E-03_JPRB,0.43055E-03_JPRB,0.28106E-03_JPRB,0.11779E-03_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.94153E-03_JPRB,0.94015E-03_JPRB,0.87425E-03_JPRB,0.79221E-03_JPRB,0.69422E-03_JPRB, &
 & 0.58249E-03_JPRB,0.45555E-03_JPRB,0.30043E-03_JPRB,0.12541E-03_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.95043E-03_JPRB,0.95859E-03_JPRB,0.89645E-03_JPRB,0.81618E-03_JPRB,0.71892E-03_JPRB, &
 & 0.60660E-03_JPRB,0.47691E-03_JPRB,0.31810E-03_JPRB,0.13086E-03_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.95300E-03_JPRB,0.97180E-03_JPRB,0.91414E-03_JPRB,0.83540E-03_JPRB,0.73965E-03_JPRB, &
 & 0.62755E-03_JPRB,0.49627E-03_JPRB,0.33494E-03_JPRB,0.13792E-03_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.94924E-03_JPRB,0.98033E-03_JPRB,0.92629E-03_JPRB,0.85073E-03_JPRB,0.75722E-03_JPRB, &
 & 0.64562E-03_JPRB,0.51410E-03_JPRB,0.35114E-03_JPRB,0.14650E-03_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.79344E-03_JPRB,0.78971E-03_JPRB,0.73267E-03_JPRB,0.66405E-03_JPRB,0.58083E-03_JPRB, &
 & 0.48392E-03_JPRB,0.37549E-03_JPRB,0.24569E-03_JPRB,0.97034E-04_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.80574E-03_JPRB,0.81004E-03_JPRB,0.75547E-03_JPRB,0.68809E-03_JPRB,0.60484E-03_JPRB, &
 & 0.50707E-03_JPRB,0.39618E-03_JPRB,0.26227E-03_JPRB,0.10267E-03_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.81227E-03_JPRB,0.82486E-03_JPRB,0.77408E-03_JPRB,0.70758E-03_JPRB,0.62511E-03_JPRB, &
 & 0.52731E-03_JPRB,0.41439E-03_JPRB,0.27759E-03_JPRB,0.10742E-03_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.81298E-03_JPRB,0.83538E-03_JPRB,0.78743E-03_JPRB,0.72262E-03_JPRB,0.64193E-03_JPRB, &
 & 0.54449E-03_JPRB,0.43080E-03_JPRB,0.29211E-03_JPRB,0.11325E-03_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.80893E-03_JPRB,0.84184E-03_JPRB,0.79706E-03_JPRB,0.73516E-03_JPRB,0.65638E-03_JPRB, &
 & 0.55984E-03_JPRB,0.44607E-03_JPRB,0.30621E-03_JPRB,0.12059E-03_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.54732E-02_JPRB,0.53034E-02_JPRB,0.49969E-02_JPRB,0.45431E-02_JPRB,0.40134E-02_JPRB, &
 & 0.34010E-02_JPRB,0.26972E-02_JPRB,0.18637E-02_JPRB,0.96692E-03_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.54607E-02_JPRB,0.53367E-02_JPRB,0.50546E-02_JPRB,0.46321E-02_JPRB,0.41099E-02_JPRB, &
 & 0.34970E-02_JPRB,0.27999E-02_JPRB,0.19729E-02_JPRB,0.11063E-02_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.54405E-02_JPRB,0.53637E-02_JPRB,0.51145E-02_JPRB,0.47117E-02_JPRB,0.41981E-02_JPRB, &
 & 0.35927E-02_JPRB,0.29070E-02_JPRB,0.20850E-02_JPRB,0.12360E-02_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.54052E-02_JPRB,0.53858E-02_JPRB,0.51679E-02_JPRB,0.47829E-02_JPRB,0.42844E-02_JPRB, &
 & 0.36942E-02_JPRB,0.30161E-02_JPRB,0.22030E-02_JPRB,0.13785E-02_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.53549E-02_JPRB,0.54029E-02_JPRB,0.52131E-02_JPRB,0.48529E-02_JPRB,0.43733E-02_JPRB, &
 & 0.37946E-02_JPRB,0.31262E-02_JPRB,0.23268E-02_JPRB,0.15336E-02_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.52482E-02_JPRB,0.50940E-02_JPRB,0.47786E-02_JPRB,0.43454E-02_JPRB,0.38186E-02_JPRB, &
 & 0.32129E-02_JPRB,0.25325E-02_JPRB,0.17227E-02_JPRB,0.80430E-03_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.52403E-02_JPRB,0.51313E-02_JPRB,0.48370E-02_JPRB,0.44315E-02_JPRB,0.39109E-02_JPRB, &
 & 0.33052E-02_JPRB,0.26254E-02_JPRB,0.18226E-02_JPRB,0.90614E-03_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.52188E-02_JPRB,0.51614E-02_JPRB,0.48948E-02_JPRB,0.45073E-02_JPRB,0.39963E-02_JPRB, &
 & 0.33961E-02_JPRB,0.27198E-02_JPRB,0.19222E-02_JPRB,0.10146E-02_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.51826E-02_JPRB,0.51837E-02_JPRB,0.49460E-02_JPRB,0.45770E-02_JPRB,0.40791E-02_JPRB, &
 & 0.34891E-02_JPRB,0.28146E-02_JPRB,0.20278E-02_JPRB,0.11325E-02_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.51359E-02_JPRB,0.51960E-02_JPRB,0.49902E-02_JPRB,0.46430E-02_JPRB,0.41602E-02_JPRB, &
 & 0.35811E-02_JPRB,0.29127E-02_JPRB,0.21431E-02_JPRB,0.12633E-02_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.49876E-02_JPRB,0.48388E-02_JPRB,0.45133E-02_JPRB,0.40992E-02_JPRB,0.35901E-02_JPRB, &
 & 0.30030E-02_JPRB,0.23527E-02_JPRB,0.15765E-02_JPRB,0.64714E-03_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.49850E-02_JPRB,0.48808E-02_JPRB,0.45736E-02_JPRB,0.41821E-02_JPRB,0.36790E-02_JPRB, &
 & 0.30941E-02_JPRB,0.24388E-02_JPRB,0.16655E-02_JPRB,0.72927E-03_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.49660E-02_JPRB,0.49117E-02_JPRB,0.46346E-02_JPRB,0.42593E-02_JPRB,0.37631E-02_JPRB, &
 & 0.31820E-02_JPRB,0.25243E-02_JPRB,0.17543E-02_JPRB,0.81771E-03_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.49361E-02_JPRB,0.49307E-02_JPRB,0.46909E-02_JPRB,0.43285E-02_JPRB,0.38459E-02_JPRB, &
 & 0.32679E-02_JPRB,0.26083E-02_JPRB,0.18450E-02_JPRB,0.91578E-03_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.48943E-02_JPRB,0.49413E-02_JPRB,0.47366E-02_JPRB,0.43959E-02_JPRB,0.39239E-02_JPRB, &
 & 0.33496E-02_JPRB,0.26941E-02_JPRB,0.19416E-02_JPRB,0.10197E-02_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.46848E-02_JPRB,0.45423E-02_JPRB,0.42109E-02_JPRB,0.38147E-02_JPRB,0.33318E-02_JPRB, &
 & 0.27806E-02_JPRB,0.21628E-02_JPRB,0.14435E-02_JPRB,0.52019E-03_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.46885E-02_JPRB,0.45846E-02_JPRB,0.42767E-02_JPRB,0.38967E-02_JPRB,0.34228E-02_JPRB, &
 & 0.28698E-02_JPRB,0.22469E-02_JPRB,0.15180E-02_JPRB,0.58537E-03_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.46784E-02_JPRB,0.46158E-02_JPRB,0.43389E-02_JPRB,0.39718E-02_JPRB,0.35088E-02_JPRB, &
 & 0.29561E-02_JPRB,0.23285E-02_JPRB,0.15932E-02_JPRB,0.65783E-03_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.46546E-02_JPRB,0.46379E-02_JPRB,0.43907E-02_JPRB,0.40421E-02_JPRB,0.35928E-02_JPRB, &
 & 0.30394E-02_JPRB,0.24053E-02_JPRB,0.16703E-02_JPRB,0.73788E-03_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.46218E-02_JPRB,0.46560E-02_JPRB,0.44359E-02_JPRB,0.41109E-02_JPRB,0.36691E-02_JPRB, &
 & 0.31156E-02_JPRB,0.24821E-02_JPRB,0.17515E-02_JPRB,0.82261E-03_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.43680E-02_JPRB,0.42271E-02_JPRB,0.38928E-02_JPRB,0.35080E-02_JPRB,0.30576E-02_JPRB, &
 & 0.25405E-02_JPRB,0.19725E-02_JPRB,0.13117E-02_JPRB,0.42455E-03_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.43836E-02_JPRB,0.42742E-02_JPRB,0.39603E-02_JPRB,0.35901E-02_JPRB,0.31440E-02_JPRB, &
 & 0.26294E-02_JPRB,0.20540E-02_JPRB,0.13812E-02_JPRB,0.47676E-03_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.43831E-02_JPRB,0.43074E-02_JPRB,0.40201E-02_JPRB,0.36636E-02_JPRB,0.32261E-02_JPRB, &
 & 0.27164E-02_JPRB,0.21330E-02_JPRB,0.14464E-02_JPRB,0.53568E-03_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.43690E-02_JPRB,0.43343E-02_JPRB,0.40742E-02_JPRB,0.37289E-02_JPRB,0.33089E-02_JPRB, &
 & 0.28017E-02_JPRB,0.22054E-02_JPRB,0.15130E-02_JPRB,0.59880E-03_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.43473E-02_JPRB,0.43575E-02_JPRB,0.41195E-02_JPRB,0.37951E-02_JPRB,0.33885E-02_JPRB, &
 & 0.28774E-02_JPRB,0.22767E-02_JPRB,0.15816E-02_JPRB,0.66710E-03_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.40714E-02_JPRB,0.39122E-02_JPRB,0.35777E-02_JPRB,0.32091E-02_JPRB,0.27872E-02_JPRB, &
 & 0.22994E-02_JPRB,0.17735E-02_JPRB,0.11790E-02_JPRB,0.33561E-03_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.40973E-02_JPRB,0.39625E-02_JPRB,0.36472E-02_JPRB,0.32877E-02_JPRB,0.28694E-02_JPRB, &
 & 0.23826E-02_JPRB,0.18515E-02_JPRB,0.12426E-02_JPRB,0.37756E-03_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.41108E-02_JPRB,0.40033E-02_JPRB,0.37116E-02_JPRB,0.33595E-02_JPRB,0.29464E-02_JPRB, &
 & 0.24646E-02_JPRB,0.19290E-02_JPRB,0.13037E-02_JPRB,0.42584E-03_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.41078E-02_JPRB,0.40382E-02_JPRB,0.37677E-02_JPRB,0.34232E-02_JPRB,0.30216E-02_JPRB, &
 & 0.25463E-02_JPRB,0.20016E-02_JPRB,0.13624E-02_JPRB,0.47733E-03_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.40964E-02_JPRB,0.40666E-02_JPRB,0.38151E-02_JPRB,0.34890E-02_JPRB,0.30973E-02_JPRB, &
 & 0.26200E-02_JPRB,0.20705E-02_JPRB,0.14239E-02_JPRB,0.53330E-03_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.37806E-02_JPRB,0.36256E-02_JPRB,0.32982E-02_JPRB,0.29389E-02_JPRB,0.25345E-02_JPRB, &
 & 0.20760E-02_JPRB,0.15879E-02_JPRB,0.10489E-02_JPRB,0.28018E-03_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.38204E-02_JPRB,0.36872E-02_JPRB,0.33713E-02_JPRB,0.30154E-02_JPRB,0.26103E-02_JPRB, &
 & 0.21557E-02_JPRB,0.16619E-02_JPRB,0.11071E-02_JPRB,0.31519E-03_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.38460E-02_JPRB,0.37374E-02_JPRB,0.34369E-02_JPRB,0.30817E-02_JPRB,0.26834E-02_JPRB, &
 & 0.22319E-02_JPRB,0.17344E-02_JPRB,0.11636E-02_JPRB,0.35270E-03_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.38578E-02_JPRB,0.37771E-02_JPRB,0.34946E-02_JPRB,0.31444E-02_JPRB,0.27541E-02_JPRB, &
 & 0.23067E-02_JPRB,0.18034E-02_JPRB,0.12192E-02_JPRB,0.39298E-03_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.38608E-02_JPRB,0.38134E-02_JPRB,0.35421E-02_JPRB,0.32035E-02_JPRB,0.28239E-02_JPRB, &
 & 0.23777E-02_JPRB,0.18670E-02_JPRB,0.12748E-02_JPRB,0.43632E-03_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.34769E-02_JPRB,0.33291E-02_JPRB,0.30196E-02_JPRB,0.26781E-02_JPRB,0.23024E-02_JPRB, &
 & 0.18824E-02_JPRB,0.14244E-02_JPRB,0.92897E-03_JPRB,0.24101E-03_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.35239E-02_JPRB,0.33972E-02_JPRB,0.30964E-02_JPRB,0.27587E-02_JPRB,0.23816E-02_JPRB, &
 & 0.19578E-02_JPRB,0.14914E-02_JPRB,0.98181E-03_JPRB,0.27130E-03_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.35607E-02_JPRB,0.34526E-02_JPRB,0.31656E-02_JPRB,0.28309E-02_JPRB,0.24544E-02_JPRB, &
 & 0.20284E-02_JPRB,0.15562E-02_JPRB,0.10333E-02_JPRB,0.30255E-03_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.35844E-02_JPRB,0.35023E-02_JPRB,0.32271E-02_JPRB,0.28968E-02_JPRB,0.25226E-02_JPRB, &
 & 0.20957E-02_JPRB,0.16188E-02_JPRB,0.10830E-02_JPRB,0.33737E-03_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.35961E-02_JPRB,0.35446E-02_JPRB,0.32825E-02_JPRB,0.29568E-02_JPRB,0.25866E-02_JPRB, &
 & 0.21594E-02_JPRB,0.16782E-02_JPRB,0.11324E-02_JPRB,0.37448E-03_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.31490E-02_JPRB,0.30162E-02_JPRB,0.27350E-02_JPRB,0.24183E-02_JPRB,0.20753E-02_JPRB, &
 & 0.16954E-02_JPRB,0.12750E-02_JPRB,0.82561E-03_JPRB,0.24776E-03_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.32098E-02_JPRB,0.30913E-02_JPRB,0.28147E-02_JPRB,0.25006E-02_JPRB,0.21544E-02_JPRB, &
 & 0.17699E-02_JPRB,0.13387E-02_JPRB,0.87243E-03_JPRB,0.27735E-03_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.32582E-02_JPRB,0.31563E-02_JPRB,0.28883E-02_JPRB,0.25742E-02_JPRB,0.22278E-02_JPRB, &
 & 0.18394E-02_JPRB,0.14003E-02_JPRB,0.91830E-03_JPRB,0.30712E-03_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.32928E-02_JPRB,0.32146E-02_JPRB,0.29543E-02_JPRB,0.26421E-02_JPRB,0.22954E-02_JPRB, &
 & 0.19038E-02_JPRB,0.14592E-02_JPRB,0.96296E-03_JPRB,0.33982E-03_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.33113E-02_JPRB,0.32637E-02_JPRB,0.30129E-02_JPRB,0.27034E-02_JPRB,0.23582E-02_JPRB, &
 & 0.19652E-02_JPRB,0.15140E-02_JPRB,0.10071E-02_JPRB,0.37422E-03_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.28236E-02_JPRB,0.26993E-02_JPRB,0.24463E-02_JPRB,0.21584E-02_JPRB,0.18515E-02_JPRB, &
 & 0.15144E-02_JPRB,0.11396E-02_JPRB,0.73456E-03_JPRB,0.30599E-03_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.28929E-02_JPRB,0.27796E-02_JPRB,0.25302E-02_JPRB,0.22416E-02_JPRB,0.19311E-02_JPRB, &
 & 0.15864E-02_JPRB,0.12002E-02_JPRB,0.77955E-03_JPRB,0.32947E-03_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.29497E-02_JPRB,0.28523E-02_JPRB,0.26078E-02_JPRB,0.23174E-02_JPRB,0.20043E-02_JPRB, &
 & 0.16542E-02_JPRB,0.12577E-02_JPRB,0.82291E-03_JPRB,0.35529E-03_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.29901E-02_JPRB,0.29165E-02_JPRB,0.26763E-02_JPRB,0.23877E-02_JPRB,0.20731E-02_JPRB, &
 & 0.17177E-02_JPRB,0.13124E-02_JPRB,0.86431E-03_JPRB,0.38167E-03_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.30139E-02_JPRB,0.29672E-02_JPRB,0.27348E-02_JPRB,0.24509E-02_JPRB,0.21349E-02_JPRB, &
 & 0.17760E-02_JPRB,0.13646E-02_JPRB,0.90496E-03_JPRB,0.40993E-03_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.25422E-02_JPRB,0.24347E-02_JPRB,0.22108E-02_JPRB,0.19505E-02_JPRB,0.16727E-02_JPRB, &
 & 0.13714E-02_JPRB,0.10368E-02_JPRB,0.66936E-03_JPRB,0.31350E-03_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.26126E-02_JPRB,0.25184E-02_JPRB,0.22944E-02_JPRB,0.20307E-02_JPRB,0.17483E-02_JPRB, &
 & 0.14377E-02_JPRB,0.10928E-02_JPRB,0.71181E-03_JPRB,0.33782E-03_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.26690E-02_JPRB,0.25901E-02_JPRB,0.23690E-02_JPRB,0.21043E-02_JPRB,0.18188E-02_JPRB, &
 & 0.15016E-02_JPRB,0.11462E-02_JPRB,0.75188E-03_JPRB,0.35774E-03_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.27048E-02_JPRB,0.26504E-02_JPRB,0.24329E-02_JPRB,0.21704E-02_JPRB,0.18832E-02_JPRB, &
 & 0.15599E-02_JPRB,0.11973E-02_JPRB,0.79054E-03_JPRB,0.37720E-03_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.27241E-02_JPRB,0.26964E-02_JPRB,0.24876E-02_JPRB,0.22289E-02_JPRB,0.19396E-02_JPRB, &
 & 0.16131E-02_JPRB,0.12459E-02_JPRB,0.82843E-03_JPRB,0.39980E-03_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.22863E-02_JPRB,0.21916E-02_JPRB,0.19903E-02_JPRB,0.17560E-02_JPRB,0.15053E-02_JPRB, &
 & 0.12361E-02_JPRB,0.93929E-03_JPRB,0.60469E-03_JPRB,0.28176E-03_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.23519E-02_JPRB,0.22705E-02_JPRB,0.20691E-02_JPRB,0.18315E-02_JPRB,0.15760E-02_JPRB, &
 & 0.12985E-02_JPRB,0.99139E-03_JPRB,0.64462E-03_JPRB,0.30471E-03_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.23974E-02_JPRB,0.23352E-02_JPRB,0.21377E-02_JPRB,0.19000E-02_JPRB,0.16408E-02_JPRB, &
 & 0.13574E-02_JPRB,0.10412E-02_JPRB,0.68214E-03_JPRB,0.32553E-03_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.24260E-02_JPRB,0.23879E-02_JPRB,0.21943E-02_JPRB,0.19602E-02_JPRB,0.16992E-02_JPRB, &
 & 0.14109E-02_JPRB,0.10885E-02_JPRB,0.71852E-03_JPRB,0.34169E-03_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.24412E-02_JPRB,0.24274E-02_JPRB,0.22422E-02_JPRB,0.20116E-02_JPRB,0.17502E-02_JPRB, &
 & 0.14591E-02_JPRB,0.11336E-02_JPRB,0.75474E-03_JPRB,0.36020E-03_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.20393E-02_JPRB,0.19603E-02_JPRB,0.17821E-02_JPRB,0.15739E-02_JPRB,0.13509E-02_JPRB, &
 & 0.11133E-02_JPRB,0.84826E-03_JPRB,0.54289E-03_JPRB,0.23248E-03_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.20953E-02_JPRB,0.20307E-02_JPRB,0.18542E-02_JPRB,0.16433E-02_JPRB,0.14162E-02_JPRB, &
 & 0.11712E-02_JPRB,0.89683E-03_JPRB,0.57958E-03_JPRB,0.25095E-03_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.21323E-02_JPRB,0.20881E-02_JPRB,0.19144E-02_JPRB,0.17046E-02_JPRB,0.14742E-02_JPRB, &
 & 0.12241E-02_JPRB,0.94271E-03_JPRB,0.61480E-03_JPRB,0.26566E-03_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.21562E-02_JPRB,0.21324E-02_JPRB,0.19654E-02_JPRB,0.17578E-02_JPRB,0.15256E-02_JPRB, &
 & 0.12715E-02_JPRB,0.98599E-03_JPRB,0.64941E-03_JPRB,0.28144E-03_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.21687E-02_JPRB,0.21674E-02_JPRB,0.20081E-02_JPRB,0.18029E-02_JPRB,0.15712E-02_JPRB, &
 & 0.13148E-02_JPRB,0.10270E-02_JPRB,0.68370E-03_JPRB,0.29755E-03_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.10084E-01_JPRB,0.95278E-02_JPRB,0.88730E-02_JPRB,0.81189E-02_JPRB,0.71873E-02_JPRB, &
 & 0.61505E-02_JPRB,0.50159E-02_JPRB,0.37383E-02_JPRB,0.30410E-02_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.10011E-01_JPRB,0.95195E-02_JPRB,0.89419E-02_JPRB,0.82272E-02_JPRB,0.73508E-02_JPRB, &
 & 0.63699E-02_JPRB,0.52392E-02_JPRB,0.39784E-02_JPRB,0.34237E-02_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.99285E-02_JPRB,0.95060E-02_JPRB,0.90107E-02_JPRB,0.83435E-02_JPRB,0.75299E-02_JPRB, &
 & 0.65814E-02_JPRB,0.54661E-02_JPRB,0.42490E-02_JPRB,0.38569E-02_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.98396E-02_JPRB,0.95039E-02_JPRB,0.90786E-02_JPRB,0.84657E-02_JPRB,0.77142E-02_JPRB, &
 & 0.67908E-02_JPRB,0.57132E-02_JPRB,0.45510E-02_JPRB,0.43277E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART6',0,ZHOOK_HANDLE)


KA(:, 5, 1, 8) = (/ &
 & 0.97470E-02_JPRB,0.95073E-02_JPRB,0.91451E-02_JPRB,0.85961E-02_JPRB,0.78983E-02_JPRB, &
 & 0.70134E-02_JPRB,0.59878E-02_JPRB,0.48898E-02_JPRB,0.48367E-02_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.10032E-01_JPRB,0.95001E-02_JPRB,0.88015E-02_JPRB,0.80012E-02_JPRB,0.70675E-02_JPRB, &
 & 0.59994E-02_JPRB,0.48088E-02_JPRB,0.34803E-02_JPRB,0.24973E-02_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.99727E-02_JPRB,0.94952E-02_JPRB,0.88708E-02_JPRB,0.81052E-02_JPRB,0.72227E-02_JPRB, &
 & 0.61975E-02_JPRB,0.50149E-02_JPRB,0.36876E-02_JPRB,0.28262E-02_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.99020E-02_JPRB,0.94876E-02_JPRB,0.89395E-02_JPRB,0.82200E-02_JPRB,0.73884E-02_JPRB, &
 & 0.63917E-02_JPRB,0.52241E-02_JPRB,0.39189E-02_JPRB,0.31881E-02_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.98208E-02_JPRB,0.94907E-02_JPRB,0.90072E-02_JPRB,0.83409E-02_JPRB,0.75534E-02_JPRB, &
 & 0.65848E-02_JPRB,0.54476E-02_JPRB,0.41701E-02_JPRB,0.35802E-02_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.97350E-02_JPRB,0.95036E-02_JPRB,0.90758E-02_JPRB,0.84664E-02_JPRB,0.77179E-02_JPRB, &
 & 0.67885E-02_JPRB,0.56906E-02_JPRB,0.44399E-02_JPRB,0.40032E-02_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.99249E-02_JPRB,0.94002E-02_JPRB,0.86731E-02_JPRB,0.78226E-02_JPRB,0.68627E-02_JPRB, &
 & 0.57870E-02_JPRB,0.45641E-02_JPRB,0.32036E-02_JPRB,0.20068E-02_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.98781E-02_JPRB,0.94039E-02_JPRB,0.87415E-02_JPRB,0.79225E-02_JPRB,0.70078E-02_JPRB, &
 & 0.59682E-02_JPRB,0.47504E-02_JPRB,0.33906E-02_JPRB,0.22741E-02_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.98245E-02_JPRB,0.94056E-02_JPRB,0.88077E-02_JPRB,0.80290E-02_JPRB,0.71634E-02_JPRB, &
 & 0.61455E-02_JPRB,0.49439E-02_JPRB,0.35923E-02_JPRB,0.25675E-02_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.97585E-02_JPRB,0.94181E-02_JPRB,0.88723E-02_JPRB,0.81452E-02_JPRB,0.73134E-02_JPRB, &
 & 0.63196E-02_JPRB,0.51498E-02_JPRB,0.38082E-02_JPRB,0.28828E-02_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.96800E-02_JPRB,0.94346E-02_JPRB,0.89400E-02_JPRB,0.82650E-02_JPRB,0.74596E-02_JPRB, &
 & 0.65093E-02_JPRB,0.53613E-02_JPRB,0.40378E-02_JPRB,0.32210E-02_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.97390E-02_JPRB,0.92223E-02_JPRB,0.84805E-02_JPRB,0.75962E-02_JPRB,0.66183E-02_JPRB, &
 & 0.55421E-02_JPRB,0.43153E-02_JPRB,0.29439E-02_JPRB,0.16096E-02_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.97149E-02_JPRB,0.92440E-02_JPRB,0.85515E-02_JPRB,0.76965E-02_JPRB,0.67525E-02_JPRB, &
 & 0.57037E-02_JPRB,0.44852E-02_JPRB,0.31152E-02_JPRB,0.18298E-02_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.96772E-02_JPRB,0.92607E-02_JPRB,0.86210E-02_JPRB,0.78004E-02_JPRB,0.68947E-02_JPRB, &
 & 0.58626E-02_JPRB,0.46601E-02_JPRB,0.32973E-02_JPRB,0.20675E-02_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.96222E-02_JPRB,0.92823E-02_JPRB,0.86884E-02_JPRB,0.79077E-02_JPRB,0.70317E-02_JPRB, &
 & 0.60213E-02_JPRB,0.48471E-02_JPRB,0.34874E-02_JPRB,0.23199E-02_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.95548E-02_JPRB,0.93032E-02_JPRB,0.87544E-02_JPRB,0.80177E-02_JPRB,0.71673E-02_JPRB, &
 & 0.61924E-02_JPRB,0.50398E-02_JPRB,0.36845E-02_JPRB,0.25914E-02_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.94682E-02_JPRB,0.89654E-02_JPRB,0.82210E-02_JPRB,0.73222E-02_JPRB,0.63403E-02_JPRB, &
 & 0.52735E-02_JPRB,0.40692E-02_JPRB,0.27114E-02_JPRB,0.12929E-02_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.94609E-02_JPRB,0.90053E-02_JPRB,0.83016E-02_JPRB,0.74278E-02_JPRB,0.64685E-02_JPRB, &
 & 0.54213E-02_JPRB,0.42231E-02_JPRB,0.28638E-02_JPRB,0.14728E-02_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.94353E-02_JPRB,0.90391E-02_JPRB,0.83802E-02_JPRB,0.75305E-02_JPRB,0.66027E-02_JPRB, &
 & 0.55646E-02_JPRB,0.43790E-02_JPRB,0.30279E-02_JPRB,0.16663E-02_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.93989E-02_JPRB,0.90684E-02_JPRB,0.84481E-02_JPRB,0.76404E-02_JPRB,0.67294E-02_JPRB, &
 & 0.57082E-02_JPRB,0.45495E-02_JPRB,0.31980E-02_JPRB,0.18711E-02_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.93472E-02_JPRB,0.90926E-02_JPRB,0.85136E-02_JPRB,0.77442E-02_JPRB,0.68542E-02_JPRB, &
 & 0.58646E-02_JPRB,0.47259E-02_JPRB,0.33701E-02_JPRB,0.20921E-02_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.90687E-02_JPRB,0.86083E-02_JPRB,0.78842E-02_JPRB,0.69920E-02_JPRB,0.60171E-02_JPRB, &
 & 0.49784E-02_JPRB,0.38163E-02_JPRB,0.24892E-02_JPRB,0.10375E-02_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.90845E-02_JPRB,0.86742E-02_JPRB,0.79759E-02_JPRB,0.71037E-02_JPRB,0.61494E-02_JPRB, &
 & 0.51176E-02_JPRB,0.39577E-02_JPRB,0.26285E-02_JPRB,0.11848E-02_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.90836E-02_JPRB,0.87225E-02_JPRB,0.80580E-02_JPRB,0.72119E-02_JPRB,0.62799E-02_JPRB, &
 & 0.52546E-02_JPRB,0.41006E-02_JPRB,0.27750E-02_JPRB,0.13422E-02_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.90655E-02_JPRB,0.87611E-02_JPRB,0.81305E-02_JPRB,0.73221E-02_JPRB,0.64054E-02_JPRB, &
 & 0.53892E-02_JPRB,0.42503E-02_JPRB,0.29301E-02_JPRB,0.15078E-02_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.90286E-02_JPRB,0.87944E-02_JPRB,0.82022E-02_JPRB,0.74247E-02_JPRB,0.65248E-02_JPRB, &
 & 0.55305E-02_JPRB,0.44113E-02_JPRB,0.30838E-02_JPRB,0.16859E-02_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.85850E-02_JPRB,0.81350E-02_JPRB,0.74326E-02_JPRB,0.65794E-02_JPRB,0.56482E-02_JPRB, &
 & 0.46582E-02_JPRB,0.35544E-02_JPRB,0.22844E-02_JPRB,0.80765E-03_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.86250E-02_JPRB,0.82179E-02_JPRB,0.75359E-02_JPRB,0.67022E-02_JPRB,0.57899E-02_JPRB, &
 & 0.47962E-02_JPRB,0.36869E-02_JPRB,0.24122E-02_JPRB,0.92682E-03_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.86440E-02_JPRB,0.82839E-02_JPRB,0.76315E-02_JPRB,0.68246E-02_JPRB,0.59218E-02_JPRB, &
 & 0.49298E-02_JPRB,0.38219E-02_JPRB,0.25431E-02_JPRB,0.10538E-02_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.86410E-02_JPRB,0.83371E-02_JPRB,0.77195E-02_JPRB,0.69421E-02_JPRB,0.60483E-02_JPRB, &
 & 0.50620E-02_JPRB,0.39587E-02_JPRB,0.26818E-02_JPRB,0.11890E-02_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.86213E-02_JPRB,0.83816E-02_JPRB,0.78035E-02_JPRB,0.70537E-02_JPRB,0.61695E-02_JPRB, &
 & 0.51947E-02_JPRB,0.41038E-02_JPRB,0.28206E-02_JPRB,0.13358E-02_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.80690E-02_JPRB,0.76260E-02_JPRB,0.69398E-02_JPRB,0.61270E-02_JPRB,0.52372E-02_JPRB, &
 & 0.42965E-02_JPRB,0.32695E-02_JPRB,0.20922E-02_JPRB,0.69791E-03_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.81346E-02_JPRB,0.77325E-02_JPRB,0.70609E-02_JPRB,0.62554E-02_JPRB,0.53744E-02_JPRB, &
 & 0.44362E-02_JPRB,0.34019E-02_JPRB,0.22104E-02_JPRB,0.78609E-03_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.81749E-02_JPRB,0.78188E-02_JPRB,0.71688E-02_JPRB,0.63791E-02_JPRB,0.55086E-02_JPRB, &
 & 0.45702E-02_JPRB,0.35360E-02_JPRB,0.23302E-02_JPRB,0.88068E-03_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.81959E-02_JPRB,0.78839E-02_JPRB,0.72650E-02_JPRB,0.64997E-02_JPRB,0.56387E-02_JPRB, &
 & 0.47059E-02_JPRB,0.36681E-02_JPRB,0.24532E-02_JPRB,0.97840E-03_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.81937E-02_JPRB,0.79411E-02_JPRB,0.73546E-02_JPRB,0.66134E-02_JPRB,0.57649E-02_JPRB, &
 & 0.48383E-02_JPRB,0.38022E-02_JPRB,0.25773E-02_JPRB,0.10847E-02_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.75182E-02_JPRB,0.70907E-02_JPRB,0.64287E-02_JPRB,0.56605E-02_JPRB,0.48216E-02_JPRB, &
 & 0.39323E-02_JPRB,0.29776E-02_JPRB,0.18987E-02_JPRB,0.67472E-03_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.76076E-02_JPRB,0.72195E-02_JPRB,0.65653E-02_JPRB,0.58009E-02_JPRB,0.49640E-02_JPRB, &
 & 0.40692E-02_JPRB,0.31049E-02_JPRB,0.20098E-02_JPRB,0.74914E-03_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.76735E-02_JPRB,0.73227E-02_JPRB,0.66862E-02_JPRB,0.59346E-02_JPRB,0.51012E-02_JPRB, &
 & 0.42015E-02_JPRB,0.32328E-02_JPRB,0.21222E-02_JPRB,0.83367E-03_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.77132E-02_JPRB,0.74045E-02_JPRB,0.67969E-02_JPRB,0.60620E-02_JPRB,0.52309E-02_JPRB, &
 & 0.43347E-02_JPRB,0.33599E-02_JPRB,0.22355E-02_JPRB,0.91964E-03_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.77286E-02_JPRB,0.74752E-02_JPRB,0.68965E-02_JPRB,0.61793E-02_JPRB,0.53584E-02_JPRB, &
 & 0.44621E-02_JPRB,0.34884E-02_JPRB,0.23497E-02_JPRB,0.10114E-02_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.70149E-02_JPRB,0.65825E-02_JPRB,0.59329E-02_JPRB,0.52017E-02_JPRB,0.44219E-02_JPRB, &
 & 0.35899E-02_JPRB,0.27069E-02_JPRB,0.17187E-02_JPRB,0.74519E-03_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.71248E-02_JPRB,0.67269E-02_JPRB,0.60810E-02_JPRB,0.53515E-02_JPRB,0.45670E-02_JPRB, &
 & 0.37282E-02_JPRB,0.28313E-02_JPRB,0.18204E-02_JPRB,0.83494E-03_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.72044E-02_JPRB,0.68394E-02_JPRB,0.62076E-02_JPRB,0.54929E-02_JPRB,0.47097E-02_JPRB, &
 & 0.38613E-02_JPRB,0.29540E-02_JPRB,0.19235E-02_JPRB,0.93279E-03_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.72597E-02_JPRB,0.69309E-02_JPRB,0.63267E-02_JPRB,0.56269E-02_JPRB,0.48423E-02_JPRB, &
 & 0.39913E-02_JPRB,0.30764E-02_JPRB,0.20273E-02_JPRB,0.10348E-02_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.72955E-02_JPRB,0.70104E-02_JPRB,0.64378E-02_JPRB,0.57479E-02_JPRB,0.49695E-02_JPRB, &
 & 0.41180E-02_JPRB,0.31960E-02_JPRB,0.21324E-02_JPRB,0.11387E-02_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.65628E-02_JPRB,0.61735E-02_JPRB,0.55551E-02_JPRB,0.48677E-02_JPRB,0.41265E-02_JPRB, &
 & 0.33334E-02_JPRB,0.25028E-02_JPRB,0.15938E-02_JPRB,0.74406E-03_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.66786E-02_JPRB,0.63151E-02_JPRB,0.57025E-02_JPRB,0.50172E-02_JPRB,0.42702E-02_JPRB, &
 & 0.34674E-02_JPRB,0.26229E-02_JPRB,0.16875E-02_JPRB,0.82711E-03_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.67664E-02_JPRB,0.64350E-02_JPRB,0.58347E-02_JPRB,0.51562E-02_JPRB,0.44059E-02_JPRB, &
 & 0.35945E-02_JPRB,0.27422E-02_JPRB,0.17822E-02_JPRB,0.92379E-03_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.68381E-02_JPRB,0.65357E-02_JPRB,0.59597E-02_JPRB,0.52850E-02_JPRB,0.45292E-02_JPRB, &
 & 0.37195E-02_JPRB,0.28585E-02_JPRB,0.18773E-02_JPRB,0.10214E-02_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.68910E-02_JPRB,0.66274E-02_JPRB,0.60702E-02_JPRB,0.54014E-02_JPRB,0.46503E-02_JPRB, &
 & 0.38396E-02_JPRB,0.29707E-02_JPRB,0.19733E-02_JPRB,0.11179E-02_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.60794E-02_JPRB,0.57316E-02_JPRB,0.51563E-02_JPRB,0.45236E-02_JPRB,0.38371E-02_JPRB, &
 & 0.31013E-02_JPRB,0.23239E-02_JPRB,0.14745E-02_JPRB,0.70212E-03_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.62026E-02_JPRB,0.58782E-02_JPRB,0.53110E-02_JPRB,0.46778E-02_JPRB,0.39838E-02_JPRB, &
 & 0.32334E-02_JPRB,0.24368E-02_JPRB,0.15615E-02_JPRB,0.77146E-03_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.63087E-02_JPRB,0.60102E-02_JPRB,0.54544E-02_JPRB,0.48220E-02_JPRB,0.41191E-02_JPRB, &
 & 0.33562E-02_JPRB,0.25462E-02_JPRB,0.16493E-02_JPRB,0.85116E-03_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.63948E-02_JPRB,0.61265E-02_JPRB,0.55863E-02_JPRB,0.49541E-02_JPRB,0.42453E-02_JPRB, &
 & 0.34753E-02_JPRB,0.26508E-02_JPRB,0.17372E-02_JPRB,0.93862E-03_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.64607E-02_JPRB,0.62309E-02_JPRB,0.57052E-02_JPRB,0.50757E-02_JPRB,0.43660E-02_JPRB, &
 & 0.35907E-02_JPRB,0.27548E-02_JPRB,0.18249E-02_JPRB,0.10221E-02_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.55937E-02_JPRB,0.52793E-02_JPRB,0.47517E-02_JPRB,0.41692E-02_JPRB,0.35394E-02_JPRB, &
 & 0.28625E-02_JPRB,0.21454E-02_JPRB,0.13668E-02_JPRB,0.61956E-03_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.57319E-02_JPRB,0.54374E-02_JPRB,0.49129E-02_JPRB,0.43258E-02_JPRB,0.36843E-02_JPRB, &
 & 0.29907E-02_JPRB,0.22551E-02_JPRB,0.14474E-02_JPRB,0.68007E-03_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.58515E-02_JPRB,0.55788E-02_JPRB,0.50622E-02_JPRB,0.44734E-02_JPRB,0.38194E-02_JPRB, &
 & 0.31146E-02_JPRB,0.23600E-02_JPRB,0.15267E-02_JPRB,0.75016E-03_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.59483E-02_JPRB,0.57068E-02_JPRB,0.51995E-02_JPRB,0.46068E-02_JPRB,0.39501E-02_JPRB, &
 & 0.32357E-02_JPRB,0.24610E-02_JPRB,0.16061E-02_JPRB,0.82038E-03_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.60233E-02_JPRB,0.58195E-02_JPRB,0.53236E-02_JPRB,0.47349E-02_JPRB,0.40732E-02_JPRB, &
 & 0.33509E-02_JPRB,0.25596E-02_JPRB,0.16868E-02_JPRB,0.89122E-03_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.19771E-01_JPRB,0.18370E-01_JPRB,0.17356E-01_JPRB,0.16079E-01_JPRB,0.14680E-01_JPRB, &
 & 0.13282E-01_JPRB,0.11980E-01_JPRB,0.11582E-01_JPRB,0.12985E-01_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.19636E-01_JPRB,0.18337E-01_JPRB,0.17425E-01_JPRB,0.16276E-01_JPRB,0.15036E-01_JPRB, &
 & 0.13800E-01_JPRB,0.12788E-01_JPRB,0.12799E-01_JPRB,0.14491E-01_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.19487E-01_JPRB,0.18291E-01_JPRB,0.17516E-01_JPRB,0.16543E-01_JPRB,0.15458E-01_JPRB, &
 & 0.14398E-01_JPRB,0.13717E-01_JPRB,0.14121E-01_JPRB,0.16094E-01_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.19329E-01_JPRB,0.18244E-01_JPRB,0.17665E-01_JPRB,0.16858E-01_JPRB,0.15921E-01_JPRB, &
 & 0.15082E-01_JPRB,0.14738E-01_JPRB,0.15534E-01_JPRB,0.17796E-01_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.19162E-01_JPRB,0.18208E-01_JPRB,0.17862E-01_JPRB,0.17203E-01_JPRB,0.16407E-01_JPRB, &
 & 0.15804E-01_JPRB,0.15831E-01_JPRB,0.17016E-01_JPRB,0.19554E-01_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.20491E-01_JPRB,0.19041E-01_JPRB,0.17931E-01_JPRB,0.16490E-01_JPRB,0.14871E-01_JPRB, &
 & 0.13204E-01_JPRB,0.11551E-01_JPRB,0.10493E-01_JPRB,0.11370E-01_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.20351E-01_JPRB,0.19021E-01_JPRB,0.18003E-01_JPRB,0.16688E-01_JPRB,0.15207E-01_JPRB, &
 & 0.13674E-01_JPRB,0.12228E-01_JPRB,0.11542E-01_JPRB,0.12722E-01_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.20205E-01_JPRB,0.18987E-01_JPRB,0.18097E-01_JPRB,0.16946E-01_JPRB,0.15590E-01_JPRB, &
 & 0.14204E-01_JPRB,0.13003E-01_JPRB,0.12703E-01_JPRB,0.14170E-01_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.20054E-01_JPRB,0.18946E-01_JPRB,0.18241E-01_JPRB,0.17244E-01_JPRB,0.16012E-01_JPRB, &
 & 0.14800E-01_JPRB,0.13862E-01_JPRB,0.13953E-01_JPRB,0.15702E-01_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.19890E-01_JPRB,0.18914E-01_JPRB,0.18431E-01_JPRB,0.17568E-01_JPRB,0.16464E-01_JPRB, &
 & 0.15445E-01_JPRB,0.14813E-01_JPRB,0.15302E-01_JPRB,0.17318E-01_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.21143E-01_JPRB,0.19662E-01_JPRB,0.18419E-01_JPRB,0.16811E-01_JPRB,0.15005E-01_JPRB, &
 & 0.13075E-01_JPRB,0.11094E-01_JPRB,0.93893E-02_JPRB,0.95682E-02_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.21021E-01_JPRB,0.19658E-01_JPRB,0.18498E-01_JPRB,0.17007E-01_JPRB,0.15312E-01_JPRB, &
 & 0.13491E-01_JPRB,0.11661E-01_JPRB,0.10256E-01_JPRB,0.10742E-01_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.20887E-01_JPRB,0.19635E-01_JPRB,0.18594E-01_JPRB,0.17251E-01_JPRB,0.15669E-01_JPRB, &
 & 0.13959E-01_JPRB,0.12304E-01_JPRB,0.11227E-01_JPRB,0.12012E-01_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.20742E-01_JPRB,0.19603E-01_JPRB,0.18727E-01_JPRB,0.17530E-01_JPRB,0.16058E-01_JPRB, &
 & 0.14485E-01_JPRB,0.13015E-01_JPRB,0.12294E-01_JPRB,0.13375E-01_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.20582E-01_JPRB,0.19578E-01_JPRB,0.18903E-01_JPRB,0.17831E-01_JPRB,0.16483E-01_JPRB, &
 & 0.15047E-01_JPRB,0.13818E-01_JPRB,0.13471E-01_JPRB,0.14836E-01_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.21726E-01_JPRB,0.20199E-01_JPRB,0.18812E-01_JPRB,0.17047E-01_JPRB,0.15080E-01_JPRB, &
 & 0.12938E-01_JPRB,0.10693E-01_JPRB,0.84650E-02_JPRB,0.79270E-02_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.21624E-01_JPRB,0.20213E-01_JPRB,0.18897E-01_JPRB,0.17238E-01_JPRB,0.15368E-01_JPRB, &
 & 0.13326E-01_JPRB,0.11175E-01_JPRB,0.91656E-02_JPRB,0.89409E-02_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.21502E-01_JPRB,0.20207E-01_JPRB,0.18990E-01_JPRB,0.17468E-01_JPRB,0.15708E-01_JPRB, &
 & 0.13755E-01_JPRB,0.11721E-01_JPRB,0.99561E-02_JPRB,0.10044E-01_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.21364E-01_JPRB,0.20186E-01_JPRB,0.19114E-01_JPRB,0.17747E-01_JPRB,0.16075E-01_JPRB, &
 & 0.14230E-01_JPRB,0.12327E-01_JPRB,0.10844E-01_JPRB,0.11238E-01_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.21208E-01_JPRB,0.20165E-01_JPRB,0.19280E-01_JPRB,0.18035E-01_JPRB,0.16477E-01_JPRB, &
 & 0.14734E-01_JPRB,0.13004E-01_JPRB,0.11837E-01_JPRB,0.12527E-01_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.22212E-01_JPRB,0.20643E-01_JPRB,0.19101E-01_JPRB,0.17193E-01_JPRB,0.15094E-01_JPRB, &
 & 0.12790E-01_JPRB,0.10344E-01_JPRB,0.77661E-02_JPRB,0.65292E-02_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.22131E-01_JPRB,0.20679E-01_JPRB,0.19192E-01_JPRB,0.17388E-01_JPRB,0.15373E-01_JPRB, &
 & 0.13156E-01_JPRB,0.10779E-01_JPRB,0.83326E-02_JPRB,0.74004E-02_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.22024E-01_JPRB,0.20689E-01_JPRB,0.19289E-01_JPRB,0.17614E-01_JPRB,0.15701E-01_JPRB, &
 & 0.13560E-01_JPRB,0.11259E-01_JPRB,0.89716E-02_JPRB,0.83509E-02_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.21891E-01_JPRB,0.20674E-01_JPRB,0.19419E-01_JPRB,0.17880E-01_JPRB,0.16055E-01_JPRB, &
 & 0.14002E-01_JPRB,0.11784E-01_JPRB,0.96942E-02_JPRB,0.93863E-02_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.21733E-01_JPRB,0.20659E-01_JPRB,0.19581E-01_JPRB,0.18166E-01_JPRB,0.16436E-01_JPRB, &
 & 0.14467E-01_JPRB,0.12356E-01_JPRB,0.10508E-01_JPRB,0.10499E-01_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.22561E-01_JPRB,0.20963E-01_JPRB,0.19278E-01_JPRB,0.17248E-01_JPRB,0.15027E-01_JPRB, &
 & 0.12605E-01_JPRB,0.99913E-02_JPRB,0.71998E-02_JPRB,0.53191E-02_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.22505E-01_JPRB,0.21027E-01_JPRB,0.19391E-01_JPRB,0.17451E-01_JPRB,0.15296E-01_JPRB, &
 & 0.12947E-01_JPRB,0.10394E-01_JPRB,0.76719E-02_JPRB,0.60628E-02_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.22407E-01_JPRB,0.21057E-01_JPRB,0.19505E-01_JPRB,0.17673E-01_JPRB,0.15617E-01_JPRB, &
 & 0.13330E-01_JPRB,0.10834E-01_JPRB,0.82004E-02_JPRB,0.68698E-02_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.22287E-01_JPRB,0.21061E-01_JPRB,0.19636E-01_JPRB,0.17933E-01_JPRB,0.15963E-01_JPRB, &
 & 0.13742E-01_JPRB,0.11312E-01_JPRB,0.87854E-02_JPRB,0.77488E-02_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.22148E-01_JPRB,0.21053E-01_JPRB,0.19794E-01_JPRB,0.18212E-01_JPRB,0.16329E-01_JPRB, &
 & 0.14180E-01_JPRB,0.11816E-01_JPRB,0.94417E-02_JPRB,0.86993E-02_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.22745E-01_JPRB,0.21135E-01_JPRB,0.19327E-01_JPRB,0.17197E-01_JPRB,0.14893E-01_JPRB, &
 & 0.12374E-01_JPRB,0.96536E-02_JPRB,0.67256E-02_JPRB,0.43127E-02_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.22707E-01_JPRB,0.21230E-01_JPRB,0.19474E-01_JPRB,0.17423E-01_JPRB,0.15162E-01_JPRB, &
 & 0.12700E-01_JPRB,0.10030E-01_JPRB,0.71370E-02_JPRB,0.49389E-02_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.22632E-01_JPRB,0.21281E-01_JPRB,0.19608E-01_JPRB,0.17649E-01_JPRB,0.15471E-01_JPRB, &
 & 0.13070E-01_JPRB,0.10436E-01_JPRB,0.75822E-02_JPRB,0.56174E-02_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.22537E-01_JPRB,0.21307E-01_JPRB,0.19744E-01_JPRB,0.17903E-01_JPRB,0.15813E-01_JPRB, &
 & 0.13461E-01_JPRB,0.10872E-01_JPRB,0.80682E-02_JPRB,0.63562E-02_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.22420E-01_JPRB,0.21314E-01_JPRB,0.19904E-01_JPRB,0.18182E-01_JPRB,0.16160E-01_JPRB, &
 & 0.13874E-01_JPRB,0.11331E-01_JPRB,0.86088E-02_JPRB,0.71565E-02_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.22742E-01_JPRB,0.21141E-01_JPRB,0.19244E-01_JPRB,0.17036E-01_JPRB,0.14667E-01_JPRB, &
 & 0.12093E-01_JPRB,0.93194E-02_JPRB,0.63016E-02_JPRB,0.33604E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART7',0,ZHOOK_HANDLE)


KA(:, 2, 8, 9) = (/ &
 & 0.22738E-01_JPRB,0.21267E-01_JPRB,0.19420E-01_JPRB,0.17289E-01_JPRB,0.14951E-01_JPRB, &
 & 0.12414E-01_JPRB,0.96717E-02_JPRB,0.66654E-02_JPRB,0.38903E-02_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.22699E-01_JPRB,0.21347E-01_JPRB,0.19574E-01_JPRB,0.17525E-01_JPRB,0.15260E-01_JPRB, &
 & 0.12775E-01_JPRB,0.10048E-01_JPRB,0.70608E-02_JPRB,0.44626E-02_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.22634E-01_JPRB,0.21402E-01_JPRB,0.19725E-01_JPRB,0.17775E-01_JPRB,0.15596E-01_JPRB, &
 & 0.13150E-01_JPRB,0.10455E-01_JPRB,0.74847E-02_JPRB,0.50904E-02_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.22550E-01_JPRB,0.21432E-01_JPRB,0.19888E-01_JPRB,0.18059E-01_JPRB,0.15936E-01_JPRB, &
 & 0.13540E-01_JPRB,0.10879E-01_JPRB,0.79454E-02_JPRB,0.57754E-02_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.22571E-01_JPRB,0.20980E-01_JPRB,0.19017E-01_JPRB,0.16764E-01_JPRB,0.14350E-01_JPRB, &
 & 0.11743E-01_JPRB,0.89583E-02_JPRB,0.59107E-02_JPRB,0.27753E-02_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.22607E-01_JPRB,0.21147E-01_JPRB,0.19231E-01_JPRB,0.17040E-01_JPRB,0.14648E-01_JPRB, &
 & 0.12069E-01_JPRB,0.92988E-02_JPRB,0.62425E-02_JPRB,0.31527E-02_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.22609E-01_JPRB,0.21268E-01_JPRB,0.19413E-01_JPRB,0.17284E-01_JPRB,0.14954E-01_JPRB, &
 & 0.12424E-01_JPRB,0.96568E-02_JPRB,0.66010E-02_JPRB,0.35387E-02_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.22589E-01_JPRB,0.21355E-01_JPRB,0.19582E-01_JPRB,0.17535E-01_JPRB,0.15285E-01_JPRB, &
 & 0.12790E-01_JPRB,0.10038E-01_JPRB,0.69765E-02_JPRB,0.39766E-02_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.22546E-01_JPRB,0.21413E-01_JPRB,0.19758E-01_JPRB,0.17821E-01_JPRB,0.15622E-01_JPRB, &
 & 0.13166E-01_JPRB,0.10432E-01_JPRB,0.73821E-02_JPRB,0.44450E-02_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.22137E-01_JPRB,0.20618E-01_JPRB,0.18650E-01_JPRB,0.16403E-01_JPRB,0.13972E-01_JPRB, &
 & 0.11364E-01_JPRB,0.85848E-02_JPRB,0.55632E-02_JPRB,0.31593E-02_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.22231E-01_JPRB,0.20835E-01_JPRB,0.18905E-01_JPRB,0.16706E-01_JPRB,0.14289E-01_JPRB, &
 & 0.11695E-01_JPRB,0.89167E-02_JPRB,0.58739E-02_JPRB,0.35325E-02_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.22295E-01_JPRB,0.21010E-01_JPRB,0.19131E-01_JPRB,0.16972E-01_JPRB,0.14595E-01_JPRB, &
 & 0.12040E-01_JPRB,0.92665E-02_JPRB,0.62059E-02_JPRB,0.39315E-02_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.22331E-01_JPRB,0.21144E-01_JPRB,0.19334E-01_JPRB,0.17233E-01_JPRB,0.14916E-01_JPRB, &
 & 0.12396E-01_JPRB,0.96355E-02_JPRB,0.65507E-02_JPRB,0.43409E-02_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.22332E-01_JPRB,0.21248E-01_JPRB,0.19527E-01_JPRB,0.17517E-01_JPRB,0.15252E-01_JPRB, &
 & 0.12765E-01_JPRB,0.10012E-01_JPRB,0.69176E-02_JPRB,0.47851E-02_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.21611E-01_JPRB,0.20177E-01_JPRB,0.18220E-01_JPRB,0.16014E-01_JPRB,0.13625E-01_JPRB, &
 & 0.11072E-01_JPRB,0.83376E-02_JPRB,0.53526E-02_JPRB,0.32967E-02_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.21754E-01_JPRB,0.20431E-01_JPRB,0.18507E-01_JPRB,0.16333E-01_JPRB,0.13954E-01_JPRB, &
 & 0.11415E-01_JPRB,0.86702E-02_JPRB,0.56558E-02_JPRB,0.36779E-02_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.21862E-01_JPRB,0.20634E-01_JPRB,0.18769E-01_JPRB,0.16624E-01_JPRB,0.14280E-01_JPRB, &
 & 0.11762E-01_JPRB,0.90145E-02_JPRB,0.59759E-02_JPRB,0.40891E-02_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.21929E-01_JPRB,0.20796E-01_JPRB,0.18995E-01_JPRB,0.16914E-01_JPRB,0.14621E-01_JPRB, &
 & 0.12122E-01_JPRB,0.93752E-02_JPRB,0.63026E-02_JPRB,0.45492E-02_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.21956E-01_JPRB,0.20925E-01_JPRB,0.19222E-01_JPRB,0.17218E-01_JPRB,0.14974E-01_JPRB, &
 & 0.12492E-01_JPRB,0.97406E-02_JPRB,0.66508E-02_JPRB,0.50324E-02_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.20989E-01_JPRB,0.19649E-01_JPRB,0.17719E-01_JPRB,0.15554E-01_JPRB,0.13207E-01_JPRB, &
 & 0.10709E-01_JPRB,0.80423E-02_JPRB,0.51308E-02_JPRB,0.32152E-02_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.21187E-01_JPRB,0.19941E-01_JPRB,0.18042E-01_JPRB,0.15892E-01_JPRB,0.13549E-01_JPRB, &
 & 0.11055E-01_JPRB,0.83766E-02_JPRB,0.54250E-02_JPRB,0.35851E-02_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.21336E-01_JPRB,0.20173E-01_JPRB,0.18327E-01_JPRB,0.16203E-01_JPRB,0.13894E-01_JPRB, &
 & 0.11411E-01_JPRB,0.87228E-02_JPRB,0.57329E-02_JPRB,0.40006E-02_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.21440E-01_JPRB,0.20364E-01_JPRB,0.18584E-01_JPRB,0.16516E-01_JPRB,0.14243E-01_JPRB, &
 & 0.11781E-01_JPRB,0.90825E-02_JPRB,0.60483E-02_JPRB,0.44327E-02_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.21509E-01_JPRB,0.20531E-01_JPRB,0.18841E-01_JPRB,0.16838E-01_JPRB,0.14607E-01_JPRB, &
 & 0.12155E-01_JPRB,0.94413E-02_JPRB,0.63798E-02_JPRB,0.48628E-02_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.20300E-01_JPRB,0.19036E-01_JPRB,0.17142E-01_JPRB,0.15033E-01_JPRB,0.12745E-01_JPRB, &
 & 0.10318E-01_JPRB,0.77330E-02_JPRB,0.48977E-02_JPRB,0.29186E-02_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.20539E-01_JPRB,0.19361E-01_JPRB,0.17504E-01_JPRB,0.15398E-01_JPRB,0.13114E-01_JPRB, &
 & 0.10679E-01_JPRB,0.80651E-02_JPRB,0.51844E-02_JPRB,0.32743E-02_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.20734E-01_JPRB,0.19633E-01_JPRB,0.17821E-01_JPRB,0.15739E-01_JPRB,0.13481E-01_JPRB, &
 & 0.11044E-01_JPRB,0.84099E-02_JPRB,0.54812E-02_JPRB,0.36601E-02_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.20892E-01_JPRB,0.19871E-01_JPRB,0.18120E-01_JPRB,0.16090E-01_JPRB,0.13847E-01_JPRB, &
 & 0.11415E-01_JPRB,0.87615E-02_JPRB,0.57863E-02_JPRB,0.40403E-02_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.21016E-01_JPRB,0.20092E-01_JPRB,0.18420E-01_JPRB,0.16433E-01_JPRB,0.14220E-01_JPRB, &
 & 0.11787E-01_JPRB,0.91177E-02_JPRB,0.61020E-02_JPRB,0.44775E-02_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.32077E-01_JPRB,0.29717E-01_JPRB,0.27957E-01_JPRB,0.27088E-01_JPRB,0.26148E-01_JPRB, &
 & 0.25463E-01_JPRB,0.27887E-01_JPRB,0.32409E-01_JPRB,0.37623E-01_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.31656E-01_JPRB,0.29512E-01_JPRB,0.28047E-01_JPRB,0.27317E-01_JPRB,0.26667E-01_JPRB, &
 & 0.26788E-01_JPRB,0.30344E-01_JPRB,0.35248E-01_JPRB,0.40533E-01_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.31222E-01_JPRB,0.29398E-01_JPRB,0.28183E-01_JPRB,0.27633E-01_JPRB,0.27598E-01_JPRB, &
 & 0.28788E-01_JPRB,0.33344E-01_JPRB,0.38694E-01_JPRB,0.44458E-01_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.30838E-01_JPRB,0.29185E-01_JPRB,0.28219E-01_JPRB,0.28269E-01_JPRB,0.28900E-01_JPRB, &
 & 0.31215E-01_JPRB,0.36765E-01_JPRB,0.42659E-01_JPRB,0.48710E-01_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.30476E-01_JPRB,0.28982E-01_JPRB,0.28435E-01_JPRB,0.29011E-01_JPRB,0.30822E-01_JPRB, &
 & 0.34422E-01_JPRB,0.40770E-01_JPRB,0.47309E-01_JPRB,0.54027E-01_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.34215E-01_JPRB,0.31859E-01_JPRB,0.30015E-01_JPRB,0.28551E-01_JPRB,0.26684E-01_JPRB, &
 & 0.25243E-01_JPRB,0.25874E-01_JPRB,0.29803E-01_JPRB,0.34327E-01_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.33819E-01_JPRB,0.31701E-01_JPRB,0.30099E-01_JPRB,0.28712E-01_JPRB,0.27156E-01_JPRB, &
 & 0.26446E-01_JPRB,0.28380E-01_JPRB,0.32886E-01_JPRB,0.37685E-01_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.33393E-01_JPRB,0.31477E-01_JPRB,0.30146E-01_JPRB,0.28931E-01_JPRB,0.28112E-01_JPRB, &
 & 0.28308E-01_JPRB,0.31383E-01_JPRB,0.36360E-01_JPRB,0.41605E-01_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.33012E-01_JPRB,0.31222E-01_JPRB,0.30110E-01_JPRB,0.29460E-01_JPRB,0.29343E-01_JPRB, &
 & 0.30463E-01_JPRB,0.34829E-01_JPRB,0.40350E-01_JPRB,0.46115E-01_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.32618E-01_JPRB,0.30977E-01_JPRB,0.30249E-01_JPRB,0.30140E-01_JPRB,0.31029E-01_JPRB, &
 & 0.33086E-01_JPRB,0.38518E-01_JPRB,0.44611E-01_JPRB,0.51063E-01_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.36609E-01_JPRB,0.34016E-01_JPRB,0.32008E-01_JPRB,0.30013E-01_JPRB,0.27528E-01_JPRB, &
 & 0.25143E-01_JPRB,0.24092E-01_JPRB,0.26746E-01_JPRB,0.30590E-01_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.36187E-01_JPRB,0.33816E-01_JPRB,0.32068E-01_JPRB,0.30121E-01_JPRB,0.27943E-01_JPRB, &
 & 0.26137E-01_JPRB,0.26190E-01_JPRB,0.29769E-01_JPRB,0.34003E-01_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.35755E-01_JPRB,0.33555E-01_JPRB,0.32022E-01_JPRB,0.30354E-01_JPRB,0.28696E-01_JPRB, &
 & 0.27732E-01_JPRB,0.28744E-01_JPRB,0.33056E-01_JPRB,0.37754E-01_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.35304E-01_JPRB,0.33277E-01_JPRB,0.31985E-01_JPRB,0.30856E-01_JPRB,0.29759E-01_JPRB, &
 & 0.29582E-01_JPRB,0.31793E-01_JPRB,0.36769E-01_JPRB,0.41965E-01_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.34895E-01_JPRB,0.32987E-01_JPRB,0.32094E-01_JPRB,0.31490E-01_JPRB,0.31100E-01_JPRB, &
 & 0.31735E-01_JPRB,0.35104E-01_JPRB,0.40646E-01_JPRB,0.46442E-01_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.38977E-01_JPRB,0.36120E-01_JPRB,0.33897E-01_JPRB,0.31410E-01_JPRB,0.28525E-01_JPRB, &
 & 0.25373E-01_JPRB,0.22918E-01_JPRB,0.23596E-01_JPRB,0.26905E-01_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.38508E-01_JPRB,0.35924E-01_JPRB,0.33917E-01_JPRB,0.31530E-01_JPRB,0.28933E-01_JPRB, &
 & 0.26161E-01_JPRB,0.24652E-01_JPRB,0.26430E-01_JPRB,0.30108E-01_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.38014E-01_JPRB,0.35658E-01_JPRB,0.33872E-01_JPRB,0.31757E-01_JPRB,0.29547E-01_JPRB, &
 & 0.27436E-01_JPRB,0.26616E-01_JPRB,0.29450E-01_JPRB,0.33541E-01_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.37555E-01_JPRB,0.35363E-01_JPRB,0.33895E-01_JPRB,0.32125E-01_JPRB,0.30540E-01_JPRB, &
 & 0.28878E-01_JPRB,0.28956E-01_JPRB,0.32793E-01_JPRB,0.37351E-01_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.37151E-01_JPRB,0.35088E-01_JPRB,0.33984E-01_JPRB,0.32788E-01_JPRB,0.31573E-01_JPRB, &
 & 0.30633E-01_JPRB,0.31627E-01_JPRB,0.36308E-01_JPRB,0.41371E-01_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.41153E-01_JPRB,0.38034E-01_JPRB,0.35706E-01_JPRB,0.32805E-01_JPRB,0.29387E-01_JPRB, &
 & 0.25927E-01_JPRB,0.22231E-01_JPRB,0.20561E-01_JPRB,0.23186E-01_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.40611E-01_JPRB,0.37835E-01_JPRB,0.35759E-01_JPRB,0.32923E-01_JPRB,0.29781E-01_JPRB, &
 & 0.26577E-01_JPRB,0.23565E-01_JPRB,0.23003E-01_JPRB,0.26110E-01_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.40174E-01_JPRB,0.37589E-01_JPRB,0.35747E-01_JPRB,0.33131E-01_JPRB,0.30334E-01_JPRB, &
 & 0.27648E-01_JPRB,0.25145E-01_JPRB,0.25696E-01_JPRB,0.29208E-01_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.39802E-01_JPRB,0.37389E-01_JPRB,0.35760E-01_JPRB,0.33447E-01_JPRB,0.31294E-01_JPRB, &
 & 0.28785E-01_JPRB,0.27005E-01_JPRB,0.28729E-01_JPRB,0.32665E-01_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.39471E-01_JPRB,0.37195E-01_JPRB,0.35872E-01_JPRB,0.34084E-01_JPRB,0.32227E-01_JPRB, &
 & 0.30087E-01_JPRB,0.29177E-01_JPRB,0.32029E-01_JPRB,0.36449E-01_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.43370E-01_JPRB,0.39997E-01_JPRB,0.37440E-01_JPRB,0.34118E-01_JPRB,0.30345E-01_JPRB, &
 & 0.26246E-01_JPRB,0.21955E-01_JPRB,0.18231E-01_JPRB,0.19573E-01_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.42801E-01_JPRB,0.39763E-01_JPRB,0.37480E-01_JPRB,0.34252E-01_JPRB,0.30723E-01_JPRB, &
 & 0.26892E-01_JPRB,0.22943E-01_JPRB,0.20080E-01_JPRB,0.22108E-01_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.42453E-01_JPRB,0.39592E-01_JPRB,0.37449E-01_JPRB,0.34486E-01_JPRB,0.31160E-01_JPRB, &
 & 0.27853E-01_JPRB,0.24129E-01_JPRB,0.22254E-01_JPRB,0.24945E-01_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.42151E-01_JPRB,0.39446E-01_JPRB,0.37500E-01_JPRB,0.34777E-01_JPRB,0.31970E-01_JPRB, &
 & 0.28872E-01_JPRB,0.25539E-01_JPRB,0.24809E-01_JPRB,0.28086E-01_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.41833E-01_JPRB,0.39344E-01_JPRB,0.37631E-01_JPRB,0.35392E-01_JPRB,0.32810E-01_JPRB, &
 & 0.29983E-01_JPRB,0.27309E-01_JPRB,0.27744E-01_JPRB,0.31535E-01_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.45445E-01_JPRB,0.41961E-01_JPRB,0.39238E-01_JPRB,0.35426E-01_JPRB,0.31192E-01_JPRB, &
 & 0.26649E-01_JPRB,0.21695E-01_JPRB,0.16623E-01_JPRB,0.16293E-01_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.45078E-01_JPRB,0.41797E-01_JPRB,0.39225E-01_JPRB,0.35507E-01_JPRB,0.31562E-01_JPRB, &
 & 0.27229E-01_JPRB,0.22532E-01_JPRB,0.18019E-01_JPRB,0.18534E-01_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.44870E-01_JPRB,0.41785E-01_JPRB,0.39209E-01_JPRB,0.35749E-01_JPRB,0.31958E-01_JPRB, &
 & 0.27976E-01_JPRB,0.23572E-01_JPRB,0.19783E-01_JPRB,0.21105E-01_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.44638E-01_JPRB,0.41726E-01_JPRB,0.39301E-01_JPRB,0.35989E-01_JPRB,0.32614E-01_JPRB, &
 & 0.28887E-01_JPRB,0.24743E-01_JPRB,0.21842E-01_JPRB,0.23947E-01_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.44319E-01_JPRB,0.41703E-01_JPRB,0.39403E-01_JPRB,0.36491E-01_JPRB,0.33461E-01_JPRB, &
 & 0.29864E-01_JPRB,0.26133E-01_JPRB,0.24238E-01_JPRB,0.27063E-01_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.47338E-01_JPRB,0.43694E-01_JPRB,0.40795E-01_JPRB,0.36657E-01_JPRB,0.31991E-01_JPRB, &
 & 0.26976E-01_JPRB,0.21436E-01_JPRB,0.15589E-01_JPRB,0.13371E-01_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.47172E-01_JPRB,0.43681E-01_JPRB,0.40850E-01_JPRB,0.36728E-01_JPRB,0.32341E-01_JPRB, &
 & 0.27474E-01_JPRB,0.22184E-01_JPRB,0.16691E-01_JPRB,0.15337E-01_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.47077E-01_JPRB,0.43885E-01_JPRB,0.40965E-01_JPRB,0.37016E-01_JPRB,0.32654E-01_JPRB, &
 & 0.28038E-01_JPRB,0.23084E-01_JPRB,0.18052E-01_JPRB,0.17670E-01_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.46877E-01_JPRB,0.43984E-01_JPRB,0.41138E-01_JPRB,0.37264E-01_JPRB,0.33142E-01_JPRB, &
 & 0.28868E-01_JPRB,0.24126E-01_JPRB,0.19696E-01_JPRB,0.20174E-01_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.46627E-01_JPRB,0.44042E-01_JPRB,0.41218E-01_JPRB,0.37582E-01_JPRB,0.33931E-01_JPRB, &
 & 0.29818E-01_JPRB,0.25367E-01_JPRB,0.21590E-01_JPRB,0.22899E-01_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.49069E-01_JPRB,0.45230E-01_JPRB,0.41949E-01_JPRB,0.37482E-01_JPRB,0.32547E-01_JPRB, &
 & 0.27221E-01_JPRB,0.21190E-01_JPRB,0.14771E-01_JPRB,0.82104E-02_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.48982E-01_JPRB,0.45358E-01_JPRB,0.42113E-01_JPRB,0.37642E-01_JPRB,0.32970E-01_JPRB, &
 & 0.27650E-01_JPRB,0.21850E-01_JPRB,0.15738E-01_JPRB,0.94586E-02_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.48934E-01_JPRB,0.45677E-01_JPRB,0.42390E-01_JPRB,0.38084E-01_JPRB,0.33301E-01_JPRB, &
 & 0.28097E-01_JPRB,0.22664E-01_JPRB,0.16844E-01_JPRB,0.11686E-01_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.48760E-01_JPRB,0.45876E-01_JPRB,0.42614E-01_JPRB,0.38405E-01_JPRB,0.33732E-01_JPRB, &
 & 0.28793E-01_JPRB,0.23625E-01_JPRB,0.18186E-01_JPRB,0.14417E-01_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.48535E-01_JPRB,0.45946E-01_JPRB,0.42722E-01_JPRB,0.38669E-01_JPRB,0.34439E-01_JPRB, &
 & 0.29718E-01_JPRB,0.24746E-01_JPRB,0.19636E-01_JPRB,0.17490E-01_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.50581E-01_JPRB,0.46588E-01_JPRB,0.42861E-01_JPRB,0.37978E-01_JPRB,0.32756E-01_JPRB, &
 & 0.27218E-01_JPRB,0.20963E-01_JPRB,0.14152E-01_JPRB,0.94977E-02_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.50552E-01_JPRB,0.46832E-01_JPRB,0.43092E-01_JPRB,0.38231E-01_JPRB,0.33230E-01_JPRB, &
 & 0.27672E-01_JPRB,0.21597E-01_JPRB,0.15000E-01_JPRB,0.11069E-01_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.50470E-01_JPRB,0.47126E-01_JPRB,0.43390E-01_JPRB,0.38763E-01_JPRB,0.33692E-01_JPRB, &
 & 0.28191E-01_JPRB,0.22303E-01_JPRB,0.15932E-01_JPRB,0.12529E-01_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.50251E-01_JPRB,0.47290E-01_JPRB,0.43621E-01_JPRB,0.39150E-01_JPRB,0.34250E-01_JPRB, &
 & 0.28907E-01_JPRB,0.23153E-01_JPRB,0.17091E-01_JPRB,0.14647E-01_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.50025E-01_JPRB,0.47335E-01_JPRB,0.43789E-01_JPRB,0.39526E-01_JPRB,0.34961E-01_JPRB, &
 & 0.29783E-01_JPRB,0.24207E-01_JPRB,0.18303E-01_JPRB,0.16505E-01_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.51775E-01_JPRB,0.47733E-01_JPRB,0.43604E-01_JPRB,0.38377E-01_JPRB,0.33010E-01_JPRB, &
 & 0.27211E-01_JPRB,0.20853E-01_JPRB,0.13952E-01_JPRB,0.10099E-01_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.51722E-01_JPRB,0.48082E-01_JPRB,0.43912E-01_JPRB,0.38859E-01_JPRB,0.33550E-01_JPRB, &
 & 0.27720E-01_JPRB,0.21535E-01_JPRB,0.14746E-01_JPRB,0.11460E-01_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.51577E-01_JPRB,0.48309E-01_JPRB,0.44107E-01_JPRB,0.39371E-01_JPRB,0.34132E-01_JPRB, &
 & 0.28431E-01_JPRB,0.22288E-01_JPRB,0.15640E-01_JPRB,0.12761E-01_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.51367E-01_JPRB,0.48474E-01_JPRB,0.44409E-01_JPRB,0.39819E-01_JPRB,0.34807E-01_JPRB, &
 & 0.29240E-01_JPRB,0.23192E-01_JPRB,0.16707E-01_JPRB,0.14096E-01_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.51186E-01_JPRB,0.48565E-01_JPRB,0.44658E-01_JPRB,0.40350E-01_JPRB,0.35545E-01_JPRB, &
 & 0.30221E-01_JPRB,0.24214E-01_JPRB,0.17744E-01_JPRB,0.15290E-01_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.52731E-01_JPRB,0.48681E-01_JPRB,0.44186E-01_JPRB,0.38733E-01_JPRB,0.33169E-01_JPRB, &
 & 0.27108E-01_JPRB,0.20634E-01_JPRB,0.13723E-01_JPRB,0.97949E-02_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.52654E-01_JPRB,0.49001E-01_JPRB,0.44433E-01_JPRB,0.39315E-01_JPRB,0.33776E-01_JPRB, &
 & 0.27772E-01_JPRB,0.21363E-01_JPRB,0.14506E-01_JPRB,0.11186E-01_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.52581E-01_JPRB,0.49321E-01_JPRB,0.44768E-01_JPRB,0.39827E-01_JPRB,0.34382E-01_JPRB, &
 & 0.28565E-01_JPRB,0.22205E-01_JPRB,0.15366E-01_JPRB,0.12310E-01_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.52474E-01_JPRB,0.49527E-01_JPRB,0.45170E-01_JPRB,0.40364E-01_JPRB,0.35120E-01_JPRB, &
 & 0.29376E-01_JPRB,0.23174E-01_JPRB,0.16305E-01_JPRB,0.14325E-01_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.52313E-01_JPRB,0.49659E-01_JPRB,0.45526E-01_JPRB,0.41026E-01_JPRB,0.35905E-01_JPRB, &
 & 0.30399E-01_JPRB,0.24222E-01_JPRB,0.17291E-01_JPRB,0.16045E-01_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.53347E-01_JPRB,0.49460E-01_JPRB,0.44667E-01_JPRB,0.39102E-01_JPRB,0.33300E-01_JPRB, &
 & 0.27005E-01_JPRB,0.20373E-01_JPRB,0.13403E-01_JPRB,0.88882E-02_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.53473E-01_JPRB,0.49893E-01_JPRB,0.44992E-01_JPRB,0.39672E-01_JPRB,0.33886E-01_JPRB, &
 & 0.27737E-01_JPRB,0.21157E-01_JPRB,0.14194E-01_JPRB,0.99472E-02_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.53543E-01_JPRB,0.50285E-01_JPRB,0.45484E-01_JPRB,0.40250E-01_JPRB,0.34541E-01_JPRB, &
 & 0.28510E-01_JPRB,0.22035E-01_JPRB,0.15061E-01_JPRB,0.11235E-01_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.53461E-01_JPRB,0.50524E-01_JPRB,0.45912E-01_JPRB,0.40827E-01_JPRB,0.35322E-01_JPRB, &
 & 0.29374E-01_JPRB,0.23048E-01_JPRB,0.15925E-01_JPRB,0.12822E-01_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.53278E-01_JPRB,0.50624E-01_JPRB,0.46303E-01_JPRB,0.41556E-01_JPRB,0.36186E-01_JPRB, &
 & 0.30414E-01_JPRB,0.24058E-01_JPRB,0.16868E-01_JPRB,0.14203E-01_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.37171E-01_JPRB,0.34434E-01_JPRB,0.32644E-01_JPRB,0.32703E-01_JPRB,0.33235E-01_JPRB, &
 & 0.36611E-01_JPRB,0.43526E-01_JPRB,0.50696E-01_JPRB,0.58297E-01_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.36741E-01_JPRB,0.34071E-01_JPRB,0.32455E-01_JPRB,0.33094E-01_JPRB,0.34229E-01_JPRB, &
 & 0.38792E-01_JPRB,0.46364E-01_JPRB,0.53998E-01_JPRB,0.61977E-01_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.36310E-01_JPRB,0.33795E-01_JPRB,0.32514E-01_JPRB,0.33548E-01_JPRB,0.35414E-01_JPRB, &
 & 0.41445E-01_JPRB,0.49627E-01_JPRB,0.57817E-01_JPRB,0.66049E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART8',0,ZHOOK_HANDLE)


KA(:, 4, 1,11) = (/ &
 & 0.35845E-01_JPRB,0.33632E-01_JPRB,0.32631E-01_JPRB,0.34397E-01_JPRB,0.37428E-01_JPRB, &
 & 0.44985E-01_JPRB,0.53868E-01_JPRB,0.62763E-01_JPRB,0.71579E-01_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.35331E-01_JPRB,0.33379E-01_JPRB,0.32910E-01_JPRB,0.35528E-01_JPRB,0.39783E-01_JPRB, &
 & 0.48705E-01_JPRB,0.58316E-01_JPRB,0.67942E-01_JPRB,0.77160E-01_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.40448E-01_JPRB,0.37395E-01_JPRB,0.35029E-01_JPRB,0.34305E-01_JPRB,0.33991E-01_JPRB, &
 & 0.35316E-01_JPRB,0.40968E-01_JPRB,0.47712E-01_JPRB,0.54932E-01_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.39920E-01_JPRB,0.36968E-01_JPRB,0.34927E-01_JPRB,0.34599E-01_JPRB,0.34841E-01_JPRB, &
 & 0.37250E-01_JPRB,0.43923E-01_JPRB,0.51161E-01_JPRB,0.58827E-01_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.39405E-01_JPRB,0.36691E-01_JPRB,0.34999E-01_JPRB,0.35076E-01_JPRB,0.35924E-01_JPRB, &
 & 0.39772E-01_JPRB,0.47443E-01_JPRB,0.55253E-01_JPRB,0.63303E-01_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.38792E-01_JPRB,0.36414E-01_JPRB,0.35121E-01_JPRB,0.35787E-01_JPRB,0.37790E-01_JPRB, &
 & 0.43290E-01_JPRB,0.51773E-01_JPRB,0.60284E-01_JPRB,0.68983E-01_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.38190E-01_JPRB,0.36098E-01_JPRB,0.35328E-01_JPRB,0.36844E-01_JPRB,0.39952E-01_JPRB, &
 & 0.47291E-01_JPRB,0.56573E-01_JPRB,0.65870E-01_JPRB,0.75177E-01_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.43810E-01_JPRB,0.40500E-01_JPRB,0.37754E-01_JPRB,0.36293E-01_JPRB,0.34676E-01_JPRB, &
 & 0.34367E-01_JPRB,0.37493E-01_JPRB,0.43650E-01_JPRB,0.50087E-01_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.43199E-01_JPRB,0.40018E-01_JPRB,0.37716E-01_JPRB,0.36450E-01_JPRB,0.35395E-01_JPRB, &
 & 0.35866E-01_JPRB,0.40426E-01_JPRB,0.47076E-01_JPRB,0.53958E-01_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.42538E-01_JPRB,0.39757E-01_JPRB,0.37868E-01_JPRB,0.36772E-01_JPRB,0.36302E-01_JPRB, &
 & 0.37914E-01_JPRB,0.44070E-01_JPRB,0.51299E-01_JPRB,0.58670E-01_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.41856E-01_JPRB,0.39457E-01_JPRB,0.37979E-01_JPRB,0.37163E-01_JPRB,0.37947E-01_JPRB, &
 & 0.40970E-01_JPRB,0.48419E-01_JPRB,0.56334E-01_JPRB,0.64404E-01_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.41250E-01_JPRB,0.39154E-01_JPRB,0.38065E-01_JPRB,0.38049E-01_JPRB,0.39929E-01_JPRB, &
 & 0.44658E-01_JPRB,0.53223E-01_JPRB,0.61909E-01_JPRB,0.70665E-01_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.47088E-01_JPRB,0.43589E-01_JPRB,0.40605E-01_JPRB,0.38686E-01_JPRB,0.35713E-01_JPRB, &
 & 0.33942E-01_JPRB,0.34171E-01_JPRB,0.39143E-01_JPRB,0.44787E-01_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.46380E-01_JPRB,0.43081E-01_JPRB,0.40678E-01_JPRB,0.38772E-01_JPRB,0.36271E-01_JPRB, &
 & 0.35115E-01_JPRB,0.36728E-01_JPRB,0.42523E-01_JPRB,0.48625E-01_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.45787E-01_JPRB,0.42889E-01_JPRB,0.40853E-01_JPRB,0.39000E-01_JPRB,0.36901E-01_JPRB, &
 & 0.36794E-01_JPRB,0.40276E-01_JPRB,0.46812E-01_JPRB,0.53448E-01_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.45216E-01_JPRB,0.42628E-01_JPRB,0.40916E-01_JPRB,0.39286E-01_JPRB,0.38129E-01_JPRB, &
 & 0.39329E-01_JPRB,0.44499E-01_JPRB,0.51734E-01_JPRB,0.59041E-01_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.44698E-01_JPRB,0.42312E-01_JPRB,0.40992E-01_JPRB,0.39909E-01_JPRB,0.39896E-01_JPRB, &
 & 0.42322E-01_JPRB,0.49157E-01_JPRB,0.57134E-01_JPRB,0.65206E-01_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.50564E-01_JPRB,0.46864E-01_JPRB,0.43550E-01_JPRB,0.41145E-01_JPRB,0.37282E-01_JPRB, &
 & 0.33847E-01_JPRB,0.31921E-01_JPRB,0.34655E-01_JPRB,0.39581E-01_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.49853E-01_JPRB,0.46324E-01_JPRB,0.43735E-01_JPRB,0.41212E-01_JPRB,0.37826E-01_JPRB, &
 & 0.34760E-01_JPRB,0.33939E-01_JPRB,0.37988E-01_JPRB,0.43340E-01_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.49277E-01_JPRB,0.46142E-01_JPRB,0.43937E-01_JPRB,0.41409E-01_JPRB,0.38245E-01_JPRB, &
 & 0.36079E-01_JPRB,0.36891E-01_JPRB,0.42172E-01_JPRB,0.48104E-01_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.48731E-01_JPRB,0.45921E-01_JPRB,0.43964E-01_JPRB,0.41658E-01_JPRB,0.39073E-01_JPRB, &
 & 0.38270E-01_JPRB,0.40535E-01_JPRB,0.46833E-01_JPRB,0.53415E-01_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.48265E-01_JPRB,0.45648E-01_JPRB,0.43993E-01_JPRB,0.42096E-01_JPRB,0.40473E-01_JPRB, &
 & 0.40846E-01_JPRB,0.44703E-01_JPRB,0.51860E-01_JPRB,0.59120E-01_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.54155E-01_JPRB,0.50312E-01_JPRB,0.46699E-01_JPRB,0.43479E-01_JPRB,0.38935E-01_JPRB, &
 & 0.34460E-01_JPRB,0.30470E-01_JPRB,0.30214E-01_JPRB,0.34389E-01_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.53396E-01_JPRB,0.49741E-01_JPRB,0.46925E-01_JPRB,0.43573E-01_JPRB,0.39485E-01_JPRB, &
 & 0.35160E-01_JPRB,0.32122E-01_JPRB,0.33415E-01_JPRB,0.38087E-01_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.52823E-01_JPRB,0.49548E-01_JPRB,0.47130E-01_JPRB,0.43740E-01_JPRB,0.39828E-01_JPRB, &
 & 0.36044E-01_JPRB,0.34474E-01_JPRB,0.37304E-01_JPRB,0.42510E-01_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.52327E-01_JPRB,0.49384E-01_JPRB,0.47097E-01_JPRB,0.43937E-01_JPRB,0.40452E-01_JPRB, &
 & 0.37736E-01_JPRB,0.37393E-01_JPRB,0.41655E-01_JPRB,0.47452E-01_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.51903E-01_JPRB,0.49131E-01_JPRB,0.47026E-01_JPRB,0.44222E-01_JPRB,0.41687E-01_JPRB, &
 & 0.39818E-01_JPRB,0.40660E-01_JPRB,0.46275E-01_JPRB,0.52724E-01_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.58007E-01_JPRB,0.53733E-01_JPRB,0.49779E-01_JPRB,0.45887E-01_JPRB,0.40462E-01_JPRB, &
 & 0.35176E-01_JPRB,0.29765E-01_JPRB,0.26441E-01_JPRB,0.29320E-01_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.57151E-01_JPRB,0.53110E-01_JPRB,0.50041E-01_JPRB,0.45960E-01_JPRB,0.40973E-01_JPRB, &
 & 0.35887E-01_JPRB,0.31026E-01_JPRB,0.29123E-01_JPRB,0.32803E-01_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.56502E-01_JPRB,0.52846E-01_JPRB,0.50182E-01_JPRB,0.46056E-01_JPRB,0.41337E-01_JPRB, &
 & 0.36666E-01_JPRB,0.32781E-01_JPRB,0.32480E-01_JPRB,0.36858E-01_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.55999E-01_JPRB,0.52671E-01_JPRB,0.50072E-01_JPRB,0.46217E-01_JPRB,0.41835E-01_JPRB, &
 & 0.38000E-01_JPRB,0.35109E-01_JPRB,0.36308E-01_JPRB,0.41318E-01_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.55573E-01_JPRB,0.52382E-01_JPRB,0.49967E-01_JPRB,0.46401E-01_JPRB,0.42955E-01_JPRB, &
 & 0.39677E-01_JPRB,0.37716E-01_JPRB,0.40481E-01_JPRB,0.46095E-01_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.61929E-01_JPRB,0.57176E-01_JPRB,0.52730E-01_JPRB,0.48103E-01_JPRB,0.42015E-01_JPRB, &
 & 0.35869E-01_JPRB,0.29499E-01_JPRB,0.23665E-01_JPRB,0.24549E-01_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.61013E-01_JPRB,0.56553E-01_JPRB,0.52930E-01_JPRB,0.48080E-01_JPRB,0.42522E-01_JPRB, &
 & 0.36573E-01_JPRB,0.30581E-01_JPRB,0.25834E-01_JPRB,0.27791E-01_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.60303E-01_JPRB,0.56131E-01_JPRB,0.52872E-01_JPRB,0.48123E-01_JPRB,0.42911E-01_JPRB, &
 & 0.37343E-01_JPRB,0.31938E-01_JPRB,0.28446E-01_JPRB,0.31375E-01_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.59783E-01_JPRB,0.55843E-01_JPRB,0.52678E-01_JPRB,0.48331E-01_JPRB,0.43398E-01_JPRB, &
 & 0.38468E-01_JPRB,0.33698E-01_JPRB,0.31535E-01_JPRB,0.35398E-01_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.59221E-01_JPRB,0.55525E-01_JPRB,0.52626E-01_JPRB,0.48547E-01_JPRB,0.44309E-01_JPRB, &
 & 0.39969E-01_JPRB,0.35748E-01_JPRB,0.35119E-01_JPRB,0.39791E-01_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.65420E-01_JPRB,0.60290E-01_JPRB,0.55521E-01_JPRB,0.50117E-01_JPRB,0.43421E-01_JPRB, &
 & 0.36608E-01_JPRB,0.29349E-01_JPRB,0.21841E-01_JPRB,0.18774E-01_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.64534E-01_JPRB,0.59710E-01_JPRB,0.55627E-01_JPRB,0.50054E-01_JPRB,0.43842E-01_JPRB, &
 & 0.37357E-01_JPRB,0.30337E-01_JPRB,0.23525E-01_JPRB,0.22756E-01_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.63805E-01_JPRB,0.59237E-01_JPRB,0.55452E-01_JPRB,0.50019E-01_JPRB,0.44319E-01_JPRB, &
 & 0.38089E-01_JPRB,0.31491E-01_JPRB,0.25524E-01_JPRB,0.26401E-01_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.63315E-01_JPRB,0.59001E-01_JPRB,0.55252E-01_JPRB,0.50261E-01_JPRB,0.44802E-01_JPRB, &
 & 0.39006E-01_JPRB,0.32915E-01_JPRB,0.27972E-01_JPRB,0.30021E-01_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.62781E-01_JPRB,0.58825E-01_JPRB,0.55257E-01_JPRB,0.50524E-01_JPRB,0.45567E-01_JPRB, &
 & 0.40297E-01_JPRB,0.34643E-01_JPRB,0.30888E-01_JPRB,0.34021E-01_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.68132E-01_JPRB,0.62682E-01_JPRB,0.57743E-01_JPRB,0.51836E-01_JPRB,0.44670E-01_JPRB, &
 & 0.37300E-01_JPRB,0.29365E-01_JPRB,0.20724E-01_JPRB,0.15957E-01_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.67210E-01_JPRB,0.62151E-01_JPRB,0.57960E-01_JPRB,0.51867E-01_JPRB,0.45128E-01_JPRB, &
 & 0.38064E-01_JPRB,0.30245E-01_JPRB,0.22146E-01_JPRB,0.17704E-01_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.66632E-01_JPRB,0.61949E-01_JPRB,0.57882E-01_JPRB,0.51878E-01_JPRB,0.45637E-01_JPRB, &
 & 0.38758E-01_JPRB,0.31283E-01_JPRB,0.23744E-01_JPRB,0.20098E-01_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.66350E-01_JPRB,0.62044E-01_JPRB,0.57835E-01_JPRB,0.52180E-01_JPRB,0.46090E-01_JPRB, &
 & 0.39573E-01_JPRB,0.32509E-01_JPRB,0.25642E-01_JPRB,0.22076E-01_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.65965E-01_JPRB,0.62105E-01_JPRB,0.57959E-01_JPRB,0.52489E-01_JPRB,0.46765E-01_JPRB, &
 & 0.40717E-01_JPRB,0.34057E-01_JPRB,0.28015E-01_JPRB,0.24829E-01_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.69905E-01_JPRB,0.64410E-01_JPRB,0.59589E-01_JPRB,0.53150E-01_JPRB,0.45760E-01_JPRB, &
 & 0.38179E-01_JPRB,0.29785E-01_JPRB,0.20444E-01_JPRB,0.16092E-01_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.69271E-01_JPRB,0.64175E-01_JPRB,0.59782E-01_JPRB,0.53281E-01_JPRB,0.46486E-01_JPRB, &
 & 0.38949E-01_JPRB,0.30645E-01_JPRB,0.21725E-01_JPRB,0.17857E-01_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.69073E-01_JPRB,0.64491E-01_JPRB,0.59955E-01_JPRB,0.53684E-01_JPRB,0.46981E-01_JPRB, &
 & 0.39609E-01_JPRB,0.31674E-01_JPRB,0.23165E-01_JPRB,0.20394E-01_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.68904E-01_JPRB,0.64793E-01_JPRB,0.60179E-01_JPRB,0.54162E-01_JPRB,0.47530E-01_JPRB, &
 & 0.40495E-01_JPRB,0.32809E-01_JPRB,0.24930E-01_JPRB,0.23016E-01_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.68639E-01_JPRB,0.65010E-01_JPRB,0.60484E-01_JPRB,0.54605E-01_JPRB,0.48370E-01_JPRB, &
 & 0.41561E-01_JPRB,0.34350E-01_JPRB,0.26933E-01_JPRB,0.26488E-01_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.71529E-01_JPRB,0.66044E-01_JPRB,0.61072E-01_JPRB,0.54140E-01_JPRB,0.46654E-01_JPRB, &
 & 0.38794E-01_JPRB,0.29996E-01_JPRB,0.20236E-01_JPRB,0.16124E-01_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.71291E-01_JPRB,0.66315E-01_JPRB,0.61418E-01_JPRB,0.54500E-01_JPRB,0.47446E-01_JPRB, &
 & 0.39590E-01_JPRB,0.30905E-01_JPRB,0.21401E-01_JPRB,0.17542E-01_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.71222E-01_JPRB,0.66826E-01_JPRB,0.61770E-01_JPRB,0.55219E-01_JPRB,0.48148E-01_JPRB, &
 & 0.40334E-01_JPRB,0.31908E-01_JPRB,0.22727E-01_JPRB,0.19804E-01_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.71079E-01_JPRB,0.67236E-01_JPRB,0.62161E-01_JPRB,0.55849E-01_JPRB,0.48917E-01_JPRB, &
 & 0.41311E-01_JPRB,0.33042E-01_JPRB,0.24356E-01_JPRB,0.21082E-01_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.70901E-01_JPRB,0.67518E-01_JPRB,0.62549E-01_JPRB,0.56439E-01_JPRB,0.49900E-01_JPRB, &
 & 0.42406E-01_JPRB,0.34548E-01_JPRB,0.26106E-01_JPRB,0.23666E-01_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.73149E-01_JPRB,0.67708E-01_JPRB,0.62294E-01_JPRB,0.54947E-01_JPRB,0.47337E-01_JPRB, &
 & 0.39165E-01_JPRB,0.30053E-01_JPRB,0.20069E-01_JPRB,0.15304E-01_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.73122E-01_JPRB,0.68287E-01_JPRB,0.62803E-01_JPRB,0.55664E-01_JPRB,0.48241E-01_JPRB, &
 & 0.39986E-01_JPRB,0.31044E-01_JPRB,0.21133E-01_JPRB,0.17384E-01_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.73057E-01_JPRB,0.68826E-01_JPRB,0.63303E-01_JPRB,0.56536E-01_JPRB,0.49104E-01_JPRB, &
 & 0.40926E-01_JPRB,0.32050E-01_JPRB,0.22349E-01_JPRB,0.18964E-01_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.73037E-01_JPRB,0.69286E-01_JPRB,0.63846E-01_JPRB,0.57252E-01_JPRB,0.50018E-01_JPRB, &
 & 0.42025E-01_JPRB,0.33217E-01_JPRB,0.23850E-01_JPRB,0.20572E-01_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.73013E-01_JPRB,0.69604E-01_JPRB,0.64290E-01_JPRB,0.57954E-01_JPRB,0.51076E-01_JPRB, &
 & 0.43212E-01_JPRB,0.34653E-01_JPRB,0.25391E-01_JPRB,0.23448E-01_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.43248E-01_JPRB,0.41017E-01_JPRB,0.40213E-01_JPRB,0.39821E-01_JPRB,0.45256E-01_JPRB, &
 & 0.55821E-01_JPRB,0.66932E-01_JPRB,0.78037E-01_JPRB,0.88086E-01_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.42407E-01_JPRB,0.40307E-01_JPRB,0.40078E-01_JPRB,0.40681E-01_JPRB,0.47543E-01_JPRB, &
 & 0.59099E-01_JPRB,0.70845E-01_JPRB,0.82585E-01_JPRB,0.93228E-01_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.41692E-01_JPRB,0.39727E-01_JPRB,0.39865E-01_JPRB,0.41830E-01_JPRB,0.50093E-01_JPRB, &
 & 0.62450E-01_JPRB,0.74841E-01_JPRB,0.87232E-01_JPRB,0.98476E-01_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.41002E-01_JPRB,0.39248E-01_JPRB,0.39945E-01_JPRB,0.42942E-01_JPRB,0.52768E-01_JPRB, &
 & 0.65829E-01_JPRB,0.78890E-01_JPRB,0.91937E-01_JPRB,0.10362E+00_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.40428E-01_JPRB,0.39045E-01_JPRB,0.40116E-01_JPRB,0.44981E-01_JPRB,0.56655E-01_JPRB, &
 & 0.70681E-01_JPRB,0.84705E-01_JPRB,0.98731E-01_JPRB,0.11111E+00_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.47227E-01_JPRB,0.44198E-01_JPRB,0.42698E-01_JPRB,0.42511E-01_JPRB,0.46394E-01_JPRB, &
 & 0.55784E-01_JPRB,0.66888E-01_JPRB,0.77989E-01_JPRB,0.88812E-01_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.46375E-01_JPRB,0.43473E-01_JPRB,0.42428E-01_JPRB,0.43299E-01_JPRB,0.48252E-01_JPRB, &
 & 0.59000E-01_JPRB,0.70708E-01_JPRB,0.82423E-01_JPRB,0.93885E-01_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.45650E-01_JPRB,0.42988E-01_JPRB,0.42307E-01_JPRB,0.44252E-01_JPRB,0.50414E-01_JPRB, &
 & 0.62373E-01_JPRB,0.74750E-01_JPRB,0.87127E-01_JPRB,0.99197E-01_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.44980E-01_JPRB,0.42686E-01_JPRB,0.42476E-01_JPRB,0.45355E-01_JPRB,0.53027E-01_JPRB, &
 & 0.66067E-01_JPRB,0.79179E-01_JPRB,0.92288E-01_JPRB,0.10480E+00_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.44383E-01_JPRB,0.42475E-01_JPRB,0.42723E-01_JPRB,0.47155E-01_JPRB,0.57007E-01_JPRB, &
 & 0.71138E-01_JPRB,0.85276E-01_JPRB,0.99396E-01_JPRB,0.11272E+00_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.51829E-01_JPRB,0.48303E-01_JPRB,0.45805E-01_JPRB,0.45348E-01_JPRB,0.47474E-01_JPRB, &
 & 0.53773E-01_JPRB,0.64381E-01_JPRB,0.75065E-01_JPRB,0.85879E-01_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.50945E-01_JPRB,0.47626E-01_JPRB,0.45531E-01_JPRB,0.46104E-01_JPRB,0.48805E-01_JPRB, &
 & 0.57008E-01_JPRB,0.68342E-01_JPRB,0.79675E-01_JPRB,0.91103E-01_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.50329E-01_JPRB,0.47163E-01_JPRB,0.45393E-01_JPRB,0.46795E-01_JPRB,0.50514E-01_JPRB, &
 & 0.60488E-01_JPRB,0.72503E-01_JPRB,0.84519E-01_JPRB,0.96625E-01_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.49725E-01_JPRB,0.46894E-01_JPRB,0.45600E-01_JPRB,0.47784E-01_JPRB,0.52670E-01_JPRB, &
 & 0.64382E-01_JPRB,0.77172E-01_JPRB,0.89966E-01_JPRB,0.10271E+00_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.49109E-01_JPRB,0.46633E-01_JPRB,0.45896E-01_JPRB,0.49191E-01_JPRB,0.56129E-01_JPRB, &
 & 0.69438E-01_JPRB,0.83245E-01_JPRB,0.97061E-01_JPRB,0.11071E+00_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.57082E-01_JPRB,0.53110E-01_JPRB,0.49763E-01_JPRB,0.48460E-01_JPRB,0.48719E-01_JPRB, &
 & 0.51181E-01_JPRB,0.59984E-01_JPRB,0.69952E-01_JPRB,0.80045E-01_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.56133E-01_JPRB,0.52450E-01_JPRB,0.49568E-01_JPRB,0.49064E-01_JPRB,0.49725E-01_JPRB, &
 & 0.54041E-01_JPRB,0.64091E-01_JPRB,0.74728E-01_JPRB,0.85496E-01_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.55439E-01_JPRB,0.51866E-01_JPRB,0.49497E-01_JPRB,0.49475E-01_JPRB,0.51076E-01_JPRB, &
 & 0.57243E-01_JPRB,0.68327E-01_JPRB,0.79652E-01_JPRB,0.91098E-01_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.54777E-01_JPRB,0.51575E-01_JPRB,0.49681E-01_JPRB,0.50221E-01_JPRB,0.52765E-01_JPRB, &
 & 0.61084E-01_JPRB,0.73197E-01_JPRB,0.85337E-01_JPRB,0.97552E-01_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.54098E-01_JPRB,0.51233E-01_JPRB,0.49878E-01_JPRB,0.51295E-01_JPRB,0.55484E-01_JPRB, &
 & 0.66162E-01_JPRB,0.79298E-01_JPRB,0.92434E-01_JPRB,0.10558E+00_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.62544E-01_JPRB,0.58281E-01_JPRB,0.54351E-01_JPRB,0.52107E-01_JPRB,0.50211E-01_JPRB, &
 & 0.49416E-01_JPRB,0.54519E-01_JPRB,0.63528E-01_JPRB,0.72634E-01_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.61658E-01_JPRB,0.57644E-01_JPRB,0.54210E-01_JPRB,0.52563E-01_JPRB,0.50949E-01_JPRB, &
 & 0.51794E-01_JPRB,0.58802E-01_JPRB,0.68560E-01_JPRB,0.78383E-01_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.60918E-01_JPRB,0.57016E-01_JPRB,0.54117E-01_JPRB,0.52719E-01_JPRB,0.52074E-01_JPRB, &
 & 0.54457E-01_JPRB,0.63161E-01_JPRB,0.73629E-01_JPRB,0.84158E-01_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.60164E-01_JPRB,0.56692E-01_JPRB,0.54302E-01_JPRB,0.53086E-01_JPRB,0.53404E-01_JPRB, &
 & 0.57689E-01_JPRB,0.68126E-01_JPRB,0.79422E-01_JPRB,0.90757E-01_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.59366E-01_JPRB,0.56267E-01_JPRB,0.54377E-01_JPRB,0.53811E-01_JPRB,0.55627E-01_JPRB, &
 & 0.62331E-01_JPRB,0.74295E-01_JPRB,0.86596E-01_JPRB,0.98923E-01_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.68500E-01_JPRB,0.63504E-01_JPRB,0.59102E-01_JPRB,0.56112E-01_JPRB,0.52198E-01_JPRB, &
 & 0.48725E-01_JPRB,0.49458E-01_JPRB,0.56540E-01_JPRB,0.64611E-01_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.67642E-01_JPRB,0.62951E-01_JPRB,0.59010E-01_JPRB,0.56509E-01_JPRB,0.52640E-01_JPRB, &
 & 0.50781E-01_JPRB,0.53492E-01_JPRB,0.61845E-01_JPRB,0.70650E-01_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.66730E-01_JPRB,0.62270E-01_JPRB,0.58880E-01_JPRB,0.56541E-01_JPRB,0.53578E-01_JPRB, &
 & 0.52912E-01_JPRB,0.57553E-01_JPRB,0.66900E-01_JPRB,0.76420E-01_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.65853E-01_JPRB,0.61851E-01_JPRB,0.59079E-01_JPRB,0.56674E-01_JPRB,0.54628E-01_JPRB, &
 & 0.55405E-01_JPRB,0.62327E-01_JPRB,0.72621E-01_JPRB,0.82946E-01_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.64917E-01_JPRB,0.61395E-01_JPRB,0.59088E-01_JPRB,0.57140E-01_JPRB,0.56317E-01_JPRB, &
 & 0.59242E-01_JPRB,0.68519E-01_JPRB,0.79819E-01_JPRB,0.91147E-01_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.74814E-01_JPRB,0.69115E-01_JPRB,0.63783E-01_JPRB,0.59970E-01_JPRB,0.54833E-01_JPRB, &
 & 0.49011E-01_JPRB,0.46051E-01_JPRB,0.49756E-01_JPRB,0.56816E-01_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.73755E-01_JPRB,0.68509E-01_JPRB,0.63672E-01_JPRB,0.60441E-01_JPRB,0.55205E-01_JPRB, &
 & 0.50759E-01_JPRB,0.49447E-01_JPRB,0.55044E-01_JPRB,0.62843E-01_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.72664E-01_JPRB,0.67698E-01_JPRB,0.63630E-01_JPRB,0.60499E-01_JPRB,0.55993E-01_JPRB, &
 & 0.52467E-01_JPRB,0.52809E-01_JPRB,0.59966E-01_JPRB,0.68463E-01_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.71633E-01_JPRB,0.67174E-01_JPRB,0.63866E-01_JPRB,0.60581E-01_JPRB,0.56744E-01_JPRB, &
 & 0.54377E-01_JPRB,0.56941E-01_JPRB,0.65640E-01_JPRB,0.74923E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART9',0,ZHOOK_HANDLE)


KA(:, 5, 7,12) = (/ &
 & 0.70621E-01_JPRB,0.66745E-01_JPRB,0.63972E-01_JPRB,0.60930E-01_JPRB,0.57801E-01_JPRB, &
 & 0.57488E-01_JPRB,0.62631E-01_JPRB,0.72711E-01_JPRB,0.82984E-01_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.81108E-01_JPRB,0.74731E-01_JPRB,0.68669E-01_JPRB,0.63699E-01_JPRB,0.57482E-01_JPRB, &
 & 0.50207E-01_JPRB,0.44226E-01_JPRB,0.43565E-01_JPRB,0.49479E-01_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.79714E-01_JPRB,0.73898E-01_JPRB,0.68659E-01_JPRB,0.64276E-01_JPRB,0.57881E-01_JPRB, &
 & 0.51786E-01_JPRB,0.46974E-01_JPRB,0.48378E-01_JPRB,0.55162E-01_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.78456E-01_JPRB,0.73135E-01_JPRB,0.68758E-01_JPRB,0.64370E-01_JPRB,0.58662E-01_JPRB, &
 & 0.53164E-01_JPRB,0.49684E-01_JPRB,0.53168E-01_JPRB,0.60666E-01_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.77309E-01_JPRB,0.72680E-01_JPRB,0.69000E-01_JPRB,0.64433E-01_JPRB,0.59353E-01_JPRB, &
 & 0.54540E-01_JPRB,0.53042E-01_JPRB,0.58717E-01_JPRB,0.66992E-01_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.76406E-01_JPRB,0.72288E-01_JPRB,0.69084E-01_JPRB,0.64775E-01_JPRB,0.60105E-01_JPRB, &
 & 0.56876E-01_JPRB,0.57740E-01_JPRB,0.65467E-01_JPRB,0.74695E-01_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.87281E-01_JPRB,0.80336E-01_JPRB,0.73586E-01_JPRB,0.67589E-01_JPRB,0.60164E-01_JPRB, &
 & 0.51553E-01_JPRB,0.43512E-01_JPRB,0.38366E-01_JPRB,0.42260E-01_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.85638E-01_JPRB,0.79229E-01_JPRB,0.73710E-01_JPRB,0.68169E-01_JPRB,0.60640E-01_JPRB, &
 & 0.53028E-01_JPRB,0.45744E-01_JPRB,0.42413E-01_JPRB,0.47570E-01_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.84292E-01_JPRB,0.78481E-01_JPRB,0.73900E-01_JPRB,0.68269E-01_JPRB,0.61342E-01_JPRB, &
 & 0.54381E-01_JPRB,0.47902E-01_JPRB,0.46760E-01_JPRB,0.52980E-01_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.83115E-01_JPRB,0.77996E-01_JPRB,0.74142E-01_JPRB,0.68304E-01_JPRB,0.62073E-01_JPRB, &
 & 0.55597E-01_JPRB,0.50525E-01_JPRB,0.51779E-01_JPRB,0.58954E-01_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.82186E-01_JPRB,0.77706E-01_JPRB,0.74161E-01_JPRB,0.68663E-01_JPRB,0.62685E-01_JPRB, &
 & 0.57315E-01_JPRB,0.54189E-01_JPRB,0.58003E-01_JPRB,0.66142E-01_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.93285E-01_JPRB,0.85813E-01_JPRB,0.78575E-01_JPRB,0.71552E-01_JPRB,0.62937E-01_JPRB, &
 & 0.53130E-01_JPRB,0.43544E-01_JPRB,0.34852E-01_JPRB,0.25971E-01_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.91673E-01_JPRB,0.84652E-01_JPRB,0.78625E-01_JPRB,0.72093E-01_JPRB,0.63376E-01_JPRB, &
 & 0.54541E-01_JPRB,0.45576E-01_JPRB,0.38102E-01_JPRB,0.28356E-01_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.90273E-01_JPRB,0.83828E-01_JPRB,0.78840E-01_JPRB,0.72190E-01_JPRB,0.64026E-01_JPRB, &
 & 0.55889E-01_JPRB,0.47404E-01_JPRB,0.41695E-01_JPRB,0.31456E-01_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.88982E-01_JPRB,0.83233E-01_JPRB,0.79026E-01_JPRB,0.72231E-01_JPRB,0.64765E-01_JPRB, &
 & 0.57025E-01_JPRB,0.49463E-01_JPRB,0.46003E-01_JPRB,0.35501E-01_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.88015E-01_JPRB,0.82954E-01_JPRB,0.78987E-01_JPRB,0.72605E-01_JPRB,0.65378E-01_JPRB, &
 & 0.58432E-01_JPRB,0.52293E-01_JPRB,0.51371E-01_JPRB,0.39951E-01_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.98224E-01_JPRB,0.90470E-01_JPRB,0.83283E-01_JPRB,0.75729E-01_JPRB,0.65953E-01_JPRB, &
 & 0.55333E-01_JPRB,0.44607E-01_JPRB,0.33712E-01_JPRB,0.29825E-01_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.96868E-01_JPRB,0.89565E-01_JPRB,0.83537E-01_JPRB,0.76001E-01_JPRB,0.66302E-01_JPRB, &
 & 0.56711E-01_JPRB,0.46387E-01_JPRB,0.36339E-01_JPRB,0.33228E-01_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.95464E-01_JPRB,0.88759E-01_JPRB,0.83774E-01_JPRB,0.75894E-01_JPRB,0.67115E-01_JPRB, &
 & 0.57847E-01_JPRB,0.48034E-01_JPRB,0.39456E-01_JPRB,0.36088E-01_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.94340E-01_JPRB,0.88366E-01_JPRB,0.83721E-01_JPRB,0.76044E-01_JPRB,0.67766E-01_JPRB, &
 & 0.58947E-01_JPRB,0.50010E-01_JPRB,0.43247E-01_JPRB,0.40125E-01_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.93518E-01_JPRB,0.88039E-01_JPRB,0.83475E-01_JPRB,0.76422E-01_JPRB,0.68414E-01_JPRB, &
 & 0.60495E-01_JPRB,0.52431E-01_JPRB,0.48069E-01_JPRB,0.44798E-01_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.10275E+00_JPRB,0.94729E-01_JPRB,0.87688E-01_JPRB,0.79394E-01_JPRB,0.68734E-01_JPRB, &
 & 0.57476E-01_JPRB,0.45697E-01_JPRB,0.32943E-01_JPRB,0.29614E-01_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.10159E+00_JPRB,0.94167E-01_JPRB,0.88202E-01_JPRB,0.79488E-01_JPRB,0.69232E-01_JPRB, &
 & 0.58694E-01_JPRB,0.47208E-01_JPRB,0.35215E-01_JPRB,0.33437E-01_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.10046E+00_JPRB,0.93671E-01_JPRB,0.88347E-01_JPRB,0.79409E-01_JPRB,0.69985E-01_JPRB, &
 & 0.59703E-01_JPRB,0.48739E-01_JPRB,0.37920E-01_JPRB,0.36670E-01_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.99712E-01_JPRB,0.93473E-01_JPRB,0.88135E-01_JPRB,0.79671E-01_JPRB,0.70541E-01_JPRB, &
 & 0.60786E-01_JPRB,0.50658E-01_JPRB,0.41158E-01_JPRB,0.41155E-01_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.99052E-01_JPRB,0.93236E-01_JPRB,0.87897E-01_JPRB,0.79933E-01_JPRB,0.71310E-01_JPRB, &
 & 0.62364E-01_JPRB,0.52850E-01_JPRB,0.45390E-01_JPRB,0.47055E-01_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.10693E+00_JPRB,0.98594E-01_JPRB,0.91730E-01_JPRB,0.82575E-01_JPRB,0.71131E-01_JPRB, &
 & 0.59390E-01_JPRB,0.46621E-01_JPRB,0.32428E-01_JPRB,0.26794E-01_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.10593E+00_JPRB,0.98329E-01_JPRB,0.92368E-01_JPRB,0.82651E-01_JPRB,0.71827E-01_JPRB, &
 & 0.60538E-01_JPRB,0.47868E-01_JPRB,0.34468E-01_JPRB,0.29114E-01_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.10521E+00_JPRB,0.98305E-01_JPRB,0.92444E-01_JPRB,0.82725E-01_JPRB,0.72549E-01_JPRB, &
 & 0.61456E-01_JPRB,0.49349E-01_JPRB,0.36800E-01_JPRB,0.32781E-01_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.10471E+00_JPRB,0.98393E-01_JPRB,0.92240E-01_JPRB,0.83082E-01_JPRB,0.73117E-01_JPRB, &
 & 0.62504E-01_JPRB,0.51152E-01_JPRB,0.39616E-01_JPRB,0.37780E-01_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.10409E+00_JPRB,0.98364E-01_JPRB,0.92131E-01_JPRB,0.83350E-01_JPRB,0.73995E-01_JPRB, &
 & 0.64047E-01_JPRB,0.53327E-01_JPRB,0.43375E-01_JPRB,0.42285E-01_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.52810E-01_JPRB,0.49450E-01_JPRB,0.49647E-01_JPRB,0.57104E-01_JPRB,0.73433E-01_JPRB, &
 & 0.91743E-01_JPRB,0.11005E+00_JPRB,0.12834E+00_JPRB,0.14491E+00_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.51653E-01_JPRB,0.48971E-01_JPRB,0.50186E-01_JPRB,0.59440E-01_JPRB,0.77723E-01_JPRB, &
 & 0.97098E-01_JPRB,0.11647E+00_JPRB,0.13583E+00_JPRB,0.15375E+00_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.50696E-01_JPRB,0.48582E-01_JPRB,0.50737E-01_JPRB,0.61667E-01_JPRB,0.81568E-01_JPRB, &
 & 0.10190E+00_JPRB,0.12223E+00_JPRB,0.14254E+00_JPRB,0.16133E+00_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.49759E-01_JPRB,0.48321E-01_JPRB,0.51484E-01_JPRB,0.64441E-01_JPRB,0.85673E-01_JPRB, &
 & 0.10703E+00_JPRB,0.12837E+00_JPRB,0.14971E+00_JPRB,0.16936E+00_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.48804E-01_JPRB,0.48067E-01_JPRB,0.52560E-01_JPRB,0.67354E-01_JPRB,0.89656E-01_JPRB, &
 & 0.11200E+00_JPRB,0.13434E+00_JPRB,0.15666E+00_JPRB,0.17718E+00_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.57042E-01_JPRB,0.54069E-01_JPRB,0.53905E-01_JPRB,0.58729E-01_JPRB,0.73592E-01_JPRB, &
 & 0.91941E-01_JPRB,0.11029E+00_JPRB,0.12863E+00_JPRB,0.14602E+00_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.55841E-01_JPRB,0.53550E-01_JPRB,0.54566E-01_JPRB,0.60781E-01_JPRB,0.78168E-01_JPRB, &
 & 0.97652E-01_JPRB,0.11714E+00_JPRB,0.13661E+00_JPRB,0.15506E+00_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.54920E-01_JPRB,0.52981E-01_JPRB,0.54943E-01_JPRB,0.62919E-01_JPRB,0.82379E-01_JPRB, &
 & 0.10292E+00_JPRB,0.12345E+00_JPRB,0.14397E+00_JPRB,0.16344E+00_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.54055E-01_JPRB,0.52591E-01_JPRB,0.55488E-01_JPRB,0.65511E-01_JPRB,0.86681E-01_JPRB, &
 & 0.10829E+00_JPRB,0.12990E+00_JPRB,0.15147E+00_JPRB,0.17196E+00_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.53226E-01_JPRB,0.52334E-01_JPRB,0.56238E-01_JPRB,0.68429E-01_JPRB,0.90830E-01_JPRB, &
 & 0.11345E+00_JPRB,0.13607E+00_JPRB,0.15868E+00_JPRB,0.17998E+00_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.62670E-01_JPRB,0.59309E-01_JPRB,0.58772E-01_JPRB,0.61122E-01_JPRB,0.72960E-01_JPRB, &
 & 0.91113E-01_JPRB,0.10930E+00_JPRB,0.12747E+00_JPRB,0.14514E+00_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.61411E-01_JPRB,0.58632E-01_JPRB,0.59230E-01_JPRB,0.62688E-01_JPRB,0.77748E-01_JPRB, &
 & 0.97139E-01_JPRB,0.11652E+00_JPRB,0.13590E+00_JPRB,0.15479E+00_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.60334E-01_JPRB,0.57923E-01_JPRB,0.59411E-01_JPRB,0.64539E-01_JPRB,0.82093E-01_JPRB, &
 & 0.10257E+00_JPRB,0.12305E+00_JPRB,0.14350E+00_JPRB,0.16343E+00_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.59451E-01_JPRB,0.57416E-01_JPRB,0.59633E-01_JPRB,0.66820E-01_JPRB,0.86494E-01_JPRB, &
 & 0.10804E+00_JPRB,0.12960E+00_JPRB,0.15112E+00_JPRB,0.17209E+00_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.58597E-01_JPRB,0.57143E-01_JPRB,0.60240E-01_JPRB,0.69594E-01_JPRB,0.91059E-01_JPRB, &
 & 0.11373E+00_JPRB,0.13640E+00_JPRB,0.15905E+00_JPRB,0.18103E+00_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.69822E-01_JPRB,0.65601E-01_JPRB,0.63945E-01_JPRB,0.64755E-01_JPRB,0.73038E-01_JPRB, &
 & 0.90165E-01_JPRB,0.10817E+00_JPRB,0.12616E+00_JPRB,0.14389E+00_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.68507E-01_JPRB,0.64727E-01_JPRB,0.64234E-01_JPRB,0.66213E-01_JPRB,0.77749E-01_JPRB, &
 & 0.96668E-01_JPRB,0.11597E+00_JPRB,0.13524E+00_JPRB,0.15427E+00_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.67276E-01_JPRB,0.63962E-01_JPRB,0.64238E-01_JPRB,0.67909E-01_JPRB,0.82185E-01_JPRB, &
 & 0.10254E+00_JPRB,0.12301E+00_JPRB,0.14345E+00_JPRB,0.16365E+00_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.66381E-01_JPRB,0.63334E-01_JPRB,0.64220E-01_JPRB,0.69770E-01_JPRB,0.86724E-01_JPRB, &
 & 0.10832E+00_JPRB,0.12994E+00_JPRB,0.15151E+00_JPRB,0.17282E+00_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.65437E-01_JPRB,0.62972E-01_JPRB,0.64673E-01_JPRB,0.72222E-01_JPRB,0.91630E-01_JPRB, &
 & 0.11445E+00_JPRB,0.13728E+00_JPRB,0.16006E+00_JPRB,0.18257E+00_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.78344E-01_JPRB,0.73091E-01_JPRB,0.69713E-01_JPRB,0.69214E-01_JPRB,0.74668E-01_JPRB, &
 & 0.88915E-01_JPRB,0.10667E+00_JPRB,0.12441E+00_JPRB,0.14209E+00_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.76773E-01_JPRB,0.71981E-01_JPRB,0.69752E-01_JPRB,0.70736E-01_JPRB,0.78904E-01_JPRB, &
 & 0.95797E-01_JPRB,0.11493E+00_JPRB,0.13406E+00_JPRB,0.15311E+00_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.75310E-01_JPRB,0.71068E-01_JPRB,0.69651E-01_JPRB,0.72503E-01_JPRB,0.83070E-01_JPRB, &
 & 0.10214E+00_JPRB,0.12251E+00_JPRB,0.14289E+00_JPRB,0.16320E+00_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.74250E-01_JPRB,0.70202E-01_JPRB,0.69499E-01_JPRB,0.74333E-01_JPRB,0.87301E-01_JPRB, &
 & 0.10818E+00_JPRB,0.12976E+00_JPRB,0.15132E+00_JPRB,0.17281E+00_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.73209E-01_JPRB,0.69739E-01_JPRB,0.69847E-01_JPRB,0.76315E-01_JPRB,0.91870E-01_JPRB, &
 & 0.11438E+00_JPRB,0.13720E+00_JPRB,0.16000E+00_JPRB,0.18274E+00_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.87696E-01_JPRB,0.81522E-01_JPRB,0.76509E-01_JPRB,0.74345E-01_JPRB,0.77107E-01_JPRB, &
 & 0.86456E-01_JPRB,0.10266E+00_JPRB,0.11975E+00_JPRB,0.13684E+00_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.85834E-01_JPRB,0.80104E-01_JPRB,0.76319E-01_JPRB,0.75879E-01_JPRB,0.80970E-01_JPRB, &
 & 0.93234E-01_JPRB,0.11135E+00_JPRB,0.12988E+00_JPRB,0.14843E+00_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.84103E-01_JPRB,0.79034E-01_JPRB,0.76204E-01_JPRB,0.77685E-01_JPRB,0.84459E-01_JPRB, &
 & 0.99600E-01_JPRB,0.11936E+00_JPRB,0.13921E+00_JPRB,0.15907E+00_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.82699E-01_JPRB,0.78102E-01_JPRB,0.75915E-01_JPRB,0.79277E-01_JPRB,0.87923E-01_JPRB, &
 & 0.10572E+00_JPRB,0.12681E+00_JPRB,0.14791E+00_JPRB,0.16901E+00_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.81604E-01_JPRB,0.77529E-01_JPRB,0.76175E-01_JPRB,0.80727E-01_JPRB,0.91640E-01_JPRB, &
 & 0.11182E+00_JPRB,0.13414E+00_JPRB,0.15644E+00_JPRB,0.17875E+00_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.97322E-01_JPRB,0.90329E-01_JPRB,0.84313E-01_JPRB,0.80452E-01_JPRB,0.80118E-01_JPRB, &
 & 0.84204E-01_JPRB,0.96138E-01_JPRB,0.11212E+00_JPRB,0.12812E+00_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.95378E-01_JPRB,0.88856E-01_JPRB,0.83999E-01_JPRB,0.81744E-01_JPRB,0.83529E-01_JPRB, &
 & 0.90072E-01_JPRB,0.10504E+00_JPRB,0.12254E+00_JPRB,0.14003E+00_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.93471E-01_JPRB,0.87725E-01_JPRB,0.83968E-01_JPRB,0.83424E-01_JPRB,0.86362E-01_JPRB, &
 & 0.95913E-01_JPRB,0.11338E+00_JPRB,0.13227E+00_JPRB,0.15114E+00_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.91861E-01_JPRB,0.86679E-01_JPRB,0.83638E-01_JPRB,0.84829E-01_JPRB,0.89126E-01_JPRB, &
 & 0.10167E+00_JPRB,0.12111E+00_JPRB,0.14127E+00_JPRB,0.16142E+00_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.90669E-01_JPRB,0.86079E-01_JPRB,0.83677E-01_JPRB,0.85955E-01_JPRB,0.92165E-01_JPRB, &
 & 0.10751E+00_JPRB,0.12862E+00_JPRB,0.15005E+00_JPRB,0.17145E+00_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.10748E+00_JPRB,0.99760E-01_JPRB,0.92641E-01_JPRB,0.87386E-01_JPRB,0.83918E-01_JPRB, &
 & 0.82807E-01_JPRB,0.88461E-01_JPRB,0.10199E+00_JPRB,0.11655E+00_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.10548E+00_JPRB,0.98347E-01_JPRB,0.92153E-01_JPRB,0.88724E-01_JPRB,0.86807E-01_JPRB, &
 & 0.87435E-01_JPRB,0.96918E-01_JPRB,0.11262E+00_JPRB,0.12866E+00_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.10345E+00_JPRB,0.96941E-01_JPRB,0.92269E-01_JPRB,0.90148E-01_JPRB,0.89023E-01_JPRB, &
 & 0.92390E-01_JPRB,0.10517E+00_JPRB,0.12260E+00_JPRB,0.14006E+00_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.10168E+00_JPRB,0.95648E-01_JPRB,0.92050E-01_JPRB,0.91217E-01_JPRB,0.91169E-01_JPRB, &
 & 0.97530E-01_JPRB,0.11302E+00_JPRB,0.13185E+00_JPRB,0.15061E+00_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.10031E+00_JPRB,0.94918E-01_JPRB,0.92030E-01_JPRB,0.91944E-01_JPRB,0.93599E-01_JPRB, &
 & 0.10280E+00_JPRB,0.12083E+00_JPRB,0.14095E+00_JPRB,0.16101E+00_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.11850E+00_JPRB,0.10963E+00_JPRB,0.10118E+00_JPRB,0.94592E-01_JPRB,0.88496E-01_JPRB, &
 & 0.82777E-01_JPRB,0.81368E-01_JPRB,0.90482E-01_JPRB,0.10334E+00_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.11636E+00_JPRB,0.10836E+00_JPRB,0.10080E+00_JPRB,0.96151E-01_JPRB,0.90961E-01_JPRB, &
 & 0.86437E-01_JPRB,0.88759E-01_JPRB,0.10103E+00_JPRB,0.11540E+00_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.11416E+00_JPRB,0.10675E+00_JPRB,0.10109E+00_JPRB,0.97591E-01_JPRB,0.92676E-01_JPRB, &
 & 0.90148E-01_JPRB,0.96288E-01_JPRB,0.11094E+00_JPRB,0.12669E+00_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.11214E+00_JPRB,0.10527E+00_JPRB,0.10096E+00_JPRB,0.98437E-01_JPRB,0.94256E-01_JPRB, &
 & 0.94326E-01_JPRB,0.10386E+00_JPRB,0.12050E+00_JPRB,0.13763E+00_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.11054E+00_JPRB,0.10425E+00_JPRB,0.10085E+00_JPRB,0.98717E-01_JPRB,0.96200E-01_JPRB, &
 & 0.98935E-01_JPRB,0.11173E+00_JPRB,0.13010E+00_JPRB,0.14859E+00_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.13016E+00_JPRB,0.11986E+00_JPRB,0.10995E+00_JPRB,0.10196E+00_JPRB,0.93774E-01_JPRB, &
 & 0.84360E-01_JPRB,0.76878E-01_JPRB,0.79680E-01_JPRB,0.67359E-01_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.12774E+00_JPRB,0.11853E+00_JPRB,0.10979E+00_JPRB,0.10367E+00_JPRB,0.96160E-01_JPRB, &
 & 0.87173E-01_JPRB,0.82710E-01_JPRB,0.89689E-01_JPRB,0.82456E-01_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.12531E+00_JPRB,0.11685E+00_JPRB,0.11022E+00_JPRB,0.10509E+00_JPRB,0.97450E-01_JPRB, &
 & 0.90061E-01_JPRB,0.89222E-01_JPRB,0.99588E-01_JPRB,0.96338E-01_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.12312E+00_JPRB,0.11523E+00_JPRB,0.11015E+00_JPRB,0.10584E+00_JPRB,0.98534E-01_JPRB, &
 & 0.93531E-01_JPRB,0.96262E-01_JPRB,0.10942E+00_JPRB,0.11043E+00_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.12128E+00_JPRB,0.11400E+00_JPRB,0.10998E+00_JPRB,0.10588E+00_JPRB,0.10008E+00_JPRB, &
 & 0.97359E-01_JPRB,0.10364E+00_JPRB,0.11932E+00_JPRB,0.12582E+00_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.14105E+00_JPRB,0.12987E+00_JPRB,0.11910E+00_JPRB,0.11026E+00_JPRB,0.10035E+00_JPRB, &
 & 0.88081E-01_JPRB,0.76687E-01_JPRB,0.74205E-01_JPRB,0.50899E-01_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.13825E+00_JPRB,0.12810E+00_JPRB,0.11908E+00_JPRB,0.11198E+00_JPRB,0.10215E+00_JPRB, &
 & 0.90197E-01_JPRB,0.81650E-01_JPRB,0.83605E-01_JPRB,0.56975E-01_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.13566E+00_JPRB,0.12624E+00_JPRB,0.11939E+00_JPRB,0.11316E+00_JPRB,0.10299E+00_JPRB, &
 & 0.92874E-01_JPRB,0.87279E-01_JPRB,0.93203E-01_JPRB,0.64736E-01_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.13334E+00_JPRB,0.12460E+00_JPRB,0.11935E+00_JPRB,0.11337E+00_JPRB,0.10395E+00_JPRB, &
 & 0.95956E-01_JPRB,0.93410E-01_JPRB,0.10293E+00_JPRB,0.71284E-01_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.13131E+00_JPRB,0.12363E+00_JPRB,0.11937E+00_JPRB,0.11314E+00_JPRB,0.10517E+00_JPRB, &
 & 0.98969E-01_JPRB,0.10016E+00_JPRB,0.11304E+00_JPRB,0.78587E-01_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.15212E+00_JPRB,0.13991E+00_JPRB,0.12851E+00_JPRB,0.11872E+00_JPRB,0.10663E+00_JPRB, &
 & 0.91867E-01_JPRB,0.77350E-01_JPRB,0.69757E-01_JPRB,0.57657E-01_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.14895E+00_JPRB,0.13760E+00_JPRB,0.12846E+00_JPRB,0.12032E+00_JPRB,0.10790E+00_JPRB, &
 & 0.93798E-01_JPRB,0.81816E-01_JPRB,0.78361E-01_JPRB,0.63811E-01_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.14609E+00_JPRB,0.13558E+00_JPRB,0.12854E+00_JPRB,0.12100E+00_JPRB,0.10856E+00_JPRB, &
 & 0.96260E-01_JPRB,0.86684E-01_JPRB,0.87192E-01_JPRB,0.72200E-01_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.14343E+00_JPRB,0.13400E+00_JPRB,0.12849E+00_JPRB,0.12073E+00_JPRB,0.10951E+00_JPRB, &
 & 0.98753E-01_JPRB,0.91530E-01_JPRB,0.96391E-01_JPRB,0.79517E-01_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.14120E+00_JPRB,0.13303E+00_JPRB,0.12833E+00_JPRB,0.12041E+00_JPRB,0.11038E+00_JPRB, &
 & 0.10129E+00_JPRB,0.97562E-01_JPRB,0.10658E+00_JPRB,0.84371E-01_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.16284E+00_JPRB,0.14976E+00_JPRB,0.13792E+00_JPRB,0.12684E+00_JPRB,0.11275E+00_JPRB, &
 & 0.95645E-01_JPRB,0.78767E-01_JPRB,0.66366E-01_JPRB,0.59038E-01_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.15947E+00_JPRB,0.14721E+00_JPRB,0.13779E+00_JPRB,0.12800E+00_JPRB,0.11359E+00_JPRB, &
 & 0.97597E-01_JPRB,0.82782E-01_JPRB,0.73753E-01_JPRB,0.67374E-01_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.15626E+00_JPRB,0.14498E+00_JPRB,0.13763E+00_JPRB,0.12811E+00_JPRB,0.11414E+00_JPRB, &
 & 0.99826E-01_JPRB,0.86643E-01_JPRB,0.81525E-01_JPRB,0.75874E-01_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.15335E+00_JPRB,0.14330E+00_JPRB,0.13746E+00_JPRB,0.12758E+00_JPRB,0.11501E+00_JPRB, &
 & 0.10172E+00_JPRB,0.90750E-01_JPRB,0.90246E-01_JPRB,0.81744E-01_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.15088E+00_JPRB,0.14217E+00_JPRB,0.13690E+00_JPRB,0.12723E+00_JPRB,0.11557E+00_JPRB, &
 & 0.10388E+00_JPRB,0.96218E-01_JPRB,0.10042E+00_JPRB,0.88529E-01_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.62837E-01_JPRB,0.60695E-01_JPRB,0.77720E-01_JPRB,0.11279E+00_JPRB,0.15033E+00_JPRB, &
 & 0.18788E+00_JPRB,0.22539E+00_JPRB,0.26284E+00_JPRB,0.29421E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART10',0,ZHOOK_HANDLE)


KA(:, 2, 1,14) = (/ &
 & 0.61599E-01_JPRB,0.60148E-01_JPRB,0.79591E-01_JPRB,0.11750E+00_JPRB,0.15661E+00_JPRB, &
 & 0.19570E+00_JPRB,0.23478E+00_JPRB,0.27378E+00_JPRB,0.30578E+00_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.60827E-01_JPRB,0.59792E-01_JPRB,0.82175E-01_JPRB,0.12253E+00_JPRB,0.16330E+00_JPRB, &
 & 0.20407E+00_JPRB,0.24482E+00_JPRB,0.28548E+00_JPRB,0.31829E+00_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.60773E-01_JPRB,0.59852E-01_JPRB,0.85295E-01_JPRB,0.12765E+00_JPRB,0.17012E+00_JPRB, &
 & 0.21258E+00_JPRB,0.25502E+00_JPRB,0.29736E+00_JPRB,0.33114E+00_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.60579E-01_JPRB,0.60436E-01_JPRB,0.88993E-01_JPRB,0.13334E+00_JPRB,0.17771E+00_JPRB, &
 & 0.22206E+00_JPRB,0.26642E+00_JPRB,0.31066E+00_JPRB,0.34557E+00_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.70150E-01_JPRB,0.67933E-01_JPRB,0.82763E-01_JPRB,0.11770E+00_JPRB,0.15687E+00_JPRB, &
 & 0.19605E+00_JPRB,0.23520E+00_JPRB,0.27426E+00_JPRB,0.30923E+00_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.68737E-01_JPRB,0.67168E-01_JPRB,0.84453E-01_JPRB,0.12329E+00_JPRB,0.16434E+00_JPRB, &
 & 0.20537E+00_JPRB,0.24638E+00_JPRB,0.28735E+00_JPRB,0.32358E+00_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.67693E-01_JPRB,0.66713E-01_JPRB,0.87076E-01_JPRB,0.12893E+00_JPRB,0.17184E+00_JPRB, &
 & 0.21474E+00_JPRB,0.25764E+00_JPRB,0.30044E+00_JPRB,0.33811E+00_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.67352E-01_JPRB,0.66652E-01_JPRB,0.90088E-01_JPRB,0.13441E+00_JPRB,0.17914E+00_JPRB, &
 & 0.22388E+00_JPRB,0.26860E+00_JPRB,0.31321E+00_JPRB,0.35245E+00_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.66923E-01_JPRB,0.67069E-01_JPRB,0.93870E-01_JPRB,0.14034E+00_JPRB,0.18704E+00_JPRB, &
 & 0.23374E+00_JPRB,0.28042E+00_JPRB,0.32702E+00_JPRB,0.36794E+00_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.79385E-01_JPRB,0.76263E-01_JPRB,0.87808E-01_JPRB,0.12001E+00_JPRB,0.15997E+00_JPRB, &
 & 0.19992E+00_JPRB,0.23984E+00_JPRB,0.27971E+00_JPRB,0.31814E+00_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.77666E-01_JPRB,0.75357E-01_JPRB,0.89439E-01_JPRB,0.12673E+00_JPRB,0.16892E+00_JPRB, &
 & 0.21110E+00_JPRB,0.25327E+00_JPRB,0.29539E+00_JPRB,0.33569E+00_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.76193E-01_JPRB,0.74694E-01_JPRB,0.92082E-01_JPRB,0.13335E+00_JPRB,0.17774E+00_JPRB, &
 & 0.22213E+00_JPRB,0.26651E+00_JPRB,0.31084E+00_JPRB,0.35313E+00_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.75335E-01_JPRB,0.74405E-01_JPRB,0.95067E-01_JPRB,0.13953E+00_JPRB,0.18597E+00_JPRB, &
 & 0.23241E+00_JPRB,0.27884E+00_JPRB,0.32518E+00_JPRB,0.36942E+00_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.74635E-01_JPRB,0.74698E-01_JPRB,0.98457E-01_JPRB,0.14565E+00_JPRB,0.19414E+00_JPRB, &
 & 0.24262E+00_JPRB,0.29108E+00_JPRB,0.33947E+00_JPRB,0.38555E+00_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.89595E-01_JPRB,0.85781E-01_JPRB,0.93997E-01_JPRB,0.12072E+00_JPRB,0.16001E+00_JPRB, &
 & 0.19998E+00_JPRB,0.23994E+00_JPRB,0.27984E+00_JPRB,0.31934E+00_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.87421E-01_JPRB,0.84747E-01_JPRB,0.95233E-01_JPRB,0.12788E+00_JPRB,0.17024E+00_JPRB, &
 & 0.21274E+00_JPRB,0.25525E+00_JPRB,0.29772E+00_JPRB,0.33967E+00_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.85503E-01_JPRB,0.83808E-01_JPRB,0.97531E-01_JPRB,0.13512E+00_JPRB,0.18009E+00_JPRB, &
 & 0.22508E+00_JPRB,0.27005E+00_JPRB,0.31493E+00_JPRB,0.35929E+00_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.84061E-01_JPRB,0.83216E-01_JPRB,0.10039E+00_JPRB,0.14194E+00_JPRB,0.18919E+00_JPRB, &
 & 0.23644E+00_JPRB,0.28372E+00_JPRB,0.33088E+00_JPRB,0.37743E+00_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.83141E-01_JPRB,0.83249E-01_JPRB,0.10352E+00_JPRB,0.14853E+00_JPRB,0.19798E+00_JPRB, &
 & 0.24744E+00_JPRB,0.29688E+00_JPRB,0.34622E+00_JPRB,0.39491E+00_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.10093E+00_JPRB,0.96180E-01_JPRB,0.10202E+00_JPRB,0.12191E+00_JPRB,0.15810E+00_JPRB, &
 & 0.19761E+00_JPRB,0.23710E+00_JPRB,0.27651E+00_JPRB,0.31584E+00_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.98348E-01_JPRB,0.95154E-01_JPRB,0.10279E+00_JPRB,0.12897E+00_JPRB,0.16954E+00_JPRB, &
 & 0.21190E+00_JPRB,0.25425E+00_JPRB,0.29655E+00_JPRB,0.33869E+00_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.96078E-01_JPRB,0.94065E-01_JPRB,0.10459E+00_JPRB,0.13623E+00_JPRB,0.18035E+00_JPRB, &
 & 0.22539E+00_JPRB,0.27041E+00_JPRB,0.31537E+00_JPRB,0.36019E+00_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.94202E-01_JPRB,0.93296E-01_JPRB,0.10703E+00_JPRB,0.14326E+00_JPRB,0.19057E+00_JPRB, &
 & 0.23817E+00_JPRB,0.28575E+00_JPRB,0.33330E+00_JPRB,0.38060E+00_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.93055E-01_JPRB,0.92935E-01_JPRB,0.10982E+00_JPRB,0.15042E+00_JPRB,0.20048E+00_JPRB, &
 & 0.25056E+00_JPRB,0.30061E+00_JPRB,0.35061E+00_JPRB,0.40035E+00_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.11421E+00_JPRB,0.10796E+00_JPRB,0.11173E+00_JPRB,0.12476E+00_JPRB,0.15549E+00_JPRB, &
 & 0.19408E+00_JPRB,0.23286E+00_JPRB,0.27161E+00_JPRB,0.31032E+00_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.11123E+00_JPRB,0.10718E+00_JPRB,0.11218E+00_JPRB,0.13121E+00_JPRB,0.16775E+00_JPRB, &
 & 0.20966E+00_JPRB,0.25155E+00_JPRB,0.29340E+00_JPRB,0.33523E+00_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.10875E+00_JPRB,0.10588E+00_JPRB,0.11334E+00_JPRB,0.13798E+00_JPRB,0.17972E+00_JPRB, &
 & 0.22462E+00_JPRB,0.26950E+00_JPRB,0.31433E+00_JPRB,0.35914E+00_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.10666E+00_JPRB,0.10458E+00_JPRB,0.11529E+00_JPRB,0.14519E+00_JPRB,0.19132E+00_JPRB, &
 & 0.23911E+00_JPRB,0.28688E+00_JPRB,0.33463E+00_JPRB,0.38232E+00_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.10502E+00_JPRB,0.10381E+00_JPRB,0.11770E+00_JPRB,0.15287E+00_JPRB,0.20267E+00_JPRB, &
 & 0.25329E+00_JPRB,0.30392E+00_JPRB,0.35446E+00_JPRB,0.40496E+00_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.12988E+00_JPRB,0.12138E+00_JPRB,0.12291E+00_JPRB,0.12930E+00_JPRB,0.15315E+00_JPRB, &
 & 0.18907E+00_JPRB,0.22686E+00_JPRB,0.26460E+00_JPRB,0.30239E+00_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.12649E+00_JPRB,0.12054E+00_JPRB,0.12314E+00_JPRB,0.13530E+00_JPRB,0.16601E+00_JPRB, &
 & 0.20667E+00_JPRB,0.24798E+00_JPRB,0.28925E+00_JPRB,0.33056E+00_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.12370E+00_JPRB,0.11924E+00_JPRB,0.12400E+00_JPRB,0.14174E+00_JPRB,0.17907E+00_JPRB, &
 & 0.22369E+00_JPRB,0.26838E+00_JPRB,0.31304E+00_JPRB,0.35775E+00_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.12121E+00_JPRB,0.11770E+00_JPRB,0.12551E+00_JPRB,0.14889E+00_JPRB,0.19207E+00_JPRB, &
 & 0.24005E+00_JPRB,0.28802E+00_JPRB,0.33592E+00_JPRB,0.38391E+00_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.11892E+00_JPRB,0.11635E+00_JPRB,0.12739E+00_JPRB,0.15666E+00_JPRB,0.20470E+00_JPRB, &
 & 0.25583E+00_JPRB,0.30694E+00_JPRB,0.35802E+00_JPRB,0.40917E+00_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.14795E+00_JPRB,0.13669E+00_JPRB,0.13564E+00_JPRB,0.13646E+00_JPRB,0.15231E+00_JPRB, &
 & 0.18310E+00_JPRB,0.21966E+00_JPRB,0.25622E+00_JPRB,0.29284E+00_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.14430E+00_JPRB,0.13540E+00_JPRB,0.13550E+00_JPRB,0.14118E+00_JPRB,0.16490E+00_JPRB, &
 & 0.20238E+00_JPRB,0.24284E+00_JPRB,0.28324E+00_JPRB,0.32374E+00_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.14109E+00_JPRB,0.13403E+00_JPRB,0.13585E+00_JPRB,0.14713E+00_JPRB,0.17836E+00_JPRB, &
 & 0.22126E+00_JPRB,0.26548E+00_JPRB,0.30963E+00_JPRB,0.35392E+00_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.13807E+00_JPRB,0.13250E+00_JPRB,0.13707E+00_JPRB,0.15422E+00_JPRB,0.19232E+00_JPRB, &
 & 0.23967E+00_JPRB,0.28757E+00_JPRB,0.33540E+00_JPRB,0.38338E+00_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.13514E+00_JPRB,0.13080E+00_JPRB,0.13878E+00_JPRB,0.16197E+00_JPRB,0.20594E+00_JPRB, &
 & 0.25719E+00_JPRB,0.30860E+00_JPRB,0.35994E+00_JPRB,0.41142E+00_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.16812E+00_JPRB,0.15406E+00_JPRB,0.15051E+00_JPRB,0.14632E+00_JPRB,0.15371E+00_JPRB, &
 & 0.17730E+00_JPRB,0.21108E+00_JPRB,0.24622E+00_JPRB,0.28143E+00_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.16420E+00_JPRB,0.15230E+00_JPRB,0.14950E+00_JPRB,0.14998E+00_JPRB,0.16549E+00_JPRB, &
 & 0.19706E+00_JPRB,0.23609E+00_JPRB,0.27539E+00_JPRB,0.31477E+00_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.16053E+00_JPRB,0.15077E+00_JPRB,0.14903E+00_JPRB,0.15488E+00_JPRB,0.17883E+00_JPRB, &
 & 0.21740E+00_JPRB,0.26082E+00_JPRB,0.30423E+00_JPRB,0.34775E+00_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.15694E+00_JPRB,0.14891E+00_JPRB,0.14991E+00_JPRB,0.16140E+00_JPRB,0.19301E+00_JPRB, &
 & 0.23753E+00_JPRB,0.28500E+00_JPRB,0.33244E+00_JPRB,0.37999E+00_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.15342E+00_JPRB,0.14670E+00_JPRB,0.15145E+00_JPRB,0.16838E+00_JPRB,0.20634E+00_JPRB, &
 & 0.25567E+00_JPRB,0.30677E+00_JPRB,0.35784E+00_JPRB,0.40903E+00_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.18962E+00_JPRB,0.17319E+00_JPRB,0.16709E+00_JPRB,0.15817E+00_JPRB,0.15908E+00_JPRB, &
 & 0.17425E+00_JPRB,0.20287E+00_JPRB,0.23665E+00_JPRB,0.27049E+00_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.18536E+00_JPRB,0.17110E+00_JPRB,0.16526E+00_JPRB,0.16124E+00_JPRB,0.16946E+00_JPRB, &
 & 0.19394E+00_JPRB,0.22959E+00_JPRB,0.26781E+00_JPRB,0.30611E+00_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.18117E+00_JPRB,0.16910E+00_JPRB,0.16400E+00_JPRB,0.16579E+00_JPRB,0.18236E+00_JPRB, &
 & 0.21466E+00_JPRB,0.25610E+00_JPRB,0.29874E+00_JPRB,0.34146E+00_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.17697E+00_JPRB,0.16677E+00_JPRB,0.16446E+00_JPRB,0.17161E+00_JPRB,0.19589E+00_JPRB, &
 & 0.23479E+00_JPRB,0.28114E+00_JPRB,0.32796E+00_JPRB,0.37484E+00_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.17281E+00_JPRB,0.16399E+00_JPRB,0.16565E+00_JPRB,0.17716E+00_JPRB,0.20808E+00_JPRB, &
 & 0.25277E+00_JPRB,0.30323E+00_JPRB,0.35372E+00_JPRB,0.40429E+00_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.21055E+00_JPRB,0.19254E+00_JPRB,0.18359E+00_JPRB,0.17274E+00_JPRB,0.17137E+00_JPRB, &
 & 0.18167E+00_JPRB,0.20669E+00_JPRB,0.24044E+00_JPRB,0.24447E+00_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.20570E+00_JPRB,0.19011E+00_JPRB,0.18168E+00_JPRB,0.17577E+00_JPRB,0.18167E+00_JPRB, &
 & 0.20144E+00_JPRB,0.23412E+00_JPRB,0.27305E+00_JPRB,0.28987E+00_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.20088E+00_JPRB,0.18755E+00_JPRB,0.18057E+00_JPRB,0.18058E+00_JPRB,0.19347E+00_JPRB, &
 & 0.22124E+00_JPRB,0.26062E+00_JPRB,0.30406E+00_JPRB,0.33203E+00_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.19608E+00_JPRB,0.18439E+00_JPRB,0.18082E+00_JPRB,0.18569E+00_JPRB,0.20488E+00_JPRB, &
 & 0.23927E+00_JPRB,0.28460E+00_JPRB,0.33201E+00_JPRB,0.37191E+00_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.19134E+00_JPRB,0.18083E+00_JPRB,0.18137E+00_JPRB,0.19023E+00_JPRB,0.21563E+00_JPRB, &
 & 0.25670E+00_JPRB,0.30697E+00_JPRB,0.35809E+00_JPRB,0.40924E+00_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.23222E+00_JPRB,0.21282E+00_JPRB,0.20059E+00_JPRB,0.18856E+00_JPRB,0.18455E+00_JPRB, &
 & 0.18954E+00_JPRB,0.20921E+00_JPRB,0.24116E+00_JPRB,0.20678E+00_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.22666E+00_JPRB,0.20982E+00_JPRB,0.19853E+00_JPRB,0.19166E+00_JPRB,0.19460E+00_JPRB, &
 & 0.20805E+00_JPRB,0.23602E+00_JPRB,0.27405E+00_JPRB,0.24947E+00_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.22121E+00_JPRB,0.20649E+00_JPRB,0.19756E+00_JPRB,0.19621E+00_JPRB,0.20452E+00_JPRB, &
 & 0.22597E+00_JPRB,0.26146E+00_JPRB,0.30478E+00_JPRB,0.28725E+00_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.21578E+00_JPRB,0.20240E+00_JPRB,0.19746E+00_JPRB,0.20035E+00_JPRB,0.21392E+00_JPRB, &
 & 0.24302E+00_JPRB,0.28559E+00_JPRB,0.33317E+00_JPRB,0.32415E+00_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.21026E+00_JPRB,0.19816E+00_JPRB,0.19729E+00_JPRB,0.20402E+00_JPRB,0.22339E+00_JPRB, &
 & 0.25983E+00_JPRB,0.30840E+00_JPRB,0.35980E+00_JPRB,0.36272E+00_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.25447E+00_JPRB,0.23356E+00_JPRB,0.21785E+00_JPRB,0.20504E+00_JPRB,0.19797E+00_JPRB, &
 & 0.19705E+00_JPRB,0.20967E+00_JPRB,0.23794E+00_JPRB,0.19657E+00_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.24820E+00_JPRB,0.22981E+00_JPRB,0.21561E+00_JPRB,0.20828E+00_JPRB,0.20711E+00_JPRB, &
 & 0.21347E+00_JPRB,0.23520E+00_JPRB,0.27088E+00_JPRB,0.23547E+00_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.24206E+00_JPRB,0.22556E+00_JPRB,0.21467E+00_JPRB,0.21216E+00_JPRB,0.21525E+00_JPRB, &
 & 0.22938E+00_JPRB,0.25994E+00_JPRB,0.30180E+00_JPRB,0.27108E+00_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.23572E+00_JPRB,0.22056E+00_JPRB,0.21408E+00_JPRB,0.21517E+00_JPRB,0.22293E+00_JPRB, &
 & 0.24576E+00_JPRB,0.28399E+00_JPRB,0.33091E+00_JPRB,0.30909E+00_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.22932E+00_JPRB,0.21557E+00_JPRB,0.21287E+00_JPRB,0.21778E+00_JPRB,0.23130E+00_JPRB, &
 & 0.26208E+00_JPRB,0.30701E+00_JPRB,0.35815E+00_JPRB,0.34602E+00_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.79223E-01_JPRB,0.75104E-01_JPRB,0.13846E+00_JPRB,0.20766E+00_JPRB,0.27685E+00_JPRB, &
 & 0.34601E+00_JPRB,0.41512E+00_JPRB,0.48397E+00_JPRB,0.52564E+00_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.76682E-01_JPRB,0.76450E-01_JPRB,0.14571E+00_JPRB,0.21854E+00_JPRB,0.29137E+00_JPRB, &
 & 0.36417E+00_JPRB,0.43689E+00_JPRB,0.50929E+00_JPRB,0.55383E+00_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.74345E-01_JPRB,0.78213E-01_JPRB,0.15207E+00_JPRB,0.22808E+00_JPRB,0.30407E+00_JPRB, &
 & 0.38004E+00_JPRB,0.45593E+00_JPRB,0.53155E+00_JPRB,0.57851E+00_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.72607E-01_JPRB,0.80130E-01_JPRB,0.15758E+00_JPRB,0.23638E+00_JPRB,0.31513E+00_JPRB, &
 & 0.39385E+00_JPRB,0.47252E+00_JPRB,0.55092E+00_JPRB,0.60005E+00_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.72847E-01_JPRB,0.82433E-01_JPRB,0.16249E+00_JPRB,0.24371E+00_JPRB,0.32491E+00_JPRB, &
 & 0.40606E+00_JPRB,0.48713E+00_JPRB,0.56790E+00_JPRB,0.61880E+00_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.89010E-01_JPRB,0.84748E-01_JPRB,0.15528E+00_JPRB,0.23291E+00_JPRB,0.31052E+00_JPRB, &
 & 0.38812E+00_JPRB,0.46559E+00_JPRB,0.54282E+00_JPRB,0.60189E+00_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.86286E-01_JPRB,0.86390E-01_JPRB,0.16350E+00_JPRB,0.24523E+00_JPRB,0.32694E+00_JPRB, &
 & 0.40865E+00_JPRB,0.49029E+00_JPRB,0.57166E+00_JPRB,0.63436E+00_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.83865E-01_JPRB,0.88469E-01_JPRB,0.17076E+00_JPRB,0.25611E+00_JPRB,0.34145E+00_JPRB, &
 & 0.42675E+00_JPRB,0.51202E+00_JPRB,0.59693E+00_JPRB,0.66276E+00_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.81971E-01_JPRB,0.90581E-01_JPRB,0.17733E+00_JPRB,0.26595E+00_JPRB,0.35459E+00_JPRB, &
 & 0.44319E+00_JPRB,0.53165E+00_JPRB,0.61981E+00_JPRB,0.68802E+00_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.81826E-01_JPRB,0.93085E-01_JPRB,0.18319E+00_JPRB,0.27476E+00_JPRB,0.36629E+00_JPRB, &
 & 0.45781E+00_JPRB,0.54921E+00_JPRB,0.64033E+00_JPRB,0.71080E+00_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.10078E+00_JPRB,0.96469E-01_JPRB,0.17126E+00_JPRB,0.25687E+00_JPRB,0.34247E+00_JPRB, &
 & 0.42804E+00_JPRB,0.51357E+00_JPRB,0.59868E+00_JPRB,0.67473E+00_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.97698E-01_JPRB,0.98193E-01_JPRB,0.18058E+00_JPRB,0.27084E+00_JPRB,0.36108E+00_JPRB, &
 & 0.45128E+00_JPRB,0.54134E+00_JPRB,0.63128E+00_JPRB,0.71182E+00_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.95186E-01_JPRB,0.10027E+00_JPRB,0.18871E+00_JPRB,0.28303E+00_JPRB,0.37733E+00_JPRB, &
 & 0.47160E+00_JPRB,0.56577E+00_JPRB,0.65972E+00_JPRB,0.74408E+00_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.93223E-01_JPRB,0.10231E+00_JPRB,0.19621E+00_JPRB,0.29427E+00_JPRB,0.39234E+00_JPRB, &
 & 0.49035E+00_JPRB,0.58829E+00_JPRB,0.68586E+00_JPRB,0.77383E+00_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.93003E-01_JPRB,0.10431E+00_JPRB,0.20302E+00_JPRB,0.30448E+00_JPRB,0.40592E+00_JPRB, &
 & 0.50734E+00_JPRB,0.60870E+00_JPRB,0.70970E+00_JPRB,0.80084E+00_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.11556E+00_JPRB,0.11007E+00_JPRB,0.18689E+00_JPRB,0.28032E+00_JPRB,0.37373E+00_JPRB, &
 & 0.46710E+00_JPRB,0.56044E+00_JPRB,0.65346E+00_JPRB,0.74264E+00_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.11235E+00_JPRB,0.11167E+00_JPRB,0.19754E+00_JPRB,0.29630E+00_JPRB,0.39502E+00_JPRB, &
 & 0.49371E+00_JPRB,0.59235E+00_JPRB,0.69064E+00_JPRB,0.78516E+00_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.10972E+00_JPRB,0.11355E+00_JPRB,0.20696E+00_JPRB,0.31040E+00_JPRB,0.41383E+00_JPRB, &
 & 0.51721E+00_JPRB,0.62053E+00_JPRB,0.72352E+00_JPRB,0.82248E+00_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.10741E+00_JPRB,0.11554E+00_JPRB,0.21557E+00_JPRB,0.32331E+00_JPRB,0.43105E+00_JPRB, &
 & 0.53874E+00_JPRB,0.64632E+00_JPRB,0.75359E+00_JPRB,0.85679E+00_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.10619E+00_JPRB,0.11745E+00_JPRB,0.22327E+00_JPRB,0.33487E+00_JPRB,0.44646E+00_JPRB, &
 & 0.55799E+00_JPRB,0.66944E+00_JPRB,0.78056E+00_JPRB,0.88741E+00_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.13422E+00_JPRB,0.12619E+00_JPRB,0.20125E+00_JPRB,0.30186E+00_JPRB,0.40245E+00_JPRB, &
 & 0.50302E+00_JPRB,0.60348E+00_JPRB,0.70372E+00_JPRB,0.80253E+00_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.13052E+00_JPRB,0.12743E+00_JPRB,0.21345E+00_JPRB,0.32016E+00_JPRB,0.42685E+00_JPRB, &
 & 0.53351E+00_JPRB,0.64011E+00_JPRB,0.74634E+00_JPRB,0.85136E+00_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.12741E+00_JPRB,0.12876E+00_JPRB,0.22450E+00_JPRB,0.33672E+00_JPRB,0.44894E+00_JPRB, &
 & 0.56113E+00_JPRB,0.67322E+00_JPRB,0.78494E+00_JPRB,0.89542E+00_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.12456E+00_JPRB,0.13045E+00_JPRB,0.23454E+00_JPRB,0.35177E+00_JPRB,0.46901E+00_JPRB, &
 & 0.58622E+00_JPRB,0.70332E+00_JPRB,0.82004E+00_JPRB,0.93535E+00_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.12240E+00_JPRB,0.13234E+00_JPRB,0.24346E+00_JPRB,0.36515E+00_JPRB,0.48682E+00_JPRB, &
 & 0.60842E+00_JPRB,0.72992E+00_JPRB,0.85105E+00_JPRB,0.97074E+00_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.15641E+00_JPRB,0.14549E+00_JPRB,0.21406E+00_JPRB,0.31903E+00_JPRB,0.42534E+00_JPRB, &
 & 0.53165E+00_JPRB,0.63788E+00_JPRB,0.74385E+00_JPRB,0.84964E+00_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.15207E+00_JPRB,0.14574E+00_JPRB,0.22708E+00_JPRB,0.34022E+00_JPRB,0.45360E+00_JPRB, &
 & 0.56697E+00_JPRB,0.68027E+00_JPRB,0.79322E+00_JPRB,0.90603E+00_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.14825E+00_JPRB,0.14665E+00_JPRB,0.23979E+00_JPRB,0.35965E+00_JPRB,0.47950E+00_JPRB, &
 & 0.59932E+00_JPRB,0.71907E+00_JPRB,0.83857E+00_JPRB,0.95773E+00_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.14482E+00_JPRB,0.14790E+00_JPRB,0.25144E+00_JPRB,0.37711E+00_JPRB,0.50278E+00_JPRB, &
 & 0.62841E+00_JPRB,0.75400E+00_JPRB,0.87926E+00_JPRB,0.10043E+01_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.14196E+00_JPRB,0.14929E+00_JPRB,0.26158E+00_JPRB,0.39235E+00_JPRB,0.52312E+00_JPRB, &
 & 0.65390E+00_JPRB,0.78460E+00_JPRB,0.91489E+00_JPRB,0.10450E+01_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.18245E+00_JPRB,0.16813E+00_JPRB,0.22831E+00_JPRB,0.33360E+00_JPRB,0.44476E+00_JPRB, &
 & 0.55591E+00_JPRB,0.66702E+00_JPRB,0.77783E+00_JPRB,0.88903E+00_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.17706E+00_JPRB,0.16763E+00_JPRB,0.24144E+00_JPRB,0.35719E+00_JPRB,0.47625E+00_JPRB, &
 & 0.59524E+00_JPRB,0.71422E+00_JPRB,0.83295E+00_JPRB,0.95194E+00_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.17236E+00_JPRB,0.16756E+00_JPRB,0.25360E+00_JPRB,0.37892E+00_JPRB,0.50520E+00_JPRB, &
 & 0.63143E+00_JPRB,0.75766E+00_JPRB,0.88351E+00_JPRB,0.10099E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART11',0,ZHOOK_HANDLE)


KA(:, 4, 7,15) = (/ &
 & 0.16823E+00_JPRB,0.16816E+00_JPRB,0.26586E+00_JPRB,0.39858E+00_JPRB,0.53141E+00_JPRB, &
 & 0.66420E+00_JPRB,0.79692E+00_JPRB,0.92941E+00_JPRB,0.10623E+01_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.16468E+00_JPRB,0.16894E+00_JPRB,0.27725E+00_JPRB,0.41585E+00_JPRB,0.55445E+00_JPRB, &
 & 0.69298E+00_JPRB,0.83146E+00_JPRB,0.96971E+00_JPRB,0.11082E+01_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.21221E+00_JPRB,0.19366E+00_JPRB,0.24501E+00_JPRB,0.34518E+00_JPRB,0.46022E+00_JPRB, &
 & 0.57522E+00_JPRB,0.69013E+00_JPRB,0.80500E+00_JPRB,0.92024E+00_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.20558E+00_JPRB,0.19344E+00_JPRB,0.25798E+00_JPRB,0.37195E+00_JPRB,0.49597E+00_JPRB, &
 & 0.61989E+00_JPRB,0.74379E+00_JPRB,0.86737E+00_JPRB,0.99166E+00_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.19977E+00_JPRB,0.19260E+00_JPRB,0.26963E+00_JPRB,0.39624E+00_JPRB,0.52829E+00_JPRB, &
 & 0.66032E+00_JPRB,0.79227E+00_JPRB,0.92396E+00_JPRB,0.10564E+01_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.19471E+00_JPRB,0.19196E+00_JPRB,0.28135E+00_JPRB,0.41773E+00_JPRB,0.55693E+00_JPRB, &
 & 0.69614E+00_JPRB,0.83525E+00_JPRB,0.97412E+00_JPRB,0.11137E+01_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.19023E+00_JPRB,0.19149E+00_JPRB,0.29229E+00_JPRB,0.43683E+00_JPRB,0.58243E+00_JPRB, &
 & 0.72800E+00_JPRB,0.87352E+00_JPRB,0.10186E+01_JPRB,0.11647E+01_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.24675E+00_JPRB,0.22274E+00_JPRB,0.26456E+00_JPRB,0.35496E+00_JPRB,0.47007E+00_JPRB, &
 & 0.58755E+00_JPRB,0.70496E+00_JPRB,0.82216E+00_JPRB,0.94015E+00_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.23844E+00_JPRB,0.22223E+00_JPRB,0.27692E+00_JPRB,0.38304E+00_JPRB,0.51028E+00_JPRB, &
 & 0.63780E+00_JPRB,0.76534E+00_JPRB,0.89259E+00_JPRB,0.10206E+01_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.23115E+00_JPRB,0.22076E+00_JPRB,0.28808E+00_JPRB,0.40973E+00_JPRB,0.54629E+00_JPRB, &
 & 0.68281E+00_JPRB,0.81930E+00_JPRB,0.95554E+00_JPRB,0.10926E+01_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.22487E+00_JPRB,0.21935E+00_JPRB,0.29872E+00_JPRB,0.43339E+00_JPRB,0.57783E+00_JPRB, &
 & 0.72230E+00_JPRB,0.86661E+00_JPRB,0.10108E+01_JPRB,0.11557E+01_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.21911E+00_JPRB,0.21807E+00_JPRB,0.30914E+00_JPRB,0.45602E+00_JPRB,0.60799E+00_JPRB, &
 & 0.75991E+00_JPRB,0.91189E+00_JPRB,0.10634E+01_JPRB,0.12161E+01_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.28580E+00_JPRB,0.25610E+00_JPRB,0.28839E+00_JPRB,0.36810E+00_JPRB,0.47645E+00_JPRB, &
 & 0.59554E+00_JPRB,0.71455E+00_JPRB,0.83348E+00_JPRB,0.95290E+00_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.27554E+00_JPRB,0.25438E+00_JPRB,0.29985E+00_JPRB,0.39603E+00_JPRB,0.52141E+00_JPRB, &
 & 0.65175E+00_JPRB,0.78205E+00_JPRB,0.91212E+00_JPRB,0.10429E+01_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.26639E+00_JPRB,0.25230E+00_JPRB,0.31000E+00_JPRB,0.42263E+00_JPRB,0.56074E+00_JPRB, &
 & 0.70092E+00_JPRB,0.84101E+00_JPRB,0.98094E+00_JPRB,0.11215E+01_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.25840E+00_JPRB,0.24961E+00_JPRB,0.31933E+00_JPRB,0.44762E+00_JPRB,0.59663E+00_JPRB, &
 & 0.74572E+00_JPRB,0.89477E+00_JPRB,0.10436E+01_JPRB,0.11932E+01_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.25110E+00_JPRB,0.24738E+00_JPRB,0.32882E+00_JPRB,0.47409E+00_JPRB,0.63208E+00_JPRB, &
 & 0.79011E+00_JPRB,0.94801E+00_JPRB,0.11055E+01_JPRB,0.12642E+01_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.32402E+00_JPRB,0.29231E+00_JPRB,0.32114E+00_JPRB,0.39449E+00_JPRB,0.49965E+00_JPRB, &
 & 0.62359E+00_JPRB,0.74830E+00_JPRB,0.87279E+00_JPRB,0.99780E+00_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.31203E+00_JPRB,0.28940E+00_JPRB,0.33009E+00_JPRB,0.42179E+00_JPRB,0.54573E+00_JPRB, &
 & 0.68214E+00_JPRB,0.81856E+00_JPRB,0.95481E+00_JPRB,0.10916E+01_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.30125E+00_JPRB,0.28556E+00_JPRB,0.33820E+00_JPRB,0.44749E+00_JPRB,0.58870E+00_JPRB, &
 & 0.73583E+00_JPRB,0.88295E+00_JPRB,0.10298E+01_JPRB,0.11773E+01_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.29153E+00_JPRB,0.28159E+00_JPRB,0.34632E+00_JPRB,0.47427E+00_JPRB,0.63035E+00_JPRB, &
 & 0.78788E+00_JPRB,0.94537E+00_JPRB,0.11027E+01_JPRB,0.12607E+01_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.28247E+00_JPRB,0.27799E+00_JPRB,0.35496E+00_JPRB,0.50259E+00_JPRB,0.66996E+00_JPRB, &
 & 0.83740E+00_JPRB,0.10047E+01_JPRB,0.11720E+01_JPRB,0.13400E+01_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.36545E+00_JPRB,0.33140E+00_JPRB,0.35636E+00_JPRB,0.42085E+00_JPRB,0.52250E+00_JPRB, &
 & 0.64898E+00_JPRB,0.77872E+00_JPRB,0.90834E+00_JPRB,0.10384E+01_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.35131E+00_JPRB,0.32685E+00_JPRB,0.36231E+00_JPRB,0.44658E+00_JPRB,0.56903E+00_JPRB, &
 & 0.71087E+00_JPRB,0.85304E+00_JPRB,0.99503E+00_JPRB,0.11374E+01_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.33841E+00_JPRB,0.32098E+00_JPRB,0.36825E+00_JPRB,0.47208E+00_JPRB,0.61613E+00_JPRB, &
 & 0.77016E+00_JPRB,0.92410E+00_JPRB,0.10779E+01_JPRB,0.12323E+01_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.32642E+00_JPRB,0.31543E+00_JPRB,0.37504E+00_JPRB,0.50058E+00_JPRB,0.66195E+00_JPRB, &
 & 0.82736E+00_JPRB,0.99279E+00_JPRB,0.11580E+01_JPRB,0.13239E+01_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.31541E+00_JPRB,0.31006E+00_JPRB,0.38358E+00_JPRB,0.53015E+00_JPRB,0.70512E+00_JPRB, &
 & 0.88131E+00_JPRB,0.10574E+01_JPRB,0.12335E+01_JPRB,0.14101E+01_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.40964E+00_JPRB,0.37314E+00_JPRB,0.39372E+00_JPRB,0.44813E+00_JPRB,0.54521E+00_JPRB, &
 & 0.67332E+00_JPRB,0.80793E+00_JPRB,0.94247E+00_JPRB,0.10773E+01_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.39277E+00_JPRB,0.36624E+00_JPRB,0.39629E+00_JPRB,0.47194E+00_JPRB,0.59295E+00_JPRB, &
 & 0.73949E+00_JPRB,0.88734E+00_JPRB,0.10350E+01_JPRB,0.11832E+01_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.37714E+00_JPRB,0.35816E+00_JPRB,0.39962E+00_JPRB,0.49769E+00_JPRB,0.64296E+00_JPRB, &
 & 0.80367E+00_JPRB,0.96435E+00_JPRB,0.11249E+01_JPRB,0.12860E+01_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.36268E+00_JPRB,0.35049E+00_JPRB,0.40459E+00_JPRB,0.52725E+00_JPRB,0.69174E+00_JPRB, &
 & 0.86463E+00_JPRB,0.10374E+01_JPRB,0.12101E+01_JPRB,0.13834E+01_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.34948E+00_JPRB,0.34295E+00_JPRB,0.41358E+00_JPRB,0.55736E+00_JPRB,0.73767E+00_JPRB, &
 & 0.92205E+00_JPRB,0.11064E+01_JPRB,0.12905E+01_JPRB,0.14753E+01_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.90320E-01_JPRB,0.86361E-01_JPRB,0.17271E+00_JPRB,0.25905E+00_JPRB,0.34536E+00_JPRB, &
 & 0.43163E+00_JPRB,0.51777E+00_JPRB,0.60344E+00_JPRB,0.64541E+00_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.88026E-01_JPRB,0.92415E-01_JPRB,0.18482E+00_JPRB,0.27721E+00_JPRB,0.36957E+00_JPRB, &
 & 0.46188E+00_JPRB,0.55406E+00_JPRB,0.64572E+00_JPRB,0.69076E+00_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.85829E-01_JPRB,0.97954E-01_JPRB,0.19590E+00_JPRB,0.29382E+00_JPRB,0.39172E+00_JPRB, &
 & 0.48957E+00_JPRB,0.58728E+00_JPRB,0.68449E+00_JPRB,0.73223E+00_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.83674E-01_JPRB,0.10298E+00_JPRB,0.20595E+00_JPRB,0.30890E+00_JPRB,0.41183E+00_JPRB, &
 & 0.51469E+00_JPRB,0.61741E+00_JPRB,0.71956E+00_JPRB,0.77014E+00_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.84304E-01_JPRB,0.10756E+00_JPRB,0.21511E+00_JPRB,0.32264E+00_JPRB,0.43014E+00_JPRB, &
 & 0.53758E+00_JPRB,0.64487E+00_JPRB,0.75164E+00_JPRB,0.80439E+00_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.99611E-01_JPRB,0.10121E+00_JPRB,0.20241E+00_JPRB,0.30359E+00_JPRB,0.40479E+00_JPRB, &
 & 0.50590E+00_JPRB,0.60686E+00_JPRB,0.70732E+00_JPRB,0.77453E+00_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.97224E-01_JPRB,0.10870E+00_JPRB,0.21739E+00_JPRB,0.32607E+00_JPRB,0.43471E+00_JPRB, &
 & 0.54336E+00_JPRB,0.65181E+00_JPRB,0.75967E+00_JPRB,0.83199E+00_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.94894E-01_JPRB,0.11558E+00_JPRB,0.23114E+00_JPRB,0.34669E+00_JPRB,0.46220E+00_JPRB, &
 & 0.57772E+00_JPRB,0.69302E+00_JPRB,0.80771E+00_JPRB,0.88476E+00_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.92656E-01_JPRB,0.12184E+00_JPRB,0.24366E+00_JPRB,0.36546E+00_JPRB,0.48723E+00_JPRB, &
 & 0.60893E+00_JPRB,0.73046E+00_JPRB,0.85132E+00_JPRB,0.93269E+00_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.93593E-01_JPRB,0.12749E+00_JPRB,0.25497E+00_JPRB,0.38243E+00_JPRB,0.50985E+00_JPRB, &
 & 0.63721E+00_JPRB,0.76438E+00_JPRB,0.89083E+00_JPRB,0.97622E+00_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.11521E+00_JPRB,0.11614E+00_JPRB,0.23226E+00_JPRB,0.34836E+00_JPRB,0.46443E+00_JPRB, &
 & 0.58044E+00_JPRB,0.69629E+00_JPRB,0.81149E+00_JPRB,0.90951E+00_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.11222E+00_JPRB,0.12555E+00_JPRB,0.25108E+00_JPRB,0.37659E+00_JPRB,0.50206E+00_JPRB, &
 & 0.62747E+00_JPRB,0.75258E+00_JPRB,0.87709E+00_JPRB,0.98316E+00_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.10948E+00_JPRB,0.13410E+00_JPRB,0.26819E+00_JPRB,0.40226E+00_JPRB,0.53629E+00_JPRB, &
 & 0.67035E+00_JPRB,0.80421E+00_JPRB,0.93726E+00_JPRB,0.10505E+01_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.10697E+00_JPRB,0.14195E+00_JPRB,0.28389E+00_JPRB,0.42580E+00_JPRB,0.56768E+00_JPRB, &
 & 0.70947E+00_JPRB,0.85107E+00_JPRB,0.99187E+00_JPRB,0.11120E+01_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.10462E+00_JPRB,0.14901E+00_JPRB,0.29800E+00_JPRB,0.44697E+00_JPRB,0.59590E+00_JPRB, &
 & 0.74474E+00_JPRB,0.89338E+00_JPRB,0.10415E+01_JPRB,0.11678E+01_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.13825E+00_JPRB,0.13238E+00_JPRB,0.26314E+00_JPRB,0.39468E+00_JPRB,0.52618E+00_JPRB, &
 & 0.65761E+00_JPRB,0.78893E+00_JPRB,0.91946E+00_JPRB,0.10423E+01_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.13437E+00_JPRB,0.14320E+00_JPRB,0.28638E+00_JPRB,0.42954E+00_JPRB,0.57266E+00_JPRB, &
 & 0.71574E+00_JPRB,0.85868E+00_JPRB,0.10008E+01_JPRB,0.11347E+01_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.13067E+00_JPRB,0.15392E+00_JPRB,0.30782E+00_JPRB,0.46170E+00_JPRB,0.61554E+00_JPRB, &
 & 0.76929E+00_JPRB,0.92283E+00_JPRB,0.10757E+01_JPRB,0.12195E+01_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.12733E+00_JPRB,0.16364E+00_JPRB,0.32725E+00_JPRB,0.49085E+00_JPRB,0.65439E+00_JPRB, &
 & 0.81785E+00_JPRB,0.98125E+00_JPRB,0.11437E+01_JPRB,0.12968E+01_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.12429E+00_JPRB,0.17242E+00_JPRB,0.34483E+00_JPRB,0.51721E+00_JPRB,0.68954E+00_JPRB, &
 & 0.86178E+00_JPRB,0.10339E+01_JPRB,0.12053E+01_JPRB,0.13667E+01_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.16714E+00_JPRB,0.15294E+00_JPRB,0.29770E+00_JPRB,0.44651E+00_JPRB,0.59528E+00_JPRB, &
 & 0.74397E+00_JPRB,0.89246E+00_JPRB,0.10402E+01_JPRB,0.11846E+01_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.16248E+00_JPRB,0.16289E+00_JPRB,0.32569E+00_JPRB,0.48850E+00_JPRB,0.65127E+00_JPRB, &
 & 0.81396E+00_JPRB,0.97625E+00_JPRB,0.11381E+01_JPRB,0.12962E+01_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.15803E+00_JPRB,0.17580E+00_JPRB,0.35158E+00_JPRB,0.52733E+00_JPRB,0.70303E+00_JPRB, &
 & 0.87864E+00_JPRB,0.10540E+01_JPRB,0.12284E+01_JPRB,0.13993E+01_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.15368E+00_JPRB,0.18757E+00_JPRB,0.37512E+00_JPRB,0.56264E+00_JPRB,0.75011E+00_JPRB, &
 & 0.93747E+00_JPRB,0.11247E+01_JPRB,0.13108E+01_JPRB,0.14933E+01_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.14943E+00_JPRB,0.19824E+00_JPRB,0.39645E+00_JPRB,0.59477E+00_JPRB,0.79303E+00_JPRB, &
 & 0.99112E+00_JPRB,0.11890E+01_JPRB,0.13858E+01_JPRB,0.15783E+01_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.20217E+00_JPRB,0.17926E+00_JPRB,0.33507E+00_JPRB,0.50257E+00_JPRB,0.67002E+00_JPRB, &
 & 0.83741E+00_JPRB,0.10046E+01_JPRB,0.11708E+01_JPRB,0.13365E+01_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.19655E+00_JPRB,0.18668E+00_JPRB,0.36910E+00_JPRB,0.55360E+00_JPRB,0.73806E+00_JPRB, &
 & 0.92245E+00_JPRB,0.11065E+01_JPRB,0.12896E+01_JPRB,0.14724E+01_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.19100E+00_JPRB,0.20029E+00_JPRB,0.40054E+00_JPRB,0.60077E+00_JPRB,0.80095E+00_JPRB, &
 & 0.10010E+01_JPRB,0.12008E+01_JPRB,0.13997E+01_JPRB,0.15979E+01_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.18556E+00_JPRB,0.21465E+00_JPRB,0.42926E+00_JPRB,0.64385E+00_JPRB,0.85838E+00_JPRB, &
 & 0.10728E+01_JPRB,0.12869E+01_JPRB,0.15000E+01_JPRB,0.17126E+01_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.18024E+00_JPRB,0.22760E+00_JPRB,0.45517E+00_JPRB,0.68271E+00_JPRB,0.91019E+00_JPRB, &
 & 0.11375E+01_JPRB,0.13647E+01_JPRB,0.15907E+01_JPRB,0.18161E+01_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.24417E+00_JPRB,0.21368E+00_JPRB,0.37507E+00_JPRB,0.56256E+00_JPRB,0.75006E+00_JPRB, &
 & 0.93742E+00_JPRB,0.11245E+01_JPRB,0.13107E+01_JPRB,0.14982E+01_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.23715E+00_JPRB,0.21661E+00_JPRB,0.41650E+00_JPRB,0.62470E+00_JPRB,0.83285E+00_JPRB, &
 & 0.10409E+01_JPRB,0.12487E+01_JPRB,0.14555E+01_JPRB,0.16638E+01_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.23022E+00_JPRB,0.22856E+00_JPRB,0.45485E+00_JPRB,0.68222E+00_JPRB,0.90954E+00_JPRB, &
 & 0.11367E+01_JPRB,0.13637E+01_JPRB,0.15896E+01_JPRB,0.18170E+01_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.22335E+00_JPRB,0.24491E+00_JPRB,0.48979E+00_JPRB,0.73464E+00_JPRB,0.97947E+00_JPRB, &
 & 0.12241E+01_JPRB,0.14686E+01_JPRB,0.17118E+01_JPRB,0.19566E+01_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.21655E+00_JPRB,0.26068E+00_JPRB,0.52133E+00_JPRB,0.78194E+00_JPRB,0.10425E+01_JPRB, &
 & 0.13029E+01_JPRB,0.15630E+01_JPRB,0.18220E+01_JPRB,0.20827E+01_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.29541E+00_JPRB,0.25848E+00_JPRB,0.41687E+00_JPRB,0.62527E+00_JPRB,0.83361E+00_JPRB, &
 & 0.10419E+01_JPRB,0.12499E+01_JPRB,0.14571E+01_JPRB,0.16668E+01_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.28549E+00_JPRB,0.25449E+00_JPRB,0.46724E+00_JPRB,0.70082E+00_JPRB,0.93434E+00_JPRB, &
 & 0.11678E+01_JPRB,0.14009E+01_JPRB,0.16328E+01_JPRB,0.18680E+01_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.27625E+00_JPRB,0.26285E+00_JPRB,0.51364E+00_JPRB,0.77040E+00_JPRB,0.10271E+01_JPRB, &
 & 0.12838E+01_JPRB,0.15402E+01_JPRB,0.17956E+01_JPRB,0.20538E+01_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.26742E+00_JPRB,0.27883E+00_JPRB,0.55601E+00_JPRB,0.83395E+00_JPRB,0.11118E+01_JPRB, &
 & 0.13896E+01_JPRB,0.16670E+01_JPRB,0.19436E+01_JPRB,0.22230E+01_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.25873E+00_JPRB,0.29706E+00_JPRB,0.59410E+00_JPRB,0.89109E+00_JPRB,0.11880E+01_JPRB, &
 & 0.14848E+01_JPRB,0.17812E+01_JPRB,0.20764E+01_JPRB,0.23753E+01_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.35727E+00_JPRB,0.31262E+00_JPRB,0.45859E+00_JPRB,0.68783E+00_JPRB,0.91710E+00_JPRB, &
 & 0.11462E+01_JPRB,0.13749E+01_JPRB,0.16027E+01_JPRB,0.18342E+01_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.34378E+00_JPRB,0.30157E+00_JPRB,0.51912E+00_JPRB,0.77863E+00_JPRB,0.10382E+01_JPRB, &
 & 0.12975E+01_JPRB,0.15566E+01_JPRB,0.18147E+01_JPRB,0.20764E+01_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.33111E+00_JPRB,0.30494E+00_JPRB,0.57506E+00_JPRB,0.86254E+00_JPRB,0.11500E+01_JPRB, &
 & 0.14374E+01_JPRB,0.17244E+01_JPRB,0.20104E+01_JPRB,0.23002E+01_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.31901E+00_JPRB,0.31860E+00_JPRB,0.62597E+00_JPRB,0.93889E+00_JPRB,0.12519E+01_JPRB, &
 & 0.15648E+01_JPRB,0.18772E+01_JPRB,0.21885E+01_JPRB,0.25042E+01_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.30738E+00_JPRB,0.33686E+00_JPRB,0.67173E+00_JPRB,0.10075E+01_JPRB,0.13433E+01_JPRB, &
 & 0.16788E+01_JPRB,0.20142E+01_JPRB,0.23482E+01_JPRB,0.26866E+01_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.42900E+00_JPRB,0.37537E+00_JPRB,0.50742E+00_JPRB,0.76107E+00_JPRB,0.10147E+01_JPRB, &
 & 0.12682E+01_JPRB,0.15216E+01_JPRB,0.17737E+01_JPRB,0.20298E+01_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.41120E+00_JPRB,0.35980E+00_JPRB,0.57626E+00_JPRB,0.86440E+00_JPRB,0.11524E+01_JPRB, &
 & 0.14403E+01_JPRB,0.17281E+01_JPRB,0.20148E+01_JPRB,0.23052E+01_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.39435E+00_JPRB,0.35582E+00_JPRB,0.64201E+00_JPRB,0.96295E+00_JPRB,0.12838E+01_JPRB, &
 & 0.16046E+01_JPRB,0.19250E+01_JPRB,0.22444E+01_JPRB,0.25680E+01_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.37835E+00_JPRB,0.36721E+00_JPRB,0.70220E+00_JPRB,0.10532E+01_JPRB,0.14042E+01_JPRB, &
 & 0.17550E+01_JPRB,0.21055E+01_JPRB,0.24551E+01_JPRB,0.28089E+01_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.36302E+00_JPRB,0.38402E+00_JPRB,0.75599E+00_JPRB,0.11339E+01_JPRB,0.15118E+01_JPRB, &
 & 0.18894E+01_JPRB,0.22669E+01_JPRB,0.26429E+01_JPRB,0.30243E+01_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.50130E+00_JPRB,0.43864E+00_JPRB,0.59754E+00_JPRB,0.89626E+00_JPRB,0.11949E+01_JPRB, &
 & 0.14934E+01_JPRB,0.17919E+01_JPRB,0.20890E+01_JPRB,0.23902E+01_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.47862E+00_JPRB,0.41971E+00_JPRB,0.67375E+00_JPRB,0.10106E+01_JPRB,0.13473E+01_JPRB, &
 & 0.16840E+01_JPRB,0.20203E+01_JPRB,0.23553E+01_JPRB,0.26950E+01_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.45729E+00_JPRB,0.41739E+00_JPRB,0.74475E+00_JPRB,0.11171E+01_JPRB,0.14893E+01_JPRB, &
 & 0.18615E+01_JPRB,0.22335E+01_JPRB,0.26038E+01_JPRB,0.29786E+01_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.43691E+00_JPRB,0.42957E+00_JPRB,0.80967E+00_JPRB,0.12144E+01_JPRB,0.16191E+01_JPRB, &
 & 0.20236E+01_JPRB,0.24280E+01_JPRB,0.28308E+01_JPRB,0.32389E+01_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.41748E+00_JPRB,0.44621E+00_JPRB,0.86800E+00_JPRB,0.13019E+01_JPRB,0.17360E+01_JPRB, &
 & 0.21698E+01_JPRB,0.26031E+01_JPRB,0.30355E+01_JPRB,0.34723E+01_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.58052E+00_JPRB,0.50796E+00_JPRB,0.69775E+00_JPRB,0.10466E+01_JPRB,0.13954E+01_JPRB, &
 & 0.17440E+01_JPRB,0.20924E+01_JPRB,0.24394E+01_JPRB,0.27908E+01_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.55207E+00_JPRB,0.48627E+00_JPRB,0.78177E+00_JPRB,0.11726E+01_JPRB,0.15635E+01_JPRB, &
 & 0.19543E+01_JPRB,0.23447E+01_JPRB,0.27336E+01_JPRB,0.31273E+01_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.52503E+00_JPRB,0.48543E+00_JPRB,0.85881E+00_JPRB,0.12881E+01_JPRB,0.17174E+01_JPRB, &
 & 0.21467E+01_JPRB,0.25754E+01_JPRB,0.30027E+01_JPRB,0.34355E+01_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.49945E+00_JPRB,0.49746E+00_JPRB,0.92780E+00_JPRB,0.13917E+01_JPRB,0.18554E+01_JPRB, &
 & 0.23191E+01_JPRB,0.27823E+01_JPRB,0.32446E+01_JPRB,0.37108E+01_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.47536E+00_JPRB,0.51344E+00_JPRB,0.98885E+00_JPRB,0.14832E+01_JPRB,0.19776E+01_JPRB, &
 & 0.24717E+01_JPRB,0.29655E+01_JPRB,0.34576E+01_JPRB,0.39563E+01_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.66560E+00_JPRB,0.58240E+00_JPRB,0.80598E+00_JPRB,0.12089E+01_JPRB,0.16118E+01_JPRB, &
 & 0.20145E+01_JPRB,0.24172E+01_JPRB,0.28183E+01_JPRB,0.32240E+01_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.62986E+00_JPRB,0.55885E+00_JPRB,0.89794E+00_JPRB,0.13468E+01_JPRB,0.17957E+01_JPRB, &
 & 0.22443E+01_JPRB,0.26925E+01_JPRB,0.31396E+01_JPRB,0.35914E+01_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.59613E+00_JPRB,0.55868E+00_JPRB,0.98065E+00_JPRB,0.14709E+01_JPRB,0.19611E+01_JPRB, &
 & 0.24513E+01_JPRB,0.29409E+01_JPRB,0.34293E+01_JPRB,0.39230E+01_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.56427E+00_JPRB,0.56950E+00_JPRB,0.10539E+01_JPRB,0.15808E+01_JPRB,0.21076E+01_JPRB, &
 & 0.26342E+01_JPRB,0.31605E+01_JPRB,0.36850E+01_JPRB,0.42159E+01_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.53530E+00_JPRB,0.58425E+00_JPRB,0.11174E+01_JPRB,0.16761E+01_JPRB,0.22346E+01_JPRB, &
 & 0.27933E+01_JPRB,0.33512E+01_JPRB,0.39078E+01_JPRB,0.44703E+01_JPRB /)  
  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.12810E-03_JPRB,0.12891E-03_JPRB,0.12890E-03_JPRB,0.12713E-03_JPRB,0.12477E-03_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.10653E-03_JPRB,0.10667E-03_JPRB,0.10648E-03_JPRB,0.10473E-03_JPRB,0.10293E-03_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.90176E-04_JPRB,0.90077E-04_JPRB,0.89286E-04_JPRB,0.87879E-04_JPRB,0.85987E-04_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.77704E-04_JPRB,0.77304E-04_JPRB,0.75879E-04_JPRB,0.74246E-04_JPRB,0.72070E-04_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.67183E-04_JPRB,0.65906E-04_JPRB,0.64619E-04_JPRB,0.63000E-04_JPRB,0.61056E-04_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.58741E-04_JPRB,0.57649E-04_JPRB,0.56028E-04_JPRB,0.54293E-04_JPRB,0.52506E-04_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.51839E-04_JPRB,0.50715E-04_JPRB,0.49053E-04_JPRB,0.47195E-04_JPRB,0.45368E-04_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.44321E-04_JPRB,0.43297E-04_JPRB,0.41923E-04_JPRB,0.40298E-04_JPRB,0.38744E-04_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.37527E-04_JPRB,0.36516E-04_JPRB,0.35380E-04_JPRB,0.34037E-04_JPRB,0.32951E-04_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.31752E-04_JPRB,0.30703E-04_JPRB,0.29586E-04_JPRB,0.28499E-04_JPRB,0.27519E-04_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.26638E-04_JPRB,0.25643E-04_JPRB,0.24693E-04_JPRB,0.23832E-04_JPRB,0.22913E-04_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.22325E-04_JPRB,0.21480E-04_JPRB,0.20621E-04_JPRB,0.19867E-04_JPRB,0.19066E-04_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.18764E-04_JPRB,0.17998E-04_JPRB,0.17269E-04_JPRB,0.16527E-04_JPRB,0.15821E-04_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.15650E-04_JPRB,0.14992E-04_JPRB,0.14356E-04_JPRB,0.13710E-04_JPRB,0.13119E-04_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.13054E-04_JPRB,0.12477E-04_JPRB,0.11929E-04_JPRB,0.11393E-04_JPRB,0.10948E-04_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.10852E-04_JPRB,0.10390E-04_JPRB,0.99195E-05_JPRB,0.95020E-05_JPRB,0.91993E-05_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.90990E-05_JPRB,0.87209E-05_JPRB,0.83384E-05_JPRB,0.80029E-05_JPRB,0.77245E-05_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.77169E-05_JPRB,0.73662E-05_JPRB,0.70552E-05_JPRB,0.68029E-05_JPRB,0.65749E-05_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.65250E-05_JPRB,0.62364E-05_JPRB,0.60172E-05_JPRB,0.57804E-05_JPRB,0.55504E-05_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.55167E-05_JPRB,0.53021E-05_JPRB,0.51088E-05_JPRB,0.49113E-05_JPRB,0.47150E-05_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.47261E-05_JPRB,0.45530E-05_JPRB,0.43641E-05_JPRB,0.41725E-05_JPRB,0.40077E-05_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.40646E-05_JPRB,0.39062E-05_JPRB,0.37472E-05_JPRB,0.36009E-05_JPRB,0.34549E-05_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.35479E-05_JPRB,0.34057E-05_JPRB,0.32704E-05_JPRB,0.31420E-05_JPRB,0.30219E-05_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.31353E-05_JPRB,0.30270E-05_JPRB,0.29024E-05_JPRB,0.27776E-05_JPRB,0.26600E-05_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.26595E-05_JPRB,0.25621E-05_JPRB,0.24646E-05_JPRB,0.23582E-05_JPRB,0.22563E-05_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.22468E-05_JPRB,0.21651E-05_JPRB,0.20812E-05_JPRB,0.20043E-05_JPRB,0.19221E-05_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.19009E-05_JPRB,0.18335E-05_JPRB,0.17685E-05_JPRB,0.17039E-05_JPRB,0.16406E-05_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.15746E-05_JPRB,0.15188E-05_JPRB,0.14669E-05_JPRB,0.14148E-05_JPRB,0.13668E-05_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.13001E-05_JPRB,0.12561E-05_JPRB,0.12122E-05_JPRB,0.11718E-05_JPRB,0.11306E-05_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.10716E-05_JPRB,0.10380E-05_JPRB,0.10018E-05_JPRB,0.96745E-06_JPRB,0.93475E-06_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.87651E-06_JPRB,0.85172E-06_JPRB,0.82453E-06_JPRB,0.79560E-06_JPRB,0.77011E-06_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.71565E-06_JPRB,0.69699E-06_JPRB,0.67699E-06_JPRB,0.65403E-06_JPRB,0.63202E-06_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.58391E-06_JPRB,0.56946E-06_JPRB,0.55318E-06_JPRB,0.53575E-06_JPRB,0.51774E-06_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.47490E-06_JPRB,0.46531E-06_JPRB,0.45175E-06_JPRB,0.43686E-06_JPRB,0.42260E-06_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.38718E-06_JPRB,0.37610E-06_JPRB,0.36650E-06_JPRB,0.35580E-06_JPRB,0.34417E-06_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.31464E-06_JPRB,0.30494E-06_JPRB,0.29872E-06_JPRB,0.29096E-06_JPRB,0.28230E-06_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.25542E-06_JPRB,0.24885E-06_JPRB,0.24314E-06_JPRB,0.23745E-06_JPRB,0.23092E-06_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.20741E-06_JPRB,0.20175E-06_JPRB,0.19699E-06_JPRB,0.19305E-06_JPRB,0.18791E-06_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.16760E-06_JPRB,0.16406E-06_JPRB,0.15993E-06_JPRB,0.15631E-06_JPRB,0.15327E-06_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.13579E-06_JPRB,0.13287E-06_JPRB,0.12985E-06_JPRB,0.12725E-06_JPRB,0.12470E-06_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.11006E-06_JPRB,0.10757E-06_JPRB,0.10568E-06_JPRB,0.10314E-06_JPRB,0.10101E-06_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.88711E-07_JPRB,0.87131E-07_JPRB,0.85162E-07_JPRB,0.83405E-07_JPRB,0.81585E-07_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.70889E-07_JPRB,0.69917E-07_JPRB,0.68692E-07_JPRB,0.67463E-07_JPRB,0.66047E-07_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.56659E-07_JPRB,0.56077E-07_JPRB,0.55518E-07_JPRB,0.54462E-07_JPRB,0.53563E-07_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.45380E-07_JPRB,0.45159E-07_JPRB,0.44718E-07_JPRB,0.44063E-07_JPRB,0.43116E-07_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.35962E-07_JPRB,0.36177E-07_JPRB,0.35997E-07_JPRB,0.35600E-07_JPRB,0.34340E-07_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.28578E-07_JPRB,0.28924E-07_JPRB,0.28901E-07_JPRB,0.28176E-07_JPRB,0.27246E-07_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.63215E-03_JPRB,0.64756E-03_JPRB,0.65734E-03_JPRB,0.66515E-03_JPRB,0.67077E-03_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.52378E-03_JPRB,0.53631E-03_JPRB,0.54485E-03_JPRB,0.55071E-03_JPRB,0.55605E-03_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.43777E-03_JPRB,0.44814E-03_JPRB,0.45521E-03_JPRB,0.46124E-03_JPRB,0.46700E-03_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.37023E-03_JPRB,0.37869E-03_JPRB,0.38568E-03_JPRB,0.39070E-03_JPRB,0.39760E-03_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.31753E-03_JPRB,0.32632E-03_JPRB,0.33254E-03_JPRB,0.33817E-03_JPRB,0.34312E-03_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.27580E-03_JPRB,0.28310E-03_JPRB,0.28915E-03_JPRB,0.29488E-03_JPRB,0.29855E-03_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.24129E-03_JPRB,0.24697E-03_JPRB,0.25302E-03_JPRB,0.25785E-03_JPRB,0.26137E-03_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.20470E-03_JPRB,0.21040E-03_JPRB,0.21552E-03_JPRB,0.21963E-03_JPRB,0.22260E-03_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.17290E-03_JPRB,0.17782E-03_JPRB,0.18188E-03_JPRB,0.18513E-03_JPRB,0.18794E-03_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.14599E-03_JPRB,0.15063E-03_JPRB,0.15389E-03_JPRB,0.15682E-03_JPRB,0.15965E-03_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.12390E-03_JPRB,0.12797E-03_JPRB,0.13071E-03_JPRB,0.13347E-03_JPRB,0.13571E-03_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.10553E-03_JPRB,0.10875E-03_JPRB,0.11134E-03_JPRB,0.11351E-03_JPRB,0.11513E-03_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.90263E-04_JPRB,0.92560E-04_JPRB,0.94667E-04_JPRB,0.96225E-04_JPRB,0.97041E-04_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.76542E-04_JPRB,0.78227E-04_JPRB,0.79755E-04_JPRB,0.80768E-04_JPRB,0.81412E-04_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.64562E-04_JPRB,0.66024E-04_JPRB,0.67121E-04_JPRB,0.67878E-04_JPRB,0.67992E-04_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.54587E-04_JPRB,0.55668E-04_JPRB,0.56439E-04_JPRB,0.56778E-04_JPRB,0.56649E-04_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.46248E-04_JPRB,0.46885E-04_JPRB,0.47469E-04_JPRB,0.47476E-04_JPRB,0.47464E-04_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.39084E-04_JPRB,0.39701E-04_JPRB,0.39836E-04_JPRB,0.39919E-04_JPRB,0.39762E-04_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.33297E-04_JPRB,0.33670E-04_JPRB,0.33781E-04_JPRB,0.33571E-04_JPRB,0.33418E-04_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.28475E-04_JPRB,0.28479E-04_JPRB,0.28352E-04_JPRB,0.28202E-04_JPRB,0.28107E-04_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.24023E-04_JPRB,0.23977E-04_JPRB,0.23874E-04_JPRB,0.23858E-04_JPRB,0.23729E-04_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.20276E-04_JPRB,0.20314E-04_JPRB,0.20262E-04_JPRB,0.20205E-04_JPRB,0.20013E-04_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.17177E-04_JPRB,0.17179E-04_JPRB,0.17181E-04_JPRB,0.17048E-04_JPRB,0.16915E-04_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.14586E-04_JPRB,0.14632E-04_JPRB,0.14569E-04_JPRB,0.14465E-04_JPRB,0.14404E-04_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.12165E-04_JPRB,0.12220E-04_JPRB,0.12164E-04_JPRB,0.12099E-04_JPRB,0.12036E-04_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.10178E-04_JPRB,0.10224E-04_JPRB,0.10201E-04_JPRB,0.10134E-04_JPRB,0.10060E-04_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.85622E-05_JPRB,0.85826E-05_JPRB,0.85520E-05_JPRB,0.85109E-05_JPRB,0.84378E-05_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.70263E-05_JPRB,0.70549E-05_JPRB,0.70334E-05_JPRB,0.70000E-05_JPRB,0.69500E-05_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.57510E-05_JPRB,0.57749E-05_JPRB,0.57692E-05_JPRB,0.57384E-05_JPRB,0.57121E-05_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.47038E-05_JPRB,0.47261E-05_JPRB,0.47278E-05_JPRB,0.47023E-05_JPRB,0.46867E-05_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.38249E-05_JPRB,0.38339E-05_JPRB,0.38498E-05_JPRB,0.38364E-05_JPRB,0.38125E-05_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.30973E-05_JPRB,0.31120E-05_JPRB,0.31166E-05_JPRB,0.31203E-05_JPRB,0.31022E-05_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.25085E-05_JPRB,0.25263E-05_JPRB,0.25293E-05_JPRB,0.25328E-05_JPRB,0.25249E-05_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.20261E-05_JPRB,0.20479E-05_JPRB,0.20565E-05_JPRB,0.20575E-05_JPRB,0.20588E-05_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.16319E-05_JPRB,0.16639E-05_JPRB,0.16745E-05_JPRB,0.16740E-05_JPRB,0.16759E-05_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.13097E-05_JPRB,0.13449E-05_JPRB,0.13611E-05_JPRB,0.13624E-05_JPRB,0.13589E-05_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.10521E-05_JPRB,0.10847E-05_JPRB,0.11052E-05_JPRB,0.11102E-05_JPRB,0.11085E-05_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.84668E-06_JPRB,0.87235E-06_JPRB,0.89544E-06_JPRB,0.90607E-06_JPRB,0.90616E-06_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.68060E-06_JPRB,0.70180E-06_JPRB,0.72187E-06_JPRB,0.73562E-06_JPRB,0.73800E-06_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.54634E-06_JPRB,0.56481E-06_JPRB,0.58256E-06_JPRB,0.59543E-06_JPRB,0.60122E-06_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.43866E-06_JPRB,0.45577E-06_JPRB,0.46957E-06_JPRB,0.48176E-06_JPRB,0.48940E-06_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.35062E-06_JPRB,0.36647E-06_JPRB,0.37935E-06_JPRB,0.38978E-06_JPRB,0.39697E-06_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.27883E-06_JPRB,0.29514E-06_JPRB,0.30397E-06_JPRB,0.31251E-06_JPRB,0.32004E-06_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.22098E-06_JPRB,0.23550E-06_JPRB,0.24289E-06_JPRB,0.25018E-06_JPRB,0.25708E-06_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.17295E-06_JPRB,0.18624E-06_JPRB,0.19332E-06_JPRB,0.19934E-06_JPRB,0.20587E-06_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.13623E-06_JPRB,0.14680E-06_JPRB,0.15403E-06_JPRB,0.15912E-06_JPRB,0.16499E-06_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.10864E-06_JPRB,0.11680E-06_JPRB,0.12353E-06_JPRB,0.12840E-06_JPRB,0.13352E-06_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.21069E-02_JPRB,0.21571E-02_JPRB,0.21943E-02_JPRB,0.22061E-02_JPRB,0.22124E-02_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.17411E-02_JPRB,0.17833E-02_JPRB,0.18097E-02_JPRB,0.18225E-02_JPRB,0.18251E-02_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.14440E-02_JPRB,0.14790E-02_JPRB,0.14963E-02_JPRB,0.15066E-02_JPRB,0.15066E-02_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.11998E-02_JPRB,0.12261E-02_JPRB,0.12398E-02_JPRB,0.12500E-02_JPRB,0.12487E-02_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.99980E-03_JPRB,0.10202E-02_JPRB,0.10332E-02_JPRB,0.10399E-02_JPRB,0.10392E-02_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.83805E-03_JPRB,0.85629E-03_JPRB,0.86827E-03_JPRB,0.87303E-03_JPRB,0.87540E-03_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.70743E-03_JPRB,0.72381E-03_JPRB,0.73251E-03_JPRB,0.73550E-03_JPRB,0.73931E-03_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.59348E-03_JPRB,0.60572E-03_JPRB,0.61137E-03_JPRB,0.61496E-03_JPRB,0.61761E-03_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.49556E-03_JPRB,0.50488E-03_JPRB,0.50987E-03_JPRB,0.51421E-03_JPRB,0.51581E-03_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.41461E-03_JPRB,0.42145E-03_JPRB,0.42584E-03_JPRB,0.42969E-03_JPRB,0.43055E-03_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.34683E-03_JPRB,0.35181E-03_JPRB,0.35660E-03_JPRB,0.35911E-03_JPRB,0.35958E-03_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.29004E-03_JPRB,0.29383E-03_JPRB,0.29787E-03_JPRB,0.29964E-03_JPRB,0.30042E-03_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.24146E-03_JPRB,0.24561E-03_JPRB,0.24879E-03_JPRB,0.25053E-03_JPRB,0.25134E-03_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.20160E-03_JPRB,0.20537E-03_JPRB,0.20774E-03_JPRB,0.20928E-03_JPRB,0.21023E-03_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.16916E-03_JPRB,0.17226E-03_JPRB,0.17386E-03_JPRB,0.17529E-03_JPRB,0.17634E-03_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.14183E-03_JPRB,0.14414E-03_JPRB,0.14604E-03_JPRB,0.14741E-03_JPRB,0.14844E-03_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.11954E-03_JPRB,0.12161E-03_JPRB,0.12286E-03_JPRB,0.12386E-03_JPRB,0.12448E-03_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.10067E-03_JPRB,0.10205E-03_JPRB,0.10331E-03_JPRB,0.10409E-03_JPRB,0.10476E-03_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.85014E-04_JPRB,0.86248E-04_JPRB,0.87024E-04_JPRB,0.87958E-04_JPRB,0.88579E-04_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.71930E-04_JPRB,0.73074E-04_JPRB,0.73985E-04_JPRB,0.74934E-04_JPRB,0.74848E-04_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.61205E-04_JPRB,0.62259E-04_JPRB,0.63209E-04_JPRB,0.63383E-04_JPRB,0.63466E-04_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.52046E-04_JPRB,0.52896E-04_JPRB,0.53420E-04_JPRB,0.53516E-04_JPRB,0.53755E-04_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.44380E-04_JPRB,0.45121E-04_JPRB,0.45277E-04_JPRB,0.45604E-04_JPRB,0.45761E-04_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.38058E-04_JPRB,0.38409E-04_JPRB,0.38657E-04_JPRB,0.38813E-04_JPRB,0.38628E-04_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.31735E-04_JPRB,0.31990E-04_JPRB,0.32199E-04_JPRB,0.32288E-04_JPRB,0.32179E-04_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.26378E-04_JPRB,0.26667E-04_JPRB,0.26778E-04_JPRB,0.26840E-04_JPRB,0.26760E-04_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.21949E-04_JPRB,0.22195E-04_JPRB,0.22340E-04_JPRB,0.22330E-04_JPRB,0.22281E-04_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.18001E-04_JPRB,0.18209E-04_JPRB,0.18338E-04_JPRB,0.18376E-04_JPRB,0.18309E-04_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.14715E-04_JPRB,0.14906E-04_JPRB,0.15025E-04_JPRB,0.15098E-04_JPRB,0.15026E-04_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.12019E-04_JPRB,0.12197E-04_JPRB,0.12312E-04_JPRB,0.12380E-04_JPRB,0.12346E-04_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.97566E-05_JPRB,0.99318E-05_JPRB,0.10036E-04_JPRB,0.10096E-04_JPRB,0.10118E-04_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.78810E-05_JPRB,0.80716E-05_JPRB,0.81637E-05_JPRB,0.82202E-05_JPRB,0.82608E-05_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.63541E-05_JPRB,0.65171E-05_JPRB,0.66330E-05_JPRB,0.66977E-05_JPRB,0.67239E-05_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.51077E-05_JPRB,0.52428E-05_JPRB,0.53636E-05_JPRB,0.54363E-05_JPRB,0.54693E-05_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.40883E-05_JPRB,0.42196E-05_JPRB,0.43199E-05_JPRB,0.44074E-05_JPRB,0.44462E-05_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.32909E-05_JPRB,0.33941E-05_JPRB,0.34746E-05_JPRB,0.35546E-05_JPRB,0.36089E-05_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.26401E-05_JPRB,0.27269E-05_JPRB,0.28003E-05_JPRB,0.28616E-05_JPRB,0.29188E-05_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.21222E-05_JPRB,0.22032E-05_JPRB,0.22638E-05_JPRB,0.23127E-05_JPRB,0.23603E-05_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.17056E-05_JPRB,0.17838E-05_JPRB,0.18386E-05_JPRB,0.18804E-05_JPRB,0.19134E-05_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.13662E-05_JPRB,0.14333E-05_JPRB,0.14855E-05_JPRB,0.15238E-05_JPRB,0.15521E-05_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.10889E-05_JPRB,0.11445E-05_JPRB,0.11955E-05_JPRB,0.12300E-05_JPRB,0.12560E-05_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.86251E-06_JPRB,0.91556E-06_JPRB,0.95999E-06_JPRB,0.99454E-06_JPRB,0.10171E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART13',0,ZHOOK_HANDLE)


KB(:,55, 3) = (/ &
 & 0.68640E-06_JPRB,0.72868E-06_JPRB,0.77389E-06_JPRB,0.80627E-06_JPRB,0.82696E-06_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.54334E-06_JPRB,0.58339E-06_JPRB,0.61953E-06_JPRB,0.65190E-06_JPRB,0.67285E-06_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.43336E-06_JPRB,0.46511E-06_JPRB,0.49561E-06_JPRB,0.52337E-06_JPRB,0.54491E-06_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.34428E-06_JPRB,0.37236E-06_JPRB,0.39687E-06_JPRB,0.42017E-06_JPRB,0.43790E-06_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.27883E-06_JPRB,0.30237E-06_JPRB,0.32096E-06_JPRB,0.33978E-06_JPRB,0.35485E-06_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.52806E-02_JPRB,0.53551E-02_JPRB,0.53836E-02_JPRB,0.53810E-02_JPRB,0.53413E-02_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.43594E-02_JPRB,0.44114E-02_JPRB,0.44268E-02_JPRB,0.44183E-02_JPRB,0.43877E-02_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.36080E-02_JPRB,0.36421E-02_JPRB,0.36603E-02_JPRB,0.36540E-02_JPRB,0.36307E-02_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.30007E-02_JPRB,0.30324E-02_JPRB,0.30479E-02_JPRB,0.30377E-02_JPRB,0.30175E-02_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.25113E-02_JPRB,0.25415E-02_JPRB,0.25489E-02_JPRB,0.25428E-02_JPRB,0.25281E-02_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.21119E-02_JPRB,0.21340E-02_JPRB,0.21396E-02_JPRB,0.21381E-02_JPRB,0.21232E-02_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.17705E-02_JPRB,0.17884E-02_JPRB,0.17942E-02_JPRB,0.17931E-02_JPRB,0.17819E-02_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.14714E-02_JPRB,0.14854E-02_JPRB,0.14921E-02_JPRB,0.14920E-02_JPRB,0.14874E-02_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.12224E-02_JPRB,0.12349E-02_JPRB,0.12432E-02_JPRB,0.12411E-02_JPRB,0.12395E-02_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.10170E-02_JPRB,0.10281E-02_JPRB,0.10319E-02_JPRB,0.10310E-02_JPRB,0.10286E-02_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.84681E-03_JPRB,0.85484E-03_JPRB,0.85517E-03_JPRB,0.85545E-03_JPRB,0.85571E-03_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.70330E-03_JPRB,0.70875E-03_JPRB,0.71078E-03_JPRB,0.71261E-03_JPRB,0.71112E-03_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.58481E-03_JPRB,0.58870E-03_JPRB,0.59157E-03_JPRB,0.59305E-03_JPRB,0.59234E-03_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.48640E-03_JPRB,0.49044E-03_JPRB,0.49395E-03_JPRB,0.49468E-03_JPRB,0.49466E-03_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.40472E-03_JPRB,0.40915E-03_JPRB,0.41235E-03_JPRB,0.41278E-03_JPRB,0.41345E-03_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.33826E-03_JPRB,0.34205E-03_JPRB,0.34364E-03_JPRB,0.34480E-03_JPRB,0.34528E-03_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.28308E-03_JPRB,0.28627E-03_JPRB,0.28792E-03_JPRB,0.28910E-03_JPRB,0.28958E-03_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.23759E-03_JPRB,0.23994E-03_JPRB,0.24196E-03_JPRB,0.24295E-03_JPRB,0.24270E-03_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.19993E-03_JPRB,0.20202E-03_JPRB,0.20390E-03_JPRB,0.20456E-03_JPRB,0.20411E-03_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.16851E-03_JPRB,0.17060E-03_JPRB,0.17151E-03_JPRB,0.17169E-03_JPRB,0.17133E-03_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.14275E-03_JPRB,0.14392E-03_JPRB,0.14445E-03_JPRB,0.14452E-03_JPRB,0.14399E-03_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.12060E-03_JPRB,0.12142E-03_JPRB,0.12181E-03_JPRB,0.12165E-03_JPRB,0.12105E-03_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.10168E-03_JPRB,0.10240E-03_JPRB,0.10276E-03_JPRB,0.10261E-03_JPRB,0.10202E-03_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.85780E-04_JPRB,0.86636E-04_JPRB,0.86815E-04_JPRB,0.86780E-04_JPRB,0.86722E-04_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.71540E-04_JPRB,0.72201E-04_JPRB,0.72422E-04_JPRB,0.72501E-04_JPRB,0.72398E-04_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.59609E-04_JPRB,0.60152E-04_JPRB,0.60443E-04_JPRB,0.60540E-04_JPRB,0.60534E-04_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.49681E-04_JPRB,0.50194E-04_JPRB,0.50481E-04_JPRB,0.50649E-04_JPRB,0.50643E-04_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.40815E-04_JPRB,0.41335E-04_JPRB,0.41565E-04_JPRB,0.41729E-04_JPRB,0.41776E-04_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.33476E-04_JPRB,0.33932E-04_JPRB,0.34171E-04_JPRB,0.34301E-04_JPRB,0.34397E-04_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.27419E-04_JPRB,0.27824E-04_JPRB,0.28083E-04_JPRB,0.28221E-04_JPRB,0.28296E-04_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.22349E-04_JPRB,0.22753E-04_JPRB,0.22975E-04_JPRB,0.23100E-04_JPRB,0.23164E-04_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.18197E-04_JPRB,0.18488E-04_JPRB,0.18747E-04_JPRB,0.18878E-04_JPRB,0.18943E-04_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.14815E-04_JPRB,0.15081E-04_JPRB,0.15284E-04_JPRB,0.15408E-04_JPRB,0.15493E-04_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.12046E-04_JPRB,0.12304E-04_JPRB,0.12476E-04_JPRB,0.12590E-04_JPRB,0.12654E-04_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.97834E-05_JPRB,0.10018E-04_JPRB,0.10187E-04_JPRB,0.10295E-04_JPRB,0.10365E-04_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.79058E-05_JPRB,0.81583E-05_JPRB,0.83158E-05_JPRB,0.84259E-05_JPRB,0.84791E-05_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.63847E-05_JPRB,0.66212E-05_JPRB,0.67735E-05_JPRB,0.68818E-05_JPRB,0.69382E-05_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.51619E-05_JPRB,0.53698E-05_JPRB,0.55239E-05_JPRB,0.56230E-05_JPRB,0.56931E-05_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.41764E-05_JPRB,0.43546E-05_JPRB,0.45018E-05_JPRB,0.45927E-05_JPRB,0.46609E-05_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.33696E-05_JPRB,0.35302E-05_JPRB,0.36585E-05_JPRB,0.37548E-05_JPRB,0.38091E-05_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.27142E-05_JPRB,0.28585E-05_JPRB,0.29700E-05_JPRB,0.30632E-05_JPRB,0.31163E-05_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.21974E-05_JPRB,0.23176E-05_JPRB,0.24169E-05_JPRB,0.24980E-05_JPRB,0.25555E-05_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.17820E-05_JPRB,0.18827E-05_JPRB,0.19647E-05_JPRB,0.20347E-05_JPRB,0.20895E-05_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.14445E-05_JPRB,0.15274E-05_JPRB,0.15999E-05_JPRB,0.16558E-05_JPRB,0.17004E-05_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.11612E-05_JPRB,0.12390E-05_JPRB,0.13020E-05_JPRB,0.13508E-05_JPRB,0.13881E-05_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.93606E-06_JPRB,0.10017E-05_JPRB,0.10598E-05_JPRB,0.11016E-05_JPRB,0.11367E-05_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.76682E-06_JPRB,0.82318E-06_JPRB,0.87281E-06_JPRB,0.91208E-06_JPRB,0.94037E-06_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.12856E-01_JPRB,0.13079E-01_JPRB,0.13167E-01_JPRB,0.13177E-01_JPRB,0.13097E-01_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.10708E-01_JPRB,0.10853E-01_JPRB,0.10911E-01_JPRB,0.10898E-01_JPRB,0.10814E-01_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.88690E-02_JPRB,0.89759E-02_JPRB,0.90116E-02_JPRB,0.89730E-02_JPRB,0.88895E-02_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.73377E-02_JPRB,0.74116E-02_JPRB,0.74224E-02_JPRB,0.73845E-02_JPRB,0.73097E-02_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.61050E-02_JPRB,0.61465E-02_JPRB,0.61522E-02_JPRB,0.61190E-02_JPRB,0.60607E-02_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.51170E-02_JPRB,0.51524E-02_JPRB,0.51567E-02_JPRB,0.51299E-02_JPRB,0.50853E-02_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.42872E-02_JPRB,0.43210E-02_JPRB,0.43249E-02_JPRB,0.43090E-02_JPRB,0.42772E-02_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.35726E-02_JPRB,0.35987E-02_JPRB,0.36030E-02_JPRB,0.35888E-02_JPRB,0.35606E-02_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.29687E-02_JPRB,0.29865E-02_JPRB,0.29887E-02_JPRB,0.29805E-02_JPRB,0.29536E-02_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.24631E-02_JPRB,0.24766E-02_JPRB,0.24818E-02_JPRB,0.24706E-02_JPRB,0.24511E-02_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.20423E-02_JPRB,0.20574E-02_JPRB,0.20622E-02_JPRB,0.20550E-02_JPRB,0.20390E-02_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.17009E-02_JPRB,0.17137E-02_JPRB,0.17151E-02_JPRB,0.17066E-02_JPRB,0.16944E-02_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.14175E-02_JPRB,0.14281E-02_JPRB,0.14264E-02_JPRB,0.14202E-02_JPRB,0.14101E-02_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.11824E-02_JPRB,0.11879E-02_JPRB,0.11852E-02_JPRB,0.11799E-02_JPRB,0.11727E-02_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.98538E-03_JPRB,0.98799E-03_JPRB,0.98648E-03_JPRB,0.98258E-03_JPRB,0.97798E-03_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.82156E-03_JPRB,0.82317E-03_JPRB,0.82299E-03_JPRB,0.82154E-03_JPRB,0.81913E-03_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.68689E-03_JPRB,0.68935E-03_JPRB,0.68992E-03_JPRB,0.69010E-03_JPRB,0.68854E-03_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.57658E-03_JPRB,0.57999E-03_JPRB,0.58178E-03_JPRB,0.58209E-03_JPRB,0.58220E-03_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.48638E-03_JPRB,0.49049E-03_JPRB,0.49261E-03_JPRB,0.49405E-03_JPRB,0.49565E-03_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.41128E-03_JPRB,0.41527E-03_JPRB,0.41847E-03_JPRB,0.42111E-03_JPRB,0.42278E-03_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.34942E-03_JPRB,0.35347E-03_JPRB,0.35669E-03_JPRB,0.35970E-03_JPRB,0.36033E-03_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.29778E-03_JPRB,0.30183E-03_JPRB,0.30543E-03_JPRB,0.30722E-03_JPRB,0.30756E-03_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.25439E-03_JPRB,0.25855E-03_JPRB,0.26145E-03_JPRB,0.26279E-03_JPRB,0.26328E-03_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.21688E-03_JPRB,0.22055E-03_JPRB,0.22366E-03_JPRB,0.22472E-03_JPRB,0.22545E-03_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.18184E-03_JPRB,0.18525E-03_JPRB,0.18789E-03_JPRB,0.18888E-03_JPRB,0.18981E-03_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.15217E-03_JPRB,0.15529E-03_JPRB,0.15752E-03_JPRB,0.15878E-03_JPRB,0.15947E-03_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.12738E-03_JPRB,0.13010E-03_JPRB,0.13202E-03_JPRB,0.13325E-03_JPRB,0.13405E-03_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.10533E-03_JPRB,0.10771E-03_JPRB,0.10944E-03_JPRB,0.11063E-03_JPRB,0.11132E-03_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.86935E-04_JPRB,0.89079E-04_JPRB,0.90576E-04_JPRB,0.91599E-04_JPRB,0.92136E-04_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.71757E-04_JPRB,0.73600E-04_JPRB,0.74913E-04_JPRB,0.75823E-04_JPRB,0.76332E-04_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.58933E-04_JPRB,0.60448E-04_JPRB,0.61689E-04_JPRB,0.62502E-04_JPRB,0.62968E-04_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.48240E-04_JPRB,0.49626E-04_JPRB,0.50671E-04_JPRB,0.51353E-04_JPRB,0.51808E-04_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.39365E-04_JPRB,0.40603E-04_JPRB,0.41556E-04_JPRB,0.42201E-04_JPRB,0.42661E-04_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.32140E-04_JPRB,0.33199E-04_JPRB,0.34102E-04_JPRB,0.34681E-04_JPRB,0.35122E-04_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.26212E-04_JPRB,0.27122E-04_JPRB,0.27914E-04_JPRB,0.28482E-04_JPRB,0.28883E-04_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.21367E-04_JPRB,0.22132E-04_JPRB,0.22808E-04_JPRB,0.23366E-04_JPRB,0.23750E-04_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.17366E-04_JPRB,0.18036E-04_JPRB,0.18610E-04_JPRB,0.19128E-04_JPRB,0.19501E-04_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.14166E-04_JPRB,0.14744E-04_JPRB,0.15227E-04_JPRB,0.15695E-04_JPRB,0.16033E-04_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.11520E-04_JPRB,0.12036E-04_JPRB,0.12466E-04_JPRB,0.12850E-04_JPRB,0.13177E-04_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.93545E-05_JPRB,0.97967E-05_JPRB,0.10185E-04_JPRB,0.10504E-04_JPRB,0.10808E-04_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.75900E-05_JPRB,0.79775E-05_JPRB,0.83066E-05_JPRB,0.85876E-05_JPRB,0.88446E-05_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.61841E-05_JPRB,0.65213E-05_JPRB,0.67983E-05_JPRB,0.70299E-05_JPRB,0.72479E-05_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.50267E-05_JPRB,0.53142E-05_JPRB,0.55644E-05_JPRB,0.57696E-05_JPRB,0.59449E-05_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.40664E-05_JPRB,0.43169E-05_JPRB,0.45344E-05_JPRB,0.47274E-05_JPRB,0.48783E-05_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.32881E-05_JPRB,0.34993E-05_JPRB,0.36900E-05_JPRB,0.38580E-05_JPRB,0.39983E-05_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.26562E-05_JPRB,0.28386E-05_JPRB,0.30033E-05_JPRB,0.31435E-05_JPRB,0.32655E-05_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.21842E-05_JPRB,0.23355E-05_JPRB,0.24742E-05_JPRB,0.25918E-05_JPRB,0.26979E-05_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.31802E-01_JPRB,0.32385E-01_JPRB,0.32761E-01_JPRB,0.32924E-01_JPRB,0.32887E-01_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.27075E-01_JPRB,0.27526E-01_JPRB,0.27777E-01_JPRB,0.27825E-01_JPRB,0.27714E-01_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.22867E-01_JPRB,0.23213E-01_JPRB,0.23346E-01_JPRB,0.23326E-01_JPRB,0.23192E-01_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.19243E-01_JPRB,0.19469E-01_JPRB,0.19534E-01_JPRB,0.19508E-01_JPRB,0.19374E-01_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.16143E-01_JPRB,0.16291E-01_JPRB,0.16340E-01_JPRB,0.16286E-01_JPRB,0.16140E-01_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.13508E-01_JPRB,0.13619E-01_JPRB,0.13632E-01_JPRB,0.13563E-01_JPRB,0.13444E-01_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.11360E-01_JPRB,0.11423E-01_JPRB,0.11418E-01_JPRB,0.11354E-01_JPRB,0.11254E-01_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.95257E-02_JPRB,0.95677E-02_JPRB,0.95569E-02_JPRB,0.94993E-02_JPRB,0.94147E-02_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.79688E-02_JPRB,0.80079E-02_JPRB,0.79930E-02_JPRB,0.79576E-02_JPRB,0.78976E-02_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.66527E-02_JPRB,0.66824E-02_JPRB,0.66717E-02_JPRB,0.66442E-02_JPRB,0.65988E-02_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.55583E-02_JPRB,0.55741E-02_JPRB,0.55685E-02_JPRB,0.55458E-02_JPRB,0.55136E-02_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.46281E-02_JPRB,0.46404E-02_JPRB,0.46354E-02_JPRB,0.46240E-02_JPRB,0.46070E-02_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.38479E-02_JPRB,0.38586E-02_JPRB,0.38647E-02_JPRB,0.38587E-02_JPRB,0.38482E-02_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.31996E-02_JPRB,0.32113E-02_JPRB,0.32185E-02_JPRB,0.32206E-02_JPRB,0.32221E-02_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.26655E-02_JPRB,0.26804E-02_JPRB,0.26909E-02_JPRB,0.27001E-02_JPRB,0.27000E-02_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.22269E-02_JPRB,0.22430E-02_JPRB,0.22546E-02_JPRB,0.22636E-02_JPRB,0.22685E-02_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.18711E-02_JPRB,0.18853E-02_JPRB,0.19010E-02_JPRB,0.19079E-02_JPRB,0.19146E-02_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.15792E-02_JPRB,0.15950E-02_JPRB,0.16049E-02_JPRB,0.16149E-02_JPRB,0.16250E-02_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.13390E-02_JPRB,0.13523E-02_JPRB,0.13631E-02_JPRB,0.13762E-02_JPRB,0.13899E-02_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.11423E-02_JPRB,0.11552E-02_JPRB,0.11689E-02_JPRB,0.11828E-02_JPRB,0.12002E-02_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.97837E-03_JPRB,0.99414E-03_JPRB,0.10078E-02_JPRB,0.10254E-02_JPRB,0.10445E-02_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.84508E-03_JPRB,0.85961E-03_JPRB,0.87553E-03_JPRB,0.89474E-03_JPRB,0.91454E-03_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.73067E-03_JPRB,0.74643E-03_JPRB,0.76522E-03_JPRB,0.78433E-03_JPRB,0.80547E-03_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.63501E-03_JPRB,0.65286E-03_JPRB,0.67124E-03_JPRB,0.69177E-03_JPRB,0.71245E-03_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.54302E-03_JPRB,0.56011E-03_JPRB,0.57838E-03_JPRB,0.59932E-03_JPRB,0.61930E-03_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.46413E-03_JPRB,0.48141E-03_JPRB,0.49888E-03_JPRB,0.51888E-03_JPRB,0.53851E-03_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.39787E-03_JPRB,0.41416E-03_JPRB,0.43137E-03_JPRB,0.45076E-03_JPRB,0.46884E-03_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.33542E-03_JPRB,0.35026E-03_JPRB,0.36640E-03_JPRB,0.38421E-03_JPRB,0.40074E-03_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.28198E-03_JPRB,0.29533E-03_JPRB,0.31033E-03_JPRB,0.32658E-03_JPRB,0.34246E-03_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.23644E-03_JPRB,0.24877E-03_JPRB,0.26248E-03_JPRB,0.27695E-03_JPRB,0.29184E-03_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.19698E-03_JPRB,0.20826E-03_JPRB,0.22042E-03_JPRB,0.23357E-03_JPRB,0.24697E-03_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.16338E-03_JPRB,0.17334E-03_JPRB,0.18409E-03_JPRB,0.19557E-03_JPRB,0.20792E-03_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.13558E-03_JPRB,0.14397E-03_JPRB,0.15333E-03_JPRB,0.16359E-03_JPRB,0.17463E-03_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.11191E-03_JPRB,0.11919E-03_JPRB,0.12729E-03_JPRB,0.13624E-03_JPRB,0.14629E-03_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.91906E-04_JPRB,0.98189E-04_JPRB,0.10520E-03_JPRB,0.11302E-03_JPRB,0.12177E-03_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.75087E-04_JPRB,0.80743E-04_JPRB,0.86708E-04_JPRB,0.93427E-04_JPRB,0.10110E-03_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.61186E-04_JPRB,0.66125E-04_JPRB,0.71313E-04_JPRB,0.77107E-04_JPRB,0.83777E-04_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.49938E-04_JPRB,0.54303E-04_JPRB,0.58807E-04_JPRB,0.63705E-04_JPRB,0.69474E-04_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.40809E-04_JPRB,0.44513E-04_JPRB,0.48369E-04_JPRB,0.52594E-04_JPRB,0.57525E-04_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.33309E-04_JPRB,0.36401E-04_JPRB,0.39694E-04_JPRB,0.43295E-04_JPRB,0.47517E-04_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.27001E-04_JPRB,0.29637E-04_JPRB,0.32443E-04_JPRB,0.35515E-04_JPRB,0.39073E-04_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.21920E-04_JPRB,0.24176E-04_JPRB,0.26587E-04_JPRB,0.29204E-04_JPRB,0.32173E-04_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.17840E-04_JPRB,0.19707E-04_JPRB,0.21784E-04_JPRB,0.24000E-04_JPRB,0.26498E-04_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.14500E-04_JPRB,0.16042E-04_JPRB,0.17779E-04_JPRB,0.19655E-04_JPRB,0.21743E-04_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.11756E-04_JPRB,0.13018E-04_JPRB,0.14458E-04_JPRB,0.16053E-04_JPRB,0.17779E-04_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.95229E-05_JPRB,0.10574E-04_JPRB,0.11760E-04_JPRB,0.13107E-04_JPRB,0.14585E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART14',0,ZHOOK_HANDLE)


KB(:,59, 6) = (/ &
 & 0.78970E-05_JPRB,0.87821E-05_JPRB,0.97860E-05_JPRB,0.10919E-04_JPRB,0.12187E-04_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.81347E-01_JPRB,0.83688E-01_JPRB,0.85307E-01_JPRB,0.86283E-01_JPRB,0.87010E-01_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.72041E-01_JPRB,0.73994E-01_JPRB,0.75287E-01_JPRB,0.76180E-01_JPRB,0.76714E-01_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.63278E-01_JPRB,0.64818E-01_JPRB,0.65954E-01_JPRB,0.66651E-01_JPRB,0.67143E-01_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.55139E-01_JPRB,0.56478E-01_JPRB,0.57384E-01_JPRB,0.58076E-01_JPRB,0.58539E-01_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.47894E-01_JPRB,0.48966E-01_JPRB,0.49829E-01_JPRB,0.50447E-01_JPRB,0.50916E-01_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.41499E-01_JPRB,0.42507E-01_JPRB,0.43240E-01_JPRB,0.43755E-01_JPRB,0.44135E-01_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.35885E-01_JPRB,0.36754E-01_JPRB,0.37403E-01_JPRB,0.37954E-01_JPRB,0.38313E-01_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.30699E-01_JPRB,0.31463E-01_JPRB,0.32108E-01_JPRB,0.32586E-01_JPRB,0.32972E-01_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.26192E-01_JPRB,0.26846E-01_JPRB,0.27409E-01_JPRB,0.27839E-01_JPRB,0.28217E-01_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.22340E-01_JPRB,0.22929E-01_JPRB,0.23404E-01_JPRB,0.23811E-01_JPRB,0.24187E-01_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.19095E-01_JPRB,0.19575E-01_JPRB,0.20007E-01_JPRB,0.20410E-01_JPRB,0.20766E-01_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.16366E-01_JPRB,0.16771E-01_JPRB,0.17186E-01_JPRB,0.17542E-01_JPRB,0.17949E-01_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.14069E-01_JPRB,0.14481E-01_JPRB,0.14832E-01_JPRB,0.15200E-01_JPRB,0.15580E-01_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.12162E-01_JPRB,0.12539E-01_JPRB,0.12888E-01_JPRB,0.13247E-01_JPRB,0.13615E-01_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.10528E-01_JPRB,0.10892E-01_JPRB,0.11265E-01_JPRB,0.11631E-01_JPRB,0.12012E-01_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.91441E-02_JPRB,0.95086E-02_JPRB,0.98896E-02_JPRB,0.10282E-01_JPRB,0.10687E-01_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.79938E-02_JPRB,0.83641E-02_JPRB,0.87511E-02_JPRB,0.91674E-02_JPRB,0.96121E-02_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.70400E-02_JPRB,0.74172E-02_JPRB,0.78125E-02_JPRB,0.82611E-02_JPRB,0.87532E-02_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.62612E-02_JPRB,0.66491E-02_JPRB,0.70836E-02_JPRB,0.75546E-02_JPRB,0.80730E-02_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.56090E-02_JPRB,0.60373E-02_JPRB,0.65021E-02_JPRB,0.70140E-02_JPRB,0.75729E-02_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.51011E-02_JPRB,0.55473E-02_JPRB,0.60429E-02_JPRB,0.66026E-02_JPRB,0.72780E-02_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.46990E-02_JPRB,0.51673E-02_JPRB,0.57072E-02_JPRB,0.63464E-02_JPRB,0.71159E-02_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.43314E-02_JPRB,0.48384E-02_JPRB,0.54243E-02_JPRB,0.61639E-02_JPRB,0.69924E-02_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.39886E-02_JPRB,0.45262E-02_JPRB,0.51941E-02_JPRB,0.59985E-02_JPRB,0.68708E-02_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.36017E-02_JPRB,0.41399E-02_JPRB,0.48219E-02_JPRB,0.56481E-02_JPRB,0.65560E-02_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.32617E-02_JPRB,0.38037E-02_JPRB,0.45057E-02_JPRB,0.53485E-02_JPRB,0.62708E-02_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.29777E-02_JPRB,0.35364E-02_JPRB,0.42387E-02_JPRB,0.50890E-02_JPRB,0.60544E-02_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.26397E-02_JPRB,0.31715E-02_JPRB,0.38573E-02_JPRB,0.46880E-02_JPRB,0.56335E-02_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.23227E-02_JPRB,0.28385E-02_JPRB,0.34927E-02_JPRB,0.42880E-02_JPRB,0.52154E-02_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.20486E-02_JPRB,0.25378E-02_JPRB,0.31647E-02_JPRB,0.39312E-02_JPRB,0.48261E-02_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.17755E-02_JPRB,0.22226E-02_JPRB,0.28140E-02_JPRB,0.35274E-02_JPRB,0.43895E-02_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.15269E-02_JPRB,0.19274E-02_JPRB,0.24688E-02_JPRB,0.31407E-02_JPRB,0.39517E-02_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.13050E-02_JPRB,0.16697E-02_JPRB,0.21647E-02_JPRB,0.27916E-02_JPRB,0.35423E-02_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.11057E-02_JPRB,0.14327E-02_JPRB,0.18777E-02_JPRB,0.24513E-02_JPRB,0.31448E-02_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.92448E-03_JPRB,0.12134E-02_JPRB,0.16064E-02_JPRB,0.21237E-02_JPRB,0.27575E-02_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.76618E-03_JPRB,0.10179E-02_JPRB,0.13627E-02_JPRB,0.18254E-02_JPRB,0.24067E-02_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.62940E-03_JPRB,0.85036E-03_JPRB,0.11489E-02_JPRB,0.15623E-02_JPRB,0.20896E-02_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.51855E-03_JPRB,0.71067E-03_JPRB,0.97602E-03_JPRB,0.13414E-02_JPRB,0.18179E-02_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.42590E-03_JPRB,0.59305E-03_JPRB,0.82548E-03_JPRB,0.11486E-02_JPRB,0.15798E-02_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.34697E-03_JPRB,0.49059E-03_JPRB,0.69535E-03_JPRB,0.97532E-03_JPRB,0.13630E-02_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.28092E-03_JPRB,0.40191E-03_JPRB,0.57931E-03_JPRB,0.82673E-03_JPRB,0.11685E-02_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.22883E-03_JPRB,0.33102E-03_JPRB,0.48584E-03_JPRB,0.70577E-03_JPRB,0.10069E-02_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.18567E-03_JPRB,0.27212E-03_JPRB,0.40629E-03_JPRB,0.59966E-03_JPRB,0.86643E-03_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.14981E-03_JPRB,0.22158E-03_JPRB,0.33702E-03_JPRB,0.50672E-03_JPRB,0.74022E-03_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.11956E-03_JPRB,0.17899E-03_JPRB,0.27717E-03_JPRB,0.42406E-03_JPRB,0.63003E-03_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.95581E-04_JPRB,0.14413E-03_JPRB,0.22637E-03_JPRB,0.35457E-03_JPRB,0.53700E-03_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.81967E-04_JPRB,0.12578E-03_JPRB,0.20146E-03_JPRB,0.32061E-03_JPRB,0.49099E-03_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.22107E+00_JPRB,0.22673E+00_JPRB,0.23188E+00_JPRB,0.23626E+00_JPRB,0.23937E+00_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.20348E+00_JPRB,0.20983E+00_JPRB,0.21521E+00_JPRB,0.21960E+00_JPRB,0.22328E+00_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.18724E+00_JPRB,0.19358E+00_JPRB,0.19903E+00_JPRB,0.20382E+00_JPRB,0.20780E+00_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.17271E+00_JPRB,0.17902E+00_JPRB,0.18466E+00_JPRB,0.18949E+00_JPRB,0.19358E+00_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.15881E+00_JPRB,0.16550E+00_JPRB,0.17139E+00_JPRB,0.17656E+00_JPRB,0.18127E+00_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.14632E+00_JPRB,0.15311E+00_JPRB,0.15937E+00_JPRB,0.16532E+00_JPRB,0.17049E+00_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.13481E+00_JPRB,0.14215E+00_JPRB,0.14899E+00_JPRB,0.15502E+00_JPRB,0.16068E+00_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.12437E+00_JPRB,0.13191E+00_JPRB,0.13890E+00_JPRB,0.14560E+00_JPRB,0.15188E+00_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.11481E+00_JPRB,0.12252E+00_JPRB,0.12982E+00_JPRB,0.13710E+00_JPRB,0.14374E+00_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.10661E+00_JPRB,0.11453E+00_JPRB,0.12244E+00_JPRB,0.12996E+00_JPRB,0.13720E+00_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.99573E-01_JPRB,0.10782E+00_JPRB,0.11598E+00_JPRB,0.12384E+00_JPRB,0.13154E+00_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.93585E-01_JPRB,0.10212E+00_JPRB,0.11044E+00_JPRB,0.11870E+00_JPRB,0.12683E+00_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.88642E-01_JPRB,0.97342E-01_JPRB,0.10600E+00_JPRB,0.11474E+00_JPRB,0.12338E+00_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.84783E-01_JPRB,0.93706E-01_JPRB,0.10275E+00_JPRB,0.11190E+00_JPRB,0.12089E+00_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.81924E-01_JPRB,0.91085E-01_JPRB,0.10043E+00_JPRB,0.11011E+00_JPRB,0.11942E+00_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.79898E-01_JPRB,0.89495E-01_JPRB,0.99246E-01_JPRB,0.10903E+00_JPRB,0.11866E+00_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.78843E-01_JPRB,0.88816E-01_JPRB,0.99112E-01_JPRB,0.10908E+00_JPRB,0.11873E+00_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.78672E-01_JPRB,0.89175E-01_JPRB,0.99763E-01_JPRB,0.10991E+00_JPRB,0.11974E+00_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.79471E-01_JPRB,0.90393E-01_JPRB,0.10090E+00_JPRB,0.11134E+00_JPRB,0.12148E+00_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.81097E-01_JPRB,0.92118E-01_JPRB,0.10299E+00_JPRB,0.11352E+00_JPRB,0.12362E+00_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.83219E-01_JPRB,0.94430E-01_JPRB,0.10536E+00_JPRB,0.11619E+00_JPRB,0.12656E+00_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.85363E-01_JPRB,0.96707E-01_JPRB,0.10798E+00_JPRB,0.11904E+00_JPRB,0.12986E+00_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.86741E-01_JPRB,0.98297E-01_JPRB,0.11004E+00_JPRB,0.12158E+00_JPRB,0.13234E+00_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.87017E-01_JPRB,0.99113E-01_JPRB,0.11121E+00_JPRB,0.12302E+00_JPRB,0.13390E+00_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.85258E-01_JPRB,0.97671E-01_JPRB,0.10985E+00_JPRB,0.12188E+00_JPRB,0.13289E+00_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.83622E-01_JPRB,0.96133E-01_JPRB,0.10847E+00_JPRB,0.12060E+00_JPRB,0.13189E+00_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.82148E-01_JPRB,0.94689E-01_JPRB,0.10723E+00_JPRB,0.11944E+00_JPRB,0.13102E+00_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.78933E-01_JPRB,0.91494E-01_JPRB,0.10410E+00_JPRB,0.11650E+00_JPRB,0.12816E+00_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.75553E-01_JPRB,0.88087E-01_JPRB,0.10066E+00_JPRB,0.11319E+00_JPRB,0.12513E+00_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.72215E-01_JPRB,0.84600E-01_JPRB,0.97314E-01_JPRB,0.10990E+00_JPRB,0.12202E+00_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.68050E-01_JPRB,0.80392E-01_JPRB,0.93038E-01_JPRB,0.10568E+00_JPRB,0.11811E+00_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.63504E-01_JPRB,0.75885E-01_JPRB,0.88427E-01_JPRB,0.10109E+00_JPRB,0.11352E+00_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.59117E-01_JPRB,0.71359E-01_JPRB,0.83835E-01_JPRB,0.96461E-01_JPRB,0.10897E+00_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.54516E-01_JPRB,0.66547E-01_JPRB,0.79117E-01_JPRB,0.91745E-01_JPRB,0.10426E+00_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.49520E-01_JPRB,0.61408E-01_JPRB,0.73788E-01_JPRB,0.86383E-01_JPRB,0.98886E-01_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.44727E-01_JPRB,0.56224E-01_JPRB,0.68415E-01_JPRB,0.81094E-01_JPRB,0.93621E-01_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.40177E-01_JPRB,0.51146E-01_JPRB,0.63191E-01_JPRB,0.75749E-01_JPRB,0.88249E-01_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.36081E-01_JPRB,0.46596E-01_JPRB,0.58341E-01_JPRB,0.70769E-01_JPRB,0.83353E-01_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.32278E-01_JPRB,0.42393E-01_JPRB,0.53717E-01_JPRB,0.65898E-01_JPRB,0.78578E-01_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.28586E-01_JPRB,0.38352E-01_JPRB,0.49175E-01_JPRB,0.61145E-01_JPRB,0.73682E-01_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.25090E-01_JPRB,0.34439E-01_JPRB,0.44807E-01_JPRB,0.56352E-01_JPRB,0.68823E-01_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.22080E-01_JPRB,0.30938E-01_JPRB,0.40952E-01_JPRB,0.52101E-01_JPRB,0.64364E-01_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.19382E-01_JPRB,0.27719E-01_JPRB,0.37405E-01_JPRB,0.48197E-01_JPRB,0.60044E-01_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.16835E-01_JPRB,0.24689E-01_JPRB,0.33908E-01_JPRB,0.44390E-01_JPRB,0.55911E-01_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.14459E-01_JPRB,0.21799E-01_JPRB,0.30531E-01_JPRB,0.40642E-01_JPRB,0.51808E-01_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.12380E-01_JPRB,0.19213E-01_JPRB,0.27475E-01_JPRB,0.37204E-01_JPRB,0.48065E-01_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.11536E-01_JPRB,0.18115E-01_JPRB,0.26160E-01_JPRB,0.35756E-01_JPRB,0.46501E-01_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.79231E+00_JPRB,0.80247E+00_JPRB,0.81169E+00_JPRB,0.81859E+00_JPRB,0.82469E+00_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.76567E+00_JPRB,0.77861E+00_JPRB,0.78976E+00_JPRB,0.79966E+00_JPRB,0.80754E+00_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.73926E+00_JPRB,0.75515E+00_JPRB,0.76982E+00_JPRB,0.78244E+00_JPRB,0.79228E+00_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.71308E+00_JPRB,0.73273E+00_JPRB,0.74955E+00_JPRB,0.76355E+00_JPRB,0.77553E+00_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.68845E+00_JPRB,0.70973E+00_JPRB,0.72813E+00_JPRB,0.74466E+00_JPRB,0.75909E+00_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.66397E+00_JPRB,0.68720E+00_JPRB,0.70872E+00_JPRB,0.72756E+00_JPRB,0.74467E+00_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.64097E+00_JPRB,0.66723E+00_JPRB,0.69155E+00_JPRB,0.71362E+00_JPRB,0.73339E+00_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.62162E+00_JPRB,0.65070E+00_JPRB,0.67764E+00_JPRB,0.70183E+00_JPRB,0.72348E+00_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.60571E+00_JPRB,0.63800E+00_JPRB,0.66649E+00_JPRB,0.69291E+00_JPRB,0.71712E+00_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.59651E+00_JPRB,0.62972E+00_JPRB,0.66058E+00_JPRB,0.68832E+00_JPRB,0.71517E+00_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.58974E+00_JPRB,0.62545E+00_JPRB,0.65753E+00_JPRB,0.68785E+00_JPRB,0.71519E+00_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.58721E+00_JPRB,0.62395E+00_JPRB,0.65801E+00_JPRB,0.68952E+00_JPRB,0.71705E+00_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.58931E+00_JPRB,0.62554E+00_JPRB,0.66080E+00_JPRB,0.69275E+00_JPRB,0.72212E+00_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.59392E+00_JPRB,0.63108E+00_JPRB,0.66576E+00_JPRB,0.69831E+00_JPRB,0.72831E+00_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.60088E+00_JPRB,0.63911E+00_JPRB,0.67310E+00_JPRB,0.70594E+00_JPRB,0.73492E+00_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.61058E+00_JPRB,0.64827E+00_JPRB,0.68351E+00_JPRB,0.71436E+00_JPRB,0.74248E+00_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.62259E+00_JPRB,0.66086E+00_JPRB,0.69462E+00_JPRB,0.72450E+00_JPRB,0.75205E+00_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.63547E+00_JPRB,0.67373E+00_JPRB,0.70715E+00_JPRB,0.73642E+00_JPRB,0.76277E+00_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.65060E+00_JPRB,0.68811E+00_JPRB,0.72216E+00_JPRB,0.75104E+00_JPRB,0.77730E+00_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.66635E+00_JPRB,0.70367E+00_JPRB,0.73703E+00_JPRB,0.76712E+00_JPRB,0.79450E+00_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.68330E+00_JPRB,0.72114E+00_JPRB,0.75529E+00_JPRB,0.78560E+00_JPRB,0.81251E+00_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.69895E+00_JPRB,0.73787E+00_JPRB,0.77209E+00_JPRB,0.80355E+00_JPRB,0.82948E+00_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.71249E+00_JPRB,0.75244E+00_JPRB,0.78786E+00_JPRB,0.82021E+00_JPRB,0.84807E+00_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.72352E+00_JPRB,0.76491E+00_JPRB,0.80192E+00_JPRB,0.83419E+00_JPRB,0.86330E+00_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.72315E+00_JPRB,0.76487E+00_JPRB,0.80310E+00_JPRB,0.83637E+00_JPRB,0.86732E+00_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.72144E+00_JPRB,0.76571E+00_JPRB,0.80444E+00_JPRB,0.83852E+00_JPRB,0.86991E+00_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.72061E+00_JPRB,0.76655E+00_JPRB,0.80661E+00_JPRB,0.84238E+00_JPRB,0.87357E+00_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.71071E+00_JPRB,0.75799E+00_JPRB,0.79882E+00_JPRB,0.83566E+00_JPRB,0.86813E+00_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.69960E+00_JPRB,0.74652E+00_JPRB,0.79034E+00_JPRB,0.82858E+00_JPRB,0.86201E+00_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.68767E+00_JPRB,0.73584E+00_JPRB,0.78080E+00_JPRB,0.82018E+00_JPRB,0.85505E+00_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.67181E+00_JPRB,0.72136E+00_JPRB,0.76709E+00_JPRB,0.80803E+00_JPRB,0.84449E+00_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.65485E+00_JPRB,0.70505E+00_JPRB,0.75190E+00_JPRB,0.79482E+00_JPRB,0.83260E+00_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.63639E+00_JPRB,0.68756E+00_JPRB,0.73541E+00_JPRB,0.78029E+00_JPRB,0.82060E+00_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.61610E+00_JPRB,0.67008E+00_JPRB,0.71893E+00_JPRB,0.76424E+00_JPRB,0.80647E+00_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.59373E+00_JPRB,0.64972E+00_JPRB,0.69969E+00_JPRB,0.74707E+00_JPRB,0.79068E+00_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.56865E+00_JPRB,0.62791E+00_JPRB,0.68069E+00_JPRB,0.72878E+00_JPRB,0.77390E+00_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.54350E+00_JPRB,0.60516E+00_JPRB,0.66027E+00_JPRB,0.71007E+00_JPRB,0.75592E+00_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.51991E+00_JPRB,0.58375E+00_JPRB,0.64136E+00_JPRB,0.69342E+00_JPRB,0.74093E+00_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.49673E+00_JPRB,0.56229E+00_JPRB,0.62200E+00_JPRB,0.67685E+00_JPRB,0.72556E+00_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.47256E+00_JPRB,0.53950E+00_JPRB,0.60133E+00_JPRB,0.65838E+00_JPRB,0.70926E+00_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.44771E+00_JPRB,0.51552E+00_JPRB,0.57980E+00_JPRB,0.63854E+00_JPRB,0.69202E+00_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.42506E+00_JPRB,0.49358E+00_JPRB,0.56009E+00_JPRB,0.62090E+00_JPRB,0.67547E+00_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.40218E+00_JPRB,0.47240E+00_JPRB,0.53999E+00_JPRB,0.60216E+00_JPRB,0.65925E+00_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.37888E+00_JPRB,0.45101E+00_JPRB,0.51913E+00_JPRB,0.58357E+00_JPRB,0.64216E+00_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.35513E+00_JPRB,0.42824E+00_JPRB,0.49765E+00_JPRB,0.56376E+00_JPRB,0.62409E+00_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.33174E+00_JPRB,0.40632E+00_JPRB,0.47713E+00_JPRB,0.54453E+00_JPRB,0.60605E+00_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.32315E+00_JPRB,0.39758E+00_JPRB,0.46935E+00_JPRB,0.53732E+00_JPRB,0.59942E+00_JPRB /)  
KB(:,13,10) = (/ &
 & 0.20814E+01_JPRB,0.20759E+01_JPRB,0.20660E+01_JPRB,0.20703E+01_JPRB,0.20598E+01_JPRB /)  
KB(:,14,10) = (/ &
 & 0.20861E+01_JPRB,0.20862E+01_JPRB,0.20902E+01_JPRB,0.20921E+01_JPRB,0.20850E+01_JPRB /)  
KB(:,15,10) = (/ &
 & 0.20793E+01_JPRB,0.20969E+01_JPRB,0.21057E+01_JPRB,0.21014E+01_JPRB,0.21089E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART15',0,ZHOOK_HANDLE)


KB(:,16,10) = (/ &
 & 0.20801E+01_JPRB,0.20948E+01_JPRB,0.21151E+01_JPRB,0.21351E+01_JPRB,0.21560E+01_JPRB /)  
KB(:,17,10) = (/ &
 & 0.20802E+01_JPRB,0.21249E+01_JPRB,0.21608E+01_JPRB,0.21842E+01_JPRB,0.21924E+01_JPRB /)  
KB(:,18,10) = (/ &
 & 0.20972E+01_JPRB,0.21483E+01_JPRB,0.21814E+01_JPRB,0.21999E+01_JPRB,0.22088E+01_JPRB /)  
KB(:,19,10) = (/ &
 & 0.21086E+01_JPRB,0.21513E+01_JPRB,0.21845E+01_JPRB,0.22099E+01_JPRB,0.22261E+01_JPRB /)  
KB(:,20,10) = (/ &
 & 0.21001E+01_JPRB,0.21488E+01_JPRB,0.21917E+01_JPRB,0.22212E+01_JPRB,0.22394E+01_JPRB /)  
KB(:,21,10) = (/ &
 & 0.20945E+01_JPRB,0.21494E+01_JPRB,0.22004E+01_JPRB,0.22330E+01_JPRB,0.22537E+01_JPRB /)  
KB(:,22,10) = (/ &
 & 0.20951E+01_JPRB,0.21635E+01_JPRB,0.22151E+01_JPRB,0.22483E+01_JPRB,0.22658E+01_JPRB /)  
KB(:,23,10) = (/ &
 & 0.21106E+01_JPRB,0.21802E+01_JPRB,0.22288E+01_JPRB,0.22593E+01_JPRB,0.22769E+01_JPRB /)  
KB(:,24,10) = (/ &
 & 0.21251E+01_JPRB,0.21978E+01_JPRB,0.22479E+01_JPRB,0.22750E+01_JPRB,0.23069E+01_JPRB /)  
KB(:,25,10) = (/ &
 & 0.21350E+01_JPRB,0.22127E+01_JPRB,0.22620E+01_JPRB,0.22919E+01_JPRB,0.23205E+01_JPRB /)  
KB(:,26,10) = (/ &
 & 0.21397E+01_JPRB,0.22248E+01_JPRB,0.22778E+01_JPRB,0.23148E+01_JPRB,0.23338E+01_JPRB /)  
KB(:,27,10) = (/ &
 & 0.21476E+01_JPRB,0.22244E+01_JPRB,0.22911E+01_JPRB,0.23271E+01_JPRB,0.23529E+01_JPRB /)  
KB(:,28,10) = (/ &
 & 0.21502E+01_JPRB,0.22263E+01_JPRB,0.22854E+01_JPRB,0.23382E+01_JPRB,0.23803E+01_JPRB /)  
KB(:,29,10) = (/ &
 & 0.21444E+01_JPRB,0.22159E+01_JPRB,0.22839E+01_JPRB,0.23447E+01_JPRB,0.24026E+01_JPRB /)  
KB(:,30,10) = (/ &
 & 0.21459E+01_JPRB,0.22135E+01_JPRB,0.22803E+01_JPRB,0.23564E+01_JPRB,0.24114E+01_JPRB /)  
KB(:,31,10) = (/ &
 & 0.21548E+01_JPRB,0.22131E+01_JPRB,0.22785E+01_JPRB,0.23559E+01_JPRB,0.23993E+01_JPRB /)  
KB(:,32,10) = (/ &
 & 0.21820E+01_JPRB,0.22366E+01_JPRB,0.23010E+01_JPRB,0.23445E+01_JPRB,0.23808E+01_JPRB /)  
KB(:,33,10) = (/ &
 & 0.22356E+01_JPRB,0.22739E+01_JPRB,0.22923E+01_JPRB,0.23386E+01_JPRB,0.23842E+01_JPRB /)  
KB(:,34,10) = (/ &
 & 0.22861E+01_JPRB,0.23162E+01_JPRB,0.23352E+01_JPRB,0.23408E+01_JPRB,0.23839E+01_JPRB /)  
KB(:,35,10) = (/ &
 & 0.23385E+01_JPRB,0.23680E+01_JPRB,0.23728E+01_JPRB,0.23741E+01_JPRB,0.23938E+01_JPRB /)  
KB(:,36,10) = (/ &
 & 0.23851E+01_JPRB,0.24072E+01_JPRB,0.24258E+01_JPRB,0.24337E+01_JPRB,0.24446E+01_JPRB /)  
KB(:,37,10) = (/ &
 & 0.23954E+01_JPRB,0.24271E+01_JPRB,0.24525E+01_JPRB,0.24638E+01_JPRB,0.24744E+01_JPRB /)  
KB(:,38,10) = (/ &
 & 0.24138E+01_JPRB,0.24360E+01_JPRB,0.24658E+01_JPRB,0.24931E+01_JPRB,0.25112E+01_JPRB /)  
KB(:,39,10) = (/ &
 & 0.24207E+01_JPRB,0.24415E+01_JPRB,0.24747E+01_JPRB,0.25054E+01_JPRB,0.25446E+01_JPRB /)  
KB(:,40,10) = (/ &
 & 0.24183E+01_JPRB,0.24401E+01_JPRB,0.24836E+01_JPRB,0.25135E+01_JPRB,0.25532E+01_JPRB /)  
KB(:,41,10) = (/ &
 & 0.24046E+01_JPRB,0.24486E+01_JPRB,0.24788E+01_JPRB,0.25037E+01_JPRB,0.25503E+01_JPRB /)  
KB(:,42,10) = (/ &
 & 0.23965E+01_JPRB,0.24448E+01_JPRB,0.24659E+01_JPRB,0.25035E+01_JPRB,0.25440E+01_JPRB /)  
KB(:,43,10) = (/ &
 & 0.23757E+01_JPRB,0.24456E+01_JPRB,0.24672E+01_JPRB,0.25043E+01_JPRB,0.25340E+01_JPRB /)  
KB(:,44,10) = (/ &
 & 0.23417E+01_JPRB,0.24271E+01_JPRB,0.24708E+01_JPRB,0.24891E+01_JPRB,0.25157E+01_JPRB /)  
KB(:,45,10) = (/ &
 & 0.23140E+01_JPRB,0.24224E+01_JPRB,0.24648E+01_JPRB,0.24895E+01_JPRB,0.25109E+01_JPRB /)  
KB(:,46,10) = (/ &
 & 0.22839E+01_JPRB,0.23815E+01_JPRB,0.24548E+01_JPRB,0.24874E+01_JPRB,0.24983E+01_JPRB /)  
KB(:,47,10) = (/ &
 & 0.22509E+01_JPRB,0.23585E+01_JPRB,0.24548E+01_JPRB,0.24976E+01_JPRB,0.25158E+01_JPRB /)  
KB(:,48,10) = (/ &
 & 0.22243E+01_JPRB,0.23182E+01_JPRB,0.24167E+01_JPRB,0.24851E+01_JPRB,0.25144E+01_JPRB /)  
KB(:,49,10) = (/ &
 & 0.21934E+01_JPRB,0.22838E+01_JPRB,0.23882E+01_JPRB,0.24694E+01_JPRB,0.25145E+01_JPRB /)  
KB(:,50,10) = (/ &
 & 0.21637E+01_JPRB,0.22591E+01_JPRB,0.23593E+01_JPRB,0.24450E+01_JPRB,0.25097E+01_JPRB /)  
KB(:,51,10) = (/ &
 & 0.21256E+01_JPRB,0.22383E+01_JPRB,0.23340E+01_JPRB,0.24239E+01_JPRB,0.25025E+01_JPRB /)  
KB(:,52,10) = (/ &
 & 0.20804E+01_JPRB,0.22090E+01_JPRB,0.23144E+01_JPRB,0.24005E+01_JPRB,0.24803E+01_JPRB /)  
KB(:,53,10) = (/ &
 & 0.20229E+01_JPRB,0.21712E+01_JPRB,0.22790E+01_JPRB,0.23709E+01_JPRB,0.24497E+01_JPRB /)  
KB(:,54,10) = (/ &
 & 0.19647E+01_JPRB,0.21430E+01_JPRB,0.22514E+01_JPRB,0.23430E+01_JPRB,0.24343E+01_JPRB /)  
KB(:,55,10) = (/ &
 & 0.19094E+01_JPRB,0.20990E+01_JPRB,0.22287E+01_JPRB,0.23283E+01_JPRB,0.24126E+01_JPRB /)  
KB(:,56,10) = (/ &
 & 0.18499E+01_JPRB,0.20432E+01_JPRB,0.21961E+01_JPRB,0.22965E+01_JPRB,0.23921E+01_JPRB /)  
KB(:,57,10) = (/ &
 & 0.17845E+01_JPRB,0.19868E+01_JPRB,0.21557E+01_JPRB,0.22661E+01_JPRB,0.23666E+01_JPRB /)  
KB(:,58,10) = (/ &
 & 0.17304E+01_JPRB,0.19324E+01_JPRB,0.21130E+01_JPRB,0.22379E+01_JPRB,0.23344E+01_JPRB /)  
KB(:,59,10) = (/ &
 & 0.17036E+01_JPRB,0.19129E+01_JPRB,0.20925E+01_JPRB,0.22299E+01_JPRB,0.23291E+01_JPRB /)  
KB(:,13,11) = (/ &
 & 0.28487E+01_JPRB,0.28532E+01_JPRB,0.28392E+01_JPRB,0.28113E+01_JPRB,0.28077E+01_JPRB /)  
KB(:,14,11) = (/ &
 & 0.29217E+01_JPRB,0.29135E+01_JPRB,0.28970E+01_JPRB,0.28895E+01_JPRB,0.29104E+01_JPRB /)  
KB(:,15,11) = (/ &
 & 0.29720E+01_JPRB,0.29567E+01_JPRB,0.29515E+01_JPRB,0.29771E+01_JPRB,0.29749E+01_JPRB /)  
KB(:,16,11) = (/ &
 & 0.29934E+01_JPRB,0.30029E+01_JPRB,0.30226E+01_JPRB,0.30339E+01_JPRB,0.30204E+01_JPRB /)  
KB(:,17,11) = (/ &
 & 0.30408E+01_JPRB,0.30652E+01_JPRB,0.30797E+01_JPRB,0.30959E+01_JPRB,0.31120E+01_JPRB /)  
KB(:,18,11) = (/ &
 & 0.31059E+01_JPRB,0.31457E+01_JPRB,0.31893E+01_JPRB,0.32154E+01_JPRB,0.32284E+01_JPRB /)  
KB(:,19,11) = (/ &
 & 0.31895E+01_JPRB,0.32505E+01_JPRB,0.32863E+01_JPRB,0.32994E+01_JPRB,0.32949E+01_JPRB /)  
KB(:,20,11) = (/ &
 & 0.32605E+01_JPRB,0.33203E+01_JPRB,0.33389E+01_JPRB,0.33469E+01_JPRB,0.33350E+01_JPRB /)  
KB(:,21,11) = (/ &
 & 0.33097E+01_JPRB,0.33567E+01_JPRB,0.33762E+01_JPRB,0.33842E+01_JPRB,0.33798E+01_JPRB /)  
KB(:,22,11) = (/ &
 & 0.33482E+01_JPRB,0.33901E+01_JPRB,0.34068E+01_JPRB,0.34227E+01_JPRB,0.34010E+01_JPRB /)  
KB(:,23,11) = (/ &
 & 0.33722E+01_JPRB,0.34154E+01_JPRB,0.34438E+01_JPRB,0.34434E+01_JPRB,0.34235E+01_JPRB /)  
KB(:,24,11) = (/ &
 & 0.33951E+01_JPRB,0.34377E+01_JPRB,0.34659E+01_JPRB,0.34658E+01_JPRB,0.34557E+01_JPRB /)  
KB(:,25,11) = (/ &
 & 0.34209E+01_JPRB,0.34720E+01_JPRB,0.34904E+01_JPRB,0.34950E+01_JPRB,0.34725E+01_JPRB /)  
KB(:,26,11) = (/ &
 & 0.34497E+01_JPRB,0.34967E+01_JPRB,0.35233E+01_JPRB,0.35072E+01_JPRB,0.34967E+01_JPRB /)  
KB(:,27,11) = (/ &
 & 0.34791E+01_JPRB,0.35327E+01_JPRB,0.35370E+01_JPRB,0.35122E+01_JPRB,0.35139E+01_JPRB /)  
KB(:,28,11) = (/ &
 & 0.35134E+01_JPRB,0.35471E+01_JPRB,0.35465E+01_JPRB,0.35405E+01_JPRB,0.35525E+01_JPRB /)  
KB(:,29,11) = (/ &
 & 0.35424E+01_JPRB,0.35704E+01_JPRB,0.35632E+01_JPRB,0.35824E+01_JPRB,0.35567E+01_JPRB /)  
KB(:,30,11) = (/ &
 & 0.35629E+01_JPRB,0.35947E+01_JPRB,0.35992E+01_JPRB,0.36011E+01_JPRB,0.36027E+01_JPRB /)  
KB(:,31,11) = (/ &
 & 0.35753E+01_JPRB,0.36045E+01_JPRB,0.36365E+01_JPRB,0.36213E+01_JPRB,0.36310E+01_JPRB /)  
KB(:,32,11) = (/ &
 & 0.35596E+01_JPRB,0.36100E+01_JPRB,0.36333E+01_JPRB,0.36490E+01_JPRB,0.36651E+01_JPRB /)  
KB(:,33,11) = (/ &
 & 0.35241E+01_JPRB,0.35883E+01_JPRB,0.36383E+01_JPRB,0.36740E+01_JPRB,0.36685E+01_JPRB /)  
KB(:,34,11) = (/ &
 & 0.35027E+01_JPRB,0.35491E+01_JPRB,0.36249E+01_JPRB,0.36739E+01_JPRB,0.36810E+01_JPRB /)  
KB(:,35,11) = (/ &
 & 0.34699E+01_JPRB,0.35289E+01_JPRB,0.35926E+01_JPRB,0.36193E+01_JPRB,0.36411E+01_JPRB /)  
KB(:,36,11) = (/ &
 & 0.35153E+01_JPRB,0.35225E+01_JPRB,0.35498E+01_JPRB,0.35989E+01_JPRB,0.36429E+01_JPRB /)  
KB(:,37,11) = (/ &
 & 0.35644E+01_JPRB,0.35488E+01_JPRB,0.35358E+01_JPRB,0.35755E+01_JPRB,0.36247E+01_JPRB /)  
KB(:,38,11) = (/ &
 & 0.35952E+01_JPRB,0.35902E+01_JPRB,0.35685E+01_JPRB,0.35598E+01_JPRB,0.35995E+01_JPRB /)  
KB(:,39,11) = (/ &
 & 0.36371E+01_JPRB,0.36388E+01_JPRB,0.36159E+01_JPRB,0.35751E+01_JPRB,0.35930E+01_JPRB /)  
KB(:,40,11) = (/ &
 & 0.36530E+01_JPRB,0.36611E+01_JPRB,0.36495E+01_JPRB,0.35923E+01_JPRB,0.35985E+01_JPRB /)  
KB(:,41,11) = (/ &
 & 0.36431E+01_JPRB,0.36852E+01_JPRB,0.36606E+01_JPRB,0.36324E+01_JPRB,0.35949E+01_JPRB /)  
KB(:,42,11) = (/ &
 & 0.36510E+01_JPRB,0.36940E+01_JPRB,0.36905E+01_JPRB,0.36729E+01_JPRB,0.36122E+01_JPRB /)  
KB(:,43,11) = (/ &
 & 0.36633E+01_JPRB,0.36955E+01_JPRB,0.37103E+01_JPRB,0.36924E+01_JPRB,0.36526E+01_JPRB /)  
KB(:,44,11) = (/ &
 & 0.36584E+01_JPRB,0.36852E+01_JPRB,0.37131E+01_JPRB,0.37219E+01_JPRB,0.36946E+01_JPRB /)  
KB(:,45,11) = (/ &
 & 0.36636E+01_JPRB,0.36530E+01_JPRB,0.37160E+01_JPRB,0.37197E+01_JPRB,0.37150E+01_JPRB /)  
KB(:,46,11) = (/ &
 & 0.36713E+01_JPRB,0.36779E+01_JPRB,0.37130E+01_JPRB,0.37408E+01_JPRB,0.37431E+01_JPRB /)  
KB(:,47,11) = (/ &
 & 0.36885E+01_JPRB,0.36889E+01_JPRB,0.37012E+01_JPRB,0.37377E+01_JPRB,0.37538E+01_JPRB /)  
KB(:,48,11) = (/ &
 & 0.36735E+01_JPRB,0.37253E+01_JPRB,0.37092E+01_JPRB,0.37311E+01_JPRB,0.37444E+01_JPRB /)  
KB(:,49,11) = (/ &
 & 0.36543E+01_JPRB,0.37300E+01_JPRB,0.37306E+01_JPRB,0.37311E+01_JPRB,0.37688E+01_JPRB /)  
KB(:,50,11) = (/ &
 & 0.36397E+01_JPRB,0.37435E+01_JPRB,0.37659E+01_JPRB,0.37491E+01_JPRB,0.37600E+01_JPRB /)  
KB(:,51,11) = (/ &
 & 0.36124E+01_JPRB,0.37293E+01_JPRB,0.37963E+01_JPRB,0.37839E+01_JPRB,0.37789E+01_JPRB /)  
KB(:,52,11) = (/ &
 & 0.35636E+01_JPRB,0.37078E+01_JPRB,0.37818E+01_JPRB,0.38114E+01_JPRB,0.37775E+01_JPRB /)  
KB(:,53,11) = (/ &
 & 0.34978E+01_JPRB,0.36691E+01_JPRB,0.37922E+01_JPRB,0.38152E+01_JPRB,0.38092E+01_JPRB /)  
KB(:,54,11) = (/ &
 & 0.34749E+01_JPRB,0.36230E+01_JPRB,0.37686E+01_JPRB,0.38328E+01_JPRB,0.38292E+01_JPRB /)  
KB(:,55,11) = (/ &
 & 0.34238E+01_JPRB,0.35883E+01_JPRB,0.37261E+01_JPRB,0.38299E+01_JPRB,0.38488E+01_JPRB /)  
KB(:,56,11) = (/ &
 & 0.33568E+01_JPRB,0.35597E+01_JPRB,0.37073E+01_JPRB,0.38247E+01_JPRB,0.38591E+01_JPRB /)  
KB(:,57,11) = (/ &
 & 0.32794E+01_JPRB,0.35193E+01_JPRB,0.36712E+01_JPRB,0.37875E+01_JPRB,0.38581E+01_JPRB /)  
KB(:,58,11) = (/ &
 & 0.31971E+01_JPRB,0.34544E+01_JPRB,0.36268E+01_JPRB,0.37609E+01_JPRB,0.38393E+01_JPRB /)  
KB(:,59,11) = (/ &
 & 0.31680E+01_JPRB,0.34441E+01_JPRB,0.36338E+01_JPRB,0.37596E+01_JPRB,0.38510E+01_JPRB /)  
KB(:,13,12) = (/ &
 & 0.40944E+01_JPRB,0.40706E+01_JPRB,0.40738E+01_JPRB,0.40615E+01_JPRB,0.40255E+01_JPRB /)  
KB(:,14,12) = (/ &
 & 0.42568E+01_JPRB,0.42640E+01_JPRB,0.42578E+01_JPRB,0.42281E+01_JPRB,0.41677E+01_JPRB /)  
KB(:,15,12) = (/ &
 & 0.44471E+01_JPRB,0.44460E+01_JPRB,0.44235E+01_JPRB,0.43647E+01_JPRB,0.43107E+01_JPRB /)  
KB(:,16,12) = (/ &
 & 0.45971E+01_JPRB,0.45776E+01_JPRB,0.45277E+01_JPRB,0.44905E+01_JPRB,0.45101E+01_JPRB /)  
KB(:,17,12) = (/ &
 & 0.46780E+01_JPRB,0.46358E+01_JPRB,0.46311E+01_JPRB,0.46380E+01_JPRB,0.46103E+01_JPRB /)  
KB(:,18,12) = (/ &
 & 0.47294E+01_JPRB,0.47444E+01_JPRB,0.47418E+01_JPRB,0.47299E+01_JPRB,0.47059E+01_JPRB /)  
KB(:,19,12) = (/ &
 & 0.48604E+01_JPRB,0.48842E+01_JPRB,0.48819E+01_JPRB,0.49000E+01_JPRB,0.48969E+01_JPRB /)  
KB(:,20,12) = (/ &
 & 0.49979E+01_JPRB,0.50271E+01_JPRB,0.50614E+01_JPRB,0.50783E+01_JPRB,0.50637E+01_JPRB /)  
KB(:,21,12) = (/ &
 & 0.51216E+01_JPRB,0.51841E+01_JPRB,0.52155E+01_JPRB,0.52098E+01_JPRB,0.51706E+01_JPRB /)  
KB(:,22,12) = (/ &
 & 0.52796E+01_JPRB,0.53177E+01_JPRB,0.53275E+01_JPRB,0.53003E+01_JPRB,0.52540E+01_JPRB /)  
KB(:,23,12) = (/ &
 & 0.54021E+01_JPRB,0.54214E+01_JPRB,0.54107E+01_JPRB,0.53770E+01_JPRB,0.53308E+01_JPRB /)  
KB(:,24,12) = (/ &
 & 0.54951E+01_JPRB,0.54954E+01_JPRB,0.54655E+01_JPRB,0.54275E+01_JPRB,0.53548E+01_JPRB /)  
KB(:,25,12) = (/ &
 & 0.55606E+01_JPRB,0.55401E+01_JPRB,0.55126E+01_JPRB,0.54611E+01_JPRB,0.53900E+01_JPRB /)  
KB(:,26,12) = (/ &
 & 0.56084E+01_JPRB,0.55775E+01_JPRB,0.55344E+01_JPRB,0.54935E+01_JPRB,0.53765E+01_JPRB /)  
KB(:,27,12) = (/ &
 & 0.56424E+01_JPRB,0.55975E+01_JPRB,0.55674E+01_JPRB,0.55057E+01_JPRB,0.54137E+01_JPRB /)  
KB(:,28,12) = (/ &
 & 0.56582E+01_JPRB,0.56350E+01_JPRB,0.55811E+01_JPRB,0.55009E+01_JPRB,0.54160E+01_JPRB /)  
KB(:,29,12) = (/ &
 & 0.56833E+01_JPRB,0.56401E+01_JPRB,0.55975E+01_JPRB,0.55109E+01_JPRB,0.54249E+01_JPRB /)  
KB(:,30,12) = (/ &
 & 0.57003E+01_JPRB,0.56620E+01_JPRB,0.55904E+01_JPRB,0.55121E+01_JPRB,0.54542E+01_JPRB /)  
KB(:,31,12) = (/ &
 & 0.57132E+01_JPRB,0.56848E+01_JPRB,0.56091E+01_JPRB,0.55447E+01_JPRB,0.55236E+01_JPRB /)  
KB(:,32,12) = (/ &
 & 0.57800E+01_JPRB,0.57027E+01_JPRB,0.56220E+01_JPRB,0.56024E+01_JPRB,0.55523E+01_JPRB /)  
KB(:,33,12) = (/ &
 & 0.57668E+01_JPRB,0.57069E+01_JPRB,0.56826E+01_JPRB,0.56406E+01_JPRB,0.56224E+01_JPRB /)  
KB(:,34,12) = (/ &
 & 0.57877E+01_JPRB,0.57628E+01_JPRB,0.57465E+01_JPRB,0.57131E+01_JPRB,0.56752E+01_JPRB /)  
KB(:,35,12) = (/ &
 & 0.58053E+01_JPRB,0.58032E+01_JPRB,0.57814E+01_JPRB,0.58008E+01_JPRB,0.57412E+01_JPRB /)  
KB(:,36,12) = (/ &
 & 0.57386E+01_JPRB,0.58034E+01_JPRB,0.57934E+01_JPRB,0.57973E+01_JPRB,0.57760E+01_JPRB /)  
KB(:,37,12) = (/ &
 & 0.56650E+01_JPRB,0.57400E+01_JPRB,0.57795E+01_JPRB,0.58096E+01_JPRB,0.57723E+01_JPRB /)  
KB(:,38,12) = (/ &
 & 0.56068E+01_JPRB,0.56512E+01_JPRB,0.57137E+01_JPRB,0.58154E+01_JPRB,0.57795E+01_JPRB /)  
KB(:,39,12) = (/ &
 & 0.55712E+01_JPRB,0.56156E+01_JPRB,0.56456E+01_JPRB,0.57952E+01_JPRB,0.57768E+01_JPRB /)  
KB(:,40,12) = (/ &
 & 0.55331E+01_JPRB,0.55774E+01_JPRB,0.56049E+01_JPRB,0.57462E+01_JPRB,0.57382E+01_JPRB /)  
KB(:,41,12) = (/ &
 & 0.55579E+01_JPRB,0.55330E+01_JPRB,0.55754E+01_JPRB,0.56805E+01_JPRB,0.57245E+01_JPRB /)  
KB(:,42,12) = (/ &
 & 0.55684E+01_JPRB,0.55372E+01_JPRB,0.55455E+01_JPRB,0.56019E+01_JPRB,0.57291E+01_JPRB /)  
KB(:,43,12) = (/ &
 & 0.56282E+01_JPRB,0.55547E+01_JPRB,0.55863E+01_JPRB,0.55852E+01_JPRB,0.56892E+01_JPRB /)  
KB(:,44,12) = (/ &
 & 0.56429E+01_JPRB,0.55998E+01_JPRB,0.55663E+01_JPRB,0.55662E+01_JPRB,0.56522E+01_JPRB /)  
KB(:,45,12) = (/ &
 & 0.56488E+01_JPRB,0.56642E+01_JPRB,0.55915E+01_JPRB,0.56136E+01_JPRB,0.56176E+01_JPRB /)  
KB(:,46,12) = (/ &
 & 0.57246E+01_JPRB,0.57165E+01_JPRB,0.56557E+01_JPRB,0.56271E+01_JPRB,0.56227E+01_JPRB /)  
KB(:,47,12) = (/ &
 & 0.57406E+01_JPRB,0.57550E+01_JPRB,0.57336E+01_JPRB,0.56616E+01_JPRB,0.56928E+01_JPRB /)  
KB(:,48,12) = (/ &
 & 0.57616E+01_JPRB,0.57715E+01_JPRB,0.57765E+01_JPRB,0.57429E+01_JPRB,0.57151E+01_JPRB /)  
KB(:,49,12) = (/ &
 & 0.58013E+01_JPRB,0.57807E+01_JPRB,0.58014E+01_JPRB,0.57796E+01_JPRB,0.57022E+01_JPRB /)  
KB(:,50,12) = (/ &
 & 0.58611E+01_JPRB,0.58307E+01_JPRB,0.58954E+01_JPRB,0.58904E+01_JPRB,0.58254E+01_JPRB /)  
KB(:,51,12) = (/ &
 & 0.59182E+01_JPRB,0.59013E+01_JPRB,0.59353E+01_JPRB,0.59746E+01_JPRB,0.59215E+01_JPRB /)  
KB(:,52,12) = (/ &
 & 0.59636E+01_JPRB,0.59631E+01_JPRB,0.59638E+01_JPRB,0.60147E+01_JPRB,0.60288E+01_JPRB /)  
KB(:,53,12) = (/ &
 & 0.60261E+01_JPRB,0.59972E+01_JPRB,0.59771E+01_JPRB,0.60154E+01_JPRB,0.60632E+01_JPRB /)  
KB(:,54,12) = (/ &
 & 0.60204E+01_JPRB,0.60805E+01_JPRB,0.60002E+01_JPRB,0.60580E+01_JPRB,0.60854E+01_JPRB /)  
KB(:,55,12) = (/ &
 & 0.60584E+01_JPRB,0.61138E+01_JPRB,0.60917E+01_JPRB,0.60710E+01_JPRB,0.61237E+01_JPRB /)  
KB(:,56,12) = (/ &
 & 0.60402E+01_JPRB,0.61059E+01_JPRB,0.61154E+01_JPRB,0.61008E+01_JPRB,0.61463E+01_JPRB /)  
KB(:,57,12) = (/ &
 & 0.60080E+01_JPRB,0.61076E+01_JPRB,0.61306E+01_JPRB,0.61548E+01_JPRB,0.61892E+01_JPRB /)  
KB(:,58,12) = (/ &
 & 0.59781E+01_JPRB,0.61168E+01_JPRB,0.61621E+01_JPRB,0.61680E+01_JPRB,0.62246E+01_JPRB /)  
KB(:,59,12) = (/ &
 & 0.59824E+01_JPRB,0.60878E+01_JPRB,0.61825E+01_JPRB,0.62179E+01_JPRB,0.62658E+01_JPRB /)  
KB(:,13,13) = (/ &
 & 0.62252E+01_JPRB,0.61003E+01_JPRB,0.59711E+01_JPRB,0.58641E+01_JPRB,0.57820E+01_JPRB /)  
KB(:,14,13) = (/ &
 & 0.66429E+01_JPRB,0.64784E+01_JPRB,0.63526E+01_JPRB,0.62330E+01_JPRB,0.61644E+01_JPRB /)  
KB(:,15,13) = (/ &
 & 0.69743E+01_JPRB,0.68232E+01_JPRB,0.67077E+01_JPRB,0.66230E+01_JPRB,0.65438E+01_JPRB /)  
KB(:,16,13) = (/ &
 & 0.72971E+01_JPRB,0.72050E+01_JPRB,0.71016E+01_JPRB,0.69747E+01_JPRB,0.67726E+01_JPRB /)  
KB(:,17,13) = (/ &
 & 0.77109E+01_JPRB,0.75892E+01_JPRB,0.74253E+01_JPRB,0.72127E+01_JPRB,0.70341E+01_JPRB /)  
KB(:,18,13) = (/ &
 & 0.80450E+01_JPRB,0.78275E+01_JPRB,0.75988E+01_JPRB,0.74227E+01_JPRB,0.73977E+01_JPRB /)  
KB(:,19,13) = (/ &
 & 0.81727E+01_JPRB,0.79248E+01_JPRB,0.78355E+01_JPRB,0.77125E+01_JPRB,0.75391E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART16',0,ZHOOK_HANDLE)


KB(:,20,13) = (/ &
 & 0.82796E+01_JPRB,0.81265E+01_JPRB,0.80271E+01_JPRB,0.78599E+01_JPRB,0.77204E+01_JPRB /)  
KB(:,21,13) = (/ &
 & 0.84685E+01_JPRB,0.83415E+01_JPRB,0.82106E+01_JPRB,0.80317E+01_JPRB,0.78896E+01_JPRB /)  
KB(:,22,13) = (/ &
 & 0.86169E+01_JPRB,0.85255E+01_JPRB,0.83779E+01_JPRB,0.82528E+01_JPRB,0.81573E+01_JPRB /)  
KB(:,23,13) = (/ &
 & 0.88276E+01_JPRB,0.86892E+01_JPRB,0.86001E+01_JPRB,0.84644E+01_JPRB,0.83125E+01_JPRB /)  
KB(:,24,13) = (/ &
 & 0.89834E+01_JPRB,0.88963E+01_JPRB,0.87866E+01_JPRB,0.86675E+01_JPRB,0.84751E+01_JPRB /)  
KB(:,25,13) = (/ &
 & 0.91971E+01_JPRB,0.90977E+01_JPRB,0.89941E+01_JPRB,0.88254E+01_JPRB,0.85750E+01_JPRB /)  
KB(:,26,13) = (/ &
 & 0.93611E+01_JPRB,0.92762E+01_JPRB,0.91306E+01_JPRB,0.88795E+01_JPRB,0.86828E+01_JPRB /)  
KB(:,27,13) = (/ &
 & 0.95231E+01_JPRB,0.94096E+01_JPRB,0.91709E+01_JPRB,0.89786E+01_JPRB,0.86968E+01_JPRB /)  
KB(:,28,13) = (/ &
 & 0.96495E+01_JPRB,0.94564E+01_JPRB,0.92347E+01_JPRB,0.89785E+01_JPRB,0.86180E+01_JPRB /)  
KB(:,29,13) = (/ &
 & 0.97336E+01_JPRB,0.94935E+01_JPRB,0.92561E+01_JPRB,0.89137E+01_JPRB,0.86661E+01_JPRB /)  
KB(:,30,13) = (/ &
 & 0.97605E+01_JPRB,0.95111E+01_JPRB,0.92200E+01_JPRB,0.89355E+01_JPRB,0.85920E+01_JPRB /)  
KB(:,31,13) = (/ &
 & 0.97562E+01_JPRB,0.95167E+01_JPRB,0.91771E+01_JPRB,0.88618E+01_JPRB,0.85414E+01_JPRB /)  
KB(:,32,13) = (/ &
 & 0.97192E+01_JPRB,0.94434E+01_JPRB,0.91403E+01_JPRB,0.87870E+01_JPRB,0.85159E+01_JPRB /)  
KB(:,33,13) = (/ &
 & 0.97162E+01_JPRB,0.94370E+01_JPRB,0.90971E+01_JPRB,0.88239E+01_JPRB,0.85528E+01_JPRB /)  
KB(:,34,13) = (/ &
 & 0.96997E+01_JPRB,0.93448E+01_JPRB,0.90783E+01_JPRB,0.87958E+01_JPRB,0.87225E+01_JPRB /)  
KB(:,35,13) = (/ &
 & 0.97261E+01_JPRB,0.93769E+01_JPRB,0.90457E+01_JPRB,0.89061E+01_JPRB,0.87695E+01_JPRB /)  
KB(:,36,13) = (/ &
 & 0.97573E+01_JPRB,0.94639E+01_JPRB,0.92105E+01_JPRB,0.90277E+01_JPRB,0.88187E+01_JPRB /)  
KB(:,37,13) = (/ &
 & 0.98297E+01_JPRB,0.95424E+01_JPRB,0.93169E+01_JPRB,0.90796E+01_JPRB,0.89104E+01_JPRB /)  
KB(:,38,13) = (/ &
 & 0.99015E+01_JPRB,0.96432E+01_JPRB,0.94039E+01_JPRB,0.91616E+01_JPRB,0.89941E+01_JPRB /)  
KB(:,39,13) = (/ &
 & 0.99137E+01_JPRB,0.96714E+01_JPRB,0.94790E+01_JPRB,0.92092E+01_JPRB,0.90352E+01_JPRB /)  
KB(:,40,13) = (/ &
 & 0.99728E+01_JPRB,0.96872E+01_JPRB,0.94263E+01_JPRB,0.92759E+01_JPRB,0.90690E+01_JPRB /)  
KB(:,41,13) = (/ &
 & 0.10009E+02_JPRB,0.96720E+01_JPRB,0.94529E+01_JPRB,0.92520E+01_JPRB,0.90775E+01_JPRB /)  
KB(:,42,13) = (/ &
 & 0.99394E+01_JPRB,0.96947E+01_JPRB,0.94735E+01_JPRB,0.92670E+01_JPRB,0.90312E+01_JPRB /)  
KB(:,43,13) = (/ &
 & 0.98412E+01_JPRB,0.96685E+01_JPRB,0.93802E+01_JPRB,0.91747E+01_JPRB,0.90019E+01_JPRB /)  
KB(:,44,13) = (/ &
 & 0.98284E+01_JPRB,0.96419E+01_JPRB,0.93576E+01_JPRB,0.91166E+01_JPRB,0.88968E+01_JPRB /)  
KB(:,45,13) = (/ &
 & 0.98765E+01_JPRB,0.96737E+01_JPRB,0.94176E+01_JPRB,0.90811E+01_JPRB,0.88300E+01_JPRB /)  
KB(:,46,13) = (/ &
 & 0.99370E+01_JPRB,0.96739E+01_JPRB,0.94534E+01_JPRB,0.91692E+01_JPRB,0.88574E+01_JPRB /)  
KB(:,47,13) = (/ &
 & 0.10145E+02_JPRB,0.99712E+01_JPRB,0.96675E+01_JPRB,0.93530E+01_JPRB,0.89895E+01_JPRB /)  
KB(:,48,13) = (/ &
 & 0.10395E+02_JPRB,0.10167E+02_JPRB,0.99330E+01_JPRB,0.95943E+01_JPRB,0.92927E+01_JPRB /)  
KB(:,49,13) = (/ &
 & 0.10580E+02_JPRB,0.10365E+02_JPRB,0.10114E+02_JPRB,0.98197E+01_JPRB,0.95303E+01_JPRB /)  
KB(:,50,13) = (/ &
 & 0.10794E+02_JPRB,0.10715E+02_JPRB,0.10421E+02_JPRB,0.10154E+02_JPRB,0.98629E+01_JPRB /)  
KB(:,51,13) = (/ &
 & 0.10946E+02_JPRB,0.10939E+02_JPRB,0.10689E+02_JPRB,0.10427E+02_JPRB,0.10145E+02_JPRB /)  
KB(:,52,13) = (/ &
 & 0.11156E+02_JPRB,0.11126E+02_JPRB,0.10973E+02_JPRB,0.10622E+02_JPRB,0.10371E+02_JPRB /)  
KB(:,53,13) = (/ &
 & 0.11165E+02_JPRB,0.11308E+02_JPRB,0.11212E+02_JPRB,0.10985E+02_JPRB,0.10624E+02_JPRB /)  
KB(:,54,13) = (/ &
 & 0.11221E+02_JPRB,0.11354E+02_JPRB,0.11431E+02_JPRB,0.11243E+02_JPRB,0.10959E+02_JPRB /)  
KB(:,55,13) = (/ &
 & 0.11238E+02_JPRB,0.11406E+02_JPRB,0.11591E+02_JPRB,0.11479E+02_JPRB,0.11275E+02_JPRB /)  
KB(:,56,13) = (/ &
 & 0.11335E+02_JPRB,0.11405E+02_JPRB,0.11662E+02_JPRB,0.11637E+02_JPRB,0.11480E+02_JPRB /)  
KB(:,57,13) = (/ &
 & 0.11355E+02_JPRB,0.11451E+02_JPRB,0.11592E+02_JPRB,0.11670E+02_JPRB,0.11515E+02_JPRB /)  
KB(:,58,13) = (/ &
 & 0.11389E+02_JPRB,0.11476E+02_JPRB,0.11586E+02_JPRB,0.11657E+02_JPRB,0.11618E+02_JPRB /)  
KB(:,59,13) = (/ &
 & 0.11480E+02_JPRB,0.11599E+02_JPRB,0.11673E+02_JPRB,0.11677E+02_JPRB,0.11653E+02_JPRB /)  
KB(:,13,14) = (/ &
 & 0.97590E+01_JPRB,0.94275E+01_JPRB,0.91020E+01_JPRB,0.89149E+01_JPRB,0.87289E+01_JPRB /)  
KB(:,14,14) = (/ &
 & 0.10505E+02_JPRB,0.10164E+02_JPRB,0.99232E+01_JPRB,0.97321E+01_JPRB,0.94201E+01_JPRB /)  
KB(:,15,14) = (/ &
 & 0.11237E+02_JPRB,0.10955E+02_JPRB,0.10714E+02_JPRB,0.10370E+02_JPRB,0.10019E+02_JPRB /)  
KB(:,16,14) = (/ &
 & 0.12124E+02_JPRB,0.11740E+02_JPRB,0.11352E+02_JPRB,0.10992E+02_JPRB,0.10632E+02_JPRB /)  
KB(:,17,14) = (/ &
 & 0.12886E+02_JPRB,0.12429E+02_JPRB,0.12001E+02_JPRB,0.11642E+02_JPRB,0.11273E+02_JPRB /)  
KB(:,18,14) = (/ &
 & 0.13556E+02_JPRB,0.13047E+02_JPRB,0.12733E+02_JPRB,0.12297E+02_JPRB,0.11616E+02_JPRB /)  
KB(:,19,14) = (/ &
 & 0.14349E+02_JPRB,0.13901E+02_JPRB,0.13193E+02_JPRB,0.12562E+02_JPRB,0.12015E+02_JPRB /)  
KB(:,20,14) = (/ &
 & 0.15084E+02_JPRB,0.14361E+02_JPRB,0.13567E+02_JPRB,0.12903E+02_JPRB,0.12393E+02_JPRB /)  
KB(:,21,14) = (/ &
 & 0.15509E+02_JPRB,0.14641E+02_JPRB,0.13824E+02_JPRB,0.13136E+02_JPRB,0.12832E+02_JPRB /)  
KB(:,22,14) = (/ &
 & 0.15737E+02_JPRB,0.14756E+02_JPRB,0.13944E+02_JPRB,0.13493E+02_JPRB,0.13014E+02_JPRB /)  
KB(:,23,14) = (/ &
 & 0.15733E+02_JPRB,0.14806E+02_JPRB,0.14130E+02_JPRB,0.13708E+02_JPRB,0.13129E+02_JPRB /)  
KB(:,24,14) = (/ &
 & 0.15735E+02_JPRB,0.14832E+02_JPRB,0.14382E+02_JPRB,0.13702E+02_JPRB,0.13090E+02_JPRB /)  
KB(:,25,14) = (/ &
 & 0.15596E+02_JPRB,0.15046E+02_JPRB,0.14369E+02_JPRB,0.13676E+02_JPRB,0.13207E+02_JPRB /)  
KB(:,26,14) = (/ &
 & 0.15679E+02_JPRB,0.15085E+02_JPRB,0.14382E+02_JPRB,0.13864E+02_JPRB,0.13243E+02_JPRB /)  
KB(:,27,14) = (/ &
 & 0.15773E+02_JPRB,0.15051E+02_JPRB,0.14458E+02_JPRB,0.13792E+02_JPRB,0.13309E+02_JPRB /)  
KB(:,28,14) = (/ &
 & 0.15791E+02_JPRB,0.15118E+02_JPRB,0.14520E+02_JPRB,0.13908E+02_JPRB,0.13506E+02_JPRB /)  
KB(:,29,14) = (/ &
 & 0.15907E+02_JPRB,0.15282E+02_JPRB,0.14696E+02_JPRB,0.14168E+02_JPRB,0.13591E+02_JPRB /)  
KB(:,30,14) = (/ &
 & 0.15997E+02_JPRB,0.15426E+02_JPRB,0.14908E+02_JPRB,0.14325E+02_JPRB,0.13655E+02_JPRB /)  
KB(:,31,14) = (/ &
 & 0.16254E+02_JPRB,0.15640E+02_JPRB,0.15053E+02_JPRB,0.14410E+02_JPRB,0.13542E+02_JPRB /)  
KB(:,32,14) = (/ &
 & 0.16522E+02_JPRB,0.15885E+02_JPRB,0.15194E+02_JPRB,0.14363E+02_JPRB,0.13365E+02_JPRB /)  
KB(:,33,14) = (/ &
 & 0.16844E+02_JPRB,0.16068E+02_JPRB,0.15151E+02_JPRB,0.14109E+02_JPRB,0.13003E+02_JPRB /)  
KB(:,34,14) = (/ &
 & 0.16915E+02_JPRB,0.16003E+02_JPRB,0.14953E+02_JPRB,0.13814E+02_JPRB,0.12608E+02_JPRB /)  
KB(:,35,14) = (/ &
 & 0.16922E+02_JPRB,0.15890E+02_JPRB,0.14756E+02_JPRB,0.13405E+02_JPRB,0.12281E+02_JPRB /)  
KB(:,36,14) = (/ &
 & 0.16966E+02_JPRB,0.15773E+02_JPRB,0.14522E+02_JPRB,0.13240E+02_JPRB,0.11917E+02_JPRB /)  
KB(:,37,14) = (/ &
 & 0.17142E+02_JPRB,0.15897E+02_JPRB,0.14564E+02_JPRB,0.13378E+02_JPRB,0.11953E+02_JPRB /)  
KB(:,38,14) = (/ &
 & 0.17346E+02_JPRB,0.16051E+02_JPRB,0.14752E+02_JPRB,0.13439E+02_JPRB,0.11971E+02_JPRB /)  
KB(:,39,14) = (/ &
 & 0.17475E+02_JPRB,0.16210E+02_JPRB,0.14948E+02_JPRB,0.13510E+02_JPRB,0.12056E+02_JPRB /)  
KB(:,40,14) = (/ &
 & 0.17754E+02_JPRB,0.16503E+02_JPRB,0.15328E+02_JPRB,0.13801E+02_JPRB,0.12328E+02_JPRB /)  
KB(:,41,14) = (/ &
 & 0.18031E+02_JPRB,0.16909E+02_JPRB,0.15619E+02_JPRB,0.14276E+02_JPRB,0.12740E+02_JPRB /)  
KB(:,42,14) = (/ &
 & 0.18386E+02_JPRB,0.17235E+02_JPRB,0.15966E+02_JPRB,0.14652E+02_JPRB,0.13194E+02_JPRB /)  
KB(:,43,14) = (/ &
 & 0.18710E+02_JPRB,0.17591E+02_JPRB,0.16361E+02_JPRB,0.15070E+02_JPRB,0.13707E+02_JPRB /)  
KB(:,44,14) = (/ &
 & 0.19098E+02_JPRB,0.17898E+02_JPRB,0.16845E+02_JPRB,0.15582E+02_JPRB,0.14265E+02_JPRB /)  
KB(:,45,14) = (/ &
 & 0.19252E+02_JPRB,0.18167E+02_JPRB,0.17135E+02_JPRB,0.15969E+02_JPRB,0.14652E+02_JPRB /)  
KB(:,46,14) = (/ &
 & 0.19041E+02_JPRB,0.18357E+02_JPRB,0.17265E+02_JPRB,0.16200E+02_JPRB,0.15002E+02_JPRB /)  
KB(:,47,14) = (/ &
 & 0.18766E+02_JPRB,0.18032E+02_JPRB,0.17152E+02_JPRB,0.16208E+02_JPRB,0.15088E+02_JPRB /)  
KB(:,48,14) = (/ &
 & 0.18411E+02_JPRB,0.17740E+02_JPRB,0.16984E+02_JPRB,0.16085E+02_JPRB,0.15089E+02_JPRB /)  
KB(:,49,14) = (/ &
 & 0.18291E+02_JPRB,0.17667E+02_JPRB,0.16941E+02_JPRB,0.16014E+02_JPRB,0.14979E+02_JPRB /)  
KB(:,50,14) = (/ &
 & 0.18624E+02_JPRB,0.17786E+02_JPRB,0.17174E+02_JPRB,0.16136E+02_JPRB,0.15128E+02_JPRB /)  
KB(:,51,14) = (/ &
 & 0.19430E+02_JPRB,0.18470E+02_JPRB,0.17722E+02_JPRB,0.16775E+02_JPRB,0.15711E+02_JPRB /)  
KB(:,52,14) = (/ &
 & 0.20123E+02_JPRB,0.18895E+02_JPRB,0.18060E+02_JPRB,0.17255E+02_JPRB,0.16173E+02_JPRB /)  
KB(:,53,14) = (/ &
 & 0.20744E+02_JPRB,0.19415E+02_JPRB,0.18626E+02_JPRB,0.17397E+02_JPRB,0.16465E+02_JPRB /)  
KB(:,54,14) = (/ &
 & 0.21714E+02_JPRB,0.20093E+02_JPRB,0.19173E+02_JPRB,0.18078E+02_JPRB,0.16884E+02_JPRB /)  
KB(:,55,14) = (/ &
 & 0.22731E+02_JPRB,0.21068E+02_JPRB,0.19674E+02_JPRB,0.18569E+02_JPRB,0.17315E+02_JPRB /)  
KB(:,56,14) = (/ &
 & 0.23924E+02_JPRB,0.22190E+02_JPRB,0.20317E+02_JPRB,0.18891E+02_JPRB,0.17603E+02_JPRB /)  
KB(:,57,14) = (/ &
 & 0.24940E+02_JPRB,0.23270E+02_JPRB,0.21498E+02_JPRB,0.19833E+02_JPRB,0.18265E+02_JPRB /)  
KB(:,58,14) = (/ &
 & 0.25828E+02_JPRB,0.24271E+02_JPRB,0.22518E+02_JPRB,0.20827E+02_JPRB,0.19003E+02_JPRB /)  
KB(:,59,14) = (/ &
 & 0.26483E+02_JPRB,0.24983E+02_JPRB,0.23453E+02_JPRB,0.21676E+02_JPRB,0.19755E+02_JPRB /)  
KB(:,13,15) = (/ &
 & 0.15960E+02_JPRB,0.15303E+02_JPRB,0.14694E+02_JPRB,0.13842E+02_JPRB,0.13008E+02_JPRB /)  
KB(:,14,15) = (/ &
 & 0.17675E+02_JPRB,0.16896E+02_JPRB,0.15925E+02_JPRB,0.14915E+02_JPRB,0.14133E+02_JPRB /)  
KB(:,15,15) = (/ &
 & 0.19385E+02_JPRB,0.18234E+02_JPRB,0.16959E+02_JPRB,0.15987E+02_JPRB,0.15180E+02_JPRB /)  
KB(:,16,15) = (/ &
 & 0.20552E+02_JPRB,0.19165E+02_JPRB,0.17982E+02_JPRB,0.16927E+02_JPRB,0.16368E+02_JPRB /)  
KB(:,17,15) = (/ &
 & 0.21349E+02_JPRB,0.19954E+02_JPRB,0.19023E+02_JPRB,0.18091E+02_JPRB,0.17398E+02_JPRB /)  
KB(:,18,15) = (/ &
 & 0.22160E+02_JPRB,0.21597E+02_JPRB,0.20213E+02_JPRB,0.19055E+02_JPRB,0.18102E+02_JPRB /)  
KB(:,19,15) = (/ &
 & 0.23816E+02_JPRB,0.22303E+02_JPRB,0.21008E+02_JPRB,0.19912E+02_JPRB,0.18903E+02_JPRB /)  
KB(:,20,15) = (/ &
 & 0.24810E+02_JPRB,0.23381E+02_JPRB,0.21933E+02_JPRB,0.20846E+02_JPRB,0.19540E+02_JPRB /)  
KB(:,21,15) = (/ &
 & 0.25893E+02_JPRB,0.24250E+02_JPRB,0.22750E+02_JPRB,0.21616E+02_JPRB,0.19627E+02_JPRB /)  
KB(:,22,15) = (/ &
 & 0.26542E+02_JPRB,0.24773E+02_JPRB,0.23600E+02_JPRB,0.21309E+02_JPRB,0.19278E+02_JPRB /)  
KB(:,23,15) = (/ &
 & 0.27270E+02_JPRB,0.25621E+02_JPRB,0.23587E+02_JPRB,0.21255E+02_JPRB,0.19478E+02_JPRB /)  
KB(:,24,15) = (/ &
 & 0.27744E+02_JPRB,0.26088E+02_JPRB,0.23254E+02_JPRB,0.21242E+02_JPRB,0.19100E+02_JPRB /)  
KB(:,25,15) = (/ &
 & 0.28557E+02_JPRB,0.25575E+02_JPRB,0.23098E+02_JPRB,0.20631E+02_JPRB,0.18206E+02_JPRB /)  
KB(:,26,15) = (/ &
 & 0.28140E+02_JPRB,0.25135E+02_JPRB,0.22210E+02_JPRB,0.19496E+02_JPRB,0.17366E+02_JPRB /)  
KB(:,27,15) = (/ &
 & 0.27284E+02_JPRB,0.24232E+02_JPRB,0.21249E+02_JPRB,0.18720E+02_JPRB,0.16279E+02_JPRB /)  
KB(:,28,15) = (/ &
 & 0.26494E+02_JPRB,0.23076E+02_JPRB,0.20060E+02_JPRB,0.17566E+02_JPRB,0.14956E+02_JPRB /)  
KB(:,29,15) = (/ &
 & 0.24773E+02_JPRB,0.21460E+02_JPRB,0.18370E+02_JPRB,0.15793E+02_JPRB,0.13302E+02_JPRB /)  
KB(:,30,15) = (/ &
 & 0.23157E+02_JPRB,0.19587E+02_JPRB,0.16563E+02_JPRB,0.13805E+02_JPRB,0.11647E+02_JPRB /)  
KB(:,31,15) = (/ &
 & 0.20881E+02_JPRB,0.17370E+02_JPRB,0.14460E+02_JPRB,0.11958E+02_JPRB,0.99808E+01_JPRB /)  
KB(:,32,15) = (/ &
 & 0.18247E+02_JPRB,0.15035E+02_JPRB,0.12296E+02_JPRB,0.10101E+02_JPRB,0.83032E+01_JPRB /)  
KB(:,33,15) = (/ &
 & 0.15492E+02_JPRB,0.12470E+02_JPRB,0.10235E+02_JPRB,0.81131E+01_JPRB,0.64390E+01_JPRB /)  
KB(:,34,15) = (/ &
 & 0.13284E+02_JPRB,0.10782E+02_JPRB,0.82553E+01_JPRB,0.64597E+01_JPRB,0.42402E+01_JPRB /)  
KB(:,35,15) = (/ &
 & 0.11520E+02_JPRB,0.89534E+01_JPRB,0.69691E+01_JPRB,0.48753E+01_JPRB,0.27443E+01_JPRB /)  
KB(:,36,15) = (/ &
 & 0.10067E+02_JPRB,0.75650E+01_JPRB,0.54572E+01_JPRB,0.31866E+01_JPRB,0.14626E+01_JPRB /)  
KB(:,37,15) = (/ &
 & 0.97744E+01_JPRB,0.73767E+01_JPRB,0.52433E+01_JPRB,0.27509E+01_JPRB,0.10380E+01_JPRB /)  
KB(:,38,15) = (/ &
 & 0.94733E+01_JPRB,0.70859E+01_JPRB,0.47807E+01_JPRB,0.23954E+01_JPRB,0.74468E+00_JPRB /)  
KB(:,39,15) = (/ &
 & 0.94041E+01_JPRB,0.67286E+01_JPRB,0.41966E+01_JPRB,0.20683E+01_JPRB,0.27939E+00_JPRB /)  
KB(:,40,15) = (/ &
 & 0.10076E+02_JPRB,0.74414E+01_JPRB,0.47964E+01_JPRB,0.25258E+01_JPRB,0.87689E+00_JPRB /)  
KB(:,41,15) = (/ &
 & 0.10878E+02_JPRB,0.81759E+01_JPRB,0.56173E+01_JPRB,0.30416E+01_JPRB,0.13231E+01_JPRB /)  
KB(:,42,15) = (/ &
 & 0.11858E+02_JPRB,0.88284E+01_JPRB,0.63009E+01_JPRB,0.37211E+01_JPRB,0.17214E+01_JPRB /)  
KB(:,43,15) = (/ &
 & 0.13284E+02_JPRB,0.99847E+01_JPRB,0.73905E+01_JPRB,0.50291E+01_JPRB,0.24940E+01_JPRB /)  
KB(:,44,15) = (/ &
 & 0.14796E+02_JPRB,0.11545E+02_JPRB,0.85671E+01_JPRB,0.61687E+01_JPRB,0.37136E+01_JPRB /)  
KB(:,45,15) = (/ &
 & 0.16662E+02_JPRB,0.12949E+02_JPRB,0.98033E+01_JPRB,0.73353E+01_JPRB,0.52329E+01_JPRB /)  
KB(:,46,15) = (/ &
 & 0.19200E+02_JPRB,0.14684E+02_JPRB,0.11434E+02_JPRB,0.85867E+01_JPRB,0.64428E+01_JPRB /)  
KB(:,47,15) = (/ &
 & 0.21780E+02_JPRB,0.16837E+02_JPRB,0.13158E+02_JPRB,0.10165E+02_JPRB,0.76608E+01_JPRB /)  
KB(:,48,15) = (/ &
 & 0.24689E+02_JPRB,0.19487E+02_JPRB,0.15145E+02_JPRB,0.11845E+02_JPRB,0.89940E+01_JPRB /)  
KB(:,49,15) = (/ &
 & 0.27130E+02_JPRB,0.21775E+02_JPRB,0.17116E+02_JPRB,0.13679E+02_JPRB,0.10905E+02_JPRB /)  
KB(:,50,15) = (/ &
 & 0.27854E+02_JPRB,0.22306E+02_JPRB,0.17103E+02_JPRB,0.13783E+02_JPRB,0.10863E+02_JPRB /)  
KB(:,51,15) = (/ &
 & 0.27653E+02_JPRB,0.21825E+02_JPRB,0.16692E+02_JPRB,0.12707E+02_JPRB,0.98148E+01_JPRB /)  
KB(:,52,15) = (/ &
 & 0.27815E+02_JPRB,0.22411E+02_JPRB,0.17151E+02_JPRB,0.12787E+02_JPRB,0.95823E+01_JPRB /)  
KB(:,53,15) = (/ &
 & 0.29119E+02_JPRB,0.23144E+02_JPRB,0.17252E+02_JPRB,0.13594E+02_JPRB,0.99767E+01_JPRB /)  
KB(:,54,15) = (/ &
 & 0.29129E+02_JPRB,0.23469E+02_JPRB,0.17342E+02_JPRB,0.12745E+02_JPRB,0.95359E+01_JPRB /)  
KB(:,55,15) = (/ &
 & 0.29058E+02_JPRB,0.23190E+02_JPRB,0.17458E+02_JPRB,0.12690E+02_JPRB,0.90099E+01_JPRB /)  
KB(:,56,15) = (/ &
 & 0.28657E+02_JPRB,0.23001E+02_JPRB,0.17896E+02_JPRB,0.13433E+02_JPRB,0.94907E+01_JPRB /)  
KB(:,57,15) = (/ &
 & 0.29240E+02_JPRB,0.22830E+02_JPRB,0.17734E+02_JPRB,0.13185E+02_JPRB,0.97411E+01_JPRB /)  
KB(:,58,15) = (/ &
 & 0.29947E+02_JPRB,0.22946E+02_JPRB,0.17582E+02_JPRB,0.13008E+02_JPRB,0.96489E+01_JPRB /)  
KB(:,59,15) = (/ &
 & 0.28976E+02_JPRB,0.21746E+02_JPRB,0.15522E+02_JPRB,0.11254E+02_JPRB,0.80222E+01_JPRB /)  
KB(:,13,16) = (/ &
 & 0.25931E+02_JPRB,0.24537E+02_JPRB,0.23224E+02_JPRB,0.21983E+02_JPRB,0.20855E+02_JPRB /)  
KB(:,14,16) = (/ &
 & 0.29220E+02_JPRB,0.27507E+02_JPRB,0.25899E+02_JPRB,0.24431E+02_JPRB,0.23088E+02_JPRB /)  
KB(:,15,16) = (/ &
 & 0.32471E+02_JPRB,0.30409E+02_JPRB,0.28502E+02_JPRB,0.26794E+02_JPRB,0.25226E+02_JPRB /)  
KB(:,16,16) = (/ &
 & 0.35624E+02_JPRB,0.33186E+02_JPRB,0.30989E+02_JPRB,0.28748E+02_JPRB,0.24479E+02_JPRB /)  
KB(:,17,16) = (/ &
 & 0.38605E+02_JPRB,0.35797E+02_JPRB,0.30613E+02_JPRB,0.25949E+02_JPRB,0.21171E+02_JPRB /)  
KB(:,18,16) = (/ &
 & 0.41350E+02_JPRB,0.31676E+02_JPRB,0.25965E+02_JPRB,0.21818E+02_JPRB,0.18145E+02_JPRB /)  
KB(:,19,16) = (/ &
 & 0.34377E+02_JPRB,0.28144E+02_JPRB,0.23342E+02_JPRB,0.17735E+02_JPRB,0.13818E+02_JPRB /)  
KB(:,20,16) = (/ &
 & 0.31245E+02_JPRB,0.24408E+02_JPRB,0.19618E+02_JPRB,0.13984E+02_JPRB,0.93171E+01_JPRB /)  
KB(:,21,16) = (/ &
 & 0.28216E+02_JPRB,0.21711E+02_JPRB,0.16938E+02_JPRB,0.11225E+02_JPRB,0.60954E+01_JPRB /)  
KB(:,22,16) = (/ &
 & 0.25410E+02_JPRB,0.20320E+02_JPRB,0.12451E+02_JPRB,0.80509E+01_JPRB,0.41742E+01_JPRB /)  
KB(:,23,16) = (/ &
 & 0.22191E+02_JPRB,0.15284E+02_JPRB,0.84334E+01_JPRB,0.32443E+01_JPRB,0.10236E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART17',0,ZHOOK_HANDLE)


KB(:,24,16) = (/ &
 & 0.19170E+02_JPRB,0.98429E+01_JPRB,0.40822E+01_JPRB,0.90070E-05_JPRB,0.84964E-05_JPRB /)  
KB(:,25,16) = (/ &
 & 0.11441E+02_JPRB,0.50508E+01_JPRB,0.77316E-05_JPRB,0.71796E-05_JPRB,0.66473E-05_JPRB /)  
KB(:,26,16) = (/ &
 & 0.73617E+01_JPRB,0.56953E+00_JPRB,0.62155E-05_JPRB,0.57759E-05_JPRB,0.53447E-05_JPRB /)  
KB(:,27,16) = (/ &
 & 0.37038E+01_JPRB,0.54098E-05_JPRB,0.49933E-05_JPRB,0.45180E-05_JPRB,0.42997E-05_JPRB /)  
KB(:,28,16) = (/ &
 & 0.47094E-05_JPRB,0.43472E-05_JPRB,0.40149E-05_JPRB,0.36332E-05_JPRB,0.34550E-05_JPRB /)  
KB(:,29,16) = (/ &
 & 0.37812E-05_JPRB,0.34885E-05_JPRB,0.32238E-05_JPRB,0.29187E-05_JPRB,0.27779E-05_JPRB /)  
KB(:,30,16) = (/ &
 & 0.30339E-05_JPRB,0.28004E-05_JPRB,0.25314E-05_JPRB,0.23451E-05_JPRB,0.22313E-05_JPRB /)  
KB(:,31,16) = (/ &
 & 0.24328E-05_JPRB,0.22460E-05_JPRB,0.20326E-05_JPRB,0.18813E-05_JPRB,0.17930E-05_JPRB /)  
KB(:,32,16) = (/ &
 & 0.18939E-05_JPRB,0.18012E-05_JPRB,0.16316E-05_JPRB,0.15109E-05_JPRB,0.14395E-05_JPRB /)  
KB(:,33,16) = (/ &
 & 0.15657E-05_JPRB,0.14309E-05_JPRB,0.13083E-05_JPRB,0.12124E-05_JPRB,0.15795E-05_JPRB /)  
KB(:,34,16) = (/ &
 & 0.12582E-05_JPRB,0.11508E-05_JPRB,0.10527E-05_JPRB,0.97625E-06_JPRB,0.19757E-05_JPRB /)  
KB(:,35,16) = (/ &
 & 0.10197E-05_JPRB,0.93275E-06_JPRB,0.85375E-06_JPRB,0.79153E-06_JPRB,0.21668E-05_JPRB /)  
KB(:,36,16) = (/ &
 & 0.83336E-06_JPRB,0.76274E-06_JPRB,0.69805E-06_JPRB,0.64735E-06_JPRB,0.17739E-05_JPRB /)  
KB(:,37,16) = (/ &
 & 0.68945E-06_JPRB,0.63022E-06_JPRB,0.57702E-06_JPRB,0.53486E-06_JPRB,0.10843E-05_JPRB /)  
KB(:,38,16) = (/ &
 & 0.55406E-06_JPRB,0.52180E-06_JPRB,0.47760E-06_JPRB,0.44282E-06_JPRB,0.89395E-06_JPRB /)  
KB(:,39,16) = (/ &
 & 0.45861E-06_JPRB,0.43223E-06_JPRB,0.39548E-06_JPRB,0.36639E-06_JPRB,0.47718E-06_JPRB /)  
KB(:,40,16) = (/ &
 & 0.38297E-06_JPRB,0.36441E-06_JPRB,0.32989E-06_JPRB,0.30551E-06_JPRB,0.28352E-06_JPRB /)  
KB(:,41,16) = (/ &
 & 0.31987E-06_JPRB,0.30430E-06_JPRB,0.27838E-06_JPRB,0.25513E-06_JPRB,0.23647E-06_JPRB /)  
KB(:,42,16) = (/ &
 & 0.26734E-06_JPRB,0.24677E-06_JPRB,0.23264E-06_JPRB,0.21290E-06_JPRB,0.19743E-06_JPRB /)  
KB(:,43,16) = (/ &
 & 0.22458E-06_JPRB,0.20712E-06_JPRB,0.19517E-06_JPRB,0.17853E-06_JPRB,0.16551E-06_JPRB /)  
KB(:,44,16) = (/ &
 & 0.18898E-06_JPRB,0.17429E-06_JPRB,0.16587E-06_JPRB,0.15173E-06_JPRB,0.13895E-06_JPRB /)  
KB(:,45,16) = (/ &
 & 0.15450E-06_JPRB,0.14658E-06_JPRB,0.13533E-06_JPRB,0.12759E-06_JPRB,0.11679E-06_JPRB /)  
KB(:,46,16) = (/ &
 & 0.13028E-06_JPRB,0.12362E-06_JPRB,0.11400E-06_JPRB,0.10744E-06_JPRB,0.98279E-07_JPRB /)  
KB(:,47,16) = (/ &
 & 0.11024E-06_JPRB,0.10159E-06_JPRB,0.96435E-07_JPRB,0.91711E-07_JPRB,0.83972E-07_JPRB /)  
KB(:,48,16) = (/ &
 & 0.93198E-07_JPRB,0.85906E-07_JPRB,0.81590E-07_JPRB,0.75279E-07_JPRB,0.70931E-07_JPRB /)  
KB(:,49,16) = (/ &
 & 0.76236E-07_JPRB,0.72626E-07_JPRB,0.68995E-07_JPRB,0.63641E-07_JPRB,0.60530E-07_JPRB /)  
KB(:,50,16) = (/ &
 & 0.64328E-07_JPRB,0.61369E-07_JPRB,0.56594E-07_JPRB,0.53672E-07_JPRB,0.49555E-07_JPRB /)  
KB(:,51,16) = (/ &
 & 0.54169E-07_JPRB,0.51722E-07_JPRB,0.47685E-07_JPRB,0.45298E-07_JPRB,0.41770E-07_JPRB /)  
KB(:,52,16) = (/ &
 & 0.46180E-07_JPRB,0.42221E-07_JPRB,0.40251E-07_JPRB,0.37120E-07_JPRB,0.35204E-07_JPRB /)  
KB(:,53,16) = (/ &
 & 0.33194E-01_JPRB,0.35538E-07_JPRB,0.33930E-07_JPRB,0.31297E-07_JPRB,0.29712E-07_JPRB /)  
KB(:,54,16) = (/ &
 & 0.63212E-01_JPRB,0.54132E-01_JPRB,0.36437E-01_JPRB,0.71353E-02_JPRB,0.24978E-07_JPRB /)  
KB(:,55,16) = (/ &
 & 0.62321E-01_JPRB,0.69163E-01_JPRB,0.76899E-01_JPRB,0.64692E-01_JPRB,0.42869E-01_JPRB /)  
KB(:,56,16) = (/ &
 & 0.73050E-01_JPRB,0.83118E-01_JPRB,0.74962E-01_JPRB,0.82540E-01_JPRB,0.91058E-01_JPRB /)  
KB(:,57,16) = (/ &
 & 0.71162E-01_JPRB,0.79898E-01_JPRB,0.89953E-01_JPRB,0.10014E+00_JPRB,0.10382E+00_JPRB /)  
KB(:,58,16) = (/ &
 & 0.67770E-01_JPRB,0.78960E-01_JPRB,0.86882E-01_JPRB,0.97002E-01_JPRB,0.10740E+00_JPRB /)  
KB(:,59,16) = (/ &
 & 0.66421E-01_JPRB,0.77608E-01_JPRB,0.10426E+00_JPRB,0.10063E+00_JPRB,0.10735E+00_JPRB /)  
  
!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.860560E-06_JPRB, 0.130439E-05_JPRB, 0.382378E-05_JPRB /)
FORREF(:, 2) = (/ 0.817926E-06_JPRB, 0.158599E-05_JPRB, 0.658771E-04_JPRB /)
FORREF(:, 3) = (/ 0.129369E-05_JPRB, 0.824406E-05_JPRB, 0.952778E-04_JPRB /)
FORREF(:, 4) = (/ 0.438918E-05_JPRB, 0.375356E-04_JPRB, 0.119111E-03_JPRB /)
FORREF(:, 5) = (/ 0.306057E-04_JPRB, 0.622798E-04_JPRB, 0.100740E-03_JPRB /)
FORREF(:, 6) = (/ 0.891934E-04_JPRB, 0.856393E-04_JPRB, 0.635583E-04_JPRB /)
FORREF(:, 7) = (/ 0.171959E-03_JPRB, 0.173431E-03_JPRB, 0.611721E-04_JPRB /)
FORREF(:, 8) = (/ 0.357795E-03_JPRB, 0.247261E-03_JPRB, 0.488864E-04_JPRB /)
FORREF(:, 9) = (/ 0.326623E-03_JPRB, 0.289471E-03_JPRB, 0.548834E-04_JPRB /)
FORREF(:,10) = (/ 0.345103E-03_JPRB, 0.320898E-03_JPRB, 0.633214E-04_JPRB /)
FORREF(:,11) = (/ 0.392567E-03_JPRB, 0.325153E-03_JPRB, 0.744479E-04_JPRB /)
FORREF(:,12) = (/ 0.349277E-03_JPRB, 0.345610E-03_JPRB, 0.916479E-04_JPRB /)
FORREF(:,13) = (/ 0.425161E-03_JPRB, 0.348452E-03_JPRB, 0.125788E-03_JPRB /)
FORREF(:,14) = (/ 0.407594E-03_JPRB, 0.435836E-03_JPRB, 0.287583E-03_JPRB /)
FORREF(:,15) = (/ 0.521605E-03_JPRB, 0.486596E-03_JPRB, 0.483511E-03_JPRB /)
FORREF(:,16) = (/ 0.773790E-03_JPRB, 0.737247E-03_JPRB, 0.665939E-03_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
     
SELFREF(:, 1) = (/ &
 & 0.750370E-03_JPRB, 0.644938E-03_JPRB, 0.554321E-03_JPRB, 0.476436E-03_JPRB, 0.409494E-03_JPRB, &
 & 0.351957E-03_JPRB, 0.302505E-03_JPRB, 0.260002E-03_JPRB, 0.223470E-03_JPRB, 0.192071E-03_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.136135E-02_JPRB, 0.113187E-02_JPRB, 0.941076E-03_JPRB, 0.782440E-03_JPRB, 0.650546E-03_JPRB, &
 & 0.540885E-03_JPRB, 0.449709E-03_JPRB, 0.373902E-03_JPRB, 0.310874E-03_JPRB, 0.258471E-03_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.333950E-02_JPRB, 0.256391E-02_JPRB, 0.196845E-02_JPRB, 0.151129E-02_JPRB, 0.116030E-02_JPRB, &
 & 0.890824E-03_JPRB, 0.683934E-03_JPRB, 0.525093E-03_JPRB, 0.403143E-03_JPRB, 0.309515E-03_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.793392E-02_JPRB, 0.589865E-02_JPRB, 0.438548E-02_JPRB, 0.326048E-02_JPRB, 0.242408E-02_JPRB, &
 & 0.180223E-02_JPRB, 0.133991E-02_JPRB, 0.996186E-03_JPRB, 0.740636E-03_JPRB, 0.550642E-03_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.828169E-02_JPRB, 0.703139E-02_JPRB, 0.596984E-02_JPRB, 0.506856E-02_JPRB, 0.430335E-02_JPRB, &
 & 0.365366E-02_JPRB, 0.310206E-02_JPRB, 0.263374E-02_JPRB, 0.223612E-02_JPRB, 0.189852E-02_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.834190E-02_JPRB, 0.780225E-02_JPRB, 0.729750E-02_JPRB, 0.682541E-02_JPRB, 0.638386E-02_JPRB, &
 & 0.597087E-02_JPRB, 0.558460E-02_JPRB, 0.522332E-02_JPRB, 0.488541E-02_JPRB, 0.456936E-02_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.119082E-01_JPRB, 0.112566E-01_JPRB, 0.106406E-01_JPRB, 0.100583E-01_JPRB, 0.950785E-02_JPRB, &
 & 0.898755E-02_JPRB, 0.849571E-02_JPRB, 0.803080E-02_JPRB, 0.759132E-02_JPRB, 0.717590E-02_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.144004E-01_JPRB, 0.141762E-01_JPRB, 0.139554E-01_JPRB, 0.137381E-01_JPRB, 0.135241E-01_JPRB, &
 & 0.133135E-01_JPRB, 0.131062E-01_JPRB, 0.129021E-01_JPRB, 0.127011E-01_JPRB, 0.125033E-01_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.186171E-01_JPRB, 0.175281E-01_JPRB, 0.165027E-01_JPRB, 0.155373E-01_JPRB, 0.146284E-01_JPRB, &
 & 0.137726E-01_JPRB, 0.129670E-01_JPRB, 0.122084E-01_JPRB, 0.114942E-01_JPRB, 0.108218E-01_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.209396E-01_JPRB, 0.195077E-01_JPRB, 0.181737E-01_JPRB, 0.169309E-01_JPRB, 0.157731E-01_JPRB, &
 & 0.146945E-01_JPRB, 0.136897E-01_JPRB, 0.127535E-01_JPRB, 0.118814E-01_JPRB, 0.110689E-01_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.203661E-01_JPRB, 0.193311E-01_JPRB, 0.183487E-01_JPRB, 0.174163E-01_JPRB, 0.165312E-01_JPRB, &
 & 0.156911E-01_JPRB, 0.148937E-01_JPRB, 0.141368E-01_JPRB, 0.134184E-01_JPRB, 0.127365E-01_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.226784E-01_JPRB, 0.210210E-01_JPRB, 0.194848E-01_JPRB, 0.180608E-01_JPRB, 0.167409E-01_JPRB, &
 & 0.155174E-01_JPRB, 0.143834E-01_JPRB, 0.133322E-01_JPRB, 0.123579E-01_JPRB, 0.114547E-01_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.221773E-01_JPRB, 0.210306E-01_JPRB, 0.199433E-01_JPRB, 0.189122E-01_JPRB, 0.179344E-01_JPRB, &
 & 0.170071E-01_JPRB, 0.161278E-01_JPRB, 0.152939E-01_JPRB, 0.145032E-01_JPRB, 0.137533E-01_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.275920E-01_JPRB, 0.252595E-01_JPRB, 0.231241E-01_JPRB, 0.211693E-01_JPRB, 0.193797E-01_JPRB, &
 & 0.177415E-01_JPRB, 0.162417E-01_JPRB, 0.148687E-01_JPRB, 0.136117E-01_JPRB, 0.124610E-01_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.288687E-01_JPRB, 0.269968E-01_JPRB, 0.252462E-01_JPRB, 0.236092E-01_JPRB, 0.220783E-01_JPRB, &
 & 0.206466E-01_JPRB, 0.193078E-01_JPRB, 0.180559E-01_JPRB, 0.168851E-01_JPRB, 0.157902E-01_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.371842E-01_JPRB, 0.347595E-01_JPRB, 0.324929E-01_JPRB, 0.303741E-01_JPRB, 0.283934E-01_JPRB, &
 & 0.265419E-01_JPRB, 0.248112E-01_JPRB, 0.231933E-01_JPRB, 0.216809E-01_JPRB, 0.202671E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB18:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


END SUBROUTINE SRTM_KGB18

