MODULE YOMTOPH

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!*
!     ------------------------------------------------------------------
!     Top limits of parametrization call
!     we have one by parameterization,
!              ETXXXX : Top pressure
!              NTXXXX : Corresponding level in standard atmosphere

!       ETQSAT,ETDIFU,ETCOEF,ETDRAG,ETCVIM,ETPLUI,ETRADI,ETNEBU
!       ETOZON,ETDRME,ETCOEFE,ETCOET,ETAJUC,NTAJUC
!       NTQSAT,NTDIFU,NTCOEF,NTDRAG,NTCVIM,NTPLUI,NTRADI,NTNEBU
!       NTOZON,NTDRME,NTCOEFE,NTCOET

!     Constants for Mesospheric drag parameterization

!       XDRMUK  : Mesospheric drag coefficient for U and V
!       XDRMUX  : Maximum mesospheric drag coefficient for U and V
!       XDRMUP  : Bottom pressure for U and V
!       XDRMTK  : Mesospheric drag coefficient for T
!       XDRMTX  : Maximum mesospheric drag coefficient for T
!       XDRMTP  : Bottom pressure for T
!       XDRMQK  : Mesospheric drag coefficient for Q
!       XDRMQP  : Bottom pressure for Q

!       RMESOU(NFLEVG) : Vertical mesospheric drag profil for U and V
!       RMESOT(NFLEVG) : Vertical mesospheric drag profil for T
!       RMESOQ(NFLEV)  : Vertical mesospheric drag profil for Q

!       RFMESOQ   : Mesospheric water reference

!       RCLX      : Multiplicator for Cl term in ozone photochemistry

!       TPSCLIM   : Temperature threshold for activation of heterogeneous
!                   chemistry (polar stratospheric clouds temperature formation)

REAL(KIND=JPRB),ALLOCATABLE:: RMESOU(:)
REAL(KIND=JPRB),ALLOCATABLE:: RMESOT(:)
REAL(KIND=JPRB),ALLOCATABLE:: RMESOQ(:)

REAL(KIND=JPRB) :: RFMESOQ

INTEGER(KIND=JPIM) :: NTQSAT
INTEGER(KIND=JPIM) :: NTDIFU
INTEGER(KIND=JPIM) :: NTCOEF
INTEGER(KIND=JPIM) :: NTDRAG
INTEGER(KIND=JPIM) :: NTCVIM
INTEGER(KIND=JPIM) :: NTPLUI
INTEGER(KIND=JPIM) :: NTRADI
INTEGER(KIND=JPIM) :: NTNEBU
INTEGER(KIND=JPIM) :: NTOZON
INTEGER(KIND=JPIM) :: NTDRME
INTEGER(KIND=JPIM) :: NTCOEFE
INTEGER(KIND=JPIM) :: NTCOET
INTEGER(KIND=JPIM) :: NTAJUC
REAL(KIND=JPRB) :: ETQSAT
REAL(KIND=JPRB) :: ETDIFU
REAL(KIND=JPRB) :: ETCOEF
REAL(KIND=JPRB) :: ETDRAG
REAL(KIND=JPRB) :: ETCVIM
REAL(KIND=JPRB) :: ETPLUI
REAL(KIND=JPRB) :: ETRADI
REAL(KIND=JPRB) :: ETNEBU
REAL(KIND=JPRB) :: ETOZON
REAL(KIND=JPRB) :: ETDRME
REAL(KIND=JPRB) :: ETCOEFE
REAL(KIND=JPRB) :: ETCOET
REAL(KIND=JPRB) :: ETAJUC
REAL(KIND=JPRB) :: XDRMUK
REAL(KIND=JPRB) :: XDRMUX
REAL(KIND=JPRB) :: XDRMUP
REAL(KIND=JPRB) :: XDRMTK
REAL(KIND=JPRB) :: XDRMTX
REAL(KIND=JPRB) :: XDRMTP
REAL(KIND=JPRB) :: XDRMQK
REAL(KIND=JPRB) :: XDRMQP

REAL(KIND=JPRB) :: RCLX

REAL(KIND=JPRB) :: TPSCLIM

!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(etajuc,etcoef,etcoefe,etcoet,etcvim,etdifu,etdrag,etdrme,etnebu,etozon,etplui)
!$OMP THREADPRIVATE(etqsat,etradi,ntajuc,ntcoef,ntcoefe,ntcoet,ntcvim,ntdifu,ntdrag,ntdrme,ntnebu)
!$OMP THREADPRIVATE(ntozon,ntplui,ntqsat,ntradi,rclx,rfmesoq,tpsclim,xdrmqk,xdrmqp,xdrmtk,xdrmtp)
!$OMP THREADPRIVATE(xdrmtx,xdrmuk,xdrmup,xdrmux)
!$OMP THREADPRIVATE(rmesoq,rmesot,rmesou)
END MODULE YOMTOPH
