#ifdef CPP_XIOS

MODULE lmdz_xios
  USE xios
  
  LOGICAL,PARAMETER :: using_xios = .TRUE.

END MODULE lmdz_xios

#else

MODULE lmdz_xios
  !!!! Wrapper XIOS
  !! => must be replaced latter by official xios wrapper when available

  LOGICAL,PARAMETER :: using_xios = .FALSE.

INTERFACE xios_send_field
  MODULE PROCEDURE xios_send_field_scalar, xios_send_field_1d, xios_send_field_2d, xios_send_field_3d, &
                   xios_send_field_4d, xios_send_field_5d
END INTERFACE  xios_send_field

INTERFACE xios_recv_field
  MODULE PROCEDURE xios_recv_field_scalar, xios_recv_field_1d, xios_recv_field_2d, xios_recv_field_3d, &
                   xios_recv_field_4d
END INTERFACE  xios_recv_field

INTERFACE xios_field_is_active
  MODULE PROCEDURE xios_field_is_active_id,xios_field_is_active_hdl
END INTERFACE xios_field_is_active

INTERFACE xios_set_attr
  MODULE PROCEDURE xios_set_fieldgroup_attr_hdl, xios_set_field_attr_hdl, xios_set_domain_attr_hdl, &
                   xios_set_axis_attr_hdl, xios_set_file_attr_hdl
END INTERFACE  xios_set_attr

INTERFACE xios_get_handle
  MODULE PROCEDURE  xios_get_context_handle, xios_get_field_handle, xios_get_fieldgroup_handle, &
                    xios_get_domain_handle,xios_get_file_handle, xios_get_filegroup_handle 
END INTERFACE  xios_get_handle

INTERFACE xios_add_child
  MODULE PROCEDURE xios_fieldgroup_add_child, xios_add_fieldtofile, xios_add_file
END INTERFACE  xios_add_child

INTERFACE xios_set_current_context
      MODULE PROCEDURE xios_set_current_context_hdl, xios_set_current_context_id
END INTERFACE xios_set_current_context

INTERFACE xios_get_current_context
      MODULE PROCEDURE xios_get_current_context_hdl, xios_get_current_context_id
END INTERFACE xios_get_current_context

INTERFACE xios_set_start_date
  MODULE PROCEDURE xios_set_start_date_date, xios_set_start_date_dur
END INTERFACE xios_set_start_date

INTERFACE xios_set_time_origin
  MODULE PROCEDURE xios_set_time_origin_date, xios_set_time_origin_dur
END INTERFACE xios_set_time_origin

INTERFACE xios_is_defined_attr
  MODULE PROCEDURE xios_is_defined_domain_attr_hdl
END INTERFACE xios_is_defined_attr

TYPE xios_duration
  DOUBLE PRECISION :: year=0, month=0, day=0, hour=0, minute=0, second=0, timestep=0
END TYPE xios_duration

TYPE xios_date
  INTEGER :: year=0, month=0, day=0, hour=0, minute=0, second=0
END TYPE xios_date

   
REAL,PARAMETER :: xios_timestep=1.
REAL,PARAMETER :: xios_second=1.

TYPE xios_fieldgroup
END TYPE xios_fieldgroup

TYPE xios_filegroup
END TYPE xios_filegroup

TYPE xios_context
END TYPE xios_context

TYPE xios_domain
END TYPE xios_domain

TYPE xios_axis
END TYPE xios_axis

TYPE xios_file
END TYPE xios_file

TYPE xios_field
END TYPE 


CONTAINS  
  
  
  SUBROUTINE  xios_initialize(client_id, local_comm, return_comm)
   IMPLICIT NONE
   CHARACTER(LEN=*),INTENT(IN) :: client_id
   INTEGER,INTENT(IN),OPTIONAL         :: local_comm
   INTEGER,INTENT(OUT),OPTIONAL        :: return_comm
   INTEGER :: f_local_comm
   INTEGER :: f_return_comm

  END SUBROUTINE  xios_initialize 

SUBROUTINE xios_define_calendar(type, timestep, start_date, time_origin, &
                                    day_length, month_lengths, year_length, &
                                    leap_year_month, leap_year_drift, leap_year_drift_offset)
      IMPLICIT NONE
      CHARACTER(len = *),              INTENT(IN) :: type
      TYPE(xios_duration), OPTIONAL, INTENT(IN) :: timestep
      TYPE(xios_date),     OPTIONAL, INTENT(IN) :: start_date
      TYPE(xios_date),     OPTIONAL, INTENT(IN) :: time_origin
      INTEGER,               OPTIONAL, INTENT(IN) :: day_length
      INTEGER,               OPTIONAL, INTENT(IN) :: month_lengths(:)
      INTEGER,               OPTIONAL, INTENT(IN) :: year_length
      REAL (KIND=8),         OPTIONAL, INTENT(IN) :: leap_year_drift
      REAL (KIND=8),         OPTIONAL, INTENT(IN) :: leap_year_drift_offset
      INTEGER,               OPTIONAL, INTENT(IN) :: leap_year_month

   END SUBROUTINE xios_define_calendar
   
  SUBROUTINE xios_duration_convert_to_string(dur, str)
    IMPLICIT NONE
    TYPE(xios_duration), INTENT(IN) :: dur
    CHARACTER(len = *), INTENT(OUT) :: str
    str=''
  END SUBROUTINE xios_duration_convert_to_string

  FUNCTION xios_duration_convert_from_string(str) RESULT(res)
    IMPLICIT NONE
    CHARACTER(len = *), INTENT(IN) :: str
    TYPE(xios_duration) :: res

  END FUNCTION xios_duration_convert_from_string

   SUBROUTINE xios_set_timestep(timestep)
      IMPLICIT NONE
      TYPE(xios_duration), INTENT(IN) :: timestep
   END SUBROUTINE xios_set_timestep
   
  SUBROUTINE xios_set_start_date_date(start_date)
      IMPLICIT NONE
      TYPE(xios_date), INTENT(IN) :: start_date
   END SUBROUTINE xios_set_start_date_date

   SUBROUTINE xios_set_start_date_dur(start_date)
      IMPLICIT NONE
      TYPE(xios_duration), INTENT(IN) :: start_date
   END SUBROUTINE xios_set_start_date_dur
   
   SUBROUTINE xios_set_time_origin_date(time_origin)
      IMPLICIT NONE
      TYPE(xios_date), INTENT(IN) :: time_origin
   END SUBROUTINE xios_set_time_origin_date

   SUBROUTINE xios_set_time_origin_dur(time_origin)
      IMPLICIT NONE
      TYPE(xios_duration), INTENT(IN) :: time_origin
   END SUBROUTINE xios_set_time_origin_dur
            
  SUBROUTINE xios_send_field_scalar(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field
  END SUBROUTINE xios_send_field_scalar  

  SUBROUTINE xios_send_field_1d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field(:)
  END SUBROUTINE xios_send_field_1d  

  SUBROUTINE xios_send_field_2d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field(:,:)
  END SUBROUTINE xios_send_field_2d  

  SUBROUTINE xios_send_field_3d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field(:,:,:)
  END SUBROUTINE xios_send_field_3d  

  SUBROUTINE xios_send_field_4d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field(:,:,:,:)
  END SUBROUTINE xios_send_field_4d  

  SUBROUTINE xios_send_field_5d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(IN) :: field(:,:,:,:,:)
  END SUBROUTINE xios_send_field_5d  


  SUBROUTINE xios_recv_field_scalar(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(OUT) :: field
    field=0
  END SUBROUTINE xios_recv_field_scalar  

  SUBROUTINE xios_recv_field_1d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(OUT) :: field(:)
    field=0
  END SUBROUTINE xios_recv_field_1d  

  SUBROUTINE xios_recv_field_2d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(OUT) :: field(:,:)
    field=0
  END SUBROUTINE xios_recv_field_2d  

  SUBROUTINE xios_recv_field_3d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(OUT) :: field(:,:,:)
    field=0
  END SUBROUTINE xios_recv_field_3d  

  SUBROUTINE xios_recv_field_4d(name,field)
  IMPLICIT NONE
    CHARACTER(LEN=*),INTENT(IN) :: name
    REAL,INTENT(OUT) :: field(:,:,:,:)
    field=0
  END SUBROUTINE xios_recv_field_4d  


  FUNCTION xios_is_active_field(field_id)
  IMPLICIT NONE
   LOGICAL ::  xios_is_active_field
   CHARACTER(LEN=*) :: field_id
    xios_is_active_field = .TRUE.
  END FUNCTION xios_is_active_field

  LOGICAL FUNCTION xios_is_valid_field(idt)
    IMPLICIT NONE
    CHARACTER(len  = *)    , INTENT(IN) :: idt
    xios_is_valid_field = .FALSE.
  END FUNCTION  xios_is_valid_field

  LOGICAL FUNCTION xios_is_valid_file(idt)
    IMPLICIT NONE
    CHARACTER(len  = *)    , INTENT(IN) :: idt
    xios_is_valid_file = .FALSE.
  END FUNCTION  xios_is_valid_file

  LOGICAL FUNCTION xios_is_valid_axis(idt)
    IMPLICIT NONE
    CHARACTER(len  = *)    , INTENT(IN) :: idt
    xios_is_valid_axis = .FALSE.
  END FUNCTION  xios_is_valid_axis

  LOGICAL FUNCTION xios_is_valid_domain(idt)
    IMPLICIT NONE
    CHARACTER(len  = *)    , INTENT(IN) :: idt
    xios_is_valid_domain = .FALSE.
  END FUNCTION  xios_is_valid_domain


   SUBROUTINE  xios_context_initialize(context_id,comm)
   IMPLICIT NONE
   CHARACTER(LEN=*),INTENT(IN)  :: context_id
   INTEGER, INTENT(IN)          :: comm

   END SUBROUTINE  xios_context_initialize


   SUBROUTINE  xios_finalize
   IMPLICIT NONE

   END SUBROUTINE  xios_finalize


   SUBROUTINE  xios_oasis_enddef
   IMPLICIT NONE

   END SUBROUTINE  xios_oasis_enddef


   SUBROUTINE xios_close_context_definition
   IMPLICIT NONE

   END SUBROUTINE xios_close_context_definition


   SUBROUTINE xios_set_current_context_hdl(context, withswap)
      IMPLICIT NONE
      TYPE(xios_context)          , INTENT(IN) :: context
      LOGICAL                     , OPTIONAL, INTENT(IN) :: withswap
   END SUBROUTINE xios_set_current_context_hdl
   
   SUBROUTINE xios_set_current_context_id(idt)
      IMPLICIT NONE

      CHARACTER(len = *) , INTENT(IN) :: idt
      LOGICAL           :: withswap
    END SUBROUTINE xios_set_current_context_id
    

   SUBROUTINE xios_get_current_context_hdl(context)
      IMPLICIT NONE
      TYPE(xios_context), INTENT(OUT) :: context
   END SUBROUTINE xios_get_current_context_hdl

   SUBROUTINE xios_get_current_context_id(idt)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(OUT) :: idt
      TYPE(xios_context) :: context
   END SUBROUTINE xios_get_current_context_id

   SUBROUTINE xios_context_finalize()
   IMPLICIT NONE

   END SUBROUTINE xios_context_finalize


   SUBROUTINE xios_solve_inheritance()
   IMPLICIT NONE

   END SUBROUTINE xios_solve_inheritance




  
  SUBROUTINE xios_update_calendar(step)
  IMPLICIT NONE
   INTEGER, INTENT(IN):: step  
  END SUBROUTINE xios_update_calendar

  SUBROUTINE xios_set_filegroup_attr(name,enabled)
    CHARACTER(LEN=*) :: name
    LOGICAL,OPTIONAL          :: enabled
  END SUBROUTINE xios_set_filegroup_attr

  SUBROUTINE xios_get_axis_attr(name,n_glo,value)
    CHARACTER(LEN=*) :: name
    INTEGER,OPTIONAL          :: n_glo
    REAL,OPTIONAL             :: value(:)
  END SUBROUTINE xios_get_axis_attr

   SUBROUTINE xios_get_context_handle(idt,ret)
    IMPLICIT NONE
    CHARACTER(len = *)  , INTENT(IN)  :: idt
    TYPE(xios_context), INTENT(OUT):: ret
    TYPE(xios_context)             :: nothing 
      
      ret=nothing
   END SUBROUTINE xios_get_context_handle

   SUBROUTINE xios_get_domain_handle(idt,ret)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(IN) :: idt      
      TYPE(xios_domain), INTENT(OUT):: ret
      TYPE(xios_domain)             :: hdl
      ret=hdl
   END SUBROUTINE xios_get_domain_handle   

   SUBROUTINE xios_get_field_handle(idt,ret)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(IN) :: idt      
      TYPE(xios_field), INTENT(OUT):: ret
      TYPE(xios_field)             :: hdl
      ret=hdl
   END SUBROUTINE xios_get_field_handle   

   SUBROUTINE xios_get_fieldgroup_handle(idt,ret)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(IN) :: idt      
      TYPE(xios_fieldgroup), INTENT(OUT):: ret
      TYPE(xios_fieldgroup)             :: hdl
      ret=hdl
   END SUBROUTINE xios_get_fieldgroup_handle   

   SUBROUTINE xios_get_file_handle(idt,ret)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(IN) :: idt      
      TYPE(xios_file), INTENT(OUT):: ret
      TYPE(xios_file)             :: hdl
      ret=hdl
   END SUBROUTINE xios_get_file_handle   

   SUBROUTINE xios_get_filegroup_handle(idt,ret)
      IMPLICIT NONE
      CHARACTER(len = *) , INTENT(IN) :: idt      
      TYPE(xios_filegroup), INTENT(OUT):: ret
      TYPE(xios_filegroup)             :: hdl
      ret=hdl
   END SUBROUTINE xios_get_filegroup_handle   



  SUBROUTINE xios_fieldgroup_add_child(fieldgroup_hdl, field_hdl, id)
    TYPE(xios_fieldgroup)     :: fieldgroup_hdl
    TYPE(xios_field)          :: field_hdl
    CHARACTER(LEN=*),OPTIONAL :: id
  END SUBROUTINE xios_fieldgroup_add_child

  SUBROUTINE xios_add_file(parent_hdl, child_hdl, child_id)
      TYPE(xios_filegroup)      , INTENT(IN) :: parent_hdl
      TYPE(xios_file)           , INTENT(OUT):: child_hdl
      CHARACTER(len = *), OPTIONAL, INTENT(IN)  :: child_id
      TYPE(xios_file) :: hdl
      child_hdl = hdl
  END SUBROUTINE xios_add_file

  SUBROUTINE xios_add_field(parent_hdl, child_hdl, child_id)
      TYPE(xios_fieldgroup)      , INTENT(IN) :: parent_hdl
      TYPE(xios_field)           , INTENT(OUT):: child_hdl
      CHARACTER(len = *), OPTIONAL, INTENT(IN)  :: child_id
      TYPE(xios_field) :: hdl
      child_hdl = hdl
  END SUBROUTINE xios_add_field
  
  SUBROUTINE xios_add_fieldtofile(parent_hdl, child_hdl, child_id)
    TYPE(xios_file)            , INTENT(IN) :: parent_hdl
    TYPE(xios_field)           , INTENT(OUT):: child_hdl
    CHARACTER(len = *), OPTIONAL , INTENT(IN) :: child_id
    TYPE(xios_field) :: hdl
    child_hdl = hdl

  END SUBROUTINE xios_add_fieldtofile
   
  LOGICAL FUNCTION xios_field_is_active_id(field_id, at_current_timestep_arg)
      IMPLICIT NONE
      CHARACTER(len  = *) , INTENT(IN) :: field_id
      LOGICAL, OPTIONAL   , INTENT(IN) :: at_current_timestep_arg

     xios_field_is_active_id=.FALSE.
   END FUNCTION xios_field_is_active_id

   LOGICAL FUNCTION xios_field_is_active_hdl(field_hdl, at_current_timestep_arg)
      IMPLICIT NONE
      TYPE(xios_field) , INTENT(IN) :: field_hdl
      LOGICAL, OPTIONAL  , INTENT(IN) :: at_current_timestep_arg

     xios_field_is_active_hdl = .FALSE.
   END FUNCTION xios_field_is_active_hdl
   

  SUBROUTINE  xios_set_generate_rectilinear_domain_attr(id, bounds_lon_start, bounds_lon_end,  bounds_lat_start,  bounds_lat_end)
    CHARACTER(LEN=*) :: id
    REAL, OPTIONAL :: bounds_lon_start
    REAL, OPTIONAL :: bounds_lon_end
    REAL, OPTIONAL :: bounds_lat_start
    REAL, OPTIONAL :: bounds_lat_end
  END SUBROUTINE  xios_set_generate_rectilinear_domain_attr    

  SUBROUTINE xios_set_domain_attr  &
    ( domain_id, area, bounds_lat_1d, bounds_lat_2d, bounds_lat_name, bounds_lon_1d, bounds_lon_2d  &
    , bounds_lon_name, comment, data_dim, data_i_index, data_ibegin, data_j_index, data_jbegin, data_ni  &
    , data_nj, dim_i_name, dim_j_name, domain_ref, i_index, ibegin, j_index, jbegin, lat_name, latvalue_1d  &
    , latvalue_2d, lon_name, long_name, lonvalue_1d, lonvalue_2d, mask_1d, mask_2d, name, ni, ni_glo  &
    , nj, nj_glo, nvertex, prec, radius, standard_name, type )

    IMPLICIT NONE
      TYPE(xios_domain)  :: domain_hdl
      CHARACTER(LEN=*), INTENT(IN) ::domain_id
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: area(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lat_1d(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lat_2d(:,:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_lat_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lon_1d(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lon_2d(:,:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_lon_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: data_dim
      INTEGER  , OPTIONAL, INTENT(IN) :: data_i_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_ibegin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_j_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_jbegin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_ni
      INTEGER  , OPTIONAL, INTENT(IN) :: data_nj
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_i_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_j_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      INTEGER  , OPTIONAL, INTENT(IN) :: i_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: ibegin
      INTEGER  , OPTIONAL, INTENT(IN) :: j_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: jbegin
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: lat_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: latvalue_1d(:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: latvalue_2d(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: lon_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: lonvalue_1d(:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: lonvalue_2d(:,:)
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask_1d(:)
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask_2d(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      INTEGER  , OPTIONAL, INTENT(IN) :: ni
      INTEGER  , OPTIONAL, INTENT(IN) :: ni_glo
      INTEGER  , OPTIONAL, INTENT(IN) :: nj
      INTEGER  , OPTIONAL, INTENT(IN) :: nj_glo
      INTEGER  , OPTIONAL, INTENT(IN) :: nvertex
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: radius
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: type

  END SUBROUTINE xios_set_domain_attr  

  SUBROUTINE xios_set_domain_attr_hdl  &
    ( domain_hdl, area, bounds_lat_1d, bounds_lat_2d, bounds_lat_name, bounds_lon_1d, bounds_lon_2d  &
    , bounds_lon_name, comment, data_dim, data_i_index, data_ibegin, data_j_index, data_jbegin, data_ni  &
    , data_nj, dim_i_name, dim_j_name, domain_ref, i_index, ibegin, j_index, jbegin, lat_name, latvalue_1d  &
    , latvalue_2d, lon_name, long_name, lonvalue_1d, lonvalue_2d, mask_1d, mask_2d, name, ni, ni_glo  &
    , nj, nj_glo, nvertex, prec, radius, standard_name, type )

    IMPLICIT NONE
      TYPE(xios_domain) , INTENT(IN) :: domain_hdl
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: area(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lat_1d(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lat_2d(:,:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_lat_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lon_1d(:,:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds_lon_2d(:,:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_lon_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: data_dim
      INTEGER  , OPTIONAL, INTENT(IN) :: data_i_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_ibegin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_j_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_jbegin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_ni
      INTEGER  , OPTIONAL, INTENT(IN) :: data_nj
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_i_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_j_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      INTEGER  , OPTIONAL, INTENT(IN) :: i_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: ibegin
      INTEGER  , OPTIONAL, INTENT(IN) :: j_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: jbegin
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: lat_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: latvalue_1d(:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: latvalue_2d(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: lon_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: lonvalue_1d(:)
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: lonvalue_2d(:,:)
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask_1d(:)
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask_2d(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      INTEGER  , OPTIONAL, INTENT(IN) :: ni
      INTEGER  , OPTIONAL, INTENT(IN) :: ni_glo
      INTEGER  , OPTIONAL, INTENT(IN) :: nj
      INTEGER  , OPTIONAL, INTENT(IN) :: nj_glo
      INTEGER  , OPTIONAL, INTENT(IN) :: nvertex
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: radius
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: type
  
  END SUBROUTINE xios_set_domain_attr_hdl



  SUBROUTINE xios_set_axis_attr  &
    ( axis_id, axis_ref, axis_type, begin, bounds, bounds_name, comment, data_begin, data_index  &
    , data_n, dim_name, formula, formula_bounds, formula_term, formula_term_bounds, index, label  &
    , long_name, mask, n, n_distributed_partition, n_glo, name, positive, prec, standard_name, unit  &
    , value )

    IMPLICIT NONE
      TYPE(xios_axis)  :: axis_hdl
      CHARACTER(LEN=*), INTENT(IN) ::axis_id
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_type
      INTEGER  , OPTIONAL, INTENT(IN) :: begin
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: data_begin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_n
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_bounds
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_term
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_term_bounds
      INTEGER  , OPTIONAL, INTENT(IN) :: index(:)
      CHARACTER(len=*) , OPTIONAL, INTENT(IN) :: label(:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: n
      INTEGER  , OPTIONAL, INTENT(IN) :: n_distributed_partition
      INTEGER  , OPTIONAL, INTENT(IN) :: n_glo
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: positive
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: value(:)

  END SUBROUTINE xios_set_axis_attr

  SUBROUTINE xios_set_axis_attr_hdl  &
    ( axis_hdl, axis_ref, axis_type, begin, bounds, bounds_name, comment, data_begin, data_index  &
    , data_n, dim_name, formula, formula_bounds, formula_term, formula_term_bounds, index, label  &
    , long_name, mask, n, n_distributed_partition, n_glo, name, positive, prec, standard_name, unit  &
    , value )

    IMPLICIT NONE
      TYPE(xios_axis) , INTENT(IN) :: axis_hdl
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_type
      INTEGER  , OPTIONAL, INTENT(IN) :: begin
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: bounds(:,:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: bounds_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: data_begin
      INTEGER  , OPTIONAL, INTENT(IN) :: data_index(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: data_n
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: dim_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_bounds
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_term
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: formula_term_bounds
      INTEGER  , OPTIONAL, INTENT(IN) :: index(:)
      CHARACTER(len=*) , OPTIONAL, INTENT(IN) :: label(:)
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: mask(:)
      INTEGER  , OPTIONAL, INTENT(IN) :: n
      INTEGER  , OPTIONAL, INTENT(IN) :: n_distributed_partition
      INTEGER  , OPTIONAL, INTENT(IN) :: n_glo
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: positive
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: value(:)

  END SUBROUTINE xios_set_axis_attr_hdl

  SUBROUTINE xios_set_field_attr  &
    ( field_id, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode, check_if_active  &
    , comment, compression_level, default_value, detect_missing_value, domain_ref, enabled, expr  &
    , field_ref, freq_offset, freq_op, grid_path, grid_ref, indexed_output, level, long_name, name  &
    , operation, prec, read_access, scalar_ref, scale_factor, standard_name, ts_enabled, ts_split_freq  &
    , unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_field)  :: field_hdl
      CHARACTER(LEN=*), INTENT(IN) ::field_id
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(IN) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: default_value
      LOGICAL  , OPTIONAL, INTENT(IN) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(IN) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: operation
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_min

  END SUBROUTINE xios_set_field_attr

  SUBROUTINE xios_set_field_attr_hdl  &
    ( field_hdl, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode, check_if_active  &
    , comment, compression_level, default_value, detect_missing_value, domain_ref, enabled, expr  &
    , field_ref, freq_offset, freq_op, grid_path, grid_ref, indexed_output, level, long_name, name  &
    , operation, prec, read_access, scalar_ref, scale_factor, standard_name, ts_enabled, ts_split_freq  &
    , unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_field) , INTENT(IN) :: field_hdl
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(IN) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: default_value
      LOGICAL  , OPTIONAL, INTENT(IN) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(IN) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: operation
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_min


  END SUBROUTINE xios_set_field_attr_hdl


  SUBROUTINE xios_set_fieldgroup_attr  &
    ( fieldgroup_id, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode  &
    , check_if_active, comment, compression_level, default_value, detect_missing_value, domain_ref  &
    , enabled, expr, field_ref, freq_offset, freq_op, grid_path, grid_ref, group_ref, indexed_output  &
    , level, long_name, name, operation, prec, read_access, scalar_ref, scale_factor, standard_name  &
    , ts_enabled, ts_split_freq, unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_fieldgroup)  :: fieldgroup_hdl
      CHARACTER(LEN=*), INTENT(IN) ::fieldgroup_id
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(IN) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: default_value
      LOGICAL  , OPTIONAL, INTENT(IN) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_ref
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: group_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(IN) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: operation
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_min

  END SUBROUTINE xios_set_fieldgroup_attr

  SUBROUTINE xios_set_fieldgroup_attr_hdl  &
    ( fieldgroup_hdl, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode  &
    , check_if_active, comment, compression_level, default_value, detect_missing_value, domain_ref  &
    , enabled, expr, field_ref, freq_offset, freq_op, grid_path, grid_ref, group_ref, indexed_output  &
    , level, long_name, name, operation, prec, read_access, scalar_ref, scale_factor, standard_name  &
    , ts_enabled, ts_split_freq, unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_fieldgroup) , INTENT(IN) :: fieldgroup_hdl
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(IN) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: default_value
      LOGICAL  , OPTIONAL, INTENT(IN) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: grid_ref
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: group_ref
      LOGICAL  , OPTIONAL, INTENT(IN) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(IN) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: operation
      INTEGER  , OPTIONAL, INTENT(IN) :: prec
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(IN) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(IN) :: valid_min

  END SUBROUTINE xios_set_fieldgroup_attr_hdl


  SUBROUTINE xios_set_file_attr  &
    ( file_id, append, comment, compression_level, convention, convention_str, cyclic, description  &
    , enabled, format, min_digits, mode, name, name_suffix, output_freq, output_level, par_access  &
    , read_metadata_par, record_offset, split_end_offset, split_freq, split_freq_format, split_last_date  &
    , split_start_offset, sync_freq, time_counter, time_counter_name, time_stamp_format, time_stamp_name  &
    , time_units, timeseries, ts_prefix, type, uuid_format, uuid_name )

    IMPLICIT NONE
      TYPE(xios_file)  :: file_hdl
      CHARACTER(LEN=*), INTENT(IN) ::file_id
      LOGICAL  , OPTIONAL, INTENT(IN) :: append
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: convention
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: convention_str
      LOGICAL  , OPTIONAL, INTENT(IN) :: cyclic
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: description
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: format
      INTEGER  , OPTIONAL, INTENT(IN) :: min_digits
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: mode
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name_suffix
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: output_freq
      INTEGER  , OPTIONAL, INTENT(IN) :: output_level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: par_access
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_metadata_par
      INTEGER  , OPTIONAL, INTENT(IN) :: record_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_end_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: split_freq_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: split_last_date
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_start_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: sync_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_counter
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_counter_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_stamp_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_stamp_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_units
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: timeseries
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: ts_prefix
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: type
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: uuid_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: uuid_name

  END SUBROUTINE xios_set_file_attr

  SUBROUTINE xios_set_file_attr_hdl  &
    ( file_hdl, append, comment, compression_level, convention, convention_str, cyclic, description  &
    , enabled, format, min_digits, mode, name, name_suffix, output_freq, output_level, par_access  &
    , read_metadata_par, record_offset, split_end_offset, split_freq, split_freq_format, split_last_date  &
    , split_start_offset, sync_freq, time_counter, time_counter_name, time_stamp_format, time_stamp_name  &
    , time_units, timeseries, ts_prefix, type, uuid_format, uuid_name )

    IMPLICIT NONE
      TYPE(xios_file) , INTENT(IN) :: file_hdl
      LOGICAL  , OPTIONAL, INTENT(IN) :: append
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: comment
      INTEGER  , OPTIONAL, INTENT(IN) :: compression_level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: convention
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: convention_str
      LOGICAL  , OPTIONAL, INTENT(IN) :: cyclic
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: description
      LOGICAL  , OPTIONAL, INTENT(IN) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: format
      INTEGER  , OPTIONAL, INTENT(IN) :: min_digits
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: mode
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: name_suffix
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: output_freq
      INTEGER  , OPTIONAL, INTENT(IN) :: output_level
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: par_access
      LOGICAL  , OPTIONAL, INTENT(IN) :: read_metadata_par
      INTEGER  , OPTIONAL, INTENT(IN) :: record_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_end_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: split_freq_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: split_last_date
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: split_start_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(IN) :: sync_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_counter
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_counter_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_stamp_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_stamp_name
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: time_units
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: timeseries
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: ts_prefix
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: type
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: uuid_format
      CHARACTER(len = *) , OPTIONAL, INTENT(IN) :: uuid_name

  END SUBROUTINE xios_set_file_attr_hdl


  SUBROUTINE xios_is_defined_domain_attr  &
    ( domain_id, area, bounds_lat_1d, bounds_lat_2d, bounds_lat_name, bounds_lon_1d, bounds_lon_2d  &
    , bounds_lon_name, comment, data_dim, data_i_index, data_ibegin, data_j_index, data_jbegin, data_ni  &
    , data_nj, dim_i_name, dim_j_name, domain_ref, i_index, ibegin, j_index, jbegin, lat_name, latvalue_1d  &
    , latvalue_2d, lon_name, long_name, lonvalue_1d, lonvalue_2d, mask_1d, mask_2d, name, ni, ni_glo  &
    , nj, nj_glo, nvertex, prec, radius, standard_name, type )

    IMPLICIT NONE
      CHARACTER(LEN=*), INTENT(IN) ::domain_id
      LOGICAL, OPTIONAL, INTENT(OUT) :: area
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: comment
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_dim
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_i_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_ibegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_j_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_jbegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_ni
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_nj
      LOGICAL, OPTIONAL, INTENT(OUT) :: dim_i_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: dim_j_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: domain_ref
      LOGICAL, OPTIONAL, INTENT(OUT) :: i_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: ibegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: j_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: jbegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: lat_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: latvalue_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: latvalue_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: lon_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: long_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: lonvalue_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: lonvalue_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: mask_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: mask_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: name
      LOGICAL, OPTIONAL, INTENT(OUT) :: ni
      LOGICAL, OPTIONAL, INTENT(OUT) :: ni_glo
      LOGICAL, OPTIONAL, INTENT(OUT) :: nj
      LOGICAL, OPTIONAL, INTENT(OUT) :: nj_glo
      LOGICAL, OPTIONAL, INTENT(OUT) :: nvertex
      LOGICAL, OPTIONAL, INTENT(OUT) :: prec
      LOGICAL, OPTIONAL, INTENT(OUT) :: radius
      LOGICAL, OPTIONAL, INTENT(OUT) :: standard_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: type

      area = .FALSE.
      bounds_lat_1d = .FALSE.
      bounds_lat_2d = .FALSE.
      bounds_lat_name = .FALSE.
      bounds_lon_1d = .FALSE.
      bounds_lon_2d = .FALSE.
      bounds_lon_name = .FALSE.
      comment = .FALSE.
      data_dim = .FALSE.
      data_i_index = .FALSE.
      data_ibegin = .FALSE.
      data_j_index = .FALSE.
      data_jbegin = .FALSE.
      data_ni = .FALSE.
      data_nj = .FALSE.
      dim_i_name = .FALSE.
      dim_j_name = .FALSE.
      domain_ref = .FALSE.
      i_index = .FALSE.
      ibegin = .FALSE.
      j_index = .FALSE.
      jbegin = .FALSE.
      lat_name = .FALSE.
      latvalue_1d = .FALSE.
      latvalue_2d = .FALSE.
      lon_name = .FALSE.
      long_name = .FALSE.
      lonvalue_1d = .FALSE.
      lonvalue_2d = .FALSE.
      mask_1d = .FALSE.
      mask_2d = .FALSE.
      name = .FALSE.
      ni = .FALSE.
      ni_glo = .FALSE.
      nj = .FALSE.
      nj_glo = .FALSE.
      nvertex = .FALSE.
      prec = .FALSE.
      radius = .FALSE.
      standard_name = .FALSE.
      type = .FALSE.

  END SUBROUTINE xios_is_defined_domain_attr

  SUBROUTINE xios_is_defined_domain_attr_hdl  &
    ( domain_hdl, area, bounds_lat_1d, bounds_lat_2d, bounds_lat_name, bounds_lon_1d, bounds_lon_2d  &
    , bounds_lon_name, comment, data_dim, data_i_index, data_ibegin, data_j_index, data_jbegin, data_ni  &
    , data_nj, dim_i_name, dim_j_name, domain_ref, i_index, ibegin, j_index, jbegin, lat_name, latvalue_1d  &
    , latvalue_2d, lon_name, long_name, lonvalue_1d, lonvalue_2d, mask_1d, mask_2d, name, ni, ni_glo  &
    , nj, nj_glo, nvertex, prec, radius, standard_name, type )

    IMPLICIT NONE 
      TYPE(xios_domain), INTENT(IN) :: domain_hdl
      LOGICAL, OPTIONAL, INTENT(OUT) :: area
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lat_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: bounds_lon_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: comment
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_dim
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_i_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_ibegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_j_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_jbegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_ni
      LOGICAL, OPTIONAL, INTENT(OUT) :: data_nj
      LOGICAL, OPTIONAL, INTENT(OUT) :: dim_i_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: dim_j_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: domain_ref
      LOGICAL, OPTIONAL, INTENT(OUT) :: i_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: ibegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: j_index
      LOGICAL, OPTIONAL, INTENT(OUT) :: jbegin
      LOGICAL, OPTIONAL, INTENT(OUT) :: lat_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: latvalue_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: latvalue_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: lon_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: long_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: lonvalue_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: lonvalue_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: mask_1d
      LOGICAL, OPTIONAL, INTENT(OUT) :: mask_2d
      LOGICAL, OPTIONAL, INTENT(OUT) :: name
      LOGICAL, OPTIONAL, INTENT(OUT) :: ni
      LOGICAL, OPTIONAL, INTENT(OUT) :: ni_glo
      LOGICAL, OPTIONAL, INTENT(OUT) :: nj
      LOGICAL, OPTIONAL, INTENT(OUT) :: nj_glo
      LOGICAL, OPTIONAL, INTENT(OUT) :: nvertex
      LOGICAL, OPTIONAL, INTENT(OUT) :: prec
      LOGICAL, OPTIONAL, INTENT(OUT) :: radius
      LOGICAL, OPTIONAL, INTENT(OUT) :: standard_name
      LOGICAL, OPTIONAL, INTENT(OUT) :: type

      area = .FALSE.
      bounds_lat_1d = .FALSE.
      bounds_lat_2d = .FALSE.
      bounds_lat_name = .FALSE.
      bounds_lon_1d = .FALSE.
      bounds_lon_2d = .FALSE.
      bounds_lon_name = .FALSE.
      comment = .FALSE.
      data_dim = .FALSE.
      data_i_index = .FALSE.
      data_ibegin = .FALSE.
      data_j_index = .FALSE.
      data_jbegin = .FALSE.
      data_ni = .FALSE.
      data_nj = .FALSE.
      dim_i_name = .FALSE.
      dim_j_name = .FALSE.
      domain_ref = .FALSE.
      i_index = .FALSE.
      ibegin = .FALSE.
      j_index = .FALSE.
      jbegin = .FALSE.
      lat_name = .FALSE.
      latvalue_1d = .FALSE.
      latvalue_2d = .FALSE.
      lon_name = .FALSE.
      long_name = .FALSE.
      lonvalue_1d = .FALSE.
      lonvalue_2d = .FALSE.
      mask_1d = .FALSE.
      mask_2d = .FALSE.
      name = .FALSE.
      ni = .FALSE.
      ni_glo = .FALSE.
      nj = .FALSE.
      nj_glo = .FALSE.
      nvertex = .FALSE.
      prec = .FALSE.
      radius = .FALSE.
      standard_name = .FALSE.
      type = .FALSE.

  END SUBROUTINE xios_is_defined_domain_attr_hdl

  SUBROUTINE xios_get_field_attr  &
    ( field_id, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode, check_if_active  &
    , comment, compression_level, default_value, detect_missing_value, domain_ref, enabled, expr  &
    , field_ref, freq_offset, freq_op, grid_path, grid_ref, indexed_output, level, long_name, name  &
    , operation, prec, read_access, scalar_ref, scale_factor, standard_name, ts_enabled, ts_split_freq  &
    , unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_field)  :: field_hdl
      CHARACTER(LEN=*), INTENT(IN) ::field_id
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(OUT) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: comment
      INTEGER  , OPTIONAL, INTENT(OUT) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: default_value
      LOGICAL  , OPTIONAL, INTENT(OUT) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: grid_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(OUT) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: operation
      INTEGER  , OPTIONAL, INTENT(OUT) :: prec
      LOGICAL  , OPTIONAL, INTENT(OUT) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(OUT) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: valid_min

  END SUBROUTINE xios_get_field_attr

  SUBROUTINE xios_get_field_attr_hdl  &
    ( field_hdl, add_offset, axis_ref, build_workflow_graph, cell_methods, cell_methods_mode, check_if_active  &
    , comment, compression_level, default_value, detect_missing_value, domain_ref, enabled, expr  &
    , field_ref, freq_offset, freq_op, grid_path, grid_ref, indexed_output, level, long_name, name  &
    , operation, prec, read_access, scalar_ref, scale_factor, standard_name, ts_enabled, ts_split_freq  &
    , unit, valid_max, valid_min )

    IMPLICIT NONE
      TYPE(xios_field) , INTENT(IN) :: field_hdl
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: add_offset
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: axis_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: build_workflow_graph
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: cell_methods
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: cell_methods_mode
      LOGICAL  , OPTIONAL, INTENT(OUT) :: check_if_active
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: comment
      INTEGER  , OPTIONAL, INTENT(OUT) :: compression_level
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: default_value
      LOGICAL  , OPTIONAL, INTENT(OUT) :: detect_missing_value
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: domain_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: enabled
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: expr
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: field_ref
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: freq_offset
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: freq_op
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: grid_path
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: grid_ref
      LOGICAL  , OPTIONAL, INTENT(OUT) :: indexed_output
      INTEGER  , OPTIONAL, INTENT(OUT) :: level
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: long_name
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: name
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: operation
      INTEGER  , OPTIONAL, INTENT(OUT) :: prec
      LOGICAL  , OPTIONAL, INTENT(OUT) :: read_access
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: scalar_ref
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: scale_factor
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: standard_name
      LOGICAL  , OPTIONAL, INTENT(OUT) :: ts_enabled
      TYPE(xios_duration)  , OPTIONAL, INTENT(OUT) :: ts_split_freq
      CHARACTER(len = *) , OPTIONAL, INTENT(OUT) :: unit
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: valid_max
      REAL (KIND=8) , OPTIONAL, INTENT(OUT) :: valid_min

  END SUBROUTINE xios_get_field_attr_hdl
      
END MODULE lmdz_xios

#endif 
