!***************************************************************************
SUBROUTINE RRTM_CMBGB8
!***************************************************************************

!     BAND 8:  1080-1180 cm-1 (low (i.e.>~300mb) - H2O; high - O3)
!***************************************************************************

! Parameters
USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO8 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
 & FRACREFBO, ABSCO2AO,ABSCO2BO,ABSN2OAO   ,ABSN2OBO   ,&
 & CFC12O   , CFC22ADJO  
USE YOERRTA8 , ONLY : KA      ,KB      ,SELFREF    ,FRACREFA   ,&
 & FRACREFB , ABSCO2A ,ABSCO2B ,ABSN2OA    ,ABSN2OB    ,&
 & CFC12    , CFC22ADJ  
USE YOERRTRWT, ONLY : FREFA    ,FREFB    ,RWGT
USE YOERRTFTR, ONLY : NGC      ,NGS      ,NGN      

IMPLICIT NONE

INTEGER(KIND=JPIM) :: IGC, IPR, IPRSM, JP, JT

REAL(KIND=JPRB) :: Z_SUMF1, Z_SUMF2, Z_SUMK, Z_SUMK1, Z_SUMK2, Z_SUMK3, Z_SUMK4, Z_SUMK5, Z_SUMK6
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB8',0,ZHOOK_HANDLE)
DO JT = 1,5
  DO JP = 1,7
    IPRSM = 0
    DO IGC = 1,NGC(8)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(7)+IGC)
        IPRSM = IPRSM + 1
        Z_SUMK = Z_SUMK + KAO(JT,JP,IPRSM)*RWGT(IPRSM+112)
      ENDDO
      KA(JT,JP,IGC) = Z_SUMK
    ENDDO
  ENDDO
ENDDO
DO JT = 1,5
  DO JP = 7,59
    IPRSM = 0
    DO IGC = 1,NGC(8)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(7)+IGC)
        IPRSM = IPRSM + 1
        Z_SUMK = Z_SUMK + KBO(JT,JP,IPRSM)*RWGT(IPRSM+112)
      ENDDO
      KB(JT,JP,IGC) = Z_SUMK
    ENDDO
  ENDDO
ENDDO

DO JT = 1,10
  IPRSM = 0
  DO IGC = 1,NGC(8)
    Z_SUMK = 0.0_JPRB
    DO IPR = 1, NGN(NGS(7)+IGC)
      IPRSM = IPRSM + 1
      Z_SUMK = Z_SUMK + SELFREFO(JT,IPRSM)*RWGT(IPRSM+112)
    ENDDO
    SELFREF(JT,IGC) = Z_SUMK
  ENDDO
ENDDO

IPRSM = 0
DO IGC = 1,NGC(8)
  Z_SUMF1= 0.0_JPRB
  Z_SUMF2= 0.0_JPRB
  Z_SUMK1= 0.0_JPRB
  Z_SUMK2= 0.0_JPRB
  Z_SUMK3= 0.0_JPRB
  Z_SUMK4= 0.0_JPRB
  Z_SUMK5= 0.0_JPRB
  Z_SUMK6= 0.0_JPRB
  DO IPR = 1, NGN(NGS(7)+IGC)
    IPRSM = IPRSM + 1
    Z_SUMF1= Z_SUMF1+ FRACREFAO(IPRSM)
    Z_SUMF2= Z_SUMF2+ FRACREFBO(IPRSM)
    Z_SUMK1= Z_SUMK1+ ABSCO2AO(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK2= Z_SUMK2+ ABSCO2BO(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK3= Z_SUMK3+ ABSN2OAO(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK4= Z_SUMK4+ ABSN2OBO(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK5= Z_SUMK5+ CFC12O(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK6= Z_SUMK6+ CFC22ADJO(IPRSM)*RWGT(IPRSM+112)
  ENDDO
  FRACREFA(IGC) = Z_SUMF1
  FRACREFB(IGC) = Z_SUMF2
  ABSCO2A(IGC) = Z_SUMK1
  ABSCO2B(IGC) = Z_SUMK2
  ABSN2OA(IGC) = Z_SUMK3
  ABSN2OB(IGC) = Z_SUMK4
  CFC12(IGC) = Z_SUMK5
  CFC22ADJ(IGC) = Z_SUMK6
ENDDO

DO IGC = 1,NGC(8)
  FREFA(NGS(7)+IGC,1) = FRACREFA(IGC)
  FREFB(NGS(7)+IGC,1) = FRACREFB(IGC)
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB8',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_CMBGB8
