!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL4 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,K_JP,K_JT,K_JT1,P_ONEMINUS,&
 & P_COLH2O,P_COLCO2,P_COLO3,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond 2000-05-15 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG4   ,NGS3
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA4 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,SELFREF,STRRAT1 , STRRAT2

!  Input
!#include "yoeratm.h"

!      REAL TAUAER(JPLAY)

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
REAL(KIND=JPRB)                  :: P_FORFAC(JPLAY) ! Argument NOT used
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_ONEMINUS 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCO2(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLO3(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PRECISE             
!- from PROFDATA             
!- from SELF             
!- from SP             
INTEGER(KIND=JPIM) :: IJS(JPLAY)
REAL(KIND=JPRB) :: ZFS(JPLAY),Z_SPECCOMB(JPLAY)
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY),INDS(JPLAY)

INTEGER(KIND=JPIM) :: IG, JS, I_LAY

REAL(KIND=JPRB) :: Z_FAC000, Z_FAC001, Z_FAC010, Z_FAC011, Z_FAC100, Z_FAC101,&
 & Z_FAC110, Z_FAC111, Z_FS, Z_SPECMULT, Z_SPECPARM  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,4),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure), 
!     temperature, and appropriate species.  Below LAYTROP, the water
!     vapor self-continuum is interpolated (in temperature) separately. 
 
IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL4',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  Z_SPECCOMB(I_LAY) = P_COLH2O(I_LAY) + STRRAT1*P_COLCO2(I_LAY)
  Z_SPECPARM = P_COLH2O(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 8._JPRB*(Z_SPECPARM)
  JS = 1 + INT(Z_SPECMULT)
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(4) + JS
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(4) + JS
  INDS(I_LAY) = K_INDSELF(I_LAY)

  ZFS(I_LAY)=Z_FS
  IJS(I_LAY)=JS

ENDDO

!-- DS_000515
DO IG = 1, NG4
  DO I_LAY = 1, K_LAYTROP
!-- DS_000515

    Z_FS=ZFS(I_LAY)
    JS=IJS(I_LAY)
!--jjm         
!    FAC000 = (_ONE_ - FS) * FAC00(LAY)
!    FAC010 = (_ONE_ - FS) * FAC10(LAY)
!    FAC100 = FS * FAC00(LAY)
!    FAC110 = FS * FAC10(LAY)
!    FAC001 = (_ONE_ - FS) * FAC01(LAY)
!    FAC011 = (_ONE_ - FS) * FAC11(LAY)
!    FAC101 = FS * FAC01(LAY)
!    FAC111 = FS * FAC11(LAY)
!---

    P_TAU (NGS3+IG,I_LAY) = Z_SPECCOMB(I_LAY) *    &
     !-- DS_000515
     & ((1. - Z_FS) *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)   ,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+ 9,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)   ,IG) +    &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+ 9,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)+ 1,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+10,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)+ 1,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+10,IG))) + &
     !     &(Z_FAC000 * ABSA(IND0(I_LAY)   ,IG) +&
     !     & Z_FAC100 * ABSA(IND0(I_LAY)+ 1,IG) +&
     !     & Z_FAC010 * ABSA(IND0(I_LAY)+ 9,IG) +&
     !     & Z_FAC110 * ABSA(IND0(I_LAY)+10,IG) +&
     !     & Z_FAC001 * ABSA(IND1(I_LAY)   ,IG) +&
     !     & Z_FAC101 * ABSA(IND1(I_LAY)+ 1,IG) +&
     !     & Z_FAC011 * ABSA(IND1(I_LAY)+ 9,IG) +&
     !     & Z_FAC111 * ABSA(IND1(I_LAY)+10,IG))+&
     !-- DS_000515
     & P_COLH2O(I_LAY) * &
     & P_SELFFAC(I_LAY) * (SELFREF(INDS(I_LAY),IG) + &
     & P_SELFFRAC(I_LAY) *&
     & (SELFREF(INDS(I_LAY)+1,IG) - SELFREF(INDS(I_LAY),IG)))&
     & + P_TAUAERL(I_LAY,4)  
    PFRAC(NGS3+IG,I_LAY) = FRACREFA(IG,JS) + Z_FS *&
     & (FRACREFA(IG,JS+1) - FRACREFA(IG,JS))  
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  Z_SPECCOMB(I_LAY) = P_COLO3(I_LAY) + STRRAT2*P_COLCO2(I_LAY)
  Z_SPECPARM = P_COLO3(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 4._JPRB*(Z_SPECPARM)
  JS = 1 + INT(Z_SPECMULT)
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  IF (JS  >  1) THEN
    JS = JS + 1
  ELSEIF (Z_FS  >=  0.0024_JPRB) THEN
    JS = 2
    Z_FS = (Z_FS - 0.0024_JPRB)/0.9976_JPRB
  ELSE
    JS = 1
    Z_FS = Z_FS/0.0024_JPRB
  ENDIF
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(4) + JS
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(4) + JS
  ZFS(I_LAY)=Z_FS
  IJS(I_LAY)=JS
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  Z_FS=ZFS(I_LAY)
  JS=IJS(I_LAY)
!--- jjm
!  FAC000 = (_ONE_ - FS) * FAC00(LAY)
!  FAC010 = (_ONE_ - FS) * FAC10(LAY)
!  FAC100 = FS * FAC00(LAY)
!  FAC110 = FS * FAC10(LAY)
!  FAC001 = (_ONE_ - FS) * FAC01(LAY)
!  FAC011 = (_ONE_ - FS) * FAC11(LAY)
!  FAC101 = FS * FAC01(LAY)
!  FAC111 = FS * FAC11(LAY)
!------                   
  DO IG = 1, NG4
    P_TAU (NGS3+IG,I_LAY) = Z_SPECCOMB(I_LAY) *   &
     !-- DS_000515
     & ( (1. - Z_FS) *(P_FAC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +   &
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+6,IG) +   &
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +    &
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+6,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +   &
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+7,IG) +   &
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)+1,IG) +   &
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+7,IG)))   &
     !     &(Z_FAC000 * ABSB(IND0(I_LAY)   ,IG) +&
     !     & Z_FAC100 * ABSB(IND0(I_LAY)+ 1,IG) +&
     !     & Z_FAC010 * ABSB(IND0(I_LAY)+ 6,IG) +&
     !     & Z_FAC110 * ABSB(IND0(I_LAY)+ 7,IG) +&
     !     & Z_FAC001 * ABSB(IND1(I_LAY)   ,IG) +&
     !     & Z_FAC101 * ABSB(IND1(I_LAY)+ 1,IG) +&
     !     & Z_FAC011 * ABSB(IND1(I_LAY)+ 6,IG) +&
     !     & Z_FAC111 * ABSB(IND1(I_LAY)+ 7,IG))&
     !-- DS_000515
     & + P_TAUAERL(I_LAY,4)  
    PFRAC(NGS3+IG,I_LAY) = FRACREFB(IG,JS) + Z_FS *&
     & (FRACREFB(IG,JS+1) - FRACREFB(IG,JS))  
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL4',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL4
