!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB13

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 13:  2080-2250 cm-1 (low - H2O,N2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO13, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA13, ONLY : STRRAT

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13',1,ZHOOK_HANDLE)

!     ------------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART1',0,ZHOOK_HANDLE)


STRRAT = 16658.87_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
 & 6.0224E-05_JPRB,8.4190E-05_JPRB,9.2945E-05_JPRB,9.8340E-05_JPRB,1.0097E-04_JPRB,1.0123E-04_JPRB,&
 & 9.8980E-05_JPRB,9.5101E-05_JPRB,1.0057E-04_JPRB/)  
KAO( :, 2, 1, 1) = (/&
 & 6.0879E-05_JPRB,8.9195E-05_JPRB,9.9910E-05_JPRB,1.0710E-04_JPRB,1.1122E-04_JPRB,1.1263E-04_JPRB,&
 & 1.1044E-04_JPRB,1.0763E-04_JPRB,1.0542E-04_JPRB/)  
KAO( :, 3, 1, 1) = (/&
 & 6.1791E-05_JPRB,9.5106E-05_JPRB,1.0827E-04_JPRB,1.1785E-04_JPRB,1.2380E-04_JPRB,1.2668E-04_JPRB,&
 & 1.2512E-04_JPRB,1.2107E-04_JPRB,1.1351E-04_JPRB/)  
KAO( :, 4, 1, 1) = (/&
 & 6.3010E-05_JPRB,1.0201E-04_JPRB,1.1821E-04_JPRB,1.3067E-04_JPRB,1.3868E-04_JPRB,1.4333E-04_JPRB,&
 & 1.4292E-04_JPRB,1.3776E-04_JPRB,1.2486E-04_JPRB/)  
KAO( :, 5, 1, 1) = (/&
 & 6.4569E-05_JPRB,1.0987E-04_JPRB,1.2980E-04_JPRB,1.4543E-04_JPRB,1.5604E-04_JPRB,1.6272E-04_JPRB,&
 & 1.6360E-04_JPRB,1.5809E-04_JPRB,1.3899E-04_JPRB/)  
KAO( :, 1, 2, 1) = (/&
 & 5.2287E-05_JPRB,7.1405E-05_JPRB,7.7712E-05_JPRB,8.1186E-05_JPRB,8.2505E-05_JPRB,8.2006E-05_JPRB,&
 & 7.9565E-05_JPRB,7.6455E-05_JPRB,9.9524E-05_JPRB/)  
KAO( :, 2, 2, 1) = (/&
 & 5.2781E-05_JPRB,7.5455E-05_JPRB,8.3243E-05_JPRB,8.8119E-05_JPRB,9.0567E-05_JPRB,9.0970E-05_JPRB,&
 & 8.8663E-05_JPRB,8.6015E-05_JPRB,1.0412E-04_JPRB/)  
KAO( :, 3, 2, 1) = (/&
 & 5.3548E-05_JPRB,8.0317E-05_JPRB,9.0003E-05_JPRB,9.6753E-05_JPRB,1.0065E-04_JPRB,1.0210E-04_JPRB,&
 & 1.0019E-04_JPRB,9.6846E-05_JPRB,1.1058E-04_JPRB/)  
KAO( :, 4, 2, 1) = (/&
 & 5.4581E-05_JPRB,8.6067E-05_JPRB,9.8148E-05_JPRB,1.0717E-04_JPRB,1.1272E-04_JPRB,1.1541E-04_JPRB,&
 & 1.1436E-04_JPRB,1.1002E-04_JPRB,1.1929E-04_JPRB/)  
KAO( :, 5, 2, 1) = (/&
 & 5.5952E-05_JPRB,9.2760E-05_JPRB,1.0776E-04_JPRB,1.1931E-04_JPRB,1.2684E-04_JPRB,1.3110E-04_JPRB,&
 & 1.3118E-04_JPRB,1.2615E-04_JPRB,1.3023E-04_JPRB/)  
KAO( :, 1, 3, 1) = (/&
 & 4.5915E-05_JPRB,6.0577E-05_JPRB,6.4826E-05_JPRB,6.6685E-05_JPRB,6.6750E-05_JPRB,6.5539E-05_JPRB,&
 & 6.2942E-05_JPRB,6.0959E-05_JPRB,1.1753E-04_JPRB/)  
KAO( :, 2, 3, 1) = (/&
 & 4.6227E-05_JPRB,6.3783E-05_JPRB,6.9133E-05_JPRB,7.1876E-05_JPRB,7.2797E-05_JPRB,7.2195E-05_JPRB,&
 & 6.9765E-05_JPRB,6.7154E-05_JPRB,1.2464E-04_JPRB/)  
KAO( :, 3, 3, 1) = (/&
 & 4.6851E-05_JPRB,6.7690E-05_JPRB,7.4367E-05_JPRB,7.8503E-05_JPRB,8.0513E-05_JPRB,8.0733E-05_JPRB,&
 & 7.8338E-05_JPRB,7.5667E-05_JPRB,1.3207E-04_JPRB/)  
KAO( :, 4, 3, 1) = (/&
 & 4.7751E-05_JPRB,7.2324E-05_JPRB,8.0776E-05_JPRB,8.6619E-05_JPRB,8.9966E-05_JPRB,9.1016E-05_JPRB,&
 & 8.9192E-05_JPRB,8.5836E-05_JPRB,1.3971E-04_JPRB/)  
KAO( :, 5, 3, 1) = (/&
 & 4.8912E-05_JPRB,7.7822E-05_JPRB,8.8433E-05_JPRB,9.6277E-05_JPRB,1.0117E-04_JPRB,1.0326E-04_JPRB,&
 & 1.0232E-04_JPRB,9.7968E-05_JPRB,1.4868E-04_JPRB/)  
KAO( :, 1, 4, 1) = (/&
 & 4.0950E-05_JPRB,5.2139E-05_JPRB,5.4765E-05_JPRB,5.5573E-05_JPRB,5.4704E-05_JPRB,5.2865E-05_JPRB,&
 & 5.0161E-05_JPRB,4.9155E-05_JPRB,1.5352E-04_JPRB/)  
KAO( :, 2, 4, 1) = (/&
 & 4.1070E-05_JPRB,5.4592E-05_JPRB,5.8140E-05_JPRB,5.9442E-05_JPRB,5.9104E-05_JPRB,5.7678E-05_JPRB,&
 & 5.5011E-05_JPRB,5.2621E-05_JPRB,1.6066E-04_JPRB/)  
KAO( :, 3, 4, 1) = (/&
 & 4.1547E-05_JPRB,5.7742E-05_JPRB,6.2323E-05_JPRB,6.4435E-05_JPRB,6.4943E-05_JPRB,6.4068E-05_JPRB,&
 & 6.1387E-05_JPRB,5.9195E-05_JPRB,1.6903E-04_JPRB/)  
KAO( :, 4, 4, 1) = (/&
 & 4.2287E-05_JPRB,6.1604E-05_JPRB,6.7380E-05_JPRB,7.0692E-05_JPRB,7.2200E-05_JPRB,7.1920E-05_JPRB,&
 & 6.9467E-05_JPRB,6.6532E-05_JPRB,1.7839E-04_JPRB/)  
KAO( :, 5, 4, 1) = (/&
 & 4.3274E-05_JPRB,6.6127E-05_JPRB,7.3452E-05_JPRB,7.8267E-05_JPRB,8.0937E-05_JPRB,8.1435E-05_JPRB,&
 & 7.9548E-05_JPRB,7.5644E-05_JPRB,1.8879E-04_JPRB/)  
KAO( :, 1, 5, 1) = (/&
 & 3.6899E-05_JPRB,4.5432E-05_JPRB,4.6910E-05_JPRB,4.6828E-05_JPRB,4.5505E-05_JPRB,4.3257E-05_JPRB,&
 & 4.0494E-05_JPRB,4.0683E-05_JPRB,2.1040E-04_JPRB/)  
KAO( :, 2, 5, 1) = (/&
 & 3.6791E-05_JPRB,4.7257E-05_JPRB,4.9430E-05_JPRB,4.9831E-05_JPRB,4.8726E-05_JPRB,4.6653E-05_JPRB,&
 & 4.3906E-05_JPRB,4.1943E-05_JPRB,2.1714E-04_JPRB/)  
KAO( :, 3, 5, 1) = (/&
 & 3.7067E-05_JPRB,4.9759E-05_JPRB,5.2813E-05_JPRB,5.3675E-05_JPRB,5.3108E-05_JPRB,5.1487E-05_JPRB,&
 & 4.8518E-05_JPRB,4.6186E-05_JPRB,2.2577E-04_JPRB/)  
KAO( :, 4, 5, 1) = (/&
 & 3.7713E-05_JPRB,5.2955E-05_JPRB,5.6991E-05_JPRB,5.8578E-05_JPRB,5.8728E-05_JPRB,5.7522E-05_JPRB,&
 & 5.4651E-05_JPRB,5.2154E-05_JPRB,2.3593E-04_JPRB/)  
KAO( :, 5, 5, 1) = (/&
 & 3.8601E-05_JPRB,5.6859E-05_JPRB,6.2047E-05_JPRB,6.4624E-05_JPRB,6.5592E-05_JPRB,6.4919E-05_JPRB,&
 & 6.2327E-05_JPRB,5.8914E-05_JPRB,2.4626E-04_JPRB/)  
KAO( :, 1, 6, 1) = (/&
 & 3.3082E-05_JPRB,3.9382E-05_JPRB,4.0055E-05_JPRB,3.9341E-05_JPRB,3.7713E-05_JPRB,3.5318E-05_JPRB,&
 & 3.2652E-05_JPRB,3.2896E-05_JPRB,2.9458E-04_JPRB/)  
KAO( :, 2, 6, 1) = (/&
 & 3.2847E-05_JPRB,4.0822E-05_JPRB,4.1992E-05_JPRB,4.1637E-05_JPRB,4.0248E-05_JPRB,3.7895E-05_JPRB,&
 & 3.4950E-05_JPRB,3.3596E-05_JPRB,2.9908E-04_JPRB/)  
KAO( :, 3, 6, 1) = (/&
 & 3.2992E-05_JPRB,4.2782E-05_JPRB,4.4664E-05_JPRB,4.4799E-05_JPRB,4.3587E-05_JPRB,4.1448E-05_JPRB,&
 & 3.8538E-05_JPRB,3.6195E-05_JPRB,3.0643E-04_JPRB/)  
KAO( :, 4, 6, 1) = (/&
 & 3.3529E-05_JPRB,4.5435E-05_JPRB,4.8125E-05_JPRB,4.8714E-05_JPRB,4.7939E-05_JPRB,4.6103E-05_JPRB,&
 & 4.3124E-05_JPRB,4.0777E-05_JPRB,3.1650E-04_JPRB/)  
KAO( :, 5, 6, 1) = (/&
 & 3.4353E-05_JPRB,4.8744E-05_JPRB,5.2397E-05_JPRB,5.3568E-05_JPRB,5.3408E-05_JPRB,5.1940E-05_JPRB,&
 & 4.9013E-05_JPRB,4.5970E-05_JPRB,3.2817E-04_JPRB/)  
KAO( :, 1, 7, 1) = (/&
 & 2.9702E-05_JPRB,3.4031E-05_JPRB,3.4045E-05_JPRB,3.2966E-05_JPRB,3.1191E-05_JPRB,2.8774E-05_JPRB,&
 & 2.6215E-05_JPRB,2.6660E-05_JPRB,4.4900E-04_JPRB/)  
KAO( :, 2, 7, 1) = (/&
 & 2.9362E-05_JPRB,3.5097E-05_JPRB,3.5527E-05_JPRB,3.4696E-05_JPRB,3.3156E-05_JPRB,3.0815E-05_JPRB,&
 & 2.7832E-05_JPRB,2.7318E-05_JPRB,4.4931E-04_JPRB/)  
KAO( :, 3, 7, 1) = (/&
 & 2.9381E-05_JPRB,3.6764E-05_JPRB,3.7674E-05_JPRB,3.7240E-05_JPRB,3.5897E-05_JPRB,3.3579E-05_JPRB,&
 & 3.0718E-05_JPRB,2.8716E-05_JPRB,4.5416E-04_JPRB/)  
KAO( :, 4, 7, 1) = (/&
 & 2.9804E-05_JPRB,3.8980E-05_JPRB,4.0580E-05_JPRB,4.0617E-05_JPRB,3.9435E-05_JPRB,3.7220E-05_JPRB,&
 & 3.4325E-05_JPRB,3.1670E-05_JPRB,4.6259E-04_JPRB/)  
KAO( :, 5, 7, 1) = (/&
 & 3.0562E-05_JPRB,4.1836E-05_JPRB,4.4230E-05_JPRB,4.4708E-05_JPRB,4.3841E-05_JPRB,4.1868E-05_JPRB,&
 & 3.8884E-05_JPRB,3.5908E-05_JPRB,4.7345E-04_JPRB/)  
KAO( :, 1, 8, 1) = (/&
 & 2.7321E-05_JPRB,3.0014E-05_JPRB,2.9442E-05_JPRB,2.8040E-05_JPRB,2.6171E-05_JPRB,2.3688E-05_JPRB,&
 & 2.1169E-05_JPRB,2.1771E-05_JPRB,8.4757E-04_JPRB/)  
KAO( :, 2, 8, 1) = (/&
 & 2.6852E-05_JPRB,3.0756E-05_JPRB,3.0519E-05_JPRB,2.9342E-05_JPRB,2.7606E-05_JPRB,2.5285E-05_JPRB,&
 & 2.2516E-05_JPRB,2.2054E-05_JPRB,8.3254E-04_JPRB/)  
KAO( :, 3, 8, 1) = (/&
 & 2.6744E-05_JPRB,3.2077E-05_JPRB,3.2249E-05_JPRB,3.1375E-05_JPRB,2.9814E-05_JPRB,2.7516E-05_JPRB,&
 & 2.4584E-05_JPRB,2.2691E-05_JPRB,8.2738E-04_JPRB/)  
KAO( :, 4, 8, 1) = (/&
 & 2.7044E-05_JPRB,3.3995E-05_JPRB,3.4700E-05_JPRB,3.4193E-05_JPRB,3.2808E-05_JPRB,3.0482E-05_JPRB,&
 & 2.7565E-05_JPRB,2.5008E-05_JPRB,8.3006E-04_JPRB/)  
KAO( :, 5, 8, 1) = (/&
 & 2.7742E-05_JPRB,3.6507E-05_JPRB,3.7912E-05_JPRB,3.7803E-05_JPRB,3.6547E-05_JPRB,3.4307E-05_JPRB,&
 & 3.1271E-05_JPRB,2.8258E-05_JPRB,8.3842E-04_JPRB/)  
KAO( :, 1, 9, 1) = (/&
 & 2.4687E-05_JPRB,2.6227E-05_JPRB,2.5301E-05_JPRB,2.3694E-05_JPRB,2.1797E-05_JPRB,1.9441E-05_JPRB,&
 & 1.7144E-05_JPRB,1.8070E-05_JPRB,3.0692E-03_JPRB/)  
KAO( :, 2, 9, 1) = (/&
 & 2.4149E-05_JPRB,2.6661E-05_JPRB,2.5983E-05_JPRB,2.4666E-05_JPRB,2.2860E-05_JPRB,2.0564E-05_JPRB,&
 & 1.8143E-05_JPRB,1.7595E-05_JPRB,2.9547E-03_JPRB/)  
KAO( :, 3, 9, 1) = (/&
 & 2.3961E-05_JPRB,2.7611E-05_JPRB,2.7357E-05_JPRB,2.6251E-05_JPRB,2.4586E-05_JPRB,2.2361E-05_JPRB,&
 & 1.9658E-05_JPRB,1.8317E-05_JPRB,2.8730E-03_JPRB/)  
KAO( :, 4, 9, 1) = (/&
 & 2.4159E-05_JPRB,2.9205E-05_JPRB,2.9375E-05_JPRB,2.8560E-05_JPRB,2.7008E-05_JPRB,2.4819E-05_JPRB,&
 & 2.2013E-05_JPRB,1.9707E-05_JPRB,2.8257E-03_JPRB/)  
KAO( :, 5, 9, 1) = (/&
 & 2.4768E-05_JPRB,3.1434E-05_JPRB,3.2114E-05_JPRB,3.1586E-05_JPRB,3.0168E-05_JPRB,2.7970E-05_JPRB,&
 & 2.5064E-05_JPRB,2.2198E-05_JPRB,2.8077E-03_JPRB/)  
KAO( :, 1,10, 1) = (/&
 & 2.1797E-05_JPRB,2.2612E-05_JPRB,2.1570E-05_JPRB,1.9956E-05_JPRB,1.8112E-05_JPRB,1.6002E-05_JPRB,&
 & 1.3941E-05_JPRB,1.4620E-05_JPRB,1.2580E-02_JPRB/)  
KAO( :, 2,10, 1) = (/&
 & 2.1252E-05_JPRB,2.2866E-05_JPRB,2.2054E-05_JPRB,2.0662E-05_JPRB,1.8925E-05_JPRB,1.6823E-05_JPRB,&
 & 1.4740E-05_JPRB,1.4291E-05_JPRB,1.1973E-02_JPRB/)  
KAO( :, 3,10, 1) = (/&
 & 2.1032E-05_JPRB,2.3616E-05_JPRB,2.3143E-05_JPRB,2.1982E-05_JPRB,2.0293E-05_JPRB,1.8202E-05_JPRB,&
 & 1.5821E-05_JPRB,1.4749E-05_JPRB,1.1500E-02_JPRB/)  
KAO( :, 4,10, 1) = (/&
 & 2.1171E-05_JPRB,2.4967E-05_JPRB,2.4887E-05_JPRB,2.3890E-05_JPRB,2.2324E-05_JPRB,2.0262E-05_JPRB,&
 & 1.7708E-05_JPRB,1.5622E-05_JPRB,1.1158E-02_JPRB/)  
KAO( :, 5,10, 1) = (/&
 & 2.1717E-05_JPRB,2.6968E-05_JPRB,2.7236E-05_JPRB,2.6488E-05_JPRB,2.5038E-05_JPRB,2.2971E-05_JPRB,&
 & 2.0251E-05_JPRB,1.7568E-05_JPRB,1.0927E-02_JPRB/)  
KAO( :, 1,11, 1) = (/&
 & 1.8470E-05_JPRB,1.9129E-05_JPRB,1.8217E-05_JPRB,1.6833E-05_JPRB,1.5198E-05_JPRB,1.3363E-05_JPRB,&
 & 1.1543E-05_JPRB,1.1814E-05_JPRB,1.7618E-02_JPRB/)  
KAO( :, 2,11, 1) = (/&
 & 1.8063E-05_JPRB,1.9445E-05_JPRB,1.8772E-05_JPRB,1.7526E-05_JPRB,1.5974E-05_JPRB,1.4135E-05_JPRB,&
 & 1.2268E-05_JPRB,1.1501E-05_JPRB,1.6744E-02_JPRB/)  
KAO( :, 3,11, 1) = (/&
 & 1.7957E-05_JPRB,2.0240E-05_JPRB,1.9844E-05_JPRB,1.8765E-05_JPRB,1.7266E-05_JPRB,1.5419E-05_JPRB,&
 & 1.3308E-05_JPRB,1.2031E-05_JPRB,1.6060E-02_JPRB/)  
KAO( :, 4,11, 1) = (/&
 & 1.8203E-05_JPRB,2.1589E-05_JPRB,2.1496E-05_JPRB,2.0575E-05_JPRB,1.9161E-05_JPRB,1.7309E-05_JPRB,&
 & 1.5025E-05_JPRB,1.2988E-05_JPRB,1.5567E-02_JPRB/)  
KAO( :, 5,11, 1) = (/&
 & 1.8839E-05_JPRB,2.3539E-05_JPRB,2.3752E-05_JPRB,2.3027E-05_JPRB,2.1716E-05_JPRB,1.9862E-05_JPRB,&
 & 1.7378E-05_JPRB,1.4830E-05_JPRB,1.5199E-02_JPRB/)  
KAO( :, 1,12, 1) = (/&
 & 1.5612E-05_JPRB,1.6179E-05_JPRB,1.5392E-05_JPRB,1.4206E-05_JPRB,1.2794E-05_JPRB,1.1200E-05_JPRB,&
 & 9.6111E-06_JPRB,9.5638E-06_JPRB,1.8266E-02_JPRB/)  
KAO( :, 2,12, 1) = (/&
 & 1.5307E-05_JPRB,1.6515E-05_JPRB,1.5933E-05_JPRB,1.4844E-05_JPRB,1.3479E-05_JPRB,1.1890E-05_JPRB,&
 & 1.0208E-05_JPRB,9.3516E-06_JPRB,1.7358E-02_JPRB/)  
KAO( :, 3,12, 1) = (/&
 & 1.5280E-05_JPRB,1.7278E-05_JPRB,1.6918E-05_JPRB,1.5945E-05_JPRB,1.4639E-05_JPRB,1.3025E-05_JPRB,&
 & 1.1176E-05_JPRB,9.8024E-06_JPRB,1.6665E-02_JPRB/)  
KAO( :, 4,12, 1) = (/&
 & 1.5592E-05_JPRB,1.8520E-05_JPRB,1.8406E-05_JPRB,1.7580E-05_JPRB,1.6331E-05_JPRB,1.4710E-05_JPRB,&
 & 1.2711E-05_JPRB,1.0774E-05_JPRB,1.6133E-02_JPRB/)  
KAO( :, 5,12, 1) = (/&
 & 1.6237E-05_JPRB,2.0286E-05_JPRB,2.0469E-05_JPRB,1.9802E-05_JPRB,1.8638E-05_JPRB,1.6992E-05_JPRB,&
 & 1.4787E-05_JPRB,1.2409E-05_JPRB,1.5729E-02_JPRB/)  
KAO( :, 1,13, 1) = (/&
 & 1.3792E-05_JPRB,1.4238E-05_JPRB,1.3502E-05_JPRB,1.2414E-05_JPRB,1.1117E-05_JPRB,9.6608E-06_JPRB,&
 & 8.1806E-06_JPRB,7.6738E-06_JPRB,1.5338E-02_JPRB/)  
KAO( :, 2,13, 1) = (/&
 & 1.3542E-05_JPRB,1.4555E-05_JPRB,1.3995E-05_JPRB,1.2981E-05_JPRB,1.1719E-05_JPRB,1.0269E-05_JPRB,&
 & 8.6775E-06_JPRB,7.6029E-06_JPRB,1.4590E-02_JPRB/)  
KAO( :, 3,13, 1) = (/&
 & 1.3558E-05_JPRB,1.5256E-05_JPRB,1.4880E-05_JPRB,1.3955E-05_JPRB,1.2744E-05_JPRB,1.1268E-05_JPRB,&
 & 9.5734E-06_JPRB,8.0878E-06_JPRB,1.4000E-02_JPRB/)  
KAO( :, 4,13, 1) = (/&
 & 1.3858E-05_JPRB,1.6375E-05_JPRB,1.6230E-05_JPRB,1.5419E-05_JPRB,1.4252E-05_JPRB,1.2754E-05_JPRB,&
 & 1.0921E-05_JPRB,9.0320E-06_JPRB,1.3543E-02_JPRB/)  
KAO( :, 5,13, 1) = (/&
 & 1.4462E-05_JPRB,1.7948E-05_JPRB,1.8079E-05_JPRB,1.7409E-05_JPRB,1.6310E-05_JPRB,1.4770E-05_JPRB,&
 & 1.2761E-05_JPRB,1.0416E-05_JPRB,1.3196E-02_JPRB/)  
KAO( :, 1, 1, 2) = (/&
 & 1.0631E-04_JPRB,1.5549E-04_JPRB,1.7340E-04_JPRB,1.8106E-04_JPRB,1.8266E-04_JPRB,1.7952E-04_JPRB,&
 & 1.7173E-04_JPRB,1.6014E-04_JPRB,1.4099E-04_JPRB/)  
KAO( :, 2, 1, 2) = (/&
 & 1.0836E-04_JPRB,1.6879E-04_JPRB,1.9237E-04_JPRB,2.0382E-04_JPRB,2.0859E-04_JPRB,2.0748E-04_JPRB,&
 & 2.0039E-04_JPRB,1.8243E-04_JPRB,1.5914E-04_JPRB/)  
KAO( :, 3, 1, 2) = (/&
 & 1.1141E-04_JPRB,1.8503E-04_JPRB,2.1527E-04_JPRB,2.3112E-04_JPRB,2.3976E-04_JPRB,2.4062E-04_JPRB,&
 & 2.3400E-04_JPRB,2.1520E-04_JPRB,1.8165E-04_JPRB/)  
KAO( :, 4, 1, 2) = (/&
 & 1.1542E-04_JPRB,2.0406E-04_JPRB,2.4207E-04_JPRB,2.6306E-04_JPRB,2.7542E-04_JPRB,2.7832E-04_JPRB,&
 & 2.7291E-04_JPRB,2.5096E-04_JPRB,2.0989E-04_JPRB/)  
KAO( :, 5, 1, 2) = (/&
 & 1.2040E-04_JPRB,2.2620E-04_JPRB,2.7276E-04_JPRB,2.9953E-04_JPRB,3.1543E-04_JPRB,3.2079E-04_JPRB,&
 & 3.1620E-04_JPRB,2.8905E-04_JPRB,2.4408E-04_JPRB/)  
KAO( :, 1, 2, 2) = (/&
 & 9.2736E-05_JPRB,1.3080E-04_JPRB,1.4408E-04_JPRB,1.4918E-04_JPRB,1.4919E-04_JPRB,1.4563E-04_JPRB,&
 & 1.3832E-04_JPRB,1.2913E-04_JPRB,1.3821E-04_JPRB/)  
KAO( :, 2, 2, 2) = (/&
 & 9.4585E-05_JPRB,1.4205E-04_JPRB,1.5994E-04_JPRB,1.6797E-04_JPRB,1.7060E-04_JPRB,1.6851E-04_JPRB,&
 & 1.6121E-04_JPRB,1.4625E-04_JPRB,1.5045E-04_JPRB/)  
KAO( :, 3, 2, 2) = (/&
 & 9.7336E-05_JPRB,1.5584E-04_JPRB,1.7917E-04_JPRB,1.9059E-04_JPRB,1.9617E-04_JPRB,1.9585E-04_JPRB,&
 & 1.8879E-04_JPRB,1.7257E-04_JPRB,1.6847E-04_JPRB/)  
KAO( :, 4, 2, 2) = (/&
 & 1.0100E-04_JPRB,1.7222E-04_JPRB,2.0175E-04_JPRB,2.1726E-04_JPRB,2.2590E-04_JPRB,2.2731E-04_JPRB,&
 & 2.2070E-04_JPRB,2.0218E-04_JPRB,1.9129E-04_JPRB/)  
KAO( :, 5, 2, 2) = (/&
 & 1.0558E-04_JPRB,1.9122E-04_JPRB,2.2772E-04_JPRB,2.4801E-04_JPRB,2.5982E-04_JPRB,2.6260E-04_JPRB,&
 & 2.5652E-04_JPRB,2.3358E-04_JPRB,2.1889E-04_JPRB/)  
KAO( :, 1, 3, 2) = (/&
 & 8.2078E-05_JPRB,1.0954E-04_JPRB,1.1829E-04_JPRB,1.2081E-04_JPRB,1.1948E-04_JPRB,1.1532E-04_JPRB,&
 & 1.0856E-04_JPRB,1.0266E-04_JPRB,1.7007E-04_JPRB/)  
KAO( :, 2, 3, 2) = (/&
 & 8.3515E-05_JPRB,1.1841E-04_JPRB,1.3075E-04_JPRB,1.3555E-04_JPRB,1.3601E-04_JPRB,1.3281E-04_JPRB,&
 & 1.2585E-04_JPRB,1.1400E-04_JPRB,1.7692E-04_JPRB/)  
KAO( :, 3, 3, 2) = (/&
 & 8.5702E-05_JPRB,1.2951E-04_JPRB,1.4617E-04_JPRB,1.5357E-04_JPRB,1.5612E-04_JPRB,1.5431E-04_JPRB,&
 & 1.4752E-04_JPRB,1.3319E-04_JPRB,1.8883E-04_JPRB/)  
KAO( :, 4, 3, 2) = (/&
 & 8.8714E-05_JPRB,1.4294E-04_JPRB,1.6445E-04_JPRB,1.7481E-04_JPRB,1.7986E-04_JPRB,1.7967E-04_JPRB,&
 & 1.7282E-04_JPRB,1.5669E-04_JPRB,2.0641E-04_JPRB/)  
KAO( :, 5, 3, 2) = (/&
 & 9.2653E-05_JPRB,1.5873E-04_JPRB,1.8560E-04_JPRB,1.9973E-04_JPRB,2.0749E-04_JPRB,2.0832E-04_JPRB,&
 & 2.0174E-04_JPRB,1.8232E-04_JPRB,2.2828E-04_JPRB/)  
KAO( :, 1, 4, 2) = (/&
 & 7.5057E-05_JPRB,9.3742E-05_JPRB,9.8708E-05_JPRB,9.9032E-05_JPRB,9.6534E-05_JPRB,9.1631E-05_JPRB,&
 & 8.5330E-05_JPRB,8.0637E-05_JPRB,2.4302E-04_JPRB/)  
KAO( :, 2, 4, 2) = (/&
 & 7.6019E-05_JPRB,1.0050E-04_JPRB,1.0818E-04_JPRB,1.1027E-04_JPRB,1.0900E-04_JPRB,1.0488E-04_JPRB,&
 & 9.8357E-05_JPRB,8.9315E-05_JPRB,2.5003E-04_JPRB/)  
KAO( :, 3, 4, 2) = (/&
 & 7.7597E-05_JPRB,1.0920E-04_JPRB,1.2007E-04_JPRB,1.2426E-04_JPRB,1.2440E-04_JPRB,1.2138E-04_JPRB,&
 & 1.1480E-04_JPRB,1.0183E-04_JPRB,2.5796E-04_JPRB/)  
KAO( :, 4, 4, 2) = (/&
 & 7.9952E-05_JPRB,1.1979E-04_JPRB,1.3449E-04_JPRB,1.4091E-04_JPRB,1.4297E-04_JPRB,1.4131E-04_JPRB,&
 & 1.3468E-04_JPRB,1.2088E-04_JPRB,2.6766E-04_JPRB/)  
KAO( :, 5, 4, 2) = (/&
 & 8.3148E-05_JPRB,1.3259E-04_JPRB,1.5143E-04_JPRB,1.6061E-04_JPRB,1.6491E-04_JPRB,1.6427E-04_JPRB,&
 & 1.5762E-04_JPRB,1.4129E-04_JPRB,2.8200E-04_JPRB/)  
KAO( :, 1, 5, 2) = (/&
 & 7.0507E-05_JPRB,8.2851E-05_JPRB,8.4727E-05_JPRB,8.3356E-05_JPRB,7.9669E-05_JPRB,7.4240E-05_JPRB,&
 & 6.8168E-05_JPRB,6.4269E-05_JPRB,3.5533E-04_JPRB/)  
KAO( :, 2, 5, 2) = (/&
 & 7.1163E-05_JPRB,8.7993E-05_JPRB,9.1940E-05_JPRB,9.1728E-05_JPRB,8.9016E-05_JPRB,8.4180E-05_JPRB,&
 & 7.7602E-05_JPRB,7.0901E-05_JPRB,3.6205E-04_JPRB/)  
KAO( :, 3, 5, 2) = (/&
 & 7.2353E-05_JPRB,9.4696E-05_JPRB,1.0096E-04_JPRB,1.0241E-04_JPRB,1.0073E-04_JPRB,9.6618E-05_JPRB,&
 & 9.0257E-05_JPRB,7.9342E-05_JPRB,3.6910E-04_JPRB/)  
KAO( :, 4, 5, 2) = (/&
 & 7.4211E-05_JPRB,1.0309E-04_JPRB,1.1198E-04_JPRB,1.1540E-04_JPRB,1.1506E-04_JPRB,1.1201E-04_JPRB,&
 & 1.0538E-04_JPRB,9.2743E-05_JPRB,3.7730E-04_JPRB/)  
KAO( :, 5, 5, 2) = (/&
 & 7.6842E-05_JPRB,1.1301E-04_JPRB,1.2533E-04_JPRB,1.3080E-04_JPRB,1.3221E-04_JPRB,1.3010E-04_JPRB,&
 & 1.2341E-04_JPRB,1.0902E-04_JPRB,3.8882E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART2',0,ZHOOK_HANDLE)


KAO( :, 1, 6, 2) = (/&
 & 6.7057E-05_JPRB,7.4992E-05_JPRB,7.4494E-05_JPRB,7.1808E-05_JPRB,6.7401E-05_JPRB,6.1558E-05_JPRB,&
 & 5.5600E-05_JPRB,5.3582E-05_JPRB,5.2728E-04_JPRB/)  
KAO( :, 2, 6, 2) = (/&
 & 6.7342E-05_JPRB,7.8865E-05_JPRB,7.9962E-05_JPRB,7.8191E-05_JPRB,7.4156E-05_JPRB,6.8577E-05_JPRB,&
 & 6.2398E-05_JPRB,5.6569E-05_JPRB,5.3013E-04_JPRB/)  
KAO( :, 3, 6, 2) = (/&
 & 6.8218E-05_JPRB,8.4114E-05_JPRB,8.7034E-05_JPRB,8.6152E-05_JPRB,8.2978E-05_JPRB,7.8073E-05_JPRB,&
 & 7.1379E-05_JPRB,6.2472E-05_JPRB,5.3405E-04_JPRB/)  
KAO( :, 4, 6, 2) = (/&
 & 6.9765E-05_JPRB,9.0741E-05_JPRB,9.5513E-05_JPRB,9.6075E-05_JPRB,9.4001E-05_JPRB,8.9757E-05_JPRB,&
 & 8.2727E-05_JPRB,7.1298E-05_JPRB,5.3812E-04_JPRB/)  
KAO( :, 5, 6, 2) = (/&
 & 7.2087E-05_JPRB,9.8694E-05_JPRB,1.0570E-04_JPRB,1.0811E-04_JPRB,1.0716E-04_JPRB,1.0356E-04_JPRB,&
 & 9.6610E-05_JPRB,8.3845E-05_JPRB,5.4521E-04_JPRB/)  
KAO( :, 1, 7, 2) = (/&
 & 6.3981E-05_JPRB,6.8796E-05_JPRB,6.6960E-05_JPRB,6.3245E-05_JPRB,5.8395E-05_JPRB,5.2642E-05_JPRB,&
 & 4.7017E-05_JPRB,4.3597E-05_JPRB,8.5561E-04_JPRB/)  
KAO( :, 2, 7, 2) = (/&
 & 6.4065E-05_JPRB,7.1972E-05_JPRB,7.1316E-05_JPRB,6.8334E-05_JPRB,6.3687E-05_JPRB,5.7772E-05_JPRB,&
 & 5.1662E-05_JPRB,4.6088E-05_JPRB,8.4325E-04_JPRB/)  
KAO( :, 3, 7, 2) = (/&
 & 6.4710E-05_JPRB,7.6213E-05_JPRB,7.7049E-05_JPRB,7.4782E-05_JPRB,7.0451E-05_JPRB,6.4812E-05_JPRB,&
 & 5.7879E-05_JPRB,5.0007E-05_JPRB,8.3547E-04_JPRB/)  
KAO( :, 4, 7, 2) = (/&
 & 6.6047E-05_JPRB,8.1740E-05_JPRB,8.4011E-05_JPRB,8.2492E-05_JPRB,7.9038E-05_JPRB,7.3729E-05_JPRB,&
 & 6.6297E-05_JPRB,5.5934E-05_JPRB,8.3289E-04_JPRB/)  
KAO( :, 5, 7, 2) = (/&
 & 6.8167E-05_JPRB,8.8466E-05_JPRB,9.2188E-05_JPRB,9.2019E-05_JPRB,8.9278E-05_JPRB,8.4398E-05_JPRB,&
 & 7.6796E-05_JPRB,6.5449E-05_JPRB,8.3519E-04_JPRB/)  
KAO( :, 1, 8, 2) = (/&
 & 6.2510E-05_JPRB,6.4632E-05_JPRB,6.1651E-05_JPRB,5.7339E-05_JPRB,5.1955E-05_JPRB,4.6202E-05_JPRB,&
 & 4.0544E-05_JPRB,3.4871E-05_JPRB,1.7109E-03_JPRB/)  
KAO( :, 2, 8, 2) = (/&
 & 6.2657E-05_JPRB,6.7414E-05_JPRB,6.5438E-05_JPRB,6.1572E-05_JPRB,5.6549E-05_JPRB,5.0497E-05_JPRB,&
 & 4.4065E-05_JPRB,3.7625E-05_JPRB,1.6570E-03_JPRB/)  
KAO( :, 3, 8, 2) = (/&
 & 6.3371E-05_JPRB,7.1203E-05_JPRB,7.0449E-05_JPRB,6.7168E-05_JPRB,6.2333E-05_JPRB,5.6127E-05_JPRB,&
 & 4.8965E-05_JPRB,4.1883E-05_JPRB,1.6155E-03_JPRB/)  
KAO( :, 4, 8, 2) = (/&
 & 6.4738E-05_JPRB,7.6021E-05_JPRB,7.6569E-05_JPRB,7.3931E-05_JPRB,6.9329E-05_JPRB,6.3277E-05_JPRB,&
 & 5.5409E-05_JPRB,4.5618E-05_JPRB,1.5874E-03_JPRB/)  
KAO( :, 5, 8, 2) = (/&
 & 6.6770E-05_JPRB,8.2019E-05_JPRB,8.3827E-05_JPRB,8.1865E-05_JPRB,7.7838E-05_JPRB,7.1738E-05_JPRB,&
 & 6.3577E-05_JPRB,5.2190E-05_JPRB,1.5711E-03_JPRB/)  
KAO( :, 1, 9, 2) = (/&
 & 5.9728E-05_JPRB,5.9777E-05_JPRB,5.6068E-05_JPRB,5.1537E-05_JPRB,4.6074E-05_JPRB,4.0294E-05_JPRB,&
 & 3.4429E-05_JPRB,2.7470E-05_JPRB,6.4927E-03_JPRB/)  
KAO( :, 2, 9, 2) = (/&
 & 6.0003E-05_JPRB,6.2162E-05_JPRB,5.9412E-05_JPRB,5.5191E-05_JPRB,4.9924E-05_JPRB,4.3949E-05_JPRB,&
 & 3.7436E-05_JPRB,3.0651E-05_JPRB,6.2135E-03_JPRB/)  
KAO( :, 3, 9, 2) = (/&
 & 6.0913E-05_JPRB,6.5739E-05_JPRB,6.3824E-05_JPRB,6.0113E-05_JPRB,5.5046E-05_JPRB,4.8801E-05_JPRB,&
 & 4.1506E-05_JPRB,3.4176E-05_JPRB,5.9805E-03_JPRB/)  
KAO( :, 4, 9, 2) = (/&
 & 6.2491E-05_JPRB,7.0239E-05_JPRB,6.9462E-05_JPRB,6.6167E-05_JPRB,6.1198E-05_JPRB,5.4677E-05_JPRB,&
 & 4.6786E-05_JPRB,3.7966E-05_JPRB,5.7915E-03_JPRB/)  
KAO( :, 5, 9, 2) = (/&
 & 6.4708E-05_JPRB,7.5807E-05_JPRB,7.6215E-05_JPRB,7.3304E-05_JPRB,6.8390E-05_JPRB,6.1872E-05_JPRB,&
 & 5.3436E-05_JPRB,4.2944E-05_JPRB,5.6478E-03_JPRB/)  
KAO( :, 1,10, 2) = (/&
 & 5.7126E-05_JPRB,5.5833E-05_JPRB,5.1557E-05_JPRB,4.6740E-05_JPRB,4.1349E-05_JPRB,3.5460E-05_JPRB,&
 & 2.9383E-05_JPRB,2.2254E-05_JPRB,2.8102E-02_JPRB/)  
KAO( :, 2,10, 2) = (/&
 & 5.7625E-05_JPRB,5.8090E-05_JPRB,5.4514E-05_JPRB,5.0007E-05_JPRB,4.4659E-05_JPRB,3.8611E-05_JPRB,&
 & 3.1928E-05_JPRB,2.5019E-05_JPRB,2.6630E-02_JPRB/)  
KAO( :, 3,10, 2) = (/&
 & 5.8840E-05_JPRB,6.1513E-05_JPRB,5.8714E-05_JPRB,5.4556E-05_JPRB,4.9297E-05_JPRB,4.2998E-05_JPRB,&
 & 3.5795E-05_JPRB,2.7821E-05_JPRB,2.5370E-02_JPRB/)  
KAO( :, 4,10, 2) = (/&
 & 6.0763E-05_JPRB,6.6038E-05_JPRB,6.4072E-05_JPRB,6.0305E-05_JPRB,5.4952E-05_JPRB,4.8371E-05_JPRB,&
 & 4.0375E-05_JPRB,3.1951E-05_JPRB,2.4311E-02_JPRB/)  
KAO( :, 5,10, 2) = (/&
 & 6.3372E-05_JPRB,7.1487E-05_JPRB,7.0499E-05_JPRB,6.7017E-05_JPRB,6.1584E-05_JPRB,5.4655E-05_JPRB,&
 & 4.6116E-05_JPRB,3.6268E-05_JPRB,2.3439E-02_JPRB/)  
KAO( :, 1,11, 2) = (/&
 & 5.3603E-05_JPRB,5.2084E-05_JPRB,4.7825E-05_JPRB,4.2996E-05_JPRB,3.7707E-05_JPRB,3.1871E-05_JPRB,&
 & 2.5749E-05_JPRB,1.8962E-05_JPRB,4.0768E-02_JPRB/)  
KAO( :, 2,11, 2) = (/&
 & 5.4665E-05_JPRB,5.4805E-05_JPRB,5.1049E-05_JPRB,4.6457E-05_JPRB,4.1159E-05_JPRB,3.5139E-05_JPRB,&
 & 2.8405E-05_JPRB,2.1377E-05_JPRB,3.8491E-02_JPRB/)  
KAO( :, 3,11, 2) = (/&
 & 5.6497E-05_JPRB,5.8583E-05_JPRB,5.5394E-05_JPRB,5.1053E-05_JPRB,4.5792E-05_JPRB,3.9489E-05_JPRB,&
 & 3.2243E-05_JPRB,2.4328E-05_JPRB,3.6513E-02_JPRB/)  
KAO( :, 4,11, 2) = (/&
 & 5.8985E-05_JPRB,6.3339E-05_JPRB,6.0862E-05_JPRB,5.6796E-05_JPRB,5.1415E-05_JPRB,4.4728E-05_JPRB,&
 & 3.6818E-05_JPRB,2.8272E-05_JPRB,3.4835E-02_JPRB/)  
KAO( :, 5,11, 2) = (/&
 & 6.2109E-05_JPRB,6.9025E-05_JPRB,6.7331E-05_JPRB,6.3560E-05_JPRB,5.7958E-05_JPRB,5.0821E-05_JPRB,&
 & 4.2238E-05_JPRB,3.2283E-05_JPRB,3.3538E-02_JPRB/)  
KAO( :, 1,12, 2) = (/&
 & 4.8218E-05_JPRB,4.6772E-05_JPRB,4.2783E-05_JPRB,3.8266E-05_JPRB,3.3329E-05_JPRB,2.7973E-05_JPRB,&
 & 2.2210E-05_JPRB,1.6103E-05_JPRB,4.2855E-02_JPRB/)  
KAO( :, 2,12, 2) = (/&
 & 4.9589E-05_JPRB,4.9591E-05_JPRB,4.5984E-05_JPRB,4.1620E-05_JPRB,3.6685E-05_JPRB,3.1116E-05_JPRB,&
 & 2.4857E-05_JPRB,1.8118E-05_JPRB,4.0385E-02_JPRB/)  
KAO( :, 3,12, 2) = (/&
 & 5.1684E-05_JPRB,5.3446E-05_JPRB,5.0256E-05_JPRB,4.6072E-05_JPRB,4.1058E-05_JPRB,3.5154E-05_JPRB,&
 & 2.8460E-05_JPRB,2.1061E-05_JPRB,3.8259E-02_JPRB/)  
KAO( :, 4,12, 2) = (/&
 & 5.4404E-05_JPRB,5.8179E-05_JPRB,5.5538E-05_JPRB,5.1508E-05_JPRB,4.6383E-05_JPRB,4.0102E-05_JPRB,&
 & 3.2710E-05_JPRB,2.4512E-05_JPRB,3.6555E-02_JPRB/)  
KAO( :, 5,12, 2) = (/&
 & 5.7705E-05_JPRB,6.3751E-05_JPRB,6.1743E-05_JPRB,5.7901E-05_JPRB,5.2567E-05_JPRB,4.5798E-05_JPRB,&
 & 3.7620E-05_JPRB,2.8071E-05_JPRB,3.5258E-02_JPRB/)  
KAO( :, 1,13, 2) = (/&
 & 4.4847E-05_JPRB,4.3227E-05_JPRB,3.9370E-05_JPRB,3.5016E-05_JPRB,3.0292E-05_JPRB,2.5212E-05_JPRB,&
 & 1.9650E-05_JPRB,1.3504E-05_JPRB,3.6293E-02_JPRB/)  
KAO( :, 2,13, 2) = (/&
 & 4.6428E-05_JPRB,4.6148E-05_JPRB,4.2554E-05_JPRB,3.8305E-05_JPRB,3.3519E-05_JPRB,2.8187E-05_JPRB,&
 & 2.2241E-05_JPRB,1.5699E-05_JPRB,3.4162E-02_JPRB/)  
KAO( :, 3,13, 2) = (/&
 & 4.8652E-05_JPRB,5.0010E-05_JPRB,4.6740E-05_JPRB,4.2580E-05_JPRB,3.7668E-05_JPRB,3.2017E-05_JPRB,&
 & 2.5602E-05_JPRB,1.8433E-05_JPRB,3.2408E-02_JPRB/)  
KAO( :, 4,13, 2) = (/&
 & 5.1540E-05_JPRB,5.4741E-05_JPRB,5.1862E-05_JPRB,4.7783E-05_JPRB,4.2732E-05_JPRB,3.6679E-05_JPRB,&
 & 2.9552E-05_JPRB,2.1520E-05_JPRB,3.1021E-02_JPRB/)  
KAO( :, 5,13, 2) = (/&
 & 5.5009E-05_JPRB,6.0274E-05_JPRB,5.7902E-05_JPRB,5.3924E-05_JPRB,4.8654E-05_JPRB,4.2058E-05_JPRB,&
 & 3.4024E-05_JPRB,2.4705E-05_JPRB,2.9920E-02_JPRB/)  
KAO( :, 1, 1, 3) = (/&
 & 2.1996E-04_JPRB,2.9526E-04_JPRB,3.2298E-04_JPRB,3.3886E-04_JPRB,3.4278E-04_JPRB,3.3270E-04_JPRB,&
 & 3.0580E-04_JPRB,2.6421E-04_JPRB,1.9405E-04_JPRB/)  
KAO( :, 2, 1, 3) = (/&
 & 2.2777E-04_JPRB,3.2546E-04_JPRB,3.6631E-04_JPRB,3.9178E-04_JPRB,3.9976E-04_JPRB,3.8992E-04_JPRB,&
 & 3.6015E-04_JPRB,3.0390E-04_JPRB,2.3244E-04_JPRB/)  
KAO( :, 3, 1, 3) = (/&
 & 2.3798E-04_JPRB,3.6240E-04_JPRB,4.1819E-04_JPRB,4.5171E-04_JPRB,4.6388E-04_JPRB,4.5403E-04_JPRB,&
 & 4.2005E-04_JPRB,3.4862E-04_JPRB,2.7996E-04_JPRB/)  
KAO( :, 4, 1, 3) = (/&
 & 2.5036E-04_JPRB,4.0578E-04_JPRB,4.7739E-04_JPRB,5.1796E-04_JPRB,5.3466E-04_JPRB,5.2428E-04_JPRB,&
 & 4.8540E-04_JPRB,4.0265E-04_JPRB,3.3613E-04_JPRB/)  
KAO( :, 5, 1, 3) = (/&
 & 2.6491E-04_JPRB,4.5514E-04_JPRB,5.4139E-04_JPRB,5.9019E-04_JPRB,6.1021E-04_JPRB,6.0113E-04_JPRB,&
 & 5.5511E-04_JPRB,4.6549E-04_JPRB,4.0231E-04_JPRB/)  
KAO( :, 1, 2, 3) = (/&
 & 1.9023E-04_JPRB,2.4938E-04_JPRB,2.6928E-04_JPRB,2.7999E-04_JPRB,2.8164E-04_JPRB,2.7165E-04_JPRB,&
 & 2.4816E-04_JPRB,2.1405E-04_JPRB,1.8605E-04_JPRB/)  
KAO( :, 2, 2, 3) = (/&
 & 1.9755E-04_JPRB,2.7578E-04_JPRB,3.0701E-04_JPRB,3.2514E-04_JPRB,3.2961E-04_JPRB,3.1950E-04_JPRB,&
 & 2.9350E-04_JPRB,2.4834E-04_JPRB,2.1661E-04_JPRB/)  
KAO( :, 3, 2, 3) = (/&
 & 2.0698E-04_JPRB,3.0835E-04_JPRB,3.5213E-04_JPRB,3.7659E-04_JPRB,3.8400E-04_JPRB,3.7352E-04_JPRB,&
 & 3.4485E-04_JPRB,2.8635E-04_JPRB,2.5484E-04_JPRB/)  
KAO( :, 4, 2, 3) = (/&
 & 2.1845E-04_JPRB,3.4704E-04_JPRB,4.0375E-04_JPRB,4.3389E-04_JPRB,4.4469E-04_JPRB,4.3366E-04_JPRB,&
 & 4.0044E-04_JPRB,3.3118E-04_JPRB,3.0181E-04_JPRB/)  
KAO( :, 5, 2, 3) = (/&
 & 2.3191E-04_JPRB,3.9121E-04_JPRB,4.5961E-04_JPRB,4.9694E-04_JPRB,5.1051E-04_JPRB,5.0008E-04_JPRB,&
 & 4.5954E-04_JPRB,3.8446E-04_JPRB,3.5821E-04_JPRB/)  
KAO( :, 1, 3, 3) = (/&
 & 1.6337E-04_JPRB,2.0696E-04_JPRB,2.1920E-04_JPRB,2.2438E-04_JPRB,2.2325E-04_JPRB,2.1342E-04_JPRB,&
 & 1.9346E-04_JPRB,1.6754E-04_JPRB,2.2851E-04_JPRB/)  
KAO( :, 2, 3, 3) = (/&
 & 1.6969E-04_JPRB,2.2863E-04_JPRB,2.5003E-04_JPRB,2.6113E-04_JPRB,2.6214E-04_JPRB,2.5210E-04_JPRB,&
 & 2.2996E-04_JPRB,1.9528E-04_JPRB,2.5004E-04_JPRB/)  
KAO( :, 3, 3, 3) = (/&
 & 1.7794E-04_JPRB,2.5581E-04_JPRB,2.8765E-04_JPRB,3.0386E-04_JPRB,3.0684E-04_JPRB,2.9654E-04_JPRB,&
 & 2.7213E-04_JPRB,2.2576E-04_JPRB,2.7938E-04_JPRB/)  
KAO( :, 4, 3, 3) = (/&
 & 1.8809E-04_JPRB,2.8851E-04_JPRB,3.3100E-04_JPRB,3.5226E-04_JPRB,3.5780E-04_JPRB,3.4669E-04_JPRB,&
 & 3.1871E-04_JPRB,2.6155E-04_JPRB,3.1781E-04_JPRB/)  
KAO( :, 5, 3, 3) = (/&
 & 2.0000E-04_JPRB,3.2610E-04_JPRB,3.7882E-04_JPRB,4.0593E-04_JPRB,4.1389E-04_JPRB,4.0266E-04_JPRB,&
 & 3.6759E-04_JPRB,3.0486E-04_JPRB,3.6667E-04_JPRB/)  
KAO( :, 1, 4, 3) = (/&
 & 1.4241E-04_JPRB,1.7332E-04_JPRB,1.7952E-04_JPRB,1.8020E-04_JPRB,1.7647E-04_JPRB,1.6735E-04_JPRB,&
 & 1.4973E-04_JPRB,1.3184E-04_JPRB,3.2106E-04_JPRB/)  
KAO( :, 2, 4, 3) = (/&
 & 1.4769E-04_JPRB,1.9050E-04_JPRB,2.0392E-04_JPRB,2.0940E-04_JPRB,2.0737E-04_JPRB,1.9737E-04_JPRB,&
 & 1.7818E-04_JPRB,1.5166E-04_JPRB,3.3469E-04_JPRB/)  
KAO( :, 3, 4, 3) = (/&
 & 1.5465E-04_JPRB,2.1252E-04_JPRB,2.3439E-04_JPRB,2.4418E-04_JPRB,2.4355E-04_JPRB,2.3330E-04_JPRB,&
 & 2.1176E-04_JPRB,1.7565E-04_JPRB,3.5614E-04_JPRB/)  
KAO( :, 4, 4, 3) = (/&
 & 1.6328E-04_JPRB,2.3941E-04_JPRB,2.6997E-04_JPRB,2.8414E-04_JPRB,2.8560E-04_JPRB,2.7432E-04_JPRB,&
 & 2.4968E-04_JPRB,2.0300E-04_JPRB,3.8786E-04_JPRB/)  
KAO( :, 5, 4, 3) = (/&
 & 1.7360E-04_JPRB,2.7074E-04_JPRB,3.1000E-04_JPRB,3.2898E-04_JPRB,3.3251E-04_JPRB,3.2018E-04_JPRB,&
 & 2.9030E-04_JPRB,2.3792E-04_JPRB,4.3003E-04_JPRB/)  
KAO( :, 1, 5, 3) = (/&
 & 1.2728E-04_JPRB,1.4778E-04_JPRB,1.4974E-04_JPRB,1.4737E-04_JPRB,1.4151E-04_JPRB,1.3231E-04_JPRB,&
 & 1.1681E-04_JPRB,1.0270E-04_JPRB,4.7573E-04_JPRB/)  
KAO( :, 2, 5, 3) = (/&
 & 1.3157E-04_JPRB,1.6147E-04_JPRB,1.6852E-04_JPRB,1.6982E-04_JPRB,1.6546E-04_JPRB,1.5568E-04_JPRB,&
 & 1.3883E-04_JPRB,1.1790E-04_JPRB,4.8146E-04_JPRB/)  
KAO( :, 3, 5, 3) = (/&
 & 1.3726E-04_JPRB,1.7914E-04_JPRB,1.9255E-04_JPRB,1.9744E-04_JPRB,1.9449E-04_JPRB,1.8411E-04_JPRB,&
 & 1.6473E-04_JPRB,1.3672E-04_JPRB,4.9353E-04_JPRB/)  
KAO( :, 4, 5, 3) = (/&
 & 1.4435E-04_JPRB,2.0063E-04_JPRB,2.2141E-04_JPRB,2.2988E-04_JPRB,2.2840E-04_JPRB,2.1697E-04_JPRB,&
 & 1.9533E-04_JPRB,1.5780E-04_JPRB,5.1440E-04_JPRB/)  
KAO( :, 5, 5, 3) = (/&
 & 1.5296E-04_JPRB,2.2635E-04_JPRB,2.5441E-04_JPRB,2.6691E-04_JPRB,2.6692E-04_JPRB,2.5417E-04_JPRB,&
 & 2.2886E-04_JPRB,1.8463E-04_JPRB,5.4687E-04_JPRB/)  
KAO( :, 1, 6, 3) = (/&
 & 1.1763E-04_JPRB,1.2927E-04_JPRB,1.2797E-04_JPRB,1.2303E-04_JPRB,1.1545E-04_JPRB,1.0562E-04_JPRB,&
 & 9.1765E-05_JPRB,7.9707E-05_JPRB,7.1798E-04_JPRB/)  
KAO( :, 2, 6, 3) = (/&
 & 1.2108E-04_JPRB,1.3972E-04_JPRB,1.4189E-04_JPRB,1.3941E-04_JPRB,1.3314E-04_JPRB,1.2332E-04_JPRB,&
 & 1.0817E-04_JPRB,9.2633E-05_JPRB,7.1177E-04_JPRB/)  
KAO( :, 3, 6, 3) = (/&
 & 1.2566E-04_JPRB,1.5364E-04_JPRB,1.6005E-04_JPRB,1.6046E-04_JPRB,1.5545E-04_JPRB,1.4506E-04_JPRB,&
 & 1.2802E-04_JPRB,1.0643E-04_JPRB,7.1286E-04_JPRB/)  
KAO( :, 4, 6, 3) = (/&
 & 1.3128E-04_JPRB,1.7051E-04_JPRB,1.8240E-04_JPRB,1.8616E-04_JPRB,1.8213E-04_JPRB,1.7092E-04_JPRB,&
 & 1.5182E-04_JPRB,1.2232E-04_JPRB,7.2407E-04_JPRB/)  
KAO( :, 5, 6, 3) = (/&
 & 1.3815E-04_JPRB,1.9078E-04_JPRB,2.0902E-04_JPRB,2.1580E-04_JPRB,2.1291E-04_JPRB,2.0039E-04_JPRB,&
 & 1.7876E-04_JPRB,1.4231E-04_JPRB,7.4599E-04_JPRB/)  
KAO( :, 1, 7, 3) = (/&
 & 1.1390E-04_JPRB,1.1947E-04_JPRB,1.1509E-04_JPRB,1.0795E-04_JPRB,9.8745E-05_JPRB,8.7676E-05_JPRB,&
 & 7.3630E-05_JPRB,6.4348E-05_JPRB,1.1861E-03_JPRB/)  
KAO( :, 2, 7, 3) = (/&
 & 1.1683E-04_JPRB,1.2744E-04_JPRB,1.2545E-04_JPRB,1.1972E-04_JPRB,1.1135E-04_JPRB,1.0038E-04_JPRB,&
 & 8.6144E-05_JPRB,7.3622E-05_JPRB,1.1591E-03_JPRB/)  
KAO( :, 3, 7, 3) = (/&
 & 1.2074E-04_JPRB,1.3815E-04_JPRB,1.3900E-04_JPRB,1.3526E-04_JPRB,1.2779E-04_JPRB,1.1675E-04_JPRB,&
 & 1.0110E-04_JPRB,8.3354E-05_JPRB,1.1418E-03_JPRB/)  
KAO( :, 4, 7, 3) = (/&
 & 1.2564E-04_JPRB,1.5125E-04_JPRB,1.5566E-04_JPRB,1.5486E-04_JPRB,1.4804E-04_JPRB,1.3653E-04_JPRB,&
 & 1.1897E-04_JPRB,9.5580E-05_JPRB,1.1345E-03_JPRB/)  
KAO( :, 5, 7, 3) = (/&
 & 1.3130E-04_JPRB,1.6685E-04_JPRB,1.7626E-04_JPRB,1.7784E-04_JPRB,1.7201E-04_JPRB,1.5950E-04_JPRB,&
 & 1.4031E-04_JPRB,1.0987E-04_JPRB,1.1432E-03_JPRB/)  
KAO( :, 1, 8, 3) = (/&
 & 1.1676E-04_JPRB,1.1853E-04_JPRB,1.1141E-04_JPRB,1.0211E-04_JPRB,9.1156E-05_JPRB,7.8301E-05_JPRB,&
 & 6.3522E-05_JPRB,5.5937E-05_JPRB,2.4094E-03_JPRB/)  
KAO( :, 2, 8, 3) = (/&
 & 1.1985E-04_JPRB,1.2513E-04_JPRB,1.1980E-04_JPRB,1.1130E-04_JPRB,1.0061E-04_JPRB,8.7533E-05_JPRB,&
 & 7.2505E-05_JPRB,6.1035E-05_JPRB,2.3252E-03_JPRB/)  
KAO( :, 3, 8, 3) = (/&
 & 1.2377E-04_JPRB,1.3400E-04_JPRB,1.3053E-04_JPRB,1.2319E-04_JPRB,1.1282E-04_JPRB,9.9725E-05_JPRB,&
 & 8.3671E-05_JPRB,6.6418E-05_JPRB,2.2547E-03_JPRB/)  
KAO( :, 4, 8, 3) = (/&
 & 1.2843E-04_JPRB,1.4498E-04_JPRB,1.4372E-04_JPRB,1.3796E-04_JPRB,1.2812E-04_JPRB,1.1463E-04_JPRB,&
 & 9.6976E-05_JPRB,7.5638E-05_JPRB,2.2063E-03_JPRB/)  
KAO( :, 5, 8, 3) = (/&
 & 1.3377E-04_JPRB,1.5770E-04_JPRB,1.5943E-04_JPRB,1.5571E-04_JPRB,1.4617E-04_JPRB,1.3202E-04_JPRB,&
 & 1.1296E-04_JPRB,8.6665E-05_JPRB,2.1851E-03_JPRB/)  
KAO( :, 1, 9, 3) = (/&
 & 1.1900E-04_JPRB,1.1760E-04_JPRB,1.0852E-04_JPRB,9.7634E-05_JPRB,8.5611E-05_JPRB,7.2038E-05_JPRB,&
 & 5.7121E-05_JPRB,5.0882E-05_JPRB,9.3039E-03_JPRB/)  
KAO( :, 2, 9, 3) = (/&
 & 1.2244E-04_JPRB,1.2389E-04_JPRB,1.1590E-04_JPRB,1.0554E-04_JPRB,9.3325E-05_JPRB,7.9548E-05_JPRB,&
 & 6.3970E-05_JPRB,5.3089E-05_JPRB,8.8588E-03_JPRB/)  
KAO( :, 3, 9, 3) = (/&
 & 1.2665E-04_JPRB,1.3180E-04_JPRB,1.2538E-04_JPRB,1.1542E-04_JPRB,1.0335E-04_JPRB,8.9270E-05_JPRB,&
 & 7.2786E-05_JPRB,5.6389E-05_JPRB,8.4831E-03_JPRB/)  
KAO( :, 4, 9, 3) = (/&
 & 1.3137E-04_JPRB,1.4182E-04_JPRB,1.3671E-04_JPRB,1.2766E-04_JPRB,1.1600E-04_JPRB,1.0124E-04_JPRB,&
 & 8.3094E-05_JPRB,6.1858E-05_JPRB,8.1874E-03_JPRB/)  
KAO( :, 5, 9, 3) = (/&
 & 1.3659E-04_JPRB,1.5316E-04_JPRB,1.4996E-04_JPRB,1.4235E-04_JPRB,1.3080E-04_JPRB,1.1485E-04_JPRB,&
 & 9.5226E-05_JPRB,6.9785E-05_JPRB,7.9858E-03_JPRB/)  
KAO( :, 1,10, 3) = (/&
 & 1.2241E-04_JPRB,1.1830E-04_JPRB,1.0781E-04_JPRB,9.5617E-05_JPRB,8.2345E-05_JPRB,6.8338E-05_JPRB,&
 & 5.2826E-05_JPRB,4.6160E-05_JPRB,4.0381E-02_JPRB/)  
KAO( :, 2,10, 3) = (/&
 & 1.2664E-04_JPRB,1.2454E-04_JPRB,1.1474E-04_JPRB,1.0301E-04_JPRB,8.9686E-05_JPRB,7.5133E-05_JPRB,&
 & 5.8776E-05_JPRB,4.7480E-05_JPRB,3.8200E-02_JPRB/)  
KAO( :, 3,10, 3) = (/&
 & 1.3156E-04_JPRB,1.3237E-04_JPRB,1.2366E-04_JPRB,1.1203E-04_JPRB,9.8559E-05_JPRB,8.3570E-05_JPRB,&
 & 6.6092E-05_JPRB,4.9993E-05_JPRB,3.6380E-02_JPRB/)  
KAO( :, 4,10, 3) = (/&
 & 1.3697E-04_JPRB,1.4182E-04_JPRB,1.3416E-04_JPRB,1.2285E-04_JPRB,1.0946E-04_JPRB,9.3555E-05_JPRB,&
 & 7.4960E-05_JPRB,5.3295E-05_JPRB,3.4905E-02_JPRB/)  
KAO( :, 5,10, 3) = (/&
 & 1.4259E-04_JPRB,1.5277E-04_JPRB,1.4630E-04_JPRB,1.3560E-04_JPRB,1.2209E-04_JPRB,1.0520E-04_JPRB,&
 & 8.5036E-05_JPRB,5.9404E-05_JPRB,3.3870E-02_JPRB/)  
KAO( :, 1,11, 3) = (/&
 & 1.2464E-04_JPRB,1.1924E-04_JPRB,1.0798E-04_JPRB,9.5208E-05_JPRB,8.1370E-05_JPRB,6.6802E-05_JPRB,&
 & 5.0925E-05_JPRB,4.1000E-05_JPRB,5.9272E-02_JPRB/)  
KAO( :, 2,11, 3) = (/&
 & 1.2962E-04_JPRB,1.2601E-04_JPRB,1.1550E-04_JPRB,1.0297E-04_JPRB,8.8796E-05_JPRB,7.3413E-05_JPRB,&
 & 5.6677E-05_JPRB,4.3091E-05_JPRB,5.5988E-02_JPRB/)  
KAO( :, 3,11, 3) = (/&
 & 1.3526E-04_JPRB,1.3432E-04_JPRB,1.2476E-04_JPRB,1.1207E-04_JPRB,9.7433E-05_JPRB,8.1433E-05_JPRB,&
 & 6.3587E-05_JPRB,4.4893E-05_JPRB,5.3301E-02_JPRB/)  
KAO( :, 4,11, 3) = (/&
 & 1.4143E-04_JPRB,1.4433E-04_JPRB,1.3524E-04_JPRB,1.2250E-04_JPRB,1.0762E-04_JPRB,9.0841E-05_JPRB,&
 & 7.1572E-05_JPRB,4.8589E-05_JPRB,5.1249E-02_JPRB/)  
KAO( :, 5,11, 3) = (/&
 & 1.4794E-04_JPRB,1.5535E-04_JPRB,1.4694E-04_JPRB,1.3429E-04_JPRB,1.1923E-04_JPRB,1.0163E-04_JPRB,&
 & 8.0508E-05_JPRB,5.4223E-05_JPRB,4.9838E-02_JPRB/)  
KAO( :, 1,12, 3) = (/&
 & 1.1910E-04_JPRB,1.1316E-04_JPRB,1.0208E-04_JPRB,8.9709E-05_JPRB,7.6333E-05_JPRB,6.2180E-05_JPRB,&
 & 4.7000E-05_JPRB,3.5676E-05_JPRB,6.3357E-02_JPRB/)  
KAO( :, 2,12, 3) = (/&
 & 1.2455E-04_JPRB,1.2008E-04_JPRB,1.0962E-04_JPRB,9.7228E-05_JPRB,8.3393E-05_JPRB,6.8465E-05_JPRB,&
 & 5.2437E-05_JPRB,3.7619E-05_JPRB,5.9804E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART3',0,ZHOOK_HANDLE)


KAO( :, 3,12, 3) = (/&
 & 1.3047E-04_JPRB,1.2832E-04_JPRB,1.1854E-04_JPRB,1.0591E-04_JPRB,9.1615E-05_JPRB,7.5950E-05_JPRB,&
 & 5.8544E-05_JPRB,3.9665E-05_JPRB,5.6934E-02_JPRB/)  
KAO( :, 4,12, 3) = (/&
 & 1.3670E-04_JPRB,1.3799E-04_JPRB,1.2856E-04_JPRB,1.1584E-04_JPRB,1.0096E-04_JPRB,8.4392E-05_JPRB,&
 & 6.5619E-05_JPRB,4.3295E-05_JPRB,5.4726E-02_JPRB/)  
KAO( :, 5,12, 3) = (/&
 & 1.4329E-04_JPRB,1.4852E-04_JPRB,1.3961E-04_JPRB,1.2668E-04_JPRB,1.1132E-04_JPRB,9.3911E-05_JPRB,&
 & 7.3404E-05_JPRB,4.8588E-05_JPRB,5.3331E-02_JPRB/)  
KAO( :, 1,13, 3) = (/&
 & 1.1744E-04_JPRB,1.1063E-04_JPRB,9.9314E-05_JPRB,8.6900E-05_JPRB,7.3501E-05_JPRB,5.9317E-05_JPRB,&
 & 4.4384E-05_JPRB,3.1424E-05_JPRB,5.4422E-02_JPRB/)  
KAO( :, 2,13, 3) = (/&
 & 1.2299E-04_JPRB,1.1743E-04_JPRB,1.0678E-04_JPRB,9.4184E-05_JPRB,8.0294E-05_JPRB,6.5353E-05_JPRB,&
 & 4.9396E-05_JPRB,3.3221E-05_JPRB,5.1307E-02_JPRB/)  
KAO( :, 3,13, 3) = (/&
 & 1.2905E-04_JPRB,1.2561E-04_JPRB,1.1534E-04_JPRB,1.0249E-04_JPRB,8.8036E-05_JPRB,7.2203E-05_JPRB,&
 & 5.4868E-05_JPRB,3.5562E-05_JPRB,4.8781E-02_JPRB/)  
KAO( :, 4,13, 3) = (/&
 & 1.3536E-04_JPRB,1.3482E-04_JPRB,1.2477E-04_JPRB,1.1168E-04_JPRB,9.6529E-05_JPRB,7.9711E-05_JPRB,&
 & 6.1059E-05_JPRB,3.9213E-05_JPRB,4.6937E-02_JPRB/)  
KAO( :, 5,13, 3) = (/&
 & 1.4199E-04_JPRB,1.4483E-04_JPRB,1.3499E-04_JPRB,1.2149E-04_JPRB,1.0563E-04_JPRB,8.7931E-05_JPRB,&
 & 6.7855E-05_JPRB,4.4192E-05_JPRB,4.5940E-02_JPRB/)  
KAO( :, 1, 1, 4) = (/&
 & 5.9013E-04_JPRB,7.0245E-04_JPRB,7.3164E-04_JPRB,7.2179E-04_JPRB,6.8573E-04_JPRB,6.2586E-04_JPRB,&
 & 5.3565E-04_JPRB,3.8435E-04_JPRB,2.9201E-04_JPRB/)  
KAO( :, 2, 1, 4) = (/&
 & 6.1984E-04_JPRB,7.6785E-04_JPRB,8.0887E-04_JPRB,8.0653E-04_JPRB,7.7581E-04_JPRB,7.1523E-04_JPRB,&
 & 6.1584E-04_JPRB,4.5439E-04_JPRB,3.5568E-04_JPRB/)  
KAO( :, 3, 1, 4) = (/&
 & 6.5388E-04_JPRB,8.3863E-04_JPRB,8.9298E-04_JPRB,9.0379E-04_JPRB,8.7674E-04_JPRB,8.1428E-04_JPRB,&
 & 7.0393E-04_JPRB,5.3376E-04_JPRB,4.3604E-04_JPRB/)  
KAO( :, 4, 1, 4) = (/&
 & 6.9104E-04_JPRB,9.1397E-04_JPRB,9.8676E-04_JPRB,1.0109E-03_JPRB,9.8675E-04_JPRB,9.2127E-04_JPRB,&
 & 8.0143E-04_JPRB,6.2432E-04_JPRB,5.3306E-04_JPRB/)  
KAO( :, 5, 1, 4) = (/&
 & 7.3106E-04_JPRB,9.9279E-04_JPRB,1.0893E-03_JPRB,1.1247E-03_JPRB,1.1052E-03_JPRB,1.0359E-03_JPRB,&
 & 9.1211E-04_JPRB,7.2751E-04_JPRB,6.4803E-04_JPRB/)  
KAO( :, 1, 2, 4) = (/&
 & 5.1187E-04_JPRB,6.0705E-04_JPRB,6.2677E-04_JPRB,6.1236E-04_JPRB,5.7704E-04_JPRB,5.2457E-04_JPRB,&
 & 4.4788E-04_JPRB,3.2136E-04_JPRB,2.7655E-04_JPRB/)  
KAO( :, 2, 2, 4) = (/&
 & 5.4076E-04_JPRB,6.6478E-04_JPRB,6.9333E-04_JPRB,6.8548E-04_JPRB,6.5547E-04_JPRB,6.0224E-04_JPRB,&
 & 5.1801E-04_JPRB,3.7991E-04_JPRB,3.3492E-04_JPRB/)  
KAO( :, 3, 2, 4) = (/&
 & 5.7303E-04_JPRB,7.2753E-04_JPRB,7.6688E-04_JPRB,7.7045E-04_JPRB,7.4435E-04_JPRB,6.8770E-04_JPRB,&
 & 5.9408E-04_JPRB,4.4774E-04_JPRB,4.0831E-04_JPRB/)  
KAO( :, 4, 2, 4) = (/&
 & 6.0856E-04_JPRB,7.9562E-04_JPRB,8.4981E-04_JPRB,8.6454E-04_JPRB,8.3973E-04_JPRB,7.7971E-04_JPRB,&
 & 6.7967E-04_JPRB,5.2619E-04_JPRB,4.9767E-04_JPRB/)  
KAO( :, 5, 2, 4) = (/&
 & 6.4744E-04_JPRB,8.6751E-04_JPRB,9.4144E-04_JPRB,9.6462E-04_JPRB,9.4185E-04_JPRB,8.7987E-04_JPRB,&
 & 7.7686E-04_JPRB,6.1504E-04_JPRB,6.0360E-04_JPRB/)  
KAO( :, 1, 3, 4) = (/&
 & 4.3480E-04_JPRB,5.0939E-04_JPRB,5.1971E-04_JPRB,5.0362E-04_JPRB,4.7059E-04_JPRB,4.2466E-04_JPRB,&
 & 3.6011E-04_JPRB,2.5628E-04_JPRB,3.1317E-04_JPRB/)  
KAO( :, 2, 3, 4) = (/&
 & 4.6125E-04_JPRB,5.5965E-04_JPRB,5.7749E-04_JPRB,5.6507E-04_JPRB,5.3629E-04_JPRB,4.9048E-04_JPRB,&
 & 4.1883E-04_JPRB,3.0535E-04_JPRB,3.6323E-04_JPRB/)  
KAO( :, 3, 3, 4) = (/&
 & 4.9122E-04_JPRB,6.1523E-04_JPRB,6.4073E-04_JPRB,6.3706E-04_JPRB,6.1179E-04_JPRB,5.6184E-04_JPRB,&
 & 4.8250E-04_JPRB,3.6188E-04_JPRB,4.3066E-04_JPRB/)  
KAO( :, 4, 3, 4) = (/&
 & 5.2513E-04_JPRB,6.7573E-04_JPRB,7.1288E-04_JPRB,7.1737E-04_JPRB,6.9265E-04_JPRB,6.3867E-04_JPRB,&
 & 5.5339E-04_JPRB,4.2777E-04_JPRB,5.1587E-04_JPRB/)  
KAO( :, 5, 3, 4) = (/&
 & 5.6222E-04_JPRB,7.4076E-04_JPRB,7.9225E-04_JPRB,8.0338E-04_JPRB,7.7867E-04_JPRB,7.2219E-04_JPRB,&
 & 6.3593E-04_JPRB,5.0139E-04_JPRB,6.1836E-04_JPRB/)  
KAO( :, 1, 4, 4) = (/&
 & 3.6976E-04_JPRB,4.2501E-04_JPRB,4.2710E-04_JPRB,4.1037E-04_JPRB,3.7995E-04_JPRB,3.3967E-04_JPRB,&
 & 2.8574E-04_JPRB,1.9979E-04_JPRB,4.2399E-04_JPRB/)  
KAO( :, 2, 4, 4) = (/&
 & 3.9327E-04_JPRB,4.6788E-04_JPRB,4.7574E-04_JPRB,4.6106E-04_JPRB,4.3415E-04_JPRB,3.9414E-04_JPRB,&
 & 3.3408E-04_JPRB,2.4080E-04_JPRB,4.6262E-04_JPRB/)  
KAO( :, 3, 4, 4) = (/&
 & 4.2065E-04_JPRB,5.1570E-04_JPRB,5.3050E-04_JPRB,5.2117E-04_JPRB,4.9670E-04_JPRB,4.5372E-04_JPRB,&
 & 3.8660E-04_JPRB,2.8761E-04_JPRB,5.2104E-04_JPRB/)  
KAO( :, 4, 4, 4) = (/&
 & 4.5210E-04_JPRB,5.6870E-04_JPRB,5.9248E-04_JPRB,5.8890E-04_JPRB,5.6466E-04_JPRB,5.1691E-04_JPRB,&
 & 4.4461E-04_JPRB,3.4096E-04_JPRB,6.0030E-04_JPRB/)  
KAO( :, 5, 4, 4) = (/&
 & 4.8655E-04_JPRB,6.2705E-04_JPRB,6.6097E-04_JPRB,6.6244E-04_JPRB,6.3703E-04_JPRB,5.8594E-04_JPRB,&
 & 5.1212E-04_JPRB,4.0060E-04_JPRB,6.9904E-04_JPRB/)  
KAO( :, 1, 5, 4) = (/&
 & 3.1593E-04_JPRB,3.5529E-04_JPRB,3.5086E-04_JPRB,3.3304E-04_JPRB,3.0635E-04_JPRB,2.7113E-04_JPRB,&
 & 2.2537E-04_JPRB,1.5625E-04_JPRB,6.0940E-04_JPRB/)  
KAO( :, 2, 5, 4) = (/&
 & 3.3652E-04_JPRB,3.9074E-04_JPRB,3.9127E-04_JPRB,3.7581E-04_JPRB,3.5016E-04_JPRB,3.1504E-04_JPRB,&
 & 2.6515E-04_JPRB,1.8777E-04_JPRB,6.3592E-04_JPRB/)  
KAO( :, 3, 5, 4) = (/&
 & 3.6116E-04_JPRB,4.3121E-04_JPRB,4.3815E-04_JPRB,4.2535E-04_JPRB,4.0138E-04_JPRB,3.6428E-04_JPRB,&
 & 3.0823E-04_JPRB,2.2541E-04_JPRB,6.8312E-04_JPRB/)  
KAO( :, 4, 5, 4) = (/&
 & 3.8955E-04_JPRB,4.7734E-04_JPRB,4.9105E-04_JPRB,4.8184E-04_JPRB,4.5822E-04_JPRB,4.1678E-04_JPRB,&
 & 3.5536E-04_JPRB,2.6865E-04_JPRB,7.5327E-04_JPRB/)  
KAO( :, 5, 5, 4) = (/&
 & 4.2054E-04_JPRB,5.2915E-04_JPRB,5.4965E-04_JPRB,5.4417E-04_JPRB,5.1930E-04_JPRB,4.7415E-04_JPRB,&
 & 4.0964E-04_JPRB,3.1712E-04_JPRB,8.4523E-04_JPRB/)  
KAO( :, 1, 6, 4) = (/&
 & 2.6945E-04_JPRB,2.9554E-04_JPRB,2.8676E-04_JPRB,2.6850E-04_JPRB,2.4490E-04_JPRB,2.1445E-04_JPRB,&
 & 1.7595E-04_JPRB,1.2228E-04_JPRB,9.0714E-04_JPRB/)  
KAO( :, 2, 6, 4) = (/&
 & 2.8703E-04_JPRB,3.2438E-04_JPRB,3.1923E-04_JPRB,3.0362E-04_JPRB,2.8005E-04_JPRB,2.4944E-04_JPRB,&
 & 2.0785E-04_JPRB,1.4399E-04_JPRB,9.1574E-04_JPRB/)  
KAO( :, 3, 6, 4) = (/&
 & 3.0826E-04_JPRB,3.5756E-04_JPRB,3.5816E-04_JPRB,3.4447E-04_JPRB,3.2155E-04_JPRB,2.8951E-04_JPRB,&
 & 2.4288E-04_JPRB,1.7387E-04_JPRB,9.4950E-04_JPRB/)  
KAO( :, 4, 6, 4) = (/&
 & 3.3280E-04_JPRB,3.9668E-04_JPRB,4.0334E-04_JPRB,3.9114E-04_JPRB,3.6863E-04_JPRB,3.3278E-04_JPRB,&
 & 2.8109E-04_JPRB,2.0888E-04_JPRB,1.0075E-03_JPRB/)  
KAO( :, 5, 6, 4) = (/&
 & 3.5966E-04_JPRB,4.4146E-04_JPRB,4.5343E-04_JPRB,4.4331E-04_JPRB,4.1953E-04_JPRB,3.7997E-04_JPRB,&
 & 3.2403E-04_JPRB,2.4762E-04_JPRB,1.0914E-03_JPRB/)  
KAO( :, 1, 7, 4) = (/&
 & 2.3611E-04_JPRB,2.5013E-04_JPRB,2.3826E-04_JPRB,2.1972E-04_JPRB,1.9747E-04_JPRB,1.7091E-04_JPRB,&
 & 1.3828E-04_JPRB,9.7674E-05_JPRB,1.5029E-03_JPRB/)  
KAO( :, 2, 7, 4) = (/&
 & 2.5027E-04_JPRB,2.7295E-04_JPRB,2.6351E-04_JPRB,2.4730E-04_JPRB,2.2544E-04_JPRB,1.9811E-04_JPRB,&
 & 1.6292E-04_JPRB,1.1091E-04_JPRB,1.4865E-03_JPRB/)  
KAO( :, 3, 7, 4) = (/&
 & 2.6744E-04_JPRB,2.9951E-04_JPRB,2.9483E-04_JPRB,2.8048E-04_JPRB,2.5858E-04_JPRB,2.3043E-04_JPRB,&
 & 1.9141E-04_JPRB,1.3387E-04_JPRB,1.5029E-03_JPRB/)  
KAO( :, 4, 7, 4) = (/&
 & 2.8737E-04_JPRB,3.3140E-04_JPRB,3.3216E-04_JPRB,3.1861E-04_JPRB,2.9712E-04_JPRB,2.6612E-04_JPRB,&
 & 2.2227E-04_JPRB,1.6157E-04_JPRB,1.5533E-03_JPRB/)  
KAO( :, 5, 7, 4) = (/&
 & 3.0980E-04_JPRB,3.6893E-04_JPRB,3.7432E-04_JPRB,3.6173E-04_JPRB,3.3923E-04_JPRB,3.0465E-04_JPRB,&
 & 2.5628E-04_JPRB,1.9217E-04_JPRB,1.6348E-03_JPRB/)  
KAO( :, 1, 8, 4) = (/&
 & 2.2652E-04_JPRB,2.2848E-04_JPRB,2.1284E-04_JPRB,1.9191E-04_JPRB,1.6879E-04_JPRB,1.4336E-04_JPRB,&
 & 1.1285E-04_JPRB,7.9764E-05_JPRB,3.0781E-03_JPRB/)  
KAO( :, 2, 8, 4) = (/&
 & 2.3707E-04_JPRB,2.4545E-04_JPRB,2.3111E-04_JPRB,2.1207E-04_JPRB,1.8962E-04_JPRB,1.6330E-04_JPRB,&
 & 1.3129E-04_JPRB,8.8046E-05_JPRB,3.0098E-03_JPRB/)  
KAO( :, 3, 8, 4) = (/&
 & 2.4991E-04_JPRB,2.6528E-04_JPRB,2.5454E-04_JPRB,2.3750E-04_JPRB,2.1491E-04_JPRB,1.8797E-04_JPRB,&
 & 1.5356E-04_JPRB,1.0513E-04_JPRB,2.9995E-03_JPRB/)  
KAO( :, 4, 8, 4) = (/&
 & 2.6517E-04_JPRB,2.8955E-04_JPRB,2.8339E-04_JPRB,2.6733E-04_JPRB,2.4488E-04_JPRB,2.1619E-04_JPRB,&
 & 1.7792E-04_JPRB,1.2592E-04_JPRB,3.0451E-03_JPRB/)  
KAO( :, 5, 8, 4) = (/&
 & 2.8248E-04_JPRB,3.1914E-04_JPRB,3.1724E-04_JPRB,3.0164E-04_JPRB,2.7867E-04_JPRB,2.4743E-04_JPRB,&
 & 2.0485E-04_JPRB,1.4978E-04_JPRB,3.1535E-03_JPRB/)  
KAO( :, 1, 9, 4) = (/&
 & 2.3338E-04_JPRB,2.2637E-04_JPRB,2.0631E-04_JPRB,1.8248E-04_JPRB,1.5663E-04_JPRB,1.2940E-04_JPRB,&
 & 9.8919E-05_JPRB,6.6772E-05_JPRB,1.1981E-02_JPRB/)  
KAO( :, 2, 9, 4) = (/&
 & 2.4198E-04_JPRB,2.3910E-04_JPRB,2.1989E-04_JPRB,1.9677E-04_JPRB,1.7190E-04_JPRB,1.4401E-04_JPRB,&
 & 1.1186E-04_JPRB,7.2859E-05_JPRB,1.1621E-02_JPRB/)  
KAO( :, 3, 9, 4) = (/&
 & 2.5171E-04_JPRB,2.5396E-04_JPRB,2.3686E-04_JPRB,2.1562E-04_JPRB,1.9038E-04_JPRB,1.6141E-04_JPRB,&
 & 1.2789E-04_JPRB,8.4203E-05_JPRB,1.1443E-02_JPRB/)  
KAO( :, 4, 9, 4) = (/&
 & 2.6331E-04_JPRB,2.7176E-04_JPRB,2.5835E-04_JPRB,2.3792E-04_JPRB,2.1195E-04_JPRB,1.8205E-04_JPRB,&
 & 1.4597E-04_JPRB,9.9793E-05_JPRB,1.1469E-02_JPRB/)  
KAO( :, 5, 9, 4) = (/&
 & 2.7657E-04_JPRB,2.9387E-04_JPRB,2.8372E-04_JPRB,2.6346E-04_JPRB,2.3692E-04_JPRB,2.0548E-04_JPRB,&
 & 1.6638E-04_JPRB,1.1782E-04_JPRB,1.1707E-02_JPRB/)  
KAO( :, 1,10, 4) = (/&
 & 2.4954E-04_JPRB,2.3620E-04_JPRB,2.1260E-04_JPRB,1.8570E-04_JPRB,1.5704E-04_JPRB,1.2663E-04_JPRB,&
 & 9.4550E-05_JPRB,5.8858E-05_JPRB,5.2756E-02_JPRB/)  
KAO( :, 2,10, 4) = (/&
 & 2.5766E-04_JPRB,2.4800E-04_JPRB,2.2452E-04_JPRB,1.9756E-04_JPRB,1.6882E-04_JPRB,1.3823E-04_JPRB,&
 & 1.0447E-04_JPRB,6.4244E-05_JPRB,5.0947E-02_JPRB/)  
KAO( :, 3,10, 4) = (/&
 & 2.6638E-04_JPRB,2.6038E-04_JPRB,2.3824E-04_JPRB,2.1240E-04_JPRB,1.8367E-04_JPRB,1.5156E-04_JPRB,&
 & 1.1609E-04_JPRB,7.2825E-05_JPRB,5.0037E-02_JPRB/)  
KAO( :, 4,10, 4) = (/&
 & 2.7598E-04_JPRB,2.7501E-04_JPRB,2.5538E-04_JPRB,2.3010E-04_JPRB,2.0028E-04_JPRB,1.6662E-04_JPRB,&
 & 1.2905E-04_JPRB,8.4471E-05_JPRB,5.0181E-02_JPRB/)  
KAO( :, 5,10, 4) = (/&
 & 2.8718E-04_JPRB,2.9275E-04_JPRB,2.7541E-04_JPRB,2.4987E-04_JPRB,2.1867E-04_JPRB,1.8373E-04_JPRB,&
 & 1.4422E-04_JPRB,9.7498E-05_JPRB,5.1335E-02_JPRB/)  
KAO( :, 1,11, 4) = (/&
 & 2.6411E-04_JPRB,2.4710E-04_JPRB,2.2075E-04_JPRB,1.9143E-04_JPRB,1.6059E-04_JPRB,1.2809E-04_JPRB,&
 & 9.4145E-05_JPRB,5.5264E-05_JPRB,7.9299E-02_JPRB/)  
KAO( :, 2,11, 4) = (/&
 & 2.7210E-04_JPRB,2.5809E-04_JPRB,2.3159E-04_JPRB,2.0221E-04_JPRB,1.7108E-04_JPRB,1.3827E-04_JPRB,&
 & 1.0265E-04_JPRB,6.0771E-05_JPRB,7.7122E-02_JPRB/)  
KAO( :, 3,11, 4) = (/&
 & 2.8014E-04_JPRB,2.6895E-04_JPRB,2.4355E-04_JPRB,2.1491E-04_JPRB,1.8365E-04_JPRB,1.4942E-04_JPRB,&
 & 1.1181E-04_JPRB,6.9122E-05_JPRB,7.6765E-02_JPRB/)  
KAO( :, 4,11, 4) = (/&
 & 2.8881E-04_JPRB,2.8113E-04_JPRB,2.5786E-04_JPRB,2.2946E-04_JPRB,1.9727E-04_JPRB,1.6160E-04_JPRB,&
 & 1.2257E-04_JPRB,7.8465E-05_JPRB,7.8124E-02_JPRB/)  
KAO( :, 5,11, 4) = (/&
 & 2.9828E-04_JPRB,2.9581E-04_JPRB,2.7411E-04_JPRB,2.4589E-04_JPRB,2.1291E-04_JPRB,1.7587E-04_JPRB,&
 & 1.3594E-04_JPRB,8.9600E-05_JPRB,8.1170E-02_JPRB/)  
KAO( :, 1,12, 4) = (/&
 & 2.5900E-04_JPRB,2.4054E-04_JPRB,2.1383E-04_JPRB,1.8455E-04_JPRB,1.5406E-04_JPRB,1.2218E-04_JPRB,&
 & 8.8914E-05_JPRB,5.0392E-05_JPRB,8.6490E-02_JPRB/)  
KAO( :, 2,12, 4) = (/&
 & 2.6587E-04_JPRB,2.4971E-04_JPRB,2.2287E-04_JPRB,1.9390E-04_JPRB,1.6307E-04_JPRB,1.3059E-04_JPRB,&
 & 9.5693E-05_JPRB,5.6200E-05_JPRB,8.4739E-02_JPRB/)  
KAO( :, 3,12, 4) = (/&
 & 2.7262E-04_JPRB,2.5871E-04_JPRB,2.3314E-04_JPRB,2.0445E-04_JPRB,1.7328E-04_JPRB,1.3985E-04_JPRB,&
 & 1.0369E-04_JPRB,6.3281E-05_JPRB,8.5196E-02_JPRB/)  
KAO( :, 4,12, 4) = (/&
 & 2.7987E-04_JPRB,2.6889E-04_JPRB,2.4524E-04_JPRB,2.1669E-04_JPRB,1.8519E-04_JPRB,1.5064E-04_JPRB,&
 & 1.1324E-04_JPRB,7.1445E-05_JPRB,8.7799E-02_JPRB/)  
KAO( :, 5,12, 4) = (/&
 & 2.8782E-04_JPRB,2.8193E-04_JPRB,2.5958E-04_JPRB,2.3156E-04_JPRB,1.9937E-04_JPRB,1.6355E-04_JPRB,&
 & 1.2524E-04_JPRB,8.1256E-05_JPRB,9.2236E-02_JPRB/)  
KAO( :, 1,13, 4) = (/&
 & 2.5778E-04_JPRB,2.3735E-04_JPRB,2.0980E-04_JPRB,1.8003E-04_JPRB,1.4941E-04_JPRB,1.1772E-04_JPRB,&
 & 8.4515E-05_JPRB,4.7447E-05_JPRB,7.6105E-02_JPRB/)  
KAO( :, 2,13, 4) = (/&
 & 2.6333E-04_JPRB,2.4457E-04_JPRB,2.1672E-04_JPRB,1.8743E-04_JPRB,1.5665E-04_JPRB,1.2434E-04_JPRB,&
 & 9.0194E-05_JPRB,5.2576E-05_JPRB,7.5229E-02_JPRB/)  
KAO( :, 3,13, 4) = (/&
 & 2.6832E-04_JPRB,2.5148E-04_JPRB,2.2532E-04_JPRB,1.9639E-04_JPRB,1.6531E-04_JPRB,1.3247E-04_JPRB,&
 & 9.7365E-05_JPRB,5.8706E-05_JPRB,7.6481E-02_JPRB/)  
KAO( :, 4,13, 4) = (/&
 & 2.7426E-04_JPRB,2.6072E-04_JPRB,2.3633E-04_JPRB,2.0753E-04_JPRB,1.7633E-04_JPRB,1.4258E-04_JPRB,&
 & 1.0613E-04_JPRB,6.5878E-05_JPRB,7.9777E-02_JPRB/)  
KAO( :, 5,13, 4) = (/&
 & 2.8141E-04_JPRB,2.7288E-04_JPRB,2.4996E-04_JPRB,2.2169E-04_JPRB,1.8986E-04_JPRB,1.5488E-04_JPRB,&
 & 1.1727E-04_JPRB,7.4750E-05_JPRB,8.4864E-02_JPRB/)  
KAO( :, 1, 1, 5) = (/&
 & 1.7137E-03_JPRB,1.6965E-03_JPRB,1.6056E-03_JPRB,1.4623E-03_JPRB,1.2864E-03_JPRB,1.0870E-03_JPRB,&
 & 8.6301E-04_JPRB,6.0966E-04_JPRB,4.4058E-04_JPRB/)  
KAO( :, 2, 1, 5) = (/&
 & 1.7704E-03_JPRB,1.7874E-03_JPRB,1.7001E-03_JPRB,1.5551E-03_JPRB,1.3819E-03_JPRB,1.1838E-03_JPRB,&
 & 9.5980E-04_JPRB,7.0743E-04_JPRB,5.5098E-04_JPRB/)  
KAO( :, 3, 1, 5) = (/&
 & 1.8247E-03_JPRB,1.8784E-03_JPRB,1.8001E-03_JPRB,1.6592E-03_JPRB,1.4952E-03_JPRB,1.3012E-03_JPRB,&
 & 1.0846E-03_JPRB,8.2466E-04_JPRB,6.8654E-04_JPRB/)  
KAO( :, 4, 1, 5) = (/&
 & 1.8807E-03_JPRB,1.9750E-03_JPRB,1.9078E-03_JPRB,1.7834E-03_JPRB,1.6310E-03_JPRB,1.4483E-03_JPRB,&
 & 1.2338E-03_JPRB,9.6045E-04_JPRB,8.5044E-04_JPRB/)  
KAO( :, 5, 1, 5) = (/&
 & 1.9386E-03_JPRB,2.0802E-03_JPRB,2.0314E-03_JPRB,1.9311E-03_JPRB,1.7973E-03_JPRB,1.6224E-03_JPRB,&
 & 1.4041E-03_JPRB,1.1149E-03_JPRB,1.0435E-03_JPRB/)  
KAO( :, 1, 2, 5) = (/&
 & 1.5019E-03_JPRB,1.4891E-03_JPRB,1.4050E-03_JPRB,1.2791E-03_JPRB,1.1249E-03_JPRB,9.4471E-04_JPRB,&
 & 7.4490E-04_JPRB,5.1735E-04_JPRB,4.2795E-04_JPRB/)  
KAO( :, 2, 2, 5) = (/&
 & 1.5481E-03_JPRB,1.5670E-03_JPRB,1.4869E-03_JPRB,1.3627E-03_JPRB,1.2086E-03_JPRB,1.0310E-03_JPRB,&
 & 8.2991E-04_JPRB,6.0449E-04_JPRB,5.2985E-04_JPRB/)  
KAO( :, 3, 2, 5) = (/&
 & 1.5955E-03_JPRB,1.6464E-03_JPRB,1.5764E-03_JPRB,1.4549E-03_JPRB,1.3083E-03_JPRB,1.1370E-03_JPRB,&
 & 9.3949E-04_JPRB,7.0586E-04_JPRB,6.5574E-04_JPRB/)  
KAO( :, 4, 2, 5) = (/&
 & 1.6449E-03_JPRB,1.7318E-03_JPRB,1.6759E-03_JPRB,1.5663E-03_JPRB,1.4318E-03_JPRB,1.2693E-03_JPRB,&
 & 1.0703E-03_JPRB,8.2289E-04_JPRB,8.0944E-04_JPRB/)  
KAO( :, 5, 2, 5) = (/&
 & 1.6963E-03_JPRB,1.8275E-03_JPRB,1.7899E-03_JPRB,1.7018E-03_JPRB,1.5826E-03_JPRB,1.4255E-03_JPRB,&
 & 1.2208E-03_JPRB,9.5732E-04_JPRB,9.9376E-04_JPRB/)  
KAO( :, 1, 3, 5) = (/&
 & 1.2946E-03_JPRB,1.2789E-03_JPRB,1.2021E-03_JPRB,1.0905E-03_JPRB,9.5582E-04_JPRB,7.9856E-04_JPRB,&
 & 6.2419E-04_JPRB,4.2060E-04_JPRB,4.8597E-04_JPRB/)  
KAO( :, 2, 3, 5) = (/&
 & 1.3334E-03_JPRB,1.3450E-03_JPRB,1.2700E-03_JPRB,1.1621E-03_JPRB,1.0260E-03_JPRB,8.6938E-04_JPRB,&
 & 6.9581E-04_JPRB,4.9333E-04_JPRB,5.8939E-04_JPRB/)  
KAO( :, 3, 3, 5) = (/&
 & 1.3735E-03_JPRB,1.4122E-03_JPRB,1.3468E-03_JPRB,1.2420E-03_JPRB,1.1098E-03_JPRB,9.5952E-04_JPRB,&
 & 7.8793E-04_JPRB,5.7747E-04_JPRB,7.1825E-04_JPRB/)  
KAO( :, 4, 3, 5) = (/&
 & 1.4149E-03_JPRB,1.4860E-03_JPRB,1.4348E-03_JPRB,1.3382E-03_JPRB,1.2156E-03_JPRB,1.0728E-03_JPRB,&
 & 8.9873E-04_JPRB,6.7617E-04_JPRB,8.7351E-04_JPRB/)  
KAO( :, 5, 3, 5) = (/&
 & 1.4592E-03_JPRB,1.5699E-03_JPRB,1.5381E-03_JPRB,1.4563E-03_JPRB,1.3459E-03_JPRB,1.2082E-03_JPRB,&
 & 1.0276E-03_JPRB,7.9087E-04_JPRB,1.0595E-03_JPRB/)  
KAO( :, 1, 4, 5) = (/&
 & 1.1144E-03_JPRB,1.0934E-03_JPRB,1.0240E-03_JPRB,9.2287E-04_JPRB,8.0421E-04_JPRB,6.6808E-04_JPRB,&
 & 5.1730E-04_JPRB,3.3813E-04_JPRB,6.1462E-04_JPRB/)  
KAO( :, 2, 4, 5) = (/&
 & 1.1469E-03_JPRB,1.1488E-03_JPRB,1.0800E-03_JPRB,9.8253E-04_JPRB,8.6268E-04_JPRB,7.2497E-04_JPRB,&
 & 5.7476E-04_JPRB,3.9764E-04_JPRB,7.1472E-04_JPRB/)  
KAO( :, 3, 4, 5) = (/&
 & 1.1797E-03_JPRB,1.2067E-03_JPRB,1.1428E-03_JPRB,1.0501E-03_JPRB,9.3226E-04_JPRB,7.9746E-04_JPRB,&
 & 6.5011E-04_JPRB,4.6691E-04_JPRB,8.5032E-04_JPRB/)  
KAO( :, 4, 4, 5) = (/&
 & 1.2139E-03_JPRB,1.2682E-03_JPRB,1.2174E-03_JPRB,1.1319E-03_JPRB,1.0196E-03_JPRB,8.9229E-04_JPRB,&
 & 7.4246E-04_JPRB,5.4839E-04_JPRB,1.0185E-03_JPRB/)  
KAO( :, 5, 4, 5) = (/&
 & 1.2525E-03_JPRB,1.3386E-03_JPRB,1.3069E-03_JPRB,1.2320E-03_JPRB,1.1286E-03_JPRB,1.0072E-03_JPRB,&
 & 8.5027E-04_JPRB,6.4344E-04_JPRB,1.2190E-03_JPRB/)  
KAO( :, 1, 5, 5) = (/&
 & 9.5403E-04_JPRB,9.3019E-04_JPRB,8.6917E-04_JPRB,7.7882E-04_JPRB,6.7397E-04_JPRB,5.5681E-04_JPRB,&
 & 4.2732E-04_JPRB,2.7040E-04_JPRB,8.4167E-04_JPRB/)  
KAO( :, 2, 5, 5) = (/&
 & 9.8163E-04_JPRB,9.7748E-04_JPRB,9.1548E-04_JPRB,8.2676E-04_JPRB,7.2236E-04_JPRB,6.0295E-04_JPRB,&
 & 4.7188E-04_JPRB,3.1812E-04_JPRB,9.2459E-04_JPRB/)  
KAO( :, 3, 5, 5) = (/&
 & 1.0087E-03_JPRB,1.0268E-03_JPRB,9.6743E-04_JPRB,8.8361E-04_JPRB,7.8023E-04_JPRB,6.6112E-04_JPRB,&
 & 5.3219E-04_JPRB,3.7543E-04_JPRB,1.0523E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART4',0,ZHOOK_HANDLE)


KAO( :, 4, 5, 5) = (/&
 & 1.0377E-03_JPRB,1.0786E-03_JPRB,1.0288E-03_JPRB,9.5341E-04_JPRB,8.5203E-04_JPRB,7.3754E-04_JPRB,&
 & 6.0792E-04_JPRB,4.4270E-04_JPRB,1.2261E-03_JPRB/)  
KAO( :, 5, 5, 5) = (/&
 & 1.0724E-03_JPRB,1.1380E-03_JPRB,1.1047E-03_JPRB,1.0358E-03_JPRB,9.4134E-04_JPRB,8.3220E-04_JPRB,&
 & 6.9728E-04_JPRB,5.2081E-04_JPRB,1.4470E-03_JPRB/)  
KAO( :, 1, 6, 5) = (/&
 & 8.0588E-04_JPRB,7.8134E-04_JPRB,7.2703E-04_JPRB,6.4891E-04_JPRB,5.5742E-04_JPRB,4.5781E-04_JPRB,&
 & 3.4857E-04_JPRB,2.1150E-04_JPRB,1.1955E-03_JPRB/)  
KAO( :, 2, 6, 5) = (/&
 & 8.2987E-04_JPRB,8.2145E-04_JPRB,7.6654E-04_JPRB,6.8713E-04_JPRB,5.9710E-04_JPRB,4.9603E-04_JPRB,&
 & 3.8344E-04_JPRB,2.5028E-04_JPRB,1.2644E-03_JPRB/)  
KAO( :, 3, 6, 5) = (/&
 & 8.5260E-04_JPRB,8.6248E-04_JPRB,8.0901E-04_JPRB,7.3393E-04_JPRB,6.4549E-04_JPRB,5.4230E-04_JPRB,&
 & 4.3028E-04_JPRB,2.9597E-04_JPRB,1.3809E-03_JPRB/)  
KAO( :, 4, 6, 5) = (/&
 & 8.7789E-04_JPRB,9.0633E-04_JPRB,8.5910E-04_JPRB,7.9201E-04_JPRB,7.0399E-04_JPRB,6.0291E-04_JPRB,&
 & 4.9056E-04_JPRB,3.5045E-04_JPRB,1.5502E-03_JPRB/)  
KAO( :, 5, 6, 5) = (/&
 & 9.0920E-04_JPRB,9.5736E-04_JPRB,9.2249E-04_JPRB,8.6100E-04_JPRB,7.7647E-04_JPRB,6.7926E-04_JPRB,&
 & 5.6406E-04_JPRB,4.1413E-04_JPRB,1.7775E-03_JPRB/)  
KAO( :, 1, 7, 5) = (/&
 & 6.7718E-04_JPRB,6.5283E-04_JPRB,6.0385E-04_JPRB,5.3746E-04_JPRB,4.5928E-04_JPRB,3.7434E-04_JPRB,&
 & 2.8222E-04_JPRB,1.6381E-04_JPRB,1.9446E-03_JPRB/)  
KAO( :, 2, 7, 5) = (/&
 & 6.9831E-04_JPRB,6.8657E-04_JPRB,6.3767E-04_JPRB,5.6836E-04_JPRB,4.9039E-04_JPRB,4.0548E-04_JPRB,&
 & 3.1038E-04_JPRB,1.9535E-04_JPRB,2.0007E-03_JPRB/)  
KAO( :, 3, 7, 5) = (/&
 & 7.1868E-04_JPRB,7.2062E-04_JPRB,6.7244E-04_JPRB,6.0563E-04_JPRB,5.3050E-04_JPRB,4.4299E-04_JPRB,&
 & 3.4588E-04_JPRB,2.3206E-04_JPRB,2.1166E-03_JPRB/)  
KAO( :, 4, 7, 5) = (/&
 & 7.4125E-04_JPRB,7.5799E-04_JPRB,7.1378E-04_JPRB,6.5339E-04_JPRB,5.7827E-04_JPRB,4.9033E-04_JPRB,&
 & 3.9327E-04_JPRB,2.7533E-04_JPRB,2.2963E-03_JPRB/)  
KAO( :, 5, 7, 5) = (/&
 & 7.6923E-04_JPRB,8.0202E-04_JPRB,7.6642E-04_JPRB,7.1096E-04_JPRB,6.3687E-04_JPRB,5.5087E-04_JPRB,&
 & 4.5258E-04_JPRB,3.2683E-04_JPRB,2.5393E-03_JPRB/)  
KAO( :, 1, 8, 5) = (/&
 & 5.7599E-04_JPRB,5.5064E-04_JPRB,5.0518E-04_JPRB,4.4746E-04_JPRB,3.8078E-04_JPRB,3.0749E-04_JPRB,&
 & 2.2925E-04_JPRB,1.2727E-04_JPRB,4.0446E-03_JPRB/)  
KAO( :, 2, 8, 5) = (/&
 & 5.9400E-04_JPRB,5.7851E-04_JPRB,5.3320E-04_JPRB,4.7317E-04_JPRB,4.0494E-04_JPRB,3.3229E-04_JPRB,&
 & 2.5224E-04_JPRB,1.5307E-04_JPRB,4.1120E-03_JPRB/)  
KAO( :, 3, 8, 5) = (/&
 & 6.1213E-04_JPRB,6.0695E-04_JPRB,5.6225E-04_JPRB,5.0253E-04_JPRB,4.3721E-04_JPRB,3.6322E-04_JPRB,&
 & 2.7965E-04_JPRB,1.8169E-04_JPRB,4.2811E-03_JPRB/)  
KAO( :, 4, 8, 5) = (/&
 & 6.3202E-04_JPRB,6.3848E-04_JPRB,5.9649E-04_JPRB,5.4156E-04_JPRB,4.7672E-04_JPRB,4.0069E-04_JPRB,&
 & 3.1617E-04_JPRB,2.1644E-04_JPRB,4.5447E-03_JPRB/)  
KAO( :, 5, 8, 5) = (/&
 & 6.5665E-04_JPRB,6.7566E-04_JPRB,6.4050E-04_JPRB,5.8944E-04_JPRB,5.2476E-04_JPRB,4.4890E-04_JPRB,&
 & 3.6328E-04_JPRB,2.5754E-04_JPRB,4.8900E-03_JPRB/)  
KAO( :, 1, 9, 5) = (/&
 & 5.0775E-04_JPRB,4.7779E-04_JPRB,4.3345E-04_JPRB,3.8064E-04_JPRB,3.2167E-04_JPRB,2.5711E-04_JPRB,&
 & 1.8824E-04_JPRB,1.0074E-04_JPRB,1.6194E-02_JPRB/)  
KAO( :, 2, 9, 5) = (/&
 & 5.2113E-04_JPRB,4.9905E-04_JPRB,4.5480E-04_JPRB,4.0079E-04_JPRB,3.3970E-04_JPRB,2.7482E-04_JPRB,&
 & 2.0609E-04_JPRB,1.2012E-04_JPRB,1.6408E-02_JPRB/)  
KAO( :, 3, 9, 5) = (/&
 & 5.3522E-04_JPRB,5.2108E-04_JPRB,4.7732E-04_JPRB,4.2276E-04_JPRB,3.6348E-04_JPRB,2.9937E-04_JPRB,&
 & 2.2764E-04_JPRB,1.4255E-04_JPRB,1.6992E-02_JPRB/)  
KAO( :, 4, 9, 5) = (/&
 & 5.5077E-04_JPRB,5.4517E-04_JPRB,5.0402E-04_JPRB,4.5270E-04_JPRB,3.9497E-04_JPRB,3.2945E-04_JPRB,&
 & 2.5566E-04_JPRB,1.6981E-04_JPRB,1.7864E-02_JPRB/)  
KAO( :, 5, 9, 5) = (/&
 & 5.6949E-04_JPRB,5.7445E-04_JPRB,5.3893E-04_JPRB,4.9094E-04_JPRB,4.3412E-04_JPRB,3.6760E-04_JPRB,&
 & 2.9217E-04_JPRB,2.0252E-04_JPRB,1.8952E-02_JPRB/)  
KAO( :, 1,10, 5) = (/&
 & 4.9717E-04_JPRB,4.5696E-04_JPRB,4.0763E-04_JPRB,3.5309E-04_JPRB,2.9433E-04_JPRB,2.3192E-04_JPRB,&
 & 1.6609E-04_JPRB,8.8589E-05_JPRB,7.4795E-02_JPRB/)  
KAO( :, 2,10, 5) = (/&
 & 5.0423E-04_JPRB,4.7002E-04_JPRB,4.2162E-04_JPRB,3.6653E-04_JPRB,3.0673E-04_JPRB,2.4316E-04_JPRB,&
 & 1.7817E-04_JPRB,1.0118E-04_JPRB,7.6452E-02_JPRB/)  
KAO( :, 3,10, 5) = (/&
 & 5.1212E-04_JPRB,4.8431E-04_JPRB,4.3650E-04_JPRB,3.8161E-04_JPRB,3.2242E-04_JPRB,2.6059E-04_JPRB,&
 & 1.9440E-04_JPRB,1.1733E-04_JPRB,7.9783E-02_JPRB/)  
KAO( :, 4,10, 5) = (/&
 & 5.2160E-04_JPRB,5.0030E-04_JPRB,4.5482E-04_JPRB,4.0224E-04_JPRB,3.4538E-04_JPRB,2.8370E-04_JPRB,&
 & 2.1573E-04_JPRB,1.3763E-04_JPRB,8.4425E-02_JPRB/)  
KAO( :, 5,10, 5) = (/&
 & 5.3403E-04_JPRB,5.2047E-04_JPRB,4.8022E-04_JPRB,4.3074E-04_JPRB,3.7548E-04_JPRB,3.1365E-04_JPRB,&
 & 2.4302E-04_JPRB,1.6290E-04_JPRB,8.9982E-02_JPRB/)  
KAO( :, 1,11, 5) = (/&
 & 5.0375E-04_JPRB,4.5815E-04_JPRB,4.0474E-04_JPRB,3.4759E-04_JPRB,2.8717E-04_JPRB,2.2431E-04_JPRB,&
 & 1.5880E-04_JPRB,8.5670E-05_JPRB,1.2034E-01_JPRB/)  
KAO( :, 2,11, 5) = (/&
 & 5.0787E-04_JPRB,4.6747E-04_JPRB,4.1520E-04_JPRB,3.5802E-04_JPRB,2.9753E-04_JPRB,2.3416E-04_JPRB,&
 & 1.6914E-04_JPRB,9.5910E-05_JPRB,1.2557E-01_JPRB/)  
KAO( :, 3,11, 5) = (/&
 & 5.1316E-04_JPRB,4.7918E-04_JPRB,4.2800E-04_JPRB,3.7201E-04_JPRB,3.1196E-04_JPRB,2.4926E-04_JPRB,&
 & 1.8340E-04_JPRB,1.0921E-04_JPRB,1.3355E-01_JPRB/)  
KAO( :, 4,11, 5) = (/&
 & 5.2086E-04_JPRB,4.9333E-04_JPRB,4.4531E-04_JPRB,3.9163E-04_JPRB,3.3267E-04_JPRB,2.6993E-04_JPRB,&
 & 2.0215E-04_JPRB,1.2601E-04_JPRB,1.4382E-01_JPRB/)  
KAO( :, 5,11, 5) = (/&
 & 5.3248E-04_JPRB,5.1252E-04_JPRB,4.7016E-04_JPRB,4.1783E-04_JPRB,3.5976E-04_JPRB,2.9627E-04_JPRB,&
 & 2.2508E-04_JPRB,1.4674E-04_JPRB,1.5553E-01_JPRB/)  
KAO( :, 1,12, 5) = (/&
 & 4.8240E-04_JPRB,4.3715E-04_JPRB,3.8420E-04_JPRB,3.2860E-04_JPRB,2.7039E-04_JPRB,2.1019E-04_JPRB,&
 & 1.4796E-04_JPRB,8.0464E-05_JPRB,1.3884E-01_JPRB/)  
KAO( :, 2,12, 5) = (/&
 & 4.8661E-04_JPRB,4.4595E-04_JPRB,3.9410E-04_JPRB,3.3838E-04_JPRB,2.8030E-04_JPRB,2.1996E-04_JPRB,&
 & 1.5763E-04_JPRB,8.9327E-05_JPRB,1.4656E-01_JPRB/)  
KAO( :, 3,12, 5) = (/&
 & 4.9262E-04_JPRB,4.5710E-04_JPRB,4.0631E-04_JPRB,3.5229E-04_JPRB,2.9463E-04_JPRB,2.3404E-04_JPRB,&
 & 1.7076E-04_JPRB,1.0107E-04_JPRB,1.5747E-01_JPRB/)  
KAO( :, 4,12, 5) = (/&
 & 5.0100E-04_JPRB,4.7173E-04_JPRB,4.2405E-04_JPRB,3.7163E-04_JPRB,3.1400E-04_JPRB,2.5322E-04_JPRB,&
 & 1.8793E-04_JPRB,1.1578E-04_JPRB,1.7108E-01_JPRB/)  
KAO( :, 5,12, 5) = (/&
 & 5.1336E-04_JPRB,4.9148E-04_JPRB,4.4858E-04_JPRB,3.9659E-04_JPRB,3.3958E-04_JPRB,2.7759E-04_JPRB,&
 & 2.0885E-04_JPRB,1.3367E-04_JPRB,1.8676E-01_JPRB/)  
KAO( :, 1,13, 5) = (/&
 & 4.6582E-04_JPRB,4.2090E-04_JPRB,3.6844E-04_JPRB,3.1420E-04_JPRB,2.5774E-04_JPRB,1.9961E-04_JPRB,&
 & 1.4017E-04_JPRB,7.6735E-05_JPRB,1.3087E-01_JPRB/)  
KAO( :, 2,13, 5) = (/&
 & 4.7086E-04_JPRB,4.2959E-04_JPRB,3.7847E-04_JPRB,3.2415E-04_JPRB,2.6787E-04_JPRB,2.0968E-04_JPRB,&
 & 1.4924E-04_JPRB,8.4911E-05_JPRB,1.3959E-01_JPRB/)  
KAO( :, 3,13, 5) = (/&
 & 4.7837E-04_JPRB,4.4165E-04_JPRB,3.9141E-04_JPRB,3.3849E-04_JPRB,2.8244E-04_JPRB,2.2337E-04_JPRB,&
 & 1.6172E-04_JPRB,9.5329E-05_JPRB,1.5133E-01_JPRB/)  
KAO( :, 4,13, 5) = (/&
 & 4.8890E-04_JPRB,4.5706E-04_JPRB,4.0967E-04_JPRB,3.5806E-04_JPRB,3.0129E-04_JPRB,2.4154E-04_JPRB,&
 & 1.7785E-04_JPRB,1.0830E-04_JPRB,1.6573E-01_JPRB/)  
KAO( :, 5,13, 5) = (/&
 & 5.0378E-04_JPRB,4.7838E-04_JPRB,4.3426E-04_JPRB,3.8267E-04_JPRB,3.2585E-04_JPRB,2.6428E-04_JPRB,&
 & 1.9742E-04_JPRB,1.2409E-04_JPRB,1.8212E-01_JPRB/)  
KAO( :, 1, 1, 6) = (/&
 & 3.2508E-03_JPRB,2.9778E-03_JPRB,2.7444E-03_JPRB,2.4732E-03_JPRB,2.1617E-03_JPRB,1.8050E-03_JPRB,&
 & 1.4116E-03_JPRB,9.5646E-04_JPRB,7.5194E-04_JPRB/)  
KAO( :, 2, 1, 6) = (/&
 & 3.2951E-03_JPRB,3.0775E-03_JPRB,2.8725E-03_JPRB,2.6161E-03_JPRB,2.3021E-03_JPRB,1.9458E-03_JPRB,&
 & 1.5643E-03_JPRB,1.1089E-03_JPRB,9.5011E-04_JPRB/)  
KAO( :, 3, 1, 6) = (/&
 & 3.3739E-03_JPRB,3.2201E-03_JPRB,3.0329E-03_JPRB,2.7889E-03_JPRB,2.4684E-03_JPRB,2.1285E-03_JPRB,&
 & 1.7492E-03_JPRB,1.2948E-03_JPRB,1.1897E-03_JPRB/)  
KAO( :, 4, 1, 6) = (/&
 & 3.4775E-03_JPRB,3.3896E-03_JPRB,3.2288E-03_JPRB,2.9832E-03_JPRB,2.6770E-03_JPRB,2.3508E-03_JPRB,&
 & 1.9685E-03_JPRB,1.5165E-03_JPRB,1.4693E-03_JPRB/)  
KAO( :, 5, 1, 6) = (/&
 & 3.6048E-03_JPRB,3.5835E-03_JPRB,3.4508E-03_JPRB,3.2113E-03_JPRB,2.9250E-03_JPRB,2.6127E-03_JPRB,&
 & 2.2307E-03_JPRB,1.7682E-03_JPRB,1.7887E-03_JPRB/)  
KAO( :, 1, 2, 6) = (/&
 & 2.9479E-03_JPRB,2.7010E-03_JPRB,2.4920E-03_JPRB,2.2328E-03_JPRB,1.9390E-03_JPRB,1.6094E-03_JPRB,&
 & 1.2398E-03_JPRB,8.2486E-04_JPRB,7.2631E-04_JPRB/)  
KAO( :, 2, 2, 6) = (/&
 & 2.9968E-03_JPRB,2.8020E-03_JPRB,2.6127E-03_JPRB,2.3636E-03_JPRB,2.0690E-03_JPRB,1.7351E-03_JPRB,&
 & 1.3731E-03_JPRB,9.5550E-04_JPRB,9.1418E-04_JPRB/)  
KAO( :, 3, 2, 6) = (/&
 & 3.0736E-03_JPRB,2.9425E-03_JPRB,2.7649E-03_JPRB,2.5241E-03_JPRB,2.2257E-03_JPRB,1.8987E-03_JPRB,&
 & 1.5376E-03_JPRB,1.1187E-03_JPRB,1.1471E-03_JPRB/)  
KAO( :, 4, 2, 6) = (/&
 & 3.1728E-03_JPRB,3.1058E-03_JPRB,2.9466E-03_JPRB,2.7114E-03_JPRB,2.4176E-03_JPRB,2.0996E-03_JPRB,&
 & 1.7359E-03_JPRB,1.3160E-03_JPRB,1.4227E-03_JPRB/)  
KAO( :, 5, 2, 6) = (/&
 & 3.2938E-03_JPRB,3.2890E-03_JPRB,3.1552E-03_JPRB,2.9263E-03_JPRB,2.6481E-03_JPRB,2.3331E-03_JPRB,&
 & 1.9715E-03_JPRB,1.5406E-03_JPRB,1.7422E-03_JPRB/)  
KAO( :, 1, 3, 6) = (/&
 & 2.6363E-03_JPRB,2.4111E-03_JPRB,2.2160E-03_JPRB,1.9706E-03_JPRB,1.6942E-03_JPRB,1.3925E-03_JPRB,&
 & 1.0560E-03_JPRB,6.8807E-04_JPRB,8.1595E-04_JPRB/)  
KAO( :, 2, 3, 6) = (/&
 & 2.6810E-03_JPRB,2.5033E-03_JPRB,2.3265E-03_JPRB,2.0848E-03_JPRB,1.8107E-03_JPRB,1.5037E-03_JPRB,&
 & 1.1662E-03_JPRB,7.9613E-04_JPRB,9.9881E-04_JPRB/)  
KAO( :, 3, 3, 6) = (/&
 & 2.7498E-03_JPRB,2.6291E-03_JPRB,2.4618E-03_JPRB,2.2271E-03_JPRB,1.9564E-03_JPRB,1.6455E-03_JPRB,&
 & 1.3062E-03_JPRB,9.3309E-04_JPRB,1.2299E-03_JPRB/)  
KAO( :, 4, 3, 6) = (/&
 & 2.8378E-03_JPRB,2.7765E-03_JPRB,2.6213E-03_JPRB,2.3981E-03_JPRB,2.1275E-03_JPRB,1.8208E-03_JPRB,&
 & 1.4785E-03_JPRB,1.0978E-03_JPRB,1.5182E-03_JPRB/)  
KAO( :, 5, 3, 6) = (/&
 & 2.9436E-03_JPRB,2.9446E-03_JPRB,2.8064E-03_JPRB,2.5984E-03_JPRB,2.3329E-03_JPRB,2.0260E-03_JPRB,&
 & 1.6822E-03_JPRB,1.2888E-03_JPRB,1.8654E-03_JPRB/)  
KAO( :, 1, 4, 6) = (/&
 & 2.3305E-03_JPRB,2.1270E-03_JPRB,1.9394E-03_JPRB,1.7178E-03_JPRB,1.4629E-03_JPRB,1.1886E-03_JPRB,&
 & 8.9024E-04_JPRB,5.6452E-04_JPRB,1.0437E-03_JPRB/)  
KAO( :, 2, 4, 6) = (/&
 & 2.3711E-03_JPRB,2.2090E-03_JPRB,2.0410E-03_JPRB,1.8166E-03_JPRB,1.5629E-03_JPRB,1.2867E-03_JPRB,&
 & 9.8103E-04_JPRB,6.5250E-04_JPRB,1.2371E-03_JPRB/)  
KAO( :, 3, 4, 6) = (/&
 & 2.4284E-03_JPRB,2.3161E-03_JPRB,2.1600E-03_JPRB,1.9393E-03_JPRB,1.6907E-03_JPRB,1.4107E-03_JPRB,&
 & 1.0981E-03_JPRB,7.6618E-04_JPRB,1.4857E-03_JPRB/)  
KAO( :, 4, 4, 6) = (/&
 & 2.5037E-03_JPRB,2.4445E-03_JPRB,2.2974E-03_JPRB,2.0880E-03_JPRB,1.8467E-03_JPRB,1.5615E-03_JPRB,&
 & 1.2436E-03_JPRB,9.0463E-04_JPRB,1.7998E-03_JPRB/)  
KAO( :, 5, 4, 6) = (/&
 & 2.5974E-03_JPRB,2.5927E-03_JPRB,2.4566E-03_JPRB,2.2651E-03_JPRB,2.0287E-03_JPRB,1.7391E-03_JPRB,&
 & 1.4181E-03_JPRB,1.0646E-03_JPRB,2.1898E-03_JPRB/)  
KAO( :, 1, 5, 6) = (/&
 & 2.0361E-03_JPRB,1.8547E-03_JPRB,1.6766E-03_JPRB,1.4795E-03_JPRB,1.2501E-03_JPRB,1.0047E-03_JPRB,&
 & 7.4302E-04_JPRB,4.6057E-04_JPRB,1.3928E-03_JPRB/)  
KAO( :, 2, 5, 6) = (/&
 & 2.0694E-03_JPRB,1.9228E-03_JPRB,1.7645E-03_JPRB,1.5634E-03_JPRB,1.3341E-03_JPRB,1.0877E-03_JPRB,&
 & 8.2111E-04_JPRB,5.3228E-04_JPRB,1.6120E-03_JPRB/)  
KAO( :, 3, 5, 6) = (/&
 & 2.1184E-03_JPRB,2.0120E-03_JPRB,1.8652E-03_JPRB,1.6659E-03_JPRB,1.4419E-03_JPRB,1.1971E-03_JPRB,&
 & 9.1972E-04_JPRB,6.2395E-04_JPRB,1.9022E-03_JPRB/)  
KAO( :, 4, 5, 6) = (/&
 & 2.1844E-03_JPRB,2.1219E-03_JPRB,1.9833E-03_JPRB,1.7902E-03_JPRB,1.5765E-03_JPRB,1.3280E-03_JPRB,&
 & 1.0415E-03_JPRB,7.3888E-04_JPRB,2.2685E-03_JPRB/)  
KAO( :, 5, 5, 6) = (/&
 & 2.2663E-03_JPRB,2.2517E-03_JPRB,2.1217E-03_JPRB,1.9449E-03_JPRB,1.7373E-03_JPRB,1.4799E-03_JPRB,&
 & 1.1890E-03_JPRB,8.7483E-04_JPRB,2.7203E-03_JPRB/)  
KAO( :, 1, 6, 6) = (/&
 & 1.7550E-03_JPRB,1.5950E-03_JPRB,1.4324E-03_JPRB,1.2563E-03_JPRB,1.0568E-03_JPRB,8.4088E-04_JPRB,&
 & 6.1343E-04_JPRB,3.7218E-04_JPRB,1.8822E-03_JPRB/)  
KAO( :, 2, 6, 6) = (/&
 & 1.7806E-03_JPRB,1.6483E-03_JPRB,1.5014E-03_JPRB,1.3260E-03_JPRB,1.1237E-03_JPRB,9.0650E-04_JPRB,&
 & 6.7793E-04_JPRB,4.3012E-04_JPRB,2.1151E-03_JPRB/)  
KAO( :, 3, 6, 6) = (/&
 & 1.8227E-03_JPRB,1.7227E-03_JPRB,1.5844E-03_JPRB,1.4081E-03_JPRB,1.2080E-03_JPRB,9.9575E-04_JPRB,&
 & 7.6012E-04_JPRB,5.0351E-04_JPRB,2.4397E-03_JPRB/)  
KAO( :, 4, 6, 6) = (/&
 & 1.8792E-03_JPRB,1.8150E-03_JPRB,1.6849E-03_JPRB,1.5100E-03_JPRB,1.3192E-03_JPRB,1.1065E-03_JPRB,&
 & 8.6119E-04_JPRB,5.9588E-04_JPRB,2.8694E-03_JPRB/)  
KAO( :, 5, 6, 6) = (/&
 & 1.9487E-03_JPRB,1.9242E-03_JPRB,1.8033E-03_JPRB,1.6413E-03_JPRB,1.4558E-03_JPRB,1.2357E-03_JPRB,&
 & 9.8340E-04_JPRB,7.0882E-04_JPRB,3.4091E-03_JPRB/)  
KAO( :, 1, 7, 6) = (/&
 & 1.4965E-03_JPRB,1.3571E-03_JPRB,1.2126E-03_JPRB,1.0566E-03_JPRB,8.8614E-04_JPRB,7.0122E-04_JPRB,&
 & 5.0618E-04_JPRB,3.0014E-04_JPRB,2.8627E-03_JPRB/)  
KAO( :, 2, 7, 6) = (/&
 & 1.5173E-03_JPRB,1.3996E-03_JPRB,1.2672E-03_JPRB,1.1141E-03_JPRB,9.3989E-04_JPRB,7.5155E-04_JPRB,&
 & 5.5619E-04_JPRB,3.4628E-04_JPRB,3.1242E-03_JPRB/)  
KAO( :, 3, 7, 6) = (/&
 & 1.5535E-03_JPRB,1.4627E-03_JPRB,1.3365E-03_JPRB,1.1831E-03_JPRB,1.0064E-03_JPRB,8.2131E-04_JPRB,&
 & 6.2417E-04_JPRB,4.0465E-04_JPRB,3.4941E-03_JPRB/)  
KAO( :, 4, 7, 6) = (/&
 & 1.6022E-03_JPRB,1.5406E-03_JPRB,1.4217E-03_JPRB,1.2670E-03_JPRB,1.0965E-03_JPRB,9.1271E-04_JPRB,&
 & 7.0644E-04_JPRB,4.7877E-04_JPRB,3.9901E-03_JPRB/)  
KAO( :, 5, 7, 6) = (/&
 & 1.6619E-03_JPRB,1.6316E-03_JPRB,1.5215E-03_JPRB,1.3760E-03_JPRB,1.2105E-03_JPRB,1.0220E-03_JPRB,&
 & 8.0646E-04_JPRB,5.7116E-04_JPRB,4.6499E-03_JPRB/)  
KAO( :, 1, 8, 6) = (/&
 & 1.2713E-03_JPRB,1.1506E-03_JPRB,1.0229E-03_JPRB,8.8637E-04_JPRB,7.3985E-04_JPRB,5.8404E-04_JPRB,&
 & 4.1869E-04_JPRB,2.4146E-04_JPRB,5.8577E-03_JPRB/)  
KAO( :, 2, 8, 6) = (/&
 & 1.2886E-03_JPRB,1.1855E-03_JPRB,1.0667E-03_JPRB,9.3200E-04_JPRB,7.8398E-04_JPRB,6.2296E-04_JPRB,&
 & 4.5565E-04_JPRB,2.7881E-04_JPRB,6.2369E-03_JPRB/)  
KAO( :, 3, 8, 6) = (/&
 & 1.3186E-03_JPRB,1.2381E-03_JPRB,1.1243E-03_JPRB,9.9079E-04_JPRB,8.3814E-04_JPRB,6.7723E-04_JPRB,&
 & 5.1049E-04_JPRB,3.2546E-04_JPRB,6.7543E-03_JPRB/)  
KAO( :, 4, 8, 6) = (/&
 & 1.3600E-03_JPRB,1.3028E-03_JPRB,1.1954E-03_JPRB,1.0612E-03_JPRB,9.1150E-04_JPRB,7.5260E-04_JPRB,&
 & 5.7914E-04_JPRB,3.8472E-04_JPRB,7.4388E-03_JPRB/)  
KAO( :, 5, 8, 6) = (/&
 & 1.4121E-03_JPRB,1.3805E-03_JPRB,1.2804E-03_JPRB,1.1524E-03_JPRB,1.0064E-03_JPRB,8.4434E-04_JPRB,&
 & 6.6144E-04_JPRB,4.5882E-04_JPRB,8.3420E-03_JPRB/)  
KAO( :, 1, 9, 6) = (/&
 & 1.0717E-03_JPRB,9.6880E-04_JPRB,8.5692E-04_JPRB,7.3841E-04_JPRB,6.1349E-04_JPRB,4.8265E-04_JPRB,&
 & 3.4488E-04_JPRB,1.9332E-04_JPRB,2.4273E-02_JPRB/)  
KAO( :, 2, 9, 6) = (/&
 & 1.0856E-03_JPRB,9.9623E-04_JPRB,8.9079E-04_JPRB,7.7337E-04_JPRB,6.4809E-04_JPRB,5.1388E-04_JPRB,&
 & 3.7203E-04_JPRB,2.2290E-04_JPRB,2.5642E-02_JPRB/)  
KAO( :, 3, 9, 6) = (/&
 & 1.1096E-03_JPRB,1.0377E-03_JPRB,9.3686E-04_JPRB,8.2124E-04_JPRB,6.9314E-04_JPRB,5.5575E-04_JPRB,&
 & 4.1434E-04_JPRB,2.5972E-04_JPRB,2.7416E-02_JPRB/)  
KAO( :, 4, 9, 6) = (/&
 & 1.1443E-03_JPRB,1.0913E-03_JPRB,9.9449E-04_JPRB,8.7964E-04_JPRB,7.5151E-04_JPRB,6.1540E-04_JPRB,&
 & 4.6972E-04_JPRB,3.0675E-04_JPRB,2.9667E-02_JPRB/)  
KAO( :, 5, 9, 6) = (/&
 & 1.1902E-03_JPRB,1.1571E-03_JPRB,1.0659E-03_JPRB,9.5531E-04_JPRB,8.2901E-04_JPRB,6.9019E-04_JPRB,&
 & 5.3796E-04_JPRB,3.6567E-04_JPRB,3.2492E-02_JPRB/)  
KAO( :, 1,10, 6) = (/&
 & 9.1682E-04_JPRB,8.2727E-04_JPRB,7.2786E-04_JPRB,6.2407E-04_JPRB,5.1616E-04_JPRB,4.0448E-04_JPRB,&
 & 2.8759E-04_JPRB,1.5707E-04_JPRB,1.2096E-01_JPRB/)  
KAO( :, 2,10, 6) = (/&
 & 9.2807E-04_JPRB,8.4772E-04_JPRB,7.5273E-04_JPRB,6.4976E-04_JPRB,5.4191E-04_JPRB,4.2868E-04_JPRB,&
 & 3.0799E-04_JPRB,1.8018E-04_JPRB,1.2769E-01_JPRB/)  
KAO( :, 3,10, 6) = (/&
 & 9.4733E-04_JPRB,8.8010E-04_JPRB,7.8844E-04_JPRB,6.8649E-04_JPRB,5.7756E-04_JPRB,4.6108E-04_JPRB,&
 & 3.3990E-04_JPRB,2.0965E-04_JPRB,1.3587E-01_JPRB/)  
KAO( :, 4,10, 6) = (/&
 & 9.7616E-04_JPRB,9.2298E-04_JPRB,8.3457E-04_JPRB,7.3405E-04_JPRB,6.2454E-04_JPRB,5.0775E-04_JPRB,&
 & 3.8366E-04_JPRB,2.4715E-04_JPRB,1.4598E-01_JPRB/)  
KAO( :, 5,10, 6) = (/&
 & 1.0147E-03_JPRB,9.7749E-04_JPRB,8.9296E-04_JPRB,7.9678E-04_JPRB,6.8754E-04_JPRB,5.6799E-04_JPRB,&
 & 4.3982E-04_JPRB,2.9475E-04_JPRB,1.5853E-01_JPRB/)  
KAO( :, 1,11, 6) = (/&
 & 8.5061E-04_JPRB,7.6545E-04_JPRB,6.7209E-04_JPRB,5.7435E-04_JPRB,4.7342E-04_JPRB,3.6961E-04_JPRB,&
 & 2.6119E-04_JPRB,1.4392E-04_JPRB,2.1829E-01_JPRB/)  
KAO( :, 2,11, 6) = (/&
 & 8.6223E-04_JPRB,7.8453E-04_JPRB,6.9368E-04_JPRB,5.9640E-04_JPRB,4.9523E-04_JPRB,3.8977E-04_JPRB,&
 & 2.7888E-04_JPRB,1.6251E-04_JPRB,2.3198E-01_JPRB/)  
KAO( :, 3,11, 6) = (/&
 & 8.8180E-04_JPRB,8.1321E-04_JPRB,7.2410E-04_JPRB,6.2697E-04_JPRB,5.2544E-04_JPRB,4.1867E-04_JPRB,&
 & 3.0656E-04_JPRB,1.8726E-04_JPRB,2.4754E-01_JPRB/)  
KAO( :, 4,11, 6) = (/&
 & 9.0901E-04_JPRB,8.5074E-04_JPRB,7.6319E-04_JPRB,6.6771E-04_JPRB,5.6719E-04_JPRB,4.5846E-04_JPRB,&
 & 3.4374E-04_JPRB,2.1942E-04_JPRB,2.6580E-01_JPRB/)  
KAO( :, 5,11, 6) = (/&
 & 9.4336E-04_JPRB,8.9780E-04_JPRB,8.1395E-04_JPRB,7.2298E-04_JPRB,6.2010E-04_JPRB,5.0948E-04_JPRB,&
 & 3.9195E-04_JPRB,2.5983E-04_JPRB,2.8833E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART5',0,ZHOOK_HANDLE)


KAO( :, 1,12, 6) = (/&
 & 8.0200E-04_JPRB,7.2122E-04_JPRB,6.3265E-04_JPRB,5.3924E-04_JPRB,4.4340E-04_JPRB,3.4532E-04_JPRB,&
 & 2.4304E-04_JPRB,1.3437E-04_JPRB,2.6966E-01_JPRB/)  
KAO( :, 2,12, 6) = (/&
 & 8.1599E-04_JPRB,7.4215E-04_JPRB,6.5450E-04_JPRB,5.6136E-04_JPRB,4.6493E-04_JPRB,3.6523E-04_JPRB,&
 & 2.6103E-04_JPRB,1.5096E-04_JPRB,2.8948E-01_JPRB/)  
KAO( :, 3,12, 6) = (/&
 & 8.3783E-04_JPRB,7.7160E-04_JPRB,6.8467E-04_JPRB,5.9130E-04_JPRB,4.9479E-04_JPRB,3.9390E-04_JPRB,&
 & 2.8643E-04_JPRB,1.7267E-04_JPRB,3.1014E-01_JPRB/)  
KAO( :, 4,12, 6) = (/&
 & 8.6812E-04_JPRB,8.0949E-04_JPRB,7.2339E-04_JPRB,6.3152E-04_JPRB,5.3506E-04_JPRB,4.2989E-04_JPRB,&
 & 3.1937E-04_JPRB,2.0004E-04_JPRB,3.3406E-01_JPRB/)  
KAO( :, 5,12, 6) = (/&
 & 9.0435E-04_JPRB,8.5462E-04_JPRB,7.7208E-04_JPRB,6.8293E-04_JPRB,5.8297E-04_JPRB,4.7540E-04_JPRB,&
 & 3.6088E-04_JPRB,2.3381E-04_JPRB,3.6313E-01_JPRB/)  
KAO( :, 1,13, 6) = (/&
 & 7.8053E-04_JPRB,7.0155E-04_JPRB,6.1461E-04_JPRB,5.2266E-04_JPRB,4.2870E-04_JPRB,3.3288E-04_JPRB,&
 & 2.3333E-04_JPRB,1.2902E-04_JPRB,2.6881E-01_JPRB/)  
KAO( :, 2,13, 6) = (/&
 & 7.9882E-04_JPRB,7.2653E-04_JPRB,6.3912E-04_JPRB,5.4681E-04_JPRB,4.5162E-04_JPRB,3.5376E-04_JPRB,&
 & 2.5204E-04_JPRB,1.4416E-04_JPRB,2.9113E-01_JPRB/)  
KAO( :, 3,13, 6) = (/&
 & 8.2403E-04_JPRB,7.5779E-04_JPRB,6.7018E-04_JPRB,5.7745E-04_JPRB,4.8198E-04_JPRB,3.8252E-04_JPRB,&
 & 2.7644E-04_JPRB,1.6449E-04_JPRB,3.1399E-01_JPRB/)  
KAO( :, 4,13, 6) = (/&
 & 8.5594E-04_JPRB,7.9631E-04_JPRB,7.0954E-04_JPRB,6.1806E-04_JPRB,5.2193E-04_JPRB,4.1790E-04_JPRB,&
 & 3.0801E-04_JPRB,1.8991E-04_JPRB,3.3908E-01_JPRB/)  
KAO( :, 5,13, 6) = (/&
 & 8.9284E-04_JPRB,8.4070E-04_JPRB,7.5811E-04_JPRB,6.6820E-04_JPRB,5.6955E-04_JPRB,4.6197E-04_JPRB,&
 & 3.4688E-04_JPRB,2.2019E-04_JPRB,3.6894E-01_JPRB/)  
KAO( :, 1, 1, 7) = (/&
 & 6.0831E-03_JPRB,5.4716E-03_JPRB,4.8761E-03_JPRB,4.3169E-03_JPRB,3.7156E-03_JPRB,3.0689E-03_JPRB,&
 & 2.3667E-03_JPRB,1.5757E-03_JPRB,1.3430E-03_JPRB/)  
KAO( :, 2, 1, 7) = (/&
 & 6.2160E-03_JPRB,5.6592E-03_JPRB,5.1333E-03_JPRB,4.5937E-03_JPRB,3.9991E-03_JPRB,3.3587E-03_JPRB,&
 & 2.6257E-03_JPRB,1.8103E-03_JPRB,1.6552E-03_JPRB/)  
KAO( :, 3, 1, 7) = (/&
 & 6.3763E-03_JPRB,5.8806E-03_JPRB,5.4307E-03_JPRB,4.8990E-03_JPRB,4.3331E-03_JPRB,3.6723E-03_JPRB,&
 & 2.9252E-03_JPRB,2.0812E-03_JPRB,2.0370E-03_JPRB/)  
KAO( :, 4, 1, 7) = (/&
 & 6.5762E-03_JPRB,6.1595E-03_JPRB,5.7556E-03_JPRB,5.2564E-03_JPRB,4.6989E-03_JPRB,4.0150E-03_JPRB,&
 & 3.2758E-03_JPRB,2.3980E-03_JPRB,2.4986E-03_JPRB/)  
KAO( :, 5, 1, 7) = (/&
 & 6.8177E-03_JPRB,6.4963E-03_JPRB,6.1231E-03_JPRB,5.6619E-03_JPRB,5.0935E-03_JPRB,4.4057E-03_JPRB,&
 & 3.6750E-03_JPRB,2.7782E-03_JPRB,3.0517E-03_JPRB/)  
KAO( :, 1, 2, 7) = (/&
 & 5.5406E-03_JPRB,4.9770E-03_JPRB,4.4333E-03_JPRB,3.9291E-03_JPRB,3.3714E-03_JPRB,2.7757E-03_JPRB,&
 & 2.1410E-03_JPRB,1.4066E-03_JPRB,1.3940E-03_JPRB/)  
KAO( :, 2, 2, 7) = (/&
 & 5.6795E-03_JPRB,5.1605E-03_JPRB,4.6810E-03_JPRB,4.1841E-03_JPRB,3.6317E-03_JPRB,3.0411E-03_JPRB,&
 & 2.3785E-03_JPRB,1.6219E-03_JPRB,1.7125E-03_JPRB/)  
KAO( :, 3, 2, 7) = (/&
 & 5.8479E-03_JPRB,5.3775E-03_JPRB,4.9639E-03_JPRB,4.4697E-03_JPRB,3.9362E-03_JPRB,3.3371E-03_JPRB,&
 & 2.6519E-03_JPRB,1.8755E-03_JPRB,2.0935E-03_JPRB/)  
KAO( :, 4, 2, 7) = (/&
 & 6.0553E-03_JPRB,5.6506E-03_JPRB,5.2744E-03_JPRB,4.7999E-03_JPRB,4.2764E-03_JPRB,3.6617E-03_JPRB,&
 & 2.9719E-03_JPRB,2.1746E-03_JPRB,2.5431E-03_JPRB/)  
KAO( :, 5, 2, 7) = (/&
 & 6.2994E-03_JPRB,5.9802E-03_JPRB,5.6290E-03_JPRB,5.1787E-03_JPRB,4.6510E-03_JPRB,4.0342E-03_JPRB,&
 & 3.3435E-03_JPRB,2.5279E-03_JPRB,3.0760E-03_JPRB/)  
KAO( :, 1, 3, 7) = (/&
 & 4.9647E-03_JPRB,4.4497E-03_JPRB,3.9602E-03_JPRB,3.5016E-03_JPRB,2.9975E-03_JPRB,2.4522E-03_JPRB,&
 & 1.8688E-03_JPRB,1.2052E-03_JPRB,1.6686E-03_JPRB/)  
KAO( :, 2, 3, 7) = (/&
 & 5.0999E-03_JPRB,4.6210E-03_JPRB,4.1813E-03_JPRB,3.7355E-03_JPRB,3.2261E-03_JPRB,2.6792E-03_JPRB,&
 & 2.0838E-03_JPRB,1.3908E-03_JPRB,2.0388E-03_JPRB/)  
KAO( :, 3, 3, 7) = (/&
 & 5.2679E-03_JPRB,4.8293E-03_JPRB,4.4423E-03_JPRB,3.9951E-03_JPRB,3.4860E-03_JPRB,2.9419E-03_JPRB,&
 & 2.3248E-03_JPRB,1.6141E-03_JPRB,2.4914E-03_JPRB/)  
KAO( :, 4, 3, 7) = (/&
 & 5.4762E-03_JPRB,5.0914E-03_JPRB,4.7365E-03_JPRB,4.2903E-03_JPRB,3.7907E-03_JPRB,3.2409E-03_JPRB,&
 & 2.6074E-03_JPRB,1.8823E-03_JPRB,3.0282E-03_JPRB/)  
KAO( :, 5, 3, 7) = (/&
 & 5.7173E-03_JPRB,5.4006E-03_JPRB,5.0668E-03_JPRB,4.6277E-03_JPRB,4.1360E-03_JPRB,3.5816E-03_JPRB,&
 & 2.9410E-03_JPRB,2.2019E-03_JPRB,3.6468E-03_JPRB/)  
KAO( :, 1, 4, 7) = (/&
 & 4.4058E-03_JPRB,3.9416E-03_JPRB,3.5104E-03_JPRB,3.0879E-03_JPRB,2.6418E-03_JPRB,2.1472E-03_JPRB,&
 & 1.6100E-03_JPRB,1.0192E-03_JPRB,2.1860E-03_JPRB/)  
KAO( :, 2, 4, 7) = (/&
 & 4.5309E-03_JPRB,4.0974E-03_JPRB,3.7008E-03_JPRB,3.2995E-03_JPRB,2.8437E-03_JPRB,2.3378E-03_JPRB,&
 & 1.7928E-03_JPRB,1.1728E-03_JPRB,2.6265E-03_JPRB/)  
KAO( :, 3, 4, 7) = (/&
 & 4.6961E-03_JPRB,4.2954E-03_JPRB,3.9392E-03_JPRB,3.5397E-03_JPRB,3.0713E-03_JPRB,2.5630E-03_JPRB,&
 & 2.0061E-03_JPRB,1.3611E-03_JPRB,3.1721E-03_JPRB/)  
KAO( :, 4, 4, 7) = (/&
 & 4.8988E-03_JPRB,4.5465E-03_JPRB,4.2146E-03_JPRB,3.8097E-03_JPRB,3.3355E-03_JPRB,2.8256E-03_JPRB,&
 & 2.2535E-03_JPRB,1.5915E-03_JPRB,3.8341E-03_JPRB/)  
KAO( :, 5, 4, 7) = (/&
 & 5.1310E-03_JPRB,4.8388E-03_JPRB,4.5280E-03_JPRB,4.1140E-03_JPRB,3.6446E-03_JPRB,3.1343E-03_JPRB,&
 & 2.5481E-03_JPRB,1.8697E-03_JPRB,4.6238E-03_JPRB/)  
KAO( :, 1, 5, 7) = (/&
 & 3.8779E-03_JPRB,3.4634E-03_JPRB,3.0842E-03_JPRB,2.6949E-03_JPRB,2.2979E-03_JPRB,1.8588E-03_JPRB,&
 & 1.3777E-03_JPRB,8.5534E-04_JPRB,2.9342E-03_JPRB/)  
KAO( :, 2, 5, 7) = (/&
 & 3.9975E-03_JPRB,3.6104E-03_JPRB,3.2535E-03_JPRB,2.8827E-03_JPRB,2.4794E-03_JPRB,2.0228E-03_JPRB,&
 & 1.5286E-03_JPRB,9.8435E-04_JPRB,3.4742E-03_JPRB/)  
KAO( :, 3, 5, 7) = (/&
 & 4.1529E-03_JPRB,3.7986E-03_JPRB,3.4711E-03_JPRB,3.1033E-03_JPRB,2.6811E-03_JPRB,2.2132E-03_JPRB,&
 & 1.7129E-03_JPRB,1.1425E-03_JPRB,4.1273E-03_JPRB/)  
KAO( :, 4, 5, 7) = (/&
 & 4.3432E-03_JPRB,4.0329E-03_JPRB,3.7255E-03_JPRB,3.3556E-03_JPRB,2.9159E-03_JPRB,2.4433E-03_JPRB,&
 & 1.9336E-03_JPRB,1.3357E-03_JPRB,4.9170E-03_JPRB/)  
KAO( :, 5, 5, 7) = (/&
 & 4.5622E-03_JPRB,4.3036E-03_JPRB,4.0154E-03_JPRB,3.6360E-03_JPRB,3.1929E-03_JPRB,2.7222E-03_JPRB,&
 & 2.1936E-03_JPRB,1.5699E-03_JPRB,5.8667E-03_JPRB/)  
KAO( :, 1, 6, 7) = (/&
 & 3.3589E-03_JPRB,2.9956E-03_JPRB,2.6626E-03_JPRB,2.3138E-03_JPRB,1.9609E-03_JPRB,1.5811E-03_JPRB,&
 & 1.1611E-03_JPRB,7.0395E-04_JPRB,3.8423E-03_JPRB/)  
KAO( :, 2, 6, 7) = (/&
 & 3.4759E-03_JPRB,3.1375E-03_JPRB,2.8167E-03_JPRB,2.4801E-03_JPRB,2.1214E-03_JPRB,1.7215E-03_JPRB,&
 & 1.2829E-03_JPRB,8.1184E-04_JPRB,4.5185E-03_JPRB/)  
KAO( :, 3, 6, 7) = (/&
 & 3.6242E-03_JPRB,3.3148E-03_JPRB,3.0137E-03_JPRB,2.6792E-03_JPRB,2.3068E-03_JPRB,1.8847E-03_JPRB,&
 & 1.4366E-03_JPRB,9.4529E-04_JPRB,5.3431E-03_JPRB/)  
KAO( :, 4, 6, 7) = (/&
 & 3.8024E-03_JPRB,3.5303E-03_JPRB,3.2447E-03_JPRB,2.9079E-03_JPRB,2.5158E-03_JPRB,2.0837E-03_JPRB,&
 & 1.6281E-03_JPRB,1.1078E-03_JPRB,6.3321E-03_JPRB/)  
KAO( :, 5, 6, 7) = (/&
 & 4.0032E-03_JPRB,3.7796E-03_JPRB,3.5066E-03_JPRB,3.1648E-03_JPRB,2.7620E-03_JPRB,2.3300E-03_JPRB,&
 & 1.8584E-03_JPRB,1.3026E-03_JPRB,7.5117E-03_JPRB/)  
KAO( :, 1, 7, 7) = (/&
 & 2.8830E-03_JPRB,2.5691E-03_JPRB,2.2767E-03_JPRB,1.9708E-03_JPRB,1.6569E-03_JPRB,1.3271E-03_JPRB,&
 & 9.6810E-04_JPRB,5.7391E-04_JPRB,5.4404E-03_JPRB/)  
KAO( :, 2, 7, 7) = (/&
 & 2.9931E-03_JPRB,2.7018E-03_JPRB,2.4141E-03_JPRB,2.1144E-03_JPRB,1.7953E-03_JPRB,1.4497E-03_JPRB,&
 & 1.0681E-03_JPRB,6.6067E-04_JPRB,6.3234E-03_JPRB/)  
KAO( :, 3, 7, 7) = (/&
 & 3.1305E-03_JPRB,2.8628E-03_JPRB,2.5899E-03_JPRB,2.2886E-03_JPRB,1.9605E-03_JPRB,1.5922E-03_JPRB,&
 & 1.1949E-03_JPRB,7.7319E-04_JPRB,7.4384E-03_JPRB/)  
KAO( :, 4, 7, 7) = (/&
 & 3.2919E-03_JPRB,3.0575E-03_JPRB,2.7962E-03_JPRB,2.4931E-03_JPRB,2.1505E-03_JPRB,1.7657E-03_JPRB,&
 & 1.3594E-03_JPRB,9.0965E-04_JPRB,8.7978E-03_JPRB/)  
KAO( :, 5, 7, 7) = (/&
 & 3.4715E-03_JPRB,3.2809E-03_JPRB,3.0291E-03_JPRB,2.7241E-03_JPRB,2.3709E-03_JPRB,1.9816E-03_JPRB,&
 & 1.5601E-03_JPRB,1.0736E-03_JPRB,1.0416E-02_JPRB/)  
KAO( :, 1, 8, 7) = (/&
 & 2.4760E-03_JPRB,2.2062E-03_JPRB,1.9505E-03_JPRB,1.6811E-03_JPRB,1.4033E-03_JPRB,1.1135E-03_JPRB,&
 & 8.0567E-04_JPRB,4.6971E-04_JPRB,1.0033E-02_JPRB/)  
KAO( :, 2, 8, 7) = (/&
 & 2.5766E-03_JPRB,2.3254E-03_JPRB,2.0701E-03_JPRB,1.8033E-03_JPRB,1.5196E-03_JPRB,1.2179E-03_JPRB,&
 & 8.9015E-04_JPRB,5.3726E-04_JPRB,1.1309E-02_JPRB/)  
KAO( :, 3, 8, 7) = (/&
 & 2.7010E-03_JPRB,2.4689E-03_JPRB,2.2239E-03_JPRB,1.9529E-03_JPRB,1.6624E-03_JPRB,1.3434E-03_JPRB,&
 & 9.9513E-04_JPRB,6.2989E-04_JPRB,1.3008E-02_JPRB/)  
KAO( :, 4, 8, 7) = (/&
 & 2.8429E-03_JPRB,2.6411E-03_JPRB,2.4042E-03_JPRB,2.1312E-03_JPRB,1.8298E-03_JPRB,1.4940E-03_JPRB,&
 & 1.1345E-03_JPRB,7.4505E-04_JPRB,1.5177E-02_JPRB/)  
KAO( :, 5, 8, 7) = (/&
 & 2.9996E-03_JPRB,2.8348E-03_JPRB,2.6056E-03_JPRB,2.3332E-03_JPRB,2.0258E-03_JPRB,1.6825E-03_JPRB,&
 & 1.3078E-03_JPRB,8.8471E-04_JPRB,1.7852E-02_JPRB/)  
KAO( :, 1, 9, 7) = (/&
 & 2.1045E-03_JPRB,1.8749E-03_JPRB,1.6563E-03_JPRB,1.4213E-03_JPRB,1.1793E-03_JPRB,9.2862E-04_JPRB,&
 & 6.6550E-04_JPRB,3.8300E-04_JPRB,4.0779E-02_JPRB/)  
KAO( :, 2, 9, 7) = (/&
 & 2.1941E-03_JPRB,1.9801E-03_JPRB,1.7595E-03_JPRB,1.5250E-03_JPRB,1.2768E-03_JPRB,1.0150E-03_JPRB,&
 & 7.3680E-04_JPRB,4.3556E-04_JPRB,4.4180E-02_JPRB/)  
KAO( :, 3, 9, 7) = (/&
 & 2.3035E-03_JPRB,2.1066E-03_JPRB,1.8914E-03_JPRB,1.6530E-03_JPRB,1.3964E-03_JPRB,1.1220E-03_JPRB,&
 & 8.2430E-04_JPRB,5.1028E-04_JPRB,4.8665E-02_JPRB/)  
KAO( :, 4, 9, 7) = (/&
 & 2.4266E-03_JPRB,2.2548E-03_JPRB,2.0445E-03_JPRB,1.8037E-03_JPRB,1.5398E-03_JPRB,1.2522E-03_JPRB,&
 & 9.4060E-04_JPRB,6.0474E-04_JPRB,5.4418E-02_JPRB/)  
KAO( :, 5, 9, 7) = (/&
 & 2.5648E-03_JPRB,2.4232E-03_JPRB,2.2170E-03_JPRB,1.9746E-03_JPRB,1.7066E-03_JPRB,1.4131E-03_JPRB,&
 & 1.0872E-03_JPRB,7.2231E-04_JPRB,6.1744E-02_JPRB/)  
KAO( :, 1,10, 7) = (/&
 & 1.7736E-03_JPRB,1.5819E-03_JPRB,1.3957E-03_JPRB,1.1944E-03_JPRB,9.8623E-04_JPRB,7.7163E-04_JPRB,&
 & 5.4898E-04_JPRB,3.1298E-04_JPRB,2.1288E-01_JPRB/)  
KAO( :, 2,10, 7) = (/&
 & 1.8520E-03_JPRB,1.6738E-03_JPRB,1.4851E-03_JPRB,1.2823E-03_JPRB,1.0679E-03_JPRB,8.4345E-04_JPRB,&
 & 6.0874E-04_JPRB,3.5579E-04_JPRB,2.2960E-01_JPRB/)  
KAO( :, 3,10, 7) = (/&
 & 1.9439E-03_JPRB,1.7818E-03_JPRB,1.5963E-03_JPRB,1.3903E-03_JPRB,1.1685E-03_JPRB,9.3435E-04_JPRB,&
 & 6.8422E-04_JPRB,4.1671E-04_JPRB,2.4868E-01_JPRB/)  
KAO( :, 4,10, 7) = (/&
 & 2.0519E-03_JPRB,1.9108E-03_JPRB,1.7263E-03_JPRB,1.5165E-03_JPRB,1.2885E-03_JPRB,1.0455E-03_JPRB,&
 & 7.8283E-04_JPRB,4.9584E-04_JPRB,2.7032E-01_JPRB/)  
KAO( :, 5,10, 7) = (/&
 & 2.1743E-03_JPRB,2.0588E-03_JPRB,1.8772E-03_JPRB,1.6640E-03_JPRB,1.4326E-03_JPRB,1.1843E-03_JPRB,&
 & 9.0587E-04_JPRB,5.9427E-04_JPRB,2.9596E-01_JPRB/)  
KAO( :, 1,11, 7) = (/&
 & 1.5501E-03_JPRB,1.3901E-03_JPRB,1.2238E-03_JPRB,1.0457E-03_JPRB,8.6223E-04_JPRB,6.7257E-04_JPRB,&
 & 4.7782E-04_JPRB,2.7194E-04_JPRB,4.0190E-01_JPRB/)  
KAO( :, 2,11, 7) = (/&
 & 1.6161E-03_JPRB,1.4686E-03_JPRB,1.3022E-03_JPRB,1.1228E-03_JPRB,9.3349E-04_JPRB,7.3693E-04_JPRB,&
 & 5.3209E-04_JPRB,3.1210E-04_JPRB,4.3586E-01_JPRB/)  
KAO( :, 3,11, 7) = (/&
 & 1.6959E-03_JPRB,1.5640E-03_JPRB,1.3990E-03_JPRB,1.2156E-03_JPRB,1.0204E-03_JPRB,8.1637E-04_JPRB,&
 & 6.0174E-04_JPRB,3.6844E-04_JPRB,4.7353E-01_JPRB/)  
KAO( :, 4,11, 7) = (/&
 & 1.7905E-03_JPRB,1.6788E-03_JPRB,1.5149E-03_JPRB,1.3282E-03_JPRB,1.1282E-03_JPRB,9.1912E-04_JPRB,&
 & 6.9230E-04_JPRB,4.4075E-04_JPRB,5.1437E-01_JPRB/)  
KAO( :, 5,11, 7) = (/&
 & 1.8993E-03_JPRB,1.8110E-03_JPRB,1.6496E-03_JPRB,1.4619E-03_JPRB,1.2633E-03_JPRB,1.0482E-03_JPRB,&
 & 8.0399E-04_JPRB,5.3153E-04_JPRB,5.6007E-01_JPRB/)  
KAO( :, 1,12, 7) = (/&
 & 1.4337E-03_JPRB,1.2858E-03_JPRB,1.1285E-03_JPRB,9.6281E-04_JPRB,7.9113E-04_JPRB,6.1463E-04_JPRB,&
 & 4.3486E-04_JPRB,2.4590E-04_JPRB,5.1560E-01_JPRB/)  
KAO( :, 2,12, 7) = (/&
 & 1.4907E-03_JPRB,1.3522E-03_JPRB,1.1952E-03_JPRB,1.0259E-03_JPRB,8.4928E-04_JPRB,6.6742E-04_JPRB,&
 & 4.8034E-04_JPRB,2.8126E-04_JPRB,5.6136E-01_JPRB/)  
KAO( :, 3,12, 7) = (/&
 & 1.5589E-03_JPRB,1.4349E-03_JPRB,1.2778E-03_JPRB,1.1050E-03_JPRB,9.2336E-04_JPRB,7.3586E-04_JPRB,&
 & 5.4130E-04_JPRB,3.2994E-04_JPRB,6.1298E-01_JPRB/)  
KAO( :, 4,12, 7) = (/&
 & 1.6374E-03_JPRB,1.5317E-03_JPRB,1.3749E-03_JPRB,1.1997E-03_JPRB,1.0160E-03_JPRB,8.2656E-04_JPRB,&
 & 6.2085E-04_JPRB,3.9394E-04_JPRB,6.6802E-01_JPRB/)  
KAO( :, 5,12, 7) = (/&
 & 1.7281E-03_JPRB,1.6427E-03_JPRB,1.4888E-03_JPRB,1.3162E-03_JPRB,1.1355E-03_JPRB,9.3878E-04_JPRB,&
 & 7.1928E-04_JPRB,4.7571E-04_JPRB,7.2750E-01_JPRB/)  
KAO( :, 1,13, 7) = (/&
 & 1.4127E-03_JPRB,1.2657E-03_JPRB,1.1099E-03_JPRB,9.4602E-04_JPRB,7.7557E-04_JPRB,6.0086E-04_JPRB,&
 & 4.2330E-04_JPRB,2.3798E-04_JPRB,5.3307E-01_JPRB/)  
KAO( :, 2,13, 7) = (/&
 & 1.4751E-03_JPRB,1.3349E-03_JPRB,1.1777E-03_JPRB,1.0078E-03_JPRB,8.3162E-04_JPRB,6.5054E-04_JPRB,&
 & 4.6516E-04_JPRB,2.6968E-04_JPRB,5.8063E-01_JPRB/)  
KAO( :, 3,13, 7) = (/&
 & 1.5459E-03_JPRB,1.4170E-03_JPRB,1.2569E-03_JPRB,1.0823E-03_JPRB,9.0010E-04_JPRB,7.1353E-04_JPRB,&
 & 5.2060E-04_JPRB,3.1113E-04_JPRB,6.3437E-01_JPRB/)  
KAO( :, 4,13, 7) = (/&
 & 1.6229E-03_JPRB,1.5083E-03_JPRB,1.3464E-03_JPRB,1.1679E-03_JPRB,9.8357E-04_JPRB,7.9315E-04_JPRB,&
 & 5.8870E-04_JPRB,3.6533E-04_JPRB,6.9306E-01_JPRB/)  
KAO( :, 5,13, 7) = (/&
 & 1.7093E-03_JPRB,1.6104E-03_JPRB,1.4477E-03_JPRB,1.2713E-03_JPRB,1.0860E-03_JPRB,8.8862E-04_JPRB,&
 & 6.7236E-04_JPRB,4.3506E-04_JPRB,7.5652E-01_JPRB/)  
KAO( :, 1, 1, 8) = (/&
 & 1.1271E-02_JPRB,1.0036E-02_JPRB,8.8055E-03_JPRB,7.5864E-03_JPRB,6.4304E-03_JPRB,5.2105E-03_JPRB,&
 & 3.8976E-03_JPRB,2.4887E-03_JPRB,2.5781E-03_JPRB/)  
KAO( :, 2, 1, 8) = (/&
 & 1.1795E-02_JPRB,1.0572E-02_JPRB,9.3466E-03_JPRB,8.1711E-03_JPRB,6.9948E-03_JPRB,5.7121E-03_JPRB,&
 & 4.3485E-03_JPRB,2.8557E-03_JPRB,3.2233E-03_JPRB/)  
KAO( :, 3, 1, 8) = (/&
 & 1.2322E-02_JPRB,1.1132E-02_JPRB,9.9358E-03_JPRB,8.8252E-03_JPRB,7.5937E-03_JPRB,6.2705E-03_JPRB,&
 & 4.8434E-03_JPRB,3.3250E-03_JPRB,3.9875E-03_JPRB/)  
KAO( :, 4, 1, 8) = (/&
 & 1.2851E-02_JPRB,1.1725E-02_JPRB,1.0603E-02_JPRB,9.4992E-03_JPRB,8.2313E-03_JPRB,6.8944E-03_JPRB,&
 & 5.3932E-03_JPRB,3.9133E-03_JPRB,4.8783E-03_JPRB/)  
KAO( :, 5, 1, 8) = (/&
 & 1.3382E-02_JPRB,1.2340E-02_JPRB,1.1321E-02_JPRB,1.0197E-02_JPRB,8.9293E-03_JPRB,7.5819E-03_JPRB,&
 & 6.0303E-03_JPRB,4.6405E-03_JPRB,5.9012E-03_JPRB/)  
KAO( :, 1, 2, 8) = (/&
 & 1.0672E-02_JPRB,9.5056E-03_JPRB,8.3387E-03_JPRB,7.1916E-03_JPRB,6.1140E-03_JPRB,4.9607E-03_JPRB,&
 & 3.7058E-03_JPRB,2.3880E-03_JPRB,2.7395E-03_JPRB/)  
KAO( :, 2, 2, 8) = (/&
 & 1.1169E-02_JPRB,1.0020E-02_JPRB,8.8610E-03_JPRB,7.7691E-03_JPRB,6.6689E-03_JPRB,5.4487E-03_JPRB,&
 & 4.1407E-03_JPRB,2.7243E-03_JPRB,3.3802E-03_JPRB/)  
KAO( :, 3, 2, 8) = (/&
 & 1.1679E-02_JPRB,1.0568E-02_JPRB,9.4396E-03_JPRB,8.4156E-03_JPRB,7.2560E-03_JPRB,5.9872E-03_JPRB,&
 & 4.6292E-03_JPRB,3.1276E-03_JPRB,4.1522E-03_JPRB/)  
KAO( :, 4, 2, 8) = (/&
 & 1.2189E-02_JPRB,1.1143E-02_JPRB,1.0088E-02_JPRB,9.0819E-03_JPRB,7.8824E-03_JPRB,6.5917E-03_JPRB,&
 & 5.1714E-03_JPRB,3.6254E-03_JPRB,5.0691E-03_JPRB/)  
KAO( :, 5, 2, 8) = (/&
 & 1.2702E-02_JPRB,1.1729E-02_JPRB,1.0782E-02_JPRB,9.7685E-03_JPRB,8.5622E-03_JPRB,7.2579E-03_JPRB,&
 & 5.7650E-03_JPRB,4.2498E-03_JPRB,6.1336E-03_JPRB/)  
KAO( :, 1, 3, 8) = (/&
 & 9.8797E-03_JPRB,8.7861E-03_JPRB,7.6933E-03_JPRB,6.6349E-03_JPRB,5.6262E-03_JPRB,4.5704E-03_JPRB,&
 & 3.4179E-03_JPRB,2.1903E-03_JPRB,3.6361E-03_JPRB/)  
KAO( :, 2, 3, 8) = (/&
 & 1.0349E-02_JPRB,9.2701E-03_JPRB,8.1866E-03_JPRB,7.1655E-03_JPRB,6.1521E-03_JPRB,5.0318E-03_JPRB,&
 & 3.8109E-03_JPRB,2.5138E-03_JPRB,4.3860E-03_JPRB/)  
KAO( :, 3, 3, 8) = (/&
 & 1.0830E-02_JPRB,9.7857E-03_JPRB,8.7308E-03_JPRB,7.7641E-03_JPRB,6.7179E-03_JPRB,5.5402E-03_JPRB,&
 & 4.2653E-03_JPRB,2.8863E-03_JPRB,5.2476E-03_JPRB/)  
KAO( :, 4, 3, 8) = (/&
 & 1.1311E-02_JPRB,1.0326E-02_JPRB,9.3387E-03_JPRB,8.4020E-03_JPRB,7.3182E-03_JPRB,6.0959E-03_JPRB,&
 & 4.7833E-03_JPRB,3.3218E-03_JPRB,6.2518E-03_JPRB/)  
KAO( :, 5, 3, 8) = (/&
 & 1.1804E-02_JPRB,1.0884E-02_JPRB,9.9988E-03_JPRB,9.0694E-03_JPRB,7.9619E-03_JPRB,6.7205E-03_JPRB,&
 & 5.3622E-03_JPRB,3.8455E-03_JPRB,7.4421E-03_JPRB/)  
KAO( :, 1, 4, 8) = (/&
 & 9.0341E-03_JPRB,8.0181E-03_JPRB,7.0097E-03_JPRB,6.0433E-03_JPRB,5.0961E-03_JPRB,4.1279E-03_JPRB,&
 & 3.0949E-03_JPRB,1.9591E-03_JPRB,5.2205E-03_JPRB/)  
KAO( :, 2, 4, 8) = (/&
 & 9.4663E-03_JPRB,8.4620E-03_JPRB,7.4631E-03_JPRB,6.5118E-03_JPRB,5.5670E-03_JPRB,4.5574E-03_JPRB,&
 & 3.4524E-03_JPRB,2.2551E-03_JPRB,6.2821E-03_JPRB/)  
KAO( :, 3, 4, 8) = (/&
 & 9.9093E-03_JPRB,8.9346E-03_JPRB,7.9590E-03_JPRB,7.0438E-03_JPRB,6.0869E-03_JPRB,5.0245E-03_JPRB,&
 & 3.8570E-03_JPRB,2.6046E-03_JPRB,7.4874E-03_JPRB/)  
KAO( :, 4, 4, 8) = (/&
 & 1.0364E-02_JPRB,9.4379E-03_JPRB,8.5216E-03_JPRB,7.6276E-03_JPRB,6.6482E-03_JPRB,5.5372E-03_JPRB,&
 & 4.3314E-03_JPRB,3.0117E-03_JPRB,8.8492E-03_JPRB/)  
KAO( :, 5, 4, 8) = (/&
 & 1.0832E-02_JPRB,9.9630E-03_JPRB,9.1301E-03_JPRB,8.2526E-03_JPRB,7.2502E-03_JPRB,6.1063E-03_JPRB,&
 & 4.8699E-03_JPRB,3.4864E-03_JPRB,1.0381E-02_JPRB/)  
KAO( :, 1, 5, 8) = (/&
 & 8.2066E-03_JPRB,7.2704E-03_JPRB,6.3520E-03_JPRB,5.4803E-03_JPRB,4.5989E-03_JPRB,3.7047E-03_JPRB,&
 & 2.7766E-03_JPRB,1.7333E-03_JPRB,7.2922E-03_JPRB/)  
KAO( :, 2, 5, 8) = (/&
 & 8.5864E-03_JPRB,7.6589E-03_JPRB,6.7541E-03_JPRB,5.8852E-03_JPRB,5.0024E-03_JPRB,4.0864E-03_JPRB,&
 & 3.0959E-03_JPRB,1.9895E-03_JPRB,8.7707E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART6',0,ZHOOK_HANDLE)


KAO( :, 3, 5, 8) = (/&
 & 8.9852E-03_JPRB,8.0815E-03_JPRB,7.1976E-03_JPRB,6.3516E-03_JPRB,5.4653E-03_JPRB,4.5110E-03_JPRB,&
 & 3.4542E-03_JPRB,2.3009E-03_JPRB,1.0486E-02_JPRB/)  
KAO( :, 4, 5, 8) = (/&
 & 9.4036E-03_JPRB,8.5424E-03_JPRB,7.7055E-03_JPRB,6.8683E-03_JPRB,5.9736E-03_JPRB,4.9773E-03_JPRB,&
 & 3.8692E-03_JPRB,2.6768E-03_JPRB,1.2445E-02_JPRB/)  
KAO( :, 5, 5, 8) = (/&
 & 9.8437E-03_JPRB,9.0342E-03_JPRB,8.2571E-03_JPRB,7.4313E-03_JPRB,6.5257E-03_JPRB,5.4908E-03_JPRB,&
 & 4.3579E-03_JPRB,3.1244E-03_JPRB,1.4671E-02_JPRB/)  
KAO( :, 1, 6, 8) = (/&
 & 7.3775E-03_JPRB,6.5258E-03_JPRB,5.7033E-03_JPRB,4.9243E-03_JPRB,4.1126E-03_JPRB,3.2909E-03_JPRB,&
 & 2.4468E-03_JPRB,1.5110E-03_JPRB,9.9543E-03_JPRB/)  
KAO( :, 2, 6, 8) = (/&
 & 7.6997E-03_JPRB,6.8542E-03_JPRB,6.0539E-03_JPRB,5.2649E-03_JPRB,4.4522E-03_JPRB,3.6170E-03_JPRB,&
 & 2.7307E-03_JPRB,1.7266E-03_JPRB,1.1860E-02_JPRB/)  
KAO( :, 3, 6, 8) = (/&
 & 8.0489E-03_JPRB,7.2263E-03_JPRB,6.4458E-03_JPRB,5.6660E-03_JPRB,4.8447E-03_JPRB,3.9877E-03_JPRB,&
 & 3.0489E-03_JPRB,1.9907E-03_JPRB,1.4111E-02_JPRB/)  
KAO( :, 4, 6, 8) = (/&
 & 8.4274E-03_JPRB,7.6434E-03_JPRB,6.8896E-03_JPRB,6.1185E-03_JPRB,5.2908E-03_JPRB,4.4013E-03_JPRB,&
 & 3.4126E-03_JPRB,2.3197E-03_JPRB,1.6745E-02_JPRB/)  
KAO( :, 5, 6, 8) = (/&
 & 8.8394E-03_JPRB,8.0956E-03_JPRB,7.3855E-03_JPRB,6.6147E-03_JPRB,5.7835E-03_JPRB,4.8630E-03_JPRB,&
 & 3.8408E-03_JPRB,2.7242E-03_JPRB,1.9764E-02_JPRB/)  
KAO( :, 1, 7, 8) = (/&
 & 6.5565E-03_JPRB,5.7913E-03_JPRB,5.0650E-03_JPRB,4.3717E-03_JPRB,3.6417E-03_JPRB,2.9003E-03_JPRB,&
 & 2.1352E-03_JPRB,1.3029E-03_JPRB,1.4373E-02_JPRB/)  
KAO( :, 2, 7, 8) = (/&
 & 6.8314E-03_JPRB,6.0702E-03_JPRB,5.3740E-03_JPRB,4.6650E-03_JPRB,3.9304E-03_JPRB,3.1756E-03_JPRB,&
 & 2.3780E-03_JPRB,1.4833E-03_JPRB,1.7113E-02_JPRB/)  
KAO( :, 3, 7, 8) = (/&
 & 7.1400E-03_JPRB,6.4022E-03_JPRB,5.7201E-03_JPRB,5.0134E-03_JPRB,4.2702E-03_JPRB,3.4939E-03_JPRB,&
 & 2.6530E-03_JPRB,1.7044E-03_JPRB,2.0310E-02_JPRB/)  
KAO( :, 4, 7, 8) = (/&
 & 7.4900E-03_JPRB,6.7869E-03_JPRB,6.1184E-03_JPRB,5.4134E-03_JPRB,4.6538E-03_JPRB,3.8497E-03_JPRB,&
 & 2.9716E-03_JPRB,1.9853E-03_JPRB,2.4047E-02_JPRB/)  
KAO( :, 5, 7, 8) = (/&
 & 7.8853E-03_JPRB,7.2198E-03_JPRB,6.5744E-03_JPRB,5.8583E-03_JPRB,5.0855E-03_JPRB,4.2547E-03_JPRB,&
 & 3.3480E-03_JPRB,2.3372E-03_JPRB,2.8402E-02_JPRB/)  
KAO( :, 1, 8, 8) = (/&
 & 5.7906E-03_JPRB,5.1087E-03_JPRB,4.4702E-03_JPRB,3.8543E-03_JPRB,3.2058E-03_JPRB,2.5413E-03_JPRB,&
 & 1.8524E-03_JPRB,1.1137E-03_JPRB,2.4973E-02_JPRB/)  
KAO( :, 2, 8, 8) = (/&
 & 6.0296E-03_JPRB,5.3498E-03_JPRB,4.7428E-03_JPRB,4.1103E-03_JPRB,3.4527E-03_JPRB,2.7740E-03_JPRB,&
 & 2.0568E-03_JPRB,1.2678E-03_JPRB,2.9683E-02_JPRB/)  
KAO( :, 3, 8, 8) = (/&
 & 6.3087E-03_JPRB,5.6506E-03_JPRB,5.0549E-03_JPRB,4.4167E-03_JPRB,3.7489E-03_JPRB,3.0452E-03_JPRB,&
 & 2.2930E-03_JPRB,1.4507E-03_JPRB,3.5325E-02_JPRB/)  
KAO( :, 4, 8, 8) = (/&
 & 6.6419E-03_JPRB,6.0135E-03_JPRB,5.4190E-03_JPRB,4.7745E-03_JPRB,4.0857E-03_JPRB,3.3552E-03_JPRB,&
 & 2.5672E-03_JPRB,1.6862E-03_JPRB,4.1942E-02_JPRB/)  
KAO( :, 5, 8, 8) = (/&
 & 7.0283E-03_JPRB,6.4363E-03_JPRB,5.8469E-03_JPRB,5.1836E-03_JPRB,4.4693E-03_JPRB,3.7129E-03_JPRB,&
 & 2.8969E-03_JPRB,1.9865E-03_JPRB,4.9701E-02_JPRB/)  
KAO( :, 1, 9, 8) = (/&
 & 5.0360E-03_JPRB,4.4397E-03_JPRB,3.8840E-03_JPRB,3.3435E-03_JPRB,2.7807E-03_JPRB,2.1932E-03_JPRB,&
 & 1.5839E-03_JPRB,9.3584E-04_JPRB,8.5840E-02_JPRB/)  
KAO( :, 2, 9, 8) = (/&
 & 5.2453E-03_JPRB,4.6508E-03_JPRB,4.1231E-03_JPRB,3.5696E-03_JPRB,2.9904E-03_JPRB,2.3871E-03_JPRB,&
 & 1.7527E-03_JPRB,1.0640E-03_JPRB,1.0011E-01_JPRB/)  
KAO( :, 3, 9, 8) = (/&
 & 5.5017E-03_JPRB,4.9250E-03_JPRB,4.4061E-03_JPRB,3.8385E-03_JPRB,3.2464E-03_JPRB,2.6177E-03_JPRB,&
 & 1.9509E-03_JPRB,1.2177E-03_JPRB,1.1783E-01_JPRB/)  
KAO( :, 4, 9, 8) = (/&
 & 5.8157E-03_JPRB,5.2667E-03_JPRB,4.7409E-03_JPRB,4.1617E-03_JPRB,3.5430E-03_JPRB,2.8840E-03_JPRB,&
 & 2.1850E-03_JPRB,1.4137E-03_JPRB,1.3938E-01_JPRB/)  
KAO( :, 5, 9, 8) = (/&
 & 6.1830E-03_JPRB,5.6669E-03_JPRB,5.1359E-03_JPRB,4.5353E-03_JPRB,3.8872E-03_JPRB,3.1987E-03_JPRB,&
 & 2.4695E-03_JPRB,1.6659E-03_JPRB,1.6517E-01_JPRB/)  
KAO( :, 1,10, 8) = (/&
 & 4.3296E-03_JPRB,3.8182E-03_JPRB,3.3429E-03_JPRB,2.8727E-03_JPRB,2.3861E-03_JPRB,1.8763E-03_JPRB,&
 & 1.3438E-03_JPRB,7.8161E-04_JPRB,3.9143E-01_JPRB/)  
KAO( :, 2,10, 8) = (/&
 & 4.5130E-03_JPRB,4.0050E-03_JPRB,3.5504E-03_JPRB,3.0710E-03_JPRB,2.5674E-03_JPRB,2.0397E-03_JPRB,&
 & 1.4837E-03_JPRB,8.8733E-04_JPRB,4.3656E-01_JPRB/)  
KAO( :, 3,10, 8) = (/&
 & 4.7537E-03_JPRB,4.2601E-03_JPRB,3.8073E-03_JPRB,3.3140E-03_JPRB,2.7911E-03_JPRB,2.2372E-03_JPRB,&
 & 1.6497E-03_JPRB,1.0161E-03_JPRB,4.9451E-01_JPRB/)  
KAO( :, 4,10, 8) = (/&
 & 5.0463E-03_JPRB,4.5800E-03_JPRB,4.1210E-03_JPRB,3.6090E-03_JPRB,3.0570E-03_JPRB,2.4709E-03_JPRB,&
 & 1.8508E-03_JPRB,1.1821E-03_JPRB,5.6882E-01_JPRB/)  
KAO( :, 5,10, 8) = (/&
 & 5.3939E-03_JPRB,4.9543E-03_JPRB,4.4851E-03_JPRB,3.9500E-03_JPRB,3.3687E-03_JPRB,2.7497E-03_JPRB,&
 & 2.1004E-03_JPRB,1.3979E-03_JPRB,6.6139E-01_JPRB/)  
KAO( :, 1,11, 8) = (/&
 & 3.7600E-03_JPRB,3.3296E-03_JPRB,2.9316E-03_JPRB,2.5257E-03_JPRB,2.0989E-03_JPRB,1.6511E-03_JPRB,&
 & 1.1820E-03_JPRB,6.8533E-04_JPRB,7.4408E-01_JPRB/)  
KAO( :, 2,11, 8) = (/&
 & 3.9507E-03_JPRB,3.5282E-03_JPRB,3.1373E-03_JPRB,2.7184E-03_JPRB,2.2731E-03_JPRB,1.8035E-03_JPRB,&
 & 1.3072E-03_JPRB,7.7991E-04_JPRB,8.1308E-01_JPRB/)  
KAO( :, 3,11, 8) = (/&
 & 4.1947E-03_JPRB,3.7893E-03_JPRB,3.3928E-03_JPRB,2.9586E-03_JPRB,2.4893E-03_JPRB,1.9891E-03_JPRB,&
 & 1.4610E-03_JPRB,8.9963E-04_JPRB,8.9527E-01_JPRB/)  
KAO( :, 4,11, 8) = (/&
 & 4.4908E-03_JPRB,4.1076E-03_JPRB,3.7028E-03_JPRB,3.2435E-03_JPRB,2.7433E-03_JPRB,2.2120E-03_JPRB,&
 & 1.6527E-03_JPRB,1.0595E-03_JPRB,9.9684E-01_JPRB/)  
KAO( :, 5,11, 8) = (/&
 & 4.8478E-03_JPRB,4.4859E-03_JPRB,4.0645E-03_JPRB,3.5748E-03_JPRB,3.0447E-03_JPRB,2.4822E-03_JPRB,&
 & 1.8975E-03_JPRB,1.2673E-03_JPRB,1.1166E+00_JPRB/)  
KAO( :, 1,12, 8) = (/&
 & 3.2909E-03_JPRB,2.9295E-03_JPRB,2.5867E-03_JPRB,2.2286E-03_JPRB,1.8515E-03_JPRB,1.4556E-03_JPRB,&
 & 1.0393E-03_JPRB,6.0072E-04_JPRB,1.0077E+00_JPRB/)  
KAO( :, 2,12, 8) = (/&
 & 3.4843E-03_JPRB,3.1331E-03_JPRB,2.7896E-03_JPRB,2.4180E-03_JPRB,2.0217E-03_JPRB,1.5999E-03_JPRB,&
 & 1.1545E-03_JPRB,6.8643E-04_JPRB,1.0948E+00_JPRB/)  
KAO( :, 3,12, 8) = (/&
 & 3.7310E-03_JPRB,3.3942E-03_JPRB,3.0433E-03_JPRB,2.6518E-03_JPRB,2.2272E-03_JPRB,1.7748E-03_JPRB,&
 & 1.3002E-03_JPRB,8.0128E-04_JPRB,1.1979E+00_JPRB/)  
KAO( :, 4,12, 8) = (/&
 & 4.0332E-03_JPRB,3.7134E-03_JPRB,3.3499E-03_JPRB,2.9292E-03_JPRB,2.4733E-03_JPRB,1.9891E-03_JPRB,&
 & 1.4867E-03_JPRB,9.5533E-04_JPRB,1.3214E+00_JPRB/)  
KAO( :, 5,12, 8) = (/&
 & 4.3825E-03_JPRB,4.0886E-03_JPRB,3.7068E-03_JPRB,3.2581E-03_JPRB,2.7706E-03_JPRB,2.2595E-03_JPRB,&
 & 1.7283E-03_JPRB,1.1510E-03_JPRB,1.4622E+00_JPRB/)  
KAO( :, 1,13, 8) = (/&
 & 3.0478E-03_JPRB,2.7205E-03_JPRB,2.3969E-03_JPRB,2.0570E-03_JPRB,1.7018E-03_JPRB,1.3312E-03_JPRB,&
 & 9.4239E-04_JPRB,5.3797E-04_JPRB,1.1139E+00_JPRB/)  
KAO( :, 2,13, 8) = (/&
 & 3.2266E-03_JPRB,2.9089E-03_JPRB,2.5816E-03_JPRB,2.2296E-03_JPRB,1.8550E-03_JPRB,1.4585E-03_JPRB,&
 & 1.0452E-03_JPRB,6.1598E-04_JPRB,1.2073E+00_JPRB/)  
KAO( :, 3,13, 8) = (/&
 & 3.4554E-03_JPRB,3.1502E-03_JPRB,2.8168E-03_JPRB,2.4455E-03_JPRB,2.0432E-03_JPRB,1.6195E-03_JPRB,&
 & 1.1807E-03_JPRB,7.2584E-04_JPRB,1.3161E+00_JPRB/)  
KAO( :, 4,13, 8) = (/&
 & 3.7354E-03_JPRB,3.4492E-03_JPRB,3.1036E-03_JPRB,2.7077E-03_JPRB,2.2785E-03_JPRB,1.8279E-03_JPRB,&
 & 1.3627E-03_JPRB,8.7250E-04_JPRB,1.4441E+00_JPRB/)  
KAO( :, 5,13, 8) = (/&
 & 4.0484E-03_JPRB,3.7921E-03_JPRB,3.4369E-03_JPRB,3.0193E-03_JPRB,2.5680E-03_JPRB,2.0959E-03_JPRB,&
 & 1.6011E-03_JPRB,1.0569E-03_JPRB,1.5851E+00_JPRB/)  
KAO( :, 1, 1, 9) = (/&
 & 1.9029E-02_JPRB,1.6853E-02_JPRB,1.4735E-02_JPRB,1.2587E-02_JPRB,1.0467E-02_JPRB,8.5540E-03_JPRB,&
 & 6.8482E-03_JPRB,5.4691E-03_JPRB,7.2696E-03_JPRB/)  
KAO( :, 2, 1, 9) = (/&
 & 2.0092E-02_JPRB,1.7878E-02_JPRB,1.5728E-02_JPRB,1.3580E-02_JPRB,1.1524E-02_JPRB,9.7463E-03_JPRB,&
 & 8.1292E-03_JPRB,6.9002E-03_JPRB,9.2265E-03_JPRB/)  
KAO( :, 3, 1, 9) = (/&
 & 2.1289E-02_JPRB,1.9078E-02_JPRB,1.6951E-02_JPRB,1.4803E-02_JPRB,1.2902E-02_JPRB,1.1235E-02_JPRB,&
 & 9.7244E-03_JPRB,8.5896E-03_JPRB,1.1472E-02_JPRB/)  
KAO( :, 4, 1, 9) = (/&
 & 2.2660E-02_JPRB,2.0471E-02_JPRB,1.8401E-02_JPRB,1.6346E-02_JPRB,1.4609E-02_JPRB,1.3016E-02_JPRB,&
 & 1.1621E-02_JPRB,1.0516E-02_JPRB,1.4012E-02_JPRB/)  
KAO( :, 5, 1, 9) = (/&
 & 2.4197E-02_JPRB,2.2063E-02_JPRB,2.0065E-02_JPRB,1.8209E-02_JPRB,1.6609E-02_JPRB,1.5079E-02_JPRB,&
 & 1.3788E-02_JPRB,1.2665E-02_JPRB,1.6825E-02_JPRB/)  
KAO( :, 1, 2, 9) = (/&
 & 1.9742E-02_JPRB,1.7478E-02_JPRB,1.5268E-02_JPRB,1.3020E-02_JPRB,1.0794E-02_JPRB,8.7264E-03_JPRB,&
 & 6.7494E-03_JPRB,5.0072E-03_JPRB,7.5472E-03_JPRB/)  
KAO( :, 2, 2, 9) = (/&
 & 2.0752E-02_JPRB,1.8451E-02_JPRB,1.6203E-02_JPRB,1.3921E-02_JPRB,1.1711E-02_JPRB,9.7269E-03_JPRB,&
 & 7.8214E-03_JPRB,6.2435E-03_JPRB,9.6127E-03_JPRB/)  
KAO( :, 3, 2, 9) = (/&
 & 2.1850E-02_JPRB,1.9539E-02_JPRB,1.7284E-02_JPRB,1.4968E-02_JPRB,1.2893E-02_JPRB,1.0990E-02_JPRB,&
 & 9.1753E-03_JPRB,7.7563E-03_JPRB,1.2009E-02_JPRB/)  
KAO( :, 4, 2, 9) = (/&
 & 2.3047E-02_JPRB,2.0746E-02_JPRB,1.8528E-02_JPRB,1.6289E-02_JPRB,1.4365E-02_JPRB,1.2522E-02_JPRB,&
 & 1.0820E-02_JPRB,9.5216E-03_JPRB,1.4733E-02_JPRB/)  
KAO( :, 5, 2, 9) = (/&
 & 2.4378E-02_JPRB,2.2145E-02_JPRB,1.9963E-02_JPRB,1.7904E-02_JPRB,1.6106E-02_JPRB,1.4326E-02_JPRB,&
 & 1.2781E-02_JPRB,1.1538E-02_JPRB,1.7764E-02_JPRB/)  
KAO( :, 1, 3, 9) = (/&
 & 2.0246E-02_JPRB,1.7907E-02_JPRB,1.5619E-02_JPRB,1.3303E-02_JPRB,1.1014E-02_JPRB,8.8212E-03_JPRB,&
 & 6.6585E-03_JPRB,4.5305E-03_JPRB,9.1026E-03_JPRB/)  
KAO( :, 2, 3, 9) = (/&
 & 2.1216E-02_JPRB,1.8847E-02_JPRB,1.6535E-02_JPRB,1.4182E-02_JPRB,1.1869E-02_JPRB,9.7020E-03_JPRB,&
 & 7.5117E-03_JPRB,5.5113E-03_JPRB,1.1552E-02_JPRB/)  
KAO( :, 3, 3, 9) = (/&
 & 2.2286E-02_JPRB,1.9902E-02_JPRB,1.7571E-02_JPRB,1.5169E-02_JPRB,1.2921E-02_JPRB,1.0740E-02_JPRB,&
 & 8.6112E-03_JPRB,6.7529E-03_JPRB,1.4497E-02_JPRB/)  
KAO( :, 4, 3, 9) = (/&
 & 2.3424E-02_JPRB,2.1046E-02_JPRB,1.8711E-02_JPRB,1.6326E-02_JPRB,1.4157E-02_JPRB,1.2014E-02_JPRB,&
 & 9.9676E-03_JPRB,8.2723E-03_JPRB,1.7885E-02_JPRB/)  
KAO( :, 5, 3, 9) = (/&
 & 2.4644E-02_JPRB,2.2304E-02_JPRB,1.9954E-02_JPRB,1.7680E-02_JPRB,1.5613E-02_JPRB,1.3543E-02_JPRB,&
 & 1.1603E-02_JPRB,1.0079E-02_JPRB,2.1675E-02_JPRB/)  
KAO( :, 1, 4, 9) = (/&
 & 2.0516E-02_JPRB,1.8121E-02_JPRB,1.5769E-02_JPRB,1.3411E-02_JPRB,1.1085E-02_JPRB,8.8389E-03_JPRB,&
 & 6.5833E-03_JPRB,4.2076E-03_JPRB,1.2881E-02_JPRB/)  
KAO( :, 2, 4, 9) = (/&
 & 2.1468E-02_JPRB,1.9043E-02_JPRB,1.6678E-02_JPRB,1.4283E-02_JPRB,1.1934E-02_JPRB,9.6739E-03_JPRB,&
 & 7.3557E-03_JPRB,4.9709E-03_JPRB,1.5909E-02_JPRB/)  
KAO( :, 3, 4, 9) = (/&
 & 2.2532E-02_JPRB,2.0092E-02_JPRB,1.7713E-02_JPRB,1.5283E-02_JPRB,1.2949E-02_JPRB,1.0652E-02_JPRB,&
 & 8.2469E-03_JPRB,5.9560E-03_JPRB,1.9619E-02_JPRB/)  
KAO( :, 4, 4, 9) = (/&
 & 2.3665E-02_JPRB,2.1230E-02_JPRB,1.8849E-02_JPRB,1.6407E-02_JPRB,1.4104E-02_JPRB,1.1750E-02_JPRB,&
 & 9.3432E-03_JPRB,7.1888E-03_JPRB,2.4018E-02_JPRB/)  
KAO( :, 5, 4, 9) = (/&
 & 2.4860E-02_JPRB,2.2477E-02_JPRB,2.0057E-02_JPRB,1.7676E-02_JPRB,1.5382E-02_JPRB,1.3031E-02_JPRB,&
 & 1.0691E-02_JPRB,8.7092E-03_JPRB,2.9097E-02_JPRB/)  
KAO( :, 1, 5, 9) = (/&
 & 2.0504E-02_JPRB,1.8088E-02_JPRB,1.5703E-02_JPRB,1.3326E-02_JPRB,1.0997E-02_JPRB,8.7375E-03_JPRB,&
 & 6.4349E-03_JPRB,4.0325E-03_JPRB,1.9706E-02_JPRB/)  
KAO( :, 2, 5, 9) = (/&
 & 2.1455E-02_JPRB,1.9003E-02_JPRB,1.6600E-02_JPRB,1.4207E-02_JPRB,1.1857E-02_JPRB,9.5485E-03_JPRB,&
 & 7.1823E-03_JPRB,4.6356E-03_JPRB,2.3733E-02_JPRB/)  
KAO( :, 3, 5, 9) = (/&
 & 2.2502E-02_JPRB,2.0037E-02_JPRB,1.7638E-02_JPRB,1.5221E-02_JPRB,1.2854E-02_JPRB,1.0499E-02_JPRB,&
 & 8.0330E-03_JPRB,5.4121E-03_JPRB,2.8573E-02_JPRB/)  
KAO( :, 4, 5, 9) = (/&
 & 2.3616E-02_JPRB,2.1161E-02_JPRB,1.8779E-02_JPRB,1.6343E-02_JPRB,1.3995E-02_JPRB,1.1576E-02_JPRB,&
 & 8.9770E-03_JPRB,6.4039E-03_JPRB,3.4371E-02_JPRB/)  
KAO( :, 5, 5, 9) = (/&
 & 2.4795E-02_JPRB,2.2401E-02_JPRB,2.0008E-02_JPRB,1.7611E-02_JPRB,1.5244E-02_JPRB,1.2739E-02_JPRB,&
 & 1.0086E-02_JPRB,7.6459E-03_JPRB,4.1145E-02_JPRB/)  
KAO( :, 1, 6, 9) = (/&
 & 2.0133E-02_JPRB,1.7738E-02_JPRB,1.5364E-02_JPRB,1.2999E-02_JPRB,1.0725E-02_JPRB,8.4927E-03_JPRB,&
 & 6.2104E-03_JPRB,3.8293E-03_JPRB,2.9307E-02_JPRB/)  
KAO( :, 2, 6, 9) = (/&
 & 2.1045E-02_JPRB,1.8610E-02_JPRB,1.6208E-02_JPRB,1.3856E-02_JPRB,1.1560E-02_JPRB,9.2671E-03_JPRB,&
 & 6.8969E-03_JPRB,4.3962E-03_JPRB,3.5253E-02_JPRB/)  
KAO( :, 3, 6, 9) = (/&
 & 2.2058E-02_JPRB,1.9606E-02_JPRB,1.7213E-02_JPRB,1.4861E-02_JPRB,1.2529E-02_JPRB,1.0178E-02_JPRB,&
 & 7.7198E-03_JPRB,5.0397E-03_JPRB,4.2153E-02_JPRB/)  
KAO( :, 4, 6, 9) = (/&
 & 2.3150E-02_JPRB,2.0703E-02_JPRB,1.8349E-02_JPRB,1.5982E-02_JPRB,1.3648E-02_JPRB,1.1231E-02_JPRB,&
 & 8.6302E-03_JPRB,5.8174E-03_JPRB,5.0140E-02_JPRB/)  
KAO( :, 5, 6, 9) = (/&
 & 2.4302E-02_JPRB,2.1916E-02_JPRB,1.9594E-02_JPRB,1.7235E-02_JPRB,1.4884E-02_JPRB,1.2368E-02_JPRB,&
 & 9.6429E-03_JPRB,6.8104E-03_JPRB,5.9434E-02_JPRB/)  
KAO( :, 1, 7, 9) = (/&
 & 1.9536E-02_JPRB,1.7189E-02_JPRB,1.4859E-02_JPRB,1.2545E-02_JPRB,1.0327E-02_JPRB,8.1473E-03_JPRB,&
 & 5.9285E-03_JPRB,3.5890E-03_JPRB,4.5929E-02_JPRB/)  
KAO( :, 2, 7, 9) = (/&
 & 2.0386E-02_JPRB,1.8001E-02_JPRB,1.5633E-02_JPRB,1.3342E-02_JPRB,1.1116E-02_JPRB,8.8902E-03_JPRB,&
 & 6.5600E-03_JPRB,4.1234E-03_JPRB,5.5119E-02_JPRB/)  
KAO( :, 3, 7, 9) = (/&
 & 2.1349E-02_JPRB,1.8942E-02_JPRB,1.6585E-02_JPRB,1.4307E-02_JPRB,1.2057E-02_JPRB,9.7494E-03_JPRB,&
 & 7.3377E-03_JPRB,4.7340E-03_JPRB,6.5943E-02_JPRB/)  
KAO( :, 4, 7, 9) = (/&
 & 2.2403E-02_JPRB,1.9996E-02_JPRB,1.7685E-02_JPRB,1.5416E-02_JPRB,1.3126E-02_JPRB,1.0758E-02_JPRB,&
 & 8.2128E-03_JPRB,5.4226E-03_JPRB,7.8488E-02_JPRB/)  
KAO( :, 5, 7, 9) = (/&
 & 2.3510E-02_JPRB,2.1150E-02_JPRB,1.8904E-02_JPRB,1.6637E-02_JPRB,1.4327E-02_JPRB,1.1873E-02_JPRB,&
 & 9.1897E-03_JPRB,6.2247E-03_JPRB,9.2665E-02_JPRB/)  
KAO( :, 1, 8, 9) = (/&
 & 1.8746E-02_JPRB,1.6470E-02_JPRB,1.4220E-02_JPRB,1.1987E-02_JPRB,9.8350E-03_JPRB,7.7336E-03_JPRB,&
 & 5.6041E-03_JPRB,3.3408E-03_JPRB,8.6619E-02_JPRB/)  
KAO( :, 2, 8, 9) = (/&
 & 1.9538E-02_JPRB,1.7231E-02_JPRB,1.4934E-02_JPRB,1.2719E-02_JPRB,1.0574E-02_JPRB,8.4413E-03_JPRB,&
 & 6.1857E-03_JPRB,3.8236E-03_JPRB,1.0386E-01_JPRB/)  
KAO( :, 3, 8, 9) = (/&
 & 2.0463E-02_JPRB,1.8125E-02_JPRB,1.5828E-02_JPRB,1.3641E-02_JPRB,1.1488E-02_JPRB,9.2568E-03_JPRB,&
 & 6.9051E-03_JPRB,4.3974E-03_JPRB,1.2423E-01_JPRB/)  
KAO( :, 4, 8, 9) = (/&
 & 2.1475E-02_JPRB,1.9130E-02_JPRB,1.6884E-02_JPRB,1.4717E-02_JPRB,1.2518E-02_JPRB,1.0208E-02_JPRB,&
 & 7.7414E-03_JPRB,5.0487E-03_JPRB,1.4791E-01_JPRB/)  
KAO( :, 5, 8, 9) = (/&
 & 2.2552E-02_JPRB,2.0240E-02_JPRB,1.8077E-02_JPRB,1.5918E-02_JPRB,1.3670E-02_JPRB,1.1281E-02_JPRB,&
 & 8.6774E-03_JPRB,5.7934E-03_JPRB,1.7479E-01_JPRB/)  
KAO( :, 1, 9, 9) = (/&
 & 1.7677E-02_JPRB,1.5514E-02_JPRB,1.3384E-02_JPRB,1.1273E-02_JPRB,9.2209E-03_JPRB,7.2255E-03_JPRB,&
 & 5.2054E-03_JPRB,3.0724E-03_JPRB,3.0542E-01_JPRB/)  
KAO( :, 2, 9, 9) = (/&
 & 1.8381E-02_JPRB,1.6193E-02_JPRB,1.4015E-02_JPRB,1.1915E-02_JPRB,9.8821E-03_JPRB,7.8714E-03_JPRB,&
 & 5.7484E-03_JPRB,3.4992E-03_JPRB,3.6713E-01_JPRB/)  
KAO( :, 3, 9, 9) = (/&
 & 1.9248E-02_JPRB,1.7024E-02_JPRB,1.4840E-02_JPRB,1.2769E-02_JPRB,1.0738E-02_JPRB,8.6406E-03_JPRB,&
 & 6.3997E-03_JPRB,4.0183E-03_JPRB,4.4040E-01_JPRB/)  
KAO( :, 4, 9, 9) = (/&
 & 2.0207E-02_JPRB,1.7971E-02_JPRB,1.5835E-02_JPRB,1.3795E-02_JPRB,1.1724E-02_JPRB,9.5294E-03_JPRB,&
 & 7.1782E-03_JPRB,4.6229E-03_JPRB,5.2636E-01_JPRB/)  
KAO( :, 5, 9, 9) = (/&
 & 2.1234E-02_JPRB,1.9021E-02_JPRB,1.6969E-02_JPRB,1.4942E-02_JPRB,1.2829E-02_JPRB,1.0542E-02_JPRB,&
 & 8.0575E-03_JPRB,5.3170E-03_JPRB,6.2525E-01_JPRB/)  
KAO( :, 1,10, 9) = (/&
 & 1.6394E-02_JPRB,1.4380E-02_JPRB,1.2403E-02_JPRB,1.0449E-02_JPRB,8.5433E-03_JPRB,6.6777E-03_JPRB,&
 & 4.7921E-03_JPRB,2.8109E-03_JPRB,1.2050E+00_JPRB/)  
KAO( :, 2,10, 9) = (/&
 & 1.7024E-02_JPRB,1.4988E-02_JPRB,1.2970E-02_JPRB,1.1025E-02_JPRB,9.1364E-03_JPRB,7.2561E-03_JPRB,&
 & 5.2885E-03_JPRB,3.1895E-03_JPRB,1.4500E+00_JPRB/)  
KAO( :, 3,10, 9) = (/&
 & 1.7826E-02_JPRB,1.5753E-02_JPRB,1.3734E-02_JPRB,1.1808E-02_JPRB,9.9253E-03_JPRB,7.9700E-03_JPRB,&
 & 5.8931E-03_JPRB,3.6564E-03_JPRB,1.7463E+00_JPRB/)  
KAO( :, 4,10, 9) = (/&
 & 1.8735E-02_JPRB,1.6645E-02_JPRB,1.4665E-02_JPRB,1.2773E-02_JPRB,1.0857E-02_JPRB,8.8090E-03_JPRB,&
 & 6.6108E-03_JPRB,4.2090E-03_JPRB,2.0981E+00_JPRB/)  
KAO( :, 5,10, 9) = (/&
 & 1.9712E-02_JPRB,1.7647E-02_JPRB,1.5744E-02_JPRB,1.3877E-02_JPRB,1.1904E-02_JPRB,9.7573E-03_JPRB,&
 & 7.4286E-03_JPRB,4.8520E-03_JPRB,2.5126E+00_JPRB/)  
KAO( :, 1,11, 9) = (/&
 & 1.5188E-02_JPRB,1.3334E-02_JPRB,1.1520E-02_JPRB,9.7424E-03_JPRB,8.0090E-03_JPRB,6.2916E-03_JPRB,&
 & 4.5326E-03_JPRB,2.6753E-03_JPRB,1.9077E+00_JPRB/)  
KAO( :, 2,11, 9) = (/&
 & 1.5822E-02_JPRB,1.3943E-02_JPRB,1.2110E-02_JPRB,1.0341E-02_JPRB,8.6186E-03_JPRB,6.8684E-03_JPRB,&
 & 5.0259E-03_JPRB,3.0456E-03_JPRB,2.2451E+00_JPRB/)  
KAO( :, 3,11, 9) = (/&
 & 1.6607E-02_JPRB,1.4701E-02_JPRB,1.2884E-02_JPRB,1.1139E-02_JPRB,9.4122E-03_JPRB,7.5743E-03_JPRB,&
 & 5.6288E-03_JPRB,3.4987E-03_JPRB,2.6727E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART7',0,ZHOOK_HANDLE)


KAO( :, 4,11, 9) = (/&
 & 1.7478E-02_JPRB,1.5574E-02_JPRB,1.3803E-02_JPRB,1.2100E-02_JPRB,1.0320E-02_JPRB,8.3983E-03_JPRB,&
 & 6.3281E-03_JPRB,4.0305E-03_JPRB,3.1969E+00_JPRB/)  
KAO( :, 5,11, 9) = (/&
 & 1.8411E-02_JPRB,1.6558E-02_JPRB,1.4871E-02_JPRB,1.3181E-02_JPRB,1.1341E-02_JPRB,9.3258E-03_JPRB,&
 & 7.1170E-03_JPRB,4.6613E-03_JPRB,3.8404E+00_JPRB/)  
KAO( :, 1,12, 9) = (/&
 & 1.3941E-02_JPRB,1.2255E-02_JPRB,1.0613E-02_JPRB,9.0147E-03_JPRB,7.4482E-03_JPRB,5.8708E-03_JPRB,&
 & 4.2432E-03_JPRB,2.5105E-03_JPRB,2.4052E+00_JPRB/)  
KAO( :, 2,12, 9) = (/&
 & 1.4580E-02_JPRB,1.2868E-02_JPRB,1.1223E-02_JPRB,9.6378E-03_JPRB,8.0671E-03_JPRB,6.4400E-03_JPRB,&
 & 4.7289E-03_JPRB,2.8707E-03_JPRB,2.7400E+00_JPRB/)  
KAO( :, 3,12, 9) = (/&
 & 1.5332E-02_JPRB,1.3609E-02_JPRB,1.1989E-02_JPRB,1.0428E-02_JPRB,8.8315E-03_JPRB,7.1273E-03_JPRB,&
 & 5.3125E-03_JPRB,3.3035E-03_JPRB,3.1791E+00_JPRB/)  
KAO( :, 4,12, 9) = (/&
 & 1.6161E-02_JPRB,1.4458E-02_JPRB,1.2893E-02_JPRB,1.1362E-02_JPRB,9.7096E-03_JPRB,7.9231E-03_JPRB,&
 & 5.9850E-03_JPRB,3.8141E-03_JPRB,3.7447E+00_JPRB/)  
KAO( :, 5,12, 9) = (/&
 & 1.7070E-02_JPRB,1.5426E-02_JPRB,1.3937E-02_JPRB,1.2403E-02_JPRB,1.0694E-02_JPRB,8.8139E-03_JPRB,&
 & 6.7376E-03_JPRB,4.4323E-03_JPRB,4.4627E+00_JPRB/)  
KAO( :, 1,13, 9) = (/&
 & 1.2794E-02_JPRB,1.1266E-02_JPRB,9.7854E-03_JPRB,8.3492E-03_JPRB,6.9236E-03_JPRB,5.4666E-03_JPRB,&
 & 3.9567E-03_JPRB,2.3393E-03_JPRB,2.6597E+00_JPRB/)  
KAO( :, 2,13, 9) = (/&
 & 1.3432E-02_JPRB,1.1882E-02_JPRB,1.0408E-02_JPRB,8.9833E-03_JPRB,7.5382E-03_JPRB,6.0260E-03_JPRB,&
 & 4.4305E-03_JPRB,2.6861E-03_JPRB,2.9232E+00_JPRB/)  
KAO( :, 3,13, 9) = (/&
 & 1.4173E-02_JPRB,1.2623E-02_JPRB,1.1177E-02_JPRB,9.7661E-03_JPRB,8.2766E-03_JPRB,6.6966E-03_JPRB,&
 & 4.9881E-03_JPRB,3.0967E-03_JPRB,3.2802E+00_JPRB/)  
KAO( :, 4,13, 9) = (/&
 & 1.5004E-02_JPRB,1.3479E-02_JPRB,1.2087E-02_JPRB,1.0672E-02_JPRB,9.1287E-03_JPRB,7.4565E-03_JPRB,&
 & 5.6287E-03_JPRB,3.5870E-03_JPRB,3.7540E+00_JPRB/)  
KAO( :, 5,13, 9) = (/&
 & 1.5937E-02_JPRB,1.4472E-02_JPRB,1.3138E-02_JPRB,1.1698E-02_JPRB,1.0080E-02_JPRB,8.3092E-03_JPRB,&
 & 6.3550E-03_JPRB,4.1944E-03_JPRB,4.3785E+00_JPRB/)  
KAO( :, 1, 1,10) = (/&
 & 2.6762E-02_JPRB,2.3836E-02_JPRB,2.1231E-02_JPRB,1.8931E-02_JPRB,1.6906E-02_JPRB,1.4777E-02_JPRB,&
 & 1.3342E-02_JPRB,1.2105E-02_JPRB,1.6563E-02_JPRB/)  
KAO( :, 2, 1,10) = (/&
 & 2.9265E-02_JPRB,2.6518E-02_JPRB,2.4370E-02_JPRB,2.2173E-02_JPRB,2.0444E-02_JPRB,1.8164E-02_JPRB,&
 & 1.7054E-02_JPRB,1.5689E-02_JPRB,2.1225E-02_JPRB/)  
KAO( :, 3, 1,10) = (/&
 & 3.2760E-02_JPRB,2.9967E-02_JPRB,2.8038E-02_JPRB,2.6333E-02_JPRB,2.4279E-02_JPRB,2.2399E-02_JPRB,&
 & 2.1466E-02_JPRB,1.9893E-02_JPRB,2.6794E-02_JPRB/)  
KAO( :, 4, 1,10) = (/&
 & 3.6728E-02_JPRB,3.3924E-02_JPRB,3.2080E-02_JPRB,3.0665E-02_JPRB,2.8563E-02_JPRB,2.7253E-02_JPRB,&
 & 2.6630E-02_JPRB,2.4967E-02_JPRB,3.3311E-02_JPRB/)  
KAO( :, 5, 1,10) = (/&
 & 4.1067E-02_JPRB,3.8420E-02_JPRB,3.6876E-02_JPRB,3.5143E-02_JPRB,3.3523E-02_JPRB,3.2742E-02_JPRB,&
 & 3.2418E-02_JPRB,3.0721E-02_JPRB,4.0819E-02_JPRB/)  
KAO( :, 1, 2,10) = (/&
 & 2.8605E-02_JPRB,2.5321E-02_JPRB,2.2167E-02_JPRB,1.9077E-02_JPRB,1.6173E-02_JPRB,1.3425E-02_JPRB,&
 & 1.2233E-02_JPRB,1.1219E-02_JPRB,1.7512E-02_JPRB/)  
KAO( :, 2, 2,10) = (/&
 & 3.0223E-02_JPRB,2.6983E-02_JPRB,2.4080E-02_JPRB,2.1317E-02_JPRB,1.8746E-02_JPRB,1.6523E-02_JPRB,&
 & 1.5770E-02_JPRB,1.4686E-02_JPRB,2.2528E-02_JPRB/)  
KAO( :, 3, 2,10) = (/&
 & 3.2701E-02_JPRB,2.9579E-02_JPRB,2.6971E-02_JPRB,2.4770E-02_JPRB,2.2162E-02_JPRB,2.0505E-02_JPRB,&
 & 1.9969E-02_JPRB,1.8858E-02_JPRB,2.8417E-02_JPRB/)  
KAO( :, 4, 2,10) = (/&
 & 3.6116E-02_JPRB,3.3194E-02_JPRB,3.0876E-02_JPRB,2.8651E-02_JPRB,2.6284E-02_JPRB,2.5161E-02_JPRB,&
 & 2.4787E-02_JPRB,2.3679E-02_JPRB,3.5174E-02_JPRB/)  
KAO( :, 5, 2,10) = (/&
 & 4.0224E-02_JPRB,3.7508E-02_JPRB,3.5629E-02_JPRB,3.3002E-02_JPRB,3.1044E-02_JPRB,3.0447E-02_JPRB,&
 & 3.0074E-02_JPRB,2.9018E-02_JPRB,4.2802E-02_JPRB/)  
KAO( :, 1, 3,10) = (/&
 & 3.1173E-02_JPRB,2.7478E-02_JPRB,2.3852E-02_JPRB,2.0280E-02_JPRB,1.6676E-02_JPRB,1.3128E-02_JPRB,&
 & 1.0535E-02_JPRB,9.7264E-03_JPRB,2.0918E-02_JPRB/)  
KAO( :, 2, 3,10) = (/&
 & 3.2510E-02_JPRB,2.8808E-02_JPRB,2.5249E-02_JPRB,2.1598E-02_JPRB,1.8067E-02_JPRB,1.5028E-02_JPRB,&
 & 1.3592E-02_JPRB,1.2783E-02_JPRB,2.6767E-02_JPRB/)  
KAO( :, 3, 3,10) = (/&
 & 3.4191E-02_JPRB,3.0498E-02_JPRB,2.6966E-02_JPRB,2.3575E-02_JPRB,2.0182E-02_JPRB,1.8352E-02_JPRB,&
 & 1.7404E-02_JPRB,1.6536E-02_JPRB,3.3672E-02_JPRB/)  
KAO( :, 4, 3,10) = (/&
 & 3.6367E-02_JPRB,3.2714E-02_JPRB,2.9565E-02_JPRB,2.6531E-02_JPRB,2.3647E-02_JPRB,2.2602E-02_JPRB,&
 & 2.1804E-02_JPRB,2.0933E-02_JPRB,4.1820E-02_JPRB/)  
KAO( :, 5, 3,10) = (/&
 & 3.9166E-02_JPRB,3.5919E-02_JPRB,3.3501E-02_JPRB,3.0557E-02_JPRB,2.8090E-02_JPRB,2.7339E-02_JPRB,&
 & 2.6717E-02_JPRB,2.5907E-02_JPRB,5.1316E-02_JPRB/)  
KAO( :, 1, 4,10) = (/&
 & 3.4066E-02_JPRB,2.9987E-02_JPRB,2.5967E-02_JPRB,2.1961E-02_JPRB,1.7860E-02_JPRB,1.3888E-02_JPRB,&
 & 1.0186E-02_JPRB,8.1254E-03_JPRB,2.9250E-02_JPRB/)  
KAO( :, 2, 4,10) = (/&
 & 3.5460E-02_JPRB,3.1308E-02_JPRB,2.7262E-02_JPRB,2.3213E-02_JPRB,1.9156E-02_JPRB,1.5144E-02_JPRB,&
 & 1.1782E-02_JPRB,1.0834E-02_JPRB,3.8098E-02_JPRB/)  
KAO( :, 3, 4,10) = (/&
 & 3.6874E-02_JPRB,3.2726E-02_JPRB,2.8680E-02_JPRB,2.4650E-02_JPRB,2.0393E-02_JPRB,1.6831E-02_JPRB,&
 & 1.4883E-02_JPRB,1.4098E-02_JPRB,4.8024E-02_JPRB/)  
KAO( :, 4, 4,10) = (/&
 & 3.8521E-02_JPRB,3.4326E-02_JPRB,3.0378E-02_JPRB,2.6392E-02_JPRB,2.2432E-02_JPRB,1.9980E-02_JPRB,&
 & 1.8770E-02_JPRB,1.7981E-02_JPRB,5.9374E-02_JPRB/)  
KAO( :, 5, 4,10) = (/&
 & 4.0371E-02_JPRB,3.6305E-02_JPRB,3.2708E-02_JPRB,2.8856E-02_JPRB,2.5853E-02_JPRB,2.4145E-02_JPRB,&
 & 2.3195E-02_JPRB,2.2463E-02_JPRB,7.2233E-02_JPRB/)  
KAO( :, 1, 5,10) = (/&
 & 3.6434E-02_JPRB,3.2049E-02_JPRB,2.7755E-02_JPRB,2.3391E-02_JPRB,1.9132E-02_JPRB,1.4843E-02_JPRB,&
 & 1.0790E-02_JPRB,6.8244E-03_JPRB,4.2858E-02_JPRB/)  
KAO( :, 2, 5,10) = (/&
 & 3.8052E-02_JPRB,3.3555E-02_JPRB,2.9121E-02_JPRB,2.4755E-02_JPRB,2.0357E-02_JPRB,1.6002E-02_JPRB,&
 & 1.1813E-02_JPRB,9.0432E-03_JPRB,5.4802E-02_JPRB/)  
KAO( :, 3, 5,10) = (/&
 & 3.9720E-02_JPRB,3.5157E-02_JPRB,3.0682E-02_JPRB,2.6285E-02_JPRB,2.1672E-02_JPRB,1.7348E-02_JPRB,&
 & 1.3380E-02_JPRB,1.1960E-02_JPRB,7.0286E-02_JPRB/)  
KAO( :, 4, 5,10) = (/&
 & 4.1616E-02_JPRB,3.6963E-02_JPRB,3.2456E-02_JPRB,2.8024E-02_JPRB,2.3329E-02_JPRB,1.9031E-02_JPRB,&
 & 1.6245E-02_JPRB,1.5312E-02_JPRB,8.8323E-02_JPRB/)  
KAO( :, 5, 5,10) = (/&
 & 4.3467E-02_JPRB,3.8778E-02_JPRB,3.4533E-02_JPRB,2.9811E-02_JPRB,2.5445E-02_JPRB,2.1728E-02_JPRB,&
 & 2.0136E-02_JPRB,1.9200E-02_JPRB,1.0804E-01_JPRB/)  
KAO( :, 1, 6,10) = (/&
 & 3.9016E-02_JPRB,3.4252E-02_JPRB,2.9584E-02_JPRB,2.4915E-02_JPRB,2.0266E-02_JPRB,1.5607E-02_JPRB,&
 & 1.1369E-02_JPRB,6.7556E-03_JPRB,6.7432E-02_JPRB/)  
KAO( :, 2, 6,10) = (/&
 & 4.0452E-02_JPRB,3.5642E-02_JPRB,3.0903E-02_JPRB,2.6184E-02_JPRB,2.1443E-02_JPRB,1.6916E-02_JPRB,&
 & 1.2438E-02_JPRB,7.7587E-03_JPRB,8.0666E-02_JPRB/)  
KAO( :, 3, 6,10) = (/&
 & 4.2155E-02_JPRB,3.7272E-02_JPRB,3.2474E-02_JPRB,2.7702E-02_JPRB,2.2975E-02_JPRB,1.8296E-02_JPRB,&
 & 1.3696E-02_JPRB,9.8129E-03_JPRB,9.9349E-02_JPRB/)  
KAO( :, 4, 6,10) = (/&
 & 4.4121E-02_JPRB,3.9182E-02_JPRB,3.4311E-02_JPRB,2.9590E-02_JPRB,2.4570E-02_JPRB,1.9828E-02_JPRB,&
 & 1.5267E-02_JPRB,1.2859E-02_JPRB,1.2445E-01_JPRB/)  
KAO( :, 5, 6,10) = (/&
 & 4.6213E-02_JPRB,4.1161E-02_JPRB,3.6458E-02_JPRB,3.1468E-02_JPRB,2.6559E-02_JPRB,2.1785E-02_JPRB,&
 & 1.7650E-02_JPRB,1.6392E-02_JPRB,1.5469E-01_JPRB/)  
KAO( :, 1, 7,10) = (/&
 & 4.1359E-02_JPRB,3.6208E-02_JPRB,3.1312E-02_JPRB,2.6328E-02_JPRB,2.1267E-02_JPRB,1.6329E-02_JPRB,&
 & 1.1827E-02_JPRB,6.9169E-03_JPRB,1.1368E-01_JPRB/)  
KAO( :, 2, 7,10) = (/&
 & 4.2810E-02_JPRB,3.7687E-02_JPRB,3.2642E-02_JPRB,2.7514E-02_JPRB,2.2469E-02_JPRB,1.7642E-02_JPRB,&
 & 1.2961E-02_JPRB,7.8247E-03_JPRB,1.3536E-01_JPRB/)  
KAO( :, 3, 7,10) = (/&
 & 4.4524E-02_JPRB,3.9305E-02_JPRB,3.4135E-02_JPRB,2.9034E-02_JPRB,2.4045E-02_JPRB,1.9110E-02_JPRB,&
 & 1.4148E-02_JPRB,8.9564E-03_JPRB,1.6103E-01_JPRB/)  
KAO( :, 4, 7,10) = (/&
 & 4.6334E-02_JPRB,4.1093E-02_JPRB,3.5887E-02_JPRB,3.0860E-02_JPRB,2.5799E-02_JPRB,2.0761E-02_JPRB,&
 & 1.5735E-02_JPRB,1.0795E-02_JPRB,1.9350E-01_JPRB/)  
KAO( :, 5, 7,10) = (/&
 & 4.8572E-02_JPRB,4.3224E-02_JPRB,3.8076E-02_JPRB,3.3049E-02_JPRB,2.7908E-02_JPRB,2.2762E-02_JPRB,&
 & 1.7415E-02_JPRB,1.3780E-02_JPRB,2.3787E-01_JPRB/)  
KAO( :, 1, 8,10) = (/&
 & 4.3378E-02_JPRB,3.7958E-02_JPRB,3.2795E-02_JPRB,2.7505E-02_JPRB,2.2211E-02_JPRB,1.6954E-02_JPRB,&
 & 1.2107E-02_JPRB,7.0694E-03_JPRB,2.2556E-01_JPRB/)  
KAO( :, 2, 8,10) = (/&
 & 4.4773E-02_JPRB,3.9362E-02_JPRB,3.4029E-02_JPRB,2.8646E-02_JPRB,2.3299E-02_JPRB,1.8142E-02_JPRB,&
 & 1.3413E-02_JPRB,7.9253E-03_JPRB,2.7089E-01_JPRB/)  
KAO( :, 3, 8,10) = (/&
 & 4.6409E-02_JPRB,4.0922E-02_JPRB,3.5484E-02_JPRB,3.0037E-02_JPRB,2.4685E-02_JPRB,1.9797E-02_JPRB,&
 & 1.4575E-02_JPRB,9.0349E-03_JPRB,3.2354E-01_JPRB/)  
KAO( :, 4, 8,10) = (/&
 & 4.8517E-02_JPRB,4.2960E-02_JPRB,3.7415E-02_JPRB,3.1998E-02_JPRB,2.6730E-02_JPRB,2.1507E-02_JPRB,&
 & 1.6141E-02_JPRB,1.0325E-02_JPRB,3.8344E-01_JPRB/)  
KAO( :, 5, 8,10) = (/&
 & 5.0774E-02_JPRB,4.5143E-02_JPRB,3.9523E-02_JPRB,3.4165E-02_JPRB,2.9055E-02_JPRB,2.3639E-02_JPRB,&
 & 1.7862E-02_JPRB,1.1998E-02_JPRB,4.5852E-01_JPRB/)  
KAO( :, 1, 9,10) = (/&
 & 4.4741E-02_JPRB,3.9148E-02_JPRB,3.3761E-02_JPRB,2.8274E-02_JPRB,2.2811E-02_JPRB,1.7318E-02_JPRB,&
 & 1.2244E-02_JPRB,7.1252E-03_JPRB,8.3568E-01_JPRB/)  
KAO( :, 2, 9,10) = (/&
 & 4.6123E-02_JPRB,4.0465E-02_JPRB,3.4958E-02_JPRB,2.9415E-02_JPRB,2.3808E-02_JPRB,1.8402E-02_JPRB,&
 & 1.3524E-02_JPRB,7.9651E-03_JPRB,1.0063E+00_JPRB/)  
KAO( :, 3, 9,10) = (/&
 & 4.7534E-02_JPRB,4.1886E-02_JPRB,3.6283E-02_JPRB,3.0629E-02_JPRB,2.4989E-02_JPRB,2.0028E-02_JPRB,&
 & 1.4812E-02_JPRB,9.0475E-03_JPRB,1.2094E+00_JPRB/)  
KAO( :, 4, 9,10) = (/&
 & 4.9654E-02_JPRB,4.3880E-02_JPRB,3.8124E-02_JPRB,3.2363E-02_JPRB,2.7020E-02_JPRB,2.1905E-02_JPRB,&
 & 1.6314E-02_JPRB,1.0326E-02_JPRB,1.4400E+00_JPRB/)  
KAO( :, 5, 9,10) = (/&
 & 5.2092E-02_JPRB,4.6279E-02_JPRB,4.0415E-02_JPRB,3.4883E-02_JPRB,2.9494E-02_JPRB,2.4010E-02_JPRB,&
 & 1.8108E-02_JPRB,1.1750E-02_JPRB,1.7026E+00_JPRB/)  
KAO( :, 1,10,10) = (/&
 & 4.5400E-02_JPRB,3.9727E-02_JPRB,3.4202E-02_JPRB,2.8645E-02_JPRB,2.3051E-02_JPRB,1.7520E-02_JPRB,&
 & 1.2293E-02_JPRB,7.0668E-03_JPRB,3.4266E+00_JPRB/)  
KAO( :, 2,10,10) = (/&
 & 4.6758E-02_JPRB,4.0959E-02_JPRB,3.5395E-02_JPRB,2.9735E-02_JPRB,2.3996E-02_JPRB,1.8576E-02_JPRB,&
 & 1.3516E-02_JPRB,7.9973E-03_JPRB,4.1099E+00_JPRB/)  
KAO( :, 3,10,10) = (/&
 & 4.8048E-02_JPRB,4.2318E-02_JPRB,3.6627E-02_JPRB,3.0846E-02_JPRB,2.5140E-02_JPRB,2.0176E-02_JPRB,&
 & 1.4829E-02_JPRB,9.0540E-03_JPRB,4.9855E+00_JPRB/)  
KAO( :, 4,10,10) = (/&
 & 4.9997E-02_JPRB,4.4155E-02_JPRB,3.8326E-02_JPRB,3.2491E-02_JPRB,2.7179E-02_JPRB,2.1979E-02_JPRB,&
 & 1.6362E-02_JPRB,1.0317E-02_JPRB,6.0098E+00_JPRB/)  
KAO( :, 5,10,10) = (/&
 & 5.2444E-02_JPRB,4.6561E-02_JPRB,4.0609E-02_JPRB,3.4910E-02_JPRB,2.9562E-02_JPRB,2.4235E-02_JPRB,&
 & 1.8223E-02_JPRB,1.1743E-02_JPRB,7.1315E+00_JPRB/)  
KAO( :, 1,11,10) = (/&
 & 4.5658E-02_JPRB,3.9952E-02_JPRB,3.4443E-02_JPRB,2.8833E-02_JPRB,2.3231E-02_JPRB,1.7803E-02_JPRB,&
 & 1.2587E-02_JPRB,7.2875E-03_JPRB,5.3649E+00_JPRB/)  
KAO( :, 2,11,10) = (/&
 & 4.6850E-02_JPRB,4.1124E-02_JPRB,3.5510E-02_JPRB,2.9860E-02_JPRB,2.4205E-02_JPRB,1.8972E-02_JPRB,&
 & 1.3852E-02_JPRB,8.2974E-03_JPRB,6.4734E+00_JPRB/)  
KAO( :, 3,11,10) = (/&
 & 4.8321E-02_JPRB,4.2589E-02_JPRB,3.6878E-02_JPRB,3.1119E-02_JPRB,2.5570E-02_JPRB,2.0721E-02_JPRB,&
 & 1.5183E-02_JPRB,9.4279E-03_JPRB,7.8016E+00_JPRB/)  
KAO( :, 4,11,10) = (/&
 & 5.0607E-02_JPRB,4.4776E-02_JPRB,3.8924E-02_JPRB,3.3081E-02_JPRB,2.7944E-02_JPRB,2.2646E-02_JPRB,&
 & 1.6967E-02_JPRB,1.0786E-02_JPRB,9.3814E+00_JPRB/)  
KAO( :, 5,11,10) = (/&
 & 5.3189E-02_JPRB,4.7267E-02_JPRB,4.1301E-02_JPRB,3.5698E-02_JPRB,3.0480E-02_JPRB,2.5061E-02_JPRB,&
 & 1.9030E-02_JPRB,1.2260E-02_JPRB,1.1143E+01_JPRB/)  
KAO( :, 1,12,10) = (/&
 & 4.4854E-02_JPRB,3.9248E-02_JPRB,3.3879E-02_JPRB,2.8362E-02_JPRB,2.2914E-02_JPRB,1.7730E-02_JPRB,&
 & 1.2612E-02_JPRB,7.3730E-03_JPRB,6.1785E+00_JPRB/)  
KAO( :, 2,12,10) = (/&
 & 4.6033E-02_JPRB,4.0478E-02_JPRB,3.4947E-02_JPRB,2.9376E-02_JPRB,2.4012E-02_JPRB,1.9043E-02_JPRB,&
 & 1.3870E-02_JPRB,8.4065E-03_JPRB,7.5551E+00_JPRB/)  
KAO( :, 3,12,10) = (/&
 & 4.7929E-02_JPRB,4.2284E-02_JPRB,3.6631E-02_JPRB,3.0973E-02_JPRB,2.5841E-02_JPRB,2.0835E-02_JPRB,&
 & 1.5374E-02_JPRB,9.6454E-03_JPRB,9.2004E+00_JPRB/)  
KAO( :, 4,12,10) = (/&
 & 5.0374E-02_JPRB,4.4657E-02_JPRB,3.8857E-02_JPRB,3.3248E-02_JPRB,2.8288E-02_JPRB,2.3006E-02_JPRB,&
 & 1.7300E-02_JPRB,1.1060E-02_JPRB,1.0995E+01_JPRB/)  
KAO( :, 5,12,10) = (/&
 & 5.3127E-02_JPRB,4.7293E-02_JPRB,4.1498E-02_JPRB,3.6136E-02_JPRB,3.1085E-02_JPRB,2.5531E-02_JPRB,&
 & 1.9582E-02_JPRB,1.2642E-02_JPRB,1.3019E+01_JPRB/)  
KAO( :, 1,13,10) = (/&
 & 4.3325E-02_JPRB,3.7930E-02_JPRB,3.2755E-02_JPRB,2.7447E-02_JPRB,2.2319E-02_JPRB,1.7411E-02_JPRB,&
 & 1.2453E-02_JPRB,7.3368E-03_JPRB,5.8866E+00_JPRB/)  
KAO( :, 2,13,10) = (/&
 & 4.4885E-02_JPRB,3.9512E-02_JPRB,3.4133E-02_JPRB,2.8720E-02_JPRB,2.3711E-02_JPRB,1.8875E-02_JPRB,&
 & 1.3756E-02_JPRB,8.3802E-03_JPRB,7.1313E+00_JPRB/)  
KAO( :, 3,13,10) = (/&
 & 4.7105E-02_JPRB,4.1602E-02_JPRB,3.6075E-02_JPRB,3.0646E-02_JPRB,2.5891E-02_JPRB,2.0741E-02_JPRB,&
 & 1.5481E-02_JPRB,9.7027E-03_JPRB,8.6483E+00_JPRB/)  
KAO( :, 4,13,10) = (/&
 & 4.9710E-02_JPRB,4.4134E-02_JPRB,3.8464E-02_JPRB,3.3281E-02_JPRB,2.8408E-02_JPRB,2.3139E-02_JPRB,&
 & 1.7501E-02_JPRB,1.1201E-02_JPRB,1.0384E+01_JPRB/)  
KAO( :, 5,13,10) = (/&
 & 5.2678E-02_JPRB,4.7001E-02_JPRB,4.1355E-02_JPRB,3.6354E-02_JPRB,3.1421E-02_JPRB,2.5818E-02_JPRB,&
 & 1.9874E-02_JPRB,1.2850E-02_JPRB,1.2332E+01_JPRB/)  
KAO( :, 1, 1,11) = (/&
 & 3.4006E-02_JPRB,3.0838E-02_JPRB,2.8315E-02_JPRB,2.6031E-02_JPRB,2.3204E-02_JPRB,2.0875E-02_JPRB,&
 & 1.7987E-02_JPRB,1.5519E-02_JPRB,2.1659E-02_JPRB/)  
KAO( :, 2, 1,11) = (/&
 & 3.8880E-02_JPRB,3.5625E-02_JPRB,3.3192E-02_JPRB,3.0992E-02_JPRB,2.8389E-02_JPRB,2.5986E-02_JPRB,&
 & 2.2691E-02_JPRB,2.0442E-02_JPRB,2.7838E-02_JPRB/)  
KAO( :, 3, 1,11) = (/&
 & 4.3962E-02_JPRB,4.0825E-02_JPRB,3.8703E-02_JPRB,3.6297E-02_JPRB,3.4511E-02_JPRB,3.1450E-02_JPRB,&
 & 2.8328E-02_JPRB,2.6446E-02_JPRB,3.5353E-02_JPRB/)  
KAO( :, 4, 1,11) = (/&
 & 4.9311E-02_JPRB,4.6293E-02_JPRB,4.4623E-02_JPRB,4.2521E-02_JPRB,4.0745E-02_JPRB,3.7590E-02_JPRB,&
 & 3.5066E-02_JPRB,3.3577E-02_JPRB,4.4098E-02_JPRB/)  
KAO( :, 5, 1,11) = (/&
 & 5.4902E-02_JPRB,5.1787E-02_JPRB,5.0538E-02_JPRB,4.9462E-02_JPRB,4.7171E-02_JPRB,4.4663E-02_JPRB,&
 & 4.2782E-02_JPRB,4.2346E-02_JPRB,5.4138E-02_JPRB/)  
KAO( :, 1, 2,11) = (/&
 & 3.3012E-02_JPRB,2.9524E-02_JPRB,2.6537E-02_JPRB,2.4015E-02_JPRB,2.1124E-02_JPRB,1.8957E-02_JPRB,&
 & 1.6213E-02_JPRB,1.4498E-02_JPRB,2.4045E-02_JPRB/)  
KAO( :, 2, 2,11) = (/&
 & 3.6932E-02_JPRB,3.3550E-02_JPRB,3.1000E-02_JPRB,2.8534E-02_JPRB,2.6293E-02_JPRB,2.3594E-02_JPRB,&
 & 2.0668E-02_JPRB,1.9041E-02_JPRB,3.0483E-02_JPRB/)  
KAO( :, 3, 2,11) = (/&
 & 4.1673E-02_JPRB,3.8445E-02_JPRB,3.6326E-02_JPRB,3.3911E-02_JPRB,3.1922E-02_JPRB,2.8763E-02_JPRB,&
 & 2.6126E-02_JPRB,2.4581E-02_JPRB,3.8179E-02_JPRB/)  
KAO( :, 4, 2,11) = (/&
 & 4.6918E-02_JPRB,4.3776E-02_JPRB,4.1906E-02_JPRB,4.0246E-02_JPRB,3.7729E-02_JPRB,3.4837E-02_JPRB,&
 & 3.2578E-02_JPRB,3.1324E-02_JPRB,4.7309E-02_JPRB/)  
KAO( :, 5, 2,11) = (/&
 & 5.2471E-02_JPRB,4.9278E-02_JPRB,4.7809E-02_JPRB,4.6827E-02_JPRB,4.4067E-02_JPRB,4.1837E-02_JPRB,&
 & 4.0124E-02_JPRB,3.9172E-02_JPRB,5.7813E-02_JPRB/)  
KAO( :, 1, 3,11) = (/&
 & 3.4501E-02_JPRB,3.0473E-02_JPRB,2.6575E-02_JPRB,2.2929E-02_JPRB,1.9181E-02_JPRB,1.6191E-02_JPRB,&
 & 1.4206E-02_JPRB,1.2625E-02_JPRB,3.1974E-02_JPRB/)  
KAO( :, 2, 3,11) = (/&
 & 3.6715E-02_JPRB,3.2658E-02_JPRB,2.9031E-02_JPRB,2.5829E-02_JPRB,2.3118E-02_JPRB,2.0224E-02_JPRB,&
 & 1.8346E-02_JPRB,1.6857E-02_JPRB,4.0926E-02_JPRB/)  
KAO( :, 3, 3,11) = (/&
 & 3.9788E-02_JPRB,3.6029E-02_JPRB,3.3165E-02_JPRB,3.0553E-02_JPRB,2.7991E-02_JPRB,2.5038E-02_JPRB,&
 & 2.3354E-02_JPRB,2.2060E-02_JPRB,5.0503E-02_JPRB/)  
KAO( :, 4, 3,11) = (/&
 & 4.4214E-02_JPRB,4.0649E-02_JPRB,3.8329E-02_JPRB,3.6284E-02_JPRB,3.3473E-02_JPRB,3.0774E-02_JPRB,&
 & 2.9336E-02_JPRB,2.8146E-02_JPRB,6.1109E-02_JPRB/)  
KAO( :, 5, 3,11) = (/&
 & 4.9685E-02_JPRB,4.6100E-02_JPRB,4.4117E-02_JPRB,4.2257E-02_JPRB,3.9617E-02_JPRB,3.7525E-02_JPRB,&
 & 3.6458E-02_JPRB,3.5132E-02_JPRB,7.3052E-02_JPRB/)  
KAO( :, 1, 4,11) = (/&
 & 3.7701E-02_JPRB,3.3183E-02_JPRB,2.8775E-02_JPRB,2.4369E-02_JPRB,1.9949E-02_JPRB,1.5608E-02_JPRB,&
 & 1.2337E-02_JPRB,1.0909E-02_JPRB,4.5234E-02_JPRB/)  
KAO( :, 2, 4,11) = (/&
 & 3.9570E-02_JPRB,3.4927E-02_JPRB,3.0377E-02_JPRB,2.5987E-02_JPRB,2.1638E-02_JPRB,1.7716E-02_JPRB,&
 & 1.5957E-02_JPRB,1.4485E-02_JPRB,5.8101E-02_JPRB/)  
KAO( :, 3, 4,11) = (/&
 & 4.1487E-02_JPRB,3.6886E-02_JPRB,3.2552E-02_JPRB,2.8478E-02_JPRB,2.4613E-02_JPRB,2.1797E-02_JPRB,&
 & 2.0639E-02_JPRB,1.9138E-02_JPRB,7.3443E-02_JPRB/)  
KAO( :, 4, 4,11) = (/&
 & 4.4074E-02_JPRB,3.9637E-02_JPRB,3.5709E-02_JPRB,3.2584E-02_JPRB,2.9098E-02_JPRB,2.7106E-02_JPRB,&
 & 2.6271E-02_JPRB,2.4880E-02_JPRB,9.0496E-02_JPRB/)  
KAO( :, 5, 4,11) = (/&
 & 4.7920E-02_JPRB,4.3761E-02_JPRB,4.0716E-02_JPRB,3.7902E-02_JPRB,3.4829E-02_JPRB,3.3417E-02_JPRB,&
 & 3.2862E-02_JPRB,3.1333E-02_JPRB,1.0813E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART8',0,ZHOOK_HANDLE)


KAO( :, 1, 5,11) = (/&
 & 4.1870E-02_JPRB,3.6784E-02_JPRB,3.1817E-02_JPRB,2.6817E-02_JPRB,2.1907E-02_JPRB,1.6884E-02_JPRB,&
 & 1.2273E-02_JPRB,9.3968E-03_JPRB,6.4840E-02_JPRB/)  
KAO( :, 2, 5,11) = (/&
 & 4.3297E-02_JPRB,3.8168E-02_JPRB,3.3137E-02_JPRB,2.8168E-02_JPRB,2.3151E-02_JPRB,1.8216E-02_JPRB,&
 & 1.4106E-02_JPRB,1.2594E-02_JPRB,8.4416E-02_JPRB/)  
KAO( :, 3, 5,11) = (/&
 & 4.5197E-02_JPRB,3.9955E-02_JPRB,3.4866E-02_JPRB,2.9774E-02_JPRB,2.4780E-02_JPRB,2.0210E-02_JPRB,&
 & 1.7877E-02_JPRB,1.6653E-02_JPRB,1.0767E-01_JPRB/)  
KAO( :, 4, 5,11) = (/&
 & 4.7208E-02_JPRB,4.1906E-02_JPRB,3.6778E-02_JPRB,3.1900E-02_JPRB,2.6959E-02_JPRB,2.4148E-02_JPRB,&
 & 2.3054E-02_JPRB,2.1659E-02_JPRB,1.3362E-01_JPRB/)  
KAO( :, 5, 5,11) = (/&
 & 4.9723E-02_JPRB,4.4415E-02_JPRB,3.9606E-02_JPRB,3.5130E-02_JPRB,3.1176E-02_JPRB,2.9987E-02_JPRB,&
 & 2.9188E-02_JPRB,2.7574E-02_JPRB,1.6267E-01_JPRB/)  
KAO( :, 1, 6,11) = (/&
 & 4.6177E-02_JPRB,4.0428E-02_JPRB,3.5000E-02_JPRB,2.9479E-02_JPRB,2.3910E-02_JPRB,1.8380E-02_JPRB,&
 & 1.3182E-02_JPRB,8.0681E-03_JPRB,9.4271E-02_JPRB/)  
KAO( :, 2, 6,11) = (/&
 & 4.7848E-02_JPRB,4.2133E-02_JPRB,3.6528E-02_JPRB,3.0847E-02_JPRB,2.5231E-02_JPRB,1.9720E-02_JPRB,&
 & 1.4391E-02_JPRB,1.0657E-02_JPRB,1.2169E-01_JPRB/)  
KAO( :, 3, 6,11) = (/&
 & 4.9573E-02_JPRB,4.3747E-02_JPRB,3.7998E-02_JPRB,3.2369E-02_JPRB,2.6844E-02_JPRB,2.1245E-02_JPRB,&
 & 1.6159E-02_JPRB,1.4369E-02_JPRB,1.5614E-01_JPRB/)  
KAO( :, 4, 6,11) = (/&
 & 5.1449E-02_JPRB,4.5620E-02_JPRB,3.9881E-02_JPRB,3.4359E-02_JPRB,2.8492E-02_JPRB,2.3216E-02_JPRB,&
 & 1.9980E-02_JPRB,1.8809E-02_JPRB,1.9622E-01_JPRB/)  
KAO( :, 5, 6,11) = (/&
 & 5.3758E-02_JPRB,4.7819E-02_JPRB,4.2046E-02_JPRB,3.6553E-02_JPRB,3.0747E-02_JPRB,2.6899E-02_JPRB,&
 & 2.5355E-02_JPRB,2.3973E-02_JPRB,2.4061E-01_JPRB/)  
KAO( :, 1, 7,11) = (/&
 & 5.0539E-02_JPRB,4.4226E-02_JPRB,3.8237E-02_JPRB,3.2119E-02_JPRB,2.5955E-02_JPRB,1.9850E-02_JPRB,&
 & 1.4014E-02_JPRB,8.2656E-03_JPRB,1.5715E-01_JPRB/)  
KAO( :, 2, 7,11) = (/&
 & 5.2213E-02_JPRB,4.5893E-02_JPRB,3.9703E-02_JPRB,3.3446E-02_JPRB,2.7259E-02_JPRB,2.1129E-02_JPRB,&
 & 1.5451E-02_JPRB,9.4123E-03_JPRB,1.9172E-01_JPRB/)  
KAO( :, 3, 7,11) = (/&
 & 5.3964E-02_JPRB,4.7586E-02_JPRB,4.1300E-02_JPRB,3.5018E-02_JPRB,2.8812E-02_JPRB,2.2874E-02_JPRB,&
 & 1.6862E-02_JPRB,1.2078E-02_JPRB,2.4474E-01_JPRB/)  
KAO( :, 4, 7,11) = (/&
 & 5.6281E-02_JPRB,4.9820E-02_JPRB,4.3435E-02_JPRB,3.7102E-02_JPRB,3.0863E-02_JPRB,2.4675E-02_JPRB,&
 & 1.8760E-02_JPRB,1.6116E-02_JPRB,3.1097E-01_JPRB/)  
KAO( :, 5, 7,11) = (/&
 & 5.8608E-02_JPRB,5.2097E-02_JPRB,4.5621E-02_JPRB,3.9415E-02_JPRB,3.3038E-02_JPRB,2.6921E-02_JPRB,&
 & 2.2270E-02_JPRB,2.0802E-02_JPRB,3.8459E-01_JPRB/)  
KAO( :, 1, 8,11) = (/&
 & 5.4836E-02_JPRB,4.7985E-02_JPRB,4.1396E-02_JPRB,3.4685E-02_JPRB,2.8011E-02_JPRB,2.1239E-02_JPRB,&
 & 1.4808E-02_JPRB,8.7162E-03_JPRB,3.2201E-01_JPRB/)  
KAO( :, 2, 8,11) = (/&
 & 5.6598E-02_JPRB,4.9598E-02_JPRB,4.2901E-02_JPRB,3.6120E-02_JPRB,2.9254E-02_JPRB,2.2462E-02_JPRB,&
 & 1.6430E-02_JPRB,9.7013E-03_JPRB,3.8537E-01_JPRB/)  
KAO( :, 3, 8,11) = (/&
 & 5.8383E-02_JPRB,5.1431E-02_JPRB,4.4592E-02_JPRB,3.7658E-02_JPRB,3.0762E-02_JPRB,2.4304E-02_JPRB,&
 & 1.8006E-02_JPRB,1.1047E-02_JPRB,4.7230E-01_JPRB/)  
KAO( :, 4, 8,11) = (/&
 & 6.0542E-02_JPRB,5.3465E-02_JPRB,4.6470E-02_JPRB,3.9515E-02_JPRB,3.2802E-02_JPRB,2.6370E-02_JPRB,&
 & 1.9678E-02_JPRB,1.3674E-02_JPRB,5.9222E-01_JPRB/)  
KAO( :, 5, 8,11) = (/&
 & 6.3504E-02_JPRB,5.6367E-02_JPRB,4.9211E-02_JPRB,4.2376E-02_JPRB,3.5393E-02_JPRB,2.8477E-02_JPRB,&
 & 2.1872E-02_JPRB,1.7879E-02_JPRB,7.4060E-01_JPRB/)  
KAO( :, 1, 9,11) = (/&
 & 5.8530E-02_JPRB,5.1215E-02_JPRB,4.4050E-02_JPRB,3.6938E-02_JPRB,2.9723E-02_JPRB,2.2521E-02_JPRB,&
 & 1.5575E-02_JPRB,8.9613E-03_JPRB,1.2250E+00_JPRB/)  
KAO( :, 2, 9,11) = (/&
 & 6.0508E-02_JPRB,5.2947E-02_JPRB,4.5790E-02_JPRB,3.8466E-02_JPRB,3.1050E-02_JPRB,2.3735E-02_JPRB,&
 & 1.7082E-02_JPRB,1.0081E-02_JPRB,1.4743E+00_JPRB/)  
KAO( :, 3, 9,11) = (/&
 & 6.2412E-02_JPRB,5.4914E-02_JPRB,4.7544E-02_JPRB,4.0031E-02_JPRB,3.2611E-02_JPRB,2.5512E-02_JPRB,&
 & 1.8968E-02_JPRB,1.1343E-02_JPRB,1.7744E+00_JPRB/)  
KAO( :, 4, 9,11) = (/&
 & 6.4422E-02_JPRB,5.6870E-02_JPRB,4.9390E-02_JPRB,4.1890E-02_JPRB,3.4611E-02_JPRB,2.7684E-02_JPRB,&
 & 2.0680E-02_JPRB,1.2948E-02_JPRB,2.1658E+00_JPRB/)  
KAO( :, 5, 9,11) = (/&
 & 6.7272E-02_JPRB,5.9620E-02_JPRB,5.1959E-02_JPRB,4.4449E-02_JPRB,3.7070E-02_JPRB,3.0178E-02_JPRB,&
 & 2.2884E-02_JPRB,1.5505E-02_JPRB,2.6879E+00_JPRB/)  
KAO( :, 1,10,11) = (/&
 & 6.1580E-02_JPRB,5.3887E-02_JPRB,4.6212E-02_JPRB,3.8787E-02_JPRB,3.1170E-02_JPRB,2.3588E-02_JPRB,&
 & 1.6242E-02_JPRB,9.1562E-03_JPRB,5.0131E+00_JPRB/)  
KAO( :, 2,10,11) = (/&
 & 6.3734E-02_JPRB,5.5768E-02_JPRB,4.8169E-02_JPRB,4.0370E-02_JPRB,3.2604E-02_JPRB,2.4832E-02_JPRB,&
 & 1.7635E-02_JPRB,1.0375E-02_JPRB,6.1201E+00_JPRB/)  
KAO( :, 3,10,11) = (/&
 & 6.5820E-02_JPRB,5.7831E-02_JPRB,4.9999E-02_JPRB,4.2115E-02_JPRB,3.4203E-02_JPRB,2.6490E-02_JPRB,&
 & 1.9622E-02_JPRB,1.1697E-02_JPRB,7.4107E+00_JPRB/)  
KAO( :, 4,10,11) = (/&
 & 6.7912E-02_JPRB,5.9913E-02_JPRB,5.1985E-02_JPRB,4.3986E-02_JPRB,3.6001E-02_JPRB,2.8914E-02_JPRB,&
 & 2.1590E-02_JPRB,1.3339E-02_JPRB,9.0185E+00_JPRB/)  
KAO( :, 5,10,11) = (/&
 & 7.0732E-02_JPRB,6.2601E-02_JPRB,5.4503E-02_JPRB,4.6414E-02_JPRB,3.8865E-02_JPRB,3.1467E-02_JPRB,&
 & 2.3923E-02_JPRB,1.5241E-02_JPRB,1.1156E+01_JPRB/)  
KAO( :, 1,11,11) = (/&
 & 6.4605E-02_JPRB,5.6532E-02_JPRB,4.8552E-02_JPRB,4.0738E-02_JPRB,3.2744E-02_JPRB,2.4819E-02_JPRB,&
 & 1.7263E-02_JPRB,9.7908E-03_JPRB,7.8274E+00_JPRB/)  
KAO( :, 2,11,11) = (/&
 & 6.6894E-02_JPRB,5.8534E-02_JPRB,5.0603E-02_JPRB,4.2448E-02_JPRB,3.4262E-02_JPRB,2.6260E-02_JPRB,&
 & 1.8818E-02_JPRB,1.1087E-02_JPRB,9.5674E+00_JPRB/)  
KAO( :, 3,11,11) = (/&
 & 6.9134E-02_JPRB,6.0821E-02_JPRB,5.2610E-02_JPRB,4.4286E-02_JPRB,3.6011E-02_JPRB,2.8243E-02_JPRB,&
 & 2.0923E-02_JPRB,1.2641E-02_JPRB,1.1695E+01_JPRB/)  
KAO( :, 4,11,11) = (/&
 & 7.1444E-02_JPRB,6.3062E-02_JPRB,5.4727E-02_JPRB,4.6341E-02_JPRB,3.8163E-02_JPRB,3.0937E-02_JPRB,&
 & 2.3046E-02_JPRB,1.4407E-02_JPRB,1.4290E+01_JPRB/)  
KAO( :, 5,11,11) = (/&
 & 7.4689E-02_JPRB,6.6247E-02_JPRB,5.7761E-02_JPRB,4.9331E-02_JPRB,4.1557E-02_JPRB,3.3813E-02_JPRB,&
 & 2.5726E-02_JPRB,1.6474E-02_JPRB,1.7723E+01_JPRB/)  
KAO( :, 1,12,11) = (/&
 & 6.6565E-02_JPRB,5.8241E-02_JPRB,5.0116E-02_JPRB,4.2016E-02_JPRB,3.3802E-02_JPRB,2.5721E-02_JPRB,&
 & 1.8057E-02_JPRB,1.0339E-02_JPRB,9.3068E+00_JPRB/)  
KAO( :, 2,12,11) = (/&
 & 6.8895E-02_JPRB,6.0321E-02_JPRB,5.2166E-02_JPRB,4.3813E-02_JPRB,3.5352E-02_JPRB,2.7349E-02_JPRB,&
 & 1.9762E-02_JPRB,1.1726E-02_JPRB,1.1320E+01_JPRB/)  
KAO( :, 3,12,11) = (/&
 & 7.1293E-02_JPRB,6.2788E-02_JPRB,5.4349E-02_JPRB,4.5762E-02_JPRB,3.7291E-02_JPRB,2.9714E-02_JPRB,&
 & 2.1861E-02_JPRB,1.3399E-02_JPRB,1.3746E+01_JPRB/)  
KAO( :, 4,12,11) = (/&
 & 7.4182E-02_JPRB,6.5550E-02_JPRB,5.6943E-02_JPRB,4.8285E-02_JPRB,4.0149E-02_JPRB,3.2582E-02_JPRB,&
 & 2.4300E-02_JPRB,1.5394E-02_JPRB,1.6888E+01_JPRB/)  
KAO( :, 5,12,11) = (/&
 & 7.7769E-02_JPRB,6.9096E-02_JPRB,6.0288E-02_JPRB,5.1657E-02_JPRB,4.3787E-02_JPRB,3.5953E-02_JPRB,&
 & 2.7241E-02_JPRB,1.7571E-02_JPRB,2.0864E+01_JPRB/)  
KAO( :, 1,13,11) = (/&
 & 6.7288E-02_JPRB,5.8877E-02_JPRB,5.0755E-02_JPRB,4.2517E-02_JPRB,3.4247E-02_JPRB,2.6263E-02_JPRB,&
 & 1.8588E-02_JPRB,1.0728E-02_JPRB,8.9064E+00_JPRB/)  
KAO( :, 2,13,11) = (/&
 & 6.9672E-02_JPRB,6.1086E-02_JPRB,5.2816E-02_JPRB,4.4401E-02_JPRB,3.5953E-02_JPRB,2.8119E-02_JPRB,&
 & 2.0390E-02_JPRB,1.2229E-02_JPRB,1.0911E+01_JPRB/)  
KAO( :, 3,13,11) = (/&
 & 7.2646E-02_JPRB,6.4043E-02_JPRB,5.5467E-02_JPRB,4.6763E-02_JPRB,3.8350E-02_JPRB,3.0852E-02_JPRB,&
 & 2.2586E-02_JPRB,1.3987E-02_JPRB,1.3268E+01_JPRB/)  
KAO( :, 4,13,11) = (/&
 & 7.6364E-02_JPRB,6.7563E-02_JPRB,5.8748E-02_JPRB,4.9899E-02_JPRB,4.1863E-02_JPRB,3.3973E-02_JPRB,&
 & 2.5440E-02_JPRB,1.6181E-02_JPRB,1.6175E+01_JPRB/)  
KAO( :, 5,13,11) = (/&
 & 8.0410E-02_JPRB,7.1534E-02_JPRB,6.2509E-02_JPRB,5.3806E-02_JPRB,4.5873E-02_JPRB,3.7854E-02_JPRB,&
 & 2.8649E-02_JPRB,1.8582E-02_JPRB,1.9867E+01_JPRB/)  
KAO( :, 1, 1,12) = (/&
 & 4.9841E-02_JPRB,4.4490E-02_JPRB,4.1303E-02_JPRB,3.7661E-02_JPRB,3.4374E-02_JPRB,3.0218E-02_JPRB,&
 & 2.6408E-02_JPRB,2.2425E-02_JPRB,3.2278E-02_JPRB/)  
KAO( :, 2, 1,12) = (/&
 & 5.7650E-02_JPRB,5.2260E-02_JPRB,4.8821E-02_JPRB,4.5102E-02_JPRB,4.1618E-02_JPRB,3.7433E-02_JPRB,&
 & 3.4112E-02_JPRB,2.9968E-02_JPRB,4.1893E-02_JPRB/)  
KAO( :, 3, 1,12) = (/&
 & 6.5474E-02_JPRB,6.0019E-02_JPRB,5.6468E-02_JPRB,5.3494E-02_JPRB,4.9266E-02_JPRB,4.6229E-02_JPRB,&
 & 4.2427E-02_JPRB,3.9480E-02_JPRB,5.2169E-02_JPRB/)  
KAO( :, 4, 1,12) = (/&
 & 7.3266E-02_JPRB,6.7747E-02_JPRB,6.4431E-02_JPRB,6.2152E-02_JPRB,5.8324E-02_JPRB,5.6278E-02_JPRB,&
 & 5.1411E-02_JPRB,5.1078E-02_JPRB,6.3958E-02_JPRB/)  
KAO( :, 5, 1,12) = (/&
 & 8.0950E-02_JPRB,7.5647E-02_JPRB,7.3090E-02_JPRB,7.0878E-02_JPRB,6.8730E-02_JPRB,6.6425E-02_JPRB,&
 & 6.1537E-02_JPRB,6.4721E-02_JPRB,7.7752E-02_JPRB/)  
KAO( :, 1, 2,12) = (/&
 & 4.6529E-02_JPRB,4.1918E-02_JPRB,3.8638E-02_JPRB,3.5085E-02_JPRB,3.2117E-02_JPRB,2.7976E-02_JPRB,&
 & 2.4660E-02_JPRB,2.0193E-02_JPRB,3.6378E-02_JPRB/)  
KAO( :, 2, 2,12) = (/&
 & 5.4059E-02_JPRB,4.9350E-02_JPRB,4.6045E-02_JPRB,4.2538E-02_JPRB,3.9123E-02_JPRB,3.5351E-02_JPRB,&
 & 3.1963E-02_JPRB,2.6590E-02_JPRB,4.7334E-02_JPRB/)  
KAO( :, 3, 2,12) = (/&
 & 6.1738E-02_JPRB,5.6865E-02_JPRB,5.3592E-02_JPRB,5.0849E-02_JPRB,4.7212E-02_JPRB,4.4241E-02_JPRB,&
 & 3.9834E-02_JPRB,3.4654E-02_JPRB,5.9199E-02_JPRB/)  
KAO( :, 4, 2,12) = (/&
 & 6.9699E-02_JPRB,6.4653E-02_JPRB,6.1768E-02_JPRB,5.9341E-02_JPRB,5.6731E-02_JPRB,5.3710E-02_JPRB,&
 & 4.8897E-02_JPRB,4.4731E-02_JPRB,7.2042E-02_JPRB/)  
KAO( :, 5, 2,12) = (/&
 & 7.7745E-02_JPRB,7.2901E-02_JPRB,7.0552E-02_JPRB,6.8743E-02_JPRB,6.7472E-02_JPRB,6.3767E-02_JPRB,&
 & 5.9291E-02_JPRB,5.7415E-02_JPRB,8.6627E-02_JPRB/)  
KAO( :, 1, 3,12) = (/&
 & 4.2062E-02_JPRB,3.7711E-02_JPRB,3.4334E-02_JPRB,3.0926E-02_JPRB,2.8025E-02_JPRB,2.4558E-02_JPRB,&
 & 2.1311E-02_JPRB,1.7634E-02_JPRB,4.9902E-02_JPRB/)  
KAO( :, 2, 3,12) = (/&
 & 4.8678E-02_JPRB,4.4324E-02_JPRB,4.1100E-02_JPRB,3.8070E-02_JPRB,3.4742E-02_JPRB,3.1650E-02_JPRB,&
 & 2.7890E-02_JPRB,2.3218E-02_JPRB,6.2894E-02_JPRB/)  
KAO( :, 3, 3,12) = (/&
 & 5.6167E-02_JPRB,5.1670E-02_JPRB,4.8444E-02_JPRB,4.5977E-02_JPRB,4.2837E-02_JPRB,4.0019E-02_JPRB,&
 & 3.5364E-02_JPRB,3.0176E-02_JPRB,7.8591E-02_JPRB/)  
KAO( :, 4, 3,12) = (/&
 & 6.3921E-02_JPRB,5.9620E-02_JPRB,5.6596E-02_JPRB,5.4403E-02_JPRB,5.2332E-02_JPRB,4.8849E-02_JPRB,&
 & 4.4022E-02_JPRB,3.8881E-02_JPRB,9.6792E-02_JPRB/)  
KAO( :, 5, 3,12) = (/&
 & 7.1755E-02_JPRB,6.7802E-02_JPRB,6.5648E-02_JPRB,6.4060E-02_JPRB,6.2628E-02_JPRB,5.8608E-02_JPRB,&
 & 5.3986E-02_JPRB,4.9725E-02_JPRB,1.1574E-01_JPRB/)  
KAO( :, 1, 4,12) = (/&
 & 4.2323E-02_JPRB,3.7345E-02_JPRB,3.2720E-02_JPRB,2.8218E-02_JPRB,2.4532E-02_JPRB,2.0757E-02_JPRB,&
 & 1.8047E-02_JPRB,1.5414E-02_JPRB,7.5075E-02_JPRB/)  
KAO( :, 2, 4,12) = (/&
 & 4.5621E-02_JPRB,4.0856E-02_JPRB,3.6741E-02_JPRB,3.3228E-02_JPRB,3.0105E-02_JPRB,2.7246E-02_JPRB,&
 & 2.3891E-02_JPRB,2.0542E-02_JPRB,9.4476E-02_JPRB/)  
KAO( :, 3, 4,12) = (/&
 & 5.0938E-02_JPRB,4.6389E-02_JPRB,4.2972E-02_JPRB,4.0292E-02_JPRB,3.7820E-02_JPRB,3.4834E-02_JPRB,&
 & 3.0651E-02_JPRB,2.6871E-02_JPRB,1.1638E-01_JPRB/)  
KAO( :, 4, 4,12) = (/&
 & 5.7835E-02_JPRB,5.3600E-02_JPRB,5.0835E-02_JPRB,4.8668E-02_JPRB,4.6908E-02_JPRB,4.3138E-02_JPRB,&
 & 3.8678E-02_JPRB,3.4608E-02_JPRB,1.4036E-01_JPRB/)  
KAO( :, 5, 4,12) = (/&
 & 6.5625E-02_JPRB,6.1550E-02_JPRB,5.9598E-02_JPRB,5.8329E-02_JPRB,5.6532E-02_JPRB,5.2486E-02_JPRB,&
 & 4.8246E-02_JPRB,4.4046E-02_JPRB,1.6774E-01_JPRB/)  
KAO( :, 1, 5,12) = (/&
 & 4.7313E-02_JPRB,4.1507E-02_JPRB,3.5955E-02_JPRB,3.0395E-02_JPRB,2.4915E-02_JPRB,1.9463E-02_JPRB,&
 & 1.5471E-02_JPRB,1.3526E-02_JPRB,1.1349E-01_JPRB/)  
KAO( :, 2, 5,12) = (/&
 & 4.9244E-02_JPRB,4.3467E-02_JPRB,3.7885E-02_JPRB,3.2452E-02_JPRB,2.7414E-02_JPRB,2.3444E-02_JPRB,&
 & 2.0705E-02_JPRB,1.8174E-02_JPRB,1.4301E-01_JPRB/)  
KAO( :, 3, 5,12) = (/&
 & 5.1407E-02_JPRB,4.5739E-02_JPRB,4.0584E-02_JPRB,3.6389E-02_JPRB,3.2936E-02_JPRB,2.9965E-02_JPRB,&
 & 2.6974E-02_JPRB,2.4069E-02_JPRB,1.7509E-01_JPRB/)  
KAO( :, 4, 5,12) = (/&
 & 5.5244E-02_JPRB,5.0142E-02_JPRB,4.5994E-02_JPRB,4.3212E-02_JPRB,4.1091E-02_JPRB,3.7645E-02_JPRB,&
 & 3.4454E-02_JPRB,3.1352E-02_JPRB,2.1139E-01_JPRB/)  
KAO( :, 5, 5,12) = (/&
 & 6.0988E-02_JPRB,5.6526E-02_JPRB,5.3622E-02_JPRB,5.2392E-02_JPRB,5.0078E-02_JPRB,4.6505E-02_JPRB,&
 & 4.3357E-02_JPRB,4.0176E-02_JPRB,2.5233E-01_JPRB/)  
KAO( :, 1, 6,12) = (/&
 & 5.3543E-02_JPRB,4.6854E-02_JPRB,4.0556E-02_JPRB,3.4124E-02_JPRB,2.7581E-02_JPRB,2.1205E-02_JPRB,&
 & 1.5012E-02_JPRB,1.1854E-02_JPRB,1.6344E-01_JPRB/)  
KAO( :, 2, 6,12) = (/&
 & 5.5268E-02_JPRB,4.8609E-02_JPRB,4.2123E-02_JPRB,3.5498E-02_JPRB,2.9110E-02_JPRB,2.2794E-02_JPRB,&
 & 1.8116E-02_JPRB,1.5898E-02_JPRB,2.0983E-01_JPRB/)  
KAO( :, 3, 6,12) = (/&
 & 5.7133E-02_JPRB,5.0456E-02_JPRB,4.3928E-02_JPRB,3.7527E-02_JPRB,3.1445E-02_JPRB,2.6337E-02_JPRB,&
 & 2.3556E-02_JPRB,2.1068E-02_JPRB,2.6329E-01_JPRB/)  
KAO( :, 4, 6,12) = (/&
 & 5.9454E-02_JPRB,5.2789E-02_JPRB,4.6413E-02_JPRB,4.0569E-02_JPRB,3.6370E-02_JPRB,3.2588E-02_JPRB,&
 & 3.0510E-02_JPRB,2.7765E-02_JPRB,3.2205E-01_JPRB/)  
KAO( :, 5, 6,12) = (/&
 & 6.2205E-02_JPRB,5.6007E-02_JPRB,5.0615E-02_JPRB,4.6993E-02_JPRB,4.3715E-02_JPRB,4.0774E-02_JPRB,&
 & 3.8896E-02_JPRB,3.6103E-02_JPRB,3.8619E-01_JPRB/)  
KAO( :, 1, 7,12) = (/&
 & 6.0265E-02_JPRB,5.2736E-02_JPRB,4.5532E-02_JPRB,3.8162E-02_JPRB,3.0863E-02_JPRB,2.3507E-02_JPRB,&
 & 1.6295E-02_JPRB,1.0412E-02_JPRB,2.4973E-01_JPRB/)  
KAO( :, 2, 7,12) = (/&
 & 6.2205E-02_JPRB,5.4530E-02_JPRB,4.7203E-02_JPRB,3.9805E-02_JPRB,3.2362E-02_JPRB,2.4886E-02_JPRB,&
 & 1.8121E-02_JPRB,1.3884E-02_JPRB,3.2971E-01_JPRB/)  
KAO( :, 3, 7,12) = (/&
 & 6.4226E-02_JPRB,5.6598E-02_JPRB,4.9127E-02_JPRB,4.1578E-02_JPRB,3.4062E-02_JPRB,2.6961E-02_JPRB,&
 & 2.1190E-02_JPRB,1.8496E-02_JPRB,4.1960E-01_JPRB/)  
KAO( :, 4, 7,12) = (/&
 & 6.6268E-02_JPRB,5.8530E-02_JPRB,5.0921E-02_JPRB,4.3485E-02_JPRB,3.6432E-02_JPRB,3.0158E-02_JPRB,&
 & 2.6927E-02_JPRB,2.4386E-02_JPRB,5.2305E-01_JPRB/)  
KAO( :, 5, 7,12) = (/&
 & 6.9017E-02_JPRB,6.1350E-02_JPRB,5.3776E-02_JPRB,4.6719E-02_JPRB,4.0414E-02_JPRB,3.6297E-02_JPRB,&
 & 3.4763E-02_JPRB,3.1958E-02_JPRB,6.4099E-01_JPRB/)  
KAO( :, 1, 8,12) = (/&
 & 6.7351E-02_JPRB,5.8939E-02_JPRB,5.0741E-02_JPRB,4.2559E-02_JPRB,3.4322E-02_JPRB,2.6023E-02_JPRB,&
 & 1.7903E-02_JPRB,1.0436E-02_JPRB,4.7669E-01_JPRB/)  
KAO( :, 2, 8,12) = (/&
 & 6.9803E-02_JPRB,6.1083E-02_JPRB,5.2877E-02_JPRB,4.4484E-02_JPRB,3.5947E-02_JPRB,2.7535E-02_JPRB,&
 & 1.9536E-02_JPRB,1.2383E-02_JPRB,6.1756E-01_JPRB/)  
KAO( :, 3, 8,12) = (/&
 & 7.2114E-02_JPRB,6.3433E-02_JPRB,5.4955E-02_JPRB,4.6298E-02_JPRB,3.7783E-02_JPRB,2.9395E-02_JPRB,&
 & 2.1671E-02_JPRB,1.6236E-02_JPRB,8.0333E-01_JPRB/)  
KAO( :, 4, 8,12) = (/&
 & 7.4179E-02_JPRB,6.5484E-02_JPRB,5.6918E-02_JPRB,4.8333E-02_JPRB,3.9986E-02_JPRB,3.1892E-02_JPRB,&
 & 2.4841E-02_JPRB,2.1727E-02_JPRB,1.0238E+00_JPRB/)  
KAO( :, 5, 8,12) = (/&
 & 7.6619E-02_JPRB,6.7894E-02_JPRB,5.9259E-02_JPRB,5.0828E-02_JPRB,4.2369E-02_JPRB,3.5339E-02_JPRB,&
 & 3.0974E-02_JPRB,2.8579E-02_JPRB,1.2721E+00_JPRB/)  
KAO( :, 1, 9,12) = (/&
 & 7.4478E-02_JPRB,6.5171E-02_JPRB,5.5864E-02_JPRB,4.6941E-02_JPRB,3.7748E-02_JPRB,2.8605E-02_JPRB,&
 & 1.9435E-02_JPRB,1.1004E-02_JPRB,1.7884E+00_JPRB/)  
KAO( :, 2, 9,12) = (/&
 & 7.7257E-02_JPRB,6.7603E-02_JPRB,5.8386E-02_JPRB,4.8944E-02_JPRB,3.9580E-02_JPRB,3.0097E-02_JPRB,&
 & 2.0950E-02_JPRB,1.2526E-02_JPRB,2.2521E+00_JPRB/)  
KAO( :, 3, 9,12) = (/&
 & 7.9904E-02_JPRB,7.0069E-02_JPRB,6.0638E-02_JPRB,5.1114E-02_JPRB,4.1495E-02_JPRB,3.1843E-02_JPRB,&
 & 2.3233E-02_JPRB,1.4537E-02_JPRB,2.9339E+00_JPRB/)  
KAO( :, 4, 9,12) = (/&
 & 8.2346E-02_JPRB,7.2597E-02_JPRB,6.3019E-02_JPRB,5.3300E-02_JPRB,4.3544E-02_JPRB,3.4492E-02_JPRB,&
 & 2.5780E-02_JPRB,1.8842E-02_JPRB,3.7982E+00_JPRB/)  
KAO( :, 5, 9,12) = (/&
 & 8.4921E-02_JPRB,7.5081E-02_JPRB,6.5371E-02_JPRB,5.5672E-02_JPRB,4.6484E-02_JPRB,3.7440E-02_JPRB,&
 & 2.9153E-02_JPRB,2.5208E-02_JPRB,4.8104E+00_JPRB/)  
KAO( :, 1,10,12) = (/&
 & 8.1560E-02_JPRB,7.1369E-02_JPRB,6.1175E-02_JPRB,5.1264E-02_JPRB,4.1241E-02_JPRB,3.1126E-02_JPRB,&
 & 2.1112E-02_JPRB,1.1696E-02_JPRB,7.4468E+00_JPRB/)  
KAO( :, 2,10,12) = (/&
 & 8.4440E-02_JPRB,7.3887E-02_JPRB,6.3687E-02_JPRB,5.3392E-02_JPRB,4.3082E-02_JPRB,3.2635E-02_JPRB,&
 & 2.2609E-02_JPRB,1.3248E-02_JPRB,9.2981E+00_JPRB/)  
KAO( :, 3,10,12) = (/&
 & 8.7510E-02_JPRB,7.6590E-02_JPRB,6.6316E-02_JPRB,5.5795E-02_JPRB,4.5078E-02_JPRB,3.4503E-02_JPRB,&
 & 2.4942E-02_JPRB,1.4958E-02_JPRB,1.2082E+01_JPRB/)  
KAO( :, 4,10,12) = (/&
 & 9.0511E-02_JPRB,7.9705E-02_JPRB,6.9107E-02_JPRB,5.8258E-02_JPRB,4.7506E-02_JPRB,3.7279E-02_JPRB,&
 & 2.7590E-02_JPRB,1.7415E-02_JPRB,1.5900E+01_JPRB/)  
KAO( :, 5,10,12) = (/&
 & 9.3419E-02_JPRB,8.2537E-02_JPRB,7.1769E-02_JPRB,6.0958E-02_JPRB,5.0392E-02_JPRB,4.0420E-02_JPRB,&
 & 3.0465E-02_JPRB,2.2350E-02_JPRB,2.0480E+01_JPRB/)  
KAO( :, 1,11,12) = (/&
 & 8.9464E-02_JPRB,7.8283E-02_JPRB,6.7101E-02_JPRB,5.6285E-02_JPRB,4.5266E-02_JPRB,3.4192E-02_JPRB,&
 & 2.3302E-02_JPRB,1.2995E-02_JPRB,1.1790E+01_JPRB/)  
KAO( :, 2,11,12) = (/&
 & 9.2590E-02_JPRB,8.1019E-02_JPRB,6.9897E-02_JPRB,5.8591E-02_JPRB,4.7313E-02_JPRB,3.5860E-02_JPRB,&
 & 2.5050E-02_JPRB,1.4711E-02_JPRB,1.4906E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART9',0,ZHOOK_HANDLE)


KAO( :, 3,11,12) = (/&
 & 9.5857E-02_JPRB,8.3955E-02_JPRB,7.2681E-02_JPRB,6.1172E-02_JPRB,4.9475E-02_JPRB,3.7915E-02_JPRB,&
 & 2.7663E-02_JPRB,1.6572E-02_JPRB,1.9642E+01_JPRB/)  
KAO( :, 4,11,12) = (/&
 & 9.9442E-02_JPRB,8.7628E-02_JPRB,7.5988E-02_JPRB,6.4098E-02_JPRB,5.2240E-02_JPRB,4.1108E-02_JPRB,&
 & 3.0576E-02_JPRB,1.8973E-02_JPRB,2.5991E+01_JPRB/)  
KAO( :, 5,11,12) = (/&
 & 1.0289E-01_JPRB,9.0944E-02_JPRB,7.9112E-02_JPRB,6.7235E-02_JPRB,5.5656E-02_JPRB,4.4964E-02_JPRB,&
 & 3.3825E-02_JPRB,2.2911E-02_JPRB,3.3545E+01_JPRB/)  
KAO( :, 1,12,12) = (/&
 & 9.6584E-02_JPRB,8.4508E-02_JPRB,7.2437E-02_JPRB,6.0815E-02_JPRB,4.8901E-02_JPRB,3.6973E-02_JPRB,&
 & 2.5367E-02_JPRB,1.4216E-02_JPRB,1.4049E+01_JPRB/)  
KAO( :, 2,12,12) = (/&
 & 9.9962E-02_JPRB,8.7468E-02_JPRB,7.5539E-02_JPRB,6.3320E-02_JPRB,5.1161E-02_JPRB,3.8859E-02_JPRB,&
 & 2.7427E-02_JPRB,1.6079E-02_JPRB,1.7978E+01_JPRB/)  
KAO( :, 3,12,12) = (/&
 & 1.0340E-01_JPRB,9.0660E-02_JPRB,7.8491E-02_JPRB,6.6122E-02_JPRB,5.3580E-02_JPRB,4.1278E-02_JPRB,&
 & 3.0377E-02_JPRB,1.8202E-02_JPRB,2.3758E+01_JPRB/)  
KAO( :, 4,12,12) = (/&
 & 1.0749E-01_JPRB,9.4783E-02_JPRB,8.2213E-02_JPRB,6.9419E-02_JPRB,5.6626E-02_JPRB,4.4917E-02_JPRB,&
 & 3.3518E-02_JPRB,2.0812E-02_JPRB,3.1380E+01_JPRB/)  
KAO( :, 5,12,12) = (/&
 & 1.1220E-01_JPRB,9.9222E-02_JPRB,8.6341E-02_JPRB,7.3393E-02_JPRB,6.0808E-02_JPRB,4.9200E-02_JPRB,&
 & 3.7236E-02_JPRB,2.4135E-02_JPRB,4.0595E+01_JPRB/)  
KAO( :, 1,13,12) = (/&
 & 1.0300E-01_JPRB,9.0135E-02_JPRB,7.7297E-02_JPRB,6.4939E-02_JPRB,5.2208E-02_JPRB,3.9524E-02_JPRB,&
 & 2.7327E-02_JPRB,1.5400E-02_JPRB,1.3848E+01_JPRB/)  
KAO( :, 2,13,12) = (/&
 & 1.0667E-01_JPRB,9.3334E-02_JPRB,8.0681E-02_JPRB,6.7642E-02_JPRB,5.4655E-02_JPRB,4.1706E-02_JPRB,&
 & 2.9739E-02_JPRB,1.7385E-02_JPRB,1.7658E+01_JPRB/)  
KAO( :, 3,13,12) = (/&
 & 1.1046E-01_JPRB,9.6956E-02_JPRB,8.3948E-02_JPRB,7.0727E-02_JPRB,5.7403E-02_JPRB,4.4569E-02_JPRB,&
 & 3.2904E-02_JPRB,1.9868E-02_JPRB,2.3136E+01_JPRB/)  
KAO( :, 4,13,12) = (/&
 & 1.1527E-01_JPRB,1.0171E-01_JPRB,8.8265E-02_JPRB,7.4632E-02_JPRB,6.1070E-02_JPRB,4.8844E-02_JPRB,&
 & 3.6366E-02_JPRB,2.2679E-02_JPRB,3.0331E+01_JPRB/)  
KAO( :, 5,13,12) = (/&
 & 1.2126E-01_JPRB,1.0736E-01_JPRB,9.3522E-02_JPRB,7.9617E-02_JPRB,6.6218E-02_JPRB,5.3664E-02_JPRB,&
 & 4.0795E-02_JPRB,2.6028E-02_JPRB,3.9050E+01_JPRB/)  
KAO( :, 1, 1,13) = (/&
 & 7.7575E-02_JPRB,6.7876E-02_JPRB,6.3410E-02_JPRB,5.7807E-02_JPRB,5.1861E-02_JPRB,4.6380E-02_JPRB,&
 & 3.9791E-02_JPRB,3.9685E-02_JPRB,4.9236E-02_JPRB/)  
KAO( :, 2, 1,13) = (/&
 & 8.9138E-02_JPRB,7.8170E-02_JPRB,7.4208E-02_JPRB,6.9230E-02_JPRB,6.2955E-02_JPRB,5.7605E-02_JPRB,&
 & 5.0411E-02_JPRB,5.4657E-02_JPRB,6.4256E-02_JPRB/)  
KAO( :, 3, 1,13) = (/&
 & 1.0111E-01_JPRB,8.9496E-02_JPRB,8.5836E-02_JPRB,8.0803E-02_JPRB,7.5668E-02_JPRB,6.9307E-02_JPRB,&
 & 6.4355E-02_JPRB,7.2863E-02_JPRB,8.3997E-02_JPRB/)  
KAO( :, 4, 1,13) = (/&
 & 1.1325E-01_JPRB,1.0162E-01_JPRB,9.8222E-02_JPRB,9.3360E-02_JPRB,8.9664E-02_JPRB,8.2030E-02_JPRB,&
 & 8.1890E-02_JPRB,9.4421E-02_JPRB,1.0835E-01_JPRB/)  
KAO( :, 5, 1,13) = (/&
 & 1.2539E-01_JPRB,1.1433E-01_JPRB,1.1116E-01_JPRB,1.0717E-01_JPRB,1.0371E-01_JPRB,9.7171E-02_JPRB,&
 & 1.0295E-01_JPRB,1.1937E-01_JPRB,1.3710E-01_JPRB/)  
KAO( :, 1, 2,13) = (/&
 & 7.5084E-02_JPRB,6.5711E-02_JPRB,6.1443E-02_JPRB,5.6215E-02_JPRB,5.0525E-02_JPRB,4.5190E-02_JPRB,&
 & 3.8256E-02_JPRB,3.4359E-02_JPRB,5.8705E-02_JPRB/)  
KAO( :, 2, 2,13) = (/&
 & 8.7481E-02_JPRB,7.7103E-02_JPRB,7.2673E-02_JPRB,6.7753E-02_JPRB,6.2029E-02_JPRB,5.6624E-02_JPRB,&
 & 4.8617E-02_JPRB,4.8264E-02_JPRB,7.3515E-02_JPRB/)  
KAO( :, 3, 2,13) = (/&
 & 1.0027E-01_JPRB,8.9526E-02_JPRB,8.4990E-02_JPRB,7.9770E-02_JPRB,7.5196E-02_JPRB,6.8702E-02_JPRB,&
 & 6.1742E-02_JPRB,6.5561E-02_JPRB,9.1679E-02_JPRB/)  
KAO( :, 4, 2,13) = (/&
 & 1.1299E-01_JPRB,1.0255E-01_JPRB,9.8199E-02_JPRB,9.3168E-02_JPRB,8.9322E-02_JPRB,8.2695E-02_JPRB,&
 & 7.7970E-02_JPRB,8.6300E-02_JPRB,1.1329E-01_JPRB/)  
KAO( :, 5, 2,13) = (/&
 & 1.2555E-01_JPRB,1.1568E-01_JPRB,1.1171E-01_JPRB,1.0774E-01_JPRB,1.0377E-01_JPRB,9.8889E-02_JPRB,&
 & 9.7493E-02_JPRB,1.1062E-01_JPRB,1.3853E-01_JPRB/)  
KAO( :, 1, 3,13) = (/&
 & 6.9691E-02_JPRB,6.1107E-02_JPRB,5.6756E-02_JPRB,5.1486E-02_JPRB,4.6192E-02_JPRB,4.1148E-02_JPRB,&
 & 3.4753E-02_JPRB,2.8332E-02_JPRB,8.2983E-02_JPRB/)  
KAO( :, 2, 3,13) = (/&
 & 8.2227E-02_JPRB,7.2883E-02_JPRB,6.8298E-02_JPRB,6.2912E-02_JPRB,5.7544E-02_JPRB,5.2210E-02_JPRB,&
 & 4.4957E-02_JPRB,4.0005E-02_JPRB,1.0478E-01_JPRB/)  
KAO( :, 3, 3,13) = (/&
 & 9.4982E-02_JPRB,8.5432E-02_JPRB,8.0995E-02_JPRB,7.5178E-02_JPRB,7.0646E-02_JPRB,6.4384E-02_JPRB,&
 & 5.7678E-02_JPRB,5.5116E-02_JPRB,1.2972E-01_JPRB/)  
KAO( :, 4, 3,13) = (/&
 & 1.0814E-01_JPRB,9.8743E-02_JPRB,9.4541E-02_JPRB,8.8889E-02_JPRB,8.4938E-02_JPRB,7.8960E-02_JPRB,&
 & 7.3010E-02_JPRB,7.4136E-02_JPRB,1.5589E-01_JPRB/)  
KAO( :, 5, 3,13) = (/&
 & 1.2147E-01_JPRB,1.1222E-01_JPRB,1.0815E-01_JPRB,1.0392E-01_JPRB,1.0025E-01_JPRB,9.5831E-02_JPRB,&
 & 9.0492E-02_JPRB,9.6998E-02_JPRB,1.8572E-01_JPRB/)  
KAO( :, 1, 4,13) = (/&
 & 6.2565E-02_JPRB,5.4985E-02_JPRB,5.1005E-02_JPRB,4.5945E-02_JPRB,4.0688E-02_JPRB,3.6000E-02_JPRB,&
 & 3.0283E-02_JPRB,2.3725E-02_JPRB,1.3254E-01_JPRB/)  
KAO( :, 2, 4,13) = (/&
 & 7.4730E-02_JPRB,6.6495E-02_JPRB,6.2334E-02_JPRB,5.7038E-02_JPRB,5.1581E-02_JPRB,4.6682E-02_JPRB,&
 & 4.0217E-02_JPRB,3.3423E-02_JPRB,1.6553E-01_JPRB/)  
KAO( :, 3, 4,13) = (/&
 & 8.7721E-02_JPRB,7.9227E-02_JPRB,7.4754E-02_JPRB,6.9285E-02_JPRB,6.4310E-02_JPRB,5.8891E-02_JPRB,&
 & 5.2591E-02_JPRB,4.6205E-02_JPRB,2.0091E-01_JPRB/)  
KAO( :, 4, 4,13) = (/&
 & 1.0117E-01_JPRB,9.2830E-02_JPRB,8.8248E-02_JPRB,8.2981E-02_JPRB,7.8335E-02_JPRB,7.3405E-02_JPRB,&
 & 6.7339E-02_JPRB,6.2337E-02_JPRB,2.4019E-01_JPRB/)  
KAO( :, 5, 4,13) = (/&
 & 1.1481E-01_JPRB,1.0652E-01_JPRB,1.0206E-01_JPRB,9.8001E-02_JPRB,9.4065E-02_JPRB,9.0188E-02_JPRB,&
 & 8.3658E-02_JPRB,8.2259E-02_JPRB,2.8323E-01_JPRB/)  
KAO( :, 1, 5,13) = (/&
 & 5.8407E-02_JPRB,5.1108E-02_JPRB,4.6239E-02_JPRB,4.0778E-02_JPRB,3.5382E-02_JPRB,3.0729E-02_JPRB,&
 & 2.5929E-02_JPRB,2.0262E-02_JPRB,2.0976E-01_JPRB/)  
KAO( :, 2, 5,13) = (/&
 & 6.7590E-02_JPRB,6.0046E-02_JPRB,5.5590E-02_JPRB,5.0588E-02_JPRB,4.5609E-02_JPRB,4.0658E-02_JPRB,&
 & 3.5218E-02_JPRB,2.8718E-02_JPRB,2.6203E-01_JPRB/)  
KAO( :, 3, 5,13) = (/&
 & 7.9667E-02_JPRB,7.2301E-02_JPRB,6.7704E-02_JPRB,6.2413E-02_JPRB,5.7716E-02_JPRB,5.2470E-02_JPRB,&
 & 4.6833E-02_JPRB,3.9205E-02_JPRB,3.2020E-01_JPRB/)  
KAO( :, 4, 5,13) = (/&
 & 9.2812E-02_JPRB,8.5546E-02_JPRB,8.0951E-02_JPRB,7.5755E-02_JPRB,7.1407E-02_JPRB,6.6676E-02_JPRB,&
 & 6.0889E-02_JPRB,5.2582E-02_JPRB,3.8339E-01_JPRB/)  
KAO( :, 5, 5,13) = (/&
 & 1.0648E-01_JPRB,9.9221E-02_JPRB,9.4821E-02_JPRB,9.0576E-02_JPRB,8.7197E-02_JPRB,8.3294E-02_JPRB,&
 & 7.6479E-02_JPRB,6.9420E-02_JPRB,4.4984E-01_JPRB/)  
KAO( :, 1, 6,13) = (/&
 & 6.1074E-02_JPRB,5.3442E-02_JPRB,4.6642E-02_JPRB,3.9682E-02_JPRB,3.3065E-02_JPRB,2.6709E-02_JPRB,&
 & 2.1402E-02_JPRB,1.7316E-02_JPRB,3.1217E-01_JPRB/)  
KAO( :, 2, 6,13) = (/&
 & 6.6102E-02_JPRB,5.8128E-02_JPRB,5.1965E-02_JPRB,4.5770E-02_JPRB,3.9615E-02_JPRB,3.4605E-02_JPRB,&
 & 2.9773E-02_JPRB,2.4794E-02_JPRB,3.9753E-01_JPRB/)  
KAO( :, 3, 6,13) = (/&
 & 7.3850E-02_JPRB,6.6350E-02_JPRB,6.0820E-02_JPRB,5.4981E-02_JPRB,5.0172E-02_JPRB,4.5675E-02_JPRB,&
 & 4.0524E-02_JPRB,3.4061E-02_JPRB,4.9206E-01_JPRB/)  
KAO( :, 4, 6,13) = (/&
 & 8.4087E-02_JPRB,7.7167E-02_JPRB,7.2506E-02_JPRB,6.7577E-02_JPRB,6.3361E-02_JPRB,5.9142E-02_JPRB,&
 & 5.3549E-02_JPRB,4.5331E-02_JPRB,5.9295E-01_JPRB/)  
KAO( :, 5, 6,13) = (/&
 & 9.7016E-02_JPRB,9.0406E-02_JPRB,8.6048E-02_JPRB,8.1976E-02_JPRB,7.8673E-02_JPRB,7.5050E-02_JPRB,&
 & 6.8277E-02_JPRB,5.9321E-02_JPRB,7.0097E-01_JPRB/)  
KAO( :, 1, 7,13) = (/&
 & 6.9484E-02_JPRB,6.0801E-02_JPRB,5.2496E-02_JPRB,4.4095E-02_JPRB,3.5736E-02_JPRB,2.7213E-02_JPRB,&
 & 1.9462E-02_JPRB,1.5131E-02_JPRB,4.9666E-01_JPRB/)  
KAO( :, 2, 7,13) = (/&
 & 7.2482E-02_JPRB,6.3426E-02_JPRB,5.5184E-02_JPRB,4.6899E-02_JPRB,3.8506E-02_JPRB,3.1147E-02_JPRB,&
 & 2.5118E-02_JPRB,2.1656E-02_JPRB,6.3678E-01_JPRB/)  
KAO( :, 3, 7,13) = (/&
 & 7.6126E-02_JPRB,6.7402E-02_JPRB,5.9699E-02_JPRB,5.1994E-02_JPRB,4.4998E-02_JPRB,3.9088E-02_JPRB,&
 & 3.4888E-02_JPRB,3.0019E-02_JPRB,7.9664E-01_JPRB/)  
KAO( :, 4, 7,13) = (/&
 & 8.2337E-02_JPRB,7.4163E-02_JPRB,6.7469E-02_JPRB,6.0768E-02_JPRB,5.5760E-02_JPRB,5.1620E-02_JPRB,&
 & 4.6705E-02_JPRB,4.0344E-02_JPRB,9.7480E-01_JPRB/)  
KAO( :, 5, 7,13) = (/&
 & 9.1160E-02_JPRB,8.3680E-02_JPRB,7.7975E-02_JPRB,7.3495E-02_JPRB,7.0289E-02_JPRB,6.6562E-02_JPRB,&
 & 6.0431E-02_JPRB,5.2966E-02_JPRB,1.1667E+00_JPRB/)  
KAO( :, 1, 8,13) = (/&
 & 7.9875E-02_JPRB,6.9892E-02_JPRB,5.9964E-02_JPRB,5.0404E-02_JPRB,4.0546E-02_JPRB,3.0791E-02_JPRB,&
 & 2.0999E-02_JPRB,1.3352E-02_JPRB,9.4134E-01_JPRB/)  
KAO( :, 2, 8,13) = (/&
 & 8.2831E-02_JPRB,7.2481E-02_JPRB,6.2676E-02_JPRB,5.2633E-02_JPRB,4.2647E-02_JPRB,3.2676E-02_JPRB,&
 & 2.3318E-02_JPRB,1.9244E-02_JPRB,1.2413E+00_JPRB/)  
KAO( :, 3, 8,13) = (/&
 & 8.5814E-02_JPRB,7.5310E-02_JPRB,6.5363E-02_JPRB,5.5397E-02_JPRB,4.5622E-02_JPRB,3.6515E-02_JPRB,&
 & 3.0395E-02_JPRB,2.6861E-02_JPRB,1.5851E+00_JPRB/)  
KAO( :, 4, 8,13) = (/&
 & 8.9328E-02_JPRB,7.9178E-02_JPRB,6.9765E-02_JPRB,6.0251E-02_JPRB,5.1815E-02_JPRB,4.5308E-02_JPRB,&
 & 4.1250E-02_JPRB,3.6343E-02_JPRB,1.9653E+00_JPRB/)  
KAO( :, 5, 8,13) = (/&
 & 9.4353E-02_JPRB,8.4864E-02_JPRB,7.6567E-02_JPRB,6.8745E-02_JPRB,6.3044E-02_JPRB,5.8949E-02_JPRB,&
 & 5.4004E-02_JPRB,4.8133E-02_JPRB,2.3851E+00_JPRB/)  
KAO( :, 1, 9,13) = (/&
 & 9.1060E-02_JPRB,7.9678E-02_JPRB,6.8298E-02_JPRB,5.7272E-02_JPRB,4.6070E-02_JPRB,3.4830E-02_JPRB,&
 & 2.3532E-02_JPRB,1.3075E-02_JPRB,3.3036E+00_JPRB/)  
KAO( :, 2, 9,13) = (/&
 & 9.4393E-02_JPRB,8.2597E-02_JPRB,7.1203E-02_JPRB,5.9719E-02_JPRB,4.8226E-02_JPRB,3.6550E-02_JPRB,&
 & 2.5153E-02_JPRB,1.6919E-02_JPRB,4.4974E+00_JPRB/)  
KAO( :, 3, 9,13) = (/&
 & 9.7943E-02_JPRB,8.5705E-02_JPRB,7.4242E-02_JPRB,6.2533E-02_JPRB,5.0588E-02_JPRB,3.8901E-02_JPRB,&
 & 2.8455E-02_JPRB,2.3917E-02_JPRB,5.8908E+00_JPRB/)  
KAO( :, 4, 9,13) = (/&
 & 1.0146E-01_JPRB,8.9335E-02_JPRB,7.7594E-02_JPRB,6.5536E-02_JPRB,5.3840E-02_JPRB,4.3166E-02_JPRB,&
 & 3.6140E-02_JPRB,3.2576E-02_JPRB,7.5007E+00_JPRB/)  
KAO( :, 5, 9,13) = (/&
 & 1.0475E-01_JPRB,9.2703E-02_JPRB,8.1242E-02_JPRB,7.0200E-02_JPRB,6.0029E-02_JPRB,5.2409E-02_JPRB,&
 & 4.7785E-02_JPRB,4.3561E-02_JPRB,9.3123E+00_JPRB/)  
KAO( :, 1,10,13) = (/&
 & 1.0323E-01_JPRB,9.0321E-02_JPRB,7.7420E-02_JPRB,6.4606E-02_JPRB,5.2109E-02_JPRB,3.9304E-02_JPRB,&
 & 2.6545E-02_JPRB,1.4340E-02_JPRB,1.3176E+01_JPRB/)  
KAO( :, 2,10,13) = (/&
 & 1.0726E-01_JPRB,9.3851E-02_JPRB,8.0568E-02_JPRB,6.7728E-02_JPRB,5.4502E-02_JPRB,4.1373E-02_JPRB,&
 & 2.8209E-02_JPRB,1.6426E-02_JPRB,1.8337E+01_JPRB/)  
KAO( :, 3,10,13) = (/&
 & 1.1119E-01_JPRB,9.7297E-02_JPRB,8.4158E-02_JPRB,7.0666E-02_JPRB,5.7175E-02_JPRB,4.3645E-02_JPRB,&
 & 3.0420E-02_JPRB,2.1518E-02_JPRB,2.4733E+01_JPRB/)  
KAO( :, 4,10,13) = (/&
 & 1.1524E-01_JPRB,1.0114E-01_JPRB,8.7553E-02_JPRB,7.3838E-02_JPRB,6.0042E-02_JPRB,4.6213E-02_JPRB,&
 & 3.5024E-02_JPRB,2.9502E-02_JPRB,3.2293E+01_JPRB/)  
KAO( :, 5,10,13) = (/&
 & 1.1918E-01_JPRB,1.0517E-01_JPRB,9.1457E-02_JPRB,7.7569E-02_JPRB,6.3670E-02_JPRB,5.1602E-02_JPRB,&
 & 4.3593E-02_JPRB,3.9624E-02_JPRB,4.0987E+01_JPRB/)  
KAO( :, 1,11,13) = (/&
 & 1.1809E-01_JPRB,1.0333E-01_JPRB,8.8567E-02_JPRB,7.3956E-02_JPRB,5.9648E-02_JPRB,4.4991E-02_JPRB,&
 & 3.0394E-02_JPRB,1.6520E-02_JPRB,2.1329E+01_JPRB/)  
KAO( :, 2,11,13) = (/&
 & 1.2259E-01_JPRB,1.0727E-01_JPRB,9.2136E-02_JPRB,7.7442E-02_JPRB,6.2348E-02_JPRB,4.7316E-02_JPRB,&
 & 3.2372E-02_JPRB,1.8681E-02_JPRB,3.0195E+01_JPRB/)  
KAO( :, 3,11,13) = (/&
 & 1.2699E-01_JPRB,1.1113E-01_JPRB,9.6180E-02_JPRB,8.0804E-02_JPRB,6.5376E-02_JPRB,4.9936E-02_JPRB,&
 & 3.5020E-02_JPRB,2.2950E-02_JPRB,4.1235E+01_JPRB/)  
KAO( :, 4,11,13) = (/&
 & 1.3128E-01_JPRB,1.1530E-01_JPRB,9.9899E-02_JPRB,8.4291E-02_JPRB,6.8622E-02_JPRB,5.2932E-02_JPRB,&
 & 3.9181E-02_JPRB,3.0475E-02_JPRB,5.4497E+01_JPRB/)  
KAO( :, 5,11,13) = (/&
 & 1.3614E-01_JPRB,1.2013E-01_JPRB,1.0437E-01_JPRB,8.8367E-02_JPRB,7.2398E-02_JPRB,5.7416E-02_JPRB,&
 & 4.6256E-02_JPRB,4.1156E-02_JPRB,6.9986E+01_JPRB/)  
KAO( :, 1,12,13) = (/&
 & 1.3386E-01_JPRB,1.1712E-01_JPRB,1.0039E-01_JPRB,8.3885E-02_JPRB,6.7654E-02_JPRB,5.1023E-02_JPRB,&
 & 3.4519E-02_JPRB,1.8911E-02_JPRB,2.6006E+01_JPRB/)  
KAO( :, 2,12,13) = (/&
 & 1.3877E-01_JPRB,1.2143E-01_JPRB,1.0437E-01_JPRB,8.7721E-02_JPRB,7.0645E-02_JPRB,5.3609E-02_JPRB,&
 & 3.6836E-02_JPRB,2.1259E-02_JPRB,3.7252E+01_JPRB/)  
KAO( :, 3,12,13) = (/&
 & 1.4375E-01_JPRB,1.2579E-01_JPRB,1.0893E-01_JPRB,9.1548E-02_JPRB,7.4049E-02_JPRB,5.6582E-02_JPRB,&
 & 3.9974E-02_JPRB,2.4775E-02_JPRB,5.1456E+01_JPRB/)  
KAO( :, 4,12,13) = (/&
 & 1.4854E-01_JPRB,1.3051E-01_JPRB,1.1314E-01_JPRB,9.5475E-02_JPRB,7.7776E-02_JPRB,6.0170E-02_JPRB,&
 & 4.4338E-02_JPRB,3.1553E-02_JPRB,6.8626E+01_JPRB/)  
KAO( :, 5,12,13) = (/&
 & 1.5381E-01_JPRB,1.3581E-01_JPRB,1.1807E-01_JPRB,1.0009E-01_JPRB,8.2154E-02_JPRB,6.5109E-02_JPRB,&
 & 5.0201E-02_JPRB,4.2427E-02_JPRB,8.8644E+01_JPRB/)  
KAO( :, 1,13,13) = (/&
 & 1.5013E-01_JPRB,1.3136E-01_JPRB,1.1260E-01_JPRB,9.4157E-02_JPRB,7.5949E-02_JPRB,5.7300E-02_JPRB,&
 & 3.8872E-02_JPRB,2.1485E-02_JPRB,2.5822E+01_JPRB/)  
KAO( :, 2,13,13) = (/&
 & 1.5573E-01_JPRB,1.3627E-01_JPRB,1.1719E-01_JPRB,9.8539E-02_JPRB,7.9406E-02_JPRB,6.0263E-02_JPRB,&
 & 4.1620E-02_JPRB,2.4096E-02_JPRB,3.6956E+01_JPRB/)  
KAO( :, 3,13,13) = (/&
 & 1.6146E-01_JPRB,1.4129E-01_JPRB,1.2242E-01_JPRB,1.0291E-01_JPRB,8.3225E-02_JPRB,6.3641E-02_JPRB,&
 & 4.5364E-02_JPRB,2.7291E-02_JPRB,5.1399E+01_JPRB/)  
KAO( :, 4,13,13) = (/&
 & 1.6709E-01_JPRB,1.4686E-01_JPRB,1.2738E-01_JPRB,1.0746E-01_JPRB,8.7536E-02_JPRB,6.7870E-02_JPRB,&
 & 5.0138E-02_JPRB,3.3350E-02_JPRB,6.8906E+01_JPRB/)  
KAO( :, 5,13,13) = (/&
 & 1.7380E-01_JPRB,1.5350E-01_JPRB,1.3346E-01_JPRB,1.1314E-01_JPRB,9.2912E-02_JPRB,7.3777E-02_JPRB,&
 & 5.5622E-02_JPRB,4.3609E-02_JPRB,8.9452E+01_JPRB/)  
KAO( :, 1, 1,14) = (/&
 & 1.2272E-01_JPRB,1.0738E-01_JPRB,9.4283E-02_JPRB,8.6737E-02_JPRB,7.7664E-02_JPRB,7.2045E-02_JPRB,&
 & 7.8412E-02_JPRB,9.0417E-02_JPRB,1.0437E-01_JPRB/)  
KAO( :, 2, 1,14) = (/&
 & 1.4194E-01_JPRB,1.2421E-01_JPRB,1.1268E-01_JPRB,1.0273E-01_JPRB,9.4698E-02_JPRB,9.3256E-02_JPRB,&
 & 1.0748E-01_JPRB,1.2382E-01_JPRB,1.4306E-01_JPRB/)  
KAO( :, 3, 1,14) = (/&
 & 1.6121E-01_JPRB,1.4107E-01_JPRB,1.3136E-01_JPRB,1.2076E-01_JPRB,1.1385E-01_JPRB,1.2008E-01_JPRB,&
 & 1.4204E-01_JPRB,1.6386E-01_JPRB,1.8913E-01_JPRB/)  
KAO( :, 4, 1,14) = (/&
 & 1.8022E-01_JPRB,1.5771E-01_JPRB,1.4978E-01_JPRB,1.4054E-01_JPRB,1.3566E-01_JPRB,1.5231E-01_JPRB,&
 & 1.8204E-01_JPRB,2.1017E-01_JPRB,2.4241E-01_JPRB/)  
KAO( :, 5, 1,14) = (/&
 & 1.9876E-01_JPRB,1.7399E-01_JPRB,1.6813E-01_JPRB,1.6037E-01_JPRB,1.6177E-01_JPRB,1.8999E-01_JPRB,&
 & 2.2725E-01_JPRB,2.6257E-01_JPRB,3.0267E-01_JPRB/)  
KAO( :, 1, 2,14) = (/&
 & 1.2729E-01_JPRB,1.1140E-01_JPRB,9.8262E-02_JPRB,9.0117E-02_JPRB,7.9778E-02_JPRB,7.1136E-02_JPRB,&
 & 7.1341E-02_JPRB,8.1863E-02_JPRB,9.9580E-02_JPRB/)  
KAO( :, 2, 2,14) = (/&
 & 1.4798E-01_JPRB,1.2949E-01_JPRB,1.1804E-01_JPRB,1.0763E-01_JPRB,9.8062E-02_JPRB,9.0609E-02_JPRB,&
 & 9.8103E-02_JPRB,1.1375E-01_JPRB,1.3363E-01_JPRB/)  
KAO( :, 3, 2,14) = (/&
 & 1.6873E-01_JPRB,1.4766E-01_JPRB,1.3850E-01_JPRB,1.2733E-01_JPRB,1.1689E-01_JPRB,1.1520E-01_JPRB,&
 & 1.3107E-01_JPRB,1.5211E-01_JPRB,1.7565E-01_JPRB/)  
KAO( :, 4, 2,14) = (/&
 & 1.8958E-01_JPRB,1.6590E-01_JPRB,1.5866E-01_JPRB,1.4880E-01_JPRB,1.3847E-01_JPRB,1.4498E-01_JPRB,&
 & 1.6951E-01_JPRB,1.9684E-01_JPRB,2.2617E-01_JPRB/)  
KAO( :, 5, 2,14) = (/&
 & 2.1038E-01_JPRB,1.8454E-01_JPRB,1.7933E-01_JPRB,1.7078E-01_JPRB,1.6390E-01_JPRB,1.7978E-01_JPRB,&
 & 2.1333E-01_JPRB,2.4781E-01_JPRB,2.8462E-01_JPRB/)  
KAO( :, 1, 3,14) = (/&
 & 1.2550E-01_JPRB,1.0981E-01_JPRB,9.6955E-02_JPRB,8.9024E-02_JPRB,7.7880E-02_JPRB,6.7645E-02_JPRB,&
 & 6.1403E-02_JPRB,6.7382E-02_JPRB,1.4225E-01_JPRB/)  
KAO( :, 2, 3,14) = (/&
 & 1.4763E-01_JPRB,1.2918E-01_JPRB,1.1753E-01_JPRB,1.0765E-01_JPRB,9.6693E-02_JPRB,8.5332E-02_JPRB,&
 & 8.4254E-02_JPRB,9.5793E-02_JPRB,1.7778E-01_JPRB/)  
KAO( :, 3, 3,14) = (/&
 & 1.7047E-01_JPRB,1.4918E-01_JPRB,1.3933E-01_JPRB,1.2852E-01_JPRB,1.1691E-01_JPRB,1.0756E-01_JPRB,&
 & 1.1280E-01_JPRB,1.3060E-01_JPRB,2.1534E-01_JPRB/)  
KAO( :, 4, 3,14) = (/&
 & 1.9358E-01_JPRB,1.6939E-01_JPRB,1.6102E-01_JPRB,1.5122E-01_JPRB,1.3831E-01_JPRB,1.3427E-01_JPRB,&
 & 1.4739E-01_JPRB,1.7189E-01_JPRB,2.5797E-01_JPRB/)  
KAO( :, 5, 3,14) = (/&
 & 2.1660E-01_JPRB,1.9053E-01_JPRB,1.8371E-01_JPRB,1.7470E-01_JPRB,1.6255E-01_JPRB,1.6554E-01_JPRB,&
 & 1.8894E-01_JPRB,2.1979E-01_JPRB,3.0718E-01_JPRB/)  
KAO( :, 1, 4,14) = (/&
 & 1.2051E-01_JPRB,1.0544E-01_JPRB,9.2670E-02_JPRB,8.4885E-02_JPRB,7.4104E-02_JPRB,6.3445E-02_JPRB,&
 & 5.3222E-02_JPRB,5.2652E-02_JPRB,2.4708E-01_JPRB/)  
KAO( :, 2, 4,14) = (/&
 & 1.4414E-01_JPRB,1.2613E-01_JPRB,1.1387E-01_JPRB,1.0420E-01_JPRB,9.2996E-02_JPRB,8.0617E-02_JPRB,&
 & 7.2382E-02_JPRB,7.7038E-02_JPRB,3.0415E-01_JPRB/)  
KAO( :, 3, 4,14) = (/&
 & 1.6863E-01_JPRB,1.4759E-01_JPRB,1.3702E-01_JPRB,1.2578E-01_JPRB,1.1376E-01_JPRB,1.0097E-01_JPRB,&
 & 9.6748E-02_JPRB,1.0777E-01_JPRB,3.6725E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART10',0,ZHOOK_HANDLE)


KAO( :, 4, 4,14) = (/&
 & 1.9357E-01_JPRB,1.6961E-01_JPRB,1.6032E-01_JPRB,1.4935E-01_JPRB,1.3627E-01_JPRB,1.2523E-01_JPRB,&
 & 1.2694E-01_JPRB,1.4559E-01_JPRB,4.3596E-01_JPRB/)  
KAO( :, 5, 4,14) = (/&
 & 2.1857E-01_JPRB,1.9291E-01_JPRB,1.8484E-01_JPRB,1.7444E-01_JPRB,1.6154E-01_JPRB,1.5384E-01_JPRB,&
 & 1.6473E-01_JPRB,1.9089E-01_JPRB,5.0957E-01_JPRB/)  
KAO( :, 1, 5,14) = (/&
 & 1.1387E-01_JPRB,9.9639E-02_JPRB,8.7347E-02_JPRB,7.9247E-02_JPRB,6.8932E-02_JPRB,5.8370E-02_JPRB,&
 & 4.7289E-02_JPRB,4.1078E-02_JPRB,4.1374E-01_JPRB/)  
KAO( :, 2, 5,14) = (/&
 & 1.3841E-01_JPRB,1.2111E-01_JPRB,1.0901E-01_JPRB,9.8972E-02_JPRB,8.7653E-02_JPRB,7.5350E-02_JPRB,&
 & 6.3780E-02_JPRB,6.0994E-02_JPRB,5.1453E-01_JPRB/)  
KAO( :, 3, 5,14) = (/&
 & 1.6401E-01_JPRB,1.4350E-01_JPRB,1.3292E-01_JPRB,1.2113E-01_JPRB,1.0884E-01_JPRB,9.5638E-02_JPRB,&
 & 8.4952E-02_JPRB,8.8128E-02_JPRB,6.2691E-01_JPRB/)  
KAO( :, 4, 5,14) = (/&
 & 1.9052E-01_JPRB,1.6716E-01_JPRB,1.5743E-01_JPRB,1.4548E-01_JPRB,1.3189E-01_JPRB,1.1925E-01_JPRB,&
 & 1.1148E-01_JPRB,1.2277E-01_JPRB,7.4875E-01_JPRB/)  
KAO( :, 5, 5,14) = (/&
 & 2.1750E-01_JPRB,1.9225E-01_JPRB,1.8333E-01_JPRB,1.7169E-01_JPRB,1.5768E-01_JPRB,1.4619E-01_JPRB,&
 & 1.4557E-01_JPRB,1.6521E-01_JPRB,8.7275E-01_JPRB/)  
KAO( :, 1, 6,14) = (/&
 & 1.0474E-01_JPRB,9.1641E-02_JPRB,8.0224E-02_JPRB,7.2183E-02_JPRB,6.2228E-02_JPRB,5.2131E-02_JPRB,&
 & 4.1492E-02_JPRB,3.2184E-02_JPRB,6.9511E-01_JPRB/)  
KAO( :, 2, 6,14) = (/&
 & 1.2944E-01_JPRB,1.1326E-01_JPRB,1.0170E-01_JPRB,9.1896E-02_JPRB,8.0557E-02_JPRB,6.8664E-02_JPRB,&
 & 5.6745E-02_JPRB,4.8206E-02_JPRB,8.6732E-01_JPRB/)  
KAO( :, 3, 6,14) = (/&
 & 1.5591E-01_JPRB,1.3642E-01_JPRB,1.2581E-01_JPRB,1.1418E-01_JPRB,1.0169E-01_JPRB,8.8193E-02_JPRB,&
 & 7.5718E-02_JPRB,7.0944E-02_JPRB,1.0534E+00_JPRB/)  
KAO( :, 4, 6,14) = (/&
 & 1.8354E-01_JPRB,1.6133E-01_JPRB,1.5134E-01_JPRB,1.3874E-01_JPRB,1.2518E-01_JPRB,1.1115E-01_JPRB,&
 & 9.9229E-02_JPRB,1.0154E-01_JPRB,1.2543E+00_JPRB/)  
KAO( :, 5, 6,14) = (/&
 & 2.1175E-01_JPRB,1.8777E-01_JPRB,1.7853E-01_JPRB,1.6545E-01_JPRB,1.5132E-01_JPRB,1.3778E-01_JPRB,&
 & 1.2959E-01_JPRB,1.4035E-01_JPRB,1.4668E+00_JPRB/)  
KAO( :, 1, 7,14) = (/&
 & 9.8037E-02_JPRB,8.5785E-02_JPRB,7.4031E-02_JPRB,6.5638E-02_JPRB,5.5734E-02_JPRB,4.5971E-02_JPRB,&
 & 3.6011E-02_JPRB,2.6144E-02_JPRB,1.2159E+00_JPRB/)  
KAO( :, 2, 7,14) = (/&
 & 1.1998E-01_JPRB,1.0498E-01_JPRB,9.3637E-02_JPRB,8.4452E-02_JPRB,7.3349E-02_JPRB,6.1893E-02_JPRB,&
 & 4.9919E-02_JPRB,3.9040E-02_JPRB,1.5511E+00_JPRB/)  
KAO( :, 3, 7,14) = (/&
 & 1.4686E-01_JPRB,1.2856E-01_JPRB,1.1785E-01_JPRB,1.0669E-01_JPRB,9.3946E-02_JPRB,8.0872E-02_JPRB,&
 & 6.7552E-02_JPRB,5.7747E-02_JPRB,1.9129E+00_JPRB/)  
KAO( :, 4, 7,14) = (/&
 & 1.7522E-01_JPRB,1.5432E-01_JPRB,1.4422E-01_JPRB,1.3156E-01_JPRB,1.1748E-01_JPRB,1.0312E-01_JPRB,&
 & 9.0045E-02_JPRB,8.3407E-02_JPRB,2.2944E+00_JPRB/)  
KAO( :, 5, 7,14) = (/&
 & 2.0470E-01_JPRB,1.8180E-01_JPRB,1.7230E-01_JPRB,1.5882E-01_JPRB,1.4368E-01_JPRB,1.2923E-01_JPRB,&
 & 1.1721E-01_JPRB,1.1674E-01_JPRB,2.6936E+00_JPRB/)  
KAO( :, 1, 8,14) = (/&
 & 9.9268E-02_JPRB,8.6861E-02_JPRB,7.4453E-02_JPRB,6.4036E-02_JPRB,5.3505E-02_JPRB,4.2319E-02_JPRB,&
 & 3.1550E-02_JPRB,2.2217E-02_JPRB,2.4996E+00_JPRB/)  
KAO( :, 2, 8,14) = (/&
 & 1.1614E-01_JPRB,1.0162E-01_JPRB,8.8779E-02_JPRB,7.8855E-02_JPRB,6.7312E-02_JPRB,5.5689E-02_JPRB,&
 & 4.4126E-02_JPRB,3.3034E-02_JPRB,3.2562E+00_JPRB/)  
KAO( :, 3, 8,14) = (/&
 & 1.3955E-01_JPRB,1.2210E-01_JPRB,1.1063E-01_JPRB,9.9801E-02_JPRB,8.7158E-02_JPRB,7.3984E-02_JPRB,&
 & 6.0483E-02_JPRB,4.8160E-02_JPRB,4.0870E+00_JPRB/)  
KAO( :, 4, 8,14) = (/&
 & 1.6821E-01_JPRB,1.4816E-01_JPRB,1.3755E-01_JPRB,1.2480E-01_JPRB,1.1087E-01_JPRB,9.5535E-02_JPRB,&
 & 8.1708E-02_JPRB,6.9310E-02_JPRB,4.9903E+00_JPRB/)  
KAO( :, 5, 8,14) = (/&
 & 1.9964E-01_JPRB,1.7735E-01_JPRB,1.6653E-01_JPRB,1.5239E-01_JPRB,1.3733E-01_JPRB,1.2121E-01_JPRB,&
 & 1.0795E-01_JPRB,9.7500E-02_JPRB,5.9489E+00_JPRB/)  
KAO( :, 1, 9,14) = (/&
 & 1.0767E-01_JPRB,9.4219E-02_JPRB,8.0760E-02_JPRB,6.7681E-02_JPRB,5.5573E-02_JPRB,4.2663E-02_JPRB,&
 & 3.0129E-02_JPRB,1.9372E-02_JPRB,9.4494E+00_JPRB/)  
KAO( :, 2, 9,14) = (/&
 & 1.1878E-01_JPRB,1.0394E-01_JPRB,8.9411E-02_JPRB,7.7688E-02_JPRB,6.4557E-02_JPRB,5.1682E-02_JPRB,&
 & 3.8689E-02_JPRB,2.8319E-02_JPRB,1.2605E+01_JPRB/)  
KAO( :, 3, 9,14) = (/&
 & 1.3639E-01_JPRB,1.1934E-01_JPRB,1.0569E-01_JPRB,9.3279E-02_JPRB,7.9895E-02_JPRB,6.6582E-02_JPRB,&
 & 5.3130E-02_JPRB,4.1437E-02_JPRB,1.6195E+01_JPRB/)  
KAO( :, 4, 9,14) = (/&
 & 1.6051E-01_JPRB,1.4083E-01_JPRB,1.2883E-01_JPRB,1.1557E-01_JPRB,1.0198E-01_JPRB,8.7219E-02_JPRB,&
 & 7.3054E-02_JPRB,5.9439E-02_JPRB,2.0162E+01_JPRB/)  
KAO( :, 5, 9,14) = (/&
 & 1.9047E-01_JPRB,1.6928E-01_JPRB,1.5797E-01_JPRB,1.4317E-01_JPRB,1.2816E-01_JPRB,1.1220E-01_JPRB,&
 & 9.8138E-02_JPRB,8.3143E-02_JPRB,2.4370E+01_JPRB/)  
KAO( :, 1,10,14) = (/&
 & 1.2399E-01_JPRB,1.0850E-01_JPRB,9.2999E-02_JPRB,7.7504E-02_JPRB,6.2608E-02_JPRB,4.7376E-02_JPRB,&
 & 3.2192E-02_JPRB,1.8471E-02_JPRB,3.9887E+01_JPRB/)  
KAO( :, 2,10,14) = (/&
 & 1.3044E-01_JPRB,1.1413E-01_JPRB,9.7827E-02_JPRB,8.3086E-02_JPRB,6.7807E-02_JPRB,5.2528E-02_JPRB,&
 & 3.7452E-02_JPRB,2.5677E-02_JPRB,5.4647E+01_JPRB/)  
KAO( :, 3,10,14) = (/&
 & 1.4288E-01_JPRB,1.2502E-01_JPRB,1.0881E-01_JPRB,9.4032E-02_JPRB,7.8460E-02_JPRB,6.3126E-02_JPRB,&
 & 4.8115E-02_JPRB,3.7197E-02_JPRB,7.1742E+01_JPRB/)  
KAO( :, 4,10,14) = (/&
 & 1.6124E-01_JPRB,1.4108E-01_JPRB,1.2689E-01_JPRB,1.1135E-01_JPRB,9.5742E-02_JPRB,8.0119E-02_JPRB,&
 & 6.6079E-02_JPRB,5.3593E-02_JPRB,9.0502E+01_JPRB/)  
KAO( :, 5,10,14) = (/&
 & 1.8553E-01_JPRB,1.6386E-01_JPRB,1.5092E-01_JPRB,1.3528E-01_JPRB,1.1973E-01_JPRB,1.0415E-01_JPRB,&
 & 8.9746E-02_JPRB,7.5568E-02_JPRB,1.1085E+02_JPRB/)  
KAO( :, 1,11,14) = (/&
 & 1.4634E-01_JPRB,1.2805E-01_JPRB,1.0976E-01_JPRB,9.1467E-02_JPRB,7.3855E-02_JPRB,5.5821E-02_JPRB,&
 & 3.7725E-02_JPRB,2.1087E-02_JPRB,6.7956E+01_JPRB/)  
KAO( :, 2,11,14) = (/&
 & 1.5280E-01_JPRB,1.3370E-01_JPRB,1.1460E-01_JPRB,9.6711E-02_JPRB,7.8221E-02_JPRB,6.0001E-02_JPRB,&
 & 4.1942E-02_JPRB,2.7978E-02_JPRB,9.3212E+01_JPRB/)  
KAO( :, 3,11,14) = (/&
 & 1.6241E-01_JPRB,1.4212E-01_JPRB,1.2352E-01_JPRB,1.0575E-01_JPRB,8.7369E-02_JPRB,6.9001E-02_JPRB,&
 & 5.1438E-02_JPRB,4.0090E-02_JPRB,1.2204E+02_JPRB/)  
KAO( :, 4,11,14) = (/&
 & 1.7773E-01_JPRB,1.5551E-01_JPRB,1.3890E-01_JPRB,1.2079E-01_JPRB,1.0263E-01_JPRB,8.4231E-02_JPRB,&
 & 6.9240E-02_JPRB,5.7401E-02_JPRB,1.5432E+02_JPRB/)  
KAO( :, 5,11,14) = (/&
 & 1.9855E-01_JPRB,1.7536E-01_JPRB,1.5997E-01_JPRB,1.4235E-01_JPRB,1.2466E-01_JPRB,1.0802E-01_JPRB,&
 & 9.3905E-02_JPRB,8.0223E-02_JPRB,1.8971E+02_JPRB/)  
KAO( :, 1,12,14) = (/&
 & 1.7212E-01_JPRB,1.5061E-01_JPRB,1.2910E-01_JPRB,1.0758E-01_JPRB,8.6852E-02_JPRB,6.5625E-02_JPRB,&
 & 4.4312E-02_JPRB,2.4340E-02_JPRB,8.4903E+01_JPRB/)  
KAO( :, 2,12,14) = (/&
 & 1.7934E-01_JPRB,1.5692E-01_JPRB,1.3450E-01_JPRB,1.1330E-01_JPRB,9.1337E-02_JPRB,6.9634E-02_JPRB,&
 & 4.7833E-02_JPRB,3.1026E-02_JPRB,1.1639E+02_JPRB/)  
KAO( :, 3,12,14) = (/&
 & 1.8728E-01_JPRB,1.6386E-01_JPRB,1.4213E-01_JPRB,1.2054E-01_JPRB,9.8954E-02_JPRB,7.7262E-02_JPRB,&
 & 5.6412E-02_JPRB,4.3794E-02_JPRB,1.5321E+02_JPRB/)  
KAO( :, 4,12,14) = (/&
 & 2.0028E-01_JPRB,1.7525E-01_JPRB,1.5522E-01_JPRB,1.3365E-01_JPRB,1.1228E-01_JPRB,9.0973E-02_JPRB,&
 & 7.3137E-02_JPRB,6.1836E-02_JPRB,1.9487E+02_JPRB/)  
KAO( :, 5,12,14) = (/&
 & 2.1815E-01_JPRB,1.9249E-01_JPRB,1.7398E-01_JPRB,1.5323E-01_JPRB,1.3224E-01_JPRB,1.1343E-01_JPRB,&
 & 9.8759E-02_JPRB,8.5478E-02_JPRB,2.4055E+02_JPRB/)  
KAO( :, 1,13,14) = (/&
 & 2.0214E-01_JPRB,1.7687E-01_JPRB,1.5160E-01_JPRB,1.2634E-01_JPRB,1.0196E-01_JPRB,7.7014E-02_JPRB,&
 & 5.1962E-02_JPRB,2.8242E-02_JPRB,8.4112E+01_JPRB/)  
KAO( :, 2,13,14) = (/&
 & 2.1011E-01_JPRB,1.8385E-01_JPRB,1.5760E-01_JPRB,1.3272E-01_JPRB,1.0696E-01_JPRB,8.1283E-02_JPRB,&
 & 5.5458E-02_JPRB,3.4895E-02_JPRB,1.1624E+02_JPRB/)  
KAO( :, 3,13,14) = (/&
 & 2.1853E-01_JPRB,1.9120E-01_JPRB,1.6551E-01_JPRB,1.3968E-01_JPRB,1.1398E-01_JPRB,8.8112E-02_JPRB,&
 & 6.3575E-02_JPRB,4.8146E-02_JPRB,1.5368E+02_JPRB/)  
KAO( :, 4,13,14) = (/&
 & 2.2961E-01_JPRB,2.0092E-01_JPRB,1.7711E-01_JPRB,1.5169E-01_JPRB,1.2625E-01_JPRB,1.0098E-01_JPRB,&
 & 7.9581E-02_JPRB,6.7244E-02_JPRB,1.9645E+02_JPRB/)  
KAO( :, 5,13,14) = (/&
 & 2.4584E-01_JPRB,2.1666E-01_JPRB,1.9421E-01_JPRB,1.6994E-01_JPRB,1.4516E-01_JPRB,1.2228E-01_JPRB,&
 & 1.0565E-01_JPRB,9.1741E-02_JPRB,2.4440E+02_JPRB/)  
KAO( :, 1, 1,15) = (/&
 & 1.6714E-01_JPRB,1.4623E-01_JPRB,1.2535E-01_JPRB,1.1978E-01_JPRB,1.3700E-01_JPRB,1.6925E-01_JPRB,&
 & 2.0052E-01_JPRB,2.2511E-01_JPRB,2.6590E-01_JPRB/)  
KAO( :, 2, 1,15) = (/&
 & 1.9315E-01_JPRB,1.6902E-01_JPRB,1.4490E-01_JPRB,1.5051E-01_JPRB,1.8304E-01_JPRB,2.2712E-01_JPRB,&
 & 2.6888E-01_JPRB,3.0220E-01_JPRB,3.5680E-01_JPRB/)  
KAO( :, 3, 1,15) = (/&
 & 2.1967E-01_JPRB,1.9223E-01_JPRB,1.6933E-01_JPRB,1.8733E-01_JPRB,2.3841E-01_JPRB,2.9577E-01_JPRB,&
 & 3.5003E-01_JPRB,3.9291E-01_JPRB,4.6433E-01_JPRB/)  
KAO( :, 4, 1,15) = (/&
 & 2.4620E-01_JPRB,2.1544E-01_JPRB,1.9690E-01_JPRB,2.3005E-01_JPRB,3.0239E-01_JPRB,3.7520E-01_JPRB,&
 & 4.4404E-01_JPRB,4.9769E-01_JPRB,5.8881E-01_JPRB/)  
KAO( :, 5, 1,15) = (/&
 & 2.7258E-01_JPRB,2.3851E-01_JPRB,2.2655E-01_JPRB,2.8238E-01_JPRB,3.7464E-01_JPRB,4.6513E-01_JPRB,&
 & 5.5029E-01_JPRB,6.1683E-01_JPRB,7.3011E-01_JPRB/)  
KAO( :, 1, 2,15) = (/&
 & 1.8366E-01_JPRB,1.6071E-01_JPRB,1.3776E-01_JPRB,1.2787E-01_JPRB,1.3633E-01_JPRB,1.6291E-01_JPRB,&
 & 1.9304E-01_JPRB,2.1749E-01_JPRB,2.5915E-01_JPRB/)  
KAO( :, 2, 2,15) = (/&
 & 2.1410E-01_JPRB,1.8735E-01_JPRB,1.6059E-01_JPRB,1.5940E-01_JPRB,1.8012E-01_JPRB,2.2284E-01_JPRB,&
 & 2.6404E-01_JPRB,2.9719E-01_JPRB,3.5437E-01_JPRB/)  
KAO( :, 3, 2,15) = (/&
 & 2.4518E-01_JPRB,2.1455E-01_JPRB,1.8756E-01_JPRB,1.9671E-01_JPRB,2.3732E-01_JPRB,2.9467E-01_JPRB,&
 & 3.4914E-01_JPRB,3.9288E-01_JPRB,4.6863E-01_JPRB/)  
KAO( :, 4, 2,15) = (/&
 & 2.7631E-01_JPRB,2.4179E-01_JPRB,2.1947E-01_JPRB,2.3962E-01_JPRB,3.0475E-01_JPRB,3.7844E-01_JPRB,&
 & 4.4844E-01_JPRB,5.0450E-01_JPRB,6.0205E-01_JPRB/)  
KAO( :, 5, 2,15) = (/&
 & 3.0712E-01_JPRB,2.6878E-01_JPRB,2.5148E-01_JPRB,2.9094E-01_JPRB,3.8157E-01_JPRB,4.7390E-01_JPRB,&
 & 5.6159E-01_JPRB,6.3185E-01_JPRB,7.5391E-01_JPRB/)  
KAO( :, 1, 3,15) = (/&
 & 1.9381E-01_JPRB,1.6957E-01_JPRB,1.4535E-01_JPRB,1.3089E-01_JPRB,1.3034E-01_JPRB,1.4478E-01_JPRB,&
 & 1.7182E-01_JPRB,1.9411E-01_JPRB,2.5084E-01_JPRB/)  
KAO( :, 2, 3,15) = (/&
 & 2.2879E-01_JPRB,2.0020E-01_JPRB,1.7161E-01_JPRB,1.6253E-01_JPRB,1.7117E-01_JPRB,2.0325E-01_JPRB,&
 & 2.4118E-01_JPRB,2.7244E-01_JPRB,3.3342E-01_JPRB/)  
KAO( :, 3, 3,15) = (/&
 & 2.6449E-01_JPRB,2.3152E-01_JPRB,2.0076E-01_JPRB,1.9976E-01_JPRB,2.2310E-01_JPRB,2.7442E-01_JPRB,&
 & 3.2567E-01_JPRB,3.6802E-01_JPRB,4.4181E-01_JPRB/)  
KAO( :, 4, 3,15) = (/&
 & 3.0062E-01_JPRB,2.6305E-01_JPRB,2.3583E-01_JPRB,2.4242E-01_JPRB,2.8858E-01_JPRB,3.5854E-01_JPRB,&
 & 4.2563E-01_JPRB,4.8116E-01_JPRB,5.7642E-01_JPRB/)  
KAO( :, 5, 3,15) = (/&
 & 3.3647E-01_JPRB,2.9433E-01_JPRB,2.7280E-01_JPRB,2.9278E-01_JPRB,3.6645E-01_JPRB,4.5559E-01_JPRB,&
 & 5.4090E-01_JPRB,6.1169E-01_JPRB,7.3212E-01_JPRB/)  
KAO( :, 1, 4,15) = (/&
 & 1.9999E-01_JPRB,1.7501E-01_JPRB,1.5001E-01_JPRB,1.3105E-01_JPRB,1.2399E-01_JPRB,1.2689E-01_JPRB,&
 & 1.4635E-01_JPRB,1.6609E-01_JPRB,3.8961E-01_JPRB/)  
KAO( :, 2, 4,15) = (/&
 & 2.3934E-01_JPRB,2.0943E-01_JPRB,1.7951E-01_JPRB,1.6550E-01_JPRB,1.6246E-01_JPRB,1.7858E-01_JPRB,&
 & 2.1156E-01_JPRB,2.4017E-01_JPRB,4.8945E-01_JPRB/)  
KAO( :, 3, 4,15) = (/&
 & 2.7991E-01_JPRB,2.4495E-01_JPRB,2.1142E-01_JPRB,2.0298E-01_JPRB,2.1064E-01_JPRB,2.4602E-01_JPRB,&
 & 2.9261E-01_JPRB,3.3237E-01_JPRB,5.9861E-01_JPRB/)  
KAO( :, 4, 4,15) = (/&
 & 3.2106E-01_JPRB,2.8093E-01_JPRB,2.4927E-01_JPRB,2.4578E-01_JPRB,2.7114E-01_JPRB,3.2797E-01_JPRB,&
 & 3.9010E-01_JPRB,4.4342E-01_JPRB,7.1678E-01_JPRB/)  
KAO( :, 5, 4,15) = (/&
 & 3.6208E-01_JPRB,3.1681E-01_JPRB,2.9211E-01_JPRB,2.9449E-01_JPRB,3.4380E-01_JPRB,4.2351E-01_JPRB,&
 & 5.0405E-01_JPRB,5.7325E-01_JPRB,8.4831E-01_JPRB/)  
KAO( :, 1, 5,15) = (/&
 & 2.0321E-01_JPRB,1.7781E-01_JPRB,1.5241E-01_JPRB,1.3060E-01_JPRB,1.1953E-01_JPRB,1.1366E-01_JPRB,&
 & 1.2139E-01_JPRB,1.3841E-01_JPRB,7.6737E-01_JPRB/)  
KAO( :, 2, 5,15) = (/&
 & 2.4681E-01_JPRB,2.1596E-01_JPRB,1.8512E-01_JPRB,1.6773E-01_JPRB,1.5630E-01_JPRB,1.5939E-01_JPRB,&
 & 1.8094E-01_JPRB,2.0654E-01_JPRB,9.3237E-01_JPRB/)  
KAO( :, 3, 5,15) = (/&
 & 2.9225E-01_JPRB,2.5571E-01_JPRB,2.2020E-01_JPRB,2.0776E-01_JPRB,2.0115E-01_JPRB,2.1929E-01_JPRB,&
 & 2.5668E-01_JPRB,2.9327E-01_JPRB,1.1037E+00_JPRB/)  
KAO( :, 4, 5,15) = (/&
 & 3.3924E-01_JPRB,2.9689E-01_JPRB,2.6138E-01_JPRB,2.5151E-01_JPRB,2.5830E-01_JPRB,2.9435E-01_JPRB,&
 & 3.4948E-01_JPRB,3.9959E-01_JPRB,1.2806E+00_JPRB/)  
KAO( :, 5, 5,15) = (/&
 & 3.8698E-01_JPRB,3.3860E-01_JPRB,3.0762E-01_JPRB,3.0044E-01_JPRB,3.2724E-01_JPRB,3.8517E-01_JPRB,&
 & 4.5934E-01_JPRB,5.2570E-01_JPRB,1.4803E+00_JPRB/)  
KAO( :, 1, 6,15) = (/&
 & 2.0167E-01_JPRB,1.7647E-01_JPRB,1.5126E-01_JPRB,1.2807E-01_JPRB,1.1544E-01_JPRB,1.0229E-01_JPRB,&
 & 9.9864E-02_JPRB,1.1026E-01_JPRB,1.4089E+00_JPRB/)  
KAO( :, 2, 6,15) = (/&
 & 2.4970E-01_JPRB,2.1848E-01_JPRB,1.8731E-01_JPRB,1.6569E-01_JPRB,1.5115E-01_JPRB,1.4241E-01_JPRB,&
 & 1.4999E-01_JPRB,1.7053E-01_JPRB,1.7402E+00_JPRB/)  
KAO( :, 3, 6,15) = (/&
 & 3.0094E-01_JPRB,2.6336E-01_JPRB,2.2581E-01_JPRB,2.1051E-01_JPRB,1.9387E-01_JPRB,1.9632E-01_JPRB,&
 & 2.1699E-01_JPRB,2.4938E-01_JPRB,2.0912E+00_JPRB/)  
KAO( :, 4, 6,15) = (/&
 & 3.5441E-01_JPRB,3.1006E-01_JPRB,2.6999E-01_JPRB,2.5637E-01_JPRB,2.4732E-01_JPRB,2.6431E-01_JPRB,&
 & 3.0280E-01_JPRB,3.4805E-01_JPRB,2.4589E+00_JPRB/)  
KAO( :, 5, 6,15) = (/&
 & 4.0878E-01_JPRB,3.5772E-01_JPRB,3.1991E-01_JPRB,3.0644E-01_JPRB,3.1239E-01_JPRB,3.4703E-01_JPRB,&
 & 4.0741E-01_JPRB,4.6767E-01_JPRB,2.8357E+00_JPRB/)  
KAO( :, 1, 7,15) = (/&
 & 1.9961E-01_JPRB,1.7465E-01_JPRB,1.4970E-01_JPRB,1.2517E-01_JPRB,1.1019E-01_JPRB,9.4432E-02_JPRB,&
 & 8.3552E-02_JPRB,8.4867E-02_JPRB,2.6743E+00_JPRB/)  
KAO( :, 2, 7,15) = (/&
 & 2.5271E-01_JPRB,2.2112E-01_JPRB,1.8951E-01_JPRB,1.6349E-01_JPRB,1.4808E-01_JPRB,1.3037E-01_JPRB,&
 & 1.2620E-01_JPRB,1.3661E-01_JPRB,3.3775E+00_JPRB/)  
KAO( :, 3, 7,15) = (/&
 & 3.0993E-01_JPRB,2.7118E-01_JPRB,2.3244E-01_JPRB,2.1005E-01_JPRB,1.9021E-01_JPRB,1.7858E-01_JPRB,&
 & 1.8396E-01_JPRB,2.0656E-01_JPRB,4.1391E+00_JPRB/)  
KAO( :, 4, 7,15) = (/&
 & 3.7010E-01_JPRB,3.2384E-01_JPRB,2.8021E-01_JPRB,2.6259E-01_JPRB,2.4156E-01_JPRB,2.4022E-01_JPRB,&
 & 2.5897E-01_JPRB,2.9714E-01_JPRB,4.9411E+00_JPRB/)  
KAO( :, 5, 7,15) = (/&
 & 4.3194E-01_JPRB,3.7799E-01_JPRB,3.3448E-01_JPRB,3.1568E-01_JPRB,3.0414E-01_JPRB,3.1604E-01_JPRB,&
 & 3.5629E-01_JPRB,4.0998E-01_JPRB,5.7688E+00_JPRB/)  
KAO( :, 1, 8,15) = (/&
 & 1.9933E-01_JPRB,1.7442E-01_JPRB,1.4950E-01_JPRB,1.2458E-01_JPRB,1.0537E-01_JPRB,8.9910E-02_JPRB,&
 & 7.2635E-02_JPRB,6.5335E-02_JPRB,6.0216E+00_JPRB/)  
KAO( :, 2, 8,15) = (/&
 & 2.5812E-01_JPRB,2.2586E-01_JPRB,1.9358E-01_JPRB,1.6410E-01_JPRB,1.4589E-01_JPRB,1.2373E-01_JPRB,&
 & 1.0885E-01_JPRB,1.0727E-01_JPRB,7.7945E+00_JPRB/)  
KAO( :, 3, 8,15) = (/&
 & 3.2225E-01_JPRB,2.8198E-01_JPRB,2.4170E-01_JPRB,2.1259E-01_JPRB,1.9127E-01_JPRB,1.6827E-01_JPRB,&
 & 1.5878E-01_JPRB,1.6851E-01_JPRB,9.7347E+00_JPRB/)  
KAO( :, 4, 8,15) = (/&
 & 3.9033E-01_JPRB,3.4151E-01_JPRB,2.9429E-01_JPRB,2.7000E-01_JPRB,2.4193E-01_JPRB,2.2526E-01_JPRB,&
 & 2.2474E-01_JPRB,2.5040E-01_JPRB,1.1796E+01_JPRB/)  
KAO( :, 5, 8,15) = (/&
 & 4.6081E-01_JPRB,4.0323E-01_JPRB,3.5398E-01_JPRB,3.3209E-01_JPRB,3.0343E-01_JPRB,2.9566E-01_JPRB,&
 & 3.1093E-01_JPRB,3.5490E-01_JPRB,1.3934E+01_JPRB/)  
KAO( :, 1, 9,15) = (/&
 & 1.9412E-01_JPRB,1.6985E-01_JPRB,1.4559E-01_JPRB,1.2132E-01_JPRB,1.0003E-01_JPRB,8.3920E-02_JPRB,&
 & 6.4680E-02_JPRB,5.0884E-02_JPRB,2.5202E+01_JPRB/)  
KAO( :, 2, 9,15) = (/&
 & 2.5742E-01_JPRB,2.2525E-01_JPRB,1.9306E-01_JPRB,1.6223E-01_JPRB,1.4019E-01_JPRB,1.1848E-01_JPRB,&
 & 9.6308E-02_JPRB,8.4787E-02_JPRB,3.3443E+01_JPRB/)  
KAO( :, 3, 9,15) = (/&
 & 3.2748E-01_JPRB,2.8656E-01_JPRB,2.4562E-01_JPRB,2.1272E-01_JPRB,1.9002E-01_JPRB,1.6032E-01_JPRB,&
 & 1.4014E-01_JPRB,1.3516E-01_JPRB,4.2589E+01_JPRB/)  
KAO( :, 4, 9,15) = (/&
 & 4.0257E-01_JPRB,3.5230E-01_JPRB,3.0305E-01_JPRB,2.7255E-01_JPRB,2.4419E-01_JPRB,2.1398E-01_JPRB,&
 & 1.9809E-01_JPRB,2.0651E-01_JPRB,5.2403E+01_JPRB/)  
KAO( :, 5, 9,15) = (/&
 & 4.8160E-01_JPRB,4.2145E-01_JPRB,3.6810E-01_JPRB,3.4131E-01_JPRB,3.0598E-01_JPRB,2.8022E-01_JPRB,&
 & 2.7440E-01_JPRB,3.0100E-01_JPRB,6.2821E+01_JPRB/)  
KAO( :, 1,10,15) = (/&
 & 1.9076E-01_JPRB,1.6691E-01_JPRB,1.4306E-01_JPRB,1.1922E-01_JPRB,9.6624E-02_JPRB,7.8836E-02_JPRB,&
 & 6.0420E-02_JPRB,4.2402E-02_JPRB,1.1849E+02_JPRB/)  
KAO( :, 2,10,15) = (/&
 & 2.5693E-01_JPRB,2.2481E-01_JPRB,1.9273E-01_JPRB,1.6146E-01_JPRB,1.3713E-01_JPRB,1.1570E-01_JPRB,&
 & 8.9288E-02_JPRB,7.0550E-02_JPRB,1.6078E+02_JPRB/)  
KAO( :, 3,10,15) = (/&
 & 3.3240E-01_JPRB,2.9084E-01_JPRB,2.4929E-01_JPRB,2.1443E-01_JPRB,1.8866E-01_JPRB,1.5859E-01_JPRB,&
 & 1.2931E-01_JPRB,1.1318E-01_JPRB,2.0842E+02_JPRB/)  
KAO( :, 4,10,15) = (/&
 & 4.1554E-01_JPRB,3.6358E-01_JPRB,3.1223E-01_JPRB,2.7723E-01_JPRB,2.4827E-01_JPRB,2.1112E-01_JPRB,&
 & 1.8236E-01_JPRB,1.7494E-01_JPRB,2.6109E+02_JPRB/)  
KAO( :, 5,10,15) = (/&
 & 5.0485E-01_JPRB,4.4183E-01_JPRB,3.8382E-01_JPRB,3.4997E-01_JPRB,3.1509E-01_JPRB,2.7563E-01_JPRB,&
 & 2.5258E-01_JPRB,2.5852E-01_JPRB,3.1766E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART11',0,ZHOOK_HANDLE)


KAO( :, 1,11,15) = (/&
 & 2.1844E-01_JPRB,1.9116E-01_JPRB,1.6385E-01_JPRB,1.3654E-01_JPRB,1.1043E-01_JPRB,8.9314E-02_JPRB,&
 & 6.8138E-02_JPRB,4.5935E-02_JPRB,2.2340E+02_JPRB/)  
KAO( :, 2,11,15) = (/&
 & 2.8726E-01_JPRB,2.5136E-01_JPRB,2.1545E-01_JPRB,1.8158E-01_JPRB,1.5471E-01_JPRB,1.3017E-01_JPRB,&
 & 9.9967E-02_JPRB,7.4771E-02_JPRB,3.0363E+02_JPRB/)  
KAO( :, 3,11,15) = (/&
 & 3.7321E-01_JPRB,3.2655E-01_JPRB,2.7990E-01_JPRB,2.4162E-01_JPRB,2.1196E-01_JPRB,1.7932E-01_JPRB,&
 & 1.4260E-01_JPRB,1.1849E-01_JPRB,3.9534E+02_JPRB/)  
KAO( :, 4,11,15) = (/&
 & 4.6764E-01_JPRB,4.0919E-01_JPRB,3.5259E-01_JPRB,3.1283E-01_JPRB,2.7919E-01_JPRB,2.3760E-01_JPRB,&
 & 1.9841E-01_JPRB,1.8073E-01_JPRB,4.9612E+02_JPRB/)  
KAO( :, 5,11,15) = (/&
 & 5.6847E-01_JPRB,4.9745E-01_JPRB,4.3470E-01_JPRB,3.9501E-01_JPRB,3.5535E-01_JPRB,3.0691E-01_JPRB,&
 & 2.7182E-01_JPRB,2.6544E-01_JPRB,6.0376E+02_JPRB/)  
KAO( :, 1,12,15) = (/&
 & 2.5386E-01_JPRB,2.2213E-01_JPRB,1.9039E-01_JPRB,1.5866E-01_JPRB,1.2803E-01_JPRB,1.0260E-01_JPRB,&
 & 7.7411E-02_JPRB,5.0505E-02_JPRB,3.1181E+02_JPRB/)  
KAO( :, 2,12,15) = (/&
 & 3.2584E-01_JPRB,2.8511E-01_JPRB,2.4435E-01_JPRB,2.0586E-01_JPRB,1.7487E-01_JPRB,1.4640E-01_JPRB,&
 & 1.1295E-01_JPRB,8.0206E-02_JPRB,4.2527E+02_JPRB/)  
KAO( :, 3,12,15) = (/&
 & 4.2185E-01_JPRB,3.6913E-01_JPRB,3.1659E-01_JPRB,2.7453E-01_JPRB,2.3949E-01_JPRB,2.0235E-01_JPRB,&
 & 1.5885E-01_JPRB,1.2527E-01_JPRB,5.5386E+02_JPRB/)  
KAO( :, 4,12,15) = (/&
 & 5.2872E-01_JPRB,4.6263E-01_JPRB,4.0035E-01_JPRB,3.5526E-01_JPRB,3.1589E-01_JPRB,2.6854E-01_JPRB,&
 & 2.1892E-01_JPRB,1.8866E-01_JPRB,6.9524E+02_JPRB/)  
KAO( :, 5,12,15) = (/&
 & 6.4364E-01_JPRB,5.6320E-01_JPRB,4.9357E-01_JPRB,4.4708E-01_JPRB,4.0237E-01_JPRB,3.4474E-01_JPRB,&
 & 2.9649E-01_JPRB,2.7537E-01_JPRB,8.4735E+02_JPRB/)  
KAO( :, 1,13,15) = (/&
 & 3.0271E-01_JPRB,2.6486E-01_JPRB,2.2703E-01_JPRB,1.8919E-01_JPRB,1.5231E-01_JPRB,1.2084E-01_JPRB,&
 & 9.0270E-02_JPRB,5.7320E-02_JPRB,3.4698E+02_JPRB/)  
KAO( :, 2,13,15) = (/&
 & 3.8384E-01_JPRB,3.3586E-01_JPRB,2.8793E-01_JPRB,2.4185E-01_JPRB,2.0369E-01_JPRB,1.6894E-01_JPRB,&
 & 1.3012E-01_JPRB,8.8518E-02_JPRB,4.7325E+02_JPRB/)  
KAO( :, 3,13,15) = (/&
 & 4.9165E-01_JPRB,4.3019E-01_JPRB,3.6920E-01_JPRB,3.1973E-01_JPRB,2.7695E-01_JPRB,2.3380E-01_JPRB,&
 & 1.8192E-01_JPRB,1.3513E-01_JPRB,6.1726E+02_JPRB/)  
KAO( :, 4,13,15) = (/&
 & 6.1738E-01_JPRB,5.4020E-01_JPRB,4.6750E-01_JPRB,4.1230E-01_JPRB,3.6547E-01_JPRB,3.1024E-01_JPRB,&
 & 2.4776E-01_JPRB,2.0059E-01_JPRB,7.7596E+02_JPRB/)  
KAO( :, 5,13,15) = (/&
 & 7.5168E-01_JPRB,6.5770E-01_JPRB,5.7644E-01_JPRB,5.1768E-01_JPRB,4.6514E-01_JPRB,3.9851E-01_JPRB,&
 & 3.3091E-01_JPRB,2.9046E-01_JPRB,9.4535E+02_JPRB/)  
KAO( :, 1, 1,16) = (/&
 & 1.8794E-01_JPRB,1.6446E-01_JPRB,1.4098E-01_JPRB,1.4453E-01_JPRB,1.9112E-01_JPRB,2.3568E-01_JPRB,&
 & 2.7559E-01_JPRB,2.9928E-01_JPRB,3.6389E-01_JPRB/)  
KAO( :, 2, 1,16) = (/&
 & 2.1699E-01_JPRB,1.8988E-01_JPRB,1.6277E-01_JPRB,1.9700E-01_JPRB,2.6048E-01_JPRB,3.2128E-01_JPRB,&
 & 3.7575E-01_JPRB,4.0820E-01_JPRB,4.9613E-01_JPRB/)  
KAO( :, 3, 1,16) = (/&
 & 2.4618E-01_JPRB,2.1543E-01_JPRB,1.8468E-01_JPRB,2.5950E-01_JPRB,3.4314E-01_JPRB,4.2321E-01_JPRB,&
 & 4.9501E-01_JPRB,5.3795E-01_JPRB,6.5375E-01_JPRB/)  
KAO( :, 4, 1,16) = (/&
 & 2.7517E-01_JPRB,2.4080E-01_JPRB,2.2265E-01_JPRB,3.3206E-01_JPRB,4.3916E-01_JPRB,5.4174E-01_JPRB,&
 & 6.3374E-01_JPRB,6.8883E-01_JPRB,8.3685E-01_JPRB/)  
KAO( :, 5, 1,16) = (/&
 & 3.0356E-01_JPRB,2.6563E-01_JPRB,2.7796E-01_JPRB,4.1454E-01_JPRB,5.4825E-01_JPRB,6.7630E-01_JPRB,&
 & 7.9114E-01_JPRB,8.6022E-01_JPRB,1.0450E+00_JPRB/)  
KAO( :, 1, 2,16) = (/&
 & 2.1263E-01_JPRB,1.8604E-01_JPRB,1.5947E-01_JPRB,1.5196E-01_JPRB,2.0093E-01_JPRB,2.4784E-01_JPRB,&
 & 2.8986E-01_JPRB,3.1499E-01_JPRB,3.9172E-01_JPRB/)  
KAO( :, 2, 2,16) = (/&
 & 2.4750E-01_JPRB,2.1657E-01_JPRB,1.8564E-01_JPRB,2.1030E-01_JPRB,2.7808E-01_JPRB,3.4296E-01_JPRB,&
 & 4.0127E-01_JPRB,4.3611E-01_JPRB,5.4225E-01_JPRB/)  
KAO( :, 3, 2,16) = (/&
 & 2.8278E-01_JPRB,2.4744E-01_JPRB,2.1211E-01_JPRB,2.8057E-01_JPRB,3.7097E-01_JPRB,4.5769E-01_JPRB,&
 & 5.3545E-01_JPRB,5.8223E-01_JPRB,7.2368E-01_JPRB/)  
KAO( :, 4, 2,16) = (/&
 & 3.1792E-01_JPRB,2.7821E-01_JPRB,2.4340E-01_JPRB,3.6301E-01_JPRB,4.8000E-01_JPRB,5.9222E-01_JPRB,&
 & 6.9274E-01_JPRB,7.5351E-01_JPRB,9.3616E-01_JPRB/)  
KAO( :, 5, 2,16) = (/&
 & 3.5252E-01_JPRB,3.0850E-01_JPRB,3.0650E-01_JPRB,4.5727E-01_JPRB,6.0467E-01_JPRB,7.4622E-01_JPRB,&
 & 8.7306E-01_JPRB,9.4984E-01_JPRB,1.1794E+00_JPRB/)  
KAO( :, 1, 3,16) = (/&
 & 2.3237E-01_JPRB,2.0331E-01_JPRB,1.7427E-01_JPRB,1.4795E-01_JPRB,1.9535E-01_JPRB,2.4099E-01_JPRB,&
 & 2.8188E-01_JPRB,3.0650E-01_JPRB,3.8991E-01_JPRB/)  
KAO( :, 2, 3,16) = (/&
 & 2.7395E-01_JPRB,2.3972E-01_JPRB,2.0548E-01_JPRB,2.0945E-01_JPRB,2.7700E-01_JPRB,3.4180E-01_JPRB,&
 & 3.9994E-01_JPRB,4.3491E-01_JPRB,5.5290E-01_JPRB/)  
KAO( :, 3, 3,16) = (/&
 & 3.1641E-01_JPRB,2.7688E-01_JPRB,2.3734E-01_JPRB,2.8529E-01_JPRB,3.7722E-01_JPRB,4.6547E-01_JPRB,&
 & 5.4473E-01_JPRB,5.9265E-01_JPRB,7.5290E-01_JPRB/)  
KAO( :, 4, 3,16) = (/&
 & 3.5913E-01_JPRB,3.1425E-01_JPRB,2.6936E-01_JPRB,3.7538E-01_JPRB,4.9654E-01_JPRB,6.1283E-01_JPRB,&
 & 7.1724E-01_JPRB,7.8067E-01_JPRB,9.9115E-01_JPRB/)  
KAO( :, 5, 3,16) = (/&
 & 4.0136E-01_JPRB,3.5124E-01_JPRB,3.2170E-01_JPRB,4.7982E-01_JPRB,6.3476E-01_JPRB,7.8330E-01_JPRB,&
 & 9.1698E-01_JPRB,9.9858E-01_JPRB,1.2670E+00_JPRB/)  
KAO( :, 1, 4,16) = (/&
 & 2.4989E-01_JPRB,2.1869E-01_JPRB,1.8745E-01_JPRB,1.5621E-01_JPRB,1.8314E-01_JPRB,2.2578E-01_JPRB,&
 & 2.6437E-01_JPRB,2.8743E-01_JPRB,4.8014E-01_JPRB/)  
KAO( :, 2, 4,16) = (/&
 & 2.9922E-01_JPRB,2.6183E-01_JPRB,2.2443E-01_JPRB,2.0216E-01_JPRB,2.6741E-01_JPRB,3.2989E-01_JPRB,&
 & 3.8624E-01_JPRB,4.2053E-01_JPRB,5.7494E-01_JPRB/)  
KAO( :, 3, 4,16) = (/&
 & 3.5007E-01_JPRB,3.0634E-01_JPRB,2.6259E-01_JPRB,2.8203E-01_JPRB,3.7315E-01_JPRB,4.6045E-01_JPRB,&
 & 5.3900E-01_JPRB,5.8709E-01_JPRB,7.5343E-01_JPRB/)  
KAO( :, 4, 4,16) = (/&
 & 4.0160E-01_JPRB,3.5141E-01_JPRB,3.0118E-01_JPRB,3.7881E-01_JPRB,5.0127E-01_JPRB,6.1841E-01_JPRB,&
 & 7.2420E-01_JPRB,7.8857E-01_JPRB,1.0118E+00_JPRB/)  
KAO( :, 5, 4,16) = (/&
 & 4.5313E-01_JPRB,3.9646E-01_JPRB,3.4036E-01_JPRB,4.9269E-01_JPRB,6.5192E-01_JPRB,8.0453E-01_JPRB,&
 & 9.4219E-01_JPRB,1.0271E+00_JPRB,1.3148E+00_JPRB/)  
KAO( :, 1, 5,16) = (/&
 & 2.6693E-01_JPRB,2.3353E-01_JPRB,2.0017E-01_JPRB,1.6678E-01_JPRB,1.6870E-01_JPRB,2.0825E-01_JPRB,&
 & 2.4377E-01_JPRB,2.6562E-01_JPRB,1.0097E+00_JPRB/)  
KAO( :, 2, 5,16) = (/&
 & 3.2490E-01_JPRB,2.8429E-01_JPRB,2.4362E-01_JPRB,2.0306E-01_JPRB,2.5435E-01_JPRB,3.1387E-01_JPRB,&
 & 3.6729E-01_JPRB,4.0072E-01_JPRB,1.2293E+00_JPRB/)  
KAO( :, 3, 5,16) = (/&
 & 3.8533E-01_JPRB,3.3720E-01_JPRB,2.8903E-01_JPRB,2.7540E-01_JPRB,3.6433E-01_JPRB,4.4941E-01_JPRB,&
 & 5.2674E-01_JPRB,5.7460E-01_JPRB,1.4580E+00_JPRB/)  
KAO( :, 4, 5,16) = (/&
 & 4.4720E-01_JPRB,3.9129E-01_JPRB,3.3549E-01_JPRB,3.7808E-01_JPRB,5.0020E-01_JPRB,6.1752E-01_JPRB,&
 & 7.2292E-01_JPRB,7.8975E-01_JPRB,1.6925E+00_JPRB/)  
KAO( :, 5, 5,16) = (/&
 & 5.0948E-01_JPRB,4.4592E-01_JPRB,3.8223E-01_JPRB,5.0057E-01_JPRB,6.6242E-01_JPRB,8.1818E-01_JPRB,&
 & 9.5865E-01_JPRB,1.0467E+00_JPRB,1.9289E+00_JPRB/)  
KAO( :, 1, 6,16) = (/&
 & 2.8083E-01_JPRB,2.4573E-01_JPRB,2.1063E-01_JPRB,1.7555E-01_JPRB,1.5015E-01_JPRB,1.8516E-01_JPRB,&
 & 2.1690E-01_JPRB,2.3675E-01_JPRB,1.9657E+00_JPRB/)  
KAO( :, 2, 6,16) = (/&
 & 3.4835E-01_JPRB,3.0480E-01_JPRB,2.6132E-01_JPRB,2.1777E-01_JPRB,2.3453E-01_JPRB,2.8980E-01_JPRB,&
 & 3.3958E-01_JPRB,3.7078E-01_JPRB,2.4391E+00_JPRB/)  
KAO( :, 3, 6,16) = (/&
 & 4.1976E-01_JPRB,3.6729E-01_JPRB,3.1483E-01_JPRB,2.6738E-01_JPRB,3.4635E-01_JPRB,4.2784E-01_JPRB,&
 & 5.0150E-01_JPRB,5.4802E-01_JPRB,2.9392E+00_JPRB/)  
KAO( :, 4, 6,16) = (/&
 & 4.9356E-01_JPRB,4.3188E-01_JPRB,3.7019E-01_JPRB,3.6832E-01_JPRB,4.8722E-01_JPRB,6.0225E-01_JPRB,&
 & 7.0615E-01_JPRB,7.7190E-01_JPRB,3.4563E+00_JPRB/)  
KAO( :, 5, 6,16) = (/&
 & 5.6851E-01_JPRB,4.9738E-01_JPRB,4.2634E-01_JPRB,4.9804E-01_JPRB,6.5918E-01_JPRB,8.1420E-01_JPRB,&
 & 9.5511E-01_JPRB,1.0452E+00_JPRB,3.9808E+00_JPRB/)  
KAO( :, 1, 7,16) = (/&
 & 2.9602E-01_JPRB,2.5901E-01_JPRB,2.2201E-01_JPRB,1.8497E-01_JPRB,1.4799E-01_JPRB,1.6095E-01_JPRB,&
 & 1.8877E-01_JPRB,2.0662E-01_JPRB,3.9956E+00_JPRB/)  
KAO( :, 2, 7,16) = (/&
 & 3.7489E-01_JPRB,3.2803E-01_JPRB,2.8110E-01_JPRB,2.3429E-01_JPRB,2.1216E-01_JPRB,2.6198E-01_JPRB,&
 & 3.0739E-01_JPRB,3.3690E-01_JPRB,5.0612E+00_JPRB/)  
KAO( :, 3, 7,16) = (/&
 & 4.5934E-01_JPRB,4.0186E-01_JPRB,3.4446E-01_JPRB,2.8709E-01_JPRB,3.2355E-01_JPRB,3.9962E-01_JPRB,&
 & 4.6900E-01_JPRB,5.1413E-01_JPRB,6.2014E+00_JPRB/)  
KAO( :, 4, 7,16) = (/&
 & 5.4772E-01_JPRB,4.7919E-01_JPRB,4.1082E-01_JPRB,3.5907E-01_JPRB,4.6765E-01_JPRB,5.7781E-01_JPRB,&
 & 6.7844E-01_JPRB,7.4475E-01_JPRB,7.3945E+00_JPRB/)  
KAO( :, 5, 7,16) = (/&
 & 6.3818E-01_JPRB,5.5843E-01_JPRB,4.7875E-01_JPRB,4.8820E-01_JPRB,6.4638E-01_JPRB,7.9944E-01_JPRB,&
 & 9.3819E-01_JPRB,1.0310E+00_JPRB,8.6187E+00_JPRB/)  
KAO( :, 1, 8,16) = (/&
 & 3.1643E-01_JPRB,2.7689E-01_JPRB,2.3733E-01_JPRB,1.9778E-01_JPRB,1.5822E-01_JPRB,1.3698E-01_JPRB,&
 & 1.6092E-01_JPRB,1.7692E-01_JPRB,9.6744E+00_JPRB/)  
KAO( :, 2, 8,16) = (/&
 & 4.0971E-01_JPRB,3.5849E-01_JPRB,3.0728E-01_JPRB,2.5607E-01_JPRB,2.0550E-01_JPRB,2.3311E-01_JPRB,&
 & 2.7394E-01_JPRB,3.0140E-01_JPRB,1.2526E+01_JPRB/)  
KAO( :, 3, 8,16) = (/&
 & 5.1114E-01_JPRB,4.4727E-01_JPRB,3.8338E-01_JPRB,3.1946E-01_JPRB,2.9762E-01_JPRB,3.6825E-01_JPRB,&
 & 4.3294E-01_JPRB,4.7698E-01_JPRB,1.5632E+01_JPRB/)  
KAO( :, 4, 8,16) = (/&
 & 6.1845E-01_JPRB,5.4119E-01_JPRB,4.6383E-01_JPRB,3.8657E-01_JPRB,4.4256E-01_JPRB,5.4777E-01_JPRB,&
 & 6.4434E-01_JPRB,7.1023E-01_JPRB,1.8915E+01_JPRB/)  
KAO( :, 5, 8,16) = (/&
 & 7.2956E-01_JPRB,6.3833E-01_JPRB,5.4715E-01_JPRB,4.8521E-01_JPRB,6.2642E-01_JPRB,7.7483E-01_JPRB,&
 & 9.1223E-01_JPRB,1.0061E+00_JPRB,2.2311E+01_JPRB/)  
KAO( :, 1, 9,16) = (/&
 & 3.3206E-01_JPRB,2.9059E-01_JPRB,2.4908E-01_JPRB,2.0756E-01_JPRB,1.6605E-01_JPRB,1.2520E-01_JPRB,&
 & 1.3332E-01_JPRB,1.4726E-01_JPRB,4.3754E+01_JPRB/)  
KAO( :, 2, 9,16) = (/&
 & 4.4050E-01_JPRB,3.8544E-01_JPRB,3.3040E-01_JPRB,2.7529E-01_JPRB,2.2025E-01_JPRB,2.0212E-01_JPRB,&
 & 2.3801E-01_JPRB,2.6323E-01_JPRB,5.8016E+01_JPRB/)  
KAO( :, 3, 9,16) = (/&
 & 5.6026E-01_JPRB,4.9023E-01_JPRB,4.2020E-01_JPRB,3.5022E-01_JPRB,2.8778E-01_JPRB,3.3184E-01_JPRB,&
 & 3.9083E-01_JPRB,4.3264E-01_JPRB,7.3805E+01_JPRB/)  
KAO( :, 4, 9,16) = (/&
 & 6.8858E-01_JPRB,6.0253E-01_JPRB,5.1637E-01_JPRB,4.3040E-01_JPRB,4.1206E-01_JPRB,5.0884E-01_JPRB,&
 & 5.9967E-01_JPRB,6.6456E-01_JPRB,9.0709E+01_JPRB/)  
KAO( :, 5, 9,16) = (/&
 & 8.2259E-01_JPRB,7.1975E-01_JPRB,6.1688E-01_JPRB,5.1707E-01_JPRB,5.9606E-01_JPRB,7.3858E-01_JPRB,&
 & 8.7057E-01_JPRB,9.6569E-01_JPRB,1.0838E+02_JPRB/)  
KAO( :, 1,10,16) = (/&
 & 3.5261E-01_JPRB,3.0855E-01_JPRB,2.6447E-01_JPRB,2.2042E-01_JPRB,1.7636E-01_JPRB,1.3225E-01_JPRB,&
 & 1.1302E-01_JPRB,1.2540E-01_JPRB,2.2383E+02_JPRB/)  
KAO( :, 2,10,16) = (/&
 & 4.7821E-01_JPRB,4.1843E-01_JPRB,3.5857E-01_JPRB,2.9886E-01_JPRB,2.3906E-01_JPRB,1.8964E-01_JPRB,&
 & 2.1098E-01_JPRB,2.3441E-01_JPRB,3.0350E+02_JPRB/)  
KAO( :, 3,10,16) = (/&
 & 6.1881E-01_JPRB,5.4145E-01_JPRB,4.6410E-01_JPRB,3.8673E-01_JPRB,3.0946E-01_JPRB,3.0407E-01_JPRB,&
 & 3.5878E-01_JPRB,3.9920E-01_JPRB,3.9277E+02_JPRB/)  
KAO( :, 4,10,16) = (/&
 & 7.7105E-01_JPRB,6.7484E-01_JPRB,5.7823E-01_JPRB,4.8190E-01_JPRB,4.1230E-01_JPRB,4.7947E-01_JPRB,&
 & 5.6602E-01_JPRB,6.3051E-01_JPRB,4.8953E+02_JPRB/)  
KAO( :, 5,10,16) = (/&
 & 9.3145E-01_JPRB,8.1502E-01_JPRB,6.9859E-01_JPRB,5.8205E-01_JPRB,5.7779E-01_JPRB,7.1138E-01_JPRB,&
 & 8.4040E-01_JPRB,9.3669E-01_JPRB,5.9127E+02_JPRB/)  
KAO( :, 1,11,16) = (/&
 & 4.3261E-01_JPRB,3.7853E-01_JPRB,3.2446E-01_JPRB,2.7039E-01_JPRB,2.1632E-01_JPRB,1.6222E-01_JPRB,&
 & 1.3099E-01_JPRB,1.4452E-01_JPRB,4.6285E+02_JPRB/)  
KAO( :, 2,11,16) = (/&
 & 5.8535E-01_JPRB,5.1218E-01_JPRB,4.3901E-01_JPRB,3.6590E-01_JPRB,2.9265E-01_JPRB,2.2872E-01_JPRB,&
 & 2.4101E-01_JPRB,2.6929E-01_JPRB,6.2611E+02_JPRB/)  
KAO( :, 3,11,16) = (/&
 & 7.5565E-01_JPRB,6.6141E-01_JPRB,5.6693E-01_JPRB,4.7237E-01_JPRB,3.7786E-01_JPRB,3.5050E-01_JPRB,&
 & 4.0844E-01_JPRB,4.5697E-01_JPRB,8.0847E+02_JPRB/)  
KAO( :, 4,11,16) = (/&
 & 9.3953E-01_JPRB,8.2209E-01_JPRB,7.0458E-01_JPRB,5.8709E-01_JPRB,4.9467E-01_JPRB,5.4296E-01_JPRB,&
 & 6.4241E-01_JPRB,7.1951E-01_JPRB,1.0051E+03_JPRB/)  
KAO( :, 5,11,16) = (/&
 & 1.1321E+00_JPRB,9.9048E-01_JPRB,8.4898E-01_JPRB,7.0764E-01_JPRB,6.7182E-01_JPRB,8.0337E-01_JPRB,&
 & 9.5077E-01_JPRB,1.0665E+00_JPRB,1.2110E+03_JPRB/)  
KAO( :, 1,12,16) = (/&
 & 5.3519E-01_JPRB,4.6832E-01_JPRB,4.0142E-01_JPRB,3.3452E-01_JPRB,2.6763E-01_JPRB,2.0072E-01_JPRB,&
 & 1.5467E-01_JPRB,1.6502E-01_JPRB,7.0824E+02_JPRB/)  
KAO( :, 2,12,16) = (/&
 & 7.2183E-01_JPRB,6.3160E-01_JPRB,5.4131E-01_JPRB,4.5112E-01_JPRB,3.6090E-01_JPRB,2.7900E-01_JPRB,&
 & 2.7245E-01_JPRB,3.0622E-01_JPRB,9.5519E+02_JPRB/)  
KAO( :, 3,12,16) = (/&
 & 9.2882E-01_JPRB,8.1286E-01_JPRB,6.9674E-01_JPRB,5.8057E-01_JPRB,4.6450E-01_JPRB,4.1101E-01_JPRB,&
 & 4.5999E-01_JPRB,5.1778E-01_JPRB,1.2292E+03_JPRB/)  
KAO( :, 4,12,16) = (/&
 & 1.1518E+00_JPRB,1.0078E+00_JPRB,8.6369E-01_JPRB,7.1969E-01_JPRB,5.9900E-01_JPRB,6.1266E-01_JPRB,&
 & 7.2069E-01_JPRB,8.1237E-01_JPRB,1.5237E+03_JPRB/)  
KAO( :, 5,12,16) = (/&
 & 1.3877E+00_JPRB,1.2141E+00_JPRB,1.0407E+00_JPRB,8.6727E-01_JPRB,7.9163E-01_JPRB,8.9653E-01_JPRB,&
 & 1.0630E+00_JPRB,1.1997E+00_JPRB,1.8362E+03_JPRB/)  
KAO( :, 1,13,16) = (/&
 & 6.8305E-01_JPRB,5.9769E-01_JPRB,5.1231E-01_JPRB,4.2692E-01_JPRB,3.4152E-01_JPRB,2.5608E-01_JPRB,&
 & 1.8801E-01_JPRB,1.8615E-01_JPRB,8.6247E+02_JPRB/)  
KAO( :, 2,13,16) = (/&
 & 9.1792E-01_JPRB,8.0318E-01_JPRB,6.8841E-01_JPRB,5.7362E-01_JPRB,4.5889E-01_JPRB,3.5002E-01_JPRB,&
 & 3.1177E-01_JPRB,3.4406E-01_JPRB,1.1588E+03_JPRB/)  
KAO( :, 3,13,16) = (/&
 & 1.1812E+00_JPRB,1.0334E+00_JPRB,8.8578E-01_JPRB,7.3808E-01_JPRB,5.9053E-01_JPRB,4.9511E-01_JPRB,&
 & 5.1116E-01_JPRB,5.7929E-01_JPRB,1.4913E+03_JPRB/)  
KAO( :, 4,13,16) = (/&
 & 1.4677E+00_JPRB,1.2842E+00_JPRB,1.1009E+00_JPRB,9.1748E-01_JPRB,7.4504E-01_JPRB,7.0766E-01_JPRB,&
 & 7.9819E-01_JPRB,9.0553E-01_JPRB,1.8526E+03_JPRB/)  
KAO( :, 5,13,16) = (/&
 & 1.7710E+00_JPRB,1.5496E+00_JPRB,1.3282E+00_JPRB,1.1069E+00_JPRB,9.5682E-01_JPRB,1.0004E+00_JPRB,&
 & 1.1734E+00_JPRB,1.3329E+00_JPRB,2.2362E+03_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 9.83745E-03_JPRB, 8.45687E-03_JPRB, 7.27004E-03_JPRB, 6.24977E-03_JPRB, 5.37269E-03_JPRB,&
 & 4.61869E-03_JPRB, 3.97051E-03_JPRB, 3.41329E-03_JPRB, 2.93427E-03_JPRB, 2.52248E-03_JPRB/)  
SELFREFO( :, 2) = (/&
 & 9.79014E-03_JPRB, 8.48557E-03_JPRB, 7.35483E-03_JPRB, 6.37477E-03_JPRB, 5.52531E-03_JPRB,&
 & 4.78905E-03_JPRB, 4.15089E-03_JPRB, 3.59777E-03_JPRB, 3.11835E-03_JPRB, 2.70282E-03_JPRB/)  
SELFREFO( :, 3) = (/&
 & 9.36931E-03_JPRB, 8.10880E-03_JPRB, 7.01787E-03_JPRB, 6.07371E-03_JPRB, 5.25658E-03_JPRB,&
 & 4.54938E-03_JPRB, 3.93732E-03_JPRB, 3.40761E-03_JPRB, 2.94916E-03_JPRB, 2.55239E-03_JPRB/)  
SELFREFO( :, 4) = (/&
 & 8.44896E-03_JPRB, 7.26401E-03_JPRB, 6.24525E-03_JPRB, 5.36937E-03_JPRB, 4.61632E-03_JPRB,&
 & 3.96889E-03_JPRB, 3.41226E-03_JPRB, 2.93370E-03_JPRB, 2.52226E-03_JPRB, 2.16851E-03_JPRB/)  
SELFREFO( :, 5) = (/&
 & 6.69018E-03_JPRB, 5.93911E-03_JPRB, 5.27237E-03_JPRB, 4.68047E-03_JPRB, 4.15502E-03_JPRB,&
 & 3.68856E-03_JPRB, 3.27447E-03_JPRB, 2.90686E-03_JPRB, 2.58053E-03_JPRB, 2.29083E-03_JPRB/)  
SELFREFO( :, 6) = (/&
 & 6.26590E-03_JPRB, 5.54076E-03_JPRB, 4.89954E-03_JPRB, 4.33252E-03_JPRB, 3.83113E-03_JPRB,&
 & 3.38776E-03_JPRB, 2.99570E-03_JPRB, 2.64901E-03_JPRB, 2.34244E-03_JPRB, 2.07136E-03_JPRB/)  
SELFREFO( :, 7) = (/&
 & 6.01943E-03_JPRB, 5.31006E-03_JPRB, 4.68429E-03_JPRB, 4.13226E-03_JPRB, 3.64529E-03_JPRB,&
 & 3.21570E-03_JPRB, 2.83674E-03_JPRB, 2.50244E-03_JPRB, 2.20754E-03_JPRB, 1.94739E-03_JPRB/)  
SELFREFO( :, 8) = (/&
 & 5.80205E-03_JPRB, 5.07696E-03_JPRB, 4.44248E-03_JPRB, 3.88730E-03_JPRB, 3.40149E-03_JPRB,&
 & 2.97640E-03_JPRB, 2.60444E-03_JPRB, 2.27895E-03_JPRB, 1.99415E-03_JPRB, 1.74494E-03_JPRB/)  
SELFREFO( :, 9) = (/&
 & 4.90962E-03_JPRB, 4.54613E-03_JPRB, 4.20956E-03_JPRB, 3.89790E-03_JPRB, 3.60931E-03_JPRB,&
 & 3.34210E-03_JPRB, 3.09466E-03_JPRB, 2.86555E-03_JPRB, 2.65339E-03_JPRB, 2.45695E-03_JPRB/)  
SELFREFO( :,10) = (/&
 & 4.51541E-03_JPRB, 4.34841E-03_JPRB, 4.18758E-03_JPRB, 4.03271E-03_JPRB, 3.88356E-03_JPRB,&
 & 3.73992E-03_JPRB, 3.60160E-03_JPRB, 3.46840E-03_JPRB, 3.34012E-03_JPRB, 3.21658E-03_JPRB/)  
SELFREFO( :,11) = (/&
 & 4.41859E-03_JPRB, 4.25299E-03_JPRB, 4.09360E-03_JPRB, 3.94018E-03_JPRB, 3.79252E-03_JPRB,&
 & 3.65038E-03_JPRB, 3.51357E-03_JPRB, 3.38189E-03_JPRB, 3.25515E-03_JPRB, 3.13316E-03_JPRB/)  
SELFREFO( :,12) = (/&
 & 4.41867E-03_JPRB, 4.22140E-03_JPRB, 4.03294E-03_JPRB, 3.85289E-03_JPRB, 3.68088E-03_JPRB,&
 & 3.51655E-03_JPRB, 3.35956E-03_JPRB, 3.20957E-03_JPRB, 3.06628E-03_JPRB, 2.92939E-03_JPRB/)  
SELFREFO( :,13) = (/&
 & 4.42776E-03_JPRB, 4.34604E-03_JPRB, 4.26583E-03_JPRB, 4.18710E-03_JPRB, 4.10983E-03_JPRB,&
 & 4.03398E-03_JPRB, 3.95953E-03_JPRB, 3.88645E-03_JPRB, 3.81472E-03_JPRB, 3.74432E-03_JPRB/)  
SELFREFO( :,14) = (/&
 & 4.46410E-03_JPRB, 4.46210E-03_JPRB, 4.46011E-03_JPRB, 4.45812E-03_JPRB, 4.45613E-03_JPRB,&
 & 4.45414E-03_JPRB, 4.45216E-03_JPRB, 4.45017E-03_JPRB, 4.44818E-03_JPRB, 4.44620E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART12',0,ZHOOK_HANDLE)


SELFREFO( :,15) = (/&
 & 3.21270E-03_JPRB, 3.42098E-03_JPRB, 3.64276E-03_JPRB, 3.87892E-03_JPRB, 4.13040E-03_JPRB,&
 & 4.39817E-03_JPRB, 4.68330E-03_JPRB, 4.98692E-03_JPRB, 5.31023E-03_JPRB, 5.65449E-03_JPRB/)  
SELFREFO( :,16) = (/&
 & 3.11411E-03_JPRB, 3.35874E-03_JPRB, 3.62259E-03_JPRB, 3.90717E-03_JPRB, 4.21410E-03_JPRB,&
 & 4.54514E-03_JPRB, 4.90219E-03_JPRB, 5.28729E-03_JPRB, 5.70264E-03_JPRB, 6.15061E-03_JPRB/)  

FRACREFAO( : , 1) = (/&
 !   From P = 706.3 mb.
 & 0.17683899_JPRB,0.17319500_JPRB,0.15712699_JPRB,0.13604601_JPRB,&
 & 0.10776200_JPRB,0.08750010_JPRB,0.06808820_JPRB,0.04905150_JPRB,&
 & 0.03280360_JPRB,0.00350836_JPRB,0.00281864_JPRB,0.00219862_JPRB,&
 & 0.00160943_JPRB,0.00101885_JPRB,0.00038147_JPRB,0.00005348_JPRB/)  
FRACREFAO( : , 2) = (/&
 & 0.17535400_JPRB,0.16999300_JPRB,0.15610200_JPRB,0.13589200_JPRB,&
 & 0.10842100_JPRB,0.08988550_JPRB,0.06943920_JPRB,0.04974900_JPRB,&
 & 0.03323400_JPRB,0.00352752_JPRB,0.00289402_JPRB,0.00231003_JPRB,&
 & 0.00174659_JPRB,0.00101884_JPRB,0.00038147_JPRB,0.00005348_JPRB/)  
FRACREFAO( : , 3) = (/&
 & 0.17409500_JPRB,0.16846400_JPRB,0.15641899_JPRB,0.13503000_JPRB,&
 & 0.10838600_JPRB,0.08985800_JPRB,0.07092720_JPRB,0.05075710_JPRB,&
 & 0.03364180_JPRB,0.00354241_JPRB,0.00303507_JPRB,0.00243391_JPRB,&
 & 0.00177502_JPRB,0.00114638_JPRB,0.00043585_JPRB,0.00005348_JPRB/)  
FRACREFAO( : , 4) = (/&
 & 0.17248300_JPRB,0.16778600_JPRB,0.15543500_JPRB,0.13496999_JPRB,&
 & 0.10826300_JPRB,0.09028740_JPRB,0.07156720_JPRB,0.05187120_JPRB,&
 & 0.03424890_JPRB,0.00363933_JPRB,0.00324715_JPRB,0.00255030_JPRB,&
 & 0.00187380_JPRB,0.00116978_JPRB,0.00051229_JPRB,0.00009768_JPRB/)  
FRACREFAO( : , 5) = (/&
 & 0.17061099_JPRB,0.16715799_JPRB,0.15405200_JPRB,0.13471501_JPRB,&
 & 0.10896400_JPRB,0.09069460_JPRB,0.07229760_JPRB,0.05218280_JPRB,&
 & 0.03555340_JPRB,0.00379576_JPRB,0.00330240_JPRB,0.00274693_JPRB,&
 & 0.00201587_JPRB,0.00119598_JPRB,0.00061885_JPRB,0.00009768_JPRB/)  
FRACREFAO( : , 6) = (/&
 & 0.16789700_JPRB,0.16629100_JPRB,0.15270300_JPRB,0.13360199_JPRB,&
 & 0.11047200_JPRB,0.09151080_JPRB,0.07325000_JPRB,0.05261450_JPRB,&
 & 0.03657990_JPRB,0.00450092_JPRB,0.00349537_JPRB,0.00283321_JPRB,&
 & 0.00208396_JPRB,0.00140354_JPRB,0.00066587_JPRB,0.00009768_JPRB/)  
FRACREFAO( : , 7) = (/&
 & 0.16412200_JPRB,0.16387400_JPRB,0.15211500_JPRB,0.13062200_JPRB,&
 & 0.11325100_JPRB,0.09348130_JPRB,0.07381380_JPRB,0.05434740_JPRB,&
 & 0.03803160_JPRB,0.00481346_JPRB,0.00393592_JPRB,0.00296633_JPRB,&
 & 0.00222532_JPRB,0.00163762_JPRB,0.00066648_JPRB,0.00009768_JPRB/)  
FRACREFAO( : , 8) = (/&
 & 0.15513401_JPRB,0.15768200_JPRB,0.14850400_JPRB,0.13330200_JPRB,&
 & 0.11446500_JPRB,0.09868230_JPRB,0.07642050_JPRB,0.05624170_JPRB,&
 & 0.04197810_JPRB,0.00502288_JPRB,0.00429452_JPRB,0.00315347_JPRB,&
 & 0.00263559_JPRB,0.00171772_JPRB,0.00066860_JPRB,0.00009768_JPRB/)  
FRACREFAO( : , 9) = (/&
 & 0.15732600_JPRB,0.15223300_JPRB,0.14271900_JPRB,0.13563600_JPRB,&
 & 0.11859600_JPRB,0.10274200_JPRB,0.07934560_JPRB,0.05763410_JPRB,&
 & 0.03921740_JPRB,0.00437741_JPRB,0.00337921_JPRB,0.00280212_JPRB,&
 & 0.00200156_JPRB,0.00124812_JPRB,0.00064664_JPRB,0.00009768_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB13:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


END SUBROUTINE RRTM_KGB13
