!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB6

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 6:  820-980 cm-1 (low - H2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO6 , ONLY : KAO     ,SELFREFO   ,FRACREFAO  ,CFC11ADJO ,&
 & CFC12O   , ABSCO2O   

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB6:PART1',0,ZHOOK_HANDLE)


FRACREFAO( :) = (/&
 !     From P = 706 mb.
 & 0.13739009_JPRB,0.14259538_JPRB,0.14033118_JPRB,0.13547136_JPRB,&
 & 0.12569460_JPRB,0.11028396_JPRB,0.08626066_JPRB,0.06245148_JPRB,&
 & 0.04309394_JPRB,0.00473551_JPRB,0.00403920_JPRB,0.00321695_JPRB,&
 & 0.00232470_JPRB,0.00147662_JPRB,0.00056095_JPRB,0.00007373_JPRB/)  

!     CFC11 is multiplied by 1.385 to account for the 1060-1107 cm-1 band.
CFC11ADJO( :) = (/&
 & 0.0_JPRB,      0.0_JPRB, 36.7627_JPRB, 150.757_JPRB,    &
 & 81.4109_JPRB, 74.9112_JPRB, 56.9325_JPRB, 49.3226_JPRB,  &
 & 57.1074_JPRB, 66.1202_JPRB, 109.557_JPRB, 89.0562_JPRB,  &
 & 149.865_JPRB, 196.140_JPRB, 258.393_JPRB, 80.9923_JPRB/)  

CFC12O( :) = (/&
 & 62.8368_JPRB, 43.2626_JPRB, 26.7549_JPRB, 22.2487_JPRB,&
 & 23.5029_JPRB, 34.8323_JPRB, 26.2335_JPRB, 23.2306_JPRB,&
 & 18.4062_JPRB, 13.9534_JPRB, 22.6268_JPRB, 24.2604_JPRB,&
 & 30.0088_JPRB, 26.3634_JPRB, 15.8237_JPRB, 57.5050_JPRB/)  

ABSCO2O( :) = (/&
 & 7.44852E-05_JPRB, 6.29208E-05_JPRB, 7.34031E-05_JPRB, 6.65218E-05_JPRB,&
 & 7.87511E-05_JPRB, 1.22489E-04_JPRB, 3.39785E-04_JPRB, 9.33040E-04_JPRB,&
 & 1.54323E-03_JPRB, 4.07220E-04_JPRB, 4.34332E-04_JPRB, 8.76418E-05_JPRB,&
 & 9.80381E-05_JPRB, 3.51680E-05_JPRB, 5.31766E-05_JPRB, 1.01542E-05_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 2.2568E-05_JPRB,2.5521E-05_JPRB,2.4392E-05_JPRB,2.3686E-05_JPRB,2.3850E-05_JPRB/)  
KAO( :, 2, 1) = (/&
 & 1.8872E-05_JPRB,1.8763E-05_JPRB,1.8106E-05_JPRB,1.7702E-05_JPRB,1.7681E-05_JPRB/)  
KAO( :, 3, 1) = (/&
 & 1.2996E-05_JPRB,1.3086E-05_JPRB,1.3378E-05_JPRB,1.3260E-05_JPRB,1.1771E-05_JPRB/)  
KAO( :, 4, 1) = (/&
 & 9.6276E-06_JPRB,9.9774E-06_JPRB,9.6694E-06_JPRB,8.4861E-06_JPRB,8.9160E-06_JPRB/)  
KAO( :, 5, 1) = (/&
 & 7.1690E-06_JPRB,7.2984E-06_JPRB,5.8013E-06_JPRB,6.2225E-06_JPRB,6.6628E-06_JPRB/)  
KAO( :, 6, 1) = (/&
 & 5.6038E-06_JPRB,4.4095E-06_JPRB,4.4722E-06_JPRB,4.4395E-06_JPRB,5.4630E-06_JPRB/)  
KAO( :, 7, 1) = (/&
 & 3.4775E-06_JPRB,3.0437E-06_JPRB,3.3876E-06_JPRB,3.8636E-06_JPRB,4.9257E-06_JPRB/)  
KAO( :, 8, 1) = (/&
 & 2.7310E-06_JPRB,3.2224E-06_JPRB,3.6552E-06_JPRB,4.3975E-06_JPRB,5.5359E-06_JPRB/)  
KAO( :, 9, 1) = (/&
 & 6.6325E-06_JPRB,7.7076E-06_JPRB,8.9070E-06_JPRB,1.0179E-05_JPRB,1.1909E-05_JPRB/)  
KAO( :,10, 1) = (/&
 & 2.4079E-05_JPRB,2.6989E-05_JPRB,3.0753E-05_JPRB,3.4229E-05_JPRB,3.8060E-05_JPRB/)  
KAO( :,11, 1) = (/&
 & 3.3970E-05_JPRB,3.7965E-05_JPRB,4.2993E-05_JPRB,4.7630E-05_JPRB,5.2629E-05_JPRB/)  
KAO( :,12, 1) = (/&
 & 3.5907E-05_JPRB,4.0095E-05_JPRB,4.5267E-05_JPRB,5.0045E-05_JPRB,5.5178E-05_JPRB/)  
KAO( :,13, 1) = (/&
 & 3.0600E-05_JPRB,3.4162E-05_JPRB,3.8530E-05_JPRB,4.2579E-05_JPRB,4.6937E-05_JPRB/)  
KAO( :, 1, 2) = (/&
 & 2.9639E-05_JPRB,3.3221E-05_JPRB,3.2806E-05_JPRB,2.8964E-05_JPRB,2.6726E-05_JPRB/)  
KAO( :, 2, 2) = (/&
 & 2.3653E-05_JPRB,2.4355E-05_JPRB,2.4028E-05_JPRB,2.0887E-05_JPRB,2.2925E-05_JPRB/)  
KAO( :, 3, 2) = (/&
 & 1.6734E-05_JPRB,1.6216E-05_JPRB,1.4570E-05_JPRB,1.6223E-05_JPRB,1.7762E-05_JPRB/)  
KAO( :, 4, 2) = (/&
 & 1.0615E-05_JPRB,1.0115E-05_JPRB,1.1508E-05_JPRB,1.1885E-05_JPRB,1.3929E-05_JPRB/)  
KAO( :, 5, 2) = (/&
 & 7.5406E-06_JPRB,7.3085E-06_JPRB,8.6006E-06_JPRB,9.3888E-06_JPRB,1.1719E-05_JPRB/)  
KAO( :, 6, 2) = (/&
 & 4.8289E-06_JPRB,6.2547E-06_JPRB,5.8818E-06_JPRB,7.9263E-06_JPRB,1.0542E-05_JPRB/)  
KAO( :, 7, 2) = (/&
 & 4.3622E-06_JPRB,4.7605E-06_JPRB,5.4656E-06_JPRB,7.2224E-06_JPRB,1.0212E-05_JPRB/)  
KAO( :, 8, 2) = (/&
 & 4.2923E-06_JPRB,4.6584E-06_JPRB,6.2268E-06_JPRB,8.3462E-06_JPRB,1.1797E-05_JPRB/)  
KAO( :, 9, 2) = (/&
 & 9.7259E-06_JPRB,1.1243E-05_JPRB,1.3832E-05_JPRB,1.8290E-05_JPRB,2.4869E-05_JPRB/)  
KAO( :,10, 2) = (/&
 & 3.3596E-05_JPRB,3.8056E-05_JPRB,4.3895E-05_JPRB,5.4699E-05_JPRB,7.1889E-05_JPRB/)  
KAO( :,11, 2) = (/&
 & 4.7132E-05_JPRB,5.3142E-05_JPRB,6.1177E-05_JPRB,7.5188E-05_JPRB,9.8046E-05_JPRB/)  
KAO( :,12, 2) = (/&
 & 4.9755E-05_JPRB,5.6067E-05_JPRB,6.4461E-05_JPRB,7.8769E-05_JPRB,1.0238E-04_JPRB/)  
KAO( :,13, 2) = (/&
 & 4.2448E-05_JPRB,4.7895E-05_JPRB,5.4990E-05_JPRB,6.7099E-05_JPRB,8.7152E-05_JPRB/)  
KAO( :, 1, 3) = (/&
 & 2.4391E-05_JPRB,2.6179E-05_JPRB,3.0228E-05_JPRB,3.9877E-05_JPRB,4.1318E-05_JPRB/)  
KAO( :, 2, 3) = (/&
 & 2.0506E-05_JPRB,2.0015E-05_JPRB,2.6885E-05_JPRB,2.9284E-05_JPRB,2.9837E-05_JPRB/)  
KAO( :, 3, 3) = (/&
 & 1.3542E-05_JPRB,1.5721E-05_JPRB,1.9501E-05_JPRB,1.8947E-05_JPRB,2.4397E-05_JPRB/)  
KAO( :, 4, 3) = (/&
 & 9.0261E-06_JPRB,1.3633E-05_JPRB,1.2485E-05_JPRB,1.7278E-05_JPRB,2.0007E-05_JPRB/)  
KAO( :, 5, 3) = (/&
 & 8.7945E-06_JPRB,9.7631E-06_JPRB,1.1634E-05_JPRB,1.3600E-05_JPRB,1.9745E-05_JPRB/)  
KAO( :, 6, 3) = (/&
 & 7.5275E-06_JPRB,7.1532E-06_JPRB,9.4521E-06_JPRB,1.3168E-05_JPRB,1.9311E-05_JPRB/)  
KAO( :, 7, 3) = (/&
 & 5.6021E-06_JPRB,6.6005E-06_JPRB,8.8148E-06_JPRB,1.3299E-05_JPRB,1.9798E-05_JPRB/)  
KAO( :, 8, 3) = (/&
 & 5.6076E-06_JPRB,7.6899E-06_JPRB,1.0237E-05_JPRB,1.5421E-05_JPRB,2.3499E-05_JPRB/)  
KAO( :, 9, 3) = (/&
 & 1.3625E-05_JPRB,1.7122E-05_JPRB,2.2283E-05_JPRB,3.1506E-05_JPRB,4.8193E-05_JPRB/)  
KAO( :,10, 3) = (/&
 & 4.6234E-05_JPRB,5.4855E-05_JPRB,6.8590E-05_JPRB,8.9964E-05_JPRB,1.3093E-04_JPRB/)  
KAO( :,11, 3) = (/&
 & 6.5003E-05_JPRB,7.6686E-05_JPRB,9.5408E-05_JPRB,1.2507E-04_JPRB,1.8079E-04_JPRB/)  
KAO( :,12, 3) = (/&
 & 6.8759E-05_JPRB,8.1014E-05_JPRB,1.0079E-04_JPRB,1.3196E-04_JPRB,1.9017E-04_JPRB/)  
KAO( :,13, 3) = (/&
 & 5.8741E-05_JPRB,6.9297E-05_JPRB,8.6397E-05_JPRB,1.1292E-04_JPRB,1.6288E-04_JPRB/)  
KAO( :, 1, 4) = (/&
 & 3.6952E-05_JPRB,3.9167E-05_JPRB,4.5764E-05_JPRB,4.7701E-05_JPRB,5.5871E-05_JPRB/)  
KAO( :, 2, 4) = (/&
 & 2.6008E-05_JPRB,3.6209E-05_JPRB,2.8658E-05_JPRB,3.8449E-05_JPRB,3.8668E-05_JPRB/)  
KAO( :, 3, 4) = (/&
 & 2.1596E-05_JPRB,2.1370E-05_JPRB,2.2422E-05_JPRB,2.7123E-05_JPRB,3.0425E-05_JPRB/)  
KAO( :, 4, 4) = (/&
 & 1.4408E-05_JPRB,1.3094E-05_JPRB,1.9460E-05_JPRB,2.1634E-05_JPRB,3.3208E-05_JPRB/)  
KAO( :, 5, 4) = (/&
 & 8.9120E-06_JPRB,1.2874E-05_JPRB,1.5169E-05_JPRB,2.3591E-05_JPRB,3.5032E-05_JPRB/)  
KAO( :, 6, 4) = (/&
 & 7.0427E-06_JPRB,1.1114E-05_JPRB,1.4987E-05_JPRB,2.2856E-05_JPRB,3.4461E-05_JPRB/)  
KAO( :, 7, 4) = (/&
 & 7.4919E-06_JPRB,9.5389E-06_JPRB,1.5038E-05_JPRB,2.3474E-05_JPRB,3.5967E-05_JPRB/)  
KAO( :, 8, 4) = (/&
 & 8.6186E-06_JPRB,1.1413E-05_JPRB,1.7846E-05_JPRB,2.8336E-05_JPRB,4.4637E-05_JPRB/)  
KAO( :, 9, 4) = (/&
 & 1.9661E-05_JPRB,2.5521E-05_JPRB,3.7417E-05_JPRB,5.9323E-05_JPRB,9.6439E-05_JPRB/)  
KAO( :,10, 4) = (/&
 & 6.3994E-05_JPRB,8.1146E-05_JPRB,1.0850E-04_JPRB,1.6659E-04_JPRB,2.7179E-04_JPRB/)  
KAO( :,11, 4) = (/&
 & 9.0362E-05_JPRB,1.1392E-04_JPRB,1.5220E-04_JPRB,2.3565E-04_JPRB,3.8761E-04_JPRB/)  
KAO( :,12, 4) = (/&
 & 9.5893E-05_JPRB,1.2069E-04_JPRB,1.6199E-04_JPRB,2.5340E-04_JPRB,4.1839E-04_JPRB/)  
KAO( :,13, 4) = (/&
 & 8.2144E-05_JPRB,1.0344E-04_JPRB,1.3998E-04_JPRB,2.2132E-04_JPRB,3.6483E-04_JPRB/)  
KAO( :, 1, 5) = (/&
 & 3.3532E-05_JPRB,4.1940E-05_JPRB,5.7696E-05_JPRB,6.0186E-05_JPRB,6.3029E-05_JPRB/)  
KAO( :, 2, 5) = (/&
 & 2.3830E-05_JPRB,3.5587E-05_JPRB,4.6056E-05_JPRB,4.1505E-05_JPRB,5.7960E-05_JPRB/)  
KAO( :, 3, 5) = (/&
 & 2.1812E-05_JPRB,2.5706E-05_JPRB,2.8233E-05_JPRB,3.5229E-05_JPRB,5.8555E-05_JPRB/)  
KAO( :, 4, 5) = (/&
 & 1.7315E-05_JPRB,1.9695E-05_JPRB,2.2530E-05_JPRB,3.8597E-05_JPRB,5.8973E-05_JPRB/)  
KAO( :, 5, 5) = (/&
 & 1.1890E-05_JPRB,1.3867E-05_JPRB,2.3935E-05_JPRB,3.9940E-05_JPRB,5.8993E-05_JPRB/)  
KAO( :, 6, 5) = (/&
 & 1.0677E-05_JPRB,1.4192E-05_JPRB,2.4839E-05_JPRB,4.0149E-05_JPRB,5.9735E-05_JPRB/)  
KAO( :, 7, 5) = (/&
 & 9.2784E-06_JPRB,1.5528E-05_JPRB,2.6050E-05_JPRB,4.1864E-05_JPRB,6.4186E-05_JPRB/)  
KAO( :, 8, 5) = (/&
 & 1.1359E-05_JPRB,1.8672E-05_JPRB,3.1354E-05_JPRB,5.1149E-05_JPRB,8.0918E-05_JPRB/)  
KAO( :, 9, 5) = (/&
 & 2.6841E-05_JPRB,4.0944E-05_JPRB,6.8221E-05_JPRB,1.1515E-04_JPRB,1.8821E-04_JPRB/)  
KAO( :,10, 5) = (/&
 & 8.7415E-05_JPRB,1.2053E-04_JPRB,1.9441E-04_JPRB,3.3166E-04_JPRB,5.5740E-04_JPRB/)  
KAO( :,11, 5) = (/&
 & 1.2386E-04_JPRB,1.7143E-04_JPRB,2.7887E-04_JPRB,4.7716E-04_JPRB,8.0477E-04_JPRB/)  
KAO( :,12, 5) = (/&
 & 1.3204E-04_JPRB,1.8364E-04_JPRB,3.0111E-04_JPRB,5.1685E-04_JPRB,8.7520E-04_JPRB/)  
KAO( :,13, 5) = (/&
 & 1.1358E-04_JPRB,1.5915E-04_JPRB,2.6323E-04_JPRB,4.5343E-04_JPRB,7.7073E-04_JPRB/)  
KAO( :, 1, 6) = (/&
 & 5.6626E-05_JPRB,6.2952E-05_JPRB,5.6997E-05_JPRB,7.8387E-05_JPRB,1.4023E-04_JPRB/)  
KAO( :, 2, 6) = (/&
 & 4.2639E-05_JPRB,4.0472E-05_JPRB,5.1521E-05_JPRB,7.2367E-05_JPRB,1.2444E-04_JPRB/)  
KAO( :, 3, 6) = (/&
 & 3.3191E-05_JPRB,2.9821E-05_JPRB,4.1035E-05_JPRB,7.5835E-05_JPRB,1.1292E-04_JPRB/)  
KAO( :, 4, 6) = (/&
 & 1.7563E-05_JPRB,2.2621E-05_JPRB,4.3898E-05_JPRB,7.3541E-05_JPRB,1.0514E-04_JPRB/)  
KAO( :, 5, 6) = (/&
 & 1.4086E-05_JPRB,2.3545E-05_JPRB,4.5696E-05_JPRB,7.1090E-05_JPRB,1.0366E-04_JPRB/)  
KAO( :, 6, 6) = (/&
 & 1.2590E-05_JPRB,2.4048E-05_JPRB,4.4731E-05_JPRB,6.9646E-05_JPRB,1.0367E-04_JPRB/)  
KAO( :, 7, 6) = (/&
 & 1.3429E-05_JPRB,2.6924E-05_JPRB,4.6412E-05_JPRB,7.4051E-05_JPRB,1.1343E-04_JPRB/)  
KAO( :, 8, 6) = (/&
 & 1.8185E-05_JPRB,3.3168E-05_JPRB,5.7618E-05_JPRB,9.5901E-05_JPRB,1.5240E-04_JPRB/)  
KAO( :, 9, 6) = (/&
 & 4.0915E-05_JPRB,7.1523E-05_JPRB,1.2899E-04_JPRB,2.2341E-04_JPRB,3.6849E-04_JPRB/)  
KAO( :,10, 6) = (/&
 & 1.2433E-04_JPRB,2.0393E-04_JPRB,3.7307E-04_JPRB,6.6855E-04_JPRB,1.1425E-03_JPRB/)  
KAO( :,11, 6) = (/&
 & 1.8043E-04_JPRB,3.0126E-04_JPRB,5.5504E-04_JPRB,9.9966E-04_JPRB,1.7159E-03_JPRB/)  
KAO( :,12, 6) = (/&
 & 1.9679E-04_JPRB,3.3338E-04_JPRB,6.1765E-04_JPRB,1.1153E-03_JPRB,1.9175E-03_JPRB/)  
KAO( :,13, 6) = (/&
 & 1.7363E-04_JPRB,2.9831E-04_JPRB,5.5435E-04_JPRB,1.0025E-03_JPRB,1.7267E-03_JPRB/)  
KAO( :, 1, 7) = (/&
 & 5.4728E-05_JPRB,6.3216E-05_JPRB,9.7227E-05_JPRB,1.9830E-04_JPRB,3.0115E-04_JPRB/)  
KAO( :, 2, 7) = (/&
 & 3.7424E-05_JPRB,4.6891E-05_JPRB,9.3922E-05_JPRB,1.8575E-04_JPRB,2.6393E-04_JPRB/)  
KAO( :, 3, 7) = (/&
 & 3.2885E-05_JPRB,5.4240E-05_JPRB,1.1210E-04_JPRB,1.7073E-04_JPRB,2.3633E-04_JPRB/)  
KAO( :, 4, 7) = (/&
 & 2.6560E-05_JPRB,6.2341E-05_JPRB,1.0718E-04_JPRB,1.5691E-04_JPRB,2.1887E-04_JPRB/)  
KAO( :, 5, 7) = (/&
 & 2.8005E-05_JPRB,6.1158E-05_JPRB,9.7995E-05_JPRB,1.4461E-04_JPRB,2.0623E-04_JPRB/)  
KAO( :, 6, 7) = (/&
 & 2.6304E-05_JPRB,5.4858E-05_JPRB,8.8237E-05_JPRB,1.3524E-04_JPRB,2.0068E-04_JPRB/)  
KAO( :, 7, 7) = (/&
 & 2.8057E-05_JPRB,5.2849E-05_JPRB,8.8492E-05_JPRB,1.4199E-04_JPRB,2.1851E-04_JPRB/)  
KAO( :, 8, 7) = (/&
 & 3.4390E-05_JPRB,6.3412E-05_JPRB,1.1163E-04_JPRB,1.8592E-04_JPRB,2.9376E-04_JPRB/)  
KAO( :, 9, 7) = (/&
 & 7.2790E-05_JPRB,1.4039E-04_JPRB,2.5926E-04_JPRB,4.5257E-04_JPRB,7.4795E-04_JPRB/)  
KAO( :,10, 7) = (/&
 & 2.1021E-04_JPRB,4.1798E-04_JPRB,8.0790E-04_JPRB,1.4658E-03_JPRB,2.5048E-03_JPRB/)  
KAO( :,11, 7) = (/&
 & 3.2720E-04_JPRB,6.6181E-04_JPRB,1.2928E-03_JPRB,2.3683E-03_JPRB,4.0754E-03_JPRB/)  
KAO( :,12, 7) = (/&
 & 3.7693E-04_JPRB,7.7171E-04_JPRB,1.5176E-03_JPRB,2.7982E-03_JPRB,4.8311E-03_JPRB/)  
KAO( :,13, 7) = (/&
 & 3.5194E-04_JPRB,7.2710E-04_JPRB,1.4369E-03_JPRB,2.6518E-03_JPRB,4.5779E-03_JPRB/)  
KAO( :, 1, 8) = (/&
 & 8.8622E-05_JPRB,2.2200E-04_JPRB,4.1760E-04_JPRB,5.9916E-04_JPRB,8.1306E-04_JPRB/)  
KAO( :, 2, 8) = (/&
 & 7.7484E-05_JPRB,1.9083E-04_JPRB,3.2988E-04_JPRB,4.7824E-04_JPRB,6.5145E-04_JPRB/)  
KAO( :, 3, 8) = (/&
 & 6.8249E-05_JPRB,1.8888E-04_JPRB,2.9496E-04_JPRB,4.2064E-04_JPRB,5.7727E-04_JPRB/)  
KAO( :, 4, 8) = (/&
 & 1.0307E-04_JPRB,1.8157E-04_JPRB,2.7450E-04_JPRB,3.9411E-04_JPRB,5.4734E-04_JPRB/)  
KAO( :, 5, 8) = (/&
 & 1.0013E-04_JPRB,1.6578E-04_JPRB,2.5412E-04_JPRB,3.7165E-04_JPRB,5.2629E-04_JPRB/)  
KAO( :, 6, 8) = (/&
 & 8.7661E-05_JPRB,1.4688E-04_JPRB,2.3121E-04_JPRB,3.4816E-04_JPRB,5.0439E-04_JPRB/)  
KAO( :, 7, 8) = (/&
 & 7.9171E-05_JPRB,1.3672E-04_JPRB,2.2306E-04_JPRB,3.4738E-04_JPRB,5.2076E-04_JPRB/)  
KAO( :, 8, 8) = (/&
 & 8.3889E-05_JPRB,1.5157E-04_JPRB,2.5895E-04_JPRB,4.2268E-04_JPRB,6.6361E-04_JPRB/)  
KAO( :, 9, 8) = (/&
 & 1.6488E-04_JPRB,3.1976E-04_JPRB,5.8317E-04_JPRB,1.0082E-03_JPRB,1.6627E-03_JPRB/)  
KAO( :,10, 8) = (/&
 & 4.7725E-04_JPRB,9.7517E-04_JPRB,1.8746E-03_JPRB,3.3981E-03_JPRB,5.7914E-03_JPRB/)  
KAO( :,11, 8) = (/&
 & 7.9688E-04_JPRB,1.6560E-03_JPRB,3.2130E-03_JPRB,5.8470E-03_JPRB,9.9511E-03_JPRB/)  
KAO( :,12, 8) = (/&
 & 9.7776E-04_JPRB,2.0671E-03_JPRB,4.0593E-03_JPRB,7.3885E-03_JPRB,1.2564E-02_JPRB/)  
KAO( :,13, 8) = (/&
 & 9.8124E-04_JPRB,2.1024E-03_JPRB,4.1582E-03_JPRB,7.5870E-03_JPRB,1.2921E-02_JPRB/)  
KAO( :, 1, 9) = (/&
 & 7.4912E-04_JPRB,1.1099E-03_JPRB,1.5644E-03_JPRB,2.1464E-03_JPRB,2.8897E-03_JPRB/)  
KAO( :, 2, 9) = (/&
 & 6.2597E-04_JPRB,9.2912E-04_JPRB,1.3142E-03_JPRB,1.8181E-03_JPRB,2.4773E-03_JPRB/)  
KAO( :, 3, 9) = (/&
 & 4.7892E-04_JPRB,7.1171E-04_JPRB,1.0243E-03_JPRB,1.4397E-03_JPRB,1.9820E-03_JPRB/)  
KAO( :, 4, 9) = (/&
 & 3.8453E-04_JPRB,5.9140E-04_JPRB,8.7342E-04_JPRB,1.2581E-03_JPRB,1.7584E-03_JPRB/)  
KAO( :, 5, 9) = (/&
 & 3.6098E-04_JPRB,5.7696E-04_JPRB,8.8197E-04_JPRB,1.2954E-03_JPRB,1.8431E-03_JPRB/)  
KAO( :, 6, 9) = (/&
 & 3.4542E-04_JPRB,5.7060E-04_JPRB,8.9328E-04_JPRB,1.3402E-03_JPRB,1.9357E-03_JPRB/)  
KAO( :, 7, 9) = (/&
 & 3.3888E-04_JPRB,5.8373E-04_JPRB,9.4422E-04_JPRB,1.4513E-03_JPRB,2.1408E-03_JPRB/)  
KAO( :, 8, 9) = (/&
 & 3.7707E-04_JPRB,6.8408E-04_JPRB,1.1538E-03_JPRB,1.8357E-03_JPRB,2.7831E-03_JPRB/)  
KAO( :, 9, 9) = (/&
 & 7.0739E-04_JPRB,1.3735E-03_JPRB,2.4588E-03_JPRB,4.1112E-03_JPRB,6.4788E-03_JPRB/)  
KAO( :,10, 9) = (/&
 & 1.8575E-03_JPRB,3.8603E-03_JPRB,7.2941E-03_JPRB,1.2720E-02_JPRB,2.0839E-02_JPRB/)  
KAO( :,11, 9) = (/&
 & 2.9958E-03_JPRB,6.2197E-03_JPRB,1.1775E-02_JPRB,2.0597E-02_JPRB,3.3906E-02_JPRB/)  
KAO( :,12, 9) = (/&
 & 3.6668E-03_JPRB,7.6016E-03_JPRB,1.4363E-02_JPRB,2.5216E-02_JPRB,4.1719E-02_JPRB/)  
KAO( :,13, 9) = (/&
 & 3.7360E-03_JPRB,7.7341E-03_JPRB,1.4600E-02_JPRB,2.5684E-02_JPRB,4.2617E-02_JPRB/)  
KAO( :, 1,10) = (/&
 & 2.2204E-03_JPRB,3.1215E-03_JPRB,4.1592E-03_JPRB,5.5251E-03_JPRB,7.2462E-03_JPRB/)  
KAO( :, 2,10) = (/&
 & 1.8794E-03_JPRB,2.6515E-03_JPRB,3.6524E-03_JPRB,4.9115E-03_JPRB,6.4747E-03_JPRB/)  
KAO( :, 3,10) = (/&
 & 1.4689E-03_JPRB,2.0942E-03_JPRB,2.9433E-03_JPRB,4.0441E-03_JPRB,5.4540E-03_JPRB/)  
KAO( :, 4,10) = (/&
 & 1.1490E-03_JPRB,1.6495E-03_JPRB,2.3294E-03_JPRB,3.2354E-03_JPRB,4.4282E-03_JPRB/)  
KAO( :, 5,10) = (/&
 & 8.6570E-04_JPRB,1.3179E-03_JPRB,1.9604E-03_JPRB,2.8379E-03_JPRB,4.0441E-03_JPRB/)  
KAO( :, 6,10) = (/&
 & 8.5652E-04_JPRB,1.4272E-03_JPRB,2.2416E-03_JPRB,3.3643E-03_JPRB,4.8824E-03_JPRB/)  
KAO( :, 7,10) = (/&
 & 9.3347E-04_JPRB,1.6326E-03_JPRB,2.6435E-03_JPRB,4.0816E-03_JPRB,6.0203E-03_JPRB/)  
KAO( :, 8,10) = (/&
 & 1.1389E-03_JPRB,2.0806E-03_JPRB,3.5187E-03_JPRB,5.6514E-03_JPRB,8.6161E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB6:PART2',0,ZHOOK_HANDLE)


KAO( :, 9,10) = (/&
 & 2.3318E-03_JPRB,4.5800E-03_JPRB,8.2437E-03_JPRB,1.3780E-02_JPRB,2.1744E-02_JPRB/)  
KAO( :,10,10) = (/&
 & 6.2326E-03_JPRB,1.3165E-02_JPRB,2.5232E-02_JPRB,4.4615E-02_JPRB,7.3492E-02_JPRB/)  
KAO( :,11,10) = (/&
 & 9.8704E-03_JPRB,2.0942E-02_JPRB,4.0187E-02_JPRB,7.0789E-02_JPRB,1.1609E-01_JPRB/)  
KAO( :,12,10) = (/&
 & 1.1999E-02_JPRB,2.5297E-02_JPRB,4.8337E-02_JPRB,8.4705E-02_JPRB,1.3826E-01_JPRB/)  
KAO( :,13,10) = (/&
 & 1.1789E-02_JPRB,2.4642E-02_JPRB,4.6747E-02_JPRB,8.1645E-02_JPRB,1.3284E-01_JPRB/)  
KAO( :, 1,11) = (/&
 & 3.1261E-03_JPRB,4.2813E-03_JPRB,5.7811E-03_JPRB,7.6623E-03_JPRB,1.0021E-02_JPRB/)  
KAO( :, 2,11) = (/&
 & 2.7730E-03_JPRB,3.9256E-03_JPRB,5.2937E-03_JPRB,7.0385E-03_JPRB,9.1561E-03_JPRB/)  
KAO( :, 3,11) = (/&
 & 2.2211E-03_JPRB,3.2332E-03_JPRB,4.4680E-03_JPRB,6.0516E-03_JPRB,7.9945E-03_JPRB/)  
KAO( :, 4,11) = (/&
 & 1.7260E-03_JPRB,2.5271E-03_JPRB,3.5974E-03_JPRB,5.0208E-03_JPRB,6.7957E-03_JPRB/)  
KAO( :, 5,11) = (/&
 & 1.3640E-03_JPRB,2.0174E-03_JPRB,2.8988E-03_JPRB,4.1037E-03_JPRB,5.6676E-03_JPRB/)  
KAO( :, 6,11) = (/&
 & 1.1158E-03_JPRB,1.8312E-03_JPRB,2.8771E-03_JPRB,4.3425E-03_JPRB,6.2982E-03_JPRB/)  
KAO( :, 7,11) = (/&
 & 1.2321E-03_JPRB,2.1507E-03_JPRB,3.5466E-03_JPRB,5.5748E-03_JPRB,8.3259E-03_JPRB/)  
KAO( :, 8,11) = (/&
 & 1.5691E-03_JPRB,2.9089E-03_JPRB,5.0376E-03_JPRB,8.1424E-03_JPRB,1.2407E-02_JPRB/)  
KAO( :, 9,11) = (/&
 & 3.5241E-03_JPRB,7.0356E-03_JPRB,1.2741E-02_JPRB,2.1461E-02_JPRB,3.3839E-02_JPRB/)  
KAO( :,10,11) = (/&
 & 1.0170E-02_JPRB,2.1914E-02_JPRB,4.2506E-02_JPRB,7.5273E-02_JPRB,1.2386E-01_JPRB/)  
KAO( :,11,11) = (/&
 & 1.6549E-02_JPRB,3.5671E-02_JPRB,6.9003E-02_JPRB,1.2202E-01_JPRB,2.0089E-01_JPRB/)  
KAO( :,12,11) = (/&
 & 2.0073E-02_JPRB,4.2914E-02_JPRB,8.2517E-02_JPRB,1.4566E-01_JPRB,2.3923E-01_JPRB/)  
KAO( :,13,11) = (/&
 & 1.9754E-02_JPRB,4.1795E-02_JPRB,8.0135E-02_JPRB,1.4074E-01_JPRB,2.2980E-01_JPRB/)  
KAO( :, 1,12) = (/&
 & 4.1564E-03_JPRB,5.9925E-03_JPRB,8.3120E-03_JPRB,1.1209E-02_JPRB,1.4597E-02_JPRB/)  
KAO( :, 2,12) = (/&
 & 3.9567E-03_JPRB,5.4909E-03_JPRB,7.6176E-03_JPRB,1.0371E-02_JPRB,1.3856E-02_JPRB/)  
KAO( :, 3,12) = (/&
 & 3.3974E-03_JPRB,4.7965E-03_JPRB,6.6252E-03_JPRB,8.9930E-03_JPRB,1.2050E-02_JPRB/)  
KAO( :, 4,12) = (/&
 & 2.7271E-03_JPRB,4.0009E-03_JPRB,5.6537E-03_JPRB,7.7402E-03_JPRB,1.0333E-02_JPRB/)  
KAO( :, 5,12) = (/&
 & 2.1241E-03_JPRB,3.2132E-03_JPRB,4.6676E-03_JPRB,6.6066E-03_JPRB,9.0309E-03_JPRB/)  
KAO( :, 6,12) = (/&
 & 1.6495E-03_JPRB,2.5482E-03_JPRB,3.8834E-03_JPRB,5.7278E-03_JPRB,8.1979E-03_JPRB/)  
KAO( :, 7,12) = (/&
 & 1.5776E-03_JPRB,2.7768E-03_JPRB,4.6314E-03_JPRB,7.2948E-03_JPRB,1.0930E-02_JPRB/)  
KAO( :, 8,12) = (/&
 & 2.1394E-03_JPRB,4.0088E-03_JPRB,6.9630E-03_JPRB,1.1391E-02_JPRB,1.7592E-02_JPRB/)  
KAO( :, 9,12) = (/&
 & 5.1508E-03_JPRB,1.0419E-02_JPRB,1.9252E-02_JPRB,3.2952E-02_JPRB,5.2981E-02_JPRB/)  
KAO( :,10,12) = (/&
 & 1.6525E-02_JPRB,3.6418E-02_JPRB,7.1731E-02_JPRB,1.2850E-01_JPRB,2.1301E-01_JPRB/)  
KAO( :,11,12) = (/&
 & 2.8843E-02_JPRB,6.3252E-02_JPRB,1.2384E-01_JPRB,2.2076E-01_JPRB,3.6471E-01_JPRB/)  
KAO( :,12,12) = (/&
 & 3.6629E-02_JPRB,7.9908E-02_JPRB,1.5563E-01_JPRB,2.7617E-01_JPRB,4.5458E-01_JPRB/)  
KAO( :,13,12) = (/&
 & 3.6750E-02_JPRB,7.9425E-02_JPRB,1.5346E-01_JPRB,2.7137E-01_JPRB,4.4636E-01_JPRB/)  
KAO( :, 1,13) = (/&
 & 6.2842E-03_JPRB,8.5901E-03_JPRB,1.1770E-02_JPRB,1.5848E-02_JPRB,2.1231E-02_JPRB/)  
KAO( :, 2,13) = (/&
 & 5.8832E-03_JPRB,8.3961E-03_JPRB,1.1688E-02_JPRB,1.5821E-02_JPRB,2.1081E-02_JPRB/)  
KAO( :, 3,13) = (/&
 & 5.0693E-03_JPRB,7.3487E-03_JPRB,1.0502E-02_JPRB,1.4654E-02_JPRB,1.9671E-02_JPRB/)  
KAO( :, 4,13) = (/&
 & 4.3064E-03_JPRB,6.2164E-03_JPRB,8.9638E-03_JPRB,1.2692E-02_JPRB,1.7434E-02_JPRB/)  
KAO( :, 5,13) = (/&
 & 3.5860E-03_JPRB,5.3245E-03_JPRB,7.6791E-03_JPRB,1.0860E-02_JPRB,1.5079E-02_JPRB/)  
KAO( :, 6,13) = (/&
 & 2.8314E-03_JPRB,4.3212E-03_JPRB,6.4657E-03_JPRB,9.2062E-03_JPRB,1.2862E-02_JPRB/)  
KAO( :, 7,13) = (/&
 & 2.2377E-03_JPRB,3.6343E-03_JPRB,5.9331E-03_JPRB,9.1864E-03_JPRB,1.3701E-02_JPRB/)  
KAO( :, 8,13) = (/&
 & 2.8263E-03_JPRB,5.3372E-03_JPRB,9.3113E-03_JPRB,1.5184E-02_JPRB,2.3750E-02_JPRB/)  
KAO( :, 9,13) = (/&
 & 7.1632E-03_JPRB,1.4853E-02_JPRB,2.8075E-02_JPRB,4.9370E-02_JPRB,8.0768E-02_JPRB/)  
KAO( :,10,13) = (/&
 & 2.5324E-02_JPRB,5.6755E-02_JPRB,1.1356E-01_JPRB,2.0699E-01_JPRB,3.4818E-01_JPRB/)  
KAO( :,11,13) = (/&
 & 4.7551E-02_JPRB,1.0638E-01_JPRB,2.1201E-01_JPRB,3.8439E-01_JPRB,6.4430E-01_JPRB/)  
KAO( :,12,13) = (/&
 & 6.5536E-02_JPRB,1.4596E-01_JPRB,2.8971E-01_JPRB,5.2186E-01_JPRB,8.7097E-01_JPRB/)  
KAO( :,13,13) = (/&
 & 7.1040E-02_JPRB,1.5739E-01_JPRB,3.0996E-01_JPRB,5.5635E-01_JPRB,9.2532E-01_JPRB/)  
KAO( :, 1,14) = (/&
 & 8.9073E-03_JPRB,1.2577E-02_JPRB,1.7104E-02_JPRB,2.3298E-02_JPRB,3.0760E-02_JPRB/)  
KAO( :, 2,14) = (/&
 & 9.1449E-03_JPRB,1.2712E-02_JPRB,1.7315E-02_JPRB,2.3477E-02_JPRB,3.1268E-02_JPRB/)  
KAO( :, 3,14) = (/&
 & 8.6458E-03_JPRB,1.1907E-02_JPRB,1.6470E-02_JPRB,2.2100E-02_JPRB,2.9699E-02_JPRB/)  
KAO( :, 4,14) = (/&
 & 7.6642E-03_JPRB,1.0832E-02_JPRB,1.5035E-02_JPRB,2.0201E-02_JPRB,2.7549E-02_JPRB/)  
KAO( :, 5,14) = (/&
 & 6.6532E-03_JPRB,9.4973E-03_JPRB,1.3436E-02_JPRB,1.8486E-02_JPRB,2.5410E-02_JPRB/)  
KAO( :, 6,14) = (/&
 & 5.6659E-03_JPRB,8.2188E-03_JPRB,1.1655E-02_JPRB,1.6380E-02_JPRB,2.2833E-02_JPRB/)  
KAO( :, 7,14) = (/&
 & 4.7388E-03_JPRB,7.0553E-03_JPRB,1.0065E-02_JPRB,1.4371E-02_JPRB,2.0476E-02_JPRB/)  
KAO( :, 8,14) = (/&
 & 4.0074E-03_JPRB,6.9317E-03_JPRB,1.1650E-02_JPRB,1.9270E-02_JPRB,3.0109E-02_JPRB/)  
KAO( :, 9,14) = (/&
 & 9.4290E-03_JPRB,1.9762E-02_JPRB,3.7876E-02_JPRB,6.6863E-02_JPRB,1.1024E-01_JPRB/)  
KAO( :,10,14) = (/&
 & 3.5639E-02_JPRB,8.0302E-02_JPRB,1.6119E-01_JPRB,2.9567E-01_JPRB,5.0285E-01_JPRB/)  
KAO( :,11,14) = (/&
 & 7.0994E-02_JPRB,1.5991E-01_JPRB,3.2149E-01_JPRB,5.8889E-01_JPRB,1.0009E+00_JPRB/)  
KAO( :,12,14) = (/&
 & 1.0472E-01_JPRB,2.3582E-01_JPRB,4.7386E-01_JPRB,8.6654E-01_JPRB,1.4714E+00_JPRB/)  
KAO( :,13,14) = (/&
 & 1.2287E-01_JPRB,2.7626E-01_JPRB,5.5413E-01_JPRB,1.0143E+00_JPRB,1.7166E+00_JPRB/)  
KAO( :, 1,15) = (/&
 & 1.0915E-02_JPRB,1.5406E-02_JPRB,2.1787E-02_JPRB,3.0490E-02_JPRB,4.2541E-02_JPRB/)  
KAO( :, 2,15) = (/&
 & 1.1315E-02_JPRB,1.6166E-02_JPRB,2.2798E-02_JPRB,3.1923E-02_JPRB,4.3992E-02_JPRB/)  
KAO( :, 3,15) = (/&
 & 1.0941E-02_JPRB,1.5701E-02_JPRB,2.1967E-02_JPRB,3.0980E-02_JPRB,4.2137E-02_JPRB/)  
KAO( :, 4,15) = (/&
 & 1.0488E-02_JPRB,1.4945E-02_JPRB,2.1284E-02_JPRB,2.9684E-02_JPRB,4.1028E-02_JPRB/)  
KAO( :, 5,15) = (/&
 & 9.8738E-03_JPRB,1.4407E-02_JPRB,2.0449E-02_JPRB,2.8357E-02_JPRB,3.9999E-02_JPRB/)  
KAO( :, 6,15) = (/&
 & 8.9244E-03_JPRB,1.3460E-02_JPRB,1.9534E-02_JPRB,2.7000E-02_JPRB,3.8027E-02_JPRB/)  
KAO( :, 7,15) = (/&
 & 8.0056E-03_JPRB,1.2241E-02_JPRB,1.8433E-02_JPRB,2.6084E-02_JPRB,3.5910E-02_JPRB/)  
KAO( :, 8,15) = (/&
 & 7.2557E-03_JPRB,1.0997E-02_JPRB,1.6847E-02_JPRB,2.4941E-02_JPRB,3.5979E-02_JPRB/)  
KAO( :, 9,15) = (/&
 & 1.1206E-02_JPRB,2.3492E-02_JPRB,4.5074E-02_JPRB,7.9749E-02_JPRB,1.3179E-01_JPRB/)  
KAO( :,10,15) = (/&
 & 4.3714E-02_JPRB,9.8800E-02_JPRB,1.9893E-01_JPRB,3.6488E-01_JPRB,6.2367E-01_JPRB/)  
KAO( :,11,15) = (/&
 & 9.0564E-02_JPRB,2.0463E-01_JPRB,4.1227E-01_JPRB,7.5790E-01_JPRB,1.2930E+00_JPRB/)  
KAO( :,12,15) = (/&
 & 1.4027E-01_JPRB,3.1640E-01_JPRB,6.3737E-01_JPRB,1.1714E+00_JPRB,1.9962E+00_JPRB/)  
KAO( :,13,15) = (/&
 & 1.7360E-01_JPRB,3.9198E-01_JPRB,7.8920E-01_JPRB,1.4509E+00_JPRB,2.4685E+00_JPRB/)  
KAO( :, 1,16) = (/&
 & 1.1824E-02_JPRB,1.7312E-02_JPRB,2.6044E-02_JPRB,4.2271E-02_JPRB,6.3915E-02_JPRB/)  
KAO( :, 2,16) = (/&
 & 1.2333E-02_JPRB,1.8642E-02_JPRB,2.7212E-02_JPRB,4.2155E-02_JPRB,7.0740E-02_JPRB/)  
KAO( :, 3,16) = (/&
 & 1.1914E-02_JPRB,1.8039E-02_JPRB,2.6483E-02_JPRB,3.8087E-02_JPRB,6.0410E-02_JPRB/)  
KAO( :, 4,16) = (/&
 & 1.1617E-02_JPRB,1.6736E-02_JPRB,2.5551E-02_JPRB,3.7243E-02_JPRB,5.5742E-02_JPRB/)  
KAO( :, 5,16) = (/&
 & 1.2207E-02_JPRB,1.6058E-02_JPRB,2.3899E-02_JPRB,3.5249E-02_JPRB,5.2521E-02_JPRB/)  
KAO( :, 6,16) = (/&
 & 1.2552E-02_JPRB,1.6221E-02_JPRB,2.2453E-02_JPRB,3.3451E-02_JPRB,4.8959E-02_JPRB/)  
KAO( :, 7,16) = (/&
 & 1.2682E-02_JPRB,1.6583E-02_JPRB,2.1720E-02_JPRB,3.1647E-02_JPRB,4.6528E-02_JPRB/)  
KAO( :, 8,16) = (/&
 & 1.2800E-02_JPRB,1.6916E-02_JPRB,2.2044E-02_JPRB,3.0239E-02_JPRB,4.5143E-02_JPRB/)  
KAO( :, 9,16) = (/&
 & 1.2606E-02_JPRB,2.5371E-02_JPRB,4.8585E-02_JPRB,8.6042E-02_JPRB,1.4214E-01_JPRB/)  
KAO( :,10,16) = (/&
 & 4.7940E-02_JPRB,1.0811E-01_JPRB,2.1696E-01_JPRB,3.9856E-01_JPRB,6.7922E-01_JPRB/)  
KAO( :,11,16) = (/&
 & 1.0038E-01_JPRB,2.2692E-01_JPRB,4.5634E-01_JPRB,8.3917E-01_JPRB,1.4277E+00_JPRB/)  
KAO( :,12,16) = (/&
 & 1.5780E-01_JPRB,3.5540E-01_JPRB,7.1875E-01_JPRB,1.3169E+00_JPRB,2.2414E+00_JPRB/)  
KAO( :,13,16) = (/&
 & 1.9907E-01_JPRB,4.4847E-01_JPRB,9.0510E-01_JPRB,1.6605E+00_JPRB,2.8238E+00_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 7.71391E-02_JPRB, 6.43175E-02_JPRB, 5.36271E-02_JPRB, 4.47136E-02_JPRB, 3.72816E-02_JPRB,&
 & 3.10849E-02_JPRB, 2.59182E-02_JPRB, 2.16102E-02_JPRB, 1.80183E-02_JPRB, 1.50234E-02_JPRB/)  
SELFREFO( :, 2) = (/&
 & 8.39275E-02_JPRB, 7.04019E-02_JPRB, 5.90561E-02_JPRB, 4.95388E-02_JPRB, 4.15552E-02_JPRB,&
 & 3.48583E-02_JPRB, 2.92406E-02_JPRB, 2.45283E-02_JPRB, 2.05754E-02_JPRB, 1.72595E-02_JPRB/)  
SELFREFO( :, 3) = (/&
 & 8.77747E-02_JPRB, 7.41411E-02_JPRB, 6.26251E-02_JPRB, 5.28978E-02_JPRB, 4.46814E-02_JPRB,&
 & 3.77413E-02_JPRB, 3.18791E-02_JPRB, 2.69275E-02_JPRB, 2.27449E-02_JPRB, 1.92121E-02_JPRB/)  
SELFREFO( :, 4) = (/&
 & 9.35855E-02_JPRB, 7.94116E-02_JPRB, 6.73843E-02_JPRB, 5.71787E-02_JPRB, 4.85187E-02_JPRB,&
 & 4.11704E-02_JPRB, 3.49349E-02_JPRB, 2.96439E-02_JPRB, 2.51542E-02_JPRB, 2.13445E-02_JPRB/)  
SELFREFO( :, 5) = (/&
 & 9.31058E-02_JPRB, 7.97629E-02_JPRB, 6.83321E-02_JPRB, 5.85395E-02_JPRB, 5.01503E-02_JPRB,&
 & 4.29633E-02_JPRB, 3.68062E-02_JPRB, 3.15316E-02_JPRB, 2.70128E-02_JPRB, 2.31416E-02_JPRB/)  
SELFREFO( :, 6) = (/&
 & 7.92454E-02_JPRB, 7.03070E-02_JPRB, 6.23769E-02_JPRB, 5.53412E-02_JPRB, 4.90991E-02_JPRB,&
 & 4.35611E-02_JPRB, 3.86477E-02_JPRB, 3.42885E-02_JPRB, 3.04210E-02_JPRB, 2.69898E-02_JPRB/)  
SELFREFO( :, 7) = (/&
 & 7.29322E-02_JPRB, 6.57740E-02_JPRB, 5.93183E-02_JPRB, 5.34963E-02_JPRB, 4.82457E-02_JPRB,&
 & 4.35104E-02_JPRB, 3.92399E-02_JPRB, 3.53886E-02_JPRB, 3.19152E-02_JPRB, 2.87828E-02_JPRB/)  
SELFREFO( :, 8) = (/&
 & 7.53680E-02_JPRB, 6.63817E-02_JPRB, 5.84669E-02_JPRB, 5.14958E-02_JPRB, 4.53558E-02_JPRB,&
 & 3.99480E-02_JPRB, 3.51849E-02_JPRB, 3.09897E-02_JPRB, 2.72948E-02_JPRB, 2.40404E-02_JPRB/)  
SELFREFO( :, 9) = (/&
 & 7.17087E-02_JPRB, 6.34545E-02_JPRB, 5.61505E-02_JPRB, 4.96871E-02_JPRB, 4.39678E-02_JPRB,&
 & 3.89068E-02_JPRB, 3.44283E-02_JPRB, 3.04654E-02_JPRB, 2.69586E-02_JPRB, 2.38554E-02_JPRB/)  
SELFREFO( :,10) = (/&
 & 7.20376E-02_JPRB, 6.42071E-02_JPRB, 5.72277E-02_JPRB, 5.10070E-02_JPRB, 4.54625E-02_JPRB,&
 & 4.05207E-02_JPRB, 3.61161E-02_JPRB, 3.21903E-02_JPRB, 2.86912E-02_JPRB, 2.55724E-02_JPRB/)  
SELFREFO( :,11) = (/&
 & 8.56200E-02_JPRB, 7.44248E-02_JPRB, 6.46934E-02_JPRB, 5.62344E-02_JPRB, 4.88815E-02_JPRB,&
 & 4.24900E-02_JPRB, 3.69342E-02_JPRB, 3.21049E-02_JPRB, 2.79070E-02_JPRB, 2.42581E-02_JPRB/)  
SELFREFO( :,12) = (/&
 & 9.30364E-02_JPRB, 8.00633E-02_JPRB, 6.88992E-02_JPRB, 5.92918E-02_JPRB, 5.10240E-02_JPRB,&
 & 4.39092E-02_JPRB, 3.77864E-02_JPRB, 3.25174E-02_JPRB, 2.79832E-02_JPRB, 2.40811E-02_JPRB/)  
SELFREFO( :,13) = (/&
 & 9.58838E-02_JPRB, 8.17150E-02_JPRB, 6.96399E-02_JPRB, 5.93492E-02_JPRB, 5.05792E-02_JPRB,&
 & 4.31051E-02_JPRB, 3.67354E-02_JPRB, 3.13070E-02_JPRB, 2.66808E-02_JPRB, 2.27381E-02_JPRB/)  
SELFREFO( :,14) = (/&
 & 8.92791E-02_JPRB, 7.69435E-02_JPRB, 6.63123E-02_JPRB, 5.71500E-02_JPRB, 4.92536E-02_JPRB,&
 & 4.24483E-02_JPRB, 3.65833E-02_JPRB, 3.15286E-02_JPRB, 2.71723E-02_JPRB, 2.34179E-02_JPRB/)  
SELFREFO( :,15) = (/&
 & 9.09947E-02_JPRB, 7.81455E-02_JPRB, 6.71107E-02_JPRB, 5.76340E-02_JPRB, 4.94956E-02_JPRB,&
 & 4.25064E-02_JPRB, 3.65041E-02_JPRB, 3.13494E-02_JPRB, 2.69226E-02_JPRB, 2.31209E-02_JPRB/)  
SELFREFO( :,16) = (/&
 & 7.99990E-02_JPRB, 7.02289E-02_JPRB, 6.16519E-02_JPRB, 5.41224E-02_JPRB, 4.75125E-02_JPRB,&
 & 4.17099E-02_JPRB, 3.66159E-02_JPRB, 3.21440E-02_JPRB, 2.82183E-02_JPRB, 2.47720E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB6:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


END SUBROUTINE RRTM_KGB6
