! This module replaces grid/fxy_new.h

MODULE fxy_new_mod_h
  USE comconst_mod, ONLY: pi
  USE serre_mod, ONLY: pxo, pyo, alphax, alphay, transx, transy
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  USE paramet_mod_h
  IMPLICIT NONE; PRIVATE
  PUBLIC fx, fxprim, fy, fyprim


CONTAINS
  REAL FUNCTION ripx(ri)
    REAL, INTENT(IN) :: ri
    ripx = (ri - 1.0) * 2. * pi / REAL(iim)
  END FUNCTION ripx

  REAL FUNCTION fx(ri)
    REAL, INTENT(IN) :: ri
    fx = ripx(ri) + transx + alphax * SIN(ripx(ri) + transx - pxo) - pi
  END FUNCTION fx

  REAL FUNCTION fxprim(ri)
    REAL, INTENT(IN) :: ri
    fxprim = 2. * pi / REAL(iim) * (1. + alphax * COS(ripx(ri) + transx - pxo))
  END FUNCTION fxprim

  REAL FUNCTION bigy(rj)
    REAL, INTENT(IN) :: rj
    bigy = 2. * (REAL(jjp1) - rj) * pi / jjm
  END FUNCTION bigy

  REAL FUNCTION fy(rj)
    REAL, INTENT(IN) :: rj
    fy = (bigy(rj) + transy + alphay * SIN(bigy(rj) + transy - pyo)) / 2. - pi / 2.
  END FUNCTION fy

  REAL FUNCTION fyprim(rj)
    REAL, INTENT(IN) :: rj
    fyprim = (pi / jjm) * (1. + alphay * COS(bigy(rj) + transy - pyo))
  END FUNCTION fyprim
END MODULE fxy_new_mod_h