!$gpum horizontal klon ngrid
module lmdz_call_blosno

contains

   subroutine call_blosno(ngrid, nlay, abortphy, flag_inhib_tend, itap, dtime, ustar, temp, q, qb, pplay, paprs, &
                                dtemp_bs, dq_bs, dqb_bs, bsfl, precip_bs)

!==================================================================================================
! call_blosno in the main interface between the LMDZ physics monitor physiq_mod
! and the blowing snow parameterizations
!
! contact: Etienne Vignon etienne.vignon@lmd.ipsl.fr
!================================================================================================

      use lmdz_blosno_sublimsedim, only: blosno_sublimsedim
      USE add_phys_tend_mod, ONLY: add_phys_tend, prt_enerbil

      implicit none
!======================================================
! Declarations
!======================================================

!INPUT
!=====

      INTEGER, INTENT(IN)                     :: abortphy, flag_inhib_tend, itap ! flag and physics time counter for add_phys_tend
      integer, intent(in)                     :: ngrid ! number of horizontal grid points
      integer, intent(in)                     :: nlay  ! number of vertical layers
      real, intent(in)                        :: dtime ! physics time step [s]
      real, intent(in), dimension(ngrid)      :: ustar ! surface friction velocity [m/s]
      real, intent(in), dimension(ngrid, nlay) :: temp  ! temperature of the air [K]
      real, intent(in), dimension(ngrid, nlay) :: q     ! specific content of water [kg/kg]
      real, intent(in), dimension(ngrid, nlay) :: qb    ! specific content of blowing snow [kg/kg]
      real, intent(in), dimension(ngrid, nlay) :: pplay ! pressure at the middle of layers [Pa]
      real, intent(in), dimension(ngrid, nlay + 1) :: paprs ! pressure at the layer bottom interface [Pa]

! OUTPUT
!========
      real, intent(out), dimension(ngrid, nlay) :: dtemp_bs ! temperature tendency [K/s]
      real, intent(out), dimension(ngrid, nlay) :: dq_bs    ! water vapor tendency [kg/kg/s]
      real, intent(out), dimension(ngrid, nlay) :: dqb_bs   ! blowing snow mass tendancy [kg/kg/s]
      real, intent(out), dimension(ngrid, nlay + 1) :: bsfl   ! vertical profile of blowing snow vertical flux [kg/m2/s]
      real, intent(out), dimension(ngrid)      :: precip_bs ! surface sedimentation flux of blowing snow [kg/s/m2]

! LOCAL
!========
      real, dimension(ngrid, nlay)              :: du0, dv0, dql0, dqi0

!=================================================================
! Call to main routine of blowing snow sublimation and sedim.
!=================================================================
      call blosno_sublimsedim(ngrid, nlay, dtime, ustar, temp, q, qb, pplay, paprs, &
                                     dtemp_bs, dq_bs, dqb_bs, bsfl, precip_bs)

!=================================================================
! Add tendencies
!=================================================================
      du0(:, :) = 0.
      dv0(:, :) = 0.
      dql0(:, :) = 0.
      dqi0(:, :) = 0.

      CALL add_phys_tend(du0, dv0, dtemp_bs, dq_bs, dql0, dqi0, dqb_bs, paprs, &
                         'bsss', abortphy, flag_inhib_tend, itap, 0)

   end subroutine call_blosno

end module lmdz_call_blosno
