# Altitude above the ground
z=[0.0,76.0,124.0,174.0,225.0,274.0,325.0,375.0,425.0,475.0,525.0,574.0,624.0,674.0,725.0,774.0,825.0,874.0,925.0,974.0,1025.0,1075.0,1125.0,1175.0,1225.0,1275.0,1324.0,1374.0,1424.0,1474.0,1524.0,1575.0,1625.0,1675.0,1725.0,1774.0,1825.0,1874.0,1924.0,1974.0,2025.0,2075.0,2124.0,2176.0,2225.0,2275.0,2325.0,2375.0,2426.0,2475.0,2524.0,2575.0,2624.0,2675.0,2725.0,2775.0,2824.0,2875.0,2923.0,2974.0,3024.0,3075.0,3125.0,3176.0,3225.0,3275.0,3324.0,3375.0,3424.0,3475.0,3525.0,3574.0,3625.0,3675.0,3723.0,3774.0,3824.0,3873.0,3924.0,3974.0,4025.0,4075.0,4125.0,4175.0,4218.0,4274.9,4325.6,4374.5,4425.7,4474.9,4525.6,4574.5,4625.0,4674.5,4724.8,4774.9,4823.4,4874.5,4925.3,4974.5]

# Zonal wind
U=[0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,-0.50,-1.00,-1.50,-2.00,-2.00,-2.00,-2.20,-2.50,-2.70,-3.00,-3.00,-3.00,-3.00,-2.70,-2.50,-2.20,-1.50,-1.00,-0.70,-0.50,-0.20,0.00,0.20,0.50,0.70,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.50,2.00,2.50,3.00,3.00,3.50,4.00,5.00,6.00,7.00,8.00,9.00,9.50,10.00,11.00,12.00,13.00,14.00,15.00,15.50,16.00,16.50,17.00,17.50,18.00,18.20,18.50,18.70,19.00,19.50,20.00,20.00,20.00,20.00,20.00,20.00,19.50,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00,19.00]

# Meridional wind
V=[0.00,-2.00,-1.50,-1.00,-0.50,-0.50,-1.00,-1.50,-2.00,-2.50,-3.00,-3.00,-3.00,-3.00,-3.50,-4.00,-4.00,-4.00,-4.00,-4.00,-4.00,-4.50,-5.00,-5.00,-5.00,-5.00,-4.50,-4.00,-4.00,-4.00,-3.50,-3.00,-3.00,-3.50,-4.00,-5.00,-5.80,-6.30,-7.00,-7.50,-8.00,-8.50,-9.00,-9.50,-10.00,-10.00,-10.00,-10.00,-10.20,-10.50,-10.70,-11.00,-11.50,-12.00,-11.50,-11.00,-10.50,-10.00,-10.00,-9.50,-9.00,-9.00,-8.50,-8.00,-8.00,-8.00,-8.00,-8.20,-8.50,-8.70,-9.00,-9.50,-10.00,-10.50,-11.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00,-12.00]

# Potential temperature
theta=[296.0,297.0,298.0,298.3,298.6,299.0,299.3,299.6,300.0,300.3,300.6,301.0,301.3,301.5,301.7,302.0,302.1,302.3,302.4,302.6,302.7,302.9,303.0,303.5,304.0,304.5,305.0,305.2,305.4,305.6,305.8,306.0,306.2,306.4,306.6,306.8,307.0,307.0,307.1,307.3,307.4,307.6,307.7,307.8,307.9,308.0,308.2,308.4,308.6,308.8,309.0,309.3,309.6,310.0,310.5,311.0,311.2,311.4,311.6,311.8,312.0,312.5,313.0,313.5,314.0,314.2,314.4,314.6,314.8,315.0,315.3,315.6,316.0,316.2,316.4,316.6,316.8,317.0,317.2,317.4,317.6,317.8,318.0,318.3,318.6,318.8,319.1,319.6,320.0,320.5,321.0,321.3,321.6,322.0,323.0,324.0,325.0,325.3,325.5,325.6]

# Water vapor mixing ratio
rv=[0.0112,0.0111,0.0110,0.0109,0.0108,0.0107,0.0105,0.0103,0.0100,0.0098,0.0096,0.0094,0.0091,0.0088,0.0085,0.0082,0.0079,0.0076,0.0073,0.0070,0.0067,0.0064,0.0061,0.0058,0.0055,0.0053,0.0051,0.0050,0.0050,0.0050,0.0049,0.0049,0.0049,0.0049,0.0049,0.0048,0.0048,0.0048,0.0048,0.0048,0.0048,0.0048,0.0048,0.0047,0.0047,0.0047,0.0047,0.0047,0.0047,0.0047,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0045,0.0045,0.0045,0.0045,0.0045,0.0045,0.0045,0.0045,0.0044,0.0043,0.0042,0.0041,0.0039,0.0037,0.0036,0.0035,0.0033,0.0031,0.0030,0.0030,0.0029,0.0028,0.0027,0.0025,0.0024,0.0023,0.0021,0.0017,0.0015,0.0015,0.0008,0.0002,0.0002,0.0002,0.0001,0.0001,0.0001,0.0001,0.0001]


nz = len(z)

f = open('init.txt','w')

header = '{0:>8} {1:>6} {2:>6} {3:>6} {4:6>}\n'.format('z','u','v','theta','rv')
f.write(header)

for ilev in range(0,nz):
    line = '{0:8.2f} {1:6.2f} {2:6.2f} {3:6.2f} {4:6.4f}\n'.format(z[ilev],U[ilev],V[ilev],theta[ilev],rv[ilev])
    f.write(line)

f.close()
