
import os
import sys

import numpy as np
from matplotlib import dates
import datetime
import netCDF4 as nc4
import xarray as xr
import pandas as pd
import matplotlib.pyplot as plt

file_radar='OBS_RADAR_MPACE.nc'

# read Radar data
ds=xr.open_dataset(file_radar)
ll=int(np.size(ds['time']))
ll2=int(ll/2)
vec=ds["time"][ll2::]+ds["time"][ll2-1]+ds["time"][1]
vec2=np.concatenate([ds["time"][0:ll2],vec])
ds["time"]=vec2
ds.time.attrs["units"] = "hours since 2004-10-09"
ds=xr.decode_cf(ds)
ds['zf']=ds['height']*1000.
ds.zf.attrs["units"]='m'
ds['lwp']=ds['LWP']/1000.
ds.lwp.attrs["units"]='kg/m2'
ds['iwp']=ds['IWP']/1000.
ds.iwp.attrs["units"]='kg/m2'
ds['iwc']=ds['IWC']/1000.
ds.iwc.attrs["units"]='kg/m3'
ds['tke_dissip']=ds['dissipation']
ds['cloudbase']=ds['CloudBase']*1000.
ds['cloudtop']=ds['CloudTop']*1000.
ds.rename({'height':'levf'})
ds=ds.sel(time=slice("2004-10-09 17:00:00","2004-10-10 05:00:00"))
#ds=ds.resample(time="1H").mean()
ds.to_netcdf('test.nc')

cmd1='ncks -O -v zf,lwp,iwp,iwc,tke_dissip,cloudbase,cloudtop test.nc OBS.nc'
cmd2='rm test.nc'
#cmd3='ncks -A -v MLB OBS_RADAR_MPACE.nc OBS.nc'
#cmd4='ncks -O -x -v MLB,time OBS.nc OBS.nc'
#cmd5='ncrename -v hour,time OBS.nc'
#cmd6='ncrename -d hour,time OBS.nc'

os.system(cmd1)
os.system(cmd2)
#os.system(cmd3)
#os.system(cmd4)
#os.system(cmd5)
#os.system(cmd6)




