#!/bin/bash

SIM=CTRL

if [ -d $SIM ] ; then
   \rm -rf $SIM
fi

cass=( 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 )

for icas in 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14; do


CAS=RH${cass[$icas]}
echo $CAS

mkdir -p $SIM/$CAS
\cp *def $SIM/$CAS/
\cp *data $SIM/$CAS/
\cp lscale* $SIM/$CAS/

cd $SIM/$CAS
ln -sf ../../INPUT-PROFILES/prof.inp.${cass[$icas]} prof.inp.001

../../lmdz1d.e >| listing
cd ../../

done
./extract.x $SIM
./tracer.x $SIM
