#!/bin/bash

for sim in LES* ; do

cas=`echo $sim | sed -e 's/LES//'`
Ug=`grep $cas ../description | awk ' { print $3 } '`
Vg=`grep $cas ../description | awk ' { print $4 } '`

cd $sim
#Transformation des t0.a en prof.inp.001
#
#
#Lecture dans le nouveau LMDZ1D.
#          read (ilesfile,*) height(k),thlprof(k),qtprof (k),
#     .                      uprof (k),vprof  (k),e12prof(k)
#          read (ilesfile,*) height(k),ugprof(k),vgprof(k),wfls(k),
#     .                      dqtdxls(k),dqtdyls(k),dqtdtls(k),thlpcar(k)
# 
#lecture dans ayotte.f, dan t0.a
#       read(99,*) ll,zlayd(l),u(l),v(l),teta(l)

nl=`wc -l t0.a | awk ' { print $1+1 }'`
echo $nl
echo $nl > prof.inp.001

temp0=`tail -1 t0.a | awk ' { print $5 } '`
echo $temp0
tac t0.a | awk ' BEGIN { ps=101325. ; p=ps ; zm=0. ; temp='$temp0' }\
{ theta=$5 ; z=$2 ; dz=z-zm ;\
p=p-p*dz*9.81/(287.06*temp) ;\
temp=theta*(p/100000.)^0.2857142 ;\
zm=z ; print z , temp , 0. , $3 , $4 , 0. , p }\
END { print z+10000. , temp , 0. , $3 , $4 , 0. , p / 3. } '  >> prof.inp.001

echo $nl > lscale.inp.001
tac t0.a | awk ' { z=$2 ; vg='$Vg'*z/2000. ; if ( vg > '$Vg' ) vg='$Vg' ; print z , '$Ug' , vg, 0. , 0. , 0. , 0. , 0. } END { print z+10000. , '$Ug' , vg, 0. , 0. , 0. , 0. , 0. } '  >> lscale.inp.001

cd ..
done
