MODULE YOMRDI15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     -----------------------------------------------------------------
!*    ** *YOMRDI15* - COEFFICIENTS WITHIN RADIATION INTERFACE
!*                          FROZEN VERSION (CYCLE 15) OF YOERDI
!     -----------------------------------------------------------------

REAL(KIND=JPRB) :: RSDTSN15
REAL(KIND=JPRB) :: RRAE15
REAL(KIND=JPRB) :: RMU0015
REAL(KIND=JPRB) :: RALBICE15
REAL(KIND=JPRB) :: RALBSEA15
REAL(KIND=JPRB) :: RALBSNM15
REAL(KIND=JPRB) :: RALBSNO15
REAL(KIND=JPRB) :: RCARDI15
REAL(KIND=JPRB) :: REMISS15
REAL(KIND=JPRB) :: RSNOWAL15
REAL(KIND=JPRB) :: RVLBDC15
REAL(KIND=JPRB) :: RCH415
REAL(KIND=JPRB) :: RN2O15
REAL(KIND=JPRB) :: RCFC1115
REAL(KIND=JPRB) :: RCFC1215
REAL(KIND=JPRB) :: REPALB15
REAL(KIND=JPRB) :: REPCLC15
REAL(KIND=JPRB) :: REPH2O15

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME       TYPE     PURPOSE
!  ----    :  ----   : -------------------------------------------------
! RSDTSN15 :
! RRAE15   : EFFECT OF EARTH'S CURVATURE ON COSINE SOLAR ZENITH ANGLE
! RMU0015  : MINIMUM COSINE OF SOLAR ZENITH ANGLE DUE TO EARTH'S
!            CURVATURE
! RALBICE15: FLOATING ICE ALBEDO (Unusefull for FMR in Arpege-climat)
! RALBSEA15: OPEN SEA ALBEDO (Unusefull for FMR in Arpege-climat)
! RALBSNM15:       SNOW ALBEDO (Unusefull for FMR in Arpege-climat)
! RALBSNO15: THICK SNOW ALBEDO (Unusefull for FMR in Arpege-climat)

! RCARDI15 : SPECIFIC ATMOSPHERIC CONTENT IN CO2
! REMISS15 : SURFACE LONGWAVE EMISSIVITY

! RSNOWAL15: SNOW DEPTH (IN EQUIVALENT WATER) FOR WHICH SNOW IS
!            CONSIDERED AS THICK
! RVLBDC15 : SPECIFIES THE REDUCTION OF THERMAL DIFFUSION UNDER
!            VEGETATION
! REPALB15 : SECURITY TO AVOID ZERO ALBEDOS.
! REPCLC15 : SECURITY TO AVOID ZERO OR ONE CLOUD COVERS
! REPH2O15 : SECURITY TO AVOID WATER VAPOUR CONTENT IN A LAYER
!            TO BE MORE THAN THE RESPECTIVE VALUE AT SATURATION.
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(ralbice15,ralbsea15,ralbsnm15,ralbsno15,rcardi15,rcfc1115,rcfc1215,rch415)
!$OMP THREADPRIVATE(remiss15,repalb15,repclc15,reph2o15,rmu0015,rn2o15,rrae15,rsdtsn15,rsnowal15,rvlbdc15)
END MODULE YOMRDI15
