MODULE lmdz_spla_gastoparticle

CONTAINS

SUBROUTINE spla_gastoparticle(klon,klev,nbtr,pdtphys,zdz,zrho,xlat,pplay,t_seri, &
        id_prec,id_fine, &
        tr_seri,his_g2pgas ,his_g2paer )
  !nhl     .                         fluxso4chem, flux_sparam_sulf,

USE lmdz_spla_ini, ONLY: RNAVO,masse_s,masse_ammsulfate

  !USE yoecumf_mod_h !!!! AS: pour Tiedke (Tiedtke) ; ça compile sans -->> inutile?!

IMPLICIT NONE
  !
  INTEGER, intent(in) :: klon,klev  ! from dimphy
  INTEGER, intent(in) :: nbtr  ! from infotrac_phy
  !
  INTEGER,intent(in) :: id_prec,id_fine            ! JE: 20140120
  REAL, intent(in) :: pdtphys
  REAL, dimension(klon,klev), intent(in) :: zrho
  REAL, dimension(klon,klev), intent(in) :: zdz
  REAL, dimension(klon), intent(in) :: xlat       ! latitudes pour chaque point
  REAL, dimension(klon,klev), intent(in) :: pplay  ! JE: 20140120
  REAL, dimension(klon,klev), intent(in) :: t_seri ! JE: 20140120
  REAL, dimension(klon,klev,nbtr), intent(inout) :: tr_seri   ! traceurs
  REAL, dimension(klon), intent(out) :: his_g2pgas ! JE: 20140120
  REAL, dimension(klon), intent(out) :: his_g2paer ! JE: 20140120
  !       local
  REAL :: tendincm3(klon,klev)  ! JE: 20140120
  REAL :: tempvar(klon,klev)    ! JE: 20140120
  REAL :: tend2d(klon,klev)     ! JE: 20140120
  REAL :: tend                  ! tendance par espece
  REAL :: pi
  !------------------------- Scaling Parameter --------------------------
  !
  !  REAL scale_param_so4(klon)  !Scaling parameter for sulfate
  INTEGER :: i, k
  REAL :: tau_chem     !---chemical lifetime in s
  !
  !------------------------- Variables to save --------------------------
  !
  !nhl      REAL fluxso4chem(klon,klev)
  !nhl      REAL flux_sparam_sulf(klon,klev)

  !======================================================================
  pi=atan(1.)*4.
  !
  IF (id_prec>0 .AND. id_fine>0) THEN
  DO k = 1, klev
  DO i = 1, klon
  !
  !    tau_chem=scale_param_so4(i)*86400.*(8.-5.*cos(xlat(i)*pi/180.))    !tchemfctn2
  !nhl        tau_chem=86400.*(8.-5.*cos(xlat(i)*pi/180.))    !tchemfctn2
    tau_chem=86400.*(5.-4.*cos(xlat(i)*pi/180.))    !
    tend=tr_seri(i,k,id_prec)*(1.-exp(-pdtphys/tau_chem)) ! Sulfate production
  !nhl        tend=(1.-exp(-pdtphys/tau_chem))
  !nhl        tend=scale_param_so4(i) !as this it works
  !
    tr_seri(i,k,id_prec) =tr_seri(i,k,id_prec) - tend
    tr_seri(i,k,id_fine) =tr_seri(i,k,id_fine) + &
          tend/RNAVO*masse_ammsulfate  !--gAER/KgAir
    tend2d(i,k)=tend
  !
  !nhl        fluxso4chem(i,k) = tend/RNAVO*masse_ammsulfate
  !nhl        flux_sparam_sulf(i,k) = tend/RNAVO*masse_ammsulfate
  ENDDO
  ENDDO



    tempvar=tend2d
     CALL kg_to_cm3(pplay,t_seri,tempvar)
    tendincm3=tempvar

  DO k = 1, klev
  DO i = 1, klon

     ! his_g2pgas(i) = his_g2pgas(i) + tendincm3(i,k)*1e6*zdz(i,k)/pdtphys
    his_g2paer(i) = his_g2paer(i) + &
          tendincm3(i,k)/RNAVO*masse_ammsulfate*1.e3* &
          1.e6*zdz(i,k)/pdtphys    ! mg/m2/s
    his_g2pgas(i) = his_g2paer(i)*masse_s/masse_ammsulfate ! mg-S/m2/s

  ENDDO
  ENDDO
  ENDIF

  !
  RETURN
END SUBROUTINE spla_gastoparticle

END MODULE lmdz_spla_gastoparticle
