module const

  implicit none

  real, parameter:: beta = 0.756 / 1023.343
  ! Salinity expansion coefficient. Derivative with respect to
  ! practical salinity, not mass fraction of salt. Value at 25 Celsius
  ! degrees, zero pressure, practical salinity 35, from Gill (1982
  ! k0829, table A.3.1).

  real, parameter:: cpa = 1004.67
  ! specific heat of dry air, in J / kg / K (Businger 1982)

  real, parameter:: cpw = 4000. ! specific heat of liquid water, in J / kg / K
  real, parameter:: grav  = 9.780326772 ! constante de gravitation, m s-2
  real, parameter::  rhow = 1022. ! density of liquid water, in kg / m3

  real, parameter:: rgas = 287.1
  ! specific ideal gas constant for dry air, in J / kg / K

  real, parameter:: von = 0.4 ! von Karman's "constant"

  real, parameter:: eps_w = 0.62197
  ! molecular mass of water over molecular mass of dry air (Gill 1982
  ! k0829, equation 3.1.13)

end module const
