MODULE YOERDI

USE PARKIND1  ,ONLY : JPRB

IMPLICIT NONE

PUBLIC

SAVE

!     -----------------------------------------------------------------
!*    ** *YOERDI* - COEFFICIENTS WITHIN RADIATION INTERFACE
!     -----------------------------------------------------------------

REAL(KIND=JPRB) :: RRAE
REAL(KIND=JPRB) :: RSUNDUR
REAL(KIND=JPRB) :: RCARDI
REAL(KIND=JPRB) :: RCH4
REAL(KIND=JPRB) :: RN2O
REAL(KIND=JPRB) :: RNO2
REAL(KIND=JPRB) :: RO3
REAL(KIND=JPRB) :: RCCL4
REAL(KIND=JPRB) :: RCFC11
REAL(KIND=JPRB) :: RCFC12
REAL(KIND=JPRB) :: RCFC22
REAL(KIND=JPRB) :: REPCLC
REAL(KIND=JPRB) :: REPH2O
REAL(KIND=JPRB) :: RCCO2, RCCH4, RCN2O, RCNO2, RCCFC11, RCCFC12, RCCFC22, RCCCL4
REAL(KIND=JPRB) :: RSOLINC

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     Original  J.-J. MORCRETTE       E.C.M.W.F.      89/07/14
!     Modified  P. Viterbo    99/03/26    Surface tiling
!     Modified  P. Viterbo    24/05/2004  surf library
!     Modified JJMorcrette    2005/01/19  GHG and Solar constant variability

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! RRAE   : EFFECT OF EARTH'S CURVATURE ON COSINE SOLAR ZENITH ANGLE
! RSUNDUR: MINIMUM DIRECT SOLAR FOR COMPUTING SOLAR DURATION
! RCARDI : SPECIFIC ATMOSPHERIC CONTENT IN CO2
! RCH4, RN2O, RNO2, RO3, RCFC11, RCFC12 MASS MIXING RATIO OF VARIOUS TRACE GASES
! RCCH4, RCN2O, ... MASS MIXING RATIO OF VARIOUS TRACE GASES IN CLIMATE MODE
! REPCLC : SECURITY TO AVOID ZERO OR ONE CLOUD COVERS
! REPH2O : SECURITY TO AVOID WATER VAPOUR CONTENT IN A LAYER
!          TO BE MORE THAN THE RESPECTIVE VALUE AT SATURATION.
!     -----------------------------------------------------------------
END MODULE YOERDI
