!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL9 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,K_JP,K_JT,K_JT1,P_ONEMINUS,&
 & P_COLH2O,P_COLN2O,P_COLCH4,K_LAYTROP,K_LAYSWTCH,K_LAYLOW,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond   2000-05-15 speed-up
!     JJMorcrette 2000-05-17 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG9   ,NGS8
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA9 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,SELFREF,ABSN2O  , CH4REF  ,&
 & ETAREF  , H2OREF ,N2OREF ,STRRAT  

!  Input
!#include "yoeratm.h"

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_ONEMINUS 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLN2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCH4(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYSWTCH 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYLOW 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PRECISE             
!- from PROFDATA             
!- from SELF             
!- from SP             
INTEGER(KIND=JPIM) :: JFRAC(JPLAY)
REAL(KIND=JPRB) :: Z_FFRAC(JPLAY),ZFS(JPLAY),Z_SPECCOMB(JPLAY)
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY),INDS(JPLAY),IIOFF(JPLAY)

!      REAL TAUAER(JPLAY)
REAL(KIND=JPRB) :: Z_N2OMULT(JPLAY)

INTEGER(KIND=JPIM) :: IG, IOFF, JS, I_LAY, I_NS

REAL(KIND=JPRB) :: Z_COLREF1, Z_COLREF2, Z_CURRN2O, Z_FAC000, Z_FAC001,&
 & Z_FAC010, Z_FAC011, Z_FAC100, Z_FAC101, Z_FAC110, Z_FAC111, &
 & Z_FP, Z_FS, Z_RATIO, Z_SPECMULT, Z_SPECPARM, Z_WCOMB1, &
 & Z_WCOMB2  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,9),TAUAER)

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL9',0,ZHOOK_HANDLE)
IOFF = 0

!     Compute the optical depth by interpolating in ln(pressure), 
!     temperature, and appropriate species.  Below LAYTROP, the water
!     vapor self-continuum is interpolated (in temperature) separately.
  
DO I_LAY = 1, K_LAYTROP
  Z_SPECCOMB(I_LAY) = P_COLH2O(I_LAY) + STRRAT*P_COLCH4(I_LAY)
  Z_SPECPARM = P_COLH2O(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 8._JPRB*(Z_SPECPARM)
  JS = 1 + INT(Z_SPECMULT)
  JFRAC(I_LAY) = JS
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  Z_FFRAC(I_LAY) = Z_FS
  IF (JS  ==  8) THEN
    IF (Z_FS <= 0.68_JPRB) THEN
      Z_FS = Z_FS/0.68_JPRB
    ELSEIF (Z_FS  <=  0.92_JPRB) THEN
      JS = JS + 1
      Z_FS = (Z_FS-0.68_JPRB)/0.24_JPRB
    ELSE
      JS = JS + 2
      Z_FS = (Z_FS-0.92_JPRB)/0.08_JPRB
    ENDIF
  ELSEIF (JS  == 9) THEN
    JS = 10
    Z_FS = 1.0_JPRB
    JFRAC(I_LAY) = 8
    Z_FFRAC(I_LAY) = 1.0_JPRB
  ENDIF
  Z_FP = P_FAC01(I_LAY) + P_FAC11(I_LAY)
  I_NS = JS + INT(Z_FS + 0.5_JPRB)
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(9) + JS
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(9) + JS
  INDS(I_LAY) = K_INDSELF(I_LAY)
  IF (I_LAY  ==  K_LAYLOW) IOFF = NG9
  IF (I_LAY  ==  K_LAYSWTCH) IOFF = 2*NG9
  Z_COLREF1 = N2OREF(K_JP(I_LAY))
  Z_COLREF2 = N2OREF(K_JP(I_LAY)+1)
  IF (I_NS  ==  11) THEN
    Z_WCOMB1 = 1.0_JPRB/H2OREF(K_JP(I_LAY))
    Z_WCOMB2 = 1.0_JPRB/H2OREF(K_JP(I_LAY)+1)
  ELSE
    Z_WCOMB1 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CH4REF(K_JP(I_LAY)))
    Z_WCOMB2 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CH4REF(K_JP(I_LAY)+1))
  ENDIF
  Z_RATIO = (Z_COLREF1*Z_WCOMB1)+Z_FP*((Z_COLREF2*Z_WCOMB2)-(Z_COLREF1*Z_WCOMB1))
  Z_CURRN2O = Z_SPECCOMB(I_LAY) * Z_RATIO
  Z_N2OMULT(I_LAY) = P_COLN2O(I_LAY) - Z_CURRN2O

  ZFS(I_LAY)=Z_FS
  IIOFF(I_LAY)=IOFF

ENDDO

!-- DS_000515
DO IG = 1, NG9
  DO I_LAY = 1, K_LAYTROP
!-- DS_000515

    Z_FS=ZFS(I_LAY)
    IOFF=IIOFF(I_LAY)
!---jjm
!    FAC000 = (_ONE_ - FS) * FAC00(LAY)
!    FAC010 = (_ONE_ - FS) * FAC10(LAY)
!    FAC100 = FS * FAC00(LAY)
!    FAC110 = FS * FAC10(LAY)
!    FAC001 = (_ONE_ - FS) * FAC01(LAY)
!    FAC011 = (_ONE_ - FS) * FAC11(LAY)
!    FAC101 = FS * FAC01(LAY)
!    FAC111 = FS * FAC11(LAY)
!------         

    P_TAU (NGS8+IG,I_LAY) = Z_SPECCOMB(I_LAY) *&
     !-- DS_000515
     !     &(Z_FAC000 * ABSA(IND0(I_LAY)   ,IG) +&
     !     & Z_FAC100 * ABSA(IND0(I_LAY)+ 1,IG) +&
     !     & Z_FAC010 * ABSA(IND0(I_LAY)+11,IG) +&
     !     & Z_FAC110 * ABSA(IND0(I_LAY)+12,IG) +&
     !     & Z_FAC001 * ABSA(IND1(I_LAY)   ,IG) +&
     !     & Z_FAC101 * ABSA(IND1(I_LAY)+ 1,IG) +&
     !     & Z_FAC011 * ABSA(IND1(I_LAY)+11,IG) +&
     !     & Z_FAC111 * ABSA(IND1(I_LAY)+12,IG))+&
     & ( (1. - Z_FS) *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)   ,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+11,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)   ,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+11,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)+ 1,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+12,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)+ 1,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+12,IG))) + &
     !-- DS_000515
     & P_COLH2O(I_LAY) * &
     & P_SELFFAC(I_LAY) * (SELFREF(INDS(I_LAY),IG) + &
     & P_SELFFRAC(I_LAY) *&
     & (SELFREF(INDS(I_LAY)+1,IG) - SELFREF(INDS(I_LAY),IG)))&
     & + Z_N2OMULT(I_LAY) * ABSN2O(IG+IOFF)&
     & + P_TAUAERL(I_LAY,9)  
    PFRAC(NGS8+IG,I_LAY) = FRACREFA(IG,JFRAC(I_LAY)) + Z_FFRAC(I_LAY) *&
     & (FRACREFA(IG,JFRAC(I_LAY)+1) - FRACREFA(IG,JFRAC(I_LAY)))  
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(9) + 1
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(9) + 1
ENDDO

!-- JJM_000517
DO IG = 1, NG9
  DO I_LAY = K_LAYTROP+1, KLEV
!-- JJM_000517
    P_TAU (NGS8+IG,I_LAY) = P_COLCH4(I_LAY) *&
     & (P_FAC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +&
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +&
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +&
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+1,IG))&
     & + P_TAUAERL(I_LAY,9)  
    PFRAC(NGS8+IG,I_LAY) = FRACREFB(IG)
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL9',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL9
