SUBROUTINE SU_UVRAD ( KUV )

!**** *SU_UVRAD*   - INITIALIZE COMMON YOE_UVRAD

!     PURPOSE.
!     --------
!           INITIALIZE YOE_UVRAD, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE ULTRAVIOLET RADIATION PROCESSOR

!**   INTERFACE.
!     ----------
!        *CALL* *SU_UVRAD* FROM *SUECRAD*


!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOE_UVRAD


!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE *ECMWF*

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 2005-10-04

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOMLUN   , ONLY : NULOUT
USE YOE_UVRAD, ONLY : IPUV, JUVLAM, &
              & RK250 , RTUV1, RTUV2, RSUVB0, RAYUVB, &
              & RTAUVA, RPIUVA, RCGUVA, RCIEAS, RUVLAM, RFCAER, RFCOZO, &
              & RASA  , RASB, RASC, RASD, RASE, RASF, RFA0, RFA1, &
              & RFB0  , RFB1, RFB2, RFB3, RFC0, RFC1, RFC2, RFC3, &
              & RFD0  , RFD1, RFD2, RFD3, JCOP, RXPO, RXPL 

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KUV 


INTEGER(KIND=JPIM) :: J, JAE
!INTEGER(KIND=JPIM) :: IACOP(24), IBCOP(120), ICCOP(600), IDCOP(3000)
INTEGER(KIND=JPIM) :: IACOP(24), IBCOP(120), ICCOP(600)

REAL(KIND=JPRB) :: ZBEG, ZEXP, ZHRES, ZRES, ZUVLAM
REAL(KIND=JPRB) :: ZAK250(24)  ,ZATUV1(24)  ,ZATUV2(24)  ,ZASUVB(24)  ,ZARAYUV(24)
REAL(KIND=JPRB) :: ZBK250(120) ,ZBTUV1(120) ,ZBTUV2(120) ,ZBSUVB(120) ,ZBRAYUV(120)
REAL(KIND=JPRB) :: ZCK250(600) ,ZCTUV1(600) ,ZCTUV2(600) ,ZCSUVB(600) ,ZCRAYUV(600)
!REAL(KIND=JPRB) :: ZDK250(3000),ZDTUV1(3000),ZDTUV2(3000),ZDSUVB(3000),ZDRAYUV(3000)

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!     ----------------------------------------------------------------
!#include "abor1.intfb.h"

!     ----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SU_UVRAD',0,ZHOOK_HANDLE)

! multiplying factors for sensitivity studies

RFCAER=1.0_JPRB
RFCOZO=1.0_JPRB

!-- explicit computations from 280. to 400. nm by (400-280)/(KUV-1) nm

!-- correspondence table with intervals in Slingo (1989) and Fu (1996)

IACOP = (/ 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4 /) 
IBCOP = (/ 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 /)
ICCOP = (/ 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,&
         & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 /)
!IDCOP = (/ 

!          O3 absorption parameters from integrating Molina & Molina, 1986

! RK250: ozone cross-section ( x E-20 cm2 molecule-1 )

! revised 20051031 (code "read_integrate_kurucz_rayleigh_O3")
! check norms: 0.1262176396E+05  0.1293728681E+05  0.1350083624E+05
ZAK250 = (/ &                                                            
 & 0.3053413E+03_JPRB, 0.1737485E+03_JPRB, 0.1045573E+03_JPRB, 0.5265653E+02_JPRB, 0.2620346E+02_JPRB, &
 & 0.1350141E+02_JPRB, 0.6771311E+01_JPRB, 0.3435206E+01_JPRB, 0.1629208E+01_JPRB, 0.7546285E+00_JPRB, &
 & 0.3856211E+00_JPRB, 0.1501495E+00_JPRB, 0.7608691E-01_JPRB, 0.2646207E-01_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZATUV1 = (/ &                                                              
 & 0.1955606E-03_JPRB, 0.4455332E-03_JPRB, 0.6856191E-03_JPRB, 0.1009841E-02_JPRB, 0.1181320E-02_JPRB, &
 & 0.1593266E-02_JPRB, 0.1902945E-02_JPRB, 0.2377848E-02_JPRB, 0.3512989E-02_JPRB, 0.4511920E-02_JPRB, &
 & 0.4672713E-02_JPRB, 0.6355066E-02_JPRB, 0.7100463E-02_JPRB, 0.1112103E-01_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZATUV2 = (/ &                                                              
 &-0.3391206E-06_JPRB, 0.1269089E-05_JPRB, 0.3833753E-05_JPRB, 0.5239359E-05_JPRB, 0.1149881E-04_JPRB, &
 & 0.1214144E-04_JPRB, 0.1456489E-04_JPRB, 0.1640689E-04_JPRB, 0.8903441E-05_JPRB, 0.9585654E-05_JPRB, &
 & 0.1444280E-04_JPRB, 0.2252139E-04_JPRB, 0.7899461E-05_JPRB, 0.1340369E-04_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)

! check norms: 0.1262176396E+05  0.1293728681E+05  0.1350083624E+05
ZBK250 = (/ &                                                            
 & 0.3746235E+03_JPRB, 0.3374782E+03_JPRB, 0.3109353E+03_JPRB, 0.2882899E+03_JPRB, 0.2577510E+03_JPRB, &
 & 0.2259643E+03_JPRB, 0.2085487E+03_JPRB, 0.1854031E+03_JPRB, 0.1612119E+03_JPRB, 0.1453486E+03_JPRB, &
 & 0.1310256E+03_JPRB, 0.1133554E+03_JPRB, 0.1020065E+03_JPRB, 0.8859325E+02_JPRB, 0.7909053E+02_JPRB, &
 & 0.6807025E+02_JPRB, 0.6024819E+02_JPRB, 0.5107318E+02_JPRB, 0.4535628E+02_JPRB, 0.3949330E+02_JPRB, &
 & 0.3422062E+02_JPRB, 0.2996915E+02_JPRB, 0.2577570E+02_JPRB, 0.2279167E+02_JPRB, 0.2034549E+02_JPRB, &
 & 0.1721408E+02_JPRB, 0.1564205E+02_JPRB, 0.1300914E+02_JPRB, 0.1160289E+02_JPRB, 0.9688561E+01_JPRB, &
 & 0.8512331E+01_JPRB, 0.7888720E+01_JPRB, 0.6400194E+01_JPRB, 0.5981788E+01_JPRB, 0.4811029E+01_JPRB, &
 & 0.4636916E+01_JPRB, 0.3695886E+01_JPRB, 0.3476093E+01_JPRB, 0.2543994E+01_JPRB, 0.2691098E+01_JPRB, &
 & 0.2131005E+01_JPRB, 0.1743577E+01_JPRB, 0.1933369E+01_JPRB, 0.1154597E+01_JPRB, 0.1144737E+01_JPRB, &
 & 0.1227887E+01_JPRB, 0.6772851E+00_JPRB, 0.8242575E+00_JPRB, 0.7724384E+00_JPRB, 0.3580751E+00_JPRB, &
 & 0.5599410E+00_JPRB, 0.5106917E+00_JPRB, 0.2370067E+00_JPRB, 0.3617942E+00_JPRB, 0.2703357E+00_JPRB, &
 & 0.1238728E+00_JPRB, 0.2085226E+00_JPRB, 0.2350139E+00_JPRB, 0.9726696E-01_JPRB, 0.1077734E+00_JPRB, &
 & 0.1266662E+00_JPRB, 0.5216565E-01_JPRB, 0.4033553E-01_JPRB, 0.7404691E-01_JPRB, 0.8175474E-01_JPRB, &
 & 0.3928745E-01_JPRB, 0.2581425E-01_JPRB, 0.3220713E-01_JPRB, 0.1852549E-01_JPRB, 0.1710368E-01_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZBTUV1 = (/ &                                                              
 & 0.1304379E-03_JPRB, 0.2381045E-03_JPRB, 0.1312193E-03_JPRB, 0.1382507E-03_JPRB, 0.4377790E-03_JPRB, &
 & 0.2744315E-03_JPRB, 0.3904921E-03_JPRB, 0.4057293E-03_JPRB, 0.3944389E-03_JPRB, 0.6213526E-03_JPRB, &
 & 0.5230166E-03_JPRB, 0.7115036E-03_JPRB, 0.8224138E-03_JPRB, 0.7839015E-03_JPRB, 0.6757493E-03_JPRB, &
 & 0.1013929E-02_JPRB, 0.9388676E-03_JPRB, 0.1139504E-02_JPRB, 0.9152941E-03_JPRB, 0.1010882E-02_JPRB, &
 & 0.1092914E-02_JPRB, 0.1116954E-02_JPRB, 0.1157353E-02_JPRB, 0.1312172E-02_JPRB, 0.1258207E-02_JPRB, &
 & 0.1565364E-02_JPRB, 0.1304358E-02_JPRB, 0.1921441E-02_JPRB, 0.1597455E-02_JPRB, 0.1585083E-02_JPRB, &
 & 0.1804721E-02_JPRB, 0.1717419E-02_JPRB, 0.2201039E-02_JPRB, 0.1650979E-02_JPRB, 0.2436943E-02_JPRB, &
 & 0.1758300E-02_JPRB, 0.2866617E-02_JPRB, 0.2292916E-02_JPRB, 0.3437942E-02_JPRB, 0.2268845E-02_JPRB, &
 & 0.3270049E-02_JPRB, 0.3506425E-02_JPRB, 0.2534346E-02_JPRB, 0.5591768E-02_JPRB, 0.3701606E-02_JPRB, &
 & 0.3035392E-02_JPRB, 0.6216419E-02_JPRB, 0.3456239E-02_JPRB, 0.4134974E-02_JPRB, 0.8414933E-02_JPRB, &
 & 0.3396263E-02_JPRB, 0.4222453E-02_JPRB, 0.8249625E-02_JPRB, 0.3627255E-02_JPRB, 0.6302904E-02_JPRB, &
 & 0.1011540E-01_JPRB, 0.4498586E-02_JPRB, 0.4007648E-02_JPRB, 0.8463577E-02_JPRB, 0.7236953E-02_JPRB, &
 & 0.5225470E-02_JPRB, 0.1114658E-01_JPRB, 0.1362563E-01_JPRB, 0.6584077E-02_JPRB, 0.4911811E-02_JPRB, &
 & 0.1365494E-01_JPRB, 0.9170420E-02_JPRB, 0.7847505E-02_JPRB, 0.8155373E-02_JPRB, 0.2917714E-01_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZBTUV2 = (/ &                                                              
 &-0.2310595E-05_JPRB,-0.1588555E-05_JPRB,-0.3803504E-06_JPRB, 0.2203029E-05_JPRB,-0.2347744E-05_JPRB, &
 & 0.3014092E-05_JPRB,-0.2353008E-05_JPRB, 0.3071326E-05_JPRB, 0.2498274E-05_JPRB, 0.6234744E-06_JPRB, &
 & 0.3393139E-05_JPRB, 0.5542024E-05_JPRB, 0.9758300E-06_JPRB, 0.5219182E-05_JPRB, 0.3721842E-05_JPRB, &
 & 0.2097421E-05_JPRB, 0.4340026E-05_JPRB, 0.5201248E-05_JPRB, 0.8369003E-05_JPRB, 0.8713780E-05_JPRB, &
 & 0.8890532E-05_JPRB, 0.1285612E-04_JPRB, 0.1431880E-04_JPRB, 0.1206355E-04_JPRB, 0.8875655E-05_JPRB, &
 & 0.1178909E-04_JPRB, 0.1027358E-04_JPRB, 0.6029656E-05_JPRB, 0.1471264E-04_JPRB, 0.2339166E-04_JPRB, &
 & 0.1449467E-04_JPRB, 0.1392035E-04_JPRB, 0.9490171E-05_JPRB, 0.1963981E-04_JPRB, 0.1545245E-04_JPRB, &
 & 0.2217010E-04_JPRB, 0.9402666E-05_JPRB, 0.1555344E-04_JPRB, 0.1678093E-04_JPRB, 0.1418057E-04_JPRB, &
 & 0.1018282E-04_JPRB, 0.1016892E-04_JPRB, 0.6648122E-05_JPRB,-0.1761027E-05_JPRB, 0.1343048E-04_JPRB, &
 & 0.5945775E-05_JPRB, 0.5228630E-05_JPRB, 0.1189961E-04_JPRB, 0.1062544E-04_JPRB, 0.6783912E-05_JPRB, &
 & 0.1611166E-04_JPRB, 0.9911433E-05_JPRB, 0.4732061E-05_JPRB, 0.2326484E-04_JPRB, 0.6846333E-05_JPRB, &
 & 0.5566848E-05_JPRB, 0.2998335E-04_JPRB, 0.4369986E-05_JPRB, 0.2288655E-04_JPRB, 0.4555816E-04_JPRB, &
 & 0.2229065E-04_JPRB,-0.5176777E-05_JPRB, 0.9089374E-05_JPRB, 0.2211234E-04_JPRB,-0.5195374E-04_JPRB, &
 &-0.5204193E-04_JPRB, 0.1285348E-03_JPRB,-0.3511670E-05_JPRB, 0.6086764E-04_JPRB,-0.2923827E-03_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)

! check norms: 0.1262176396E+05  0.1293728681E+05  0.1350083624E+05
ZCK250(  1:300) = (/ &
 & 0.3912691E+03_JPRB, 0.3839502E+03_JPRB, 0.3743189E+03_JPRB, 0.3712760E+03_JPRB, 0.3682782E+03_JPRB, &
 & 0.3607995E+03_JPRB, 0.3484512E+03_JPRB, 0.3362245E+03_JPRB, 0.3306447E+03_JPRB, 0.3257288E+03_JPRB, &
 & 0.3205932E+03_JPRB, 0.3156011E+03_JPRB, 0.3106752E+03_JPRB, 0.3061641E+03_JPRB, 0.3025993E+03_JPRB, &
 & 0.2990364E+03_JPRB, 0.2958928E+03_JPRB, 0.2922895E+03_JPRB, 0.2815917E+03_JPRB, 0.2710969E+03_JPRB, &
 & 0.2643130E+03_JPRB, 0.2602894E+03_JPRB, 0.2555913E+03_JPRB, 0.2508463E+03_JPRB, 0.2458966E+03_JPRB, &
 & 0.2400022E+03_JPRB, 0.2328428E+03_JPRB, 0.2266644E+03_JPRB, 0.2237314E+03_JPRB, 0.2211230E+03_JPRB, &
 & 0.2176822E+03_JPRB, 0.2129666E+03_JPRB, 0.2082285E+03_JPRB, 0.2050648E+03_JPRB, 0.2015646E+03_JPRB, &
 & 0.1964826E+03_JPRB, 0.1907146E+03_JPRB, 0.1843511E+03_JPRB, 0.1790203E+03_JPRB, 0.1740547E+03_JPRB, &
 & 0.1699693E+03_JPRB, 0.1658762E+03_JPRB, 0.1631024E+03_JPRB, 0.1594428E+03_JPRB, 0.1561083E+03_JPRB, &
 & 0.1522514E+03_JPRB, 0.1489648E+03_JPRB, 0.1456738E+03_JPRB, 0.1427900E+03_JPRB, 0.1400463E+03_JPRB, &
 & 0.1368885E+03_JPRB, 0.1338666E+03_JPRB, 0.1308455E+03_JPRB, 0.1279194E+03_JPRB, 0.1252291E+03_JPRB, &
 & 0.1221635E+03_JPRB, 0.1173480E+03_JPRB, 0.1134466E+03_JPRB, 0.1104490E+03_JPRB, 0.1075005E+03_JPRB, &
 & 0.1052409E+03_JPRB, 0.1034875E+03_JPRB, 0.1014312E+03_JPRB, 0.9917348E+02_JPRB, 0.9690936E+02_JPRB, &
 & 0.9363521E+02_JPRB, 0.9064002E+02_JPRB, 0.8742842E+02_JPRB, 0.8607183E+02_JPRB, 0.8419236E+02_JPRB, &
 & 0.8235930E+02_JPRB, 0.8037249E+02_JPRB, 0.7882393E+02_JPRB, 0.7689006E+02_JPRB, 0.7481278E+02_JPRB, &
 & 0.7260259E+02_JPRB, 0.7000890E+02_JPRB, 0.6741465E+02_JPRB, 0.6606238E+02_JPRB, 0.6431214E+02_JPRB, &
 & 0.6274430E+02_JPRB, 0.6096603E+02_JPRB, 0.5956343E+02_JPRB, 0.5820831E+02_JPRB, 0.5665523E+02_JPRB, &
 & 0.5500309E+02_JPRB, 0.5351154E+02_JPRB, 0.5118981E+02_JPRB, 0.5002563E+02_JPRB, 0.4881731E+02_JPRB, &
 & 0.4748677E+02_JPRB, 0.4631187E+02_JPRB, 0.4524318E+02_JPRB, 0.4422579E+02_JPRB, 0.4326350E+02_JPRB, &
 & 0.4201139E+02_JPRB, 0.4046981E+02_JPRB, 0.3921751E+02_JPRB, 0.3804230E+02_JPRB, 0.3728167E+02_JPRB, &
 & 0.3646048E+02_JPRB, 0.3568511E+02_JPRB, 0.3469347E+02_JPRB, 0.3368040E+02_JPRB, 0.3223647E+02_JPRB, &
 & 0.3120151E+02_JPRB, 0.3046987E+02_JPRB, 0.2973342E+02_JPRB, 0.2916021E+02_JPRB, 0.2869675E+02_JPRB, &
 & 0.2819547E+02_JPRB, 0.2704570E+02_JPRB, 0.2633426E+02_JPRB, 0.2524253E+02_JPRB, 0.2440977E+02_JPRB, &
 & 0.2368355E+02_JPRB, 0.2307297E+02_JPRB, 0.2260014E+02_JPRB, 0.2230349E+02_JPRB, 0.2196699E+02_JPRB, &
 & 0.2159911E+02_JPRB, 0.2100203E+02_JPRB, 0.2042105E+02_JPRB, 0.1959785E+02_JPRB, 0.1850330E+02_JPRB, &
 & 0.1799117E+02_JPRB, 0.1739673E+02_JPRB, 0.1696323E+02_JPRB, 0.1671992E+02_JPRB, 0.1652047E+02_JPRB, &
 & 0.1630084E+02_JPRB, 0.1608451E+02_JPRB, 0.1578843E+02_JPRB, 0.1524567E+02_JPRB, 0.1440076E+02_JPRB, &
 & 0.1386541E+02_JPRB, 0.1329988E+02_JPRB, 0.1272576E+02_JPRB, 0.1254554E+02_JPRB, 0.1245282E+02_JPRB, &
 & 0.1218871E+02_JPRB, 0.1178283E+02_JPRB, 0.1145067E+02_JPRB, 0.1133450E+02_JPRB, 0.1119256E+02_JPRB, &
 & 0.1078407E+02_JPRB, 0.1020251E+02_JPRB, 0.9528469E+01_JPRB, 0.9329364E+01_JPRB, 0.9126274E+01_JPRB, &
 & 0.8931937E+01_JPRB, 0.8718665E+01_JPRB, 0.8575605E+01_JPRB, 0.8437309E+01_JPRB, 0.8310787E+01_JPRB, &
 & 0.8215147E+01_JPRB, 0.8127766E+01_JPRB, 0.8001044E+01_JPRB, 0.7630502E+01_JPRB, 0.7218388E+01_JPRB, &
 & 0.6842024E+01_JPRB, 0.6619379E+01_JPRB, 0.6379956E+01_JPRB, 0.6211814E+01_JPRB, 0.6073732E+01_JPRB, &
 & 0.6047354E+01_JPRB, 0.6167841E+01_JPRB, 0.6213631E+01_JPRB, 0.5978124E+01_JPRB, 0.5663016E+01_JPRB, &
 & 0.5312896E+01_JPRB, 0.4966990E+01_JPRB, 0.4632250E+01_JPRB, 0.4511959E+01_JPRB, 0.4437874E+01_JPRB, &
 & 0.4521541E+01_JPRB, 0.4730288E+01_JPRB, 0.4850666E+01_JPRB, 0.4597253E+01_JPRB, 0.4254414E+01_JPRB, &
 & 0.3974671E+01_JPRB, 0.3772243E+01_JPRB, 0.3622352E+01_JPRB, 0.3596173E+01_JPRB, 0.3597771E+01_JPRB, &
 & 0.3587278E+01_JPRB, 0.3569527E+01_JPRB, 0.3534352E+01_JPRB, 0.3400931E+01_JPRB, 0.3269153E+01_JPRB, &
 & 0.3038523E+01_JPRB, 0.2772412E+01_JPRB, 0.2532108E+01_JPRB, 0.2400635E+01_JPRB, 0.2269651E+01_JPRB, &
 & 0.2318103E+01_JPRB, 0.2555933E+01_JPRB, 0.2783417E+01_JPRB, 0.2859555E+01_JPRB, 0.2929581E+01_JPRB, &
 & 0.2773406E+01_JPRB, 0.2471774E+01_JPRB, 0.2117337E+01_JPRB, 0.1887952E+01_JPRB, 0.1665876E+01_JPRB, &
 & 0.1545364E+01_JPRB, 0.1530765E+01_JPRB, 0.1569366E+01_JPRB, 0.1765859E+01_JPRB, 0.2076064E+01_JPRB, &
 & 0.2118826E+01_JPRB, 0.2013361E+01_JPRB, 0.1904165E+01_JPRB, 0.1817854E+01_JPRB, 0.1717719E+01_JPRB, &
 & 0.1528353E+01_JPRB, 0.1301476E+01_JPRB, 0.1075097E+01_JPRB, 0.9913148E+00_JPRB, 0.9390067E+00_JPRB, &
 & 0.9410631E+00_JPRB, 0.9908390E+00_JPRB, 0.1077318E+01_JPRB, 0.1253445E+01_JPRB, 0.1470490E+01_JPRB, &
 & 0.1500942E+01_JPRB, 0.1410377E+01_JPRB, 0.1291770E+01_JPRB, 0.1121325E+01_JPRB, 0.9340122E+00_JPRB, &
 & 0.7967983E+00_JPRB, 0.6878130E+00_JPRB, 0.6101190E+00_JPRB, 0.6281103E+00_JPRB, 0.6616779E+00_JPRB, &
 & 0.6857364E+00_JPRB, 0.7056597E+00_JPRB, 0.7477958E+00_JPRB, 0.9194159E+00_JPRB, 0.1109930E+01_JPRB, &
 & 0.1092774E+01_JPRB, 0.9152249E+00_JPRB, 0.7291639E+00_JPRB, 0.6087120E+00_JPRB, 0.4870125E+00_JPRB, &
 & 0.4089467E+00_JPRB, 0.3685752E+00_JPRB, 0.3364085E+00_JPRB, 0.3355197E+00_JPRB, 0.3394912E+00_JPRB, &
 & 0.4048120E+00_JPRB, 0.4981886E+00_JPRB, 0.6072237E+00_JPRB, 0.6562844E+00_JPRB, 0.7088529E+00_JPRB, &
 & 0.6887763E+00_JPRB, 0.6012469E+00_JPRB, 0.5178619E+00_JPRB, 0.4263444E+00_JPRB, 0.3389390E+00_JPRB, &
 & 0.2766929E+00_JPRB, 0.2419911E+00_JPRB, 0.2081429E+00_JPRB, 0.2205261E+00_JPRB, 0.2407883E+00_JPRB, &
 & 0.2829715E+00_JPRB, 0.3323930E+00_JPRB, 0.3840338E+00_JPRB, 0.4009112E+00_JPRB, 0.4141605E+00_JPRB, &
 & 0.3841738E+00_JPRB, 0.3191549E+00_JPRB, 0.2538516E+00_JPRB, 0.2141375E+00_JPRB, 0.1749193E+00_JPRB, &
 & 0.1442347E+00_JPRB, 0.1308030E+00_JPRB, 0.1175839E+00_JPRB, 0.1152005E+00_JPRB, 0.1144295E+00_JPRB, &
 & 0.1332690E+00_JPRB, 0.1750619E+00_JPRB, 0.2049352E+00_JPRB, 0.2269636E+00_JPRB, 0.2466895E+00_JPRB, &
 & 0.2630055E+00_JPRB, 0.2741632E+00_JPRB, 0.2762103E+00_JPRB, 0.2284683E+00_JPRB, 0.1768542E+00_JPRB, &
 & 0.1404621E+00_JPRB, 0.1127350E+00_JPRB, 0.8942173E-01_JPRB, 0.8041714E-01_JPRB, 0.7391840E-01_JPRB, &
 & 0.7558672E-01_JPRB, 0.8552747E-01_JPRB, 0.9933794E-01_JPRB, 0.1231135E+00_JPRB, 0.1472332E+00_JPRB /)
ZCK250(301:600) = (/ &
 & 0.1526061E+00_JPRB, 0.1421443E+00_JPRB, 0.1296576E+00_JPRB, 0.1091694E+00_JPRB, 0.8614825E-01_JPRB, &
 & 0.6917399E-01_JPRB, 0.5783544E-01_JPRB, 0.4674525E-01_JPRB, 0.4370108E-01_JPRB, 0.4142633E-01_JPRB, &
 & 0.3910948E-01_JPRB, 0.3637619E-01_JPRB, 0.3495317E-01_JPRB, 0.4133272E-01_JPRB, 0.4971278E-01_JPRB, &
 & 0.5383842E-01_JPRB, 0.5446874E-01_JPRB, 0.6006002E-01_JPRB, 0.8558061E-01_JPRB, 0.1183642E+00_JPRB, &
 & 0.1234464E+00_JPRB, 0.1012597E+00_JPRB, 0.8177673E-01_JPRB, 0.7039373E-01_JPRB, 0.5842135E-01_JPRB, &
 & 0.4994100E-01_JPRB, 0.4395068E-01_JPRB, 0.3678789E-01_JPRB, 0.3423710E-01_JPRB, 0.3205213E-01_JPRB, &
 & 0.2882322E-01_JPRB, 0.2490090E-01_JPRB, 0.2239739E-01_JPRB, 0.2488575E-01_JPRB, 0.2809792E-01_JPRB, &
 & 0.3163878E-01_JPRB, 0.3529353E-01_JPRB, 0.3743464E-01_JPRB, 0.3154792E-01_JPRB, 0.2476330E-01_JPRB, &
 & 0.2125607E-01_JPRB, 0.2063931E-01_JPRB, 0.1970776E-01_JPRB, 0.1711069E-01_JPRB, 0.1448247E-01_JPRB, &
 & 0.1419092E-01_JPRB, 0.1697305E-01_JPRB, 0.1922265E-01_JPRB, 0.1809877E-01_JPRB, 0.1633014E-01_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZCTUV1(  1:300) = (/ &
 &-0.7300886E-04_JPRB, 0.2165305E-04_JPRB, 0.1518885E-03_JPRB, 0.1801729E-03_JPRB, 0.2046781E-03_JPRB, &
 & 0.2321395E-03_JPRB, 0.2666132E-03_JPRB, 0.2905016E-03_JPRB, 0.2372348E-03_JPRB, 0.1789425E-03_JPRB, &
 & 0.1385595E-03_JPRB, 0.1176325E-03_JPRB, 0.1025867E-03_JPRB, 0.1330112E-03_JPRB, 0.1624851E-03_JPRB, &
 & 0.1525305E-03_JPRB, 0.8864058E-04_JPRB, 0.4904664E-04_JPRB, 0.1451164E-03_JPRB, 0.2617269E-03_JPRB, &
 & 0.3550630E-03_JPRB, 0.4328231E-03_JPRB, 0.5061485E-03_JPRB, 0.5026669E-03_JPRB, 0.4904191E-03_JPRB, &
 & 0.4514644E-03_JPRB, 0.3765797E-03_JPRB, 0.3052066E-03_JPRB, 0.2502422E-03_JPRB, 0.1951159E-03_JPRB, &
 & 0.2224293E-03_JPRB, 0.3463365E-03_JPRB, 0.4626359E-03_JPRB, 0.4548639E-03_JPRB, 0.4312663E-03_JPRB, &
 & 0.3981121E-03_JPRB, 0.3601595E-03_JPRB, 0.3408163E-03_JPRB, 0.4272911E-03_JPRB, 0.5288183E-03_JPRB, &
 & 0.5513737E-03_JPRB, 0.4471895E-03_JPRB, 0.3864898E-03_JPRB, 0.3626459E-03_JPRB, 0.3489821E-03_JPRB, &
 & 0.4398179E-03_JPRB, 0.5966221E-03_JPRB, 0.7405845E-03_JPRB, 0.6992127E-03_JPRB, 0.6250672E-03_JPRB, &
 & 0.5602797E-03_JPRB, 0.5163022E-03_JPRB, 0.4840466E-03_JPRB, 0.5107349E-03_JPRB, 0.5462615E-03_JPRB, &
 & 0.5881982E-03_JPRB, 0.6573852E-03_JPRB, 0.7159264E-03_JPRB, 0.7562820E-03_JPRB, 0.7965609E-03_JPRB, &
 & 0.8163875E-03_JPRB, 0.8190289E-03_JPRB, 0.8226782E-03_JPRB, 0.8284381E-03_JPRB, 0.8345755E-03_JPRB, &
 & 0.8056005E-03_JPRB, 0.7495604E-03_JPRB, 0.7066258E-03_JPRB, 0.7724642E-03_JPRB, 0.9057206E-03_JPRB, &
 & 0.8502832E-03_JPRB, 0.6413947E-03_JPRB, 0.5219530E-03_JPRB, 0.6165869E-03_JPRB, 0.7758490E-03_JPRB, &
 & 0.8803623E-03_JPRB, 0.9650903E-03_JPRB, 0.1049895E-02_JPRB, 0.1079331E-02_JPRB, 0.1114359E-02_JPRB, &
 & 0.1041519E-02_JPRB, 0.8810123E-03_JPRB, 0.7704380E-03_JPRB, 0.8720518E-03_JPRB, 0.1053372E-02_JPRB, &
 & 0.1148837E-02_JPRB, 0.1189115E-02_JPRB, 0.1224080E-02_JPRB, 0.1139373E-02_JPRB, 0.1039175E-02_JPRB, &
 & 0.9717263E-03_JPRB, 0.9659483E-03_JPRB, 0.9509932E-03_JPRB, 0.8842079E-03_JPRB, 0.8138584E-03_JPRB, &
 & 0.8657698E-03_JPRB, 0.1011626E-02_JPRB, 0.1128555E-02_JPRB, 0.1102516E-02_JPRB, 0.1043855E-02_JPRB, &
 & 0.1035198E-02_JPRB, 0.1093726E-02_JPRB, 0.1145715E-02_JPRB, 0.1101793E-02_JPRB, 0.1023007E-02_JPRB, &
 & 0.1049129E-02_JPRB, 0.1125353E-02_JPRB, 0.1193913E-02_JPRB, 0.1135826E-02_JPRB, 0.1054100E-02_JPRB, &
 & 0.1004690E-02_JPRB, 0.9727073E-03_JPRB, 0.9889501E-03_JPRB, 0.1206755E-02_JPRB, 0.1413361E-02_JPRB, &
 & 0.1483673E-02_JPRB, 0.1389585E-02_JPRB, 0.1303692E-02_JPRB, 0.1202618E-02_JPRB, 0.1067236E-02_JPRB, &
 & 0.1081125E-02_JPRB, 0.1193359E-02_JPRB, 0.1297538E-02_JPRB, 0.1362035E-02_JPRB, 0.1438721E-02_JPRB, &
 & 0.1498571E-02_JPRB, 0.1605460E-02_JPRB, 0.1667381E-02_JPRB, 0.1561088E-02_JPRB, 0.1404859E-02_JPRB, &
 & 0.1300112E-02_JPRB, 0.1232071E-02_JPRB, 0.1186359E-02_JPRB, 0.1317165E-02_JPRB, 0.1565706E-02_JPRB, &
 & 0.1757936E-02_JPRB, 0.1998126E-02_JPRB, 0.2219445E-02_JPRB, 0.1934279E-02_JPRB, 0.1663420E-02_JPRB, &
 & 0.1494387E-02_JPRB, 0.1478608E-02_JPRB, 0.1506739E-02_JPRB, 0.1668795E-02_JPRB, 0.1919090E-02_JPRB, &
 & 0.1843774E-02_JPRB, 0.1546209E-02_JPRB, 0.1246735E-02_JPRB, 0.1458146E-02_JPRB, 0.1869647E-02_JPRB, &
 & 0.1982769E-02_JPRB, 0.1804524E-02_JPRB, 0.1709744E-02_JPRB, 0.1773561E-02_JPRB, 0.1859586E-02_JPRB, &
 & 0.1826165E-02_JPRB, 0.1656768E-02_JPRB, 0.1557886E-02_JPRB, 0.1705018E-02_JPRB, 0.1915113E-02_JPRB, &
 & 0.2075051E-02_JPRB, 0.2126461E-02_JPRB, 0.2189845E-02_JPRB, 0.2264029E-02_JPRB, 0.2330736E-02_JPRB, &
 & 0.2142399E-02_JPRB, 0.1641383E-02_JPRB, 0.1314965E-02_JPRB, 0.1430123E-02_JPRB, 0.1671123E-02_JPRB, &
 & 0.2000943E-02_JPRB, 0.2398306E-02_JPRB, 0.2805397E-02_JPRB, 0.2760983E-02_JPRB, 0.2603031E-02_JPRB, &
 & 0.2254001E-02_JPRB, 0.1707438E-02_JPRB, 0.1358394E-02_JPRB, 0.1617800E-02_JPRB, 0.2065673E-02_JPRB, &
 & 0.2466817E-02_JPRB, 0.2769094E-02_JPRB, 0.3017141E-02_JPRB, 0.3025354E-02_JPRB, 0.2981591E-02_JPRB, &
 & 0.2718787E-02_JPRB, 0.2352677E-02_JPRB, 0.2036865E-02_JPRB, 0.2123214E-02_JPRB, 0.2251885E-02_JPRB, &
 & 0.2545599E-02_JPRB, 0.2963245E-02_JPRB, 0.3421649E-02_JPRB, 0.3761743E-02_JPRB, 0.4168039E-02_JPRB, &
 & 0.3792586E-02_JPRB, 0.2691818E-02_JPRB, 0.1859473E-02_JPRB, 0.1698663E-02_JPRB, 0.1596011E-02_JPRB, &
 & 0.1866468E-02_JPRB, 0.2472971E-02_JPRB, 0.3382006E-02_JPRB, 0.4041891E-02_JPRB, 0.4838723E-02_JPRB, &
 & 0.5173073E-02_JPRB, 0.4874604E-02_JPRB, 0.4306427E-02_JPRB, 0.3231780E-02_JPRB, 0.2000433E-02_JPRB, &
 & 0.1861439E-02_JPRB, 0.2225228E-02_JPRB, 0.2649365E-02_JPRB, 0.3034028E-02_JPRB, 0.3543490E-02_JPRB, &
 & 0.4232267E-02_JPRB, 0.5139813E-02_JPRB, 0.6346525E-02_JPRB, 0.6436912E-02_JPRB, 0.6250926E-02_JPRB, &
 & 0.5587344E-02_JPRB, 0.4808163E-02_JPRB, 0.3922214E-02_JPRB, 0.2997367E-02_JPRB, 0.2173786E-02_JPRB, &
 & 0.2030102E-02_JPRB, 0.2242679E-02_JPRB, 0.2624961E-02_JPRB, 0.3565763E-02_JPRB, 0.5075541E-02_JPRB, &
 & 0.6281868E-02_JPRB, 0.6886248E-02_JPRB, 0.7266843E-02_JPRB, 0.6076686E-02_JPRB, 0.4795772E-02_JPRB, &
 & 0.4356297E-02_JPRB, 0.4466772E-02_JPRB, 0.4258595E-02_JPRB, 0.2897404E-02_JPRB, 0.1843119E-02_JPRB, &
 & 0.2009932E-02_JPRB, 0.3199593E-02_JPRB, 0.4951469E-02_JPRB, 0.6041670E-02_JPRB, 0.7461846E-02_JPRB, &
 & 0.8546823E-02_JPRB, 0.8710152E-02_JPRB, 0.8794515E-02_JPRB, 0.8287750E-02_JPRB, 0.7636299E-02_JPRB, &
 & 0.5824848E-02_JPRB, 0.4316517E-02_JPRB, 0.3105479E-02_JPRB, 0.2465729E-02_JPRB, 0.1831760E-02_JPRB, &
 & 0.2086637E-02_JPRB, 0.3358716E-02_JPRB, 0.4856066E-02_JPRB, 0.5922231E-02_JPRB, 0.7184053E-02_JPRB, &
 & 0.8372539E-02_JPRB, 0.9001604E-02_JPRB, 0.9555919E-02_JPRB, 0.8104750E-02_JPRB, 0.6525334E-02_JPRB, &
 & 0.4792899E-02_JPRB, 0.3547894E-02_JPRB, 0.2745707E-02_JPRB, 0.3341994E-02_JPRB, 0.4115321E-02_JPRB, &
 & 0.4877749E-02_JPRB, 0.5827051E-02_JPRB, 0.7167797E-02_JPRB, 0.7492950E-02_JPRB, 0.7709746E-02_JPRB, &
 & 0.8481136E-02_JPRB, 0.9578651E-02_JPRB, 0.1096287E-01_JPRB, 0.1099204E-01_JPRB, 0.1081739E-01_JPRB, &
 & 0.8763371E-02_JPRB, 0.6211870E-02_JPRB, 0.4962033E-02_JPRB, 0.3850856E-02_JPRB, 0.2970878E-02_JPRB, &
 & 0.2839165E-02_JPRB, 0.3280359E-02_JPRB, 0.3735243E-02_JPRB, 0.4371049E-02_JPRB, 0.5292864E-02_JPRB, &
 & 0.6320171E-02_JPRB, 0.7608543E-02_JPRB, 0.9269996E-02_JPRB, 0.9811061E-02_JPRB, 0.1011115E-01_JPRB, &
 & 0.1063044E-01_JPRB, 0.1127774E-01_JPRB, 0.1068954E-01_JPRB, 0.6261593E-02_JPRB, 0.3448325E-02_JPRB /)
ZCTUV1(301:600) = (/ &
 & 0.3132930E-02_JPRB, 0.4512714E-02_JPRB, 0.6235344E-02_JPRB, 0.7328861E-02_JPRB, 0.9068431E-02_JPRB, &
 & 0.1026526E-01_JPRB, 0.1043364E-01_JPRB, 0.1075774E-01_JPRB, 0.1175188E-01_JPRB, 0.1299149E-01_JPRB, &
 & 0.1349927E-01_JPRB, 0.1335356E-01_JPRB, 0.1329088E-01_JPRB, 0.1371228E-01_JPRB, 0.1416486E-01_JPRB, &
 & 0.1314228E-01_JPRB, 0.1087734E-01_JPRB, 0.8150859E-02_JPRB, 0.4523423E-02_JPRB, 0.2050808E-02_JPRB, &
 & 0.1681349E-02_JPRB, 0.2845095E-02_JPRB, 0.4677435E-02_JPRB, 0.6798010E-02_JPRB, 0.1090589E-01_JPRB, &
 & 0.1337907E-01_JPRB, 0.1275446E-01_JPRB, 0.1242592E-01_JPRB, 0.1394778E-01_JPRB, 0.1606850E-01_JPRB, &
 & 0.1529291E-01_JPRB, 0.1153001E-01_JPRB, 0.8916092E-02_JPRB, 0.6729881E-02_JPRB, 0.4765625E-02_JPRB, &
 & 0.5167450E-02_JPRB, 0.7806076E-02_JPRB, 0.1046871E-01_JPRB, 0.9795097E-02_JPRB, 0.8494707E-02_JPRB, &
 & 0.7421230E-02_JPRB, 0.6606390E-02_JPRB, 0.6140483E-02_JPRB, 0.8835159E-02_JPRB, 0.1348886E-01_JPRB, &
 & 0.2018839E-01_JPRB, 0.2876065E-01_JPRB, 0.4566265E-01_JPRB, 0.3430709E-01_JPRB, 0.2582433E-01_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)
ZCTUV2(  1:300) = (/ &
 & 0.5449728E-05_JPRB, 0.1073871E-05_JPRB,-0.4617351E-05_JPRB,-0.4662597E-05_JPRB,-0.4245903E-05_JPRB, &
 &-0.3501344E-05_JPRB,-0.2327032E-05_JPRB,-0.1160485E-05_JPRB,-0.9958612E-06_JPRB,-0.9097969E-06_JPRB, &
 &-0.6708045E-06_JPRB,-0.3015507E-06_JPRB,-0.6392786E-08_JPRB,-0.3021240E-06_JPRB,-0.6042436E-06_JPRB, &
 & 0.1495235E-06_JPRB, 0.2286339E-05_JPRB, 0.3876945E-05_JPRB, 0.3135600E-05_JPRB, 0.1962560E-05_JPRB, &
 & 0.2706349E-06_JPRB,-0.2130587E-05_JPRB,-0.4417644E-05_JPRB,-0.4455218E-05_JPRB,-0.4247367E-05_JPRB, &
 &-0.2599687E-05_JPRB, 0.1002400E-05_JPRB, 0.4013848E-05_JPRB, 0.4290779E-05_JPRB, 0.4239120E-05_JPRB, &
 & 0.2425512E-05_JPRB,-0.1615081E-05_JPRB,-0.5240423E-05_JPRB,-0.4114007E-05_JPRB,-0.2223535E-05_JPRB, &
 & 0.7356294E-06_JPRB, 0.4315885E-05_JPRB, 0.7074211E-05_JPRB, 0.3583437E-05_JPRB,-0.7265943E-06_JPRB, &
 &-0.2152072E-05_JPRB, 0.8515158E-06_JPRB, 0.2627439E-05_JPRB, 0.3447826E-05_JPRB, 0.3982830E-05_JPRB, &
 & 0.3435070E-05_JPRB, 0.2089333E-05_JPRB, 0.6670214E-06_JPRB,-0.5065600E-06_JPRB,-0.1649474E-05_JPRB, &
 &-0.5022627E-06_JPRB, 0.2711703E-05_JPRB, 0.5396061E-05_JPRB, 0.5160576E-05_JPRB, 0.4445397E-05_JPRB, &
 & 0.4654078E-05_JPRB, 0.6341880E-05_JPRB, 0.7375423E-05_JPRB, 0.5832266E-05_JPRB, 0.3559810E-05_JPRB, &
 & 0.1810887E-05_JPRB, 0.4885454E-06_JPRB,-0.4923044E-06_JPRB, 0.8285694E-06_JPRB, 0.2424262E-05_JPRB, &
 & 0.4601969E-05_JPRB, 0.6532422E-05_JPRB, 0.7979189E-05_JPRB, 0.5542080E-05_JPRB, 0.6684266E-06_JPRB, &
 & 0.5030713E-06_JPRB, 0.3990714E-05_JPRB, 0.6064054E-05_JPRB, 0.5041105E-05_JPRB, 0.3097796E-05_JPRB, &
 & 0.2510567E-05_JPRB, 0.2758335E-05_JPRB, 0.2725572E-05_JPRB, 0.1902094E-05_JPRB, 0.5449911E-06_JPRB, &
 & 0.1825130E-05_JPRB, 0.5139096E-05_JPRB, 0.7489894E-05_JPRB, 0.6139778E-05_JPRB, 0.3478090E-05_JPRB, &
 & 0.2995152E-05_JPRB, 0.3705460E-05_JPRB, 0.4955684E-05_JPRB, 0.5840223E-05_JPRB, 0.6808994E-05_JPRB, &
 & 0.7637068E-05_JPRB, 0.8072566E-05_JPRB, 0.8472739E-05_JPRB, 0.8785633E-05_JPRB, 0.9082861E-05_JPRB, &
 & 0.8783771E-05_JPRB, 0.8007679E-05_JPRB, 0.7444976E-05_JPRB, 0.8667521E-05_JPRB, 0.1001028E-04_JPRB, &
 & 0.9730282E-05_JPRB, 0.7358927E-05_JPRB, 0.5605692E-05_JPRB, 0.9000273E-05_JPRB, 0.1483381E-04_JPRB, &
 & 0.1546519E-04_JPRB, 0.1342223E-04_JPRB, 0.1142913E-04_JPRB, 0.1142773E-04_JPRB, 0.1189336E-04_JPRB, &
 & 0.1269055E-04_JPRB, 0.1521436E-04_JPRB, 0.1622249E-04_JPRB, 0.1450292E-04_JPRB, 0.1258747E-04_JPRB, &
 & 0.1118601E-04_JPRB, 0.1046087E-04_JPRB, 0.1042888E-04_JPRB, 0.1318807E-04_JPRB, 0.1757355E-04_JPRB, &
 & 0.1569589E-04_JPRB, 0.8876419E-05_JPRB, 0.3477785E-05_JPRB, 0.6092179E-05_JPRB, 0.1169360E-04_JPRB, &
 & 0.1280658E-04_JPRB, 0.1156909E-04_JPRB, 0.1077928E-04_JPRB, 0.1150577E-04_JPRB, 0.1265658E-04_JPRB, &
 & 0.1216864E-04_JPRB, 0.1071351E-04_JPRB, 0.9272525E-05_JPRB, 0.9172681E-05_JPRB, 0.9266210E-05_JPRB, &
 & 0.8021223E-05_JPRB, 0.5337233E-05_JPRB, 0.2790878E-05_JPRB, 0.5715482E-05_JPRB, 0.8468879E-05_JPRB, &
 & 0.1234670E-04_JPRB, 0.1693622E-04_JPRB, 0.1945495E-04_JPRB, 0.1515071E-04_JPRB, 0.8224375E-05_JPRB, &
 & 0.1201112E-04_JPRB, 0.2331155E-04_JPRB, 0.3526882E-04_JPRB, 0.2870291E-04_JPRB, 0.1563162E-04_JPRB, &
 & 0.1140909E-04_JPRB, 0.1557432E-04_JPRB, 0.1762633E-04_JPRB, 0.1500678E-04_JPRB, 0.1178058E-04_JPRB, &
 & 0.1138556E-04_JPRB, 0.1392922E-04_JPRB, 0.1566068E-04_JPRB, 0.1500365E-04_JPRB, 0.1378532E-04_JPRB, &
 & 0.1177548E-04_JPRB, 0.9777851E-05_JPRB, 0.7775072E-05_JPRB, 0.8716728E-05_JPRB, 0.9806249E-05_JPRB, &
 & 0.1316521E-04_JPRB, 0.1904226E-04_JPRB, 0.2291855E-04_JPRB, 0.2240074E-04_JPRB, 0.2072333E-04_JPRB, &
 & 0.1811899E-04_JPRB, 0.1469667E-04_JPRB, 0.1133881E-04_JPRB, 0.1322723E-04_JPRB, 0.1647023E-04_JPRB, &
 & 0.1916838E-04_JPRB, 0.2205816E-04_JPRB, 0.2387456E-04_JPRB, 0.2335926E-04_JPRB, 0.2209182E-04_JPRB, &
 & 0.1890222E-04_JPRB, 0.1381362E-04_JPRB, 0.9271030E-05_JPRB, 0.5131299E-05_JPRB, 0.1653106E-05_JPRB, &
 & 0.4911985E-05_JPRB, 0.1272395E-04_JPRB, 0.1980745E-04_JPRB, 0.2038804E-04_JPRB, 0.2024396E-04_JPRB, &
 & 0.2059572E-04_JPRB, 0.2124187E-04_JPRB, 0.2100664E-04_JPRB, 0.1594810E-04_JPRB, 0.8547316E-05_JPRB, &
 & 0.9426703E-05_JPRB, 0.1696874E-04_JPRB, 0.2096693E-04_JPRB, 0.1660292E-04_JPRB, 0.1010086E-04_JPRB, &
 & 0.8478976E-05_JPRB, 0.9815730E-05_JPRB, 0.1096572E-04_JPRB, 0.1022864E-04_JPRB, 0.8534034E-05_JPRB, &
 & 0.7089896E-05_JPRB, 0.6877433E-05_JPRB, 0.7622835E-05_JPRB, 0.1016432E-04_JPRB, 0.1179338E-04_JPRB, &
 & 0.1105352E-04_JPRB, 0.9418647E-05_JPRB, 0.7047521E-05_JPRB, 0.2836491E-05_JPRB,-0.3273142E-05_JPRB, &
 &-0.5378550E-05_JPRB,-0.4812351E-05_JPRB,-0.4587549E-05_JPRB, 0.2554223E-06_JPRB, 0.6261604E-05_JPRB, &
 & 0.1238181E-04_JPRB, 0.1535396E-04_JPRB, 0.1632936E-04_JPRB, 0.1245009E-04_JPRB, 0.7953743E-05_JPRB, &
 & 0.7041203E-05_JPRB, 0.8162968E-05_JPRB, 0.8718669E-05_JPRB, 0.4926565E-05_JPRB,-0.3380653E-05_JPRB, &
 &-0.8394464E-05_JPRB,-0.4490310E-05_JPRB, 0.1038037E-05_JPRB, 0.1348030E-04_JPRB, 0.2415614E-04_JPRB, &
 & 0.2358109E-04_JPRB, 0.1487318E-04_JPRB, 0.8895374E-05_JPRB, 0.7548401E-05_JPRB, 0.6078768E-05_JPRB, &
 & 0.6853832E-05_JPRB, 0.9282053E-05_JPRB, 0.1039655E-04_JPRB, 0.1021246E-04_JPRB, 0.8594036E-05_JPRB, &
 & 0.6369831E-05_JPRB, 0.6854452E-05_JPRB, 0.7271157E-05_JPRB, 0.6951013E-05_JPRB, 0.6097368E-05_JPRB, &
 & 0.1010198E-04_JPRB, 0.1231559E-04_JPRB, 0.1322275E-04_JPRB, 0.1709857E-04_JPRB, 0.2124202E-04_JPRB, &
 & 0.1979320E-04_JPRB, 0.1126303E-04_JPRB, 0.4723688E-06_JPRB,-0.7984352E-06_JPRB,-0.7715917E-07_JPRB, &
 &-0.1499937E-05_JPRB,-0.3995374E-05_JPRB,-0.4728345E-05_JPRB, 0.8784824E-05_JPRB, 0.2100014E-04_JPRB, &
 & 0.2723090E-04_JPRB, 0.2794500E-04_JPRB, 0.2646355E-04_JPRB, 0.2066187E-04_JPRB, 0.1373170E-04_JPRB, &
 & 0.8347183E-05_JPRB, 0.3109514E-05_JPRB,-0.3910176E-05_JPRB, 0.5399752E-05_JPRB, 0.2236864E-04_JPRB, &
 & 0.2737938E-04_JPRB, 0.1373889E-04_JPRB,-0.4865972E-05_JPRB,-0.7329967E-05_JPRB,-0.7027517E-05_JPRB, &
 & 0.5835257E-05_JPRB, 0.1728207E-04_JPRB, 0.2252474E-04_JPRB, 0.3336825E-04_JPRB, 0.4236085E-04_JPRB, &
 & 0.3230816E-04_JPRB, 0.8722150E-05_JPRB,-0.9830307E-05_JPRB,-0.4446554E-05_JPRB, 0.7582591E-05_JPRB, &
 & 0.1569976E-04_JPRB, 0.1360494E-04_JPRB, 0.1223443E-04_JPRB, 0.2941493E-04_JPRB, 0.5059241E-04_JPRB, &
 & 0.4548364E-04_JPRB, 0.1569561E-04_JPRB, 0.3601336E-05_JPRB, 0.4300248E-04_JPRB, 0.6058728E-04_JPRB /)
ZCTUV2(301:600) = (/ &
 & 0.5357265E-04_JPRB, 0.3029424E-04_JPRB, 0.1513925E-05_JPRB,-0.1018678E-04_JPRB,-0.2847171E-04_JPRB, &
 &-0.3043390E-04_JPRB,-0.9641391E-05_JPRB, 0.1707224E-04_JPRB, 0.1344189E-04_JPRB, 0.3707683E-05_JPRB, &
 & 0.7901584E-05_JPRB, 0.2753039E-04_JPRB, 0.4065997E-04_JPRB, 0.8414642E-05_JPRB,-0.2501079E-04_JPRB, &
 &-0.1891941E-04_JPRB, 0.1456770E-04_JPRB, 0.3651696E-04_JPRB, 0.2586492E-04_JPRB, 0.1050168E-04_JPRB, &
 & 0.5334877E-06_JPRB,-0.1962072E-04_JPRB,-0.5089322E-04_JPRB,-0.8441173E-04_JPRB,-0.1526737E-03_JPRB, &
 &-0.1566662E-03_JPRB,-0.7777984E-04_JPRB, 0.1420665E-04_JPRB, 0.2271288E-05_JPRB,-0.2627546E-04_JPRB, &
 & 0.1128679E-04_JPRB, 0.1177677E-03_JPRB, 0.1880122E-03_JPRB, 0.1648969E-03_JPRB, 0.1299399E-03_JPRB, &
 & 0.6704369E-04_JPRB,-0.2064946E-04_JPRB,-0.9502823E-04_JPRB,-0.4572404E-04_JPRB, 0.3763052E-04_JPRB, &
 & 0.8176474E-04_JPRB, 0.7521586E-04_JPRB, 0.6640679E-04_JPRB, 0.4663960E-04_JPRB, 0.1536782E-05_JPRB, &
 &-0.1030770E-03_JPRB,-0.2760625E-03_JPRB,-0.6169242E-03_JPRB,-0.3990865E-03_JPRB,-0.2450004E-03_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, &
 & 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB, 0.0000000E+00_JPRB /)

!ZDK250 = (/ &
!ZDTUV1 = (/ &
!ZDTUV2 = (/ &


                                    
! revised 20051031
! TSI UV: 0.1057502799E+03 integrated over the 280-400 nm interval
ZASUVB = (/ &                                                            
 & 0.1251796E+01_JPRB, 0.1800686E+01_JPRB, 0.3127783E+01_JPRB, 0.3057467E+01_JPRB, 0.3225982E+01_JPRB, &
 & 0.3601007E+01_JPRB, 0.3833149E+01_JPRB, 0.3772373E+01_JPRB, 0.3740471E+01_JPRB, 0.5108631E+01_JPRB, &
 & 0.4926397E+01_JPRB, 0.4104165E+01_JPRB, 0.4356608E+01_JPRB, 0.5318757E+01_JPRB, 0.5635120E+01_JPRB, &
 & 0.4680448E+01_JPRB, 0.5237057E+01_JPRB, 0.6325728E+01_JPRB, 0.5219252E+01_JPRB, 0.5970084E+01_JPRB, &
 & 0.4724881E+01_JPRB, 0.4951663E+01_JPRB, 0.5338753E+01_JPRB, 0.6442023E+01_JPRB /)

! TSI UV: 0.1057502799E+03 integrated over the 280-400 nm interval
ZBSUVB = (/ &                                                            
 & 0.6848311E-01_JPRB, 0.2498671E+00_JPRB, 0.3945846E+00_JPRB, 0.3491516E+00_JPRB, 0.1897091E+00_JPRB, &
 & 0.8228300E-01_JPRB, 0.2997684E+00_JPRB, 0.4743167E+00_JPRB, 0.4136641E+00_JPRB, 0.5306536E+00_JPRB, &
 & 0.7163181E+00_JPRB, 0.6737111E+00_JPRB, 0.5750798E+00_JPRB, 0.6513190E+00_JPRB, 0.5113551E+00_JPRB, &
 & 0.6462190E+00_JPRB, 0.5669341E+00_JPRB, 0.6326718E+00_JPRB, 0.4581728E+00_JPRB, 0.7534690E+00_JPRB, &
 & 0.5087756E+00_JPRB, 0.7125608E+00_JPRB, 0.5832244E+00_JPRB, 0.7415306E+00_JPRB, 0.6798909E+00_JPRB, &
 & 0.7188407E+00_JPRB, 0.6775800E+00_JPRB, 0.8080093E+00_JPRB, 0.8375965E+00_JPRB, 0.5589809E+00_JPRB, &
 & 0.7169390E+00_JPRB, 0.8965086E+00_JPRB, 0.7290298E+00_JPRB, 0.8052218E+00_JPRB, 0.6854493E+00_JPRB, &
 & 0.7742989E+00_JPRB, 0.6145189E+00_JPRB, 0.9867508E+00_JPRB, 0.6230114E+00_JPRB, 0.7737931E+00_JPRB, &
 & 0.8929048E+00_JPRB, 0.6839315E+00_JPRB, 0.6537453E+00_JPRB, 0.6464708E+00_JPRB, 0.8634182E+00_JPRB, &
 & 0.9398837E+00_JPRB, 0.1117516E+01_JPRB, 0.1016506E+01_JPRB, 0.9115749E+00_JPRB, 0.1123150E+01_JPRB, &
 & 0.9910813E+00_JPRB, 0.9517728E+00_JPRB, 0.1039072E+01_JPRB, 0.9489145E+00_JPRB, 0.9955564E+00_JPRB, &
 & 0.9388580E+00_JPRB, 0.6909630E+00_JPRB, 0.7680316E+00_JPRB, 0.8123949E+00_JPRB, 0.8939177E+00_JPRB, &
 & 0.9223812E+00_JPRB, 0.8122940E+00_JPRB, 0.8338263E+00_JPRB, 0.9790789E+00_JPRB, 0.8090277E+00_JPRB, &
 & 0.1097064E+01_JPRB, 0.1042524E+01_JPRB, 0.9627741E+00_JPRB, 0.1277082E+01_JPRB, 0.9393126E+00_JPRB, &
 & 0.1239610E+01_JPRB, 0.1066807E+01_JPRB, 0.9717703E+00_JPRB, 0.1129375E+01_JPRB, 0.1227557E+01_JPRB, &
 & 0.1157243E+01_JPRB, 0.9689299E+00_JPRB, 0.8114618E+00_JPRB, 0.6022537E+00_JPRB, 0.1140560E+01_JPRB, &
 & 0.1067406E+01_JPRB, 0.1023137E+01_JPRB, 0.1176517E+01_JPRB, 0.9235301E+00_JPRB, 0.1046466E+01_JPRB, &
 & 0.1342558E+01_JPRB, 0.1303960E+01_JPRB, 0.1248713E+01_JPRB, 0.1120003E+01_JPRB, 0.1310493E+01_JPRB, &
 & 0.1126627E+01_JPRB, 0.1383549E+01_JPRB, 0.9327253E+00_JPRB, 0.8592345E+00_JPRB, 0.9171154E+00_JPRB, &
 & 0.1090722E+01_JPRB, 0.1083875E+01_JPRB, 0.1342697E+01_JPRB, 0.1462411E+01_JPRB, 0.9903797E+00_JPRB, &
 & 0.1264847E+01_JPRB, 0.1143896E+01_JPRB, 0.6993406E+00_JPRB, 0.6519147E+00_JPRB, 0.9648829E+00_JPRB, &
 & 0.9177119E+00_JPRB, 0.9760993E+00_JPRB, 0.8564172E+00_JPRB, 0.8915388E+00_JPRB, 0.1309896E+01_JPRB, &
 & 0.1252062E+01_JPRB, 0.1518355E+01_JPRB, 0.1037630E+01_JPRB, 0.3918341E+00_JPRB, 0.1138872E+01_JPRB, &
 & 0.1384648E+01_JPRB, 0.7875828E+00_JPRB, 0.9430014E+00_JPRB, 0.1651466E+01_JPRB, 0.1675324E+01_JPRB /)

! TSI UV: 0.1057502799E+03 integrated over the 280-400 nm interval
ZCSUVB(  1:300) = (/ &
 & 0.1158150E-01_JPRB, 0.4307253E-02_JPRB, 0.8679530E-02_JPRB, 0.1612620E-01_JPRB, 0.2778863E-01_JPRB, &
 & 0.3575870E-01_JPRB, 0.3593124E-01_JPRB, 0.5114494E-01_JPRB, 0.6681306E-01_JPRB, 0.6021919E-01_JPRB, &
 & 0.8154579E-01_JPRB, 0.6622351E-01_JPRB, 0.8759850E-01_JPRB, 0.7109950E-01_JPRB, 0.8811727E-01_JPRB, &
 & 0.7734752E-01_JPRB, 0.6886194E-01_JPRB, 0.7562198E-01_JPRB, 0.5066989E-01_JPRB, 0.7665027E-01_JPRB, &
 & 0.5342708E-01_JPRB, 0.5731519E-01_JPRB, 0.3119192E-01_JPRB, 0.2780394E-01_JPRB, 0.1997097E-01_JPRB, &
 & 0.1199952E-01_JPRB, 0.3781212E-02_JPRB, 0.1343422E-01_JPRB, 0.2034198E-01_JPRB, 0.3272607E-01_JPRB, &
 & 0.4846868E-01_JPRB, 0.5698028E-01_JPRB, 0.7398895E-01_JPRB, 0.4847769E-01_JPRB, 0.7185277E-01_JPRB, &
 & 0.9515611E-01_JPRB, 0.1128814E+00_JPRB, 0.9564205E-01_JPRB, 0.7717521E-01_JPRB, 0.9346189E-01_JPRB, &
 & 0.4597404E-01_JPRB, 0.3428929E-01_JPRB, 0.1077923E+00_JPRB, 0.1154901E+00_JPRB, 0.1101183E+00_JPRB, &
 & 0.9279595E-01_JPRB, 0.9740494E-01_JPRB, 0.7512583E-01_JPRB, 0.1420005E+00_JPRB, 0.1233264E+00_JPRB, &
 & 0.1506065E+00_JPRB, 0.1314347E+00_JPRB, 0.1466181E+00_JPRB, 0.1625762E+00_JPRB, 0.1250826E+00_JPRB, &
 & 0.1025410E+00_JPRB, 0.1180653E+00_JPRB, 0.1372793E+00_JPRB, 0.1567150E+00_JPRB, 0.1591106E+00_JPRB, &
 & 0.1509978E+00_JPRB, 0.1523881E+00_JPRB, 0.1050467E+00_JPRB, 0.8648758E-01_JPRB, 0.8015965E-01_JPRB, &
 & 0.1484698E+00_JPRB, 0.1179774E+00_JPRB, 0.1492430E+00_JPRB, 0.1174614E+00_JPRB, 0.1181674E+00_JPRB, &
 & 0.1251424E+00_JPRB, 0.1001071E+00_JPRB, 0.9280812E-01_JPRB, 0.1512694E+00_JPRB, 0.4202820E-01_JPRB, &
 & 0.1189204E+00_JPRB, 0.1582238E+00_JPRB, 0.9405126E-01_JPRB, 0.1425538E+00_JPRB, 0.1324698E+00_JPRB, &
 & 0.1597341E+00_JPRB, 0.1710007E+00_JPRB, 0.8407424E-01_JPRB, 0.5323930E-01_JPRB, 0.9888584E-01_JPRB, &
 & 0.6824519E-01_JPRB, 0.1120127E+00_JPRB, 0.1361283E+00_JPRB, 0.1293499E+00_JPRB, 0.1869357E+00_JPRB, &
 & 0.1177258E+00_JPRB, 0.9133044E-01_JPRB, 0.4441319E-01_JPRB, 0.9906802E-01_JPRB, 0.1056354E+00_JPRB, &
 & 0.1822143E+00_JPRB, 0.1713972E+00_JPRB, 0.6409213E-01_JPRB, 0.1762541E+00_JPRB, 0.1595112E+00_JPRB, &
 & 0.4608663E-01_JPRB, 0.6802742E-01_JPRB, 0.1393778E+00_JPRB, 0.1646635E+00_JPRB, 0.9062016E-01_JPRB, &
 & 0.1500694E+00_JPRB, 0.1700569E+00_JPRB, 0.1527697E+00_JPRB, 0.1529162E+00_JPRB, 0.8674857E-01_JPRB, &
 & 0.4436884E-01_JPRB, 0.1046963E+00_JPRB, 0.1463353E+00_JPRB, 0.8535615E-01_JPRB, 0.2024678E+00_JPRB, &
 & 0.1631171E+00_JPRB, 0.1501661E+00_JPRB, 0.1783627E+00_JPRB, 0.1560721E+00_JPRB, 0.9381256E-01_JPRB, &
 & 0.1548443E+00_JPRB, 0.1065238E+00_JPRB, 0.1752939E+00_JPRB, 0.1560214E+00_JPRB, 0.8720748E-01_JPRB, &
 & 0.1526506E+00_JPRB, 0.2124056E+00_JPRB, 0.1212607E+00_JPRB, 0.1718601E+00_JPRB, 0.6066382E-01_JPRB, &
 & 0.1302736E+00_JPRB, 0.1977617E+00_JPRB, 0.1057830E+00_JPRB, 0.1346538E+00_JPRB, 0.1091080E+00_JPRB, &
 & 0.1827814E+00_JPRB, 0.1490962E+00_JPRB, 0.1923628E+00_JPRB, 0.1350661E+00_JPRB, 0.1487027E+00_JPRB, &
 & 0.1854675E+00_JPRB, 0.1422262E+00_JPRB, 0.1845453E+00_JPRB, 0.1926982E+00_JPRB, 0.1326593E+00_JPRB, &
 & 0.9339384E-01_JPRB, 0.7605023E-01_JPRB, 0.1398333E+00_JPRB, 0.1053312E+00_JPRB, 0.1443723E+00_JPRB, &
 & 0.4935243E-01_JPRB, 0.1231221E+00_JPRB, 0.1592260E+00_JPRB, 0.1695701E+00_JPRB, 0.2156683E+00_JPRB, &
 & 0.1872401E+00_JPRB, 0.2222135E+00_JPRB, 0.1774713E+00_JPRB, 0.1779839E+00_JPRB, 0.1315997E+00_JPRB, &
 & 0.1245990E+00_JPRB, 0.1306088E+00_JPRB, 0.1570354E+00_JPRB, 0.1659742E+00_JPRB, 0.1508124E+00_JPRB, &
 & 0.1550767E+00_JPRB, 0.1582761E+00_JPRB, 0.1203409E+00_JPRB, 0.1615870E+00_JPRB, 0.2099411E+00_JPRB, &
 & 0.1686777E+00_JPRB, 0.1619672E+00_JPRB, 0.5918952E-01_JPRB, 0.1481797E+00_JPRB, 0.1474352E+00_JPRB, &
 & 0.1851919E+00_JPRB, 0.1679120E+00_JPRB, 0.1998436E+00_JPRB, 0.1389546E+00_JPRB, 0.8239684E-01_JPRB, &
 & 0.1047535E+00_JPRB, 0.9949701E-01_JPRB, 0.1487465E+00_JPRB, 0.1276272E+00_JPRB, 0.1338947E+00_JPRB, &
 & 0.1867179E+00_JPRB, 0.2201701E+00_JPRB, 0.1779457E+00_JPRB, 0.2388429E+00_JPRB, 0.1630742E+00_JPRB, &
 & 0.1068201E+00_JPRB, 0.8450688E-01_JPRB, 0.1127901E+00_JPRB, 0.1274841E+00_JPRB, 0.1914103E+00_JPRB, &
 & 0.2002285E+00_JPRB, 0.9097867E-01_JPRB, 0.1278886E+00_JPRB, 0.1344432E+00_JPRB, 0.2202541E+00_JPRB, &
 & 0.1482008E+00_JPRB, 0.1469951E+00_JPRB, 0.2015719E+00_JPRB, 0.1878379E+00_JPRB, 0.2082990E+00_JPRB, &
 & 0.1017584E+00_JPRB, 0.1451019E+00_JPRB, 0.7703697E-01_JPRB, 0.1780647E+00_JPRB, 0.1819695E+00_JPRB, &
 & 0.1600806E+00_JPRB, 0.1267505E+00_JPRB, 0.1588537E+00_JPRB, 0.9667448E-01_JPRB, 0.1113860E+00_JPRB, &
 & 0.9133881E-01_JPRB, 0.1729763E+00_JPRB, 0.1181825E+00_JPRB, 0.1292425E+00_JPRB, 0.1347307E+00_JPRB, &
 & 0.1512866E+00_JPRB, 0.1808238E+00_JPRB, 0.1699806E+00_JPRB, 0.2193174E+00_JPRB, 0.1420098E+00_JPRB, &
 & 0.1576642E+00_JPRB, 0.1784694E+00_JPRB, 0.1526431E+00_JPRB, 0.2519739E+00_JPRB, 0.1991331E+00_JPRB, &
 & 0.2155590E+00_JPRB, 0.2423780E+00_JPRB, 0.2025711E+00_JPRB, 0.2256757E+00_JPRB, 0.2313318E+00_JPRB, &
 & 0.1832516E+00_JPRB, 0.2300989E+00_JPRB, 0.2196651E+00_JPRB, 0.2103950E+00_JPRB, 0.1730957E+00_JPRB, &
 & 0.1979747E+00_JPRB, 0.1740626E+00_JPRB, 0.1905000E+00_JPRB, 0.1610193E+00_JPRB, 0.1880183E+00_JPRB, &
 & 0.2203149E+00_JPRB, 0.2412104E+00_JPRB, 0.2545475E+00_JPRB, 0.1662324E+00_JPRB, 0.2408452E+00_JPRB, &
 & 0.2558326E+00_JPRB, 0.1969197E+00_JPRB, 0.2039628E+00_JPRB, 0.1443392E+00_JPRB, 0.1900270E+00_JPRB, &
 & 0.2009350E+00_JPRB, 0.1847773E+00_JPRB, 0.1558351E+00_JPRB, 0.1924818E+00_JPRB, 0.2177436E+00_JPRB, &
 & 0.2086823E+00_JPRB, 0.1804881E+00_JPRB, 0.2275202E+00_JPRB, 0.2078572E+00_JPRB, 0.2145247E+00_JPRB, &
 & 0.1762646E+00_JPRB, 0.2206831E+00_JPRB, 0.2270376E+00_JPRB, 0.1269940E+00_JPRB, 0.1979352E+00_JPRB, &
 & 0.2014534E+00_JPRB, 0.2058836E+00_JPRB, 0.2000303E+00_JPRB, 0.1874826E+00_JPRB, 0.2007064E+00_JPRB, &
 & 0.1420998E+00_JPRB, 0.2326092E+00_JPRB, 0.2102334E+00_JPRB, 0.2060209E+00_JPRB, 0.1478948E+00_JPRB, &
 & 0.6166791E-01_JPRB, 0.9824482E-01_JPRB, 0.2134419E+00_JPRB, 0.1737989E+00_JPRB, 0.1438094E+00_JPRB, &
 & 0.9751125E-01_JPRB, 0.9984105E-01_JPRB, 0.1418594E+00_JPRB, 0.2413629E+00_JPRB, 0.1874570E+00_JPRB, &
 & 0.1152467E+00_JPRB, 0.1874475E+00_JPRB, 0.1836579E+00_JPRB, 0.1809469E+00_JPRB, 0.1450959E+00_JPRB, &
 & 0.2264130E+00_JPRB, 0.1111494E+00_JPRB, 0.1591455E+00_JPRB, 0.1895232E+00_JPRB, 0.2076865E+00_JPRB /)
ZCSUVB(301:600) = (/ &
 & 0.2530582E+00_JPRB, 0.1691832E+00_JPRB, 0.1673257E+00_JPRB, 0.1651305E+00_JPRB, 0.1676837E+00_JPRB, &
 & 0.1801740E+00_JPRB, 0.1678922E+00_JPRB, 0.1142739E+00_JPRB, 0.1588322E+00_JPRB, 0.1911218E+00_JPRB, &
 & 0.2137500E+00_JPRB, 0.1589394E+00_JPRB, 0.1462175E+00_JPRB, 0.1521134E+00_JPRB, 0.1628060E+00_JPRB, &
 & 0.2311198E+00_JPRB, 0.1948069E+00_JPRB, 0.1652501E+00_JPRB, 0.1950638E+00_JPRB, 0.1928383E+00_JPRB, &
 & 0.1185256E+00_JPRB, 0.1315500E+00_JPRB, 0.1481399E+00_JPRB, 0.1733126E+00_JPRB, 0.2374996E+00_JPRB, &
 & 0.2374471E+00_JPRB, 0.1786689E+00_JPRB, 0.2087820E+00_JPRB, 0.2633031E+00_JPRB, 0.2088632E+00_JPRB, &
 & 0.2220497E+00_JPRB, 0.1871010E+00_JPRB, 0.2358347E+00_JPRB, 0.1865678E+00_JPRB, 0.2109712E+00_JPRB, &
 & 0.2466503E+00_JPRB, 0.2067040E+00_JPRB, 0.2054577E+00_JPRB, 0.1018214E+00_JPRB, 0.2021408E+00_JPRB, &
 & 0.2510176E+00_JPRB, 0.2619543E+00_JPRB, 0.2186540E+00_JPRB, 0.2692426E+00_JPRB, 0.2762131E+00_JPRB, &
 & 0.1443544E+00_JPRB, 0.2331391E+00_JPRB, 0.2068319E+00_JPRB, 0.1624159E+00_JPRB, 0.1925712E+00_JPRB, &
 & 0.2315444E+00_JPRB, 0.2675816E+00_JPRB, 0.2617563E+00_JPRB, 0.2397498E+00_JPRB, 0.2389780E+00_JPRB, &
 & 0.2017490E+00_JPRB, 0.2164805E+00_JPRB, 0.1560795E+00_JPRB, 0.2334687E+00_JPRB, 0.2590291E+00_JPRB, &
 & 0.2519819E+00_JPRB, 0.2069263E+00_JPRB, 0.1131312E+00_JPRB, 0.1501324E+00_JPRB, 0.2495983E+00_JPRB, &
 & 0.2326745E+00_JPRB, 0.2538886E+00_JPRB, 0.2257110E+00_JPRB, 0.2008390E+00_JPRB, 0.2162623E+00_JPRB, &
 & 0.2815691E+00_JPRB, 0.2071696E+00_JPRB, 0.2931835E+00_JPRB, 0.2567119E+00_JPRB, 0.1889232E+00_JPRB, &
 & 0.2792606E+00_JPRB, 0.2335529E+00_JPRB, 0.1652571E+00_JPRB, 0.2136573E+00_JPRB, 0.2655147E+00_JPRB, &
 & 0.2021998E+00_JPRB, 0.2492024E+00_JPRB, 0.2237493E+00_JPRB, 0.9668919E-01_JPRB, 0.1970893E+00_JPRB, &
 & 0.9243014E-01_JPRB, 0.1704992E+00_JPRB, 0.1867496E+00_JPRB, 0.1740344E+00_JPRB, 0.1877484E+00_JPRB, &
 & 0.1485550E+00_JPRB, 0.9281972E-01_JPRB, 0.1346586E+00_JPRB, 0.8005841E-01_JPRB, 0.1461620E+00_JPRB, &
 & 0.1703585E+00_JPRB, 0.2748065E+00_JPRB, 0.2135569E+00_JPRB, 0.2206926E+00_JPRB, 0.2611456E+00_JPRB, &
 & 0.3002764E+00_JPRB, 0.2001613E+00_JPRB, 0.1852186E+00_JPRB, 0.1820937E+00_JPRB, 0.1996564E+00_JPRB, &
 & 0.1438404E+00_JPRB, 0.2192468E+00_JPRB, 0.2426639E+00_JPRB, 0.2698561E+00_JPRB, 0.1475303E+00_JPRB, &
 & 0.1369558E+00_JPRB, 0.2283586E+00_JPRB, 0.1959572E+00_JPRB, 0.3457803E+00_JPRB, 0.2694656E+00_JPRB, &
 & 0.1617160E+00_JPRB, 0.1227123E+00_JPRB, 0.2226935E+00_JPRB, 0.1845919E+00_JPRB, 0.2318165E+00_JPRB, &
 & 0.2967969E+00_JPRB, 0.2018478E+00_JPRB, 0.1869166E+00_JPRB, 0.2005376E+00_JPRB, 0.1603670E+00_JPRB, &
 & 0.2054483E+00_JPRB, 0.2567736E+00_JPRB, 0.2826306E+00_JPRB, 0.2930521E+00_JPRB, 0.3046532E+00_JPRB, &
 & 0.2922131E+00_JPRB, 0.2425442E+00_JPRB, 0.2202092E+00_JPRB, 0.3031651E+00_JPRB, 0.2458283E+00_JPRB, &
 & 0.2005188E+00_JPRB, 0.3134617E+00_JPRB, 0.2558356E+00_JPRB, 0.2571902E+00_JPRB, 0.2217072E+00_JPRB, &
 & 0.2084442E+00_JPRB, 0.2559362E+00_JPRB, 0.2557498E+00_JPRB, 0.2190597E+00_JPRB, 0.1808136E+00_JPRB, &
 & 0.2219874E+00_JPRB, 0.3175022E+00_JPRB, 0.2378181E+00_JPRB, 0.2659648E+00_JPRB, 0.2672206E+00_JPRB, &
 & 0.2852412E+00_JPRB, 0.2738525E+00_JPRB, 0.2187990E+00_JPRB, 0.1703537E+00_JPRB, 0.1783808E+00_JPRB, &
 & 0.1845599E+00_JPRB, 0.2636097E+00_JPRB, 0.3560195E+00_JPRB, 0.3115435E+00_JPRB, 0.2678166E+00_JPRB, &
 & 0.1147860E+00_JPRB, 0.1107158E+00_JPRB, 0.2578273E+00_JPRB, 0.2698551E+00_JPRB, 0.1795411E+00_JPRB, &
 & 0.2748137E+00_JPRB, 0.2236250E+00_JPRB, 0.9111431E-01_JPRB, 0.1095607E+00_JPRB, 0.1601207E+00_JPRB, &
 & 0.2477373E+00_JPRB, 0.2842807E+00_JPRB, 0.1589658E+00_JPRB, 0.1025690E+00_JPRB, 0.1235626E+00_JPRB, &
 & 0.1114009E+00_JPRB, 0.2359608E+00_JPRB, 0.2825647E+00_JPRB, 0.3238992E+00_JPRB, 0.1368962E+00_JPRB, &
 & 0.2139942E+00_JPRB, 0.2490571E+00_JPRB, 0.1949766E+00_JPRB, 0.2244310E+00_JPRB, 0.2014157E+00_JPRB, &
 & 0.2007936E+00_JPRB, 0.2693866E+00_JPRB, 0.2962085E+00_JPRB, 0.2980880E+00_JPRB, 0.2782205E+00_JPRB, &
 & 0.3581445E+00_JPRB, 0.3251818E+00_JPRB, 0.3322366E+00_JPRB, 0.2409279E+00_JPRB, 0.2059198E+00_JPRB, &
 & 0.1942687E+00_JPRB, 0.2585852E+00_JPRB, 0.1726274E+00_JPRB, 0.2225615E+00_JPRB, 0.1423369E+00_JPRB, &
 & 0.2277843E+00_JPRB, 0.2619196E+00_JPRB, 0.3190190E+00_JPRB, 0.2141752E+00_JPRB, 0.2419485E+00_JPRB, &
 & 0.3032540E+00_JPRB, 0.2357463E+00_JPRB, 0.1822032E+00_JPRB, 0.1373469E+00_JPRB, 0.2853460E+00_JPRB, &
 & 0.1031687E+00_JPRB, 0.1750166E+00_JPRB, 0.1704368E+00_JPRB, 0.1019661E+00_JPRB, 0.1487524E+00_JPRB, &
 & 0.1650886E+00_JPRB, 0.1164109E+00_JPRB, 0.1054042E+00_JPRB, 0.1594288E+00_JPRB, 0.1055822E+00_JPRB, &
 & 0.1176607E+00_JPRB, 0.1849293E+00_JPRB, 0.2224796E+00_JPRB, 0.1783373E+00_JPRB, 0.2614759E+00_JPRB, &
 & 0.1500050E+00_JPRB, 0.2488365E+00_JPRB, 0.1675993E+00_JPRB, 0.1911893E+00_JPRB, 0.1600818E+00_JPRB, &
 & 0.9722187E-01_JPRB, 0.1919937E+00_JPRB, 0.2495219E+00_JPRB, 0.2255473E+00_JPRB, 0.2118145E+00_JPRB, &
 & 0.1620823E+00_JPRB, 0.1034425E+00_JPRB, 0.2278996E+00_JPRB, 0.2416400E+00_JPRB, 0.1213528E+00_JPRB, &
 & 0.2125401E+00_JPRB, 0.1247030E+00_JPRB, 0.2620897E+00_JPRB, 0.1179802E+00_JPRB, 0.1742258E+00_JPRB, &
 & 0.1820025E+00_JPRB, 0.3155541E+00_JPRB, 0.2765884E+00_JPRB, 0.2444874E+00_JPRB, 0.2912637E+00_JPRB, &
 & 0.2198656E+00_JPRB, 0.2843479E+00_JPRB, 0.2241306E+00_JPRB, 0.2015474E+00_JPRB, 0.3221704E+00_JPRB, &
 & 0.2833514E+00_JPRB, 0.3601597E+00_JPRB, 0.2911269E+00_JPRB, 0.2972085E+00_JPRB, 0.2865082E+00_JPRB, &
 & 0.2065020E+00_JPRB, 0.2025947E+00_JPRB, 0.2778561E+00_JPRB, 0.2096391E+00_JPRB, 0.1410383E+00_JPRB, &
 & 0.9857938E-01_JPRB, 0.6269173E-01_JPRB, 0.2530281E-01_JPRB, 0.7657863E-01_JPRB, 0.1286815E+00_JPRB, &
 & 0.2086445E+00_JPRB, 0.2141411E+00_JPRB, 0.1877717E+00_JPRB, 0.2910647E+00_JPRB, 0.2372502E+00_JPRB, &
 & 0.2744186E+00_JPRB, 0.2735835E+00_JPRB, 0.2960536E+00_JPRB, 0.2737275E+00_JPRB, 0.2668652E+00_JPRB, &
 & 0.3166273E+00_JPRB, 0.1598142E+00_JPRB, 0.1693170E+00_JPRB, 0.9992833E-01_JPRB, 0.4189600E-01_JPRB, &
 & 0.7145026E-01_JPRB, 0.1279196E+00_JPRB, 0.1842234E+00_JPRB, 0.2720304E+00_JPRB, 0.2873777E+00_JPRB, &
 & 0.3626651E+00_JPRB, 0.2933673E+00_JPRB, 0.3022911E+00_JPRB, 0.3212442E+00_JPRB, 0.3718986E+00_JPRB, &
 & 0.3289628E+00_JPRB, 0.3477682E+00_JPRB, 0.3787437E+00_JPRB, 0.3112315E+00_JPRB, 0.3086174E+00_JPRB /)

!ZDSUVB = (/ &
                                               
!          Rayleigh cross-sections from Bodhaine et al., 1999
! NB: values in cm2, so tau = RAYUVB * Pressure * Avogadro / ( m_a * grav )
!     Pressure: N cm-1 s-2
!     Avogadro: Avog number (mol-1)
!     m_a     : dry air mean molecular weight ( g mol-1 )
!     grav    : gravity ( cm s-2) 

! revised 20051031
!Rayl: 0.3293000611E-25 sun-weighted over the 280-400 nm interval
ZARAYUV = (/ &                                                           
 & 0.7306844E-25_JPRB, 0.6736580E-25_JPRB, 0.6322517E-25_JPRB, 0.5858758E-25_JPRB, 0.5445114E-25_JPRB, &
 & 0.5087498E-25_JPRB, 0.4744089E-25_JPRB, 0.4430921E-25_JPRB, 0.4145744E-25_JPRB, 0.3880453E-25_JPRB, &
 & 0.3640141E-25_JPRB, 0.3414811E-25_JPRB, 0.3210803E-25_JPRB, 0.3019948E-25_JPRB, 0.2842767E-25_JPRB, &
 & 0.2681506E-25_JPRB, 0.2527365E-25_JPRB, 0.2386328E-25_JPRB, 0.2259065E-25_JPRB, 0.2130931E-25_JPRB, &
 & 0.2022461E-25_JPRB, 0.1907690E-25_JPRB, 0.1816129E-25_JPRB, 0.1714296E-25_JPRB /)

!Rayl: 0.3293000611E-25 sun-weighted over the 280-400 nm interval
ZBRAYUV = (/ &                                                           
 & 0.7553307E-25_JPRB, 0.7443457E-25_JPRB, 0.7335825E-25_JPRB, 0.7226265E-25_JPRB, 0.7125960E-25_JPRB, &
 & 0.6991365E-25_JPRB, 0.6898332E-25_JPRB, 0.6798154E-25_JPRB, 0.6684466E-25_JPRB, 0.6591285E-25_JPRB, &
 & 0.6496839E-25_JPRB, 0.6396853E-25_JPRB, 0.6313266E-25_JPRB, 0.6216223E-25_JPRB, 0.6126177E-25_JPRB, &
 & 0.6032645E-25_JPRB, 0.5953125E-25_JPRB, 0.5853245E-25_JPRB, 0.5775356E-25_JPRB, 0.5693963E-25_JPRB, &
 & 0.5606095E-25_JPRB, 0.5534949E-25_JPRB, 0.5444878E-25_JPRB, 0.5378845E-25_JPRB, 0.5302978E-25_JPRB, &
 & 0.5231385E-25_JPRB, 0.5155581E-25_JPRB, 0.5083396E-25_JPRB, 0.5011746E-25_JPRB, 0.4939369E-25_JPRB, &
 & 0.4866159E-25_JPRB, 0.4809942E-25_JPRB, 0.4740003E-25_JPRB, 0.4675913E-25_JPRB, 0.4614712E-25_JPRB, &
 & 0.4555732E-25_JPRB, 0.4489270E-25_JPRB, 0.4430247E-25_JPRB, 0.4366891E-25_JPRB, 0.4312100E-25_JPRB, &
 & 0.4253825E-25_JPRB, 0.4196292E-25_JPRB, 0.4146292E-25_JPRB, 0.4089423E-25_JPRB, 0.4035688E-25_JPRB, &
 & 0.3982210E-25_JPRB, 0.3931992E-25_JPRB, 0.3881491E-25_JPRB, 0.3831836E-25_JPRB, 0.3782540E-25_JPRB, &
 & 0.3735359E-25_JPRB, 0.3685556E-25_JPRB, 0.3638909E-25_JPRB, 0.3593377E-25_JPRB, 0.3547793E-25_JPRB, &
 & 0.3502970E-25_JPRB, 0.3455926E-25_JPRB, 0.3412171E-25_JPRB, 0.3372662E-25_JPRB, 0.3331015E-25_JPRB, &
 & 0.3291422E-25_JPRB, 0.3249210E-25_JPRB, 0.3210885E-25_JPRB, 0.3170751E-25_JPRB, 0.3128713E-25_JPRB, &
 & 0.3093283E-25_JPRB, 0.3055725E-25_JPRB, 0.3020082E-25_JPRB, 0.2981950E-25_JPRB, 0.2946112E-25_JPRB, &
 & 0.2911369E-25_JPRB, 0.2875635E-25_JPRB, 0.2842758E-25_JPRB, 0.2809044E-25_JPRB, 0.2775960E-25_JPRB, &
 & 0.2742853E-25_JPRB, 0.2711246E-25_JPRB, 0.2676895E-25_JPRB, 0.2647165E-25_JPRB, 0.2615410E-25_JPRB, &
 & 0.2587241E-25_JPRB, 0.2555613E-25_JPRB, 0.2524211E-25_JPRB, 0.2495965E-25_JPRB, 0.2469929E-25_JPRB, &
 & 0.2439028E-25_JPRB, 0.2412799E-25_JPRB, 0.2385009E-25_JPRB, 0.2358339E-25_JPRB, 0.2331176E-25_JPRB, &
 & 0.2306411E-25_JPRB, 0.2278344E-25_JPRB, 0.2251960E-25_JPRB, 0.2230511E-25_JPRB, 0.2205796E-25_JPRB, &
 & 0.2178428E-25_JPRB, 0.2154956E-25_JPRB, 0.2130606E-25_JPRB, 0.2108947E-25_JPRB, 0.2085232E-25_JPRB, &
 & 0.2061758E-25_JPRB, 0.2039777E-25_JPRB, 0.2017122E-25_JPRB, 0.1995736E-25_JPRB, 0.1972342E-25_JPRB, &
 & 0.1952774E-25_JPRB, 0.1930078E-25_JPRB, 0.1910372E-25_JPRB, 0.1890537E-25_JPRB, 0.1869344E-25_JPRB, &
 & 0.1849739E-25_JPRB, 0.1830610E-25_JPRB, 0.1811516E-25_JPRB, 0.1791227E-25_JPRB, 0.1772642E-25_JPRB, &
 & 0.1754530E-25_JPRB, 0.1739054E-25_JPRB, 0.1715780E-25_JPRB, 0.1699967E-25_JPRB, 0.1682695E-25_JPRB /)

!Rayl: 0.3293000611E-25 sun-weighted over the 280-400 nm interval
ZCRAYUV(  1:300) = (/ &
 & 0.7616638E-25_JPRB, 0.7596217E-25_JPRB, 0.7566579E-25_JPRB, 0.7545073E-25_JPRB, 0.7520894E-25_JPRB, &
 & 0.7498396E-25_JPRB, 0.7474992E-25_JPRB, 0.7449660E-25_JPRB, 0.7426870E-25_JPRB, 0.7405151E-25_JPRB, &
 & 0.7382129E-25_JPRB, 0.7359474E-25_JPRB, 0.7336698E-25_JPRB, 0.7312532E-25_JPRB, 0.7293129E-25_JPRB, &
 & 0.7270750E-25_JPRB, 0.7246929E-25_JPRB, 0.7225889E-25_JPRB, 0.7201327E-25_JPRB, 0.7179669E-25_JPRB, &
 & 0.7159132E-25_JPRB, 0.7137091E-25_JPRB, 0.7112686E-25_JPRB, 0.7092680E-25_JPRB, 0.7072331E-25_JPRB, &
 & 0.7050776E-25_JPRB, 0.7027431E-25_JPRB, 0.7005233E-25_JPRB, 0.6984647E-25_JPRB, 0.6963897E-25_JPRB, &
 & 0.6943879E-25_JPRB, 0.6922317E-25_JPRB, 0.6899903E-25_JPRB, 0.6880721E-25_JPRB, 0.6858853E-25_JPRB, &
 & 0.6837090E-25_JPRB, 0.6817655E-25_JPRB, 0.6795759E-25_JPRB, 0.6775398E-25_JPRB, 0.6756201E-25_JPRB, &
 & 0.6737114E-25_JPRB, 0.6711798E-25_JPRB, 0.6694924E-25_JPRB, 0.6673852E-25_JPRB, 0.6654869E-25_JPRB, &
 & 0.6633041E-25_JPRB, 0.6614539E-25_JPRB, 0.6595648E-25_JPRB, 0.6575899E-25_JPRB, 0.6556557E-25_JPRB, &
 & 0.6535321E-25_JPRB, 0.6515833E-25_JPRB, 0.6496196E-25_JPRB, 0.6476328E-25_JPRB, 0.6457961E-25_JPRB, &
 & 0.6441038E-25_JPRB, 0.6419320E-25_JPRB, 0.6400914E-25_JPRB, 0.6382210E-25_JPRB, 0.6362626E-25_JPRB, &
 & 0.6343807E-25_JPRB, 0.6325313E-25_JPRB, 0.6305017E-25_JPRB, 0.6287837E-25_JPRB, 0.6271078E-25_JPRB, &
 & 0.6250013E-25_JPRB, 0.6232995E-25_JPRB, 0.6213345E-25_JPRB, 0.6199295E-25_JPRB, 0.6177485E-25_JPRB, &
 & 0.6158079E-25_JPRB, 0.6138453E-25_JPRB, 0.6123282E-25_JPRB, 0.6104834E-25_JPRB, 0.6085159E-25_JPRB, &
 & 0.6068199E-25_JPRB, 0.6050634E-25_JPRB, 0.6031437E-25_JPRB, 0.6016957E-25_JPRB, 0.5996980E-25_JPRB, &
 & 0.5980282E-25_JPRB, 0.5962179E-25_JPRB, 0.5947632E-25_JPRB, 0.5930616E-25_JPRB, 0.5910388E-25_JPRB, &
 & 0.5893103E-25_JPRB, 0.5879395E-25_JPRB, 0.5857085E-25_JPRB, 0.5842694E-25_JPRB, 0.5827528E-25_JPRB, &
 & 0.5809260E-25_JPRB, 0.5791326E-25_JPRB, 0.5774750E-25_JPRB, 0.5757388E-25_JPRB, 0.5740871E-25_JPRB, &
 & 0.5725365E-25_JPRB, 0.5709284E-25_JPRB, 0.5695706E-25_JPRB, 0.5675827E-25_JPRB, 0.5660968E-25_JPRB, &
 & 0.5644708E-25_JPRB, 0.5629105E-25_JPRB, 0.5610676E-25_JPRB, 0.5597107E-25_JPRB, 0.5578470E-25_JPRB, &
 & 0.5561693E-25_JPRB, 0.5547664E-25_JPRB, 0.5532939E-25_JPRB, 0.5515983E-25_JPRB, 0.5500726E-25_JPRB, &
 & 0.5488026E-25_JPRB, 0.5466552E-25_JPRB, 0.5453631E-25_JPRB, 0.5435469E-25_JPRB, 0.5421854E-25_JPRB, &
 & 0.5406856E-25_JPRB, 0.5390386E-25_JPRB, 0.5376519E-25_JPRB, 0.5362250E-25_JPRB, 0.5343698E-25_JPRB, &
 & 0.5331479E-25_JPRB, 0.5315746E-25_JPRB, 0.5301434E-25_JPRB, 0.5286928E-25_JPRB, 0.5268597E-25_JPRB, &
 & 0.5257406E-25_JPRB, 0.5240588E-25_JPRB, 0.5227215E-25_JPRB, 0.5212194E-25_JPRB, 0.5196392E-25_JPRB, &
 & 0.5181440E-25_JPRB, 0.5168025E-25_JPRB, 0.5153224E-25_JPRB, 0.5140691E-25_JPRB, 0.5122811E-25_JPRB, &
 & 0.5110644E-25_JPRB, 0.5097039E-25_JPRB, 0.5081770E-25_JPRB, 0.5066004E-25_JPRB, 0.5054125E-25_JPRB, &
 & 0.5039219E-25_JPRB, 0.5023992E-25_JPRB, 0.5009734E-25_JPRB, 0.4998271E-25_JPRB, 0.4982583E-25_JPRB, &
 & 0.4969272E-25_JPRB, 0.4957173E-25_JPRB, 0.4941637E-25_JPRB, 0.4930264E-25_JPRB, 0.4915094E-25_JPRB, &
 & 0.4900671E-25_JPRB, 0.4884935E-25_JPRB, 0.4873834E-25_JPRB, 0.4859938E-25_JPRB, 0.4846769E-25_JPRB, &
 & 0.4834488E-25_JPRB, 0.4820086E-25_JPRB, 0.4807528E-25_JPRB, 0.4794680E-25_JPRB, 0.4781788E-25_JPRB, &
 & 0.4766772E-25_JPRB, 0.4754919E-25_JPRB, 0.4741631E-25_JPRB, 0.4728048E-25_JPRB, 0.4716431E-25_JPRB, &
 & 0.4703830E-25_JPRB, 0.4689923E-25_JPRB, 0.4677535E-25_JPRB, 0.4665251E-25_JPRB, 0.4652005E-25_JPRB, &
 & 0.4638987E-25_JPRB, 0.4627368E-25_JPRB, 0.4614312E-25_JPRB, 0.4600859E-25_JPRB, 0.4587120E-25_JPRB, &
 & 0.4576507E-25_JPRB, 0.4563778E-25_JPRB, 0.4551894E-25_JPRB, 0.4540353E-25_JPRB, 0.4527886E-25_JPRB, &
 & 0.4514944E-25_JPRB, 0.4502190E-25_JPRB, 0.4491759E-25_JPRB, 0.4478702E-25_JPRB, 0.4466893E-25_JPRB, &
 & 0.4453446E-25_JPRB, 0.4442118E-25_JPRB, 0.4429979E-25_JPRB, 0.4417654E-25_JPRB, 0.4406395E-25_JPRB, &
 & 0.4393794E-25_JPRB, 0.4382254E-25_JPRB, 0.4371032E-25_JPRB, 0.4359890E-25_JPRB, 0.4347318E-25_JPRB, &
 & 0.4337158E-25_JPRB, 0.4325351E-25_JPRB, 0.4312833E-25_JPRB, 0.4302253E-25_JPRB, 0.4289430E-25_JPRB, &
 & 0.4278239E-25_JPRB, 0.4267910E-25_JPRB, 0.4255298E-25_JPRB, 0.4244454E-25_JPRB, 0.4233537E-25_JPRB, &
 & 0.4221707E-25_JPRB, 0.4210167E-25_JPRB, 0.4198555E-25_JPRB, 0.4189473E-25_JPRB, 0.4176732E-25_JPRB, &
 & 0.4165337E-25_JPRB, 0.4155153E-25_JPRB, 0.4144353E-25_JPRB, 0.4134188E-25_JPRB, 0.4122111E-25_JPRB, &
 & 0.4110894E-25_JPRB, 0.4101121E-25_JPRB, 0.4090171E-25_JPRB, 0.4079204E-25_JPRB, 0.4068998E-25_JPRB, &
 & 0.4056811E-25_JPRB, 0.4046853E-25_JPRB, 0.4035664E-25_JPRB, 0.4025730E-25_JPRB, 0.4014375E-25_JPRB, &
 & 0.4004650E-25_JPRB, 0.3994781E-25_JPRB, 0.3983609E-25_JPRB, 0.3973505E-25_JPRB, 0.3963121E-25_JPRB, &
 & 0.3953201E-25_JPRB, 0.3941969E-25_JPRB, 0.3932154E-25_JPRB, 0.3922008E-25_JPRB, 0.3911375E-25_JPRB, &
 & 0.3901542E-25_JPRB, 0.3890660E-25_JPRB, 0.3881347E-25_JPRB, 0.3870995E-25_JPRB, 0.3861014E-25_JPRB, &
 & 0.3850985E-25_JPRB, 0.3841576E-25_JPRB, 0.3831229E-25_JPRB, 0.3821930E-25_JPRB, 0.3811757E-25_JPRB, &
 & 0.3802202E-25_JPRB, 0.3791729E-25_JPRB, 0.3782096E-25_JPRB, 0.3772830E-25_JPRB, 0.3762521E-25_JPRB, &
 & 0.3752196E-25_JPRB, 0.3743804E-25_JPRB, 0.3733339E-25_JPRB, 0.3724655E-25_JPRB, 0.3714239E-25_JPRB, &
 & 0.3704893E-25_JPRB, 0.3695292E-25_JPRB, 0.3686195E-25_JPRB, 0.3676398E-25_JPRB, 0.3667089E-25_JPRB, &
 & 0.3657894E-25_JPRB, 0.3649280E-25_JPRB, 0.3638438E-25_JPRB, 0.3630178E-25_JPRB, 0.3620675E-25_JPRB, &
 & 0.3610680E-25_JPRB, 0.3602397E-25_JPRB, 0.3592707E-25_JPRB, 0.3583906E-25_JPRB, 0.3574758E-25_JPRB, &
 & 0.3565372E-25_JPRB, 0.3556517E-25_JPRB, 0.3547120E-25_JPRB, 0.3538869E-25_JPRB, 0.3530207E-25_JPRB, &
 & 0.3519870E-25_JPRB, 0.3511801E-25_JPRB, 0.3502476E-25_JPRB, 0.3493818E-25_JPRB, 0.3486291E-25_JPRB, &
 & 0.3476539E-25_JPRB, 0.3466662E-25_JPRB, 0.3458988E-25_JPRB, 0.3450374E-25_JPRB, 0.3441917E-25_JPRB, &
 & 0.3432756E-25_JPRB, 0.3424206E-25_JPRB, 0.3415836E-25_JPRB, 0.3407089E-25_JPRB, 0.3398823E-25_JPRB, &
 & 0.3391132E-25_JPRB, 0.3381723E-25_JPRB, 0.3372699E-25_JPRB, 0.3364352E-25_JPRB, 0.3356600E-25_JPRB, &
 & 0.3348421E-25_JPRB, 0.3340288E-25_JPRB, 0.3330966E-25_JPRB, 0.3322651E-25_JPRB, 0.3314748E-25_JPRB /)
ZCRAYUV(301:600) = (/ &
 & 0.3305984E-25_JPRB, 0.3298072E-25_JPRB, 0.3289859E-25_JPRB, 0.3282017E-25_JPRB, 0.3273561E-25_JPRB, &
 & 0.3265128E-25_JPRB, 0.3257629E-25_JPRB, 0.3249522E-25_JPRB, 0.3241397E-25_JPRB, 0.3233116E-25_JPRB, &
 & 0.3225721E-25_JPRB, 0.3217845E-25_JPRB, 0.3209827E-25_JPRB, 0.3202007E-25_JPRB, 0.3193858E-25_JPRB, &
 & 0.3186312E-25_JPRB, 0.3177970E-25_JPRB, 0.3169526E-25_JPRB, 0.3162512E-25_JPRB, 0.3154191E-25_JPRB, &
 & 0.3147949E-25_JPRB, 0.3139129E-25_JPRB, 0.3130702E-25_JPRB, 0.3123660E-25_JPRB, 0.3115790E-25_JPRB, &
 & 0.3108486E-25_JPRB, 0.3101754E-25_JPRB, 0.3092851E-25_JPRB, 0.3085713E-25_JPRB, 0.3078730E-25_JPRB, &
 & 0.3070664E-25_JPRB, 0.3062619E-25_JPRB, 0.3055719E-25_JPRB, 0.3048145E-25_JPRB, 0.3040600E-25_JPRB, &
 & 0.3033070E-25_JPRB, 0.3025883E-25_JPRB, 0.3018769E-25_JPRB, 0.3011228E-25_JPRB, 0.3004097E-25_JPRB, &
 & 0.2996710E-25_JPRB, 0.2989633E-25_JPRB, 0.2982268E-25_JPRB, 0.2974796E-25_JPRB, 0.2967974E-25_JPRB, &
 & 0.2961358E-25_JPRB, 0.2953785E-25_JPRB, 0.2945691E-25_JPRB, 0.2939451E-25_JPRB, 0.2931466E-25_JPRB, &
 & 0.2925504E-25_JPRB, 0.2918363E-25_JPRB, 0.2911492E-25_JPRB, 0.2904339E-25_JPRB, 0.2896760E-25_JPRB, &
 & 0.2890574E-25_JPRB, 0.2883687E-25_JPRB, 0.2876630E-25_JPRB, 0.2869037E-25_JPRB, 0.2862616E-25_JPRB, &
 & 0.2855907E-25_JPRB, 0.2848499E-25_JPRB, 0.2842363E-25_JPRB, 0.2836590E-25_JPRB, 0.2828614E-25_JPRB, &
 & 0.2822013E-25_JPRB, 0.2815331E-25_JPRB, 0.2808206E-25_JPRB, 0.2801999E-25_JPRB, 0.2795129E-25_JPRB, &
 & 0.2788733E-25_JPRB, 0.2781790E-25_JPRB, 0.2775226E-25_JPRB, 0.2768396E-25_JPRB, 0.2761947E-25_JPRB, &
 & 0.2755280E-25_JPRB, 0.2748942E-25_JPRB, 0.2742622E-25_JPRB, 0.2736305E-25_JPRB, 0.2729839E-25_JPRB, &
 & 0.2723205E-25_JPRB, 0.2716291E-25_JPRB, 0.2710531E-25_JPRB, 0.2703178E-25_JPRB, 0.2697369E-25_JPRB, &
 & 0.2690815E-25_JPRB, 0.2684563E-25_JPRB, 0.2678317E-25_JPRB, 0.2671934E-25_JPRB, 0.2666264E-25_JPRB, &
 & 0.2660071E-25_JPRB, 0.2652226E-25_JPRB, 0.2647622E-25_JPRB, 0.2640349E-25_JPRB, 0.2634147E-25_JPRB, &
 & 0.2628049E-25_JPRB, 0.2622270E-25_JPRB, 0.2615982E-25_JPRB, 0.2610121E-25_JPRB, 0.2603948E-25_JPRB, &
 & 0.2597863E-25_JPRB, 0.2592153E-25_JPRB, 0.2585788E-25_JPRB, 0.2579637E-25_JPRB, 0.2574628E-25_JPRB, &
 & 0.2567483E-25_JPRB, 0.2561915E-25_JPRB, 0.2555600E-25_JPRB, 0.2549877E-25_JPRB, 0.2545187E-25_JPRB, &
 & 0.2537348E-25_JPRB, 0.2531826E-25_JPRB, 0.2526576E-25_JPRB, 0.2520277E-25_JPRB, 0.2514406E-25_JPRB, &
 & 0.2508984E-25_JPRB, 0.2502242E-25_JPRB, 0.2497412E-25_JPRB, 0.2491734E-25_JPRB, 0.2485537E-25_JPRB, &
 & 0.2479957E-25_JPRB, 0.2474433E-25_JPRB, 0.2468558E-25_JPRB, 0.2462352E-25_JPRB, 0.2456774E-25_JPRB, &
 & 0.2451092E-25_JPRB, 0.2445473E-25_JPRB, 0.2440110E-25_JPRB, 0.2434430E-25_JPRB, 0.2428878E-25_JPRB, &
 & 0.2423375E-25_JPRB, 0.2418300E-25_JPRB, 0.2412748E-25_JPRB, 0.2407345E-25_JPRB, 0.2401573E-25_JPRB, &
 & 0.2395626E-25_JPRB, 0.2390419E-25_JPRB, 0.2384824E-25_JPRB, 0.2379713E-25_JPRB, 0.2374113E-25_JPRB, &
 & 0.2368813E-25_JPRB, 0.2363609E-25_JPRB, 0.2357891E-25_JPRB, 0.2352318E-25_JPRB, 0.2346731E-25_JPRB, &
 & 0.2342027E-25_JPRB, 0.2336675E-25_JPRB, 0.2330989E-25_JPRB, 0.2326043E-25_JPRB, 0.2320905E-25_JPRB, &
 & 0.2315493E-25_JPRB, 0.2310179E-25_JPRB, 0.2305187E-25_JPRB, 0.2299280E-25_JPRB, 0.2294418E-25_JPRB, &
 & 0.2288918E-25_JPRB, 0.2284270E-25_JPRB, 0.2279157E-25_JPRB, 0.2274044E-25_JPRB, 0.2269143E-25_JPRB, &
 & 0.2263537E-25_JPRB, 0.2258695E-25_JPRB, 0.2253686E-25_JPRB, 0.2248540E-25_JPRB, 0.2243068E-25_JPRB, &
 & 0.2238817E-25_JPRB, 0.2233570E-25_JPRB, 0.2228893E-25_JPRB, 0.2223422E-25_JPRB, 0.2217755E-25_JPRB, &
 & 0.2213169E-25_JPRB, 0.2208572E-25_JPRB, 0.2203020E-25_JPRB, 0.2198316E-25_JPRB, 0.2194407E-25_JPRB, &
 & 0.2188110E-25_JPRB, 0.2183839E-25_JPRB, 0.2178888E-25_JPRB, 0.2174415E-25_JPRB, 0.2169765E-25_JPRB, &
 & 0.2164350E-25_JPRB, 0.2159686E-25_JPRB, 0.2154432E-25_JPRB, 0.2150311E-25_JPRB, 0.2144809E-25_JPRB, &
 & 0.2141063E-25_JPRB, 0.2135743E-25_JPRB, 0.2131350E-25_JPRB, 0.2126439E-25_JPRB, 0.2121757E-25_JPRB, &
 & 0.2116993E-25_JPRB, 0.2112348E-25_JPRB, 0.2107558E-25_JPRB, 0.2103303E-25_JPRB, 0.2098430E-25_JPRB, &
 & 0.2093762E-25_JPRB, 0.2089122E-25_JPRB, 0.2084616E-25_JPRB, 0.2079919E-25_JPRB, 0.2075581E-25_JPRB, &
 & 0.2070484E-25_JPRB, 0.2066188E-25_JPRB, 0.2061627E-25_JPRB, 0.2057537E-25_JPRB, 0.2052658E-25_JPRB, &
 & 0.2048236E-25_JPRB, 0.2043740E-25_JPRB, 0.2039009E-25_JPRB, 0.2034790E-25_JPRB, 0.2030402E-25_JPRB, &
 & 0.2026373E-25_JPRB, 0.2021292E-25_JPRB, 0.2017653E-25_JPRB, 0.2012671E-25_JPRB, 0.2008244E-25_JPRB, &
 & 0.2003679E-25_JPRB, 0.1999900E-25_JPRB, 0.1995156E-25_JPRB, 0.1990708E-25_JPRB, 0.1986896E-25_JPRB, &
 & 0.1982515E-25_JPRB, 0.1977577E-25_JPRB, 0.1973389E-25_JPRB, 0.1969472E-25_JPRB, 0.1965130E-25_JPRB, &
 & 0.1961169E-25_JPRB, 0.1956593E-25_JPRB, 0.1952552E-25_JPRB, 0.1948516E-25_JPRB, 0.1944288E-25_JPRB, &
 & 0.1939545E-25_JPRB, 0.1935074E-25_JPRB, 0.1931325E-25_JPRB, 0.1927054E-25_JPRB, 0.1922953E-25_JPRB, &
 & 0.1919001E-25_JPRB, 0.1914619E-25_JPRB, 0.1910454E-25_JPRB, 0.1906483E-25_JPRB, 0.1902818E-25_JPRB, &
 & 0.1898249E-25_JPRB, 0.1894532E-25_JPRB, 0.1889855E-25_JPRB, 0.1886213E-25_JPRB, 0.1882224E-25_JPRB, &
 & 0.1877868E-25_JPRB, 0.1874022E-25_JPRB, 0.1869706E-25_JPRB, 0.1865394E-25_JPRB, 0.1861920E-25_JPRB, &
 & 0.1857844E-25_JPRB, 0.1854381E-25_JPRB, 0.1849851E-25_JPRB, 0.1846284E-25_JPRB, 0.1842192E-25_JPRB, &
 & 0.1838483E-25_JPRB, 0.1834272E-25_JPRB, 0.1830332E-25_JPRB, 0.1826590E-25_JPRB, 0.1822672E-25_JPRB, &
 & 0.1818896E-25_JPRB, 0.1814961E-25_JPRB, 0.1810901E-25_JPRB, 0.1807128E-25_JPRB, 0.1803498E-25_JPRB, &
 & 0.1799625E-25_JPRB, 0.1795890E-25_JPRB, 0.1791572E-25_JPRB, 0.1788046E-25_JPRB, 0.1784347E-25_JPRB, &
 & 0.1780655E-25_JPRB, 0.1776813E-25_JPRB, 0.1773257E-25_JPRB, 0.1769180E-25_JPRB, 0.1765592E-25_JPRB, &
 & 0.1761816E-25_JPRB, 0.1758429E-25_JPRB, 0.1754198E-25_JPRB, 0.1750965E-25_JPRB, 0.1747065E-25_JPRB, &
 & 0.1743662E-25_JPRB, 0.1739582E-25_JPRB, 0.1736024E-25_JPRB, 0.1732771E-25_JPRB, 0.1729447E-25_JPRB, &
 & 0.1724799E-25_JPRB, 0.1721488E-25_JPRB, 0.1718100E-25_JPRB, 0.1714394E-25_JPRB, 0.1710822E-25_JPRB, &
 & 0.1707207E-25_JPRB, 0.1703568E-25_JPRB, 0.1700035E-25_JPRB, 0.1696602E-25_JPRB, 0.1692917E-25_JPRB, &
 & 0.1689509E-25_JPRB, 0.1686000E-25_JPRB, 0.1682677E-25_JPRB, 0.1679007E-25_JPRB, 0.1675450E-25_JPRB /)

!ZDRAYUV = (/


!          Liquid water cloud optical parameters from Slingo, 1989, JAS 46, 120
RASA = (/ 3.094E-02_JPRB, 2.944E-02_JPRB, 3.308E-02_JPRB, 2.801E-02_JPRB /)
RASB = (/ 1.252_JPRB    , 1.270_JPRB    , 1.246_JPRB    , 1.293_JPRB     /)
RASC = (/ 7.90E-07_JPRB ,-6.50E-07_JPRB ,-3.00E-07_JPRB , 1.00E-06_JPRB  /)
RASD = (/ 3.69E-07_JPRB , 4.33E-07_JPRB , 2.36E-07_JPRB , 0.00E+00_JPRB  /)
RASE = (/ 0.844_JPRB    , 0.841_JPRB    , 0.839_JPRB    , 0.836_JPRB     /)
RASF = (/ 1.558E-03_JPRB, 1.680E-03_JPRB, 1.946E-03_JPRB, 2.153E-03_JPRB /)

!          Ice water cloud optical parameters from Fu, 1996, J. Clim., 9, 2070 &
!          extinction coefficient
RFA0 = (/-0.236447E-03_JPRB,-0.266955E-03_JPRB,-0.293599E-03_JPRB,-0.258858E-03_JPRB /)
RFA1 = (/ 0.253817E+01_JPRB, 0.254179E+01_JPRB, 0.254540E+01_JPRB, 0.253815E+01_JPRB /)
!	   single scattering albedo
RFB0 = (/-0.269916E-06_JPRB,-0.100570E-06_JPRB, 0.182299E-06_JPRB,-0.198529E-06_JPRB /)
RFB1 = (/ 0.212909E-06_JPRB, 0.160441E-06_JPRB, 0.112454E-06_JPRB, 0.939480E-07_JPRB /)
RFB2 = (/-0.265397E-09_JPRB,-0.205663E-09_JPRB,-0.108031E-09_JPRB,-0.254540E-09_JPRB /)
RFB3 = (/ 0.112983E-11_JPRB, 0.888595E-12_JPRB, 0.499801E-12_JPRB, 0.110876E-11_JPRB /)
!          assymetry factor
RFC0 = (/ 0.733260E+00_JPRB, 0.737809E+00_JPRB, 0.740926E+00_JPRB, 0.743546E+00_JPRB /)
RFC1 = (/ 0.918317E-03_JPRB, 0.897515E-03_JPRB, 0.890216E-03_JPRB, 0.908674E-03_JPRB /)
RFC2 = (/-0.422974E-06_JPRB,-0.217099E-06_JPRB,-0.187919E-06_JPRB,-0.465326E-06_JPRB /)
RFC3 = (/-0.107976E-07_JPRB,-0.116090E-07_JPRB,-0.116760E-07_JPRB,-0.105786E-07_JPRB /)
!          forward Delta function
RFD0 = (/ 0.119114E+00_JPRB, 0.118072E+00_JPRB, 0.117402E+00_JPRB, 0.116918E+00_JPRB /)
RFD1 = (/ 0.271746E-03_JPRB, 0.271772E-03_JPRB, 0.266303E-03_JPRB, 0.259549E-03_JPRB /)
RFD2 = (/ 0.167483E-05_JPRB, 0.169253E-05_JPRB, 0.177039E-05_JPRB, 0.186749E-05_JPRB /)
RFD3 = (/-0.114603E-07_JPRB,-0.115557E-07_JPRB,-0.118611E-07_JPRB,-0.122603E-07_JPRB /)

!          Aerosols (from GADS)
! continental average 80%
! maritime clean      95%
! desert              50% 
! urban               80% 
RTAUVA(1,:) = (/ & 
 & 2.2150_JPRB , 1.0985_JPRB , 1.1208_JPRB , 2.2535_JPRB , 1.03858_JPRB , 1.12044_JPRB /)  
RTAUVA(2,:) = (/ & 
 & 1.9353_JPRB , 1.0754_JPRB , 1.0955_JPRB , 1.9756_JPRB , 1.03858_JPRB , 1.12044_JPRB /)  
RTAUVA(3,:) = (/ & 
 & 1.6822_JPRB , 1.0506_JPRB , 1.0716_JPRB , 1.7074_JPRB , 1.03858_JPRB , 1.12044_JPRB /)  
RTAUVA(4,:) = (/ & 
 & 1.4664_JPRB , 1.0347_JPRB , 1.0499_JPRB , 1.4806_JPRB , 1.03858_JPRB , 1.12044_JPRB /)

RPIUVA(1, :)= (/ &
 &  .8736_JPRB , 0.9868_JPRB , 0.6758_JPRB , 0.7806_JPRB, .9401905_JPRB , 0.9989_JPRB /)  
RPIUVA(2, :)= (/ &
 &  .9253_JPRB , 0.9969_JPRB , 0.7080_JPRB , 0.8226_JPRB, .9401905_JPRB , 0.9990_JPRB /)  
RPIUVA(3, :)= (/ &
 &  .9322_JPRB , 0.9983_JPRB , 0.7512_JPRB , 0.8278_JPRB, .9401905_JPRB , 0.9990_JPRB /)  
RPIUVA(4, :)= (/ &
 &  .9315_JPRB , 0.9985_JPRB , 0.7849_JPRB , 0.8259_JPRB, .9401905_JPRB , 0.9991_JPRB /)  

RCGUVA(1, :)= (/ &
 & 0.7445_JPRB , 0.8093_JPRB , 0.8242_JPRB , 0.7285_JPRB, .7008249_JPRB , 0.7567_JPRB /)  
RCGUVA(2, :)= (/ &
 & 0.7317_JPRB , 0.8061_JPRB , 0.8068_JPRB , 0.7137_JPRB, .7008249_JPRB , 0.7675_JPRB /)  
RCGUVA(3, :)= (/ &
 & 0.7262_JPRB , 0.8046_JPRB , 0.7861_JPRB , 0.7086_JPRB, .7008249_JPRB , 0.7743_JPRB /)  
RCGUVA(4, :)= (/ &
 & 0.7209_JPRB , 0.7993_JPRB , 0.7700_JPRB , 0.7040_JPRB, .7008249_JPRB , 0.7782_JPRB /)  

!- Definition of the CIE erythemasl action spectrum

RXPO = (/ 0.000_JPRB, -0.094_JPRB, -0.015_JPRB /)
RXPL = (/ 298.0_JPRB,  328.0_JPRB,  139.0_JPRB /)

RK250(:) =0._JPRB
RTUV1(:) =0._JPRB
RTUV2(:) =0._JPRB
RSUVB0(:)=0._JPRB
RAYUVB(:)=0._JPRB
JCOP(:)  =0
JUVLAM(:)=0

ZRES=120._JPRB/KUV
ZBEG=280._JPRB-ZRES
ZHRES=ZRES*0.5_JPRB

DO J=1,KUV
  RUVLAM(J)=280._JPRB+(J-1)*ZRES
  IPUV(J)  =INT((RUVLAM(J)-ZBEG)/ZRES+0.0001_JPRB)
  ZUVLAM=RUVLAM(J)+ZHRES
  IF( ZUVLAM <= RXPL(1) ) THEN
    RCIEAS(J) = 10._JPRB**RXPO(1)
  ELSEIF (ZUVLAM <= RXPL(2) ) THEN
    ZEXP= RXPO(2)*(ZUVLAM-RXPL(1))
    RCIEAS(J) = 10._JPRB**ZEXP
  ELSE
    ZEXP= RXPO(3)*(ZUVLAM-RXPL(3))
    RCIEAS(J) = 10._JPRB**ZEXP
  ENDIF
  IF (RUVLAM(J) == 305._JPRB .OR. RUVLAM(J) == 310._JPRB .OR. &
    & RUVLAM(J) == 320._JPRB .OR. RUVLAM(J) == 380._JPRB) JUVLAM(J) = 1

  WRITE(NULOUT,'("Eryth.Action Spectrum:",I3,F8.2,E12.5,F10.2,I3)') &
    & IPUV(J),ZUVLAM,RCIEAS(J),RUVLAM(J),JUVLAM(J)
ENDDO

IF (KUV == 24) THEN
  DO J=1,KUV
    JCOP(J)=IACOP(J)
    RK250(J)=ZAK250(J)
    RTUV1(J)=ZATUV1(J)
    RTUV2(J)=ZATUV2(J)
    RSUVB0(J)=ZASUVB(J)
    RAYUVB(J)=ZARAYUV(J)
    JUVLAM(J)=1
  ENDDO
ELSEIF (KUV == 120) THEN
  DO J=1,KUV
    JCOP(J)=IBCOP(J)
    RK250(J)=ZBK250(J)
    RTUV1(J)=ZBTUV1(J)
    RTUV2(J)=ZBTUV2(J)
    RSUVB0(J)=ZBSUVB(J)
    RAYUVB(J)=ZBRAYUV(J)
  ENDDO
ELSEIF (KUV == 600) THEN
  DO J=1,KUV
    JCOP(J)=ICCOP(J)
    RK250(J)=ZCK250(J)
    RTUV1(J)=ZCTUV1(J)
    RTUV2(J)=ZCTUV2(J)
    RSUVB0(J)=ZCSUVB(J)
    RAYUVB(J)=ZCRAYUV(J)
  ENDDO
ELSE
  STOP
ENDIF
 
   
WRITE(NULOUT,'("SU_UVRAD O3:",25I3)') (JCOP(J),J=1,KUV)
DO J=1,KUV
  WRITE(NULOUT,'("SU_UVRAD O3:",I3,5E12.5)') J,RK250(J),RTUV1(J),RTUV2(J),RSUVB0(J),RAYUVB(J)
ENDDO
DO J=1,4
  WRITE(NULOUT,'("CLOUDSLINGO:",I3,6E12.5)') J,RASA(J),RASB(J),RASC(J),RASD(J),RASE(J),RASF(J)
ENDDO
DO J=1,4
  WRITE(NULOUT,'("ICECLDFUA B:",I3,6E12.5)') J,RFA0(J),RFA1(J),RFB0(J),RFB1(J),RFB2(J),RFB3(J)
ENDDO
DO J=1,4
  WRITE(NULOUT,'("ICECLDFUC D:",I3,8E12.5)') J,RFC0(J),RFC1(J),RFC2(J),RFC3(J),&
     &                                        RFD0(J),RFD1(J),RFD2(J),RFD3(J)
ENDDO
DO J=1,4
  DO JAE=1,6
    WRITE(NULOUT,'("AEROSOLS   :",2I3,3E12.5)') J,JAE,RTAUVA(J,JAE),RPIUVA(J,JAE),RCGUVA(J,JAE)
  ENDDO
ENDDO
  
!     ----------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('SU_UVRAD',1,ZHOOK_HANDLE)
END SUBROUTINE SU_UVRAD




































