! reprobus SUBROUTINE wrappers

MODULE lmdz_reprobus_wrappers

#ifdef REPROBUS
  USE CHEM_REP
#else
  USE mod_grid_phy_lmdz, ONLY: nbp_lon, nbp_lat


  IMPLICIT NONE

  ! TODO ugly temp solution until we properly wrap the REPROBUS code
  INTEGER :: itroprep(1)
  INTEGER ::  iter, ndimozon
  REAL :: rsuntime(2), pdt_rep, daynum, solaireTIME, gravit, Z1, Z2, fac, B
  REAL :: ptrop(1), ttrop(1), ztrop(1)
  REAL, DIMENSION(1, 1) :: pdel, d_q_rep, d_ql_rep, d_qi_rep, rch42d, rn2o2d, rcfc112d, rcfc122d
  LOGICAL :: ok_suntime, ok_rtime2d

CONTAINS

  SUBROUTINE lmdz_reprobus_wrapper_abort
    STOP 'REPROBUS key undefined, must not enter in REPROBUS wrappers ==> aborting'
  END SUBROUTINE lmdz_reprobus_wrapper_abort

  ! TODO replace ugly wrappers below with actual signatures from REPROBUS code

  SUBROUTINE init_chem_rep_trac(nbtr, nqo, name)
    INTEGER :: nbtr, nqo
    CHARACTER(len = 256) :: name(:)
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_trac

  SUBROUTINE init_chem_rep_phys(klon, klev)
    INTEGER :: klon, klev
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_phys

  SUBROUTINE init_chem_rep_xjour(j)
    REAL :: j
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_xjour

  SUBROUTINE finalize_reprobus
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE finalize_reprobus

  SUBROUTINE init_reprobus_para(nlon, nlat, nlev, klon, mpi_size, distrib_phys, communicator)
    INTEGER :: nlon, nlat, nlev, klon, mpi_size, distrib_phys(:), communicator
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_reprobus_para

  SUBROUTINE chemini_rep(presnivs, pdtphys, annee_ref, day_ref, day_ini, start_time, itau_phy, io_lon, io_lat)
    INTEGER :: annee_ref, day_ref, day_ini, itau_phy
    REAL :: presnivs(:), pdtphys, start_time, io_lon(:), io_lat(:)
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE chemini_rep

  SUBROUTINE chemtime_rep(it, date, tstep, itap)
    INTEGER :: it, itap
    REAL :: date, tstep
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE chemtime_rep

  SUBROUTINE coord_hyb_rep(paprs, pplay, aps, bps, ap, bp, cell_area)
    REAL :: paprs(:,:), pplay(:,:), aps(:), bps(:), ap(:), bp(:), cell_area(:)
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE coord_hyb_rep

  SUBROUTINE chemmain_rlong_1401(tr_seri, xlon, xlat, t_seri, pplay, paprs, pphi, pphis, presnivs, sh, debutphy)
    REAL :: tr_seri(:,:,:), xlon(:), xlat(:), t_seri(:,:), pplay(:,:), paprs(:,:), pphi(:,:), pphis(:), presnivs(:), sh(:,:)
    LOGICAL :: debutphy
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE chemmain_rlong_1401

  SUBROUTINE rtime(debut)
    LOGICAL :: debut
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE rtime

  SUBROUTINE rad_interactif(pozon, iof)
    real :: pozon(:,:,:)
    integer :: iof
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE rad_interactif

#endif
END MODULE lmdz_reprobus_wrappers
