!aeropt_5wv_ecrad.F90 2022-09-20 A. Idelkadi et O. Boucher 
!
     SUBROUTINE AEROPT_5WV_ECRAD(istartcol,iendcol,istartlev,iendlev, &
                                 config,thermodynamics,aerosol)


      USE DIMPHY
      USE aero_mod
      USE phys_local_var_mod, ONLY: od443aer,od550aer,od865aer
!                                      dryod550aer, 
!                                      ec550aer,od550lt1aer,abs550aer
!        USE phys_output_var_mod, ONLY: dryaod_diag
!        USE YOMCST, ONLY: RD,RG
      USE phys_local_var_mod, ONLY: rhcl

      use parkind1,                      only : jprb
      use radiation_config,              only : config_type
      use radiation_thermodynamics,      only : thermodynamics_type
      use radiation_aerosol,             only : aerosol_type
      use radiation_constants,           only : AccelDueToGravity
      use radiation_aerosol_optics_data, only : aerosol_optics_type, &
         &  IAerosolClassUndefined,   IAerosolClassIgnored, &
         &  IAerosolClassHydrophobic, IAerosolClassHydrophilic

      IMPLICIT NONE

      !---ATTENTION n_mono est a redéfinir proprement

      ! Range of levels over which aerosols are present
      integer, intent(in) :: istartlev, iendlev, istartcol,iendcol
      type(config_type), intent(in), target :: config
      type(thermodynamics_type),intent(in)  :: thermodynamics
      type(aerosol_type),       intent(in)  :: aerosol
      type(aerosol_optics_type), pointer :: ao

      ! Loop indices for column, level, g point, band and aerosol type, and relative humidity
      integer :: jcol, jlev, jtype, irh
      ! indice wavelength in aerosol_optics_lmdz.nc
      INTEGER, PARAMETER :: la443 = 1
      INTEGER, PARAMETER :: la550 = 2
!      INTEGER, PARAMETER :: la670 = 3
!      INTEGER, PARAMETER :: la765 = 4
      INTEGER, PARAMETER :: la865 = 5
      real(jprb) :: factor
      ! n_bands_sw
      real(jprb), dimension(config%aerosol_optics%n_mono_wl) :: od_aerosol_mono, local_od_mono

      !--initialization
      od443aer = 0.0_jprb
      od550aer = 0.0_jprb
      od865aer = 0.0_jprb

      ao => config%aerosol_optics

      ! Loop over level
     do jlev = istartlev,iendlev

        ! Loop over column
        do jcol = istartcol,iendcol

          ! Compute relative humidity with respect to liquid
          ! saturation and the index to the relative-humidity index of
          ! hydrophilic-aerosol data
          irh = ao%calc_rh_index(rhcl(jcol,jlev))

          factor = ( thermodynamics%pressure_hl(jcol,jlev+1) &
               &    -thermodynamics%pressure_hl(jcol,jlev  )  ) &
               &   / AccelDueToGravity

          ! Reset temporary arrays
          od_aerosol_mono = 0.0_jprb

          do jtype = 1,config%n_aerosol_types
            ! Add the optical depth for this aerosol type to the total for all aerosols.  
            ! Note that the following expressions are array-wise
            if (ao%iclass(jtype) == IAerosolClassHydrophobic) then
              local_od_mono = factor * aerosol%mixing_ratio(jcol,jlev,jtype) &
                   &  * ao%mass_ext_mono_phobic(:,ao%itype(jtype))
              od_aerosol_mono = od_aerosol_mono + local_od_mono
            else if (ao%iclass(jtype) == IAerosolClassHydrophilic) then
              ! Hydrophilic aerosols require the look-up tables to
              ! be indexed with irh
              local_od_mono = factor * aerosol%mixing_ratio(jcol,jlev,jtype) &
                   &  * ao%mass_ext_mono_philic(:,irh,ao%itype(jtype))
              od_aerosol_mono = od_aerosol_mono + local_od_mono
            end if

          end do ! Loop over aerosol type

          !--ATTENTION A BIEN FAIRE CORRESPONDRE LES INDICES
          od443aer(jcol) = od443aer(jcol) + od_aerosol_mono(la443)
          od550aer(jcol) = od550aer(jcol) + od_aerosol_mono(la550)
          od865aer(jcol) = od865aer(jcol) + od_aerosol_mono(la865)

        end do ! Loop over column

      end do ! Loop over level

     END SUBROUTINE AEROPT_5WV_ECRAD

