SUBROUTINE SUSWN (KTSW, KSW)

!**** *SUSW*   - INITIALIZE COMMON YOESW

!     PURPOSE.
!     --------
!           INITIALIZE YOESW, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE SHORTWAVE RADIATION SUBROUTINES

!**   INTERFACE.
!     ----------
!        *CALL* *SUSW

!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOESW

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE *ECMWF*

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 88-12-15
!        97-04-16 JJ Morcrette  2 and 4 interval spectral resolution
!        00-10-24 JJ Morcrette  sea-ice albedo revisited
!        00-12-14 JJ Morcrette 
!               and Ph.Dubuisson B.Bonnel 6 spectral interval resolution
!        01-04-17 Ph.Dubuisson, B.Bonnel, JJ.Morcrette 6 sp.int.resolu'n
!        01-06-28 B.Bonnel, JJ.Morcrette, Ph.Dubuisson  Rayleigh (2/4/6)
!        01-11-05 Ph.Dubuisson, JJMorcrette (new 2 intervals for TL/AD)
!        03-04-24 JJ Morcrette  SRTM with 14 spectral intervals
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOMCST   , ONLY : RG
USE YOERAD   , ONLY : NTSW     ,LONEWSW  ,LRAYL    
USE YOESW    , ONLY : APAD     ,BPAD     ,RRAY     ,RSUN     ,&
 & RPDH1    ,RPDU1    ,RPNH     ,RPNU     ,RSWCE    ,&
 & RSWCP    ,RTDH2O   ,RTDUMG   ,RTH2O    ,RTUMG    ,&
 & D        ,RROMA    ,RROMB    ,RRASY    ,RHSRA    ,&
 & RHSRB    ,RHSRC    ,RHSRD    ,RHSRE    ,RHSRF    ,&
 & RHSRTA   ,RHSRTB   ,REXPO3   ,&
 & RADJUST  ,NEXPO3  

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KTSW 
INTEGER(KIND=JPIM),INTENT(IN)    :: KSW 
INTEGER(KIND=JPIM) :: IMPSRTM(14)

!     ----------------------------------------------------------------
REAL(KIND=JPRB) :: ZAPAD2(2,3,7)  , ZBPAD2(2,3,7)  , ZD2(2,3)&
 & ,  ZRAY2(2,6)     , ZSUN2(2)       , ZSWCE2(2)  , ZSWCP2(2)&
 & ,  ZROMA2(2)      , ZROMB2(2)  , ZRASY2(2)&
 & ,  ZRA2(2)        , ZRB2(2)        , ZRC2(2)&
 & ,  ZRD2(2)        , ZRE2(2)        , ZRF2(2)  

REAL(KIND=JPRB) :: ZAPAD4(4,3,7)  , ZBPAD4(4,3,7)  , ZD4(4,3)&
 & ,  ZRAY4(4,6)     , ZSUN4(4)       , ZSWCE4(4)  , ZSWCP4(4)&
 & ,  ZROMA4(4)      , ZROMB4(4)  , ZRASY4(4)&
 & ,  ZRA4(4)        , ZRB4(4)        , ZRC4(4)&
 & ,  ZRD4(4)        , ZRE4(4)        , ZRF4(4)  
  
REAL(KIND=JPRB) :: ZAPAD6(6,3,7)  , ZBPAD6(6,3,7)  , ZD6(6,3)&
 & ,  ZRAY6(6,6)     , ZSUN6(6)       , ZSWCE6(6)  , ZSWCP6(6)&
 & ,  ZROMA6(6)      , ZROMB6(6)  , ZRASY6(6)&
 & ,  ZRA6(6)        , ZRB6(6)        , ZRC6(6)&
 & ,  ZRD6(6)        , ZRE6(6)        , ZRF6(6)&
 & ,  ZRBY6(6,6)  
  

INTEGER(KIND=JPIM) :: JC3, JC6, JI, JJ, JW, I_K, ISW6

REAL(KIND=JPRB) :: ZH2O, ZPDHNIS, ZPDH2O, ZPDUNIS,&
 & ZPDUMG, ZPRHNIS, ZPRH2O, &
 & ZPRUNIS, ZPRUMG, ZRTO1, ZRTO2, ZTDHNIS, &
 & ZTDUNIS, ZTHNIS, &
 & ZTUNIS, ZUMG, ZADJUS2, ZADJUS4, ZADJUS6  

REAL(KIND=JPRB) :: ZTDH2IS, ZTDU2IS, ZTH2IS, ZTU2IS, ZPDH2IS, ZPDU2IS, ZPRH2IS, ZPRU2IS
REAL(KIND=JPRB) :: ZTDH4IS, ZTDU4IS, ZTH4IS, ZTU4IS, ZPDH4IS, ZPDU4IS, ZPRH4IS, ZPRU4IS
REAL(KIND=JPRB) :: ZTDH6IS, ZTDU6IS, ZTH6IS, ZTU6IS, ZPDH6IS, ZPDU6IS, ZPRH6IS, ZPRU6IS
REAL(KIND=JPRB) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

!     ----------------------------------------------------------------

!*        1.  CLEAR-SKY ABSORPTION COEFFICIENTS FOR N SPECTRAL INTERVALS
!             --------------------------------------------------------

!* spectrally independent

!-- New coefficients

IF (LHOOK) CALL DR_HOOK('SUSWN',0,ZHOOK_HANDLE)
ZTDHNIS = 0.450_JPRB
ZTDUNIS = 0.375_JPRB
ZTHNIS  = 273._JPRB
ZTUNIS  = 273._JPRB
ZPDHNIS = 0.90_JPRB
ZPDUNIS = 0.75_JPRB
ZPRHNIS = 101300._JPRB
ZPRUNIS = 101300._JPRB
ISW6=6

!     ----------------------------------------------------------------

!*        1.1  COEFFICIENTS FOR TWO SPECTRAL INTERVALS
!              ---------------------------------------

!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS2 = 1.0_JPRB
ZTDH2IS = 0.450_JPRB
ZTDU2IS = 0.375_JPRB
ZTH2IS  = 273._JPRB
ZTU2IS  = 273._JPRB
ZPDH2IS = 0.90_JPRB
ZPDU2IS = 0.75_JPRB
ZPRH2IS = 101300._JPRB
ZPRU2IS = 101300._JPRB

!* 1st spectral interval: U.V. and Visible (0.25 - 0.69 Micron)

ZSUN2(1) = 0.459760_JPRB

!-- New coefficients 
ZD2(1,:)= (/ 0.800000000_JPRB, 0.900000000_JPRB, 0.000000000_JPRB /)

ZAPAD2(1, 1, :) = (/&
 & 0.1095121E+03_JPRB,&
 & 0.8906647E+03_JPRB,&
 & 0.1030601E+03_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD2(1, 2, :) = (/&
 & 0.5124541E+03_JPRB,&
 & 0.3478800E+04_JPRB,&
 & 0.1244272E+04_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD2(1, 3, :) = (/&
 & 0.4766857E-04_JPRB,&
 & 0.4019806E-02_JPRB,&
 & 0.1936247E+00_JPRB,&
 & 0.1886522E+02_JPRB,&
 & 0.6498215E+02_JPRB,&
 & 0.1799387E+02_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD2(1, 1, :) = (/&
 & 0.1095121E+03_JPRB,&
 & 0.8919103E+03_JPRB,&
 & 0.1142218E+03_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD2(1, 2, :) = (/&
 & 0.5124541E+03_JPRB,&
 & 0.3499516E+04_JPRB,&
 & 0.1278186E+04_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD2(1, 3, :) = (/&
 & 0.4766857E-04_JPRB,&
 & 0.4153343E-02_JPRB,&
 & 0.1925810E+00_JPRB,&
 & 0.1938938E+02_JPRB,&
 & 0.6918191E+02_JPRB,&
 & 0.2278795E+02_JPRB,&
 & 0.100000000E+01_JPRB/)  

ZRAY2(1,:)= (/&
 & .389107E-01_JPRB, .101608E+01_JPRB,-.354921E+01_JPRB,&
 & .659510E+01_JPRB,-.592423E+01_JPRB, .202348E+01_JPRB/)  

!-- Original coefficients of ECMWF model (before 27 June 2000)

!ZTDH2IS = 0.450_JPRB
!ZTDU2IS = 0.375_JPRB
!ZTH2IS  = 296._JPRB
!ZTU2IS  = 296._JPRB
!ZPDH2IS = 0.90_JPRB
!ZPDU2IS = 0.75_JPRB
!ZPRH2IS = 100000._JPRB
!ZPRU2IS = 100000._JPRB

!ZD2(1,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

!ZAPAD2(1, 1, :) = (/&
! &0.184678379E+06_JPRB,&
! &0.553080884E+05_JPRB,&
! &0.248143712E+04_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB/)
!ZAPAD2(1, 2, :) = (/&
! &0.715303869E+01_JPRB,&
! &0.219386847E+03_JPRB,&
! &0.830001089E+03_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB/)
!ZAPAD2(1, 3, :) = (/&
! &0.925887084E-04_JPRB,&
! &0.129353723E-01_JPRB,&
! &0.800821928E+00_JPRB,&
! &0.242715973E+02_JPRB,&
! &0.878331486E+02_JPRB,&
! &0.191559725E+02_JPRB,&
! &0.000000000E+00_JPRB/)

!ZBPAD2(1, 1, :) = (/&
! &0.184678379E+06_JPRB,&
! &0.555188347E+05_JPRB,&
! &0.253257443E+04_JPRB,&
! &0.100000000E+01_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB/)
!ZBPAD2(1, 2, :) = (/&
! &0.715303869E+01_JPRB,&
! &0.219441875E+03_JPRB,&
! &0.831119997E+03_JPRB,&
! &0.100000000E+01_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB/)
!ZBPAD2(1, 3, :) = (/&
! &0.925887084E-04_JPRB,&
! &0.131812683E-01_JPRB,&
! &0.812706117E+00_JPRB,&
! &0.249863591E+02_JPRB,&
! &0.931071925E+02_JPRB,&
! &0.252233437E+02_JPRB,&
! &0.100000000E+01_JPRB/)

ZRAY2(1,:)= (/&
 & .428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 & .522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)  

ZSWCE2(1) = 0.0_JPRB
ZSWCP2(1) = 0.0_JPRB

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is not sub-divided

!     ----------------------------------------------------------------

!* 0.68 - 4.00 Micron

ZSUN2(2) = 0.540240_JPRB

!-- New coefficients

ZD2(2,:)= (/ 0.000000000_JPRB, 0.900000000_JPRB, 0.000000000_JPRB/)

ZAPAD2(2, 1, :) = (/&
 & 0.1345066E-03_JPRB,&
 & 0.9276888E+00_JPRB,&
 & 0.3449105E+03_JPRB,&
 & 0.7143025E+04_JPRB,&
 & 0.6531248E+04_JPRB,&
 & 0.2210815E+03_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD2(2, 2, :) = (/&
 & 0.7776703E-05_JPRB,&
 & 0.6851592E-02_JPRB,&
 & 0.5533947E+00_JPRB,&
 & 0.2538585E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD2(2, 3, :) = (/&
 & 0.932012720E+02_JPRB,&
 & 0.437866983E+03_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD2(2, 1, :) = (/&
 & 0.1345066E-03_JPRB,&
 & 0.9297728E+00_JPRB,&
 & 0.3523821E+03_JPRB,&
 & 0.7931590E+04_JPRB,&
 & 0.8979086E+04_JPRB,&
 & 0.5050864E+03_JPRB,&
 & 0.1000000E+01_JPRB/)  
ZBPAD2(2, 2, :) = (/&
 & 0.7776703E-05_JPRB,&
 & 0.6976301E-02_JPRB,&
 & 0.6074521E+00_JPRB,&
 & 0.3517521E+01_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZBPAD2(2, 3, :) = (/&
 & 0.932012720E+02_JPRB,&
 & 0.439078599E+03_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZRAY2(2,:)= (/&
 & .104635E-01_JPRB, .102535E+00_JPRB,-.536771E+00_JPRB,&
 & .123640E+01_JPRB,-.128930E+01_JPRB, .502426E+00_JPRB/)  

!-- Original coefficients of ECMWF model (before 27 June 2000)

!ZD2(2,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB/)

!ZAPAD2(2, 1, :) = (/&
! &0.577160808E-06_JPRB,&
! &0.681760991E-02_JPRB,&
! &0.502416370E+01_JPRB,&
! &0.209771270E+03_JPRB,&
! &0.644493139E+03_JPRB,&
! &0.120654163E+03_JPRB,&
! &0.000000000E+00_JPRB/)
!ZAPAD2(2, 2, :) = (/&
! &0.422874202E-09_JPRB,&
! &0.257499477E-05_JPRB,&
! &0.349570458E-02_JPRB,&
! &0.917758876E+00_JPRB,&
! &0.327669989E+02_JPRB,&
! &0.874155115E+02_JPRB,&
! &0.000000000E+00_JPRB/)
!ZAPAD2(2, 3, :) = (/&
! &0.932012720E+02_JPRB,&
! &0.437866983E+03_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E-00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZBPAD2(2, 1, :) = (/&
! &0.577160808E-06_JPRB,&
! &0.682595589E-02_JPRB,&
! &0.508797283E+01_JPRB,&
! &0.223901000E+03_JPRB,&
! &0.770640908E+03_JPRB,&
! &0.186812480E+03_JPRB,&
! &0.100000000E+01_JPRB/)
!ZBPAD2(2, 2, :) = (/&
! &0.422874202E-09_JPRB,&
! &0.257567242E-05_JPRB,&
! &0.349912408E-02_JPRB,&
! &0.920770481E+00_JPRB,&
! &0.330990960E+02_JPRB,&
! &0.903249595E+02_JPRB,&
! &0.100000000E+01_JPRB/)
!ZBPAD2(2, 3, :) = (/&
! &0.932012720E+02_JPRB,&
! &0.439078599E+03_JPRB,&
! &0.100000000E+01_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZRAY2(2,:)= (/&
! &.697200E-02_JPRB, .173297E-01_JPRB,-.850903E-01_JPRB,&
! &.248261E+00_JPRB,-.302031E+00_JPRB, .129662E+00_JPRB/)

ZSWCE2(2) = 0.0_JPRB
ZSWCP2(2) = 0.0_JPRB

!=====================================================================

!*        1.2  COEFFICIENTS FOR FOUR SPECTRAL INTERVALS
!              ----------------------------------------

!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS4 = 1.0_JPRB

!* 1st spectral interval: U.V. and Visible (0.25 - 0.69 Micron)

ZSUN4(1) = 0.459760_JPRB

!-- New coefficients

!ZD4(1,:)= (/ 0.800000000_JPRB, 0.900000000_JPRB, 0.000000000_JPRB /)

!ZAPAD4(1, 1, :) = (/&
! &0.1095121E+03_JPRB,&
! &0.8906647E+03_JPRB,&
! &0.1030601E+03_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB/)
!ZAPAD4(1, 2, :) = (/&
! &0.5124541E+03_JPRB,&
! &0.3478800E+04_JPRB,&
! &0.1244272E+04_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB/)
!ZAPAD4(1, 3, :) = (/&
! &0.4766857E-04_JPRB,&
! &0.4019806E-02_JPRB,&
! &0.1936247E+00_JPRB,&
! &0.1886522E+02_JPRB,&
! &0.6498215E+02_JPRB,&
! &0.1799387E+02_JPRB,&
! &0.0000000E+00_JPRB/)

!ZBPAD4(1, 1, :) = (/&
! &0.1095121E+03_JPRB,&
! &0.8919103E+03_JPRB,&
! &0.1142218E+03_JPRB,&
! &0.1000000E+01_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB/)
!ZBPAD4(1, 2, :) = (/&
! &0.5124541E+03_JPRB,&
! &0.3499516E+04_JPRB,&
! &0.1278186E+04_JPRB,&
! &0.1000000E+01_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB,&
! &0.0000000E-00_JPRB/)
!ZBPAD4(1, 3, :) = (/&
! &0.4766857E-04_JPRB,&
! &0.4153343E-02_JPRB,&
! &0.1925810E+00_JPRB,&
! &0.1938938E+02_JPRB,&
! &0.6918191E+02_JPRB,&
! &0.2278795E+02_JPRB,&
! &0.1000000E+01_JPRB/)

!ZRAY4(1,:)= (/&
! &.389107E-01_JPRB, .101608E+01_JPRB,-.354921E+01_JPRB,&
! &.659510E+01_JPRB,-.592423E+01_JPRB, .202348E+01_JPRB/)

!-- Original coefficients in ECMWF scheme

ZTDH4IS = 0.450_JPRB
ZTDU4IS = 0.375_JPRB
ZTH4IS  = 296._JPRB
ZTU4IS  = 296._JPRB
ZPDH4IS = 0.90_JPRB
ZPDU4IS = 0.75_JPRB
ZPRH4IS = 100000._JPRB
ZPRU4IS = 100000._JPRB

ZD4(1,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD4(1, 1, :) = (/&
 & 0.184678379E+06_JPRB,&
 & 0.553080884E+05_JPRB,&
 & 0.248143712E+04_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD4(1, 2, :) = (/&
 & 0.715303869E+01_JPRB,&
 & 0.219386847E+03_JPRB,&
 & 0.830001089E+03_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD4(1, 3, :) = (/&
 & 0.925887084E-04_JPRB,&
 & 0.129353723E-01_JPRB,&
 & 0.800821928E+00_JPRB,&
 & 0.242715973E+02_JPRB,&
 & 0.878331486E+02_JPRB,&
 & 0.191559725E+02_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD4(1, 1, :) = (/&
 & 0.184678379E+06_JPRB,&
 & 0.555188347E+05_JPRB,&
 & 0.253257443E+04_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD4(1, 2, :) = (/&
 & 0.715303869E+01_JPRB,&
 & 0.219441875E+03_JPRB,&
 & 0.831119997E+03_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD4(1, 3, :) = (/&
 & 0.925887084E-04_JPRB,&
 & 0.131812683E-01_JPRB,&
 & 0.812706117E+00_JPRB,&
 & 0.249863591E+02_JPRB,&
 & 0.931071925E+02_JPRB,&
 & 0.252233437E+02_JPRB,&
 & 0.100000000E+01_JPRB/)  

ZRAY4(1,:)= (/&
 & .428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 & .522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)  

ZSWCE4(1) = 0.0_JPRB
ZSWCP4(1) = 0.0_JPRB

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is sub-divided into:

!     ----------------------------------------------------------------

!* 0.69 - 1.19 Micron

ZSUN4(2) = 0.326158_JPRB

!-- New coefficients

!ZD4(2,:)= (/ 0.000000000_JPRB, 0.900000000_JPRB, 1.000000000_JPRB /)

!ZAPAD4(2, 1, :) = (/&
! &0.1335726E+02_JPRB,&
! &0.2939136E+04_JPRB,&
! &0.4010585E+05_JPRB,&
! &0.7195030E+05_JPRB,&
! &0.1648338E+05_JPRB,&
! &0.3373738E+03_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(2, 2, :) = (/&
! &0.2001271E-01_JPRB,&
! &0.2480831E+01_JPRB,&
! &0.3444162E+02_JPRB,&
! &0.4788946E+02_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(2, 3, :) = (/&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZBPAD4(2, 1, :) = (/&
! &0.1335726E+02_JPRB,&
! &0.2942327E+04_JPRB,&
! &0.4077237E+05_JPRB,&
! &0.7749017E+05_JPRB,&
! &0.2123132E+05_JPRB,&
! &0.6659687E+03_JPRB,&
! &0.1000000E+01_JPRB/)
!ZBPAD4(2, 2, :) = (/&
! &0.2001271E-01_JPRB,&
! &0.2549067E+01_JPRB,&
! &0.3752433E+02_JPRB,&
! &0.6276637E+02_JPRB,&
! &0.1000000E+01_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB/)
!ZBPAD4(2, 3, :) = (/&
! &1.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!DATA (ZRAY4(2,K),K=1,6) /&
! & .519710E-01_JPRB,-.150667E+00_JPRB, .154170E+01_JPRB,&
! &-.518901E+01_JPRB, .668011E+01_JPRB,-.294843E+01_JPRB/

!-- Original coefficients in the ECMWF model

ZD4(2,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 1.000000000_JPRB /)

ZAPAD4(2, 1, :) = (/&
 & 0.690730834E-02_JPRB,&
 & 0.151704275E+01_JPRB,&
 & 0.751477543E+02_JPRB,&
 & 0.759770236E+03_JPRB,&
 & 0.109800326E+04_JPRB,&
 & 0.148407574E+03_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(2, 2, :) = (/&
 & 0.863790752E-03_JPRB,&
 & 0.448762291E+00_JPRB,&
 & 0.332530367E+02_JPRB,&
 & 0.190914146E+03_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(2, 3, :) = (/&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD4(2, 1, :) = (/&
 & 0.690730834E-02_JPRB,&
 & 0.151954406E+01_JPRB,&
 & 0.756512527E+02_JPRB,&
 & 0.779384997E+03_JPRB,&
 & 0.121113108E+04_JPRB,&
 & 0.207678436E+03_JPRB,&
 & 0.100000000E+01_JPRB/)  
ZBPAD4(2, 2, :) = (/&
 & 0.863790752E-03_JPRB,&
 & 0.448948107E+00_JPRB,&
 & 0.333186750E+02_JPRB,&
 & 0.192727216E+03_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZBPAD4(2, 3, :) = (/&
 & 1.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
 
DATA (ZRAY4(2,I_K),I_K=1,6) /&
 & .164261E-01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/  

ZSWCE4(2) = 0.0_JPRB
ZSWCP4(2) = 0.0_JPRB

!     ----------------------------------------------------------------

!* 1.19 - 2.38 Microns

ZSUN4(3) = 0.180608_JPRB

!-- New coefficients

!ZD4(3,:)= (/ 0.000000000_JPRB, 0.800000000_JPRB, 1.000000000_JPRB /)

!ZAPAD4(3, 1, :) = (/&
! &0.3325841E-03_JPRB,&
! &0.6194496E+00_JPRB,&
! &0.1497138E+03_JPRB,&
! &0.2314864E+04_JPRB,&
! &0.2380109E+04_JPRB,&
! &0.9553823E+02_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(3, 2, :) = (/&
! &0.4552471E-03_JPRB,&
! &0.4084154E+00_JPRB,&
! &0.6114905E+01_JPRB,&
! &0.7102540E+01_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(3, 3, :) = (/&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZBPAD4(3, 1, :) = (/&
! &0.3325841E-03_JPRB,&
! &0.6231947E+00_JPRB,&
! &0.1553098E+03_JPRB,&
! &0.2822458E+04_JPRB,&
! &0.3885194E+04_JPRB,&
! &0.2700235E+03_JPRB,&
! &0.1000000E+01_JPRB/)
!ZBPAD4(3, 2, :) = (/&
! &0.4552471E-03_JPRB,&
! &0.4088242E+00_JPRB,&
! &0.6411905E+01_JPRB,&
! &0.9444439E+01_JPRB,&
! &0.1000000E+01_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB/)
!ZBPAD4(3, 3, :) = (/&
! &1.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZRAY4(3,:)= (/&
! &.288474E-02_JPRB, .133984E-02_JPRB,-.152812E-01_JPRB,&
! &.540845E-01_JPRB,-.747444E-01_JPRB, .364285E-01_JPRB/)

ZD4(3,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 1.000000000_JPRB /)

ZAPAD4(3, 1, :) = (/&
 & 0.837531303E-05_JPRB,&
 & 0.173886341E-01_JPRB,&
 & 0.518852799E+01_JPRB,&
 & 0.159078416E+03_JPRB,&
 & 0.493273523E+03_JPRB,&
 & 0.102567293E+03_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(3, 2, :) = (/&
 & 0.657978575E-02_JPRB,&
 & 0.752617872E+00_JPRB,&
 & 0.158209734E+02_JPRB,&
 & 0.410274915E+02_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(3, 3, :) = (/&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD4(3, 1, :) = (/&
 & 0.837531303E-05_JPRB,&
 & 0.174882536E-01_JPRB,&
 & 0.534536580E+01_JPRB,&
 & 0.180351767E+03_JPRB,&
 & 0.673126838E+03_JPRB,&
 & 0.182718543E+03_JPRB,&
 & 0.100000000E+01_JPRB/)  
ZBPAD4(3, 2, :) = (/&
 & 0.657978575E-02_JPRB,&
 & 0.753752065E+00_JPRB,&
 & 0.159286262E+02_JPRB,&
 & 0.424278450E+02_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZBPAD4(3, 3, :) = (/&
 & 1.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZRAY4(3,:)= (/&
 & .180438E-02_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE4(3) = 0.0_JPRB
ZSWCP4(3) = 0.0_JPRB

!     ----------------------------------------------------------------

!* 2.38 - 4.00 Microns

ZSUN4(4) = 0.033474_JPRB

!-- New coefficients

!ZD4(4,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

!ZAPAD4(4, 1, :) = (/&
! &0.2122889E-06_JPRB,&
! &0.9030576E-03_JPRB,&
! &0.2431282E+00_JPRB,&
! &0.4901345E+01_JPRB,&
! &0.3996347E+01_JPRB,&
! &0.3910227E+01_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(4, 2, :) = (/&
! &0.1215163E-03_JPRB,&
! &0.1222574E+00_JPRB,&
! &0.9382420E+01_JPRB,&
! &0.6875727E+02_JPRB,&
! &0.2746421E+02_JPRB,&
! &0.0000000E+00_JPRB,&
! &0.0000000E+00_JPRB/)
!ZAPAD4(4, 3, :) = (/&
! &0.263068898E+02_JPRB,&
! &0.146425875E+03_JPRB,&
! &0.860137809E+02_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZBPAD4(4, 1, :) = (/&
! &0.2122889E-06_JPRB,&
! &0.9379083E-03_JPRB,&
! &0.2957335E+00_JPRB,&
! &0.8747190E+01_JPRB,&
! &0.1015794E+02_JPRB,&
! &0.1361277E+02_JPRB,&
! &0.1000000E+01_JPRB/)
!ZBPAD4(4, 2, :) = (/&
! &0.1215163E-03_JPRB,&
! &0.1255648E+00_JPRB,&
! &0.1060119E+02_JPRB,&
! &0.8414439E+02_JPRB,&
! &0.4299438E+02_JPRB,&
! &0.1000000E+01_JPRB,&
! &0.0000000E+00_JPRB/)
!ZBPAD4(4, 3, :) = (/&
! &0.263068898E+02_JPRB,&
! &0.152569217E+03_JPRB,&
! &0.976791971E+02_JPRB,&
! &0.100000000E+01_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB,&
! &0.000000000E+00_JPRB/)

!ZRAY4(4,:)= (/&
! &.493545E-03_JPRB, .355696E-03_JPRB,-.284543E-02_JPRB,&
! &.741248E-02_JPRB,-.773691E-02_JPRB, .370679E-02_JPRB/)

ZD4(4,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD4(4, 1, :) = (/&
 & 0.122118185E-06_JPRB,&
 & 0.154042531E-02_JPRB,&
 & 0.141152193E+01_JPRB,&
 & 0.685368761E+02_JPRB,&
 & 0.216522281E+03_JPRB,&
 & 0.421228746E+02_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(4, 2, :) = (/&
 & 0.364233560E-10_JPRB,&
 & 0.217340835E-06_JPRB,&
 & 0.292623386E-03_JPRB,&
 & 0.797100631E-01_JPRB,&
 & 0.319103672E+01_JPRB,&
 & 0.110530283E+02_JPRB,&
 & 0.000000000E+00_JPRB/)  
ZAPAD4(4, 3, :) = (/&
 & 0.263068898E+02_JPRB,&
 & 0.146425875E+03_JPRB,&
 & 0.860137809E+02_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD4(4, 1, :) = (/&
 & 0.122118185E-06_JPRB,&
 & 0.156287582E-02_JPRB,&
 & 0.156994562E+01_JPRB,&
 & 0.102304103E+03_JPRB,&
 & 0.475479878E+03_JPRB,&
 & 0.188714799E+03_JPRB,&
 & 0.100000000E+01_JPRB/)  
ZBPAD4(4, 2, :) = (/&
 & 0.364233560E-10_JPRB,&
 & 0.218265806E-06_JPRB,&
 & 0.297085917E-03_JPRB,&
 & 0.834253403E-01_JPRB,&
 & 0.358290002E+01_JPRB,&
 & 0.139206164E+02_JPRB,&
 & 0.100000000E+01_JPRB/)  
ZBPAD4(4, 3, :) = (/&
 & 0.263068898E+02_JPRB,&
 & 0.152569217E+03_JPRB,&
 & 0.976791971E+02_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZRAY4(4,:)= (/&
 & .136020E-03_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE4(4) = 0.0_JPRB
ZSWCP4(4) = 0.0_JPRB

!=====================================================================

!*        1.3  COEFFICIENTS FOR SIX SPECTRAL INTERVALS
!              ---------------------------------------

!* DERIVED FROM HITRAN APRIL 1992 with LOWTRAN P AND T SCALING
!       H2O:  Pref=1000hPa, Tref=296K, Pdep=0.9
!       UMG:  Pref=1000hPa, Tref=296K, Pdep=0.75 (CO2+N2O+CO+CH4+O2)
!       O3 :  unchanged in interval 1, from HITRAN 92 in interval 4

ZADJUS6 = 0.9905709_JPRB
ZADJUS6 = 1.0_JPRB

ZTDH6IS = 0.450_JPRB
ZTDU6IS = 0.375_JPRB
ZTH6IS  = 273._JPRB
ZTU6IS  = 273._JPRB
ZPDH6IS = 0.90_JPRB
ZPDU6IS = 0.75_JPRB
ZPRH6IS = 101300._JPRB
ZPRU6IS = 101300._JPRB

!* 1st spectral interval: U.V.  (0.18 - 0.25 Micron)

ZSUN6(1) = 0.001917_JPRB

ZD6(1,:)= (/ 1.000000000_JPRB, 1.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(1, 1, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD6(1, 2, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD6(1, 3, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
 
ZBPAD6(1, 1, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD6(1, 2, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD6(1, 3, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  

ZRAY6(1,:)= (/&
 & .334018E+00_JPRB,-.298776E+01_JPRB, .613911E+02_JPRB,&
 & -.164331E+03_JPRB, .197946E+03_JPRB,-.652206E+02_JPRB/)  
ZRBY6(1,:)= (/&
 & .43959002E+01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(1) = 0.0_JPRB
ZSWCP6(1) = 0.0_JPRB

NEXPO3(1) = 7
REXPO3(1, 1, :) =(/&
 & 0.051395E+00_JPRB, 0.048250E+00_JPRB, 0.112339E+00_JPRB,&
 & 0.101426E+00_JPRB, 0.007700E+00_JPRB, 0.441320E+00_JPRB,&
 & 0.237571E+00_JPRB /)  
REXPO3(1, 2, :) =(/&
 & 0.100022E+02_JPRB, 0.851159E+02_JPRB, 0.346737E+03_JPRB,&
 & 0.158501E+02_JPRB, 0.724223E+01_JPRB, 0.177828E+03_JPRB,&
 & 0.467708E+02_JPRB /)  
  
!* 2nd spectral interval: U.V.  (0.25 - 0.44 Micron)

ZSUN6(2) = 0.135708_JPRB

ZD6(2,:)= (/ 1.000000000_JPRB, 1.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(2, 1, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD6(2, 2, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZAPAD6(2, 3, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
 
ZBPAD6(2, 1, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD6(2, 2, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
ZBPAD6(2, 3, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
 
ZRAY6(2,:)= (/&
 & -.895408E-03_JPRB, .283130E+01_JPRB,-.867917E+01_JPRB,&
 & .148672E+02_JPRB,-.127282E+02_JPRB, .422212E+01_JPRB/)  
ZRBY6(2,:)= (/&
 & .55503070E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(2) = 0.0_JPRB
ZSWCP6(2) = 0.0_JPRB

NEXPO3(2) = 7
REXPO3(2, 1, :) =(/&
 & 0.043801E+00_JPRB, 0.078893E+00_JPRB, 0.036839E+00_JPRB,&
 & 0.022503E+00_JPRB, 0.042333E+00_JPRB, 0.037870E+00_JPRB,&
 & 0.737762E+00_JPRB /)  
REXPO3(2, 2, :) =(/&
 & 0.234249E+01_JPRB, 0.125170E+00_JPRB, 0.549527E+02_JPRB,&
 & 0.257041E+03_JPRB, 0.476838E+00_JPRB, 0.911993E+01_JPRB,&
 & 0.000000E+00_JPRB /)  

!* 3rd spectral interval: Visible  (0.44 - 0.69 Micron)

ZSUN6(3) = 0.322135_JPRB

ZD6(3,:)= (/ 0.800000000_JPRB, 0.900000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(3, 1, :) = (/&
 & 0.1762097E+03_JPRB,&
 & 0.1641762E+03_JPRB,&
 & 0.8687919E+02_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB/)  
ZAPAD6(3, 2, :) = (/&
 & 0.5581224E+00_JPRB,&
 & 0.1748430E+03_JPRB,&
 & 0.1134123E+04_JPRB,&
 & 0.3490429E+03_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB/)  
ZAPAD6(3, 3, :) = (/&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
 
ZBPAD6(3, 1, :) = (/&
 & 0.1762097E+03_JPRB,&
 & 0.1663950E+03_JPRB,&
 & 0.8939724E+02_JPRB,&
 & 0.1000000E+01_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB/)  
ZBPAD6(3, 2, :) = (/&
 & 0.5581224E+00_JPRB,&
 & 0.1749251E+03_JPRB,&
 & 0.1159910E+04_JPRB,&
 & 0.3893268E+03_JPRB,&
 & 0.1000000E+01_JPRB,&
 & 0.0000000E-00_JPRB,&
 & 0.0000000E-00_JPRB/)  
ZBPAD6(3, 3, :) = (/&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB,&
 & 0.000000000E-00_JPRB/)  
 
ZRAY6(3,:)= (/&
 & .474852E-01_JPRB, .605110E+00_JPRB,-.248070E+01_JPRB,&
 & .485580E+01_JPRB,-.444043E+01_JPRB, .152369E+01_JPRB/)  
ZRBY6(3,:)= (/&
 & .10528199E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(3) = 0.0_JPRB
ZSWCP6(3) = 0.0_JPRB

NEXPO3(3) = 6
REXPO3(3, 1, :) =(/&
 & 0.063442E+00_JPRB, 0.058550E+00_JPRB, 0.237534E+00_JPRB,&
 & 0.412292E+00_JPRB, 0.126141E+00_JPRB, 0.102041E+00_JPRB,&
 & 0.000000E+00_JPRB /)  
REXPO3(3, 2, :) =(/&
 & 0.125170E+00_JPRB, 0.119209E-01_JPRB, 0.119209E+00_JPRB,&
 & 0.417233E-01_JPRB, 0.894070E-01_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  

!     ----------------------------------------------------------------

!* Near-Infrared (0.69 - 4.0 Microns) is sub-divided into:

!     ----------------------------------------------------------------

!* 0.69 - 1.19 Micron

!* UMG is O2 only

ZSUN6(4) = 0.326158_JPRB

ZD6(4,:)= (/ 0.000000000_JPRB, 0.900000000_JPRB, 1.000000000_JPRB /)

ZAPAD6(4, 1, :) = (/&
 & 0.1335726E+02_JPRB,&
 & 0.2939136E+04_JPRB,&
 & 0.4010585E+05_JPRB,&
 & 0.7195030E+05_JPRB,&
 & 0.1648338E+05_JPRB,&
 & 0.3373738E+03_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(4, 2, :) = (/&
 & 0.2001271E-01_JPRB,&
 & 0.2480831E+01_JPRB,&
 & 0.3444162E+02_JPRB,&
 & 0.4788946E+02_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(4, 3, :) = (/&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD6(4, 1, :) = (/&
 & 0.1335726E+02_JPRB,&
 & 0.2942327E+04_JPRB,&
 & 0.4077237E+05_JPRB,&
 & 0.7749017E+05_JPRB,&
 & 0.2123132E+05_JPRB,&
 & 0.6659687E+03_JPRB,&
 & 0.1000000E+01_JPRB/)  
ZBPAD6(4, 2, :) = (/&
 & 0.2001271E-01_JPRB,&
 & 0.2549067E+01_JPRB,&
 & 0.3752433E+02_JPRB,&
 & 0.6276637E+02_JPRB,&
 & 0.1000000E+01_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZBPAD6(4, 3, :) = (/&
 & 1.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  
 
ZRAY6(4,:)= (/&
 & .519710E-01_JPRB,-.150667E+00_JPRB, .154170E+01_JPRB,&
 & -.518901E+01_JPRB, .668011E+01_JPRB,-.294843E+01_JPRB/)  
ZRBY6(4,:)= (/&
 & .16436996E-01_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(4) = 0.0_JPRB
ZSWCP6(4) = 0.0_JPRB

NEXPO3(4) = 4
REXPO3(4, 1, :) =(/&
 & 0.000074E+00_JPRB, 0.320194E+00_JPRB, 0.082915E+00_JPRB,&
 & 0.596816E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  
REXPO3(4, 2, :) =(/&
 & 0.232458E+00_JPRB, 0.119209E-01_JPRB, 0.178814E-01_JPRB,&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  

!     ----------------------------------------------------------------

!* 1.19 - 2.38 Microns

!* UMG is CO2 only

ZSUN6(5) = 0.180608_JPRB

ZD6(5,:)= (/ 0.000000000_JPRB, 0.800000000_JPRB, 1.000000000_JPRB /)

ZAPAD6(5, 1, :) = (/&
 & 0.3325841E-03_JPRB,&
 & 0.6194496E+00_JPRB,&
 & 0.1497138E+03_JPRB,&
 & 0.2314864E+04_JPRB,&
 & 0.2380109E+04_JPRB,&
 & 0.9553823E+02_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(5, 2, :) = (/&
 & 0.4552471E-03_JPRB,&
 & 0.4084154E+00_JPRB,&
 & 0.6114905E+01_JPRB,&
 & 0.7102540E+01_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(5, 3, :) = (/&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD6(5, 1, :) = (/&
 & 0.3325841E-03_JPRB,&
 & 0.6231947E+00_JPRB,&
 & 0.1553098E+03_JPRB,&
 & 0.2822458E+04_JPRB,&
 & 0.3885194E+04_JPRB,&
 & 0.2700235E+03_JPRB,&
 & 0.1000000E+01_JPRB/)  
ZBPAD6(5, 2, :) = (/&
 & 0.4552471E-03_JPRB,&
 & 0.4088242E+00_JPRB,&
 & 0.6411905E+01_JPRB,&
 & 0.9444439E+01_JPRB,&
 & 0.1000000E+01_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZBPAD6(5, 3, :) = (/&
 & 1.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZRAY6(5,:)= (/&
 & .288474E-02_JPRB, .133984E-02_JPRB,-.152812E-01_JPRB,&
 & .540845E-01_JPRB,-.747444E-01_JPRB, .364285E-01_JPRB/)  
ZRBY6(5,:)= (/&
 & .18073079E-02_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(5) = 0.0_JPRB
ZSWCP6(5) = 0.0_JPRB

NEXPO3(5) = 0
REXPO3(5, 1, :) =(/&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  
REXPO3(5, 2, :) =(/&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  

!     ----------------------------------------------------------------

!* 2.38 - 4.00 Microns

ZSUN6(6) = 0.033474_JPRB

ZD6(6,:)= (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.000000000_JPRB /)

ZAPAD6(6, 1, :) = (/&
 & 0.2122889E-06_JPRB,&
 & 0.9030576E-03_JPRB,&
 & 0.2431282E+00_JPRB,&
 & 0.4901345E+01_JPRB,&
 & 0.3996347E+01_JPRB,&
 & 0.3910227E+01_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(6, 2, :) = (/&
 & 0.1215163E-03_JPRB,&
 & 0.1222574E+00_JPRB,&
 & 0.9382420E+01_JPRB,&
 & 0.6875727E+02_JPRB,&
 & 0.2746421E+02_JPRB,&
 & 0.0000000E+00_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZAPAD6(6, 3, :) = (/&
 & 0.263068898E+02_JPRB,&
 & 0.146425875E+03_JPRB,&
 & 0.860137809E+02_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZBPAD6(6, 1, :) = (/&
 & 0.2122889E-06_JPRB,&
 & 0.9379083E-03_JPRB,&
 & 0.2957335E+00_JPRB,&
 & 0.8747190E+01_JPRB,&
 & 0.1015794E+02_JPRB,&
 & 0.1361277E+02_JPRB,&
 & 0.1000000E+01_JPRB/)  
ZBPAD6(6, 2, :) = (/&
 & 0.1215163E-03_JPRB,&
 & 0.1255648E+00_JPRB,&
 & 0.1060119E+02_JPRB,&
 & 0.8414439E+02_JPRB,&
 & 0.4299438E+02_JPRB,&
 & 0.1000000E+01_JPRB,&
 & 0.0000000E+00_JPRB/)  
ZBPAD6(6, 3, :) = (/&
 & 0.263068898E+02_JPRB,&
 & 0.152569217E+03_JPRB,&
 & 0.976791971E+02_JPRB,&
 & 0.100000000E+01_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB,&
 & 0.000000000E+00_JPRB/)  

ZRAY6(6,:)= (/&
 & .493545E-03_JPRB, .355696E-03_JPRB,-.284543E-02_JPRB,&
 & .741248E-02_JPRB,-.773691E-02_JPRB, .370679E-02_JPRB/)  
ZRBY6(6,:)= (/&
 & .13618247E-03_JPRB, .000000E+00_JPRB, .000000E+00_JPRB,&
 & .000000E+00_JPRB, .000000E+00_JPRB, .000000E+00_JPRB/)  

ZSWCE6(6) = 0.0_JPRB
ZSWCP6(6) = 0.0_JPRB

NEXPO3(6) = 0
REXPO3(6, 1, :) =(/&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  
REXPO3(6, 2, :) =(/&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB, 0.000000E+00_JPRB, 0.000000E+00_JPRB,&
 & 0.000000E+00_JPRB /)  

!=====================================================================
!*    2.4   OPTICAL PARAMETERS FOR RAIN DROPS
!           Savijarvi et al. (1996)

ZRTO1 =  0.003_JPRB
ZRTO2 = -0.22_JPRB
! CAUTION JUST TEMPORARY PARAMETERS      
ZROMA2(1:2)= (/ 0.00008_JPRB , 0.264_JPRB  /)
ZROMB2(1:2)= (/ 0.23_JPRB    , 0.09_JPRB   /)
ZRASY2(1:2)= (/ 0.88_JPRB    , 0.94_JPRB   /)

ZRA2(1:2)= (/ 1.5_JPRB     , 1.5_JPRB    /)
ZRB2(1:2)= (/ 0.50_JPRB    , 1.13_JPRB   /)
ZRC2(1:2)= (/ 5.58E-7_JPRB , 8.55E-4_JPRB/)
ZRD2(1:2)= (/ 1.25E-7_JPRB , 1.28E-3_JPRB/)
ZRE2(1:2)= (/ 0.841_JPRB   , 0.786_JPRB  /)
ZRF2(1:2)= (/ 2.08E-3_JPRB , 5.32E-3_JPRB/)

ZROMA4(1:4)= (/ 0.00008_JPRB , 0.0105_JPRB , 0.264_JPRB  , 0.465_JPRB   /)
ZROMB4(1:4)= (/ 0.23_JPRB    , 0.22_JPRB   , 0.09_JPRB   , 0.001_JPRB   /)
ZRASY4(1:4)= (/ 0.88_JPRB    , 0.89_JPRB   , 0.94_JPRB   , 0.97_JPRB    /)

ZRA4(1:4)= (/ 1.5_JPRB     , 1.5_JPRB    , 1.5_JPRB    , 1.5_JPRB     /)
ZRB4(1:4)= (/ 0.50_JPRB    , 0.78_JPRB   , 1.13_JPRB   , 2.00_JPRB    /)
ZRC4(1:4)= (/ 5.58E-7_JPRB , 2.18E-5_JPRB, 8.55E-4_JPRB, 1.94E-1_JPRB /)
ZRD4(1:4)= (/ 1.25E-7_JPRB , 2.25E-5_JPRB, 1.28E-3_JPRB, 8.04E-3_JPRB /)
ZRE4(1:4)= (/ 0.841_JPRB   , 0.821_JPRB  , 0.786_JPRB  , 0.820_JPRB   /)
ZRF4(1:4)= (/ 2.08E-3_JPRB , 3.06E-3_JPRB, 5.32E-3_JPRB, 5.59E-3_JPRB /)

ZROMA6(1:6)= (/ 0.00008_JPRB , 0.00008_JPRB , 0.00008_JPRB , 0.0105_JPRB , 0.264_JPRB  , 0.465_JPRB   /)
ZROMB6(1:6)= (/ 0.23_JPRB    , 0.23_JPRB    , 0.23_JPRB    , 0.22_JPRB   , 0.09_JPRB   , 0.001_JPRB   /)
ZRASY6(1:6)= (/ 0.88_JPRB    , 0.88_JPRB    , 0.88_JPRB    , 0.89_JPRB   , 0.94_JPRB   , 0.97_JPRB    /)

ZRA6(1:6)= (/ 1.5_JPRB     , 1.5_JPRB     , 1.5_JPRB     , 1.5_JPRB    , 1.5_JPRB    , 1.5_JPRB     /)
ZRB6(1:6)= (/ 0.50_JPRB    , 0.50_JPRB    , 0.50_JPRB    , 0.78_JPRB   , 1.13_JPRB   , 2.00_JPRB    /)
ZRC6(1:6)= (/ 5.58E-7_JPRB , 5.58E-7_JPRB , 5.58E-7_JPRB , 2.18E-5_JPRB, 8.55E-4_JPRB, 1.94E-1_JPRB /)
ZRD6(1:6)= (/ 1.25E-7_JPRB , 1.25E-7_JPRB , 1.25E-7_JPRB , 2.25E-5_JPRB, 1.28E-3_JPRB, 8.04E-3_JPRB /)
ZRE6(1:6)= (/ 0.841_JPRB   , 0.841_JPRB   , 0.841_JPRB   , 0.821_JPRB  , 0.786_JPRB  , 0.820_JPRB   /)
ZRF6(1:6)= (/ 2.08E-3_JPRB , 2.08E-3_JPRB , 2.08E-3_JPRB , 3.06E-3_JPRB, 5.32E-3_JPRB, 5.59E-3_JPRB /)

!=====================================================================
!       3.    FOURTEEN SPECTRAL INTERVALS FOR RRTM_SW

! SW : 14 spectral intervals : mapping to SW6 spectral intervals
!                                  0.185-0.25-0.44-0.69-1.19-2.38-4.00
!  3.846 -  3.077                  6
!  3.077 -  2.500                  6
!  2.500 -  2.150                  5  
!  2.150 -  1.942                  5
!  1.942 -  1.626                  5
!  1.626 -  1.299                  5
!  1.299 -  1.242                  5
!  1.242 -  0.7782                 4
!  0.7782-  0.6250                 4
!  0.6250-  0.4415                 3
!  0.4415-  0.3448                 2  
!  0.3448-  0.2632                 2 
!  0.2632-  0.2000                 1
! 12.195 -  3.846                  6

IMPSRTM(1:14)= (/ 6,6,5,5,5,5,5,4,4,3,2,2,1,6 /)
!=====================================================================

!*       4.    SET VALUES.
!              -----------

IF (LONEWSW) THEN
  ZPDH2O = ZPDHNIS
  ZPDUMG = ZPDUNIS
  ZPRH2O = ZPRHNIS
  ZPRUMG = ZPRUNIS
  RTDH2O = ZTDHNIS
  RTDUMG = ZTDUNIS
  RTH2O  = ZTHNIS
  RTUMG  = ZTUNIS
ENDIF

RPDH1=ZPDH2O+1.0_JPRB
RPDU1=ZPDUMG+1.0_JPRB
ZH2O=1.0_JPRB/( 10._JPRB* RG * RPDH1 )
ZUMG=1.0_JPRB/( 10._JPRB* RG * RPDU1 )
RPNU = ZUMG/(ZPRUMG**ZPDUMG)
RPNH = ZH2O/(ZPRH2O**ZPDH2O)

IF(.NOT.ALLOCATED(RSUN)) ALLOCATE (RSUN(NTSW))

DO JW=1,ISW6
  RSUN(JW)=0.0_JPRB
  RSWCE(JW)=0.0_JPRB
  RSWCP(JW)=0.0_JPRB
  
  DO JC3=1,3
    D(JW,JC3)=0.0_JPRB
  ENDDO
  DO JC6=1,6
    RRAY(JW,JC6)=0.0_JPRB
  ENDDO
  DO JI=1,3
    DO JJ=1,7
      APAD(JW,JI,JJ)=0.0_JPRB
      BPAD(JW,JI,JJ)=0.0_JPRB
    ENDDO
  ENDDO
ENDDO

IF (KSW == 2) THEN
  ZPDH2O = ZPDH2IS
  ZPDUMG = ZPDU2IS
  ZPRH2O = ZPRH2IS
  ZPRUMG = ZPRU2IS
  RTDH2O = ZTDH2IS
  RTDUMG = ZTDU2IS
  RTH2O  = ZTH2IS
  RTUMG  = ZTU2IS
  
  RADJUST=ZADJUS2
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN2(JW)

    RSWCE(JW)=ZSWCE2(JW)
    RSWCP(JW)=ZSWCP2(JW)

    RROMA(JW)=ZROMA2(JW)
    RROMB(JW)=ZROMB2(JW)
    RRASY(JW)=ZRASY2(JW)
    RHSRA(JW)=ZRA2(JW)
    RHSRB(JW)=ZRB2(JW)
    RHSRC(JW)=ZRC2(JW)
    RHSRD(JW)=ZRD2(JW)
    RHSRE(JW)=ZRE2(JW)
    RHSRF(JW)=ZRF2(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD2(JW,JC3)
    ENDDO
    DO JC6=1,6
      RRAY(JW,JC6)=ZRAY2(JW,JC6)
    ENDDO
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD2(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD2(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
ELSEIF (KSW == 4) THEN
  ZPDH2O = ZPDH4IS
  ZPDUMG = ZPDU4IS
  ZPRH2O = ZPRH4IS
  ZPRUMG = ZPRU4IS
  RTDH2O = ZTDH4IS
  RTDUMG = ZTDU4IS
  RTH2O  = ZTH4IS
  RTUMG  = ZTU4IS
  
  RADJUST=ZADJUS4
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN4(JW)

    RSWCE(JW)=ZSWCE4(JW)
    RSWCP(JW)=ZSWCP4(JW)

    RROMA(JW)=ZROMA4(JW)
    RROMB(JW)=ZROMB4(JW)
    RRASY(JW)=ZRASY4(JW)
    RHSRA(JW)=ZRA4(JW)
    RHSRB(JW)=ZRB4(JW)
    RHSRC(JW)=ZRC4(JW)
    RHSRD(JW)=ZRD4(JW)
    RHSRE(JW)=ZRE4(JW)
    RHSRF(JW)=ZRF4(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD4(JW,JC3)
    ENDDO
    DO JC6=1,6
      RRAY(JW,JC6)=ZRAY4(JW,JC6)
    ENDDO
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD4(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD4(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
ELSEIF (KSW == 6) THEN
  ZPDH2O = ZPDH6IS
  ZPDUMG = ZPDU6IS
  ZPRH2O = ZPRH6IS
  ZPRUMG = ZPRU6IS
  RTDH2O = ZTDH6IS
  RTDUMG = ZTDU6IS
  RTH2O  = ZTH6IS
  RTUMG  = ZTU6IS
  
  RADJUST=ZADJUS6
  RHSRTA=ZRTO1
  RHSRTB=ZRTO2
  DO JW=1,KSW
    RSUN (JW)=ZSUN6(JW)

    RSWCE(JW)=ZSWCE6(JW)
    RSWCP(JW)=ZSWCP6(JW)

    RROMA(JW)=ZROMA6(JW)
    RROMB(JW)=ZROMB6(JW)
    RRASY(JW)=ZRASY6(JW)
    RHSRA(JW)=ZRA6(JW)
    RHSRB(JW)=ZRB6(JW)
    RHSRC(JW)=ZRC6(JW)
    RHSRD(JW)=ZRD6(JW)
    RHSRE(JW)=ZRE6(JW)
    RHSRF(JW)=ZRF6(JW)

    DO JC3=1,3
      D(JW,JC3)=ZD6(JW,JC3)
    ENDDO
    IF (LRAYL) THEN
      DO JC6=1,6
        RRAY(JW,JC6)=ZRAY6(JW,JC6)
      ENDDO
    ELSE  
      DO JC6=1,6
        RRAY(JW,JC6)=ZRBY6(JW,JC6)
      ENDDO
    ENDIF  
    DO JI=1,3
      DO JJ=1,7
        APAD(JW,JI,JJ)=ZAPAD6(JW,JI,JJ)
        BPAD(JW,JI,JJ)=ZBPAD6(JW,JI,JJ)
      ENDDO
    ENDDO
  ENDDO
  
ELSEIF (KTSW == 14 .AND. KSW == 14) THEN
  PRINT *,'SUSWN: 14-SPECTRAL INTERVALS --> RRTM_SW'
  
ELSE
  PRINT *,'SUSWN: NTSW, NSW: ',KTSW,KSW
  CALL ABOR1('SUSWN: WRONG NUMBER OF SW INTERVALS')
ENDIF

!     ----------------------------------------------------------------

!*       5.    PRINT VALUES.
!              ------------

!     PRINT 9700,RPDH1,RPDU1,RPNU,RPNH
!9700 FORMAT(1X,'RPDH1,RPDU1,RPNU,RPNH ',4F10.5)      
!     DO JW=1,KSW      
!       PRINT *,' SW INTERVAL ',JW
!       PRINT 9701,JW,RSUN(JW),RSWCE(JW),RSWCP(JW)
!9701   FORMAT(1X,I3,F10.7,2F10.5)
!       PRINT 9702,JW,(D(JW,JC3),JC3=1,3)
!9702   FORMAT(1X,I3,3F10.5)
!       PRINT 9703,JW,(RRAY(JW,JC6),JC6=1,6)
!9703   FORMAT(1X,I3,6E15.8)
!       PRINT 9704,JW,(JABS,(APAD(JW,JABS,JJ),JJ=1,7),JABS=1,3)
!9704   FORMAT(1X,I3,(I3,7E15.8))
!       PRINT 9706,JW,RROMA(JW),RROMB(JW),RRASY(JW),RHSRTA,RHSRTB
!9706   FORMAT(1X,I3,' Rain Optics from Rain Rate: ',F8.5,F6.3,3F6.3)
!       PRINT 9707,JW,RHSRA(JW),RHSRB(JW),RHSRC(JW),RHSRD(JW)
!    &   ,RHSRE(JW),RHSRF(JW)  
!9707   FORMAT(1X,I3,' Rain Optics as function of Reff: ',6E11.4)
!     ENDDO

!     ----------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('SUSWN',1,ZHOOK_HANDLE)
END SUBROUTINE SUSWN
