MODULE YOMSC2

USE PARKIND1  ,ONLY : JPIM

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------

! NSLWIDE    : NUMBER OF "ROWS" THE MODEL LAGGED PART RUNS BEHIND
! NOBWIDE    : NUMBER OF "ROWS" FOR OBSERVATION HALO
! NRIWIDEN   : NUMBER OF "ROWS" FOR RADIATION INPUT NORTH (MODEL GRID)
! NRIWIDES   : NUMBER OF "ROWS" FOR RADIATION INPUT SOUTH (MODEL GRID)
! NRIWIDEW   : NUMBER OF "ROWS" FOR RADIATION INPUT WEST  (MODEL GRID)
! NRIWIDEE   : NUMBER OF "ROWS" FOR RADIATION INPUT EAST  (MODEL GRID)
! NROWIDEN   : NUMBER OF "ROWS" FOR RADIATION OUTPUT NORTH (RADIATION GRID)
! NROWIDES   : NUMBER OF "ROWS" FOR RADIATION OUTPUT SOUTH (RADIATION GRID)
! NROWIDEW   : NUMBER OF "ROWS" FOR RADIATION OUTPUT WEST  (RADIATION GRID)
! NROWIDEE   : NUMBER OF "ROWS" FOR RADIATION OUTPUT EAST  (RADIATION GRID)
! NFLDSLB1   : NUMBER OF FIELDS IN SEMI-LAGRANGIAN BUFFER 1
! NFLDSLB2   : NUMBER OF FIELDS IN SEMI-LAGRANGIAN BUFFER 2
! NFLDOBB1   : NUMBER OF FIELDS IN OBSERVATION BUFFER 1
! NFLDSLB15  : NUMBER OF FIELDS IN SEMI-LAGRANGIAN BUFFER 15 (TL and adjoint)
! NDIST      : START ADRESS FOR EACH ROW IN GRID-POINT CALCULATIONS
! NDIEND     : END   ADRESS FOR EACH ROW IN GRID-POINT CALCULATIONS
! NCIST      : START ADRESS FOR EACH ROW OF GRID-POINT FIELD IN BUFFER
! NCIEND     : END   ADRESS FOR EACH ROW OF GRID-POINT FIELD IN BUFFER

INTEGER(KIND=JPIM),ALLOCATABLE:: NDIST(:)
INTEGER(KIND=JPIM),ALLOCATABLE:: NDIEND(:)
INTEGER(KIND=JPIM),ALLOCATABLE:: NCIST(:)
INTEGER(KIND=JPIM),ALLOCATABLE:: NCIEND(:)

INTEGER(KIND=JPIM) :: NSLWIDE
INTEGER(KIND=JPIM) :: NFLDSLB1
INTEGER(KIND=JPIM) :: NFLDSLB2
INTEGER(KIND=JPIM) :: NFLDOBB1
INTEGER(KIND=JPIM) :: NFLDSLB15
INTEGER(KIND=JPIM) :: NOBWIDE
INTEGER(KIND=JPIM) :: NRIWIDEN
INTEGER(KIND=JPIM) :: NRIWIDES
INTEGER(KIND=JPIM) :: NRIWIDEW
INTEGER(KIND=JPIM) :: NRIWIDEE
INTEGER(KIND=JPIM) :: NROWIDEN
INTEGER(KIND=JPIM) :: NROWIDES
INTEGER(KIND=JPIM) :: NROWIDEW
INTEGER(KIND=JPIM) :: NROWIDEE

!-----------------------------------------------------------------------
!$OMP THREADPRIVATE(nfldobb1,nfldslb1,nfldslb15,nfldslb2,nobwide,nriwidee,nriwiden,nriwides)
!$OMP THREADPRIVATE(nriwidew,nrowidee,nrowiden,nrowides,nrowidew,nslwide)
!$OMP THREADPRIVATE(nciend,ncist,ndiend,ndist)
END MODULE YOMSC2
