SUBROUTINE CALCUL_CLOUD_OVERLAP_DECORR_LEN &
     & (KIDIA, KFDIA, KLON, KLEV, &
     &  driver_config, &
     &  pressure_hl, &
     &  PDECORR_LEN_EDGES_M, PDECORR_LEN_WATER_M, PDECORR_LEN_RATIO)

! A Idelkadi ! -------------
! 04 2024
! Depart de la routine de l' IFS
! But : calcul de la Ld (longueur de decorrelation)
! Dans le cas overlap_scheme_name=="Exp-Ran"
! 3 cas en fonction de kdecolat (namelist_ecrad) :
! 0 => Ld=overlap_decorr_length (namelist_ecrad)
! 1 => Ld=f(latitude) Shonk et al. (2010) Eq. 13 formula
! 2 => Ld=f(latitude) Shonk et al. (2010) lissee a l equateur
! 3 => Ld=f(pres) : 
!      Ld=low_decorrelation_length si pres >= 680hPa 
!      Ld=mid_decorrelation_length si pres entre [440,680]
!      Ld=high_decorrelation_length si pres < 440hPa
!
! TO DO 
! Que faire de PDECORR_LEN_WATER_M ?
! -------------------------------------------------------------------

USE PARKIND1 , ONLY : JPIM, JPRB
USE YOMHOOK  , ONLY : LHOOK, DR_HOOK, JPHOOK
USE YOMCST   , ONLY : RPI
USE geometry_mod, ONLY: latitude_deg
USE lmdz_cloud_optics_prop_ini , ONLY : prmhc, prlmc
USE setup_config_from_lmdz,   ONLY : driver_config_type
USE write_field_phy
! -------------------------------------------------------------------

IMPLICIT NONE

! INPUT ARGUMENTS

! *** Array dimensions and ranges
INTEGER(KIND=JPIM),INTENT(IN) :: KIDIA    ! Start column to process
INTEGER(KIND=JPIM),INTENT(IN) :: KFDIA    ! End column to process
INTEGER(KIND=JPIM),INTENT(IN) :: KLON     ! Number of columns
! AI 04 2024
INTEGER(KIND=JPIM),INTENT(IN) :: KLEV

! *** Single-level variables 
!AI 04 2024
REAL(KIND=JPRB), intent(in)   :: pressure_hl(KLON,KLEV+1)
type(driver_config_type),intent(in)   :: driver_config

! OUTPUT ARGUMENTS

! *** Decorrelation lengths for cloud edges and cloud water content, in m
! A.I 04 2024
REAL(KIND=JPRB), INTENT(OUT)           :: PDECORR_LEN_EDGES_M(KLON,KLEV)
REAL(KIND=JPRB), INTENT(OUT), OPTIONAL :: PDECORR_LEN_WATER_M(KLON,KLEV)
  
! Ratio of water-content to cloud-edge decorrelation lengths
REAL(KIND=JPRB), INTENT(OUT), OPTIONAL :: PDECORR_LEN_RATIO

! LOCAL VARIABLES

REAL(KIND=JPRB) :: ZRADIANS_TO_DEGREES, ZABS_LAT_DEG, ZCOS_LAT

! AI 04 2024
REAL(KIND=JPRB) :: PGEMU(KLON) ! Sine of latitude
REAL(KIND=JPRB) :: RDECORR_CF
REAL(KIND=JPRB) :: RDECORR_CW = 1.0_JPRB

INTEGER(KIND=JPIM) :: JL, JK

REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

! -------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('CLOUD_OVERLAP_DECORR_LEN',0,ZHOOK_HANDLE)
  
! -------------------------------------------------------------------
print*,'driver_config%kdecolat = ', driver_config%kdecolat

IF (driver_config%kdecolat == 0) THEN

  ! Decorrelation lengths are constant values
  ! overlap_decorr_length lu dans namelist en m
  RDECORR_CF = driver_config%overlap_decorr_length / 1000.0_JPRB
  PDECORR_LEN_EDGES_M(KIDIA:KFDIA,:) = driver_config%overlap_decorr_length
!  IF (PRESENT(PDECORR_LEN_WATER_M)) THEN
!    PDECORR_LEN_WATER_M = RDECORR_CW * 1000.0_JPRB
!  ENDIF
!  IF (PRESENT(PDECORR_LEN_RATIO)) THEN
!    PDECORR_LEN_RATIO = RDECORR_CW / RDECORR_CF
!  ENDIF

ELSE

  ZRADIANS_TO_DEGREES = 180.0_JPRB / RPI
  PGEMU = SIN(latitude_deg)

  IF (driver_config%kdecolat == 1) THEN
    ! Shonk et al. (2010) Eq. 13 formula
    DO JL = KIDIA,KFDIA
      ZABS_LAT_DEG = ABS(ASIN(PGEMU(JL)) * ZRADIANS_TO_DEGREES)
      PDECORR_LEN_EDGES_M(JL,:) = (2.899_JPRB - 0.02759_JPRB * ZABS_LAT_DEG) * 1000.0_JPRB
    ENDDO
  ELSE ! KDECOLAT == 2
    DO JL = KIDIA,KFDIA
      ! Shonk et al. (2010) but smoothed over the equator
      ZCOS_LAT = COS(ASIN(PGEMU(JL)))
      PDECORR_LEN_EDGES_M(JL,:) = (0.75_JPRB + 2.149_JPRB * ZCOS_LAT*ZCOS_LAT) * 1000.0_JPRB
    ENDDO
  ENDIF


  ! Both KDECOLAT = 1 and 2 assume that the decorrelation length for
  ! cloud water content is half that for cloud edges
!  IF (PRESENT(PDECORR_LEN_WATER_M)) THEN
!    PDECORR_LEN_WATER_M(KIDIA:KFDIA,:) = PDECORR_LEN_EDGES_M(KIDIA:KFDIA,:) * 0.5_JPRB 
!  ENDIF

!  IF (PRESENT(PDECORR_LEN_RATIO)) THEN
!    PDECORR_LEN_RATIO = 0.5_JPRB
!  ENDIF

ENDIF

!AI 04 2024
IF (driver_config%kdecolat == 3) THEN
  DO jk = 1, klev
      DO JL = 1, klon
        IF (pressure_hl(JL,jk)<prmhc) THEN
          PDECORR_LEN_EDGES_M(JL,jk) = driver_config%high_decorrelation_length
        ELSE IF (pressure_hl(JL,jk)>=prmhc .AND. pressure_hl(JL,jk)<prlmc) THEN
          PDECORR_LEN_EDGES_M(JL,jk) = driver_config%mid_decorrelation_length
        ELSE IF (pressure_hl(JL,jk)>=prlmc) THEN
          PDECORR_LEN_EDGES_M(JL,jk) = driver_config%low_decorrelation_length
        ENDIF
      ENDDO
  ENDDO
  
  ! Both KDECOLAT = 1 and 2 assume that the decorrelation length for
  ! cloud water content is half that for cloud edges
!  IF (PRESENT(PDECORR_LEN_WATER_M)) THEN
!    PDECORR_LEN_WATER_M(KIDIA:KFDIA,:) = PDECORR_LEN_EDGES_M(KIDIA:KFDIA,:) * 0.5_JPRB 
!  ENDIF
!  IF (PRESENT(PDECORR_LEN_RATIO)) THEN
!    PDECORR_LEN_RATIO = 0.5_JPRB
!  ENDIF
ENDIF
!CALL writefield_phy('latitude',latitude_deg,1)
!CALL writefield_phy('pressure_hl',pressure_hl,klev+1)
!CALL writefield_phy('Ldecorel',PDECORR_LEN_EDGES_M,klev)
! -------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('CLOUD_OVERLAP_DECORR_LEN',1,ZHOOK_HANDLE)

END SUBROUTINE CALCUL_CLOUD_OVERLAP_DECORR_LEN
