!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
SUBROUTINE SRTM_KGB23

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 16:  8050-12850 cm-1 (low - H2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA23, ONLY : KA, SELFREF, FORREF, SFLUXREF, RAYL &
 & , GIVFAC, LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB23',0,ZHOOK_HANDLE)
SFLUXREF = (/ &
 & 53.2101_JPRB , 51.4143_JPRB, 49.3348_JPRB, 45.4612_JPRB    , &
 & 40.8294_JPRB , 35.1801_JPRB, 28.6947_JPRB, 21.5751_JPRB    , &
 & 14.6388_JPRB , 1.59111_JPRB, 1.31860_JPRB, 1.04018_JPRB    , &
 & 0.762140_JPRB,0.484214_JPRB,0.182275_JPRB, 2.54948E-02_JPRB /)  

!     Rayleigh extinction coefficient at all v 
RAYL = (/ &
 & 5.94837E-08_JPRB,5.70593E-08_JPRB,6.27845E-08_JPRB,5.56602E-08_JPRB, &
 & 5.25571E-08_JPRB,4.73388E-08_JPRB,4.17466E-08_JPRB,3.98097E-08_JPRB, &
 & 4.00786E-08_JPRB,3.67478E-08_JPRB,3.45186E-08_JPRB,3.46156E-08_JPRB, &
 & 3.32155E-08_JPRB,3.23642E-08_JPRB,2.72590E-08_JPRB,2.96813E-08_JPRB /)  

!     Average Giver et al. correction factor for this band.
GIVFAC = 1.029_JPRB

LAYREFFR = 6

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1) = (/ &
 & 0.33078E-07_JPRB,0.34034E-07_JPRB,0.35124E-07_JPRB,0.34187E-07_JPRB,0.34744E-07_JPRB /)  
KA(:, 2, 1) = (/ &
 & 0.25544E-07_JPRB,0.25873E-07_JPRB,0.26742E-07_JPRB,0.27512E-07_JPRB,0.27504E-07_JPRB /)  
KA(:, 3, 1) = (/ &
 & 0.18549E-07_JPRB,0.19611E-07_JPRB,0.20840E-07_JPRB,0.22548E-07_JPRB,0.23069E-07_JPRB /)  
KA(:, 4, 1) = (/ &
 & 0.28794E-07_JPRB,0.30837E-07_JPRB,0.32679E-07_JPRB,0.34307E-07_JPRB,0.36901E-07_JPRB /)  
KA(:, 5, 1) = (/ &
 & 0.36776E-07_JPRB,0.39144E-07_JPRB,0.41300E-07_JPRB,0.43264E-07_JPRB,0.46626E-07_JPRB /)  
KA(:, 6, 1) = (/ &
 & 0.59710E-07_JPRB,0.62941E-07_JPRB,0.65500E-07_JPRB,0.67353E-07_JPRB,0.68774E-07_JPRB /)  
KA(:, 7, 1) = (/ &
 & 0.12143E-06_JPRB,0.12932E-06_JPRB,0.13250E-06_JPRB,0.13526E-06_JPRB,0.13849E-06_JPRB /)  
KA(:, 8, 1) = (/ &
 & 0.12531E-06_JPRB,0.13241E-06_JPRB,0.13939E-06_JPRB,0.14705E-06_JPRB,0.15465E-06_JPRB /)  
KA(:, 9, 1) = (/ &
 & 0.20209E-06_JPRB,0.21134E-06_JPRB,0.22163E-06_JPRB,0.23098E-06_JPRB,0.24004E-06_JPRB /)  
KA(:,10, 1) = (/ &
 & 0.10750E-05_JPRB,0.11204E-05_JPRB,0.11575E-05_JPRB,0.11923E-05_JPRB,0.12227E-05_JPRB /)  
KA(:,11, 1) = (/ &
 & 0.27782E-05_JPRB,0.28204E-05_JPRB,0.28406E-05_JPRB,0.28380E-05_JPRB,0.28440E-05_JPRB /)  
KA(:,12, 1) = (/ &
 & 0.38510E-05_JPRB,0.39934E-05_JPRB,0.40697E-05_JPRB,0.41102E-05_JPRB,0.41571E-05_JPRB /)  
KA(:,13, 1) = (/ &
 & 0.43157E-05_JPRB,0.44488E-05_JPRB,0.45799E-05_JPRB,0.46585E-05_JPRB,0.47223E-05_JPRB /)  
KA(:, 1, 2) = (/ &
 & 0.84637E-06_JPRB,0.86989E-06_JPRB,0.90697E-06_JPRB,0.90000E-06_JPRB,0.91373E-06_JPRB /)  
KA(:, 2, 2) = (/ &
 & 0.67062E-06_JPRB,0.68649E-06_JPRB,0.72334E-06_JPRB,0.73645E-06_JPRB,0.72978E-06_JPRB /)  
KA(:, 3, 2) = (/ &
 & 0.52317E-06_JPRB,0.53924E-06_JPRB,0.55425E-06_JPRB,0.58347E-06_JPRB,0.57813E-06_JPRB /)  
KA(:, 4, 2) = (/ &
 & 0.39868E-06_JPRB,0.41431E-06_JPRB,0.42761E-06_JPRB,0.43892E-06_JPRB,0.45982E-06_JPRB /)  
KA(:, 5, 2) = (/ &
 & 0.32074E-06_JPRB,0.33452E-06_JPRB,0.34754E-06_JPRB,0.35582E-06_JPRB,0.37378E-06_JPRB /)  
KA(:, 6, 2) = (/ &
 & 0.42465E-06_JPRB,0.44058E-06_JPRB,0.45605E-06_JPRB,0.47192E-06_JPRB,0.48493E-06_JPRB /)  
KA(:, 7, 2) = (/ &
 & 0.47581E-06_JPRB,0.50000E-06_JPRB,0.52487E-06_JPRB,0.54192E-06_JPRB,0.55955E-06_JPRB /)  
KA(:, 8, 2) = (/ &
 & 0.10592E-05_JPRB,0.11093E-05_JPRB,0.11483E-05_JPRB,0.11923E-05_JPRB,0.12169E-05_JPRB /)  
KA(:, 9, 2) = (/ &
 & 0.50835E-05_JPRB,0.51710E-05_JPRB,0.52329E-05_JPRB,0.52644E-05_JPRB,0.52818E-05_JPRB /)  
KA(:,10, 2) = (/ &
 & 0.77867E-05_JPRB,0.82156E-05_JPRB,0.86002E-05_JPRB,0.89664E-05_JPRB,0.92394E-05_JPRB /)  
KA(:,11, 2) = (/ &
 & 0.89031E-05_JPRB,0.93573E-05_JPRB,0.97686E-05_JPRB,0.10236E-04_JPRB,0.10591E-04_JPRB /)  
KA(:,12, 2) = (/ &
 & 0.98068E-05_JPRB,0.10238E-04_JPRB,0.10700E-04_JPRB,0.11108E-04_JPRB,0.11471E-04_JPRB /)  
KA(:,13, 2) = (/ &
 & 0.11145E-04_JPRB,0.11697E-04_JPRB,0.12123E-04_JPRB,0.12482E-04_JPRB,0.12856E-04_JPRB /)  
KA(:, 1, 3) = (/ &
 & 0.66049E-05_JPRB,0.67547E-05_JPRB,0.70104E-05_JPRB,0.69745E-05_JPRB,0.70687E-05_JPRB /)  
KA(:, 2, 3) = (/ &
 & 0.54104E-05_JPRB,0.55245E-05_JPRB,0.57623E-05_JPRB,0.58532E-05_JPRB,0.58099E-05_JPRB /)  
KA(:, 3, 3) = (/ &
 & 0.43608E-05_JPRB,0.44784E-05_JPRB,0.45778E-05_JPRB,0.47665E-05_JPRB,0.47295E-05_JPRB /)  
KA(:, 4, 3) = (/ &
 & 0.35399E-05_JPRB,0.36454E-05_JPRB,0.37356E-05_JPRB,0.38107E-05_JPRB,0.39586E-05_JPRB /)  
KA(:, 5, 3) = (/ &
 & 0.28576E-05_JPRB,0.29552E-05_JPRB,0.30325E-05_JPRB,0.31028E-05_JPRB,0.32276E-05_JPRB /)  
KA(:, 6, 3) = (/ &
 & 0.21017E-05_JPRB,0.21836E-05_JPRB,0.22554E-05_JPRB,0.23121E-05_JPRB,0.23486E-05_JPRB /)  
KA(:, 7, 3) = (/ &
 & 0.19384E-05_JPRB,0.19914E-05_JPRB,0.20428E-05_JPRB,0.20879E-05_JPRB,0.21191E-05_JPRB /)  
KA(:, 8, 3) = (/ &
 & 0.32672E-05_JPRB,0.33753E-05_JPRB,0.34694E-05_JPRB,0.35273E-05_JPRB,0.35984E-05_JPRB /)  
KA(:, 9, 3) = (/ &
 & 0.82257E-05_JPRB,0.84975E-05_JPRB,0.86969E-05_JPRB,0.88995E-05_JPRB,0.90123E-05_JPRB /)  
KA(:,10, 3) = (/ &
 & 0.35363E-04_JPRB,0.36204E-04_JPRB,0.36916E-04_JPRB,0.37708E-04_JPRB,0.38294E-04_JPRB /)  
KA(:,11, 3) = (/ &
 & 0.48837E-04_JPRB,0.50952E-04_JPRB,0.52710E-04_JPRB,0.54347E-04_JPRB,0.55976E-04_JPRB /)  
KA(:,12, 3) = (/ &
 & 0.56059E-04_JPRB,0.58301E-04_JPRB,0.60100E-04_JPRB,0.61776E-04_JPRB,0.63179E-04_JPRB /)  
KA(:,13, 3) = (/ &
 & 0.57871E-04_JPRB,0.59505E-04_JPRB,0.60930E-04_JPRB,0.62289E-04_JPRB,0.63278E-04_JPRB /)  
KA(:, 1, 4) = (/ &
 & 0.27624E-04_JPRB,0.28017E-04_JPRB,0.29078E-04_JPRB,0.28567E-04_JPRB,0.28724E-04_JPRB /)  
KA(:, 2, 4) = (/ &
 & 0.23107E-04_JPRB,0.23464E-04_JPRB,0.24357E-04_JPRB,0.24519E-04_JPRB,0.24024E-04_JPRB /)  
KA(:, 3, 4) = (/ &
 & 0.19113E-04_JPRB,0.19400E-04_JPRB,0.19615E-04_JPRB,0.20420E-04_JPRB,0.19962E-04_JPRB /)  
KA(:, 4, 4) = (/ &
 & 0.15873E-04_JPRB,0.16138E-04_JPRB,0.16349E-04_JPRB,0.16528E-04_JPRB,0.17176E-04_JPRB /)  
KA(:, 5, 4) = (/ &
 & 0.13198E-04_JPRB,0.13437E-04_JPRB,0.13641E-04_JPRB,0.13810E-04_JPRB,0.14393E-04_JPRB /)  
KA(:, 6, 4) = (/ &
 & 0.10951E-04_JPRB,0.11172E-04_JPRB,0.11352E-04_JPRB,0.11506E-04_JPRB,0.11631E-04_JPRB /)  
KA(:, 7, 4) = (/ &
 & 0.86121E-05_JPRB,0.88300E-05_JPRB,0.90149E-05_JPRB,0.91565E-05_JPRB,0.92594E-05_JPRB /)  
KA(:, 8, 4) = (/ &
 & 0.71478E-05_JPRB,0.72918E-05_JPRB,0.74035E-05_JPRB,0.74959E-05_JPRB,0.75566E-05_JPRB /)  
KA(:, 9, 4) = (/ &
 & 0.16458E-04_JPRB,0.17092E-04_JPRB,0.17686E-04_JPRB,0.17967E-04_JPRB,0.18273E-04_JPRB /)  
KA(:,10, 4) = (/ &
 & 0.47953E-04_JPRB,0.49663E-04_JPRB,0.51524E-04_JPRB,0.52800E-04_JPRB,0.54192E-04_JPRB /)  
KA(:,11, 4) = (/ &
 & 0.94263E-04_JPRB,0.95557E-04_JPRB,0.96513E-04_JPRB,0.97430E-04_JPRB,0.97733E-04_JPRB /)  
KA(:,12, 4) = (/ &
 & 0.12087E-03_JPRB,0.12152E-03_JPRB,0.12240E-03_JPRB,0.12318E-03_JPRB,0.12403E-03_JPRB /)  
KA(:,13, 4) = (/ &
 & 0.12781E-03_JPRB,0.12897E-03_JPRB,0.13049E-03_JPRB,0.13171E-03_JPRB,0.13337E-03_JPRB /)  
KA(:, 1, 5) = (/ &
 & 0.82859E-04_JPRB,0.84817E-04_JPRB,0.89056E-04_JPRB,0.88057E-04_JPRB,0.89410E-04_JPRB /)  
KA(:, 2, 5) = (/ &
 & 0.70937E-04_JPRB,0.72685E-04_JPRB,0.76796E-04_JPRB,0.77955E-04_JPRB,0.76735E-04_JPRB /)  
KA(:, 3, 5) = (/ &
 & 0.59876E-04_JPRB,0.61448E-04_JPRB,0.62837E-04_JPRB,0.66293E-04_JPRB,0.64996E-04_JPRB /)  
KA(:, 4, 5) = (/ &
 & 0.50598E-04_JPRB,0.52054E-04_JPRB,0.53293E-04_JPRB,0.54332E-04_JPRB,0.57333E-04_JPRB /)  
KA(:, 5, 5) = (/ &
 & 0.42742E-04_JPRB,0.44035E-04_JPRB,0.45164E-04_JPRB,0.46134E-04_JPRB,0.48935E-04_JPRB /)  
KA(:, 6, 5) = (/ &
 & 0.35769E-04_JPRB,0.36975E-04_JPRB,0.38038E-04_JPRB,0.38917E-04_JPRB,0.39681E-04_JPRB /)  
KA(:, 7, 5) = (/ &
 & 0.29747E-04_JPRB,0.30824E-04_JPRB,0.31756E-04_JPRB,0.32589E-04_JPRB,0.33314E-04_JPRB /)  
KA(:, 8, 5) = (/ &
 & 0.21994E-04_JPRB,0.22945E-04_JPRB,0.23786E-04_JPRB,0.24517E-04_JPRB,0.25155E-04_JPRB /)  
KA(:, 9, 5) = (/ &
 & 0.22298E-04_JPRB,0.22688E-04_JPRB,0.23127E-04_JPRB,0.23803E-04_JPRB,0.24335E-04_JPRB /)  
KA(:,10, 5) = (/ &
 & 0.88898E-04_JPRB,0.91280E-04_JPRB,0.93333E-04_JPRB,0.95224E-04_JPRB,0.96298E-04_JPRB /)  
KA(:,11, 5) = (/ &
 & 0.12299E-03_JPRB,0.12407E-03_JPRB,0.12536E-03_JPRB,0.12642E-03_JPRB,0.12813E-03_JPRB /)  
KA(:,12, 5) = (/ &
 & 0.14539E-03_JPRB,0.14851E-03_JPRB,0.15022E-03_JPRB,0.15157E-03_JPRB,0.15204E-03_JPRB /)  
KA(:,13, 5) = (/ &
 & 0.15949E-03_JPRB,0.16239E-03_JPRB,0.16467E-03_JPRB,0.16667E-03_JPRB,0.16801E-03_JPRB /)  
KA(:, 1, 6) = (/ &
 & 0.25339E-03_JPRB,0.25995E-03_JPRB,0.27170E-03_JPRB,0.26963E-03_JPRB,0.27413E-03_JPRB /)  
KA(:, 2, 6) = (/ &
 & 0.21908E-03_JPRB,0.22404E-03_JPRB,0.23522E-03_JPRB,0.23902E-03_JPRB,0.23717E-03_JPRB /)  
KA(:, 3, 6) = (/ &
 & 0.18611E-03_JPRB,0.19076E-03_JPRB,0.19518E-03_JPRB,0.20503E-03_JPRB,0.20222E-03_JPRB /)  
KA(:, 4, 6) = (/ &
 & 0.15769E-03_JPRB,0.16210E-03_JPRB,0.16597E-03_JPRB,0.16948E-03_JPRB,0.17817E-03_JPRB /)  
KA(:, 5, 6) = (/ &
 & 0.13402E-03_JPRB,0.13792E-03_JPRB,0.14153E-03_JPRB,0.14434E-03_JPRB,0.15267E-03_JPRB /)  
KA(:, 6, 6) = (/ &
 & 0.11390E-03_JPRB,0.11743E-03_JPRB,0.12065E-03_JPRB,0.12316E-03_JPRB,0.12543E-03_JPRB /)  
KA(:, 7, 6) = (/ &
 & 0.96417E-04_JPRB,0.99612E-04_JPRB,0.10233E-03_JPRB,0.10453E-03_JPRB,0.10652E-03_JPRB /)  
KA(:, 8, 6) = (/ &
 & 0.81395E-04_JPRB,0.84205E-04_JPRB,0.86346E-04_JPRB,0.88406E-04_JPRB,0.90122E-04_JPRB /)  
KA(:, 9, 6) = (/ &
 & 0.47776E-04_JPRB,0.48971E-04_JPRB,0.49736E-04_JPRB,0.49917E-04_JPRB,0.50289E-04_JPRB /)  
KA(:,10, 6) = (/ &
 & 0.10698E-03_JPRB,0.10815E-03_JPRB,0.10817E-03_JPRB,0.10799E-03_JPRB,0.10851E-03_JPRB /)  
KA(:,11, 6) = (/ &
 & 0.20220E-03_JPRB,0.20727E-03_JPRB,0.21241E-03_JPRB,0.21675E-03_JPRB,0.21989E-03_JPRB /)  
KA(:,12, 6) = (/ &
 & 0.23474E-03_JPRB,0.23601E-03_JPRB,0.23974E-03_JPRB,0.24383E-03_JPRB,0.24876E-03_JPRB /)  
KA(:,13, 6) = (/ &
 & 0.23410E-03_JPRB,0.23809E-03_JPRB,0.24185E-03_JPRB,0.24554E-03_JPRB,0.24952E-03_JPRB /)  
KA(:, 1, 7) = (/ &
 & 0.67024E-03_JPRB,0.68026E-03_JPRB,0.70419E-03_JPRB,0.70159E-03_JPRB,0.71089E-03_JPRB /)  
KA(:, 2, 7) = (/ &
 & 0.58729E-03_JPRB,0.59778E-03_JPRB,0.62097E-03_JPRB,0.62912E-03_JPRB,0.62423E-03_JPRB /)  
KA(:, 3, 7) = (/ &
 & 0.50967E-03_JPRB,0.51900E-03_JPRB,0.52765E-03_JPRB,0.54794E-03_JPRB,0.54266E-03_JPRB /)  
KA(:, 4, 7) = (/ &
 & 0.44167E-03_JPRB,0.45006E-03_JPRB,0.45793E-03_JPRB,0.46469E-03_JPRB,0.48335E-03_JPRB /)  
KA(:, 5, 7) = (/ &
 & 0.38096E-03_JPRB,0.38881E-03_JPRB,0.39576E-03_JPRB,0.40259E-03_JPRB,0.42086E-03_JPRB /)  
KA(:, 6, 7) = (/ &
 & 0.32818E-03_JPRB,0.33539E-03_JPRB,0.34192E-03_JPRB,0.34829E-03_JPRB,0.35405E-03_JPRB /)  
KA(:, 7, 7) = (/ &
 & 0.28259E-03_JPRB,0.28946E-03_JPRB,0.29584E-03_JPRB,0.30203E-03_JPRB,0.30742E-03_JPRB /)  
KA(:, 8, 7) = (/ &
 & 0.24273E-03_JPRB,0.24912E-03_JPRB,0.25546E-03_JPRB,0.26110E-03_JPRB,0.26607E-03_JPRB /)  
KA(:, 9, 7) = (/ &
 & 0.19937E-03_JPRB,0.20653E-03_JPRB,0.21314E-03_JPRB,0.21968E-03_JPRB,0.22520E-03_JPRB /)  
KA(:,10, 7) = (/ &
 & 0.13306E-03_JPRB,0.13331E-03_JPRB,0.13393E-03_JPRB,0.13538E-03_JPRB,0.13616E-03_JPRB /)  
KA(:,11, 7) = (/ &
 & 0.16236E-03_JPRB,0.16154E-03_JPRB,0.16187E-03_JPRB,0.16113E-03_JPRB,0.16209E-03_JPRB /)  
KA(:,12, 7) = (/ &
 & 0.17872E-03_JPRB,0.18355E-03_JPRB,0.18612E-03_JPRB,0.18792E-03_JPRB,0.18745E-03_JPRB /)  
KA(:,13, 7) = (/ &
 & 0.18970E-03_JPRB,0.19384E-03_JPRB,0.19773E-03_JPRB,0.20261E-03_JPRB,0.20377E-03_JPRB /)  
KA(:, 1, 8) = (/ &
 & 0.18130E-02_JPRB,0.18305E-02_JPRB,0.18716E-02_JPRB,0.18655E-02_JPRB,0.18814E-02_JPRB /)  
KA(:, 2, 8) = (/ &
 & 0.16420E-02_JPRB,0.16600E-02_JPRB,0.17006E-02_JPRB,0.17156E-02_JPRB,0.17108E-02_JPRB /)  
KA(:, 3, 8) = (/ &
 & 0.14687E-02_JPRB,0.14870E-02_JPRB,0.15042E-02_JPRB,0.15423E-02_JPRB,0.15376E-02_JPRB /)  
KA(:, 4, 8) = (/ &
 & 0.13068E-02_JPRB,0.13248E-02_JPRB,0.13421E-02_JPRB,0.13592E-02_JPRB,0.13960E-02_JPRB /)  
KA(:, 5, 8) = (/ &
 & 0.11574E-02_JPRB,0.11753E-02_JPRB,0.11928E-02_JPRB,0.12097E-02_JPRB,0.12467E-02_JPRB /)  
KA(:, 6, 8) = (/ &
 & 0.10167E-02_JPRB,0.10342E-02_JPRB,0.10515E-02_JPRB,0.10681E-02_JPRB,0.10840E-02_JPRB /)  
KA(:, 7, 8) = (/ &
 & 0.88992E-03_JPRB,0.90662E-03_JPRB,0.92299E-03_JPRB,0.93844E-03_JPRB,0.95347E-03_JPRB /)  
KA(:, 8, 8) = (/ &
 & 0.78445E-03_JPRB,0.80031E-03_JPRB,0.81639E-03_JPRB,0.83131E-03_JPRB,0.84631E-03_JPRB /)  
KA(:, 9, 8) = (/ &
 & 0.69812E-03_JPRB,0.71312E-03_JPRB,0.72801E-03_JPRB,0.74222E-03_JPRB,0.75605E-03_JPRB /)  
KA(:,10, 8) = (/ &
 & 0.32521E-03_JPRB,0.33835E-03_JPRB,0.35194E-03_JPRB,0.36381E-03_JPRB,0.37594E-03_JPRB /)  
KA(:,11, 8) = (/ &
 & 0.31406E-03_JPRB,0.32013E-03_JPRB,0.32456E-03_JPRB,0.33261E-03_JPRB,0.33741E-03_JPRB /)  
KA(:,12, 8) = (/ &
 & 0.28132E-03_JPRB,0.28732E-03_JPRB,0.29674E-03_JPRB,0.30509E-03_JPRB,0.31393E-03_JPRB /)  
KA(:,13, 8) = (/ &
 & 0.25704E-03_JPRB,0.26316E-03_JPRB,0.27195E-03_JPRB,0.27732E-03_JPRB,0.28905E-03_JPRB /)  
KA(:, 1, 9) = (/ &
 & 0.67370E-02_JPRB,0.67873E-02_JPRB,0.68896E-02_JPRB,0.68819E-02_JPRB,0.69268E-02_JPRB /)  
KA(:, 2, 9) = (/ &
 & 0.63111E-02_JPRB,0.63622E-02_JPRB,0.64623E-02_JPRB,0.65060E-02_JPRB,0.65027E-02_JPRB /)  
KA(:, 3, 9) = (/ &
 & 0.58834E-02_JPRB,0.59361E-02_JPRB,0.59858E-02_JPRB,0.60811E-02_JPRB,0.60806E-02_JPRB /)  
KA(:, 4, 9) = (/ &
 & 0.54753E-02_JPRB,0.55309E-02_JPRB,0.55823E-02_JPRB,0.56306E-02_JPRB,0.57229E-02_JPRB /)  
KA(:, 5, 9) = (/ &
 & 0.50781E-02_JPRB,0.51373E-02_JPRB,0.51895E-02_JPRB,0.52391E-02_JPRB,0.53328E-02_JPRB /)  
KA(:, 6, 9) = (/ &
 & 0.46791E-02_JPRB,0.47408E-02_JPRB,0.47949E-02_JPRB,0.48470E-02_JPRB,0.48993E-02_JPRB /)  
KA(:, 7, 9) = (/ &
 & 0.42724E-02_JPRB,0.43381E-02_JPRB,0.43951E-02_JPRB,0.44503E-02_JPRB,0.45061E-02_JPRB /)  
KA(:, 8, 9) = (/ &
 & 0.38568E-02_JPRB,0.39254E-02_JPRB,0.39848E-02_JPRB,0.40431E-02_JPRB,0.41005E-02_JPRB /)  
KA(:, 9, 9) = (/ &
 & 0.35657E-02_JPRB,0.36362E-02_JPRB,0.36994E-02_JPRB,0.37608E-02_JPRB,0.38215E-02_JPRB /)  
KA(:,10, 9) = (/ &
 & 0.33774E-02_JPRB,0.34501E-02_JPRB,0.35171E-02_JPRB,0.35811E-02_JPRB,0.36450E-02_JPRB /)  
KA(:,11, 9) = (/ &
 & 0.23923E-02_JPRB,0.24623E-02_JPRB,0.25263E-02_JPRB,0.25890E-02_JPRB,0.26517E-02_JPRB /)  
KA(:,12, 9) = (/ &
 & 0.16959E-02_JPRB,0.17542E-02_JPRB,0.18077E-02_JPRB,0.18614E-02_JPRB,0.19187E-02_JPRB /)  
KA(:,13, 9) = (/ &
 & 0.11732E-02_JPRB,0.12232E-02_JPRB,0.12712E-02_JPRB,0.13221E-02_JPRB,0.13677E-02_JPRB /)  
KA(:, 1,10) = (/ &
 & 0.19604E-01_JPRB,0.19698E-01_JPRB,0.19938E-01_JPRB,0.19854E-01_JPRB,0.19950E-01_JPRB /)  
KA(:, 2,10) = (/ &
 & 0.18714E-01_JPRB,0.18803E-01_JPRB,0.19035E-01_JPRB,0.19131E-01_JPRB,0.19102E-01_JPRB /)  
KA(:, 3,10) = (/ &
 & 0.17676E-01_JPRB,0.17785E-01_JPRB,0.17904E-01_JPRB,0.18189E-01_JPRB,0.18156E-01_JPRB /)  
KA(:, 4,10) = (/ &
 & 0.16662E-01_JPRB,0.16773E-01_JPRB,0.16908E-01_JPRB,0.17056E-01_JPRB,0.17303E-01_JPRB /)  
KA(:, 5,10) = (/ &
 & 0.15655E-01_JPRB,0.15775E-01_JPRB,0.15942E-01_JPRB,0.16103E-01_JPRB,0.16359E-01_JPRB /)  
KA(:, 6,10) = (/ &
 & 0.14694E-01_JPRB,0.14838E-01_JPRB,0.15029E-01_JPRB,0.15200E-01_JPRB,0.15320E-01_JPRB /)  
KA(:, 7,10) = (/ &
 & 0.13797E-01_JPRB,0.13959E-01_JPRB,0.14174E-01_JPRB,0.14350E-01_JPRB,0.14471E-01_JPRB /)  
KA(:, 8,10) = (/ &
 & 0.12902E-01_JPRB,0.13089E-01_JPRB,0.13313E-01_JPRB,0.13489E-01_JPRB,0.13626E-01_JPRB /)  
KA(:, 9,10) = (/ &
 & 0.11897E-01_JPRB,0.12105E-01_JPRB,0.12333E-01_JPRB,0.12512E-01_JPRB,0.12656E-01_JPRB /)  
KA(:,10,10) = (/ &
 & 0.11834E-01_JPRB,0.12072E-01_JPRB,0.12331E-01_JPRB,0.12548E-01_JPRB,0.12721E-01_JPRB /)  
KA(:,11,10) = (/ &
 & 0.11416E-01_JPRB,0.11699E-01_JPRB,0.11968E-01_JPRB,0.12141E-01_JPRB,0.12311E-01_JPRB /)  
KA(:,12,10) = (/ &
 & 0.10776E-01_JPRB,0.11070E-01_JPRB,0.11309E-01_JPRB,0.11507E-01_JPRB,0.11702E-01_JPRB /)  
KA(:,13,10) = (/ &
 & 0.99577E-02_JPRB,0.10263E-01_JPRB,0.10492E-01_JPRB,0.10719E-01_JPRB,0.10951E-01_JPRB /)  
KA(:, 1,11) = (/ &
 & 0.29783E-01_JPRB,0.29883E-01_JPRB,0.30210E-01_JPRB,0.30141E-01_JPRB,0.30248E-01_JPRB /)  
KA(:, 2,11) = (/ &
 & 0.28562E-01_JPRB,0.28743E-01_JPRB,0.29186E-01_JPRB,0.29339E-01_JPRB,0.29258E-01_JPRB /)  
KA(:, 3,11) = (/ &
 & 0.27212E-01_JPRB,0.27429E-01_JPRB,0.27654E-01_JPRB,0.28083E-01_JPRB,0.28023E-01_JPRB /)  
KA(:, 4,11) = (/ &
 & 0.25949E-01_JPRB,0.26197E-01_JPRB,0.26424E-01_JPRB,0.26623E-01_JPRB,0.27069E-01_JPRB /)  
KA(:, 5,11) = (/ &
 & 0.24686E-01_JPRB,0.24942E-01_JPRB,0.25176E-01_JPRB,0.25403E-01_JPRB,0.25908E-01_JPRB /)  
KA(:, 6,11) = (/ &
 & 0.23430E-01_JPRB,0.23686E-01_JPRB,0.23923E-01_JPRB,0.24158E-01_JPRB,0.24433E-01_JPRB /)  
KA(:, 7,11) = (/ &
 & 0.22171E-01_JPRB,0.22424E-01_JPRB,0.22653E-01_JPRB,0.22909E-01_JPRB,0.23203E-01_JPRB /)  
KA(:, 8,11) = (/ &
 & 0.20928E-01_JPRB,0.21171E-01_JPRB,0.21407E-01_JPRB,0.21699E-01_JPRB,0.22018E-01_JPRB /)  
KA(:, 9,11) = (/ &
 & 0.19076E-01_JPRB,0.19320E-01_JPRB,0.19548E-01_JPRB,0.19858E-01_JPRB,0.20150E-01_JPRB /)  
KA(:,10,11) = (/ &
 & 0.19537E-01_JPRB,0.19788E-01_JPRB,0.20064E-01_JPRB,0.20391E-01_JPRB,0.20843E-01_JPRB /)  
KA(:,11,11) = (/ &
 & 0.19137E-01_JPRB,0.19444E-01_JPRB,0.19793E-01_JPRB,0.20268E-01_JPRB,0.20695E-01_JPRB /)  
KA(:,12,11) = (/ &
 & 0.18393E-01_JPRB,0.18715E-01_JPRB,0.19143E-01_JPRB,0.19652E-01_JPRB,0.20037E-01_JPRB /)  
KA(:,13,11) = (/ &
 & 0.17255E-01_JPRB,0.17680E-01_JPRB,0.18170E-01_JPRB,0.18641E-01_JPRB,0.19010E-01_JPRB /)  
KA(:, 1,12) = (/ &
 & 0.46641E-01_JPRB,0.46796E-01_JPRB,0.47107E-01_JPRB,0.46977E-01_JPRB,0.47093E-01_JPRB /)  
KA(:, 2,12) = (/ &
 & 0.46819E-01_JPRB,0.46956E-01_JPRB,0.47337E-01_JPRB,0.47426E-01_JPRB,0.47339E-01_JPRB /)  
KA(:, 3,12) = (/ &
 & 0.46276E-01_JPRB,0.46366E-01_JPRB,0.46462E-01_JPRB,0.46935E-01_JPRB,0.46862E-01_JPRB /)  
KA(:, 4,12) = (/ &
 & 0.44986E-01_JPRB,0.45103E-01_JPRB,0.45287E-01_JPRB,0.45535E-01_JPRB,0.46152E-01_JPRB /)  
KA(:, 5,12) = (/ &
 & 0.43367E-01_JPRB,0.43552E-01_JPRB,0.43761E-01_JPRB,0.44035E-01_JPRB,0.44674E-01_JPRB /)  
KA(:, 6,12) = (/ &
 & 0.41584E-01_JPRB,0.41793E-01_JPRB,0.42020E-01_JPRB,0.42344E-01_JPRB,0.42701E-01_JPRB /)  
KA(:, 7,12) = (/ &
 & 0.39785E-01_JPRB,0.40007E-01_JPRB,0.40269E-01_JPRB,0.40635E-01_JPRB,0.41003E-01_JPRB /)  
KA(:, 8,12) = (/ &
 & 0.37918E-01_JPRB,0.38155E-01_JPRB,0.38468E-01_JPRB,0.38839E-01_JPRB,0.39210E-01_JPRB /)  
KA(:, 9,12) = (/ &
 & 0.35060E-01_JPRB,0.35328E-01_JPRB,0.35698E-01_JPRB,0.36105E-01_JPRB,0.36551E-01_JPRB /)  
KA(:,10,12) = (/ &
 & 0.35216E-01_JPRB,0.35547E-01_JPRB,0.35872E-01_JPRB,0.36327E-01_JPRB,0.36542E-01_JPRB /)  
KA(:,11,12) = (/ &
 & 0.35158E-01_JPRB,0.35374E-01_JPRB,0.35869E-01_JPRB,0.36242E-01_JPRB,0.36691E-01_JPRB /)  
KA(:,12,12) = (/ &
 & 0.34264E-01_JPRB,0.34598E-01_JPRB,0.35106E-01_JPRB,0.35505E-01_JPRB,0.36021E-01_JPRB /)  
KA(:,13,12) = (/ &
 & 0.32716E-01_JPRB,0.33195E-01_JPRB,0.33830E-01_JPRB,0.34228E-01_JPRB,0.34925E-01_JPRB /)  
KA(:, 1,13) = (/ &
 & 0.76084E-01_JPRB,0.76052E-01_JPRB,0.76051E-01_JPRB,0.75851E-01_JPRB,0.75753E-01_JPRB /)  
KA(:, 2,13) = (/ &
 & 0.79580E-01_JPRB,0.79564E-01_JPRB,0.79664E-01_JPRB,0.79619E-01_JPRB,0.79414E-01_JPRB /)  
KA(:, 3,13) = (/ &
 & 0.82218E-01_JPRB,0.82302E-01_JPRB,0.82367E-01_JPRB,0.82543E-01_JPRB,0.82246E-01_JPRB /)  
KA(:, 4,13) = (/ &
 & 0.83613E-01_JPRB,0.83740E-01_JPRB,0.83824E-01_JPRB,0.83866E-01_JPRB,0.84103E-01_JPRB /)  
KA(:, 5,13) = (/ &
 & 0.83913E-01_JPRB,0.84123E-01_JPRB,0.84289E-01_JPRB,0.84403E-01_JPRB,0.84840E-01_JPRB /)  
KA(:, 6,13) = (/ &
 & 0.83159E-01_JPRB,0.83442E-01_JPRB,0.83718E-01_JPRB,0.83891E-01_JPRB,0.83993E-01_JPRB /)  
KA(:, 7,13) = (/ &
 & 0.81401E-01_JPRB,0.81826E-01_JPRB,0.82202E-01_JPRB,0.82451E-01_JPRB,0.82656E-01_JPRB /)  
KA(:, 8,13) = (/ &
 & 0.78949E-01_JPRB,0.79505E-01_JPRB,0.79978E-01_JPRB,0.80351E-01_JPRB,0.80690E-01_JPRB /)  
KA(:, 9,13) = (/ &
 & 0.76002E-01_JPRB,0.76671E-01_JPRB,0.77279E-01_JPRB,0.77752E-01_JPRB,0.78257E-01_JPRB /)  
KA(:,10,13) = (/ &
 & 0.69777E-01_JPRB,0.70425E-01_JPRB,0.71054E-01_JPRB,0.71706E-01_JPRB,0.72167E-01_JPRB /)  
KA(:,11,13) = (/ &
 & 0.72929E-01_JPRB,0.73732E-01_JPRB,0.74323E-01_JPRB,0.75246E-01_JPRB,0.75786E-01_JPRB /)  
KA(:,12,13) = (/ &
 & 0.73007E-01_JPRB,0.74429E-01_JPRB,0.74922E-01_JPRB,0.75916E-01_JPRB,0.76947E-01_JPRB /)  
KA(:,13,13) = (/ &
 & 0.71376E-01_JPRB,0.72507E-01_JPRB,0.73710E-01_JPRB,0.74716E-01_JPRB,0.75702E-01_JPRB /)  
KA(:, 1,14) = (/ &
 & 0.12585E+00_JPRB,0.12569E+00_JPRB,0.12576E+00_JPRB,0.12571E+00_JPRB,0.12570E+00_JPRB /)  
KA(:, 2,14) = (/ &
 & 0.13868E+00_JPRB,0.13853E+00_JPRB,0.13849E+00_JPRB,0.13824E+00_JPRB,0.13803E+00_JPRB /)  
KA(:, 3,14) = (/ &
 & 0.15142E+00_JPRB,0.15135E+00_JPRB,0.15112E+00_JPRB,0.15093E+00_JPRB,0.15074E+00_JPRB /)  
KA(:, 4,14) = (/ &
 & 0.16359E+00_JPRB,0.16359E+00_JPRB,0.16339E+00_JPRB,0.16311E+00_JPRB,0.16285E+00_JPRB /)  
KA(:, 5,14) = (/ &
 & 0.17462E+00_JPRB,0.17472E+00_JPRB,0.17456E+00_JPRB,0.17421E+00_JPRB,0.17393E+00_JPRB /)  
KA(:, 6,14) = (/ &
 & 0.18403E+00_JPRB,0.18447E+00_JPRB,0.18450E+00_JPRB,0.18424E+00_JPRB,0.18395E+00_JPRB /)  
KA(:, 7,14) = (/ &
 & 0.19179E+00_JPRB,0.19239E+00_JPRB,0.19256E+00_JPRB,0.19253E+00_JPRB,0.19252E+00_JPRB /)  
KA(:, 8,14) = (/ &
 & 0.19772E+00_JPRB,0.19863E+00_JPRB,0.19901E+00_JPRB,0.19923E+00_JPRB,0.19947E+00_JPRB /)  
KA(:, 9,14) = (/ &
 & 0.20154E+00_JPRB,0.20279E+00_JPRB,0.20355E+00_JPRB,0.20417E+00_JPRB,0.20473E+00_JPRB /)  
KA(:,10,14) = (/ &
 & 0.18853E+00_JPRB,0.19028E+00_JPRB,0.19160E+00_JPRB,0.19253E+00_JPRB,0.19393E+00_JPRB /)  
KA(:,11,14) = (/ &
 & 0.18013E+00_JPRB,0.18167E+00_JPRB,0.18320E+00_JPRB,0.18375E+00_JPRB,0.18507E+00_JPRB /)  
KA(:,12,14) = (/ &
 & 0.19011E+00_JPRB,0.19027E+00_JPRB,0.19283E+00_JPRB,0.19402E+00_JPRB,0.19478E+00_JPRB /)  
KA(:,13,14) = (/ &
 & 0.19594E+00_JPRB,0.19738E+00_JPRB,0.19911E+00_JPRB,0.20124E+00_JPRB,0.20282E+00_JPRB /)  
KA(:, 1,15) = (/ &
 & 0.22369E+00_JPRB,0.22259E+00_JPRB,0.22155E+00_JPRB,0.22059E+00_JPRB,0.21997E+00_JPRB /)  
KA(:, 2,15) = (/ &
 & 0.25602E+00_JPRB,0.25478E+00_JPRB,0.25377E+00_JPRB,0.25306E+00_JPRB,0.25237E+00_JPRB /)  
KA(:, 3,15) = (/ &
 & 0.29258E+00_JPRB,0.29107E+00_JPRB,0.28998E+00_JPRB,0.28920E+00_JPRB,0.28830E+00_JPRB /)  
KA(:, 4,15) = (/ &
 & 0.33067E+00_JPRB,0.32888E+00_JPRB,0.32753E+00_JPRB,0.32646E+00_JPRB,0.32566E+00_JPRB /)  
KA(:, 5,15) = (/ &
 & 0.37114E+00_JPRB,0.36880E+00_JPRB,0.36713E+00_JPRB,0.36598E+00_JPRB,0.36499E+00_JPRB /)  
KA(:, 6,15) = (/ &
 & 0.41494E+00_JPRB,0.41167E+00_JPRB,0.40935E+00_JPRB,0.40779E+00_JPRB,0.40636E+00_JPRB /)  
KA(:, 7,15) = (/ &
 & 0.46115E+00_JPRB,0.45729E+00_JPRB,0.45455E+00_JPRB,0.45230E+00_JPRB,0.45004E+00_JPRB /)  
KA(:, 8,15) = (/ &
 & 0.50906E+00_JPRB,0.50463E+00_JPRB,0.50137E+00_JPRB,0.49843E+00_JPRB,0.49550E+00_JPRB /)  
KA(:, 9,15) = (/ &
 & 0.55829E+00_JPRB,0.55330E+00_JPRB,0.54936E+00_JPRB,0.54557E+00_JPRB,0.54168E+00_JPRB /)  
KA(:,10,15) = (/ &
 & 0.60814E+00_JPRB,0.60274E+00_JPRB,0.59806E+00_JPRB,0.59326E+00_JPRB,0.58833E+00_JPRB /)  
KA(:,11,15) = (/ &
 & 0.62954E+00_JPRB,0.62588E+00_JPRB,0.62076E+00_JPRB,0.61665E+00_JPRB,0.61184E+00_JPRB /)  
KA(:,12,15) = (/ &
 & 0.62585E+00_JPRB,0.62437E+00_JPRB,0.61807E+00_JPRB,0.61303E+00_JPRB,0.60869E+00_JPRB /)  
KA(:,13,15) = (/ &
 & 0.64856E+00_JPRB,0.64505E+00_JPRB,0.63861E+00_JPRB,0.63277E+00_JPRB,0.62702E+00_JPRB /)  
KA(:, 1,16) = (/ &
 & 0.33327E+00_JPRB,0.33385E+00_JPRB,0.33538E+00_JPRB,0.33638E+00_JPRB,0.33736E+00_JPRB /)  
KA(:, 2,16) = (/ &
 & 0.40916E+00_JPRB,0.40842E+00_JPRB,0.40848E+00_JPRB,0.40865E+00_JPRB,0.40854E+00_JPRB /)  
KA(:, 3,16) = (/ &
 & 0.50099E+00_JPRB,0.49888E+00_JPRB,0.49727E+00_JPRB,0.49588E+00_JPRB,0.49422E+00_JPRB /)  
KA(:, 4,16) = (/ &
 & 0.60389E+00_JPRB,0.60029E+00_JPRB,0.59704E+00_JPRB,0.59367E+00_JPRB,0.59071E+00_JPRB /)  
KA(:, 5,16) = (/ &
 & 0.71868E+00_JPRB,0.71337E+00_JPRB,0.70835E+00_JPRB,0.70318E+00_JPRB,0.69852E+00_JPRB /)  
KA(:, 6,16) = (/ &
 & 0.84815E+00_JPRB,0.84138E+00_JPRB,0.83446E+00_JPRB,0.82728E+00_JPRB,0.82023E+00_JPRB /)  
KA(:, 7,16) = (/ &
 & 0.99512E+00_JPRB,0.98644E+00_JPRB,0.97698E+00_JPRB,0.96695E+00_JPRB,0.95712E+00_JPRB /)  
KA(:, 8,16) = (/ &
 & 0.11606E+01_JPRB,0.11485E+01_JPRB,0.11354E+01_JPRB,0.11218E+01_JPRB,0.11077E+01_JPRB /)  
KA(:, 9,16) = (/ &
 & 0.13444E+01_JPRB,0.13282E+01_JPRB,0.13102E+01_JPRB,0.12917E+01_JPRB,0.12735E+01_JPRB /)  
KA(:,10,16) = (/ &
 & 0.15423E+01_JPRB,0.15207E+01_JPRB,0.14970E+01_JPRB,0.14733E+01_JPRB,0.14494E+01_JPRB /)  
KA(:,11,16) = (/ &
 & 0.17462E+01_JPRB,0.17138E+01_JPRB,0.16827E+01_JPRB,0.16518E+01_JPRB,0.16199E+01_JPRB /)  
KA(:,12,16) = (/ &
 & 0.19577E+01_JPRB,0.19145E+01_JPRB,0.18728E+01_JPRB,0.18320E+01_JPRB,0.17910E+01_JPRB /)  
KA(:,13,16) = (/ &
 & 0.21716E+01_JPRB,0.21171E+01_JPRB,0.20639E+01_JPRB,0.20113E+01_JPRB,0.19587E+01_JPRB /)  
  
!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.315770E-07_JPRB, 0.671978E-07_JPRB, 0.440649E-06_JPRB /)
FORREF(:, 2) = (/ 0.313674E-06_JPRB, 0.285252E-06_JPRB, 0.421024E-05_JPRB /)
FORREF(:, 3) = (/ 0.135818E-05_JPRB, 0.145071E-05_JPRB, 0.611285E-05_JPRB /)
FORREF(:, 4) = (/ 0.534065E-05_JPRB, 0.586268E-05_JPRB, 0.933970E-05_JPRB /)
FORREF(:, 5) = (/ 0.964007E-05_JPRB, 0.107110E-04_JPRB, 0.104486E-04_JPRB /)
FORREF(:, 6) = (/ 0.302775E-04_JPRB, 0.357530E-04_JPRB, 0.340724E-04_JPRB /)
FORREF(:, 7) = (/ 0.102437E-03_JPRB, 0.108475E-03_JPRB, 0.105245E-03_JPRB /)
FORREF(:, 8) = (/ 0.146054E-03_JPRB, 0.141490E-03_JPRB, 0.133071E-03_JPRB /)
FORREF(:, 9) = (/ 0.163978E-03_JPRB, 0.150208E-03_JPRB, 0.142864E-03_JPRB /)
FORREF(:,10) = (/ 0.220412E-03_JPRB, 0.182943E-03_JPRB, 0.150941E-03_JPRB /)
FORREF(:,11) = (/ 0.228877E-03_JPRB, 0.197679E-03_JPRB, 0.163220E-03_JPRB /)
FORREF(:,12) = (/ 0.234177E-03_JPRB, 0.217734E-03_JPRB, 0.185038E-03_JPRB /)
FORREF(:,13) = (/ 0.257187E-03_JPRB, 0.241570E-03_JPRB, 0.221178E-03_JPRB /)
FORREF(:,14) = (/ 0.272455E-03_JPRB, 0.270637E-03_JPRB, 0.256269E-03_JPRB /)
FORREF(:,15) = (/ 0.339445E-03_JPRB, 0.300268E-03_JPRB, 0.286574E-03_JPRB /)
FORREF(:,16) = (/ 0.338841E-03_JPRB, 0.355428E-03_JPRB, 0.353794E-03_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.100945E-04_JPRB, 0.801113E-05_JPRB, 0.635771E-05_JPRB, 0.504554E-05_JPRB, 0.400419E-05_JPRB, &
 & 0.317777E-05_JPRB, 0.252191E-05_JPRB, 0.200141E-05_JPRB, 0.158834E-05_JPRB, 0.126052E-05_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.107573E-04_JPRB, 0.999809E-05_JPRB, 0.929245E-05_JPRB, 0.863661E-05_JPRB, 0.802706E-05_JPRB, &
 & 0.746053E-05_JPRB, 0.693399E-05_JPRB, 0.644460E-05_JPRB, 0.598976E-05_JPRB, 0.556702E-05_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.350389E-04_JPRB, 0.319234E-04_JPRB, 0.290850E-04_JPRB, 0.264989E-04_JPRB, 0.241428E-04_JPRB, &
 & 0.219962E-04_JPRB, 0.200404E-04_JPRB, 0.182586E-04_JPRB, 0.166351E-04_JPRB, 0.151560E-04_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.122993E-03_JPRB, 0.110885E-03_JPRB, 0.999691E-04_JPRB, 0.901277E-04_JPRB, 0.812551E-04_JPRB, &
 & 0.732559E-04_JPRB, 0.660443E-04_JPRB, 0.595426E-04_JPRB, 0.536809E-04_JPRB, 0.483963E-04_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.206434E-03_JPRB, 0.187435E-03_JPRB, 0.170185E-03_JPRB, 0.154522E-03_JPRB, 0.140301E-03_JPRB, &
 & 0.127388E-03_JPRB, 0.115664E-03_JPRB, 0.105019E-03_JPRB, 0.953540E-04_JPRB, 0.865783E-04_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.590645E-03_JPRB, 0.533109E-03_JPRB, 0.481177E-03_JPRB, 0.434305E-03_JPRB, 0.391998E-03_JPRB, &
 & 0.353812E-03_JPRB, 0.319346E-03_JPRB, 0.288238E-03_JPRB, 0.260160E-03_JPRB, 0.234817E-03_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.163029E-02_JPRB, 0.148773E-02_JPRB, 0.135763E-02_JPRB, 0.123891E-02_JPRB, 0.113057E-02_JPRB, &
 & 0.103170E-02_JPRB, 0.941483E-03_JPRB, 0.859153E-03_JPRB, 0.784023E-03_JPRB, 0.715462E-03_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.204528E-02_JPRB, 0.189258E-02_JPRB, 0.175128E-02_JPRB, 0.162053E-02_JPRB, 0.149954E-02_JPRB, &
 & 0.138758E-02_JPRB, 0.128398E-02_JPRB, 0.118812E-02_JPRB, 0.109941E-02_JPRB, 0.101733E-02_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.210589E-02_JPRB, 0.197078E-02_JPRB, 0.184434E-02_JPRB, 0.172601E-02_JPRB, 0.161528E-02_JPRB, &
 & 0.151164E-02_JPRB, 0.141466E-02_JPRB, 0.132390E-02_JPRB, 0.123896E-02_JPRB, 0.115947E-02_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.245098E-02_JPRB, 0.233745E-02_JPRB, 0.222918E-02_JPRB, 0.212592E-02_JPRB, 0.202745E-02_JPRB, &
 & 0.193353E-02_JPRB, 0.184397E-02_JPRB, 0.175856E-02_JPRB, 0.167710E-02_JPRB, 0.159941E-02_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.267460E-02_JPRB, 0.253325E-02_JPRB, 0.239936E-02_JPRB, 0.227255E-02_JPRB, 0.215244E-02_JPRB, &
 & 0.203868E-02_JPRB, 0.193093E-02_JPRB, 0.182888E-02_JPRB, 0.173222E-02_JPRB, 0.164067E-02_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.304510E-02_JPRB, 0.283919E-02_JPRB, 0.264720E-02_JPRB, 0.246820E-02_JPRB, 0.230130E-02_JPRB, &
 & 0.214568E-02_JPRB, 0.200059E-02_JPRB, 0.186531E-02_JPRB, 0.173918E-02_JPRB, 0.162157E-02_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.338445E-02_JPRB, 0.314719E-02_JPRB, 0.292655E-02_JPRB, 0.272139E-02_JPRB, 0.253060E-02_JPRB, &
 & 0.235319E-02_JPRB, 0.218822E-02_JPRB, 0.203482E-02_JPRB, 0.189217E-02_JPRB, 0.175952E-02_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.388649E-02_JPRB, 0.357018E-02_JPRB, 0.327961E-02_JPRB, 0.301269E-02_JPRB, 0.276750E-02_JPRB, &
 & 0.254226E-02_JPRB, 0.233535E-02_JPRB, 0.214528E-02_JPRB, 0.197068E-02_JPRB, 0.181029E-02_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.412547E-02_JPRB, 0.387413E-02_JPRB, 0.363810E-02_JPRB, 0.341646E-02_JPRB, 0.320831E-02_JPRB, &
 & 0.301285E-02_JPRB, 0.282930E-02_JPRB, 0.265693E-02_JPRB, 0.249506E-02_JPRB, 0.234305E-02_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.534327E-02_JPRB, 0.482967E-02_JPRB, 0.436544E-02_JPRB, 0.394583E-02_JPRB, 0.356655E-02_JPRB, &
 & 0.322373E-02_JPRB, 0.291387E-02_JPRB, 0.263378E-02_JPRB, 0.238062E-02_JPRB, 0.215179E-02_JPRB /)  
     
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_KGB23',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_KGB23

