! replacement for coefils.h
MODULE coefils_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  IMPLICIT NONE; PRIVATE

  PUBLIC jfiltnu, jfiltsu, jfiltnv, jfiltsv, sddu, sddv, unsddu, unsddv, coefilu, coefilv, &
          modfrstu, modfrstv, eignfnu, eignfnv, coefilu2, coefilv2

  INTEGER :: jfiltnu ! index of the last lat line filtered in NH (U grid)
  INTEGER :: jfiltsu ! index of the first lat line filtered in SH (U grid)
  INTEGER :: jfiltnv ! index of the last lat line filtered in NH (V grid)
  INTEGER :: jfiltsv ! index of the first lat line filtered in SH (V grid)
  INTEGER, DIMENSION(jjm) :: modfrstu ! number of retained (ie: unfiltered) modes on U grid
  INTEGER, DIMENSION(jjm) :: modfrstv ! number of retained (ie: unfiltered) modes on V grid
  REAL, DIMENSION(iim) :: sddu, sddv, unsddu, unsddv
  REAL, DIMENSION(iim, jjm) :: coefilu, coefilv, coefilu2, coefilv2
  REAL, DIMENSION(iim, iim) :: eignfnu, eignfnv
END MODULE coefils_mod_h
