! (C) Copyright 1991- ECMWF.
!
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
!
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.

MODULE YOEPHY

USE PARKIND1, ONLY : JPRB, JPIM
!USE ISO_C_BINDING

IMPLICIT NONE

SAVE

!     -----------------------------------------------------------------
!*    ** *YOEPHY* - SWITCHES RELATED TO DIABATIC PROCESSES
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

TYPE :: TEPHY
!!! LOGICAL :: LEPHYS
!!! LOGICAL :: LECOND
!!! LOGICAL :: LECUMF
!!! LOGICAL :: LEDCLD
!!! LOGICAL :: LEEVAP
!!! LOGICAL :: LEGWDG
!!! LOGICAL :: LEGWWMS
!!! LOGICAL :: LEOZOC
!!! LOGICAL :: LEQNGT
!!! LOGICAL :: LERADI
!!! LOGICAL :: LERADS
!!! LOGICAL :: LESICE
!!! LOGICAL :: LESURF
!!! LOGICAL :: LEVDIF
!!! LOGICAL :: LAGPHY
!!! LOGICAL :: LEPCLD
!!! LOGICAL :: LEO3CH
!!! LOGICAL :: LO3CH_SAFE
!!! LOGICAL :: LO3CH_OLDVER
!!! LOGICAL :: LO3CH_BMS
!!! LOGICAL :: LO3CH_HLO
!!! CHARACTER(LEN=4) :: CO3CHEM
!!! LOGICAL :: LECO2DIU
!!! LOGICAL :: LNEEONLINE
!!! LOGICAL :: LBUD23
!!! LOGICAL :: LPPTILES
!!! LOGICAL :: LBUDCYCLE
!!! LOGICAL :: LEMETHOX
!!! LOGICAL :: LECURR
!!! LOGICAL :: LESURFTRAJ
!!! LOGICAL :: LVDFTRAC
!!! LOGICAL :: LMFTRAC
!!! LOGICAL :: LMFSCAV
!!! LOGICAL :: LERAIN
!!! LOGICAL :: LEMWAVE
!!! LOGICAL :: LEGBRAD
!!! LOGICAL :: LERAINGG
!!! LOGICAL :: LESMOS
!!! LOGICAL :: LESMAP
!!! LOGICAL :: LEOCWA
!!! LOGICAL :: LEOCCO
!!! LOGICAL :: LEOCSA
!!! LOGICAL :: LEOCLA
!!! LOGICAL :: LEVGEN
!!! LOGICAL :: LESSRO
!!! LOGICAL :: LEFLAKE
!!! LOGICAL :: LEOCML
!!! LOGICAL :: LEOBC
!!! LOGICAL :: LEOBCMAX
!!! REAL(KIND=JPRB) :: REOBCMAX
!!! LOGICAL :: LEOBCICE
!!! LOGICAL :: LEOCLAKE
!!! LOGICAL :: LEOLAKESST
!!! LOGICAL :: LOCMLTKE
!!! LOGICAL :: LECLIPQT0
!!! LOGICAL :: LECLIPCLDT0
!!! LOGICAL :: LDUCTDIA
!!! LOGICAL :: LDIAGTURB_EC
!!! LOGICAL :: LDIAGTURBGRAD_EC
! ----- split ECMWF physics:for split physics (one part at t-Dt, one part at t+Dt)
!!! LOGICAL :: LSLPHY ! Moved from YOMCT0 /MH
!!! LOGICAL :: LESN09
!!! LOGICAL :: LELAIV
!!! LOGICAL :: LECTESSEL
!!! LOGICAL :: LEAGS
!!! LOGICAL :: LSPCRM
!!! LOGICAL :: LELIGHT
!!! REAL(KIND=JPRB) :: RTHRFRTI
!!! REAL(KIND=JPRB) :: RCIMIN
!!! REAL(KIND=JPRB) :: RLAIINT
!!! INTEGER (KIND=JPIM) :: NPRACCL
!!! INTEGER (KIND=JPIM) :: NLIMODE
!!! LOGICAL :: LECLIM10D ! 10-day clim interpolation
!!! LOGICAL :: LESNML
!!! INTEGER (KIND=JPIM) :: NSNMLWS

!VARIABLES FOR THE FLUX ADJUSTMENT OF GPP/RECO
!!! LOGICAL             :: LBFASCO2

! SOME VARIABLES RELATED TO THE DIFFERENT NBF CO2 CLIMATOLOGIES

! NCO2CLIMYY1    ===> First year in the NBF CO2 climatology
! NCO2CLIMYY2    ===> Last year in the NBF CO2 climatology
! NCO2CLIMN1     ===> starting time for the diurnally variable fluxes (in minutes)
! NCO2CLIMN2     ===> end time for the diurnally variable fluxes (in minutes)
! NCO2CLIMFRQ    ===> time frequency at which the diurnal cycle is provided (in minutes)

!!! INTEGER(KIND=JPIM) :: NCO2CLIMYY1
!!! INTEGER(KIND=JPIM) :: NCO2CLIMYY2
!!! INTEGER(KIND=JPIM) :: NCO2CLIMN1
!!! INTEGER(KIND=JPIM) :: NCO2CLIMN2
!!! INTEGER(KIND=JPIM) :: NCO2CLIMFRQ

! Surface albedo and emissivity scheme for radiation (needs to be
! defined here rather than in yoerad because NALBEDOSCHEME controls
! what albedo climatology fields are read in, which is done before
! yoerad is initialized).
INTEGER(KIND=JPIM) :: NALBEDOSCHEME
INTEGER(KIND=JPIM) :: NEMISSSCHEME

! Albedo of permanent snow, used in Antarctica and on glaciers
!!! REAL(KIND=JPRB) :: RALFMINPSN

!     REFERENCE.
!     ----------

!     F Vitart      E.C.M.W.F.      06/08/10

! RNORTHML : northern limit domain
! RSOUTHML : southern limit
! RWESTML : western limit
! REASTML : eastern limit
! INVML:  =true: ML is applied inside the domain, =false: ML is applied outside the domain

!!! REAL(KIND=JPRB) :: RNORTHML
!!! REAL(KIND=JPRB) :: RSOUTHML
!!! REAL(KIND=JPRB) :: RWESTML
!!! REAL(KIND=JPRB) :: REASTML

!!! LOGICAL :: INVML
!!! LOGICAL :: LFPOS_EC_PHYS = .FALSE.
!!! LOGICAL :: LFPOS_ACC_RESET

! LRAD_CLOUD_INHOMOG: Logical:Use regime-dependent value of fractional
! standard deviation (FSD) of condensate in radiation scheme.
! Required to set up GFL variable to carry FSD from cloudsc to radiation
!!! LOGICAL :: LRAD_CLOUD_INHOMOG

! YSURF :  Pointer to surface package configuration

!!! TYPE(C_PTR) :: YSURF
!----------------------------------------------------------------------------

CONTAINS

  PROCEDURE, PASS :: PRINT => PRINT_CONFIGURATION

END TYPE TEPHY

TYPE(TEPHY), POINTER :: YREPHY => NULL()

!     REFERENCE.
!     ----------

!     J.-J. MORCRETTE       E.C.M.W.F.      91/07/14

!     MODIFICATIONS
!     -------------

!     P. Viterbo   ECMWF   03-12-2004  Include user-defined RTHRFRTI
!     G. Balsamo   ECMWF   14-03-2007  Include LEVGEN, LESSRO switches
!     G. Balsamo   ECMWF   07-04-2008  Include LEFLAKE switch
!     G. Balsamo   ECMWF   13-10-2008  Include LEOCML switch
!     F. Vitart    ECMWF   21-01-2013  Include LEOBC switch
!     G. Balsamo   ECMWF   13-10-2008  Include LESNWD switch
!     P. Lopez     ECMWF   24-01-2009  Include LDUCTDIA switch
!     G. Balsamo   ECMWF   24-02-2009  Include full set of SNOW switches
!     Y. Takaya    ECMWF   21-08-2009  Include LEOCLA switch
!     S. Boussetta/G.Balsamo May 2009  Include variable LAI switch LELAIV
!     E. Dutra             18-11-2009  snow 2009 cleaning of logicals - LESN09 to activate all
!     Y. Takaya/P. de Rosnay May 2020  SSS for SMOS
!     P. Lopez     ECMWF   14-08-2009  Include LEGBRAD switch and NPRACCL
!     S.Boussetta/G.Balsamo  Nov 2010  Include land carbon switch LECTESSEL
!     G.Balsamo    ECMWF   21-06-2011  Include LEAGS switch (CO2&Evap modularity)
!     P. Lopez     ECMWF   22-08-2012  Include LERAINGG switch for rain gauge assim.
!     S.Boussetta  Nov 2013  Include 10-day clim interpolation switch LECLIM10D
!     F. Vana & M. Kharoutdinov 06-Feb-2015  Super-parametrization scheme.
!     A. Agusti-Panareda   09-08-2013  Add flag for GPP/REC flux adjustment (LBFASCO2)
!     P. Lopez     ECMWF   24-07-2015  Added LELIGHT and NLIMODE for lightning parameterization.
!     E.Dutra/G.Arduini    Jan 2018: Include LESNML switch turn on/off snow multi-layer
!     R. Hogan     ECMWF   14-01-2019  Replace LE4ALB with NALBEDOSCHEME, add NEMISSSCHEME
!     P. Bechtold  ECMWF   21-02-2019  Add LDIAGTURB_EC switch for 3D Turb EDRP diagnostics
!     R. Hogan     ECMWF   07-03-2019  Add RALFMINPSN: albedo of permanent snow
!     ------------------------------------------------------------------

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LEPHYS : LOGICAL : SWITCH THE FULL E.C.M.W.F. PHYSICS PACKAGE ON
! LAGPHY : LOGICAL : IF TRUE, PHYSICS PACKAGE CALLED IN LAGGED MODE
! LECOND : LOGICAL : TURN THE LARGE-SCALE CONDENSATION ON
! LECUMF : LOGICAL : TURN THE MASS-FLUX CUMULUS CONVECTION SCHEME ON
! LEDCLD : LOGICAL : TURN THE DIAGNOSTIC CLOUD SCHEME ON
! LEPCLD : LOGICAL : TURN THE PROGNOSTIC CLOUD SCHEME ON
! LEEVAP : LOGICAL : TURN THE EVAPORATION OF PRECIPITATION ON
! LEGWDG : LOGICAL : TURN THE GRAVITY WAVE DRAG ON
! LEGWWMS: LOGICAL : TURN THE WARNER-MCINTYRE-SCINOCCA NON-OROGRAPHIC GRAVITY WAVE SCHEME ON
! LEOZOC : LOGICAL : TURN THE CLIMATOLOGICAL OZONE ON
! LEQNGT : LOGICAL : TURN THE NEGATIVE HUMIDITY FIXER ON
! LERADI : LOGICAL : TURN THE RADIATION SCHEME ON
! LERADS : LOGICAL : TURN THE INTERACTIVE SURFACE RADIATIVE PROPERTIESON
! LESICE : LOGICAL : TURN THE INTERACTIVE SEA ICE PROCESSES ON
! LESURF : LOGICAL : TURN THE INTERACTIVE SURFACE PROCESSES ON
! LEVDIF : LOGICAL : TURN THE VERTICAL DIFFUSION ON
! LEO3CH : LOGICAL : TURN THE O3 CHEMISTRY ON (for EC prog. ozone)
! LO3CH_SAFE : LOGICAL : TURN INCREASED RELAXATION TO O3 TERM
! LO3CH_HLO  : LOGICAL : USE HYBRID LINEAR OZONE SCHEME
! CO3CHEM    : CHARACTER(LEN=4) : OZONE CHEMISTRY VERSION
! LO3CH_OLDVER : LOGICAL : USE OLD VERSION (v2.3) OF OZONE CHEMISTRY
! LECO2DIU: LOGICAL: UPDATE THE NBF CO2 FLUXES CLIMATOLOGY DURING THE RUN OF THE MODEL (introduce a diurnal cycle)
! LNEEONLINE: LOGICAL: USE ON-LINE CTESSEL IF TRUE
! LBFASCO2 : LOGICAL : APPLY THE FLUX ADJUSTMENT TO GPP AND REC IN CTESSEL
! LBUD23 : LOGICAL : SWITCH FOR 3 AND 2 DIMENSIONAL BUDGETS
! LPPTILES : LOGICAL : SWITCH FOR TILE POST-PROCESSING
! LBUDCYCLE: LOGICL: SWITCH FOR DIURNAL CYCLE DIAGNOSTICS
! LEMETHOX: LOGICAL: TURN THE METHANE OXIDATION ON
! LECURR : LOGICAL : IF TRUE, OCEAN CURRENT BOUNDARY CONDITION IS USED
! LVDFTRAC: LOGICAL: TURN TRACER TRANSPORT BY VERTICAL DIFFUSION ON
! LMFTRAC: LOGICAL : TURN TRACER TRANSPORT BY MASS FLUX CONVECTION ON
! LMFSCAV:LOGICAL  : TURN TRACER WET SCAAVENGING IN CUMULUS CONVECTION SCHEME ON
! LERAIN : LOGICAL : RAIN ASSIMILATION
! LEMWAVE : LOGICAL : ALL-SKY RADIANCE ASSIMILATION
! LEOCWA : LOGICAL : WARM OCEAN LAYER PARAMETRIZATION
! LEOBC  : LOGICAL : SST CORRECTION
! LEOBCMAX : LOGICAL : REMOVE ANY SST CORRECTIONS LARGER THAN REOBCMAX
! REOBCMAX : REAL : SST CORRECTIONS ABS(VALUES) LARGER THAN THIS VALUE IS IGNORED IF LEOBCCHK
! LEOBCICE : LOGICAL : ICE CORRECTION (IMPLIED IF LEOBC)
! LEOCCO : LOGICAL : COOL OCEAN SKIN PARAMETRIZATION
! LEOCSA : LOGICAL : SALINTY EFFECT ON SATURATION AT OCEAN SURFACE
! LEOCLA : LOGICAL : LANGMUIR CIRCULATION EFFECT IN SKIN LAYER SCHEME
! RTHRFRTI : INTEGER : MINIMUM FRACTION FOR ALL SURFACE TILES
! PRCIMIN : REAL : MINIMUM ICE FRACTION
! LEVGEN : LOGICAL  : VAN GENUCHTEN HYDROLOGY (with SOIL TYPE field)
! LESSRO : LOGICAL  : OROGRAPHIC (VIC-TYPE) RUNOFF
! LEFLAKE : LOGICAL  : LAKE MODEL FLAKE
! LEOCML : LOGICAL  : OCEAN MIX LAYER MODEL
! LEOCLAKE : LOGICAL  : PERSISTED LAKE SST and ICE
! LEOLAKESST : LOGICAL : USE LAKES TEMPERATURE AND ICE AS SST AND ICE ON LAKE POINTS
! LOCMLTKE : LOGICAL  : IF TRUE JANSSEN'S VERSION OF THE MELLOR-YAMADA SCHEME IS RUN.
! LECLIPQT0: LOGICAL: REMOVE NEGATIVE Q AND SUPERSATURATION AT INITIAL TIME
! LECLIPCLDT0: LOGICAL: REMOVE NEGATIVE CLOUD WATER/ICE AND BOUND CLOUD COVER AT INITIAL TIME
! LDUCTDIA : LOGICAL  : COMPUTATIONS AND ARCHIVING OF DUCTING DIAGNOSTICS
! LDIAGTURB_EC : LOGICAL  : ACTIVATE 3D TURBULENCE EDR PARAMETERS FOR CAT AND MWT
! LDIAGTURBGRAD_EC : LOGICAL  : ACTIVATE HORIZONTAL GRADIENTS FOR  3D TURBULENCE EDR PARAMETERS
! LESN09 : LOGICAL  : IF true use the snow 2009 scheme (liquid water, density, snow cover fraction, exposed and forest albedo)
! LELAIV : LOGICAL  : IF FALSE OVERWRITE CLIMATE LAI FIELDS WITH LUT VALUES
! LECTESSEL : LOGICAL : LAND CARBON (CTESSEL) USED FOR CO2 FLUXES
! LEAGS   : LOGICAL : LAND CARBON (CTESSEL) USED FOR CO2 AND EVAP FLUXES
! RLAIINT : REAL    : INTERACTIVE LAI CLIM RELAXATION (1=interactive ; 0=clim)
! LEGBRAD : LOGICAL : ACTIVATE RADAR PRECIPITATION OBSERVATION OPERATOR
! NPRACCL : INTEGER : ACCUMULATION LENGTH FOR RADAR PRECIPITATION OBSERVATION ASSIMILATION
! LERAINGG : LOGICAL : ACTIVATE RAIN GAUGE OBSERVATION OPERATOR
! LECLIM10D: Logical: IF TRUE interpolate between 10-day climate values (for albedo and LAI)
! LSPCRM : LOGICAL : ACTIVATES SUPER-PARAMETRIZATION SCHEME REPLACING MOIST PROCESSES.
! LELIGHT : LOGICAL : ACTIVATES LIGHTNING PARAMETRIZATION.
! NLIMODE : LOGICAL : SELECTION OF LIGHTNING PARAMETRIZATION (see CULIGHT routine).
! RALFMINPSN : REAL : Albedo of permanent snow, used in Antarctica and on glaciers
! NALBEDOSCHEME : INTEGER :   Surface shortwave albedo:
!                             0: ERBE
!                             1: MODIS 4 comp. (UV-Vis+NIR)x(direct+diffuse), nearest neigh to SW bands
!                             2: MODIS 6 component, weighting to SW bands
!                             3: MODIS 2 compoent (diffuse albedo for everything, weighting to SW bands
! NEMISSSCHEME  : INTEGER :   Surface longwave emissivity scheme:
!                             0: 2-interval (infrared window and everything else)
!                             1: 6-interval scheme

!     -----------------------------------------------------------------

CONTAINS

SUBROUTINE PRINT_CONFIGURATION(SELF, KDEPTH, KOUTNO)
  IMPLICIT NONE
  CLASS(TEPHY), INTENT(IN) :: SELF
  INTEGER     , INTENT(IN) :: KDEPTH
  INTEGER     , INTENT(IN) :: KOUTNO

  INTEGER :: IDEPTHLOC

  IDEPTHLOC = KDEPTH+2

  WRITE(KOUTNO,*) REPEAT(' ',KDEPTH   ) // 'model%yrml_phy_ec%yrephy : '
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEPHYS = ', SELF%LEPHYS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECOND = ', SELF%LECOND
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECUMF = ', SELF%LECUMF
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEDCLD = ', SELF%LEDCLD
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEEVAP = ', SELF%LEEVAP
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEGWDG = ', SELF%LEGWDG
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEGWWMS = ', SELF%LEGWWMS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOZOC = ', SELF%LEOZOC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEQNGT = ', SELF%LEQNGT
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LERADI = ', SELF%LERADI
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LERADS = ', SELF%LERADS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESICE = ', SELF%LESICE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESURF = ', SELF%LESURF
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEVDIF = ', SELF%LEVDIF
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LAGPHY = ', SELF%LAGPHY
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEPCLD = ', SELF%LEPCLD
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEO3CH = ', SELF%LEO3CH
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LO3CH_OLDVER = ', SELF%LO3CH_OLDVER
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LO3CH_BMS = ', SELF%LO3CH_BMS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LO3CH_HLO = ', SELF%LO3CH_HLO
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'CO3CHEM = ', SELF%CO3CHEM
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECO2DIU = ', SELF%LECO2DIU
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LNEEONLINE = ', SELF%LNEEONLINE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LBUD23 = ', SELF%LBUD23
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LPPTILES = ', SELF%LPPTILES
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LBUDCYCLE = ', SELF%LBUDCYCLE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEMETHOX = ', SELF%LEMETHOX
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECURR = ', SELF%LECURR
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LVDFTRAC = ', SELF%LVDFTRAC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LMFTRAC = ', SELF%LMFTRAC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LMFSCAV = ', SELF%LMFSCAV
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LERAIN = ', SELF%LERAIN
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEMWAVE = ', SELF%LEMWAVE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEGBRAD = ', SELF%LEGBRAD
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LERAINGG = ', SELF%LERAINGG
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESMOS = ', SELF%LESMOS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESMAP = ', SELF%LESMAP
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCWA = ', SELF%LEOCWA
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCCO = ', SELF%LEOCCO
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCSA = ', SELF%LEOCSA
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCLA = ', SELF%LEOCLA
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEVGEN = ', SELF%LEVGEN
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESSRO = ', SELF%LESSRO
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEFLAKE = ', SELF%LEFLAKE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCML = ', SELF%LEOCML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOBC = ', SELF%LEOBC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOBCICE = ', SELF%LEOBCICE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOCLAKE = ', SELF%LEOCLAKE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEOLAKESST = ', SELF%LEOLAKESST
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LOCMLTKE = ', SELF%LOCMLTKE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECLIPQT0 = ', SELF%LECLIPQT0
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECLIPCLDT0 = ', SELF%LECLIPCLDT0
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LDUCTDIA = ', SELF%LDUCTDIA
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LDIAGTURB_EC = ', SELF%LDIAGTURB_EC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LDIAGTURBGRAD_EC = ', SELF%LDIAGTURBGRAD_EC
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESN09 = ', SELF%LESN09
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LELAIV = ', SELF%LELAIV
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECTESSEL = ', SELF%LECTESSEL
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LEAGS = ', SELF%LEAGS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LSPCRM = ', SELF%LSPCRM
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LELIGHT = ', SELF%LELIGHT
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RTHRFRTI = ', SELF%RTHRFRTI
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RCIMIN = ', SELF%RCIMIN
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RLAIINT = ', SELF%RLAIINT
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NPRACCL = ', SELF%NPRACCL
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NLIMODE = ', SELF%NLIMODE
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LECLIM10D = ', SELF%LECLIM10D
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LESNML = ', SELF%LESNML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NSNMLWS = ', SELF%NSNMLWS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LBFASCO2 = ', SELF%LBFASCO2
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NCO2CLIMYY1 = ', SELF%NCO2CLIMYY1
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NCO2CLIMYY2 = ', SELF%NCO2CLIMYY2
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NCO2CLIMN1 = ', SELF%NCO2CLIMN1
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NCO2CLIMN2 = ', SELF%NCO2CLIMN2
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NCO2CLIMFRQ = ', SELF%NCO2CLIMFRQ
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RNORTHML = ', SELF%RNORTHML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RSOUTHML = ', SELF%RSOUTHML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'RWESTML = ', SELF%RWESTML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'REASTML = ', SELF%REASTML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'INVML = ', SELF%INVML
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LFPOS_EC_PHYS = ', SELF%LFPOS_EC_PHYS
  ! WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'LFPOS_ACC_RESET = ', SELF%LFPOS_ACC_RESET
  WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NALBEDOSCHEME = ', SELF%NALBEDOSCHEME
  WRITE(KOUTNO,*) REPEAT(' ',IDEPTHLOC) // 'NEMISSSCHEME = ', SELF%NEMISSSCHEME

END SUBROUTINE PRINT_CONFIGURATION

END MODULE YOEPHY
