MODULE lmdz_spla_ini

IMPLICIT NONE

SAVE

! from indice_sol_mod.f90
INTEGER, PROTECTED :: is_oce
!$OMP THREADPRIVATE(is_oce)

! from yomcst_mod_h.f90
REAL, PROTECTED :: RNAVO,RG,RD,RCPD,RLVTT,RLSTT,RETV,RTT  
!$OMP THREADPRIVATE(RNAVO,RG,RD,RCPD,RLVTT,RLSTT,RETV,RTT)

! from yoethf_mod_h.f90
! COMMON *YOETHF* DERIVED CONSTANTS SPECIFIC TO ECMWF THERMODYNAMICS
REAL :: R2ES,R3IES,R3LES,R4IES,R4LES,R5IES,R5LES,RVTMP2     
!$OMP THREADPRIVATE(R2ES,R3LES,R3IES,R4LES,R4IES,R5LES,R5IES,RVTMP2)

! from chem_mod_h.f90
REAL, PARAMETER :: masse_s=32.0  !--g mol-1 ; molar mass sulfur-32 isotope (stable)

! from chem_spla_mod_h.f90 
REAL, PARAMETER :: masse_ammsulfate = 132.0  !--g mol-1

CONTAINS

SUBROUTINE spla_ini(is_oce_in,   &
                RNAVO_in,RG_in,RD_in,RCPD_in,RLVTT_in,RLSTT_in,RETV_in,RTT_in,  &
                R2ES_in,R3LES_in,R3IES_in,R4LES_in,R4IES_in,R5LES_in,R5IES_in,RVTMP2_in  &
                )

IMPLICIT NONE

integer, intent(in) :: is_oce_in
real, intent(in) :: RNAVO_in,RG_in,RD_in,RCPD_in,RLVTT_in,RLSTT_in,RETV_in,RTT_in
real, intent(in) :: R2ES_in,R3LES_in,R3IES_in,R4LES_in,R4IES_in,R5LES_in,R5IES_in,RVTMP2_in

is_oce=is_oce_in

RNAVO=RNAVO_in
RG=RG_in
RD=RD_in
RCPD=RCPD_in
RLVTT=RLVTT_in
RLSTT=RLSTT_in
RETV=RETV_in
RTT=RTT_in

R2ES=R2ES_in
R3LES=R3LES_in
R3IES=R3IES_in
R4LES=R4LES_in
R4IES=R4IES_in
R5LES=R5LES_in
R5IES=R5IES_in
RVTMP2=RVTMP2_in

END SUBROUTINE spla_ini

END MODULE lmdz_spla_ini
