! PARAMETERS FOR GRAVITY WAVE DRAG CALCULATIONS
MODULE yoegwd_mod_h
  IMPLICIT NONE; PRIVATE
  PUBLIC GFRCRIT, GKWAKE, GRCRIT, GVCRIT, GKDRAG, GKLIFT, GHMAX, GRAHILO, GSIGCR, NKTOPG, NSTRA, GSSEC, GTSEC, GVSEC, &
          GWD_RANDO_RUWMAX, gwd_rando_sat, GWD_FRONT_RUWMAX, gwd_front_sat

  INTEGER NKTOPG, NSTRA
  REAL GFRCRIT, GKWAKE, GRCRIT, GVCRIT, GKDRAG, GKLIFT
  REAL GHMAX, GRAHILO, GSIGCR, GSSEC, GTSEC, GVSEC

  REAL GWD_RANDO_RUWMAX
  !     Maximum Eliassen-Palm flux at launch level, in "FLOTT_GWD_rando"

  REAL GWD_RANDO_SAT ! saturation parameter in "FLOTT_GWD_rando"
  !     S_c in equation (12) of Lott (JGR, vol 118, page 8897, 2013)

  REAL GWD_FRONT_RUWMAX, GWD_FRONT_SAT
  ! Same as GWD_RANDO params but for fronal GWs

  !$OMP THREADPRIVATE(GFRCRIT, GKWAKE, GRCRIT, GVCRIT, GKDRAG, GKLIFT, GHMAX, GRAHILO, GSIGCR, NKTOPG, NSTRA, GSSEC, GTSEC, GVSEC, &
  !$OMP          GWD_RANDO_RUWMAX, gwd_rando_sat, GWD_FRONT_RUWMAX, gwd_front_sat)
END MODULE yoegwd_mod_h
