MODULE YOECLD

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     -----------------------------------------------------------------
!*    ** *YOECLD* - CONTROL PARAMETERS FOR DIAGNOSTIC CLOUDS
!     -----------------------------------------------------------------

REAL(KIND=JPRB),ALLOCATABLE:: CETA(:)

REAL(KIND=JPRB) :: RANVA
REAL(KIND=JPRB) :: RANVB
REAL(KIND=JPRB) :: RANVH
REAL(KIND=JPRB) :: RCCA
REAL(KIND=JPRB) :: RCCB
REAL(KIND=JPRB) :: RCCC
REAL(KIND=JPRB) :: RCFCT
REAL(KIND=JPRB) :: RCLWMR
REAL(KIND=JPRB) :: RCSCAL
REAL(KIND=JPRB) :: RETAHB
REAL(KIND=JPRB) :: RETAMB
REAL(KIND=JPRB) :: RLOIA
REAL(KIND=JPRB) :: RLOIB
REAL(KIND=JPRB) :: RLOIC
REAL(KIND=JPRB) :: RLOID
REAL(KIND=JPRB) :: RLONIA
REAL(KIND=JPRB) :: RLONIB
REAL(KIND=JPRB) :: RRHH
REAL(KIND=JPRB) :: RRHL
REAL(KIND=JPRB) :: RRHM
REAL(KIND=JPRB) :: RGAMMAS
REAL(KIND=JPRB) :: REPSCR
REAL(KIND=JPRB) :: REPSEC
LOGICAL :: LOMEGA

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  RANVA :  REAL     COEFFICIENT FOR ANVIL CLOUDS
!  RANVB :  REAL     COEFFICIENT FOR ANVIL CLOUDS
!  RANVH :  REAL     MINIMUM HIGH CLOUD COVER FOR ANVIL CLOUDS
!  RCCA  :  REAL     COEFFICIENT FOR DIAGNOSTIC OF CONVECTIVE CLOUD
!  RCCB  :  REAL     COEFFICIENT FOR DIAGNOSTIC OF CONVECTIVE CLOUD
!  RCCC  :  REAL     MAXIMUM COVER BY CONVECTIVE CLOUD
!  RCFCT :  REAL     WEIGHTING FACTOR FOR CONVECTIVE CLOUD TOWER
!  RCLWMR:  REAL     LIQUID WATER MIXING RATIO FOR CONVECTIVE CLOUD
!  RCSCAL:  REAL     SCALING FACTOR FOR CONVECTIVE RAIN
!  CETA(NFLEVG) REAL  MODEL REFERENCE ETA-LEVEL
!  RETAHB:  REAL     ETA-LEVEL LIMIT FOR HIGH CLOUDS
!  RETAMB:  REAL     ETA-LEVEL LIMIT FOR MEDIUM CLOUDS
!  RLOIA :  REAL     COEFFICIENT FOR LOW CLOUD WHEN NO INVERSION
!  RLOIB :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLOIC :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLOID :  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLONIA:  REAL     COEFFICIENT FOR LOW CLOUD WHEN INVERSION
!  RLONIB:  REAL     COEFFICIENT FOR LOW CLOUD WHEN NO INVERSION
!  RRHH  :  REAL     CRITICAL RELATIVE HUMIDITY FOR HIGH CLOUDS
!  RRHL  :  REAL     CRITICAL RELATIVE HUMIDITY FOR LOW CLOUDS
!  RRHM  :  REAL     CRITICAL RELATIVE HUMIDITY FOR MEDIUM CLOUDS
!  GAMMAS:  REAL     PROPORTIONALITY FACTOR FOR LIQUID WATER CONTENT
!  REPSCR:  REAL     MINIMUM CONVECTIVE PRECIPITATION (SECURITY FACTOR)
!  REPSEC:  REAL     MINIMUM HORIZONTAL CLOUD COVER (SECURITY FACTOR)
!  LOMEGA:  LOGICAL  SWITCH FOR OMEGA-FILTER ON MIDDLE CLOUD
!     ------------------------------------------------------------------

!$OMP THREADPRIVATE(lomega,ranva,ranvb,ranvh,rcca,rccb,rccc,rcfct)
!$OMP THREADPRIVATE(rclwmr,rcscal,repscr,repsec,retahb,retamb,rgammas)
!$OMP THREADPRIVATE(rloia,rloib,rloic,rloid,rlonia,rlonib,rrhh,rrhl,rrhm)

!$OMP THREADPRIVATE(ceta)

END MODULE YOECLD
