!
! $Header$
!
!-------------------------------------------------------------------
! Interpolation sur des niveaux de pression.
!
! Enchainement des operations en prenant pour exemple la temperature
!
! 1. CALL ini_undefSTD :
!  On met les champs cumules à 0 si 
!  if mod(itap,nint(freq_outnmc(n)/phys_tstep))==1 
!          tnondef(i, k, n) = 0.
!          tsumstd(i, k, n) = 0.
!
! 2. Ensuite : 
!   on interpole les champs sur les niveaux STD de pression 
!   a chaque pas de temps de la physique avec plevel_new
!   t_seri -> tlevSTD
!
! 3. CALL undefSTD : 
!   On ajoute les champs à la moyenne tous les frec_calnmc
!      pas de temps
!   IF (mod(itap,nint(freq_calnmc(n)/phys_tstep))==0) THEN
!         IF (tlevstd(i,k)==missing_val) THEN
!           tnondef(i, k, n) = tnondef(i, k, n) + 1.
!         ELSE IF (tlevstd(i,k)/=missing_val) THEN
!           tsumstd(i, k, n) = tsumstd(i, k, n) + tlevstd(i, k)
!
! 4. CALL moy_undefSTD
!    On normalise à freq_outnmc, avant de reinitialiser plus haut dans ini_undef
!    IF mod(itap,nint(freq_outnmc(n)/phys_tstep))==0
!         tsumstd(i, k, n) = tsumstd(i, k, n)/(freq_moynmc(n)-tnondef(i,k,n))
!
! 5. Intrpolation des flux (pourquoi pas avec 2 ?)
!
! 6. Choix entre instantanné et moyenne en temps
!     twriteSTD(:,:,1)=tsumSTD(:,:,1)
!     twriteSTD(:,:,3)=tlevSTD(:,:)
! 
!  Premiere série de modifications (2025/05/07, FH) :
!   - Fait en sorte que freq_outnmc=ecrit_files
!   - Mis tous les USE avec ONLY dans *undefSTD.f90
!   - Utilie ecrit_files comme frequence de sortie freq_outnmc
!   - Nettoye la lecture des freq_outnmc et freq_calnmc dans conf_phys
!   - Passe les dimensionnement de certaines variables de 3 à 10
!     nombre de fichiers par défaut. En gros nout=nfiles
!  
!  Proposition de modifications :
!   - Ne plus calculer l'interpolation à tous les pas de temps
!      mais seulement à la fréquence freq_calcnmc
!   - Mettre le call ini_undefSTD juste avant undef_STD et moy_undefSTD
!   - Enlever ecrit_files(7) = freq_outNMC(1) dans phys_output_mod
!   - Enlever les vieux controles de fichiers dans conf_phys
!   - enlever les dimensionnement à 10 en dur
!   - Enlever toute chaine de caractère NMC dans le modèle.
!
!-------------------------------------------------------------------

!IM on initialise les variables 
!
!       missing_val=nf90_fill_real
!

! On peut à terme utiliser directement ecrit_files (le nom est moins
! bien choisi ...

       !print*,'STDSTD ecrit_files ',ecrit_files(1:4)
       freq_outnmc(:)=ecrit_files(:)
       freq_calnmc(:)=pdtphys

       IF (.not. ok_all_xml) then
        CALL ini_undefSTD(itap)
       ENDIF
!
!-------------------------------------------------------c
! positionnement de l'argument logique a .false.        c
! pour ne pas recalculer deux fois la meme chose !      c
! a cet effet un appel a plevel_new a ete deplace       c
! a la fin de la serie d'appels                         c
! la boucle 'DO k=1, nlevSTD' a ete internalisee        c
! dans plevel_new, d'ou la creation de cette routine... c
!-------------------------------------------------------c
!
        CALL plevel_new(klon,klev,nlevSTD,.true.,pplay,rlevSTD, &
                    t_seri,tlevSTD)
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   u_seri,ulevSTD)
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   v_seri,vlevSTD)
!

!
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zphi/RG,philevSTD)
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   qx(:,:,ivap),qlevSTD)
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_rh*100.,rhlevSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=u_seri(i,l)*v_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,uvSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=v_seri(i,l)*q_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,vqSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=v_seri(i,l)*t_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,vTSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=omega(i,l)*qx(i,l,ivap)
         ENDDO !i 
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,wqSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=v_seri(i,l)*zphi(i,l)/RG
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,vphiSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=omega(i,l)*t_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,wTSTD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=u_seri(i,l)*u_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,u2STD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=v_seri(i,l)*v_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,v2STD)
!
        DO l=1, klev
         DO i=1, klon
          zx_tmp_fi3d(i,l)=t_seri(i,l)*t_seri(i,l)
         ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,T2STD)

!
      zx_tmp_fi3d(:,:)=wo(:,:,1) * dobson_u * 1e3 / zmasse / rmo3 * rmd
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,O3STD)
!
      if (read_climoz == 2) THEN
      zx_tmp_fi3d(:,:)=wo(:,:,2) * dobson_u * 1e3 / zmasse / rmo3 * rmd
        CALL plevel_new(klon,klev,nlevSTD,.false.,pplay,rlevSTD, &
                   zx_tmp_fi3d,O3daySTD)
      endif
!
        DO l=1, klev
        DO i=1, klon
         zx_tmp_fi3d(i,l)=paprs(i,l)
        ENDDO !i
        ENDDO !l
        CALL plevel_new(klon,klev,nlevSTD,.true.,zx_tmp_fi3d,rlevSTD, &
                   omega,wlevSTD)
!
!IM on somme les valeurs toutes les freq_calNMC secondes
!IM on moyenne a la fin du mois, du jour ou toutes les 6h
!
       IF (.not. ok_all_xml) then
        CALL undefSTD(itap, read_climoz)
        CALL moy_undefSTD(itap)
       ENDIF
!
       CALL plevel(klon,klev,.true.,pplay,50000., &
                    zphi/RG,geo500)

!IM on interpole a chaque pas de temps le SWup(clr) et SWdn(clr) a 200 hPa
!
      CALL plevel(klon,klevp1,.true.,paprs,20000., &
           swdn0,SWdn200clr)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           swdn,SWdn200)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           swup0,SWup200clr)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           swup,SWup200)
!
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           lwdn0,LWdn200clr)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           lwdn,LWdn200)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           lwup0,LWup200clr)
      CALL plevel(klon,klevp1,.false.,paprs,20000., &
           lwup,LWup200)
!
      do n=1,nout
         !print*,'STDSTD n nout',n,nout,clef_files(n)
         if (clef_files(n)) then
             if (type_ecri(n)=='ave(X)') then
                 !print*,'STDSTD fichier ave(X), n=',n
                 twriteSTD(:,:,n)=tsumSTD(:,:,n)
                 qwriteSTD(:,:,n)=qsumSTD(:,:,n)
                 rhwriteSTD(:,:,n)=rhsumSTD(:,:,n)
                 phiwriteSTD(:,:,n)=phisumSTD(:,:,n)
                 uwriteSTD(:,:,n)=usumSTD(:,:,n)
                 vwriteSTD(:,:,n)=vsumSTD(:,:,n)
                 wwriteSTD(:,:,n)=wsumSTD(:,:,n)
             else
                 !print*,'STDSTD fichier autre, n=',n,type_ecri(n)
                 twriteSTD(:,:,n)=tlevSTD(:,:)
                 qwriteSTD(:,:,n)=qlevSTD(:,:)
                 rhwriteSTD(:,:,n)=rhlevSTD(:,:)
                 phiwriteSTD(:,:,n)=philevSTD(:,:)
                 uwriteSTD(:,:,n)=ulevSTD(:,:)
                 vwriteSTD(:,:,n)=vlevSTD(:,:)
                 wwriteSTD(:,:,n)=wlevSTD(:,:)
             endif
         endif
      enddo

!IM for NMC files
      DO n=1, nlevSTD3
       DO k=1, nlevSTD
        if(rlevSTD3(n).EQ.rlevSTD(k)) THEN
         twriteSTD3(:,n)=tlevSTD(:,k)
         qwriteSTD3(:,n)=qlevSTD(:,k)
         rhwriteSTD3(:,n)=rhlevSTD(:,k)
         phiwriteSTD3(:,n)=philevSTD(:,k)
         uwriteSTD3(:,n)=ulevSTD(:,k)
         vwriteSTD3(:,n)=vlevSTD(:,k)
         wwriteSTD3(:,n)=wlevSTD(:,k)
        endif !rlevSTD3(n).EQ.rlevSTD(k)
       ENDDO 
      ENDDO 
!
      DO n=1, nlevSTD8
       DO k=1, nlevSTD
        if(rlevSTD8(n).EQ.rlevSTD(k)) THEN
         tnondefSTD8(:,n)=tnondef(:,k,2)
         twriteSTD8(:,n)=tsumSTD(:,k,2)
         qwriteSTD8(:,n)=qsumSTD(:,k,2)
         rhwriteSTD8(:,n)=rhsumSTD(:,k,2)
         phiwriteSTD8(:,n)=phisumSTD(:,k,2)
         uwriteSTD8(:,n)=usumSTD(:,k,2)
         vwriteSTD8(:,n)=vsumSTD(:,k,2)
         wwriteSTD8(:,n)=wsumSTD(:,k,2)
        endif !rlevSTD8(n).EQ.rlevSTD(k)
       ENDDO 
      ENDDO 
