!
! $Header$
!
SUBROUTINE gradiv2(klevel, xcov, ycov, ld, gdx, gdy )
  !
  ! P. Le Van
  !
  !   **********************************************************
  !                            ld
  !   calcul  de  (grad (div) )   du vect. v ....
  !
  ! xcov et ycov etant les composant.covariantes de v
  !   **********************************************************
  ! xcont , ycont et ld  sont des arguments  d'entree pour le s-prog
  !  gdx   et  gdy       sont des arguments de sortie pour le s-prog
  !
  !
  USE comgeom_mod_h
  USE comdissipn_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !


  !
  ! ........    variables en arguments      ........

  INTEGER :: klevel
  REAL :: xcov( ip1jmp1,klevel ), ycov( ip1jm,klevel )
  REAL :: gdx( ip1jmp1,klevel ),  gdy( ip1jm,klevel )
  !
  ! ........       variables locales       .........
  !
  REAL :: div(ip1jmp1,llm)
  REAL :: signe, nugrads
  INTEGER :: l,ij,iter,ld

  !    ........................................................
  !
  !
  CALL SCOPY( ip1jmp1 * klevel, xcov, 1, gdx, 1 )
  CALL SCOPY(   ip1jm * klevel, ycov, 1, gdy, 1 )
  !
  !
  signe   = (-1.)**ld
  nugrads = signe * cdivu
  !


  CALL    divergf( klevel, gdx,   gdy , div )

  IF( ld.GT.1 )   THEN

    CALL laplacien ( klevel, div,  div     )

  !    ......  Iteration de l'operateur laplacien_gam   .......

    DO iter = 1, ld -2
     CALL laplacien_gam ( klevel,cuvscvgam1,cvuscugam1,unsair_gam1, &
           unsapolnga1, unsapolsga1,  div, div       )
    ENDDO

  ENDIF


   CALL filtreg( div   , jjp1, klevel, 2, 1, .TRUE., 1 )
   CALL  grad  ( klevel,  div,   gdx,  gdy             )

  !
   DO   l = 1, klevel
     DO  ij = 1, ip1jmp1
      gdx( ij,l ) = gdx( ij,l ) * nugrads
     ENDDO
     DO  ij = 1, ip1jm
      gdy( ij,l ) = gdy( ij,l ) * nugrads
     ENDDO
   ENDDO
  !
   RETURN
END SUBROUTINE gradiv2
