MODULE YOMAERD15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*     *YOMAERD15* SPECTRAL DISTRIBUTION OF AEROSOLS
!*                       FROZEN VERSION (CYCLE 15) OF YOEAERD
!     ------------------------------------------------------------------

REAL(KIND=JPRB),ALLOCATABLE:: CVDAES15(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAEL15(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAEU15(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAED15(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAEF15(:)

REAL(KIND=JPRB) :: RCAEOPS15
REAL(KIND=JPRB) :: RCAEOPL15
REAL(KIND=JPRB) :: RCAEOPU15
REAL(KIND=JPRB) :: RCAEOPD15
REAL(KIND=JPRB) :: RCAEOPF15
REAL(KIND=JPRB) :: RCTRBGA15
REAL(KIND=JPRB) :: RCVOBGA15
REAL(KIND=JPRB) :: RCSTBGA15
REAL(KIND=JPRB) :: RCTRPT15
REAL(KIND=JPRB) :: RCAEADM15
REAL(KIND=JPRB) :: RCAEROS15

REAL(KIND=JPRB) :: RAESC15(66)
REAL(KIND=JPRB) :: RAESS15(55)
REAL(KIND=JPRB) :: RAELC15(66)
REAL(KIND=JPRB) :: RAELS15(55)
REAL(KIND=JPRB) :: RAEUC15(66)
REAL(KIND=JPRB) :: RAEUS15(55)
REAL(KIND=JPRB) :: RAEDC15(66)
REAL(KIND=JPRB) :: RAEDS15(55)
REAL(KIND=JPRB) :: RCAEADK15(3)

!*     *YOMAERD15* SPECTRAL DISTRIBUTION OF AEROSOLS.
!                     (TRIANGULAR *T10* TRUNCATION FOR AEROSOLS).

!        96-11: Ph. Dandin. Meteo-France
!     J.-J. MORCRETTE    E.C.M.W.F.     92/09/24  Adaptation to IFS
!     R.G AND M.J        E.C.M.W.F.     29/11/82.
!     A. Alias           29-09-05 Sulfate aerosols (Hu Ron Ming)

!      NAME     TYPE      PURPOSE
!      ----     ----      -------

!     *CAES_*   REAL      *REFERS TO *SEA AEROSOLS.
!     *CAEL_*   REAL      *REFERS TO *LAND AEROSOLS.
!     *CAEU_*   REAL      *REFERS TO *URBAN AEROSOLS.
!     *CAED_*   REAL      *REFERS TO *DESERT AEROSOLS.
!     *CAEF_*   REAL      *REFERS TO *SULFATE AEROSOLS.
!     *C___C*   REAL      *REFERS TO *COS COMPONENT.
!     *C___S*   REAL      *REFERS TO *SIN COMPONENT.
!     *CAEOP_*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *C___S*   REAL      *REFERS TO *SEA AEROSOLS.
!     *C___L*   REAL      *REFERS TO *LAND AEROSOLS.
!     *C___U*   REAL      *REFERS TO *URBAN AEROSOLS.
!     *C___D*   REAL      *REFERS TO *DESERT AEROSOLS.
!     *C__BGA*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *CVDAE_*  REAL      *CONSTANTS USED FOR AEROSOL COMPUT. (NFLEVG+1)
!     *RCTRPT15*   REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEADK15*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEADM15*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEROS15*  REAL      *BACKGROUND VALUE IN ABSENCE OF AEROSOLS.
!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(raedc15,raeds15,raelc15,raels15,raesc15,raess15,raeuc15,raeus15,rcaeadk15,rcaeadm15)
!$OMP THREADPRIVATE(rcaeopd15,rcaeopf15,rcaeopl15,rcaeops15,rcaeopu15,rcaeros15,rcstbga15,rctrbga15,rctrpt15,rcvobga15)
!$OMP THREADPRIVATE(cvdaed15,cvdaef15,cvdael15,cvdaes15,cvdaeu15)
END MODULE YOMAERD15
