!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB19

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 16:  4650-5150 cm-1 (low - H2O,CO2; high - CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA19, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:,1) = (/ &
 & 3.25791_JPRB    , 3.29697_JPRB    , 3.16031_JPRB    , 2.96115_JPRB    , &
 & 2.69238_JPRB    , 2.33819_JPRB    , 1.92760_JPRB    , 1.44918_JPRB    , &
 & 0.979764_JPRB   , 0.107336_JPRB   , 8.94523E-02_JPRB, 6.98325E-02_JPRB, &
 & 5.12051E-02_JPRB, 3.23645E-02_JPRB, 1.23401E-02_JPRB, 1.71339E-03_JPRB /)  
SFLUXREF(:,2) = (/ &
 & 3.22769_JPRB    , 3.28817_JPRB    , 3.16687_JPRB    , 2.97662_JPRB    , &
 & 2.69495_JPRB    , 2.34392_JPRB    , 1.92900_JPRB    , 1.45391_JPRB    , &
 & 0.982522_JPRB   , 0.107638_JPRB   , 8.92458E-02_JPRB, 6.99885E-02_JPRB, &
 & 5.09679E-02_JPRB, 3.23789E-02_JPRB, 1.22673E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,3) = (/ &
 & 3.22294_JPRB    , 3.27780_JPRB    , 3.17424_JPRB    , 2.97143_JPRB    , &
 & 2.69785_JPRB    , 2.34993_JPRB    , 1.93155_JPRB    , 1.45196_JPRB    , &
 & 0.985329_JPRB   , 0.108027_JPRB   , 8.93552E-02_JPRB, 6.99937E-02_JPRB, &
 & 5.11678E-02_JPRB, 3.24846E-02_JPRB, 1.20636E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,4) = (/ &
 & 3.22445_JPRB    , 3.26113_JPRB    , 3.18438_JPRB    , 2.96921_JPRB    , &
 & 2.69579_JPRB    , 2.35586_JPRB    , 1.93454_JPRB    , 1.44949_JPRB    , &
 & 0.987347_JPRB   , 0.108611_JPRB   , 8.91643E-02_JPRB, 7.02236E-02_JPRB, &
 & 5.12980E-02_JPRB, 3.25282E-02_JPRB, 1.21189E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,5) = (/ &
 & 3.22497_JPRB    , 3.25109_JPRB    , 3.18741_JPRB    , 2.96970_JPRB    , &
 & 2.69460_JPRB    , 2.36020_JPRB    , 1.93301_JPRB    , 1.45224_JPRB    , &
 & 0.988564_JPRB   , 0.108255_JPRB   , 8.93830E-02_JPRB, 7.03655E-02_JPRB, &
 & 5.13017E-02_JPRB, 3.29414E-02_JPRB, 1.21189E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,6) = (/ &
 & 3.22632_JPRB    , 3.24174_JPRB    , 3.18524_JPRB    , 2.97402_JPRB    , &
 & 2.69807_JPRB    , 2.35742_JPRB    , 1.93377_JPRB    , 1.45621_JPRB    , &
 & 0.988132_JPRB   , 0.108344_JPRB   , 8.93188E-02_JPRB, 7.04907E-02_JPRB, &
 & 5.17938E-02_JPRB, 3.31465E-02_JPRB, 1.21155E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,7) = (/ &
 & 3.22793_JPRB    , 3.23589_JPRB    , 3.17720_JPRB    , 2.97869_JPRB    , &
 & 2.70293_JPRB    , 2.35436_JPRB    , 1.93557_JPRB    , 1.45868_JPRB    , &
 & 0.988654_JPRB   , 0.108198_JPRB   , 8.93375E-02_JPRB, 7.09790E-02_JPRB, &
 & 5.24733E-02_JPRB, 3.31298E-02_JPRB, 1.21126E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,8) = (/ &
 & 3.22966_JPRB    , 3.24087_JPRB    , 3.15676_JPRB    , 2.98171_JPRB    , &
 & 2.70894_JPRB    , 2.34975_JPRB    , 1.93855_JPRB    , 1.46354_JPRB    , &
 & 0.988544_JPRB   , 0.108574_JPRB   , 9.02522E-02_JPRB, 7.12908E-02_JPRB, &
 & 5.24844E-02_JPRB, 3.31084E-02_JPRB, 1.21060E-02_JPRB, 1.56040E-03_JPRB /)  
SFLUXREF(:,9) = (/ &
 & 3.27240_JPRB    , 3.24666_JPRB    , 3.13886_JPRB    , 2.95238_JPRB    , &
 & 2.70190_JPRB    , 2.34460_JPRB    , 1.93948_JPRB    , 1.47111_JPRB    , &
 & 0.990821_JPRB   , 0.108730_JPRB   , 9.01625E-02_JPRB, 7.13261E-02_JPRB, &
 & 5.24813E-02_JPRB, 3.31083E-02_JPRB, 1.21126E-02_JPRB, 1.56040E-03_JPRB /)  

!     Rayleigh extinction coefficient at v = 4900 cm-1.
RAYL = 2.29E-09_JPRB

STRRAT = 5.49281_JPRB

LAYREFFR = 3

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.14981E-05_JPRB,0.26659E-05_JPRB,0.31874E-05_JPRB,0.35509E-05_JPRB,0.37593E-05_JPRB, &
 & 0.38514E-05_JPRB,0.37369E-05_JPRB,0.35011E-05_JPRB,0.23894E-05_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.15103E-05_JPRB,0.27348E-05_JPRB,0.32692E-05_JPRB,0.36558E-05_JPRB,0.38926E-05_JPRB, &
 & 0.39737E-05_JPRB,0.38798E-05_JPRB,0.36565E-05_JPRB,0.24072E-05_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.15233E-05_JPRB,0.28090E-05_JPRB,0.33744E-05_JPRB,0.37729E-05_JPRB,0.40258E-05_JPRB, &
 & 0.41107E-05_JPRB,0.40389E-05_JPRB,0.38226E-05_JPRB,0.24704E-05_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.15219E-05_JPRB,0.28978E-05_JPRB,0.35015E-05_JPRB,0.38984E-05_JPRB,0.41569E-05_JPRB, &
 & 0.42771E-05_JPRB,0.42110E-05_JPRB,0.39963E-05_JPRB,0.25504E-05_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.15254E-05_JPRB,0.29633E-05_JPRB,0.36224E-05_JPRB,0.40435E-05_JPRB,0.42975E-05_JPRB, &
 & 0.44410E-05_JPRB,0.43849E-05_JPRB,0.41847E-05_JPRB,0.26420E-05_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.13024E-05_JPRB,0.23699E-05_JPRB,0.28370E-05_JPRB,0.31443E-05_JPRB,0.33326E-05_JPRB, &
 & 0.33798E-05_JPRB,0.32797E-05_JPRB,0.30078E-05_JPRB,0.18819E-05_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.13249E-05_JPRB,0.24299E-05_JPRB,0.29103E-05_JPRB,0.32336E-05_JPRB,0.34308E-05_JPRB, &
 & 0.35019E-05_JPRB,0.34046E-05_JPRB,0.31323E-05_JPRB,0.19511E-05_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.13241E-05_JPRB,0.25059E-05_JPRB,0.30019E-05_JPRB,0.33317E-05_JPRB,0.35516E-05_JPRB, &
 & 0.36333E-05_JPRB,0.35372E-05_JPRB,0.32615E-05_JPRB,0.20254E-05_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.13325E-05_JPRB,0.25840E-05_JPRB,0.31009E-05_JPRB,0.34399E-05_JPRB,0.36699E-05_JPRB, &
 & 0.37727E-05_JPRB,0.36811E-05_JPRB,0.34016E-05_JPRB,0.20611E-05_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.13321E-05_JPRB,0.26601E-05_JPRB,0.32189E-05_JPRB,0.35640E-05_JPRB,0.38012E-05_JPRB, &
 & 0.39113E-05_JPRB,0.38271E-05_JPRB,0.35499E-05_JPRB,0.21368E-05_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.11079E-05_JPRB,0.20757E-05_JPRB,0.24846E-05_JPRB,0.27511E-05_JPRB,0.28883E-05_JPRB, &
 & 0.29142E-05_JPRB,0.28203E-05_JPRB,0.25706E-05_JPRB,0.15124E-05_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.11298E-05_JPRB,0.21278E-05_JPRB,0.25551E-05_JPRB,0.28306E-05_JPRB,0.29814E-05_JPRB, &
 & 0.30126E-05_JPRB,0.29328E-05_JPRB,0.26721E-05_JPRB,0.15784E-05_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.11405E-05_JPRB,0.21812E-05_JPRB,0.26237E-05_JPRB,0.29130E-05_JPRB,0.30816E-05_JPRB, &
 & 0.31265E-05_JPRB,0.30480E-05_JPRB,0.27784E-05_JPRB,0.16468E-05_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.11347E-05_JPRB,0.22472E-05_JPRB,0.27094E-05_JPRB,0.30057E-05_JPRB,0.31821E-05_JPRB, &
 & 0.32536E-05_JPRB,0.31714E-05_JPRB,0.28837E-05_JPRB,0.17189E-05_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.11383E-05_JPRB,0.23152E-05_JPRB,0.28016E-05_JPRB,0.31126E-05_JPRB,0.33051E-05_JPRB, &
 & 0.33759E-05_JPRB,0.32961E-05_JPRB,0.29993E-05_JPRB,0.17919E-05_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.93104E-06_JPRB,0.18005E-05_JPRB,0.21693E-05_JPRB,0.23819E-05_JPRB,0.24829E-05_JPRB, &
 & 0.24860E-05_JPRB,0.23860E-05_JPRB,0.21586E-05_JPRB,0.12198E-05_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.94591E-06_JPRB,0.18309E-05_JPRB,0.22153E-05_JPRB,0.24487E-05_JPRB,0.25574E-05_JPRB, &
 & 0.25721E-05_JPRB,0.24802E-05_JPRB,0.22458E-05_JPRB,0.13105E-05_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.95638E-06_JPRB,0.18753E-05_JPRB,0.22788E-05_JPRB,0.25149E-05_JPRB,0.26499E-05_JPRB, &
 & 0.26671E-05_JPRB,0.25797E-05_JPRB,0.23335E-05_JPRB,0.14017E-05_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.95763E-06_JPRB,0.19379E-05_JPRB,0.23271E-05_JPRB,0.25858E-05_JPRB,0.27437E-05_JPRB, &
 & 0.27792E-05_JPRB,0.26790E-05_JPRB,0.24268E-05_JPRB,0.14872E-05_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.95668E-06_JPRB,0.19877E-05_JPRB,0.23997E-05_JPRB,0.26721E-05_JPRB,0.28382E-05_JPRB, &
 & 0.28806E-05_JPRB,0.27857E-05_JPRB,0.25225E-05_JPRB,0.15698E-05_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.77329E-06_JPRB,0.15354E-05_JPRB,0.18723E-05_JPRB,0.20411E-05_JPRB,0.21095E-05_JPRB, &
 & 0.21017E-05_JPRB,0.19998E-05_JPRB,0.18017E-05_JPRB,0.97629E-06_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.78241E-06_JPRB,0.15660E-05_JPRB,0.19091E-05_JPRB,0.20970E-05_JPRB,0.21786E-05_JPRB, &
 & 0.21730E-05_JPRB,0.20794E-05_JPRB,0.18731E-05_JPRB,0.10645E-05_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.79463E-06_JPRB,0.15948E-05_JPRB,0.19458E-05_JPRB,0.21529E-05_JPRB,0.22557E-05_JPRB, &
 & 0.22576E-05_JPRB,0.21631E-05_JPRB,0.19462E-05_JPRB,0.11507E-05_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.79779E-06_JPRB,0.16389E-05_JPRB,0.19877E-05_JPRB,0.22087E-05_JPRB,0.23274E-05_JPRB, &
 & 0.23462E-05_JPRB,0.22501E-05_JPRB,0.20204E-05_JPRB,0.12366E-05_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.79875E-06_JPRB,0.16865E-05_JPRB,0.20410E-05_JPRB,0.22789E-05_JPRB,0.24049E-05_JPRB, &
 & 0.24283E-05_JPRB,0.23388E-05_JPRB,0.21006E-05_JPRB,0.13155E-05_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.63799E-06_JPRB,0.13079E-05_JPRB,0.15873E-05_JPRB,0.17187E-05_JPRB,0.17689E-05_JPRB, &
 & 0.17509E-05_JPRB,0.16625E-05_JPRB,0.14950E-05_JPRB,0.77624E-06_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.64423E-06_JPRB,0.13180E-05_JPRB,0.16173E-05_JPRB,0.17648E-05_JPRB,0.18253E-05_JPRB, &
 & 0.18152E-05_JPRB,0.17299E-05_JPRB,0.15482E-05_JPRB,0.85457E-06_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.65214E-06_JPRB,0.13481E-05_JPRB,0.16476E-05_JPRB,0.18158E-05_JPRB,0.18867E-05_JPRB, &
 & 0.18859E-05_JPRB,0.17999E-05_JPRB,0.16080E-05_JPRB,0.93968E-06_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.65949E-06_JPRB,0.13728E-05_JPRB,0.16795E-05_JPRB,0.18618E-05_JPRB,0.19507E-05_JPRB, &
 & 0.19568E-05_JPRB,0.18693E-05_JPRB,0.16710E-05_JPRB,0.10256E-05_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.66012E-06_JPRB,0.14051E-05_JPRB,0.17174E-05_JPRB,0.19154E-05_JPRB,0.20111E-05_JPRB, &
 & 0.20230E-05_JPRB,0.19421E-05_JPRB,0.17361E-05_JPRB,0.11072E-05_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.52652E-06_JPRB,0.10995E-05_JPRB,0.13221E-05_JPRB,0.14282E-05_JPRB,0.14627E-05_JPRB, &
 & 0.14494E-05_JPRB,0.13754E-05_JPRB,0.12359E-05_JPRB,0.62399E-06_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.52631E-06_JPRB,0.11047E-05_JPRB,0.13498E-05_JPRB,0.14646E-05_JPRB,0.15094E-05_JPRB, &
 & 0.14961E-05_JPRB,0.14272E-05_JPRB,0.12791E-05_JPRB,0.69692E-06_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.53263E-06_JPRB,0.11231E-05_JPRB,0.13763E-05_JPRB,0.15059E-05_JPRB,0.15602E-05_JPRB, &
 & 0.15533E-05_JPRB,0.14827E-05_JPRB,0.13257E-05_JPRB,0.76959E-06_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.53788E-06_JPRB,0.11448E-05_JPRB,0.14026E-05_JPRB,0.15478E-05_JPRB,0.16122E-05_JPRB, &
 & 0.16137E-05_JPRB,0.15398E-05_JPRB,0.13748E-05_JPRB,0.84488E-06_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.54243E-06_JPRB,0.11660E-05_JPRB,0.14288E-05_JPRB,0.15891E-05_JPRB,0.16619E-05_JPRB, &
 & 0.16672E-05_JPRB,0.15978E-05_JPRB,0.14265E-05_JPRB,0.92439E-06_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.42860E-06_JPRB,0.91208E-06_JPRB,0.10887E-05_JPRB,0.11732E-05_JPRB,0.12000E-05_JPRB, &
 & 0.11901E-05_JPRB,0.11300E-05_JPRB,0.10181E-05_JPRB,0.51360E-06_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.42605E-06_JPRB,0.91355E-06_JPRB,0.11105E-05_JPRB,0.12004E-05_JPRB,0.12359E-05_JPRB, &
 & 0.12238E-05_JPRB,0.11674E-05_JPRB,0.10496E-05_JPRB,0.58593E-06_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.42910E-06_JPRB,0.92458E-06_JPRB,0.11341E-05_JPRB,0.12355E-05_JPRB,0.12754E-05_JPRB, &
 & 0.12667E-05_JPRB,0.12100E-05_JPRB,0.10877E-05_JPRB,0.65209E-06_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.43345E-06_JPRB,0.94024E-06_JPRB,0.11540E-05_JPRB,0.12669E-05_JPRB,0.13186E-05_JPRB, &
 & 0.13163E-05_JPRB,0.12567E-05_JPRB,0.11280E-05_JPRB,0.72051E-06_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.43744E-06_JPRB,0.95845E-06_JPRB,0.11764E-05_JPRB,0.13022E-05_JPRB,0.13595E-05_JPRB, &
 & 0.13618E-05_JPRB,0.13034E-05_JPRB,0.11671E-05_JPRB,0.79373E-06_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.34458E-06_JPRB,0.74844E-06_JPRB,0.89217E-06_JPRB,0.95875E-06_JPRB,0.98243E-06_JPRB, &
 & 0.97566E-06_JPRB,0.92936E-06_JPRB,0.83611E-06_JPRB,0.44181E-06_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.34797E-06_JPRB,0.75304E-06_JPRB,0.90816E-06_JPRB,0.98264E-06_JPRB,0.10080E-05_JPRB, &
 & 0.99889E-06_JPRB,0.95318E-06_JPRB,0.86041E-06_JPRB,0.51013E-06_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.34593E-06_JPRB,0.76020E-06_JPRB,0.92707E-06_JPRB,0.10062E-05_JPRB,0.10391E-05_JPRB, &
 & 0.10296E-05_JPRB,0.98530E-06_JPRB,0.89011E-06_JPRB,0.58070E-06_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.34971E-06_JPRB,0.77088E-06_JPRB,0.94623E-06_JPRB,0.10342E-05_JPRB,0.10726E-05_JPRB, &
 & 0.10689E-05_JPRB,0.10210E-05_JPRB,0.92020E-06_JPRB,0.65697E-06_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.35282E-06_JPRB,0.78517E-06_JPRB,0.96245E-06_JPRB,0.10609E-05_JPRB,0.11071E-05_JPRB, &
 & 0.11073E-05_JPRB,0.10583E-05_JPRB,0.95054E-06_JPRB,0.72956E-06_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.27840E-06_JPRB,0.61035E-06_JPRB,0.72930E-06_JPRB,0.78415E-06_JPRB,0.80451E-06_JPRB, &
 & 0.79924E-06_JPRB,0.76231E-06_JPRB,0.68727E-06_JPRB,0.40208E-06_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.28171E-06_JPRB,0.61798E-06_JPRB,0.74197E-06_JPRB,0.80115E-06_JPRB,0.82183E-06_JPRB, &
 & 0.81621E-06_JPRB,0.78030E-06_JPRB,0.70425E-06_JPRB,0.46700E-06_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.28023E-06_JPRB,0.62269E-06_JPRB,0.75685E-06_JPRB,0.82101E-06_JPRB,0.84538E-06_JPRB, &
 & 0.83821E-06_JPRB,0.80301E-06_JPRB,0.72663E-06_JPRB,0.53781E-06_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.28163E-06_JPRB,0.63156E-06_JPRB,0.77214E-06_JPRB,0.84244E-06_JPRB,0.87184E-06_JPRB, &
 & 0.86752E-06_JPRB,0.83024E-06_JPRB,0.75000E-06_JPRB,0.60478E-06_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.28518E-06_JPRB,0.64070E-06_JPRB,0.78628E-06_JPRB,0.86439E-06_JPRB,0.89969E-06_JPRB, &
 & 0.89910E-06_JPRB,0.85933E-06_JPRB,0.77376E-06_JPRB,0.67016E-06_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.22555E-06_JPRB,0.50042E-06_JPRB,0.59960E-06_JPRB,0.64537E-06_JPRB,0.66324E-06_JPRB, &
 & 0.65924E-06_JPRB,0.63003E-06_JPRB,0.56890E-06_JPRB,0.34466E-06_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.22858E-06_JPRB,0.50705E-06_JPRB,0.60997E-06_JPRB,0.65948E-06_JPRB,0.67688E-06_JPRB, &
 & 0.67311E-06_JPRB,0.64462E-06_JPRB,0.58333E-06_JPRB,0.40300E-06_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.22677E-06_JPRB,0.51178E-06_JPRB,0.62299E-06_JPRB,0.67572E-06_JPRB,0.69624E-06_JPRB, &
 & 0.69126E-06_JPRB,0.66285E-06_JPRB,0.60090E-06_JPRB,0.46066E-06_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.22825E-06_JPRB,0.51907E-06_JPRB,0.63500E-06_JPRB,0.69311E-06_JPRB,0.71796E-06_JPRB, &
 & 0.71484E-06_JPRB,0.68416E-06_JPRB,0.61859E-06_JPRB,0.51966E-06_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.23122E-06_JPRB,0.52598E-06_JPRB,0.64574E-06_JPRB,0.71116E-06_JPRB,0.74046E-06_JPRB, &
 & 0.73979E-06_JPRB,0.70672E-06_JPRB,0.63708E-06_JPRB,0.58196E-06_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.18149E-06_JPRB,0.40829E-06_JPRB,0.49022E-06_JPRB,0.52910E-06_JPRB,0.54408E-06_JPRB, &
 & 0.54163E-06_JPRB,0.51867E-06_JPRB,0.46933E-06_JPRB,0.28496E-06_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.18433E-06_JPRB,0.41378E-06_JPRB,0.49908E-06_JPRB,0.54027E-06_JPRB,0.55522E-06_JPRB, &
 & 0.55286E-06_JPRB,0.53038E-06_JPRB,0.48103E-06_JPRB,0.33336E-06_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.18246E-06_JPRB,0.41799E-06_JPRB,0.50965E-06_JPRB,0.55347E-06_JPRB,0.57134E-06_JPRB, &
 & 0.56787E-06_JPRB,0.54477E-06_JPRB,0.49462E-06_JPRB,0.38023E-06_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.18409E-06_JPRB,0.42347E-06_JPRB,0.51936E-06_JPRB,0.56749E-06_JPRB,0.58877E-06_JPRB, &
 & 0.58648E-06_JPRB,0.56149E-06_JPRB,0.50825E-06_JPRB,0.43081E-06_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.18582E-06_JPRB,0.42888E-06_JPRB,0.52830E-06_JPRB,0.58240E-06_JPRB,0.60647E-06_JPRB, &
 & 0.60598E-06_JPRB,0.57933E-06_JPRB,0.52277E-06_JPRB,0.48565E-06_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.14345E-06_JPRB,0.32927E-06_JPRB,0.39750E-06_JPRB,0.43000E-06_JPRB,0.44318E-06_JPRB, &
 & 0.44201E-06_JPRB,0.42469E-06_JPRB,0.38538E-06_JPRB,0.23377E-06_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.14571E-06_JPRB,0.33355E-06_JPRB,0.40430E-06_JPRB,0.43954E-06_JPRB,0.45256E-06_JPRB, &
 & 0.45159E-06_JPRB,0.43399E-06_JPRB,0.39467E-06_JPRB,0.27338E-06_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.14442E-06_JPRB,0.33719E-06_JPRB,0.41316E-06_JPRB,0.44996E-06_JPRB,0.46575E-06_JPRB, &
 & 0.46364E-06_JPRB,0.44528E-06_JPRB,0.40510E-06_JPRB,0.31154E-06_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.14600E-06_JPRB,0.34141E-06_JPRB,0.42136E-06_JPRB,0.46096E-06_JPRB,0.47937E-06_JPRB, &
 & 0.47817E-06_JPRB,0.45850E-06_JPRB,0.41598E-06_JPRB,0.35289E-06_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.14667E-06_JPRB,0.34608E-06_JPRB,0.42853E-06_JPRB,0.47296E-06_JPRB,0.49300E-06_JPRB, &
 & 0.49352E-06_JPRB,0.47280E-06_JPRB,0.42757E-06_JPRB,0.39752E-06_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.16288E-04_JPRB,0.25817E-04_JPRB,0.29597E-04_JPRB,0.31319E-04_JPRB,0.31220E-04_JPRB, &
 & 0.29539E-04_JPRB,0.25627E-04_JPRB,0.19758E-04_JPRB,0.72944E-05_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.18123E-04_JPRB,0.28565E-04_JPRB,0.32633E-04_JPRB,0.34427E-04_JPRB,0.34219E-04_JPRB, &
 & 0.32223E-04_JPRB,0.27987E-04_JPRB,0.21485E-04_JPRB,0.79554E-05_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.19957E-04_JPRB,0.31607E-04_JPRB,0.36033E-04_JPRB,0.37887E-04_JPRB,0.37694E-04_JPRB, &
 & 0.35399E-04_JPRB,0.30718E-04_JPRB,0.23412E-04_JPRB,0.85293E-05_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.22005E-04_JPRB,0.35064E-04_JPRB,0.39763E-04_JPRB,0.41694E-04_JPRB,0.41490E-04_JPRB, &
 & 0.38891E-04_JPRB,0.33715E-04_JPRB,0.25512E-04_JPRB,0.91232E-05_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.24240E-04_JPRB,0.38906E-04_JPRB,0.43899E-04_JPRB,0.45870E-04_JPRB,0.45580E-04_JPRB, &
 & 0.42616E-04_JPRB,0.36912E-04_JPRB,0.27728E-04_JPRB,0.97792E-05_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.14944E-04_JPRB,0.23223E-04_JPRB,0.25792E-04_JPRB,0.27019E-04_JPRB,0.26963E-04_JPRB, &
 & 0.25431E-04_JPRB,0.22069E-04_JPRB,0.16933E-04_JPRB,0.59071E-05_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.16615E-04_JPRB,0.25452E-04_JPRB,0.28322E-04_JPRB,0.29800E-04_JPRB,0.29593E-04_JPRB, &
 & 0.27776E-04_JPRB,0.24123E-04_JPRB,0.18444E-04_JPRB,0.63142E-05_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.18355E-04_JPRB,0.27996E-04_JPRB,0.31338E-04_JPRB,0.32892E-04_JPRB,0.32575E-04_JPRB, &
 & 0.30478E-04_JPRB,0.26504E-04_JPRB,0.20132E-04_JPRB,0.67898E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART2',0,ZHOOK_HANDLE)


KA(:, 4, 2, 2) = (/ &
 & 0.20092E-04_JPRB,0.30938E-04_JPRB,0.34680E-04_JPRB,0.36255E-04_JPRB,0.35836E-04_JPRB, &
 & 0.33500E-04_JPRB,0.29106E-04_JPRB,0.21950E-04_JPRB,0.73343E-05_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.21897E-04_JPRB,0.34150E-04_JPRB,0.38274E-04_JPRB,0.39931E-04_JPRB,0.39337E-04_JPRB, &
 & 0.36752E-04_JPRB,0.31831E-04_JPRB,0.23882E-04_JPRB,0.78705E-05_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.13130E-04_JPRB,0.20363E-04_JPRB,0.22377E-04_JPRB,0.23003E-04_JPRB,0.22683E-04_JPRB, &
 & 0.21429E-04_JPRB,0.18621E-04_JPRB,0.14177E-04_JPRB,0.47892E-05_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.14610E-04_JPRB,0.22299E-04_JPRB,0.24486E-04_JPRB,0.25140E-04_JPRB,0.24842E-04_JPRB, &
 & 0.23413E-04_JPRB,0.20361E-04_JPRB,0.15469E-04_JPRB,0.52250E-05_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.16133E-04_JPRB,0.24482E-04_JPRB,0.26876E-04_JPRB,0.27653E-04_JPRB,0.27357E-04_JPRB, &
 & 0.25669E-04_JPRB,0.22341E-04_JPRB,0.16897E-04_JPRB,0.56647E-05_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.17708E-04_JPRB,0.26887E-04_JPRB,0.29522E-04_JPRB,0.30577E-04_JPRB,0.30151E-04_JPRB, &
 & 0.28221E-04_JPRB,0.24545E-04_JPRB,0.18455E-04_JPRB,0.60735E-05_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.19305E-04_JPRB,0.29364E-04_JPRB,0.32520E-04_JPRB,0.33741E-04_JPRB,0.33162E-04_JPRB, &
 & 0.30976E-04_JPRB,0.26800E-04_JPRB,0.20103E-04_JPRB,0.64864E-05_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.11163E-04_JPRB,0.17498E-04_JPRB,0.19069E-04_JPRB,0.19561E-04_JPRB,0.19154E-04_JPRB, &
 & 0.17906E-04_JPRB,0.15522E-04_JPRB,0.11778E-04_JPRB,0.40461E-05_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.12505E-04_JPRB,0.19238E-04_JPRB,0.20917E-04_JPRB,0.21365E-04_JPRB,0.20913E-04_JPRB, &
 & 0.19471E-04_JPRB,0.16986E-04_JPRB,0.12856E-04_JPRB,0.43935E-05_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.13848E-04_JPRB,0.21132E-04_JPRB,0.22975E-04_JPRB,0.23433E-04_JPRB,0.22893E-04_JPRB, &
 & 0.21327E-04_JPRB,0.18662E-04_JPRB,0.14056E-04_JPRB,0.47015E-05_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.15219E-04_JPRB,0.23159E-04_JPRB,0.25250E-04_JPRB,0.25753E-04_JPRB,0.25088E-04_JPRB, &
 & 0.23437E-04_JPRB,0.20455E-04_JPRB,0.15366E-04_JPRB,0.50239E-05_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.16631E-04_JPRB,0.25311E-04_JPRB,0.27651E-04_JPRB,0.28243E-04_JPRB,0.27566E-04_JPRB, &
 & 0.25775E-04_JPRB,0.22344E-04_JPRB,0.16758E-04_JPRB,0.53594E-05_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.92688E-05_JPRB,0.14829E-04_JPRB,0.16036E-04_JPRB,0.16388E-04_JPRB,0.16087E-04_JPRB, &
 & 0.15049E-04_JPRB,0.12939E-04_JPRB,0.97243E-05_JPRB,0.35064E-05_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.10428E-04_JPRB,0.16289E-04_JPRB,0.17596E-04_JPRB,0.17928E-04_JPRB,0.17547E-04_JPRB, &
 & 0.16347E-04_JPRB,0.14108E-04_JPRB,0.10621E-04_JPRB,0.37893E-05_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.11600E-04_JPRB,0.17922E-04_JPRB,0.19403E-04_JPRB,0.19701E-04_JPRB,0.19227E-04_JPRB, &
 & 0.17835E-04_JPRB,0.15439E-04_JPRB,0.11627E-04_JPRB,0.40426E-05_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.12795E-04_JPRB,0.19672E-04_JPRB,0.21360E-04_JPRB,0.21677E-04_JPRB,0.21078E-04_JPRB, &
 & 0.19535E-04_JPRB,0.16919E-04_JPRB,0.12746E-04_JPRB,0.43015E-05_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.14029E-04_JPRB,0.21551E-04_JPRB,0.23410E-04_JPRB,0.23746E-04_JPRB,0.23106E-04_JPRB, &
 & 0.21397E-04_JPRB,0.18500E-04_JPRB,0.13918E-04_JPRB,0.45663E-05_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.75358E-05_JPRB,0.12284E-04_JPRB,0.13321E-04_JPRB,0.13580E-04_JPRB,0.13322E-04_JPRB, &
 & 0.12459E-04_JPRB,0.10757E-04_JPRB,0.80012E-05_JPRB,0.28595E-05_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.84801E-05_JPRB,0.13541E-04_JPRB,0.14600E-04_JPRB,0.14857E-04_JPRB,0.14519E-04_JPRB, &
 & 0.13528E-04_JPRB,0.11747E-04_JPRB,0.87199E-05_JPRB,0.31250E-05_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.94797E-05_JPRB,0.14898E-04_JPRB,0.16088E-04_JPRB,0.16329E-04_JPRB,0.15922E-04_JPRB, &
 & 0.14786E-04_JPRB,0.12839E-04_JPRB,0.95406E-05_JPRB,0.33925E-05_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.10510E-04_JPRB,0.16387E-04_JPRB,0.17709E-04_JPRB,0.17968E-04_JPRB,0.17465E-04_JPRB, &
 & 0.16205E-04_JPRB,0.13999E-04_JPRB,0.10465E-04_JPRB,0.36786E-05_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.11554E-04_JPRB,0.17973E-04_JPRB,0.19442E-04_JPRB,0.19736E-04_JPRB,0.19170E-04_JPRB, &
 & 0.17751E-04_JPRB,0.15288E-04_JPRB,0.11441E-04_JPRB,0.39618E-05_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.59994E-05_JPRB,0.10068E-04_JPRB,0.10903E-04_JPRB,0.11100E-04_JPRB,0.10910E-04_JPRB, &
 & 0.10207E-04_JPRB,0.88301E-05_JPRB,0.65755E-05_JPRB,0.23537E-05_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.67911E-05_JPRB,0.11098E-04_JPRB,0.11964E-04_JPRB,0.12161E-04_JPRB,0.11910E-04_JPRB, &
 & 0.11113E-04_JPRB,0.96475E-05_JPRB,0.71733E-05_JPRB,0.26021E-05_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.76012E-05_JPRB,0.12205E-04_JPRB,0.13167E-04_JPRB,0.13368E-04_JPRB,0.13058E-04_JPRB, &
 & 0.12136E-04_JPRB,0.10571E-04_JPRB,0.78452E-05_JPRB,0.28416E-05_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.84582E-05_JPRB,0.13412E-04_JPRB,0.14518E-04_JPRB,0.14721E-04_JPRB,0.14328E-04_JPRB, &
 & 0.13323E-04_JPRB,0.11527E-04_JPRB,0.85995E-05_JPRB,0.30925E-05_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.93346E-05_JPRB,0.14749E-04_JPRB,0.15973E-04_JPRB,0.16180E-04_JPRB,0.15730E-04_JPRB, &
 & 0.14597E-04_JPRB,0.12601E-04_JPRB,0.93973E-05_JPRB,0.33285E-05_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.47174E-05_JPRB,0.81367E-05_JPRB,0.88184E-05_JPRB,0.90007E-05_JPRB,0.88363E-05_JPRB, &
 & 0.83059E-05_JPRB,0.72101E-05_JPRB,0.53496E-05_JPRB,0.18862E-05_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.53543E-05_JPRB,0.89852E-05_JPRB,0.96904E-05_JPRB,0.98666E-05_JPRB,0.96509E-05_JPRB, &
 & 0.90368E-05_JPRB,0.78700E-05_JPRB,0.58341E-05_JPRB,0.21147E-05_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.60088E-05_JPRB,0.98855E-05_JPRB,0.10666E-04_JPRB,0.10849E-04_JPRB,0.10597E-04_JPRB, &
 & 0.98826E-05_JPRB,0.86243E-05_JPRB,0.63949E-05_JPRB,0.23672E-05_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.66958E-05_JPRB,0.10873E-04_JPRB,0.11751E-04_JPRB,0.11945E-04_JPRB,0.11636E-04_JPRB, &
 & 0.10852E-04_JPRB,0.94101E-05_JPRB,0.70262E-05_JPRB,0.26329E-05_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.74191E-05_JPRB,0.11960E-04_JPRB,0.12943E-04_JPRB,0.13152E-04_JPRB,0.12788E-04_JPRB, &
 & 0.11889E-04_JPRB,0.10297E-04_JPRB,0.76977E-05_JPRB,0.29019E-05_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.36886E-05_JPRB,0.65140E-05_JPRB,0.70684E-05_JPRB,0.72377E-05_JPRB,0.71080E-05_JPRB, &
 & 0.67076E-05_JPRB,0.58353E-05_JPRB,0.43297E-05_JPRB,0.16419E-05_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.41772E-05_JPRB,0.72104E-05_JPRB,0.77793E-05_JPRB,0.79335E-05_JPRB,0.77682E-05_JPRB, &
 & 0.72903E-05_JPRB,0.63640E-05_JPRB,0.47210E-05_JPRB,0.18721E-05_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.47123E-05_JPRB,0.79471E-05_JPRB,0.85662E-05_JPRB,0.87396E-05_JPRB,0.85319E-05_JPRB, &
 & 0.79769E-05_JPRB,0.69694E-05_JPRB,0.51793E-05_JPRB,0.21015E-05_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.52612E-05_JPRB,0.87319E-05_JPRB,0.94365E-05_JPRB,0.96191E-05_JPRB,0.93783E-05_JPRB, &
 & 0.87581E-05_JPRB,0.76277E-05_JPRB,0.56974E-05_JPRB,0.23505E-05_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.58401E-05_JPRB,0.96106E-05_JPRB,0.10404E-04_JPRB,0.10594E-04_JPRB,0.10308E-04_JPRB, &
 & 0.96030E-05_JPRB,0.83402E-05_JPRB,0.62627E-05_JPRB,0.26170E-05_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.29023E-05_JPRB,0.52230E-05_JPRB,0.56669E-05_JPRB,0.58158E-05_JPRB,0.57137E-05_JPRB, &
 & 0.54241E-05_JPRB,0.47416E-05_JPRB,0.35098E-05_JPRB,0.14223E-05_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.32752E-05_JPRB,0.57903E-05_JPRB,0.62548E-05_JPRB,0.63859E-05_JPRB,0.62528E-05_JPRB, &
 & 0.58881E-05_JPRB,0.51542E-05_JPRB,0.38257E-05_JPRB,0.16559E-05_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.37047E-05_JPRB,0.63892E-05_JPRB,0.68928E-05_JPRB,0.70312E-05_JPRB,0.68734E-05_JPRB, &
 & 0.64357E-05_JPRB,0.56361E-05_JPRB,0.42003E-05_JPRB,0.19248E-05_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.41471E-05_JPRB,0.70179E-05_JPRB,0.75920E-05_JPRB,0.77496E-05_JPRB,0.75508E-05_JPRB, &
 & 0.70624E-05_JPRB,0.61778E-05_JPRB,0.46271E-05_JPRB,0.22074E-05_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.46061E-05_JPRB,0.77215E-05_JPRB,0.83699E-05_JPRB,0.85300E-05_JPRB,0.83121E-05_JPRB, &
 & 0.77493E-05_JPRB,0.67551E-05_JPRB,0.50931E-05_JPRB,0.25043E-05_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.24060E-05_JPRB,0.43752E-05_JPRB,0.47372E-05_JPRB,0.48598E-05_JPRB,0.47689E-05_JPRB, &
 & 0.45290E-05_JPRB,0.39653E-05_JPRB,0.29444E-05_JPRB,0.12255E-05_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.27123E-05_JPRB,0.48479E-05_JPRB,0.52339E-05_JPRB,0.53482E-05_JPRB,0.52342E-05_JPRB, &
 & 0.49275E-05_JPRB,0.43239E-05_JPRB,0.32196E-05_JPRB,0.14282E-05_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.30632E-05_JPRB,0.53402E-05_JPRB,0.57660E-05_JPRB,0.58936E-05_JPRB,0.57515E-05_JPRB, &
 & 0.53873E-05_JPRB,0.47344E-05_JPRB,0.35410E-05_JPRB,0.16636E-05_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.34245E-05_JPRB,0.58653E-05_JPRB,0.63554E-05_JPRB,0.64878E-05_JPRB,0.63244E-05_JPRB, &
 & 0.59147E-05_JPRB,0.51855E-05_JPRB,0.39068E-05_JPRB,0.18858E-05_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.37984E-05_JPRB,0.64557E-05_JPRB,0.70032E-05_JPRB,0.71432E-05_JPRB,0.69591E-05_JPRB, &
 & 0.64936E-05_JPRB,0.56748E-05_JPRB,0.42889E-05_JPRB,0.21529E-05_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.19822E-05_JPRB,0.36438E-05_JPRB,0.39439E-05_JPRB,0.40428E-05_JPRB,0.39656E-05_JPRB, &
 & 0.37627E-05_JPRB,0.33048E-05_JPRB,0.24620E-05_JPRB,0.10349E-05_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.22347E-05_JPRB,0.40329E-05_JPRB,0.43559E-05_JPRB,0.44535E-05_JPRB,0.43556E-05_JPRB, &
 & 0.41018E-05_JPRB,0.36156E-05_JPRB,0.26976E-05_JPRB,0.12078E-05_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.25196E-05_JPRB,0.44405E-05_JPRB,0.47965E-05_JPRB,0.49025E-05_JPRB,0.47850E-05_JPRB, &
 & 0.44854E-05_JPRB,0.39542E-05_JPRB,0.29734E-05_JPRB,0.13908E-05_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.28142E-05_JPRB,0.48792E-05_JPRB,0.52882E-05_JPRB,0.53962E-05_JPRB,0.52646E-05_JPRB, &
 & 0.49202E-05_JPRB,0.43229E-05_JPRB,0.32817E-05_JPRB,0.15895E-05_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.31182E-05_JPRB,0.53684E-05_JPRB,0.58256E-05_JPRB,0.59413E-05_JPRB,0.57855E-05_JPRB, &
 & 0.54043E-05_JPRB,0.47298E-05_JPRB,0.35925E-05_JPRB,0.18050E-05_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.16206E-05_JPRB,0.30122E-05_JPRB,0.32612E-05_JPRB,0.33451E-05_JPRB,0.32794E-05_JPRB, &
 & 0.31144E-05_JPRB,0.27430E-05_JPRB,0.20488E-05_JPRB,0.85267E-06_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.18267E-05_JPRB,0.33331E-05_JPRB,0.36002E-05_JPRB,0.36816E-05_JPRB,0.36054E-05_JPRB, &
 & 0.33950E-05_JPRB,0.30021E-05_JPRB,0.22487E-05_JPRB,0.99490E-06_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.20587E-05_JPRB,0.36681E-05_JPRB,0.39651E-05_JPRB,0.40531E-05_JPRB,0.39564E-05_JPRB, &
 & 0.37127E-05_JPRB,0.32815E-05_JPRB,0.24795E-05_JPRB,0.11422E-05_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.22973E-05_JPRB,0.40325E-05_JPRB,0.43728E-05_JPRB,0.44600E-05_JPRB,0.43540E-05_JPRB, &
 & 0.40718E-05_JPRB,0.35848E-05_JPRB,0.27366E-05_JPRB,0.13051E-05_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.25452E-05_JPRB,0.44379E-05_JPRB,0.48164E-05_JPRB,0.49100E-05_JPRB,0.47833E-05_JPRB, &
 & 0.44674E-05_JPRB,0.39194E-05_JPRB,0.29904E-05_JPRB,0.14817E-05_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.66641E-04_JPRB,0.92990E-04_JPRB,0.96277E-04_JPRB,0.95182E-04_JPRB,0.91424E-04_JPRB, &
 & 0.85445E-04_JPRB,0.77014E-04_JPRB,0.62091E-04_JPRB,0.18284E-04_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.75350E-04_JPRB,0.10391E-03_JPRB,0.10751E-03_JPRB,0.10606E-03_JPRB,0.10174E-03_JPRB, &
 & 0.94756E-04_JPRB,0.84487E-04_JPRB,0.67267E-04_JPRB,0.20037E-04_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.85286E-04_JPRB,0.11563E-03_JPRB,0.11966E-03_JPRB,0.11777E-03_JPRB,0.11259E-03_JPRB, &
 & 0.10435E-03_JPRB,0.92076E-04_JPRB,0.72492E-04_JPRB,0.22229E-04_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.96137E-04_JPRB,0.12836E-03_JPRB,0.13265E-03_JPRB,0.13031E-03_JPRB,0.12404E-03_JPRB, &
 & 0.11409E-03_JPRB,0.99756E-04_JPRB,0.77897E-04_JPRB,0.24656E-04_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.10739E-03_JPRB,0.14209E-03_JPRB,0.14652E-03_JPRB,0.14363E-03_JPRB,0.13579E-03_JPRB, &
 & 0.12408E-03_JPRB,0.10749E-03_JPRB,0.83273E-04_JPRB,0.26998E-04_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.57005E-04_JPRB,0.80688E-04_JPRB,0.84199E-04_JPRB,0.83067E-04_JPRB,0.79480E-04_JPRB, &
 & 0.74096E-04_JPRB,0.66328E-04_JPRB,0.53532E-04_JPRB,0.14534E-04_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.64518E-04_JPRB,0.90274E-04_JPRB,0.94149E-04_JPRB,0.92496E-04_JPRB,0.88374E-04_JPRB, &
 & 0.82048E-04_JPRB,0.72698E-04_JPRB,0.57871E-04_JPRB,0.16202E-04_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.73014E-04_JPRB,0.10065E-03_JPRB,0.10466E-03_JPRB,0.10271E-03_JPRB,0.97880E-04_JPRB, &
 & 0.90372E-04_JPRB,0.79361E-04_JPRB,0.62357E-04_JPRB,0.18056E-04_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.82297E-04_JPRB,0.11195E-03_JPRB,0.11586E-03_JPRB,0.11365E-03_JPRB,0.10799E-03_JPRB, &
 & 0.98829E-04_JPRB,0.85923E-04_JPRB,0.66891E-04_JPRB,0.19890E-04_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.92175E-04_JPRB,0.12399E-03_JPRB,0.12794E-03_JPRB,0.12531E-03_JPRB,0.11825E-03_JPRB, &
 & 0.10764E-03_JPRB,0.92744E-04_JPRB,0.71608E-04_JPRB,0.21968E-04_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.47324E-04_JPRB,0.68167E-04_JPRB,0.71069E-04_JPRB,0.70293E-04_JPRB,0.67313E-04_JPRB, &
 & 0.62456E-04_JPRB,0.55646E-04_JPRB,0.44933E-04_JPRB,0.11374E-04_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.53658E-04_JPRB,0.76342E-04_JPRB,0.79560E-04_JPRB,0.78547E-04_JPRB,0.74997E-04_JPRB, &
 & 0.69264E-04_JPRB,0.61119E-04_JPRB,0.48587E-04_JPRB,0.12639E-04_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.60905E-04_JPRB,0.85247E-04_JPRB,0.88738E-04_JPRB,0.87387E-04_JPRB,0.83098E-04_JPRB, &
 & 0.76432E-04_JPRB,0.66733E-04_JPRB,0.52275E-04_JPRB,0.13871E-04_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.68831E-04_JPRB,0.94960E-04_JPRB,0.98638E-04_JPRB,0.96778E-04_JPRB,0.91816E-04_JPRB, &
 & 0.83747E-04_JPRB,0.72403E-04_JPRB,0.56165E-04_JPRB,0.15423E-04_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.77259E-04_JPRB,0.10549E-03_JPRB,0.10909E-03_JPRB,0.10672E-03_JPRB,0.10065E-03_JPRB, &
 & 0.91320E-04_JPRB,0.78406E-04_JPRB,0.60157E-04_JPRB,0.17141E-04_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.40102E-04_JPRB,0.56990E-04_JPRB,0.59444E-04_JPRB,0.58732E-04_JPRB,0.56091E-04_JPRB, &
 & 0.51902E-04_JPRB,0.46247E-04_JPRB,0.37442E-04_JPRB,0.94022E-05_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.44930E-04_JPRB,0.63893E-04_JPRB,0.66629E-04_JPRB,0.65694E-04_JPRB,0.62627E-04_JPRB, &
 & 0.57822E-04_JPRB,0.50819E-04_JPRB,0.40421E-04_JPRB,0.10475E-04_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.50532E-04_JPRB,0.71424E-04_JPRB,0.74352E-04_JPRB,0.73221E-04_JPRB,0.69651E-04_JPRB, &
 & 0.64034E-04_JPRB,0.55430E-04_JPRB,0.43529E-04_JPRB,0.11728E-04_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.56953E-04_JPRB,0.79740E-04_JPRB,0.82769E-04_JPRB,0.81314E-04_JPRB,0.77278E-04_JPRB, &
 & 0.70324E-04_JPRB,0.60396E-04_JPRB,0.46747E-04_JPRB,0.13063E-04_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.64019E-04_JPRB,0.88647E-04_JPRB,0.91768E-04_JPRB,0.89926E-04_JPRB,0.84958E-04_JPRB, &
 & 0.76740E-04_JPRB,0.65561E-04_JPRB,0.50066E-04_JPRB,0.14435E-04_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.33806E-04_JPRB,0.47826E-04_JPRB,0.49443E-04_JPRB,0.48775E-04_JPRB,0.46477E-04_JPRB, &
 & 0.42791E-04_JPRB,0.38155E-04_JPRB,0.31175E-04_JPRB,0.77886E-05_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.37973E-04_JPRB,0.53392E-04_JPRB,0.55526E-04_JPRB,0.54719E-04_JPRB,0.52062E-04_JPRB, &
 & 0.47763E-04_JPRB,0.42021E-04_JPRB,0.33510E-04_JPRB,0.87404E-05_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.42758E-04_JPRB,0.59666E-04_JPRB,0.62058E-04_JPRB,0.61127E-04_JPRB,0.58012E-04_JPRB, &
 & 0.53071E-04_JPRB,0.45971E-04_JPRB,0.36114E-04_JPRB,0.98499E-05_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.48006E-04_JPRB,0.66679E-04_JPRB,0.69230E-04_JPRB,0.67989E-04_JPRB,0.64400E-04_JPRB, &
 & 0.58521E-04_JPRB,0.50196E-04_JPRB,0.38710E-04_JPRB,0.11022E-04_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.53657E-04_JPRB,0.74244E-04_JPRB,0.76813E-04_JPRB,0.75303E-04_JPRB,0.71011E-04_JPRB, &
 & 0.64092E-04_JPRB,0.54599E-04_JPRB,0.41481E-04_JPRB,0.12225E-04_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.27953E-04_JPRB,0.40223E-04_JPRB,0.41331E-04_JPRB,0.40332E-04_JPRB,0.38114E-04_JPRB, &
 & 0.34967E-04_JPRB,0.31158E-04_JPRB,0.25701E-04_JPRB,0.67604E-05_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.31595E-04_JPRB,0.44975E-04_JPRB,0.46374E-04_JPRB,0.45229E-04_JPRB,0.42775E-04_JPRB, &
 & 0.39162E-04_JPRB,0.34373E-04_JPRB,0.27616E-04_JPRB,0.75558E-05_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.35649E-04_JPRB,0.50263E-04_JPRB,0.51713E-04_JPRB,0.50516E-04_JPRB,0.47855E-04_JPRB, &
 & 0.43605E-04_JPRB,0.37705E-04_JPRB,0.29800E-04_JPRB,0.84063E-05_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.40086E-04_JPRB,0.55905E-04_JPRB,0.57584E-04_JPRB,0.56348E-04_JPRB,0.53200E-04_JPRB, &
 & 0.48283E-04_JPRB,0.41331E-04_JPRB,0.31936E-04_JPRB,0.92686E-05_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.44931E-04_JPRB,0.62025E-04_JPRB,0.63942E-04_JPRB,0.62498E-04_JPRB,0.58788E-04_JPRB, &
 & 0.53032E-04_JPRB,0.45085E-04_JPRB,0.34229E-04_JPRB,0.10175E-04_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.22829E-04_JPRB,0.33278E-04_JPRB,0.34196E-04_JPRB,0.33381E-04_JPRB,0.31444E-04_JPRB, &
 & 0.28615E-04_JPRB,0.25331E-04_JPRB,0.21096E-04_JPRB,0.60732E-05_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.25917E-04_JPRB,0.37424E-04_JPRB,0.38527E-04_JPRB,0.37580E-04_JPRB,0.35302E-04_JPRB, &
 & 0.32020E-04_JPRB,0.27957E-04_JPRB,0.22660E-04_JPRB,0.68180E-05_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.29386E-04_JPRB,0.41933E-04_JPRB,0.43213E-04_JPRB,0.42039E-04_JPRB,0.39445E-04_JPRB, &
 & 0.35659E-04_JPRB,0.30780E-04_JPRB,0.24432E-04_JPRB,0.76296E-05_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.33186E-04_JPRB,0.46811E-04_JPRB,0.48218E-04_JPRB,0.46849E-04_JPRB,0.43848E-04_JPRB, &
 & 0.39567E-04_JPRB,0.33858E-04_JPRB,0.26257E-04_JPRB,0.82634E-05_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.37227E-04_JPRB,0.52060E-04_JPRB,0.53592E-04_JPRB,0.51948E-04_JPRB,0.48471E-04_JPRB, &
 & 0.43595E-04_JPRB,0.37022E-04_JPRB,0.28130E-04_JPRB,0.90053E-05_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.18333E-04_JPRB,0.27259E-04_JPRB,0.27929E-04_JPRB,0.27230E-04_JPRB,0.25672E-04_JPRB, &
 & 0.23374E-04_JPRB,0.20571E-04_JPRB,0.17333E-04_JPRB,0.54157E-05_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.20948E-04_JPRB,0.30774E-04_JPRB,0.31604E-04_JPRB,0.30823E-04_JPRB,0.29002E-04_JPRB, &
 & 0.26292E-04_JPRB,0.22734E-04_JPRB,0.18593E-04_JPRB,0.61669E-05_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.23883E-04_JPRB,0.34642E-04_JPRB,0.35656E-04_JPRB,0.34670E-04_JPRB,0.32507E-04_JPRB, &
 & 0.29303E-04_JPRB,0.25111E-04_JPRB,0.19985E-04_JPRB,0.69048E-05_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.27098E-04_JPRB,0.38802E-04_JPRB,0.40013E-04_JPRB,0.38777E-04_JPRB,0.36214E-04_JPRB, &
 & 0.32542E-04_JPRB,0.27674E-04_JPRB,0.21526E-04_JPRB,0.76591E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART3',0,ZHOOK_HANDLE)


KA(:, 5, 8, 3) = (/ &
 & 0.30462E-04_JPRB,0.43307E-04_JPRB,0.44596E-04_JPRB,0.43127E-04_JPRB,0.40142E-04_JPRB, &
 & 0.35890E-04_JPRB,0.30276E-04_JPRB,0.23065E-04_JPRB,0.84480E-05_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.14510E-04_JPRB,0.22049E-04_JPRB,0.22596E-04_JPRB,0.22021E-04_JPRB,0.20750E-04_JPRB, &
 & 0.18895E-04_JPRB,0.16685E-04_JPRB,0.14158E-04_JPRB,0.50284E-05_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.16710E-04_JPRB,0.25012E-04_JPRB,0.25686E-04_JPRB,0.25017E-04_JPRB,0.23537E-04_JPRB, &
 & 0.21350E-04_JPRB,0.18517E-04_JPRB,0.15170E-04_JPRB,0.59016E-05_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.19138E-04_JPRB,0.28271E-04_JPRB,0.29104E-04_JPRB,0.28272E-04_JPRB,0.26493E-04_JPRB, &
 & 0.23916E-04_JPRB,0.20530E-04_JPRB,0.16297E-04_JPRB,0.68413E-05_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.21798E-04_JPRB,0.31859E-04_JPRB,0.32802E-04_JPRB,0.31762E-04_JPRB,0.29603E-04_JPRB, &
 & 0.26643E-04_JPRB,0.22650E-04_JPRB,0.17559E-04_JPRB,0.78093E-05_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.24599E-04_JPRB,0.35618E-04_JPRB,0.36736E-04_JPRB,0.35456E-04_JPRB,0.32981E-04_JPRB, &
 & 0.29459E-04_JPRB,0.24877E-04_JPRB,0.18821E-04_JPRB,0.88149E-05_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.11455E-04_JPRB,0.17796E-04_JPRB,0.18282E-04_JPRB,0.17833E-04_JPRB,0.16814E-04_JPRB, &
 & 0.15305E-04_JPRB,0.13526E-04_JPRB,0.11628E-04_JPRB,0.47637E-05_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.13295E-04_JPRB,0.20290E-04_JPRB,0.20862E-04_JPRB,0.20316E-04_JPRB,0.19125E-04_JPRB, &
 & 0.17348E-04_JPRB,0.15042E-04_JPRB,0.12455E-04_JPRB,0.56495E-05_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.15297E-04_JPRB,0.22994E-04_JPRB,0.23740E-04_JPRB,0.23076E-04_JPRB,0.21626E-04_JPRB, &
 & 0.19529E-04_JPRB,0.16766E-04_JPRB,0.13399E-04_JPRB,0.65988E-05_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.17488E-04_JPRB,0.25986E-04_JPRB,0.26882E-04_JPRB,0.26021E-04_JPRB,0.24246E-04_JPRB, &
 & 0.21820E-04_JPRB,0.18554E-04_JPRB,0.14427E-04_JPRB,0.74644E-05_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.19800E-04_JPRB,0.29160E-04_JPRB,0.30208E-04_JPRB,0.29161E-04_JPRB,0.27086E-04_JPRB, &
 & 0.24189E-04_JPRB,0.20462E-04_JPRB,0.15474E-04_JPRB,0.84395E-05_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.96366E-05_JPRB,0.15168E-04_JPRB,0.15611E-04_JPRB,0.15230E-04_JPRB,0.14381E-04_JPRB, &
 & 0.13058E-04_JPRB,0.11457E-04_JPRB,0.98195E-05_JPRB,0.43210E-05_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.11221E-04_JPRB,0.17304E-04_JPRB,0.17859E-04_JPRB,0.17390E-04_JPRB,0.16383E-04_JPRB, &
 & 0.14837E-04_JPRB,0.12820E-04_JPRB,0.10541E-04_JPRB,0.50915E-05_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.12922E-04_JPRB,0.19611E-04_JPRB,0.20376E-04_JPRB,0.19769E-04_JPRB,0.18510E-04_JPRB, &
 & 0.16733E-04_JPRB,0.14297E-04_JPRB,0.11375E-04_JPRB,0.59349E-05_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.14759E-04_JPRB,0.22226E-04_JPRB,0.23087E-04_JPRB,0.22319E-04_JPRB,0.20789E-04_JPRB, &
 & 0.18677E-04_JPRB,0.15854E-04_JPRB,0.12233E-04_JPRB,0.68646E-05_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.16687E-04_JPRB,0.24901E-04_JPRB,0.25894E-04_JPRB,0.25020E-04_JPRB,0.23234E-04_JPRB, &
 & 0.20746E-04_JPRB,0.17450E-04_JPRB,0.13143E-04_JPRB,0.77945E-05_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.80728E-05_JPRB,0.12833E-04_JPRB,0.13241E-04_JPRB,0.12930E-04_JPRB,0.12209E-04_JPRB, &
 & 0.11077E-04_JPRB,0.96874E-05_JPRB,0.82518E-05_JPRB,0.36987E-05_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.94096E-05_JPRB,0.14647E-04_JPRB,0.15179E-04_JPRB,0.14789E-04_JPRB,0.13929E-04_JPRB, &
 & 0.12614E-04_JPRB,0.10863E-04_JPRB,0.88839E-05_JPRB,0.43642E-05_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.10827E-04_JPRB,0.16625E-04_JPRB,0.17336E-04_JPRB,0.16825E-04_JPRB,0.15757E-04_JPRB, &
 & 0.14215E-04_JPRB,0.12135E-04_JPRB,0.95702E-05_JPRB,0.51276E-05_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.12346E-04_JPRB,0.18823E-04_JPRB,0.19626E-04_JPRB,0.19011E-04_JPRB,0.17715E-04_JPRB, &
 & 0.15891E-04_JPRB,0.13472E-04_JPRB,0.10297E-04_JPRB,0.58818E-05_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.13954E-04_JPRB,0.21071E-04_JPRB,0.21985E-04_JPRB,0.21278E-04_JPRB,0.19773E-04_JPRB, &
 & 0.17642E-04_JPRB,0.14813E-04_JPRB,0.11109E-04_JPRB,0.66485E-05_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.67198E-05_JPRB,0.10777E-04_JPRB,0.11153E-04_JPRB,0.10900E-04_JPRB,0.10301E-04_JPRB, &
 & 0.93345E-05_JPRB,0.81433E-05_JPRB,0.69156E-05_JPRB,0.30498E-05_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.78283E-05_JPRB,0.12283E-04_JPRB,0.12805E-04_JPRB,0.12492E-04_JPRB,0.11757E-04_JPRB, &
 & 0.10649E-04_JPRB,0.91519E-05_JPRB,0.74495E-05_JPRB,0.36028E-05_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.89966E-05_JPRB,0.13983E-04_JPRB,0.14629E-04_JPRB,0.14218E-04_JPRB,0.13315E-04_JPRB, &
 & 0.11990E-04_JPRB,0.10230E-04_JPRB,0.80237E-05_JPRB,0.42382E-05_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.10250E-04_JPRB,0.15794E-04_JPRB,0.16536E-04_JPRB,0.16055E-04_JPRB,0.14979E-04_JPRB, &
 & 0.13421E-04_JPRB,0.11355E-04_JPRB,0.86371E-05_JPRB,0.48511E-05_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.11575E-04_JPRB,0.17689E-04_JPRB,0.18502E-04_JPRB,0.17950E-04_JPRB,0.16689E-04_JPRB, &
 & 0.14883E-04_JPRB,0.12476E-04_JPRB,0.93537E-05_JPRB,0.54799E-05_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.20313E-03_JPRB,0.26410E-03_JPRB,0.27054E-03_JPRB,0.25842E-03_JPRB,0.23794E-03_JPRB, &
 & 0.21033E-03_JPRB,0.17730E-03_JPRB,0.13831E-03_JPRB,0.52995E-04_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.22722E-03_JPRB,0.29058E-03_JPRB,0.29572E-03_JPRB,0.28200E-03_JPRB,0.25898E-03_JPRB, &
 & 0.22814E-03_JPRB,0.19209E-03_JPRB,0.14957E-03_JPRB,0.59096E-04_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.25054E-03_JPRB,0.31580E-03_JPRB,0.31991E-03_JPRB,0.30486E-03_JPRB,0.27955E-03_JPRB, &
 & 0.24634E-03_JPRB,0.20787E-03_JPRB,0.16179E-03_JPRB,0.65118E-04_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.27197E-03_JPRB,0.33971E-03_JPRB,0.34310E-03_JPRB,0.32677E-03_JPRB,0.30002E-03_JPRB, &
 & 0.26574E-03_JPRB,0.22502E-03_JPRB,0.17520E-03_JPRB,0.71711E-04_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.29178E-03_JPRB,0.36213E-03_JPRB,0.36503E-03_JPRB,0.34815E-03_JPRB,0.32114E-03_JPRB, &
 & 0.28599E-03_JPRB,0.24328E-03_JPRB,0.18958E-03_JPRB,0.78523E-04_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.17547E-03_JPRB,0.23012E-03_JPRB,0.23639E-03_JPRB,0.22606E-03_JPRB,0.20799E-03_JPRB, &
 & 0.18326E-03_JPRB,0.15385E-03_JPRB,0.11888E-03_JPRB,0.43633E-04_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.19601E-03_JPRB,0.25269E-03_JPRB,0.25751E-03_JPRB,0.24629E-03_JPRB,0.22623E-03_JPRB, &
 & 0.19926E-03_JPRB,0.16712E-03_JPRB,0.12877E-03_JPRB,0.48382E-04_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.21598E-03_JPRB,0.27423E-03_JPRB,0.27812E-03_JPRB,0.26576E-03_JPRB,0.24403E-03_JPRB, &
 & 0.21552E-03_JPRB,0.18141E-03_JPRB,0.13982E-03_JPRB,0.53560E-04_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.23449E-03_JPRB,0.29482E-03_JPRB,0.29820E-03_JPRB,0.28454E-03_JPRB,0.26171E-03_JPRB, &
 & 0.23254E-03_JPRB,0.19681E-03_JPRB,0.15192E-03_JPRB,0.59054E-04_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.25198E-03_JPRB,0.31408E-03_JPRB,0.31723E-03_JPRB,0.30341E-03_JPRB,0.28040E-03_JPRB, &
 & 0.25022E-03_JPRB,0.21333E-03_JPRB,0.16487E-03_JPRB,0.64779E-04_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.14736E-03_JPRB,0.19483E-03_JPRB,0.20065E-03_JPRB,0.19242E-03_JPRB,0.17728E-03_JPRB, &
 & 0.15627E-03_JPRB,0.13078E-03_JPRB,0.10037E-03_JPRB,0.34217E-04_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.16492E-03_JPRB,0.21441E-03_JPRB,0.21892E-03_JPRB,0.20980E-03_JPRB,0.19289E-03_JPRB, &
 & 0.17000E-03_JPRB,0.14249E-03_JPRB,0.10902E-03_JPRB,0.38352E-04_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.18200E-03_JPRB,0.23294E-03_JPRB,0.23658E-03_JPRB,0.22658E-03_JPRB,0.20822E-03_JPRB, &
 & 0.18391E-03_JPRB,0.15484E-03_JPRB,0.11888E-03_JPRB,0.42700E-04_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.19811E-03_JPRB,0.25094E-03_JPRB,0.25385E-03_JPRB,0.24276E-03_JPRB,0.22338E-03_JPRB, &
 & 0.19841E-03_JPRB,0.16822E-03_JPRB,0.12943E-03_JPRB,0.47257E-04_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.21352E-03_JPRB,0.26784E-03_JPRB,0.27027E-03_JPRB,0.25917E-03_JPRB,0.23966E-03_JPRB, &
 & 0.21399E-03_JPRB,0.18239E-03_JPRB,0.14058E-03_JPRB,0.51997E-04_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.12070E-03_JPRB,0.16282E-03_JPRB,0.16870E-03_JPRB,0.16215E-03_JPRB,0.14966E-03_JPRB, &
 & 0.13195E-03_JPRB,0.11003E-03_JPRB,0.83743E-04_JPRB,0.26841E-04_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.13616E-03_JPRB,0.17979E-03_JPRB,0.18420E-03_JPRB,0.17692E-03_JPRB,0.16288E-03_JPRB, &
 & 0.14351E-03_JPRB,0.12000E-03_JPRB,0.91324E-04_JPRB,0.29956E-04_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.15142E-03_JPRB,0.19606E-03_JPRB,0.19933E-03_JPRB,0.19132E-03_JPRB,0.17582E-03_JPRB, &
 & 0.15506E-03_JPRB,0.13061E-03_JPRB,0.99881E-04_JPRB,0.33175E-04_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.16591E-03_JPRB,0.21170E-03_JPRB,0.21421E-03_JPRB,0.20525E-03_JPRB,0.18888E-03_JPRB, &
 & 0.16747E-03_JPRB,0.14192E-03_JPRB,0.10907E-03_JPRB,0.36625E-04_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.17956E-03_JPRB,0.22655E-03_JPRB,0.22833E-03_JPRB,0.21949E-03_JPRB,0.20283E-03_JPRB, &
 & 0.18086E-03_JPRB,0.15393E-03_JPRB,0.11865E-03_JPRB,0.40513E-04_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.98625E-04_JPRB,0.13480E-03_JPRB,0.14099E-03_JPRB,0.13653E-03_JPRB,0.12600E-03_JPRB, &
 & 0.11107E-03_JPRB,0.92102E-04_JPRB,0.69414E-04_JPRB,0.22597E-04_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.11165E-03_JPRB,0.14975E-03_JPRB,0.15429E-03_JPRB,0.14886E-03_JPRB,0.13710E-03_JPRB, &
 & 0.12076E-03_JPRB,0.10051E-03_JPRB,0.76046E-04_JPRB,0.25265E-04_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.12461E-03_JPRB,0.16391E-03_JPRB,0.16725E-03_JPRB,0.16091E-03_JPRB,0.14796E-03_JPRB, &
 & 0.13047E-03_JPRB,0.10941E-03_JPRB,0.83193E-04_JPRB,0.27962E-04_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.13738E-03_JPRB,0.17761E-03_JPRB,0.17982E-03_JPRB,0.17281E-03_JPRB,0.15916E-03_JPRB, &
 & 0.14087E-03_JPRB,0.11892E-03_JPRB,0.90972E-04_JPRB,0.30855E-04_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.14967E-03_JPRB,0.19066E-03_JPRB,0.19231E-03_JPRB,0.18509E-03_JPRB,0.17109E-03_JPRB, &
 & 0.15227E-03_JPRB,0.12906E-03_JPRB,0.99136E-04_JPRB,0.34017E-04_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.79863E-04_JPRB,0.11034E-03_JPRB,0.11622E-03_JPRB,0.11400E-03_JPRB,0.10532E-03_JPRB, &
 & 0.92978E-04_JPRB,0.76661E-04_JPRB,0.57287E-04_JPRB,0.18664E-04_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.90753E-04_JPRB,0.12318E-03_JPRB,0.12766E-03_JPRB,0.12440E-03_JPRB,0.11482E-03_JPRB, &
 & 0.10110E-03_JPRB,0.83697E-04_JPRB,0.62663E-04_JPRB,0.20928E-04_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.10183E-03_JPRB,0.13532E-03_JPRB,0.13907E-03_JPRB,0.13464E-03_JPRB,0.12396E-03_JPRB, &
 & 0.10925E-03_JPRB,0.90984E-04_JPRB,0.68513E-04_JPRB,0.23264E-04_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.11293E-03_JPRB,0.14742E-03_JPRB,0.14995E-03_JPRB,0.14481E-03_JPRB,0.13354E-03_JPRB, &
 & 0.11797E-03_JPRB,0.98845E-04_JPRB,0.74965E-04_JPRB,0.25850E-04_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.12360E-03_JPRB,0.15914E-03_JPRB,0.16090E-03_JPRB,0.15521E-03_JPRB,0.14361E-03_JPRB, &
 & 0.12755E-03_JPRB,0.10739E-03_JPRB,0.81915E-04_JPRB,0.28635E-04_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.65679E-04_JPRB,0.90084E-04_JPRB,0.95681E-04_JPRB,0.94567E-04_JPRB,0.87338E-04_JPRB, &
 & 0.77275E-04_JPRB,0.63642E-04_JPRB,0.47097E-04_JPRB,0.15508E-04_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.74551E-04_JPRB,0.10089E-03_JPRB,0.10531E-03_JPRB,0.10327E-03_JPRB,0.95364E-04_JPRB, &
 & 0.84154E-04_JPRB,0.69569E-04_JPRB,0.51426E-04_JPRB,0.17234E-04_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.83584E-04_JPRB,0.11137E-03_JPRB,0.11469E-03_JPRB,0.11193E-03_JPRB,0.10325E-03_JPRB, &
 & 0.91075E-04_JPRB,0.75479E-04_JPRB,0.56228E-04_JPRB,0.19127E-04_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.92762E-04_JPRB,0.12171E-03_JPRB,0.12420E-03_JPRB,0.12060E-03_JPRB,0.11147E-03_JPRB, &
 & 0.98465E-04_JPRB,0.81969E-04_JPRB,0.61529E-04_JPRB,0.21452E-04_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.10189E-03_JPRB,0.13182E-03_JPRB,0.13364E-03_JPRB,0.12960E-03_JPRB,0.12008E-03_JPRB, &
 & 0.10652E-03_JPRB,0.89045E-04_JPRB,0.67334E-04_JPRB,0.23711E-04_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.53656E-04_JPRB,0.74109E-04_JPRB,0.78629E-04_JPRB,0.78245E-04_JPRB,0.72322E-04_JPRB, &
 & 0.63915E-04_JPRB,0.52625E-04_JPRB,0.38591E-04_JPRB,0.14416E-04_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.61163E-04_JPRB,0.83104E-04_JPRB,0.86832E-04_JPRB,0.85562E-04_JPRB,0.78992E-04_JPRB, &
 & 0.69666E-04_JPRB,0.57574E-04_JPRB,0.42098E-04_JPRB,0.15921E-04_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.68914E-04_JPRB,0.91909E-04_JPRB,0.94594E-04_JPRB,0.92816E-04_JPRB,0.85590E-04_JPRB, &
 & 0.75491E-04_JPRB,0.62445E-04_JPRB,0.46109E-04_JPRB,0.17209E-04_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.76847E-04_JPRB,0.10059E-03_JPRB,0.10256E-03_JPRB,0.10019E-03_JPRB,0.92496E-04_JPRB, &
 & 0.81729E-04_JPRB,0.67763E-04_JPRB,0.50445E-04_JPRB,0.18589E-04_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.84847E-04_JPRB,0.10902E-03_JPRB,0.11071E-03_JPRB,0.10784E-03_JPRB,0.99812E-04_JPRB, &
 & 0.88516E-04_JPRB,0.73718E-04_JPRB,0.55250E-04_JPRB,0.20194E-04_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.43346E-04_JPRB,0.60608E-04_JPRB,0.64818E-04_JPRB,0.64681E-04_JPRB,0.59655E-04_JPRB, &
 & 0.52617E-04_JPRB,0.43206E-04_JPRB,0.31573E-04_JPRB,0.14696E-04_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.49669E-04_JPRB,0.68380E-04_JPRB,0.71800E-04_JPRB,0.70860E-04_JPRB,0.65260E-04_JPRB, &
 & 0.57496E-04_JPRB,0.47313E-04_JPRB,0.34405E-04_JPRB,0.16164E-04_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.56274E-04_JPRB,0.76040E-04_JPRB,0.78454E-04_JPRB,0.76944E-04_JPRB,0.70665E-04_JPRB, &
 & 0.62347E-04_JPRB,0.51383E-04_JPRB,0.37665E-04_JPRB,0.17841E-04_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.63127E-04_JPRB,0.83451E-04_JPRB,0.85178E-04_JPRB,0.83082E-04_JPRB,0.76437E-04_JPRB, &
 & 0.67538E-04_JPRB,0.55797E-04_JPRB,0.41264E-04_JPRB,0.19504E-04_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.70124E-04_JPRB,0.90807E-04_JPRB,0.91960E-04_JPRB,0.89432E-04_JPRB,0.82527E-04_JPRB, &
 & 0.73176E-04_JPRB,0.60668E-04_JPRB,0.45179E-04_JPRB,0.20992E-04_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.35059E-04_JPRB,0.49531E-04_JPRB,0.53376E-04_JPRB,0.53665E-04_JPRB,0.49644E-04_JPRB, &
 & 0.43592E-04_JPRB,0.35609E-04_JPRB,0.25845E-04_JPRB,0.13231E-04_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.40376E-04_JPRB,0.56174E-04_JPRB,0.59502E-04_JPRB,0.59040E-04_JPRB,0.54399E-04_JPRB, &
 & 0.47687E-04_JPRB,0.39007E-04_JPRB,0.28189E-04_JPRB,0.15223E-04_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.46006E-04_JPRB,0.62899E-04_JPRB,0.65214E-04_JPRB,0.64178E-04_JPRB,0.58976E-04_JPRB, &
 & 0.51726E-04_JPRB,0.42386E-04_JPRB,0.30843E-04_JPRB,0.17241E-04_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.51905E-04_JPRB,0.69395E-04_JPRB,0.70988E-04_JPRB,0.69461E-04_JPRB,0.63801E-04_JPRB, &
 & 0.56040E-04_JPRB,0.46059E-04_JPRB,0.33831E-04_JPRB,0.19714E-04_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.57990E-04_JPRB,0.75737E-04_JPRB,0.76826E-04_JPRB,0.74718E-04_JPRB,0.68839E-04_JPRB, &
 & 0.60664E-04_JPRB,0.50105E-04_JPRB,0.37049E-04_JPRB,0.22308E-04_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.30150E-04_JPRB,0.42738E-04_JPRB,0.46011E-04_JPRB,0.46330E-04_JPRB,0.42907E-04_JPRB, &
 & 0.37605E-04_JPRB,0.30702E-04_JPRB,0.21962E-04_JPRB,0.11791E-04_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.34714E-04_JPRB,0.48516E-04_JPRB,0.51120E-04_JPRB,0.50726E-04_JPRB,0.46912E-04_JPRB, &
 & 0.41033E-04_JPRB,0.33505E-04_JPRB,0.23952E-04_JPRB,0.13242E-04_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.39649E-04_JPRB,0.54325E-04_JPRB,0.56146E-04_JPRB,0.55270E-04_JPRB,0.50902E-04_JPRB, &
 & 0.44559E-04_JPRB,0.36351E-04_JPRB,0.26266E-04_JPRB,0.15075E-04_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.44779E-04_JPRB,0.59893E-04_JPRB,0.61166E-04_JPRB,0.59766E-04_JPRB,0.55070E-04_JPRB, &
 & 0.48303E-04_JPRB,0.39491E-04_JPRB,0.28847E-04_JPRB,0.17164E-04_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.49946E-04_JPRB,0.65411E-04_JPRB,0.66256E-04_JPRB,0.64345E-04_JPRB,0.59474E-04_JPRB, &
 & 0.52287E-04_JPRB,0.43003E-04_JPRB,0.31612E-04_JPRB,0.19542E-04_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.25681E-04_JPRB,0.36622E-04_JPRB,0.39428E-04_JPRB,0.39582E-04_JPRB,0.36786E-04_JPRB, &
 & 0.32210E-04_JPRB,0.26270E-04_JPRB,0.18629E-04_JPRB,0.10035E-04_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.29636E-04_JPRB,0.41620E-04_JPRB,0.43701E-04_JPRB,0.43425E-04_JPRB,0.40150E-04_JPRB, &
 & 0.35105E-04_JPRB,0.28637E-04_JPRB,0.20365E-04_JPRB,0.11416E-04_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.33921E-04_JPRB,0.46628E-04_JPRB,0.48062E-04_JPRB,0.47301E-04_JPRB,0.43633E-04_JPRB, &
 & 0.38189E-04_JPRB,0.31133E-04_JPRB,0.22405E-04_JPRB,0.12946E-04_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.38341E-04_JPRB,0.51401E-04_JPRB,0.52457E-04_JPRB,0.51129E-04_JPRB,0.47238E-04_JPRB, &
 & 0.41429E-04_JPRB,0.33905E-04_JPRB,0.24546E-04_JPRB,0.14770E-04_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.42576E-04_JPRB,0.56153E-04_JPRB,0.56863E-04_JPRB,0.55182E-04_JPRB,0.51113E-04_JPRB, &
 & 0.44940E-04_JPRB,0.36987E-04_JPRB,0.26898E-04_JPRB,0.16865E-04_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.21707E-04_JPRB,0.31142E-04_JPRB,0.33487E-04_JPRB,0.33650E-04_JPRB,0.31301E-04_JPRB, &
 & 0.27396E-04_JPRB,0.22352E-04_JPRB,0.15744E-04_JPRB,0.83005E-05_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.25112E-04_JPRB,0.35474E-04_JPRB,0.37158E-04_JPRB,0.36970E-04_JPRB,0.34170E-04_JPRB, &
 & 0.29871E-04_JPRB,0.24361E-04_JPRB,0.17312E-04_JPRB,0.93559E-05_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.28762E-04_JPRB,0.39712E-04_JPRB,0.40924E-04_JPRB,0.40199E-04_JPRB,0.37169E-04_JPRB, &
 & 0.32565E-04_JPRB,0.26566E-04_JPRB,0.19074E-04_JPRB,0.10670E-04_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.32448E-04_JPRB,0.43808E-04_JPRB,0.44734E-04_JPRB,0.43534E-04_JPRB,0.40323E-04_JPRB, &
 & 0.35367E-04_JPRB,0.29011E-04_JPRB,0.20897E-04_JPRB,0.12240E-04_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.35905E-04_JPRB,0.47771E-04_JPRB,0.48482E-04_JPRB,0.47094E-04_JPRB,0.43703E-04_JPRB, &
 & 0.38474E-04_JPRB,0.31715E-04_JPRB,0.22899E-04_JPRB,0.13958E-04_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.50328E-03_JPRB,0.59028E-03_JPRB,0.59973E-03_JPRB,0.58955E-03_JPRB,0.56685E-03_JPRB, &
 & 0.50893E-03_JPRB,0.43098E-03_JPRB,0.31518E-03_JPRB,0.12599E-03_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.53454E-03_JPRB,0.62581E-03_JPRB,0.63729E-03_JPRB,0.62588E-03_JPRB,0.59902E-03_JPRB, &
 & 0.54179E-03_JPRB,0.45928E-03_JPRB,0.33824E-03_JPRB,0.13937E-03_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.56216E-03_JPRB,0.66315E-03_JPRB,0.67707E-03_JPRB,0.66553E-03_JPRB,0.63545E-03_JPRB, &
 & 0.57719E-03_JPRB,0.48913E-03_JPRB,0.36332E-03_JPRB,0.15548E-03_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.58821E-03_JPRB,0.70231E-03_JPRB,0.71934E-03_JPRB,0.70828E-03_JPRB,0.67637E-03_JPRB, &
 & 0.61438E-03_JPRB,0.52042E-03_JPRB,0.38978E-03_JPRB,0.17254E-03_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.61349E-03_JPRB,0.74309E-03_JPRB,0.76503E-03_JPRB,0.75486E-03_JPRB,0.71943E-03_JPRB, &
 & 0.65213E-03_JPRB,0.55331E-03_JPRB,0.41818E-03_JPRB,0.19176E-03_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.43720E-03_JPRB,0.51117E-03_JPRB,0.51919E-03_JPRB,0.50988E-03_JPRB,0.48875E-03_JPRB, &
 & 0.44138E-03_JPRB,0.37418E-03_JPRB,0.27478E-03_JPRB,0.10374E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART4',0,ZHOOK_HANDLE)


KA(:, 2, 2, 5) = (/ &
 & 0.46400E-03_JPRB,0.54460E-03_JPRB,0.55429E-03_JPRB,0.54395E-03_JPRB,0.52067E-03_JPRB, &
 & 0.47118E-03_JPRB,0.39949E-03_JPRB,0.29546E-03_JPRB,0.11585E-03_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.48798E-03_JPRB,0.57940E-03_JPRB,0.59177E-03_JPRB,0.58113E-03_JPRB,0.55553E-03_JPRB, &
 & 0.50290E-03_JPRB,0.42588E-03_JPRB,0.31727E-03_JPRB,0.12872E-03_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.51088E-03_JPRB,0.61529E-03_JPRB,0.63115E-03_JPRB,0.62163E-03_JPRB,0.59296E-03_JPRB, &
 & 0.53614E-03_JPRB,0.45317E-03_JPRB,0.34070E-03_JPRB,0.14334E-03_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.53331E-03_JPRB,0.65233E-03_JPRB,0.67270E-03_JPRB,0.66363E-03_JPRB,0.63091E-03_JPRB, &
 & 0.57023E-03_JPRB,0.48253E-03_JPRB,0.36597E-03_JPRB,0.15947E-03_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.37168E-03_JPRB,0.43544E-03_JPRB,0.44351E-03_JPRB,0.43496E-03_JPRB,0.41418E-03_JPRB, &
 & 0.37673E-03_JPRB,0.31849E-03_JPRB,0.23373E-03_JPRB,0.83035E-04_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.39476E-03_JPRB,0.46532E-03_JPRB,0.47527E-03_JPRB,0.46587E-03_JPRB,0.44394E-03_JPRB, &
 & 0.40288E-03_JPRB,0.34052E-03_JPRB,0.25172E-03_JPRB,0.92363E-04_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.41559E-03_JPRB,0.49597E-03_JPRB,0.50880E-03_JPRB,0.49944E-03_JPRB,0.47605E-03_JPRB, &
 & 0.43138E-03_JPRB,0.36384E-03_JPRB,0.27063E-03_JPRB,0.10327E-03_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.43551E-03_JPRB,0.52738E-03_JPRB,0.54357E-03_JPRB,0.53553E-03_JPRB,0.50924E-03_JPRB, &
 & 0.46069E-03_JPRB,0.38844E-03_JPRB,0.29089E-03_JPRB,0.11548E-03_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.45509E-03_JPRB,0.56036E-03_JPRB,0.58045E-03_JPRB,0.57279E-03_JPRB,0.54320E-03_JPRB, &
 & 0.49088E-03_JPRB,0.41461E-03_JPRB,0.31304E-03_JPRB,0.12901E-03_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.31353E-03_JPRB,0.36800E-03_JPRB,0.37478E-03_JPRB,0.36628E-03_JPRB,0.34818E-03_JPRB, &
 & 0.31938E-03_JPRB,0.26882E-03_JPRB,0.19725E-03_JPRB,0.65143E-04_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.33327E-03_JPRB,0.39347E-03_JPRB,0.40240E-03_JPRB,0.39421E-03_JPRB,0.37500E-03_JPRB, &
 & 0.34245E-03_JPRB,0.28782E-03_JPRB,0.21247E-03_JPRB,0.72911E-04_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.35116E-03_JPRB,0.41935E-03_JPRB,0.43125E-03_JPRB,0.42396E-03_JPRB,0.40374E-03_JPRB, &
 & 0.36745E-03_JPRB,0.30851E-03_JPRB,0.22861E-03_JPRB,0.82223E-04_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.36817E-03_JPRB,0.44654E-03_JPRB,0.46141E-03_JPRB,0.45505E-03_JPRB,0.43257E-03_JPRB, &
 & 0.39339E-03_JPRB,0.33051E-03_JPRB,0.24594E-03_JPRB,0.92524E-04_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.38502E-03_JPRB,0.47537E-03_JPRB,0.49387E-03_JPRB,0.48730E-03_JPRB,0.46233E-03_JPRB, &
 & 0.42007E-03_JPRB,0.35374E-03_JPRB,0.26504E-03_JPRB,0.10363E-03_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.26371E-03_JPRB,0.30958E-03_JPRB,0.31480E-03_JPRB,0.30643E-03_JPRB,0.29119E-03_JPRB, &
 & 0.26781E-03_JPRB,0.22601E-03_JPRB,0.16580E-03_JPRB,0.51526E-04_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.28046E-03_JPRB,0.33149E-03_JPRB,0.33831E-03_JPRB,0.33074E-03_JPRB,0.31455E-03_JPRB, &
 & 0.28912E-03_JPRB,0.24254E-03_JPRB,0.17884E-03_JPRB,0.57544E-04_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.29571E-03_JPRB,0.35368E-03_JPRB,0.36281E-03_JPRB,0.35630E-03_JPRB,0.33882E-03_JPRB, &
 & 0.31097E-03_JPRB,0.26070E-03_JPRB,0.19272E-03_JPRB,0.64519E-04_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.31016E-03_JPRB,0.37666E-03_JPRB,0.38893E-03_JPRB,0.38273E-03_JPRB,0.36412E-03_JPRB, &
 & 0.33364E-03_JPRB,0.28016E-03_JPRB,0.20757E-03_JPRB,0.72363E-04_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.32452E-03_JPRB,0.40122E-03_JPRB,0.41666E-03_JPRB,0.41046E-03_JPRB,0.39013E-03_JPRB, &
 & 0.35668E-03_JPRB,0.30056E-03_JPRB,0.22388E-03_JPRB,0.80981E-04_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.22069E-03_JPRB,0.25888E-03_JPRB,0.26323E-03_JPRB,0.25479E-03_JPRB,0.24246E-03_JPRB, &
 & 0.22303E-03_JPRB,0.18865E-03_JPRB,0.13826E-03_JPRB,0.42586E-04_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.23505E-03_JPRB,0.27730E-03_JPRB,0.28289E-03_JPRB,0.27510E-03_JPRB,0.26179E-03_JPRB, &
 & 0.24147E-03_JPRB,0.20303E-03_JPRB,0.14956E-03_JPRB,0.47728E-04_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.24799E-03_JPRB,0.29644E-03_JPRB,0.30324E-03_JPRB,0.29696E-03_JPRB,0.28190E-03_JPRB, &
 & 0.26059E-03_JPRB,0.21889E-03_JPRB,0.16173E-03_JPRB,0.53804E-04_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.26027E-03_JPRB,0.31607E-03_JPRB,0.32548E-03_JPRB,0.31928E-03_JPRB,0.30338E-03_JPRB, &
 & 0.27984E-03_JPRB,0.23536E-03_JPRB,0.17457E-03_JPRB,0.60579E-04_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.27261E-03_JPRB,0.33682E-03_JPRB,0.34889E-03_JPRB,0.34299E-03_JPRB,0.32589E-03_JPRB, &
 & 0.29875E-03_JPRB,0.25286E-03_JPRB,0.18852E-03_JPRB,0.67802E-04_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.18284E-03_JPRB,0.21563E-03_JPRB,0.21874E-03_JPRB,0.21147E-03_JPRB,0.20158E-03_JPRB, &
 & 0.18535E-03_JPRB,0.15699E-03_JPRB,0.11455E-03_JPRB,0.35095E-04_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.19537E-03_JPRB,0.23122E-03_JPRB,0.23571E-03_JPRB,0.22829E-03_JPRB,0.21760E-03_JPRB, &
 & 0.20013E-03_JPRB,0.16934E-03_JPRB,0.12429E-03_JPRB,0.39853E-04_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.20672E-03_JPRB,0.24731E-03_JPRB,0.25313E-03_JPRB,0.24636E-03_JPRB,0.23401E-03_JPRB, &
 & 0.21622E-03_JPRB,0.18276E-03_JPRB,0.13469E-03_JPRB,0.45173E-04_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.21741E-03_JPRB,0.26399E-03_JPRB,0.27153E-03_JPRB,0.26539E-03_JPRB,0.25198E-03_JPRB, &
 & 0.23212E-03_JPRB,0.19655E-03_JPRB,0.14593E-03_JPRB,0.50910E-04_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.22822E-03_JPRB,0.28170E-03_JPRB,0.29118E-03_JPRB,0.28544E-03_JPRB,0.27112E-03_JPRB, &
 & 0.24842E-03_JPRB,0.21129E-03_JPRB,0.15803E-03_JPRB,0.57288E-04_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.15136E-03_JPRB,0.17854E-03_JPRB,0.18119E-03_JPRB,0.17535E-03_JPRB,0.16721E-03_JPRB, &
 & 0.15392E-03_JPRB,0.13041E-03_JPRB,0.94463E-04_JPRB,0.29176E-04_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.16197E-03_JPRB,0.19183E-03_JPRB,0.19544E-03_JPRB,0.18940E-03_JPRB,0.18045E-03_JPRB, &
 & 0.16606E-03_JPRB,0.14094E-03_JPRB,0.10292E-03_JPRB,0.33234E-04_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.17149E-03_JPRB,0.20540E-03_JPRB,0.21055E-03_JPRB,0.20432E-03_JPRB,0.19421E-03_JPRB, &
 & 0.17914E-03_JPRB,0.15214E-03_JPRB,0.11170E-03_JPRB,0.37987E-04_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.18048E-03_JPRB,0.21966E-03_JPRB,0.22618E-03_JPRB,0.22017E-03_JPRB,0.20926E-03_JPRB, &
 & 0.19215E-03_JPRB,0.16364E-03_JPRB,0.12118E-03_JPRB,0.43249E-04_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.18968E-03_JPRB,0.23496E-03_JPRB,0.24258E-03_JPRB,0.23712E-03_JPRB,0.22524E-03_JPRB, &
 & 0.20589E-03_JPRB,0.17598E-03_JPRB,0.13139E-03_JPRB,0.48772E-04_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.12535E-03_JPRB,0.14733E-03_JPRB,0.14911E-03_JPRB,0.14464E-03_JPRB,0.13810E-03_JPRB, &
 & 0.12766E-03_JPRB,0.10804E-03_JPRB,0.77667E-04_JPRB,0.31607E-04_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.13428E-03_JPRB,0.15826E-03_JPRB,0.16122E-03_JPRB,0.15658E-03_JPRB,0.14914E-03_JPRB, &
 & 0.13752E-03_JPRB,0.11655E-03_JPRB,0.84956E-04_JPRB,0.35832E-04_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.14212E-03_JPRB,0.16949E-03_JPRB,0.17392E-03_JPRB,0.16905E-03_JPRB,0.16073E-03_JPRB, &
 & 0.14802E-03_JPRB,0.12582E-03_JPRB,0.92269E-04_JPRB,0.39990E-04_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.14955E-03_JPRB,0.18151E-03_JPRB,0.18720E-03_JPRB,0.18233E-03_JPRB,0.17343E-03_JPRB, &
 & 0.15845E-03_JPRB,0.13559E-03_JPRB,0.99998E-04_JPRB,0.44405E-04_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.15720E-03_JPRB,0.19441E-03_JPRB,0.20115E-03_JPRB,0.19658E-03_JPRB,0.18679E-03_JPRB, &
 & 0.17045E-03_JPRB,0.14597E-03_JPRB,0.10853E-03_JPRB,0.48354E-04_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.10518E-03_JPRB,0.12283E-03_JPRB,0.12342E-03_JPRB,0.11933E-03_JPRB,0.11376E-03_JPRB, &
 & 0.10615E-03_JPRB,0.89610E-04_JPRB,0.64322E-04_JPRB,0.38897E-04_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.11277E-03_JPRB,0.13167E-03_JPRB,0.13319E-03_JPRB,0.12937E-03_JPRB,0.12328E-03_JPRB, &
 & 0.11434E-03_JPRB,0.96637E-04_JPRB,0.70434E-04_JPRB,0.44697E-04_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.11946E-03_JPRB,0.14071E-03_JPRB,0.14389E-03_JPRB,0.14002E-03_JPRB,0.13292E-03_JPRB, &
 & 0.12246E-03_JPRB,0.10436E-03_JPRB,0.76473E-04_JPRB,0.50672E-04_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.12573E-03_JPRB,0.15045E-03_JPRB,0.15515E-03_JPRB,0.15121E-03_JPRB,0.14368E-03_JPRB, &
 & 0.13136E-03_JPRB,0.11260E-03_JPRB,0.82864E-04_JPRB,0.56090E-04_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.13210E-03_JPRB,0.16128E-03_JPRB,0.16701E-03_JPRB,0.16339E-03_JPRB,0.15508E-03_JPRB, &
 & 0.14154E-03_JPRB,0.12132E-03_JPRB,0.89973E-04_JPRB,0.61017E-04_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.90693E-04_JPRB,0.10606E-03_JPRB,0.10639E-03_JPRB,0.10214E-03_JPRB,0.97041E-04_JPRB, &
 & 0.90929E-04_JPRB,0.76654E-04_JPRB,0.55448E-04_JPRB,0.34971E-04_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.96878E-04_JPRB,0.11346E-03_JPRB,0.11478E-03_JPRB,0.11094E-03_JPRB,0.10496E-03_JPRB, &
 & 0.97427E-04_JPRB,0.82680E-04_JPRB,0.60468E-04_JPRB,0.41599E-04_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.10232E-03_JPRB,0.12125E-03_JPRB,0.12365E-03_JPRB,0.11979E-03_JPRB,0.11346E-03_JPRB, &
 & 0.10430E-03_JPRB,0.89390E-04_JPRB,0.65549E-04_JPRB,0.48186E-04_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.10772E-03_JPRB,0.12969E-03_JPRB,0.13316E-03_JPRB,0.12963E-03_JPRB,0.12290E-03_JPRB, &
 & 0.11234E-03_JPRB,0.96526E-04_JPRB,0.71097E-04_JPRB,0.54537E-04_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.11345E-03_JPRB,0.13912E-03_JPRB,0.14339E-03_JPRB,0.14025E-03_JPRB,0.13275E-03_JPRB, &
 & 0.12106E-03_JPRB,0.10412E-03_JPRB,0.77240E-04_JPRB,0.60238E-04_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.77577E-04_JPRB,0.91005E-04_JPRB,0.91202E-04_JPRB,0.87618E-04_JPRB,0.82974E-04_JPRB, &
 & 0.77488E-04_JPRB,0.65261E-04_JPRB,0.47539E-04_JPRB,0.30516E-04_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.82612E-04_JPRB,0.97349E-04_JPRB,0.98497E-04_JPRB,0.95069E-04_JPRB,0.89699E-04_JPRB, &
 & 0.82714E-04_JPRB,0.70478E-04_JPRB,0.51645E-04_JPRB,0.35968E-04_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.87206E-04_JPRB,0.10402E-03_JPRB,0.10625E-03_JPRB,0.10294E-03_JPRB,0.97013E-04_JPRB, &
 & 0.88723E-04_JPRB,0.76259E-04_JPRB,0.55960E-04_JPRB,0.41899E-04_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.91929E-04_JPRB,0.11153E-03_JPRB,0.11462E-03_JPRB,0.11153E-03_JPRB,0.10500E-03_JPRB, &
 & 0.95633E-04_JPRB,0.82267E-04_JPRB,0.60868E-04_JPRB,0.48100E-04_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.97101E-04_JPRB,0.11996E-03_JPRB,0.12377E-03_JPRB,0.12058E-03_JPRB,0.11342E-03_JPRB, &
 & 0.10316E-03_JPRB,0.88884E-04_JPRB,0.66077E-04_JPRB,0.53563E-04_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.65838E-04_JPRB,0.77620E-04_JPRB,0.77829E-04_JPRB,0.74661E-04_JPRB,0.70473E-04_JPRB, &
 & 0.65575E-04_JPRB,0.55474E-04_JPRB,0.40441E-04_JPRB,0.25521E-04_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.69998E-04_JPRB,0.83015E-04_JPRB,0.84103E-04_JPRB,0.81066E-04_JPRB,0.76507E-04_JPRB, &
 & 0.70172E-04_JPRB,0.59914E-04_JPRB,0.43882E-04_JPRB,0.30126E-04_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.74003E-04_JPRB,0.88878E-04_JPRB,0.90840E-04_JPRB,0.88139E-04_JPRB,0.82951E-04_JPRB, &
 & 0.75471E-04_JPRB,0.64689E-04_JPRB,0.47652E-04_JPRB,0.35171E-04_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.78234E-04_JPRB,0.95561E-04_JPRB,0.98237E-04_JPRB,0.95653E-04_JPRB,0.89770E-04_JPRB, &
 & 0.81434E-04_JPRB,0.69913E-04_JPRB,0.51882E-04_JPRB,0.40221E-04_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.82825E-04_JPRB,0.10313E-03_JPRB,0.10644E-03_JPRB,0.10352E-03_JPRB,0.97040E-04_JPRB, &
 & 0.87602E-04_JPRB,0.75532E-04_JPRB,0.56387E-04_JPRB,0.44675E-04_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.10615E-02_JPRB,0.12529E-02_JPRB,0.13083E-02_JPRB,0.12764E-02_JPRB,0.11881E-02_JPRB, &
 & 0.10853E-02_JPRB,0.93421E-03_JPRB,0.71644E-03_JPRB,0.30757E-03_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.10918E-02_JPRB,0.13136E-02_JPRB,0.13677E-02_JPRB,0.13350E-02_JPRB,0.12522E-02_JPRB, &
 & 0.11402E-02_JPRB,0.98392E-03_JPRB,0.76040E-03_JPRB,0.35125E-03_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.11297E-02_JPRB,0.13742E-02_JPRB,0.14266E-02_JPRB,0.13956E-02_JPRB,0.13143E-02_JPRB, &
 & 0.11951E-02_JPRB,0.10359E-02_JPRB,0.81032E-03_JPRB,0.39829E-03_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.11716E-02_JPRB,0.14330E-02_JPRB,0.14865E-02_JPRB,0.14580E-02_JPRB,0.13738E-02_JPRB, &
 & 0.12536E-02_JPRB,0.10931E-02_JPRB,0.86605E-03_JPRB,0.44907E-03_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.12137E-02_JPRB,0.14919E-02_JPRB,0.15477E-02_JPRB,0.15196E-02_JPRB,0.14358E-02_JPRB, &
 & 0.13166E-02_JPRB,0.11546E-02_JPRB,0.92748E-03_JPRB,0.50593E-03_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.92435E-03_JPRB,0.10874E-02_JPRB,0.11275E-02_JPRB,0.11015E-02_JPRB,0.10311E-02_JPRB, &
 & 0.94231E-03_JPRB,0.80960E-03_JPRB,0.63033E-03_JPRB,0.26663E-03_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.95885E-03_JPRB,0.11428E-02_JPRB,0.11829E-02_JPRB,0.11541E-02_JPRB,0.10849E-02_JPRB, &
 & 0.98930E-03_JPRB,0.85567E-03_JPRB,0.67200E-03_JPRB,0.30230E-03_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.99776E-03_JPRB,0.11978E-02_JPRB,0.12376E-02_JPRB,0.12093E-02_JPRB,0.11390E-02_JPRB, &
 & 0.10392E-02_JPRB,0.90558E-03_JPRB,0.71833E-03_JPRB,0.34245E-03_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.10380E-02_JPRB,0.12537E-02_JPRB,0.12935E-02_JPRB,0.12652E-02_JPRB,0.11933E-02_JPRB, &
 & 0.10921E-02_JPRB,0.95939E-03_JPRB,0.76948E-03_JPRB,0.38641E-03_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.10779E-02_JPRB,0.13105E-02_JPRB,0.13515E-02_JPRB,0.13214E-02_JPRB,0.12497E-02_JPRB, &
 & 0.11514E-02_JPRB,0.10182E-02_JPRB,0.82552E-03_JPRB,0.43428E-03_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.79958E-03_JPRB,0.93053E-03_JPRB,0.95669E-03_JPRB,0.93720E-03_JPRB,0.88165E-03_JPRB, &
 & 0.80178E-03_JPRB,0.69131E-03_JPRB,0.54027E-03_JPRB,0.22082E-03_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.83354E-03_JPRB,0.98064E-03_JPRB,0.10079E-02_JPRB,0.98484E-03_JPRB,0.92834E-03_JPRB, &
 & 0.84387E-03_JPRB,0.73304E-03_JPRB,0.57932E-03_JPRB,0.25149E-03_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.87012E-03_JPRB,0.10320E-02_JPRB,0.10600E-02_JPRB,0.10346E-02_JPRB,0.97491E-03_JPRB, &
 & 0.88683E-03_JPRB,0.77649E-03_JPRB,0.62208E-03_JPRB,0.28527E-03_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.90759E-03_JPRB,0.10841E-02_JPRB,0.11129E-02_JPRB,0.10858E-02_JPRB,0.10238E-02_JPRB, &
 & 0.93520E-03_JPRB,0.82494E-03_JPRB,0.66854E-03_JPRB,0.32199E-03_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.94443E-03_JPRB,0.11378E-02_JPRB,0.11668E-02_JPRB,0.11369E-02_JPRB,0.10746E-02_JPRB, &
 & 0.98835E-03_JPRB,0.87764E-03_JPRB,0.71868E-03_JPRB,0.36165E-03_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.68628E-03_JPRB,0.79104E-03_JPRB,0.80863E-03_JPRB,0.79421E-03_JPRB,0.74681E-03_JPRB, &
 & 0.67391E-03_JPRB,0.58210E-03_JPRB,0.45790E-03_JPRB,0.18137E-03_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.71790E-03_JPRB,0.83686E-03_JPRB,0.85591E-03_JPRB,0.83705E-03_JPRB,0.78808E-03_JPRB, &
 & 0.71172E-03_JPRB,0.61822E-03_JPRB,0.49245E-03_JPRB,0.20729E-03_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.75117E-03_JPRB,0.88426E-03_JPRB,0.90462E-03_JPRB,0.88167E-03_JPRB,0.82945E-03_JPRB, &
 & 0.75050E-03_JPRB,0.65652E-03_JPRB,0.53019E-03_JPRB,0.23455E-03_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.78430E-03_JPRB,0.93252E-03_JPRB,0.95418E-03_JPRB,0.92872E-03_JPRB,0.87301E-03_JPRB, &
 & 0.79337E-03_JPRB,0.69871E-03_JPRB,0.57160E-03_JPRB,0.26520E-03_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.81683E-03_JPRB,0.98168E-03_JPRB,0.10045E-02_JPRB,0.97638E-03_JPRB,0.92000E-03_JPRB, &
 & 0.84034E-03_JPRB,0.74480E-03_JPRB,0.61518E-03_JPRB,0.29808E-03_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.58497E-03_JPRB,0.66935E-03_JPRB,0.68301E-03_JPRB,0.66951E-03_JPRB,0.62962E-03_JPRB, &
 & 0.56579E-03_JPRB,0.48826E-03_JPRB,0.38379E-03_JPRB,0.14576E-03_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.61310E-03_JPRB,0.71031E-03_JPRB,0.72592E-03_JPRB,0.70978E-03_JPRB,0.66652E-03_JPRB, &
 & 0.59753E-03_JPRB,0.51826E-03_JPRB,0.41385E-03_JPRB,0.16772E-03_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.64179E-03_JPRB,0.75306E-03_JPRB,0.77095E-03_JPRB,0.75074E-03_JPRB,0.70458E-03_JPRB, &
 & 0.63276E-03_JPRB,0.55157E-03_JPRB,0.44695E-03_JPRB,0.19067E-03_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.67039E-03_JPRB,0.79634E-03_JPRB,0.81655E-03_JPRB,0.79420E-03_JPRB,0.74416E-03_JPRB, &
 & 0.67043E-03_JPRB,0.58781E-03_JPRB,0.48223E-03_JPRB,0.21651E-03_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.69870E-03_JPRB,0.83972E-03_JPRB,0.86240E-03_JPRB,0.83794E-03_JPRB,0.78674E-03_JPRB, &
 & 0.71204E-03_JPRB,0.62768E-03_JPRB,0.51780E-03_JPRB,0.24414E-03_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.49594E-03_JPRB,0.56319E-03_JPRB,0.57248E-03_JPRB,0.55950E-03_JPRB,0.52657E-03_JPRB, &
 & 0.47274E-03_JPRB,0.40631E-03_JPRB,0.31914E-03_JPRB,0.11737E-03_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.51946E-03_JPRB,0.59932E-03_JPRB,0.61091E-03_JPRB,0.59626E-03_JPRB,0.56011E-03_JPRB, &
 & 0.50076E-03_JPRB,0.43158E-03_JPRB,0.34422E-03_JPRB,0.13452E-03_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.54355E-03_JPRB,0.63601E-03_JPRB,0.65111E-03_JPRB,0.63466E-03_JPRB,0.59552E-03_JPRB, &
 & 0.53122E-03_JPRB,0.45996E-03_JPRB,0.37172E-03_JPRB,0.15179E-03_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.56762E-03_JPRB,0.67321E-03_JPRB,0.69130E-03_JPRB,0.67433E-03_JPRB,0.63164E-03_JPRB, &
 & 0.56508E-03_JPRB,0.49145E-03_JPRB,0.39979E-03_JPRB,0.17118E-03_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.59180E-03_JPRB,0.71065E-03_JPRB,0.73195E-03_JPRB,0.71355E-03_JPRB,0.66898E-03_JPRB, &
 & 0.60268E-03_JPRB,0.52617E-03_JPRB,0.43141E-03_JPRB,0.19263E-03_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.41932E-03_JPRB,0.47346E-03_JPRB,0.47850E-03_JPRB,0.46519E-03_JPRB,0.43628E-03_JPRB, &
 & 0.39132E-03_JPRB,0.33641E-03_JPRB,0.26485E-03_JPRB,0.10000E-03_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.43848E-03_JPRB,0.50411E-03_JPRB,0.51171E-03_JPRB,0.49803E-03_JPRB,0.46737E-03_JPRB, &
 & 0.41801E-03_JPRB,0.35878E-03_JPRB,0.28532E-03_JPRB,0.11408E-03_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.45836E-03_JPRB,0.53506E-03_JPRB,0.54578E-03_JPRB,0.53230E-03_JPRB,0.49970E-03_JPRB, &
 & 0.44506E-03_JPRB,0.38306E-03_JPRB,0.30828E-03_JPRB,0.13001E-03_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.47855E-03_JPRB,0.56639E-03_JPRB,0.58020E-03_JPRB,0.56722E-03_JPRB,0.53202E-03_JPRB, &
 & 0.47546E-03_JPRB,0.41064E-03_JPRB,0.33104E-03_JPRB,0.14676E-03_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.49885E-03_JPRB,0.59805E-03_JPRB,0.61555E-03_JPRB,0.60152E-03_JPRB,0.56466E-03_JPRB, &
 & 0.50884E-03_JPRB,0.44071E-03_JPRB,0.35766E-03_JPRB,0.16471E-03_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.35434E-03_JPRB,0.39784E-03_JPRB,0.40003E-03_JPRB,0.38643E-03_JPRB,0.36029E-03_JPRB, &
 & 0.32228E-03_JPRB,0.27705E-03_JPRB,0.21936E-03_JPRB,0.85304E-04_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.36972E-03_JPRB,0.42325E-03_JPRB,0.42802E-03_JPRB,0.41467E-03_JPRB,0.38745E-03_JPRB, &
 & 0.34637E-03_JPRB,0.29590E-03_JPRB,0.23622E-03_JPRB,0.97535E-04_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.38589E-03_JPRB,0.44905E-03_JPRB,0.45611E-03_JPRB,0.44402E-03_JPRB,0.41681E-03_JPRB, &
 & 0.37125E-03_JPRB,0.31793E-03_JPRB,0.25523E-03_JPRB,0.11156E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART5',0,ZHOOK_HANDLE)


KA(:, 4, 8, 6) = (/ &
 & 0.40282E-03_JPRB,0.47505E-03_JPRB,0.48489E-03_JPRB,0.47391E-03_JPRB,0.44440E-03_JPRB, &
 & 0.39797E-03_JPRB,0.34220E-03_JPRB,0.27395E-03_JPRB,0.12650E-03_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.41971E-03_JPRB,0.50175E-03_JPRB,0.51511E-03_JPRB,0.50365E-03_JPRB,0.47246E-03_JPRB, &
 & 0.42646E-03_JPRB,0.36852E-03_JPRB,0.29705E-03_JPRB,0.14272E-03_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.29829E-03_JPRB,0.33364E-03_JPRB,0.33392E-03_JPRB,0.32092E-03_JPRB,0.29738E-03_JPRB, &
 & 0.26469E-03_JPRB,0.22642E-03_JPRB,0.18017E-03_JPRB,0.77064E-04_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.31054E-03_JPRB,0.35463E-03_JPRB,0.35704E-03_JPRB,0.34432E-03_JPRB,0.32083E-03_JPRB, &
 & 0.28575E-03_JPRB,0.24402E-03_JPRB,0.19441E-03_JPRB,0.87743E-04_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.32389E-03_JPRB,0.37581E-03_JPRB,0.38023E-03_JPRB,0.36873E-03_JPRB,0.34562E-03_JPRB, &
 & 0.30799E-03_JPRB,0.26274E-03_JPRB,0.21037E-03_JPRB,0.99662E-04_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.33808E-03_JPRB,0.39748E-03_JPRB,0.40404E-03_JPRB,0.39387E-03_JPRB,0.36968E-03_JPRB, &
 & 0.33141E-03_JPRB,0.28405E-03_JPRB,0.22647E-03_JPRB,0.11282E-03_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.35231E-03_JPRB,0.41983E-03_JPRB,0.42961E-03_JPRB,0.41951E-03_JPRB,0.39352E-03_JPRB, &
 & 0.35528E-03_JPRB,0.30599E-03_JPRB,0.24648E-03_JPRB,0.12841E-03_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.25036E-03_JPRB,0.27999E-03_JPRB,0.27949E-03_JPRB,0.26793E-03_JPRB,0.24735E-03_JPRB, &
 & 0.21800E-03_JPRB,0.18604E-03_JPRB,0.14807E-03_JPRB,0.93146E-04_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.26009E-03_JPRB,0.29745E-03_JPRB,0.29870E-03_JPRB,0.28727E-03_JPRB,0.26656E-03_JPRB, &
 & 0.23674E-03_JPRB,0.20160E-03_JPRB,0.16012E-03_JPRB,0.10408E-03_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.27084E-03_JPRB,0.31508E-03_JPRB,0.31779E-03_JPRB,0.30720E-03_JPRB,0.28751E-03_JPRB, &
 & 0.25636E-03_JPRB,0.21818E-03_JPRB,0.17357E-03_JPRB,0.11611E-03_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.28251E-03_JPRB,0.33335E-03_JPRB,0.33759E-03_JPRB,0.32814E-03_JPRB,0.30785E-03_JPRB, &
 & 0.27625E-03_JPRB,0.23573E-03_JPRB,0.18761E-03_JPRB,0.12959E-03_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.29455E-03_JPRB,0.35211E-03_JPRB,0.35903E-03_JPRB,0.34997E-03_JPRB,0.32871E-03_JPRB, &
 & 0.29658E-03_JPRB,0.25454E-03_JPRB,0.20476E-03_JPRB,0.14404E-03_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.21327E-03_JPRB,0.24042E-03_JPRB,0.24026E-03_JPRB,0.23068E-03_JPRB,0.21276E-03_JPRB, &
 & 0.18665E-03_JPRB,0.15901E-03_JPRB,0.12570E-03_JPRB,0.94295E-04_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.22127E-03_JPRB,0.25493E-03_JPRB,0.25609E-03_JPRB,0.24693E-03_JPRB,0.22931E-03_JPRB, &
 & 0.20329E-03_JPRB,0.17265E-03_JPRB,0.13686E-03_JPRB,0.10535E-03_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.23042E-03_JPRB,0.26962E-03_JPRB,0.27233E-03_JPRB,0.26383E-03_JPRB,0.24677E-03_JPRB, &
 & 0.22030E-03_JPRB,0.18718E-03_JPRB,0.14788E-03_JPRB,0.11369E-03_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.24025E-03_JPRB,0.28500E-03_JPRB,0.28961E-03_JPRB,0.28171E-03_JPRB,0.26402E-03_JPRB, &
 & 0.23726E-03_JPRB,0.20232E-03_JPRB,0.16110E-03_JPRB,0.12526E-03_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.25035E-03_JPRB,0.30139E-03_JPRB,0.30818E-03_JPRB,0.30033E-03_JPRB,0.28246E-03_JPRB, &
 & 0.25541E-03_JPRB,0.21869E-03_JPRB,0.17592E-03_JPRB,0.13806E-03_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.18213E-03_JPRB,0.20563E-03_JPRB,0.20558E-03_JPRB,0.19744E-03_JPRB,0.18197E-03_JPRB, &
 & 0.15967E-03_JPRB,0.13562E-03_JPRB,0.10709E-03_JPRB,0.84300E-04_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.18873E-03_JPRB,0.21755E-03_JPRB,0.21877E-03_JPRB,0.21098E-03_JPRB,0.19617E-03_JPRB, &
 & 0.17419E-03_JPRB,0.14735E-03_JPRB,0.11726E-03_JPRB,0.96090E-04_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.19633E-03_JPRB,0.22994E-03_JPRB,0.23250E-03_JPRB,0.22538E-03_JPRB,0.21092E-03_JPRB, &
 & 0.18881E-03_JPRB,0.15987E-03_JPRB,0.12650E-03_JPRB,0.10477E-03_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.20445E-03_JPRB,0.24309E-03_JPRB,0.24729E-03_JPRB,0.24084E-03_JPRB,0.22613E-03_JPRB, &
 & 0.20371E-03_JPRB,0.17330E-03_JPRB,0.13785E-03_JPRB,0.11268E-03_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.21299E-03_JPRB,0.25719E-03_JPRB,0.26315E-03_JPRB,0.25711E-03_JPRB,0.24260E-03_JPRB, &
 & 0.21944E-03_JPRB,0.18764E-03_JPRB,0.15038E-03_JPRB,0.12367E-03_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.15527E-03_JPRB,0.17641E-03_JPRB,0.17566E-03_JPRB,0.16836E-03_JPRB,0.15534E-03_JPRB, &
 & 0.13636E-03_JPRB,0.11530E-03_JPRB,0.91307E-04_JPRB,0.70205E-04_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.16096E-03_JPRB,0.18612E-03_JPRB,0.18657E-03_JPRB,0.17973E-03_JPRB,0.16702E-03_JPRB, &
 & 0.14851E-03_JPRB,0.12550E-03_JPRB,0.99145E-04_JPRB,0.79984E-04_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.16748E-03_JPRB,0.19648E-03_JPRB,0.19822E-03_JPRB,0.19209E-03_JPRB,0.17957E-03_JPRB, &
 & 0.16107E-03_JPRB,0.13652E-03_JPRB,0.10753E-03_JPRB,0.86067E-04_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.17450E-03_JPRB,0.20751E-03_JPRB,0.21098E-03_JPRB,0.20534E-03_JPRB,0.19295E-03_JPRB, &
 & 0.17420E-03_JPRB,0.14816E-03_JPRB,0.11772E-03_JPRB,0.93252E-04_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.18233E-03_JPRB,0.21950E-03_JPRB,0.22442E-03_JPRB,0.21958E-03_JPRB,0.20754E-03_JPRB, &
 & 0.18842E-03_JPRB,0.16097E-03_JPRB,0.12851E-03_JPRB,0.10278E-03_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.23852E-02_JPRB,0.24955E-02_JPRB,0.25247E-02_JPRB,0.24784E-02_JPRB,0.23525E-02_JPRB, &
 & 0.21437E-02_JPRB,0.18704E-02_JPRB,0.15353E-02_JPRB,0.99116E-03_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.23950E-02_JPRB,0.25560E-02_JPRB,0.26150E-02_JPRB,0.25851E-02_JPRB,0.24612E-02_JPRB, &
 & 0.22632E-02_JPRB,0.20004E-02_JPRB,0.16585E-02_JPRB,0.11087E-02_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.24020E-02_JPRB,0.26226E-02_JPRB,0.27112E-02_JPRB,0.26940E-02_JPRB,0.25772E-02_JPRB, &
 & 0.23915E-02_JPRB,0.21332E-02_JPRB,0.17859E-02_JPRB,0.12435E-02_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.24093E-02_JPRB,0.26930E-02_JPRB,0.28096E-02_JPRB,0.28038E-02_JPRB,0.27017E-02_JPRB, &
 & 0.25227E-02_JPRB,0.22696E-02_JPRB,0.19198E-02_JPRB,0.13912E-02_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.24224E-02_JPRB,0.27647E-02_JPRB,0.29093E-02_JPRB,0.29173E-02_JPRB,0.28299E-02_JPRB, &
 & 0.26579E-02_JPRB,0.24103E-02_JPRB,0.20612E-02_JPRB,0.15535E-02_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.20974E-02_JPRB,0.22118E-02_JPRB,0.22296E-02_JPRB,0.21778E-02_JPRB,0.20625E-02_JPRB, &
 & 0.18815E-02_JPRB,0.16530E-02_JPRB,0.13562E-02_JPRB,0.82141E-03_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.21046E-02_JPRB,0.22702E-02_JPRB,0.23143E-02_JPRB,0.22813E-02_JPRB,0.21720E-02_JPRB, &
 & 0.19971E-02_JPRB,0.17712E-02_JPRB,0.14678E-02_JPRB,0.93003E-03_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.21127E-02_JPRB,0.23326E-02_JPRB,0.24062E-02_JPRB,0.23885E-02_JPRB,0.22861E-02_JPRB, &
 & 0.21193E-02_JPRB,0.18939E-02_JPRB,0.15834E-02_JPRB,0.10463E-02_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.21272E-02_JPRB,0.23971E-02_JPRB,0.25002E-02_JPRB,0.24977E-02_JPRB,0.24074E-02_JPRB, &
 & 0.22461E-02_JPRB,0.20177E-02_JPRB,0.17030E-02_JPRB,0.11732E-02_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.21483E-02_JPRB,0.24652E-02_JPRB,0.25947E-02_JPRB,0.26138E-02_JPRB,0.25341E-02_JPRB, &
 & 0.23755E-02_JPRB,0.21449E-02_JPRB,0.18299E-02_JPRB,0.13107E-02_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.18244E-02_JPRB,0.19320E-02_JPRB,0.19387E-02_JPRB,0.18795E-02_JPRB,0.17712E-02_JPRB, &
 & 0.16188E-02_JPRB,0.14258E-02_JPRB,0.11664E-02_JPRB,0.66404E-03_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.18322E-02_JPRB,0.19846E-02_JPRB,0.20150E-02_JPRB,0.19741E-02_JPRB,0.18746E-02_JPRB, &
 & 0.17292E-02_JPRB,0.15311E-02_JPRB,0.12668E-02_JPRB,0.75772E-03_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.18451E-02_JPRB,0.20412E-02_JPRB,0.20960E-02_JPRB,0.20746E-02_JPRB,0.19871E-02_JPRB, &
 & 0.18444E-02_JPRB,0.16430E-02_JPRB,0.13711E-02_JPRB,0.85470E-03_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.18657E-02_JPRB,0.21020E-02_JPRB,0.21815E-02_JPRB,0.21798E-02_JPRB,0.21034E-02_JPRB, &
 & 0.19629E-02_JPRB,0.17571E-02_JPRB,0.14786E-02_JPRB,0.95834E-03_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.18943E-02_JPRB,0.21674E-02_JPRB,0.22717E-02_JPRB,0.22915E-02_JPRB,0.22239E-02_JPRB, &
 & 0.20844E-02_JPRB,0.18739E-02_JPRB,0.15906E-02_JPRB,0.10775E-02_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.15758E-02_JPRB,0.16711E-02_JPRB,0.16675E-02_JPRB,0.16043E-02_JPRB,0.15088E-02_JPRB, &
 & 0.13785E-02_JPRB,0.12140E-02_JPRB,0.98780E-03_JPRB,0.53258E-03_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.15867E-02_JPRB,0.17169E-02_JPRB,0.17338E-02_JPRB,0.16891E-02_JPRB,0.16022E-02_JPRB, &
 & 0.14807E-02_JPRB,0.13108E-02_JPRB,0.10774E-02_JPRB,0.61127E-03_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.16043E-02_JPRB,0.17687E-02_JPRB,0.18047E-02_JPRB,0.17788E-02_JPRB,0.17054E-02_JPRB, &
 & 0.15869E-02_JPRB,0.14121E-02_JPRB,0.11700E-02_JPRB,0.69092E-03_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.16308E-02_JPRB,0.18263E-02_JPRB,0.18817E-02_JPRB,0.18741E-02_JPRB,0.18139E-02_JPRB, &
 & 0.16955E-02_JPRB,0.15162E-02_JPRB,0.12673E-02_JPRB,0.77859E-03_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.16631E-02_JPRB,0.18894E-02_JPRB,0.19653E-02_JPRB,0.19764E-02_JPRB,0.19240E-02_JPRB, &
 & 0.18069E-02_JPRB,0.16237E-02_JPRB,0.13697E-02_JPRB,0.87657E-03_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.13575E-02_JPRB,0.14376E-02_JPRB,0.14238E-02_JPRB,0.13660E-02_JPRB,0.12806E-02_JPRB, &
 & 0.11664E-02_JPRB,0.10231E-02_JPRB,0.82794E-03_JPRB,0.42595E-03_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.13711E-02_JPRB,0.14787E-02_JPRB,0.14807E-02_JPRB,0.14369E-02_JPRB,0.13637E-02_JPRB, &
 & 0.12570E-02_JPRB,0.11125E-02_JPRB,0.90729E-03_JPRB,0.48990E-03_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.13932E-02_JPRB,0.15262E-02_JPRB,0.15434E-02_JPRB,0.15158E-02_JPRB,0.14536E-02_JPRB, &
 & 0.13534E-02_JPRB,0.12033E-02_JPRB,0.99132E-03_JPRB,0.55848E-03_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.14217E-02_JPRB,0.15804E-02_JPRB,0.16130E-02_JPRB,0.16009E-02_JPRB,0.15482E-02_JPRB, &
 & 0.14537E-02_JPRB,0.12991E-02_JPRB,0.10796E-02_JPRB,0.63246E-03_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.14548E-02_JPRB,0.16406E-02_JPRB,0.16899E-02_JPRB,0.16924E-02_JPRB,0.16473E-02_JPRB, &
 & 0.15538E-02_JPRB,0.13988E-02_JPRB,0.11736E-02_JPRB,0.71422E-03_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.11657E-02_JPRB,0.12310E-02_JPRB,0.12114E-02_JPRB,0.11593E-02_JPRB,0.10807E-02_JPRB, &
 & 0.97870E-03_JPRB,0.85220E-03_JPRB,0.68679E-03_JPRB,0.33278E-03_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.11817E-02_JPRB,0.12689E-02_JPRB,0.12606E-02_JPRB,0.12200E-02_JPRB,0.11515E-02_JPRB, &
 & 0.10575E-02_JPRB,0.93300E-03_JPRB,0.75653E-03_JPRB,0.38390E-03_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.12052E-02_JPRB,0.13132E-02_JPRB,0.13166E-02_JPRB,0.12868E-02_JPRB,0.12281E-02_JPRB, &
 & 0.11419E-02_JPRB,0.10150E-02_JPRB,0.83054E-03_JPRB,0.44291E-03_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.12337E-02_JPRB,0.13638E-02_JPRB,0.13800E-02_JPRB,0.13608E-02_JPRB,0.13105E-02_JPRB, &
 & 0.12294E-02_JPRB,0.11010E-02_JPRB,0.91218E-03_JPRB,0.50714E-03_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.12657E-02_JPRB,0.14200E-02_JPRB,0.14498E-02_JPRB,0.14421E-02_JPRB,0.13994E-02_JPRB, &
 & 0.13201E-02_JPRB,0.11915E-02_JPRB,0.99447E-03_JPRB,0.57759E-03_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.99495E-03_JPRB,0.10489E-02_JPRB,0.10293E-02_JPRB,0.98184E-03_JPRB,0.91156E-03_JPRB, &
 & 0.82083E-03_JPRB,0.70758E-03_JPRB,0.56387E-03_JPRB,0.26025E-03_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.10122E-02_JPRB,0.10837E-02_JPRB,0.10724E-02_JPRB,0.10344E-02_JPRB,0.96982E-03_JPRB, &
 & 0.88589E-03_JPRB,0.77530E-03_JPRB,0.62605E-03_JPRB,0.29914E-03_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.10351E-02_JPRB,0.11253E-02_JPRB,0.11236E-02_JPRB,0.10922E-02_JPRB,0.10352E-02_JPRB, &
 & 0.95724E-03_JPRB,0.84889E-03_JPRB,0.69076E-03_JPRB,0.34305E-03_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.10622E-02_JPRB,0.11721E-02_JPRB,0.11813E-02_JPRB,0.11564E-02_JPRB,0.11065E-02_JPRB, &
 & 0.10331E-02_JPRB,0.92494E-03_JPRB,0.76297E-03_JPRB,0.39175E-03_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.10903E-02_JPRB,0.12244E-02_JPRB,0.12441E-02_JPRB,0.12287E-02_JPRB,0.11845E-02_JPRB, &
 & 0.11129E-02_JPRB,0.10035E-02_JPRB,0.83648E-03_JPRB,0.44712E-03_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.84532E-03_JPRB,0.88892E-03_JPRB,0.86965E-03_JPRB,0.82727E-03_JPRB,0.76674E-03_JPRB, &
 & 0.68807E-03_JPRB,0.58679E-03_JPRB,0.46179E-03_JPRB,0.21931E-03_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.86227E-03_JPRB,0.92051E-03_JPRB,0.90826E-03_JPRB,0.87315E-03_JPRB,0.81675E-03_JPRB, &
 & 0.74173E-03_JPRB,0.64502E-03_JPRB,0.51436E-03_JPRB,0.25538E-03_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.88387E-03_JPRB,0.95827E-03_JPRB,0.95473E-03_JPRB,0.92480E-03_JPRB,0.87135E-03_JPRB, &
 & 0.80090E-03_JPRB,0.70594E-03_JPRB,0.57141E-03_JPRB,0.29275E-03_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.90659E-03_JPRB,0.10014E-02_JPRB,0.10072E-02_JPRB,0.98186E-03_JPRB,0.93348E-03_JPRB, &
 & 0.86582E-03_JPRB,0.77148E-03_JPRB,0.63431E-03_JPRB,0.33522E-03_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.93066E-03_JPRB,0.10477E-02_JPRB,0.10640E-02_JPRB,0.10456E-02_JPRB,0.10022E-02_JPRB, &
 & 0.93597E-03_JPRB,0.84005E-03_JPRB,0.69831E-03_JPRB,0.38214E-03_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.71681E-03_JPRB,0.75151E-03_JPRB,0.73165E-03_JPRB,0.69303E-03_JPRB,0.64106E-03_JPRB, &
 & 0.57326E-03_JPRB,0.48762E-03_JPRB,0.37724E-03_JPRB,0.19963E-03_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.73278E-03_JPRB,0.77936E-03_JPRB,0.76580E-03_JPRB,0.73272E-03_JPRB,0.68369E-03_JPRB, &
 & 0.61851E-03_JPRB,0.53463E-03_JPRB,0.42190E-03_JPRB,0.23258E-03_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.75147E-03_JPRB,0.81327E-03_JPRB,0.80692E-03_JPRB,0.77827E-03_JPRB,0.73101E-03_JPRB, &
 & 0.66869E-03_JPRB,0.58582E-03_JPRB,0.47030E-03_JPRB,0.26770E-03_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.77011E-03_JPRB,0.85035E-03_JPRB,0.85331E-03_JPRB,0.82912E-03_JPRB,0.78414E-03_JPRB, &
 & 0.72425E-03_JPRB,0.64047E-03_JPRB,0.52434E-03_JPRB,0.30603E-03_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.79031E-03_JPRB,0.89033E-03_JPRB,0.90223E-03_JPRB,0.88462E-03_JPRB,0.84489E-03_JPRB, &
 & 0.78478E-03_JPRB,0.70032E-03_JPRB,0.57826E-03_JPRB,0.34848E-03_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.60860E-03_JPRB,0.63631E-03_JPRB,0.61722E-03_JPRB,0.58182E-03_JPRB,0.53631E-03_JPRB, &
 & 0.47875E-03_JPRB,0.40598E-03_JPRB,0.31001E-03_JPRB,0.21716E-03_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.62300E-03_JPRB,0.66096E-03_JPRB,0.64723E-03_JPRB,0.61624E-03_JPRB,0.57283E-03_JPRB, &
 & 0.51614E-03_JPRB,0.44515E-03_JPRB,0.34783E-03_JPRB,0.24030E-03_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.63811E-03_JPRB,0.69041E-03_JPRB,0.68320E-03_JPRB,0.65609E-03_JPRB,0.61386E-03_JPRB, &
 & 0.55902E-03_JPRB,0.48770E-03_JPRB,0.38933E-03_JPRB,0.26729E-03_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.65360E-03_JPRB,0.72213E-03_JPRB,0.72254E-03_JPRB,0.70011E-03_JPRB,0.66034E-03_JPRB, &
 & 0.60659E-03_JPRB,0.53507E-03_JPRB,0.43477E-03_JPRB,0.29849E-03_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.67038E-03_JPRB,0.75665E-03_JPRB,0.76418E-03_JPRB,0.74727E-03_JPRB,0.71207E-03_JPRB, &
 & 0.65924E-03_JPRB,0.58660E-03_JPRB,0.48108E-03_JPRB,0.33464E-03_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.52185E-03_JPRB,0.54797E-03_JPRB,0.53190E-03_JPRB,0.50128E-03_JPRB,0.46230E-03_JPRB, &
 & 0.41291E-03_JPRB,0.35086E-03_JPRB,0.26843E-03_JPRB,0.22407E-03_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.53416E-03_JPRB,0.57111E-03_JPRB,0.56029E-03_JPRB,0.53286E-03_JPRB,0.49524E-03_JPRB, &
 & 0.44633E-03_JPRB,0.38530E-03_JPRB,0.30138E-03_JPRB,0.24793E-03_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.54635E-03_JPRB,0.59685E-03_JPRB,0.59183E-03_JPRB,0.56852E-03_JPRB,0.53236E-03_JPRB, &
 & 0.48455E-03_JPRB,0.42287E-03_JPRB,0.33910E-03_JPRB,0.27073E-03_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.55941E-03_JPRB,0.62493E-03_JPRB,0.62582E-03_JPRB,0.60673E-03_JPRB,0.57348E-03_JPRB, &
 & 0.52713E-03_JPRB,0.46523E-03_JPRB,0.37861E-03_JPRB,0.29520E-03_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.57459E-03_JPRB,0.65537E-03_JPRB,0.66217E-03_JPRB,0.64854E-03_JPRB,0.61857E-03_JPRB, &
 & 0.57343E-03_JPRB,0.51159E-03_JPRB,0.41997E-03_JPRB,0.32408E-03_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.44547E-03_JPRB,0.47205E-03_JPRB,0.45856E-03_JPRB,0.43259E-03_JPRB,0.39885E-03_JPRB, &
 & 0.35629E-03_JPRB,0.30273E-03_JPRB,0.23099E-03_JPRB,0.20507E-03_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.45530E-03_JPRB,0.49200E-03_JPRB,0.48355E-03_JPRB,0.46058E-03_JPRB,0.42831E-03_JPRB, &
 & 0.38615E-03_JPRB,0.33301E-03_JPRB,0.25970E-03_JPRB,0.22582E-03_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.46565E-03_JPRB,0.51443E-03_JPRB,0.51077E-03_JPRB,0.49108E-03_JPRB,0.46067E-03_JPRB, &
 & 0.41962E-03_JPRB,0.36657E-03_JPRB,0.29355E-03_JPRB,0.24853E-03_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.47732E-03_JPRB,0.53905E-03_JPRB,0.54027E-03_JPRB,0.52415E-03_JPRB,0.49634E-03_JPRB, &
 & 0.45650E-03_JPRB,0.40422E-03_JPRB,0.32887E-03_JPRB,0.26943E-03_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.49131E-03_JPRB,0.56624E-03_JPRB,0.57259E-03_JPRB,0.56091E-03_JPRB,0.53532E-03_JPRB, &
 & 0.49724E-03_JPRB,0.44494E-03_JPRB,0.36671E-03_JPRB,0.29370E-03_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.37861E-03_JPRB,0.40433E-03_JPRB,0.39425E-03_JPRB,0.37277E-03_JPRB,0.34384E-03_JPRB, &
 & 0.30718E-03_JPRB,0.26082E-03_JPRB,0.19813E-03_JPRB,0.17021E-03_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.38646E-03_JPRB,0.42180E-03_JPRB,0.41569E-03_JPRB,0.39676E-03_JPRB,0.36941E-03_JPRB, &
 & 0.33370E-03_JPRB,0.28746E-03_JPRB,0.22445E-03_JPRB,0.18768E-03_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.39522E-03_JPRB,0.44150E-03_JPRB,0.43928E-03_JPRB,0.42293E-03_JPRB,0.39746E-03_JPRB, &
 & 0.36268E-03_JPRB,0.31709E-03_JPRB,0.25391E-03_JPRB,0.20463E-03_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.40576E-03_JPRB,0.46362E-03_JPRB,0.46497E-03_JPRB,0.45178E-03_JPRB,0.42852E-03_JPRB, &
 & 0.39486E-03_JPRB,0.34992E-03_JPRB,0.28472E-03_JPRB,0.22430E-03_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.41810E-03_JPRB,0.48813E-03_JPRB,0.49424E-03_JPRB,0.48434E-03_JPRB,0.46280E-03_JPRB, &
 & 0.43027E-03_JPRB,0.38540E-03_JPRB,0.31863E-03_JPRB,0.24541E-03_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.52571E-02_JPRB,0.51649E-02_JPRB,0.50998E-02_JPRB,0.49978E-02_JPRB,0.48299E-02_JPRB, &
 & 0.45478E-02_JPRB,0.41071E-02_JPRB,0.34884E-02_JPRB,0.27402E-02_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.51967E-02_JPRB,0.52277E-02_JPRB,0.52437E-02_JPRB,0.52099E-02_JPRB,0.50894E-02_JPRB, &
 & 0.48424E-02_JPRB,0.44165E-02_JPRB,0.38421E-02_JPRB,0.31643E-02_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.51548E-02_JPRB,0.53047E-02_JPRB,0.54023E-02_JPRB,0.54271E-02_JPRB,0.53544E-02_JPRB, &
 & 0.51370E-02_JPRB,0.47457E-02_JPRB,0.42178E-02_JPRB,0.36142E-02_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.51293E-02_JPRB,0.53942E-02_JPRB,0.55672E-02_JPRB,0.56512E-02_JPRB,0.56201E-02_JPRB, &
 & 0.54409E-02_JPRB,0.50927E-02_JPRB,0.46186E-02_JPRB,0.40998E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART6',0,ZHOOK_HANDLE)


KA(:, 5, 1, 8) = (/ &
 & 0.51178E-02_JPRB,0.54996E-02_JPRB,0.57406E-02_JPRB,0.58798E-02_JPRB,0.58932E-02_JPRB, &
 & 0.57606E-02_JPRB,0.54613E-02_JPRB,0.50399E-02_JPRB,0.46100E-02_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.47778E-02_JPRB,0.47398E-02_JPRB,0.47115E-02_JPRB,0.46169E-02_JPRB,0.44426E-02_JPRB, &
 & 0.41630E-02_JPRB,0.37511E-02_JPRB,0.31426E-02_JPRB,0.23122E-02_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.47384E-02_JPRB,0.48111E-02_JPRB,0.48532E-02_JPRB,0.48144E-02_JPRB,0.46755E-02_JPRB, &
 & 0.44342E-02_JPRB,0.40397E-02_JPRB,0.34599E-02_JPRB,0.26698E-02_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.47181E-02_JPRB,0.49025E-02_JPRB,0.50071E-02_JPRB,0.50151E-02_JPRB,0.49194E-02_JPRB, &
 & 0.47085E-02_JPRB,0.43402E-02_JPRB,0.37956E-02_JPRB,0.30630E-02_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.47137E-02_JPRB,0.50070E-02_JPRB,0.51691E-02_JPRB,0.52245E-02_JPRB,0.51706E-02_JPRB, &
 & 0.49959E-02_JPRB,0.46583E-02_JPRB,0.41574E-02_JPRB,0.34865E-02_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.47212E-02_JPRB,0.51234E-02_JPRB,0.53397E-02_JPRB,0.54379E-02_JPRB,0.54276E-02_JPRB, &
 & 0.52983E-02_JPRB,0.49978E-02_JPRB,0.45412E-02_JPRB,0.39357E-02_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.42971E-02_JPRB,0.42851E-02_JPRB,0.42729E-02_JPRB,0.41707E-02_JPRB,0.39926E-02_JPRB, &
 & 0.37146E-02_JPRB,0.33264E-02_JPRB,0.27717E-02_JPRB,0.18852E-02_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.42740E-02_JPRB,0.43647E-02_JPRB,0.44079E-02_JPRB,0.43562E-02_JPRB,0.42040E-02_JPRB, &
 & 0.39559E-02_JPRB,0.35908E-02_JPRB,0.30443E-02_JPRB,0.21816E-02_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.42703E-02_JPRB,0.44650E-02_JPRB,0.45616E-02_JPRB,0.45425E-02_JPRB,0.44233E-02_JPRB, &
 & 0.42066E-02_JPRB,0.38676E-02_JPRB,0.33396E-02_JPRB,0.25126E-02_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.42812E-02_JPRB,0.45806E-02_JPRB,0.47230E-02_JPRB,0.47371E-02_JPRB,0.46519E-02_JPRB, &
 & 0.44691E-02_JPRB,0.41620E-02_JPRB,0.36586E-02_JPRB,0.28704E-02_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.43030E-02_JPRB,0.47042E-02_JPRB,0.48922E-02_JPRB,0.49377E-02_JPRB,0.48939E-02_JPRB, &
 & 0.47477E-02_JPRB,0.44742E-02_JPRB,0.39985E-02_JPRB,0.32501E-02_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.38233E-02_JPRB,0.38279E-02_JPRB,0.38143E-02_JPRB,0.37097E-02_JPRB,0.35270E-02_JPRB, &
 & 0.32658E-02_JPRB,0.29019E-02_JPRB,0.24142E-02_JPRB,0.15291E-02_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.38114E-02_JPRB,0.39122E-02_JPRB,0.39475E-02_JPRB,0.38778E-02_JPRB,0.37194E-02_JPRB, &
 & 0.34777E-02_JPRB,0.31357E-02_JPRB,0.26541E-02_JPRB,0.17758E-02_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.38202E-02_JPRB,0.40186E-02_JPRB,0.40970E-02_JPRB,0.40542E-02_JPRB,0.39201E-02_JPRB, &
 & 0.37024E-02_JPRB,0.33826E-02_JPRB,0.29146E-02_JPRB,0.20543E-02_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.38442E-02_JPRB,0.41385E-02_JPRB,0.42569E-02_JPRB,0.42394E-02_JPRB,0.41310E-02_JPRB, &
 & 0.39403E-02_JPRB,0.36479E-02_JPRB,0.31917E-02_JPRB,0.23538E-02_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.38788E-02_JPRB,0.42695E-02_JPRB,0.44229E-02_JPRB,0.44328E-02_JPRB,0.43540E-02_JPRB, &
 & 0.41948E-02_JPRB,0.39317E-02_JPRB,0.34895E-02_JPRB,0.26724E-02_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.33660E-02_JPRB,0.33879E-02_JPRB,0.33669E-02_JPRB,0.32570E-02_JPRB,0.30787E-02_JPRB, &
 & 0.28362E-02_JPRB,0.25094E-02_JPRB,0.20819E-02_JPRB,0.12376E-02_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.33649E-02_JPRB,0.34740E-02_JPRB,0.34949E-02_JPRB,0.34119E-02_JPRB,0.32508E-02_JPRB, &
 & 0.30247E-02_JPRB,0.27121E-02_JPRB,0.22949E-02_JPRB,0.14462E-02_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.33839E-02_JPRB,0.35821E-02_JPRB,0.36398E-02_JPRB,0.35762E-02_JPRB,0.34359E-02_JPRB, &
 & 0.32230E-02_JPRB,0.29317E-02_JPRB,0.25218E-02_JPRB,0.16788E-02_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.34188E-02_JPRB,0.37047E-02_JPRB,0.37932E-02_JPRB,0.37524E-02_JPRB,0.36321E-02_JPRB, &
 & 0.34359E-02_JPRB,0.31677E-02_JPRB,0.27663E-02_JPRB,0.19299E-02_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.34572E-02_JPRB,0.38382E-02_JPRB,0.39563E-02_JPRB,0.39381E-02_JPRB,0.38416E-02_JPRB, &
 & 0.36710E-02_JPRB,0.34185E-02_JPRB,0.30298E-02_JPRB,0.21985E-02_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.29383E-02_JPRB,0.29689E-02_JPRB,0.29375E-02_JPRB,0.28254E-02_JPRB,0.26571E-02_JPRB, &
 & 0.24356E-02_JPRB,0.21491E-02_JPRB,0.17706E-02_JPRB,0.99284E-03_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.29460E-02_JPRB,0.30526E-02_JPRB,0.30576E-02_JPRB,0.29676E-02_JPRB,0.28114E-02_JPRB, &
 & 0.25995E-02_JPRB,0.23244E-02_JPRB,0.19573E-02_JPRB,0.11692E-02_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.29740E-02_JPRB,0.31582E-02_JPRB,0.31942E-02_JPRB,0.31202E-02_JPRB,0.29785E-02_JPRB, &
 & 0.27771E-02_JPRB,0.25160E-02_JPRB,0.21565E-02_JPRB,0.13616E-02_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.30101E-02_JPRB,0.32807E-02_JPRB,0.33417E-02_JPRB,0.32855E-02_JPRB,0.31583E-02_JPRB, &
 & 0.29708E-02_JPRB,0.27234E-02_JPRB,0.23688E-02_JPRB,0.15696E-02_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.30525E-02_JPRB,0.34071E-02_JPRB,0.34999E-02_JPRB,0.34618E-02_JPRB,0.33518E-02_JPRB, &
 & 0.31829E-02_JPRB,0.29437E-02_JPRB,0.25986E-02_JPRB,0.17941E-02_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.25527E-02_JPRB,0.25837E-02_JPRB,0.25415E-02_JPRB,0.24332E-02_JPRB,0.22747E-02_JPRB, &
 & 0.20758E-02_JPRB,0.18231E-02_JPRB,0.14951E-02_JPRB,0.78066E-03_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.25661E-02_JPRB,0.26638E-02_JPRB,0.26497E-02_JPRB,0.25583E-02_JPRB,0.24134E-02_JPRB, &
 & 0.22212E-02_JPRB,0.19774E-02_JPRB,0.16540E-02_JPRB,0.92809E-03_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.25966E-02_JPRB,0.27642E-02_JPRB,0.27764E-02_JPRB,0.26998E-02_JPRB,0.25630E-02_JPRB, &
 & 0.23812E-02_JPRB,0.21449E-02_JPRB,0.18264E-02_JPRB,0.10893E-02_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.26340E-02_JPRB,0.28771E-02_JPRB,0.29165E-02_JPRB,0.28538E-02_JPRB,0.27279E-02_JPRB, &
 & 0.25553E-02_JPRB,0.23260E-02_JPRB,0.20107E-02_JPRB,0.12665E-02_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.26829E-02_JPRB,0.29939E-02_JPRB,0.30639E-02_JPRB,0.30192E-02_JPRB,0.29089E-02_JPRB, &
 & 0.27450E-02_JPRB,0.25219E-02_JPRB,0.22101E-02_JPRB,0.14584E-02_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.22109E-02_JPRB,0.22392E-02_JPRB,0.21909E-02_JPRB,0.20870E-02_JPRB,0.19391E-02_JPRB, &
 & 0.17569E-02_JPRB,0.15368E-02_JPRB,0.12514E-02_JPRB,0.62879E-03_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.22276E-02_JPRB,0.23140E-02_JPRB,0.22874E-02_JPRB,0.21965E-02_JPRB,0.20609E-02_JPRB, &
 & 0.18868E-02_JPRB,0.16711E-02_JPRB,0.13887E-02_JPRB,0.73533E-03_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.22565E-02_JPRB,0.24065E-02_JPRB,0.24031E-02_JPRB,0.23233E-02_JPRB,0.21969E-02_JPRB, &
 & 0.20302E-02_JPRB,0.18188E-02_JPRB,0.15365E-02_JPRB,0.85609E-03_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.22974E-02_JPRB,0.25072E-02_JPRB,0.25290E-02_JPRB,0.24653E-02_JPRB,0.23482E-02_JPRB, &
 & 0.21882E-02_JPRB,0.19777E-02_JPRB,0.16966E-02_JPRB,0.98553E-03_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.23517E-02_JPRB,0.26173E-02_JPRB,0.26619E-02_JPRB,0.26145E-02_JPRB,0.25139E-02_JPRB, &
 & 0.23587E-02_JPRB,0.21497E-02_JPRB,0.18671E-02_JPRB,0.11277E-02_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.19109E-02_JPRB,0.19351E-02_JPRB,0.18847E-02_JPRB,0.17853E-02_JPRB,0.16484E-02_JPRB, &
 & 0.14828E-02_JPRB,0.12861E-02_JPRB,0.10403E-02_JPRB,0.59847E-03_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.19272E-02_JPRB,0.20031E-02_JPRB,0.19691E-02_JPRB,0.18817E-02_JPRB,0.17540E-02_JPRB, &
 & 0.15965E-02_JPRB,0.14036E-02_JPRB,0.11571E-02_JPRB,0.69475E-03_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.19559E-02_JPRB,0.20842E-02_JPRB,0.20709E-02_JPRB,0.19954E-02_JPRB,0.18765E-02_JPRB, &
 & 0.17233E-02_JPRB,0.15331E-02_JPRB,0.12839E-02_JPRB,0.80150E-03_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.19994E-02_JPRB,0.21761E-02_JPRB,0.21815E-02_JPRB,0.21203E-02_JPRB,0.20143E-02_JPRB, &
 & 0.18645E-02_JPRB,0.16732E-02_JPRB,0.14206E-02_JPRB,0.91777E-03_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.20550E-02_JPRB,0.22788E-02_JPRB,0.23027E-02_JPRB,0.22546E-02_JPRB,0.21605E-02_JPRB, &
 & 0.20175E-02_JPRB,0.18247E-02_JPRB,0.15687E-02_JPRB,0.10450E-02_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.16445E-02_JPRB,0.16716E-02_JPRB,0.16238E-02_JPRB,0.15300E-02_JPRB,0.14061E-02_JPRB, &
 & 0.12566E-02_JPRB,0.10807E-02_JPRB,0.86738E-03_JPRB,0.60827E-03_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.16600E-02_JPRB,0.17327E-02_JPRB,0.16984E-02_JPRB,0.16154E-02_JPRB,0.14994E-02_JPRB, &
 & 0.13556E-02_JPRB,0.11827E-02_JPRB,0.96695E-03_JPRB,0.70548E-03_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.16905E-02_JPRB,0.18053E-02_JPRB,0.17869E-02_JPRB,0.17163E-02_JPRB,0.16090E-02_JPRB, &
 & 0.14689E-02_JPRB,0.12961E-02_JPRB,0.10754E-02_JPRB,0.80786E-03_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.17354E-02_JPRB,0.18905E-02_JPRB,0.18865E-02_JPRB,0.18272E-02_JPRB,0.17299E-02_JPRB, &
 & 0.15951E-02_JPRB,0.14192E-02_JPRB,0.11936E-02_JPRB,0.91620E-03_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.17884E-02_JPRB,0.19860E-02_JPRB,0.19977E-02_JPRB,0.19501E-02_JPRB,0.18596E-02_JPRB, &
 & 0.17298E-02_JPRB,0.15525E-02_JPRB,0.13217E-02_JPRB,0.10338E-02_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.14133E-02_JPRB,0.14603E-02_JPRB,0.14202E-02_JPRB,0.13407E-02_JPRB,0.12334E-02_JPRB, &
 & 0.11026E-02_JPRB,0.94643E-03_JPRB,0.75979E-03_JPRB,0.57405E-03_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.14357E-02_JPRB,0.15193E-02_JPRB,0.14916E-02_JPRB,0.14232E-02_JPRB,0.13232E-02_JPRB, &
 & 0.11950E-02_JPRB,0.10392E-02_JPRB,0.84686E-03_JPRB,0.65471E-03_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.14730E-02_JPRB,0.15907E-02_JPRB,0.15765E-02_JPRB,0.15172E-02_JPRB,0.14237E-02_JPRB, &
 & 0.12997E-02_JPRB,0.11424E-02_JPRB,0.94298E-03_JPRB,0.75212E-03_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.15188E-02_JPRB,0.16737E-02_JPRB,0.16734E-02_JPRB,0.16227E-02_JPRB,0.15348E-02_JPRB, &
 & 0.14132E-02_JPRB,0.12544E-02_JPRB,0.10476E-02_JPRB,0.85445E-03_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.15705E-02_JPRB,0.17634E-02_JPRB,0.17799E-02_JPRB,0.17387E-02_JPRB,0.16551E-02_JPRB, &
 & 0.15344E-02_JPRB,0.13744E-02_JPRB,0.11635E-02_JPRB,0.96358E-03_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.12145E-02_JPRB,0.12721E-02_JPRB,0.12387E-02_JPRB,0.11722E-02_JPRB,0.10815E-02_JPRB, &
 & 0.96748E-03_JPRB,0.83052E-03_JPRB,0.66461E-03_JPRB,0.51952E-03_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.12432E-02_JPRB,0.13303E-02_JPRB,0.13076E-02_JPRB,0.12500E-02_JPRB,0.11644E-02_JPRB, &
 & 0.10531E-02_JPRB,0.91410E-03_JPRB,0.74198E-03_JPRB,0.58718E-03_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.12811E-02_JPRB,0.13998E-02_JPRB,0.13897E-02_JPRB,0.13394E-02_JPRB,0.12574E-02_JPRB, &
 & 0.11474E-02_JPRB,0.10067E-02_JPRB,0.82675E-03_JPRB,0.66821E-03_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.13251E-02_JPRB,0.14771E-02_JPRB,0.14813E-02_JPRB,0.14393E-02_JPRB,0.13610E-02_JPRB, &
 & 0.12504E-02_JPRB,0.11057E-02_JPRB,0.91975E-03_JPRB,0.76078E-03_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.13700E-02_JPRB,0.15597E-02_JPRB,0.15807E-02_JPRB,0.15467E-02_JPRB,0.14716E-02_JPRB, &
 & 0.13608E-02_JPRB,0.12138E-02_JPRB,0.10232E-02_JPRB,0.85832E-03_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.10471E-02_JPRB,0.11076E-02_JPRB,0.10790E-02_JPRB,0.10231E-02_JPRB,0.94527E-03_JPRB, &
 & 0.84789E-03_JPRB,0.72861E-03_JPRB,0.58068E-03_JPRB,0.44361E-03_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.10765E-02_JPRB,0.11637E-02_JPRB,0.11461E-02_JPRB,0.10966E-02_JPRB,0.10221E-02_JPRB, &
 & 0.92418E-03_JPRB,0.80364E-03_JPRB,0.64949E-03_JPRB,0.50409E-03_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.11121E-02_JPRB,0.12288E-02_JPRB,0.12232E-02_JPRB,0.11802E-02_JPRB,0.11084E-02_JPRB, &
 & 0.10099E-02_JPRB,0.88562E-03_JPRB,0.72467E-03_JPRB,0.57688E-03_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.11491E-02_JPRB,0.12989E-02_JPRB,0.13080E-02_JPRB,0.12720E-02_JPRB,0.12030E-02_JPRB, &
 & 0.11037E-02_JPRB,0.97404E-03_JPRB,0.80781E-03_JPRB,0.65303E-03_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.11880E-02_JPRB,0.13724E-02_JPRB,0.13975E-02_JPRB,0.13701E-02_JPRB,0.13034E-02_JPRB, &
 & 0.12049E-02_JPRB,0.10715E-02_JPRB,0.89944E-03_JPRB,0.73687E-03_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.14418E-01_JPRB,0.13406E-01_JPRB,0.12605E-01_JPRB,0.11857E-01_JPRB,0.11091E-01_JPRB, &
 & 0.10336E-01_JPRB,0.95691E-02_JPRB,0.87036E-02_JPRB,0.88524E-02_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.14296E-01_JPRB,0.13450E-01_JPRB,0.12870E-01_JPRB,0.12297E-01_JPRB,0.11684E-01_JPRB, &
 & 0.11070E-01_JPRB,0.10452E-01_JPRB,0.97477E-02_JPRB,0.10154E-01_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.14166E-01_JPRB,0.13524E-01_JPRB,0.13158E-01_JPRB,0.12768E-01_JPRB,0.12317E-01_JPRB, &
 & 0.11876E-01_JPRB,0.11397E-01_JPRB,0.10864E-01_JPRB,0.11523E-01_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.14022E-01_JPRB,0.13622E-01_JPRB,0.13487E-01_JPRB,0.13264E-01_JPRB,0.13003E-01_JPRB, &
 & 0.12732E-01_JPRB,0.12371E-01_JPRB,0.12050E-01_JPRB,0.12968E-01_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.13872E-01_JPRB,0.13730E-01_JPRB,0.13820E-01_JPRB,0.13802E-01_JPRB,0.13718E-01_JPRB, &
 & 0.13604E-01_JPRB,0.13373E-01_JPRB,0.13315E-01_JPRB,0.14498E-01_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.14547E-01_JPRB,0.13535E-01_JPRB,0.12726E-01_JPRB,0.11955E-01_JPRB,0.11121E-01_JPRB, &
 & 0.10242E-01_JPRB,0.92998E-02_JPRB,0.82716E-02_JPRB,0.79571E-02_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.14415E-01_JPRB,0.13577E-01_JPRB,0.12984E-01_JPRB,0.12377E-01_JPRB,0.11698E-01_JPRB, &
 & 0.10932E-01_JPRB,0.10129E-01_JPRB,0.92199E-02_JPRB,0.91565E-02_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.14274E-01_JPRB,0.13649E-01_JPRB,0.13264E-01_JPRB,0.12845E-01_JPRB,0.12290E-01_JPRB, &
 & 0.11686E-01_JPRB,0.11026E-01_JPRB,0.10231E-01_JPRB,0.10415E-01_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.14122E-01_JPRB,0.13744E-01_JPRB,0.13589E-01_JPRB,0.13325E-01_JPRB,0.12935E-01_JPRB, &
 & 0.12484E-01_JPRB,0.11950E-01_JPRB,0.11311E-01_JPRB,0.11744E-01_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.13965E-01_JPRB,0.13855E-01_JPRB,0.13924E-01_JPRB,0.13828E-01_JPRB,0.13608E-01_JPRB, &
 & 0.13305E-01_JPRB,0.12905E-01_JPRB,0.12457E-01_JPRB,0.13151E-01_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.14475E-01_JPRB,0.13482E-01_JPRB,0.12654E-01_JPRB,0.11861E-01_JPRB,0.10971E-01_JPRB, &
 & 0.99930E-02_JPRB,0.88735E-02_JPRB,0.76595E-02_JPRB,0.68509E-02_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.14335E-01_JPRB,0.13514E-01_JPRB,0.12906E-01_JPRB,0.12263E-01_JPRB,0.11533E-01_JPRB, &
 & 0.10637E-01_JPRB,0.96386E-02_JPRB,0.85394E-02_JPRB,0.79297E-02_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.14181E-01_JPRB,0.13576E-01_JPRB,0.13177E-01_JPRB,0.12719E-01_JPRB,0.12099E-01_JPRB, &
 & 0.11329E-01_JPRB,0.10466E-01_JPRB,0.94601E-02_JPRB,0.90731E-02_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.14024E-01_JPRB,0.13665E-01_JPRB,0.13491E-01_JPRB,0.13188E-01_JPRB,0.12703E-01_JPRB, &
 & 0.12072E-01_JPRB,0.11323E-01_JPRB,0.10433E-01_JPRB,0.10295E-01_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.13862E-01_JPRB,0.13772E-01_JPRB,0.13824E-01_JPRB,0.13679E-01_JPRB,0.13333E-01_JPRB, &
 & 0.12836E-01_JPRB,0.12214E-01_JPRB,0.11468E-01_JPRB,0.11588E-01_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.14153E-01_JPRB,0.13216E-01_JPRB,0.12406E-01_JPRB,0.11612E-01_JPRB,0.10690E-01_JPRB, &
 & 0.96495E-02_JPRB,0.84088E-02_JPRB,0.70121E-02_JPRB,0.57874E-02_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.14005E-01_JPRB,0.13241E-01_JPRB,0.12647E-01_JPRB,0.11995E-01_JPRB,0.11231E-01_JPRB, &
 & 0.10266E-01_JPRB,0.91127E-02_JPRB,0.78123E-02_JPRB,0.67372E-02_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.13845E-01_JPRB,0.13290E-01_JPRB,0.12907E-01_JPRB,0.12438E-01_JPRB,0.11783E-01_JPRB, &
 & 0.10918E-01_JPRB,0.98730E-02_JPRB,0.86646E-02_JPRB,0.77601E-02_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.13685E-01_JPRB,0.13375E-01_JPRB,0.13206E-01_JPRB,0.12899E-01_JPRB,0.12360E-01_JPRB, &
 & 0.11608E-01_JPRB,0.10665E-01_JPRB,0.95624E-02_JPRB,0.88628E-02_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.13529E-01_JPRB,0.13472E-01_JPRB,0.13531E-01_JPRB,0.13371E-01_JPRB,0.12964E-01_JPRB, &
 & 0.12311E-01_JPRB,0.11491E-01_JPRB,0.10508E-01_JPRB,0.10039E-01_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.13587E-01_JPRB,0.12730E-01_JPRB,0.11973E-01_JPRB,0.11204E-01_JPRB,0.10282E-01_JPRB, &
 & 0.92218E-02_JPRB,0.79316E-02_JPRB,0.64044E-02_JPRB,0.48583E-02_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.13430E-01_JPRB,0.12751E-01_JPRB,0.12205E-01_JPRB,0.11567E-01_JPRB,0.10798E-01_JPRB, &
 & 0.98163E-02_JPRB,0.85810E-02_JPRB,0.71221E-02_JPRB,0.56837E-02_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.13271E-01_JPRB,0.12793E-01_JPRB,0.12448E-01_JPRB,0.11993E-01_JPRB,0.11338E-01_JPRB, &
 & 0.10437E-01_JPRB,0.92786E-02_JPRB,0.78957E-02_JPRB,0.65802E-02_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.13115E-01_JPRB,0.12874E-01_JPRB,0.12735E-01_JPRB,0.12440E-01_JPRB,0.11897E-01_JPRB, &
 & 0.11094E-01_JPRB,0.10003E-01_JPRB,0.87146E-02_JPRB,0.75565E-02_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.12984E-01_JPRB,0.12973E-01_JPRB,0.13053E-01_JPRB,0.12899E-01_JPRB,0.12481E-01_JPRB, &
 & 0.11759E-01_JPRB,0.10765E-01_JPRB,0.95850E-02_JPRB,0.86117E-02_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.12817E-01_JPRB,0.12050E-01_JPRB,0.11369E-01_JPRB,0.10622E-01_JPRB,0.97180E-02_JPRB, &
 & 0.86745E-02_JPRB,0.73942E-02_JPRB,0.58154E-02_JPRB,0.40318E-02_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.12656E-01_JPRB,0.12077E-01_JPRB,0.11582E-01_JPRB,0.10960E-01_JPRB,0.10205E-01_JPRB, &
 & 0.92477E-02_JPRB,0.80000E-02_JPRB,0.64500E-02_JPRB,0.47452E-02_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.12499E-01_JPRB,0.12115E-01_JPRB,0.11810E-01_JPRB,0.11361E-01_JPRB,0.10734E-01_JPRB, &
 & 0.98374E-02_JPRB,0.86412E-02_JPRB,0.71467E-02_JPRB,0.55214E-02_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.12364E-01_JPRB,0.12194E-01_JPRB,0.12081E-01_JPRB,0.11798E-01_JPRB,0.11270E-01_JPRB, &
 & 0.10459E-01_JPRB,0.93144E-02_JPRB,0.78844E-02_JPRB,0.63718E-02_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.12255E-01_JPRB,0.12311E-01_JPRB,0.12390E-01_JPRB,0.12242E-01_JPRB,0.11833E-01_JPRB, &
 & 0.11093E-01_JPRB,0.10016E-01_JPRB,0.86730E-02_JPRB,0.72984E-02_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.11891E-01_JPRB,0.11226E-01_JPRB,0.10633E-01_JPRB,0.99134E-02_JPRB,0.90439E-02_JPRB, &
 & 0.80297E-02_JPRB,0.68136E-02_JPRB,0.52756E-02_JPRB,0.33216E-02_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.11730E-01_JPRB,0.11250E-01_JPRB,0.10822E-01_JPRB,0.10230E-01_JPRB,0.94903E-02_JPRB, &
 & 0.85683E-02_JPRB,0.73765E-02_JPRB,0.58347E-02_JPRB,0.39310E-02_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.11586E-01_JPRB,0.11299E-01_JPRB,0.11036E-01_JPRB,0.10599E-01_JPRB,0.99917E-02_JPRB, &
 & 0.91260E-02_JPRB,0.79645E-02_JPRB,0.64502E-02_JPRB,0.46031E-02_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.11473E-01_JPRB,0.11391E-01_JPRB,0.11290E-01_JPRB,0.11015E-01_JPRB,0.10500E-01_JPRB, &
 & 0.97132E-02_JPRB,0.85920E-02_JPRB,0.71112E-02_JPRB,0.53403E-02_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.11384E-01_JPRB,0.11524E-01_JPRB,0.11598E-01_JPRB,0.11442E-01_JPRB,0.11036E-01_JPRB, &
 & 0.10317E-01_JPRB,0.92441E-02_JPRB,0.78209E-02_JPRB,0.61457E-02_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.10852E-01_JPRB,0.10302E-01_JPRB,0.97896E-02_JPRB,0.91138E-02_JPRB,0.83000E-02_JPRB, &
 & 0.73373E-02_JPRB,0.61956E-02_JPRB,0.47644E-02_JPRB,0.26652E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART7',0,ZHOOK_HANDLE)


KA(:, 2, 8, 9) = (/ &
 & 0.10699E-01_JPRB,0.10325E-01_JPRB,0.99631E-02_JPRB,0.94045E-02_JPRB,0.87025E-02_JPRB, &
 & 0.78255E-02_JPRB,0.67137E-02_JPRB,0.52638E-02_JPRB,0.31922E-02_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.10574E-01_JPRB,0.10385E-01_JPRB,0.10163E-01_JPRB,0.97460E-02_JPRB,0.91609E-02_JPRB, &
 & 0.83418E-02_JPRB,0.72560E-02_JPRB,0.58143E-02_JPRB,0.37766E-02_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.10480E-01_JPRB,0.10499E-01_JPRB,0.10413E-01_JPRB,0.10139E-01_JPRB,0.96342E-02_JPRB, &
 & 0.88826E-02_JPRB,0.78405E-02_JPRB,0.64037E-02_JPRB,0.44295E-02_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.10415E-01_JPRB,0.10646E-01_JPRB,0.10720E-01_JPRB,0.10553E-01_JPRB,0.10134E-01_JPRB, &
 & 0.94529E-02_JPRB,0.84471E-02_JPRB,0.70384E-02_JPRB,0.51485E-02_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.97587E-02_JPRB,0.93185E-02_JPRB,0.88694E-02_JPRB,0.82517E-02_JPRB,0.75094E-02_JPRB, &
 & 0.66177E-02_JPRB,0.55658E-02_JPRB,0.42591E-02_JPRB,0.21931E-02_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.96183E-02_JPRB,0.93436E-02_JPRB,0.90329E-02_JPRB,0.85198E-02_JPRB,0.78654E-02_JPRB, &
 & 0.70507E-02_JPRB,0.60316E-02_JPRB,0.47067E-02_JPRB,0.25691E-02_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.95112E-02_JPRB,0.94166E-02_JPRB,0.92325E-02_JPRB,0.88355E-02_JPRB,0.82791E-02_JPRB, &
 & 0.75194E-02_JPRB,0.65208E-02_JPRB,0.52003E-02_JPRB,0.29789E-02_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.94373E-02_JPRB,0.95446E-02_JPRB,0.94815E-02_JPRB,0.92092E-02_JPRB,0.87140E-02_JPRB, &
 & 0.80091E-02_JPRB,0.70556E-02_JPRB,0.57344E-02_JPRB,0.34284E-02_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.93945E-02_JPRB,0.97041E-02_JPRB,0.97866E-02_JPRB,0.96055E-02_JPRB,0.91834E-02_JPRB, &
 & 0.85358E-02_JPRB,0.76199E-02_JPRB,0.63067E-02_JPRB,0.39360E-02_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.86571E-02_JPRB,0.83282E-02_JPRB,0.79327E-02_JPRB,0.73862E-02_JPRB,0.67217E-02_JPRB, &
 & 0.59210E-02_JPRB,0.49777E-02_JPRB,0.37950E-02_JPRB,0.25161E-02_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.85351E-02_JPRB,0.83629E-02_JPRB,0.80910E-02_JPRB,0.76400E-02_JPRB,0.70398E-02_JPRB, &
 & 0.63068E-02_JPRB,0.53903E-02_JPRB,0.41966E-02_JPRB,0.29067E-02_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.84483E-02_JPRB,0.84483E-02_JPRB,0.82944E-02_JPRB,0.79338E-02_JPRB,0.74159E-02_JPRB, &
 & 0.67272E-02_JPRB,0.58285E-02_JPRB,0.46411E-02_JPRB,0.33599E-02_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.83941E-02_JPRB,0.85821E-02_JPRB,0.85440E-02_JPRB,0.82866E-02_JPRB,0.78214E-02_JPRB, &
 & 0.71692E-02_JPRB,0.63103E-02_JPRB,0.51290E-02_JPRB,0.38620E-02_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.83806E-02_JPRB,0.87510E-02_JPRB,0.88459E-02_JPRB,0.86620E-02_JPRB,0.82607E-02_JPRB, &
 & 0.76554E-02_JPRB,0.68267E-02_JPRB,0.56504E-02_JPRB,0.44001E-02_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.75570E-02_JPRB,0.73902E-02_JPRB,0.70826E-02_JPRB,0.66405E-02_JPRB,0.60731E-02_JPRB, &
 & 0.53892E-02_JPRB,0.45656E-02_JPRB,0.35050E-02_JPRB,0.26164E-02_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.74683E-02_JPRB,0.74501E-02_JPRB,0.72578E-02_JPRB,0.68886E-02_JPRB,0.63823E-02_JPRB, &
 & 0.57485E-02_JPRB,0.49402E-02_JPRB,0.38790E-02_JPRB,0.30097E-02_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.74153E-02_JPRB,0.75630E-02_JPRB,0.74762E-02_JPRB,0.71912E-02_JPRB,0.67425E-02_JPRB, &
 & 0.61326E-02_JPRB,0.53447E-02_JPRB,0.42990E-02_JPRB,0.34771E-02_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.74057E-02_JPRB,0.77202E-02_JPRB,0.77477E-02_JPRB,0.75330E-02_JPRB,0.71268E-02_JPRB, &
 & 0.65549E-02_JPRB,0.57951E-02_JPRB,0.47555E-02_JPRB,0.39884E-02_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.74391E-02_JPRB,0.79220E-02_JPRB,0.80561E-02_JPRB,0.79014E-02_JPRB,0.75514E-02_JPRB, &
 & 0.70214E-02_JPRB,0.62779E-02_JPRB,0.52483E-02_JPRB,0.45376E-02_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.65546E-02_JPRB,0.65200E-02_JPRB,0.62910E-02_JPRB,0.59243E-02_JPRB,0.54454E-02_JPRB, &
 & 0.48623E-02_JPRB,0.41386E-02_JPRB,0.32013E-02_JPRB,0.25137E-02_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.64987E-02_JPRB,0.66047E-02_JPRB,0.64774E-02_JPRB,0.61754E-02_JPRB,0.57483E-02_JPRB, &
 & 0.51910E-02_JPRB,0.44799E-02_JPRB,0.35500E-02_JPRB,0.28998E-02_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.64867E-02_JPRB,0.67439E-02_JPRB,0.67077E-02_JPRB,0.64758E-02_JPRB,0.60840E-02_JPRB, &
 & 0.55472E-02_JPRB,0.48582E-02_JPRB,0.39433E-02_JPRB,0.33472E-02_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.65214E-02_JPRB,0.69269E-02_JPRB,0.69913E-02_JPRB,0.68034E-02_JPRB,0.64480E-02_JPRB, &
 & 0.59497E-02_JPRB,0.52811E-02_JPRB,0.43712E-02_JPRB,0.38283E-02_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.66068E-02_JPRB,0.71634E-02_JPRB,0.73032E-02_JPRB,0.71670E-02_JPRB,0.68605E-02_JPRB, &
 & 0.63896E-02_JPRB,0.57387E-02_JPRB,0.48340E-02_JPRB,0.43614E-02_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.56598E-02_JPRB,0.57241E-02_JPRB,0.55653E-02_JPRB,0.52616E-02_JPRB,0.48615E-02_JPRB, &
 & 0.43534E-02_JPRB,0.37143E-02_JPRB,0.28975E-02_JPRB,0.22483E-02_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.56408E-02_JPRB,0.58364E-02_JPRB,0.57539E-02_JPRB,0.55120E-02_JPRB,0.51475E-02_JPRB, &
 & 0.46559E-02_JPRB,0.40284E-02_JPRB,0.32222E-02_JPRB,0.26111E-02_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.56697E-02_JPRB,0.59982E-02_JPRB,0.59981E-02_JPRB,0.58053E-02_JPRB,0.54583E-02_JPRB, &
 & 0.49917E-02_JPRB,0.43867E-02_JPRB,0.35862E-02_JPRB,0.30268E-02_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.57519E-02_JPRB,0.62108E-02_JPRB,0.62874E-02_JPRB,0.61219E-02_JPRB,0.58111E-02_JPRB, &
 & 0.53715E-02_JPRB,0.47851E-02_JPRB,0.39858E-02_JPRB,0.34700E-02_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.58830E-02_JPRB,0.64813E-02_JPRB,0.66064E-02_JPRB,0.64830E-02_JPRB,0.62068E-02_JPRB, &
 & 0.57872E-02_JPRB,0.52185E-02_JPRB,0.44205E-02_JPRB,0.39619E-02_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.28544E-01_JPRB,0.26155E-01_JPRB,0.24149E-01_JPRB,0.22667E-01_JPRB,0.21632E-01_JPRB, &
 & 0.20279E-01_JPRB,0.18489E-01_JPRB,0.17580E-01_JPRB,0.19616E-01_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.28363E-01_JPRB,0.26242E-01_JPRB,0.24669E-01_JPRB,0.23473E-01_JPRB,0.22995E-01_JPRB, &
 & 0.21803E-01_JPRB,0.19985E-01_JPRB,0.19915E-01_JPRB,0.22325E-01_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.28168E-01_JPRB,0.26278E-01_JPRB,0.25280E-01_JPRB,0.24624E-01_JPRB,0.24316E-01_JPRB, &
 & 0.23197E-01_JPRB,0.21657E-01_JPRB,0.22779E-01_JPRB,0.25626E-01_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.27980E-01_JPRB,0.26431E-01_JPRB,0.25828E-01_JPRB,0.25920E-01_JPRB,0.25669E-01_JPRB, &
 & 0.24755E-01_JPRB,0.23686E-01_JPRB,0.25934E-01_JPRB,0.29281E-01_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.27732E-01_JPRB,0.26646E-01_JPRB,0.26660E-01_JPRB,0.27009E-01_JPRB,0.27233E-01_JPRB, &
 & 0.26525E-01_JPRB,0.25997E-01_JPRB,0.29201E-01_JPRB,0.33040E-01_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.30271E-01_JPRB,0.27672E-01_JPRB,0.25272E-01_JPRB,0.23430E-01_JPRB,0.22043E-01_JPRB, &
 & 0.20727E-01_JPRB,0.19083E-01_JPRB,0.16913E-01_JPRB,0.18728E-01_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.30091E-01_JPRB,0.27720E-01_JPRB,0.25820E-01_JPRB,0.24222E-01_JPRB,0.23409E-01_JPRB, &
 & 0.22468E-01_JPRB,0.20609E-01_JPRB,0.19148E-01_JPRB,0.21375E-01_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.29914E-01_JPRB,0.27750E-01_JPRB,0.26375E-01_JPRB,0.25267E-01_JPRB,0.24987E-01_JPRB, &
 & 0.23926E-01_JPRB,0.22306E-01_JPRB,0.21932E-01_JPRB,0.24591E-01_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.29701E-01_JPRB,0.27873E-01_JPRB,0.26877E-01_JPRB,0.26535E-01_JPRB,0.26327E-01_JPRB, &
 & 0.25568E-01_JPRB,0.24303E-01_JPRB,0.24920E-01_JPRB,0.28049E-01_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.29422E-01_JPRB,0.28052E-01_JPRB,0.27653E-01_JPRB,0.27818E-01_JPRB,0.27831E-01_JPRB, &
 & 0.27375E-01_JPRB,0.26338E-01_JPRB,0.28129E-01_JPRB,0.31777E-01_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.32089E-01_JPRB,0.29221E-01_JPRB,0.26504E-01_JPRB,0.24372E-01_JPRB,0.22322E-01_JPRB, &
 & 0.20541E-01_JPRB,0.19063E-01_JPRB,0.16413E-01_JPRB,0.17368E-01_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.31950E-01_JPRB,0.29299E-01_JPRB,0.26979E-01_JPRB,0.25078E-01_JPRB,0.23422E-01_JPRB, &
 & 0.22454E-01_JPRB,0.20735E-01_JPRB,0.18244E-01_JPRB,0.19956E-01_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.31786E-01_JPRB,0.29316E-01_JPRB,0.27496E-01_JPRB,0.25889E-01_JPRB,0.24965E-01_JPRB, &
 & 0.24089E-01_JPRB,0.22376E-01_JPRB,0.20693E-01_JPRB,0.22993E-01_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.31564E-01_JPRB,0.29393E-01_JPRB,0.27942E-01_JPRB,0.27000E-01_JPRB,0.26402E-01_JPRB, &
 & 0.25715E-01_JPRB,0.24406E-01_JPRB,0.23371E-01_JPRB,0.26093E-01_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.31295E-01_JPRB,0.29526E-01_JPRB,0.28627E-01_JPRB,0.28150E-01_JPRB,0.27951E-01_JPRB, &
 & 0.27569E-01_JPRB,0.26423E-01_JPRB,0.26332E-01_JPRB,0.29505E-01_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.33998E-01_JPRB,0.30694E-01_JPRB,0.27710E-01_JPRB,0.25291E-01_JPRB,0.22809E-01_JPRB, &
 & 0.20329E-01_JPRB,0.18660E-01_JPRB,0.16131E-01_JPRB,0.15800E-01_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.33852E-01_JPRB,0.30861E-01_JPRB,0.28097E-01_JPRB,0.25930E-01_JPRB,0.23654E-01_JPRB, &
 & 0.22029E-01_JPRB,0.20474E-01_JPRB,0.17896E-01_JPRB,0.18339E-01_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.33685E-01_JPRB,0.30889E-01_JPRB,0.28668E-01_JPRB,0.26585E-01_JPRB,0.25018E-01_JPRB, &
 & 0.23681E-01_JPRB,0.22215E-01_JPRB,0.19897E-01_JPRB,0.21224E-01_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.33431E-01_JPRB,0.30933E-01_JPRB,0.29107E-01_JPRB,0.27570E-01_JPRB,0.26341E-01_JPRB, &
 & 0.25360E-01_JPRB,0.24234E-01_JPRB,0.22138E-01_JPRB,0.24217E-01_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.33153E-01_JPRB,0.31115E-01_JPRB,0.29708E-01_JPRB,0.28626E-01_JPRB,0.27757E-01_JPRB, &
 & 0.27318E-01_JPRB,0.26191E-01_JPRB,0.24666E-01_JPRB,0.27426E-01_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.35630E-01_JPRB,0.31962E-01_JPRB,0.28969E-01_JPRB,0.26191E-01_JPRB,0.23359E-01_JPRB, &
 & 0.20419E-01_JPRB,0.18025E-01_JPRB,0.15529E-01_JPRB,0.14046E-01_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.35465E-01_JPRB,0.32227E-01_JPRB,0.29248E-01_JPRB,0.26845E-01_JPRB,0.24076E-01_JPRB, &
 & 0.21854E-01_JPRB,0.19842E-01_JPRB,0.17371E-01_JPRB,0.16514E-01_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.35239E-01_JPRB,0.32283E-01_JPRB,0.29869E-01_JPRB,0.27436E-01_JPRB,0.25256E-01_JPRB, &
 & 0.23352E-01_JPRB,0.21638E-01_JPRB,0.19381E-01_JPRB,0.19322E-01_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.34959E-01_JPRB,0.32275E-01_JPRB,0.30321E-01_JPRB,0.28325E-01_JPRB,0.26494E-01_JPRB, &
 & 0.24825E-01_JPRB,0.23722E-01_JPRB,0.21526E-01_JPRB,0.22221E-01_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.34633E-01_JPRB,0.32463E-01_JPRB,0.30867E-01_JPRB,0.29345E-01_JPRB,0.27730E-01_JPRB, &
 & 0.26661E-01_JPRB,0.25760E-01_JPRB,0.23698E-01_JPRB,0.25325E-01_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.36611E-01_JPRB,0.32766E-01_JPRB,0.29862E-01_JPRB,0.26964E-01_JPRB,0.23985E-01_JPRB, &
 & 0.20572E-01_JPRB,0.17499E-01_JPRB,0.14612E-01_JPRB,0.12200E-01_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.36404E-01_JPRB,0.32931E-01_JPRB,0.30135E-01_JPRB,0.27680E-01_JPRB,0.24618E-01_JPRB, &
 & 0.21792E-01_JPRB,0.19087E-01_JPRB,0.16488E-01_JPRB,0.14408E-01_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.36151E-01_JPRB,0.33151E-01_JPRB,0.30783E-01_JPRB,0.28229E-01_JPRB,0.25608E-01_JPRB, &
 & 0.23215E-01_JPRB,0.20762E-01_JPRB,0.18415E-01_JPRB,0.17025E-01_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.35835E-01_JPRB,0.33169E-01_JPRB,0.31261E-01_JPRB,0.29020E-01_JPRB,0.26813E-01_JPRB, &
 & 0.24559E-01_JPRB,0.22662E-01_JPRB,0.20622E-01_JPRB,0.19846E-01_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.35491E-01_JPRB,0.33330E-01_JPRB,0.31756E-01_JPRB,0.30047E-01_JPRB,0.27916E-01_JPRB, &
 & 0.26189E-01_JPRB,0.24713E-01_JPRB,0.22859E-01_JPRB,0.22839E-01_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.36793E-01_JPRB,0.32943E-01_JPRB,0.30074E-01_JPRB,0.27299E-01_JPRB,0.24319E-01_JPRB, &
 & 0.20802E-01_JPRB,0.17113E-01_JPRB,0.13465E-01_JPRB,0.10508E-01_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.36572E-01_JPRB,0.33074E-01_JPRB,0.30511E-01_JPRB,0.28032E-01_JPRB,0.24986E-01_JPRB, &
 & 0.21844E-01_JPRB,0.18570E-01_JPRB,0.15283E-01_JPRB,0.12467E-01_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.36275E-01_JPRB,0.33234E-01_JPRB,0.31161E-01_JPRB,0.28602E-01_JPRB,0.25904E-01_JPRB, &
 & 0.23164E-01_JPRB,0.20091E-01_JPRB,0.17151E-01_JPRB,0.14775E-01_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.35925E-01_JPRB,0.33332E-01_JPRB,0.31658E-01_JPRB,0.29367E-01_JPRB,0.27125E-01_JPRB, &
 & 0.24431E-01_JPRB,0.21734E-01_JPRB,0.19261E-01_JPRB,0.17350E-01_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.35558E-01_JPRB,0.33506E-01_JPRB,0.32097E-01_JPRB,0.30412E-01_JPRB,0.28219E-01_JPRB, &
 & 0.25923E-01_JPRB,0.23598E-01_JPRB,0.21456E-01_JPRB,0.20114E-01_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.36293E-01_JPRB,0.32550E-01_JPRB,0.29721E-01_JPRB,0.27154E-01_JPRB,0.24076E-01_JPRB, &
 & 0.20693E-01_JPRB,0.16829E-01_JPRB,0.12555E-01_JPRB,0.89579E-02_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.35985E-01_JPRB,0.32624E-01_JPRB,0.30270E-01_JPRB,0.27879E-01_JPRB,0.24830E-01_JPRB, &
 & 0.21669E-01_JPRB,0.18126E-01_JPRB,0.14126E-01_JPRB,0.10649E-01_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.35646E-01_JPRB,0.32730E-01_JPRB,0.30946E-01_JPRB,0.28474E-01_JPRB,0.25750E-01_JPRB, &
 & 0.23017E-01_JPRB,0.19564E-01_JPRB,0.15741E-01_JPRB,0.12721E-01_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.35279E-01_JPRB,0.32754E-01_JPRB,0.31424E-01_JPRB,0.29187E-01_JPRB,0.27070E-01_JPRB, &
 & 0.24316E-01_JPRB,0.21018E-01_JPRB,0.17682E-01_JPRB,0.15011E-01_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.34858E-01_JPRB,0.32947E-01_JPRB,0.31835E-01_JPRB,0.30265E-01_JPRB,0.28236E-01_JPRB, &
 & 0.25710E-01_JPRB,0.22721E-01_JPRB,0.19777E-01_JPRB,0.17474E-01_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.35060E-01_JPRB,0.31556E-01_JPRB,0.29012E-01_JPRB,0.26469E-01_JPRB,0.23391E-01_JPRB, &
 & 0.20141E-01_JPRB,0.16295E-01_JPRB,0.11885E-01_JPRB,0.58937E-02_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.34721E-01_JPRB,0.31589E-01_JPRB,0.29506E-01_JPRB,0.27211E-01_JPRB,0.24267E-01_JPRB, &
 & 0.21055E-01_JPRB,0.17547E-01_JPRB,0.13263E-01_JPRB,0.69908E-02_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.34339E-01_JPRB,0.31609E-01_JPRB,0.30075E-01_JPRB,0.27841E-01_JPRB,0.25163E-01_JPRB, &
 & 0.22398E-01_JPRB,0.18997E-01_JPRB,0.14640E-01_JPRB,0.92447E-02_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.33936E-01_JPRB,0.31619E-01_JPRB,0.30603E-01_JPRB,0.28503E-01_JPRB,0.26490E-01_JPRB, &
 & 0.23804E-01_JPRB,0.20342E-01_JPRB,0.16280E-01_JPRB,0.11993E-01_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.33530E-01_JPRB,0.31821E-01_JPRB,0.30991E-01_JPRB,0.29578E-01_JPRB,0.27714E-01_JPRB, &
 & 0.25218E-01_JPRB,0.21886E-01_JPRB,0.18137E-01_JPRB,0.14941E-01_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.33129E-01_JPRB,0.29964E-01_JPRB,0.27856E-01_JPRB,0.25331E-01_JPRB,0.22401E-01_JPRB, &
 & 0.19295E-01_JPRB,0.15555E-01_JPRB,0.11348E-01_JPRB,0.74286E-02_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.32749E-01_JPRB,0.29950E-01_JPRB,0.28249E-01_JPRB,0.25998E-01_JPRB,0.23402E-01_JPRB, &
 & 0.20209E-01_JPRB,0.16757E-01_JPRB,0.12616E-01_JPRB,0.86653E-02_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.32344E-01_JPRB,0.29933E-01_JPRB,0.28722E-01_JPRB,0.26736E-01_JPRB,0.24275E-01_JPRB, &
 & 0.21508E-01_JPRB,0.18229E-01_JPRB,0.13852E-01_JPRB,0.98082E-02_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.31944E-01_JPRB,0.30002E-01_JPRB,0.29235E-01_JPRB,0.27435E-01_JPRB,0.25548E-01_JPRB, &
 & 0.22964E-01_JPRB,0.19579E-01_JPRB,0.15278E-01_JPRB,0.11352E-01_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.31533E-01_JPRB,0.30276E-01_JPRB,0.29685E-01_JPRB,0.28539E-01_JPRB,0.26795E-01_JPRB, &
 & 0.24358E-01_JPRB,0.21106E-01_JPRB,0.16900E-01_JPRB,0.12858E-01_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.30476E-01_JPRB,0.27848E-01_JPRB,0.26383E-01_JPRB,0.23991E-01_JPRB,0.21505E-01_JPRB, &
 & 0.18546E-01_JPRB,0.15127E-01_JPRB,0.11242E-01_JPRB,0.84064E-02_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.30069E-01_JPRB,0.27873E-01_JPRB,0.26695E-01_JPRB,0.24743E-01_JPRB,0.22441E-01_JPRB, &
 & 0.19591E-01_JPRB,0.16445E-01_JPRB,0.12465E-01_JPRB,0.99520E-02_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.29683E-01_JPRB,0.27938E-01_JPRB,0.27199E-01_JPRB,0.25464E-01_JPRB,0.23474E-01_JPRB, &
 & 0.21008E-01_JPRB,0.17841E-01_JPRB,0.13636E-01_JPRB,0.11012E-01_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.29281E-01_JPRB,0.28147E-01_JPRB,0.27612E-01_JPRB,0.26457E-01_JPRB,0.24810E-01_JPRB, &
 & 0.22367E-01_JPRB,0.19198E-01_JPRB,0.15026E-01_JPRB,0.12764E-01_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.28878E-01_JPRB,0.28450E-01_JPRB,0.28275E-01_JPRB,0.27607E-01_JPRB,0.26039E-01_JPRB, &
 & 0.23769E-01_JPRB,0.20798E-01_JPRB,0.16479E-01_JPRB,0.14486E-01_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.27483E-01_JPRB,0.25515E-01_JPRB,0.24398E-01_JPRB,0.22423E-01_JPRB,0.20204E-01_JPRB, &
 & 0.17532E-01_JPRB,0.14597E-01_JPRB,0.10977E-01_JPRB,0.89256E-02_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.27095E-01_JPRB,0.25634E-01_JPRB,0.24782E-01_JPRB,0.23175E-01_JPRB,0.21102E-01_JPRB, &
 & 0.18740E-01_JPRB,0.15902E-01_JPRB,0.12114E-01_JPRB,0.10252E-01_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.26727E-01_JPRB,0.25761E-01_JPRB,0.25266E-01_JPRB,0.23974E-01_JPRB,0.22361E-01_JPRB, &
 & 0.20171E-01_JPRB,0.17193E-01_JPRB,0.13275E-01_JPRB,0.11451E-01_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.26341E-01_JPRB,0.26039E-01_JPRB,0.25768E-01_JPRB,0.25146E-01_JPRB,0.23693E-01_JPRB, &
 & 0.21452E-01_JPRB,0.18566E-01_JPRB,0.14626E-01_JPRB,0.13159E-01_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.25958E-01_JPRB,0.26232E-01_JPRB,0.26607E-01_JPRB,0.26277E-01_JPRB,0.24926E-01_JPRB, &
 & 0.22906E-01_JPRB,0.20118E-01_JPRB,0.16018E-01_JPRB,0.14784E-01_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.24404E-01_JPRB,0.23195E-01_JPRB,0.22191E-01_JPRB,0.20664E-01_JPRB,0.18645E-01_JPRB, &
 & 0.16397E-01_JPRB,0.13889E-01_JPRB,0.10532E-01_JPRB,0.85762E-02_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.24045E-01_JPRB,0.23274E-01_JPRB,0.22704E-01_JPRB,0.21382E-01_JPRB,0.19651E-01_JPRB, &
 & 0.17693E-01_JPRB,0.15133E-01_JPRB,0.11576E-01_JPRB,0.96068E-02_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.23688E-01_JPRB,0.23458E-01_JPRB,0.23185E-01_JPRB,0.22281E-01_JPRB,0.21010E-01_JPRB, &
 & 0.19021E-01_JPRB,0.16312E-01_JPRB,0.12755E-01_JPRB,0.10813E-01_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.23340E-01_JPRB,0.23719E-01_JPRB,0.23835E-01_JPRB,0.23529E-01_JPRB,0.22269E-01_JPRB, &
 & 0.20297E-01_JPRB,0.17677E-01_JPRB,0.14063E-01_JPRB,0.12469E-01_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.23007E-01_JPRB,0.23887E-01_JPRB,0.24745E-01_JPRB,0.24636E-01_JPRB,0.23538E-01_JPRB, &
 & 0.21795E-01_JPRB,0.19163E-01_JPRB,0.15452E-01_JPRB,0.13866E-01_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.38207E-01_JPRB,0.35023E-01_JPRB,0.31764E-01_JPRB,0.29513E-01_JPRB,0.27148E-01_JPRB, &
 & 0.25121E-01_JPRB,0.22678E-01_JPRB,0.23928E-01_JPRB,0.26899E-01_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.37930E-01_JPRB,0.35272E-01_JPRB,0.32250E-01_JPRB,0.30760E-01_JPRB,0.28557E-01_JPRB, &
 & 0.27105E-01_JPRB,0.25089E-01_JPRB,0.27604E-01_JPRB,0.31070E-01_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.37611E-01_JPRB,0.35491E-01_JPRB,0.32949E-01_JPRB,0.31869E-01_JPRB,0.30632E-01_JPRB, &
 & 0.29068E-01_JPRB,0.27897E-01_JPRB,0.31369E-01_JPRB,0.35419E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART8',0,ZHOOK_HANDLE)


KA(:, 4, 1,11) = (/ &
 & 0.37244E-01_JPRB,0.35566E-01_JPRB,0.33874E-01_JPRB,0.33253E-01_JPRB,0.32466E-01_JPRB, &
 & 0.31095E-01_JPRB,0.31358E-01_JPRB,0.35716E-01_JPRB,0.40368E-01_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.36895E-01_JPRB,0.35750E-01_JPRB,0.34817E-01_JPRB,0.35038E-01_JPRB,0.34265E-01_JPRB, &
 & 0.33428E-01_JPRB,0.35709E-01_JPRB,0.40899E-01_JPRB,0.46337E-01_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.39640E-01_JPRB,0.36208E-01_JPRB,0.33140E-01_JPRB,0.30731E-01_JPRB,0.28621E-01_JPRB, &
 & 0.26451E-01_JPRB,0.23824E-01_JPRB,0.23418E-01_JPRB,0.26401E-01_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.39384E-01_JPRB,0.36543E-01_JPRB,0.33542E-01_JPRB,0.32043E-01_JPRB,0.30032E-01_JPRB, &
 & 0.28484E-01_JPRB,0.26191E-01_JPRB,0.27027E-01_JPRB,0.30540E-01_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.39069E-01_JPRB,0.36650E-01_JPRB,0.34340E-01_JPRB,0.33119E-01_JPRB,0.32037E-01_JPRB, &
 & 0.30787E-01_JPRB,0.28410E-01_JPRB,0.30659E-01_JPRB,0.34733E-01_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.38756E-01_JPRB,0.36738E-01_JPRB,0.35220E-01_JPRB,0.34547E-01_JPRB,0.34264E-01_JPRB, &
 & 0.32872E-01_JPRB,0.31204E-01_JPRB,0.34827E-01_JPRB,0.39529E-01_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.38432E-01_JPRB,0.36958E-01_JPRB,0.36077E-01_JPRB,0.36343E-01_JPRB,0.36389E-01_JPRB, &
 & 0.35222E-01_JPRB,0.34916E-01_JPRB,0.39622E-01_JPRB,0.45018E-01_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.41762E-01_JPRB,0.37801E-01_JPRB,0.34598E-01_JPRB,0.31385E-01_JPRB,0.29542E-01_JPRB, &
 & 0.27120E-01_JPRB,0.24296E-01_JPRB,0.22163E-01_JPRB,0.24873E-01_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.41521E-01_JPRB,0.38107E-01_JPRB,0.34885E-01_JPRB,0.32740E-01_JPRB,0.30892E-01_JPRB, &
 & 0.28927E-01_JPRB,0.26874E-01_JPRB,0.25608E-01_JPRB,0.28828E-01_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.41284E-01_JPRB,0.38250E-01_JPRB,0.35590E-01_JPRB,0.33929E-01_JPRB,0.32637E-01_JPRB, &
 & 0.31412E-01_JPRB,0.29268E-01_JPRB,0.29038E-01_JPRB,0.32851E-01_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.40996E-01_JPRB,0.38286E-01_JPRB,0.36402E-01_JPRB,0.35356E-01_JPRB,0.34868E-01_JPRB, &
 & 0.33799E-01_JPRB,0.31619E-01_JPRB,0.33158E-01_JPRB,0.37659E-01_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.40710E-01_JPRB,0.38497E-01_JPRB,0.37108E-01_JPRB,0.37161E-01_JPRB,0.37098E-01_JPRB, &
 & 0.36226E-01_JPRB,0.34568E-01_JPRB,0.37733E-01_JPRB,0.42953E-01_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.44432E-01_JPRB,0.39911E-01_JPRB,0.36533E-01_JPRB,0.32358E-01_JPRB,0.30116E-01_JPRB, &
 & 0.27425E-01_JPRB,0.24391E-01_JPRB,0.21003E-01_JPRB,0.22873E-01_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.44241E-01_JPRB,0.40248E-01_JPRB,0.36750E-01_JPRB,0.33734E-01_JPRB,0.31371E-01_JPRB, &
 & 0.29050E-01_JPRB,0.26929E-01_JPRB,0.23993E-01_JPRB,0.26696E-01_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.43986E-01_JPRB,0.40474E-01_JPRB,0.37358E-01_JPRB,0.34847E-01_JPRB,0.32894E-01_JPRB, &
 & 0.31475E-01_JPRB,0.29486E-01_JPRB,0.27256E-01_JPRB,0.30632E-01_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.43750E-01_JPRB,0.40487E-01_JPRB,0.38107E-01_JPRB,0.36115E-01_JPRB,0.35063E-01_JPRB, &
 & 0.33924E-01_JPRB,0.31967E-01_JPRB,0.31144E-01_JPRB,0.35198E-01_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.43427E-01_JPRB,0.40610E-01_JPRB,0.38702E-01_JPRB,0.37867E-01_JPRB,0.37251E-01_JPRB, &
 & 0.36357E-01_JPRB,0.34995E-01_JPRB,0.35502E-01_JPRB,0.40197E-01_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.47176E-01_JPRB,0.42142E-01_JPRB,0.38550E-01_JPRB,0.33884E-01_JPRB,0.30889E-01_JPRB, &
 & 0.27516E-01_JPRB,0.24267E-01_JPRB,0.20680E-01_JPRB,0.20851E-01_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.47021E-01_JPRB,0.42363E-01_JPRB,0.38770E-01_JPRB,0.35164E-01_JPRB,0.32104E-01_JPRB, &
 & 0.29005E-01_JPRB,0.26645E-01_JPRB,0.23247E-01_JPRB,0.24505E-01_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.46797E-01_JPRB,0.42763E-01_JPRB,0.39235E-01_JPRB,0.36269E-01_JPRB,0.33395E-01_JPRB, &
 & 0.31307E-01_JPRB,0.29249E-01_JPRB,0.25924E-01_JPRB,0.28324E-01_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.46572E-01_JPRB,0.42912E-01_JPRB,0.40018E-01_JPRB,0.37361E-01_JPRB,0.35308E-01_JPRB, &
 & 0.33789E-01_JPRB,0.31702E-01_JPRB,0.29304E-01_JPRB,0.32735E-01_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.46255E-01_JPRB,0.42923E-01_JPRB,0.40617E-01_JPRB,0.38829E-01_JPRB,0.37399E-01_JPRB, &
 & 0.36167E-01_JPRB,0.34686E-01_JPRB,0.33312E-01_JPRB,0.37380E-01_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.49975E-01_JPRB,0.44361E-01_JPRB,0.40341E-01_JPRB,0.35539E-01_JPRB,0.31829E-01_JPRB, &
 & 0.27816E-01_JPRB,0.23845E-01_JPRB,0.20093E-01_JPRB,0.18543E-01_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.49828E-01_JPRB,0.44558E-01_JPRB,0.40763E-01_JPRB,0.36628E-01_JPRB,0.33050E-01_JPRB, &
 & 0.29095E-01_JPRB,0.26117E-01_JPRB,0.22673E-01_JPRB,0.22099E-01_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.49608E-01_JPRB,0.44841E-01_JPRB,0.41085E-01_JPRB,0.37793E-01_JPRB,0.34135E-01_JPRB, &
 & 0.31097E-01_JPRB,0.28755E-01_JPRB,0.25283E-01_JPRB,0.25831E-01_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.49365E-01_JPRB,0.45144E-01_JPRB,0.41922E-01_JPRB,0.38723E-01_JPRB,0.35845E-01_JPRB, &
 & 0.33431E-01_JPRB,0.31237E-01_JPRB,0.28118E-01_JPRB,0.29954E-01_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.49026E-01_JPRB,0.45249E-01_JPRB,0.42535E-01_JPRB,0.39993E-01_JPRB,0.37821E-01_JPRB, &
 & 0.35671E-01_JPRB,0.34099E-01_JPRB,0.31399E-01_JPRB,0.34366E-01_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.52410E-01_JPRB,0.46362E-01_JPRB,0.41901E-01_JPRB,0.37210E-01_JPRB,0.32800E-01_JPRB, &
 & 0.28263E-01_JPRB,0.23499E-01_JPRB,0.19230E-01_JPRB,0.16237E-01_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.52214E-01_JPRB,0.46505E-01_JPRB,0.42451E-01_JPRB,0.38113E-01_JPRB,0.34021E-01_JPRB, &
 & 0.29480E-01_JPRB,0.25464E-01_JPRB,0.21812E-01_JPRB,0.19595E-01_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.51982E-01_JPRB,0.46700E-01_JPRB,0.42867E-01_JPRB,0.39292E-01_JPRB,0.35048E-01_JPRB, &
 & 0.31222E-01_JPRB,0.27987E-01_JPRB,0.24489E-01_JPRB,0.23138E-01_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.51660E-01_JPRB,0.46904E-01_JPRB,0.43697E-01_JPRB,0.40172E-01_JPRB,0.36555E-01_JPRB, &
 & 0.33390E-01_JPRB,0.30506E-01_JPRB,0.27287E-01_JPRB,0.27036E-01_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.51284E-01_JPRB,0.47053E-01_JPRB,0.44408E-01_JPRB,0.41338E-01_JPRB,0.38429E-01_JPRB, &
 & 0.35446E-01_JPRB,0.33297E-01_JPRB,0.30383E-01_JPRB,0.31263E-01_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.53849E-01_JPRB,0.47597E-01_JPRB,0.43012E-01_JPRB,0.38373E-01_JPRB,0.33860E-01_JPRB, &
 & 0.28679E-01_JPRB,0.23391E-01_JPRB,0.18151E-01_JPRB,0.14106E-01_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.53641E-01_JPRB,0.47671E-01_JPRB,0.43475E-01_JPRB,0.39445E-01_JPRB,0.35042E-01_JPRB, &
 & 0.29924E-01_JPRB,0.25055E-01_JPRB,0.20655E-01_JPRB,0.17171E-01_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.53375E-01_JPRB,0.47826E-01_JPRB,0.44020E-01_JPRB,0.40653E-01_JPRB,0.36059E-01_JPRB, &
 & 0.31447E-01_JPRB,0.27345E-01_JPRB,0.23357E-01_JPRB,0.20383E-01_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.53001E-01_JPRB,0.48011E-01_JPRB,0.44999E-01_JPRB,0.41558E-01_JPRB,0.37354E-01_JPRB, &
 & 0.33601E-01_JPRB,0.29695E-01_JPRB,0.26106E-01_JPRB,0.24004E-01_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.52592E-01_JPRB,0.48152E-01_JPRB,0.45845E-01_JPRB,0.42585E-01_JPRB,0.39198E-01_JPRB, &
 & 0.35588E-01_JPRB,0.32287E-01_JPRB,0.29155E-01_JPRB,0.27991E-01_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.54223E-01_JPRB,0.47973E-01_JPRB,0.43289E-01_JPRB,0.38882E-01_JPRB,0.34299E-01_JPRB, &
 & 0.28946E-01_JPRB,0.23303E-01_JPRB,0.17068E-01_JPRB,0.11192E-01_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.53940E-01_JPRB,0.47929E-01_JPRB,0.43759E-01_JPRB,0.39916E-01_JPRB,0.35622E-01_JPRB, &
 & 0.30345E-01_JPRB,0.24752E-01_JPRB,0.19298E-01_JPRB,0.14778E-01_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.53642E-01_JPRB,0.48095E-01_JPRB,0.44399E-01_JPRB,0.41241E-01_JPRB,0.36768E-01_JPRB, &
 & 0.31745E-01_JPRB,0.26845E-01_JPRB,0.21914E-01_JPRB,0.17754E-01_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.53257E-01_JPRB,0.48243E-01_JPRB,0.45322E-01_JPRB,0.42327E-01_JPRB,0.37988E-01_JPRB, &
 & 0.33799E-01_JPRB,0.29109E-01_JPRB,0.24533E-01_JPRB,0.21056E-01_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.52778E-01_JPRB,0.48340E-01_JPRB,0.46365E-01_JPRB,0.43326E-01_JPRB,0.39837E-01_JPRB, &
 & 0.35758E-01_JPRB,0.31465E-01_JPRB,0.27467E-01_JPRB,0.24721E-01_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.53564E-01_JPRB,0.47520E-01_JPRB,0.42897E-01_JPRB,0.38870E-01_JPRB,0.34096E-01_JPRB, &
 & 0.28762E-01_JPRB,0.23161E-01_JPRB,0.16420E-01_JPRB,0.10403E-01_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.53200E-01_JPRB,0.47370E-01_JPRB,0.43390E-01_JPRB,0.39812E-01_JPRB,0.35374E-01_JPRB, &
 & 0.30449E-01_JPRB,0.24605E-01_JPRB,0.18329E-01_JPRB,0.12727E-01_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.52804E-01_JPRB,0.47486E-01_JPRB,0.44077E-01_JPRB,0.41029E-01_JPRB,0.36828E-01_JPRB, &
 & 0.31909E-01_JPRB,0.26518E-01_JPRB,0.20700E-01_JPRB,0.14792E-01_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.52379E-01_JPRB,0.47585E-01_JPRB,0.44997E-01_JPRB,0.42270E-01_JPRB,0.38168E-01_JPRB, &
 & 0.33930E-01_JPRB,0.28762E-01_JPRB,0.23052E-01_JPRB,0.16495E-01_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.51859E-01_JPRB,0.47629E-01_JPRB,0.45989E-01_JPRB,0.43387E-01_JPRB,0.40080E-01_JPRB, &
 & 0.36007E-01_JPRB,0.30957E-01_JPRB,0.25773E-01_JPRB,0.18898E-01_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.51622E-01_JPRB,0.46074E-01_JPRB,0.42057E-01_JPRB,0.38618E-01_JPRB,0.33808E-01_JPRB, &
 & 0.28847E-01_JPRB,0.23288E-01_JPRB,0.16620E-01_JPRB,0.11907E-01_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.51193E-01_JPRB,0.45980E-01_JPRB,0.42719E-01_JPRB,0.39541E-01_JPRB,0.35253E-01_JPRB, &
 & 0.30566E-01_JPRB,0.24931E-01_JPRB,0.18565E-01_JPRB,0.13988E-01_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.50740E-01_JPRB,0.46089E-01_JPRB,0.43457E-01_JPRB,0.40804E-01_JPRB,0.36736E-01_JPRB, &
 & 0.32310E-01_JPRB,0.27095E-01_JPRB,0.20684E-01_JPRB,0.16681E-01_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.50228E-01_JPRB,0.46105E-01_JPRB,0.44454E-01_JPRB,0.41838E-01_JPRB,0.38478E-01_JPRB, &
 & 0.34580E-01_JPRB,0.29293E-01_JPRB,0.22846E-01_JPRB,0.18301E-01_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.49697E-01_JPRB,0.46259E-01_JPRB,0.45191E-01_JPRB,0.43198E-01_JPRB,0.40635E-01_JPRB, &
 & 0.36709E-01_JPRB,0.31434E-01_JPRB,0.25478E-01_JPRB,0.20947E-01_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.48647E-01_JPRB,0.43752E-01_JPRB,0.40707E-01_JPRB,0.37500E-01_JPRB,0.33089E-01_JPRB, &
 & 0.28489E-01_JPRB,0.23000E-01_JPRB,0.16785E-01_JPRB,0.12627E-01_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.48181E-01_JPRB,0.43711E-01_JPRB,0.41312E-01_JPRB,0.38500E-01_JPRB,0.34693E-01_JPRB, &
 & 0.30128E-01_JPRB,0.24939E-01_JPRB,0.18673E-01_JPRB,0.15167E-01_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.47678E-01_JPRB,0.43812E-01_JPRB,0.42104E-01_JPRB,0.39699E-01_JPRB,0.36175E-01_JPRB, &
 & 0.32199E-01_JPRB,0.27269E-01_JPRB,0.20637E-01_JPRB,0.17826E-01_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.47181E-01_JPRB,0.43914E-01_JPRB,0.43002E-01_JPRB,0.40767E-01_JPRB,0.38218E-01_JPRB, &
 & 0.34662E-01_JPRB,0.29455E-01_JPRB,0.22728E-01_JPRB,0.19785E-01_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.46685E-01_JPRB,0.44343E-01_JPRB,0.43686E-01_JPRB,0.42426E-01_JPRB,0.40422E-01_JPRB, &
 & 0.36842E-01_JPRB,0.31692E-01_JPRB,0.25217E-01_JPRB,0.22679E-01_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.44854E-01_JPRB,0.40724E-01_JPRB,0.38672E-01_JPRB,0.35614E-01_JPRB,0.31949E-01_JPRB, &
 & 0.27602E-01_JPRB,0.22498E-01_JPRB,0.16720E-01_JPRB,0.12798E-01_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.44381E-01_JPRB,0.40833E-01_JPRB,0.39190E-01_JPRB,0.36792E-01_JPRB,0.33534E-01_JPRB, &
 & 0.29330E-01_JPRB,0.24604E-01_JPRB,0.18629E-01_JPRB,0.15661E-01_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.43916E-01_JPRB,0.40995E-01_JPRB,0.40051E-01_JPRB,0.37975E-01_JPRB,0.35149E-01_JPRB, &
 & 0.31642E-01_JPRB,0.27046E-01_JPRB,0.20453E-01_JPRB,0.17792E-01_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.43441E-01_JPRB,0.41288E-01_JPRB,0.40871E-01_JPRB,0.39278E-01_JPRB,0.37365E-01_JPRB, &
 & 0.34126E-01_JPRB,0.29213E-01_JPRB,0.22513E-01_JPRB,0.19591E-01_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.42963E-01_JPRB,0.41916E-01_JPRB,0.41758E-01_JPRB,0.41144E-01_JPRB,0.39580E-01_JPRB, &
 & 0.36327E-01_JPRB,0.31558E-01_JPRB,0.24885E-01_JPRB,0.22715E-01_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.52315E-01_JPRB,0.47505E-01_JPRB,0.42884E-01_JPRB,0.38287E-01_JPRB,0.34721E-01_JPRB, &
 & 0.30888E-01_JPRB,0.29687E-01_JPRB,0.33559E-01_JPRB,0.37791E-01_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.52132E-01_JPRB,0.47869E-01_JPRB,0.43358E-01_JPRB,0.39519E-01_JPRB,0.36490E-01_JPRB, &
 & 0.33059E-01_JPRB,0.34560E-01_JPRB,0.39434E-01_JPRB,0.44537E-01_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.51859E-01_JPRB,0.48259E-01_JPRB,0.44108E-01_JPRB,0.41053E-01_JPRB,0.38159E-01_JPRB, &
 & 0.36325E-01_JPRB,0.40345E-01_JPRB,0.46345E-01_JPRB,0.52382E-01_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.51556E-01_JPRB,0.48650E-01_JPRB,0.44992E-01_JPRB,0.42544E-01_JPRB,0.40704E-01_JPRB, &
 & 0.40160E-01_JPRB,0.46427E-01_JPRB,0.53431E-01_JPRB,0.60544E-01_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.51137E-01_JPRB,0.48860E-01_JPRB,0.46168E-01_JPRB,0.44111E-01_JPRB,0.43209E-01_JPRB, &
 & 0.44827E-01_JPRB,0.52800E-01_JPRB,0.60972E-01_JPRB,0.69216E-01_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.56434E-01_JPRB,0.51118E-01_JPRB,0.46217E-01_JPRB,0.41561E-01_JPRB,0.37505E-01_JPRB, &
 & 0.33646E-01_JPRB,0.30189E-01_JPRB,0.33085E-01_JPRB,0.37424E-01_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.56174E-01_JPRB,0.51590E-01_JPRB,0.46758E-01_JPRB,0.42838E-01_JPRB,0.39459E-01_JPRB, &
 & 0.35755E-01_JPRB,0.34261E-01_JPRB,0.38732E-01_JPRB,0.43938E-01_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.55870E-01_JPRB,0.52113E-01_JPRB,0.47459E-01_JPRB,0.44557E-01_JPRB,0.41223E-01_JPRB, &
 & 0.38732E-01_JPRB,0.39807E-01_JPRB,0.45508E-01_JPRB,0.51693E-01_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.55457E-01_JPRB,0.52524E-01_JPRB,0.48507E-01_JPRB,0.46112E-01_JPRB,0.43732E-01_JPRB, &
 & 0.42045E-01_JPRB,0.45811E-01_JPRB,0.52732E-01_JPRB,0.60004E-01_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.54996E-01_JPRB,0.52680E-01_JPRB,0.49849E-01_JPRB,0.47721E-01_JPRB,0.46514E-01_JPRB, &
 & 0.45961E-01_JPRB,0.52270E-01_JPRB,0.60294E-01_JPRB,0.68714E-01_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.59831E-01_JPRB,0.53764E-01_JPRB,0.48883E-01_JPRB,0.44361E-01_JPRB,0.39553E-01_JPRB, &
 & 0.35958E-01_JPRB,0.31293E-01_JPRB,0.31467E-01_JPRB,0.35795E-01_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.59532E-01_JPRB,0.54423E-01_JPRB,0.49485E-01_JPRB,0.45554E-01_JPRB,0.41889E-01_JPRB, &
 & 0.38044E-01_JPRB,0.34149E-01_JPRB,0.36846E-01_JPRB,0.42078E-01_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.59134E-01_JPRB,0.55152E-01_JPRB,0.50116E-01_JPRB,0.47410E-01_JPRB,0.43907E-01_JPRB, &
 & 0.40732E-01_JPRB,0.38444E-01_JPRB,0.43145E-01_JPRB,0.49218E-01_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.58672E-01_JPRB,0.55655E-01_JPRB,0.51271E-01_JPRB,0.49059E-01_JPRB,0.46360E-01_JPRB, &
 & 0.44063E-01_JPRB,0.43633E-01_JPRB,0.49781E-01_JPRB,0.56746E-01_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.58134E-01_JPRB,0.55813E-01_JPRB,0.52716E-01_JPRB,0.50709E-01_JPRB,0.49278E-01_JPRB, &
 & 0.47427E-01_JPRB,0.49630E-01_JPRB,0.57031E-01_JPRB,0.65034E-01_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.62624E-01_JPRB,0.55864E-01_JPRB,0.50884E-01_JPRB,0.46641E-01_JPRB,0.41202E-01_JPRB, &
 & 0.37808E-01_JPRB,0.32728E-01_JPRB,0.29634E-01_JPRB,0.33571E-01_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.62339E-01_JPRB,0.56365E-01_JPRB,0.51618E-01_JPRB,0.47600E-01_JPRB,0.43888E-01_JPRB, &
 & 0.40000E-01_JPRB,0.35145E-01_JPRB,0.34591E-01_JPRB,0.39469E-01_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.61969E-01_JPRB,0.57107E-01_JPRB,0.52103E-01_JPRB,0.49599E-01_JPRB,0.46112E-01_JPRB, &
 & 0.42482E-01_JPRB,0.38680E-01_JPRB,0.40578E-01_JPRB,0.46387E-01_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.61515E-01_JPRB,0.57939E-01_JPRB,0.53160E-01_JPRB,0.51347E-01_JPRB,0.48544E-01_JPRB, &
 & 0.45843E-01_JPRB,0.42689E-01_JPRB,0.46767E-01_JPRB,0.53378E-01_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.60986E-01_JPRB,0.58238E-01_JPRB,0.54658E-01_JPRB,0.53027E-01_JPRB,0.51696E-01_JPRB, &
 & 0.49388E-01_JPRB,0.47217E-01_JPRB,0.53278E-01_JPRB,0.60785E-01_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.65795E-01_JPRB,0.58347E-01_JPRB,0.52585E-01_JPRB,0.48437E-01_JPRB,0.42714E-01_JPRB, &
 & 0.39265E-01_JPRB,0.34039E-01_JPRB,0.28235E-01_JPRB,0.31421E-01_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.65486E-01_JPRB,0.58633E-01_JPRB,0.53696E-01_JPRB,0.49213E-01_JPRB,0.45420E-01_JPRB, &
 & 0.41668E-01_JPRB,0.36378E-01_JPRB,0.32647E-01_JPRB,0.37055E-01_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.65183E-01_JPRB,0.59134E-01_JPRB,0.54134E-01_JPRB,0.51097E-01_JPRB,0.47829E-01_JPRB, &
 & 0.44052E-01_JPRB,0.39727E-01_JPRB,0.38129E-01_JPRB,0.43417E-01_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.64717E-01_JPRB,0.59894E-01_JPRB,0.54954E-01_JPRB,0.53041E-01_JPRB,0.50294E-01_JPRB, &
 & 0.47344E-01_JPRB,0.43654E-01_JPRB,0.43889E-01_JPRB,0.49916E-01_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.64255E-01_JPRB,0.60489E-01_JPRB,0.56373E-01_JPRB,0.54824E-01_JPRB,0.53472E-01_JPRB, &
 & 0.51112E-01_JPRB,0.47282E-01_JPRB,0.50031E-01_JPRB,0.57102E-01_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.69615E-01_JPRB,0.61594E-01_JPRB,0.54882E-01_JPRB,0.50187E-01_JPRB,0.44074E-01_JPRB, &
 & 0.39997E-01_JPRB,0.34871E-01_JPRB,0.27743E-01_JPRB,0.29013E-01_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.69442E-01_JPRB,0.61757E-01_JPRB,0.55910E-01_JPRB,0.50997E-01_JPRB,0.46497E-01_JPRB, &
 & 0.42613E-01_JPRB,0.37188E-01_JPRB,0.31216E-01_JPRB,0.34347E-01_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.69156E-01_JPRB,0.62106E-01_JPRB,0.56750E-01_JPRB,0.52515E-01_JPRB,0.49101E-01_JPRB, &
 & 0.44986E-01_JPRB,0.40395E-01_JPRB,0.35961E-01_JPRB,0.40369E-01_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.68816E-01_JPRB,0.62627E-01_JPRB,0.57231E-01_JPRB,0.54601E-01_JPRB,0.51362E-01_JPRB, &
 & 0.48280E-01_JPRB,0.44442E-01_JPRB,0.41156E-01_JPRB,0.46554E-01_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.68355E-01_JPRB,0.63113E-01_JPRB,0.58516E-01_JPRB,0.56347E-01_JPRB,0.54360E-01_JPRB, &
 & 0.52199E-01_JPRB,0.48222E-01_JPRB,0.46871E-01_JPRB,0.53241E-01_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.74032E-01_JPRB,0.65393E-01_JPRB,0.58013E-01_JPRB,0.51965E-01_JPRB,0.45915E-01_JPRB, &
 & 0.40526E-01_JPRB,0.35125E-01_JPRB,0.27883E-01_JPRB,0.26586E-01_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.73937E-01_JPRB,0.65493E-01_JPRB,0.58738E-01_JPRB,0.53263E-01_JPRB,0.47941E-01_JPRB, &
 & 0.43149E-01_JPRB,0.37585E-01_JPRB,0.30874E-01_JPRB,0.31614E-01_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.73662E-01_JPRB,0.65759E-01_JPRB,0.59591E-01_JPRB,0.54630E-01_JPRB,0.50354E-01_JPRB, &
 & 0.45514E-01_JPRB,0.40708E-01_JPRB,0.34889E-01_JPRB,0.37383E-01_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.73359E-01_JPRB,0.66187E-01_JPRB,0.60275E-01_JPRB,0.56599E-01_JPRB,0.52392E-01_JPRB, &
 & 0.48574E-01_JPRB,0.44791E-01_JPRB,0.39333E-01_JPRB,0.43356E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART9',0,ZHOOK_HANDLE)


KA(:, 5, 7,12) = (/ &
 & 0.72923E-01_JPRB,0.66589E-01_JPRB,0.61432E-01_JPRB,0.58168E-01_JPRB,0.55043E-01_JPRB, &
 & 0.52561E-01_JPRB,0.48755E-01_JPRB,0.44300E-01_JPRB,0.49765E-01_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.78458E-01_JPRB,0.69177E-01_JPRB,0.61142E-01_JPRB,0.54247E-01_JPRB,0.47727E-01_JPRB, &
 & 0.41456E-01_JPRB,0.34819E-01_JPRB,0.27717E-01_JPRB,0.23941E-01_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.78410E-01_JPRB,0.69294E-01_JPRB,0.61857E-01_JPRB,0.55492E-01_JPRB,0.49764E-01_JPRB, &
 & 0.43844E-01_JPRB,0.37501E-01_JPRB,0.30644E-01_JPRB,0.28737E-01_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.78162E-01_JPRB,0.69463E-01_JPRB,0.62578E-01_JPRB,0.57026E-01_JPRB,0.52068E-01_JPRB, &
 & 0.46044E-01_JPRB,0.40472E-01_JPRB,0.34561E-01_JPRB,0.34380E-01_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.77871E-01_JPRB,0.69834E-01_JPRB,0.63268E-01_JPRB,0.59074E-01_JPRB,0.53918E-01_JPRB, &
 & 0.48672E-01_JPRB,0.44601E-01_JPRB,0.38671E-01_JPRB,0.40158E-01_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.77487E-01_JPRB,0.70209E-01_JPRB,0.64405E-01_JPRB,0.60632E-01_JPRB,0.56120E-01_JPRB, &
 & 0.52504E-01_JPRB,0.48787E-01_JPRB,0.42980E-01_JPRB,0.46410E-01_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.82666E-01_JPRB,0.72734E-01_JPRB,0.64105E-01_JPRB,0.56594E-01_JPRB,0.49561E-01_JPRB, &
 & 0.42281E-01_JPRB,0.34472E-01_JPRB,0.27105E-01_JPRB,0.21191E-01_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.82602E-01_JPRB,0.72866E-01_JPRB,0.64825E-01_JPRB,0.57780E-01_JPRB,0.51415E-01_JPRB, &
 & 0.44682E-01_JPRB,0.37233E-01_JPRB,0.30003E-01_JPRB,0.25697E-01_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.82349E-01_JPRB,0.72898E-01_JPRB,0.65478E-01_JPRB,0.59213E-01_JPRB,0.53844E-01_JPRB, &
 & 0.46925E-01_JPRB,0.39994E-01_JPRB,0.33830E-01_JPRB,0.31116E-01_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.82004E-01_JPRB,0.73222E-01_JPRB,0.66214E-01_JPRB,0.61303E-01_JPRB,0.55771E-01_JPRB, &
 & 0.49206E-01_JPRB,0.43963E-01_JPRB,0.38199E-01_JPRB,0.36759E-01_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.81608E-01_JPRB,0.73612E-01_JPRB,0.67180E-01_JPRB,0.63056E-01_JPRB,0.57653E-01_JPRB, &
 & 0.52653E-01_JPRB,0.48283E-01_JPRB,0.42441E-01_JPRB,0.42846E-01_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.85880E-01_JPRB,0.75430E-01_JPRB,0.66656E-01_JPRB,0.58773E-01_JPRB,0.51658E-01_JPRB, &
 & 0.43336E-01_JPRB,0.34393E-01_JPRB,0.26157E-01_JPRB,0.14663E-01_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.85756E-01_JPRB,0.75590E-01_JPRB,0.67337E-01_JPRB,0.60049E-01_JPRB,0.53266E-01_JPRB, &
 & 0.45473E-01_JPRB,0.37278E-01_JPRB,0.29125E-01_JPRB,0.16193E-01_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.85530E-01_JPRB,0.75588E-01_JPRB,0.67995E-01_JPRB,0.61462E-01_JPRB,0.55345E-01_JPRB, &
 & 0.48001E-01_JPRB,0.39939E-01_JPRB,0.32883E-01_JPRB,0.20331E-01_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.85095E-01_JPRB,0.75810E-01_JPRB,0.68684E-01_JPRB,0.63320E-01_JPRB,0.57485E-01_JPRB, &
 & 0.50257E-01_JPRB,0.43559E-01_JPRB,0.37443E-01_JPRB,0.23682E-01_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.84667E-01_JPRB,0.76211E-01_JPRB,0.69733E-01_JPRB,0.65095E-01_JPRB,0.59445E-01_JPRB, &
 & 0.53380E-01_JPRB,0.47785E-01_JPRB,0.41863E-01_JPRB,0.26616E-01_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.87471E-01_JPRB,0.76929E-01_JPRB,0.68322E-01_JPRB,0.60781E-01_JPRB,0.53951E-01_JPRB, &
 & 0.45056E-01_JPRB,0.35758E-01_JPRB,0.26371E-01_JPRB,0.18858E-01_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.87208E-01_JPRB,0.76940E-01_JPRB,0.68996E-01_JPRB,0.62212E-01_JPRB,0.55582E-01_JPRB, &
 & 0.47319E-01_JPRB,0.38590E-01_JPRB,0.29478E-01_JPRB,0.21575E-01_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.86835E-01_JPRB,0.76905E-01_JPRB,0.69723E-01_JPRB,0.63816E-01_JPRB,0.57699E-01_JPRB, &
 & 0.49745E-01_JPRB,0.41432E-01_JPRB,0.33605E-01_JPRB,0.25460E-01_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.86430E-01_JPRB,0.77295E-01_JPRB,0.70629E-01_JPRB,0.65834E-01_JPRB,0.59545E-01_JPRB, &
 & 0.52341E-01_JPRB,0.45178E-01_JPRB,0.38243E-01_JPRB,0.30364E-01_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.85874E-01_JPRB,0.77597E-01_JPRB,0.72138E-01_JPRB,0.67497E-01_JPRB,0.61709E-01_JPRB, &
 & 0.55855E-01_JPRB,0.49191E-01_JPRB,0.42789E-01_JPRB,0.33235E-01_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.87248E-01_JPRB,0.76929E-01_JPRB,0.68689E-01_JPRB,0.62001E-01_JPRB,0.55189E-01_JPRB, &
 & 0.46282E-01_JPRB,0.37018E-01_JPRB,0.26535E-01_JPRB,0.20617E-01_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.86938E-01_JPRB,0.76894E-01_JPRB,0.69591E-01_JPRB,0.63473E-01_JPRB,0.56879E-01_JPRB, &
 & 0.48866E-01_JPRB,0.39681E-01_JPRB,0.29869E-01_JPRB,0.23753E-01_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.86505E-01_JPRB,0.76936E-01_JPRB,0.70473E-01_JPRB,0.65213E-01_JPRB,0.59161E-01_JPRB, &
 & 0.51227E-01_JPRB,0.42751E-01_JPRB,0.34068E-01_JPRB,0.28028E-01_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.86014E-01_JPRB,0.77389E-01_JPRB,0.71734E-01_JPRB,0.67391E-01_JPRB,0.61041E-01_JPRB, &
 & 0.54172E-01_JPRB,0.46740E-01_JPRB,0.38524E-01_JPRB,0.33947E-01_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.85424E-01_JPRB,0.77682E-01_JPRB,0.73622E-01_JPRB,0.69056E-01_JPRB,0.63676E-01_JPRB, &
 & 0.57877E-01_JPRB,0.50578E-01_JPRB,0.43087E-01_JPRB,0.36933E-01_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.85419E-01_JPRB,0.75627E-01_JPRB,0.68076E-01_JPRB,0.62306E-01_JPRB,0.55288E-01_JPRB, &
 & 0.46939E-01_JPRB,0.37782E-01_JPRB,0.26869E-01_JPRB,0.20535E-01_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.84985E-01_JPRB,0.75524E-01_JPRB,0.69213E-01_JPRB,0.63729E-01_JPRB,0.57271E-01_JPRB, &
 & 0.49714E-01_JPRB,0.40473E-01_JPRB,0.30181E-01_JPRB,0.22959E-01_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.84529E-01_JPRB,0.75748E-01_JPRB,0.70315E-01_JPRB,0.65749E-01_JPRB,0.59660E-01_JPRB, &
 & 0.52260E-01_JPRB,0.43766E-01_JPRB,0.34359E-01_JPRB,0.28707E-01_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.84038E-01_JPRB,0.76252E-01_JPRB,0.71947E-01_JPRB,0.67890E-01_JPRB,0.61874E-01_JPRB, &
 & 0.55511E-01_JPRB,0.47935E-01_JPRB,0.38594E-01_JPRB,0.34330E-01_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.83450E-01_JPRB,0.76542E-01_JPRB,0.73924E-01_JPRB,0.69752E-01_JPRB,0.64960E-01_JPRB, &
 & 0.59356E-01_JPRB,0.51789E-01_JPRB,0.43079E-01_JPRB,0.38051E-01_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.68561E-01_JPRB,0.61393E-01_JPRB,0.55377E-01_JPRB,0.48367E-01_JPRB,0.42682E-01_JPRB, &
 & 0.39908E-01_JPRB,0.45275E-01_JPRB,0.51909E-01_JPRB,0.58629E-01_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.68429E-01_JPRB,0.62258E-01_JPRB,0.56444E-01_JPRB,0.49529E-01_JPRB,0.45167E-01_JPRB, &
 & 0.45643E-01_JPRB,0.53469E-01_JPRB,0.61626E-01_JPRB,0.69870E-01_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.68224E-01_JPRB,0.62810E-01_JPRB,0.57169E-01_JPRB,0.51186E-01_JPRB,0.48224E-01_JPRB, &
 & 0.52899E-01_JPRB,0.62764E-01_JPRB,0.72521E-01_JPRB,0.82353E-01_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.67917E-01_JPRB,0.63314E-01_JPRB,0.58187E-01_JPRB,0.53334E-01_JPRB,0.52038E-01_JPRB, &
 & 0.61434E-01_JPRB,0.73273E-01_JPRB,0.84850E-01_JPRB,0.96479E-01_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.67553E-01_JPRB,0.63903E-01_JPRB,0.59193E-01_JPRB,0.55737E-01_JPRB,0.58351E-01_JPRB, &
 & 0.71682E-01_JPRB,0.85665E-01_JPRB,0.99285E-01_JPRB,0.11295E+00_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.77509E-01_JPRB,0.69079E-01_JPRB,0.62486E-01_JPRB,0.54626E-01_JPRB,0.48075E-01_JPRB, &
 & 0.42537E-01_JPRB,0.44950E-01_JPRB,0.51477E-01_JPRB,0.58558E-01_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.77430E-01_JPRB,0.69950E-01_JPRB,0.63742E-01_JPRB,0.55764E-01_JPRB,0.50627E-01_JPRB, &
 & 0.46853E-01_JPRB,0.52532E-01_JPRB,0.60374E-01_JPRB,0.68733E-01_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.77189E-01_JPRB,0.70882E-01_JPRB,0.64573E-01_JPRB,0.57536E-01_JPRB,0.53311E-01_JPRB, &
 & 0.52406E-01_JPRB,0.61244E-01_JPRB,0.70634E-01_JPRB,0.80523E-01_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.76847E-01_JPRB,0.71588E-01_JPRB,0.65635E-01_JPRB,0.59928E-01_JPRB,0.56064E-01_JPRB, &
 & 0.60283E-01_JPRB,0.71500E-01_JPRB,0.82577E-01_JPRB,0.94220E-01_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.76386E-01_JPRB,0.72289E-01_JPRB,0.66796E-01_JPRB,0.62420E-01_JPRB,0.60016E-01_JPRB, &
 & 0.69350E-01_JPRB,0.82634E-01_JPRB,0.95798E-01_JPRB,0.10925E+00_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.86533E-01_JPRB,0.76872E-01_JPRB,0.69252E-01_JPRB,0.60999E-01_JPRB,0.53444E-01_JPRB, &
 & 0.46117E-01_JPRB,0.43982E-01_JPRB,0.49772E-01_JPRB,0.56991E-01_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.86412E-01_JPRB,0.77388E-01_JPRB,0.71047E-01_JPRB,0.62031E-01_JPRB,0.55847E-01_JPRB, &
 & 0.49560E-01_JPRB,0.50601E-01_JPRB,0.57831E-01_JPRB,0.66136E-01_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.86175E-01_JPRB,0.78253E-01_JPRB,0.72126E-01_JPRB,0.63678E-01_JPRB,0.58875E-01_JPRB, &
 & 0.53556E-01_JPRB,0.58645E-01_JPRB,0.67397E-01_JPRB,0.77181E-01_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.85802E-01_JPRB,0.79483E-01_JPRB,0.72991E-01_JPRB,0.66186E-01_JPRB,0.61530E-01_JPRB, &
 & 0.59229E-01_JPRB,0.68328E-01_JPRB,0.78749E-01_JPRB,0.90335E-01_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.85328E-01_JPRB,0.80671E-01_JPRB,0.74346E-01_JPRB,0.68871E-01_JPRB,0.64555E-01_JPRB, &
 & 0.67267E-01_JPRB,0.79478E-01_JPRB,0.91684E-01_JPRB,0.10533E+00_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.95394E-01_JPRB,0.84557E-01_JPRB,0.75442E-01_JPRB,0.67038E-01_JPRB,0.59073E-01_JPRB, &
 & 0.49886E-01_JPRB,0.44642E-01_JPRB,0.48508E-01_JPRB,0.55658E-01_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.95223E-01_JPRB,0.84873E-01_JPRB,0.77588E-01_JPRB,0.68316E-01_JPRB,0.60993E-01_JPRB, &
 & 0.53907E-01_JPRB,0.49824E-01_JPRB,0.55820E-01_JPRB,0.64074E-01_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.94965E-01_JPRB,0.85575E-01_JPRB,0.79290E-01_JPRB,0.69694E-01_JPRB,0.64420E-01_JPRB, &
 & 0.57295E-01_JPRB,0.56440E-01_JPRB,0.64306E-01_JPRB,0.73964E-01_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.94509E-01_JPRB,0.86370E-01_JPRB,0.80294E-01_JPRB,0.72257E-01_JPRB,0.67415E-01_JPRB, &
 & 0.61388E-01_JPRB,0.65357E-01_JPRB,0.74991E-01_JPRB,0.86332E-01_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.94009E-01_JPRB,0.87806E-01_JPRB,0.81595E-01_JPRB,0.75171E-01_JPRB,0.70245E-01_JPRB, &
 & 0.67536E-01_JPRB,0.76274E-01_JPRB,0.87845E-01_JPRB,0.10132E+00_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.10343E+00_JPRB,0.91525E-01_JPRB,0.80861E-01_JPRB,0.72378E-01_JPRB,0.64406E-01_JPRB, &
 & 0.53983E-01_JPRB,0.47036E-01_JPRB,0.47125E-01_JPRB,0.54095E-01_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.10334E+00_JPRB,0.91907E-01_JPRB,0.82762E-01_JPRB,0.74349E-01_JPRB,0.66049E-01_JPRB, &
 & 0.58213E-01_JPRB,0.51290E-01_JPRB,0.53990E-01_JPRB,0.61913E-01_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.10297E+00_JPRB,0.92357E-01_JPRB,0.85393E-01_JPRB,0.75564E-01_JPRB,0.69527E-01_JPRB, &
 & 0.62165E-01_JPRB,0.56265E-01_JPRB,0.62011E-01_JPRB,0.71236E-01_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.10256E+00_JPRB,0.93114E-01_JPRB,0.87093E-01_JPRB,0.77935E-01_JPRB,0.73042E-01_JPRB, &
 & 0.65986E-01_JPRB,0.63498E-01_JPRB,0.72109E-01_JPRB,0.83127E-01_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.10189E+00_JPRB,0.94299E-01_JPRB,0.88282E-01_JPRB,0.81218E-01_JPRB,0.76035E-01_JPRB, &
 & 0.70876E-01_JPRB,0.73640E-01_JPRB,0.84406E-01_JPRB,0.97393E-01_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.11045E+00_JPRB,0.97454E-01_JPRB,0.85408E-01_JPRB,0.76244E-01_JPRB,0.68972E-01_JPRB, &
 & 0.58251E-01_JPRB,0.49930E-01_JPRB,0.45374E-01_JPRB,0.51875E-01_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.11019E+00_JPRB,0.97819E-01_JPRB,0.87148E-01_JPRB,0.79069E-01_JPRB,0.71021E-01_JPRB, &
 & 0.62071E-01_JPRB,0.54179E-01_JPRB,0.52124E-01_JPRB,0.59618E-01_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.10981E+00_JPRB,0.98088E-01_JPRB,0.89384E-01_JPRB,0.81156E-01_JPRB,0.73973E-01_JPRB, &
 & 0.66762E-01_JPRB,0.58141E-01_JPRB,0.59499E-01_JPRB,0.68391E-01_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.10923E+00_JPRB,0.98741E-01_JPRB,0.91856E-01_JPRB,0.83093E-01_JPRB,0.78121E-01_JPRB, &
 & 0.70717E-01_JPRB,0.63590E-01_JPRB,0.68985E-01_JPRB,0.79490E-01_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.10855E+00_JPRB,0.99728E-01_JPRB,0.93768E-01_JPRB,0.86485E-01_JPRB,0.81499E-01_JPRB, &
 & 0.75384E-01_JPRB,0.71738E-01_JPRB,0.80634E-01_JPRB,0.92951E-01_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.11652E+00_JPRB,0.10245E+00_JPRB,0.89345E-01_JPRB,0.79831E-01_JPRB,0.71546E-01_JPRB, &
 & 0.62110E-01_JPRB,0.52889E-01_JPRB,0.43937E-01_JPRB,0.49094E-01_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.11624E+00_JPRB,0.10291E+00_JPRB,0.90769E-01_JPRB,0.82143E-01_JPRB,0.74705E-01_JPRB, &
 & 0.65752E-01_JPRB,0.57383E-01_JPRB,0.50125E-01_JPRB,0.56751E-01_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.11594E+00_JPRB,0.10317E+00_JPRB,0.92734E-01_JPRB,0.84722E-01_JPRB,0.77935E-01_JPRB, &
 & 0.70772E-01_JPRB,0.61416E-01_JPRB,0.57153E-01_JPRB,0.65344E-01_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.11535E+00_JPRB,0.10356E+00_JPRB,0.95024E-01_JPRB,0.87242E-01_JPRB,0.82357E-01_JPRB, &
 & 0.75212E-01_JPRB,0.65866E-01_JPRB,0.66110E-01_JPRB,0.76048E-01_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.11474E+00_JPRB,0.10447E+00_JPRB,0.97059E-01_JPRB,0.90869E-01_JPRB,0.86343E-01_JPRB, &
 & 0.79806E-01_JPRB,0.72467E-01_JPRB,0.77014E-01_JPRB,0.88751E-01_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.12265E+00_JPRB,0.10756E+00_JPRB,0.93593E-01_JPRB,0.82964E-01_JPRB,0.73576E-01_JPRB, &
 & 0.64374E-01_JPRB,0.55605E-01_JPRB,0.43559E-01_JPRB,0.46060E-01_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.12249E+00_JPRB,0.10812E+00_JPRB,0.94575E-01_JPRB,0.84973E-01_JPRB,0.76683E-01_JPRB, &
 & 0.68823E-01_JPRB,0.60052E-01_JPRB,0.49117E-01_JPRB,0.53798E-01_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.12216E+00_JPRB,0.10834E+00_JPRB,0.96338E-01_JPRB,0.87360E-01_JPRB,0.80349E-01_JPRB, &
 & 0.74206E-01_JPRB,0.64654E-01_JPRB,0.55074E-01_JPRB,0.62031E-01_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.12168E+00_JPRB,0.10860E+00_JPRB,0.98251E-01_JPRB,0.89888E-01_JPRB,0.85251E-01_JPRB, &
 & 0.79126E-01_JPRB,0.69120E-01_JPRB,0.63252E-01_JPRB,0.72334E-01_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.12099E+00_JPRB,0.10931E+00_JPRB,0.10017E+00_JPRB,0.93685E-01_JPRB,0.90048E-01_JPRB, &
 & 0.83711E-01_JPRB,0.75096E-01_JPRB,0.73779E-01_JPRB,0.84712E-01_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.12914E+00_JPRB,0.11313E+00_JPRB,0.98462E-01_JPRB,0.86441E-01_JPRB,0.75875E-01_JPRB, &
 & 0.66332E-01_JPRB,0.57013E-01_JPRB,0.43839E-01_JPRB,0.42411E-01_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.12911E+00_JPRB,0.11365E+00_JPRB,0.99113E-01_JPRB,0.88386E-01_JPRB,0.78651E-01_JPRB, &
 & 0.70676E-01_JPRB,0.61767E-01_JPRB,0.49076E-01_JPRB,0.50412E-01_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.12886E+00_JPRB,0.11401E+00_JPRB,0.10056E+00_JPRB,0.90400E-01_JPRB,0.82030E-01_JPRB, &
 & 0.75969E-01_JPRB,0.67212E-01_JPRB,0.54346E-01_JPRB,0.58598E-01_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.12844E+00_JPRB,0.11410E+00_JPRB,0.10221E+00_JPRB,0.92662E-01_JPRB,0.86791E-01_JPRB, &
 & 0.81685E-01_JPRB,0.71813E-01_JPRB,0.61251E-01_JPRB,0.68599E-01_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.12781E+00_JPRB,0.11455E+00_JPRB,0.10390E+00_JPRB,0.96184E-01_JPRB,0.92217E-01_JPRB, &
 & 0.86557E-01_JPRB,0.77640E-01_JPRB,0.70636E-01_JPRB,0.80447E-01_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.13661E+00_JPRB,0.11963E+00_JPRB,0.10401E+00_JPRB,0.90612E-01_JPRB,0.78552E-01_JPRB, &
 & 0.68665E-01_JPRB,0.58042E-01_JPRB,0.44182E-01_JPRB,0.20623E-01_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.13663E+00_JPRB,0.12000E+00_JPRB,0.10449E+00_JPRB,0.92427E-01_JPRB,0.81459E-01_JPRB, &
 & 0.72606E-01_JPRB,0.62588E-01_JPRB,0.49634E-01_JPRB,0.27517E-01_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.13648E+00_JPRB,0.12048E+00_JPRB,0.10572E+00_JPRB,0.94344E-01_JPRB,0.84635E-01_JPRB, &
 & 0.77264E-01_JPRB,0.68466E-01_JPRB,0.54964E-01_JPRB,0.37460E-01_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.13615E+00_JPRB,0.12055E+00_JPRB,0.10724E+00_JPRB,0.96538E-01_JPRB,0.88921E-01_JPRB, &
 & 0.82919E-01_JPRB,0.73837E-01_JPRB,0.61121E-01_JPRB,0.51408E-01_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.13560E+00_JPRB,0.12083E+00_JPRB,0.10867E+00_JPRB,0.99719E-01_JPRB,0.94157E-01_JPRB, &
 & 0.88097E-01_JPRB,0.79982E-01_JPRB,0.69630E-01_JPRB,0.68524E-01_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.14486E+00_JPRB,0.12685E+00_JPRB,0.11053E+00_JPRB,0.96215E-01_JPRB,0.83198E-01_JPRB, &
 & 0.72790E-01_JPRB,0.60483E-01_JPRB,0.46368E-01_JPRB,0.23123E-01_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.14497E+00_JPRB,0.12740E+00_JPRB,0.11115E+00_JPRB,0.98058E-01_JPRB,0.86138E-01_JPRB, &
 & 0.76317E-01_JPRB,0.65283E-01_JPRB,0.52226E-01_JPRB,0.29160E-01_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.14473E+00_JPRB,0.12775E+00_JPRB,0.11243E+00_JPRB,0.99891E-01_JPRB,0.89493E-01_JPRB, &
 & 0.80996E-01_JPRB,0.71303E-01_JPRB,0.57950E-01_JPRB,0.32977E-01_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.14430E+00_JPRB,0.12774E+00_JPRB,0.11386E+00_JPRB,0.10223E+00_JPRB,0.94098E-01_JPRB, &
 & 0.86252E-01_JPRB,0.77087E-01_JPRB,0.64785E-01_JPRB,0.38714E-01_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.14365E+00_JPRB,0.12806E+00_JPRB,0.11504E+00_JPRB,0.10578E+00_JPRB,0.98766E-01_JPRB, &
 & 0.91283E-01_JPRB,0.84242E-01_JPRB,0.73581E-01_JPRB,0.47497E-01_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.15269E+00_JPRB,0.13372E+00_JPRB,0.11691E+00_JPRB,0.10167E+00_JPRB,0.88459E-01_JPRB, &
 & 0.76634E-01_JPRB,0.62620E-01_JPRB,0.48153E-01_JPRB,0.27858E-01_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.15257E+00_JPRB,0.13415E+00_JPRB,0.11750E+00_JPRB,0.10380E+00_JPRB,0.91589E-01_JPRB, &
 & 0.79898E-01_JPRB,0.67862E-01_JPRB,0.54271E-01_JPRB,0.35587E-01_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.15233E+00_JPRB,0.13449E+00_JPRB,0.11899E+00_JPRB,0.10589E+00_JPRB,0.94966E-01_JPRB, &
 & 0.84666E-01_JPRB,0.73653E-01_JPRB,0.60551E-01_JPRB,0.39809E-01_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.15175E+00_JPRB,0.13439E+00_JPRB,0.12031E+00_JPRB,0.10854E+00_JPRB,0.99506E-01_JPRB, &
 & 0.89389E-01_JPRB,0.79517E-01_JPRB,0.68401E-01_JPRB,0.45578E-01_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.15105E+00_JPRB,0.13484E+00_JPRB,0.12149E+00_JPRB,0.11242E+00_JPRB,0.10353E+00_JPRB, &
 & 0.94548E-01_JPRB,0.87485E-01_JPRB,0.77323E-01_JPRB,0.55990E-01_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.15929E+00_JPRB,0.13953E+00_JPRB,0.12252E+00_JPRB,0.10682E+00_JPRB,0.93710E-01_JPRB, &
 & 0.80318E-01_JPRB,0.64679E-01_JPRB,0.49483E-01_JPRB,0.31231E-01_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.15914E+00_JPRB,0.14001E+00_JPRB,0.12322E+00_JPRB,0.10931E+00_JPRB,0.96798E-01_JPRB, &
 & 0.83533E-01_JPRB,0.70039E-01_JPRB,0.55928E-01_JPRB,0.39440E-01_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.15875E+00_JPRB,0.14019E+00_JPRB,0.12484E+00_JPRB,0.11161E+00_JPRB,0.10034E+00_JPRB, &
 & 0.88309E-01_JPRB,0.75681E-01_JPRB,0.62757E-01_JPRB,0.43280E-01_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.15815E+00_JPRB,0.14019E+00_JPRB,0.12619E+00_JPRB,0.11467E+00_JPRB,0.10492E+00_JPRB, &
 & 0.92849E-01_JPRB,0.81796E-01_JPRB,0.71221E-01_JPRB,0.50343E-01_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.15737E+00_JPRB,0.14077E+00_JPRB,0.12756E+00_JPRB,0.11888E+00_JPRB,0.10868E+00_JPRB, &
 & 0.98192E-01_JPRB,0.90106E-01_JPRB,0.80417E-01_JPRB,0.60332E-01_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.83965E-01_JPRB,0.74725E-01_JPRB,0.67262E-01_JPRB,0.61439E-01_JPRB,0.63569E-01_JPRB, &
 & 0.76568E-01_JPRB,0.91505E-01_JPRB,0.10604E+00_JPRB,0.12066E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART10',0,ZHOOK_HANDLE)


KA(:, 2, 1,14) = (/ &
 & 0.84124E-01_JPRB,0.75639E-01_JPRB,0.69121E-01_JPRB,0.66761E-01_JPRB,0.75177E-01_JPRB, &
 & 0.93190E-01_JPRB,0.11140E+00_JPRB,0.12912E+00_JPRB,0.14697E+00_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.84208E-01_JPRB,0.76821E-01_JPRB,0.71401E-01_JPRB,0.74638E-01_JPRB,0.90938E-01_JPRB, &
 & 0.11330E+00_JPRB,0.13555E+00_JPRB,0.15732E+00_JPRB,0.17919E+00_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.84082E-01_JPRB,0.77722E-01_JPRB,0.74753E-01_JPRB,0.85505E-01_JPRB,0.11037E+00_JPRB, &
 & 0.13754E+00_JPRB,0.16460E+00_JPRB,0.19114E+00_JPRB,0.21779E+00_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.83810E-01_JPRB,0.78431E-01_JPRB,0.79767E-01_JPRB,0.99722E-01_JPRB,0.13195E+00_JPRB, &
 & 0.16448E+00_JPRB,0.19691E+00_JPRB,0.22867E+00_JPRB,0.26057E+00_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.98728E-01_JPRB,0.87584E-01_JPRB,0.78635E-01_JPRB,0.69559E-01_JPRB,0.65625E-01_JPRB, &
 & 0.74022E-01_JPRB,0.88098E-01_JPRB,0.10177E+00_JPRB,0.11620E+00_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.98895E-01_JPRB,0.88195E-01_JPRB,0.80583E-01_JPRB,0.73010E-01_JPRB,0.73981E-01_JPRB, &
 & 0.89007E-01_JPRB,0.10638E+00_JPRB,0.12319E+00_JPRB,0.14079E+00_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.98911E-01_JPRB,0.89265E-01_JPRB,0.82581E-01_JPRB,0.78421E-01_JPRB,0.87111E-01_JPRB, &
 & 0.10783E+00_JPRB,0.12893E+00_JPRB,0.14951E+00_JPRB,0.17084E+00_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.98795E-01_JPRB,0.90737E-01_JPRB,0.84451E-01_JPRB,0.86623E-01_JPRB,0.10466E+00_JPRB, &
 & 0.13034E+00_JPRB,0.15592E+00_JPRB,0.18094E+00_JPRB,0.20669E+00_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.98517E-01_JPRB,0.92027E-01_JPRB,0.87783E-01_JPRB,0.98306E-01_JPRB,0.12592E+00_JPRB, &
 & 0.15706E+00_JPRB,0.18794E+00_JPRB,0.21816E+00_JPRB,0.24934E+00_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.11536E+00_JPRB,0.10204E+00_JPRB,0.91076E-01_JPRB,0.79879E-01_JPRB,0.70411E-01_JPRB, &
 & 0.71590E-01_JPRB,0.83610E-01_JPRB,0.96241E-01_JPRB,0.11049E+00_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.11565E+00_JPRB,0.10277E+00_JPRB,0.93049E-01_JPRB,0.82303E-01_JPRB,0.75267E-01_JPRB, &
 & 0.83499E-01_JPRB,0.99323E-01_JPRB,0.11472E+00_JPRB,0.13181E+00_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.11566E+00_JPRB,0.10353E+00_JPRB,0.95697E-01_JPRB,0.85227E-01_JPRB,0.84157E-01_JPRB, &
 & 0.99917E-01_JPRB,0.11933E+00_JPRB,0.13815E+00_JPRB,0.15865E+00_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.11554E+00_JPRB,0.10447E+00_JPRB,0.97554E-01_JPRB,0.90504E-01_JPRB,0.97960E-01_JPRB, &
 & 0.12029E+00_JPRB,0.14386E+00_JPRB,0.16671E+00_JPRB,0.19135E+00_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.11515E+00_JPRB,0.10586E+00_JPRB,0.99141E-01_JPRB,0.99110E-01_JPRB,0.11626E+00_JPRB, &
 & 0.14432E+00_JPRB,0.17265E+00_JPRB,0.20040E+00_JPRB,0.22976E+00_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.13374E+00_JPRB,0.11777E+00_JPRB,0.10356E+00_JPRB,0.90948E-01_JPRB,0.79121E-01_JPRB, &
 & 0.73845E-01_JPRB,0.80790E-01_JPRB,0.92777E-01_JPRB,0.10713E+00_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.13413E+00_JPRB,0.11892E+00_JPRB,0.10607E+00_JPRB,0.94460E-01_JPRB,0.81628E-01_JPRB, &
 & 0.80960E-01_JPRB,0.93972E-01_JPRB,0.10817E+00_JPRB,0.12489E+00_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.13429E+00_JPRB,0.11957E+00_JPRB,0.10936E+00_JPRB,0.96737E-01_JPRB,0.86452E-01_JPRB, &
 & 0.93977E-01_JPRB,0.11135E+00_JPRB,0.12854E+00_JPRB,0.14815E+00_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.13415E+00_JPRB,0.12054E+00_JPRB,0.11264E+00_JPRB,0.99496E-01_JPRB,0.96100E-01_JPRB, &
 & 0.11145E+00_JPRB,0.13299E+00_JPRB,0.15385E+00_JPRB,0.17718E+00_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.13374E+00_JPRB,0.12142E+00_JPRB,0.11440E+00_JPRB,0.10500E+00_JPRB,0.11046E+00_JPRB, &
 & 0.13295E+00_JPRB,0.15886E+00_JPRB,0.18424E+00_JPRB,0.21188E+00_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.15386E+00_JPRB,0.13491E+00_JPRB,0.11798E+00_JPRB,0.10225E+00_JPRB,0.89703E-01_JPRB, &
 & 0.79220E-01_JPRB,0.79340E-01_JPRB,0.90595E-01_JPRB,0.10482E+00_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.15427E+00_JPRB,0.13635E+00_JPRB,0.12030E+00_JPRB,0.10668E+00_JPRB,0.92323E-01_JPRB, &
 & 0.84157E-01_JPRB,0.91777E-01_JPRB,0.10537E+00_JPRB,0.12216E+00_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.15452E+00_JPRB,0.13729E+00_JPRB,0.12299E+00_JPRB,0.11079E+00_JPRB,0.94730E-01_JPRB, &
 & 0.92840E-01_JPRB,0.10677E+00_JPRB,0.12287E+00_JPRB,0.14246E+00_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.15437E+00_JPRB,0.13801E+00_JPRB,0.12683E+00_JPRB,0.11313E+00_JPRB,0.10059E+00_JPRB, &
 & 0.10648E+00_JPRB,0.12562E+00_JPRB,0.14488E+00_JPRB,0.16770E+00_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.15403E+00_JPRB,0.13896E+00_JPRB,0.13053E+00_JPRB,0.11647E+00_JPRB,0.11129E+00_JPRB, &
 & 0.12495E+00_JPRB,0.14877E+00_JPRB,0.17193E+00_JPRB,0.19866E+00_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.17516E+00_JPRB,0.15332E+00_JPRB,0.13386E+00_JPRB,0.11461E+00_JPRB,0.98998E-01_JPRB, &
 & 0.86199E-01_JPRB,0.78839E-01_JPRB,0.88239E-01_JPRB,0.10212E+00_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.17578E+00_JPRB,0.15465E+00_JPRB,0.13554E+00_JPRB,0.11810E+00_JPRB,0.10372E+00_JPRB, &
 & 0.90966E-01_JPRB,0.90397E-01_JPRB,0.10318E+00_JPRB,0.11979E+00_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.17603E+00_JPRB,0.15606E+00_JPRB,0.13830E+00_JPRB,0.12297E+00_JPRB,0.10694E+00_JPRB, &
 & 0.96886E-01_JPRB,0.10455E+00_JPRB,0.12004E+00_JPRB,0.13936E+00_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.17594E+00_JPRB,0.15671E+00_JPRB,0.14175E+00_JPRB,0.12765E+00_JPRB,0.11049E+00_JPRB, &
 & 0.10701E+00_JPRB,0.12142E+00_JPRB,0.13971E+00_JPRB,0.16228E+00_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.17559E+00_JPRB,0.15762E+00_JPRB,0.14567E+00_JPRB,0.13124E+00_JPRB,0.11784E+00_JPRB, &
 & 0.12121E+00_JPRB,0.14182E+00_JPRB,0.16360E+00_JPRB,0.18966E+00_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.19714E+00_JPRB,0.17254E+00_JPRB,0.15016E+00_JPRB,0.12718E+00_JPRB,0.10949E+00_JPRB, &
 & 0.93814E-01_JPRB,0.79465E-01_JPRB,0.85103E-01_JPRB,0.98359E-01_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.19796E+00_JPRB,0.17362E+00_JPRB,0.15183E+00_JPRB,0.13102E+00_JPRB,0.11370E+00_JPRB, &
 & 0.99479E-01_JPRB,0.90483E-01_JPRB,0.10125E+00_JPRB,0.11726E+00_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.19829E+00_JPRB,0.17522E+00_JPRB,0.15424E+00_JPRB,0.13545E+00_JPRB,0.11863E+00_JPRB, &
 & 0.10457E+00_JPRB,0.10363E+00_JPRB,0.11810E+00_JPRB,0.13724E+00_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.19826E+00_JPRB,0.17625E+00_JPRB,0.15748E+00_JPRB,0.14049E+00_JPRB,0.12307E+00_JPRB, &
 & 0.11254E+00_JPRB,0.11942E+00_JPRB,0.13698E+00_JPRB,0.15920E+00_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.19780E+00_JPRB,0.17685E+00_JPRB,0.16171E+00_JPRB,0.14510E+00_JPRB,0.12933E+00_JPRB, &
 & 0.12368E+00_JPRB,0.13790E+00_JPRB,0.15875E+00_JPRB,0.18443E+00_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.21950E+00_JPRB,0.19210E+00_JPRB,0.16641E+00_JPRB,0.14074E+00_JPRB,0.12030E+00_JPRB, &
 & 0.10245E+00_JPRB,0.82539E-01_JPRB,0.82181E-01_JPRB,0.95126E-01_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.22029E+00_JPRB,0.19287E+00_JPRB,0.16845E+00_JPRB,0.14392E+00_JPRB,0.12476E+00_JPRB, &
 & 0.10750E+00_JPRB,0.92052E-01_JPRB,0.97622E-01_JPRB,0.11306E+00_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.22070E+00_JPRB,0.19423E+00_JPRB,0.17032E+00_JPRB,0.14847E+00_JPRB,0.12971E+00_JPRB, &
 & 0.11297E+00_JPRB,0.10375E+00_JPRB,0.11522E+00_JPRB,0.13338E+00_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.22058E+00_JPRB,0.19569E+00_JPRB,0.17355E+00_JPRB,0.15354E+00_JPRB,0.13473E+00_JPRB, &
 & 0.12044E+00_JPRB,0.11859E+00_JPRB,0.13469E+00_JPRB,0.15609E+00_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.22021E+00_JPRB,0.19640E+00_JPRB,0.17762E+00_JPRB,0.15857E+00_JPRB,0.14102E+00_JPRB, &
 & 0.13035E+00_JPRB,0.13566E+00_JPRB,0.15573E+00_JPRB,0.18054E+00_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.24109E+00_JPRB,0.21099E+00_JPRB,0.18179E+00_JPRB,0.15454E+00_JPRB,0.13112E+00_JPRB, &
 & 0.11092E+00_JPRB,0.89296E-01_JPRB,0.80506E-01_JPRB,0.93157E-01_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.24188E+00_JPRB,0.21170E+00_JPRB,0.18440E+00_JPRB,0.15693E+00_JPRB,0.13589E+00_JPRB, &
 & 0.11596E+00_JPRB,0.96808E-01_JPRB,0.94330E-01_JPRB,0.10941E+00_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.24228E+00_JPRB,0.21270E+00_JPRB,0.18618E+00_JPRB,0.16137E+00_JPRB,0.14099E+00_JPRB, &
 & 0.12182E+00_JPRB,0.10601E+00_JPRB,0.11139E+00_JPRB,0.12901E+00_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.24222E+00_JPRB,0.21416E+00_JPRB,0.18881E+00_JPRB,0.16653E+00_JPRB,0.14643E+00_JPRB, &
 & 0.12886E+00_JPRB,0.11898E+00_JPRB,0.13037E+00_JPRB,0.15086E+00_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.24175E+00_JPRB,0.21527E+00_JPRB,0.19303E+00_JPRB,0.17188E+00_JPRB,0.15251E+00_JPRB, &
 & 0.13886E+00_JPRB,0.13479E+00_JPRB,0.15182E+00_JPRB,0.17551E+00_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.26096E+00_JPRB,0.22837E+00_JPRB,0.19625E+00_JPRB,0.16743E+00_JPRB,0.14218E+00_JPRB, &
 & 0.11905E+00_JPRB,0.97365E-01_JPRB,0.81466E-01_JPRB,0.86743E-01_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.26197E+00_JPRB,0.22928E+00_JPRB,0.19902E+00_JPRB,0.16970E+00_JPRB,0.14641E+00_JPRB, &
 & 0.12483E+00_JPRB,0.10472E+00_JPRB,0.93843E-01_JPRB,0.10806E+00_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.26221E+00_JPRB,0.22989E+00_JPRB,0.20102E+00_JPRB,0.17345E+00_JPRB,0.15221E+00_JPRB, &
 & 0.13116E+00_JPRB,0.11273E+00_JPRB,0.10943E+00_JPRB,0.12658E+00_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.26216E+00_JPRB,0.23120E+00_JPRB,0.20343E+00_JPRB,0.17903E+00_JPRB,0.15795E+00_JPRB, &
 & 0.13876E+00_JPRB,0.12342E+00_JPRB,0.12756E+00_JPRB,0.14743E+00_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.26155E+00_JPRB,0.23254E+00_JPRB,0.20744E+00_JPRB,0.18479E+00_JPRB,0.16453E+00_JPRB, &
 & 0.14894E+00_JPRB,0.13716E+00_JPRB,0.14827E+00_JPRB,0.17117E+00_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.28000E+00_JPRB,0.24504E+00_JPRB,0.21069E+00_JPRB,0.18024E+00_JPRB,0.15374E+00_JPRB, &
 & 0.12937E+00_JPRB,0.10819E+00_JPRB,0.88668E-01_JPRB,0.55926E-01_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.28047E+00_JPRB,0.24546E+00_JPRB,0.21318E+00_JPRB,0.18272E+00_JPRB,0.15865E+00_JPRB, &
 & 0.13663E+00_JPRB,0.11594E+00_JPRB,0.10024E+00_JPRB,0.74129E-01_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.28078E+00_JPRB,0.24627E+00_JPRB,0.21537E+00_JPRB,0.18699E+00_JPRB,0.16514E+00_JPRB, &
 & 0.14391E+00_JPRB,0.12463E+00_JPRB,0.11566E+00_JPRB,0.10008E+00_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.28041E+00_JPRB,0.24739E+00_JPRB,0.21799E+00_JPRB,0.19316E+00_JPRB,0.17153E+00_JPRB, &
 & 0.15296E+00_JPRB,0.13573E+00_JPRB,0.13384E+00_JPRB,0.12903E+00_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.27974E+00_JPRB,0.24878E+00_JPRB,0.22235E+00_JPRB,0.19924E+00_JPRB,0.17976E+00_JPRB, &
 & 0.16447E+00_JPRB,0.14857E+00_JPRB,0.15437E+00_JPRB,0.16255E+00_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.29848E+00_JPRB,0.26121E+00_JPRB,0.22470E+00_JPRB,0.19300E+00_JPRB,0.16476E+00_JPRB, &
 & 0.13979E+00_JPRB,0.11858E+00_JPRB,0.95361E-01_JPRB,0.54706E-01_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.29901E+00_JPRB,0.26167E+00_JPRB,0.22733E+00_JPRB,0.19555E+00_JPRB,0.17000E+00_JPRB, &
 & 0.14834E+00_JPRB,0.12686E+00_JPRB,0.10640E+00_JPRB,0.56924E-01_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.29886E+00_JPRB,0.26222E+00_JPRB,0.22932E+00_JPRB,0.20008E+00_JPRB,0.17736E+00_JPRB, &
 & 0.15653E+00_JPRB,0.13669E+00_JPRB,0.12173E+00_JPRB,0.76097E-01_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.29840E+00_JPRB,0.26333E+00_JPRB,0.23210E+00_JPRB,0.20641E+00_JPRB,0.18472E+00_JPRB, &
 & 0.16716E+00_JPRB,0.14883E+00_JPRB,0.13980E+00_JPRB,0.10268E+00_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.29738E+00_JPRB,0.26451E+00_JPRB,0.23656E+00_JPRB,0.21275E+00_JPRB,0.19460E+00_JPRB, &
 & 0.18005E+00_JPRB,0.16102E+00_JPRB,0.16046E+00_JPRB,0.13219E+00_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.31629E+00_JPRB,0.27681E+00_JPRB,0.23838E+00_JPRB,0.20550E+00_JPRB,0.17561E+00_JPRB, &
 & 0.15005E+00_JPRB,0.12855E+00_JPRB,0.10141E+00_JPRB,0.58394E-01_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.31664E+00_JPRB,0.27713E+00_JPRB,0.24100E+00_JPRB,0.20827E+00_JPRB,0.18155E+00_JPRB, &
 & 0.15952E+00_JPRB,0.13765E+00_JPRB,0.11247E+00_JPRB,0.60995E-01_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.31646E+00_JPRB,0.27774E+00_JPRB,0.24298E+00_JPRB,0.21292E+00_JPRB,0.18963E+00_JPRB, &
 & 0.16861E+00_JPRB,0.14853E+00_JPRB,0.12785E+00_JPRB,0.75808E-01_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.31577E+00_JPRB,0.27872E+00_JPRB,0.24590E+00_JPRB,0.21953E+00_JPRB,0.19753E+00_JPRB, &
 & 0.18064E+00_JPRB,0.16179E+00_JPRB,0.14607E+00_JPRB,0.10217E+00_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.31458E+00_JPRB,0.27978E+00_JPRB,0.25030E+00_JPRB,0.22598E+00_JPRB,0.20858E+00_JPRB, &
 & 0.19488E+00_JPRB,0.17415E+00_JPRB,0.16696E+00_JPRB,0.13138E+00_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.94898E-01_JPRB,0.85055E-01_JPRB,0.10490E+00_JPRB,0.15201E+00_JPRB,0.20225E+00_JPRB, &
 & 0.25227E+00_JPRB,0.30184E+00_JPRB,0.34935E+00_JPRB,0.39726E+00_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.95143E-01_JPRB,0.87211E-01_JPRB,0.12685E+00_JPRB,0.18956E+00_JPRB,0.25226E+00_JPRB, &
 & 0.31465E+00_JPRB,0.37635E+00_JPRB,0.43547E+00_JPRB,0.49508E+00_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.95189E-01_JPRB,0.92182E-01_JPRB,0.15432E+00_JPRB,0.23093E+00_JPRB,0.30732E+00_JPRB, &
 & 0.38333E+00_JPRB,0.45850E+00_JPRB,0.53039E+00_JPRB,0.60271E+00_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.95231E-01_JPRB,0.10069E+00_JPRB,0.18420E+00_JPRB,0.27567E+00_JPRB,0.36689E+00_JPRB, &
 & 0.45778E+00_JPRB,0.54750E+00_JPRB,0.63309E+00_JPRB,0.71941E+00_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.95218E-01_JPRB,0.11224E+00_JPRB,0.21607E+00_JPRB,0.32340E+00_JPRB,0.43052E+00_JPRB, &
 & 0.53710E+00_JPRB,0.64228E+00_JPRB,0.74267E+00_JPRB,0.84389E+00_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.11396E+00_JPRB,0.10141E+00_JPRB,0.10674E+00_JPRB,0.14459E+00_JPRB,0.19233E+00_JPRB, &
 & 0.23999E+00_JPRB,0.28714E+00_JPRB,0.33260E+00_JPRB,0.38043E+00_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.11432E+00_JPRB,0.10261E+00_JPRB,0.12520E+00_JPRB,0.18276E+00_JPRB,0.24324E+00_JPRB, &
 & 0.30342E+00_JPRB,0.36297E+00_JPRB,0.42016E+00_JPRB,0.48074E+00_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.11451E+00_JPRB,0.10490E+00_JPRB,0.15054E+00_JPRB,0.22514E+00_JPRB,0.29969E+00_JPRB, &
 & 0.37388E+00_JPRB,0.44723E+00_JPRB,0.51774E+00_JPRB,0.59231E+00_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.11456E+00_JPRB,0.10971E+00_JPRB,0.18129E+00_JPRB,0.27136E+00_JPRB,0.36114E+00_JPRB, &
 & 0.45069E+00_JPRB,0.53922E+00_JPRB,0.62384E+00_JPRB,0.71399E+00_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.11453E+00_JPRB,0.11800E+00_JPRB,0.21439E+00_JPRB,0.32093E+00_JPRB,0.42721E+00_JPRB, &
 & 0.53302E+00_JPRB,0.63780E+00_JPRB,0.73784E+00_JPRB,0.84437E+00_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.13655E+00_JPRB,0.12054E+00_JPRB,0.11124E+00_JPRB,0.13153E+00_JPRB,0.17207E+00_JPRB, &
 & 0.21470E+00_JPRB,0.25693E+00_JPRB,0.29779E+00_JPRB,0.34231E+00_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.13707E+00_JPRB,0.12216E+00_JPRB,0.12413E+00_JPRB,0.16670E+00_JPRB,0.22186E+00_JPRB, &
 & 0.27683E+00_JPRB,0.33137E+00_JPRB,0.38384E+00_JPRB,0.44145E+00_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.13747E+00_JPRB,0.12319E+00_JPRB,0.14360E+00_JPRB,0.20888E+00_JPRB,0.27797E+00_JPRB, &
 & 0.34687E+00_JPRB,0.41517E+00_JPRB,0.48101E+00_JPRB,0.55322E+00_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.13768E+00_JPRB,0.12546E+00_JPRB,0.17113E+00_JPRB,0.25534E+00_JPRB,0.33989E+00_JPRB, &
 & 0.42417E+00_JPRB,0.50744E+00_JPRB,0.58796E+00_JPRB,0.67649E+00_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.13772E+00_JPRB,0.12983E+00_JPRB,0.20407E+00_JPRB,0.30559E+00_JPRB,0.40688E+00_JPRB, &
 & 0.50779E+00_JPRB,0.60773E+00_JPRB,0.70383E+00_JPRB,0.80998E+00_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.16353E+00_JPRB,0.14321E+00_JPRB,0.12667E+00_JPRB,0.12562E+00_JPRB,0.14945E+00_JPRB, &
 & 0.18589E+00_JPRB,0.22262E+00_JPRB,0.25813E+00_JPRB,0.29728E+00_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.16418E+00_JPRB,0.14525E+00_JPRB,0.13251E+00_JPRB,0.15131E+00_JPRB,0.19654E+00_JPRB, &
 & 0.24525E+00_JPRB,0.29354E+00_JPRB,0.34060E+00_JPRB,0.39212E+00_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.16461E+00_JPRB,0.14670E+00_JPRB,0.14414E+00_JPRB,0.18897E+00_JPRB,0.25116E+00_JPRB, &
 & 0.31348E+00_JPRB,0.37525E+00_JPRB,0.43507E+00_JPRB,0.50121E+00_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.16491E+00_JPRB,0.14777E+00_JPRB,0.16361E+00_JPRB,0.23441E+00_JPRB,0.31211E+00_JPRB, &
 & 0.38952E+00_JPRB,0.46648E+00_JPRB,0.54097E+00_JPRB,0.62321E+00_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.16511E+00_JPRB,0.15008E+00_JPRB,0.19240E+00_JPRB,0.28461E+00_JPRB,0.37902E+00_JPRB, &
 & 0.47310E+00_JPRB,0.56644E+00_JPRB,0.65651E+00_JPRB,0.75672E+00_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.19509E+00_JPRB,0.17082E+00_JPRB,0.14980E+00_JPRB,0.13204E+00_JPRB,0.13395E+00_JPRB, &
 & 0.16269E+00_JPRB,0.19465E+00_JPRB,0.22562E+00_JPRB,0.26041E+00_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.19619E+00_JPRB,0.17214E+00_JPRB,0.15205E+00_JPRB,0.14710E+00_JPRB,0.17263E+00_JPRB, &
 & 0.21401E+00_JPRB,0.25633E+00_JPRB,0.29729E+00_JPRB,0.34247E+00_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.19681E+00_JPRB,0.17444E+00_JPRB,0.15815E+00_JPRB,0.17421E+00_JPRB,0.22342E+00_JPRB, &
 & 0.27889E+00_JPRB,0.33405E+00_JPRB,0.38778E+00_JPRB,0.44627E+00_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.19721E+00_JPRB,0.17581E+00_JPRB,0.16979E+00_JPRB,0.21414E+00_JPRB,0.28278E+00_JPRB, &
 & 0.35302E+00_JPRB,0.42274E+00_JPRB,0.49080E+00_JPRB,0.56501E+00_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.19732E+00_JPRB,0.17699E+00_JPRB,0.18956E+00_JPRB,0.26168E+00_JPRB,0.34842E+00_JPRB, &
 & 0.43503E+00_JPRB,0.52113E+00_JPRB,0.60494E+00_JPRB,0.69634E+00_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.23167E+00_JPRB,0.20281E+00_JPRB,0.17680E+00_JPRB,0.14997E+00_JPRB,0.13324E+00_JPRB, &
 & 0.14585E+00_JPRB,0.17450E+00_JPRB,0.20194E+00_JPRB,0.23383E+00_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.23317E+00_JPRB,0.20416E+00_JPRB,0.17934E+00_JPRB,0.15819E+00_JPRB,0.15707E+00_JPRB, &
 & 0.18679E+00_JPRB,0.22357E+00_JPRB,0.25924E+00_JPRB,0.29921E+00_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.23428E+00_JPRB,0.20631E+00_JPRB,0.18228E+00_JPRB,0.17432E+00_JPRB,0.19753E+00_JPRB, &
 & 0.24343E+00_JPRB,0.29156E+00_JPRB,0.33836E+00_JPRB,0.38981E+00_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.23494E+00_JPRB,0.20857E+00_JPRB,0.18851E+00_JPRB,0.20211E+00_JPRB,0.25104E+00_JPRB, &
 & 0.31278E+00_JPRB,0.37475E+00_JPRB,0.43549E+00_JPRB,0.50069E+00_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.23514E+00_JPRB,0.20988E+00_JPRB,0.20063E+00_JPRB,0.24116E+00_JPRB,0.31413E+00_JPRB, &
 & 0.39227E+00_JPRB,0.47006E+00_JPRB,0.54611E+00_JPRB,0.62816E+00_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.27443E+00_JPRB,0.24019E+00_JPRB,0.20758E+00_JPRB,0.17610E+00_JPRB,0.14566E+00_JPRB, &
 & 0.14000E+00_JPRB,0.16506E+00_JPRB,0.19019E+00_JPRB,0.22128E+00_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.27620E+00_JPRB,0.24179E+00_JPRB,0.21121E+00_JPRB,0.17965E+00_JPRB,0.15984E+00_JPRB, &
 & 0.16864E+00_JPRB,0.20104E+00_JPRB,0.23213E+00_JPRB,0.26949E+00_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.27747E+00_JPRB,0.24292E+00_JPRB,0.21364E+00_JPRB,0.18907E+00_JPRB,0.18625E+00_JPRB, &
 & 0.21432E+00_JPRB,0.25652E+00_JPRB,0.29760E+00_JPRB,0.34338E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART11',0,ZHOOK_HANDLE)


KA(:, 4, 7,15) = (/ &
 & 0.27840E+00_JPRB,0.24591E+00_JPRB,0.21750E+00_JPRB,0.20704E+00_JPRB,0.22722E+00_JPRB, &
 & 0.27512E+00_JPRB,0.32963E+00_JPRB,0.38304E+00_JPRB,0.44058E+00_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.27872E+00_JPRB,0.24790E+00_JPRB,0.22377E+00_JPRB,0.23568E+00_JPRB,0.28140E+00_JPRB, &
 & 0.34919E+00_JPRB,0.41848E+00_JPRB,0.48672E+00_JPRB,0.55917E+00_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.32341E+00_JPRB,0.28305E+00_JPRB,0.24270E+00_JPRB,0.20626E+00_JPRB,0.16778E+00_JPRB, &
 & 0.14644E+00_JPRB,0.16206E+00_JPRB,0.18656E+00_JPRB,0.21702E+00_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.32568E+00_JPRB,0.28506E+00_JPRB,0.24756E+00_JPRB,0.20963E+00_JPRB,0.17522E+00_JPRB, &
 & 0.16516E+00_JPRB,0.19045E+00_JPRB,0.21956E+00_JPRB,0.25530E+00_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.32734E+00_JPRB,0.28654E+00_JPRB,0.25088E+00_JPRB,0.21479E+00_JPRB,0.19195E+00_JPRB, &
 & 0.19819E+00_JPRB,0.23472E+00_JPRB,0.27107E+00_JPRB,0.31461E+00_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.32837E+00_JPRB,0.28793E+00_JPRB,0.25332E+00_JPRB,0.22544E+00_JPRB,0.22100E+00_JPRB, &
 & 0.24722E+00_JPRB,0.29529E+00_JPRB,0.34210E+00_JPRB,0.39526E+00_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.32863E+00_JPRB,0.29096E+00_JPRB,0.25794E+00_JPRB,0.24543E+00_JPRB,0.26342E+00_JPRB, &
 & 0.31218E+00_JPRB,0.37382E+00_JPRB,0.43401E+00_JPRB,0.50027E+00_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.37878E+00_JPRB,0.33149E+00_JPRB,0.28420E+00_JPRB,0.23973E+00_JPRB,0.19541E+00_JPRB, &
 & 0.16103E+00_JPRB,0.16029E+00_JPRB,0.18365E+00_JPRB,0.21308E+00_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.38160E+00_JPRB,0.33397E+00_JPRB,0.28731E+00_JPRB,0.24432E+00_JPRB,0.19953E+00_JPRB, &
 & 0.17386E+00_JPRB,0.18539E+00_JPRB,0.21378E+00_JPRB,0.24833E+00_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.38370E+00_JPRB,0.33584E+00_JPRB,0.29267E+00_JPRB,0.24777E+00_JPRB,0.20961E+00_JPRB, &
 & 0.19622E+00_JPRB,0.22137E+00_JPRB,0.25542E+00_JPRB,0.29676E+00_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.38483E+00_JPRB,0.33686E+00_JPRB,0.29593E+00_JPRB,0.25505E+00_JPRB,0.22908E+00_JPRB, &
 & 0.23318E+00_JPRB,0.27287E+00_JPRB,0.31549E+00_JPRB,0.36559E+00_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.38520E+00_JPRB,0.33870E+00_JPRB,0.29863E+00_JPRB,0.26759E+00_JPRB,0.26094E+00_JPRB, &
 & 0.28563E+00_JPRB,0.34036E+00_JPRB,0.39396E+00_JPRB,0.45596E+00_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.44139E+00_JPRB,0.38627E+00_JPRB,0.33114E+00_JPRB,0.27661E+00_JPRB,0.22671E+00_JPRB, &
 & 0.18314E+00_JPRB,0.16439E+00_JPRB,0.18365E+00_JPRB,0.21302E+00_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.44442E+00_JPRB,0.38894E+00_JPRB,0.33346E+00_JPRB,0.28317E+00_JPRB,0.23077E+00_JPRB, &
 & 0.19173E+00_JPRB,0.18540E+00_JPRB,0.21159E+00_JPRB,0.24601E+00_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.44688E+00_JPRB,0.39111E+00_JPRB,0.33884E+00_JPRB,0.28735E+00_JPRB,0.23759E+00_JPRB, &
 & 0.20864E+00_JPRB,0.21693E+00_JPRB,0.24969E+00_JPRB,0.29058E+00_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.44794E+00_JPRB,0.39207E+00_JPRB,0.34326E+00_JPRB,0.29193E+00_JPRB,0.25105E+00_JPRB, &
 & 0.23562E+00_JPRB,0.26192E+00_JPRB,0.30247E+00_JPRB,0.35138E+00_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.44820E+00_JPRB,0.39253E+00_JPRB,0.34576E+00_JPRB,0.30181E+00_JPRB,0.27401E+00_JPRB, &
 & 0.27758E+00_JPRB,0.32230E+00_JPRB,0.37259E+00_JPRB,0.43225E+00_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.51225E+00_JPRB,0.44827E+00_JPRB,0.38430E+00_JPRB,0.32096E+00_JPRB,0.26380E+00_JPRB, &
 & 0.21204E+00_JPRB,0.18122E+00_JPRB,0.19575E+00_JPRB,0.22762E+00_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.51551E+00_JPRB,0.45114E+00_JPRB,0.38677E+00_JPRB,0.32842E+00_JPRB,0.26803E+00_JPRB, &
 & 0.22031E+00_JPRB,0.20295E+00_JPRB,0.22783E+00_JPRB,0.26563E+00_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.51720E+00_JPRB,0.45265E+00_JPRB,0.39154E+00_JPRB,0.33278E+00_JPRB,0.27451E+00_JPRB, &
 & 0.23732E+00_JPRB,0.23493E+00_JPRB,0.26904E+00_JPRB,0.31377E+00_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.51766E+00_JPRB,0.45307E+00_JPRB,0.39664E+00_JPRB,0.33683E+00_JPRB,0.28805E+00_JPRB, &
 & 0.26198E+00_JPRB,0.27963E+00_JPRB,0.32252E+00_JPRB,0.37505E+00_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.51687E+00_JPRB,0.45253E+00_JPRB,0.39906E+00_JPRB,0.34713E+00_JPRB,0.30874E+00_JPRB, &
 & 0.30122E+00_JPRB,0.34231E+00_JPRB,0.39543E+00_JPRB,0.45934E+00_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.58922E+00_JPRB,0.51562E+00_JPRB,0.44203E+00_JPRB,0.36905E+00_JPRB,0.30406E+00_JPRB, &
 & 0.24465E+00_JPRB,0.20183E+00_JPRB,0.21102E+00_JPRB,0.20343E+00_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.59167E+00_JPRB,0.51780E+00_JPRB,0.44391E+00_JPRB,0.37709E+00_JPRB,0.30888E+00_JPRB, &
 & 0.25236E+00_JPRB,0.22396E+00_JPRB,0.24700E+00_JPRB,0.27515E+00_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.59289E+00_JPRB,0.51887E+00_JPRB,0.44833E+00_JPRB,0.38190E+00_JPRB,0.31478E+00_JPRB, &
 & 0.26966E+00_JPRB,0.25708E+00_JPRB,0.29183E+00_JPRB,0.34036E+00_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.59238E+00_JPRB,0.51846E+00_JPRB,0.45409E+00_JPRB,0.38554E+00_JPRB,0.32896E+00_JPRB, &
 & 0.29236E+00_JPRB,0.30023E+00_JPRB,0.34558E+00_JPRB,0.40217E+00_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.59040E+00_JPRB,0.51681E+00_JPRB,0.45607E+00_JPRB,0.39582E+00_JPRB,0.34740E+00_JPRB, &
 & 0.32863E+00_JPRB,0.36471E+00_JPRB,0.42134E+00_JPRB,0.48947E+00_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.67101E+00_JPRB,0.58718E+00_JPRB,0.50336E+00_JPRB,0.42031E+00_JPRB,0.34716E+00_JPRB, &
 & 0.27980E+00_JPRB,0.22553E+00_JPRB,0.22887E+00_JPRB,0.21243E+00_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.67268E+00_JPRB,0.58864E+00_JPRB,0.50464E+00_JPRB,0.42832E+00_JPRB,0.35207E+00_JPRB, &
 & 0.28740E+00_JPRB,0.24801E+00_JPRB,0.26765E+00_JPRB,0.28879E+00_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.67256E+00_JPRB,0.58859E+00_JPRB,0.50813E+00_JPRB,0.43372E+00_JPRB,0.35764E+00_JPRB, &
 & 0.30459E+00_JPRB,0.28195E+00_JPRB,0.31558E+00_JPRB,0.36763E+00_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.67050E+00_JPRB,0.58682E+00_JPRB,0.51379E+00_JPRB,0.43676E+00_JPRB,0.37243E+00_JPRB, &
 & 0.32590E+00_JPRB,0.32370E+00_JPRB,0.37117E+00_JPRB,0.43203E+00_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.66719E+00_JPRB,0.58400E+00_JPRB,0.51581E+00_JPRB,0.44632E+00_JPRB,0.38956E+00_JPRB, &
 & 0.35928E+00_JPRB,0.38845E+00_JPRB,0.44876E+00_JPRB,0.52114E+00_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.10138E+00_JPRB,0.11271E+00_JPRB,0.22512E+00_JPRB,0.33705E+00_JPRB,0.44854E+00_JPRB, &
 & 0.55854E+00_JPRB,0.66519E+00_JPRB,0.75942E+00_JPRB,0.85612E+00_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.10145E+00_JPRB,0.13913E+00_JPRB,0.27783E+00_JPRB,0.41606E+00_JPRB,0.55341E+00_JPRB, &
 & 0.68935E+00_JPRB,0.82123E+00_JPRB,0.93793E+00_JPRB,0.10573E+01_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.10144E+00_JPRB,0.16758E+00_JPRB,0.33464E+00_JPRB,0.50118E+00_JPRB,0.66683E+00_JPRB, &
 & 0.83041E+00_JPRB,0.98914E+00_JPRB,0.11301E+01_JPRB,0.12744E+01_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.10142E+00_JPRB,0.19759E+00_JPRB,0.39475E+00_JPRB,0.59125E+00_JPRB,0.78644E+00_JPRB, &
 & 0.97913E+00_JPRB,0.11666E+01_JPRB,0.13327E+01_JPRB,0.15036E+01_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.10117E+00_JPRB,0.22893E+00_JPRB,0.45719E+00_JPRB,0.68491E+00_JPRB,0.91083E+00_JPRB, &
 & 0.11348E+01_JPRB,0.13522E+01_JPRB,0.15448E+01_JPRB,0.17423E+01_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.12283E+00_JPRB,0.11939E+00_JPRB,0.23586E+00_JPRB,0.35344E+00_JPRB,0.46995E+00_JPRB, &
 & 0.58562E+00_JPRB,0.69771E+00_JPRB,0.79719E+00_JPRB,0.91456E+00_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.12300E+00_JPRB,0.14726E+00_JPRB,0.29424E+00_JPRB,0.44061E+00_JPRB,0.58626E+00_JPRB, &
 & 0.73031E+00_JPRB,0.87019E+00_JPRB,0.99468E+00_JPRB,0.11413E+01_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.12308E+00_JPRB,0.17880E+00_JPRB,0.35729E+00_JPRB,0.53471E+00_JPRB,0.71190E+00_JPRB, &
 & 0.88678E+00_JPRB,0.10560E+01_JPRB,0.12083E+01_JPRB,0.13858E+01_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.12303E+00_JPRB,0.21231E+00_JPRB,0.42408E+00_JPRB,0.63552E+00_JPRB,0.84482E+00_JPRB, &
 & 0.10530E+01_JPRB,0.12550E+01_JPRB,0.14355E+01_JPRB,0.16461E+01_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.12277E+00_JPRB,0.24738E+00_JPRB,0.49418E+00_JPRB,0.74021E+00_JPRB,0.98480E+00_JPRB, &
 & 0.12263E+01_JPRB,0.14622E+01_JPRB,0.16712E+01_JPRB,0.19192E+01_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.14866E+00_JPRB,0.13122E+00_JPRB,0.23281E+00_JPRB,0.34894E+00_JPRB,0.46454E+00_JPRB, &
 & 0.57840E+00_JPRB,0.68947E+00_JPRB,0.78868E+00_JPRB,0.91936E+00_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.14909E+00_JPRB,0.15020E+00_JPRB,0.29535E+00_JPRB,0.44246E+00_JPRB,0.58879E+00_JPRB, &
 & 0.73298E+00_JPRB,0.87446E+00_JPRB,0.10004E+01_JPRB,0.11652E+01_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.14932E+00_JPRB,0.18193E+00_JPRB,0.36339E+00_JPRB,0.54464E+00_JPRB,0.72472E+00_JPRB, &
 & 0.90302E+00_JPRB,0.10769E+01_JPRB,0.12326E+01_JPRB,0.14351E+01_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.14936E+00_JPRB,0.21850E+00_JPRB,0.43638E+00_JPRB,0.65369E+00_JPRB,0.87034E+00_JPRB, &
 & 0.10842E+01_JPRB,0.12925E+01_JPRB,0.14807E+01_JPRB,0.17238E+01_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.14913E+00_JPRB,0.25689E+00_JPRB,0.51319E+00_JPRB,0.76884E+00_JPRB,0.10226E+01_JPRB, &
 & 0.12750E+01_JPRB,0.15205E+01_JPRB,0.17418E+01_JPRB,0.20260E+01_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.17957E+00_JPRB,0.15775E+00_JPRB,0.22276E+00_JPRB,0.33390E+00_JPRB,0.44423E+00_JPRB, &
 & 0.55367E+00_JPRB,0.66019E+00_JPRB,0.75611E+00_JPRB,0.88680E+00_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.18040E+00_JPRB,0.16246E+00_JPRB,0.28812E+00_JPRB,0.43146E+00_JPRB,0.57438E+00_JPRB, &
 & 0.71573E+00_JPRB,0.85374E+00_JPRB,0.97839E+00_JPRB,0.11468E+01_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.18097E+00_JPRB,0.18562E+00_JPRB,0.36044E+00_JPRB,0.53994E+00_JPRB,0.71844E+00_JPRB, &
 & 0.89550E+00_JPRB,0.10683E+01_JPRB,0.12247E+01_JPRB,0.14347E+01_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.18121E+00_JPRB,0.21975E+00_JPRB,0.43861E+00_JPRB,0.65714E+00_JPRB,0.87443E+00_JPRB, &
 & 0.10900E+01_JPRB,0.13008E+01_JPRB,0.14906E+01_JPRB,0.17458E+01_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.18106E+00_JPRB,0.26092E+00_JPRB,0.52133E+00_JPRB,0.78101E+00_JPRB,0.10395E+01_JPRB, &
 & 0.12958E+01_JPRB,0.15460E+01_JPRB,0.17735E+01_JPRB,0.20757E+01_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.21697E+00_JPRB,0.19036E+00_JPRB,0.21215E+00_JPRB,0.31312E+00_JPRB,0.41669E+00_JPRB, &
 & 0.51939E+00_JPRB,0.61996E+00_JPRB,0.71133E+00_JPRB,0.83486E+00_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.21794E+00_JPRB,0.19137E+00_JPRB,0.27611E+00_JPRB,0.41368E+00_JPRB,0.55071E+00_JPRB, &
 & 0.68646E+00_JPRB,0.81902E+00_JPRB,0.94006E+00_JPRB,0.11028E+01_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.21886E+00_JPRB,0.20114E+00_JPRB,0.35159E+00_JPRB,0.52668E+00_JPRB,0.70100E+00_JPRB, &
 & 0.87403E+00_JPRB,0.10428E+01_JPRB,0.11973E+01_JPRB,0.14036E+01_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.21947E+00_JPRB,0.22776E+00_JPRB,0.43385E+00_JPRB,0.64994E+00_JPRB,0.86545E+00_JPRB, &
 & 0.10790E+01_JPRB,0.12882E+01_JPRB,0.14795E+01_JPRB,0.17328E+01_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.21950E+00_JPRB,0.26410E+00_JPRB,0.52266E+00_JPRB,0.78311E+00_JPRB,0.10422E+01_JPRB, &
 & 0.12993E+01_JPRB,0.15508E+01_JPRB,0.17813E+01_JPRB,0.20867E+01_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.26192E+00_JPRB,0.22964E+00_JPRB,0.21396E+00_JPRB,0.28442E+00_JPRB,0.37859E+00_JPRB, &
 & 0.47209E+00_JPRB,0.56361E+00_JPRB,0.64772E+00_JPRB,0.75904E+00_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.26327E+00_JPRB,0.23094E+00_JPRB,0.26427E+00_JPRB,0.38535E+00_JPRB,0.51302E+00_JPRB, &
 & 0.63961E+00_JPRB,0.76380E+00_JPRB,0.87816E+00_JPRB,0.10282E+01_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.26410E+00_JPRB,0.23177E+00_JPRB,0.33446E+00_JPRB,0.50065E+00_JPRB,0.66671E+00_JPRB, &
 & 0.83097E+00_JPRB,0.99257E+00_JPRB,0.11416E+01_JPRB,0.13361E+01_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.26501E+00_JPRB,0.24670E+00_JPRB,0.42047E+00_JPRB,0.62999E+00_JPRB,0.83846E+00_JPRB, &
 & 0.10456E+01_JPRB,0.12484E+01_JPRB,0.14350E+01_JPRB,0.16802E+01_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.26533E+00_JPRB,0.27595E+00_JPRB,0.51477E+00_JPRB,0.77155E+00_JPRB,0.10272E+01_JPRB, &
 & 0.12802E+01_JPRB,0.15288E+01_JPRB,0.17573E+01_JPRB,0.20585E+01_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.31548E+00_JPRB,0.27644E+00_JPRB,0.23749E+00_JPRB,0.26350E+00_JPRB,0.33563E+00_JPRB, &
 & 0.41860E+00_JPRB,0.50000E+00_JPRB,0.57557E+00_JPRB,0.67307E+00_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.31747E+00_JPRB,0.27830E+00_JPRB,0.26813E+00_JPRB,0.35238E+00_JPRB,0.46780E+00_JPRB, &
 & 0.58337E+00_JPRB,0.69695E+00_JPRB,0.80281E+00_JPRB,0.93825E+00_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.31845E+00_JPRB,0.27929E+00_JPRB,0.32577E+00_JPRB,0.46831E+00_JPRB,0.62377E+00_JPRB, &
 & 0.77768E+00_JPRB,0.92868E+00_JPRB,0.10691E+01_JPRB,0.12510E+01_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.31933E+00_JPRB,0.28093E+00_JPRB,0.40219E+00_JPRB,0.60218E+00_JPRB,0.80124E+00_JPRB, &
 & 0.99953E+00_JPRB,0.11938E+01_JPRB,0.13738E+01_JPRB,0.16072E+01_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.31962E+00_JPRB,0.30041E+00_JPRB,0.50060E+00_JPRB,0.75020E+00_JPRB,0.99895E+00_JPRB, &
 & 0.12457E+01_JPRB,0.14877E+01_JPRB,0.17119E+01_JPRB,0.20030E+01_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.37865E+00_JPRB,0.33167E+00_JPRB,0.28471E+00_JPRB,0.26304E+00_JPRB,0.29883E+00_JPRB, &
 & 0.36478E+00_JPRB,0.43575E+00_JPRB,0.50177E+00_JPRB,0.58698E+00_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.38151E+00_JPRB,0.33434E+00_JPRB,0.29226E+00_JPRB,0.33286E+00_JPRB,0.42010E+00_JPRB, &
 & 0.52397E+00_JPRB,0.62612E+00_JPRB,0.72153E+00_JPRB,0.84257E+00_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.38305E+00_JPRB,0.33575E+00_JPRB,0.33335E+00_JPRB,0.43312E+00_JPRB,0.57580E+00_JPRB, &
 & 0.71815E+00_JPRB,0.85781E+00_JPRB,0.98826E+00_JPRB,0.11549E+01_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.38418E+00_JPRB,0.33683E+00_JPRB,0.39821E+00_JPRB,0.56836E+00_JPRB,0.75670E+00_JPRB, &
 & 0.94382E+00_JPRB,0.11276E+01_JPRB,0.12990E+01_JPRB,0.15179E+01_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.38435E+00_JPRB,0.34032E+00_JPRB,0.48169E+00_JPRB,0.72105E+00_JPRB,0.95979E+00_JPRB, &
 & 0.11976E+01_JPRB,0.14311E+01_JPRB,0.16484E+01_JPRB,0.19256E+01_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.45391E+00_JPRB,0.39745E+00_JPRB,0.34100E+00_JPRB,0.28597E+00_JPRB,0.28236E+00_JPRB, &
 & 0.32683E+00_JPRB,0.39003E+00_JPRB,0.44780E+00_JPRB,0.52646E+00_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.45720E+00_JPRB,0.40042E+00_JPRB,0.34369E+00_JPRB,0.33249E+00_JPRB,0.37993E+00_JPRB, &
 & 0.46180E+00_JPRB,0.55195E+00_JPRB,0.63669E+00_JPRB,0.74252E+00_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.45930E+00_JPRB,0.40241E+00_JPRB,0.35995E+00_JPRB,0.41477E+00_JPRB,0.52224E+00_JPRB, &
 & 0.65162E+00_JPRB,0.77908E+00_JPRB,0.89846E+00_JPRB,0.10481E+01_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.46056E+00_JPRB,0.40360E+00_JPRB,0.40974E+00_JPRB,0.52851E+00_JPRB,0.70308E+00_JPRB, &
 & 0.87703E+00_JPRB,0.10485E+01_JPRB,0.12091E+01_JPRB,0.14102E+01_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.46097E+00_JPRB,0.40408E+00_JPRB,0.48083E+00_JPRB,0.68278E+00_JPRB,0.90959E+00_JPRB, &
 & 0.11347E+01_JPRB,0.13562E+01_JPRB,0.15644E+01_JPRB,0.18239E+01_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.54348E+00_JPRB,0.47578E+00_JPRB,0.40808E+00_JPRB,0.34039E+00_JPRB,0.29202E+00_JPRB, &
 & 0.31463E+00_JPRB,0.37530E+00_JPRB,0.43003E+00_JPRB,0.50713E+00_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.54726E+00_JPRB,0.47923E+00_JPRB,0.41116E+00_JPRB,0.35738E+00_JPRB,0.36873E+00_JPRB, &
 & 0.42815E+00_JPRB,0.51125E+00_JPRB,0.58827E+00_JPRB,0.68902E+00_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.54904E+00_JPRB,0.48087E+00_JPRB,0.41270E+00_JPRB,0.42187E+00_JPRB,0.48592E+00_JPRB, &
 & 0.59834E+00_JPRB,0.71541E+00_JPRB,0.82550E+00_JPRB,0.96166E+00_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.55066E+00_JPRB,0.48237E+00_JPRB,0.44342E+00_JPRB,0.51829E+00_JPRB,0.65846E+00_JPRB, &
 & 0.82163E+00_JPRB,0.98259E+00_JPRB,0.11344E+01_JPRB,0.13209E+01_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.55078E+00_JPRB,0.48256E+00_JPRB,0.50243E+00_JPRB,0.65112E+00_JPRB,0.86662E+00_JPRB, &
 & 0.10813E+01_JPRB,0.12932E+01_JPRB,0.14933E+01_JPRB,0.17377E+01_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.65114E+00_JPRB,0.56997E+00_JPRB,0.48880E+00_JPRB,0.40765E+00_JPRB,0.34114E+00_JPRB, &
 & 0.35299E+00_JPRB,0.42114E+00_JPRB,0.48311E+00_JPRB,0.56879E+00_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.65409E+00_JPRB,0.57269E+00_JPRB,0.49126E+00_JPRB,0.41893E+00_JPRB,0.41551E+00_JPRB, &
 & 0.46863E+00_JPRB,0.55986E+00_JPRB,0.64427E+00_JPRB,0.75415E+00_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.65488E+00_JPRB,0.57345E+00_JPRB,0.49197E+00_JPRB,0.47947E+00_JPRB,0.53169E+00_JPRB, &
 & 0.64034E+00_JPRB,0.76581E+00_JPRB,0.88450E+00_JPRB,0.10287E+01_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.65537E+00_JPRB,0.57398E+00_JPRB,0.51344E+00_JPRB,0.57405E+00_JPRB,0.70306E+00_JPRB, &
 & 0.87735E+00_JPRB,0.10495E+01_JPRB,0.12127E+01_JPRB,0.14094E+01_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.65395E+00_JPRB,0.57279E+00_JPRB,0.56858E+00_JPRB,0.69997E+00_JPRB,0.92273E+00_JPRB, &
 & 0.11516E+01_JPRB,0.13780E+01_JPRB,0.15930E+01_JPRB,0.18499E+01_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.77619E+00_JPRB,0.67938E+00_JPRB,0.58258E+00_JPRB,0.48578E+00_JPRB,0.39872E+00_JPRB, &
 & 0.39471E+00_JPRB,0.47009E+00_JPRB,0.53992E+00_JPRB,0.63430E+00_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.77753E+00_JPRB,0.68052E+00_JPRB,0.58367E+00_JPRB,0.49090E+00_JPRB,0.46899E+00_JPRB, &
 & 0.51194E+00_JPRB,0.61162E+00_JPRB,0.70447E+00_JPRB,0.82357E+00_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.77638E+00_JPRB,0.67972E+00_JPRB,0.58318E+00_JPRB,0.54530E+00_JPRB,0.58387E+00_JPRB, &
 & 0.68245E+00_JPRB,0.81638E+00_JPRB,0.94341E+00_JPRB,0.10965E+01_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.77440E+00_JPRB,0.67810E+00_JPRB,0.59462E+00_JPRB,0.63695E+00_JPRB,0.74739E+00_JPRB, &
 & 0.93197E+00_JPRB,0.11153E+01_JPRB,0.12903E+01_JPRB,0.14970E+01_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.77021E+00_JPRB,0.67464E+00_JPRB,0.64357E+00_JPRB,0.75637E+00_JPRB,0.97798E+00_JPRB, &
 & 0.12207E+01_JPRB,0.14609E+01_JPRB,0.16904E+01_JPRB,0.19598E+01_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.91895E+00_JPRB,0.80429E+00_JPRB,0.68964E+00_JPRB,0.57498E+00_JPRB,0.46528E+00_JPRB, &
 & 0.44199E+00_JPRB,0.52028E+00_JPRB,0.59834E+00_JPRB,0.70141E+00_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.91759E+00_JPRB,0.80320E+00_JPRB,0.68881E+00_JPRB,0.57463E+00_JPRB,0.52956E+00_JPRB, &
 & 0.55768E+00_JPRB,0.66492E+00_JPRB,0.76644E+00_JPRB,0.89471E+00_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.91361E+00_JPRB,0.79979E+00_JPRB,0.68598E+00_JPRB,0.61940E+00_JPRB,0.64101E+00_JPRB, &
 & 0.72712E+00_JPRB,0.86969E+00_JPRB,0.10053E+01_JPRB,0.11679E+01_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.90733E+00_JPRB,0.79439E+00_JPRB,0.68655E+00_JPRB,0.70603E+00_JPRB,0.79560E+00_JPRB, &
 & 0.98356E+00_JPRB,0.11773E+01_JPRB,0.13631E+01_JPRB,0.15788E+01_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.89862E+00_JPRB,0.78697E+00_JPRB,0.72670E+00_JPRB,0.82187E+00_JPRB,0.10292E+01_JPRB, &
 & 0.12848E+01_JPRB,0.15381E+01_JPRB,0.17818E+01_JPRB,0.20623E+01_JPRB /)  
  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.80849E-06_JPRB,0.81362E-06_JPRB,0.81391E-06_JPRB,0.81832E-06_JPRB,0.81000E-06_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.62593E-06_JPRB,0.63090E-06_JPRB,0.63158E-06_JPRB,0.62821E-06_JPRB,0.62502E-06_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.47825E-06_JPRB,0.47852E-06_JPRB,0.47713E-06_JPRB,0.47688E-06_JPRB,0.47989E-06_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.36039E-06_JPRB,0.35905E-06_JPRB,0.36064E-06_JPRB,0.36298E-06_JPRB,0.36860E-06_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.27679E-06_JPRB,0.27608E-06_JPRB,0.27742E-06_JPRB,0.28112E-06_JPRB,0.28759E-06_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.21771E-06_JPRB,0.21826E-06_JPRB,0.22019E-06_JPRB,0.22429E-06_JPRB,0.22996E-06_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.17334E-06_JPRB,0.17441E-06_JPRB,0.17681E-06_JPRB,0.18055E-06_JPRB,0.18537E-06_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.13974E-06_JPRB,0.14076E-06_JPRB,0.14326E-06_JPRB,0.14694E-06_JPRB,0.15070E-06_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.11289E-06_JPRB,0.11394E-06_JPRB,0.11631E-06_JPRB,0.11963E-06_JPRB,0.12284E-06_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.90574E-07_JPRB,0.91914E-07_JPRB,0.94046E-07_JPRB,0.96998E-07_JPRB,0.99841E-07_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.72483E-07_JPRB,0.74069E-07_JPRB,0.76186E-07_JPRB,0.78482E-07_JPRB,0.80964E-07_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.57463E-07_JPRB,0.59130E-07_JPRB,0.60802E-07_JPRB,0.62903E-07_JPRB,0.65218E-07_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.45767E-07_JPRB,0.47184E-07_JPRB,0.48696E-07_JPRB,0.50494E-07_JPRB,0.52527E-07_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.36636E-07_JPRB,0.37794E-07_JPRB,0.39217E-07_JPRB,0.40768E-07_JPRB,0.42465E-07_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.29173E-07_JPRB,0.30183E-07_JPRB,0.31469E-07_JPRB,0.32834E-07_JPRB,0.34213E-07_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.23225E-07_JPRB,0.24137E-07_JPRB,0.25167E-07_JPRB,0.26378E-07_JPRB,0.27534E-07_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.18675E-07_JPRB,0.19472E-07_JPRB,0.20340E-07_JPRB,0.21340E-07_JPRB,0.22286E-07_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.15020E-07_JPRB,0.15690E-07_JPRB,0.16468E-07_JPRB,0.17258E-07_JPRB,0.18060E-07_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.12149E-07_JPRB,0.12728E-07_JPRB,0.13375E-07_JPRB,0.14035E-07_JPRB,0.14711E-07_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.98596E-08_JPRB,0.10344E-07_JPRB,0.10879E-07_JPRB,0.11427E-07_JPRB,0.12003E-07_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.80127E-08_JPRB,0.84199E-08_JPRB,0.88610E-08_JPRB,0.93188E-08_JPRB,0.98102E-08_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.65473E-08_JPRB,0.68850E-08_JPRB,0.72470E-08_JPRB,0.76379E-08_JPRB,0.80329E-08_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.53107E-08_JPRB,0.55930E-08_JPRB,0.58984E-08_JPRB,0.62161E-08_JPRB,0.65511E-08_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.42749E-08_JPRB,0.45072E-08_JPRB,0.47592E-08_JPRB,0.50244E-08_JPRB,0.53034E-08_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.34593E-08_JPRB,0.36479E-08_JPRB,0.38557E-08_JPRB,0.40714E-08_JPRB,0.43031E-08_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.27981E-08_JPRB,0.29525E-08_JPRB,0.31212E-08_JPRB,0.32984E-08_JPRB,0.34890E-08_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.22616E-08_JPRB,0.23879E-08_JPRB,0.25266E-08_JPRB,0.26716E-08_JPRB,0.28295E-08_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.18232E-08_JPRB,0.19245E-08_JPRB,0.20362E-08_JPRB,0.21554E-08_JPRB,0.22831E-08_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.14679E-08_JPRB,0.15511E-08_JPRB,0.16402E-08_JPRB,0.17376E-08_JPRB,0.18413E-08_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.11828E-08_JPRB,0.12488E-08_JPRB,0.13200E-08_JPRB,0.14008E-08_JPRB,0.14841E-08_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.94970E-09_JPRB,0.10028E-08_JPRB,0.10610E-08_JPRB,0.11254E-08_JPRB,0.11933E-08_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.76210E-09_JPRB,0.80401E-09_JPRB,0.85098E-09_JPRB,0.90203E-09_JPRB,0.95794E-09_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.61242E-09_JPRB,0.64471E-09_JPRB,0.68205E-09_JPRB,0.72336E-09_JPRB,0.76846E-09_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.49214E-09_JPRB,0.51642E-09_JPRB,0.54633E-09_JPRB,0.57916E-09_JPRB,0.61506E-09_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.39552E-09_JPRB,0.41343E-09_JPRB,0.43658E-09_JPRB,0.46266E-09_JPRB,0.49121E-09_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.31773E-09_JPRB,0.33161E-09_JPRB,0.34878E-09_JPRB,0.36970E-09_JPRB,0.39231E-09_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.25526E-09_JPRB,0.26613E-09_JPRB,0.27906E-09_JPRB,0.29510E-09_JPRB,0.31346E-09_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.20571E-09_JPRB,0.21419E-09_JPRB,0.22379E-09_JPRB,0.23622E-09_JPRB,0.25076E-09_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.16573E-09_JPRB,0.17251E-09_JPRB,0.18002E-09_JPRB,0.18925E-09_JPRB,0.20074E-09_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.13312E-09_JPRB,0.13888E-09_JPRB,0.14480E-09_JPRB,0.15170E-09_JPRB,0.16067E-09_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.10717E-09_JPRB,0.11200E-09_JPRB,0.11653E-09_JPRB,0.12187E-09_JPRB,0.12864E-09_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.85395E-10_JPRB,0.90190E-10_JPRB,0.93978E-10_JPRB,0.98115E-10_JPRB,0.10324E-09_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.67933E-10_JPRB,0.72682E-10_JPRB,0.75857E-10_JPRB,0.79079E-10_JPRB,0.82942E-10_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.53572E-10_JPRB,0.58095E-10_JPRB,0.61231E-10_JPRB,0.63738E-10_JPRB,0.66738E-10_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.41729E-10_JPRB,0.46380E-10_JPRB,0.49357E-10_JPRB,0.51409E-10_JPRB,0.53743E-10_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.32319E-10_JPRB,0.36737E-10_JPRB,0.39572E-10_JPRB,0.41487E-10_JPRB,0.43327E-10_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.25820E-10_JPRB,0.29541E-10_JPRB,0.32107E-10_JPRB,0.33762E-10_JPRB,0.35250E-10_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.93809E-05_JPRB,0.10536E-04_JPRB,0.11777E-04_JPRB,0.13098E-04_JPRB,0.14486E-04_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.77050E-05_JPRB,0.86520E-05_JPRB,0.96745E-05_JPRB,0.10759E-04_JPRB,0.11891E-04_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.63112E-05_JPRB,0.70914E-05_JPRB,0.79320E-05_JPRB,0.88179E-05_JPRB,0.97344E-05_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.51672E-05_JPRB,0.58172E-05_JPRB,0.64961E-05_JPRB,0.72133E-05_JPRB,0.79595E-05_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.42470E-05_JPRB,0.47817E-05_JPRB,0.53396E-05_JPRB,0.59229E-05_JPRB,0.65385E-05_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.35105E-05_JPRB,0.39513E-05_JPRB,0.44042E-05_JPRB,0.48865E-05_JPRB,0.53983E-05_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.29057E-05_JPRB,0.32680E-05_JPRB,0.36409E-05_JPRB,0.40419E-05_JPRB,0.44646E-05_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.24132E-05_JPRB,0.27111E-05_JPRB,0.30192E-05_JPRB,0.33498E-05_JPRB,0.36985E-05_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.20041E-05_JPRB,0.22484E-05_JPRB,0.25052E-05_JPRB,0.27770E-05_JPRB,0.30661E-05_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.16762E-05_JPRB,0.18775E-05_JPRB,0.20900E-05_JPRB,0.23158E-05_JPRB,0.25543E-05_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.14013E-05_JPRB,0.15665E-05_JPRB,0.17433E-05_JPRB,0.19308E-05_JPRB,0.21290E-05_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.11680E-05_JPRB,0.13039E-05_JPRB,0.14515E-05_JPRB,0.16085E-05_JPRB,0.17733E-05_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.97491E-06_JPRB,0.10886E-05_JPRB,0.12114E-05_JPRB,0.13428E-05_JPRB,0.14806E-05_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.81608E-06_JPRB,0.91198E-06_JPRB,0.10148E-05_JPRB,0.11244E-05_JPRB,0.12392E-05_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.68407E-06_JPRB,0.76432E-06_JPRB,0.85048E-06_JPRB,0.94210E-06_JPRB,0.10393E-05_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.57340E-06_JPRB,0.64071E-06_JPRB,0.71311E-06_JPRB,0.78988E-06_JPRB,0.87304E-06_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.48234E-06_JPRB,0.53886E-06_JPRB,0.59992E-06_JPRB,0.66557E-06_JPRB,0.73565E-06_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.40628E-06_JPRB,0.45384E-06_JPRB,0.50638E-06_JPRB,0.56175E-06_JPRB,0.62086E-06_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.34276E-06_JPRB,0.38409E-06_JPRB,0.42817E-06_JPRB,0.47551E-06_JPRB,0.52508E-06_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.29024E-06_JPRB,0.32548E-06_JPRB,0.36291E-06_JPRB,0.40263E-06_JPRB,0.44423E-06_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.24623E-06_JPRB,0.27596E-06_JPRB,0.30748E-06_JPRB,0.34104E-06_JPRB,0.37571E-06_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.20814E-06_JPRB,0.23318E-06_JPRB,0.25975E-06_JPRB,0.28746E-06_JPRB,0.31674E-06_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.17399E-06_JPRB,0.19476E-06_JPRB,0.21698E-06_JPRB,0.24021E-06_JPRB,0.26463E-06_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.14352E-06_JPRB,0.16079E-06_JPRB,0.17920E-06_JPRB,0.19838E-06_JPRB,0.21852E-06_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.11644E-06_JPRB,0.13061E-06_JPRB,0.14569E-06_JPRB,0.16148E-06_JPRB,0.17794E-06_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.94327E-07_JPRB,0.10597E-06_JPRB,0.11827E-06_JPRB,0.13121E-06_JPRB,0.14471E-06_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.76386E-07_JPRB,0.85932E-07_JPRB,0.96004E-07_JPRB,0.10675E-06_JPRB,0.11785E-06_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.61093E-07_JPRB,0.68856E-07_JPRB,0.77088E-07_JPRB,0.85831E-07_JPRB,0.94878E-07_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.48781E-07_JPRB,0.55058E-07_JPRB,0.61725E-07_JPRB,0.68852E-07_JPRB,0.76234E-07_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.38909E-07_JPRB,0.43987E-07_JPRB,0.49391E-07_JPRB,0.55161E-07_JPRB,0.61197E-07_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.30779E-07_JPRB,0.34866E-07_JPRB,0.39222E-07_JPRB,0.43870E-07_JPRB,0.48785E-07_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.24249E-07_JPRB,0.27514E-07_JPRB,0.31014E-07_JPRB,0.34774E-07_JPRB,0.38772E-07_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.19076E-07_JPRB,0.21693E-07_JPRB,0.24514E-07_JPRB,0.27522E-07_JPRB,0.30756E-07_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.14949E-07_JPRB,0.17046E-07_JPRB,0.19303E-07_JPRB,0.21721E-07_JPRB,0.24320E-07_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.11627E-07_JPRB,0.13294E-07_JPRB,0.15102E-07_JPRB,0.17040E-07_JPRB,0.19115E-07_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.90208E-08_JPRB,0.10359E-07_JPRB,0.11803E-07_JPRB,0.13349E-07_JPRB,0.15003E-07_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.69979E-08_JPRB,0.80625E-08_JPRB,0.92075E-08_JPRB,0.10445E-07_JPRB,0.11768E-07_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.54507E-08_JPRB,0.62777E-08_JPRB,0.72004E-08_JPRB,0.81899E-08_JPRB,0.92488E-08_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.42541E-08_JPRB,0.48933E-08_JPRB,0.56304E-08_JPRB,0.64214E-08_JPRB,0.72725E-08_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.33161E-08_JPRB,0.38121E-08_JPRB,0.43976E-08_JPRB,0.50301E-08_JPRB,0.57140E-08_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.25817E-08_JPRB,0.29691E-08_JPRB,0.34291E-08_JPRB,0.39368E-08_JPRB,0.44836E-08_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.20203E-08_JPRB,0.23228E-08_JPRB,0.26823E-08_JPRB,0.30900E-08_JPRB,0.35285E-08_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.15833E-08_JPRB,0.18196E-08_JPRB,0.21023E-08_JPRB,0.24276E-08_JPRB,0.27787E-08_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.12403E-08_JPRB,0.14250E-08_JPRB,0.16461E-08_JPRB,0.19045E-08_JPRB,0.21855E-08_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.97249E-09_JPRB,0.11164E-08_JPRB,0.12881E-08_JPRB,0.14923E-08_JPRB,0.17175E-08_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.76431E-09_JPRB,0.87699E-09_JPRB,0.10108E-08_JPRB,0.11709E-08_JPRB,0.13516E-08_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.61553E-09_JPRB,0.70649E-09_JPRB,0.81463E-09_JPRB,0.94315E-09_JPRB,0.10907E-08_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.37708E-04_JPRB,0.43942E-04_JPRB,0.50586E-04_JPRB,0.57656E-04_JPRB,0.65139E-04_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.31694E-04_JPRB,0.36862E-04_JPRB,0.42350E-04_JPRB,0.48197E-04_JPRB,0.54341E-04_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.26564E-04_JPRB,0.30824E-04_JPRB,0.35372E-04_JPRB,0.40180E-04_JPRB,0.45231E-04_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.22232E-04_JPRB,0.25740E-04_JPRB,0.29512E-04_JPRB,0.33447E-04_JPRB,0.37588E-04_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.18578E-04_JPRB,0.21467E-04_JPRB,0.24582E-04_JPRB,0.27832E-04_JPRB,0.31221E-04_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.15530E-04_JPRB,0.17922E-04_JPRB,0.20498E-04_JPRB,0.23170E-04_JPRB,0.25973E-04_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.12972E-04_JPRB,0.14952E-04_JPRB,0.17059E-04_JPRB,0.19270E-04_JPRB,0.21580E-04_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.10858E-04_JPRB,0.12498E-04_JPRB,0.14228E-04_JPRB,0.16061E-04_JPRB,0.17958E-04_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.90819E-05_JPRB,0.10446E-04_JPRB,0.11880E-04_JPRB,0.13394E-04_JPRB,0.14951E-04_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.76648E-05_JPRB,0.87979E-05_JPRB,0.99931E-05_JPRB,0.11255E-04_JPRB,0.12542E-04_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.64634E-05_JPRB,0.74140E-05_JPRB,0.84086E-05_JPRB,0.94546E-05_JPRB,0.10527E-04_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.54523E-05_JPRB,0.62464E-05_JPRB,0.70809E-05_JPRB,0.79508E-05_JPRB,0.88446E-05_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.46110E-05_JPRB,0.52716E-05_JPRB,0.59693E-05_JPRB,0.66904E-05_JPRB,0.74322E-05_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.39134E-05_JPRB,0.44620E-05_JPRB,0.50425E-05_JPRB,0.56439E-05_JPRB,0.62577E-05_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.33208E-05_JPRB,0.37777E-05_JPRB,0.42629E-05_JPRB,0.47607E-05_JPRB,0.52714E-05_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.28177E-05_JPRB,0.32008E-05_JPRB,0.36031E-05_JPRB,0.40187E-05_JPRB,0.44358E-05_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.23932E-05_JPRB,0.27158E-05_JPRB,0.30516E-05_JPRB,0.33945E-05_JPRB,0.37416E-05_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.20340E-05_JPRB,0.23035E-05_JPRB,0.25827E-05_JPRB,0.28672E-05_JPRB,0.31559E-05_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.17308E-05_JPRB,0.19547E-05_JPRB,0.21869E-05_JPRB,0.24243E-05_JPRB,0.26649E-05_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.14734E-05_JPRB,0.16593E-05_JPRB,0.18536E-05_JPRB,0.20518E-05_JPRB,0.22514E-05_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.12538E-05_JPRB,0.14097E-05_JPRB,0.15718E-05_JPRB,0.17369E-05_JPRB,0.19013E-05_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.10626E-05_JPRB,0.11932E-05_JPRB,0.13290E-05_JPRB,0.14662E-05_JPRB,0.16025E-05_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.88990E-06_JPRB,0.99878E-06_JPRB,0.11122E-05_JPRB,0.12266E-05_JPRB,0.13395E-05_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.73535E-06_JPRB,0.82690E-06_JPRB,0.92099E-06_JPRB,0.10159E-05_JPRB,0.11099E-05_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.59728E-06_JPRB,0.67301E-06_JPRB,0.75127E-06_JPRB,0.83021E-06_JPRB,0.90845E-06_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.48484E-06_JPRB,0.54737E-06_JPRB,0.61229E-06_JPRB,0.67762E-06_JPRB,0.74258E-06_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.39347E-06_JPRB,0.44485E-06_JPRB,0.49886E-06_JPRB,0.55290E-06_JPRB,0.60674E-06_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.31488E-06_JPRB,0.35703E-06_JPRB,0.40148E-06_JPRB,0.44640E-06_JPRB,0.49091E-06_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.25130E-06_JPRB,0.28561E-06_JPRB,0.32224E-06_JPRB,0.35953E-06_JPRB,0.39618E-06_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.20030E-06_JPRB,0.22840E-06_JPRB,0.25834E-06_JPRB,0.28930E-06_JPRB,0.31965E-06_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.15807E-06_JPRB,0.18109E-06_JPRB,0.20542E-06_JPRB,0.23094E-06_JPRB,0.25635E-06_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.12418E-06_JPRB,0.14282E-06_JPRB,0.16261E-06_JPRB,0.18364E-06_JPRB,0.20465E-06_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.97383E-07_JPRB,0.11245E-06_JPRB,0.12855E-06_JPRB,0.14572E-06_JPRB,0.16307E-06_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.76015E-07_JPRB,0.88067E-07_JPRB,0.10120E-06_JPRB,0.11510E-06_JPRB,0.12935E-06_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.58813E-07_JPRB,0.68493E-07_JPRB,0.79102E-07_JPRB,0.90273E-07_JPRB,0.10200E-06_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.45440E-07_JPRB,0.53144E-07_JPRB,0.61597E-07_JPRB,0.70639E-07_JPRB,0.80255E-07_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.35015E-07_JPRB,0.41136E-07_JPRB,0.47869E-07_JPRB,0.55216E-07_JPRB,0.62994E-07_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.27056E-07_JPRB,0.31910E-07_JPRB,0.37267E-07_JPRB,0.43210E-07_JPRB,0.49522E-07_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.20908E-07_JPRB,0.24756E-07_JPRB,0.29044E-07_JPRB,0.33791E-07_JPRB,0.38904E-07_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.16131E-07_JPRB,0.19181E-07_JPRB,0.22589E-07_JPRB,0.26378E-07_JPRB,0.30504E-07_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.12418E-07_JPRB,0.14835E-07_JPRB,0.17537E-07_JPRB,0.20547E-07_JPRB,0.23860E-07_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.95994E-08_JPRB,0.11514E-07_JPRB,0.13662E-07_JPRB,0.16065E-07_JPRB,0.18717E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART13',0,ZHOOK_HANDLE)


KB(:,55, 3) = (/ &
 & 0.74239E-08_JPRB,0.89453E-08_JPRB,0.10656E-07_JPRB,0.12569E-07_JPRB,0.14693E-07_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.57300E-08_JPRB,0.69441E-08_JPRB,0.83030E-08_JPRB,0.98193E-08_JPRB,0.11523E-07_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.44152E-08_JPRB,0.53811E-08_JPRB,0.64581E-08_JPRB,0.76610E-08_JPRB,0.90201E-08_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.34072E-08_JPRB,0.41708E-08_JPRB,0.50297E-08_JPRB,0.59876E-08_JPRB,0.70684E-08_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.27302E-08_JPRB,0.33492E-08_JPRB,0.40481E-08_JPRB,0.48266E-08_JPRB,0.57046E-08_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.12015E-03_JPRB,0.13920E-03_JPRB,0.15937E-03_JPRB,0.18001E-03_JPRB,0.19929E-03_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.10256E-03_JPRB,0.11883E-03_JPRB,0.13587E-03_JPRB,0.15259E-03_JPRB,0.16812E-03_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.87203E-04_JPRB,0.10099E-03_JPRB,0.11498E-03_JPRB,0.12847E-03_JPRB,0.14114E-03_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.73859E-04_JPRB,0.85304E-04_JPRB,0.96816E-04_JPRB,0.10774E-03_JPRB,0.11805E-03_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.62334E-04_JPRB,0.71786E-04_JPRB,0.81225E-04_JPRB,0.90091E-04_JPRB,0.98454E-04_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.52581E-04_JPRB,0.60344E-04_JPRB,0.68018E-04_JPRB,0.75237E-04_JPRB,0.81903E-04_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.44197E-04_JPRB,0.50573E-04_JPRB,0.56840E-04_JPRB,0.62656E-04_JPRB,0.67968E-04_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.37151E-04_JPRB,0.42384E-04_JPRB,0.47494E-04_JPRB,0.52193E-04_JPRB,0.56467E-04_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.31193E-04_JPRB,0.35480E-04_JPRB,0.39600E-04_JPRB,0.43427E-04_JPRB,0.46870E-04_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.26374E-04_JPRB,0.29925E-04_JPRB,0.33224E-04_JPRB,0.36261E-04_JPRB,0.39040E-04_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.22315E-04_JPRB,0.25198E-04_JPRB,0.27833E-04_JPRB,0.30290E-04_JPRB,0.32509E-04_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.18883E-04_JPRB,0.21184E-04_JPRB,0.23291E-04_JPRB,0.25268E-04_JPRB,0.27046E-04_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.15977E-04_JPRB,0.17808E-04_JPRB,0.19529E-04_JPRB,0.21106E-04_JPRB,0.22533E-04_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.13524E-04_JPRB,0.14996E-04_JPRB,0.16391E-04_JPRB,0.17658E-04_JPRB,0.18796E-04_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.11433E-04_JPRB,0.12631E-04_JPRB,0.13757E-04_JPRB,0.14769E-04_JPRB,0.15677E-04_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.96558E-05_JPRB,0.10640E-04_JPRB,0.11537E-04_JPRB,0.12357E-04_JPRB,0.13086E-04_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.81632E-05_JPRB,0.89560E-05_JPRB,0.96801E-05_JPRB,0.10339E-04_JPRB,0.10919E-04_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.68972E-05_JPRB,0.75321E-05_JPRB,0.81189E-05_JPRB,0.86418E-05_JPRB,0.91120E-05_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.58255E-05_JPRB,0.63427E-05_JPRB,0.68115E-05_JPRB,0.72291E-05_JPRB,0.76088E-05_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.49235E-05_JPRB,0.53404E-05_JPRB,0.57128E-05_JPRB,0.60450E-05_JPRB,0.63540E-05_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.41602E-05_JPRB,0.44904E-05_JPRB,0.47873E-05_JPRB,0.50567E-05_JPRB,0.53085E-05_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.34993E-05_JPRB,0.37640E-05_JPRB,0.40033E-05_JPRB,0.42217E-05_JPRB,0.44321E-05_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.29168E-05_JPRB,0.31331E-05_JPRB,0.33264E-05_JPRB,0.35072E-05_JPRB,0.36808E-05_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.24105E-05_JPRB,0.25863E-05_JPRB,0.27459E-05_JPRB,0.28969E-05_JPRB,0.30433E-05_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.19699E-05_JPRB,0.21167E-05_JPRB,0.22499E-05_JPRB,0.23751E-05_JPRB,0.24984E-05_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.16085E-05_JPRB,0.17316E-05_JPRB,0.18431E-05_JPRB,0.19482E-05_JPRB,0.20520E-05_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.13140E-05_JPRB,0.14172E-05_JPRB,0.15102E-05_JPRB,0.15989E-05_JPRB,0.16862E-05_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.10643E-05_JPRB,0.11518E-05_JPRB,0.12300E-05_JPRB,0.13052E-05_JPRB,0.13789E-05_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.86103E-06_JPRB,0.93494E-06_JPRB,0.10013E-05_JPRB,0.10648E-05_JPRB,0.11275E-05_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.69566E-06_JPRB,0.75803E-06_JPRB,0.81468E-06_JPRB,0.86817E-06_JPRB,0.92113E-06_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.55856E-06_JPRB,0.61135E-06_JPRB,0.65992E-06_JPRB,0.70501E-06_JPRB,0.74915E-06_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.44644E-06_JPRB,0.49113E-06_JPRB,0.53284E-06_JPRB,0.57066E-06_JPRB,0.60776E-06_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.35638E-06_JPRB,0.39386E-06_JPRB,0.42947E-06_JPRB,0.46192E-06_JPRB,0.49295E-06_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.28317E-06_JPRB,0.31490E-06_JPRB,0.34503E-06_JPRB,0.37276E-06_JPRB,0.39894E-06_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.22341E-06_JPRB,0.25002E-06_JPRB,0.27560E-06_JPRB,0.29957E-06_JPRB,0.32144E-06_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.17554E-06_JPRB,0.19798E-06_JPRB,0.21962E-06_JPRB,0.24010E-06_JPRB,0.25876E-06_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.13737E-06_JPRB,0.15642E-06_JPRB,0.17451E-06_JPRB,0.19192E-06_JPRB,0.20795E-06_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.10754E-06_JPRB,0.12357E-06_JPRB,0.13879E-06_JPRB,0.15343E-06_JPRB,0.16712E-06_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.84121E-07_JPRB,0.97441E-07_JPRB,0.11018E-06_JPRB,0.12256E-06_JPRB,0.13419E-06_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.65604E-07_JPRB,0.76564E-07_JPRB,0.87356E-07_JPRB,0.97703E-07_JPRB,0.10745E-06_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.50943E-07_JPRB,0.59988E-07_JPRB,0.69048E-07_JPRB,0.77629E-07_JPRB,0.85933E-07_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.39679E-07_JPRB,0.47121E-07_JPRB,0.54614E-07_JPRB,0.61766E-07_JPRB,0.68783E-07_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.30934E-07_JPRB,0.36980E-07_JPRB,0.43113E-07_JPRB,0.49142E-07_JPRB,0.55005E-07_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.24050E-07_JPRB,0.28923E-07_JPRB,0.33993E-07_JPRB,0.39047E-07_JPRB,0.43928E-07_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.18660E-07_JPRB,0.22557E-07_JPRB,0.26748E-07_JPRB,0.30951E-07_JPRB,0.35000E-07_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.14488E-07_JPRB,0.17625E-07_JPRB,0.21043E-07_JPRB,0.24511E-07_JPRB,0.27884E-07_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.11674E-07_JPRB,0.14234E-07_JPRB,0.17044E-07_JPRB,0.19902E-07_JPRB,0.22702E-07_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.36288E-03_JPRB,0.38577E-03_JPRB,0.40824E-03_JPRB,0.43207E-03_JPRB,0.45772E-03_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.30781E-03_JPRB,0.32754E-03_JPRB,0.34745E-03_JPRB,0.36873E-03_JPRB,0.39050E-03_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.26023E-03_JPRB,0.27734E-03_JPRB,0.29481E-03_JPRB,0.31288E-03_JPRB,0.33087E-03_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.21963E-03_JPRB,0.23414E-03_JPRB,0.24882E-03_JPRB,0.26383E-03_JPRB,0.27866E-03_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.18486E-03_JPRB,0.19716E-03_JPRB,0.20932E-03_JPRB,0.22139E-03_JPRB,0.23350E-03_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.15516E-03_JPRB,0.16534E-03_JPRB,0.17526E-03_JPRB,0.18520E-03_JPRB,0.19528E-03_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.12986E-03_JPRB,0.13820E-03_JPRB,0.14634E-03_JPRB,0.15465E-03_JPRB,0.16304E-03_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.10854E-03_JPRB,0.11542E-03_JPRB,0.12213E-03_JPRB,0.12898E-03_JPRB,0.13583E-03_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.90628E-04_JPRB,0.96255E-04_JPRB,0.10177E-03_JPRB,0.10738E-03_JPRB,0.11299E-03_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.75891E-04_JPRB,0.80410E-04_JPRB,0.85018E-04_JPRB,0.89561E-04_JPRB,0.94064E-04_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.63476E-04_JPRB,0.67177E-04_JPRB,0.70959E-04_JPRB,0.74590E-04_JPRB,0.78334E-04_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.52999E-04_JPRB,0.56057E-04_JPRB,0.59157E-04_JPRB,0.62167E-04_JPRB,0.65272E-04_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.44256E-04_JPRB,0.46783E-04_JPRB,0.49281E-04_JPRB,0.51789E-04_JPRB,0.54376E-04_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.37011E-04_JPRB,0.39100E-04_JPRB,0.41098E-04_JPRB,0.43198E-04_JPRB,0.45322E-04_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.30966E-04_JPRB,0.32635E-04_JPRB,0.34289E-04_JPRB,0.36026E-04_JPRB,0.37776E-04_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.25866E-04_JPRB,0.27210E-04_JPRB,0.28616E-04_JPRB,0.30009E-04_JPRB,0.31487E-04_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.21609E-04_JPRB,0.22715E-04_JPRB,0.23863E-04_JPRB,0.25052E-04_JPRB,0.26299E-04_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.18055E-04_JPRB,0.18981E-04_JPRB,0.19946E-04_JPRB,0.20948E-04_JPRB,0.21978E-04_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.15103E-04_JPRB,0.15890E-04_JPRB,0.16699E-04_JPRB,0.17556E-04_JPRB,0.18410E-04_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.12647E-04_JPRB,0.13313E-04_JPRB,0.14001E-04_JPRB,0.14715E-04_JPRB,0.15427E-04_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.10601E-04_JPRB,0.11164E-04_JPRB,0.11755E-04_JPRB,0.12351E-04_JPRB,0.12931E-04_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.88699E-05_JPRB,0.93482E-05_JPRB,0.98481E-05_JPRB,0.10351E-04_JPRB,0.10829E-04_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.73864E-05_JPRB,0.77932E-05_JPRB,0.82148E-05_JPRB,0.86289E-05_JPRB,0.90270E-05_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.61189E-05_JPRB,0.64631E-05_JPRB,0.68137E-05_JPRB,0.71535E-05_JPRB,0.74761E-05_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.50349E-05_JPRB,0.53216E-05_JPRB,0.56110E-05_JPRB,0.58984E-05_JPRB,0.61738E-05_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.41408E-05_JPRB,0.43804E-05_JPRB,0.46209E-05_JPRB,0.48585E-05_JPRB,0.50962E-05_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.34100E-05_JPRB,0.36097E-05_JPRB,0.38105E-05_JPRB,0.40114E-05_JPRB,0.42081E-05_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.27924E-05_JPRB,0.29567E-05_JPRB,0.31274E-05_JPRB,0.32925E-05_JPRB,0.34580E-05_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.22821E-05_JPRB,0.24196E-05_JPRB,0.25613E-05_JPRB,0.27009E-05_JPRB,0.28413E-05_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.18665E-05_JPRB,0.19799E-05_JPRB,0.20975E-05_JPRB,0.22150E-05_JPRB,0.23326E-05_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.15195E-05_JPRB,0.16130E-05_JPRB,0.17109E-05_JPRB,0.18095E-05_JPRB,0.19094E-05_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.12351E-05_JPRB,0.13129E-05_JPRB,0.13926E-05_JPRB,0.14756E-05_JPRB,0.15593E-05_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.10023E-05_JPRB,0.10671E-05_JPRB,0.11334E-05_JPRB,0.12033E-05_JPRB,0.12728E-05_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.81269E-06_JPRB,0.86595E-06_JPRB,0.92094E-06_JPRB,0.97875E-06_JPRB,0.10378E-05_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.65647E-06_JPRB,0.70081E-06_JPRB,0.74604E-06_JPRB,0.79395E-06_JPRB,0.84339E-06_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.53019E-06_JPRB,0.56638E-06_JPRB,0.60399E-06_JPRB,0.64368E-06_JPRB,0.68472E-06_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.42776E-06_JPRB,0.45739E-06_JPRB,0.48880E-06_JPRB,0.52108E-06_JPRB,0.55567E-06_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.34556E-06_JPRB,0.36989E-06_JPRB,0.39599E-06_JPRB,0.42284E-06_JPRB,0.45123E-06_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.27905E-06_JPRB,0.29932E-06_JPRB,0.32065E-06_JPRB,0.34295E-06_JPRB,0.36646E-06_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.22522E-06_JPRB,0.24196E-06_JPRB,0.25940E-06_JPRB,0.27788E-06_JPRB,0.29753E-06_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.18137E-06_JPRB,0.19527E-06_JPRB,0.20965E-06_JPRB,0.22512E-06_JPRB,0.24112E-06_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.14606E-06_JPRB,0.15795E-06_JPRB,0.16971E-06_JPRB,0.18256E-06_JPRB,0.19571E-06_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.11745E-06_JPRB,0.12764E-06_JPRB,0.13751E-06_JPRB,0.14796E-06_JPRB,0.15891E-06_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.94319E-07_JPRB,0.10301E-06_JPRB,0.11131E-06_JPRB,0.11979E-06_JPRB,0.12892E-06_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.75512E-07_JPRB,0.83064E-07_JPRB,0.90010E-07_JPRB,0.96928E-07_JPRB,0.10441E-06_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.60409E-07_JPRB,0.66900E-07_JPRB,0.72712E-07_JPRB,0.78451E-07_JPRB,0.84657E-07_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.49299E-07_JPRB,0.54731E-07_JPRB,0.59628E-07_JPRB,0.64415E-07_JPRB,0.69585E-07_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.85498E-03_JPRB,0.88654E-03_JPRB,0.92216E-03_JPRB,0.96018E-03_JPRB,0.10038E-02_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.72755E-03_JPRB,0.75503E-03_JPRB,0.78615E-03_JPRB,0.82104E-03_JPRB,0.86252E-03_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.61644E-03_JPRB,0.64130E-03_JPRB,0.66934E-03_JPRB,0.70298E-03_JPRB,0.74077E-03_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.52100E-03_JPRB,0.54364E-03_JPRB,0.57046E-03_JPRB,0.60137E-03_JPRB,0.63388E-03_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.43945E-03_JPRB,0.46060E-03_JPRB,0.48533E-03_JPRB,0.51276E-03_JPRB,0.54036E-03_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.37082E-03_JPRB,0.39025E-03_JPRB,0.41242E-03_JPRB,0.43532E-03_JPRB,0.45905E-03_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.31280E-03_JPRB,0.33005E-03_JPRB,0.34867E-03_JPRB,0.36806E-03_JPRB,0.38776E-03_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.26373E-03_JPRB,0.27881E-03_JPRB,0.29445E-03_JPRB,0.31046E-03_JPRB,0.32667E-03_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.22211E-03_JPRB,0.23470E-03_JPRB,0.24766E-03_JPRB,0.26115E-03_JPRB,0.27459E-03_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.18729E-03_JPRB,0.19773E-03_JPRB,0.20869E-03_JPRB,0.22010E-03_JPRB,0.23102E-03_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.15755E-03_JPRB,0.16634E-03_JPRB,0.17574E-03_JPRB,0.18527E-03_JPRB,0.19396E-03_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.13244E-03_JPRB,0.14003E-03_JPRB,0.14791E-03_JPRB,0.15556E-03_JPRB,0.16235E-03_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.11137E-03_JPRB,0.11779E-03_JPRB,0.12437E-03_JPRB,0.13036E-03_JPRB,0.13579E-03_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.93817E-04_JPRB,0.99206E-04_JPRB,0.10452E-03_JPRB,0.10918E-03_JPRB,0.11356E-03_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.79006E-04_JPRB,0.83531E-04_JPRB,0.87717E-04_JPRB,0.91355E-04_JPRB,0.95066E-04_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.66464E-04_JPRB,0.70180E-04_JPRB,0.73412E-04_JPRB,0.76548E-04_JPRB,0.79673E-04_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.55955E-04_JPRB,0.58876E-04_JPRB,0.61539E-04_JPRB,0.64161E-04_JPRB,0.66744E-04_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.47057E-04_JPRB,0.49392E-04_JPRB,0.51539E-04_JPRB,0.53762E-04_JPRB,0.55883E-04_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.39571E-04_JPRB,0.41398E-04_JPRB,0.43230E-04_JPRB,0.45052E-04_JPRB,0.46859E-04_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.33232E-04_JPRB,0.34753E-04_JPRB,0.36306E-04_JPRB,0.37802E-04_JPRB,0.39368E-04_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.27886E-04_JPRB,0.29183E-04_JPRB,0.30428E-04_JPRB,0.31753E-04_JPRB,0.33114E-04_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.23408E-04_JPRB,0.24477E-04_JPRB,0.25555E-04_JPRB,0.26683E-04_JPRB,0.27811E-04_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.19576E-04_JPRB,0.20476E-04_JPRB,0.21380E-04_JPRB,0.22323E-04_JPRB,0.23289E-04_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.16284E-04_JPRB,0.17049E-04_JPRB,0.17816E-04_JPRB,0.18626E-04_JPRB,0.19444E-04_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.13488E-04_JPRB,0.14134E-04_JPRB,0.14781E-04_JPRB,0.15488E-04_JPRB,0.16173E-04_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.11176E-04_JPRB,0.11721E-04_JPRB,0.12278E-04_JPRB,0.12866E-04_JPRB,0.13450E-04_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.92494E-05_JPRB,0.97155E-05_JPRB,0.10200E-04_JPRB,0.10699E-04_JPRB,0.11199E-04_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.76168E-05_JPRB,0.80109E-05_JPRB,0.84197E-05_JPRB,0.88496E-05_JPRB,0.92853E-05_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.62645E-05_JPRB,0.66003E-05_JPRB,0.69472E-05_JPRB,0.73123E-05_JPRB,0.76881E-05_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.51581E-05_JPRB,0.54373E-05_JPRB,0.57325E-05_JPRB,0.60421E-05_JPRB,0.63612E-05_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.42336E-05_JPRB,0.44705E-05_JPRB,0.47241E-05_JPRB,0.49790E-05_JPRB,0.52554E-05_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.34635E-05_JPRB,0.36643E-05_JPRB,0.38777E-05_JPRB,0.40942E-05_JPRB,0.43335E-05_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.28355E-05_JPRB,0.30041E-05_JPRB,0.31829E-05_JPRB,0.33678E-05_JPRB,0.35664E-05_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.23151E-05_JPRB,0.24589E-05_JPRB,0.26085E-05_JPRB,0.27655E-05_JPRB,0.29287E-05_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.18832E-05_JPRB,0.20045E-05_JPRB,0.21306E-05_JPRB,0.22633E-05_JPRB,0.24025E-05_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.15291E-05_JPRB,0.16326E-05_JPRB,0.17368E-05_JPRB,0.18516E-05_JPRB,0.19681E-05_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.12403E-05_JPRB,0.13270E-05_JPRB,0.14154E-05_JPRB,0.15108E-05_JPRB,0.16100E-05_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.10056E-05_JPRB,0.10792E-05_JPRB,0.11542E-05_JPRB,0.12335E-05_JPRB,0.13173E-05_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.81549E-06_JPRB,0.87791E-06_JPRB,0.94116E-06_JPRB,0.10080E-05_JPRB,0.10781E-05_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.66029E-06_JPRB,0.71307E-06_JPRB,0.76617E-06_JPRB,0.82179E-06_JPRB,0.88107E-06_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.53353E-06_JPRB,0.57858E-06_JPRB,0.62276E-06_JPRB,0.66919E-06_JPRB,0.71931E-06_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.43199E-06_JPRB,0.46970E-06_JPRB,0.50695E-06_JPRB,0.54584E-06_JPRB,0.58793E-06_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.34966E-06_JPRB,0.38119E-06_JPRB,0.41298E-06_JPRB,0.44530E-06_JPRB,0.48058E-06_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.28227E-06_JPRB,0.30903E-06_JPRB,0.33563E-06_JPRB,0.36285E-06_JPRB,0.39216E-06_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.22764E-06_JPRB,0.25006E-06_JPRB,0.27265E-06_JPRB,0.29503E-06_JPRB,0.31940E-06_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.18380E-06_JPRB,0.20248E-06_JPRB,0.22144E-06_JPRB,0.24002E-06_JPRB,0.25999E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART14',0,ZHOOK_HANDLE)


KB(:,59, 6) = (/ &
 & 0.15102E-06_JPRB,0.16680E-06_JPRB,0.18267E-06_JPRB,0.19825E-06_JPRB,0.21512E-06_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.20763E-02_JPRB,0.21202E-02_JPRB,0.21697E-02_JPRB,0.22297E-02_JPRB,0.22985E-02_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.17631E-02_JPRB,0.18004E-02_JPRB,0.18452E-02_JPRB,0.18998E-02_JPRB,0.19604E-02_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.14970E-02_JPRB,0.15286E-02_JPRB,0.15695E-02_JPRB,0.16172E-02_JPRB,0.16748E-02_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.12672E-02_JPRB,0.12965E-02_JPRB,0.13340E-02_JPRB,0.13795E-02_JPRB,0.14367E-02_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.10695E-02_JPRB,0.10974E-02_JPRB,0.11329E-02_JPRB,0.11783E-02_JPRB,0.12365E-02_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.90477E-03_JPRB,0.93070E-03_JPRB,0.96470E-03_JPRB,0.10105E-02_JPRB,0.10654E-02_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.76431E-03_JPRB,0.79078E-03_JPRB,0.82660E-03_JPRB,0.86991E-03_JPRB,0.91843E-03_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.64676E-03_JPRB,0.67404E-03_JPRB,0.70901E-03_JPRB,0.74996E-03_JPRB,0.79243E-03_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.54776E-03_JPRB,0.57523E-03_JPRB,0.60880E-03_JPRB,0.64511E-03_JPRB,0.68243E-03_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.46614E-03_JPRB,0.49254E-03_JPRB,0.52330E-03_JPRB,0.55502E-03_JPRB,0.58894E-03_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.39726E-03_JPRB,0.42201E-03_JPRB,0.44841E-03_JPRB,0.47653E-03_JPRB,0.50717E-03_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.33898E-03_JPRB,0.36121E-03_JPRB,0.38421E-03_JPRB,0.40924E-03_JPRB,0.43694E-03_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.28981E-03_JPRB,0.30891E-03_JPRB,0.32925E-03_JPRB,0.35185E-03_JPRB,0.37616E-03_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.24765E-03_JPRB,0.26436E-03_JPRB,0.28268E-03_JPRB,0.30306E-03_JPRB,0.32381E-03_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.21161E-03_JPRB,0.22639E-03_JPRB,0.24293E-03_JPRB,0.26080E-03_JPRB,0.27811E-03_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.18103E-03_JPRB,0.19425E-03_JPRB,0.20911E-03_JPRB,0.22426E-03_JPRB,0.23882E-03_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.15524E-03_JPRB,0.16726E-03_JPRB,0.18025E-03_JPRB,0.19313E-03_JPRB,0.20539E-03_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.13346E-03_JPRB,0.14432E-03_JPRB,0.15555E-03_JPRB,0.16625E-03_JPRB,0.17682E-03_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.11513E-03_JPRB,0.12466E-03_JPRB,0.13417E-03_JPRB,0.14329E-03_JPRB,0.15286E-03_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.99437E-04_JPRB,0.10768E-03_JPRB,0.11569E-03_JPRB,0.12397E-03_JPRB,0.13224E-03_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.85975E-04_JPRB,0.92901E-04_JPRB,0.10007E-03_JPRB,0.10742E-03_JPRB,0.11487E-03_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.74186E-04_JPRB,0.80283E-04_JPRB,0.86524E-04_JPRB,0.92965E-04_JPRB,0.99720E-04_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.63518E-04_JPRB,0.68833E-04_JPRB,0.74348E-04_JPRB,0.80205E-04_JPRB,0.86286E-04_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.53971E-04_JPRB,0.58710E-04_JPRB,0.63581E-04_JPRB,0.68731E-04_JPRB,0.74066E-04_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.45287E-04_JPRB,0.49433E-04_JPRB,0.53695E-04_JPRB,0.58207E-04_JPRB,0.62933E-04_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.37993E-04_JPRB,0.41562E-04_JPRB,0.45327E-04_JPRB,0.49315E-04_JPRB,0.53437E-04_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.31889E-04_JPRB,0.34954E-04_JPRB,0.38268E-04_JPRB,0.41760E-04_JPRB,0.45472E-04_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.26490E-04_JPRB,0.29130E-04_JPRB,0.31995E-04_JPRB,0.35094E-04_JPRB,0.38302E-04_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.21977E-04_JPRB,0.24258E-04_JPRB,0.26702E-04_JPRB,0.29405E-04_JPRB,0.32254E-04_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.18218E-04_JPRB,0.20180E-04_JPRB,0.22299E-04_JPRB,0.24616E-04_JPRB,0.27154E-04_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.15034E-04_JPRB,0.16668E-04_JPRB,0.18493E-04_JPRB,0.20514E-04_JPRB,0.22747E-04_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.12376E-04_JPRB,0.13730E-04_JPRB,0.15276E-04_JPRB,0.16983E-04_JPRB,0.18913E-04_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.10149E-04_JPRB,0.11314E-04_JPRB,0.12590E-04_JPRB,0.14099E-04_JPRB,0.15742E-04_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.82889E-05_JPRB,0.92859E-05_JPRB,0.10354E-04_JPRB,0.11603E-04_JPRB,0.13042E-04_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.67264E-05_JPRB,0.75707E-05_JPRB,0.84748E-05_JPRB,0.95081E-05_JPRB,0.10721E-04_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.54454E-05_JPRB,0.61678E-05_JPRB,0.69329E-05_JPRB,0.77845E-05_JPRB,0.87984E-05_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.43942E-05_JPRB,0.50075E-05_JPRB,0.56558E-05_JPRB,0.63802E-05_JPRB,0.72168E-05_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.35518E-05_JPRB,0.40682E-05_JPRB,0.46246E-05_JPRB,0.52318E-05_JPRB,0.59289E-05_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.28695E-05_JPRB,0.33032E-05_JPRB,0.37766E-05_JPRB,0.42938E-05_JPRB,0.48871E-05_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.23151E-05_JPRB,0.26733E-05_JPRB,0.30760E-05_JPRB,0.35184E-05_JPRB,0.40216E-05_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.18635E-05_JPRB,0.21569E-05_JPRB,0.24979E-05_JPRB,0.28705E-05_JPRB,0.33004E-05_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.15043E-05_JPRB,0.17492E-05_JPRB,0.20309E-05_JPRB,0.23469E-05_JPRB,0.27129E-05_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.12156E-05_JPRB,0.14170E-05_JPRB,0.16506E-05_JPRB,0.19188E-05_JPRB,0.22303E-05_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.98090E-06_JPRB,0.11440E-05_JPRB,0.13395E-05_JPRB,0.15647E-05_JPRB,0.18280E-05_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.79029E-06_JPRB,0.92216E-06_JPRB,0.10880E-05_JPRB,0.12732E-05_JPRB,0.14934E-05_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.63691E-06_JPRB,0.74365E-06_JPRB,0.88187E-06_JPRB,0.10375E-05_JPRB,0.12193E-05_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.52696E-06_JPRB,0.61783E-06_JPRB,0.73672E-06_JPRB,0.87054E-06_JPRB,0.10284E-05_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.57453E-02_JPRB,0.59077E-02_JPRB,0.61032E-02_JPRB,0.63038E-02_JPRB,0.65156E-02_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.49738E-02_JPRB,0.51301E-02_JPRB,0.52927E-02_JPRB,0.54623E-02_JPRB,0.56575E-02_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.43017E-02_JPRB,0.44326E-02_JPRB,0.45703E-02_JPRB,0.47292E-02_JPRB,0.49039E-02_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.37082E-02_JPRB,0.38170E-02_JPRB,0.39427E-02_JPRB,0.40844E-02_JPRB,0.42438E-02_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.31847E-02_JPRB,0.32833E-02_JPRB,0.33960E-02_JPRB,0.35252E-02_JPRB,0.36740E-02_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.27225E-02_JPRB,0.28155E-02_JPRB,0.29216E-02_JPRB,0.30449E-02_JPRB,0.31911E-02_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.23309E-02_JPRB,0.24127E-02_JPRB,0.25113E-02_JPRB,0.26325E-02_JPRB,0.27748E-02_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.19939E-02_JPRB,0.20703E-02_JPRB,0.21659E-02_JPRB,0.22816E-02_JPRB,0.24232E-02_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.17051E-02_JPRB,0.17809E-02_JPRB,0.18754E-02_JPRB,0.19919E-02_JPRB,0.21299E-02_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.14632E-02_JPRB,0.15412E-02_JPRB,0.16376E-02_JPRB,0.17554E-02_JPRB,0.18936E-02_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.12639E-02_JPRB,0.13422E-02_JPRB,0.14407E-02_JPRB,0.15575E-02_JPRB,0.16941E-02_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.10971E-02_JPRB,0.11767E-02_JPRB,0.12764E-02_JPRB,0.13939E-02_JPRB,0.15238E-02_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.95870E-03_JPRB,0.10413E-02_JPRB,0.11414E-02_JPRB,0.12556E-02_JPRB,0.13798E-02_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.84686E-03_JPRB,0.93021E-03_JPRB,0.10287E-02_JPRB,0.11374E-02_JPRB,0.12572E-02_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.75447E-03_JPRB,0.83724E-03_JPRB,0.93234E-03_JPRB,0.10369E-02_JPRB,0.11513E-02_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.67798E-03_JPRB,0.75937E-03_JPRB,0.85009E-03_JPRB,0.95072E-03_JPRB,0.10606E-02_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.61364E-03_JPRB,0.69262E-03_JPRB,0.77994E-03_JPRB,0.87674E-03_JPRB,0.98252E-03_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.55903E-03_JPRB,0.63520E-03_JPRB,0.71974E-03_JPRB,0.81322E-03_JPRB,0.91554E-03_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.51301E-03_JPRB,0.58698E-03_JPRB,0.66923E-03_JPRB,0.75972E-03_JPRB,0.85851E-03_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.47350E-03_JPRB,0.54617E-03_JPRB,0.62663E-03_JPRB,0.71470E-03_JPRB,0.81105E-03_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.44016E-03_JPRB,0.51136E-03_JPRB,0.58994E-03_JPRB,0.67638E-03_JPRB,0.77061E-03_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.40944E-03_JPRB,0.47900E-03_JPRB,0.55611E-03_JPRB,0.64143E-03_JPRB,0.73316E-03_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.37741E-03_JPRB,0.44487E-03_JPRB,0.52031E-03_JPRB,0.60323E-03_JPRB,0.69243E-03_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.34297E-03_JPRB,0.40766E-03_JPRB,0.48086E-03_JPRB,0.56132E-03_JPRB,0.64787E-03_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.30431E-03_JPRB,0.36499E-03_JPRB,0.43465E-03_JPRB,0.51167E-03_JPRB,0.59496E-03_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.26970E-03_JPRB,0.32665E-03_JPRB,0.39267E-03_JPRB,0.46706E-03_JPRB,0.54760E-03_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.23923E-03_JPRB,0.29254E-03_JPRB,0.35537E-03_JPRB,0.42706E-03_JPRB,0.50543E-03_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.20758E-03_JPRB,0.25688E-03_JPRB,0.31519E-03_JPRB,0.38349E-03_JPRB,0.45925E-03_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.17937E-03_JPRB,0.22435E-03_JPRB,0.27886E-03_JPRB,0.34337E-03_JPRB,0.41641E-03_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.15469E-03_JPRB,0.19589E-03_JPRB,0.24606E-03_JPRB,0.30674E-03_JPRB,0.37723E-03_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.13101E-03_JPRB,0.16796E-03_JPRB,0.21371E-03_JPRB,0.26992E-03_JPRB,0.33751E-03_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.10980E-03_JPRB,0.14260E-03_JPRB,0.18396E-03_JPRB,0.23557E-03_JPRB,0.29905E-03_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.91682E-04_JPRB,0.12045E-03_JPRB,0.15770E-03_JPRB,0.20472E-03_JPRB,0.26370E-03_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.75628E-04_JPRB,0.10059E-03_JPRB,0.13347E-03_JPRB,0.17595E-03_JPRB,0.22995E-03_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.61269E-04_JPRB,0.82597E-04_JPRB,0.11115E-03_JPRB,0.14863E-03_JPRB,0.19734E-03_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.49295E-04_JPRB,0.67304E-04_JPRB,0.91698E-04_JPRB,0.12475E-03_JPRB,0.16838E-03_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.39400E-04_JPRB,0.54424E-04_JPRB,0.75252E-04_JPRB,0.10388E-03_JPRB,0.14254E-03_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.31621E-04_JPRB,0.44130E-04_JPRB,0.61905E-04_JPRB,0.86583E-04_JPRB,0.12082E-03_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.25214E-04_JPRB,0.35613E-04_JPRB,0.50609E-04_JPRB,0.71998E-04_JPRB,0.10219E-03_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.20045E-04_JPRB,0.28626E-04_JPRB,0.41171E-04_JPRB,0.59458E-04_JPRB,0.85829E-04_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.15795E-04_JPRB,0.22859E-04_JPRB,0.33218E-04_JPRB,0.48810E-04_JPRB,0.71516E-04_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.12537E-04_JPRB,0.18343E-04_JPRB,0.26979E-04_JPRB,0.40183E-04_JPRB,0.59926E-04_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.99418E-05_JPRB,0.14675E-04_JPRB,0.21893E-04_JPRB,0.33017E-04_JPRB,0.50138E-04_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.78293E-05_JPRB,0.11672E-04_JPRB,0.17663E-04_JPRB,0.26975E-04_JPRB,0.41690E-04_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.61519E-05_JPRB,0.92383E-05_JPRB,0.14184E-04_JPRB,0.21901E-04_JPRB,0.34420E-04_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.48509E-05_JPRB,0.73119E-05_JPRB,0.11341E-04_JPRB,0.17783E-04_JPRB,0.28416E-04_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.41003E-05_JPRB,0.62461E-05_JPRB,0.98307E-05_JPRB,0.15678E-04_JPRB,0.25521E-04_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.31088E-01_JPRB,0.30978E-01_JPRB,0.31134E-01_JPRB,0.31580E-01_JPRB,0.32297E-01_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.26804E-01_JPRB,0.26913E-01_JPRB,0.27323E-01_JPRB,0.28019E-01_JPRB,0.28853E-01_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.23192E-01_JPRB,0.23530E-01_JPRB,0.24156E-01_JPRB,0.24918E-01_JPRB,0.25770E-01_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.20205E-01_JPRB,0.20738E-01_JPRB,0.21411E-01_JPRB,0.22189E-01_JPRB,0.23073E-01_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.17721E-01_JPRB,0.18309E-01_JPRB,0.19005E-01_JPRB,0.19816E-01_JPRB,0.20712E-01_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.15569E-01_JPRB,0.16175E-01_JPRB,0.16902E-01_JPRB,0.17717E-01_JPRB,0.18588E-01_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.13679E-01_JPRB,0.14314E-01_JPRB,0.15046E-01_JPRB,0.15840E-01_JPRB,0.16695E-01_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.12060E-01_JPRB,0.12704E-01_JPRB,0.13416E-01_JPRB,0.14184E-01_JPRB,0.14994E-01_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.10678E-01_JPRB,0.11296E-01_JPRB,0.11975E-01_JPRB,0.12694E-01_JPRB,0.13474E-01_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.95206E-02_JPRB,0.10114E-01_JPRB,0.10744E-01_JPRB,0.11429E-01_JPRB,0.12190E-01_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.85244E-02_JPRB,0.90705E-02_JPRB,0.96690E-02_JPRB,0.10334E-01_JPRB,0.11084E-01_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.76472E-02_JPRB,0.81682E-02_JPRB,0.87428E-02_JPRB,0.93948E-02_JPRB,0.10155E-01_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.68906E-02_JPRB,0.73887E-02_JPRB,0.79555E-02_JPRB,0.86116E-02_JPRB,0.93920E-02_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.62406E-02_JPRB,0.67330E-02_JPRB,0.73033E-02_JPRB,0.79807E-02_JPRB,0.87803E-02_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.56879E-02_JPRB,0.61818E-02_JPRB,0.67732E-02_JPRB,0.74721E-02_JPRB,0.82924E-02_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.52214E-02_JPRB,0.57290E-02_JPRB,0.63416E-02_JPRB,0.70614E-02_JPRB,0.79109E-02_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.48396E-02_JPRB,0.53718E-02_JPRB,0.60023E-02_JPRB,0.67493E-02_JPRB,0.76290E-02_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.45394E-02_JPRB,0.50868E-02_JPRB,0.57419E-02_JPRB,0.65213E-02_JPRB,0.74390E-02_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.42997E-02_JPRB,0.48721E-02_JPRB,0.55579E-02_JPRB,0.63736E-02_JPRB,0.73370E-02_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.41212E-02_JPRB,0.47209E-02_JPRB,0.54422E-02_JPRB,0.62987E-02_JPRB,0.73128E-02_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.39976E-02_JPRB,0.46295E-02_JPRB,0.53893E-02_JPRB,0.62949E-02_JPRB,0.73658E-02_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.39007E-02_JPRB,0.45672E-02_JPRB,0.53672E-02_JPRB,0.63167E-02_JPRB,0.74374E-02_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.37869E-02_JPRB,0.44770E-02_JPRB,0.53019E-02_JPRB,0.62849E-02_JPRB,0.74424E-02_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.36393E-02_JPRB,0.43376E-02_JPRB,0.51746E-02_JPRB,0.61726E-02_JPRB,0.73435E-02_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.34235E-02_JPRB,0.41098E-02_JPRB,0.49353E-02_JPRB,0.59226E-02_JPRB,0.70781E-02_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.32247E-02_JPRB,0.38981E-02_JPRB,0.47125E-02_JPRB,0.56849E-02_JPRB,0.68251E-02_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.30456E-02_JPRB,0.37107E-02_JPRB,0.45116E-02_JPRB,0.54683E-02_JPRB,0.65906E-02_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.28232E-02_JPRB,0.34654E-02_JPRB,0.42389E-02_JPRB,0.51610E-02_JPRB,0.62484E-02_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.26119E-02_JPRB,0.32290E-02_JPRB,0.39730E-02_JPRB,0.48613E-02_JPRB,0.59121E-02_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.24180E-02_JPRB,0.30088E-02_JPRB,0.37246E-02_JPRB,0.45813E-02_JPRB,0.55929E-02_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.22093E-02_JPRB,0.27691E-02_JPRB,0.34494E-02_JPRB,0.42630E-02_JPRB,0.52317E-02_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.20033E-02_JPRB,0.25304E-02_JPRB,0.31741E-02_JPRB,0.39439E-02_JPRB,0.48637E-02_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.18130E-02_JPRB,0.23086E-02_JPRB,0.29181E-02_JPRB,0.36487E-02_JPRB,0.45175E-02_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.16283E-02_JPRB,0.20910E-02_JPRB,0.26646E-02_JPRB,0.33526E-02_JPRB,0.41695E-02_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.14435E-02_JPRB,0.18702E-02_JPRB,0.24020E-02_JPRB,0.30439E-02_JPRB,0.38103E-02_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.12773E-02_JPRB,0.16671E-02_JPRB,0.21576E-02_JPRB,0.27587E-02_JPRB,0.34731E-02_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.11238E-02_JPRB,0.14806E-02_JPRB,0.19320E-02_JPRB,0.24920E-02_JPRB,0.31602E-02_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.99065E-03_JPRB,0.13211E-02_JPRB,0.17354E-02_JPRB,0.22582E-02_JPRB,0.28857E-02_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.87220E-03_JPRB,0.11790E-02_JPRB,0.15607E-02_JPRB,0.20453E-02_JPRB,0.26367E-02_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.76443E-03_JPRB,0.10482E-02_JPRB,0.13992E-02_JPRB,0.18469E-02_JPRB,0.24023E-02_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.66506E-03_JPRB,0.92645E-03_JPRB,0.12548E-02_JPRB,0.16624E-02_JPRB,0.21789E-02_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.58147E-03_JPRB,0.82449E-03_JPRB,0.11302E-02_JPRB,0.15093E-02_JPRB,0.19886E-02_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.50762E-03_JPRB,0.73235E-03_JPRB,0.10182E-02_JPRB,0.13732E-02_JPRB,0.18200E-02_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.44063E-03_JPRB,0.64710E-03_JPRB,0.91345E-03_JPRB,0.12471E-02_JPRB,0.16632E-02_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.37891E-03_JPRB,0.56859E-03_JPRB,0.81680E-03_JPRB,0.11290E-02_JPRB,0.15165E-02_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.32563E-03_JPRB,0.50022E-03_JPRB,0.73037E-03_JPRB,0.10236E-02_JPRB,0.13873E-02_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.30307E-03_JPRB,0.47208E-03_JPRB,0.69548E-03_JPRB,0.98198E-03_JPRB,0.13371E-02_JPRB /)  
KB(:,13,10) = (/ &
 & 0.13405E+00_JPRB,0.13208E+00_JPRB,0.13012E+00_JPRB,0.12819E+00_JPRB,0.12637E+00_JPRB /)  
KB(:,14,10) = (/ &
 & 0.11726E+00_JPRB,0.11549E+00_JPRB,0.11376E+00_JPRB,0.11219E+00_JPRB,0.11171E+00_JPRB /)  
KB(:,15,10) = (/ &
 & 0.10125E+00_JPRB,0.99749E-01_JPRB,0.98394E-01_JPRB,0.98385E-01_JPRB,0.99981E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART15',0,ZHOOK_HANDLE)


KB(:,16,10) = (/ &
 & 0.86553E-01_JPRB,0.85383E-01_JPRB,0.85602E-01_JPRB,0.87440E-01_JPRB,0.89929E-01_JPRB /)  
KB(:,17,10) = (/ &
 & 0.73963E-01_JPRB,0.74028E-01_JPRB,0.75744E-01_JPRB,0.77969E-01_JPRB,0.80306E-01_JPRB /)  
KB(:,18,10) = (/ &
 & 0.64249E-01_JPRB,0.65620E-01_JPRB,0.67504E-01_JPRB,0.69584E-01_JPRB,0.72235E-01_JPRB /)  
KB(:,19,10) = (/ &
 & 0.56934E-01_JPRB,0.58613E-01_JPRB,0.60462E-01_JPRB,0.62855E-01_JPRB,0.65899E-01_JPRB /)  
KB(:,20,10) = (/ &
 & 0.50721E-01_JPRB,0.52418E-01_JPRB,0.54615E-01_JPRB,0.57565E-01_JPRB,0.61049E-01_JPRB /)  
KB(:,21,10) = (/ &
 & 0.45027E-01_JPRB,0.47161E-01_JPRB,0.49911E-01_JPRB,0.53249E-01_JPRB,0.56950E-01_JPRB /)  
KB(:,22,10) = (/ &
 & 0.40301E-01_JPRB,0.42891E-01_JPRB,0.46164E-01_JPRB,0.49801E-01_JPRB,0.53839E-01_JPRB /)  
KB(:,23,10) = (/ &
 & 0.36438E-01_JPRB,0.39487E-01_JPRB,0.43011E-01_JPRB,0.46965E-01_JPRB,0.50969E-01_JPRB /)  
KB(:,24,10) = (/ &
 & 0.33455E-01_JPRB,0.36675E-01_JPRB,0.40451E-01_JPRB,0.44369E-01_JPRB,0.48399E-01_JPRB /)  
KB(:,25,10) = (/ &
 & 0.31038E-01_JPRB,0.34461E-01_JPRB,0.38146E-01_JPRB,0.42075E-01_JPRB,0.46138E-01_JPRB /)  
KB(:,26,10) = (/ &
 & 0.29184E-01_JPRB,0.32533E-01_JPRB,0.36194E-01_JPRB,0.40134E-01_JPRB,0.44371E-01_JPRB /)  
KB(:,27,10) = (/ &
 & 0.27607E-01_JPRB,0.30907E-01_JPRB,0.34540E-01_JPRB,0.38584E-01_JPRB,0.43101E-01_JPRB /)  
KB(:,28,10) = (/ &
 & 0.26262E-01_JPRB,0.29536E-01_JPRB,0.33259E-01_JPRB,0.37529E-01_JPRB,0.42311E-01_JPRB /)  
KB(:,29,10) = (/ &
 & 0.25199E-01_JPRB,0.28472E-01_JPRB,0.32405E-01_JPRB,0.36927E-01_JPRB,0.42052E-01_JPRB /)  
KB(:,30,10) = (/ &
 & 0.24317E-01_JPRB,0.27783E-01_JPRB,0.31948E-01_JPRB,0.36772E-01_JPRB,0.42176E-01_JPRB /)  
KB(:,31,10) = (/ &
 & 0.23777E-01_JPRB,0.27457E-01_JPRB,0.31879E-01_JPRB,0.37001E-01_JPRB,0.42663E-01_JPRB /)  
KB(:,32,10) = (/ &
 & 0.23540E-01_JPRB,0.27481E-01_JPRB,0.32177E-01_JPRB,0.37596E-01_JPRB,0.43567E-01_JPRB /)  
KB(:,33,10) = (/ &
 & 0.23597E-01_JPRB,0.27797E-01_JPRB,0.32792E-01_JPRB,0.38465E-01_JPRB,0.44641E-01_JPRB /)  
KB(:,34,10) = (/ &
 & 0.23769E-01_JPRB,0.28231E-01_JPRB,0.33430E-01_JPRB,0.39373E-01_JPRB,0.45740E-01_JPRB /)  
KB(:,35,10) = (/ &
 & 0.23751E-01_JPRB,0.28376E-01_JPRB,0.33764E-01_JPRB,0.39814E-01_JPRB,0.46255E-01_JPRB /)  
KB(:,36,10) = (/ &
 & 0.23409E-01_JPRB,0.28117E-01_JPRB,0.33564E-01_JPRB,0.39651E-01_JPRB,0.46138E-01_JPRB /)  
KB(:,37,10) = (/ &
 & 0.22508E-01_JPRB,0.27169E-01_JPRB,0.32556E-01_JPRB,0.38592E-01_JPRB,0.45071E-01_JPRB /)  
KB(:,38,10) = (/ &
 & 0.21655E-01_JPRB,0.26262E-01_JPRB,0.31543E-01_JPRB,0.37540E-01_JPRB,0.43984E-01_JPRB /)  
KB(:,39,10) = (/ &
 & 0.20895E-01_JPRB,0.25391E-01_JPRB,0.30600E-01_JPRB,0.36519E-01_JPRB,0.42890E-01_JPRB /)  
KB(:,40,10) = (/ &
 & 0.19794E-01_JPRB,0.24108E-01_JPRB,0.29157E-01_JPRB,0.34891E-01_JPRB,0.41215E-01_JPRB /)  
KB(:,41,10) = (/ &
 & 0.18688E-01_JPRB,0.22822E-01_JPRB,0.27713E-01_JPRB,0.33302E-01_JPRB,0.39460E-01_JPRB /)  
KB(:,42,10) = (/ &
 & 0.17627E-01_JPRB,0.21623E-01_JPRB,0.26302E-01_JPRB,0.31747E-01_JPRB,0.37731E-01_JPRB /)  
KB(:,43,10) = (/ &
 & 0.16446E-01_JPRB,0.20270E-01_JPRB,0.24738E-01_JPRB,0.29940E-01_JPRB,0.35800E-01_JPRB /)  
KB(:,44,10) = (/ &
 & 0.15234E-01_JPRB,0.18876E-01_JPRB,0.23100E-01_JPRB,0.28072E-01_JPRB,0.33725E-01_JPRB /)  
KB(:,45,10) = (/ &
 & 0.14095E-01_JPRB,0.17542E-01_JPRB,0.21553E-01_JPRB,0.26276E-01_JPRB,0.31735E-01_JPRB /)  
KB(:,46,10) = (/ &
 & 0.12980E-01_JPRB,0.16215E-01_JPRB,0.20030E-01_JPRB,0.24474E-01_JPRB,0.29695E-01_JPRB /)  
KB(:,47,10) = (/ &
 & 0.11800E-01_JPRB,0.14839E-01_JPRB,0.18423E-01_JPRB,0.22582E-01_JPRB,0.27493E-01_JPRB /)  
KB(:,48,10) = (/ &
 & 0.10669E-01_JPRB,0.13547E-01_JPRB,0.16901E-01_JPRB,0.20822E-01_JPRB,0.25431E-01_JPRB /)  
KB(:,49,10) = (/ &
 & 0.96515E-02_JPRB,0.12347E-01_JPRB,0.15476E-01_JPRB,0.19181E-01_JPRB,0.23474E-01_JPRB /)  
KB(:,50,10) = (/ &
 & 0.87302E-02_JPRB,0.11282E-01_JPRB,0.14230E-01_JPRB,0.17719E-01_JPRB,0.21773E-01_JPRB /)  
KB(:,51,10) = (/ &
 & 0.78879E-02_JPRB,0.10297E-01_JPRB,0.13106E-01_JPRB,0.16387E-01_JPRB,0.20218E-01_JPRB /)  
KB(:,52,10) = (/ &
 & 0.71141E-02_JPRB,0.93631E-02_JPRB,0.12059E-01_JPRB,0.15140E-01_JPRB,0.18761E-01_JPRB /)  
KB(:,53,10) = (/ &
 & 0.64033E-02_JPRB,0.84706E-02_JPRB,0.11019E-01_JPRB,0.13962E-01_JPRB,0.17391E-01_JPRB /)  
KB(:,54,10) = (/ &
 & 0.58003E-02_JPRB,0.77325E-02_JPRB,0.10121E-01_JPRB,0.12913E-01_JPRB,0.16185E-01_JPRB /)  
KB(:,55,10) = (/ &
 & 0.52567E-02_JPRB,0.70672E-02_JPRB,0.93006E-02_JPRB,0.11949E-01_JPRB,0.15064E-01_JPRB /)  
KB(:,56,10) = (/ &
 & 0.47304E-02_JPRB,0.64466E-02_JPRB,0.85460E-02_JPRB,0.11037E-01_JPRB,0.13988E-01_JPRB /)  
KB(:,57,10) = (/ &
 & 0.42280E-02_JPRB,0.58745E-02_JPRB,0.78453E-02_JPRB,0.10192E-01_JPRB,0.12992E-01_JPRB /)  
KB(:,58,10) = (/ &
 & 0.37744E-02_JPRB,0.53584E-02_JPRB,0.72089E-02_JPRB,0.94309E-02_JPRB,0.12101E-01_JPRB /)  
KB(:,59,10) = (/ &
 & 0.36027E-02_JPRB,0.51588E-02_JPRB,0.69694E-02_JPRB,0.91382E-02_JPRB,0.11759E-01_JPRB /)  
KB(:,13,11) = (/ &
 & 0.24636E+00_JPRB,0.24379E+00_JPRB,0.24122E+00_JPRB,0.23863E+00_JPRB,0.23598E+00_JPRB /)  
KB(:,14,11) = (/ &
 & 0.22272E+00_JPRB,0.22032E+00_JPRB,0.21794E+00_JPRB,0.21559E+00_JPRB,0.21334E+00_JPRB /)  
KB(:,15,11) = (/ &
 & 0.19844E+00_JPRB,0.19619E+00_JPRB,0.19411E+00_JPRB,0.19222E+00_JPRB,0.19047E+00_JPRB /)  
KB(:,16,11) = (/ &
 & 0.17439E+00_JPRB,0.17254E+00_JPRB,0.17092E+00_JPRB,0.16946E+00_JPRB,0.16916E+00_JPRB /)  
KB(:,17,11) = (/ &
 & 0.15164E+00_JPRB,0.15027E+00_JPRB,0.14912E+00_JPRB,0.14939E+00_JPRB,0.15176E+00_JPRB /)  
KB(:,18,11) = (/ &
 & 0.13063E+00_JPRB,0.12971E+00_JPRB,0.13029E+00_JPRB,0.13302E+00_JPRB,0.13748E+00_JPRB /)  
KB(:,19,11) = (/ &
 & 0.11203E+00_JPRB,0.11247E+00_JPRB,0.11508E+00_JPRB,0.11959E+00_JPRB,0.12521E+00_JPRB /)  
KB(:,20,11) = (/ &
 & 0.96916E-01_JPRB,0.99041E-01_JPRB,0.10318E+00_JPRB,0.10837E+00_JPRB,0.11414E+00_JPRB /)  
KB(:,21,11) = (/ &
 & 0.85382E-01_JPRB,0.88824E-01_JPRB,0.93367E-01_JPRB,0.98603E-01_JPRB,0.10483E+00_JPRB /)  
KB(:,22,11) = (/ &
 & 0.76943E-01_JPRB,0.80844E-01_JPRB,0.85377E-01_JPRB,0.90964E-01_JPRB,0.97503E-01_JPRB /)  
KB(:,23,11) = (/ &
 & 0.70041E-01_JPRB,0.74136E-01_JPRB,0.79065E-01_JPRB,0.84905E-01_JPRB,0.92247E-01_JPRB /)  
KB(:,24,11) = (/ &
 & 0.64133E-01_JPRB,0.68708E-01_JPRB,0.74135E-01_JPRB,0.80762E-01_JPRB,0.88658E-01_JPRB /)  
KB(:,25,11) = (/ &
 & 0.59352E-01_JPRB,0.64474E-01_JPRB,0.70718E-01_JPRB,0.78064E-01_JPRB,0.86394E-01_JPRB /)  
KB(:,26,11) = (/ &
 & 0.55652E-01_JPRB,0.61613E-01_JPRB,0.68607E-01_JPRB,0.76451E-01_JPRB,0.85230E-01_JPRB /)  
KB(:,27,11) = (/ &
 & 0.53058E-01_JPRB,0.59792E-01_JPRB,0.67298E-01_JPRB,0.75623E-01_JPRB,0.84830E-01_JPRB /)  
KB(:,28,11) = (/ &
 & 0.51454E-01_JPRB,0.58747E-01_JPRB,0.66709E-01_JPRB,0.75478E-01_JPRB,0.85111E-01_JPRB /)  
KB(:,29,11) = (/ &
 & 0.50601E-01_JPRB,0.58412E-01_JPRB,0.66813E-01_JPRB,0.76014E-01_JPRB,0.86051E-01_JPRB /)  
KB(:,30,11) = (/ &
 & 0.50412E-01_JPRB,0.58677E-01_JPRB,0.67503E-01_JPRB,0.77079E-01_JPRB,0.87490E-01_JPRB /)  
KB(:,31,11) = (/ &
 & 0.50833E-01_JPRB,0.59491E-01_JPRB,0.68713E-01_JPRB,0.78659E-01_JPRB,0.89405E-01_JPRB /)  
KB(:,32,11) = (/ &
 & 0.51770E-01_JPRB,0.60792E-01_JPRB,0.70497E-01_JPRB,0.80769E-01_JPRB,0.91778E-01_JPRB /)  
KB(:,33,11) = (/ &
 & 0.53128E-01_JPRB,0.62590E-01_JPRB,0.72506E-01_JPRB,0.83033E-01_JPRB,0.94354E-01_JPRB /)  
KB(:,34,11) = (/ &
 & 0.54518E-01_JPRB,0.64238E-01_JPRB,0.74390E-01_JPRB,0.85011E-01_JPRB,0.96530E-01_JPRB /)  
KB(:,35,11) = (/ &
 & 0.55323E-01_JPRB,0.65129E-01_JPRB,0.75324E-01_JPRB,0.86085E-01_JPRB,0.97742E-01_JPRB /)  
KB(:,36,11) = (/ &
 & 0.55103E-01_JPRB,0.64989E-01_JPRB,0.75282E-01_JPRB,0.86060E-01_JPRB,0.97722E-01_JPRB /)  
KB(:,37,11) = (/ &
 & 0.53513E-01_JPRB,0.63398E-01_JPRB,0.73617E-01_JPRB,0.84326E-01_JPRB,0.95934E-01_JPRB /)  
KB(:,38,11) = (/ &
 & 0.51839E-01_JPRB,0.61729E-01_JPRB,0.71975E-01_JPRB,0.82585E-01_JPRB,0.94078E-01_JPRB /)  
KB(:,39,11) = (/ &
 & 0.50239E-01_JPRB,0.60161E-01_JPRB,0.70354E-01_JPRB,0.80923E-01_JPRB,0.92345E-01_JPRB /)  
KB(:,40,11) = (/ &
 & 0.47749E-01_JPRB,0.57519E-01_JPRB,0.67663E-01_JPRB,0.78238E-01_JPRB,0.89341E-01_JPRB /)  
KB(:,41,11) = (/ &
 & 0.45220E-01_JPRB,0.54835E-01_JPRB,0.64881E-01_JPRB,0.75369E-01_JPRB,0.86308E-01_JPRB /)  
KB(:,42,11) = (/ &
 & 0.42768E-01_JPRB,0.52225E-01_JPRB,0.62107E-01_JPRB,0.72467E-01_JPRB,0.83297E-01_JPRB /)  
KB(:,43,11) = (/ &
 & 0.39884E-01_JPRB,0.49090E-01_JPRB,0.58932E-01_JPRB,0.69072E-01_JPRB,0.79690E-01_JPRB /)  
KB(:,44,11) = (/ &
 & 0.36935E-01_JPRB,0.45822E-01_JPRB,0.55523E-01_JPRB,0.65525E-01_JPRB,0.76019E-01_JPRB /)  
KB(:,45,11) = (/ &
 & 0.34132E-01_JPRB,0.42684E-01_JPRB,0.52151E-01_JPRB,0.62095E-01_JPRB,0.72392E-01_JPRB /)  
KB(:,46,11) = (/ &
 & 0.31296E-01_JPRB,0.39456E-01_JPRB,0.48596E-01_JPRB,0.58446E-01_JPRB,0.68612E-01_JPRB /)  
KB(:,47,11) = (/ &
 & 0.28352E-01_JPRB,0.35994E-01_JPRB,0.44764E-01_JPRB,0.54432E-01_JPRB,0.64443E-01_JPRB /)  
KB(:,48,11) = (/ &
 & 0.25659E-01_JPRB,0.32738E-01_JPRB,0.41113E-01_JPRB,0.50437E-01_JPRB,0.60364E-01_JPRB /)  
KB(:,49,11) = (/ &
 & 0.23119E-01_JPRB,0.29700E-01_JPRB,0.37617E-01_JPRB,0.46554E-01_JPRB,0.56334E-01_JPRB /)  
KB(:,50,11) = (/ &
 & 0.20913E-01_JPRB,0.27063E-01_JPRB,0.34504E-01_JPRB,0.43055E-01_JPRB,0.52582E-01_JPRB /)  
KB(:,51,11) = (/ &
 & 0.18909E-01_JPRB,0.24701E-01_JPRB,0.31626E-01_JPRB,0.39797E-01_JPRB,0.48997E-01_JPRB /)  
KB(:,52,11) = (/ &
 & 0.17085E-01_JPRB,0.22478E-01_JPRB,0.28924E-01_JPRB,0.36689E-01_JPRB,0.45522E-01_JPRB /)  
KB(:,53,11) = (/ &
 & 0.15363E-01_JPRB,0.20405E-01_JPRB,0.26432E-01_JPRB,0.33725E-01_JPRB,0.42180E-01_JPRB /)  
KB(:,54,11) = (/ &
 & 0.13901E-01_JPRB,0.18604E-01_JPRB,0.24309E-01_JPRB,0.31149E-01_JPRB,0.39236E-01_JPRB /)  
KB(:,55,11) = (/ &
 & 0.12627E-01_JPRB,0.16988E-01_JPRB,0.22381E-01_JPRB,0.28834E-01_JPRB,0.36535E-01_JPRB /)  
KB(:,56,11) = (/ &
 & 0.11410E-01_JPRB,0.15484E-01_JPRB,0.20536E-01_JPRB,0.26668E-01_JPRB,0.33955E-01_JPRB /)  
KB(:,57,11) = (/ &
 & 0.10296E-01_JPRB,0.14074E-01_JPRB,0.18805E-01_JPRB,0.24610E-01_JPRB,0.31477E-01_JPRB /)  
KB(:,58,11) = (/ &
 & 0.93246E-02_JPRB,0.12835E-01_JPRB,0.17266E-01_JPRB,0.22752E-01_JPRB,0.29238E-01_JPRB /)  
KB(:,59,11) = (/ &
 & 0.89562E-02_JPRB,0.12359E-01_JPRB,0.16676E-01_JPRB,0.22030E-01_JPRB,0.28380E-01_JPRB /)  
KB(:,13,12) = (/ &
 & 0.46920E+00_JPRB,0.46679E+00_JPRB,0.46431E+00_JPRB,0.46162E+00_JPRB,0.45841E+00_JPRB /)  
KB(:,14,12) = (/ &
 & 0.44978E+00_JPRB,0.44747E+00_JPRB,0.44532E+00_JPRB,0.44273E+00_JPRB,0.44032E+00_JPRB /)  
KB(:,15,12) = (/ &
 & 0.42273E+00_JPRB,0.42112E+00_JPRB,0.41952E+00_JPRB,0.41793E+00_JPRB,0.41621E+00_JPRB /)  
KB(:,16,12) = (/ &
 & 0.39050E+00_JPRB,0.38973E+00_JPRB,0.38909E+00_JPRB,0.38861E+00_JPRB,0.38845E+00_JPRB /)  
KB(:,17,12) = (/ &
 & 0.35567E+00_JPRB,0.35584E+00_JPRB,0.35648E+00_JPRB,0.35743E+00_JPRB,0.35846E+00_JPRB /)  
KB(:,18,12) = (/ &
 & 0.32023E+00_JPRB,0.32164E+00_JPRB,0.32356E+00_JPRB,0.32582E+00_JPRB,0.32854E+00_JPRB /)  
KB(:,19,12) = (/ &
 & 0.28599E+00_JPRB,0.28851E+00_JPRB,0.29173E+00_JPRB,0.29552E+00_JPRB,0.30048E+00_JPRB /)  
KB(:,20,12) = (/ &
 & 0.25381E+00_JPRB,0.25750E+00_JPRB,0.26208E+00_JPRB,0.26822E+00_JPRB,0.27683E+00_JPRB /)  
KB(:,21,12) = (/ &
 & 0.22440E+00_JPRB,0.22938E+00_JPRB,0.23617E+00_JPRB,0.24559E+00_JPRB,0.25713E+00_JPRB /)  
KB(:,22,12) = (/ &
 & 0.19852E+00_JPRB,0.20554E+00_JPRB,0.21550E+00_JPRB,0.22788E+00_JPRB,0.24207E+00_JPRB /)  
KB(:,23,12) = (/ &
 & 0.17693E+00_JPRB,0.18660E+00_JPRB,0.19922E+00_JPRB,0.21410E+00_JPRB,0.23064E+00_JPRB /)  
KB(:,24,12) = (/ &
 & 0.16009E+00_JPRB,0.17209E+00_JPRB,0.18673E+00_JPRB,0.20389E+00_JPRB,0.22257E+00_JPRB /)  
KB(:,25,12) = (/ &
 & 0.14745E+00_JPRB,0.16127E+00_JPRB,0.17793E+00_JPRB,0.19685E+00_JPRB,0.21752E+00_JPRB /)  
KB(:,26,12) = (/ &
 & 0.13842E+00_JPRB,0.15401E+00_JPRB,0.17237E+00_JPRB,0.19313E+00_JPRB,0.21550E+00_JPRB /)  
KB(:,27,12) = (/ &
 & 0.13240E+00_JPRB,0.14962E+00_JPRB,0.16961E+00_JPRB,0.19199E+00_JPRB,0.21568E+00_JPRB /)  
KB(:,28,12) = (/ &
 & 0.12889E+00_JPRB,0.14761E+00_JPRB,0.16917E+00_JPRB,0.19286E+00_JPRB,0.21743E+00_JPRB /)  
KB(:,29,12) = (/ &
 & 0.12765E+00_JPRB,0.14781E+00_JPRB,0.17068E+00_JPRB,0.19527E+00_JPRB,0.22046E+00_JPRB /)  
KB(:,30,12) = (/ &
 & 0.12821E+00_JPRB,0.14964E+00_JPRB,0.17352E+00_JPRB,0.19873E+00_JPRB,0.22436E+00_JPRB /)  
KB(:,31,12) = (/ &
 & 0.13031E+00_JPRB,0.15282E+00_JPRB,0.17742E+00_JPRB,0.20308E+00_JPRB,0.22902E+00_JPRB /)  
KB(:,32,12) = (/ &
 & 0.13354E+00_JPRB,0.15691E+00_JPRB,0.18189E+00_JPRB,0.20791E+00_JPRB,0.23394E+00_JPRB /)  
KB(:,33,12) = (/ &
 & 0.13759E+00_JPRB,0.16158E+00_JPRB,0.18710E+00_JPRB,0.21336E+00_JPRB,0.23934E+00_JPRB /)  
KB(:,34,12) = (/ &
 & 0.14143E+00_JPRB,0.16592E+00_JPRB,0.19181E+00_JPRB,0.21830E+00_JPRB,0.24425E+00_JPRB /)  
KB(:,35,12) = (/ &
 & 0.14328E+00_JPRB,0.16813E+00_JPRB,0.19433E+00_JPRB,0.22092E+00_JPRB,0.24688E+00_JPRB /)  
KB(:,36,12) = (/ &
 & 0.14288E+00_JPRB,0.16783E+00_JPRB,0.19405E+00_JPRB,0.22076E+00_JPRB,0.24684E+00_JPRB /)  
KB(:,37,12) = (/ &
 & 0.13900E+00_JPRB,0.16377E+00_JPRB,0.19000E+00_JPRB,0.21677E+00_JPRB,0.24302E+00_JPRB /)  
KB(:,38,12) = (/ &
 & 0.13517E+00_JPRB,0.15969E+00_JPRB,0.18575E+00_JPRB,0.21259E+00_JPRB,0.23902E+00_JPRB /)  
KB(:,39,12) = (/ &
 & 0.13148E+00_JPRB,0.15568E+00_JPRB,0.18162E+00_JPRB,0.20849E+00_JPRB,0.23507E+00_JPRB /)  
KB(:,40,12) = (/ &
 & 0.12553E+00_JPRB,0.14932E+00_JPRB,0.17494E+00_JPRB,0.20171E+00_JPRB,0.22853E+00_JPRB /)  
KB(:,41,12) = (/ &
 & 0.11952E+00_JPRB,0.14280E+00_JPRB,0.16803E+00_JPRB,0.19459E+00_JPRB,0.22156E+00_JPRB /)  
KB(:,42,12) = (/ &
 & 0.11373E+00_JPRB,0.13636E+00_JPRB,0.16129E+00_JPRB,0.18763E+00_JPRB,0.21464E+00_JPRB /)  
KB(:,43,12) = (/ &
 & 0.10701E+00_JPRB,0.12880E+00_JPRB,0.15312E+00_JPRB,0.17916E+00_JPRB,0.20617E+00_JPRB /)  
KB(:,44,12) = (/ &
 & 0.10010E+00_JPRB,0.12097E+00_JPRB,0.14449E+00_JPRB,0.17006E+00_JPRB,0.19689E+00_JPRB /)  
KB(:,45,12) = (/ &
 & 0.93559E-01_JPRB,0.11347E+00_JPRB,0.13614E+00_JPRB,0.16117E+00_JPRB,0.18764E+00_JPRB /)  
KB(:,46,12) = (/ &
 & 0.86985E-01_JPRB,0.10587E+00_JPRB,0.12759E+00_JPRB,0.15183E+00_JPRB,0.17790E+00_JPRB /)  
KB(:,47,12) = (/ &
 & 0.79918E-01_JPRB,0.97829E-01_JPRB,0.11842E+00_JPRB,0.14172E+00_JPRB,0.16718E+00_JPRB /)  
KB(:,48,12) = (/ &
 & 0.73127E-01_JPRB,0.90284E-01_JPRB,0.10972E+00_JPRB,0.13198E+00_JPRB,0.15666E+00_JPRB /)  
KB(:,49,12) = (/ &
 & 0.66713E-01_JPRB,0.83137E-01_JPRB,0.10149E+00_JPRB,0.12264E+00_JPRB,0.14642E+00_JPRB /)  
KB(:,50,12) = (/ &
 & 0.61017E-01_JPRB,0.76653E-01_JPRB,0.94210E-01_JPRB,0.11429E+00_JPRB,0.13713E+00_JPRB /)  
KB(:,51,12) = (/ &
 & 0.55806E-01_JPRB,0.70628E-01_JPRB,0.87552E-01_JPRB,0.10658E+00_JPRB,0.12844E+00_JPRB /)  
KB(:,52,12) = (/ &
 & 0.50954E-01_JPRB,0.64939E-01_JPRB,0.81159E-01_JPRB,0.99264E-01_JPRB,0.12011E+00_JPRB /)  
KB(:,53,12) = (/ &
 & 0.46354E-01_JPRB,0.59512E-01_JPRB,0.74951E-01_JPRB,0.92338E-01_JPRB,0.11214E+00_JPRB /)  
KB(:,54,12) = (/ &
 & 0.42433E-01_JPRB,0.54851E-01_JPRB,0.69504E-01_JPRB,0.86317E-01_JPRB,0.10517E+00_JPRB /)  
KB(:,55,12) = (/ &
 & 0.38912E-01_JPRB,0.50588E-01_JPRB,0.64547E-01_JPRB,0.80719E-01_JPRB,0.98779E-01_JPRB /)  
KB(:,56,12) = (/ &
 & 0.35756E-01_JPRB,0.46572E-01_JPRB,0.59794E-01_JPRB,0.75289E-01_JPRB,0.92719E-01_JPRB /)  
KB(:,57,12) = (/ &
 & 0.32896E-01_JPRB,0.42811E-01_JPRB,0.55328E-01_JPRB,0.70070E-01_JPRB,0.86950E-01_JPRB /)  
KB(:,58,12) = (/ &
 & 0.30447E-01_JPRB,0.39485E-01_JPRB,0.51269E-01_JPRB,0.65351E-01_JPRB,0.81643E-01_JPRB /)  
KB(:,59,12) = (/ &
 & 0.29531E-01_JPRB,0.38222E-01_JPRB,0.49696E-01_JPRB,0.63514E-01_JPRB,0.79546E-01_JPRB /)  
KB(:,13,13) = (/ &
 & 0.87498E+00_JPRB,0.87414E+00_JPRB,0.87195E+00_JPRB,0.86869E+00_JPRB,0.86437E+00_JPRB /)  
KB(:,14,13) = (/ &
 & 0.90060E+00_JPRB,0.89974E+00_JPRB,0.89734E+00_JPRB,0.89423E+00_JPRB,0.88971E+00_JPRB /)  
KB(:,15,13) = (/ &
 & 0.91305E+00_JPRB,0.91211E+00_JPRB,0.91072E+00_JPRB,0.90792E+00_JPRB,0.90457E+00_JPRB /)  
KB(:,16,13) = (/ &
 & 0.91218E+00_JPRB,0.91265E+00_JPRB,0.91216E+00_JPRB,0.91150E+00_JPRB,0.90908E+00_JPRB /)  
KB(:,17,13) = (/ &
 & 0.89877E+00_JPRB,0.90187E+00_JPRB,0.90414E+00_JPRB,0.90531E+00_JPRB,0.90588E+00_JPRB /)  
KB(:,18,13) = (/ &
 & 0.87718E+00_JPRB,0.88256E+00_JPRB,0.88815E+00_JPRB,0.89271E+00_JPRB,0.89636E+00_JPRB /)  
KB(:,19,13) = (/ &
 & 0.84784E+00_JPRB,0.85815E+00_JPRB,0.86718E+00_JPRB,0.87552E+00_JPRB,0.88267E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART16',0,ZHOOK_HANDLE)


KB(:,20,13) = (/ &
 & 0.81552E+00_JPRB,0.83012E+00_JPRB,0.84379E+00_JPRB,0.85649E+00_JPRB,0.86736E+00_JPRB /)  
KB(:,21,13) = (/ &
 & 0.78216E+00_JPRB,0.80141E+00_JPRB,0.82018E+00_JPRB,0.83708E+00_JPRB,0.85197E+00_JPRB /)  
KB(:,22,13) = (/ &
 & 0.75119E+00_JPRB,0.77590E+00_JPRB,0.79904E+00_JPRB,0.81994E+00_JPRB,0.83870E+00_JPRB /)  
KB(:,23,13) = (/ &
 & 0.72390E+00_JPRB,0.75373E+00_JPRB,0.78079E+00_JPRB,0.80579E+00_JPRB,0.82760E+00_JPRB /)  
KB(:,24,13) = (/ &
 & 0.70145E+00_JPRB,0.73523E+00_JPRB,0.76640E+00_JPRB,0.79456E+00_JPRB,0.81899E+00_JPRB /)  
KB(:,25,13) = (/ &
 & 0.68406E+00_JPRB,0.72159E+00_JPRB,0.75604E+00_JPRB,0.78669E+00_JPRB,0.81321E+00_JPRB /)  
KB(:,26,13) = (/ &
 & 0.67200E+00_JPRB,0.71253E+00_JPRB,0.74968E+00_JPRB,0.78214E+00_JPRB,0.81015E+00_JPRB /)  
KB(:,27,13) = (/ &
 & 0.66447E+00_JPRB,0.70740E+00_JPRB,0.74639E+00_JPRB,0.77996E+00_JPRB,0.80903E+00_JPRB /)  
KB(:,28,13) = (/ &
 & 0.66095E+00_JPRB,0.70586E+00_JPRB,0.74565E+00_JPRB,0.77995E+00_JPRB,0.80973E+00_JPRB /)  
KB(:,29,13) = (/ &
 & 0.66138E+00_JPRB,0.70727E+00_JPRB,0.74725E+00_JPRB,0.78204E+00_JPRB,0.81205E+00_JPRB /)  
KB(:,30,13) = (/ &
 & 0.66437E+00_JPRB,0.71055E+00_JPRB,0.75066E+00_JPRB,0.78572E+00_JPRB,0.81538E+00_JPRB /)  
KB(:,31,13) = (/ &
 & 0.66969E+00_JPRB,0.71558E+00_JPRB,0.75561E+00_JPRB,0.79049E+00_JPRB,0.81954E+00_JPRB /)  
KB(:,32,13) = (/ &
 & 0.67664E+00_JPRB,0.72206E+00_JPRB,0.76182E+00_JPRB,0.79609E+00_JPRB,0.82431E+00_JPRB /)  
KB(:,33,13) = (/ &
 & 0.68486E+00_JPRB,0.72960E+00_JPRB,0.76872E+00_JPRB,0.80214E+00_JPRB,0.82949E+00_JPRB /)  
KB(:,34,13) = (/ &
 & 0.69234E+00_JPRB,0.73624E+00_JPRB,0.77485E+00_JPRB,0.80729E+00_JPRB,0.83397E+00_JPRB /)  
KB(:,35,13) = (/ &
 & 0.69580E+00_JPRB,0.73958E+00_JPRB,0.77791E+00_JPRB,0.80990E+00_JPRB,0.83618E+00_JPRB /)  
KB(:,36,13) = (/ &
 & 0.69461E+00_JPRB,0.73878E+00_JPRB,0.77738E+00_JPRB,0.80959E+00_JPRB,0.83608E+00_JPRB /)  
KB(:,37,13) = (/ &
 & 0.68652E+00_JPRB,0.73194E+00_JPRB,0.77165E+00_JPRB,0.80500E+00_JPRB,0.83229E+00_JPRB /)  
KB(:,38,13) = (/ &
 & 0.67804E+00_JPRB,0.72484E+00_JPRB,0.76560E+00_JPRB,0.80009E+00_JPRB,0.82834E+00_JPRB /)  
KB(:,39,13) = (/ &
 & 0.66970E+00_JPRB,0.71778E+00_JPRB,0.75963E+00_JPRB,0.79504E+00_JPRB,0.82429E+00_JPRB /)  
KB(:,40,13) = (/ &
 & 0.65605E+00_JPRB,0.70590E+00_JPRB,0.74946E+00_JPRB,0.78658E+00_JPRB,0.81742E+00_JPRB /)  
KB(:,41,13) = (/ &
 & 0.64137E+00_JPRB,0.69306E+00_JPRB,0.73837E+00_JPRB,0.77717E+00_JPRB,0.80985E+00_JPRB /)  
KB(:,42,13) = (/ &
 & 0.62638E+00_JPRB,0.67987E+00_JPRB,0.72699E+00_JPRB,0.76756E+00_JPRB,0.80186E+00_JPRB /)  
KB(:,43,13) = (/ &
 & 0.60761E+00_JPRB,0.66320E+00_JPRB,0.71239E+00_JPRB,0.75526E+00_JPRB,0.79130E+00_JPRB /)  
KB(:,44,13) = (/ &
 & 0.58682E+00_JPRB,0.64468E+00_JPRB,0.69616E+00_JPRB,0.74131E+00_JPRB,0.77948E+00_JPRB /)  
KB(:,45,13) = (/ &
 & 0.56554E+00_JPRB,0.62545E+00_JPRB,0.67917E+00_JPRB,0.72630E+00_JPRB,0.76697E+00_JPRB /)  
KB(:,46,13) = (/ &
 & 0.54212E+00_JPRB,0.60419E+00_JPRB,0.66020E+00_JPRB,0.70997E+00_JPRB,0.75300E+00_JPRB /)  
KB(:,47,13) = (/ &
 & 0.51537E+00_JPRB,0.57955E+00_JPRB,0.63814E+00_JPRB,0.69060E+00_JPRB,0.73632E+00_JPRB /)  
KB(:,48,13) = (/ &
 & 0.48823E+00_JPRB,0.55406E+00_JPRB,0.61515E+00_JPRB,0.67007E+00_JPRB,0.71851E+00_JPRB /)  
KB(:,49,13) = (/ &
 & 0.46082E+00_JPRB,0.52769E+00_JPRB,0.59101E+00_JPRB,0.64854E+00_JPRB,0.69978E+00_JPRB /)  
KB(:,50,13) = (/ &
 & 0.43478E+00_JPRB,0.50249E+00_JPRB,0.56761E+00_JPRB,0.62745E+00_JPRB,0.68113E+00_JPRB /)  
KB(:,51,13) = (/ &
 & 0.40951E+00_JPRB,0.47777E+00_JPRB,0.54418E+00_JPRB,0.60613E+00_JPRB,0.66212E+00_JPRB /)  
KB(:,52,13) = (/ &
 & 0.38439E+00_JPRB,0.45288E+00_JPRB,0.52007E+00_JPRB,0.58405E+00_JPRB,0.64238E+00_JPRB /)  
KB(:,53,13) = (/ &
 & 0.35936E+00_JPRB,0.42773E+00_JPRB,0.49564E+00_JPRB,0.56121E+00_JPRB,0.62177E+00_JPRB /)  
KB(:,54,13) = (/ &
 & 0.33659E+00_JPRB,0.40461E+00_JPRB,0.47296E+00_JPRB,0.53959E+00_JPRB,0.60208E+00_JPRB /)  
KB(:,55,13) = (/ &
 & 0.31505E+00_JPRB,0.38259E+00_JPRB,0.45108E+00_JPRB,0.51845E+00_JPRB,0.58256E+00_JPRB /)  
KB(:,56,13) = (/ &
 & 0.29381E+00_JPRB,0.36074E+00_JPRB,0.42910E+00_JPRB,0.49702E+00_JPRB,0.56263E+00_JPRB /)  
KB(:,57,13) = (/ &
 & 0.27284E+00_JPRB,0.33897E+00_JPRB,0.40701E+00_JPRB,0.47542E+00_JPRB,0.54206E+00_JPRB /)  
KB(:,58,13) = (/ &
 & 0.25321E+00_JPRB,0.31859E+00_JPRB,0.38622E+00_JPRB,0.45477E+00_JPRB,0.52205E+00_JPRB /)  
KB(:,59,13) = (/ &
 & 0.24543E+00_JPRB,0.31049E+00_JPRB,0.37793E+00_JPRB,0.44646E+00_JPRB,0.51396E+00_JPRB /)  
KB(:,13,14) = (/ &
 & 0.17373E+01_JPRB,0.17393E+01_JPRB,0.17383E+01_JPRB,0.17344E+01_JPRB,0.17279E+01_JPRB /)  
KB(:,14,14) = (/ &
 & 0.18339E+01_JPRB,0.18343E+01_JPRB,0.18325E+01_JPRB,0.18267E+01_JPRB,0.18189E+01_JPRB /)  
KB(:,15,14) = (/ &
 & 0.19299E+01_JPRB,0.19296E+01_JPRB,0.19248E+01_JPRB,0.19184E+01_JPRB,0.19080E+01_JPRB /)  
KB(:,16,14) = (/ &
 & 0.20259E+01_JPRB,0.20224E+01_JPRB,0.20169E+01_JPRB,0.20066E+01_JPRB,0.19945E+01_JPRB /)  
KB(:,17,14) = (/ &
 & 0.21175E+01_JPRB,0.21127E+01_JPRB,0.21039E+01_JPRB,0.20921E+01_JPRB,0.20768E+01_JPRB /)  
KB(:,18,14) = (/ &
 & 0.22042E+01_JPRB,0.21972E+01_JPRB,0.21859E+01_JPRB,0.21721E+01_JPRB,0.21537E+01_JPRB /)  
KB(:,19,14) = (/ &
 & 0.22848E+01_JPRB,0.22747E+01_JPRB,0.22622E+01_JPRB,0.22448E+01_JPRB,0.22240E+01_JPRB /)  
KB(:,20,14) = (/ &
 & 0.23560E+01_JPRB,0.23462E+01_JPRB,0.23302E+01_JPRB,0.23098E+01_JPRB,0.22867E+01_JPRB /)  
KB(:,21,14) = (/ &
 & 0.24183E+01_JPRB,0.24082E+01_JPRB,0.23905E+01_JPRB,0.23680E+01_JPRB,0.23418E+01_JPRB /)  
KB(:,22,14) = (/ &
 & 0.24717E+01_JPRB,0.24598E+01_JPRB,0.24413E+01_JPRB,0.24169E+01_JPRB,0.23867E+01_JPRB /)  
KB(:,23,14) = (/ &
 & 0.25171E+01_JPRB,0.25034E+01_JPRB,0.24840E+01_JPRB,0.24570E+01_JPRB,0.24242E+01_JPRB /)  
KB(:,24,14) = (/ &
 & 0.25547E+01_JPRB,0.25403E+01_JPRB,0.25194E+01_JPRB,0.24898E+01_JPRB,0.24547E+01_JPRB /)  
KB(:,25,14) = (/ &
 & 0.25855E+01_JPRB,0.25703E+01_JPRB,0.25468E+01_JPRB,0.25156E+01_JPRB,0.24784E+01_JPRB /)  
KB(:,26,14) = (/ &
 & 0.26110E+01_JPRB,0.25944E+01_JPRB,0.25683E+01_JPRB,0.25352E+01_JPRB,0.24957E+01_JPRB /)  
KB(:,27,14) = (/ &
 & 0.26319E+01_JPRB,0.26130E+01_JPRB,0.25843E+01_JPRB,0.25495E+01_JPRB,0.25077E+01_JPRB /)  
KB(:,28,14) = (/ &
 & 0.26480E+01_JPRB,0.26264E+01_JPRB,0.25959E+01_JPRB,0.25590E+01_JPRB,0.25150E+01_JPRB /)  
KB(:,29,14) = (/ &
 & 0.26603E+01_JPRB,0.26355E+01_JPRB,0.26036E+01_JPRB,0.25644E+01_JPRB,0.25186E+01_JPRB /)  
KB(:,30,14) = (/ &
 & 0.26690E+01_JPRB,0.26417E+01_JPRB,0.26076E+01_JPRB,0.25661E+01_JPRB,0.25188E+01_JPRB /)  
KB(:,31,14) = (/ &
 & 0.26742E+01_JPRB,0.26446E+01_JPRB,0.26086E+01_JPRB,0.25648E+01_JPRB,0.25163E+01_JPRB /)  
KB(:,32,14) = (/ &
 & 0.26768E+01_JPRB,0.26452E+01_JPRB,0.26068E+01_JPRB,0.25609E+01_JPRB,0.25113E+01_JPRB /)  
KB(:,33,14) = (/ &
 & 0.26771E+01_JPRB,0.26434E+01_JPRB,0.26028E+01_JPRB,0.25551E+01_JPRB,0.25044E+01_JPRB /)  
KB(:,34,14) = (/ &
 & 0.26762E+01_JPRB,0.26409E+01_JPRB,0.25981E+01_JPRB,0.25494E+01_JPRB,0.24981E+01_JPRB /)  
KB(:,35,14) = (/ &
 & 0.26773E+01_JPRB,0.26407E+01_JPRB,0.25970E+01_JPRB,0.25475E+01_JPRB,0.24957E+01_JPRB /)  
KB(:,36,14) = (/ &
 & 0.26808E+01_JPRB,0.26440E+01_JPRB,0.25999E+01_JPRB,0.25501E+01_JPRB,0.24981E+01_JPRB /)  
KB(:,37,14) = (/ &
 & 0.26888E+01_JPRB,0.26526E+01_JPRB,0.26095E+01_JPRB,0.25599E+01_JPRB,0.25079E+01_JPRB /)  
KB(:,38,14) = (/ &
 & 0.26963E+01_JPRB,0.26609E+01_JPRB,0.26186E+01_JPRB,0.25695E+01_JPRB,0.25177E+01_JPRB /)  
KB(:,39,14) = (/ &
 & 0.27030E+01_JPRB,0.26686E+01_JPRB,0.26272E+01_JPRB,0.25787E+01_JPRB,0.25269E+01_JPRB /)  
KB(:,40,14) = (/ &
 & 0.27118E+01_JPRB,0.26792E+01_JPRB,0.26399E+01_JPRB,0.25927E+01_JPRB,0.25414E+01_JPRB /)  
KB(:,41,14) = (/ &
 & 0.27201E+01_JPRB,0.26898E+01_JPRB,0.26520E+01_JPRB,0.26068E+01_JPRB,0.25561E+01_JPRB /)  
KB(:,42,14) = (/ &
 & 0.27274E+01_JPRB,0.27000E+01_JPRB,0.26636E+01_JPRB,0.26203E+01_JPRB,0.25704E+01_JPRB /)  
KB(:,43,14) = (/ &
 & 0.27341E+01_JPRB,0.27108E+01_JPRB,0.26767E+01_JPRB,0.26357E+01_JPRB,0.25871E+01_JPRB /)  
KB(:,44,14) = (/ &
 & 0.27398E+01_JPRB,0.27209E+01_JPRB,0.26898E+01_JPRB,0.26513E+01_JPRB,0.26050E+01_JPRB /)  
KB(:,45,14) = (/ &
 & 0.27435E+01_JPRB,0.27298E+01_JPRB,0.27021E+01_JPRB,0.26655E+01_JPRB,0.26220E+01_JPRB /)  
KB(:,46,14) = (/ &
 & 0.27454E+01_JPRB,0.27371E+01_JPRB,0.27139E+01_JPRB,0.26799E+01_JPRB,0.26391E+01_JPRB /)  
KB(:,47,14) = (/ &
 & 0.27460E+01_JPRB,0.27424E+01_JPRB,0.27253E+01_JPRB,0.26950E+01_JPRB,0.26569E+01_JPRB /)  
KB(:,48,14) = (/ &
 & 0.27436E+01_JPRB,0.27457E+01_JPRB,0.27342E+01_JPRB,0.27088E+01_JPRB,0.26736E+01_JPRB /)  
KB(:,49,14) = (/ &
 & 0.27370E+01_JPRB,0.27470E+01_JPRB,0.27411E+01_JPRB,0.27207E+01_JPRB,0.26888E+01_JPRB /)  
KB(:,50,14) = (/ &
 & 0.27269E+01_JPRB,0.27459E+01_JPRB,0.27451E+01_JPRB,0.27305E+01_JPRB,0.27022E+01_JPRB /)  
KB(:,51,14) = (/ &
 & 0.27139E+01_JPRB,0.27424E+01_JPRB,0.27470E+01_JPRB,0.27377E+01_JPRB,0.27140E+01_JPRB /)  
KB(:,52,14) = (/ &
 & 0.26965E+01_JPRB,0.27350E+01_JPRB,0.27474E+01_JPRB,0.27429E+01_JPRB,0.27243E+01_JPRB /)  
KB(:,53,14) = (/ &
 & 0.26758E+01_JPRB,0.27241E+01_JPRB,0.27457E+01_JPRB,0.27461E+01_JPRB,0.27331E+01_JPRB /)  
KB(:,54,14) = (/ &
 & 0.26529E+01_JPRB,0.27108E+01_JPRB,0.27417E+01_JPRB,0.27475E+01_JPRB,0.27393E+01_JPRB /)  
KB(:,55,14) = (/ &
 & 0.26271E+01_JPRB,0.26955E+01_JPRB,0.27349E+01_JPRB,0.27476E+01_JPRB,0.27437E+01_JPRB /)  
KB(:,56,14) = (/ &
 & 0.25970E+01_JPRB,0.26775E+01_JPRB,0.27251E+01_JPRB,0.27462E+01_JPRB,0.27464E+01_JPRB /)  
KB(:,57,14) = (/ &
 & 0.25617E+01_JPRB,0.26559E+01_JPRB,0.27125E+01_JPRB,0.27426E+01_JPRB,0.27477E+01_JPRB /)  
KB(:,58,14) = (/ &
 & 0.25247E+01_JPRB,0.26320E+01_JPRB,0.26988E+01_JPRB,0.27363E+01_JPRB,0.27482E+01_JPRB /)  
KB(:,59,14) = (/ &
 & 0.25089E+01_JPRB,0.26212E+01_JPRB,0.26923E+01_JPRB,0.27333E+01_JPRB,0.27480E+01_JPRB /)  
KB(:,13,15) = (/ &
 & 0.36859E+01_JPRB,0.36950E+01_JPRB,0.36942E+01_JPRB,0.36830E+01_JPRB,0.36649E+01_JPRB /)  
KB(:,14,15) = (/ &
 & 0.41563E+01_JPRB,0.41556E+01_JPRB,0.41430E+01_JPRB,0.41233E+01_JPRB,0.40913E+01_JPRB /)  
KB(:,15,15) = (/ &
 & 0.46342E+01_JPRB,0.46206E+01_JPRB,0.45970E+01_JPRB,0.45604E+01_JPRB,0.45153E+01_JPRB /)  
KB(:,16,15) = (/ &
 & 0.51044E+01_JPRB,0.50788E+01_JPRB,0.50384E+01_JPRB,0.49882E+01_JPRB,0.49250E+01_JPRB /)  
KB(:,17,15) = (/ &
 & 0.55612E+01_JPRB,0.55175E+01_JPRB,0.54618E+01_JPRB,0.53932E+01_JPRB,0.53123E+01_JPRB /)  
KB(:,18,15) = (/ &
 & 0.59883E+01_JPRB,0.59323E+01_JPRB,0.58578E+01_JPRB,0.57682E+01_JPRB,0.56700E+01_JPRB /)  
KB(:,19,15) = (/ &
 & 0.63852E+01_JPRB,0.63106E+01_JPRB,0.62177E+01_JPRB,0.61123E+01_JPRB,0.59947E+01_JPRB /)  
KB(:,20,15) = (/ &
 & 0.67473E+01_JPRB,0.66496E+01_JPRB,0.65407E+01_JPRB,0.64159E+01_JPRB,0.62789E+01_JPRB /)  
KB(:,21,15) = (/ &
 & 0.70720E+01_JPRB,0.69522E+01_JPRB,0.68220E+01_JPRB,0.66792E+01_JPRB,0.65258E+01_JPRB /)  
KB(:,22,15) = (/ &
 & 0.73512E+01_JPRB,0.72082E+01_JPRB,0.70565E+01_JPRB,0.68942E+01_JPRB,0.67258E+01_JPRB /)  
KB(:,23,15) = (/ &
 & 0.75866E+01_JPRB,0.74239E+01_JPRB,0.72515E+01_JPRB,0.70718E+01_JPRB,0.68886E+01_JPRB /)  
KB(:,24,15) = (/ &
 & 0.77818E+01_JPRB,0.75993E+01_JPRB,0.74076E+01_JPRB,0.72128E+01_JPRB,0.70154E+01_JPRB /)  
KB(:,25,15) = (/ &
 & 0.79381E+01_JPRB,0.77379E+01_JPRB,0.75298E+01_JPRB,0.73205E+01_JPRB,0.71111E+01_JPRB /)  
KB(:,26,15) = (/ &
 & 0.80556E+01_JPRB,0.78384E+01_JPRB,0.76185E+01_JPRB,0.73961E+01_JPRB,0.71755E+01_JPRB /)  
KB(:,27,15) = (/ &
 & 0.81409E+01_JPRB,0.79095E+01_JPRB,0.76795E+01_JPRB,0.74472E+01_JPRB,0.72174E+01_JPRB /)  
KB(:,28,15) = (/ &
 & 0.81987E+01_JPRB,0.79569E+01_JPRB,0.77176E+01_JPRB,0.74766E+01_JPRB,0.72412E+01_JPRB /)  
KB(:,29,15) = (/ &
 & 0.82302E+01_JPRB,0.79809E+01_JPRB,0.77337E+01_JPRB,0.74875E+01_JPRB,0.72468E+01_JPRB /)  
KB(:,30,15) = (/ &
 & 0.82419E+01_JPRB,0.79875E+01_JPRB,0.77343E+01_JPRB,0.74825E+01_JPRB,0.72390E+01_JPRB /)  
KB(:,31,15) = (/ &
 & 0.82369E+01_JPRB,0.79780E+01_JPRB,0.77201E+01_JPRB,0.74661E+01_JPRB,0.72183E+01_JPRB /)  
KB(:,32,15) = (/ &
 & 0.82187E+01_JPRB,0.79550E+01_JPRB,0.76944E+01_JPRB,0.74386E+01_JPRB,0.71874E+01_JPRB /)  
KB(:,33,15) = (/ &
 & 0.81889E+01_JPRB,0.79220E+01_JPRB,0.76592E+01_JPRB,0.74026E+01_JPRB,0.71493E+01_JPRB /)  
KB(:,34,15) = (/ &
 & 0.81602E+01_JPRB,0.78912E+01_JPRB,0.76262E+01_JPRB,0.73693E+01_JPRB,0.71134E+01_JPRB /)  
KB(:,35,15) = (/ &
 & 0.81506E+01_JPRB,0.78799E+01_JPRB,0.76144E+01_JPRB,0.73562E+01_JPRB,0.70988E+01_JPRB /)  
KB(:,36,15) = (/ &
 & 0.81664E+01_JPRB,0.78930E+01_JPRB,0.76263E+01_JPRB,0.73664E+01_JPRB,0.71072E+01_JPRB /)  
KB(:,37,15) = (/ &
 & 0.82200E+01_JPRB,0.79452E+01_JPRB,0.76751E+01_JPRB,0.74132E+01_JPRB,0.71537E+01_JPRB /)  
KB(:,38,15) = (/ &
 & 0.82730E+01_JPRB,0.79962E+01_JPRB,0.77251E+01_JPRB,0.74606E+01_JPRB,0.72002E+01_JPRB /)  
KB(:,39,15) = (/ &
 & 0.83243E+01_JPRB,0.80459E+01_JPRB,0.77713E+01_JPRB,0.75063E+01_JPRB,0.72452E+01_JPRB /)  
KB(:,40,15) = (/ &
 & 0.84027E+01_JPRB,0.81225E+01_JPRB,0.78456E+01_JPRB,0.75775E+01_JPRB,0.73152E+01_JPRB /)  
KB(:,41,15) = (/ &
 & 0.84834E+01_JPRB,0.82013E+01_JPRB,0.79233E+01_JPRB,0.76507E+01_JPRB,0.73874E+01_JPRB /)  
KB(:,42,15) = (/ &
 & 0.85638E+01_JPRB,0.82794E+01_JPRB,0.79999E+01_JPRB,0.77248E+01_JPRB,0.74594E+01_JPRB /)  
KB(:,43,15) = (/ &
 & 0.86608E+01_JPRB,0.83728E+01_JPRB,0.80910E+01_JPRB,0.78137E+01_JPRB,0.75464E+01_JPRB /)  
KB(:,44,15) = (/ &
 & 0.87658E+01_JPRB,0.84741E+01_JPRB,0.81903E+01_JPRB,0.79102E+01_JPRB,0.76390E+01_JPRB /)  
KB(:,45,15) = (/ &
 & 0.88709E+01_JPRB,0.85747E+01_JPRB,0.82886E+01_JPRB,0.80079E+01_JPRB,0.77318E+01_JPRB /)  
KB(:,46,15) = (/ &
 & 0.89828E+01_JPRB,0.86839E+01_JPRB,0.83945E+01_JPRB,0.81115E+01_JPRB,0.78321E+01_JPRB /)  
KB(:,47,15) = (/ &
 & 0.91067E+01_JPRB,0.88066E+01_JPRB,0.85118E+01_JPRB,0.82270E+01_JPRB,0.79459E+01_JPRB /)  
KB(:,48,15) = (/ &
 & 0.92318E+01_JPRB,0.89292E+01_JPRB,0.86312E+01_JPRB,0.83427E+01_JPRB,0.80595E+01_JPRB /)  
KB(:,49,15) = (/ &
 & 0.93597E+01_JPRB,0.90533E+01_JPRB,0.87516E+01_JPRB,0.84602E+01_JPRB,0.81749E+01_JPRB /)  
KB(:,50,15) = (/ &
 & 0.94828E+01_JPRB,0.91681E+01_JPRB,0.88667E+01_JPRB,0.85700E+01_JPRB,0.82833E+01_JPRB /)  
KB(:,51,15) = (/ &
 & 0.96031E+01_JPRB,0.92821E+01_JPRB,0.89785E+01_JPRB,0.86778E+01_JPRB,0.83878E+01_JPRB /)  
KB(:,52,15) = (/ &
 & 0.97227E+01_JPRB,0.93978E+01_JPRB,0.90892E+01_JPRB,0.87879E+01_JPRB,0.84938E+01_JPRB /)  
KB(:,53,15) = (/ &
 & 0.98436E+01_JPRB,0.95182E+01_JPRB,0.92014E+01_JPRB,0.88988E+01_JPRB,0.86011E+01_JPRB /)  
KB(:,54,15) = (/ &
 & 0.99573E+01_JPRB,0.96274E+01_JPRB,0.93049E+01_JPRB,0.90008E+01_JPRB,0.87001E+01_JPRB /)  
KB(:,55,15) = (/ &
 & 0.10066E+02_JPRB,0.97327E+01_JPRB,0.94075E+01_JPRB,0.90983E+01_JPRB,0.87962E+01_JPRB /)  
KB(:,56,15) = (/ &
 & 0.10177E+02_JPRB,0.98378E+01_JPRB,0.95127E+01_JPRB,0.91960E+01_JPRB,0.88926E+01_JPRB /)  
KB(:,57,15) = (/ &
 & 0.10293E+02_JPRB,0.99462E+01_JPRB,0.96173E+01_JPRB,0.92949E+01_JPRB,0.89909E+01_JPRB /)  
KB(:,58,15) = (/ &
 & 0.10405E+02_JPRB,0.10049E+02_JPRB,0.97160E+01_JPRB,0.93909E+01_JPRB,0.90821E+01_JPRB /)  
KB(:,59,15) = (/ &
 & 0.10450E+02_JPRB,0.10090E+02_JPRB,0.97556E+01_JPRB,0.94305E+01_JPRB,0.91193E+01_JPRB /)  
KB(:,13,16) = (/ &
 & 0.50473E+01_JPRB,0.50398E+01_JPRB,0.50183E+01_JPRB,0.49834E+01_JPRB,0.49369E+01_JPRB /)  
KB(:,14,16) = (/ &
 & 0.59220E+01_JPRB,0.58911E+01_JPRB,0.58423E+01_JPRB,0.57748E+01_JPRB,0.56924E+01_JPRB /)  
KB(:,15,16) = (/ &
 & 0.68737E+01_JPRB,0.68078E+01_JPRB,0.67189E+01_JPRB,0.66072E+01_JPRB,0.64839E+01_JPRB /)  
KB(:,16,16) = (/ &
 & 0.78824E+01_JPRB,0.77694E+01_JPRB,0.76268E+01_JPRB,0.74643E+01_JPRB,0.72894E+01_JPRB /)  
KB(:,17,16) = (/ &
 & 0.89270E+01_JPRB,0.87413E+01_JPRB,0.85370E+01_JPRB,0.83130E+01_JPRB,0.80798E+01_JPRB /)  
KB(:,18,16) = (/ &
 & 0.99711E+01_JPRB,0.97011E+01_JPRB,0.94250E+01_JPRB,0.91345E+01_JPRB,0.88363E+01_JPRB /)  
KB(:,19,16) = (/ &
 & 0.10989E+02_JPRB,0.10627E+02_JPRB,0.10268E+02_JPRB,0.99076E+01_JPRB,0.95430E+01_JPRB /)  
KB(:,20,16) = (/ &
 & 0.11944E+02_JPRB,0.11487E+02_JPRB,0.11042E+02_JPRB,0.10609E+02_JPRB,0.10177E+02_JPRB /)  
KB(:,21,16) = (/ &
 & 0.12817E+02_JPRB,0.12265E+02_JPRB,0.11737E+02_JPRB,0.11232E+02_JPRB,0.10736E+02_JPRB /)  
KB(:,22,16) = (/ &
 & 0.13548E+02_JPRB,0.12914E+02_JPRB,0.12305E+02_JPRB,0.11734E+02_JPRB,0.11183E+02_JPRB /)  
KB(:,23,16) = (/ &
 & 0.14162E+02_JPRB,0.13448E+02_JPRB,0.12773E+02_JPRB,0.12143E+02_JPRB,0.11545E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART17',0,ZHOOK_HANDLE)


KB(:,24,16) = (/ &
 & 0.14655E+02_JPRB,0.13870E+02_JPRB,0.13141E+02_JPRB,0.12464E+02_JPRB,0.11822E+02_JPRB /)  
KB(:,25,16) = (/ &
 & 0.15031E+02_JPRB,0.14189E+02_JPRB,0.13415E+02_JPRB,0.12699E+02_JPRB,0.12023E+02_JPRB /)  
KB(:,26,16) = (/ &
 & 0.15288E+02_JPRB,0.14405E+02_JPRB,0.13595E+02_JPRB,0.12850E+02_JPRB,0.12149E+02_JPRB /)  
KB(:,27,16) = (/ &
 & 0.15452E+02_JPRB,0.14541E+02_JPRB,0.13705E+02_JPRB,0.12937E+02_JPRB,0.12216E+02_JPRB /)  
KB(:,28,16) = (/ &
 & 0.15538E+02_JPRB,0.14608E+02_JPRB,0.13754E+02_JPRB,0.12971E+02_JPRB,0.12237E+02_JPRB /)  
KB(:,29,16) = (/ &
 & 0.15553E+02_JPRB,0.14613E+02_JPRB,0.13748E+02_JPRB,0.12957E+02_JPRB,0.12214E+02_JPRB /)  
KB(:,30,16) = (/ &
 & 0.15516E+02_JPRB,0.14571E+02_JPRB,0.13703E+02_JPRB,0.12907E+02_JPRB,0.12159E+02_JPRB /)  
KB(:,31,16) = (/ &
 & 0.15433E+02_JPRB,0.14488E+02_JPRB,0.13621E+02_JPRB,0.12822E+02_JPRB,0.12076E+02_JPRB /)  
KB(:,32,16) = (/ &
 & 0.15312E+02_JPRB,0.14373E+02_JPRB,0.13511E+02_JPRB,0.12712E+02_JPRB,0.11970E+02_JPRB /)  
KB(:,33,16) = (/ &
 & 0.15164E+02_JPRB,0.14234E+02_JPRB,0.13378E+02_JPRB,0.12584E+02_JPRB,0.11848E+02_JPRB /)  
KB(:,34,16) = (/ &
 & 0.15029E+02_JPRB,0.14108E+02_JPRB,0.13258E+02_JPRB,0.12470E+02_JPRB,0.11741E+02_JPRB /)  
KB(:,35,16) = (/ &
 & 0.14974E+02_JPRB,0.14055E+02_JPRB,0.13205E+02_JPRB,0.12418E+02_JPRB,0.11691E+02_JPRB /)  
KB(:,36,16) = (/ &
 & 0.15011E+02_JPRB,0.14086E+02_JPRB,0.13232E+02_JPRB,0.12441E+02_JPRB,0.11710E+02_JPRB /)  
KB(:,37,16) = (/ &
 & 0.15186E+02_JPRB,0.14243E+02_JPRB,0.13376E+02_JPRB,0.12573E+02_JPRB,0.11831E+02_JPRB /)  
KB(:,38,16) = (/ &
 & 0.15364E+02_JPRB,0.14405E+02_JPRB,0.13523E+02_JPRB,0.12708E+02_JPRB,0.11955E+02_JPRB /)  
KB(:,39,16) = (/ &
 & 0.15541E+02_JPRB,0.14562E+02_JPRB,0.13666E+02_JPRB,0.12840E+02_JPRB,0.12075E+02_JPRB /)  
KB(:,40,16) = (/ &
 & 0.15818E+02_JPRB,0.14814E+02_JPRB,0.13896E+02_JPRB,0.13052E+02_JPRB,0.12271E+02_JPRB /)  
KB(:,41,16) = (/ &
 & 0.16115E+02_JPRB,0.15082E+02_JPRB,0.14138E+02_JPRB,0.13278E+02_JPRB,0.12478E+02_JPRB /)  
KB(:,42,16) = (/ &
 & 0.16420E+02_JPRB,0.15352E+02_JPRB,0.14384E+02_JPRB,0.13504E+02_JPRB,0.12687E+02_JPRB /)  
KB(:,43,16) = (/ &
 & 0.16793E+02_JPRB,0.15690E+02_JPRB,0.14694E+02_JPRB,0.13784E+02_JPRB,0.12952E+02_JPRB /)  
KB(:,44,16) = (/ &
 & 0.17211E+02_JPRB,0.16062E+02_JPRB,0.15031E+02_JPRB,0.14091E+02_JPRB,0.13236E+02_JPRB /)  
KB(:,45,16) = (/ &
 & 0.17640E+02_JPRB,0.16447E+02_JPRB,0.15376E+02_JPRB,0.14411E+02_JPRB,0.13526E+02_JPRB /)  
KB(:,46,16) = (/ &
 & 0.18112E+02_JPRB,0.16870E+02_JPRB,0.15758E+02_JPRB,0.14754E+02_JPRB,0.13842E+02_JPRB /)  
KB(:,47,16) = (/ &
 & 0.18658E+02_JPRB,0.17363E+02_JPRB,0.16197E+02_JPRB,0.15151E+02_JPRB,0.14204E+02_JPRB /)  
KB(:,48,16) = (/ &
 & 0.19225E+02_JPRB,0.17876E+02_JPRB,0.16658E+02_JPRB,0.15564E+02_JPRB,0.14577E+02_JPRB /)  
KB(:,49,16) = (/ &
 & 0.19824E+02_JPRB,0.18409E+02_JPRB,0.17136E+02_JPRB,0.15993E+02_JPRB,0.14967E+02_JPRB /)  
KB(:,50,16) = (/ &
 & 0.20411E+02_JPRB,0.18926E+02_JPRB,0.17606E+02_JPRB,0.16414E+02_JPRB,0.15344E+02_JPRB /)  
KB(:,51,16) = (/ &
 & 0.21005E+02_JPRB,0.19452E+02_JPRB,0.18077E+02_JPRB,0.16838E+02_JPRB,0.15725E+02_JPRB /)  
KB(:,52,16) = (/ &
 & 0.21646E+02_JPRB,0.20001E+02_JPRB,0.18565E+02_JPRB,0.17278E+02_JPRB,0.16117E+02_JPRB /)  
KB(:,53,16) = (/ &
 & 0.22315E+02_JPRB,0.20576E+02_JPRB,0.19072E+02_JPRB,0.17736E+02_JPRB,0.16529E+02_JPRB /)  
KB(:,54,16) = (/ &
 & 0.22958E+02_JPRB,0.21134E+02_JPRB,0.19557E+02_JPRB,0.18172E+02_JPRB,0.16919E+02_JPRB /)  
KB(:,55,16) = (/ &
 & 0.23603E+02_JPRB,0.21694E+02_JPRB,0.20042E+02_JPRB,0.18600E+02_JPRB,0.17305E+02_JPRB /)  
KB(:,56,16) = (/ &
 & 0.24285E+02_JPRB,0.22278E+02_JPRB,0.20543E+02_JPRB,0.19044E+02_JPRB,0.17707E+02_JPRB /)  
KB(:,57,16) = (/ &
 & 0.24997E+02_JPRB,0.22887E+02_JPRB,0.21074E+02_JPRB,0.19504E+02_JPRB,0.18121E+02_JPRB /)  
KB(:,58,16) = (/ &
 & 0.25697E+02_JPRB,0.23494E+02_JPRB,0.21600E+02_JPRB,0.19961E+02_JPRB,0.18525E+02_JPRB /)  
KB(:,59,16) = (/ &
 & 0.25984E+02_JPRB,0.23748E+02_JPRB,0.21819E+02_JPRB,0.20147E+02_JPRB,0.18689E+02_JPRB /)  
  
!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.106275E-05_JPRB, 0.104185E-05_JPRB, 0.420154E-05_JPRB /)
FORREF(:, 2) = (/ 0.154343E-05_JPRB, 0.653193E-05_JPRB, 0.174596E-04_JPRB /)
FORREF(:, 3) = (/ 0.348917E-05_JPRB, 0.108420E-04_JPRB, 0.540849E-04_JPRB /)
FORREF(:, 4) = (/ 0.145822E-04_JPRB, 0.156027E-04_JPRB, 0.881263E-04_JPRB /)
FORREF(:, 5) = (/ 0.220204E-04_JPRB, 0.819892E-04_JPRB, 0.817937E-04_JPRB /)
FORREF(:, 6) = (/ 0.447840E-04_JPRB, 0.121116E-03_JPRB, 0.932635E-04_JPRB /)
FORREF(:, 7) = (/ 0.166516E-03_JPRB, 0.147640E-03_JPRB, 0.754029E-04_JPRB /)
FORREF(:, 8) = (/ 0.234756E-03_JPRB, 0.145934E-03_JPRB, 0.771734E-04_JPRB /)
FORREF(:, 9) = (/ 0.289207E-03_JPRB, 0.146768E-03_JPRB, 0.677806E-04_JPRB /)
FORREF(:,10) = (/ 0.334959E-03_JPRB, 0.125513E-03_JPRB, 0.636648E-04_JPRB /)
FORREF(:,11) = (/ 0.333755E-03_JPRB, 0.136575E-03_JPRB, 0.593651E-04_JPRB /)
FORREF(:,12) = (/ 0.340042E-03_JPRB, 0.116259E-03_JPRB, 0.595192E-04_JPRB /)
FORREF(:,13) = (/ 0.422470E-03_JPRB, 0.148691E-03_JPRB, 0.630266E-04_JPRB /)
FORREF(:,14) = (/ 0.440655E-03_JPRB, 0.461917E-04_JPRB, 0.108222E-04_JPRB /)
FORREF(:,15) = (/ 0.486207E-03_JPRB, 0.428458E-03_JPRB, 0.108086E-04_JPRB /)
FORREF(:,16) = (/ 0.657463E-03_JPRB, 0.657446E-03_JPRB, 0.126190E-04_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
     
SELFREF(:, 1) = (/ &
 & 0.331728E-03_JPRB, 0.287480E-03_JPRB, 0.249135E-03_JPRB, 0.215904E-03_JPRB, 0.187106E-03_JPRB, &
 & 0.162149E-03_JPRB, 0.140520E-03_JPRB, 0.121777E-03_JPRB, 0.105534E-03_JPRB, 0.914573E-04_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.882628E-03_JPRB, 0.698914E-03_JPRB, 0.553439E-03_JPRB, 0.438244E-03_JPRB, 0.347026E-03_JPRB, &
 & 0.274795E-03_JPRB, 0.217598E-03_JPRB, 0.172306E-03_JPRB, 0.136442E-03_JPRB, 0.108042E-03_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.115461E-02_JPRB, 0.937203E-03_JPRB, 0.760730E-03_JPRB, 0.617486E-03_JPRB, 0.501215E-03_JPRB, &
 & 0.406837E-03_JPRB, 0.330231E-03_JPRB, 0.268049E-03_JPRB, 0.217576E-03_JPRB, 0.176607E-03_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.103450E-02_JPRB, 0.960268E-03_JPRB, 0.891360E-03_JPRB, 0.827397E-03_JPRB, 0.768024E-03_JPRB, &
 & 0.712911E-03_JPRB, 0.661754E-03_JPRB, 0.614267E-03_JPRB, 0.570188E-03_JPRB, 0.529272E-03_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.289040E-02_JPRB, 0.240129E-02_JPRB, 0.199495E-02_JPRB, 0.165737E-02_JPRB, 0.137692E-02_JPRB, &
 & 0.114392E-02_JPRB, 0.950351E-03_JPRB, 0.789535E-03_JPRB, 0.655933E-03_JPRB, 0.544938E-03_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.361772E-02_JPRB, 0.306611E-02_JPRB, 0.259861E-02_JPRB, 0.220239E-02_JPRB, 0.186659E-02_JPRB, &
 & 0.158198E-02_JPRB, 0.134077E-02_JPRB, 0.113634E-02_JPRB, 0.963078E-03_JPRB, 0.816234E-03_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.329878E-02_JPRB, 0.318245E-02_JPRB, 0.307021E-02_JPRB, 0.296194E-02_JPRB, 0.285749E-02_JPRB, &
 & 0.275671E-02_JPRB, 0.265950E-02_JPRB, 0.256571E-02_JPRB, 0.247522E-02_JPRB, 0.238793E-02_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.293562E-02_JPRB, 0.300077E-02_JPRB, 0.306737E-02_JPRB, 0.313544E-02_JPRB, 0.320503E-02_JPRB, &
 & 0.327615E-02_JPRB, 0.334886E-02_JPRB, 0.342318E-02_JPRB, 0.349915E-02_JPRB, 0.357680E-02_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.281453E-02_JPRB, 0.295894E-02_JPRB, 0.311076E-02_JPRB, 0.327038E-02_JPRB, 0.343818E-02_JPRB, &
 & 0.361459E-02_JPRB, 0.380006E-02_JPRB, 0.399504E-02_JPRB, 0.420002E-02_JPRB, 0.441553E-02_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.239488E-02_JPRB, 0.262487E-02_JPRB, 0.287696E-02_JPRB, 0.315325E-02_JPRB, 0.345607E-02_JPRB, &
 & 0.378798E-02_JPRB, 0.415176E-02_JPRB, 0.455048E-02_JPRB, 0.498749E-02_JPRB, 0.546647E-02_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.271001E-02_JPRB, 0.292235E-02_JPRB, 0.315134E-02_JPRB, 0.339826E-02_JPRB, 0.366453E-02_JPRB, &
 & 0.395167E-02_JPRB, 0.426131E-02_JPRB, 0.459521E-02_JPRB, 0.495527E-02_JPRB, 0.534354E-02_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.206702E-02_JPRB, 0.232254E-02_JPRB, 0.260966E-02_JPRB, 0.293226E-02_JPRB, 0.329475E-02_JPRB, &
 & 0.370204E-02_JPRB, 0.415969E-02_JPRB, 0.467391E-02_JPRB, 0.525169E-02_JPRB, 0.590090E-02_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.227023E-02_JPRB, 0.257331E-02_JPRB, 0.291685E-02_JPRB, 0.330626E-02_JPRB, 0.374766E-02_JPRB, &
 & 0.424799E-02_JPRB, 0.481511E-02_JPRB, 0.545794E-02_JPRB, 0.618660E-02_JPRB, 0.701253E-02_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.851078E-03_JPRB, 0.111512E-02_JPRB, 0.146109E-02_JPRB, 0.191439E-02_JPRB, 0.250832E-02_JPRB, &
 & 0.328653E-02_JPRB, 0.430617E-02_JPRB, 0.564215E-02_JPRB, 0.739261E-02_JPRB, 0.968616E-02_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.742711E-02_JPRB, 0.721347E-02_JPRB, 0.700598E-02_JPRB, 0.680446E-02_JPRB, 0.660873E-02_JPRB, &
 & 0.641863E-02_JPRB, 0.623400E-02_JPRB, 0.605468E-02_JPRB, 0.588052E-02_JPRB, 0.571137E-02_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.107170E-01_JPRB, 0.101913E-01_JPRB, 0.969138E-02_JPRB, 0.921599E-02_JPRB, 0.876392E-02_JPRB, &
 & 0.833402E-02_JPRB, 0.792521E-02_JPRB, 0.753646E-02_JPRB, 0.716677E-02_JPRB, 0.681522E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB19:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


END SUBROUTINE SRTM_KGB19

