!***************************************************************************
SUBROUTINE RRTM_CMBGB8
!***************************************************************************

!     BAND 8:  1080-1180 cm-1 (low (i.e.>~300mb) - H2O; high - O3)
!     ABozzo 201306 updated to rrtmg v4.85
!***************************************************************************

! Parameters
USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO8 , ONLY : KAO     ,KBO     ,SELFREFO   ,FORREFO, FRACREFAO  ,&
 & FRACREFBO, KAO_MCO2, KAO_MN2O ,KAO_MO3, KBO_MCO2, KBO_MN2O, &
 & CFC12O   , CFC22ADJO  
USE YOERRTA8 , ONLY : KA      ,KB      ,SELFREF    ,FORREF, FRACREFA   ,&
 & FRACREFB , KA_MCO2, KA_MN2O ,KA_MO3, KB_MCO2, KB_MN2O,&
 & CFC12    , CFC22ADJ  
USE YOERRTRWT, ONLY : RWGT
USE YOERRTFTR, ONLY : NGC      ,NGS      ,NGN      

IMPLICIT NONE

INTEGER(KIND=JPIM) :: IGC, IPR, IPRSM, JP, JT

REAL(KIND=JPRB) :: Z_SUMF1, Z_SUMF2, Z_SUMK, Z_SUMK1, Z_SUMK2, Z_SUMK3, Z_SUMK4, Z_SUMK5
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB8',0,ZHOOK_HANDLE)
DO JT = 1,5
  DO JP = 1,13
    IPRSM = 0
    DO IGC = 1,NGC(8)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(7)+IGC)
        IPRSM = IPRSM + 1
        Z_SUMK = Z_SUMK + KAO(JT,JP,IPRSM)*RWGT(IPRSM+112)
      ENDDO
      KA(JT,JP,IGC) = Z_SUMK
    ENDDO
  ENDDO
ENDDO
DO JT = 1,5
  DO JP = 13,59
    IPRSM = 0
    DO IGC = 1,NGC(8)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(7)+IGC)
        IPRSM = IPRSM + 1
        Z_SUMK = Z_SUMK + KBO(JT,JP,IPRSM)*RWGT(IPRSM+112)
      ENDDO
      KB(JT,JP,IGC) = Z_SUMK
    ENDDO
  ENDDO
ENDDO

DO JT = 1,10
  IPRSM = 0
  DO IGC = 1,NGC(8)
    Z_SUMK = 0.0_JPRB
    DO IPR = 1, NGN(NGS(7)+IGC)
      IPRSM = IPRSM + 1
      Z_SUMK = Z_SUMK + SELFREFO(JT,IPRSM)*RWGT(IPRSM+112)
    ENDDO
    SELFREF(JT,IGC) = Z_SUMK
  ENDDO
ENDDO
DO JT = 1,4
   IPRSM = 0
   DO IGC = 1,NGC(8)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(7)+IGC)
         IPRSM = IPRSM + 1
         Z_SUMK = Z_SUMK + FORREFO(JT,IPRSM)*RWGT(IPRSM+112)
      ENDDO
      FORREF(JT,IGC) = Z_SUMK
   ENDDO
ENDDO

DO JT = 1,19
IPRSM = 0
DO IGC = 1,NGC(8)
  Z_SUMK1= 0.0_JPRB
  Z_SUMK2= 0.0_JPRB
  Z_SUMK3= 0.0_JPRB
  Z_SUMK4= 0.0_JPRB
  Z_SUMK5= 0.0_JPRB
  DO IPR = 1, NGN(NGS(7)+IGC)
    IPRSM = IPRSM + 1
    Z_SUMK1= Z_SUMK1+ KAO_MCO2(JT,IPRSM)*RWGT(IPRSM+112)
    Z_SUMK2= Z_SUMK2+ KBO_MCO2(JT,IPRSM)*RWGT(IPRSM+112)
    Z_SUMK3= Z_SUMK3+ KAO_MO3(JT,IPRSM)*RWGT(IPRSM+112)
    Z_SUMK4= Z_SUMK4+ KAO_MN2O(JT,IPRSM)*RWGT(IPRSM+112)
    Z_SUMK5= Z_SUMK5+ KBO_MN2O(JT,IPRSM)*RWGT(IPRSM+112)
  ENDDO
  KA_MCO2(JT,IGC) = Z_SUMK1
  KB_MCO2(JT,IGC) = Z_SUMK2
  KA_MO3(JT,IGC) = Z_SUMK3
  KA_MN2O(JT,IGC) = Z_SUMK4
  KB_MN2O(JT,IGC) = Z_SUMK5
ENDDO
ENDDO



IPRSM = 0
DO IGC = 1,NGC(8)
  Z_SUMF1= 0.0_JPRB
  Z_SUMF2= 0.0_JPRB
  Z_SUMK1= 0.0_JPRB
  Z_SUMK2= 0.0_JPRB
  DO IPR = 1, NGN(NGS(7)+IGC)
    IPRSM = IPRSM + 1
    Z_SUMF1= Z_SUMF1+ FRACREFAO(IPRSM)
    Z_SUMF2= Z_SUMF2+ FRACREFBO(IPRSM)
    Z_SUMK1= Z_SUMK1+ CFC12O(IPRSM)*RWGT(IPRSM+112)
    Z_SUMK2= Z_SUMK2+ CFC22ADJO(IPRSM)*RWGT(IPRSM+112)
  ENDDO
  FRACREFA(IGC) = Z_SUMF1
  FRACREFB(IGC) = Z_SUMF2
  CFC12(IGC) = Z_SUMK1
  CFC22ADJ(IGC) = Z_SUMK2
ENDDO



IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB8',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_CMBGB8
