!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 1:  10-250 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO1 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO ,&
 & FRACREFBO  ,FORREFO  

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1',1,ZHOOK_HANDLE)

!-----------------------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART1',0,ZHOOK_HANDLE)


FRACREFAO( :) = (/&
 & 0.08452097_JPRB,0.17952873_JPRB,0.16214369_JPRB,0.13602182_JPRB,&
 & 0.12760490_JPRB,0.10302561_JPRB,0.08392423_JPRB,0.06337652_JPRB,&
 & 0.04206551_JPRB,0.00487497_JPRB,0.00410743_JPRB,0.00344421_JPRB,&
 & 0.00285731_JPRB,0.00157327_JPRB,0.00080648_JPRB,0.00012406_JPRB/)  

FRACREFBO( :) = (/&
 & 0.15492001_JPRB,0.17384727_JPRB,0.15165100_JPRB,0.12675308_JPRB,&
 & 0.10986247_JPRB,0.09006091_JPRB,0.07584465_JPRB,0.05990077_JPRB,&
 & 0.04113461_JPRB,0.00438638_JPRB,0.00374754_JPRB,0.00313924_JPRB,&
 & 0.00234381_JPRB,0.00167167_JPRB,0.00062744_JPRB,0.00010889_JPRB/)  

FORREFO( :) = (/&
 & -4.50470E-02_JPRB,-1.18908E-01_JPRB,-7.21730E-02_JPRB,-2.83862E-02_JPRB,&
 & -3.01961E-02_JPRB,-1.56877E-02_JPRB,-1.53684E-02_JPRB,-1.29135E-02_JPRB,&
 & -1.27963E-02_JPRB,-1.81742E-03_JPRB, 4.40008E-05_JPRB, 1.05260E-02_JPRB,&
 & 2.17290E-02_JPRB, 1.65571E-02_JPRB, 7.60751E-02_JPRB, 1.47405E-01_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 2.9728E-01_JPRB,2.7117E-01_JPRB,2.4824E-01_JPRB,2.2823E-01_JPRB,2.1073E-01_JPRB/)  
KAO( :, 2, 1) = (/&
 & 2.5383E-01_JPRB,2.3094E-01_JPRB,2.1122E-01_JPRB,1.9387E-01_JPRB,1.7870E-01_JPRB/)  
KAO( :, 3, 1) = (/&
 & 2.2079E-01_JPRB,2.0034E-01_JPRB,1.8264E-01_JPRB,1.6726E-01_JPRB,1.5378E-01_JPRB/)  
KAO( :, 4, 1) = (/&
 & 1.9385E-01_JPRB,1.7531E-01_JPRB,1.5932E-01_JPRB,1.4544E-01_JPRB,1.3338E-01_JPRB/)  
KAO( :, 5, 1) = (/&
 & 1.7059E-01_JPRB,1.5374E-01_JPRB,1.3930E-01_JPRB,1.2682E-01_JPRB,1.1600E-01_JPRB/)  
KAO( :, 6, 1) = (/&
 & 1.5085E-01_JPRB,1.3549E-01_JPRB,1.2235E-01_JPRB,1.1112E-01_JPRB,1.0142E-01_JPRB/)  
KAO( :, 7, 1) = (/&
 & 1.3366E-01_JPRB,1.1960E-01_JPRB,1.0771E-01_JPRB,9.7560E-02_JPRB,8.8804E-02_JPRB/)  
KAO( :, 8, 1) = (/&
 & 1.1833E-01_JPRB,1.0551E-01_JPRB,9.4748E-02_JPRB,8.5642E-02_JPRB,7.7808E-02_JPRB/)  
KAO( :, 9, 1) = (/&
 & 1.0407E-01_JPRB,9.2585E-02_JPRB,8.3046E-02_JPRB,7.5077E-02_JPRB,6.8338E-02_JPRB/)  
KAO( :,10, 1) = (/&
 & 9.6249E-02_JPRB,8.6268E-02_JPRB,7.7918E-02_JPRB,7.0909E-02_JPRB,6.5026E-02_JPRB/)  
KAO( :,11, 1) = (/&
 & 8.5798E-02_JPRB,7.7607E-02_JPRB,7.0781E-02_JPRB,6.5084E-02_JPRB,6.0324E-02_JPRB/)  
KAO( :,12, 1) = (/&
 & 7.5259E-02_JPRB,6.8525E-02_JPRB,6.2945E-02_JPRB,5.8330E-02_JPRB,5.4507E-02_JPRB/)  
KAO( :,13, 1) = (/&
 & 6.6022E-02_JPRB,6.0316E-02_JPRB,5.5584E-02_JPRB,5.1665E-02_JPRB,4.8461E-02_JPRB/)  
KAO( :, 1, 2) = (/&
 & 1.0868E+00_JPRB,1.0180E+00_JPRB,9.5619E-01_JPRB,9.0008E-01_JPRB,8.4968E-01_JPRB/)  
KAO( :, 2, 2) = (/&
 & 9.1280E-01_JPRB,8.5427E-01_JPRB,8.0215E-01_JPRB,7.5470E-01_JPRB,7.1212E-01_JPRB/)  
KAO( :, 3, 2) = (/&
 & 7.7699E-01_JPRB,7.2607E-01_JPRB,6.8084E-01_JPRB,6.3997E-01_JPRB,6.0293E-01_JPRB/)  
KAO( :, 4, 2) = (/&
 & 6.6708E-01_JPRB,6.2264E-01_JPRB,5.8280E-01_JPRB,5.4723E-01_JPRB,5.1498E-01_JPRB/)  
KAO( :, 5, 2) = (/&
 & 5.7399E-01_JPRB,5.3509E-01_JPRB,5.0018E-01_JPRB,4.6892E-01_JPRB,4.4080E-01_JPRB/)  
KAO( :, 6, 2) = (/&
 & 4.9530E-01_JPRB,4.6110E-01_JPRB,4.3040E-01_JPRB,4.0285E-01_JPRB,3.7815E-01_JPRB/)  
KAO( :, 7, 2) = (/&
 & 4.2745E-01_JPRB,3.9732E-01_JPRB,3.7040E-01_JPRB,3.4614E-01_JPRB,3.2442E-01_JPRB/)  
KAO( :, 8, 2) = (/&
 & 3.6869E-01_JPRB,3.4268E-01_JPRB,3.1900E-01_JPRB,2.9776E-01_JPRB,2.7880E-01_JPRB/)  
KAO( :, 9, 2) = (/&
 & 3.1986E-01_JPRB,2.9734E-01_JPRB,2.7688E-01_JPRB,2.5843E-01_JPRB,2.4196E-01_JPRB/)  
KAO( :,10, 2) = (/&
 & 2.8291E-01_JPRB,2.6327E-01_JPRB,2.4583E-01_JPRB,2.3014E-01_JPRB,2.1607E-01_JPRB/)  
KAO( :,11, 2) = (/&
 & 2.4260E-01_JPRB,2.2644E-01_JPRB,2.1226E-01_JPRB,1.9956E-01_JPRB,1.8806E-01_JPRB/)  
KAO( :,12, 2) = (/&
 & 2.0558E-01_JPRB,1.9256E-01_JPRB,1.8115E-01_JPRB,1.7097E-01_JPRB,1.6176E-01_JPRB/)  
KAO( :,13, 2) = (/&
 & 1.7296E-01_JPRB,1.6235E-01_JPRB,1.5298E-01_JPRB,1.4476E-01_JPRB,1.3735E-01_JPRB/)  
KAO( :, 1, 3) = (/&
 & 1.9978E+00_JPRB,1.9059E+00_JPRB,1.8189E+00_JPRB,1.7366E+00_JPRB,1.6586E+00_JPRB/)  
KAO( :, 2, 3) = (/&
 & 1.6606E+00_JPRB,1.5839E+00_JPRB,1.5107E+00_JPRB,1.4431E+00_JPRB,1.3779E+00_JPRB/)  
KAO( :, 3, 3) = (/&
 & 1.3892E+00_JPRB,1.3254E+00_JPRB,1.2641E+00_JPRB,1.2074E+00_JPRB,1.1536E+00_JPRB/)  
KAO( :, 4, 3) = (/&
 & 1.1729E+00_JPRB,1.1192E+00_JPRB,1.0684E+00_JPRB,1.0206E+00_JPRB,9.7581E-01_JPRB/)  
KAO( :, 5, 3) = (/&
 & 9.9394E-01_JPRB,9.4858E-01_JPRB,9.0600E-01_JPRB,8.6583E-01_JPRB,8.2779E-01_JPRB/)  
KAO( :, 6, 3) = (/&
 & 8.4450E-01_JPRB,8.0530E-01_JPRB,7.6915E-01_JPRB,7.3568E-01_JPRB,7.0371E-01_JPRB/)  
KAO( :, 7, 3) = (/&
 & 7.1829E-01_JPRB,6.8411E-01_JPRB,6.5331E-01_JPRB,6.2452E-01_JPRB,5.9760E-01_JPRB/)  
KAO( :, 8, 3) = (/&
 & 6.1224E-01_JPRB,5.8194E-01_JPRB,5.5498E-01_JPRB,5.3049E-01_JPRB,5.0749E-01_JPRB/)  
KAO( :, 9, 3) = (/&
 & 5.2649E-01_JPRB,4.9920E-01_JPRB,4.7516E-01_JPRB,4.5390E-01_JPRB,4.3400E-01_JPRB/)  
KAO( :,10, 3) = (/&
 & 4.6036E-01_JPRB,4.3661E-01_JPRB,4.1510E-01_JPRB,3.9653E-01_JPRB,3.7973E-01_JPRB/)  
KAO( :,11, 3) = (/&
 & 3.9552E-01_JPRB,3.7556E-01_JPRB,3.5783E-01_JPRB,3.4242E-01_JPRB,3.2854E-01_JPRB/)  
KAO( :,12, 3) = (/&
 & 3.3619E-01_JPRB,3.1976E-01_JPRB,3.0528E-01_JPRB,2.9270E-01_JPRB,2.8130E-01_JPRB/)  
KAO( :,13, 3) = (/&
 & 2.8224E-01_JPRB,2.6905E-01_JPRB,2.5767E-01_JPRB,2.4740E-01_JPRB,2.3812E-01_JPRB/)  
KAO( :, 1, 4) = (/&
 & 3.1134E+00_JPRB,2.9768E+00_JPRB,2.8528E+00_JPRB,2.7371E+00_JPRB,2.6298E+00_JPRB/)  
KAO( :, 2, 4) = (/&
 & 2.5980E+00_JPRB,2.4825E+00_JPRB,2.3758E+00_JPRB,2.2768E+00_JPRB,2.1885E+00_JPRB/)  
KAO( :, 3, 4) = (/&
 & 2.1823E+00_JPRB,2.0815E+00_JPRB,1.9888E+00_JPRB,1.9036E+00_JPRB,1.8278E+00_JPRB/)  
KAO( :, 4, 4) = (/&
 & 1.8482E+00_JPRB,1.7602E+00_JPRB,1.6798E+00_JPRB,1.6064E+00_JPRB,1.5402E+00_JPRB/)  
KAO( :, 5, 4) = (/&
 & 1.5691E+00_JPRB,1.4937E+00_JPRB,1.4240E+00_JPRB,1.3603E+00_JPRB,1.3038E+00_JPRB/)  
KAO( :, 6, 4) = (/&
 & 1.3353E+00_JPRB,1.2714E+00_JPRB,1.2114E+00_JPRB,1.1566E+00_JPRB,1.1076E+00_JPRB/)  
KAO( :, 7, 4) = (/&
 & 1.1365E+00_JPRB,1.0823E+00_JPRB,1.0312E+00_JPRB,9.8386E-01_JPRB,9.4149E-01_JPRB/)  
KAO( :, 8, 4) = (/&
 & 9.6785E-01_JPRB,9.2216E-01_JPRB,8.7848E-01_JPRB,8.3819E-01_JPRB,8.0171E-01_JPRB/)  
KAO( :, 9, 4) = (/&
 & 8.2906E-01_JPRB,7.9098E-01_JPRB,7.5375E-01_JPRB,7.1927E-01_JPRB,6.8769E-01_JPRB/)  
KAO( :,10, 4) = (/&
 & 7.2091E-01_JPRB,6.8867E-01_JPRB,6.5764E-01_JPRB,6.2852E-01_JPRB,6.0157E-01_JPRB/)  
KAO( :,11, 4) = (/&
 & 6.1639E-01_JPRB,5.8956E-01_JPRB,5.6471E-01_JPRB,5.4117E-01_JPRB,5.1965E-01_JPRB/)  
KAO( :,12, 4) = (/&
 & 5.2694E-01_JPRB,5.0446E-01_JPRB,4.8409E-01_JPRB,4.6534E-01_JPRB,4.4808E-01_JPRB/)  
KAO( :,13, 4) = (/&
 & 4.4495E-01_JPRB,4.2623E-01_JPRB,4.0962E-01_JPRB,3.9458E-01_JPRB,3.8091E-01_JPRB/)  
KAO( :, 1, 5) = (/&
 & 5.1530E+00_JPRB,4.9766E+00_JPRB,4.8081E+00_JPRB,4.6516E+00_JPRB,4.5093E+00_JPRB/)  
KAO( :, 2, 5) = (/&
 & 4.3491E+00_JPRB,4.2045E+00_JPRB,4.0708E+00_JPRB,3.9418E+00_JPRB,3.8163E+00_JPRB/)  
KAO( :, 3, 5) = (/&
 & 3.6708E+00_JPRB,3.5507E+00_JPRB,3.4414E+00_JPRB,3.3312E+00_JPRB,3.2173E+00_JPRB/)  
KAO( :, 4, 5) = (/&
 & 3.1175E+00_JPRB,3.0159E+00_JPRB,2.9223E+00_JPRB,2.8267E+00_JPRB,2.7279E+00_JPRB/)  
KAO( :, 5, 5) = (/&
 & 2.6518E+00_JPRB,2.5625E+00_JPRB,2.4801E+00_JPRB,2.3975E+00_JPRB,2.3146E+00_JPRB/)  
KAO( :, 6, 5) = (/&
 & 2.2564E+00_JPRB,2.1773E+00_JPRB,2.1039E+00_JPRB,2.0333E+00_JPRB,1.9631E+00_JPRB/)  
KAO( :, 7, 5) = (/&
 & 1.9182E+00_JPRB,1.8476E+00_JPRB,1.7832E+00_JPRB,1.7230E+00_JPRB,1.6643E+00_JPRB/)  
KAO( :, 8, 5) = (/&
 & 1.6337E+00_JPRB,1.5705E+00_JPRB,1.5139E+00_JPRB,1.4617E+00_JPRB,1.4128E+00_JPRB/)  
KAO( :, 9, 5) = (/&
 & 1.4083E+00_JPRB,1.3508E+00_JPRB,1.3006E+00_JPRB,1.2545E+00_JPRB,1.2118E+00_JPRB/)  
KAO( :,10, 5) = (/&
 & 1.2328E+00_JPRB,1.1811E+00_JPRB,1.1365E+00_JPRB,1.0948E+00_JPRB,1.0570E+00_JPRB/)  
KAO( :,11, 5) = (/&
 & 1.0545E+00_JPRB,1.0121E+00_JPRB,9.7473E-01_JPRB,9.3945E-01_JPRB,9.0734E-01_JPRB/)  
KAO( :,12, 5) = (/&
 & 9.0496E-01_JPRB,8.7115E-01_JPRB,8.4024E-01_JPRB,8.1130E-01_JPRB,7.8449E-01_JPRB/)  
KAO( :,13, 5) = (/&
 & 7.7164E-01_JPRB,7.4436E-01_JPRB,7.1910E-01_JPRB,6.9522E-01_JPRB,6.7297E-01_JPRB/)  
KAO( :, 1, 6) = (/&
 & 9.6973E+00_JPRB,9.3787E+00_JPRB,9.0588E+00_JPRB,8.7497E+00_JPRB,8.4590E+00_JPRB/)  
KAO( :, 2, 6) = (/&
 & 8.3422E+00_JPRB,8.0414E+00_JPRB,7.7516E+00_JPRB,7.4834E+00_JPRB,7.2408E+00_JPRB/)  
KAO( :, 3, 6) = (/&
 & 7.1314E+00_JPRB,6.8664E+00_JPRB,6.6149E+00_JPRB,6.3897E+00_JPRB,6.1962E+00_JPRB/)  
KAO( :, 4, 6) = (/&
 & 6.1234E+00_JPRB,5.8927E+00_JPRB,5.6767E+00_JPRB,5.4877E+00_JPRB,5.3211E+00_JPRB/)  
KAO( :, 5, 6) = (/&
 & 5.2539E+00_JPRB,5.0548E+00_JPRB,4.8732E+00_JPRB,4.7110E+00_JPRB,4.5668E+00_JPRB/)  
KAO( :, 6, 6) = (/&
 & 4.5026E+00_JPRB,4.3343E+00_JPRB,4.1792E+00_JPRB,4.0419E+00_JPRB,3.9124E+00_JPRB/)  
KAO( :, 7, 6) = (/&
 & 3.8524E+00_JPRB,3.7093E+00_JPRB,3.5777E+00_JPRB,3.4570E+00_JPRB,3.3411E+00_JPRB/)  
KAO( :, 8, 6) = (/&
 & 3.2864E+00_JPRB,3.1665E+00_JPRB,3.0553E+00_JPRB,2.9496E+00_JPRB,2.8463E+00_JPRB/)  
KAO( :, 9, 6) = (/&
 & 2.8265E+00_JPRB,2.7253E+00_JPRB,2.6293E+00_JPRB,2.5362E+00_JPRB,2.4454E+00_JPRB/)  
KAO( :,10, 6) = (/&
 & 2.4703E+00_JPRB,2.3851E+00_JPRB,2.3012E+00_JPRB,2.2197E+00_JPRB,2.1390E+00_JPRB/)  
KAO( :,11, 6) = (/&
 & 2.1039E+00_JPRB,2.0324E+00_JPRB,1.9625E+00_JPRB,1.8926E+00_JPRB,1.8236E+00_JPRB/)  
KAO( :,12, 6) = (/&
 & 1.7889E+00_JPRB,1.7295E+00_JPRB,1.6689E+00_JPRB,1.6099E+00_JPRB,1.5530E+00_JPRB/)  
KAO( :,13, 6) = (/&
 & 1.5191E+00_JPRB,1.4695E+00_JPRB,1.4192E+00_JPRB,1.3697E+00_JPRB,1.3233E+00_JPRB/)  
KAO( :, 1, 7) = (/&
 & 1.9309E+01_JPRB,1.8684E+01_JPRB,1.8099E+01_JPRB,1.7538E+01_JPRB,1.7003E+01_JPRB/)  
KAO( :, 2, 7) = (/&
 & 1.7226E+01_JPRB,1.6672E+01_JPRB,1.6118E+01_JPRB,1.5594E+01_JPRB,1.5067E+01_JPRB/)  
KAO( :, 3, 7) = (/&
 & 1.5276E+01_JPRB,1.4769E+01_JPRB,1.4264E+01_JPRB,1.3763E+01_JPRB,1.3263E+01_JPRB/)  
KAO( :, 4, 7) = (/&
 & 1.3460E+01_JPRB,1.3002E+01_JPRB,1.2544E+01_JPRB,1.2084E+01_JPRB,1.1633E+01_JPRB/)  
KAO( :, 5, 7) = (/&
 & 1.1768E+01_JPRB,1.1365E+01_JPRB,1.0948E+01_JPRB,1.0535E+01_JPRB,1.0140E+01_JPRB/)  
KAO( :, 6, 7) = (/&
 & 1.0233E+01_JPRB,9.8691E+00_JPRB,9.5008E+00_JPRB,9.1399E+00_JPRB,8.8037E+00_JPRB/)  
KAO( :, 7, 7) = (/&
 & 8.8418E+00_JPRB,8.5251E+00_JPRB,8.2044E+00_JPRB,7.8974E+00_JPRB,7.6097E+00_JPRB/)  
KAO( :, 8, 7) = (/&
 & 7.5932E+00_JPRB,7.3228E+00_JPRB,7.0494E+00_JPRB,6.7890E+00_JPRB,6.5466E+00_JPRB/)  
KAO( :, 9, 7) = (/&
 & 6.5438E+00_JPRB,6.3102E+00_JPRB,6.0785E+00_JPRB,5.8572E+00_JPRB,5.6536E+00_JPRB/)  
KAO( :,10, 7) = (/&
 & 5.7701E+00_JPRB,5.5632E+00_JPRB,5.3602E+00_JPRB,5.1657E+00_JPRB,4.9886E+00_JPRB/)  
KAO( :,11, 7) = (/&
 & 4.9229E+00_JPRB,4.7468E+00_JPRB,4.5754E+00_JPRB,4.4156E+00_JPRB,4.2640E+00_JPRB/)  
KAO( :,12, 7) = (/&
 & 4.1712E+00_JPRB,4.0245E+00_JPRB,3.8835E+00_JPRB,3.7490E+00_JPRB,3.6186E+00_JPRB/)  
KAO( :,13, 7) = (/&
 & 3.5142E+00_JPRB,3.3938E+00_JPRB,3.2767E+00_JPRB,3.1632E+00_JPRB,3.0535E+00_JPRB/)  
KAO( :, 1, 8) = (/&
 & 4.3792E+01_JPRB,4.2562E+01_JPRB,4.1326E+01_JPRB,4.0173E+01_JPRB,3.9029E+01_JPRB/)  
KAO( :, 2, 8) = (/&
 & 4.1083E+01_JPRB,3.9961E+01_JPRB,3.8875E+01_JPRB,3.7761E+01_JPRB,3.6732E+01_JPRB/)  
KAO( :, 3, 8) = (/&
 & 3.8232E+01_JPRB,3.7158E+01_JPRB,3.6113E+01_JPRB,3.5094E+01_JPRB,3.4130E+01_JPRB/)  
KAO( :, 4, 8) = (/&
 & 3.5298E+01_JPRB,3.4286E+01_JPRB,3.3318E+01_JPRB,3.2377E+01_JPRB,3.1455E+01_JPRB/)  
KAO( :, 5, 8) = (/&
 & 3.2307E+01_JPRB,3.1366E+01_JPRB,3.0496E+01_JPRB,2.9612E+01_JPRB,2.8733E+01_JPRB/)  
KAO( :, 6, 8) = (/&
 & 2.9245E+01_JPRB,2.8430E+01_JPRB,2.7640E+01_JPRB,2.6836E+01_JPRB,2.6022E+01_JPRB/)  
KAO( :, 7, 8) = (/&
 & 2.6088E+01_JPRB,2.5397E+01_JPRB,2.4695E+01_JPRB,2.3991E+01_JPRB,2.3257E+01_JPRB/)  
KAO( :, 8, 8) = (/&
 & 2.2981E+01_JPRB,2.2412E+01_JPRB,2.1823E+01_JPRB,2.1203E+01_JPRB,2.0533E+01_JPRB/)  
KAO( :, 9, 8) = (/&
 & 2.0055E+01_JPRB,1.9585E+01_JPRB,1.9088E+01_JPRB,1.8539E+01_JPRB,1.7936E+01_JPRB/)  
KAO( :,10, 8) = (/&
 & 1.7813E+01_JPRB,1.7392E+01_JPRB,1.6941E+01_JPRB,1.6433E+01_JPRB,1.5881E+01_JPRB/)  
KAO( :,11, 8) = (/&
 & 1.5517E+01_JPRB,1.5141E+01_JPRB,1.4721E+01_JPRB,1.4250E+01_JPRB,1.3762E+01_JPRB/)  
KAO( :,12, 8) = (/&
 & 1.3307E+01_JPRB,1.2968E+01_JPRB,1.2587E+01_JPRB,1.2173E+01_JPRB,1.1765E+01_JPRB/)  
KAO( :,13, 8) = (/&
 & 1.1246E+01_JPRB,1.0950E+01_JPRB,1.0619E+01_JPRB,1.0276E+01_JPRB,9.9339E+00_JPRB/)  
KAO( :, 1, 9) = (/&
 & 1.1805E+02_JPRB,1.1497E+02_JPRB,1.1183E+02_JPRB,1.0901E+02_JPRB,1.0608E+02_JPRB/)  
KAO( :, 2, 9) = (/&
 & 1.2044E+02_JPRB,1.1710E+02_JPRB,1.1402E+02_JPRB,1.1089E+02_JPRB,1.0784E+02_JPRB/)  
KAO( :, 3, 9) = (/&
 & 1.2224E+02_JPRB,1.1882E+02_JPRB,1.1548E+02_JPRB,1.1225E+02_JPRB,1.0912E+02_JPRB/)  
KAO( :, 4, 9) = (/&
 & 1.2253E+02_JPRB,1.1914E+02_JPRB,1.1570E+02_JPRB,1.1248E+02_JPRB,1.0936E+02_JPRB/)  
KAO( :, 5, 9) = (/&
 & 1.2110E+02_JPRB,1.1772E+02_JPRB,1.1430E+02_JPRB,1.1120E+02_JPRB,1.0822E+02_JPRB/)  
KAO( :, 6, 9) = (/&
 & 1.1824E+02_JPRB,1.1487E+02_JPRB,1.1155E+02_JPRB,1.0851E+02_JPRB,1.0564E+02_JPRB/)  
KAO( :, 7, 9) = (/&
 & 1.1353E+02_JPRB,1.1029E+02_JPRB,1.0721E+02_JPRB,1.0431E+02_JPRB,1.0150E+02_JPRB/)  
KAO( :, 8, 9) = (/&
 & 1.0728E+02_JPRB,1.0430E+02_JPRB,1.0145E+02_JPRB,9.8717E+01_JPRB,9.6110E+01_JPRB/)  
KAO( :, 9, 9) = (/&
 & 9.9961E+01_JPRB,9.7260E+01_JPRB,9.4661E+01_JPRB,9.2129E+01_JPRB,8.9711E+01_JPRB/)  
KAO( :,10, 9) = (/&
 & 9.2244E+01_JPRB,8.9827E+01_JPRB,8.7426E+01_JPRB,8.5062E+01_JPRB,8.2760E+01_JPRB/)  
KAO( :,11, 9) = (/&
 & 8.3999E+01_JPRB,8.1726E+01_JPRB,7.9419E+01_JPRB,7.7163E+01_JPRB,7.4981E+01_JPRB/)  
KAO( :,12, 9) = (/&
 & 7.5642E+01_JPRB,7.3608E+01_JPRB,7.1481E+01_JPRB,6.9416E+01_JPRB,6.7422E+01_JPRB/)  
KAO( :,13, 9) = (/&
 & 6.6934E+01_JPRB,6.5046E+01_JPRB,6.3162E+01_JPRB,6.1319E+01_JPRB,5.9545E+01_JPRB/)  
KAO( :, 1,10) = (/&
 & 2.5219E+02_JPRB,2.4571E+02_JPRB,2.3918E+02_JPRB,2.3279E+02_JPRB,2.2858E+02_JPRB/)  
KAO( :, 2,10) = (/&
 & 2.6944E+02_JPRB,2.6208E+02_JPRB,2.5593E+02_JPRB,2.5059E+02_JPRB,2.4739E+02_JPRB/)  
KAO( :, 3,10) = (/&
 & 2.8444E+02_JPRB,2.7711E+02_JPRB,2.7148E+02_JPRB,2.6629E+02_JPRB,2.6255E+02_JPRB/)  
KAO( :, 4,10) = (/&
 & 3.0272E+02_JPRB,2.9452E+02_JPRB,2.8714E+02_JPRB,2.7941E+02_JPRB,2.7276E+02_JPRB/)  
KAO( :, 5,10) = (/&
 & 3.1679E+02_JPRB,3.0877E+02_JPRB,3.0015E+02_JPRB,2.9068E+02_JPRB,2.8102E+02_JPRB/)  
KAO( :, 6,10) = (/&
 & 3.2322E+02_JPRB,3.1468E+02_JPRB,3.0521E+02_JPRB,2.9571E+02_JPRB,2.8597E+02_JPRB/)  
KAO( :, 7,10) = (/&
 & 3.2856E+02_JPRB,3.1908E+02_JPRB,3.0869E+02_JPRB,2.9873E+02_JPRB,2.8901E+02_JPRB/)  
KAO( :, 8,10) = (/&
 & 3.2929E+02_JPRB,3.1918E+02_JPRB,3.0900E+02_JPRB,2.9900E+02_JPRB,2.8972E+02_JPRB/)  
KAO( :, 9,10) = (/&
 & 3.2403E+02_JPRB,3.1482E+02_JPRB,3.0502E+02_JPRB,2.9579E+02_JPRB,2.8721E+02_JPRB/)  
KAO( :,10,10) = (/&
 & 3.1039E+02_JPRB,3.0245E+02_JPRB,2.9340E+02_JPRB,2.8545E+02_JPRB,2.7823E+02_JPRB/)  
KAO( :,11,10) = (/&
 & 2.8971E+02_JPRB,2.8193E+02_JPRB,2.7523E+02_JPRB,2.6877E+02_JPRB,2.6210E+02_JPRB/)  
KAO( :,12,10) = (/&
 & 2.7119E+02_JPRB,2.6399E+02_JPRB,2.5760E+02_JPRB,2.5064E+02_JPRB,2.4326E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART2',0,ZHOOK_HANDLE)


KAO( :,13,10) = (/&
 & 2.5228E+02_JPRB,2.4612E+02_JPRB,2.3937E+02_JPRB,2.3200E+02_JPRB,2.2456E+02_JPRB/)  
KAO( :, 1,11) = (/&
 & 3.2436E+02_JPRB,3.1705E+02_JPRB,3.0936E+02_JPRB,3.0225E+02_JPRB,2.9528E+02_JPRB/)  
KAO( :, 2,11) = (/&
 & 3.6387E+02_JPRB,3.5499E+02_JPRB,3.4471E+02_JPRB,3.3477E+02_JPRB,3.2544E+02_JPRB/)  
KAO( :, 3,11) = (/&
 & 3.9089E+02_JPRB,3.8297E+02_JPRB,3.7268E+02_JPRB,3.6169E+02_JPRB,3.5104E+02_JPRB/)  
KAO( :, 4,11) = (/&
 & 4.0614E+02_JPRB,3.9591E+02_JPRB,3.8584E+02_JPRB,3.7702E+02_JPRB,3.6787E+02_JPRB/)  
KAO( :, 5,11) = (/&
 & 4.2111E+02_JPRB,4.0953E+02_JPRB,3.9791E+02_JPRB,3.8868E+02_JPRB,3.8088E+02_JPRB/)  
KAO( :, 6,11) = (/&
 & 4.4478E+02_JPRB,4.3170E+02_JPRB,4.1878E+02_JPRB,4.0704E+02_JPRB,3.9607E+02_JPRB/)  
KAO( :, 7,11) = (/&
 & 4.6528E+02_JPRB,4.5296E+02_JPRB,4.4095E+02_JPRB,4.2830E+02_JPRB,4.1414E+02_JPRB/)  
KAO( :, 8,11) = (/&
 & 4.8103E+02_JPRB,4.6875E+02_JPRB,4.5586E+02_JPRB,4.4138E+02_JPRB,4.2642E+02_JPRB/)  
KAO( :, 9,11) = (/&
 & 4.9211E+02_JPRB,4.7875E+02_JPRB,4.6419E+02_JPRB,4.4833E+02_JPRB,4.3292E+02_JPRB/)  
KAO( :,10,11) = (/&
 & 4.9428E+02_JPRB,4.7899E+02_JPRB,4.6351E+02_JPRB,4.4779E+02_JPRB,4.3245E+02_JPRB/)  
KAO( :,11,11) = (/&
 & 4.7778E+02_JPRB,4.6338E+02_JPRB,4.4778E+02_JPRB,4.3344E+02_JPRB,4.2003E+02_JPRB/)  
KAO( :,12,11) = (/&
 & 4.5095E+02_JPRB,4.3803E+02_JPRB,4.2442E+02_JPRB,4.1242E+02_JPRB,4.0150E+02_JPRB/)  
KAO( :,13,11) = (/&
 & 4.2162E+02_JPRB,4.0890E+02_JPRB,3.9818E+02_JPRB,3.8811E+02_JPRB,3.7807E+02_JPRB/)  
KAO( :, 1,12) = (/&
 & 4.0765E+02_JPRB,4.0438E+02_JPRB,4.0112E+02_JPRB,3.9703E+02_JPRB,3.9278E+02_JPRB/)  
KAO( :, 2,12) = (/&
 & 4.5408E+02_JPRB,4.4591E+02_JPRB,4.3895E+02_JPRB,4.3184E+02_JPRB,4.2260E+02_JPRB/)  
KAO( :, 3,12) = (/&
 & 5.0754E+02_JPRB,4.9609E+02_JPRB,4.8458E+02_JPRB,4.7355E+02_JPRB,4.6248E+02_JPRB/)  
KAO( :, 4,12) = (/&
 & 5.5729E+02_JPRB,5.4777E+02_JPRB,5.3611E+02_JPRB,5.2186E+02_JPRB,5.0830E+02_JPRB/)  
KAO( :, 5,12) = (/&
 & 5.9884E+02_JPRB,5.9059E+02_JPRB,5.8025E+02_JPRB,5.6682E+02_JPRB,5.5220E+02_JPRB/)  
KAO( :, 6,12) = (/&
 & 6.3069E+02_JPRB,6.2342E+02_JPRB,6.1247E+02_JPRB,5.9971E+02_JPRB,5.8566E+02_JPRB/)  
KAO( :, 7,12) = (/&
 & 6.6576E+02_JPRB,6.5415E+02_JPRB,6.3907E+02_JPRB,6.2535E+02_JPRB,6.1174E+02_JPRB/)  
KAO( :, 8,12) = (/&
 & 7.0612E+02_JPRB,6.9050E+02_JPRB,6.7253E+02_JPRB,6.5500E+02_JPRB,6.3767E+02_JPRB/)  
KAO( :, 9,12) = (/&
 & 7.4151E+02_JPRB,7.2711E+02_JPRB,7.0818E+02_JPRB,6.8887E+02_JPRB,6.6982E+02_JPRB/)  
KAO( :,10,12) = (/&
 & 7.6876E+02_JPRB,7.5445E+02_JPRB,7.3627E+02_JPRB,7.1768E+02_JPRB,6.9714E+02_JPRB/)  
KAO( :,11,12) = (/&
 & 7.8345E+02_JPRB,7.6652E+02_JPRB,7.4553E+02_JPRB,7.2384E+02_JPRB,7.0114E+02_JPRB/)  
KAO( :,12,12) = (/&
 & 7.8623E+02_JPRB,7.6501E+02_JPRB,7.4277E+02_JPRB,7.1917E+02_JPRB,6.9536E+02_JPRB/)  
KAO( :,13,12) = (/&
 & 7.6967E+02_JPRB,7.4813E+02_JPRB,7.2429E+02_JPRB,7.0066E+02_JPRB,6.7901E+02_JPRB/)  
KAO( :, 1,13) = (/&
 & 5.1329E+02_JPRB,5.0716E+02_JPRB,5.0382E+02_JPRB,4.9878E+02_JPRB,4.9356E+02_JPRB/)  
KAO( :, 2,13) = (/&
 & 5.7148E+02_JPRB,5.6846E+02_JPRB,5.6431E+02_JPRB,5.6063E+02_JPRB,5.5653E+02_JPRB/)  
KAO( :, 3,13) = (/&
 & 6.5145E+02_JPRB,6.4483E+02_JPRB,6.3790E+02_JPRB,6.3094E+02_JPRB,6.2717E+02_JPRB/)  
KAO( :, 4,13) = (/&
 & 7.5002E+02_JPRB,7.3461E+02_JPRB,7.2296E+02_JPRB,7.1138E+02_JPRB,7.0213E+02_JPRB/)  
KAO( :, 5,13) = (/&
 & 8.5963E+02_JPRB,8.3647E+02_JPRB,8.1752E+02_JPRB,7.9952E+02_JPRB,7.8427E+02_JPRB/)  
KAO( :, 6,13) = (/&
 & 9.6412E+02_JPRB,9.4095E+02_JPRB,9.1679E+02_JPRB,8.9731E+02_JPRB,8.7656E+02_JPRB/)  
KAO( :, 7,13) = (/&
 & 1.0550E+03_JPRB,1.0327E+03_JPRB,1.0118E+03_JPRB,9.9247E+02_JPRB,9.6895E+02_JPRB/)  
KAO( :, 8,13) = (/&
 & 1.1351E+03_JPRB,1.1102E+03_JPRB,1.0930E+03_JPRB,1.0757E+03_JPRB,1.0518E+03_JPRB/)  
KAO( :, 9,13) = (/&
 & 1.2061E+03_JPRB,1.1763E+03_JPRB,1.1581E+03_JPRB,1.1387E+03_JPRB,1.1187E+03_JPRB/)  
KAO( :,10,13) = (/&
 & 1.2746E+03_JPRB,1.2431E+03_JPRB,1.2211E+03_JPRB,1.1969E+03_JPRB,1.1743E+03_JPRB/)  
KAO( :,11,13) = (/&
 & 1.3270E+03_JPRB,1.3002E+03_JPRB,1.2748E+03_JPRB,1.2457E+03_JPRB,1.2158E+03_JPRB/)  
KAO( :,12,13) = (/&
 & 1.3778E+03_JPRB,1.3525E+03_JPRB,1.3230E+03_JPRB,1.2880E+03_JPRB,1.2527E+03_JPRB/)  
KAO( :,13,13) = (/&
 & 1.4203E+03_JPRB,1.3956E+03_JPRB,1.3627E+03_JPRB,1.3265E+03_JPRB,1.2880E+03_JPRB/)  
KAO( :, 1,14) = (/&
 & 7.0659E+02_JPRB,6.8649E+02_JPRB,6.7585E+02_JPRB,6.6280E+02_JPRB,6.4777E+02_JPRB/)  
KAO( :, 2,14) = (/&
 & 8.1314E+02_JPRB,7.9545E+02_JPRB,7.8563E+02_JPRB,7.7042E+02_JPRB,7.6159E+02_JPRB/)  
KAO( :, 3,14) = (/&
 & 9.2212E+02_JPRB,9.1802E+02_JPRB,9.0672E+02_JPRB,8.9703E+02_JPRB,8.8878E+02_JPRB/)  
KAO( :, 4,14) = (/&
 & 1.0533E+03_JPRB,1.0471E+03_JPRB,1.0407E+03_JPRB,1.0252E+03_JPRB,1.0216E+03_JPRB/)  
KAO( :, 5,14) = (/&
 & 1.1902E+03_JPRB,1.1874E+03_JPRB,1.1827E+03_JPRB,1.1705E+03_JPRB,1.1629E+03_JPRB/)  
KAO( :, 6,14) = (/&
 & 1.3538E+03_JPRB,1.3468E+03_JPRB,1.3305E+03_JPRB,1.3230E+03_JPRB,1.3152E+03_JPRB/)  
KAO( :, 7,14) = (/&
 & 1.5575E+03_JPRB,1.5374E+03_JPRB,1.5135E+03_JPRB,1.4950E+03_JPRB,1.4827E+03_JPRB/)  
KAO( :, 8,14) = (/&
 & 1.7978E+03_JPRB,1.7650E+03_JPRB,1.7335E+03_JPRB,1.7038E+03_JPRB,1.6772E+03_JPRB/)  
KAO( :, 9,14) = (/&
 & 2.0608E+03_JPRB,2.0242E+03_JPRB,1.9804E+03_JPRB,1.9383E+03_JPRB,1.9020E+03_JPRB/)  
KAO( :,10,14) = (/&
 & 2.3189E+03_JPRB,2.2831E+03_JPRB,2.2391E+03_JPRB,2.1847E+03_JPRB,2.1380E+03_JPRB/)  
KAO( :,11,14) = (/&
 & 2.5479E+03_JPRB,2.4992E+03_JPRB,2.4561E+03_JPRB,2.4037E+03_JPRB,2.3531E+03_JPRB/)  
KAO( :,12,14) = (/&
 & 2.7503E+03_JPRB,2.6955E+03_JPRB,2.6487E+03_JPRB,2.6000E+03_JPRB,2.5509E+03_JPRB/)  
KAO( :,13,14) = (/&
 & 2.9348E+03_JPRB,2.8771E+03_JPRB,2.8224E+03_JPRB,2.7731E+03_JPRB,2.7137E+03_JPRB/)  
KAO( :, 1,15) = (/&
 & 1.0087E+03_JPRB,9.8320E+02_JPRB,9.7093E+02_JPRB,9.5615E+02_JPRB,9.3254E+02_JPRB/)  
KAO( :, 2,15) = (/&
 & 1.2013E+03_JPRB,1.1684E+03_JPRB,1.1519E+03_JPRB,1.1213E+03_JPRB,1.1065E+03_JPRB/)  
KAO( :, 3,15) = (/&
 & 1.4276E+03_JPRB,1.4001E+03_JPRB,1.3700E+03_JPRB,1.3257E+03_JPRB,1.3068E+03_JPRB/)  
KAO( :, 4,15) = (/&
 & 1.6836E+03_JPRB,1.6523E+03_JPRB,1.6210E+03_JPRB,1.5698E+03_JPRB,1.5625E+03_JPRB/)  
KAO( :, 5,15) = (/&
 & 1.9769E+03_JPRB,1.9333E+03_JPRB,1.9035E+03_JPRB,1.8613E+03_JPRB,1.8254E+03_JPRB/)  
KAO( :, 6,15) = (/&
 & 2.3172E+03_JPRB,2.2683E+03_JPRB,2.2153E+03_JPRB,2.1871E+03_JPRB,2.1654E+03_JPRB/)  
KAO( :, 7,15) = (/&
 & 2.6839E+03_JPRB,2.6608E+03_JPRB,2.5827E+03_JPRB,2.5461E+03_JPRB,2.5090E+03_JPRB/)  
KAO( :, 8,15) = (/&
 & 3.0767E+03_JPRB,3.0634E+03_JPRB,3.0007E+03_JPRB,2.9429E+03_JPRB,2.9079E+03_JPRB/)  
KAO( :, 9,15) = (/&
 & 3.4941E+03_JPRB,3.4634E+03_JPRB,3.4221E+03_JPRB,3.3814E+03_JPRB,3.3456E+03_JPRB/)  
KAO( :,10,15) = (/&
 & 3.9537E+03_JPRB,3.9378E+03_JPRB,3.9008E+03_JPRB,3.8414E+03_JPRB,3.8169E+03_JPRB/)  
KAO( :,11,15) = (/&
 & 4.5046E+03_JPRB,4.4637E+03_JPRB,4.4210E+03_JPRB,4.3583E+03_JPRB,4.3332E+03_JPRB/)  
KAO( :,12,15) = (/&
 & 5.1528E+03_JPRB,5.0823E+03_JPRB,5.0105E+03_JPRB,4.9465E+03_JPRB,4.9071E+03_JPRB/)  
KAO( :,13,15) = (/&
 & 5.8749E+03_JPRB,5.7913E+03_JPRB,5.6995E+03_JPRB,5.6331E+03_JPRB,5.5557E+03_JPRB/)  
KAO( :, 1,16) = (/&
 & 1.2189E+03_JPRB,1.2224E+03_JPRB,1.2164E+03_JPRB,1.2064E+03_JPRB,1.1935E+03_JPRB/)  
KAO( :, 2,16) = (/&
 & 1.4789E+03_JPRB,1.4888E+03_JPRB,1.4867E+03_JPRB,1.4809E+03_JPRB,1.4687E+03_JPRB/)  
KAO( :, 3,16) = (/&
 & 1.8114E+03_JPRB,1.8246E+03_JPRB,1.8350E+03_JPRB,1.8138E+03_JPRB,1.8019E+03_JPRB/)  
KAO( :, 4,16) = (/&
 & 2.1704E+03_JPRB,2.2074E+03_JPRB,2.2239E+03_JPRB,2.2048E+03_JPRB,2.2173E+03_JPRB/)  
KAO( :, 5,16) = (/&
 & 2.5886E+03_JPRB,2.6353E+03_JPRB,2.6810E+03_JPRB,2.6789E+03_JPRB,2.6704E+03_JPRB/)  
KAO( :, 6,16) = (/&
 & 3.0777E+03_JPRB,3.1359E+03_JPRB,3.1850E+03_JPRB,3.2159E+03_JPRB,3.2625E+03_JPRB/)  
KAO( :, 7,16) = (/&
 & 3.6815E+03_JPRB,3.7549E+03_JPRB,3.7825E+03_JPRB,3.8441E+03_JPRB,3.9118E+03_JPRB/)  
KAO( :, 8,16) = (/&
 & 4.4826E+03_JPRB,4.4982E+03_JPRB,4.5205E+03_JPRB,4.5598E+03_JPRB,4.6673E+03_JPRB/)  
KAO( :, 9,16) = (/&
 & 5.4808E+03_JPRB,5.4311E+03_JPRB,5.4325E+03_JPRB,5.4480E+03_JPRB,5.4909E+03_JPRB/)  
KAO( :,10,16) = (/&
 & 6.6128E+03_JPRB,6.5719E+03_JPRB,6.5761E+03_JPRB,6.5449E+03_JPRB,6.5647E+03_JPRB/)  
KAO( :,11,16) = (/&
 & 7.9375E+03_JPRB,7.9476E+03_JPRB,7.9279E+03_JPRB,7.8912E+03_JPRB,7.8532E+03_JPRB/)  
KAO( :,12,16) = (/&
 & 9.5403E+03_JPRB,9.5531E+03_JPRB,9.5122E+03_JPRB,9.4385E+03_JPRB,9.3648E+03_JPRB/)  
KAO( :,13,16) = (/&
 & 1.1398E+04_JPRB,1.1400E+04_JPRB,1.1334E+04_JPRB,1.1241E+04_JPRB,1.1075E+04_JPRB/)  

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
 & 6.6025E-02_JPRB,6.0321E-02_JPRB,5.5586E-02_JPRB,5.1665E-02_JPRB,4.8458E-02_JPRB/)  
KBO( :,14, 1) = (/&
 & 6.0235E-02_JPRB,5.5378E-02_JPRB,5.1361E-02_JPRB,4.8017E-02_JPRB,4.5225E-02_JPRB/)  
KBO( :,15, 1) = (/&
 & 5.4400E-02_JPRB,5.0262E-02_JPRB,4.6762E-02_JPRB,4.3816E-02_JPRB,4.1346E-02_JPRB/)  
KBO( :,16, 1) = (/&
 & 4.7050E-02_JPRB,4.3532E-02_JPRB,4.0554E-02_JPRB,3.8051E-02_JPRB,3.5973E-02_JPRB/)  
KBO( :,17, 1) = (/&
 & 4.0158E-02_JPRB,3.7199E-02_JPRB,3.4718E-02_JPRB,3.2658E-02_JPRB,3.0958E-02_JPRB/)  
KBO( :,18, 1) = (/&
 & 3.3944E-02_JPRB,3.1506E-02_JPRB,2.9487E-02_JPRB,2.7811E-02_JPRB,2.6421E-02_JPRB/)  
KBO( :,19, 1) = (/&
 & 2.8784E-02_JPRB,2.6805E-02_JPRB,2.5163E-02_JPRB,2.3816E-02_JPRB,2.2648E-02_JPRB/)  
KBO( :,20, 1) = (/&
 & 2.4061E-02_JPRB,2.2468E-02_JPRB,2.1155E-02_JPRB,2.0067E-02_JPRB,1.9096E-02_JPRB/)  
KBO( :,21, 1) = (/&
 & 2.0001E-02_JPRB,1.8722E-02_JPRB,1.7675E-02_JPRB,1.6787E-02_JPRB,1.5981E-02_JPRB/)  
KBO( :,22, 1) = (/&
 & 1.6465E-02_JPRB,1.5454E-02_JPRB,1.4621E-02_JPRB,1.3904E-02_JPRB,1.3240E-02_JPRB/)  
KBO( :,23, 1) = (/&
 & 1.3531E-02_JPRB,1.2731E-02_JPRB,1.2060E-02_JPRB,1.1483E-02_JPRB,1.0937E-02_JPRB/)  
KBO( :,24, 1) = (/&
 & 1.1122E-02_JPRB,1.0488E-02_JPRB,9.9449E-03_JPRB,9.4777E-03_JPRB,9.0360E-03_JPRB/)  
KBO( :,25, 1) = (/&
 & 9.1073E-03_JPRB,8.6036E-03_JPRB,8.1702E-03_JPRB,7.7857E-03_JPRB,7.4321E-03_JPRB/)  
KBO( :,26, 1) = (/&
 & 7.4301E-03_JPRB,7.0285E-03_JPRB,6.6816E-03_JPRB,6.3677E-03_JPRB,6.0862E-03_JPRB/)  
KBO( :,27, 1) = (/&
 & 6.0232E-03_JPRB,5.7026E-03_JPRB,5.4272E-03_JPRB,5.1710E-03_JPRB,4.9473E-03_JPRB/)  
KBO( :,28, 1) = (/&
 & 4.8603E-03_JPRB,4.6055E-03_JPRB,4.3859E-03_JPRB,4.1792E-03_JPRB,4.0017E-03_JPRB/)  
KBO( :,29, 1) = (/&
 & 3.8797E-03_JPRB,3.6792E-03_JPRB,3.5020E-03_JPRB,3.3388E-03_JPRB,3.1981E-03_JPRB/)  
KBO( :,30, 1) = (/&
 & 3.0812E-03_JPRB,2.9236E-03_JPRB,2.7805E-03_JPRB,2.6518E-03_JPRB,2.5406E-03_JPRB/)  
KBO( :,31, 1) = (/&
 & 2.4193E-03_JPRB,2.2960E-03_JPRB,2.1816E-03_JPRB,2.0808E-03_JPRB,1.9933E-03_JPRB/)  
KBO( :,32, 1) = (/&
 & 1.8919E-03_JPRB,1.7956E-03_JPRB,1.7054E-03_JPRB,1.6268E-03_JPRB,1.5587E-03_JPRB/)  
KBO( :,33, 1) = (/&
 & 1.4723E-03_JPRB,1.3971E-03_JPRB,1.3273E-03_JPRB,1.2662E-03_JPRB,1.2122E-03_JPRB/)  
KBO( :,34, 1) = (/&
 & 1.1545E-03_JPRB,1.0954E-03_JPRB,1.0408E-03_JPRB,9.9313E-04_JPRB,9.5040E-04_JPRB/)  
KBO( :,35, 1) = (/&
 & 9.0984E-04_JPRB,8.6285E-04_JPRB,8.1968E-04_JPRB,7.8221E-04_JPRB,7.4823E-04_JPRB/)  
KBO( :,36, 1) = (/&
 & 7.2230E-04_JPRB,6.8430E-04_JPRB,6.4998E-04_JPRB,6.2002E-04_JPRB,5.9274E-04_JPRB/)  
KBO( :,37, 1) = (/&
 & 5.8190E-04_JPRB,5.5079E-04_JPRB,5.2276E-04_JPRB,4.9827E-04_JPRB,4.7605E-04_JPRB/)  
KBO( :,38, 1) = (/&
 & 4.6798E-04_JPRB,4.4253E-04_JPRB,4.1941E-04_JPRB,3.9951E-04_JPRB,3.8152E-04_JPRB/)  
KBO( :,39, 1) = (/&
 & 3.7512E-04_JPRB,3.5422E-04_JPRB,3.3519E-04_JPRB,3.1894E-04_JPRB,3.0452E-04_JPRB/)  
KBO( :,40, 1) = (/&
 & 3.0666E-04_JPRB,2.8941E-04_JPRB,2.7336E-04_JPRB,2.6010E-04_JPRB,2.4845E-04_JPRB/)  
KBO( :,41, 1) = (/&
 & 2.5152E-04_JPRB,2.3686E-04_JPRB,2.2364E-04_JPRB,2.1291E-04_JPRB,2.0310E-04_JPRB/)  
KBO( :,42, 1) = (/&
 & 2.0566E-04_JPRB,1.9385E-04_JPRB,1.8299E-04_JPRB,1.7309E-04_JPRB,1.6576E-04_JPRB/)  
KBO( :,43, 1) = (/&
 & 1.6932E-04_JPRB,1.5934E-04_JPRB,1.5033E-04_JPRB,1.4188E-04_JPRB,1.3564E-04_JPRB/)  
KBO( :,44, 1) = (/&
 & 1.3958E-04_JPRB,1.3104E-04_JPRB,1.2350E-04_JPRB,1.1633E-04_JPRB,1.1027E-04_JPRB/)  
KBO( :,45, 1) = (/&
 & 1.1479E-04_JPRB,1.0750E-04_JPRB,1.0104E-04_JPRB,9.5141E-05_JPRB,8.9953E-05_JPRB/)  
KBO( :,46, 1) = (/&
 & 9.4553E-05_JPRB,8.8276E-05_JPRB,8.2742E-05_JPRB,7.7888E-05_JPRB,7.3435E-05_JPRB/)  
KBO( :,47, 1) = (/&
 & 7.8399E-05_JPRB,7.2932E-05_JPRB,6.8177E-05_JPRB,6.4080E-05_JPRB,6.0318E-05_JPRB/)  
KBO( :,48, 1) = (/&
 & 6.4849E-05_JPRB,5.9884E-05_JPRB,5.6012E-05_JPRB,5.2488E-05_JPRB,4.9388E-05_JPRB/)  
KBO( :,49, 1) = (/&
 & 5.3502E-05_JPRB,4.9159E-05_JPRB,4.5822E-05_JPRB,4.2806E-05_JPRB,4.0245E-05_JPRB/)  
KBO( :,50, 1) = (/&
 & 4.4506E-05_JPRB,4.0716E-05_JPRB,3.7652E-05_JPRB,3.5217E-05_JPRB,3.3017E-05_JPRB/)  
KBO( :,51, 1) = (/&
 & 3.7201E-05_JPRB,3.3887E-05_JPRB,3.1219E-05_JPRB,2.9106E-05_JPRB,2.7216E-05_JPRB/)  
KBO( :,52, 1) = (/&
 & 3.0990E-05_JPRB,2.8176E-05_JPRB,2.5850E-05_JPRB,2.4002E-05_JPRB,2.2382E-05_JPRB/)  
KBO( :,53, 1) = (/&
 & 2.5835E-05_JPRB,2.3389E-05_JPRB,2.1361E-05_JPRB,1.9746E-05_JPRB,1.8343E-05_JPRB/)  
KBO( :,54, 1) = (/&
 & 2.1861E-05_JPRB,1.9731E-05_JPRB,1.7961E-05_JPRB,1.6554E-05_JPRB,1.5340E-05_JPRB/)  
KBO( :,55, 1) = (/&
 & 1.8660E-05_JPRB,1.6806E-05_JPRB,1.5260E-05_JPRB,1.3974E-05_JPRB,1.2979E-05_JPRB/)  
KBO( :,56, 1) = (/&
 & 1.5934E-05_JPRB,1.4319E-05_JPRB,1.2975E-05_JPRB,1.1855E-05_JPRB,1.0987E-05_JPRB/)  
KBO( :,57, 1) = (/&
 & 1.3617E-05_JPRB,1.2204E-05_JPRB,1.1040E-05_JPRB,1.0065E-05_JPRB,9.2784E-06_JPRB/)  
KBO( :,58, 1) = (/&
 & 1.1657E-05_JPRB,1.0421E-05_JPRB,9.4154E-06_JPRB,8.5710E-06_JPRB,7.8889E-06_JPRB/)  
KBO( :,59, 1) = (/&
 & 1.0037E-05_JPRB,8.9852E-06_JPRB,8.1354E-06_JPRB,7.4217E-06_JPRB,6.8483E-06_JPRB/)  
KBO( :,13, 2) = (/&
 & 1.7296E-01_JPRB,1.6235E-01_JPRB,1.5299E-01_JPRB,1.4476E-01_JPRB,1.3736E-01_JPRB/)  
KBO( :,14, 2) = (/&
 & 1.4802E-01_JPRB,1.3939E-01_JPRB,1.3201E-01_JPRB,1.2559E-01_JPRB,1.1999E-01_JPRB/)  
KBO( :,15, 2) = (/&
 & 1.2666E-01_JPRB,1.2001E-01_JPRB,1.1439E-01_JPRB,1.0960E-01_JPRB,1.0553E-01_JPRB/)  
KBO( :,16, 2) = (/&
 & 1.0662E-01_JPRB,1.0147E-01_JPRB,9.7166E-02_JPRB,9.3517E-02_JPRB,9.0354E-02_JPRB/)  
KBO( :,17, 2) = (/&
 & 8.9370E-02_JPRB,8.5365E-02_JPRB,8.2044E-02_JPRB,7.9207E-02_JPRB,7.6642E-02_JPRB/)  
KBO( :,18, 2) = (/&
 & 7.4539E-02_JPRB,7.1393E-02_JPRB,6.8781E-02_JPRB,6.6515E-02_JPRB,6.4461E-02_JPRB/)  
KBO( :,19, 2) = (/&
 & 6.2471E-02_JPRB,5.9987E-02_JPRB,5.7923E-02_JPRB,5.6100E-02_JPRB,5.4514E-02_JPRB/)  
KBO( :,20, 2) = (/&
 & 5.1909E-02_JPRB,4.9946E-02_JPRB,4.8296E-02_JPRB,4.6857E-02_JPRB,4.5636E-02_JPRB/)  
KBO( :,21, 2) = (/&
 & 4.2988E-02_JPRB,4.1439E-02_JPRB,4.0114E-02_JPRB,3.8994E-02_JPRB,3.8038E-02_JPRB/)  
KBO( :,22, 2) = (/&
 & 3.5398E-02_JPRB,3.4178E-02_JPRB,3.3135E-02_JPRB,3.2273E-02_JPRB,3.1510E-02_JPRB/)  
KBO( :,23, 2) = (/&
 & 2.9122E-02_JPRB,2.8160E-02_JPRB,2.7348E-02_JPRB,2.6671E-02_JPRB,2.6057E-02_JPRB/)  
KBO( :,24, 2) = (/&
 & 2.4007E-02_JPRB,2.3245E-02_JPRB,2.2611E-02_JPRB,2.2076E-02_JPRB,2.1589E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART3',0,ZHOOK_HANDLE)


KBO( :,25, 2) = (/&
 & 1.9740E-02_JPRB,1.9139E-02_JPRB,1.8649E-02_JPRB,1.8220E-02_JPRB,1.7833E-02_JPRB/)  
KBO( :,26, 2) = (/&
 & 1.6183E-02_JPRB,1.5716E-02_JPRB,1.5331E-02_JPRB,1.4993E-02_JPRB,1.4681E-02_JPRB/)  
KBO( :,27, 2) = (/&
 & 1.3189E-02_JPRB,1.2828E-02_JPRB,1.2525E-02_JPRB,1.2251E-02_JPRB,1.1998E-02_JPRB/)  
KBO( :,28, 2) = (/&
 & 1.0709E-02_JPRB,1.0427E-02_JPRB,1.0183E-02_JPRB,9.9604E-03_JPRB,9.7547E-03_JPRB/)  
KBO( :,29, 2) = (/&
 & 8.6054E-03_JPRB,8.3799E-03_JPRB,8.1829E-03_JPRB,8.0027E-03_JPRB,7.8337E-03_JPRB/)  
KBO( :,30, 2) = (/&
 & 6.8847E-03_JPRB,6.7028E-03_JPRB,6.5429E-03_JPRB,6.3953E-03_JPRB,6.2560E-03_JPRB/)  
KBO( :,31, 2) = (/&
 & 5.4573E-03_JPRB,5.3105E-03_JPRB,5.1791E-03_JPRB,5.0569E-03_JPRB,4.9413E-03_JPRB/)  
KBO( :,32, 2) = (/&
 & 4.3219E-03_JPRB,4.2029E-03_JPRB,4.0937E-03_JPRB,3.9929E-03_JPRB,3.8969E-03_JPRB/)  
KBO( :,33, 2) = (/&
 & 3.4170E-03_JPRB,3.3182E-03_JPRB,3.2286E-03_JPRB,3.1450E-03_JPRB,3.0655E-03_JPRB/)  
KBO( :,34, 2) = (/&
 & 2.7189E-03_JPRB,2.6370E-03_JPRB,2.5635E-03_JPRB,2.4948E-03_JPRB,2.4287E-03_JPRB/)  
KBO( :,35, 2) = (/&
 & 2.1701E-03_JPRB,2.1021E-03_JPRB,2.0414E-03_JPRB,1.9845E-03_JPRB,1.9298E-03_JPRB/)  
KBO( :,36, 2) = (/&
 & 1.7404E-03_JPRB,1.6842E-03_JPRB,1.6334E-03_JPRB,1.5862E-03_JPRB,1.5407E-03_JPRB/)  
KBO( :,37, 2) = (/&
 & 1.4096E-03_JPRB,1.3631E-03_JPRB,1.3204E-03_JPRB,1.2809E-03_JPRB,1.2432E-03_JPRB/)  
KBO( :,38, 2) = (/&
 & 1.1406E-03_JPRB,1.1018E-03_JPRB,1.0661E-03_JPRB,1.0329E-03_JPRB,1.0017E-03_JPRB/)  
KBO( :,39, 2) = (/&
 & 9.2061E-04_JPRB,8.8850E-04_JPRB,8.5860E-04_JPRB,8.3080E-04_JPRB,8.0479E-04_JPRB/)  
KBO( :,40, 2) = (/&
 & 7.5311E-04_JPRB,7.2636E-04_JPRB,7.0127E-04_JPRB,6.7848E-04_JPRB,6.5692E-04_JPRB/)  
KBO( :,41, 2) = (/&
 & 6.1744E-04_JPRB,5.9466E-04_JPRB,5.7382E-04_JPRB,5.5531E-04_JPRB,5.3731E-04_JPRB/)  
KBO( :,42, 2) = (/&
 & 5.0580E-04_JPRB,4.8681E-04_JPRB,4.6945E-04_JPRB,4.5312E-04_JPRB,4.3911E-04_JPRB/)  
KBO( :,43, 2) = (/&
 & 4.1621E-04_JPRB,3.9990E-04_JPRB,3.8526E-04_JPRB,3.7146E-04_JPRB,3.5984E-04_JPRB/)  
KBO( :,44, 2) = (/&
 & 3.4312E-04_JPRB,3.2894E-04_JPRB,3.1642E-04_JPRB,3.0474E-04_JPRB,2.9403E-04_JPRB/)  
KBO( :,45, 2) = (/&
 & 2.8281E-04_JPRB,2.7042E-04_JPRB,2.5951E-04_JPRB,2.4968E-04_JPRB,2.4057E-04_JPRB/)  
KBO( :,46, 2) = (/&
 & 2.3357E-04_JPRB,2.2272E-04_JPRB,2.1318E-04_JPRB,2.0478E-04_JPRB,1.9704E-04_JPRB/)  
KBO( :,47, 2) = (/&
 & 1.9389E-04_JPRB,1.8431E-04_JPRB,1.7596E-04_JPRB,1.6864E-04_JPRB,1.6210E-04_JPRB/)  
KBO( :,48, 2) = (/&
 & 1.6095E-04_JPRB,1.5228E-04_JPRB,1.4517E-04_JPRB,1.3875E-04_JPRB,1.3313E-04_JPRB/)  
KBO( :,49, 2) = (/&
 & 1.3353E-04_JPRB,1.2596E-04_JPRB,1.1967E-04_JPRB,1.1403E-04_JPRB,1.0914E-04_JPRB/)  
KBO( :,50, 2) = (/&
 & 1.1117E-04_JPRB,1.0462E-04_JPRB,9.8990E-05_JPRB,9.4240E-05_JPRB,8.9977E-05_JPRB/)  
KBO( :,51, 2) = (/&
 & 9.2729E-05_JPRB,8.7105E-05_JPRB,8.2233E-05_JPRB,7.8109E-05_JPRB,7.4418E-05_JPRB/)  
KBO( :,52, 2) = (/&
 & 7.7287E-05_JPRB,7.2506E-05_JPRB,6.8306E-05_JPRB,6.4721E-05_JPRB,6.1530E-05_JPRB/)  
KBO( :,53, 2) = (/&
 & 6.4464E-05_JPRB,6.0324E-05_JPRB,5.6713E-05_JPRB,5.3606E-05_JPRB,5.0841E-05_JPRB/)  
KBO( :,54, 2) = (/&
 & 5.4091E-05_JPRB,5.0519E-05_JPRB,4.7424E-05_JPRB,4.4759E-05_JPRB,4.2387E-05_JPRB/)  
KBO( :,55, 2) = (/&
 & 4.5573E-05_JPRB,4.2477E-05_JPRB,3.9832E-05_JPRB,3.7495E-05_JPRB,3.5529E-05_JPRB/)  
KBO( :,56, 2) = (/&
 & 3.8441E-05_JPRB,3.5737E-05_JPRB,3.3472E-05_JPRB,3.1478E-05_JPRB,2.9797E-05_JPRB/)  
KBO( :,57, 2) = (/&
 & 3.2461E-05_JPRB,3.0095E-05_JPRB,2.8145E-05_JPRB,2.6441E-05_JPRB,2.4970E-05_JPRB/)  
KBO( :,58, 2) = (/&
 & 2.7443E-05_JPRB,2.5378E-05_JPRB,2.3692E-05_JPRB,2.2241E-05_JPRB,2.0988E-05_JPRB/)  
KBO( :,59, 2) = (/&
 & 2.3149E-05_JPRB,2.1418E-05_JPRB,2.0012E-05_JPRB,1.8802E-05_JPRB,1.7768E-05_JPRB/)  
KBO( :,13, 3) = (/&
 & 2.8224E-01_JPRB,2.6908E-01_JPRB,2.5766E-01_JPRB,2.4741E-01_JPRB,2.3813E-01_JPRB/)  
KBO( :,14, 3) = (/&
 & 2.4257E-01_JPRB,2.3240E-01_JPRB,2.2331E-01_JPRB,2.1490E-01_JPRB,2.0721E-01_JPRB/)  
KBO( :,15, 3) = (/&
 & 2.0889E-01_JPRB,2.0084E-01_JPRB,1.9363E-01_JPRB,1.8713E-01_JPRB,1.8096E-01_JPRB/)  
KBO( :,16, 3) = (/&
 & 1.7673E-01_JPRB,1.7035E-01_JPRB,1.6477E-01_JPRB,1.5966E-01_JPRB,1.5481E-01_JPRB/)  
KBO( :,17, 3) = (/&
 & 1.4881E-01_JPRB,1.4382E-01_JPRB,1.3951E-01_JPRB,1.3543E-01_JPRB,1.3171E-01_JPRB/)  
KBO( :,18, 3) = (/&
 & 1.2458E-01_JPRB,1.2075E-01_JPRB,1.1737E-01_JPRB,1.1420E-01_JPRB,1.1137E-01_JPRB/)  
KBO( :,19, 3) = (/&
 & 1.0492E-01_JPRB,1.0202E-01_JPRB,9.9387E-02_JPRB,9.7022E-02_JPRB,9.4878E-02_JPRB/)  
KBO( :,20, 3) = (/&
 & 8.7628E-02_JPRB,8.5398E-02_JPRB,8.3368E-02_JPRB,8.1588E-02_JPRB,7.9957E-02_JPRB/)  
KBO( :,21, 3) = (/&
 & 7.2933E-02_JPRB,7.1178E-02_JPRB,6.9640E-02_JPRB,6.8291E-02_JPRB,6.7043E-02_JPRB/)  
KBO( :,22, 3) = (/&
 & 6.0366E-02_JPRB,5.8999E-02_JPRB,5.7832E-02_JPRB,5.6813E-02_JPRB,5.5848E-02_JPRB/)  
KBO( :,23, 3) = (/&
 & 4.9914E-02_JPRB,4.8873E-02_JPRB,4.8003E-02_JPRB,4.7216E-02_JPRB,4.6455E-02_JPRB/)  
KBO( :,24, 3) = (/&
 & 4.1391E-02_JPRB,4.0620E-02_JPRB,3.9959E-02_JPRB,3.9347E-02_JPRB,3.8754E-02_JPRB/)  
KBO( :,25, 3) = (/&
 & 3.4252E-02_JPRB,3.3678E-02_JPRB,3.3169E-02_JPRB,3.2674E-02_JPRB,3.2208E-02_JPRB/)  
KBO( :,26, 3) = (/&
 & 2.8274E-02_JPRB,2.7835E-02_JPRB,2.7424E-02_JPRB,2.7032E-02_JPRB,2.6670E-02_JPRB/)  
KBO( :,27, 3) = (/&
 & 2.3167E-02_JPRB,2.2814E-02_JPRB,2.2487E-02_JPRB,2.2168E-02_JPRB,2.1877E-02_JPRB/)  
KBO( :,28, 3) = (/&
 & 1.8878E-02_JPRB,1.8591E-02_JPRB,1.8322E-02_JPRB,1.8060E-02_JPRB,1.7820E-02_JPRB/)  
KBO( :,29, 3) = (/&
 & 1.5174E-02_JPRB,1.4934E-02_JPRB,1.4701E-02_JPRB,1.4483E-02_JPRB,1.4279E-02_JPRB/)  
KBO( :,30, 3) = (/&
 & 1.2128E-02_JPRB,1.1922E-02_JPRB,1.1721E-02_JPRB,1.1534E-02_JPRB,1.1359E-02_JPRB/)  
KBO( :,31, 3) = (/&
 & 9.5821E-03_JPRB,9.4015E-03_JPRB,9.2253E-03_JPRB,9.0655E-03_JPRB,8.9152E-03_JPRB/)  
KBO( :,32, 3) = (/&
 & 7.5634E-03_JPRB,7.4049E-03_JPRB,7.2553E-03_JPRB,7.1189E-03_JPRB,6.9900E-03_JPRB/)  
KBO( :,33, 3) = (/&
 & 5.9579E-03_JPRB,5.8225E-03_JPRB,5.6947E-03_JPRB,5.5780E-03_JPRB,5.4685E-03_JPRB/)  
KBO( :,34, 3) = (/&
 & 4.7299E-03_JPRB,4.6155E-03_JPRB,4.5082E-03_JPRB,4.4109E-03_JPRB,4.3191E-03_JPRB/)  
KBO( :,35, 3) = (/&
 & 3.7680E-03_JPRB,3.6721E-03_JPRB,3.5816E-03_JPRB,3.4997E-03_JPRB,3.4229E-03_JPRB/)  
KBO( :,36, 3) = (/&
 & 3.0177E-03_JPRB,2.9373E-03_JPRB,2.8611E-03_JPRB,2.7917E-03_JPRB,2.7276E-03_JPRB/)  
KBO( :,37, 3) = (/&
 & 2.4418E-03_JPRB,2.3740E-03_JPRB,2.3098E-03_JPRB,2.2509E-03_JPRB,2.1971E-03_JPRB/)  
KBO( :,38, 3) = (/&
 & 1.9747E-03_JPRB,1.9173E-03_JPRB,1.8635E-03_JPRB,1.8136E-03_JPRB,1.7682E-03_JPRB/)  
KBO( :,39, 3) = (/&
 & 1.5944E-03_JPRB,1.5460E-03_JPRB,1.5009E-03_JPRB,1.4588E-03_JPRB,1.4203E-03_JPRB/)  
KBO( :,40, 3) = (/&
 & 1.3041E-03_JPRB,1.2634E-03_JPRB,1.2255E-03_JPRB,1.1907E-03_JPRB,1.1583E-03_JPRB/)  
KBO( :,41, 3) = (/&
 & 1.0685E-03_JPRB,1.0341E-03_JPRB,1.0025E-03_JPRB,9.7393E-04_JPRB,9.4659E-04_JPRB/)  
KBO( :,42, 3) = (/&
 & 8.7449E-04_JPRB,8.4639E-04_JPRB,8.1987E-04_JPRB,7.9484E-04_JPRB,7.7315E-04_JPRB/)  
KBO( :,43, 3) = (/&
 & 7.1788E-04_JPRB,6.9483E-04_JPRB,6.7250E-04_JPRB,6.5138E-04_JPRB,6.3319E-04_JPRB/)  
KBO( :,44, 3) = (/&
 & 5.8977E-04_JPRB,5.7088E-04_JPRB,5.5200E-04_JPRB,5.3418E-04_JPRB,5.1765E-04_JPRB/)  
KBO( :,45, 3) = (/&
 & 4.8411E-04_JPRB,4.6836E-04_JPRB,4.5260E-04_JPRB,4.3755E-04_JPRB,4.2370E-04_JPRB/)  
KBO( :,46, 3) = (/&
 & 3.9795E-04_JPRB,3.8453E-04_JPRB,3.7150E-04_JPRB,3.5880E-04_JPRB,3.4714E-04_JPRB/)  
KBO( :,47, 3) = (/&
 & 3.2839E-04_JPRB,3.1685E-04_JPRB,3.0597E-04_JPRB,2.9536E-04_JPRB,2.8543E-04_JPRB/)  
KBO( :,48, 3) = (/&
 & 2.7072E-04_JPRB,2.6046E-04_JPRB,2.5163E-04_JPRB,2.4282E-04_JPRB,2.3441E-04_JPRB/)  
KBO( :,49, 3) = (/&
 & 2.2287E-04_JPRB,2.1412E-04_JPRB,2.0662E-04_JPRB,1.9921E-04_JPRB,1.9220E-04_JPRB/)  
KBO( :,50, 3) = (/&
 & 1.8426E-04_JPRB,1.7673E-04_JPRB,1.7009E-04_JPRB,1.6411E-04_JPRB,1.5828E-04_JPRB/)  
KBO( :,51, 3) = (/&
 & 1.5273E-04_JPRB,1.4618E-04_JPRB,1.4053E-04_JPRB,1.3551E-04_JPRB,1.3063E-04_JPRB/)  
KBO( :,52, 3) = (/&
 & 1.2644E-04_JPRB,1.2087E-04_JPRB,1.1601E-04_JPRB,1.1179E-04_JPRB,1.0769E-04_JPRB/)  
KBO( :,53, 3) = (/&
 & 1.0472E-04_JPRB,9.9917E-05_JPRB,9.5685E-05_JPRB,9.2134E-05_JPRB,8.8673E-05_JPRB/)  
KBO( :,54, 3) = (/&
 & 8.7277E-05_JPRB,8.3176E-05_JPRB,7.9528E-05_JPRB,7.6521E-05_JPRB,7.3630E-05_JPRB/)  
KBO( :,55, 3) = (/&
 & 7.3027E-05_JPRB,6.9537E-05_JPRB,6.6419E-05_JPRB,6.3736E-05_JPRB,6.1447E-05_JPRB/)  
KBO( :,56, 3) = (/&
 & 6.1140E-05_JPRB,5.8170E-05_JPRB,5.5506E-05_JPRB,5.3220E-05_JPRB,5.1302E-05_JPRB/)  
KBO( :,57, 3) = (/&
 & 5.1226E-05_JPRB,4.8684E-05_JPRB,4.6422E-05_JPRB,4.4463E-05_JPRB,4.2775E-05_JPRB/)  
KBO( :,58, 3) = (/&
 & 4.2970E-05_JPRB,4.0795E-05_JPRB,3.8883E-05_JPRB,3.7209E-05_JPRB,3.5788E-05_JPRB/)  
KBO( :,59, 3) = (/&
 & 3.6137E-05_JPRB,3.4363E-05_JPRB,3.2789E-05_JPRB,3.1431E-05_JPRB,3.0267E-05_JPRB/)  
KBO( :,13, 4) = (/&
 & 4.4498E-01_JPRB,4.2624E-01_JPRB,4.0964E-01_JPRB,3.9457E-01_JPRB,3.8094E-01_JPRB/)  
KBO( :,14, 4) = (/&
 & 3.8421E-01_JPRB,3.6885E-01_JPRB,3.5551E-01_JPRB,3.4386E-01_JPRB,3.3352E-01_JPRB/)  
KBO( :,15, 4) = (/&
 & 3.3432E-01_JPRB,3.2219E-01_JPRB,3.1159E-01_JPRB,3.0226E-01_JPRB,2.9429E-01_JPRB/)  
KBO( :,16, 4) = (/&
 & 2.8560E-01_JPRB,2.7613E-01_JPRB,2.6777E-01_JPRB,2.6061E-01_JPRB,2.5464E-01_JPRB/)  
KBO( :,17, 4) = (/&
 & 2.4342E-01_JPRB,2.3605E-01_JPRB,2.2955E-01_JPRB,2.2421E-01_JPRB,2.1979E-01_JPRB/)  
KBO( :,18, 4) = (/&
 & 2.0619E-01_JPRB,2.0048E-01_JPRB,1.9555E-01_JPRB,1.9161E-01_JPRB,1.8825E-01_JPRB/)  
KBO( :,19, 4) = (/&
 & 1.7598E-01_JPRB,1.7158E-01_JPRB,1.6796E-01_JPRB,1.6505E-01_JPRB,1.6259E-01_JPRB/)  
KBO( :,20, 4) = (/&
 & 1.4854E-01_JPRB,1.4525E-01_JPRB,1.4255E-01_JPRB,1.4041E-01_JPRB,1.3862E-01_JPRB/)  
KBO( :,21, 4) = (/&
 & 1.2481E-01_JPRB,1.2236E-01_JPRB,1.2038E-01_JPRB,1.1880E-01_JPRB,1.1756E-01_JPRB/)  
KBO( :,22, 4) = (/&
 & 1.0419E-01_JPRB,1.0238E-01_JPRB,1.0094E-01_JPRB,9.9828E-02_JPRB,9.8963E-02_JPRB/)  
KBO( :,23, 4) = (/&
 & 8.6892E-02_JPRB,8.5552E-02_JPRB,8.4508E-02_JPRB,8.3742E-02_JPRB,8.3137E-02_JPRB/)  
KBO( :,24, 4) = (/&
 & 7.2705E-02_JPRB,7.1741E-02_JPRB,7.1008E-02_JPRB,7.0499E-02_JPRB,7.0039E-02_JPRB/)  
KBO( :,25, 4) = (/&
 & 6.0676E-02_JPRB,5.9993E-02_JPRB,5.9492E-02_JPRB,5.9114E-02_JPRB,5.8730E-02_JPRB/)  
KBO( :,26, 4) = (/&
 & 5.0468E-02_JPRB,4.9976E-02_JPRB,4.9610E-02_JPRB,4.9307E-02_JPRB,4.8978E-02_JPRB/)  
KBO( :,27, 4) = (/&
 & 4.1559E-02_JPRB,4.1193E-02_JPRB,4.0911E-02_JPRB,4.0637E-02_JPRB,4.0354E-02_JPRB/)  
KBO( :,28, 4) = (/&
 & 3.3971E-02_JPRB,3.3679E-02_JPRB,3.3442E-02_JPRB,3.3204E-02_JPRB,3.2964E-02_JPRB/)  
KBO( :,29, 4) = (/&
 & 2.7264E-02_JPRB,2.7013E-02_JPRB,2.6808E-02_JPRB,2.6604E-02_JPRB,2.6386E-02_JPRB/)  
KBO( :,30, 4) = (/&
 & 2.1713E-02_JPRB,2.1498E-02_JPRB,2.1318E-02_JPRB,2.1130E-02_JPRB,2.0938E-02_JPRB/)  
KBO( :,31, 4) = (/&
 & 1.7042E-02_JPRB,1.6858E-02_JPRB,1.6691E-02_JPRB,1.6519E-02_JPRB,1.6352E-02_JPRB/)  
KBO( :,32, 4) = (/&
 & 1.3370E-02_JPRB,1.3212E-02_JPRB,1.3061E-02_JPRB,1.2908E-02_JPRB,1.2763E-02_JPRB/)  
KBO( :,33, 4) = (/&
 & 1.0471E-02_JPRB,1.0335E-02_JPRB,1.0205E-02_JPRB,1.0071E-02_JPRB,9.9443E-03_JPRB/)  
KBO( :,34, 4) = (/&
 & 8.2822E-03_JPRB,8.1673E-03_JPRB,8.0568E-03_JPRB,7.9430E-03_JPRB,7.8343E-03_JPRB/)  
KBO( :,35, 4) = (/&
 & 6.5706E-03_JPRB,6.4732E-03_JPRB,6.3800E-03_JPRB,6.2836E-03_JPRB,6.1906E-03_JPRB/)  
KBO( :,36, 4) = (/&
 & 5.2374E-03_JPRB,5.1544E-03_JPRB,5.0765E-03_JPRB,4.9959E-03_JPRB,4.9170E-03_JPRB/)  
KBO( :,37, 4) = (/&
 & 4.2152E-03_JPRB,4.1453E-03_JPRB,4.0802E-03_JPRB,4.0137E-03_JPRB,3.9470E-03_JPRB/)  
KBO( :,38, 4) = (/&
 & 3.3887E-03_JPRB,3.3299E-03_JPRB,3.2750E-03_JPRB,3.2202E-03_JPRB,3.1640E-03_JPRB/)  
KBO( :,39, 4) = (/&
 & 2.7192E-03_JPRB,2.6687E-03_JPRB,2.6217E-03_JPRB,2.5767E-03_JPRB,2.5302E-03_JPRB/)  
KBO( :,40, 4) = (/&
 & 2.2135E-03_JPRB,2.1698E-03_JPRB,2.1301E-03_JPRB,2.0941E-03_JPRB,2.0563E-03_JPRB/)  
KBO( :,41, 4) = (/&
 & 1.8054E-03_JPRB,1.7673E-03_JPRB,1.7338E-03_JPRB,1.7053E-03_JPRB,1.6746E-03_JPRB/)  
KBO( :,42, 4) = (/&
 & 1.4708E-03_JPRB,1.4392E-03_JPRB,1.4108E-03_JPRB,1.3843E-03_JPRB,1.3624E-03_JPRB/)  
KBO( :,43, 4) = (/&
 & 1.2027E-03_JPRB,1.1753E-03_JPRB,1.1507E-03_JPRB,1.1283E-03_JPRB,1.1105E-03_JPRB/)  
KBO( :,44, 4) = (/&
 & 9.8462E-04_JPRB,9.6042E-04_JPRB,9.3913E-04_JPRB,9.1991E-04_JPRB,9.0230E-04_JPRB/)  
KBO( :,45, 4) = (/&
 & 8.0542E-04_JPRB,7.8415E-04_JPRB,7.6564E-04_JPRB,7.4892E-04_JPRB,7.3408E-04_JPRB/)  
KBO( :,46, 4) = (/&
 & 6.5968E-04_JPRB,6.4114E-04_JPRB,6.2484E-04_JPRB,6.1027E-04_JPRB,5.9757E-04_JPRB/)  
KBO( :,47, 4) = (/&
 & 5.4254E-04_JPRB,5.2637E-04_JPRB,5.1198E-04_JPRB,4.9924E-04_JPRB,4.8823E-04_JPRB/)  
KBO( :,48, 4) = (/&
 & 4.4583E-04_JPRB,4.3098E-04_JPRB,4.1917E-04_JPRB,4.0789E-04_JPRB,3.9833E-04_JPRB/)  
KBO( :,49, 4) = (/&
 & 3.6597E-04_JPRB,3.5313E-04_JPRB,3.4272E-04_JPRB,3.3276E-04_JPRB,3.2437E-04_JPRB/)  
KBO( :,50, 4) = (/&
 & 3.0183E-04_JPRB,2.9081E-04_JPRB,2.8109E-04_JPRB,2.7313E-04_JPRB,2.6573E-04_JPRB/)  
KBO( :,51, 4) = (/&
 & 2.4952E-04_JPRB,2.4012E-04_JPRB,2.3178E-04_JPRB,2.2484E-04_JPRB,2.1839E-04_JPRB/)  
KBO( :,52, 4) = (/&
 & 2.0590E-04_JPRB,1.9816E-04_JPRB,1.9102E-04_JPRB,1.8499E-04_JPRB,1.7939E-04_JPRB/)  
KBO( :,53, 4) = (/&
 & 1.6997E-04_JPRB,1.6338E-04_JPRB,1.5728E-04_JPRB,1.5208E-04_JPRB,1.4721E-04_JPRB/)  
KBO( :,54, 4) = (/&
 & 1.4137E-04_JPRB,1.3582E-04_JPRB,1.3065E-04_JPRB,1.2623E-04_JPRB,1.2203E-04_JPRB/)  
KBO( :,55, 4) = (/&
 & 1.1811E-04_JPRB,1.1349E-04_JPRB,1.0913E-04_JPRB,1.0509E-04_JPRB,1.0178E-04_JPRB/)  
KBO( :,56, 4) = (/&
 & 9.8748E-05_JPRB,9.4876E-05_JPRB,9.1206E-05_JPRB,8.7799E-05_JPRB,8.4972E-05_JPRB/)  
KBO( :,57, 4) = (/&
 & 8.2626E-05_JPRB,7.9374E-05_JPRB,7.6285E-05_JPRB,7.3421E-05_JPRB,7.0844E-05_JPRB/)  
KBO( :,58, 4) = (/&
 & 6.9274E-05_JPRB,6.6523E-05_JPRB,6.3940E-05_JPRB,6.1535E-05_JPRB,5.9367E-05_JPRB/)  
KBO( :,59, 4) = (/&
 & 5.8640E-05_JPRB,5.6344E-05_JPRB,5.4214E-05_JPRB,5.2234E-05_JPRB,5.0475E-05_JPRB/)  
KBO( :,13, 5) = (/&
 & 7.7160E-01_JPRB,7.4444E-01_JPRB,7.1907E-01_JPRB,6.9531E-01_JPRB,6.7298E-01_JPRB/)  
KBO( :,14, 5) = (/&
 & 6.7466E-01_JPRB,6.5300E-01_JPRB,6.3239E-01_JPRB,6.1248E-01_JPRB,5.9379E-01_JPRB/)  
KBO( :,15, 5) = (/&
 & 5.9635E-01_JPRB,5.7861E-01_JPRB,5.6121E-01_JPRB,5.4480E-01_JPRB,5.2962E-01_JPRB/)  
KBO( :,16, 5) = (/&
 & 5.1541E-01_JPRB,5.0066E-01_JPRB,4.8672E-01_JPRB,4.7349E-01_JPRB,4.6138E-01_JPRB/)  
KBO( :,17, 5) = (/&
 & 4.4269E-01_JPRB,4.3080E-01_JPRB,4.1977E-01_JPRB,4.0931E-01_JPRB,3.9988E-01_JPRB/)  
KBO( :,18, 5) = (/&
 & 3.7780E-01_JPRB,3.6850E-01_JPRB,3.5976E-01_JPRB,3.5172E-01_JPRB,3.4458E-01_JPRB/)  
KBO( :,19, 5) = (/&
 & 3.2514E-01_JPRB,3.1806E-01_JPRB,3.1138E-01_JPRB,3.0554E-01_JPRB,3.0027E-01_JPRB/)  
KBO( :,20, 5) = (/&
 & 2.7650E-01_JPRB,2.7122E-01_JPRB,2.6628E-01_JPRB,2.6193E-01_JPRB,2.5804E-01_JPRB/)  
KBO( :,21, 5) = (/&
 & 2.3395E-01_JPRB,2.2994E-01_JPRB,2.2632E-01_JPRB,2.2310E-01_JPRB,2.2015E-01_JPRB/)  
KBO( :,22, 5) = (/&
 & 1.9653E-01_JPRB,1.9358E-01_JPRB,1.9093E-01_JPRB,1.8856E-01_JPRB,1.8639E-01_JPRB/)  
KBO( :,23, 5) = (/&
 & 1.6491E-01_JPRB,1.6277E-01_JPRB,1.6085E-01_JPRB,1.5911E-01_JPRB,1.5759E-01_JPRB/)  
KBO( :,24, 5) = (/&
 & 1.3897E-01_JPRB,1.3743E-01_JPRB,1.3602E-01_JPRB,1.3482E-01_JPRB,1.3382E-01_JPRB/)  
KBO( :,25, 5) = (/&
 & 1.1669E-01_JPRB,1.1561E-01_JPRB,1.1461E-01_JPRB,1.1379E-01_JPRB,1.1309E-01_JPRB/)  
KBO( :,26, 5) = (/&
 & 9.7609E-02_JPRB,9.6847E-02_JPRB,9.6135E-02_JPRB,9.5565E-02_JPRB,9.5002E-02_JPRB/)  
KBO( :,27, 5) = (/&
 & 8.0793E-02_JPRB,8.0221E-02_JPRB,7.9703E-02_JPRB,7.9212E-02_JPRB,7.8694E-02_JPRB/)  
KBO( :,28, 5) = (/&
 & 6.6330E-02_JPRB,6.5862E-02_JPRB,6.5425E-02_JPRB,6.4984E-02_JPRB,6.4496E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART4',0,ZHOOK_HANDLE)


KBO( :,29, 5) = (/&
 & 5.3342E-02_JPRB,5.2927E-02_JPRB,5.2528E-02_JPRB,5.2127E-02_JPRB,5.1683E-02_JPRB/)  
KBO( :,30, 5) = (/&
 & 4.2517E-02_JPRB,4.2134E-02_JPRB,4.1768E-02_JPRB,4.1401E-02_JPRB,4.1018E-02_JPRB/)  
KBO( :,31, 5) = (/&
 & 3.3321E-02_JPRB,3.2971E-02_JPRB,3.2637E-02_JPRB,3.2307E-02_JPRB,3.1983E-02_JPRB/)  
KBO( :,32, 5) = (/&
 & 2.6085E-02_JPRB,2.5777E-02_JPRB,2.5482E-02_JPRB,2.5197E-02_JPRB,2.4920E-02_JPRB/)  
KBO( :,33, 5) = (/&
 & 2.0380E-02_JPRB,2.0114E-02_JPRB,1.9855E-02_JPRB,1.9613E-02_JPRB,1.9379E-02_JPRB/)  
KBO( :,34, 5) = (/&
 & 1.6094E-02_JPRB,1.5866E-02_JPRB,1.5645E-02_JPRB,1.5443E-02_JPRB,1.5250E-02_JPRB/)  
KBO( :,35, 5) = (/&
 & 1.2747E-02_JPRB,1.2551E-02_JPRB,1.2366E-02_JPRB,1.2199E-02_JPRB,1.2040E-02_JPRB/)  
KBO( :,36, 5) = (/&
 & 1.0146E-02_JPRB,9.9805E-03_JPRB,9.8261E-03_JPRB,9.6852E-03_JPRB,9.5528E-03_JPRB/)  
KBO( :,37, 5) = (/&
 & 8.1592E-03_JPRB,8.0204E-03_JPRB,7.8907E-03_JPRB,7.7704E-03_JPRB,7.6600E-03_JPRB/)  
KBO( :,38, 5) = (/&
 & 6.5529E-03_JPRB,6.4351E-03_JPRB,6.3266E-03_JPRB,6.2249E-03_JPRB,6.1328E-03_JPRB/)  
KBO( :,39, 5) = (/&
 & 5.2501E-03_JPRB,5.1505E-03_JPRB,5.0574E-03_JPRB,4.9738E-03_JPRB,4.8970E-03_JPRB/)  
KBO( :,40, 5) = (/&
 & 4.2699E-03_JPRB,4.1868E-03_JPRB,4.1077E-03_JPRB,4.0405E-03_JPRB,3.9772E-03_JPRB/)  
KBO( :,41, 5) = (/&
 & 3.4793E-03_JPRB,3.4089E-03_JPRB,3.3430E-03_JPRB,3.2899E-03_JPRB,3.2370E-03_JPRB/)  
KBO( :,42, 5) = (/&
 & 2.8300E-03_JPRB,2.7744E-03_JPRB,2.7198E-03_JPRB,2.6679E-03_JPRB,2.6320E-03_JPRB/)  
KBO( :,43, 5) = (/&
 & 2.3102E-03_JPRB,2.2637E-03_JPRB,2.2184E-03_JPRB,2.1738E-03_JPRB,2.1446E-03_JPRB/)  
KBO( :,44, 5) = (/&
 & 1.8868E-03_JPRB,1.8478E-03_JPRB,1.8100E-03_JPRB,1.7720E-03_JPRB,1.7388E-03_JPRB/)  
KBO( :,45, 5) = (/&
 & 1.5390E-03_JPRB,1.5063E-03_JPRB,1.4743E-03_JPRB,1.4422E-03_JPRB,1.4137E-03_JPRB/)  
KBO( :,46, 5) = (/&
 & 1.2560E-03_JPRB,1.2289E-03_JPRB,1.2018E-03_JPRB,1.1747E-03_JPRB,1.1502E-03_JPRB/)  
KBO( :,47, 5) = (/&
 & 1.0286E-03_JPRB,1.0064E-03_JPRB,9.8327E-04_JPRB,9.6042E-04_JPRB,9.3954E-04_JPRB/)  
KBO( :,48, 5) = (/&
 & 8.4091E-04_JPRB,8.1988E-04_JPRB,8.0308E-04_JPRB,7.8384E-04_JPRB,7.6613E-04_JPRB/)  
KBO( :,49, 5) = (/&
 & 6.8566E-04_JPRB,6.6838E-04_JPRB,6.5450E-04_JPRB,6.3815E-04_JPRB,6.2312E-04_JPRB/)  
KBO( :,50, 5) = (/&
 & 5.6202E-04_JPRB,5.4792E-04_JPRB,5.3430E-04_JPRB,5.2267E-04_JPRB,5.0999E-04_JPRB/)  
KBO( :,51, 5) = (/&
 & 4.6200E-04_JPRB,4.5031E-04_JPRB,4.3906E-04_JPRB,4.2940E-04_JPRB,4.1869E-04_JPRB/)  
KBO( :,52, 5) = (/&
 & 3.7843E-04_JPRB,3.6947E-04_JPRB,3.6036E-04_JPRB,3.5233E-04_JPRB,3.4327E-04_JPRB/)  
KBO( :,53, 5) = (/&
 & 3.1055E-04_JPRB,3.0267E-04_JPRB,2.9523E-04_JPRB,2.8852E-04_JPRB,2.8094E-04_JPRB/)  
KBO( :,54, 5) = (/&
 & 2.5746E-04_JPRB,2.5066E-04_JPRB,2.4444E-04_JPRB,2.3894E-04_JPRB,2.3267E-04_JPRB/)  
KBO( :,55, 5) = (/&
 & 2.1472E-04_JPRB,2.0894E-04_JPRB,2.0371E-04_JPRB,1.9841E-04_JPRB,1.9408E-04_JPRB/)  
KBO( :,56, 5) = (/&
 & 1.7913E-04_JPRB,1.7430E-04_JPRB,1.6988E-04_JPRB,1.6554E-04_JPRB,1.6197E-04_JPRB/)  
KBO( :,57, 5) = (/&
 & 1.4951E-04_JPRB,1.4553E-04_JPRB,1.4177E-04_JPRB,1.3820E-04_JPRB,1.3474E-04_JPRB/)  
KBO( :,58, 5) = (/&
 & 1.2504E-04_JPRB,1.2181E-04_JPRB,1.1864E-04_JPRB,1.1569E-04_JPRB,1.1287E-04_JPRB/)  
KBO( :,59, 5) = (/&
 & 1.0614E-04_JPRB,1.0364E-04_JPRB,1.0111E-04_JPRB,9.8749E-05_JPRB,9.6452E-05_JPRB/)  
KBO( :,13, 6) = (/&
 & 1.5191E+00_JPRB,1.4695E+00_JPRB,1.4192E+00_JPRB,1.3697E+00_JPRB,1.3235E+00_JPRB/)  
KBO( :,14, 6) = (/&
 & 1.3318E+00_JPRB,1.2897E+00_JPRB,1.2478E+00_JPRB,1.2076E+00_JPRB,1.1701E+00_JPRB/)  
KBO( :,15, 6) = (/&
 & 1.1798E+00_JPRB,1.1443E+00_JPRB,1.1093E+00_JPRB,1.0759E+00_JPRB,1.0445E+00_JPRB/)  
KBO( :,16, 6) = (/&
 & 1.0281E+00_JPRB,9.9819E-01_JPRB,9.6877E-01_JPRB,9.4092E-01_JPRB,9.1439E-01_JPRB/)  
KBO( :,17, 6) = (/&
 & 8.8986E-01_JPRB,8.6523E-01_JPRB,8.4111E-01_JPRB,8.1786E-01_JPRB,7.9588E-01_JPRB/)  
KBO( :,18, 6) = (/&
 & 7.6316E-01_JPRB,7.4298E-01_JPRB,7.2337E-01_JPRB,7.0449E-01_JPRB,6.8700E-01_JPRB/)  
KBO( :,19, 6) = (/&
 & 6.5943E-01_JPRB,6.4308E-01_JPRB,6.2731E-01_JPRB,6.1232E-01_JPRB,5.9858E-01_JPRB/)  
KBO( :,20, 6) = (/&
 & 5.6316E-01_JPRB,5.4994E-01_JPRB,5.3764E-01_JPRB,5.2623E-01_JPRB,5.1573E-01_JPRB/)  
KBO( :,21, 6) = (/&
 & 4.7806E-01_JPRB,4.6791E-01_JPRB,4.5861E-01_JPRB,4.4996E-01_JPRB,4.4207E-01_JPRB/)  
KBO( :,22, 6) = (/&
 & 4.0277E-01_JPRB,3.9520E-01_JPRB,3.8813E-01_JPRB,3.8164E-01_JPRB,3.7585E-01_JPRB/)  
KBO( :,23, 6) = (/&
 & 3.3902E-01_JPRB,3.3325E-01_JPRB,3.2795E-01_JPRB,3.2312E-01_JPRB,3.1896E-01_JPRB/)  
KBO( :,24, 6) = (/&
 & 2.8650E-01_JPRB,2.8213E-01_JPRB,2.7823E-01_JPRB,2.7486E-01_JPRB,2.7205E-01_JPRB/)  
KBO( :,25, 6) = (/&
 & 2.4143E-01_JPRB,2.3816E-01_JPRB,2.3547E-01_JPRB,2.3317E-01_JPRB,2.3145E-01_JPRB/)  
KBO( :,26, 6) = (/&
 & 2.0266E-01_JPRB,2.0036E-01_JPRB,1.9851E-01_JPRB,1.9709E-01_JPRB,1.9604E-01_JPRB/)  
KBO( :,27, 6) = (/&
 & 1.6827E-01_JPRB,1.6669E-01_JPRB,1.6549E-01_JPRB,1.6454E-01_JPRB,1.6379E-01_JPRB/)  
KBO( :,28, 6) = (/&
 & 1.3863E-01_JPRB,1.3755E-01_JPRB,1.3670E-01_JPRB,1.3598E-01_JPRB,1.3532E-01_JPRB/)  
KBO( :,29, 6) = (/&
 & 1.1195E-01_JPRB,1.1112E-01_JPRB,1.1039E-01_JPRB,1.0972E-01_JPRB,1.0905E-01_JPRB/)  
KBO( :,30, 6) = (/&
 & 8.9622E-02_JPRB,8.8892E-02_JPRB,8.8204E-02_JPRB,8.7546E-02_JPRB,8.6864E-02_JPRB/)  
KBO( :,31, 6) = (/&
 & 7.0503E-02_JPRB,6.9820E-02_JPRB,6.9151E-02_JPRB,6.8505E-02_JPRB,6.7845E-02_JPRB/)  
KBO( :,32, 6) = (/&
 & 5.5386E-02_JPRB,5.4746E-02_JPRB,5.4116E-02_JPRB,5.3514E-02_JPRB,5.2914E-02_JPRB/)  
KBO( :,33, 6) = (/&
 & 4.3379E-02_JPRB,4.2797E-02_JPRB,4.2232E-02_JPRB,4.1691E-02_JPRB,4.1166E-02_JPRB/)  
KBO( :,34, 6) = (/&
 & 3.4320E-02_JPRB,3.3808E-02_JPRB,3.3321E-02_JPRB,3.2856E-02_JPRB,3.2407E-02_JPRB/)  
KBO( :,35, 6) = (/&
 & 2.7216E-02_JPRB,2.6777E-02_JPRB,2.6359E-02_JPRB,2.5963E-02_JPRB,2.5584E-02_JPRB/)  
KBO( :,36, 6) = (/&
 & 2.1684E-02_JPRB,2.1311E-02_JPRB,2.0954E-02_JPRB,2.0621E-02_JPRB,2.0303E-02_JPRB/)  
KBO( :,37, 6) = (/&
 & 1.7460E-02_JPRB,1.7144E-02_JPRB,1.6842E-02_JPRB,1.6560E-02_JPRB,1.6295E-02_JPRB/)  
KBO( :,38, 6) = (/&
 & 1.4038E-02_JPRB,1.3770E-02_JPRB,1.3517E-02_JPRB,1.3278E-02_JPRB,1.3058E-02_JPRB/)  
KBO( :,39, 6) = (/&
 & 1.1256E-02_JPRB,1.1031E-02_JPRB,1.0816E-02_JPRB,1.0618E-02_JPRB,1.0434E-02_JPRB/)  
KBO( :,40, 6) = (/&
 & 9.1649E-03_JPRB,8.9760E-03_JPRB,8.7972E-03_JPRB,8.6398E-03_JPRB,8.4878E-03_JPRB/)  
KBO( :,41, 6) = (/&
 & 7.4755E-03_JPRB,7.3166E-03_JPRB,7.1692E-03_JPRB,7.0488E-03_JPRB,6.9207E-03_JPRB/)  
KBO( :,42, 6) = (/&
 & 6.0804E-03_JPRB,5.9624E-03_JPRB,5.8409E-03_JPRB,5.7188E-03_JPRB,5.6367E-03_JPRB/)  
KBO( :,43, 6) = (/&
 & 4.9643E-03_JPRB,4.8712E-03_JPRB,4.7704E-03_JPRB,4.6675E-03_JPRB,4.6008E-03_JPRB/)  
KBO( :,44, 6) = (/&
 & 4.0546E-03_JPRB,3.9806E-03_JPRB,3.8967E-03_JPRB,3.8101E-03_JPRB,3.7308E-03_JPRB/)  
KBO( :,45, 6) = (/&
 & 3.3063E-03_JPRB,3.2467E-03_JPRB,3.1772E-03_JPRB,3.1048E-03_JPRB,3.0380E-03_JPRB/)  
KBO( :,46, 6) = (/&
 & 2.6976E-03_JPRB,2.6493E-03_JPRB,2.5918E-03_JPRB,2.5315E-03_JPRB,2.4753E-03_JPRB/)  
KBO( :,47, 6) = (/&
 & 2.2084E-03_JPRB,2.1692E-03_JPRB,2.1216E-03_JPRB,2.0717E-03_JPRB,2.0247E-03_JPRB/)  
KBO( :,48, 6) = (/&
 & 1.8045E-03_JPRB,1.7627E-03_JPRB,1.7331E-03_JPRB,1.6919E-03_JPRB,1.6528E-03_JPRB/)  
KBO( :,49, 6) = (/&
 & 1.4712E-03_JPRB,1.4359E-03_JPRB,1.4119E-03_JPRB,1.3778E-03_JPRB,1.3455E-03_JPRB/)  
KBO( :,50, 6) = (/&
 & 1.2061E-03_JPRB,1.1766E-03_JPRB,1.1505E-03_JPRB,1.1288E-03_JPRB,1.1022E-03_JPRB/)  
KBO( :,51, 6) = (/&
 & 9.9096E-04_JPRB,9.6691E-04_JPRB,9.4524E-04_JPRB,9.2753E-04_JPRB,9.0555E-04_JPRB/)  
KBO( :,52, 6) = (/&
 & 8.0904E-04_JPRB,7.9365E-04_JPRB,7.7550E-04_JPRB,7.6091E-04_JPRB,7.4280E-04_JPRB/)  
KBO( :,53, 6) = (/&
 & 6.6208E-04_JPRB,6.5010E-04_JPRB,6.3515E-04_JPRB,6.2298E-04_JPRB,6.0802E-04_JPRB/)  
KBO( :,54, 6) = (/&
 & 5.4731E-04_JPRB,5.3810E-04_JPRB,5.2612E-04_JPRB,5.1599E-04_JPRB,5.0369E-04_JPRB/)  
KBO( :,55, 6) = (/&
 & 4.5523E-04_JPRB,4.4817E-04_JPRB,4.3877E-04_JPRB,4.2800E-04_JPRB,4.2030E-04_JPRB/)  
KBO( :,56, 6) = (/&
 & 3.7865E-04_JPRB,3.7332E-04_JPRB,3.6607E-04_JPRB,3.5724E-04_JPRB,3.5095E-04_JPRB/)  
KBO( :,57, 6) = (/&
 & 3.1496E-04_JPRB,3.1113E-04_JPRB,3.0556E-04_JPRB,2.9842E-04_JPRB,2.9145E-04_JPRB/)  
KBO( :,58, 6) = (/&
 & 2.6256E-04_JPRB,2.5998E-04_JPRB,2.5570E-04_JPRB,2.5003E-04_JPRB,2.4428E-04_JPRB/)  
KBO( :,59, 6) = (/&
 & 2.2328E-04_JPRB,2.2151E-04_JPRB,2.1824E-04_JPRB,2.1368E-04_JPRB,2.0910E-04_JPRB/)  
KBO( :,13, 7) = (/&
 & 3.5144E+00_JPRB,3.3937E+00_JPRB,3.2768E+00_JPRB,3.1634E+00_JPRB,3.0537E+00_JPRB/)  
KBO( :,14, 7) = (/&
 & 3.0165E+00_JPRB,2.9173E+00_JPRB,2.8200E+00_JPRB,2.7244E+00_JPRB,2.6317E+00_JPRB/)  
KBO( :,15, 7) = (/&
 & 2.6711E+00_JPRB,2.5902E+00_JPRB,2.5088E+00_JPRB,2.4285E+00_JPRB,2.3516E+00_JPRB/)  
KBO( :,16, 7) = (/&
 & 2.3379E+00_JPRB,2.2701E+00_JPRB,2.2031E+00_JPRB,2.1365E+00_JPRB,2.0740E+00_JPRB/)  
KBO( :,17, 7) = (/&
 & 2.0449E+00_JPRB,1.9876E+00_JPRB,1.9309E+00_JPRB,1.8761E+00_JPRB,1.8247E+00_JPRB/)  
KBO( :,18, 7) = (/&
 & 1.7762E+00_JPRB,1.7285E+00_JPRB,1.6813E+00_JPRB,1.6362E+00_JPRB,1.5941E+00_JPRB/)  
KBO( :,19, 7) = (/&
 & 1.5531E+00_JPRB,1.5133E+00_JPRB,1.4745E+00_JPRB,1.4378E+00_JPRB,1.4037E+00_JPRB/)  
KBO( :,20, 7) = (/&
 & 1.3391E+00_JPRB,1.3069E+00_JPRB,1.2760E+00_JPRB,1.2466E+00_JPRB,1.2198E+00_JPRB/)  
KBO( :,21, 7) = (/&
 & 1.1467E+00_JPRB,1.1212E+00_JPRB,1.0970E+00_JPRB,1.0743E+00_JPRB,1.0539E+00_JPRB/)  
KBO( :,22, 7) = (/&
 & 9.7329E-01_JPRB,9.5340E-01_JPRB,9.3512E-01_JPRB,9.1844E-01_JPRB,9.0375E-01_JPRB/)  
KBO( :,23, 7) = (/&
 & 8.2392E-01_JPRB,8.0923E-01_JPRB,7.9603E-01_JPRB,7.8447E-01_JPRB,7.7374E-01_JPRB/)  
KBO( :,24, 7) = (/&
 & 7.0013E-01_JPRB,6.8981E-01_JPRB,6.8073E-01_JPRB,6.7262E-01_JPRB,6.6488E-01_JPRB/)  
KBO( :,25, 7) = (/&
 & 5.9333E-01_JPRB,5.8623E-01_JPRB,5.8008E-01_JPRB,5.7417E-01_JPRB,5.6882E-01_JPRB/)  
KBO( :,26, 7) = (/&
 & 5.0099E-01_JPRB,4.9624E-01_JPRB,4.9180E-01_JPRB,4.8790E-01_JPRB,4.8459E-01_JPRB/)  
KBO( :,27, 7) = (/&
 & 4.1867E-01_JPRB,4.1536E-01_JPRB,4.1237E-01_JPRB,4.0992E-01_JPRB,4.0810E-01_JPRB/)  
KBO( :,28, 7) = (/&
 & 3.4703E-01_JPRB,3.4468E-01_JPRB,3.4282E-01_JPRB,3.4143E-01_JPRB,3.4043E-01_JPRB/)  
KBO( :,29, 7) = (/&
 & 2.8153E-01_JPRB,2.7991E-01_JPRB,2.7869E-01_JPRB,2.7784E-01_JPRB,2.7705E-01_JPRB/)  
KBO( :,30, 7) = (/&
 & 2.2635E-01_JPRB,2.2520E-01_JPRB,2.2433E-01_JPRB,2.2358E-01_JPRB,2.2275E-01_JPRB/)  
KBO( :,31, 7) = (/&
 & 1.7873E-01_JPRB,1.7779E-01_JPRB,1.7701E-01_JPRB,1.7620E-01_JPRB,1.7525E-01_JPRB/)  
KBO( :,32, 7) = (/&
 & 1.4094E-01_JPRB,1.4013E-01_JPRB,1.3934E-01_JPRB,1.3848E-01_JPRB,1.3746E-01_JPRB/)  
KBO( :,33, 7) = (/&
 & 1.1081E-01_JPRB,1.1005E-01_JPRB,1.0925E-01_JPRB,1.0837E-01_JPRB,1.0737E-01_JPRB/)  
KBO( :,34, 7) = (/&
 & 8.8073E-02_JPRB,8.7360E-02_JPRB,8.6598E-02_JPRB,8.5752E-02_JPRB,8.4831E-02_JPRB/)  
KBO( :,35, 7) = (/&
 & 7.0093E-02_JPRB,6.9431E-02_JPRB,6.8725E-02_JPRB,6.7961E-02_JPRB,6.7163E-02_JPRB/)  
KBO( :,36, 7) = (/&
 & 5.5974E-02_JPRB,5.5383E-02_JPRB,5.4751E-02_JPRB,5.4084E-02_JPRB,5.3401E-02_JPRB/)  
KBO( :,37, 7) = (/&
 & 4.5129E-02_JPRB,4.4617E-02_JPRB,4.4069E-02_JPRB,4.3496E-02_JPRB,4.2919E-02_JPRB/)  
KBO( :,38, 7) = (/&
 & 3.6297E-02_JPRB,3.5849E-02_JPRB,3.5383E-02_JPRB,3.4895E-02_JPRB,3.4409E-02_JPRB/)  
KBO( :,39, 7) = (/&
 & 2.9094E-02_JPRB,2.8702E-02_JPRB,2.8301E-02_JPRB,2.7894E-02_JPRB,2.7483E-02_JPRB/)  
KBO( :,40, 7) = (/&
 & 2.3698E-02_JPRB,2.3361E-02_JPRB,2.3022E-02_JPRB,2.2702E-02_JPRB,2.2363E-02_JPRB/)  
KBO( :,41, 7) = (/&
 & 1.9342E-02_JPRB,1.9046E-02_JPRB,1.8762E-02_JPRB,1.8535E-02_JPRB,1.8252E-02_JPRB/)  
KBO( :,42, 7) = (/&
 & 1.5735E-02_JPRB,1.5529E-02_JPRB,1.5289E-02_JPRB,1.5039E-02_JPRB,1.4884E-02_JPRB/)  
KBO( :,43, 7) = (/&
 & 1.2856E-02_JPRB,1.2693E-02_JPRB,1.2490E-02_JPRB,1.2276E-02_JPRB,1.2162E-02_JPRB/)  
KBO( :,44, 7) = (/&
 & 1.0504E-02_JPRB,1.0374E-02_JPRB,1.0203E-02_JPRB,1.0021E-02_JPRB,9.8561E-03_JPRB/)  
KBO( :,45, 7) = (/&
 & 8.5662E-03_JPRB,8.4611E-03_JPRB,8.3174E-03_JPRB,8.1619E-03_JPRB,8.0238E-03_JPRB/)  
KBO( :,46, 7) = (/&
 & 6.9878E-03_JPRB,6.9029E-03_JPRB,6.7830E-03_JPRB,6.6504E-03_JPRB,6.5338E-03_JPRB/)  
KBO( :,47, 7) = (/&
 & 5.7199E-03_JPRB,5.6500E-03_JPRB,5.5517E-03_JPRB,5.4400E-03_JPRB,5.3409E-03_JPRB/)  
KBO( :,48, 7) = (/&
 & 4.6721E-03_JPRB,4.5783E-03_JPRB,4.5326E-03_JPRB,4.4394E-03_JPRB,4.3553E-03_JPRB/)  
KBO( :,49, 7) = (/&
 & 3.8045E-03_JPRB,3.7261E-03_JPRB,3.6884E-03_JPRB,3.6111E-03_JPRB,3.5400E-03_JPRB/)  
KBO( :,50, 7) = (/&
 & 3.1168E-03_JPRB,3.0525E-03_JPRB,2.9971E-03_JPRB,2.9577E-03_JPRB,2.8982E-03_JPRB/)  
KBO( :,51, 7) = (/&
 & 2.5606E-03_JPRB,2.5082E-03_JPRB,2.4624E-03_JPRB,2.4305E-03_JPRB,2.3812E-03_JPRB/)  
KBO( :,52, 7) = (/&
 & 2.0858E-03_JPRB,2.0571E-03_JPRB,2.0195E-03_JPRB,1.9935E-03_JPRB,1.9528E-03_JPRB/)  
KBO( :,53, 7) = (/&
 & 1.7067E-03_JPRB,1.6831E-03_JPRB,1.6522E-03_JPRB,1.6308E-03_JPRB,1.5976E-03_JPRB/)  
KBO( :,54, 7) = (/&
 & 1.4124E-03_JPRB,1.3940E-03_JPRB,1.3693E-03_JPRB,1.3524E-03_JPRB,1.3253E-03_JPRB/)  
KBO( :,55, 7) = (/&
 & 1.1765E-03_JPRB,1.1628E-03_JPRB,1.1437E-03_JPRB,1.1214E-03_JPRB,1.1087E-03_JPRB/)  
KBO( :,56, 7) = (/&
 & 9.8017E-04_JPRB,9.7016E-04_JPRB,9.5539E-04_JPRB,9.3773E-04_JPRB,9.2785E-04_JPRB/)  
KBO( :,57, 7) = (/&
 & 8.1688E-04_JPRB,8.0965E-04_JPRB,7.9840E-04_JPRB,7.8450E-04_JPRB,7.6983E-04_JPRB/)  
KBO( :,58, 7) = (/&
 & 6.8243E-04_JPRB,6.7751E-04_JPRB,6.6917E-04_JPRB,6.5832E-04_JPRB,6.4667E-04_JPRB/)  
KBO( :,59, 7) = (/&
 & 5.8205E-04_JPRB,5.7925E-04_JPRB,5.7356E-04_JPRB,5.6509E-04_JPRB,5.5607E-04_JPRB/)  
KBO( :,13, 8) = (/&
 & 1.1247E+01_JPRB,1.0949E+01_JPRB,1.0618E+01_JPRB,1.0275E+01_JPRB,9.9354E+00_JPRB/)  
KBO( :,14, 8) = (/&
 & 9.4998E+00_JPRB,9.2422E+00_JPRB,8.9633E+00_JPRB,8.6775E+00_JPRB,8.4009E+00_JPRB/)  
KBO( :,15, 8) = (/&
 & 8.1034E+00_JPRB,7.8837E+00_JPRB,7.6521E+00_JPRB,7.4181E+00_JPRB,7.1838E+00_JPRB/)  
KBO( :,16, 8) = (/&
 & 6.9956E+00_JPRB,6.8151E+00_JPRB,6.6234E+00_JPRB,6.4261E+00_JPRB,6.2274E+00_JPRB/)  
KBO( :,17, 8) = (/&
 & 6.1438E+00_JPRB,5.9920E+00_JPRB,5.8323E+00_JPRB,5.6650E+00_JPRB,5.4972E+00_JPRB/)  
KBO( :,18, 8) = (/&
 & 5.4091E+00_JPRB,5.2794E+00_JPRB,5.1420E+00_JPRB,4.9996E+00_JPRB,4.8583E+00_JPRB/)  
KBO( :,19, 8) = (/&
 & 4.8000E+00_JPRB,4.6894E+00_JPRB,4.5724E+00_JPRB,4.4526E+00_JPRB,4.3345E+00_JPRB/)  
KBO( :,20, 8) = (/&
 & 4.2099E+00_JPRB,4.1143E+00_JPRB,4.0152E+00_JPRB,3.9152E+00_JPRB,3.8177E+00_JPRB/)  
KBO( :,21, 8) = (/&
 & 3.6600E+00_JPRB,3.5795E+00_JPRB,3.4965E+00_JPRB,3.4138E+00_JPRB,3.3344E+00_JPRB/)  
KBO( :,22, 8) = (/&
 & 3.1475E+00_JPRB,3.0803E+00_JPRB,3.0119E+00_JPRB,2.9452E+00_JPRB,2.8804E+00_JPRB/)  
KBO( :,23, 8) = (/&
 & 2.6953E+00_JPRB,2.6395E+00_JPRB,2.5848E+00_JPRB,2.5305E+00_JPRB,2.4794E+00_JPRB/)  
KBO( :,24, 8) = (/&
 & 2.3108E+00_JPRB,2.2665E+00_JPRB,2.2227E+00_JPRB,2.1812E+00_JPRB,2.1425E+00_JPRB/)  
KBO( :,25, 8) = (/&
 & 1.9716E+00_JPRB,1.9373E+00_JPRB,1.9040E+00_JPRB,1.8732E+00_JPRB,1.8452E+00_JPRB/)  
KBO( :,26, 8) = (/&
 & 1.6730E+00_JPRB,1.6473E+00_JPRB,1.6232E+00_JPRB,1.6019E+00_JPRB,1.5822E+00_JPRB/)  
KBO( :,27, 8) = (/&
 & 1.4039E+00_JPRB,1.3856E+00_JPRB,1.3691E+00_JPRB,1.3536E+00_JPRB,1.3394E+00_JPRB/)  
KBO( :,28, 8) = (/&
 & 1.1694E+00_JPRB,1.1563E+00_JPRB,1.1443E+00_JPRB,1.1331E+00_JPRB,1.1233E+00_JPRB/)  
KBO( :,29, 8) = (/&
 & 9.5436E-01_JPRB,9.4464E-01_JPRB,9.3564E-01_JPRB,9.2762E-01_JPRB,9.2078E-01_JPRB/)  
KBO( :,30, 8) = (/&
 & 7.7171E-01_JPRB,7.6417E-01_JPRB,7.5736E-01_JPRB,7.5152E-01_JPRB,7.4699E-01_JPRB/)  
KBO( :,31, 8) = (/&
 & 6.1295E-01_JPRB,6.0696E-01_JPRB,6.0170E-01_JPRB,5.9736E-01_JPRB,5.9407E-01_JPRB/)  
KBO( :,32, 8) = (/&
 & 4.8600E-01_JPRB,4.8128E-01_JPRB,4.7723E-01_JPRB,4.7397E-01_JPRB,4.7138E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART5',0,ZHOOK_HANDLE)


KBO( :,33, 8) = (/&
 & 3.8415E-01_JPRB,3.8042E-01_JPRB,3.7730E-01_JPRB,3.7473E-01_JPRB,3.7262E-01_JPRB/)  
KBO( :,34, 8) = (/&
 & 3.0697E-01_JPRB,3.0410E-01_JPRB,3.0171E-01_JPRB,2.9969E-01_JPRB,2.9792E-01_JPRB/)  
KBO( :,35, 8) = (/&
 & 2.4580E-01_JPRB,2.4358E-01_JPRB,2.4169E-01_JPRB,2.4002E-01_JPRB,2.3839E-01_JPRB/)  
KBO( :,36, 8) = (/&
 & 1.9762E-01_JPRB,1.9584E-01_JPRB,1.9432E-01_JPRB,1.9290E-01_JPRB,1.9143E-01_JPRB/)  
KBO( :,37, 8) = (/&
 & 1.6039E-01_JPRB,1.5897E-01_JPRB,1.5773E-01_JPRB,1.5653E-01_JPRB,1.5525E-01_JPRB/)  
KBO( :,38, 8) = (/&
 & 1.2981E-01_JPRB,1.2864E-01_JPRB,1.2763E-01_JPRB,1.2661E-01_JPRB,1.2550E-01_JPRB/)  
KBO( :,39, 8) = (/&
 & 1.0464E-01_JPRB,1.0367E-01_JPRB,1.0279E-01_JPRB,1.0196E-01_JPRB,1.0102E-01_JPRB/)  
KBO( :,40, 8) = (/&
 & 8.5656E-02_JPRB,8.4878E-02_JPRB,8.4168E-02_JPRB,8.3551E-02_JPRB,8.2787E-02_JPRB/)  
KBO( :,41, 8) = (/&
 & 7.0184E-02_JPRB,6.9534E-02_JPRB,6.8986E-02_JPRB,6.8614E-02_JPRB,6.7985E-02_JPRB/)  
KBO( :,42, 8) = (/&
 & 5.7310E-02_JPRB,5.6919E-02_JPRB,5.6491E-02_JPRB,5.5977E-02_JPRB,5.5749E-02_JPRB/)  
KBO( :,43, 8) = (/&
 & 4.6943E-02_JPRB,4.6680E-02_JPRB,4.6336E-02_JPRB,4.5896E-02_JPRB,4.5779E-02_JPRB/)  
KBO( :,44, 8) = (/&
 & 3.8447E-02_JPRB,3.8265E-02_JPRB,3.7983E-02_JPRB,3.7610E-02_JPRB,3.7254E-02_JPRB/)  
KBO( :,45, 8) = (/&
 & 3.1416E-02_JPRB,3.1280E-02_JPRB,3.1046E-02_JPRB,3.0737E-02_JPRB,3.0447E-02_JPRB/)  
KBO( :,46, 8) = (/&
 & 2.5663E-02_JPRB,2.5562E-02_JPRB,2.5366E-02_JPRB,2.5110E-02_JPRB,2.4876E-02_JPRB/)  
KBO( :,47, 8) = (/&
 & 2.1026E-02_JPRB,2.0945E-02_JPRB,2.0784E-02_JPRB,2.0576E-02_JPRB,2.0390E-02_JPRB/)  
KBO( :,48, 8) = (/&
 & 1.7175E-02_JPRB,1.6957E-02_JPRB,1.6972E-02_JPRB,1.6802E-02_JPRB,1.6659E-02_JPRB/)  
KBO( :,49, 8) = (/&
 & 1.3974E-02_JPRB,1.3790E-02_JPRB,1.3801E-02_JPRB,1.3660E-02_JPRB,1.3550E-02_JPRB/)  
KBO( :,50, 8) = (/&
 & 1.1444E-02_JPRB,1.1294E-02_JPRB,1.1196E-02_JPRB,1.1188E-02_JPRB,1.1103E-02_JPRB/)  
KBO( :,51, 8) = (/&
 & 9.4010E-03_JPRB,9.2766E-03_JPRB,9.1976E-03_JPRB,9.1935E-03_JPRB,9.1284E-03_JPRB/)  
KBO( :,52, 8) = (/&
 & 7.6374E-03_JPRB,7.6018E-03_JPRB,7.5370E-03_JPRB,7.5350E-03_JPRB,7.4842E-03_JPRB/)  
KBO( :,53, 8) = (/&
 & 6.2404E-03_JPRB,6.2108E-03_JPRB,6.1568E-03_JPRB,6.1543E-03_JPRB,6.1140E-03_JPRB/)  
KBO( :,54, 8) = (/&
 & 5.1676E-03_JPRB,5.1471E-03_JPRB,5.1049E-03_JPRB,5.1078E-03_JPRB,5.0779E-03_JPRB/)  
KBO( :,55, 8) = (/&
 & 4.3128E-03_JPRB,4.3025E-03_JPRB,4.2708E-03_JPRB,4.2369E-03_JPRB,4.2598E-03_JPRB/)  
KBO( :,56, 8) = (/&
 & 3.5995E-03_JPRB,3.5977E-03_JPRB,3.5746E-03_JPRB,3.5491E-03_JPRB,3.5749E-03_JPRB/)  
KBO( :,57, 8) = (/&
 & 3.0055E-03_JPRB,3.0101E-03_JPRB,2.9938E-03_JPRB,2.9746E-03_JPRB,2.9652E-03_JPRB/)  
KBO( :,58, 8) = (/&
 & 2.5176E-03_JPRB,2.5272E-03_JPRB,2.5169E-03_JPRB,2.5032E-03_JPRB,2.4979E-03_JPRB/)  
KBO( :,59, 8) = (/&
 & 2.1638E-03_JPRB,2.1807E-03_JPRB,2.1789E-03_JPRB,2.1728E-03_JPRB,2.1711E-03_JPRB/)  
KBO( :,13, 9) = (/&
 & 6.6930E+01_JPRB,6.5036E+01_JPRB,6.3159E+01_JPRB,6.1318E+01_JPRB,5.9549E+01_JPRB/)  
KBO( :,14, 9) = (/&
 & 5.8293E+01_JPRB,5.6634E+01_JPRB,5.4990E+01_JPRB,5.3428E+01_JPRB,5.1912E+01_JPRB/)  
KBO( :,15, 9) = (/&
 & 5.0205E+01_JPRB,4.8785E+01_JPRB,4.7427E+01_JPRB,4.6113E+01_JPRB,4.4777E+01_JPRB/)  
KBO( :,16, 9) = (/&
 & 4.2911E+01_JPRB,4.1757E+01_JPRB,4.0616E+01_JPRB,3.9459E+01_JPRB,3.8271E+01_JPRB/)  
KBO( :,17, 9) = (/&
 & 3.6557E+01_JPRB,3.5595E+01_JPRB,3.4588E+01_JPRB,3.3574E+01_JPRB,3.2559E+01_JPRB/)  
KBO( :,18, 9) = (/&
 & 3.1149E+01_JPRB,3.0309E+01_JPRB,2.9446E+01_JPRB,2.8581E+01_JPRB,2.7714E+01_JPRB/)  
KBO( :,19, 9) = (/&
 & 2.6798E+01_JPRB,2.6081E+01_JPRB,2.5351E+01_JPRB,2.4620E+01_JPRB,2.3892E+01_JPRB/)  
KBO( :,20, 9) = (/&
 & 2.3235E+01_JPRB,2.2624E+01_JPRB,2.2007E+01_JPRB,2.1386E+01_JPRB,2.0773E+01_JPRB/)  
KBO( :,21, 9) = (/&
 & 2.0332E+01_JPRB,1.9813E+01_JPRB,1.9282E+01_JPRB,1.8758E+01_JPRB,1.8233E+01_JPRB/)  
KBO( :,22, 9) = (/&
 & 1.7867E+01_JPRB,1.7423E+01_JPRB,1.6975E+01_JPRB,1.6525E+01_JPRB,1.6078E+01_JPRB/)  
KBO( :,23, 9) = (/&
 & 1.5726E+01_JPRB,1.5346E+01_JPRB,1.4961E+01_JPRB,1.4574E+01_JPRB,1.4194E+01_JPRB/)  
KBO( :,24, 9) = (/&
 & 1.3878E+01_JPRB,1.3552E+01_JPRB,1.3218E+01_JPRB,1.2890E+01_JPRB,1.2567E+01_JPRB/)  
KBO( :,25, 9) = (/&
 & 1.2174E+01_JPRB,1.1894E+01_JPRB,1.1612E+01_JPRB,1.1333E+01_JPRB,1.1065E+01_JPRB/)  
KBO( :,26, 9) = (/&
 & 1.0586E+01_JPRB,1.0349E+01_JPRB,1.0113E+01_JPRB,9.8834E+00_JPRB,9.6689E+00_JPRB/)  
KBO( :,27, 9) = (/&
 & 9.0691E+00_JPRB,8.8721E+00_JPRB,8.6784E+00_JPRB,8.4956E+00_JPRB,8.3263E+00_JPRB/)  
KBO( :,28, 9) = (/&
 & 7.6767E+00_JPRB,7.5165E+00_JPRB,7.3638E+00_JPRB,7.2221E+00_JPRB,7.0906E+00_JPRB/)  
KBO( :,29, 9) = (/&
 & 6.3535E+00_JPRB,6.2280E+00_JPRB,6.1107E+00_JPRB,6.0030E+00_JPRB,5.9021E+00_JPRB/)  
KBO( :,30, 9) = (/&
 & 5.2055E+00_JPRB,5.1092E+00_JPRB,5.0195E+00_JPRB,4.9376E+00_JPRB,4.8626E+00_JPRB/)  
KBO( :,31, 9) = (/&
 & 4.1917E+00_JPRB,4.1182E+00_JPRB,4.0499E+00_JPRB,3.9891E+00_JPRB,3.9344E+00_JPRB/)  
KBO( :,32, 9) = (/&
 & 3.3675E+00_JPRB,3.3117E+00_JPRB,3.2607E+00_JPRB,3.2163E+00_JPRB,3.1756E+00_JPRB/)  
KBO( :,33, 9) = (/&
 & 2.6963E+00_JPRB,2.6546E+00_JPRB,2.6175E+00_JPRB,2.5837E+00_JPRB,2.5542E+00_JPRB/)  
KBO( :,34, 9) = (/&
 & 2.1803E+00_JPRB,2.1495E+00_JPRB,2.1217E+00_JPRB,2.0970E+00_JPRB,2.0762E+00_JPRB/)  
KBO( :,35, 9) = (/&
 & 1.7668E+00_JPRB,1.7436E+00_JPRB,1.7230E+00_JPRB,1.7051E+00_JPRB,1.6899E+00_JPRB/)  
KBO( :,36, 9) = (/&
 & 1.4368E+00_JPRB,1.4193E+00_JPRB,1.4041E+00_JPRB,1.3910E+00_JPRB,1.3800E+00_JPRB/)  
KBO( :,37, 9) = (/&
 & 1.1784E+00_JPRB,1.1654E+00_JPRB,1.1542E+00_JPRB,1.1446E+00_JPRB,1.1369E+00_JPRB/)  
KBO( :,38, 9) = (/&
 & 9.6334E-01_JPRB,9.5349E-01_JPRB,9.4564E-01_JPRB,9.3870E-01_JPRB,9.3338E-01_JPRB/)  
KBO( :,39, 9) = (/&
 & 7.8429E-01_JPRB,7.7685E-01_JPRB,7.7074E-01_JPRB,7.6618E-01_JPRB,7.6263E-01_JPRB/)  
KBO( :,40, 9) = (/&
 & 6.4772E-01_JPRB,6.4229E-01_JPRB,6.3796E-01_JPRB,6.3535E-01_JPRB,6.3341E-01_JPRB/)  
KBO( :,41, 9) = (/&
 & 5.3551E-01_JPRB,5.3135E-01_JPRB,5.2845E-01_JPRB,5.2779E-01_JPRB,5.2692E-01_JPRB/)  
KBO( :,42, 9) = (/&
 & 4.4125E-01_JPRB,4.3914E-01_JPRB,4.3725E-01_JPRB,4.3576E-01_JPRB,4.3762E-01_JPRB/)  
KBO( :,43, 9) = (/&
 & 3.6461E-01_JPRB,3.6349E-01_JPRB,3.6221E-01_JPRB,3.6126E-01_JPRB,3.6369E-01_JPRB/)  
KBO( :,44, 9) = (/&
 & 3.0116E-01_JPRB,3.0069E-01_JPRB,2.9982E-01_JPRB,2.9918E-01_JPRB,2.9973E-01_JPRB/)  
KBO( :,45, 9) = (/&
 & 2.4811E-01_JPRB,2.4796E-01_JPRB,2.4739E-01_JPRB,2.4699E-01_JPRB,2.4766E-01_JPRB/)  
KBO( :,46, 9) = (/&
 & 2.0425E-01_JPRB,2.0434E-01_JPRB,2.0395E-01_JPRB,2.0369E-01_JPRB,2.0438E-01_JPRB/)  
KBO( :,47, 9) = (/&
 & 1.6854E-01_JPRB,1.6878E-01_JPRB,1.6855E-01_JPRB,1.6839E-01_JPRB,1.6908E-01_JPRB/)  
KBO( :,48, 9) = (/&
 & 1.3856E-01_JPRB,1.3781E-01_JPRB,1.3873E-01_JPRB,1.3865E-01_JPRB,1.3926E-01_JPRB/)  
KBO( :,49, 9) = (/&
 & 1.1334E-01_JPRB,1.1274E-01_JPRB,1.1357E-01_JPRB,1.1351E-01_JPRB,1.1403E-01_JPRB/)  
KBO( :,50, 9) = (/&
 & 9.3340E-02_JPRB,9.2916E-02_JPRB,9.2960E-02_JPRB,9.3712E-02_JPRB,9.4205E-02_JPRB/)  
KBO( :,51, 9) = (/&
 & 7.7078E-02_JPRB,7.6810E-02_JPRB,7.6922E-02_JPRB,7.7641E-02_JPRB,7.8122E-02_JPRB/)  
KBO( :,52, 9) = (/&
 & 6.2961E-02_JPRB,6.3281E-02_JPRB,6.3427E-02_JPRB,6.4092E-02_JPRB,6.4534E-02_JPRB/)  
KBO( :,53, 9) = (/&
 & 5.1588E-02_JPRB,5.1905E-02_JPRB,5.2063E-02_JPRB,5.2646E-02_JPRB,5.3031E-02_JPRB/)  
KBO( :,54, 9) = (/&
 & 4.2943E-02_JPRB,4.3300E-02_JPRB,4.3511E-02_JPRB,4.4097E-02_JPRB,4.4499E-02_JPRB/)  
KBO( :,55, 9) = (/&
 & 3.6096E-02_JPRB,3.6506E-02_JPRB,3.6778E-02_JPRB,3.7049E-02_JPRB,3.7847E-02_JPRB/)  
KBO( :,56, 9) = (/&
 & 3.0345E-02_JPRB,3.0787E-02_JPRB,3.1097E-02_JPRB,3.1405E-02_JPRB,3.2218E-02_JPRB/)  
KBO( :,57, 9) = (/&
 & 2.5512E-02_JPRB,2.5968E-02_JPRB,2.6302E-02_JPRB,2.6632E-02_JPRB,2.7138E-02_JPRB/)  
KBO( :,58, 9) = (/&
 & 2.1539E-02_JPRB,2.1998E-02_JPRB,2.2352E-02_JPRB,2.2699E-02_JPRB,2.3217E-02_JPRB/)  
KBO( :,59, 9) = (/&
 & 1.8855E-02_JPRB,1.9380E-02_JPRB,1.9801E-02_JPRB,2.0231E-02_JPRB,2.0859E-02_JPRB/)  
KBO( :,13,10) = (/&
 & 2.5222E+02_JPRB,2.4612E+02_JPRB,2.3929E+02_JPRB,2.3199E+02_JPRB,2.2461E+02_JPRB/)  
KBO( :,14,10) = (/&
 & 2.3124E+02_JPRB,2.2528E+02_JPRB,2.1850E+02_JPRB,2.1149E+02_JPRB,2.0433E+02_JPRB/)  
KBO( :,15,10) = (/&
 & 2.0842E+02_JPRB,2.0210E+02_JPRB,1.9531E+02_JPRB,1.8854E+02_JPRB,1.8251E+02_JPRB/)  
KBO( :,16,10) = (/&
 & 1.8399E+02_JPRB,1.7799E+02_JPRB,1.7194E+02_JPRB,1.6680E+02_JPRB,1.6231E+02_JPRB/)  
KBO( :,17,10) = (/&
 & 1.6010E+02_JPRB,1.5487E+02_JPRB,1.5049E+02_JPRB,1.4638E+02_JPRB,1.4212E+02_JPRB/)  
KBO( :,18,10) = (/&
 & 1.3804E+02_JPRB,1.3430E+02_JPRB,1.3065E+02_JPRB,1.2671E+02_JPRB,1.2276E+02_JPRB/)  
KBO( :,19,10) = (/&
 & 1.1867E+02_JPRB,1.1546E+02_JPRB,1.1199E+02_JPRB,1.0849E+02_JPRB,1.0500E+02_JPRB/)  
KBO( :,20,10) = (/&
 & 1.0103E+02_JPRB,9.8101E+01_JPRB,9.5080E+01_JPRB,9.2102E+01_JPRB,8.9111E+01_JPRB/)  
KBO( :,21,10) = (/&
 & 8.5674E+01_JPRB,8.3188E+01_JPRB,8.0672E+01_JPRB,7.8136E+01_JPRB,7.5728E+01_JPRB/)  
KBO( :,22,10) = (/&
 & 7.2715E+01_JPRB,7.0591E+01_JPRB,6.8415E+01_JPRB,6.6340E+01_JPRB,6.4345E+01_JPRB/)  
KBO( :,23,10) = (/&
 & 6.3022E+01_JPRB,6.1199E+01_JPRB,5.9439E+01_JPRB,5.7725E+01_JPRB,5.6010E+01_JPRB/)  
KBO( :,24,10) = (/&
 & 5.5774E+01_JPRB,5.4272E+01_JPRB,5.2819E+01_JPRB,5.1321E+01_JPRB,4.9883E+01_JPRB/)  
KBO( :,25,10) = (/&
 & 4.9593E+01_JPRB,4.8355E+01_JPRB,4.7055E+01_JPRB,4.5778E+01_JPRB,4.4535E+01_JPRB/)  
KBO( :,26,10) = (/&
 & 4.4197E+01_JPRB,4.3085E+01_JPRB,4.1954E+01_JPRB,4.0860E+01_JPRB,3.9753E+01_JPRB/)  
KBO( :,27,10) = (/&
 & 3.8885E+01_JPRB,3.7934E+01_JPRB,3.6990E+01_JPRB,3.6031E+01_JPRB,3.5121E+01_JPRB/)  
KBO( :,28,10) = (/&
 & 3.3738E+01_JPRB,3.2939E+01_JPRB,3.2117E+01_JPRB,3.1331E+01_JPRB,3.0617E+01_JPRB/)  
KBO( :,29,10) = (/&
 & 2.8541E+01_JPRB,2.7853E+01_JPRB,2.7182E+01_JPRB,2.6569E+01_JPRB,2.6005E+01_JPRB/)  
KBO( :,30,10) = (/&
 & 2.3779E+01_JPRB,2.3214E+01_JPRB,2.2688E+01_JPRB,2.2215E+01_JPRB,2.1758E+01_JPRB/)  
KBO( :,31,10) = (/&
 & 1.9404E+01_JPRB,1.8965E+01_JPRB,1.8559E+01_JPRB,1.8185E+01_JPRB,1.7827E+01_JPRB/)  
KBO( :,32,10) = (/&
 & 1.5788E+01_JPRB,1.5447E+01_JPRB,1.5130E+01_JPRB,1.4835E+01_JPRB,1.4579E+01_JPRB/)  
KBO( :,33,10) = (/&
 & 1.2793E+01_JPRB,1.2531E+01_JPRB,1.2285E+01_JPRB,1.2073E+01_JPRB,1.1879E+01_JPRB/)  
KBO( :,34,10) = (/&
 & 1.0446E+01_JPRB,1.0243E+01_JPRB,1.0069E+01_JPRB,9.9145E+00_JPRB,9.7688E+00_JPRB/)  
KBO( :,35,10) = (/&
 & 8.5407E+00_JPRB,8.3976E+00_JPRB,8.2688E+00_JPRB,8.1501E+00_JPRB,8.0525E+00_JPRB/)  
KBO( :,36,10) = (/&
 & 7.0161E+00_JPRB,6.9119E+00_JPRB,6.8145E+00_JPRB,6.7306E+00_JPRB,6.6644E+00_JPRB/)  
KBO( :,37,10) = (/&
 & 5.8170E+00_JPRB,5.7380E+00_JPRB,5.6680E+00_JPRB,5.6107E+00_JPRB,5.5656E+00_JPRB/)  
KBO( :,38,10) = (/&
 & 4.8093E+00_JPRB,4.7487E+00_JPRB,4.7024E+00_JPRB,4.6645E+00_JPRB,4.6357E+00_JPRB/)  
KBO( :,39,10) = (/&
 & 3.9585E+00_JPRB,3.9132E+00_JPRB,3.8808E+00_JPRB,3.8606E+00_JPRB,3.8428E+00_JPRB/)  
KBO( :,40,10) = (/&
 & 3.2997E+00_JPRB,3.2689E+00_JPRB,3.2488E+00_JPRB,3.2415E+00_JPRB,3.2340E+00_JPRB/)  
KBO( :,41,10) = (/&
 & 2.7489E+00_JPRB,2.7291E+00_JPRB,2.7189E+00_JPRB,2.7232E+00_JPRB,2.7224E+00_JPRB/)  
KBO( :,42,10) = (/&
 & 2.2781E+00_JPRB,2.2743E+00_JPRB,2.2709E+00_JPRB,2.2713E+00_JPRB,2.2863E+00_JPRB/)  
KBO( :,43,10) = (/&
 & 1.8935E+00_JPRB,1.8963E+00_JPRB,1.8973E+00_JPRB,1.9006E+00_JPRB,1.9189E+00_JPRB/)  
KBO( :,44,10) = (/&
 & 1.5720E+00_JPRB,1.5786E+00_JPRB,1.5822E+00_JPRB,1.5873E+00_JPRB,1.5962E+00_JPRB/)  
KBO( :,45,10) = (/&
 & 1.3015E+00_JPRB,1.3098E+00_JPRB,1.3146E+00_JPRB,1.3205E+00_JPRB,1.3299E+00_JPRB/)  
KBO( :,46,10) = (/&
 & 1.0763E+00_JPRB,1.0855E+00_JPRB,1.0907E+00_JPRB,1.0967E+00_JPRB,1.1061E+00_JPRB/)  
KBO( :,47,10) = (/&
 & 8.9190E-01_JPRB,9.0098E-01_JPRB,9.0614E-01_JPRB,9.1228E-01_JPRB,9.2153E-01_JPRB/)  
KBO( :,48,10) = (/&
 & 7.3634E-01_JPRB,7.3759E-01_JPRB,7.4968E-01_JPRB,7.5555E-01_JPRB,7.6432E-01_JPRB/)  
KBO( :,49,10) = (/&
 & 6.0496E-01_JPRB,6.0623E-01_JPRB,6.1696E-01_JPRB,6.2219E-01_JPRB,6.3000E-01_JPRB/)  
KBO( :,50,10) = (/&
 & 5.0029E-01_JPRB,5.0191E-01_JPRB,5.0745E-01_JPRB,5.1663E-01_JPRB,5.2391E-01_JPRB/)  
KBO( :,51,10) = (/&
 & 4.1493E-01_JPRB,4.1674E-01_JPRB,4.2213E-01_JPRB,4.3055E-01_JPRB,4.3747E-01_JPRB/)  
KBO( :,52,10) = (/&
 & 3.3972E-01_JPRB,3.4486E-01_JPRB,3.4995E-01_JPRB,3.5750E-01_JPRB,3.6394E-01_JPRB/)  
KBO( :,53,10) = (/&
 & 2.7969E-01_JPRB,2.8412E-01_JPRB,2.8871E-01_JPRB,2.9534E-01_JPRB,3.0120E-01_JPRB/)  
KBO( :,54,10) = (/&
 & 2.3381E-01_JPRB,2.3806E-01_JPRB,2.4256E-01_JPRB,2.4899E-01_JPRB,2.5461E-01_JPRB/)  
KBO( :,55,10) = (/&
 & 1.9747E-01_JPRB,2.0173E-01_JPRB,2.0629E-01_JPRB,2.1052E-01_JPRB,2.1835E-01_JPRB/)  
KBO( :,56,10) = (/&
 & 1.6704E-01_JPRB,1.7122E-01_JPRB,1.7573E-01_JPRB,1.8004E-01_JPRB,1.8767E-01_JPRB/)  
KBO( :,57,10) = (/&
 & 1.4152E-01_JPRB,1.4559E-01_JPRB,1.5002E-01_JPRB,1.5430E-01_JPRB,1.5960E-01_JPRB/)  
KBO( :,58,10) = (/&
 & 1.2052E-01_JPRB,1.2461E-01_JPRB,1.2894E-01_JPRB,1.3321E-01_JPRB,1.3854E-01_JPRB/)  
KBO( :,59,10) = (/&
 & 1.0716E-01_JPRB,1.1189E-01_JPRB,1.1675E-01_JPRB,1.2166E-01_JPRB,1.2804E-01_JPRB/)  
KBO( :,13,11) = (/&
 & 4.2154E+02_JPRB,4.0884E+02_JPRB,3.9820E+02_JPRB,3.8820E+02_JPRB,3.7793E+02_JPRB/)  
KBO( :,14,11) = (/&
 & 3.9257E+02_JPRB,3.8172E+02_JPRB,3.7181E+02_JPRB,3.6139E+02_JPRB,3.5047E+02_JPRB/)  
KBO( :,15,11) = (/&
 & 3.6309E+02_JPRB,3.5353E+02_JPRB,3.4340E+02_JPRB,3.3282E+02_JPRB,3.2240E+02_JPRB/)  
KBO( :,16,11) = (/&
 & 3.3141E+02_JPRB,3.2240E+02_JPRB,3.1248E+02_JPRB,3.0233E+02_JPRB,2.9245E+02_JPRB/)  
KBO( :,17,11) = (/&
 & 2.9757E+02_JPRB,2.8848E+02_JPRB,2.7872E+02_JPRB,2.6968E+02_JPRB,2.6158E+02_JPRB/)  
KBO( :,18,11) = (/&
 & 2.6199E+02_JPRB,2.5343E+02_JPRB,2.4537E+02_JPRB,2.3848E+02_JPRB,2.3223E+02_JPRB/)  
KBO( :,19,11) = (/&
 & 2.2769E+02_JPRB,2.2078E+02_JPRB,2.1490E+02_JPRB,2.0918E+02_JPRB,2.0314E+02_JPRB/)  
KBO( :,20,11) = (/&
 & 1.9687E+02_JPRB,1.9172E+02_JPRB,1.8662E+02_JPRB,1.8113E+02_JPRB,1.7551E+02_JPRB/)  
KBO( :,21,11) = (/&
 & 1.6926E+02_JPRB,1.6478E+02_JPRB,1.5994E+02_JPRB,1.5502E+02_JPRB,1.5010E+02_JPRB/)  
KBO( :,22,11) = (/&
 & 1.4392E+02_JPRB,1.3980E+02_JPRB,1.3565E+02_JPRB,1.3147E+02_JPRB,1.2734E+02_JPRB/)  
KBO( :,23,11) = (/&
 & 1.2176E+02_JPRB,1.1828E+02_JPRB,1.1480E+02_JPRB,1.1132E+02_JPRB,1.0802E+02_JPRB/)  
KBO( :,24,11) = (/&
 & 1.0420E+02_JPRB,1.0127E+02_JPRB,9.8266E+01_JPRB,9.5452E+01_JPRB,9.2657E+01_JPRB/)  
KBO( :,25,11) = (/&
 & 9.1405E+01_JPRB,8.8856E+01_JPRB,8.6441E+01_JPRB,8.4023E+01_JPRB,8.1601E+01_JPRB/)  
KBO( :,26,11) = (/&
 & 8.1068E+01_JPRB,7.8976E+01_JPRB,7.6905E+01_JPRB,7.4806E+01_JPRB,7.2749E+01_JPRB/)  
KBO( :,27,11) = (/&
 & 7.1641E+01_JPRB,6.9868E+01_JPRB,6.8049E+01_JPRB,6.6237E+01_JPRB,6.4456E+01_JPRB/)  
KBO( :,28,11) = (/&
 & 6.3023E+01_JPRB,6.1456E+01_JPRB,5.9871E+01_JPRB,5.8321E+01_JPRB,5.6798E+01_JPRB/)  
KBO( :,29,11) = (/&
 & 5.4205E+01_JPRB,5.2861E+01_JPRB,5.1529E+01_JPRB,5.0220E+01_JPRB,4.8999E+01_JPRB/)  
KBO( :,30,11) = (/&
 & 4.5934E+01_JPRB,4.4818E+01_JPRB,4.3703E+01_JPRB,4.2668E+01_JPRB,4.1730E+01_JPRB/)  
KBO( :,31,11) = (/&
 & 3.8066E+01_JPRB,3.7138E+01_JPRB,3.6268E+01_JPRB,3.5481E+01_JPRB,3.4768E+01_JPRB/)  
KBO( :,32,11) = (/&
 & 3.1328E+01_JPRB,3.0606E+01_JPRB,2.9939E+01_JPRB,2.9343E+01_JPRB,2.8780E+01_JPRB/)  
KBO( :,33,11) = (/&
 & 2.5648E+01_JPRB,2.5098E+01_JPRB,2.4592E+01_JPRB,2.4122E+01_JPRB,2.3697E+01_JPRB/)  
KBO( :,34,11) = (/&
 & 2.1176E+01_JPRB,2.0755E+01_JPRB,2.0363E+01_JPRB,2.0008E+01_JPRB,1.9706E+01_JPRB/)  
KBO( :,35,11) = (/&
 & 1.7503E+01_JPRB,1.7179E+01_JPRB,1.6884E+01_JPRB,1.6631E+01_JPRB,1.6410E+01_JPRB/)  
KBO( :,36,11) = (/&
 & 1.4490E+01_JPRB,1.4242E+01_JPRB,1.4035E+01_JPRB,1.3856E+01_JPRB,1.3691E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART6',0,ZHOOK_HANDLE)


KBO( :,37,11) = (/&
 & 1.2080E+01_JPRB,1.1899E+01_JPRB,1.1752E+01_JPRB,1.1622E+01_JPRB,1.1507E+01_JPRB/)  
KBO( :,38,11) = (/&
 & 1.0040E+01_JPRB,9.9127E+00_JPRB,9.8092E+00_JPRB,9.7168E+00_JPRB,9.6388E+00_JPRB/)  
KBO( :,39,11) = (/&
 & 8.3186E+00_JPRB,8.2268E+00_JPRB,8.1489E+00_JPRB,8.0924E+00_JPRB,8.0458E+00_JPRB/)  
KBO( :,40,11) = (/&
 & 6.9855E+00_JPRB,6.9204E+00_JPRB,6.8705E+00_JPRB,6.8363E+00_JPRB,6.8129E+00_JPRB/)  
KBO( :,41,11) = (/&
 & 5.8673E+00_JPRB,5.8227E+00_JPRB,5.7933E+00_JPRB,5.7844E+00_JPRB,5.7806E+00_JPRB/)  
KBO( :,42,11) = (/&
 & 4.9033E+00_JPRB,4.8902E+00_JPRB,4.8772E+00_JPRB,4.8711E+00_JPRB,4.8995E+00_JPRB/)  
KBO( :,43,11) = (/&
 & 4.1043E+00_JPRB,4.1084E+00_JPRB,4.1066E+00_JPRB,4.1113E+00_JPRB,4.1531E+00_JPRB/)  
KBO( :,44,11) = (/&
 & 3.4292E+00_JPRB,3.4435E+00_JPRB,3.4506E+00_JPRB,3.4628E+00_JPRB,3.4927E+00_JPRB/)  
KBO( :,45,11) = (/&
 & 2.8550E+00_JPRB,2.8746E+00_JPRB,2.8867E+00_JPRB,2.9043E+00_JPRB,2.9376E+00_JPRB/)  
KBO( :,46,11) = (/&
 & 2.3728E+00_JPRB,2.3953E+00_JPRB,2.4108E+00_JPRB,2.4301E+00_JPRB,2.4648E+00_JPRB/)  
KBO( :,47,11) = (/&
 & 1.9739E+00_JPRB,1.9977E+00_JPRB,2.0154E+00_JPRB,2.0359E+00_JPRB,2.0698E+00_JPRB/)  
KBO( :,48,11) = (/&
 & 1.6359E+00_JPRB,1.6436E+00_JPRB,1.6769E+00_JPRB,1.6970E+00_JPRB,1.7291E+00_JPRB/)  
KBO( :,49,11) = (/&
 & 1.3494E+00_JPRB,1.3567E+00_JPRB,1.3870E+00_JPRB,1.4058E+00_JPRB,1.4355E+00_JPRB/)  
KBO( :,50,11) = (/&
 & 1.1201E+00_JPRB,1.1274E+00_JPRB,1.1447E+00_JPRB,1.1735E+00_JPRB,1.2015E+00_JPRB/)  
KBO( :,51,11) = (/&
 & 9.3236E-01_JPRB,9.3956E-01_JPRB,9.5616E-01_JPRB,9.8266E-01_JPRB,1.0088E+00_JPRB/)  
KBO( :,52,11) = (/&
 & 7.6514E-01_JPRB,7.8058E-01_JPRB,7.9612E-01_JPRB,8.2019E-01_JPRB,8.4401E-01_JPRB/)  
KBO( :,53,11) = (/&
 & 6.3163E-01_JPRB,6.4570E-01_JPRB,6.5991E-01_JPRB,6.8147E-01_JPRB,7.0283E-01_JPRB/)  
KBO( :,54,11) = (/&
 & 5.2916E-01_JPRB,5.4264E-01_JPRB,5.5622E-01_JPRB,5.7680E-01_JPRB,5.9711E-01_JPRB/)  
KBO( :,55,11) = (/&
 & 4.4763E-01_JPRB,4.6092E-01_JPRB,4.7420E-01_JPRB,4.8811E-01_JPRB,5.1412E-01_JPRB/)  
KBO( :,56,11) = (/&
 & 3.7915E-01_JPRB,3.9216E-01_JPRB,4.0486E-01_JPRB,4.1856E-01_JPRB,4.4359E-01_JPRB/)  
KBO( :,57,11) = (/&
 & 3.2167E-01_JPRB,3.3432E-01_JPRB,3.4630E-01_JPRB,3.5981E-01_JPRB,3.7784E-01_JPRB/)  
KBO( :,58,11) = (/&
 & 2.7464E-01_JPRB,2.8702E-01_JPRB,2.9867E-01_JPRB,3.1204E-01_JPRB,3.2934E-01_JPRB/)  
KBO( :,59,11) = (/&
 & 2.4621E-01_JPRB,2.6016E-01_JPRB,2.7340E-01_JPRB,2.8845E-01_JPRB,3.0710E-01_JPRB/)  
KBO( :,13,12) = (/&
 & 7.6977E+02_JPRB,7.4793E+02_JPRB,7.2446E+02_JPRB,7.0066E+02_JPRB,6.7917E+02_JPRB/)  
KBO( :,14,12) = (/&
 & 7.3387E+02_JPRB,7.1230E+02_JPRB,6.9130E+02_JPRB,6.7176E+02_JPRB,6.5300E+02_JPRB/)  
KBO( :,15,12) = (/&
 & 6.8782E+02_JPRB,6.6903E+02_JPRB,6.5059E+02_JPRB,6.3401E+02_JPRB,6.1759E+02_JPRB/)  
KBO( :,16,12) = (/&
 & 6.4095E+02_JPRB,6.2380E+02_JPRB,6.0836E+02_JPRB,5.9188E+02_JPRB,5.7529E+02_JPRB/)  
KBO( :,17,12) = (/&
 & 5.9449E+02_JPRB,5.7921E+02_JPRB,5.6352E+02_JPRB,5.4698E+02_JPRB,5.3012E+02_JPRB/)  
KBO( :,18,12) = (/&
 & 5.4607E+02_JPRB,5.3143E+02_JPRB,5.1532E+02_JPRB,4.9867E+02_JPRB,4.8280E+02_JPRB/)  
KBO( :,19,12) = (/&
 & 4.9392E+02_JPRB,4.7903E+02_JPRB,4.6380E+02_JPRB,4.4890E+02_JPRB,4.3556E+02_JPRB/)  
KBO( :,20,12) = (/&
 & 4.3831E+02_JPRB,4.2422E+02_JPRB,4.1067E+02_JPRB,3.9873E+02_JPRB,3.8790E+02_JPRB/)  
KBO( :,21,12) = (/&
 & 3.8303E+02_JPRB,3.7136E+02_JPRB,3.6097E+02_JPRB,3.5152E+02_JPRB,3.4179E+02_JPRB/)  
KBO( :,22,12) = (/&
 & 3.3154E+02_JPRB,3.2264E+02_JPRB,3.1420E+02_JPRB,3.0537E+02_JPRB,2.9621E+02_JPRB/)  
KBO( :,23,12) = (/&
 & 2.8552E+02_JPRB,2.7799E+02_JPRB,2.7005E+02_JPRB,2.6190E+02_JPRB,2.5375E+02_JPRB/)  
KBO( :,24,12) = (/&
 & 2.4392E+02_JPRB,2.3705E+02_JPRB,2.3003E+02_JPRB,2.2307E+02_JPRB,2.1616E+02_JPRB/)  
KBO( :,25,12) = (/&
 & 2.0671E+02_JPRB,2.0086E+02_JPRB,1.9497E+02_JPRB,1.8915E+02_JPRB,1.8353E+02_JPRB/)  
KBO( :,26,12) = (/&
 & 1.7664E+02_JPRB,1.7174E+02_JPRB,1.6687E+02_JPRB,1.6216E+02_JPRB,1.5754E+02_JPRB/)  
KBO( :,27,12) = (/&
 & 1.5319E+02_JPRB,1.4908E+02_JPRB,1.4506E+02_JPRB,1.4106E+02_JPRB,1.3709E+02_JPRB/)  
KBO( :,28,12) = (/&
 & 1.3430E+02_JPRB,1.3082E+02_JPRB,1.2741E+02_JPRB,1.2394E+02_JPRB,1.2050E+02_JPRB/)  
KBO( :,29,12) = (/&
 & 1.1630E+02_JPRB,1.1343E+02_JPRB,1.1046E+02_JPRB,1.0751E+02_JPRB,1.0464E+02_JPRB/)  
KBO( :,30,12) = (/&
 & 1.0003E+02_JPRB,9.7504E+01_JPRB,9.4984E+01_JPRB,9.2511E+01_JPRB,9.0094E+01_JPRB/)  
KBO( :,31,12) = (/&
 & 8.4543E+01_JPRB,8.2421E+01_JPRB,8.0309E+01_JPRB,7.8252E+01_JPRB,7.6362E+01_JPRB/)  
KBO( :,32,12) = (/&
 & 7.1066E+01_JPRB,6.9287E+01_JPRB,6.7542E+01_JPRB,6.5943E+01_JPRB,6.4517E+01_JPRB/)  
KBO( :,33,12) = (/&
 & 5.9266E+01_JPRB,5.7811E+01_JPRB,5.6464E+01_JPRB,5.5276E+01_JPRB,5.4194E+01_JPRB/)  
KBO( :,34,12) = (/&
 & 4.9681E+01_JPRB,4.8546E+01_JPRB,4.7554E+01_JPRB,4.6656E+01_JPRB,4.5832E+01_JPRB/)  
KBO( :,35,12) = (/&
 & 4.1619E+01_JPRB,4.0779E+01_JPRB,4.0048E+01_JPRB,3.9371E+01_JPRB,3.8753E+01_JPRB/)  
KBO( :,36,12) = (/&
 & 3.4973E+01_JPRB,3.4356E+01_JPRB,3.3793E+01_JPRB,3.3278E+01_JPRB,3.2853E+01_JPRB/)  
KBO( :,37,12) = (/&
 & 2.9625E+01_JPRB,2.9160E+01_JPRB,2.8725E+01_JPRB,2.8363E+01_JPRB,2.8073E+01_JPRB/)  
KBO( :,38,12) = (/&
 & 2.4970E+01_JPRB,2.4629E+01_JPRB,2.4322E+01_JPRB,2.4082E+01_JPRB,2.3896E+01_JPRB/)  
KBO( :,39,12) = (/&
 & 2.0934E+01_JPRB,2.0693E+01_JPRB,2.0489E+01_JPRB,2.0344E+01_JPRB,2.0233E+01_JPRB/)  
KBO( :,40,12) = (/&
 & 1.7744E+01_JPRB,1.7586E+01_JPRB,1.7465E+01_JPRB,1.7392E+01_JPRB,1.7346E+01_JPRB/)  
KBO( :,41,12) = (/&
 & 1.5025E+01_JPRB,1.4924E+01_JPRB,1.4869E+01_JPRB,1.4860E+01_JPRB,1.4867E+01_JPRB/)  
KBO( :,42,12) = (/&
 & 1.2685E+01_JPRB,1.2638E+01_JPRB,1.2631E+01_JPRB,1.2651E+01_JPRB,1.2715E+01_JPRB/)  
KBO( :,43,12) = (/&
 & 1.0719E+01_JPRB,1.0717E+01_JPRB,1.0742E+01_JPRB,1.0783E+01_JPRB,1.0880E+01_JPRB/)  
KBO( :,44,12) = (/&
 & 9.0501E+00_JPRB,9.0820E+00_JPRB,9.1279E+00_JPRB,9.1850E+00_JPRB,9.2721E+00_JPRB/)  
KBO( :,45,12) = (/&
 & 7.6162E+00_JPRB,7.6722E+00_JPRB,7.7324E+00_JPRB,7.8018E+00_JPRB,7.9000E+00_JPRB/)  
KBO( :,46,12) = (/&
 & 6.3962E+00_JPRB,6.4687E+00_JPRB,6.5373E+00_JPRB,6.6160E+00_JPRB,6.7192E+00_JPRB/)  
KBO( :,47,12) = (/&
 & 5.3742E+00_JPRB,5.4559E+00_JPRB,5.5296E+00_JPRB,5.6153E+00_JPRB,5.7197E+00_JPRB/)  
KBO( :,48,12) = (/&
 & 4.4947E+00_JPRB,4.5364E+00_JPRB,4.6536E+00_JPRB,4.7417E+00_JPRB,4.8452E+00_JPRB/)  
KBO( :,49,12) = (/&
 & 3.7377E+00_JPRB,3.7797E+00_JPRB,3.8917E+00_JPRB,3.9774E+00_JPRB,4.0760E+00_JPRB/)  
KBO( :,50,12) = (/&
 & 3.1257E+00_JPRB,3.1688E+00_JPRB,3.2414E+00_JPRB,3.3587E+00_JPRB,3.4531E+00_JPRB/)  
KBO( :,51,12) = (/&
 & 2.6197E+00_JPRB,2.6616E+00_JPRB,2.7310E+00_JPRB,2.8422E+00_JPRB,2.9329E+00_JPRB/)  
KBO( :,52,12) = (/&
 & 2.1600E+00_JPRB,2.2271E+00_JPRB,2.2920E+00_JPRB,2.3952E+00_JPRB,2.4794E+00_JPRB/)  
KBO( :,53,12) = (/&
 & 1.7940E+00_JPRB,1.8552E+00_JPRB,1.9143E+00_JPRB,2.0071E+00_JPRB,2.0842E+00_JPRB/)  
KBO( :,54,12) = (/&
 & 1.5125E+00_JPRB,1.5709E+00_JPRB,1.6271E+00_JPRB,1.7149E+00_JPRB,1.7900E+00_JPRB/)  
KBO( :,55,12) = (/&
 & 1.2864E+00_JPRB,1.3434E+00_JPRB,1.3983E+00_JPRB,1.4607E+00_JPRB,1.5586E+00_JPRB/)  
KBO( :,56,12) = (/&
 & 1.0940E+00_JPRB,1.1493E+00_JPRB,1.2023E+00_JPRB,1.2621E+00_JPRB,1.3583E+00_JPRB/)  
KBO( :,57,12) = (/&
 & 9.3078E-01_JPRB,9.8417E-01_JPRB,1.0349E+00_JPRB,1.0915E+00_JPRB,1.1646E+00_JPRB/)  
KBO( :,58,12) = (/&
 & 7.9608E-01_JPRB,8.4769E-01_JPRB,8.9646E-01_JPRB,9.5071E-01_JPRB,1.0223E+00_JPRB/)  
KBO( :,59,12) = (/&
 & 7.1554E-01_JPRB,7.6833E-01_JPRB,8.2032E-01_JPRB,8.7901E-01_JPRB,9.5749E-01_JPRB/)  
KBO( :,13,13) = (/&
 & 1.4216E+03_JPRB,1.3963E+03_JPRB,1.3631E+03_JPRB,1.3261E+03_JPRB,1.2872E+03_JPRB/)  
KBO( :,14,13) = (/&
 & 1.4474E+03_JPRB,1.4163E+03_JPRB,1.3787E+03_JPRB,1.3394E+03_JPRB,1.2981E+03_JPRB/)  
KBO( :,15,13) = (/&
 & 1.4512E+03_JPRB,1.4149E+03_JPRB,1.3749E+03_JPRB,1.3327E+03_JPRB,1.2901E+03_JPRB/)  
KBO( :,16,13) = (/&
 & 1.4256E+03_JPRB,1.3858E+03_JPRB,1.3435E+03_JPRB,1.3004E+03_JPRB,1.2608E+03_JPRB/)  
KBO( :,17,13) = (/&
 & 1.3679E+03_JPRB,1.3285E+03_JPRB,1.2893E+03_JPRB,1.2520E+03_JPRB,1.2169E+03_JPRB/)  
KBO( :,18,13) = (/&
 & 1.2910E+03_JPRB,1.2552E+03_JPRB,1.2211E+03_JPRB,1.1883E+03_JPRB,1.1564E+03_JPRB/)  
KBO( :,19,13) = (/&
 & 1.2049E+03_JPRB,1.1727E+03_JPRB,1.1421E+03_JPRB,1.1114E+03_JPRB,1.0816E+03_JPRB/)  
KBO( :,20,13) = (/&
 & 1.1167E+03_JPRB,1.0881E+03_JPRB,1.0594E+03_JPRB,1.0292E+03_JPRB,9.9813E+02_JPRB/)  
KBO( :,21,13) = (/&
 & 1.0270E+03_JPRB,9.9863E+02_JPRB,9.6867E+02_JPRB,9.3868E+02_JPRB,9.1038E+02_JPRB/)  
KBO( :,22,13) = (/&
 & 9.2976E+02_JPRB,9.0181E+02_JPRB,8.7366E+02_JPRB,8.4725E+02_JPRB,8.2285E+02_JPRB/)  
KBO( :,23,13) = (/&
 & 8.2725E+02_JPRB,8.0202E+02_JPRB,7.7822E+02_JPRB,7.5610E+02_JPRB,7.3490E+02_JPRB/)  
KBO( :,24,13) = (/&
 & 7.2581E+02_JPRB,7.0458E+02_JPRB,6.8480E+02_JPRB,6.6655E+02_JPRB,6.4907E+02_JPRB/)  
KBO( :,25,13) = (/&
 & 6.3072E+02_JPRB,6.1389E+02_JPRB,5.9813E+02_JPRB,5.8216E+02_JPRB,5.6605E+02_JPRB/)  
KBO( :,26,13) = (/&
 & 5.4441E+02_JPRB,5.3034E+02_JPRB,5.1604E+02_JPRB,5.0169E+02_JPRB,4.8714E+02_JPRB/)  
KBO( :,27,13) = (/&
 & 4.6653E+02_JPRB,4.5389E+02_JPRB,4.4148E+02_JPRB,4.2897E+02_JPRB,4.1698E+02_JPRB/)  
KBO( :,28,13) = (/&
 & 3.9708E+02_JPRB,3.8655E+02_JPRB,3.7613E+02_JPRB,3.6588E+02_JPRB,3.5605E+02_JPRB/)  
KBO( :,29,13) = (/&
 & 3.3742E+02_JPRB,3.2877E+02_JPRB,3.2031E+02_JPRB,3.1201E+02_JPRB,3.0377E+02_JPRB/)  
KBO( :,30,13) = (/&
 & 2.8701E+02_JPRB,2.8009E+02_JPRB,2.7310E+02_JPRB,2.6617E+02_JPRB,2.5918E+02_JPRB/)  
KBO( :,31,13) = (/&
 & 2.4344E+02_JPRB,2.3761E+02_JPRB,2.3174E+02_JPRB,2.2586E+02_JPRB,2.1997E+02_JPRB/)  
KBO( :,32,13) = (/&
 & 2.0631E+02_JPRB,2.0140E+02_JPRB,1.9647E+02_JPRB,1.9146E+02_JPRB,1.8661E+02_JPRB/)  
KBO( :,33,13) = (/&
 & 1.7451E+02_JPRB,1.7040E+02_JPRB,1.6625E+02_JPRB,1.6215E+02_JPRB,1.5828E+02_JPRB/)  
KBO( :,34,13) = (/&
 & 1.4849E+02_JPRB,1.4504E+02_JPRB,1.4164E+02_JPRB,1.3837E+02_JPRB,1.3534E+02_JPRB/)  
KBO( :,35,13) = (/&
 & 1.2667E+02_JPRB,1.2383E+02_JPRB,1.2110E+02_JPRB,1.1850E+02_JPRB,1.1620E+02_JPRB/)  
KBO( :,36,13) = (/&
 & 1.0839E+02_JPRB,1.0609E+02_JPRB,1.0390E+02_JPRB,1.0191E+02_JPRB,1.0024E+02_JPRB/)  
KBO( :,37,13) = (/&
 & 9.3433E+01_JPRB,9.1633E+01_JPRB,8.9904E+01_JPRB,8.8384E+01_JPRB,8.7182E+01_JPRB/)  
KBO( :,38,13) = (/&
 & 8.0277E+01_JPRB,7.8883E+01_JPRB,7.7590E+01_JPRB,7.6493E+01_JPRB,7.5656E+01_JPRB/)  
KBO( :,39,13) = (/&
 & 6.8616E+01_JPRB,6.7545E+01_JPRB,6.6602E+01_JPRB,6.5907E+01_JPRB,6.5350E+01_JPRB/)  
KBO( :,40,13) = (/&
 & 5.9404E+01_JPRB,5.8632E+01_JPRB,5.7971E+01_JPRB,5.7558E+01_JPRB,5.7248E+01_JPRB/)  
KBO( :,41,13) = (/&
 & 5.1376E+01_JPRB,5.0859E+01_JPRB,5.0445E+01_JPRB,5.0221E+01_JPRB,5.0128E+01_JPRB/)  
KBO( :,42,13) = (/&
 & 4.4234E+01_JPRB,4.3936E+01_JPRB,4.3743E+01_JPRB,4.3725E+01_JPRB,4.3767E+01_JPRB/)  
KBO( :,43,13) = (/&
 & 3.8053E+01_JPRB,3.7937E+01_JPRB,3.7898E+01_JPRB,3.8023E+01_JPRB,3.8201E+01_JPRB/)  
KBO( :,44,13) = (/&
 & 3.2676E+01_JPRB,3.2705E+01_JPRB,3.2770E+01_JPRB,3.2989E+01_JPRB,3.3265E+01_JPRB/)  
KBO( :,45,13) = (/&
 & 2.7944E+01_JPRB,2.8089E+01_JPRB,2.8247E+01_JPRB,2.8518E+01_JPRB,2.8846E+01_JPRB/)  
KBO( :,46,13) = (/&
 & 2.3845E+01_JPRB,2.4085E+01_JPRB,2.4309E+01_JPRB,2.4615E+01_JPRB,2.4979E+01_JPRB/)  
KBO( :,47,13) = (/&
 & 2.0369E+01_JPRB,2.0675E+01_JPRB,2.0941E+01_JPRB,2.1268E+01_JPRB,2.1673E+01_JPRB/)  
KBO( :,48,13) = (/&
 & 1.7326E+01_JPRB,1.7556E+01_JPRB,1.7948E+01_JPRB,1.8285E+01_JPRB,1.8703E+01_JPRB/)  
KBO( :,49,13) = (/&
 & 1.4637E+01_JPRB,1.4880E+01_JPRB,1.5276E+01_JPRB,1.5608E+01_JPRB,1.6019E+01_JPRB/)  
KBO( :,50,13) = (/&
 & 1.2439E+01_JPRB,1.2696E+01_JPRB,1.3009E+01_JPRB,1.3432E+01_JPRB,1.3843E+01_JPRB/)  
KBO( :,51,13) = (/&
 & 1.0584E+01_JPRB,1.0852E+01_JPRB,1.1176E+01_JPRB,1.1603E+01_JPRB,1.2011E+01_JPRB/)  
KBO( :,52,13) = (/&
 & 8.8615E+00_JPRB,9.2312E+00_JPRB,9.5521E+00_JPRB,9.9700E+00_JPRB,1.0369E+01_JPRB/)  
KBO( :,53,13) = (/&
 & 7.4436E+00_JPRB,7.8034E+00_JPRB,8.1100E+00_JPRB,8.5076E+00_JPRB,8.8838E+00_JPRB/)  
KBO( :,54,13) = (/&
 & 6.3609E+00_JPRB,6.7200E+00_JPRB,7.0326E+00_JPRB,7.4311E+00_JPRB,7.8042E+00_JPRB/)  
KBO( :,55,13) = (/&
 & 5.4942E+00_JPRB,5.8571E+00_JPRB,6.1799E+00_JPRB,6.4978E+00_JPRB,6.9694E+00_JPRB/)  
KBO( :,56,13) = (/&
 & 4.7434E+00_JPRB,5.1101E+00_JPRB,5.4346E+00_JPRB,5.7533E+00_JPRB,6.2335E+00_JPRB/)  
KBO( :,57,13) = (/&
 & 4.0946E+00_JPRB,4.4592E+00_JPRB,4.7823E+00_JPRB,5.1021E+00_JPRB,5.4957E+00_JPRB/)  
KBO( :,58,13) = (/&
 & 3.5510E+00_JPRB,3.9146E+00_JPRB,4.2394E+00_JPRB,4.5624E+00_JPRB,4.9570E+00_JPRB/)  
KBO( :,59,13) = (/&
 & 3.2469E+00_JPRB,3.6400E+00_JPRB,4.0004E+00_JPRB,4.3660E+00_JPRB,4.8112E+00_JPRB/)  
KBO( :,13,14) = (/&
 & 2.9334E+03_JPRB,2.8777E+03_JPRB,2.8251E+03_JPRB,2.7722E+03_JPRB,2.7139E+03_JPRB/)  
KBO( :,14,14) = (/&
 & 3.0980E+03_JPRB,3.0395E+03_JPRB,2.9754E+03_JPRB,2.9139E+03_JPRB,2.8590E+03_JPRB/)  
KBO( :,15,14) = (/&
 & 3.2422E+03_JPRB,3.1687E+03_JPRB,3.1071E+03_JPRB,3.0415E+03_JPRB,2.9792E+03_JPRB/)  
KBO( :,16,14) = (/&
 & 3.3594E+03_JPRB,3.2894E+03_JPRB,3.2245E+03_JPRB,3.1534E+03_JPRB,3.0780E+03_JPRB/)  
KBO( :,17,14) = (/&
 & 3.4662E+03_JPRB,3.3974E+03_JPRB,3.3177E+03_JPRB,3.2347E+03_JPRB,3.1458E+03_JPRB/)  
KBO( :,18,14) = (/&
 & 3.5551E+03_JPRB,3.4706E+03_JPRB,3.3818E+03_JPRB,3.2833E+03_JPRB,3.1871E+03_JPRB/)  
KBO( :,19,14) = (/&
 & 3.5953E+03_JPRB,3.5053E+03_JPRB,3.4059E+03_JPRB,3.3056E+03_JPRB,3.2071E+03_JPRB/)  
KBO( :,20,14) = (/&
 & 3.5722E+03_JPRB,3.4751E+03_JPRB,3.3772E+03_JPRB,3.2793E+03_JPRB,3.1813E+03_JPRB/)  
KBO( :,21,14) = (/&
 & 3.4918E+03_JPRB,3.3970E+03_JPRB,3.3000E+03_JPRB,3.2054E+03_JPRB,3.1102E+03_JPRB/)  
KBO( :,22,14) = (/&
 & 3.3556E+03_JPRB,3.2639E+03_JPRB,3.1694E+03_JPRB,3.0789E+03_JPRB,2.9903E+03_JPRB/)  
KBO( :,23,14) = (/&
 & 3.1787E+03_JPRB,3.0917E+03_JPRB,3.0049E+03_JPRB,2.9210E+03_JPRB,2.8398E+03_JPRB/)  
KBO( :,24,14) = (/&
 & 2.9739E+03_JPRB,2.8938E+03_JPRB,2.8153E+03_JPRB,2.7372E+03_JPRB,2.6621E+03_JPRB/)  
KBO( :,25,14) = (/&
 & 2.7453E+03_JPRB,2.6720E+03_JPRB,2.6011E+03_JPRB,2.5300E+03_JPRB,2.4637E+03_JPRB/)  
KBO( :,26,14) = (/&
 & 2.5096E+03_JPRB,2.4426E+03_JPRB,2.3775E+03_JPRB,2.3148E+03_JPRB,2.2551E+03_JPRB/)  
KBO( :,27,14) = (/&
 & 2.2699E+03_JPRB,2.2101E+03_JPRB,2.1525E+03_JPRB,2.0966E+03_JPRB,2.0458E+03_JPRB/)  
KBO( :,28,14) = (/&
 & 2.0339E+03_JPRB,1.9809E+03_JPRB,1.9302E+03_JPRB,1.8831E+03_JPRB,1.8402E+03_JPRB/)  
KBO( :,29,14) = (/&
 & 1.8034E+03_JPRB,1.7583E+03_JPRB,1.7163E+03_JPRB,1.6782E+03_JPRB,1.6421E+03_JPRB/)  
KBO( :,30,14) = (/&
 & 1.5820E+03_JPRB,1.5447E+03_JPRB,1.5128E+03_JPRB,1.4831E+03_JPRB,1.4550E+03_JPRB/)  
KBO( :,31,14) = (/&
 & 1.3768E+03_JPRB,1.3502E+03_JPRB,1.3259E+03_JPRB,1.3028E+03_JPRB,1.2805E+03_JPRB/)  
KBO( :,32,14) = (/&
 & 1.1943E+03_JPRB,1.1745E+03_JPRB,1.1559E+03_JPRB,1.1380E+03_JPRB,1.1211E+03_JPRB/)  
KBO( :,33,14) = (/&
 & 1.0318E+03_JPRB,1.0174E+03_JPRB,1.0030E+03_JPRB,9.8941E+02_JPRB,9.7764E+02_JPRB/)  
KBO( :,34,14) = (/&
 & 8.9071E+02_JPRB,8.7939E+02_JPRB,8.6886E+02_JPRB,8.6024E+02_JPRB,8.5244E+02_JPRB/)  
KBO( :,35,14) = (/&
 & 7.6798E+02_JPRB,7.6029E+02_JPRB,7.5422E+02_JPRB,7.4951E+02_JPRB,7.4470E+02_JPRB/)  
KBO( :,36,14) = (/&
 & 6.6325E+02_JPRB,6.5893E+02_JPRB,6.5635E+02_JPRB,6.5426E+02_JPRB,6.5190E+02_JPRB/)  
KBO( :,37,14) = (/&
 & 5.7400E+02_JPRB,5.7252E+02_JPRB,5.7250E+02_JPRB,5.7225E+02_JPRB,5.7202E+02_JPRB/)  
KBO( :,38,14) = (/&
 & 4.9686E+02_JPRB,4.9759E+02_JPRB,4.9968E+02_JPRB,5.0087E+02_JPRB,5.0220E+02_JPRB/)  
KBO( :,39,14) = (/&
 & 4.3040E+02_JPRB,4.3277E+02_JPRB,4.3573E+02_JPRB,4.3837E+02_JPRB,4.4124E+02_JPRB/)  
KBO( :,40,14) = (/&
 & 3.7403E+02_JPRB,3.7755E+02_JPRB,3.8110E+02_JPRB,3.8474E+02_JPRB,3.8876E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART7',0,ZHOOK_HANDLE)


KBO( :,41,14) = (/&
 & 3.2578E+02_JPRB,3.3002E+02_JPRB,3.3411E+02_JPRB,3.3839E+02_JPRB,3.4323E+02_JPRB/)  
KBO( :,42,14) = (/&
 & 2.8407E+02_JPRB,2.8896E+02_JPRB,2.9341E+02_JPRB,2.9793E+02_JPRB,3.0372E+02_JPRB/)  
KBO( :,43,14) = (/&
 & 2.4780E+02_JPRB,2.5311E+02_JPRB,2.5804E+02_JPRB,2.6300E+02_JPRB,2.6916E+02_JPRB/)  
KBO( :,44,14) = (/&
 & 2.1608E+02_JPRB,2.2160E+02_JPRB,2.2690E+02_JPRB,2.3233E+02_JPRB,2.3866E+02_JPRB/)  
KBO( :,45,14) = (/&
 & 1.8824E+02_JPRB,1.9381E+02_JPRB,1.9935E+02_JPRB,2.0504E+02_JPRB,2.1167E+02_JPRB/)  
KBO( :,46,14) = (/&
 & 1.6388E+02_JPRB,1.6938E+02_JPRB,1.7501E+02_JPRB,1.8081E+02_JPRB,1.8759E+02_JPRB/)  
KBO( :,47,14) = (/&
 & 1.4266E+02_JPRB,1.4798E+02_JPRB,1.5358E+02_JPRB,1.5946E+02_JPRB,1.6626E+02_JPRB/)  
KBO( :,48,14) = (/&
 & 1.2380E+02_JPRB,1.2887E+02_JPRB,1.3460E+02_JPRB,1.4036E+02_JPRB,1.4712E+02_JPRB/)  
KBO( :,49,14) = (/&
 & 1.0697E+02_JPRB,1.1187E+02_JPRB,1.1753E+02_JPRB,1.2324E+02_JPRB,1.2991E+02_JPRB/)  
KBO( :,50,14) = (/&
 & 9.2940E+01_JPRB,9.7678E+01_JPRB,1.0307E+02_JPRB,1.0888E+02_JPRB,1.1536E+02_JPRB/)  
KBO( :,51,14) = (/&
 & 8.1029E+01_JPRB,8.5527E+01_JPRB,9.0730E+01_JPRB,9.6501E+01_JPRB,1.0280E+02_JPRB/)  
KBO( :,52,14) = (/&
 & 7.0406E+01_JPRB,7.4706E+01_JPRB,7.9713E+01_JPRB,8.5353E+01_JPRB,9.1529E+01_JPRB/)  
KBO( :,53,14) = (/&
 & 6.0914E+01_JPRB,6.5029E+01_JPRB,6.9770E+01_JPRB,7.5302E+01_JPRB,8.1302E+01_JPRB/)  
KBO( :,54,14) = (/&
 & 5.3685E+01_JPRB,5.7712E+01_JPRB,6.2246E+01_JPRB,6.7555E+01_JPRB,7.3372E+01_JPRB/)  
KBO( :,55,14) = (/&
 & 4.8002E+01_JPRB,5.1999E+01_JPRB,5.6435E+01_JPRB,6.1422E+01_JPRB,6.7178E+01_JPRB/)  
KBO( :,56,14) = (/&
 & 4.3069E+01_JPRB,4.7058E+01_JPRB,5.1421E+01_JPRB,5.6338E+01_JPRB,6.1901E+01_JPRB/)  
KBO( :,57,14) = (/&
 & 3.8718E+01_JPRB,4.2795E+01_JPRB,4.7064E+01_JPRB,5.1974E+01_JPRB,5.7337E+01_JPRB/)  
KBO( :,58,14) = (/&
 & 3.5127E+01_JPRB,3.9394E+01_JPRB,4.3676E+01_JPRB,4.8594E+01_JPRB,5.4054E+01_JPRB/)  
KBO( :,59,14) = (/&
 & 3.4411E+01_JPRB,3.9387E+01_JPRB,4.4312E+01_JPRB,4.9761E+01_JPRB,5.5833E+01_JPRB/)  
KBO( :,13,15) = (/&
 & 5.8626E+03_JPRB,5.7531E+03_JPRB,5.6999E+03_JPRB,5.6080E+03_JPRB,5.5646E+03_JPRB/)  
KBO( :,14,15) = (/&
 & 6.6299E+03_JPRB,6.5552E+03_JPRB,6.4532E+03_JPRB,6.3570E+03_JPRB,6.2707E+03_JPRB/)  
KBO( :,15,15) = (/&
 & 7.5140E+03_JPRB,7.3938E+03_JPRB,7.2851E+03_JPRB,7.1606E+03_JPRB,7.0596E+03_JPRB/)  
KBO( :,16,15) = (/&
 & 8.4004E+03_JPRB,8.2640E+03_JPRB,8.1296E+03_JPRB,7.9995E+03_JPRB,7.8682E+03_JPRB/)  
KBO( :,17,15) = (/&
 & 9.2783E+03_JPRB,9.1233E+03_JPRB,8.9809E+03_JPRB,8.8341E+03_JPRB,8.6706E+03_JPRB/)  
KBO( :,18,15) = (/&
 & 1.0203E+04_JPRB,9.9981E+03_JPRB,9.8375E+03_JPRB,9.6605E+03_JPRB,9.4887E+03_JPRB/)  
KBO( :,19,15) = (/&
 & 1.1106E+04_JPRB,1.0894E+04_JPRB,1.0688E+04_JPRB,1.0490E+04_JPRB,1.0272E+04_JPRB/)  
KBO( :,20,15) = (/&
 & 1.2022E+04_JPRB,1.1788E+04_JPRB,1.1526E+04_JPRB,1.1301E+04_JPRB,1.1063E+04_JPRB/)  
KBO( :,21,15) = (/&
 & 1.2860E+04_JPRB,1.2601E+04_JPRB,1.2351E+04_JPRB,1.2080E+04_JPRB,1.1797E+04_JPRB/)  
KBO( :,22,15) = (/&
 & 1.3622E+04_JPRB,1.3359E+04_JPRB,1.3050E+04_JPRB,1.2774E+04_JPRB,1.2461E+04_JPRB/)  
KBO( :,23,15) = (/&
 & 1.4282E+04_JPRB,1.3995E+04_JPRB,1.3676E+04_JPRB,1.3349E+04_JPRB,1.3009E+04_JPRB/)  
KBO( :,24,15) = (/&
 & 1.4830E+04_JPRB,1.4486E+04_JPRB,1.4138E+04_JPRB,1.3782E+04_JPRB,1.3441E+04_JPRB/)  
KBO( :,25,15) = (/&
 & 1.5198E+04_JPRB,1.4832E+04_JPRB,1.4459E+04_JPRB,1.4100E+04_JPRB,1.3752E+04_JPRB/)  
KBO( :,26,15) = (/&
 & 1.5360E+04_JPRB,1.4999E+04_JPRB,1.4642E+04_JPRB,1.4292E+04_JPRB,1.3943E+04_JPRB/)  
KBO( :,27,15) = (/&
 & 1.5406E+04_JPRB,1.5053E+04_JPRB,1.4691E+04_JPRB,1.4344E+04_JPRB,1.3993E+04_JPRB/)  
KBO( :,28,15) = (/&
 & 1.5350E+04_JPRB,1.4989E+04_JPRB,1.4625E+04_JPRB,1.4280E+04_JPRB,1.3936E+04_JPRB/)  
KBO( :,29,15) = (/&
 & 1.5162E+04_JPRB,1.4811E+04_JPRB,1.4452E+04_JPRB,1.4117E+04_JPRB,1.3798E+04_JPRB/)  
KBO( :,30,15) = (/&
 & 1.4888E+04_JPRB,1.4556E+04_JPRB,1.4228E+04_JPRB,1.3905E+04_JPRB,1.3609E+04_JPRB/)  
KBO( :,31,15) = (/&
 & 1.4511E+04_JPRB,1.4207E+04_JPRB,1.3919E+04_JPRB,1.3634E+04_JPRB,1.3368E+04_JPRB/)  
KBO( :,32,15) = (/&
 & 1.4068E+04_JPRB,1.3811E+04_JPRB,1.3560E+04_JPRB,1.3325E+04_JPRB,1.3103E+04_JPRB/)  
KBO( :,33,15) = (/&
 & 1.3601E+04_JPRB,1.3399E+04_JPRB,1.3196E+04_JPRB,1.3006E+04_JPRB,1.2830E+04_JPRB/)  
KBO( :,34,15) = (/&
 & 1.3119E+04_JPRB,1.2976E+04_JPRB,1.2834E+04_JPRB,1.2699E+04_JPRB,1.2559E+04_JPRB/)  
KBO( :,35,15) = (/&
 & 1.2646E+04_JPRB,1.2564E+04_JPRB,1.2475E+04_JPRB,1.2392E+04_JPRB,1.2320E+04_JPRB/)  
KBO( :,36,15) = (/&
 & 1.2190E+04_JPRB,1.2170E+04_JPRB,1.2138E+04_JPRB,1.2103E+04_JPRB,1.2079E+04_JPRB/)  
KBO( :,37,15) = (/&
 & 1.1737E+04_JPRB,1.1781E+04_JPRB,1.1808E+04_JPRB,1.1824E+04_JPRB,1.1847E+04_JPRB/)  
KBO( :,38,15) = (/&
 & 1.1288E+04_JPRB,1.1385E+04_JPRB,1.1474E+04_JPRB,1.1550E+04_JPRB,1.1619E+04_JPRB/)  
KBO( :,39,15) = (/&
 & 1.0856E+04_JPRB,1.1010E+04_JPRB,1.1156E+04_JPRB,1.1287E+04_JPRB,1.1401E+04_JPRB/)  
KBO( :,40,15) = (/&
 & 1.0434E+04_JPRB,1.0638E+04_JPRB,1.0839E+04_JPRB,1.1017E+04_JPRB,1.1176E+04_JPRB/)  
KBO( :,41,15) = (/&
 & 1.0025E+04_JPRB,1.0281E+04_JPRB,1.0529E+04_JPRB,1.0755E+04_JPRB,1.0956E+04_JPRB/)  
KBO( :,42,15) = (/&
 & 9.6179E+03_JPRB,9.9405E+03_JPRB,1.0234E+04_JPRB,1.0504E+04_JPRB,1.0740E+04_JPRB/)  
KBO( :,43,15) = (/&
 & 9.2261E+03_JPRB,9.6002E+03_JPRB,9.9385E+03_JPRB,1.0249E+04_JPRB,1.0522E+04_JPRB/)  
KBO( :,44,15) = (/&
 & 8.8369E+03_JPRB,9.2610E+03_JPRB,9.6434E+03_JPRB,9.9917E+03_JPRB,1.0304E+04_JPRB/)  
KBO( :,45,15) = (/&
 & 8.4565E+03_JPRB,8.9270E+03_JPRB,9.3572E+03_JPRB,9.7378E+03_JPRB,1.0089E+04_JPRB/)  
KBO( :,46,15) = (/&
 & 8.0787E+03_JPRB,8.5914E+03_JPRB,9.0699E+03_JPRB,9.4822E+03_JPRB,9.8664E+03_JPRB/)  
KBO( :,47,15) = (/&
 & 7.6853E+03_JPRB,8.2420E+03_JPRB,8.7669E+03_JPRB,9.2155E+03_JPRB,9.6327E+03_JPRB/)  
KBO( :,48,15) = (/&
 & 7.2976E+03_JPRB,7.9018E+03_JPRB,8.4572E+03_JPRB,8.9503E+03_JPRB,9.3974E+03_JPRB/)  
KBO( :,49,15) = (/&
 & 6.9137E+03_JPRB,7.5530E+03_JPRB,8.1461E+03_JPRB,8.6824E+03_JPRB,9.1633E+03_JPRB/)  
KBO( :,50,15) = (/&
 & 6.5439E+03_JPRB,7.2215E+03_JPRB,7.8385E+03_JPRB,8.4232E+03_JPRB,8.9404E+03_JPRB/)  
KBO( :,51,15) = (/&
 & 6.1848E+03_JPRB,6.8963E+03_JPRB,7.5471E+03_JPRB,8.1684E+03_JPRB,8.7207E+03_JPRB/)  
KBO( :,52,15) = (/&
 & 5.8189E+03_JPRB,6.5740E+03_JPRB,7.2547E+03_JPRB,7.9146E+03_JPRB,8.4977E+03_JPRB/)  
KBO( :,53,15) = (/&
 & 5.4670E+03_JPRB,6.2525E+03_JPRB,6.9648E+03_JPRB,7.6568E+03_JPRB,8.2688E+03_JPRB/)  
KBO( :,54,15) = (/&
 & 5.1436E+03_JPRB,5.9527E+03_JPRB,6.6949E+03_JPRB,7.4192E+03_JPRB,8.0568E+03_JPRB/)  
KBO( :,55,15) = (/&
 & 4.8355E+03_JPRB,5.6683E+03_JPRB,6.4321E+03_JPRB,7.1732E+03_JPRB,7.8507E+03_JPRB/)  
KBO( :,56,15) = (/&
 & 4.5326E+03_JPRB,5.3883E+03_JPRB,6.1757E+03_JPRB,6.9385E+03_JPRB,7.6455E+03_JPRB/)  
KBO( :,57,15) = (/&
 & 4.2335E+03_JPRB,5.1109E+03_JPRB,5.9237E+03_JPRB,6.7072E+03_JPRB,7.4206E+03_JPRB/)  
KBO( :,58,15) = (/&
 & 3.9599E+03_JPRB,4.8524E+03_JPRB,5.6868E+03_JPRB,6.4919E+03_JPRB,7.2242E+03_JPRB/)  
KBO( :,59,15) = (/&
 & 3.8525E+03_JPRB,4.7532E+03_JPRB,5.5997E+03_JPRB,6.4149E+03_JPRB,7.1557E+03_JPRB/)  
KBO( :,13,16) = (/&
 & 1.1371E+04_JPRB,1.1323E+04_JPRB,1.1315E+04_JPRB,1.1164E+04_JPRB,1.1081E+04_JPRB/)  
KBO( :,14,16) = (/&
 & 1.3431E+04_JPRB,1.3485E+04_JPRB,1.3332E+04_JPRB,1.3142E+04_JPRB,1.2900E+04_JPRB/)  
KBO( :,15,16) = (/&
 & 1.5843E+04_JPRB,1.5741E+04_JPRB,1.5575E+04_JPRB,1.5331E+04_JPRB,1.5089E+04_JPRB/)  
KBO( :,16,16) = (/&
 & 1.8399E+04_JPRB,1.8340E+04_JPRB,1.8137E+04_JPRB,1.7913E+04_JPRB,1.7697E+04_JPRB/)  
KBO( :,17,16) = (/&
 & 2.1310E+04_JPRB,2.1226E+04_JPRB,2.1046E+04_JPRB,2.0865E+04_JPRB,2.0549E+04_JPRB/)  
KBO( :,18,16) = (/&
 & 2.4633E+04_JPRB,2.4423E+04_JPRB,2.4337E+04_JPRB,2.4031E+04_JPRB,2.3685E+04_JPRB/)  
KBO( :,19,16) = (/&
 & 2.8116E+04_JPRB,2.8107E+04_JPRB,2.7914E+04_JPRB,2.7644E+04_JPRB,2.7235E+04_JPRB/)  
KBO( :,20,16) = (/&
 & 3.2352E+04_JPRB,3.2111E+04_JPRB,3.1818E+04_JPRB,3.1625E+04_JPRB,3.1234E+04_JPRB/)  
KBO( :,21,16) = (/&
 & 3.7036E+04_JPRB,3.6651E+04_JPRB,3.6428E+04_JPRB,3.6095E+04_JPRB,3.5692E+04_JPRB/)  
KBO( :,22,16) = (/&
 & 4.2524E+04_JPRB,4.2050E+04_JPRB,4.1496E+04_JPRB,4.1174E+04_JPRB,4.0706E+04_JPRB/)  
KBO( :,23,16) = (/&
 & 4.8715E+04_JPRB,4.8086E+04_JPRB,4.7446E+04_JPRB,4.6855E+04_JPRB,4.6215E+04_JPRB/)  
KBO( :,24,16) = (/&
 & 5.5639E+04_JPRB,5.4833E+04_JPRB,5.3941E+04_JPRB,5.3072E+04_JPRB,5.2154E+04_JPRB/)  
KBO( :,25,16) = (/&
 & 6.3125E+04_JPRB,6.2076E+04_JPRB,6.0936E+04_JPRB,5.9802E+04_JPRB,5.8643E+04_JPRB/)  
KBO( :,26,16) = (/&
 & 7.0969E+04_JPRB,6.9666E+04_JPRB,6.8250E+04_JPRB,6.6863E+04_JPRB,6.5447E+04_JPRB/)  
KBO( :,27,16) = (/&
 & 7.9041E+04_JPRB,7.7424E+04_JPRB,7.5739E+04_JPRB,7.4111E+04_JPRB,7.2428E+04_JPRB/)  
KBO( :,28,16) = (/&
 & 8.7171E+04_JPRB,8.5329E+04_JPRB,8.3283E+04_JPRB,8.1385E+04_JPRB,7.9412E+04_JPRB/)  
KBO( :,29,16) = (/&
 & 9.5287E+04_JPRB,9.3095E+04_JPRB,9.0725E+04_JPRB,8.8465E+04_JPRB,8.6095E+04_JPRB/)  
KBO( :,30,16) = (/&
 & 1.0333E+05_JPRB,1.0061E+05_JPRB,9.7918E+04_JPRB,9.5190E+04_JPRB,9.2462E+04_JPRB/)  
KBO( :,31,16) = (/&
 & 1.1108E+05_JPRB,1.0788E+05_JPRB,1.0471E+05_JPRB,1.0154E+05_JPRB,9.8354E+04_JPRB/)  
KBO( :,32,16) = (/&
 & 1.1839E+05_JPRB,1.1468E+05_JPRB,1.1110E+05_JPRB,1.0744E+05_JPRB,1.0381E+05_JPRB/)  
KBO( :,33,16) = (/&
 & 1.2510E+05_JPRB,1.2097E+05_JPRB,1.1682E+05_JPRB,1.1275E+05_JPRB,1.0867E+05_JPRB/)  
KBO( :,34,16) = (/&
 & 1.3142E+05_JPRB,1.2677E+05_JPRB,1.2209E+05_JPRB,1.1755E+05_JPRB,1.1311E+05_JPRB/)  
KBO( :,35,16) = (/&
 & 1.3764E+05_JPRB,1.3245E+05_JPRB,1.2727E+05_JPRB,1.2228E+05_JPRB,1.1753E+05_JPRB/)  
KBO( :,36,16) = (/&
 & 1.4383E+05_JPRB,1.3810E+05_JPRB,1.3243E+05_JPRB,1.2701E+05_JPRB,1.2185E+05_JPRB/)  
KBO( :,37,16) = (/&
 & 1.5046E+05_JPRB,1.4418E+05_JPRB,1.3799E+05_JPRB,1.3212E+05_JPRB,1.2655E+05_JPRB/)  
KBO( :,38,16) = (/&
 & 1.5675E+05_JPRB,1.4982E+05_JPRB,1.4330E+05_JPRB,1.3693E+05_JPRB,1.3095E+05_JPRB/)  
KBO( :,39,16) = (/&
 & 1.6258E+05_JPRB,1.5518E+05_JPRB,1.4815E+05_JPRB,1.4138E+05_JPRB,1.3502E+05_JPRB/)  
KBO( :,40,16) = (/&
 & 1.6871E+05_JPRB,1.6088E+05_JPRB,1.5341E+05_JPRB,1.4623E+05_JPRB,1.3948E+05_JPRB/)  
KBO( :,41,16) = (/&
 & 1.7458E+05_JPRB,1.6635E+05_JPRB,1.5848E+05_JPRB,1.5090E+05_JPRB,1.4379E+05_JPRB/)  
KBO( :,42,16) = (/&
 & 1.7998E+05_JPRB,1.7152E+05_JPRB,1.6328E+05_JPRB,1.5532E+05_JPRB,1.4790E+05_JPRB/)  
KBO( :,43,16) = (/&
 & 1.8575E+05_JPRB,1.7689E+05_JPRB,1.6831E+05_JPRB,1.5999E+05_JPRB,1.5225E+05_JPRB/)  
KBO( :,44,16) = (/&
 & 1.9152E+05_JPRB,1.8231E+05_JPRB,1.7334E+05_JPRB,1.6472E+05_JPRB,1.5657E+05_JPRB/)  
KBO( :,45,16) = (/&
 & 1.9710E+05_JPRB,1.8756E+05_JPRB,1.7825E+05_JPRB,1.6934E+05_JPRB,1.6086E+05_JPRB/)  
KBO( :,46,16) = (/&
 & 2.0271E+05_JPRB,1.9287E+05_JPRB,1.8321E+05_JPRB,1.7404E+05_JPRB,1.6527E+05_JPRB/)  
KBO( :,47,16) = (/&
 & 2.0857E+05_JPRB,1.9849E+05_JPRB,1.8848E+05_JPRB,1.7903E+05_JPRB,1.6997E+05_JPRB/)  
KBO( :,48,16) = (/&
 & 2.1432E+05_JPRB,2.0416E+05_JPRB,1.9373E+05_JPRB,1.8395E+05_JPRB,1.7463E+05_JPRB/)  
KBO( :,49,16) = (/&
 & 2.1996E+05_JPRB,2.0961E+05_JPRB,1.9896E+05_JPRB,1.8885E+05_JPRB,1.7927E+05_JPRB/)  
KBO( :,50,16) = (/&
 & 2.2527E+05_JPRB,2.1474E+05_JPRB,2.0397E+05_JPRB,1.9350E+05_JPRB,1.8363E+05_JPRB/)  
KBO( :,51,16) = (/&
 & 2.3036E+05_JPRB,2.1969E+05_JPRB,2.0872E+05_JPRB,1.9800E+05_JPRB,1.8789E+05_JPRB/)  
KBO( :,52,16) = (/&
 & 2.3557E+05_JPRB,2.2457E+05_JPRB,2.1344E+05_JPRB,2.0248E+05_JPRB,1.9215E+05_JPRB/)  
KBO( :,53,16) = (/&
 & 2.4051E+05_JPRB,2.2942E+05_JPRB,2.1813E+05_JPRB,2.0698E+05_JPRB,1.9645E+05_JPRB/)  
KBO( :,54,16) = (/&
 & 2.4502E+05_JPRB,2.3386E+05_JPRB,2.2247E+05_JPRB,2.1113E+05_JPRB,2.0043E+05_JPRB/)  
KBO( :,55,16) = (/&
 & 2.4930E+05_JPRB,2.3811E+05_JPRB,2.2662E+05_JPRB,2.1524E+05_JPRB,2.0429E+05_JPRB/)  
KBO( :,56,16) = (/&
 & 2.5354E+05_JPRB,2.4234E+05_JPRB,2.3079E+05_JPRB,2.1928E+05_JPRB,2.0814E+05_JPRB/)  
KBO( :,57,16) = (/&
 & 2.5774E+05_JPRB,2.4654E+05_JPRB,2.3491E+05_JPRB,2.2331E+05_JPRB,2.1201E+05_JPRB/)  
KBO( :,58,16) = (/&
 & 2.6172E+05_JPRB,2.5053E+05_JPRB,2.3885E+05_JPRB,2.2717E+05_JPRB,2.1576E+05_JPRB/)  
KBO( :,59,16) = (/&
 & 2.6363E+05_JPRB,2.5242E+05_JPRB,2.4067E+05_JPRB,2.2890E+05_JPRB,2.1741E+05_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 1.84925E+00_JPRB,1.65087E+00_JPRB,1.47377E+00_JPRB,1.31567E+00_JPRB,1.17453E+00_JPRB,&
 & 1.04853E+00_JPRB,9.36042E-01_JPRB,8.35626E-01_JPRB,7.45982E-01_JPRB,6.65955E-01_JPRB/)  
SELFREFO( :, 2) = (/&
 & 5.91460E+00_JPRB,5.37056E+00_JPRB,4.87657E+00_JPRB,4.42802E+00_JPRB,4.02073E+00_JPRB,&
 & 3.65090E+00_JPRB,3.31508E+00_JPRB,3.01016E+00_JPRB,2.73328E+00_JPRB,2.48187E+00_JPRB/)  
SELFREFO( :, 3) = (/&
 & 6.37319E+00_JPRB,5.76807E+00_JPRB,5.22041E+00_JPRB,4.72475E+00_JPRB,4.27614E+00_JPRB,&
 & 3.87014E+00_JPRB,3.50268E+00_JPRB,3.17011E+00_JPRB,2.86911E+00_JPRB,2.59670E+00_JPRB/)  
SELFREFO( :, 4) = (/&
 & 6.24391E+00_JPRB,5.67335E+00_JPRB,5.15493E+00_JPRB,4.68388E+00_JPRB,4.25588E+00_JPRB,&
 & 3.86699E+00_JPRB,3.51363E+00_JPRB,3.19256E+00_JPRB,2.90083E+00_JPRB,2.63576E+00_JPRB/)  
SELFREFO( :, 5) = (/&
 & 6.28855E+00_JPRB,5.70697E+00_JPRB,5.17918E+00_JPRB,4.70019E+00_JPRB,4.26551E+00_JPRB,&
 & 3.87103E+00_JPRB,3.51303E+00_JPRB,3.18813E+00_JPRB,2.89329E+00_JPRB,2.62571E+00_JPRB/)  
SELFREFO( :, 6) = (/&
 & 6.15500E+00_JPRB,5.58229E+00_JPRB,5.06287E+00_JPRB,4.59178E+00_JPRB,4.16453E+00_JPRB,&
 & 3.77703E+00_JPRB,3.42558E+00_JPRB,3.10684E+00_JPRB,2.81776E+00_JPRB,2.55557E+00_JPRB/)  
SELFREFO( :, 7) = (/&
 & 6.25544E+00_JPRB,5.67036E+00_JPRB,5.14000E+00_JPRB,4.65925E+00_JPRB,4.22346E+00_JPRB,&
 & 3.82844E+00_JPRB,3.47036E+00_JPRB,3.14577E+00_JPRB,2.85154E+00_JPRB,2.58483E+00_JPRB/)  
SELFREFO( :, 8) = (/&
 & 6.08431E+00_JPRB,5.55653E+00_JPRB,5.07454E+00_JPRB,4.63436E+00_JPRB,4.23236E+00_JPRB,&
 & 3.86523E+00_JPRB,3.52994E+00_JPRB,3.22374E+00_JPRB,2.94410E+00_JPRB,2.68872E+00_JPRB/)  
SELFREFO( :, 9) = (/&
 & 6.22772E+00_JPRB,5.71381E+00_JPRB,5.24231E+00_JPRB,4.80972E+00_JPRB,4.41282E+00_JPRB,&
 & 4.04868E+00_JPRB,3.71458E+00_JPRB,3.40806E+00_JPRB,3.12683E+00_JPRB,2.86880E+00_JPRB/)  
SELFREFO( :,10) = (/&
 & 6.63397E+00_JPRB,6.10398E+00_JPRB,5.61633E+00_JPRB,5.16764E+00_JPRB,4.75480E+00_JPRB,&
 & 4.37494E+00_JPRB,4.02543E+00_JPRB,3.70384E+00_JPRB,3.40794E+00_JPRB,3.13568E+00_JPRB/)  
SELFREFO( :,11) = (/&
 & 7.05802E+00_JPRB,6.40896E+00_JPRB,5.81959E+00_JPRB,5.28442E+00_JPRB,4.79846E+00_JPRB,&
 & 4.35719E+00_JPRB,3.95651E+00_JPRB,3.59266E+00_JPRB,3.26228E+00_JPRB,2.96228E+00_JPRB/)  
SELFREFO( :,12) = (/&
 & 7.26302E+00_JPRB,6.57623E+00_JPRB,5.95438E+00_JPRB,5.39134E+00_JPRB,4.88153E+00_JPRB,&
 & 4.41994E+00_JPRB,4.00199E+00_JPRB,3.62356E+00_JPRB,3.28092E+00_JPRB,2.97067E+00_JPRB/)  
SELFREFO( :,13) = (/&
 & 6.76462E+00_JPRB,6.23813E+00_JPRB,5.75262E+00_JPRB,5.30490E+00_JPRB,4.89202E+00_JPRB,&
 & 4.51128E+00_JPRB,4.16017E+00_JPRB,3.83638E+00_JPRB,3.53780E+00_JPRB,3.26245E+00_JPRB/)  
SELFREFO( :,14) = (/&
 & 7.35977E+00_JPRB,6.71848E+00_JPRB,6.13306E+00_JPRB,5.59866E+00_JPRB,5.11082E+00_JPRB,&
 & 4.66549E+00_JPRB,4.25896E+00_JPRB,3.88786E+00_JPRB,3.54909E+00_JPRB,3.23984E+00_JPRB/)  
SELFREFO( :,15) = (/&
 & 7.51978E+00_JPRB,6.83155E+00_JPRB,6.20632E+00_JPRB,5.63830E+00_JPRB,5.12227E+00_JPRB,&
 & 4.65347E+00_JPRB,4.22758E+00_JPRB,3.84066E+00_JPRB,3.48915E+00_JPRB,3.16982E+00_JPRB/)  
SELFREFO( :,16) = (/&
 & 6.95561E+00_JPRB,6.36239E+00_JPRB,5.81977E+00_JPRB,5.32342E+00_JPRB,4.86941E+00_JPRB,&
 & 4.45411E+00_JPRB,4.07424E+00_JPRB,3.72676E+00_JPRB,3.40892E+00_JPRB,3.11819E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB1:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


!     -----------------------------------------------------------------
END SUBROUTINE RRTM_KGB1
