! This module replaces grid/fxy_sin.h

MODULE fxy_sin_mod_h
  USE comconst_mod, ONLY: pi
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  IMPLICIT NONE; PRIVATE
  PUBLIC fx, fxprim, fy, fyprim

CONTAINS

  REAL FUNCTION fx(ri)
    REAL, INTENT(IN) :: ri
    fx = 2. * pi / REAL(iim) * (ri - 0.5 * REAL(iim) - 1.)
  END FUNCTION fx

  REAL FUNCTION fxprim(ri)
    REAL, INTENT(IN) :: ri
    fxprim = 2. * pi / REAL(iim)
  END FUNCTION fxprim

  REAL FUNCTION fy(rj)
    REAL, INTENT(IN) :: rj
    fy = ASIN(1. + 2. * ((1. - rj) / REAL(jjm)))
  END FUNCTION fy

  REAL FUNCTION fyprim(rj)
    REAL, INTENT(IN) :: rj
    fyprim = 1. / SQRT((rj - 1.) * (jjm + 1. - rj))
  END FUNCTION fyprim
END MODULE fxy_sin_mod_h