! This file has been modified for the use in ICON

SUBROUTINE SURRTRF

!     Adapted from Eli J. Mlawer, Atmospheric & Environmental Research.
!     by JJMorcrette, ECMWF
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK, DR_HOOK, JPHOOK

USE YOERRTRF , ONLY : PREF      ,PREFLOG   ,TREF,CHI_MLS

!     ------------------------------------------------------------------

!     These pressures are chosen such that the ln of the first pressure
!     has only a few non-zero digits (i.e. ln(PREF(1)) = 6.96000) and
!     each subsequent ln(pressure) differs from the previous one by 0.2.

IMPLICIT NONE
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SURRTRF',0,ZHOOK_HANDLE)
PREF( :) = (/&
 & 1.05363E+03_JPRB,8.62642E+02_JPRB,7.06272E+02_JPRB,5.78246E+02_JPRB,4.73428E+02_JPRB,&
 & 3.87610E+02_JPRB,3.17348E+02_JPRB,2.59823E+02_JPRB,2.12725E+02_JPRB,1.74164E+02_JPRB,&
 & 1.42594E+02_JPRB,1.16746E+02_JPRB,9.55835E+01_JPRB,7.82571E+01_JPRB,6.40715E+01_JPRB,&
 & 5.24573E+01_JPRB,4.29484E+01_JPRB,3.51632E+01_JPRB,2.87892E+01_JPRB,2.35706E+01_JPRB,&
 & 1.92980E+01_JPRB,1.57998E+01_JPRB,1.29358E+01_JPRB,1.05910E+01_JPRB,8.67114E+00_JPRB,&
 & 7.09933E+00_JPRB,5.81244E+00_JPRB,4.75882E+00_JPRB,3.89619E+00_JPRB,3.18993E+00_JPRB,&
 & 2.61170E+00_JPRB,2.13828E+00_JPRB,1.75067E+00_JPRB,1.43333E+00_JPRB,1.17351E+00_JPRB,&
 & 9.60789E-01_JPRB,7.86628E-01_JPRB,6.44036E-01_JPRB,5.27292E-01_JPRB,4.31710E-01_JPRB,&
 & 3.53455E-01_JPRB,2.89384E-01_JPRB,2.36928E-01_JPRB,1.93980E-01_JPRB,1.58817E-01_JPRB,&
 & 1.30029E-01_JPRB,1.06458E-01_JPRB,8.71608E-02_JPRB,7.13612E-02_JPRB,5.84256E-02_JPRB,&
 & 4.78349E-02_JPRB,3.91639E-02_JPRB,3.20647E-02_JPRB,2.62523E-02_JPRB,2.14936E-02_JPRB,&
 & 1.75975E-02_JPRB,1.44076E-02_JPRB,1.17959E-02_JPRB,9.65769E-03_JPRB/)  

PREFLOG( :) = (/&
 & 6.9600E+00_JPRB, 6.7600E+00_JPRB, 6.5600E+00_JPRB, 6.3600E+00_JPRB, 6.1600E+00_JPRB,&
 & 5.9600E+00_JPRB, 5.7600E+00_JPRB, 5.5600E+00_JPRB, 5.3600E+00_JPRB, 5.1600E+00_JPRB,&
 & 4.9600E+00_JPRB, 4.7600E+00_JPRB, 4.5600E+00_JPRB, 4.3600E+00_JPRB, 4.1600E+00_JPRB,&
 & 3.9600E+00_JPRB, 3.7600E+00_JPRB, 3.5600E+00_JPRB, 3.3600E+00_JPRB, 3.1600E+00_JPRB,&
 & 2.9600E+00_JPRB, 2.7600E+00_JPRB, 2.5600E+00_JPRB, 2.3600E+00_JPRB, 2.1600E+00_JPRB,&
 & 1.9600E+00_JPRB, 1.7600E+00_JPRB, 1.5600E+00_JPRB, 1.3600E+00_JPRB, 1.1600E+00_JPRB,&
 & 9.6000E-01_JPRB, 7.6000E-01_JPRB, 5.6000E-01_JPRB, 3.6000E-01_JPRB, 1.6000E-01_JPRB,&
 & -4.0000E-02_JPRB,-2.4000E-01_JPRB,-4.4000E-01_JPRB,-6.4000E-01_JPRB,-8.4000E-01_JPRB,&
 & -1.0400E+00_JPRB,-1.2400E+00_JPRB,-1.4400E+00_JPRB,-1.6400E+00_JPRB,-1.8400E+00_JPRB,&
 & -2.0400E+00_JPRB,-2.2400E+00_JPRB,-2.4400E+00_JPRB,-2.6400E+00_JPRB,-2.8400E+00_JPRB,&
 & -3.0400E+00_JPRB,-3.2400E+00_JPRB,-3.4400E+00_JPRB,-3.6400E+00_JPRB,-3.8400E+00_JPRB,&
 & -4.0400E+00_JPRB,-4.2400E+00_JPRB,-4.4400E+00_JPRB,-4.6400E+00_JPRB/)  

!     These are the temperatures associated with the respective 
!     pressures for the MLS standard atmosphere. 
TREF( :) = (/&
 & 2.9420E+02_JPRB, 2.8799E+02_JPRB, 2.7894E+02_JPRB, 2.6925E+02_JPRB, 2.5983E+02_JPRB,&
 & 2.5017E+02_JPRB, 2.4077E+02_JPRB, 2.3179E+02_JPRB, 2.2306E+02_JPRB, 2.1578E+02_JPRB,&
 & 2.1570E+02_JPRB, 2.1570E+02_JPRB, 2.1570E+02_JPRB, 2.1706E+02_JPRB, 2.1858E+02_JPRB,&
 & 2.2018E+02_JPRB, 2.2174E+02_JPRB, 2.2328E+02_JPRB, 2.2479E+02_JPRB, 2.2655E+02_JPRB,&
 & 2.2834E+02_JPRB, 2.3113E+02_JPRB, 2.3401E+02_JPRB, 2.3703E+02_JPRB, 2.4022E+02_JPRB,&
 & 2.4371E+02_JPRB, 2.4726E+02_JPRB, 2.5085E+02_JPRB, 2.5457E+02_JPRB, 2.5832E+02_JPRB,&
 & 2.6216E+02_JPRB, 2.6606E+02_JPRB, 2.6999E+02_JPRB, 2.7340E+02_JPRB, 2.7536E+02_JPRB,&
 & 2.7568E+02_JPRB, 2.7372E+02_JPRB, 2.7163E+02_JPRB, 2.6955E+02_JPRB, 2.6593E+02_JPRB,&
 & 2.6211E+02_JPRB, 2.5828E+02_JPRB, 2.5360E+02_JPRB, 2.4854E+02_JPRB, 2.4348E+02_JPRB,&
 & 2.3809E+02_JPRB, 2.3206E+02_JPRB, 2.2603E+02_JPRB, 2.2000E+02_JPRB, 2.1435E+02_JPRB,&
 & 2.0887E+02_JPRB, 2.0340E+02_JPRB, 1.9792E+02_JPRB, 1.9290E+02_JPRB, 1.8809E+02_JPRB,&
 & 1.8329E+02_JPRB, 1.7849E+02_JPRB, 1.7394E+02_JPRB, 1.7212E+02_JPRB/)  

  CHI_MLS(1,1:12) = (/ &
     &  1.8760E-02_JPRB, 1.2223E-02_JPRB, 5.8909E-03_JPRB, 2.7675E-03_JPRB, 1.4065E-03_JPRB, &
     &  7.5970E-04_JPRB, 3.8876E-04_JPRB, 1.6542E-04_JPRB, 3.7190E-05_JPRB, 7.4765E-06_JPRB, &
     &  4.3082E-06_JPRB, 3.3319E-06_JPRB/)
  CHI_MLS(1,13:59) = (/ &
     &  3.2039E-06_JPRB,  3.1619E-06_JPRB,  3.2524E-06_JPRB,  3.4226E-06_JPRB,  3.6288E-06_JPRB, &
     &  3.9148E-06_JPRB,  4.1488E-06_JPRB,  4.3081E-06_JPRB,  4.4420E-06_JPRB,  4.5778E-06_JPRB, &
     &  4.7087E-06_JPRB,  4.7943E-06_JPRB,  4.8697E-06_JPRB,  4.9260E-06_JPRB,  4.9669E-06_JPRB, &
     &  4.9963E-06_JPRB,  5.0527E-06_JPRB,  5.1266E-06_JPRB,  5.2503E-06_JPRB,  5.3571E-06_JPRB, &
     &  5.4509E-06_JPRB,  5.4830E-06_JPRB,  5.5000E-06_JPRB,  5.5000E-06_JPRB,  5.4536E-06_JPRB, &
     &  5.4047E-06_JPRB,  5.3558E-06_JPRB,  5.2533E-06_JPRB,  5.1436E-06_JPRB,  5.0340E-06_JPRB, &
     &  4.8766E-06_JPRB,  4.6979E-06_JPRB,  4.5191E-06_JPRB,  4.3360E-06_JPRB,  4.1442E-06_JPRB, &
     &  3.9523E-06_JPRB,  3.7605E-06_JPRB,  3.5722E-06_JPRB,  3.3855E-06_JPRB,  3.1988E-06_JPRB, &
     &  3.0121E-06_JPRB,  2.8262E-06_JPRB,  2.6407E-06_JPRB,  2.4552E-06_JPRB,  2.2696E-06_JPRB, &
     &  4.3360E-06_JPRB,  4.1442E-06_JPRB/)
  CHI_MLS(2,1:12) = (/ &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB/)
  CHI_MLS(2,13:59) = (/ &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB,  3.5500E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5471E-04_JPRB,  3.5427E-04_JPRB,  3.5384E-04_JPRB,  3.5340E-04_JPRB, &
     &  3.5500E-04_JPRB,  3.5500E-04_JPRB/)
  CHI_MLS(3,1:12) = (/ &
     &  3.0170E-08_JPRB,  3.4725E-08_JPRB,  4.2477E-08_JPRB,  5.2759E-08_JPRB,  6.6944E-08_JPRB, &
     &  8.7130E-08_JPRB,  1.1391E-07_JPRB,  1.5677E-07_JPRB,  2.1788E-07_JPRB,  3.2443E-07_JPRB, &
     &  4.6594E-07_JPRB,  5.6806E-07_JPRB/)
  CHI_MLS(3,13:59) = (/ &
     &  6.9607E-07_JPRB,  1.1186E-06_JPRB,  1.7618E-06_JPRB,  2.3269E-06_JPRB,  2.9577E-06_JPRB, &
     &  3.6593E-06_JPRB,  4.5950E-06_JPRB,  5.3189E-06_JPRB,  5.9618E-06_JPRB,  6.5113E-06_JPRB, &
     &  7.0635E-06_JPRB,  7.6917E-06_JPRB,  8.2577E-06_JPRB,  8.7082E-06_JPRB,  8.8325E-06_JPRB, &
     &  8.7149E-06_JPRB,  8.0943E-06_JPRB,  7.3307E-06_JPRB,  6.3101E-06_JPRB,  5.3672E-06_JPRB, &
     &  4.4829E-06_JPRB,  3.8391E-06_JPRB,  3.2827E-06_JPRB,  2.8235E-06_JPRB,  2.4906E-06_JPRB, &
     &  2.1645E-06_JPRB,  1.8385E-06_JPRB,  1.6618E-06_JPRB,  1.5052E-06_JPRB,  1.3485E-06_JPRB, &
     &  1.1972E-06_JPRB,  1.0482E-06_JPRB,  8.9926E-07_JPRB,  7.6343E-07_JPRB,  6.5381E-07_JPRB, &
     &  5.4419E-07_JPRB,  4.3456E-07_JPRB,  3.6421E-07_JPRB,  3.1194E-07_JPRB,  2.5967E-07_JPRB, &
     &  2.0740E-07_JPRB,  1.9146E-07_JPRB,  1.9364E-07_JPRB,  1.9582E-07_JPRB,  1.9800E-07_JPRB, &
     &  7.6343E-07_JPRB,  6.5381E-07_JPRB/)
  CHI_MLS(4,1:12) = (/ &
     &  3.2000E-07_JPRB,  3.2000E-07_JPRB,  3.2000E-07_JPRB,  3.2000E-07_JPRB,  3.2000E-07_JPRB, &
     &  3.1965E-07_JPRB,  3.1532E-07_JPRB,  3.0383E-07_JPRB,  2.9422E-07_JPRB,  2.8495E-07_JPRB, &
     &  2.7671E-07_JPRB,  2.6471E-07_JPRB/)
  CHI_MLS(4,13:59) = (/ &
     &  2.4285E-07_JPRB,  2.0955E-07_JPRB,  1.7195E-07_JPRB,  1.3749E-07_JPRB,  1.1332E-07_JPRB, &
     &  1.0035E-07_JPRB,  9.1281E-08_JPRB,  8.5463E-08_JPRB,  8.0363E-08_JPRB,  7.3372E-08_JPRB, &
     &  6.5975E-08_JPRB,  5.6039E-08_JPRB,  4.7090E-08_JPRB,  3.9977E-08_JPRB,  3.2979E-08_JPRB, &
     &  2.6064E-08_JPRB,  2.1066E-08_JPRB,  1.6592E-08_JPRB,  1.3017E-08_JPRB,  1.0090E-08_JPRB, &
     &  7.6249E-09_JPRB,  6.1159E-09_JPRB,  4.6672E-09_JPRB,  3.2857E-09_JPRB,  2.8484E-09_JPRB, &
     &  2.4620E-09_JPRB,  2.0756E-09_JPRB,  1.8551E-09_JPRB,  1.6568E-09_JPRB,  1.4584E-09_JPRB, &
     &  1.3195E-09_JPRB,  1.2072E-09_JPRB,  1.0948E-09_JPRB,  9.9780E-10_JPRB,  9.3126E-10_JPRB, &
     &  8.6472E-10_JPRB,  7.9818E-10_JPRB,  7.5138E-10_JPRB,  7.1367E-10_JPRB,  6.7596E-10_JPRB, &
     &  6.3825E-10_JPRB,  6.0981E-10_JPRB,  5.8600E-10_JPRB,  5.6218E-10_JPRB,  5.3837E-10_JPRB, &
     &  9.9780E-10_JPRB,  9.3126E-10_JPRB/)
  CHI_MLS(5,1:12) = (/ &
     &  1.5000E-07_JPRB,  1.4306E-07_JPRB,  1.3474E-07_JPRB,  1.3061E-07_JPRB,  1.2793E-07_JPRB, &
     &  1.2038E-07_JPRB,  1.0798E-07_JPRB,  9.4238E-08_JPRB,  7.9488E-08_JPRB,  6.1386E-08_JPRB, &
     &  4.5563E-08_JPRB,  3.3475E-08_JPRB/)
  CHI_MLS(5,13:59) = (/ &
     &  2.5118E-08_JPRB,  1.8671E-08_JPRB,  1.4349E-08_JPRB,  1.2501E-08_JPRB,  1.2407E-08_JPRB, &
     &  1.3472E-08_JPRB,  1.4900E-08_JPRB,  1.6079E-08_JPRB,  1.7156E-08_JPRB,  1.8616E-08_JPRB, &
     &  2.0106E-08_JPRB,  2.1654E-08_JPRB,  2.3096E-08_JPRB,  2.4340E-08_JPRB,  2.5643E-08_JPRB, &
     &  2.6990E-08_JPRB,  2.8456E-08_JPRB,  2.9854E-08_JPRB,  3.0943E-08_JPRB,  3.2023E-08_JPRB, &
     &  3.3101E-08_JPRB,  3.4260E-08_JPRB,  3.5360E-08_JPRB,  3.6397E-08_JPRB,  3.7310E-08_JPRB, &
     &  3.8217E-08_JPRB,  3.9123E-08_JPRB,  4.1303E-08_JPRB,  4.3652E-08_JPRB,  4.6002E-08_JPRB, &
     &  5.0289E-08_JPRB,  5.5446E-08_JPRB,  6.0603E-08_JPRB,  6.8946E-08_JPRB,  8.3652E-08_JPRB, &
     &  9.8357E-08_JPRB,  1.1306E-07_JPRB,  1.4766E-07_JPRB,  1.9142E-07_JPRB,  2.3518E-07_JPRB, &
     &  2.7894E-07_JPRB,  3.5001E-07_JPRB,  4.3469E-07_JPRB,  5.1938E-07_JPRB,  6.0407E-07_JPRB, &
     &  6.8946E-08_JPRB,  8.3652E-08_JPRB/)
  CHI_MLS(6,1:12) = (/ &
     &  1.7000E-06_JPRB,  1.7000E-06_JPRB,  1.6999E-06_JPRB,  1.6904E-06_JPRB,  1.6671E-06_JPRB, &
     &  1.6351E-06_JPRB,  1.6098E-06_JPRB,  1.5590E-06_JPRB,  1.5120E-06_JPRB,  1.4741E-06_JPRB, &
     &  1.4385E-06_JPRB,  1.4002E-06_JPRB/)
  CHI_MLS(6,13:59) = (/ &
     &  1.3573E-06_JPRB,  1.3130E-06_JPRB,  1.2512E-06_JPRB,  1.1668E-06_JPRB,  1.0553E-06_JPRB, &
     &  9.3281E-07_JPRB,  8.1217E-07_JPRB,  7.5239E-07_JPRB,  7.0728E-07_JPRB,  6.6722E-07_JPRB, &
     &  6.2733E-07_JPRB,  5.8604E-07_JPRB,  5.4769E-07_JPRB,  5.1480E-07_JPRB,  4.8206E-07_JPRB, &
     &  4.4943E-07_JPRB,  4.1702E-07_JPRB,  3.8460E-07_JPRB,  3.5200E-07_JPRB,  3.1926E-07_JPRB, &
     &  2.8646E-07_JPRB,  2.5498E-07_JPRB,  2.2474E-07_JPRB,  1.9588E-07_JPRB,  1.8295E-07_JPRB, &
     &  1.7089E-07_JPRB,  1.5882E-07_JPRB,  1.5536E-07_JPRB,  1.5304E-07_JPRB,  1.5072E-07_JPRB, &
     &  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB, &
     &  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB, &
     &  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB,  1.5000E-07_JPRB, &
     &  1.5000E-07_JPRB,  1.5000E-07_JPRB/)
  CHI_MLS(7,1:12) = (/ &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB/)
  CHI_MLS(7,13:59) = (/ &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB,  0.2090_JPRB, &
     &  0.2090_JPRB,  0.2090_JPRB/)

  !$ACC UPDATE DEVICE(PREF, PREFLOG, TREF, CHI_MLS)

!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SURRTRF',1,ZHOOK_HANDLE)
END SUBROUTINE SURRTRF
