module fv_m

  implicit none

contains

  elemental real function fV(z, rain)

    ! H. Bellenger 2016

    real, intent(in):: z ! profondeur en m (z < 0)
    real, intent(in):: rain ! rain mass flux, in kg m-2 s-1

    ! Local:

    real dfV
    ! fraction of rain volume entering the ocean and deposited within depth "z"

    real rc, lbd, f0
    real z_mm

    ! Schlussel et al. 1997, Table 1:
    real, parameter:: zeta(14) = [0.0026091, 0.0022743, 0.0015406, 0.0012281, &
         0.0008795, 0.00077123, 0.00057451, 0.000438, 6.7228e-5, 6.4955e-5, &
         4.4234e-5, 3.3906e-5, 2.7433e-6, 4.0283e-7]
    real, parameter:: psi(14) = [0.60107, 0.29968, 0.5563, 1.80858, 0.2175, &
         0.33961, 0.96368, 0.65081, 0.5967, 2.7661, 2.2812, 2.7674, 2.6095, &
         6.5308]

    !---------------------------------------------------------------------

    if (rain > 0.) then
       rc = 0.4 ! mm
       z_mm = z * 1000. ! mm and <0
       lbd = 4.1 * (rain * 3600.)**(- 0.21) ! mm-1
       f0 = (1. + 2. * lbd * rc + 0.5 * (2. * lbd * rc)**2 &
            + 1. / 6. * (2. * lbd * rc)**3) * exp(- 1. * 2. * lbd * rc)
       dfv = sum(zeta * exp(- psi * lbd * abs(z_mm) / 100.))
       fV = - dfV * abs(z_mm) + f0
    else
       fV = 0.
    endif

  end function fV

end module fv_m
