MODULE lmdz_cv_ini

  !------------------------------------------------------------
  ! Parameters for convectL, iflag_con=3:
  ! (includes - microphysical parameters,
  !            - parameters that control the rate of approach
  !               to quasi-equilibrium)
  !            - noff & minorig (previously in input of convect1)
  !------------------------------------------------------------
  IMPLICIT NONE; PRIVATE
  PUBLIC :: sigdz, spfac, pbcrit, ptcrit, elcrit, tlcrit, coef_peel, omtrain, dtovsh, dpbase, &
          dttrig, dtcrit, tau, beta, alpha, alpha1, T_top_max, tau_stop, noconv_stop, wbmax, &
          delta, betad, ejectliq, ejectice, flag_wb, flag_epKEorig, cv_flag_feed, noff, minorig, &
          nl, nlp, nlm
  PUBLIC :: cpd, cpv, cl, ci, rrv, rrd, lv0, lf0, g, rowl, t0, clmcpv, clmcpd, cpdmcp, cpvmcpd, cpvmcl,  &
          clmci, eps, epsi, epsim1, ginv, hrd, grav, keep_bug_indices_cv3_tracer, restore_bug_cvdn

  PUBLIC :: retv,rtt,r ! From ymocst_mod_h

PUBLIC :: cv3_param, cv_param, cv_flag, cv_thermo ! Provisoire Replayisation. A retirer . Elles doivent devenir internes
PUBLIC :: cv_ini



  ! provenant de cvparam
  PUBLIC :: entp, sigs,sigd, omtsnow,coeffr, coeffs, dtmax, cu, damp


  INTEGER flag_epKEorig
  REAL flag_wb
  INTEGER cv_flag_feed
  INTEGER noff, minorig, nl, nlp, nlm
  REAL sigdz, spfac
  REAL pbcrit, ptcrit
  REAL elcrit, tlcrit
  REAL coef_peel
  REAL omtrain
  REAL dtovsh, dpbase, dttrig
  REAL dtcrit, tau, beta, alpha, alpha1
  REAL T_top_max
  REAL tau_stop, noconv_stop
  REAL wbmax
  REAL delta
  REAL betad
  REAL ejectliq
  REAL ejectice

  !$OMP THREADPRIVATE(sigdz, spfac, pbcrit, ptcrit, elcrit, tlcrit, coef_peel, omtrain, dtovsh, dpbase, &
  !$OMP      dttrig, dtcrit, tau, beta, alpha, alpha1, T_top_max, tau_stop, noconv_stop, wbmax, &
  !$OMP      delta, betad, ejectliq, ejectice, flag_wb, flag_epKEorig, cv_flag_feed, noff, minorig, &
  !$OMP      nl, nlp, nlm)

  ! Thermodynamical constants for convectL:
  REAL cpd, cpv, cl, ci, rrv, rrd, lv0, lf0, g, rowl, t0
  REAL clmcpv, clmcpd, cpdmcp, cpvmcpd, cpvmcl, clmci
  REAL eps, epsi, epsim1
  REAL ginv, hrd
  REAL grav

  !$OMP THREADPRIVATE(cpd, cpv, cl, ci, rrv, rrd, lv0, lf0, g, rowl, t0, clmcpv, clmcpd, cpdmcp, cpvmcpd, cpvmcl  &
  !$OMP      , clmci, eps, epsi, epsim1, ginv, hrd, grav)


   REAL retv,rtt,r
  !$OMP THREADPRIVATE(retv,rtt,r)

!==========================================================================================
  ! provenant de cvparam
!==========================================================================================
  ! provenant de cvparam
  real entp
  real sigs, sigd
  real omtsnow, coeffr, coeffs
  real dtmax
  real cu
  real damp

  !$OMP THREADPRIVATE( entp &
  !$OMP          , sigs, sigd &
  !$OMP          , omtsnow, coeffr, coeffs &
  !$OMP          , dtmax, cu, damp)

LOGICAL keep_bug_indices_cv3_tracer,restore_bug_cvdn
 !$OMP THREADPRIVATE( keep_bug_indices_cv3_tracer,restore_bug_cvdn)

!==========================================================================================
! Previously in cvflag_mod_h
!==========================================================================================
  PUBLIC :: icvflag_Tpa, cvflag_grav, cvflag_ice, ok_optim_yield, ok_entrain, ok_homo_tend, &
            ok_convstop, ok_intermittent, cvflag_prec_eject, qsat_depends_on_qt, adiab_ascent_mass_flux_depends_on_ejectliq, keepbug_ice_frac

  LOGICAL cvflag_grav
  LOGICAL cvflag_ice
  LOGICAL ok_optim_yield
  LOGICAL ok_entrain
  LOGICAL ok_homo_tend
  LOGICAL ok_convstop
  LOGICAL ok_intermittent
  LOGICAL cvflag_prec_eject
  LOGICAL qsat_depends_on_qt
  LOGICAL adiab_ascent_mass_flux_depends_on_ejectliq
  LOGICAL keepbug_ice_frac
  INTEGER icvflag_Tpa

  !$OMP THREADPRIVATE(icvflag_Tpa, cvflag_grav, cvflag_ice, ok_optim_yield, ok_entrain, ok_homo_tend, &
  !$OMP      ok_convstop, ok_intermittent, cvflag_prec_eject, qsat_depends_on_qt, adiab_ascent_mass_flux_depends_on_ejectliq, keepbug_ice_frac)

! Previously END MODULE cvflag_mod_h
!==========================================================================================
! Previously in MODULE conema3_mod_h
!==========================================================================================
  PUBLIC :: epmax, coef_epmax_cape, cvl_comp_threshold, cvl_sig2feed
  PUBLIC :: iflag_cvl_sigd, iflag_clw, ok_adj_ema

  REAL epmax             ! 0.993
  REAL coef_epmax_cape             ! 0.993
  REAL  cvl_comp_threshold     ! 0.
  LOGICAL ok_adj_ema      ! F
  INTEGER iflag_clw      ! 0
  INTEGER iflag_cvl_sigd
  REAL cvl_sig2feed      ! 0.97

  !$OMP THREADPRIVATE(epmax,coef_epmax_cape, cvl_comp_threshold, cvl_sig2feed)
  !$OMP THREADPRIVATE(iflag_cvl_sigd, iflag_clw, ok_adj_ema)

! From MODULE yomcst2_mod_h
PUBLIC :: gammas, alphas, betas, Fmax, scut, qqa1, qqa2, qqa3, Qcoef1max, &
         Qcoef2max, Supcrit1, Supcrit2, choice, iflag_mix, coef_clos_ls, iflag_mix_adiab

  INTEGER choice, iflag_mix, iflag_mix_adiab
  REAL  gammas, alphas, betas, Fmax, qqa1, qqa2, qqa3, scut
  REAL  Qcoef1max, Qcoef2max, Supcrit1, Supcrit2
  REAL coef_clos_ls

  !$OMP THREADPRIVATE(gammas, alphas, betas, Fmax, scut, qqa1, qqa2, qqa3, Qcoef1max, &
  !$OMP     Qcoef2max, Supcrit1, Supcrit2, choice, iflag_mix, coef_clos_ls, iflag_mix_adiab)

  PUBLIC :: fl_cor_ebil
  INTEGER  :: fl_cor_ebil
  !$OMP THREADPRIVATE(fl_cor_ebil)


  PUBLIC :: prt_level, lunout
  INTEGER  :: prt_level, lunout
  !$OMP THREADPRIVATE(prt_level, lunout)


CONTAINS


SUBROUTINE cv_ini(iflag_con_IN,iflag_ice_thermo_IN,rcpd_IN,rcpv_IN,rcw_IN,rv_IN,rcs_IN,rd_IN,rlvtt_IN,rlstt_IN,rg_IN,retv_IN,rtt_IN,r_IN,nd,k_upper,delt,fl_cor_ebil_IN,prt_level_IN, lunout_IN)
  

USE ioipsl_getin_p_mod, ONLY : getin_p

INTEGER, INTENT(IN)              :: nd,k_upper
REAL, INTENT(IN)              :: delt
  
  
  ! Argument : iflag_ice_thermo : ice thermodynamics is taken into account if
  ! iflag_ice_thermo >=1
integer, intent(in) :: iflag_con_IN,iflag_ice_thermo_IN
real, intent(in) :: rcpd_IN,rcpv_IN,rcw_IN,rv_IN,rcs_IN,rd_IN,rlvtt_IN,rlstt_IN,rg_IN
real, intent(in) :: retv_IN,rtt_IN,r_IN
integer, intent(in) :: prt_level_IN, lunout_IN,fl_cor_ebil_IN

    CALL cv_ini_previously_in_conf_phys
    CALL cv_thermo(iflag_con_IN,rcpd_IN,rcpv_IN,rcw_IN,rv_IN,rcs_IN,rd_IN,rlvtt_IN,rlstt_IN,rg_IN)
    retv=retv_IN
    rtt=rtt_IN
    r=r_IN
    fl_cor_ebil=fl_cor_ebil_IN
    prt_level=prt_level_IN
    lunout=lunout_IN

    IF ( iflag_con_IN==30 ) then ! Previously un cv_driver
        ! -- set simulation flags:
        CALL cv_flag(0)
        ! -- set thermodynamical constants:
    ELSE ! Previously in cva_driver_pre
        ! -- set simulation flags:
        CALL cv_flag(iflag_ice_thermo_IN)
        ! (common cvthermo)
    ENDIF

  ! -- set convect parameters

    ! -- set convect parameters

    ! includes microphysical parameters and parameters that
    ! control the rate of approach to quasi-equilibrium)
    ! (common cvparam)

    IF (iflag_con_IN==3) THEN
      CALL cv3_param(nd, k_upper, delt)
    ELSE IF (iflag_con_IN==4) THEN
      CALL cv_param(nd)
    ELSE IF (iflag_con_IN==30) THEN
      CALL cv30_param(nd, delt)
    ELSE
      print*,'iflag_con_IN=',iflag_con_IN,' non prevu' ; stop
    END IF

    !CALL cv3_routine_pre(ok_conserv_q)

END SUBROUTINE cv_ini

SUBROUTINE cv3_param(nd, k_upper, delt)

! Replayisation USE cvflag_mod_h
  USE ioipsl_getin_p_mod, ONLY : getin_p
! Replayisation USE conema3_mod_h
!   USE lmdz_cv_ini, ONLY : alpha,alpha1,beta,betad,coef_peel,cv_flag_feed,delta,dpbase,dtcrit,dtovsh,dttrig,ejectice,ejectliq,elcrit,flag_epkeorig,flag_wb,minorig,nl,nlm,nlp,noconv_stop,noff,omtrain,pbcrit,ptcrit,sigdz,spfac,t_top_max,tau,tau_stop,tlcrit,wbmax
!   USE lmdz_cv_ini, ONLY : keep_bug_indices_cv3_tracer,restore_bug_cvdn


  IMPLICIT NONE

!------------------------------------------------------------
!Set parameters for convectL for iflag_con = 3
!------------------------------------------------------------


!***  PBCRIT IS THE CRITICAL CLOUD DEPTH (MB) BENEATH WHICH THE ***
!***      PRECIPITATION EFFICIENCY IS ASSUMED TO BE ZERO     ***
!***  PTCRIT IS THE CLOUD DEPTH (MB) ABOVE WHICH THE PRECIP. ***
!***            EFFICIENCY IS ASSUMED TO BE UNITY            ***
!***  SIGD IS THE FRACTIONAL AREA COVERED BY UNSATURATED DNDRAFT  ***
!***  SPFAC IS THE FRACTION OF PRECIPITATION FALLING OUTSIDE ***
!***                        OF CLOUD                         ***

![TAU: CHARACTERISTIC TIMESCALE USED TO COMPUTE ALPHA & BETA]
!***    ALPHA AND BETA ARE PARAMETERS THAT CONTROL THE RATE OF ***
!***                 APPROACH TO QUASI-EQUILIBRIUM           ***
!***    (THEIR STANDARD VALUES ARE 1.0 AND 0.96, RESPECTIVELY) ***
!***           (BETA MUST BE LESS THAN OR EQUAL TO 1)        ***

!***    DTCRIT IS THE CRITICAL BUOYANCY (K) USED TO ADJUST THE ***
!***                 APPROACH TO QUASI-EQUILIBRIUM           ***
!***                     IT MUST BE LESS THAN 0              ***

  INTEGER, INTENT(IN)              :: nd
  INTEGER, INTENT(IN)              :: k_upper
  REAL, INTENT(IN)                 :: delt ! timestep (seconds)

! Local variables
  CHARACTER (LEN=20),PARAMETER :: modname = 'cv3_param'
  CHARACTER (LEN=80) :: abort_message

  LOGICAL, SAVE :: first = .TRUE.
!$OMP THREADPRIVATE(first)

!glb  noff: integer limit for convection (nd-noff)
! minorig: First level of convection

! -- limit levels for convection:

!jyg<
!  noff is chosen such that nl = k_upper so that upmost loops end at about 22 km
!
  write(lunout,*) 'cv3_param dans lmdz_cv_ini Replay post OK3'
  noff = min(max(nd-k_upper, 1), (nd+1)/2)
!!  noff = 1
!>jyg
  minorig = 1
  nl = nd - noff
  nlp = nl + 1
  nlm = nl - 1

  IF (first) THEN
! -- "microphysical" parameters:
! IM beg: ajout fis. reglage ep
! CR+JYG: shedding coefficient (used when iflag_mix_adiab=1)
! IM lu dans physiq.def via conf_phys.F90     epmax  = 0.993

    omtrain = 45.0 ! used also for snow (no disctinction rain/snow)
! -- misc:
    dtovsh = -0.2 ! dT for overshoot
! cc      dttrig = 5.   ! (loose) condition for triggering
    dttrig = 10. ! (loose) condition for triggering
    dtcrit = -2.0
! -- end of convection
! -- interface cloud parameterization:
    delta = 0.01 ! cld
! -- interface with boundary-layer (gust factor): (sb)
    betad = 10.0 ! original value (from convect 4.3)

    

! Var interm pour le getin
     cv_flag_feed=1
     CALL getin_p('cv_flag_feed',cv_flag_feed)
     T_top_max = 1000.
     CALL getin_p('t_top_max',T_top_max)
     dpbase=-40.
     CALL getin_p('dpbase',dpbase)
     pbcrit=150.0
     CALL getin_p('pbcrit',pbcrit)
     ptcrit=500.0
     CALL getin_p('ptcrit',ptcrit)
     sigdz=0.01
     CALL getin_p('sigdz',sigdz)
     spfac=0.15
     CALL getin_p('spfac',spfac)
     tau=8000.
     CALL getin_p('tau',tau)
     flag_wb=1
     CALL getin_p('flag_wb',flag_wb)
     wbmax=6.
     CALL getin_p('wbmax',wbmax)
     ok_convstop=.False.
     CALL getin_p('ok_convstop',ok_convstop)
     tau_stop=15000.
     CALL getin_p('tau_stop',tau_stop)
     ok_intermittent=.False.
     CALL getin_p('ok_intermittent',ok_intermittent)
     ok_optim_yield=.False.
     CALL getin_p('ok_optim_yield',ok_optim_yield)
     ok_homo_tend=.TRUE.
     CALL getin_p('ok_homo_tend',ok_homo_tend)
     ok_entrain=.TRUE.
     CALL getin_p('ok_entrain',ok_entrain)

     coef_peel=0.25
     CALL getin_p('coef_peel',coef_peel)

     flag_epKEorig=1
     CALL getin_p('flag_epKEorig',flag_epKEorig)
     elcrit=0.0003
     CALL getin_p('elcrit',elcrit)
     tlcrit=-55.0
     CALL getin_p('tlcrit',tlcrit)
     ejectliq=0.
     CALL getin_p('ejectliq',ejectliq)
     ejectice=0.
     CALL getin_p('ejectice',ejectice)
     cvflag_prec_eject = .FALSE.
     CALL getin_p('cvflag_prec_eject',cvflag_prec_eject)
     qsat_depends_on_qt = .FALSE.
     CALL getin_p('qsat_depends_on_qt',qsat_depends_on_qt)
     adiab_ascent_mass_flux_depends_on_ejectliq = .FALSE.
     CALL getin_p('adiab_ascent_mass_flux_depends_on_ejectliq',adiab_ascent_mass_flux_depends_on_ejectliq)
     keepbug_ice_frac = .TRUE.
     CALL getin_p('keepbug_ice_frac', keepbug_ice_frac)
     keep_bug_indices_cv3_tracer = .FALSE.
     CALL getin_p('keep_bug_indices_cv3_tracer', keep_bug_indices_cv3_tracer)
     restore_bug_cvdn=.false.
     CALL getin_p('restore_bug_cvdn',restore_bug_cvdn)


    WRITE (*, *) 't_top_max=', t_top_max
    WRITE (*, *) 'dpbase=', dpbase
    WRITE (*, *) 'pbcrit=', pbcrit
    WRITE (*, *) 'ptcrit=', ptcrit
    WRITE (*, *) 'sigdz=', sigdz
    WRITE (*, *) 'spfac=', spfac
    WRITE (*, *) 'tau=', tau
    WRITE (*, *) 'flag_wb=', flag_wb
    WRITE (*, *) 'wbmax=', wbmax
    WRITE (*, *) 'ok_convstop=', ok_convstop
    WRITE (*, *) 'tau_stop=', tau_stop
    WRITE (*, *) 'ok_intermittent=', ok_intermittent
    WRITE (*, *) 'ok_optim_yield =', ok_optim_yield
    WRITE (*, *) 'coef_peel=', coef_peel

    WRITE (*, *) 'flag_epKEorig=', flag_epKEorig
    WRITE (*, *) 'elcrit=', elcrit
    WRITE (*, *) 'tlcrit=', tlcrit
    WRITE (*, *) 'ejectliq=', ejectliq
    WRITE (*, *) 'ejectice=', ejectice
    WRITE (*, *) 'cvflag_prec_eject =', cvflag_prec_eject 
    WRITE (*, *) 'qsat_depends_on_qt =', qsat_depends_on_qt 
    WRITE (*, *) 'adiab_ascent_mass_flux_depends_on_ejectliq =', adiab_ascent_mass_flux_depends_on_ejectliq
    WRITE (*, *) 'keepbug_ice_frac =', keepbug_ice_frac 
    WRITE (*, *) 'keep_bug_indices_cv3_tracer =', keep_bug_indices_cv3_tracer 
    WRITE (*, *) 'restore_bug_cvdn=',restore_bug_cvdn

    first = .FALSE.
  END IF ! (first)

  beta = 1.0 - delt/tau
  alpha1 = 1.5E-3
!JYG    Correction bug alpha
  alpha1 = alpha1*1.5
  alpha = alpha1*delt/tau
!JYG    Bug
! cc increase alpha to compensate W decrease:
! c      alpha  = alpha*1.5

  noconv_stop = max(2.,tau_stop/delt)

  RETURN
END SUBROUTINE cv3_param

SUBROUTINE cv_param(nd)
  !USE lmdz_cv_ini, ONLY : alpha,betad,coeffr,coeffs,cu,damp,delta,dtmax,elcrit,entp,minorig,nl,nlm,nlp,noff,omtrain,omtsnow,sigd,sigs,tlcrit

  IMPLICIT NONE

  ! ------------------------------------------------------------
  ! Set parameters for convectL
  ! (includes microphysical parameters and parameters that
  ! control the rate of approach to quasi-equilibrium)
  ! ------------------------------------------------------------

  ! *** ELCRIT IS THE AUTOCONVERSION THERSHOLD WATER CONTENT (gm/gm) ***
  ! ***  TLCRIT IS CRITICAL TEMPERATURE BELOW WHICH THE AUTO-        ***
  ! ***       CONVERSION THRESHOLD IS ASSUMED TO BE ZERO             ***
  ! ***     (THE AUTOCONVERSION THRESHOLD VARIES LINEARLY            ***
  ! ***               BETWEEN 0 C AND TLCRIT)                        ***
  ! ***   ENTP IS THE COEFFICIENT OF MIXING IN THE ENTRAINMENT       ***
  ! ***                       FORMULATION                            ***
  ! ***  SIGD IS THE FRACTIONAL AREA COVERED BY UNSATURATED DNDRAFT  ***
  ! ***  SIGS IS THE FRACTION OF PRECIPITATION FALLING OUTSIDE       ***
  ! ***                        OF CLOUD                              ***
  ! ***        OMTRAIN IS THE ASSUMED FALL SPEED (P/s) OF RAIN       ***
  ! ***     OMTSNOW IS THE ASSUMED FALL SPEED (P/s) OF SNOW          ***
  ! ***  COEFFR IS A COEFFICIENT GOVERNING THE RATE OF EVAPORATION   ***
  ! ***                          OF RAIN                             ***
  ! ***  COEFFS IS A COEFFICIENT GOVERNING THE RATE OF EVAPORATION   ***
  ! ***                          OF SNOW                             ***
  ! ***     CU IS THE COEFFICIENT GOVERNING CONVECTIVE MOMENTUM      ***
  ! ***                         TRANSPORT                            ***
  ! ***    DTMAX IS THE MAXIMUM NEGATIVE TEMPERATURE PERTURBATION    ***
  ! ***        A LIFTED PARCEL IS ALLOWED TO HAVE BELOW ITS LFC      ***
  ! ***    ALPHA AND DAMP ARE PARAMETERS THAT CONTROL THE RATE OF    ***
  ! ***                 APPROACH TO QUASI-EQUILIBRIUM                ***
  ! ***   (THEIR STANDARD VALUES ARE  0.20 AND 0.1, RESPECTIVELY)    ***
  ! ***                   (DAMP MUST BE LESS THAN 1)                 ***

  INTEGER nd
  CHARACTER (LEN=20) :: modname = 'cv_routines'
  CHARACTER (LEN=80) :: abort_message

  ! noff: integer limit for convection (nd-noff)
  ! minorig: First level of convection

  write(lunout,*) 'cv_param dans lmdz_cv_ini Replay post OK3'
  noff = 2
  minorig = 2

  nl = nd - noff
  nlp = nl + 1
  nlm = nl - 1

  elcrit = 0.0011
  tlcrit = -55.0
  entp = 1.5
  sigs = 0.12
  sigd = 0.05
  omtrain = 50.0
  omtsnow = 5.5
  coeffr = 1.0
  coeffs = 0.8
  dtmax = 0.9

  cu = 0.70

  betad = 10.0

  damp = 0.1
  alpha = 0.2

  delta = 0.01 ! cld

  RETURN
END SUBROUTINE cv_param
  SUBROUTINE cv30_param(nd, delt)
! Replayisation USE conema3_mod_h

    IMPLICIT NONE

    ! ------------------------------------------------------------
    ! Set parameters for convectL for iflag_con = 3
    ! ------------------------------------------------------------


    ! ***  PBCRIT IS THE CRITICAL CLOUD DEPTH (MB) BENEATH WHICH THE ***
    ! ***      PRECIPITATION EFFICIENCY IS ASSUMED TO BE ZERO     ***
    ! ***  PTCRIT IS THE CLOUD DEPTH (MB) ABOVE WHICH THE PRECIP. ***
    ! ***            EFFICIENCY IS ASSUMED TO BE UNITY            ***
    ! ***  SIGD IS THE FRACTIONAL AREA COVERED BY UNSATURATED DNDRAFT  ***
    ! ***  SPFAC IS THE FRACTION OF PRECIPITATION FALLING OUTSIDE ***
    ! ***                        OF CLOUD                         ***

    ! [TAU: CHARACTERISTIC TIMESCALE USED TO COMPUTE ALPHA & BETA]
    ! ***    ALPHA AND BETA ARE PARAMETERS THAT CONTROL THE RATE OF ***
    ! ***                 APPROACH TO QUASI-EQUILIBRIUM           ***
    ! ***    (THEIR STANDARD VALUES ARE 1.0 AND 0.96, RESPECTIVELY) ***
    ! ***           (BETA MUST BE LESS THAN OR EQUAL TO 1)        ***

    ! ***    DTCRIT IS THE CRITICAL BUOYANCY (K) USED TO ADJUST THE ***
    ! ***                 APPROACH TO QUASI-EQUILIBRIUM           ***
    ! ***                     IT MUST BE LESS THAN 0              ***

    INTEGER nd
    REAL delt ! timestep (seconds)

    ! noff: integer limit for convection (nd-noff)
    ! minorig: First level of convection

    ! -- limit levels for convection:

    noff = 1
    minorig = 1
    nl = nd - noff
    nlp = nl + 1
    nlm = nl - 1

    ! -- "microphysical" parameters:

    sigd = 0.01
    spfac = 0.15
    pbcrit = 150.0
    ptcrit = 500.0
    ! IM cf. FH     epmax  = 0.993

    omtrain = 45.0 ! used also for snow (no disctinction rain/snow)

    ! -- misc:

    dtovsh = -0.2 ! dT for overshoot
    dpbase = -40. ! definition cloud base (400m above LCL)
    dttrig = 5. ! (loose) condition for triggering

    ! -- rate of approach to quasi-equilibrium:

    dtcrit = -2.0
    tau = 8000.
    beta = 1.0 - delt / tau
    alpha = 1.5E-3 * delt / tau
    ! increase alpha to compensate W decrease:
    alpha = alpha * 1.5

    ! -- interface cloud parameterization:

    delta = 0.01 ! cld

    ! -- interface with boundary-layer (gust factor): (sb)

    betad = 10.0 ! original value (from convect 4.3)

  END SUBROUTINE cv30_param



! ==================================================================
SUBROUTINE cv_flag(iflag_ice_thermo)

! Replayisation USE cvflag_mod_h
!  USE lmdz_cv_ini, ONLY : cvflag_grav, cvflag_ice, icvflag_Tpa
  USE ioipsl_getin_p_mod, ONLY : getin_p

  IMPLICIT NONE

  ! Argument : iflag_ice_thermo : ice thermodynamics is taken into account if
  ! iflag_ice_thermo >=1
  INTEGER iflag_ice_thermo


  ! -- si .TRUE., on rend la gravite plus explicite et eventuellement
  ! differente de 10.0 dans convect3:
  cvflag_grav = .TRUE.
  cvflag_ice = iflag_ice_thermo >= 1
  !
! si icvflag_Tpa=0, alors la fraction de glace dans l'ascendance adiabatique est
  ! fonction de la temperature de l'environnement et la temperature de l'ascendance est
  ! calculee en deux it�rations, une en supposant qu'il n'y a pas de glace et l'autre
  ! en ajoutant la glace (ancien sch�ma d'Arnaud Jam).
! si icvflag_Tpa=1, alors la fraction de glace dans l'ascendance adiabatique est
  ! fonction de la temperature de l'environnement et la temperature de l'ascendance est
  ! calculee en une seule iteration.
! si icvflag_Tpa=2, alors la fraction de glace dans l'ascendance adiabatique est
  ! fonction de la temperature de l'ascendance et la temperature de l'ascendance est
  ! calculee en une seule iteration.
  icvflag_Tpa=0
  call getin_p('icvflag_Tpa', icvflag_Tpa)

  RETURN
END SUBROUTINE cv_flag

! ==================================================================
SUBROUTINE cv_thermo(iflag_con,rcpd,rcpv,rcw,rv,rcs,rd,rlvtt,rlstt,rg)
! Replayisation USE yomcst_mod_h
!  USE lmdz_cv_ini, ONLY : ci,cl,clmci,clmcpd,clmcpv,cpd,cpdmcp,cpv,cpvmcl,cpvmcpd,eps,epsi,epsim1,g,ginv,grav,hrd,lf0,lv0,rowl,rrd,rrv,t0

IMPLICIT NONE

  ! -------------------------------------------------------------
  ! Set thermodynamical constants for convectL
  ! -------------------------------------------------------------



  INTEGER iflag_con
real, intent(in) :: rcpd,rcpv,rcw,rv,rcs,rd,rlvtt,rlstt,rg


  ! original set from convect:
  IF (iflag_con==4) THEN
    cpd = 1005.7
    cpv = 1870.0
    cl = 4190.0
    rrv = 461.5
    rrd = 287.04
    lv0 = 2.501E6
    g = 9.8
    t0 = 273.15
    grav = g
  ELSE

    ! constants consistent with LMDZ:
    cpd = rcpd
    cpv = rcpv
    cl = rcw
    ci = rcs
    rrv = rv
    rrd = rd
    lv0 = rlvtt
    lf0 = rlstt - rlvtt
    g = rg ! not used in convect3
    ! ori      t0  = RTT
    t0 = 273.15 ! convect3 (RTT=273.16)
    ! maf       grav= 10.    ! implicitely or explicitely used in convect3
    grav = g ! implicitely or explicitely used in convect3
  END IF

  rowl = 1000.0 !(a quelle variable de YOMCST cela correspond-il?)

  clmcpv = cl - cpv
  clmcpd = cl - cpd
  clmci = cl - ci
  cpdmcp = cpd - cpv
  cpvmcpd = cpv - cpd
  cpvmcl = cl - cpv ! for convect3
  eps = rrd/rrv
  epsi = 1.0/eps
  epsim1 = epsi - 1.0
  ! ginv=1.0/g
  ginv = 1.0/grav
  hrd = 0.5*rrd

  RETURN
END SUBROUTINE cv_thermo

SUBROUTINE cv_ini_previously_in_conf_phys
! Previously in conema3.h and then conema3_mod_h : 

USE ioipsl_getin_p_mod, ONLY : getin_p
implicit none

    epmax=0.993
    CALL getin_p('epmax', epmax)
    
    coef_epmax_cape=0.0   
    CALL getin_p('coef_epmax_cape', coef_epmax_cape)      

    cvl_comp_threshold= 1.00
    CALL getin_p('cvl_comp_threshold', cvl_comp_threshold)

    ok_adj_ema = .FALSE.
    CALL getin_p('ok_adj_ema',ok_adj_ema)
    
    iflag_clw = 0
    CALL getin_p('iflag_clw',iflag_clw)
    
    iflag_cvl_sigd = 0
    CALL getin_p('iflag_cvl_sigd',iflag_cvl_sigd)
    
    cvl_sig2feed = 0.97
    CALL getin_p('cvl_sig2feed', cvl_sig2feed)

    ! Previously in yomcst2
    alphas = -5.
    CALL getin_p('alphas',alphas)
    
    coef_clos_ls = 0.
    CALL getin_p('coef_clos_ls',coef_clos_ls)

    supcrit1 = .540
    CALL getin_p('supcrit1',supcrit1)
    
    supcrit2 = .600
    CALL getin_p('supcrit2',supcrit2)
    
    iflag_mix = 1
    CALL getin_p('iflag_mix',iflag_mix)
    
    iflag_mix_adiab = 0
    CALL getin_p('iflag_mix_adiab',iflag_mix_adiab)
    
    scut = 0.95
    CALL getin_p('scut',scut)

    qqa1 = 1.0
    CALL getin_p('qqa1',qqa1)

    qqa2 = 0.0
    CALL getin_p('qqa2',qqa2)

    gammas = 0.05
    CALL getin_p('gammas',gammas)

    Fmax = 0.65
    CALL getin_p('Fmax',Fmax)

END SUBROUTINE cv_ini_previously_in_conf_phys

END MODULE lmdz_cv_ini
