!
! $Header$
!
SUBROUTINE  grad(klevel, pg,pgx,pgy )
  !
  !  P. Le Van
  !
  !    ******************************************************************
  ! .. calcul des composantes covariantes en x et y du gradient de g
  !
  !    ******************************************************************
  !         pg        est un   argument  d'entree pour le s-prog
  !   pgx  et  pgy    sont des arguments de sortie pour le s-prog
  !
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !


  INTEGER :: klevel
  REAL :: pg( ip1jmp1,klevel )
  REAL :: pgx( ip1jmp1,klevel ) , pgy( ip1jm,klevel )
  INTEGER :: l,ij
  !
  !
  DO l = 1,klevel
  !
  DO  ij = 1, ip1jmp1 - 1
  pgx( ij,l ) = pg( ij +1,l ) - pg( ij,l )
  END DO
  !
  !    .... correction pour  pgx(ip1,j,l)  ....
  !    ...    pgx(iip1,j,l)= pgx(1,j,l)  ....
  !DIR$ IVDEP
  DO  ij = iip1, ip1jmp1, iip1
  pgx( ij,l ) = pgx( ij -iim,l )
  END DO
  !
  DO ij = 1,ip1jm
  pgy( ij,l ) = pg( ij,l ) - pg( ij +iip1,l )
  END DO
  !
  END DO
  RETURN
END SUBROUTINE grad
