SUBROUTINE bernoui_loc (ngrid,nlay,pphi,pecin,pbern)
  USE parallel_lmdz
  USE mod_filtreg_p
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE

  !=======================================================================
  !
  !   Auteur:   P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  ! calcul de la fonction de Bernouilli aux niveaux s  .....
  ! phi  et  ecin  sont des arguments d'entree pour le s-pg .......
  !      bern       est un  argument de sortie pour le s-pg  ......
  !
  !    fonction de Bernouilli = bern = filtre de( geopotentiel +
  !                          energ.cinet.)
  !
  !=======================================================================
  !
  !-----------------------------------------------------------------------
  !   Decalrations:
  !   -------------
  !


  !
  !   Arguments:
  !   ----------
  !
  INTEGER :: nlay,ngrid
  REAL :: pphi(ijb_u:ije_u,nlay),pecin(ijb_u:ije_u,nlay)
  REAL :: pbern(ijb_u:ije_u,nlay)
  !
  !   Local:
  !   ------
  !
  INTEGER :: ij,l,ijb,ije,jjb,jje
  !
  !-----------------------------------------------------------------------
  !   calcul de Bernouilli:
  !   ---------------------
  !
  ijb=ij_begin
  ije=ij_end+iip1
  if (pole_sud) ije=ij_end

  jjb=jj_begin
  jje=jj_end+1
  if (pole_sud) jje=jj_end

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l=1,llm

    DO ij = ijb,ije
      pbern( ij,l ) =  pphi( ij,l ) + pecin( ij,l )
    END DO

   ENDDO
!$OMP END DO NOWAIT
  !
  !-----------------------------------------------------------------------
  !   filtre:
  !   -------
  !


    CALL filtreg_p( pbern,jjb_u,jje_u,jjb,jje, jjp1, llm, &
          2,1, .true., 1 )
  !
  !-----------------------------------------------------------------------


  RETURN
END SUBROUTINE bernoui_loc
